/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vis.snapshotwriters;

import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.gbl.Gbl;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfo;
import org.matsim.vis.snapshotwriters.SnapshotLinkWidthCalculator;

public class AgentSnapshotInfoFactory {
    private static final double TWO_PI = Math.PI * 2;
    private static final double PI_HALF = 1.5707963267948966;
    private SnapshotLinkWidthCalculator linkWidthCalculator;

    public AgentSnapshotInfoFactory(SnapshotLinkWidthCalculator widthCalculator) {
        this.linkWidthCalculator = widthCalculator;
    }

    public AgentSnapshotInfo createAgentSnapshotInfo(Id<Person> agentId, double easting, double northing, double elevation, double azimuth) {
        PositionInfo info = new PositionInfo();
        info.setId(agentId);
        info.setEasting(easting);
        info.setNorthing(northing);
        info.setAzimuth(azimuth);
        return info;
    }

    public AgentSnapshotInfo createAgentSnapshotInfo(Id<Person> agentId, Link link, double distanceOnLink, int lane) {
        PositionInfo info = new PositionInfo();
        info.setId(agentId);
        double lanePosition = this.linkWidthCalculator.calculateLanePosition(lane);
        AgentSnapshotInfoFactory.calculateAndSetPosition(info, link.getFromNode().getCoord(), link.getToNode().getCoord(), distanceOnLink, link.getLength(), lanePosition);
        return info;
    }

    public AgentSnapshotInfo createAgentSnapshotInfo(Id<Person> agentId, Coord startCoord, Coord endCoord, double distanceOnLink, Integer lane, double curveLength) {
        PositionInfo info = new PositionInfo();
        info.setId(agentId);
        double lanePosition = this.linkWidthCalculator.calculateLanePosition(lane.intValue());
        Gbl.assertNotNull(startCoord);
        Gbl.assertNotNull(endCoord);
        AgentSnapshotInfoFactory.calculateAndSetPosition(info, startCoord, endCoord, distanceOnLink, curveLength, lanePosition);
        return info;
    }

    private static final void calculateAndSetPosition(PositionInfo info, Coord startCoord, Coord endCoord, double odometerOnLink, double lengthOfCurve, double lanePosition) {
        double dx = -startCoord.getX() + endCoord.getX();
        double dy = -startCoord.getY() + endCoord.getY();
        double theta = 0.0;
        theta = dx > 0.0 ? Math.atan(dy / dx) : (dx < 0.0 ? Math.PI + Math.atan(dy / dx) : (dy > 0.0 ? 1.5707963267948966 : (dy < 0.0 ? -1.5707963267948966 : 2.6169466804402974)));
        if (theta < 0.0) {
            theta += Math.PI * 2;
        }
        double euclideanLength = Math.sqrt(dx * dx + dy * dy);
        double correction = 0.0;
        if (lengthOfCurve != 0.0) {
            correction = euclideanLength / lengthOfCurve;
        }
        info.setEasting(startCoord.getX() + Math.cos(theta) * odometerOnLink * correction + Math.sin(theta) * lanePosition);
        info.setNorthing(startCoord.getY() + Math.sin(theta) * odometerOnLink * correction - Math.cos(theta) * lanePosition);
        info.setAzimuth(theta / (Math.PI * 2) * 360.0);
    }

    private static class PositionInfo
    implements AgentSnapshotInfo {
        private Id<Person> agentId = null;
        private double easting = Double.NaN;
        private double northing = Double.NaN;
        private double azimuth = Double.NaN;
        private double colorValue = 0.0;
        private AgentSnapshotInfo.AgentState agentState = null;
        private Id<Link> linkId = null;
        private int user = 0;

        PositionInfo() {
        }

        @Override
        public final Id<Person> getId() {
            return this.agentId;
        }

        public final void setId(Id<Person> tmp) {
            this.agentId = tmp;
        }

        @Override
        public final double getEasting() {
            return this.easting;
        }

        public final void setEasting(double tmp) {
            this.easting = tmp;
        }

        @Override
        public final double getNorthing() {
            return this.northing;
        }

        public final void setNorthing(double tmp) {
            this.northing = tmp;
        }

        @Override
        public final double getAzimuth() {
            return this.azimuth;
        }

        public final void setAzimuth(double tmp) {
            this.azimuth = tmp;
        }

        @Override
        public final double getColorValueBetweenZeroAndOne() {
            return this.colorValue;
        }

        @Override
        public final void setColorValueBetweenZeroAndOne(double tmp) {
            this.colorValue = tmp;
        }

        @Override
        public final AgentSnapshotInfo.AgentState getAgentState() {
            return this.agentState;
        }

        @Override
        public final void setAgentState(AgentSnapshotInfo.AgentState state) {
            this.agentState = state;
        }

        public final Id<Link> getLinkId() {
            return this.linkId;
        }

        public final void setLinkId(Id<Link> tmp) {
            this.linkId = tmp;
        }

        @Override
        public int getUserDefined() {
            return this.user;
        }

        @Override
        public void setUserDefined(int tmp) {
            this.user = tmp;
        }

        public String toString() {
            return "PositionInfo; agentId: " + this.agentId.toString() + " easting: " + this.easting + " northing: " + this.northing;
        }
    }
}

