/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vis.snapshotwriters;

import javax.inject.Inject;
import javax.inject.Provider;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.vis.snapshotwriters.KmlSnapshotWriter;
import org.matsim.vis.snapshotwriters.SnapshotWriter;

class KMLSnapshotWriterFactory
implements Provider<SnapshotWriter> {
    private Scenario scenario;
    private OutputDirectoryHierarchy controlerIO;
    private final int iteration;

    @Inject
    KMLSnapshotWriterFactory(Scenario scenario, OutputDirectoryHierarchy controlerIO, ReplanningContext replanningContext) {
        this.scenario = scenario;
        this.controlerIO = controlerIO;
        this.iteration = replanningContext.getIteration();
    }

    @Override
    public SnapshotWriter get() {
        String baseFileName = "googleearth.kmz";
        String fileName = this.controlerIO.getIterationFilename(this.iteration, baseFileName);
        String coordSystem = this.scenario.getConfig().global().getCoordinateSystem();
        return new KmlSnapshotWriter(fileName, TransformationFactory.getCoordinateTransformation(coordSystem, "WGS84"));
    }
}

