/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vis.snapshotwriters;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.opengis.kml.v_2_2_0.AbstractObjectType;
import net.opengis.kml.v_2_2_0.DocumentType;
import net.opengis.kml.v_2_2_0.FolderType;
import net.opengis.kml.v_2_2_0.IconStyleType;
import net.opengis.kml.v_2_2_0.KmlType;
import net.opengis.kml.v_2_2_0.LinkType;
import net.opengis.kml.v_2_2_0.MultiGeometryType;
import net.opengis.kml.v_2_2_0.NetworkLinkType;
import net.opengis.kml.v_2_2_0.ObjectFactory;
import net.opengis.kml.v_2_2_0.PlacemarkType;
import net.opengis.kml.v_2_2_0.PointType;
import net.opengis.kml.v_2_2_0.StyleType;
import net.opengis.kml.v_2_2_0.TimeSpanType;
import net.opengis.kml.v_2_2_0.TimeStampType;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.core.gbl.MatsimResource;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.misc.Time;
import org.matsim.vis.kml.KMZWriter;
import org.matsim.vis.kml.MatsimKMLLogo;
import org.matsim.vis.kml.MatsimKmlStyleFactory;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfo;
import org.matsim.vis.snapshotwriters.SnapshotWriter;

public class KmlSnapshotWriter
implements SnapshotWriter {
    private final ObjectFactory kmlObjectFactory = new ObjectFactory();
    private final KmlType mainKml;
    private final DocumentType mainDoc;
    private FolderType mainFolder = null;
    private final Map<String, StyleType> carStyles = new LinkedHashMap<String, StyleType>();
    private KmlType timeKml = null;
    private DocumentType timeDoc = null;
    private PlacemarkType timePlacemarkRed = null;
    private PlacemarkType timePlacemarkYellow = null;
    private PlacemarkType timePlacemarkGreen = null;
    private MultiGeometryType timeGeometryRed = null;
    private MultiGeometryType timeGeometryYellow = null;
    private MultiGeometryType timeGeometryGreen = null;
    private final KMZWriter writer;
    private final CoordinateTransformation coordTransform;
    private final TreeMap<Double, NetworkLinkType> timeLinks = new TreeMap();
    private double time = Double.NEGATIVE_INFINITY;
    private static final Logger log = Logger.getLogger(KmlSnapshotWriter.class);
    private boolean writeThisSnapshot;

    public KmlSnapshotWriter(String filename, CoordinateTransformation coordTransform) {
        this.coordTransform = coordTransform;
        this.writer = new KMZWriter(filename);
        this.mainKml = this.kmlObjectFactory.createKmlType();
        this.mainDoc = this.kmlObjectFactory.createDocumentType();
        this.mainKml.setAbstractFeatureGroup(this.kmlObjectFactory.createDocument(this.mainDoc));
        LinkType iconLink = this.kmlObjectFactory.createLinkType();
        try {
            this.writer.addNonKMLFile(MatsimResource.getAsInputStream("car.png"), "data/car.png");
            iconLink.setHref("./car.png");
        }
        catch (IOException e1) {
            log.warn("Cannot write car icon to kmz, trying to use icon from http://maps.google.com/mapfiles/kml/pal4/icon15.png");
            iconLink.setHref("http://maps.google.com/mapfiles/kml/pal4/icon15.png");
            e1.printStackTrace();
        }
        Object carStyle = this.createColoredCarStyle(iconLink, MatsimKmlStyleFactory.MATSIMRED, "redCarStyle");
        this.carStyles.put(((AbstractObjectType)carStyle).getId(), (StyleType)carStyle);
        carStyle = this.createColoredCarStyle(iconLink, MatsimKmlStyleFactory.MATSIMYELLOW, "yellowCarStyle");
        this.carStyles.put(((AbstractObjectType)carStyle).getId(), (StyleType)carStyle);
        carStyle = this.createColoredCarStyle(iconLink, MatsimKmlStyleFactory.MATSIMGREEN, "greenCarStyle");
        this.carStyles.put(((AbstractObjectType)carStyle).getId(), (StyleType)carStyle);
        for (StyleType carStyle2 : this.carStyles.values()) {
            this.mainDoc.getAbstractStyleSelectorGroup().add(this.kmlObjectFactory.createStyle(carStyle2));
        }
        this.mainFolder = this.kmlObjectFactory.createFolderType();
        this.mainDoc.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(this.mainFolder));
        try {
            MatsimKMLLogo.writeMatsimKMLLogo(this.writer);
        }
        catch (IOException e) {
            log.warn("Cannot read matsim logo file! The logo will not be added to the kmz");
            e.printStackTrace();
        }
        this.writeThisSnapshot = false;
    }

    private StyleType createColoredCarStyle(LinkType iconLink, byte[] color, String idString) {
        StyleType carStyle = this.kmlObjectFactory.createStyleType();
        carStyle.setId(idString);
        IconStyleType carIconStyle = this.kmlObjectFactory.createIconStyleType();
        carIconStyle.setIcon(iconLink);
        carIconStyle.setColor(color);
        carIconStyle.setScale(0.5);
        carStyle.setIconStyle(carIconStyle);
        return carStyle;
    }

    @Override
    public void beginSnapshot(double time) {
        this.time = time;
        this.timeKml = this.kmlObjectFactory.createKmlType();
        this.timeGeometryRed = this.kmlObjectFactory.createMultiGeometryType();
        this.timeGeometryYellow = this.kmlObjectFactory.createMultiGeometryType();
        this.timeGeometryGreen = this.kmlObjectFactory.createMultiGeometryType();
        this.timePlacemarkRed = this.kmlObjectFactory.createPlacemarkType();
        this.timePlacemarkYellow = this.kmlObjectFactory.createPlacemarkType();
        this.timePlacemarkGreen = this.kmlObjectFactory.createPlacemarkType();
        this.timePlacemarkRed.setAbstractGeometryGroup(this.kmlObjectFactory.createMultiGeometry(this.timeGeometryRed));
        this.timePlacemarkYellow.setAbstractGeometryGroup(this.kmlObjectFactory.createMultiGeometry(this.timeGeometryYellow));
        this.timePlacemarkGreen.setAbstractGeometryGroup(this.kmlObjectFactory.createMultiGeometry(this.timeGeometryGreen));
        this.timePlacemarkRed.setStyleUrl("redCarStyle");
        this.timePlacemarkYellow.setStyleUrl("yellowCarStyle");
        this.timePlacemarkGreen.setStyleUrl("greenCarStyle");
        this.timeDoc = this.kmlObjectFactory.createDocumentType();
        for (StyleType carStyle : this.carStyles.values()) {
            this.timeDoc.getAbstractStyleSelectorGroup().add(this.kmlObjectFactory.createStyle(carStyle));
        }
        this.timeDoc.getAbstractFeatureGroup().add(this.kmlObjectFactory.createPlacemark(this.timePlacemarkRed));
        this.timeDoc.getAbstractFeatureGroup().add(this.kmlObjectFactory.createPlacemark(this.timePlacemarkYellow));
        this.timeDoc.getAbstractFeatureGroup().add(this.kmlObjectFactory.createPlacemark(this.timePlacemarkGreen));
        this.timeKml.setAbstractFeatureGroup(this.kmlObjectFactory.createDocument(this.timeDoc));
    }

    @Override
    public void addAgent(AgentSnapshotInfo info) {
        if (info.getAgentState() == AgentSnapshotInfo.AgentState.PERSON_AT_ACTIVITY) {
            return;
        }
        this.writeThisSnapshot = true;
        Coord coord = this.coordTransform.transform(new Coord(info.getEasting(), info.getNorthing()));
        PointType point = this.kmlObjectFactory.createPointType();
        point.getCoordinates().add(Double.toString(coord.getX()) + "," + Double.toString(coord.getY()) + ",0.0");
        if (info.getColorValueBetweenZeroAndOne() < 0.33) {
            this.timeGeometryRed.getAbstractGeometryGroup().add(this.kmlObjectFactory.createPoint(point));
        } else if (info.getColorValueBetweenZeroAndOne() < 0.66) {
            this.timeGeometryYellow.getAbstractGeometryGroup().add(this.kmlObjectFactory.createPoint(point));
        } else {
            this.timeGeometryGreen.getAbstractGeometryGroup().add(this.kmlObjectFactory.createPoint(point));
        }
    }

    @Override
    public void endSnapshot() {
        if (this.writeThisSnapshot) {
            String filename = "data/time_" + this.time + ".kml";
            this.writer.writeLinkedKml(filename, this.timeKml);
            NetworkLinkType nl = this.kmlObjectFactory.createNetworkLinkType();
            LinkType link = this.kmlObjectFactory.createLinkType();
            link.setHref(filename);
            nl.setLink(link);
            TimeStampType timeStamp = this.kmlObjectFactory.createTimeStampType();
            timeStamp.setWhen("1970-01-01T" + Time.writeTime(this.time));
            nl.setAbstractTimePrimitiveGroup(this.kmlObjectFactory.createTimeStamp(timeStamp));
            this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createNetworkLink(nl));
            this.timeLinks.put(this.time, nl);
        }
        this.timeKml = null;
        this.timeDoc = null;
        this.writeThisSnapshot = false;
    }

    @Override
    public void finish() {
        String lastTimeS = null;
        for (Map.Entry<Double, NetworkLinkType> e : this.timeLinks.entrySet()) {
            String timeS = Time.writeTime(e.getKey());
            if (lastTimeS != null) {
                NetworkLinkType nl = e.getValue();
                TimeSpanType timeSpan = this.kmlObjectFactory.createTimeSpanType();
                timeSpan.setBegin("1970-01-01T" + lastTimeS);
                timeSpan.setEnd("1970-01-01T" + timeS);
                nl.setAbstractTimePrimitiveGroup(this.kmlObjectFactory.createTimeSpan(timeSpan));
            }
            lastTimeS = timeS;
        }
        this.writer.writeMainKml(this.mainKml);
        this.writer.close();
    }
}

