/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vis.snapshotwriters;

import java.util.ArrayList;
import java.util.List;
import org.matsim.core.config.Config;
import org.matsim.core.mobsim.framework.events.MobsimAfterSimStepEvent;
import org.matsim.core.mobsim.framework.events.MobsimBeforeCleanupEvent;
import org.matsim.core.mobsim.framework.events.MobsimInitializedEvent;
import org.matsim.core.mobsim.framework.listeners.MobsimAfterSimStepListener;
import org.matsim.core.mobsim.framework.listeners.MobsimBeforeCleanupListener;
import org.matsim.core.mobsim.framework.listeners.MobsimInitializedListener;
import org.matsim.core.mobsim.qsim.interfaces.Netsim;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfo;
import org.matsim.vis.snapshotwriters.SnapshotWriter;
import org.matsim.vis.snapshotwriters.VisLink;
import org.matsim.vis.snapshotwriters.VisMobsim;

public class SnapshotWriterManager
implements MobsimBeforeCleanupListener,
MobsimAfterSimStepListener,
MobsimInitializedListener {
    private final List<SnapshotWriter> snapshotWriters = new ArrayList<SnapshotWriter>();
    private double snapshotTime = 0.0;
    private final int snapshotPeriod;

    public SnapshotWriterManager(Config config) {
        this.snapshotPeriod = this.findSnapshotPeriod(config);
    }

    private int findSnapshotPeriod(Config config) {
        if (config.qsim() != null) {
            return (int)config.qsim().getSnapshotPeriod();
        }
        return 1;
    }

    @Override
    public void notifyMobsimInitialized(MobsimInitializedEvent e) {
        Netsim mobsim = (Netsim)e.getQueueSimulation();
        this.snapshotTime = Math.floor(mobsim.getSimTimer().getSimStartTime() / (double)this.snapshotPeriod) * (double)this.snapshotPeriod;
        if (this.snapshotTime < mobsim.getSimTimer().getSimStartTime()) {
            this.snapshotTime += (double)this.snapshotPeriod;
        }
    }

    @Override
    public void notifyMobsimBeforeCleanup(MobsimBeforeCleanupEvent e) {
        this.closeSnapshotWriters();
    }

    private void closeSnapshotWriters() {
        for (SnapshotWriter writer : this.snapshotWriters) {
            writer.finish();
        }
    }

    @Override
    public void notifyMobsimAfterSimStep(MobsimAfterSimStepEvent e) {
        double time = e.getSimulationTime();
        if (time >= this.snapshotTime) {
            this.snapshotTime += (double)this.snapshotPeriod;
            this.doSnapshot(time, (VisMobsim)e.getQueueSimulation());
        }
    }

    private void doSnapshot(double time, VisMobsim visMobsim) {
        if (!this.snapshotWriters.isEmpty()) {
            ArrayList<AgentSnapshotInfo> positions = new ArrayList<AgentSnapshotInfo>();
            for (VisLink visLink : visMobsim.getVisNetwork().getVisLinks().values()) {
                visLink.getVisData().addAgentSnapshotInfo(positions);
            }
            for (SnapshotWriter snapshotWriter : this.snapshotWriters) {
                snapshotWriter.beginSnapshot(time);
                for (AgentSnapshotInfo position : positions) {
                    snapshotWriter.addAgent(position);
                }
                snapshotWriter.endSnapshot();
            }
        }
    }

    public final void addSnapshotWriter(SnapshotWriter snapshotWriter) {
        this.snapshotWriters.add(snapshotWriter);
    }
}

