/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vis.snapshotwriters;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Provider;
import org.matsim.core.config.Config;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.mobsim.framework.listeners.MobsimListener;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.vis.snapshotwriters.KMLSnapshotWriterFactory;
import org.matsim.vis.snapshotwriters.SnapshotWriter;
import org.matsim.vis.snapshotwriters.SnapshotWriterManager;
import org.matsim.vis.snapshotwriters.TransimsSnapshotWriterFactory;

public class SnapshotWritersModule
extends AbstractModule {
    @Override
    public void install() {
        if (this.getConfig().controler().getSnapshotFormat().contains("googleearth")) {
            this.addSnapshotWriterBinding().toProvider(KMLSnapshotWriterFactory.class);
        }
        if (this.getConfig().controler().getSnapshotFormat().contains("transims")) {
            this.addSnapshotWriterBinding().toProvider(TransimsSnapshotWriterFactory.class);
        }
        if (this.getConfig().controler().getWriteSnapshotsInterval() != 0) {
            this.addMobsimListenerBinding().toProvider(SnapshotWriterManagerProvider.class);
        }
    }

    private static class SnapshotWriterManagerProvider
    implements Provider<MobsimListener> {
        private final Config config;
        private final ControlerConfigGroup controlerConfigGroup;
        private final ReplanningContext iterationContext;
        private final Collection<com.google.inject.Provider<SnapshotWriter>> snapshotWriters;

        @Inject
        private SnapshotWriterManagerProvider(Config config, ControlerConfigGroup controlerConfigGroup, ReplanningContext iterationContext, Collection<com.google.inject.Provider<SnapshotWriter>> snapshotWriters) {
            this.config = config;
            this.controlerConfigGroup = controlerConfigGroup;
            this.iterationContext = iterationContext;
            this.snapshotWriters = snapshotWriters;
        }

        @Override
        public MobsimListener get() {
            if (this.iterationContext.getIteration() % this.controlerConfigGroup.getWriteSnapshotsInterval() == 0) {
                SnapshotWriterManager manager = new SnapshotWriterManager(this.config);
                for (com.google.inject.Provider<SnapshotWriter> snapshotWriter : this.snapshotWriters) {
                    manager.addSnapshotWriter(snapshotWriter.get());
                }
                return manager;
            }
            return new NoopMobsimListener();
        }

        private static class NoopMobsimListener
        implements MobsimListener {
            private NoopMobsimListener() {
            }
        }
    }
}

