/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vis.snapshotwriters;

import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Person;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfo;

public class TeleportationVisData
implements AgentSnapshotInfo {
    private final double startX;
    private final double startY;
    private double currentX;
    private double currentY;
    private final double starttime;
    private final Id<Person> agentId;
    private int userDefined;
    private double colorval;
    private AgentSnapshotInfo.AgentState state = AgentSnapshotInfo.AgentState.PERSON_OTHER_MODE;
    private int intX;
    private int intY;
    private final double endX;
    private final double endY;
    private final double travelTime;
    private static final int offset = 100;

    public TeleportationVisData(double now, Id<Person> personId, Coord fromCoord, Coord toCoord, double travelTime) {
        this.starttime = now;
        this.travelTime = travelTime;
        this.agentId = personId;
        this.startX = fromCoord.getX();
        this.startY = fromCoord.getY();
        this.endX = toCoord.getX();
        this.endY = toCoord.getY();
        this.currentX = this.startX;
        this.currentY = this.startY;
        String idstr = personId.toString();
        int hashCode = idstr.hashCode();
        this.intX = hashCode % 100;
        hashCode -= this.intX;
        this.intY = (hashCode /= 100) % 100;
    }

    @Override
    public double getEasting() {
        return this.currentX;
    }

    @Override
    public double getNorthing() {
        return this.currentY;
    }

    @Override
    public Id<Person> getId() {
        return this.agentId;
    }

    public final void updatePosition(double time) {
        double frac = (time - this.starttime) / this.travelTime;
        this.currentX = (1.0 - frac) * this.startX + frac * this.endX + 0.1 * (double)(this.intX - 50);
        this.currentY = (1.0 - frac) * this.startY + frac * this.endY + 0.1 * (double)(this.intY - 50);
    }

    @Override
    public AgentSnapshotInfo.AgentState getAgentState() {
        return this.state;
    }

    @Override
    public double getAzimuth() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getColorValueBetweenZeroAndOne() {
        return this.colorval;
    }

    @Override
    public int getUserDefined() {
        return this.userDefined;
    }

    @Override
    public void setAgentState(AgentSnapshotInfo.AgentState state) {
        this.state = state;
    }

    @Override
    public void setColorValueBetweenZeroAndOne(double tmp) {
        this.colorval = tmp;
    }

    @Override
    public void setUserDefined(int tmp) {
        this.userDefined = tmp;
    }
}

