/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vis.snapshotwriters;

import java.io.BufferedWriter;
import java.io.IOException;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfo;
import org.matsim.vis.snapshotwriters.SnapshotWriter;

public class TransimsSnapshotWriter
implements SnapshotWriter {
    private BufferedWriter out = null;
    private double currentTime = -1.0;

    public TransimsSnapshotWriter(String filename) {
        try {
            this.out = IOUtils.getBufferedWriter(filename, true);
            String header = (Object)((Object)Labels.VEHICLE) + "\t" + (Object)((Object)Labels.TIME) + "\tLINK" + "\tNODE" + "\tLANE" + "\tDISTANCE" + "\t" + (Object)((Object)Labels.VELOCITY) + "\tVEHTYPE" + "\tACCELER" + "\tDRIVER" + "\tPASSENGERS" + "\t" + (Object)((Object)Labels.EASTING) + "\t" + (Object)((Object)Labels.NORTHING) + "\tELEVATION" + "\tAZIMUTH" + "\tUSER\n";
            this.out.write(header);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addAgent(AgentSnapshotInfo position) {
        if (position.getAgentState() == AgentSnapshotInfo.AgentState.PERSON_AT_ACTIVITY) {
            return;
        }
        String buffer = position.getId().toString() + "\t" + (int)this.currentTime + "\t0\t0\t1\t0\t" + position.getColorValueBetweenZeroAndOne() + "\t1\t0\t" + position.getId().toString() + "\t0\t" + position.getEasting() + "\t" + position.getNorthing() + "\t0" + "\t0" + "\t" + "0" + "\n";
        try {
            this.out.write(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void beginSnapshot(double time) {
        this.currentTime = time;
    }

    @Override
    public void endSnapshot() {
        this.currentTime = -1.0;
    }

    @Override
    public void finish() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum Labels {
        TIME,
        VEHICLE,
        EASTING,
        NORTHING,
        VELOCITY;

    }
}

