/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vis.snapshotwriters;

import com.google.inject.Inject;
import javax.inject.Provider;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.vis.snapshotwriters.SnapshotWriter;
import org.matsim.vis.snapshotwriters.TransimsSnapshotWriter;

class TransimsSnapshotWriterFactory
implements Provider<SnapshotWriter> {
    private OutputDirectoryHierarchy controlerIO;
    private final int iteration;

    @Inject
    TransimsSnapshotWriterFactory(OutputDirectoryHierarchy controlerIO, ReplanningContext replanningContext) {
        this.iteration = replanningContext.getIteration();
        this.controlerIO = controlerIO;
    }

    @Override
    public SnapshotWriter get() {
        String fileName = this.controlerIO.getIterationFilename(this.iteration, "T.veh.gz");
        return new TransimsSnapshotWriter(fileName);
    }
}

