/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vis.vecmathutils;

import java.awt.geom.Point2D;
import org.matsim.core.utils.collections.Tuple;

public class VectorUtils {
    public static Tuple<Point2D.Double, Point2D.Double> scaleVector(Point2D.Double start, Point2D.Double end, double scaleFactor) {
        return VectorUtils.calculateScaledVector(start, end, scaleFactor);
    }

    @Deprecated
    public static Tuple<Point2D.Double, Point2D.Double> scaleVectorStart(Point2D.Double start, Point2D.Double end, double scaleFactor) {
        Tuple<Point2D.Double, Point2D.Double> scaledVector = VectorUtils.calculateScaledVector(start, end, scaleFactor);
        return new Tuple<Point2D.Double, Point2D.Double>(scaledVector.getFirst(), end);
    }

    @Deprecated
    public static Tuple<Point2D.Double, Point2D.Double> scaleVectorEnd(Point2D.Double start, Point2D.Double end, double scaleFactor) {
        Tuple<Point2D.Double, Point2D.Double> scaledVector = VectorUtils.calculateScaledVector(start, end, scaleFactor);
        return new Tuple<Point2D.Double, Point2D.Double>(start, scaledVector.getSecond());
    }

    private static Tuple<Point2D.Double, Point2D.Double> calculateScaledVector(Point2D.Double start, Point2D.Double end, double scaleFactor) {
        Point2D.Double delta = new Point2D.Double(end.x - start.x, end.y - start.y);
        double length = Math.sqrt(Math.pow(delta.x, 2.0) + Math.pow(delta.y, 2.0));
        Point2D.Double deltaNorm = new Point2D.Double(delta.x / length, delta.y / length);
        double scaledLength = length * scaleFactor;
        double offset = (length - scaledLength) / 2.0;
        Point2D.Double scaledEnd = new Point2D.Double(start.x + (length - offset) * deltaNorm.x, start.y + (length - offset) * deltaNorm.y);
        Point2D.Double scaledStart = new Point2D.Double(start.x + offset * deltaNorm.x, start.y + offset * deltaNorm.y);
        Tuple<Point2D.Double, Point2D.Double> scaledVector = new Tuple<Point2D.Double, Point2D.Double>(scaledStart, scaledEnd);
        return scaledVector;
    }
}

