/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.visum;

import java.io.BufferedReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.matrices.Matrix;

public class VisumMatrixReader {
    private Matrix matrix = null;
    static final Logger log = Logger.getLogger(VisumMatrixReader.class);

    public VisumMatrixReader(Matrix matrix) {
        this.matrix = matrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matrix readFile(String filename) {
        block15: {
            BufferedReader infile = null;
            try {
                infile = IOUtils.getBufferedReader(filename);
                this.matrix.setDesc(filename);
                infile.mark(1024);
                String header = infile.readLine();
                infile.reset();
                if (header != null) {
                    if (header.equals("$VN;Y5")) {
                        new DenseMatrixReader(this.matrix).read(infile);
                        break block15;
                    }
                    if (header.startsWith("$O")) {
                        new SparseMatrixReader(this.matrix).read(infile);
                        break block15;
                    }
                    throw new RuntimeException("Visum file format '" + header + "' is not supported.");
                }
                throw new RuntimeException("header is missing");
            }
            catch (IOException e) {
                e.printStackTrace();
                Matrix matrix = null;
                return matrix;
            }
            finally {
                if (infile != null) {
                    try {
                        infile.close();
                    }
                    catch (IOException e) {
                        log.warn("Could not close input-stream.", e);
                    }
                }
            }
        }
        return this.matrix;
    }

    static class SparseMatrixReader {
        private static final int STATE_HEADER = 0;
        private static final int STATE_VERKEHRSMITTEL = 1;
        private static final int STATE_TIME = 2;
        private static final int STATE_FAKTOR = 3;
        private static final int STATE_DATA = 4;
        private int state = 0;
        private int lineCounter = 0;
        private final Matrix matrix;

        public SparseMatrixReader(Matrix matrix) {
            this.matrix = matrix;
        }

        public void read(BufferedReader in) throws IOException {
            String line = null;
            while ((line = in.readLine()) != null) {
                ++this.lineCounter;
                if (line.startsWith("*")) continue;
                this.parseLine(line);
            }
        }

        private void parseLine(String line) {
            if (this.state == 4) {
                String[] data = line.trim().split("\\s+");
                if (data.length != 3) {
                    throw new RuntimeException("Expected 3 tokens, but found " + data.length + " in line " + this.lineCounter + ".");
                }
                String from = data[0];
                String to = data[1];
                double value = Double.NaN;
                if (!from.equals(to)) {
                    value = Double.parseDouble(data[2]);
                }
                this.matrix.createAndAddEntry(from, to, value);
            } else if (this.state == 0) {
                this.state = 1;
            } else if (this.state == 1) {
                this.state = 2;
            } else if (this.state == 2) {
                this.state = 3;
            } else if (this.state == 3) {
                this.state = 4;
            } else {
                throw new RuntimeException("unknown internal state: " + this.state);
            }
        }
    }

    private static class DenseMatrixReader {
        private static final int STATE_HEADER = 0;
        private static final int STATE_ANZBEZIRKE = 1;
        private static final int STATE_BEZIRKE = 2;
        private static final int STATE_DATA = 3;
        private static final int STATE_GARBAGE = 4;
        private int state = 0;
        private String[] zoneNames = null;
        private int zoneCounter = 0;
        private int lineCounter = 0;
        private int nofZones = 0;
        private final Matrix matrix;

        public DenseMatrixReader(Matrix matrix) {
            this.matrix = matrix;
        }

        public void read(BufferedReader in) throws IOException {
            String line = null;
            while ((line = in.readLine()) != null) {
                ++this.lineCounter;
                if (line.startsWith("*")) continue;
                this.parseLine(line);
            }
        }

        private void parseLine(String line) {
            if (this.state == 3) {
                String[] data = line.split("\t");
                if (data.length != this.nofZones) {
                    throw new RuntimeException("Expected " + this.nofZones + " data items, but found " + data.length + " in line " + this.lineCounter + ".");
                }
                for (int i = 0; i < this.nofZones; ++i) {
                    this.matrix.setEntry(this.zoneNames[this.zoneCounter], this.zoneNames[i], Double.parseDouble(data[i]));
                }
                ++this.zoneCounter;
                if (this.zoneCounter == this.nofZones) {
                    this.state = 4;
                }
            } else if (this.state == 0) {
                this.state = 1;
            } else if (this.state == 1) {
                this.nofZones = Integer.parseInt(line);
                this.state = 2;
            } else if (this.state == 2) {
                this.zoneNames = line.split("\t");
                if (this.zoneNames.length != this.nofZones) {
                    throw new RuntimeException("Line " + this.lineCounter + ": " + "The actual number of zones (" + this.zoneNames.length + ") does not " + "correspond with the expected number of zones (" + this.nofZones + ").");
                }
                this.zoneCounter = 0;
                this.state = 3;
            }
        }
    }
}

