/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.visum;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.matsim.matrices.Entry;
import org.matsim.matrices.Matrix;

public class VisumMatrixWriter {
    static final Logger log = Logger.getLogger(VisumMatrixWriter.class);
    Matrix matrix;
    Set<String> ids;

    public VisumMatrixWriter(Matrix matrix) {
        this.matrix = matrix;
        this.ids = new TreeSet<String>();
        this.ids.addAll(matrix.getFromLocations().keySet());
        this.ids.addAll(matrix.getToLocations().keySet());
    }

    public void setIds(Set<String> ids) {
        this.ids = ids;
    }

    public void writeFile(String filename) {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(filename));){
            out.write("$VN;Y5\n");
            out.write("*\n");
            out.write("*\tAnzahl Bezirke\n");
            out.write(this.ids.size() + "\n");
            out.write("*\tBezirksNummern\n");
            int cnt = 0;
            for (String value : this.ids) {
                if (++cnt > 1) {
                    out.write("\t");
                }
                out.write(value);
            }
            out.write("\n");
            for (String from : this.ids) {
                out.write("*\t" + from + "\n");
                cnt = 0;
                for (String to : this.ids) {
                    Entry e = this.matrix.getEntry(from, to);
                    if (++cnt > 1) {
                        out.write("\t");
                    }
                    if (e == null) {
                        out.write("0");
                        continue;
                    }
                    out.write(Double.toString(e.getValue()));
                }
                out.write("\n");
            }
            out.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

