/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.visum;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.core.utils.misc.StringUtils;
import org.matsim.visum.VisumNetwork;

public class VisumNetworkReader {
    private static final String ATTRIBUTE_UNKNOWN = "%%%KEINE_AHNUNG%%%";
    private final VisumNetwork network;
    private final Logger log = Logger.getLogger(VisumNetworkReader.class);
    private int language = 0;
    private final String[] GENERAL_DCODE = new String[]{"DIRECTIONCODE", "RICHTUNGCODE"};
    private final String[] GENERAL_INDEX = new String[]{"INDEX", "INDEX"};
    private final String[] GENERAL_NAME = new String[]{"NAME", "NAME"};
    private final String[] GENERAL_NO = new String[]{"NO", "NR"};
    private final String[] GENERAL_LINENAME = new String[]{"LINENAME", "LINNAME"};
    private final String[] GENERAL_LINEROUTENAME = new String[]{"LINEROUTENAME", "LINROUTENAME"};
    private final String[] TABLE_LINKTYPE = new String[]{"$LINKTYPE:", "$STRECKENTYP:"};
    private final String[] TABLE_STOP = new String[]{"$STOP:", "$HALTESTELLE:"};
    private final String[] TABLE_STOPAREA = new String[]{"$STOPAREA:", "$HALTESTELLENBEREICH:"};
    private final String[] TABLE_STOPPOINT = new String[]{"$STOPPOINT:", "$HALTEPUNKT:"};
    private final String[] TABLE_LINE = new String[]{"$LINE:", "$LINIE:"};
    private final String[] TABLE_LINEROUTE = new String[]{"$LINEROUTE:", "$LINIENROUTE:"};
    private final String[] TABLE_LINEROUTEITEM = new String[]{"$LINEROUTEITEM:", "$LINIENROUTENELEMENT:"};
    private final String[] TABLE_TIMEPROFILE = new String[]{"$TIMEPROFILE:", "$FAHRZEITPROFIL:"};
    private final String[] TABLE_TIMEPROFILEITEM = new String[]{"$TIMEPROFILEITEM:", "$FAHRZEITPROFILELEMENT:"};
    private final String[] TABLE_VEHJOURNEY = new String[]{"$VEHJOURNEY:", "$FZGFAHRT:"};
    private final String[] TABLE_VEHJOURNEYSECTION = new String[]{"$VEHJOURNEYSECTION:", "$FZGFAHRTABSCHNITT:"};
    private final String[] TABLE_VEHUNIT = new String[]{"$VEHUNIT:", "$FZGEINHEIT:"};
    private final String[] TABLE_VEHCOMB = new String[]{"$VEHCOMB:", "$FZGKOMB:"};
    private final String[] TABLE_VEHUNITTOVEHCOMB = new String[]{"$VEHUNITTOVEHCOMB:", "$FZGEINHEITZUFZGKOMB:"};
    private final String[] ATTRIBUTE_LINKTYPE_NO = this.GENERAL_NO;
    private final String[] ATTRIBUTE_LINKTYPE_KAPIV = new String[]{"CAPPRT", "KAPIV"};
    private final String[] ATTRIBUTE_LINKTYPE_V0IV = new String[]{"V0PRT", "V0IV"};
    private final String[] ATTRIBUTE_LINKTYPE_NOLANES = new String[]{"NUMLANES", "ANZFAHRSTREIFEN"};
    private final String[] ATTRIBUTE_STOP_NO = this.GENERAL_NO;
    private final String[] ATTRIBUTE_STOP_NAME = this.GENERAL_NAME;
    private final String[] ATTRIBUTE_STOP_XCOORD = new String[]{"XCOORD", "XKOORD"};
    private final String[] ATTRIBUTE_STOP_YCOORD = new String[]{"YCOORD", "YKOORD"};
    private final String[] ATTRIBUTE_STOPAREA_NO = this.GENERAL_NO;
    private final String[] ATTRIBUTE_STOPAREA_STOPNO = new String[]{"STOPNO", "HSTNR"};
    private final String[] ATTRIBUTE_STOPPT_NO = this.GENERAL_NO;
    private final String[] ATTRIBUTE_STOPPT_STOPAREANO = new String[]{"STOPAREANO", "HSTBERNR"};
    private final String[] ATTRIBUTE_STOPPT_NAME = this.GENERAL_NAME;
    private final String[] ATTRIBUTE_STOPPT_RLNO = new String[]{"LINKNO", "STRNR"};
    private final String[] ATTRIBUTE_STOPPT_NODE = new String[]{"NODENO", "KNOTNR"};
    private final String[] ATTRIBUTE_LR_NAME = this.GENERAL_NAME;
    private final String[] ATTRIBUTE_LR_LINENAME = this.GENERAL_LINENAME;
    private final String[] ATTRIBUTE_LR_DCODE = this.GENERAL_DCODE;
    private final String[] ATTRIBUTE_LR_TAKT = new String[]{"%%%KEINE_AHNUNG%%%", "TAKT_TAG_HVZ"};
    private final String[] ATTRIBUTE_L_NAME = this.GENERAL_NAME;
    private final String[] ATTRIBUTE_L_TCODE = new String[]{"TSYSCODE", "VSYSCODE"};
    private final String[] ATTRIBUTE_L_VEHCOMBNO = new String[]{"VEHCOMBNO", "FZGKOMBNR"};
    private final String[] ATTRIBUTE_LRI_LRNAME = this.GENERAL_LINEROUTENAME;
    private final String[] ATTRIBUTE_LRI_LNAME = this.GENERAL_LINENAME;
    private final String[] ATTRIBUTE_LRI_ID = this.GENERAL_INDEX;
    private final String[] ATTRIBUTE_LRI_DCODE = this.GENERAL_DCODE;
    private final String[] ATTRIBUTE_LRI_NODEID = new String[]{"NODENO", "KNOTNR"};
    private final String[] ATTRIBUTE_LRI_SPNO = new String[]{"STOPPOINTNO", "HPUNKTNR"};
    private final String[] ATTRIBUTE_TP_LNAME = this.GENERAL_LINENAME;
    private final String[] ATTRIBUTE_TP_LRNAME = this.GENERAL_LINEROUTENAME;
    private final String[] ATTRIBUTE_TP_ID = this.GENERAL_NAME;
    private final String[] ATTRIBUTE_TP_DCODE = this.GENERAL_DCODE;
    private final String[] ATTRIBUTE_TP_VEHCOMBNO = new String[]{"VEHCOMBNO", "FZGKOMBNR"};
    private final String[] ATTRIBUTE_TPI_LNAME = this.GENERAL_LINENAME;
    private final String[] ATTRIBUTE_TPI_LRNAME = this.GENERAL_LINEROUTENAME;
    private final String[] ATTRIBUTE_TPI_ID = this.GENERAL_INDEX;
    private final String[] ATTRIBUTE_TPI_TPNAME = new String[]{"TIMEPROFILENAME", "FZPROFILNAME"};
    private final String[] ATTRIBUTE_TPI_DCODE = this.GENERAL_DCODE;
    private final String[] ATTRIBUTE_TPI_ARR = new String[]{"ARR", "ANKUNFT"};
    private final String[] ATTRIBUTE_TPI_DEP = new String[]{"DEP", "ABFAHRT"};
    private final String[] ATTRIBUTE_TPI_LRIINDEX = new String[]{"LRITEMINDEX", "LRELEMINDEX"};
    private final String[] ATTRIBUTE_D_LNAME = this.GENERAL_LINENAME;
    private final String[] ATTRIBUTE_D_LRNAME = this.GENERAL_LINEROUTENAME;
    private final String[] ATTRIBUTE_D_ID = this.GENERAL_NO;
    private final String[] ATTRIBUTE_D_TPNAME = new String[]{"TIMEPROFILENAME", "FZPROFILNAME"};
    private final String[] ATTRIBUTE_D_DEP = new String[]{"DEP", "ABFAHRT"};
    private final String[] ATTRIBUTE_D_DCODE = this.GENERAL_DCODE;
    private final String[] ATTRIBUTE_VJS_VEHJOURNEYNO = new String[]{"VEHJOURNEYNO", "FZGFAHRTNR"};
    private final String[] ATTRIBUTE_VJS_VEHCOMBNO = new String[]{"VEHCOMBNO", "FZGKOMBNR"};
    private final String[] ATTRIBUTE_VEHUNIT_ID = this.GENERAL_NO;
    private final String[] ATTRIBUTE_VEHUNIT_CODE = new String[]{"CODE", "CODE"};
    private final String[] ATTRIBUTE_VEHUNIT_SEATCAP = new String[]{"SEATCAP", "SITZPL"};
    private final String[] ATTRIBUTE_VEHUNIT_TOTALCAP = new String[]{"TOTALCAP", "GESAMTPL"};
    private final String[] ATTRIBUTE_VEHCOMB_NO = this.GENERAL_NO;
    private final String[] ATTRIBUTE_VEHCOMB_NAME = this.GENERAL_NAME;
    private final String[] ATTRIBUTE_VEHUNITTOVEHCOMB_VEHCOMBNO = new String[]{"VEHCOMBNO", "FZGKOMBNR"};
    private final String[] ATTRIBUTE_VEHUNITTOVEHCOMB_VEHUNITNO = new String[]{"VEHUNITNO", "FZGEINHEITNR"};
    private final String[] ATTRIBUTE_VEHUNITTOVEHCOMB_NUMVEHUNITS = new String[]{"NUMVEHUNITS", "ANZFZGEINH"};

    public VisumNetworkReader(VisumNetwork network) {
        this.network = network;
    }

    public void read(String filename) throws UncheckedIOException {
        BufferedReader reader = IOUtils.getBufferedReader(filename, Charset.forName("ISO-8859-1"));
        try {
            String line = reader.readLine();
            if (!"$VISION".equals(line)) {
                throw new IOException("File does not start with '$VISION'. Are you sure it is a VISUM network file?");
            }
            line = reader.readLine();
            while (line != null) {
                if (line.startsWith("$VERSION:")) {
                    this.readVersion(line, reader);
                } else if (line.startsWith(this.TABLE_STOP[this.language])) {
                    this.readStops(line, reader);
                } else if (line.startsWith(this.TABLE_LINKTYPE[this.language])) {
                    this.readEdgeTypes(line, reader);
                } else if (line.startsWith(this.TABLE_STOPAREA[this.language])) {
                    this.readStopAreas(line, reader);
                } else if (line.startsWith(this.TABLE_STOPPOINT[this.language])) {
                    this.readStopPoints(line, reader);
                } else if (line.startsWith(this.TABLE_LINE[this.language])) {
                    this.readLines(line, reader);
                } else if (line.startsWith(this.TABLE_LINEROUTE[this.language])) {
                    this.readLineRoutes(line, reader);
                } else if (line.startsWith(this.TABLE_LINEROUTEITEM[this.language])) {
                    this.readLineRouteItems(line, reader);
                } else if (line.startsWith(this.TABLE_TIMEPROFILE[this.language])) {
                    this.readTimeProfile(line, reader);
                } else if (line.startsWith(this.TABLE_TIMEPROFILEITEM[this.language])) {
                    this.readTimeProfileItems(line, reader);
                } else if (line.startsWith(this.TABLE_VEHJOURNEY[this.language])) {
                    this.readDepartures(line, reader);
                } else if (line.startsWith(this.TABLE_VEHJOURNEYSECTION[this.language])) {
                    this.readDepartureSections(line, reader);
                } else if (line.startsWith(this.TABLE_VEHUNIT[this.language])) {
                    this.readVehicleUnits(line, reader);
                } else if (line.startsWith(this.TABLE_VEHCOMB[this.language])) {
                    this.readVehicleCombinations(line, reader);
                } else if (line.startsWith(this.TABLE_VEHUNITTOVEHCOMB[this.language])) {
                    this.readVehicleUnitToVehicleCombination(line, reader);
                } else if (line.startsWith("$")) {
                    this.readUnknownTable(reader);
                } else if (!line.startsWith("* ")) {
                    throw new IOException("cannot interpret line: " + line);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            this.log.warn("there was an exception while reading the file.", e);
            try {
                reader.close();
            }
            catch (IOException e2) {
                this.log.warn("could not close reader.", e2);
            }
            throw new UncheckedIOException(e);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            this.log.warn("could not close reader.", e);
        }
    }

    private void readVersion(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring("$VERSION:".length()), ';');
        int idxLanguage = this.getAttributeIndex("LANGUAGE", attributes);
        String line = reader.readLine();
        if (line == null) {
            throw new RuntimeException("Language definition cannot be found.");
        }
        String[] parts = StringUtils.explode(line, ';');
        if (parts[idxLanguage].equals("ENG")) {
            this.language = 0;
        } else if (parts[idxLanguage].equals("DEU")) {
            this.language = 1;
        } else {
            throw new RuntimeException("Unknown language: " + parts[idxLanguage]);
        }
        reader.readLine();
    }

    private void readEdgeTypes(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_LINKTYPE[this.language].length()), ';');
        int idxNo = this.getAttributeIndex(this.ATTRIBUTE_LINKTYPE_NO[this.language], attributes);
        int idxKapIV = this.getAttributeIndex(this.ATTRIBUTE_LINKTYPE_KAPIV[this.language], attributes);
        int idxV0IV = this.getAttributeIndex(this.ATTRIBUTE_LINKTYPE_V0IV[this.language], attributes);
        int idxNoOfLanes = this.getAttributeIndex(this.ATTRIBUTE_LINKTYPE_NOLANES[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            VisumNetwork.EdgeType edgeType = new VisumNetwork.EdgeType(Id.create(parts[idxNo], VisumNetwork.EdgeType.class), parts[idxKapIV], parts[idxV0IV], parts[idxNoOfLanes]);
            this.network.addEdgeType(edgeType);
            line = reader.readLine();
        }
    }

    private void readStops(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_STOP[this.language].length()), ';');
        int idxNo = this.getAttributeIndex(this.ATTRIBUTE_STOP_NO[this.language], attributes);
        int idxName = this.getAttributeIndex(this.ATTRIBUTE_STOP_NAME[this.language], attributes);
        int idxXcoord = this.getAttributeIndex(this.ATTRIBUTE_STOP_XCOORD[this.language], attributes);
        int idxYcoord = this.getAttributeIndex(this.ATTRIBUTE_STOP_YCOORD[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            VisumNetwork.Stop stop = new VisumNetwork.Stop(Id.create(parts[idxNo], VisumNetwork.Stop.class), parts[idxName], new Coord(Double.parseDouble(parts[idxXcoord].replace(',', '.')), Double.parseDouble(parts[idxYcoord].replace(',', '.'))));
            this.network.addStop(stop);
            line = reader.readLine();
        }
    }

    private void readStopAreas(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_STOPAREA[this.language].length()), ';');
        int idxNo = this.getAttributeIndex(this.ATTRIBUTE_STOPAREA_NO[this.language], attributes);
        int idxStopId = this.getAttributeIndex(this.ATTRIBUTE_STOPAREA_STOPNO[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            VisumNetwork.StopArea stopAr = new VisumNetwork.StopArea(Id.create(parts[idxNo], VisumNetwork.StopArea.class), Id.create(parts[idxStopId], VisumNetwork.Stop.class));
            this.network.addStopArea(stopAr);
            line = reader.readLine();
        }
    }

    private void readStopPoints(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_STOPPOINT[this.language].length()), ';');
        int idxNo = this.getAttributeIndex(this.ATTRIBUTE_STOPPT_NO[this.language], attributes);
        int idxStopAreaNo = this.getAttributeIndex(this.ATTRIBUTE_STOPPT_STOPAREANO[this.language], attributes);
        int idxName = this.getAttributeIndex(this.ATTRIBUTE_STOPPT_NAME[this.language], attributes);
        int idxRLNo = this.getAttributeIndex(this.ATTRIBUTE_STOPPT_RLNO[this.language], attributes);
        int idxNode = this.getAttributeIndex(this.ATTRIBUTE_STOPPT_NODE[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            VisumNetwork.StopPoint stopPt = new VisumNetwork.StopPoint(Id.create(parts[idxNo], VisumNetwork.StopPoint.class), Id.create(parts[idxStopAreaNo], VisumNetwork.StopArea.class), parts[idxName], Id.create(parts[idxRLNo], Link.class), Id.create(parts[idxNode], Node.class));
            this.network.addStopPoint(stopPt);
            line = reader.readLine();
        }
    }

    private void readLineRoutes(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_LINEROUTE[this.language].length()), ';');
        int idxName = this.getAttributeIndex(this.ATTRIBUTE_LR_NAME[this.language], attributes);
        int idxLineName = this.getAttributeIndex(this.ATTRIBUTE_LR_LINENAME[this.language], attributes);
        int idxDCode = this.getAttributeIndex(this.ATTRIBUTE_LR_DCODE[this.language], attributes);
        int idxTakt = this.getAttributeIndex(this.ATTRIBUTE_LR_TAKT[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            VisumNetwork.TransitLineRoute lr1 = new VisumNetwork.TransitLineRoute(Id.create(parts[idxName], VisumNetwork.TransitLineRoute.class), Id.create(parts[idxLineName], VisumNetwork.TransitLine.class), parts[idxDCode]);
            if (idxTakt != -1) {
                lr1.takt = parts[idxTakt];
            }
            this.network.addLineRoute(lr1);
            line = reader.readLine();
        }
    }

    private void readLines(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_LINE[this.language].length()), ';');
        int idxName = this.getAttributeIndex(this.ATTRIBUTE_L_NAME[this.language], attributes);
        int idxTCode = this.getAttributeIndex(this.ATTRIBUTE_L_TCODE[this.language], attributes);
        int idxVehCombNo = this.getAttributeIndex(this.ATTRIBUTE_L_VEHCOMBNO[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            VisumNetwork.TransitLine tLine = new VisumNetwork.TransitLine(Id.create(parts[idxName], VisumNetwork.TransitLine.class), parts[idxTCode], parts[idxVehCombNo]);
            this.network.addline(tLine);
            line = reader.readLine();
        }
    }

    private void readLineRouteItems(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_LINEROUTEITEM[this.language].length()), ';');
        int idxLineRouteName = this.getAttributeIndex(this.ATTRIBUTE_LRI_LRNAME[this.language], attributes);
        int idxLineName = this.getAttributeIndex(this.ATTRIBUTE_LRI_LNAME[this.language], attributes);
        int idxIndex = this.getAttributeIndex(this.ATTRIBUTE_LRI_ID[this.language], attributes);
        int idxDCode = this.getAttributeIndex(this.ATTRIBUTE_LRI_DCODE[this.language], attributes);
        int idxNodeId = this.getAttributeIndex(this.ATTRIBUTE_LRI_NODEID[this.language], attributes);
        int idxStopPointNo = this.getAttributeIndex(this.ATTRIBUTE_LRI_SPNO[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            Id<Node> nodeId = Id.create(parts[idxNodeId], Node.class);
            String stopPointNoString = parts[idxStopPointNo];
            Id<VisumNetwork.StopPoint> stopPointNo = stopPointNoString.length() == 0 ? null : Id.create(stopPointNoString, VisumNetwork.StopPoint.class);
            VisumNetwork.LineRouteItem lri1 = new VisumNetwork.LineRouteItem(parts[idxLineName], parts[idxLineRouteName], parts[idxIndex], parts[idxDCode], nodeId, stopPointNo);
            this.network.addLineRouteItem(lri1);
            line = reader.readLine();
        }
    }

    private void readTimeProfile(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_TIMEPROFILE[this.language].length()), ';');
        int idxLineName = this.getAttributeIndex(this.ATTRIBUTE_TP_LNAME[this.language], attributes);
        int idxLineRouteName = this.getAttributeIndex(this.ATTRIBUTE_TP_LRNAME[this.language], attributes);
        int idxIndex = this.getAttributeIndex(this.ATTRIBUTE_TP_ID[this.language], attributes);
        int idxDCode = this.getAttributeIndex(this.ATTRIBUTE_TP_DCODE[this.language], attributes);
        int idxVehCombNo = this.getAttributeIndex(this.ATTRIBUTE_TP_VEHCOMBNO[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            VisumNetwork.TimeProfile tp1 = new VisumNetwork.TimeProfile(Id.create(parts[idxLineName], VisumNetwork.TransitLine.class), Id.create(parts[idxLineRouteName], VisumNetwork.TransitLineRoute.class), Id.create(parts[idxIndex], VisumNetwork.TimeProfile.class), parts[idxDCode], parts[idxVehCombNo]);
            this.network.addTimeProfile(tp1);
            line = reader.readLine();
        }
    }

    private void readTimeProfileItems(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_TIMEPROFILEITEM[this.language].length()), ';');
        int idxLineRouteName = this.getAttributeIndex(this.ATTRIBUTE_TPI_LRNAME[this.language], attributes);
        int idxLineName = this.getAttributeIndex(this.ATTRIBUTE_TPI_LNAME[this.language], attributes);
        int idxTPName = this.getAttributeIndex(this.ATTRIBUTE_TPI_TPNAME[this.language], attributes);
        int idxDCode = this.getAttributeIndex(this.ATTRIBUTE_TPI_DCODE[this.language], attributes);
        int idxIndex = this.getAttributeIndex(this.ATTRIBUTE_TPI_ID[this.language], attributes);
        int idxArr = this.getAttributeIndex(this.ATTRIBUTE_TPI_ARR[this.language], attributes);
        int idxDep = this.getAttributeIndex(this.ATTRIBUTE_TPI_DEP[this.language], attributes);
        int idxLRIIndex = this.getAttributeIndex(this.ATTRIBUTE_TPI_LRIINDEX[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            VisumNetwork.TimeProfileItem tpi1 = new VisumNetwork.TimeProfileItem(parts[idxLineName], parts[idxLineRouteName], parts[idxTPName], parts[idxDCode], parts[idxIndex], parts[idxArr], parts[idxDep], Id.create(parts[idxLRIIndex], VisumNetwork.TimeProfileItem.class));
            this.network.addTimeProfileItem(tpi1);
            line = reader.readLine();
        }
    }

    private void readDepartures(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_VEHJOURNEY[this.language].length()), ';');
        int idxLineRouteName = this.getAttributeIndex(this.ATTRIBUTE_D_LRNAME[this.language], attributes);
        int idxLineName = this.getAttributeIndex(this.ATTRIBUTE_D_LNAME[this.language], attributes);
        int idxNo = this.getAttributeIndex(this.ATTRIBUTE_D_ID[this.language], attributes);
        int idxTRI = this.getAttributeIndex(this.ATTRIBUTE_D_TPNAME[this.language], attributes);
        int idxDep = this.getAttributeIndex(this.ATTRIBUTE_D_DEP[this.language], attributes);
        int idxDCode = this.getAttributeIndex(this.ATTRIBUTE_D_DCODE[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            VisumNetwork.Departure d = new VisumNetwork.Departure(parts[idxLineName], parts[idxLineRouteName], parts[idxNo], parts[idxTRI], parts[idxDep], parts[idxDCode]);
            this.network.addDeparture(d);
            line = reader.readLine();
        }
    }

    private void readDepartureSections(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_VEHJOURNEYSECTION[this.language].length()), ';');
        int idxVehicleJourneyNo = this.getAttributeIndex(this.ATTRIBUTE_VJS_VEHJOURNEYNO[this.language], attributes);
        int idxVehCombinationNo = this.getAttributeIndex(this.ATTRIBUTE_VJS_VEHCOMBNO[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            String vehJourneyNo = parts[idxVehicleJourneyNo];
            String vehCombNo = parts[idxVehCombinationNo];
            VisumNetwork.Departure d = this.network.departuresByNo.get(vehJourneyNo);
            d.vehCombinationNo = vehCombNo;
            line = reader.readLine();
        }
    }

    private void readVehicleUnits(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_VEHUNIT[this.language].length()), ';');
        int idxId = this.getAttributeIndex(this.ATTRIBUTE_VEHUNIT_ID[this.language], attributes);
        int idxCode = this.getAttributeIndex(this.ATTRIBUTE_VEHUNIT_CODE[this.language], attributes);
        int idxSeatCap = this.getAttributeIndex(this.ATTRIBUTE_VEHUNIT_SEATCAP[this.language], attributes);
        int idxTotalCap = this.getAttributeIndex(this.ATTRIBUTE_VEHUNIT_TOTALCAP[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            VisumNetwork.VehicleUnit vehicleUnit = new VisumNetwork.VehicleUnit(parts[idxId], parts[idxCode], Integer.parseInt(parts[idxSeatCap]), Integer.parseInt(parts[idxTotalCap]));
            this.network.addVehicleUnit(vehicleUnit);
            line = reader.readLine();
        }
    }

    private void readVehicleCombinations(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_VEHCOMB[this.language].length()), ';');
        int idxId = this.getAttributeIndex(this.ATTRIBUTE_VEHCOMB_NO[this.language], attributes);
        int idxName = this.getAttributeIndex(this.ATTRIBUTE_VEHCOMB_NAME[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            VisumNetwork.VehicleCombination vehicleComb = new VisumNetwork.VehicleCombination(parts[idxId], parts[idxName]);
            this.network.addVehicleCombination(vehicleComb);
            line = reader.readLine();
        }
    }

    private void readVehicleUnitToVehicleCombination(String tableAttributes, BufferedReader reader) throws IOException {
        String[] attributes = StringUtils.explode(tableAttributes.substring(this.TABLE_VEHUNITTOVEHCOMB[this.language].length()), ';');
        int idxVehicleUnit = this.getAttributeIndex(this.ATTRIBUTE_VEHUNITTOVEHCOMB_VEHUNITNO[this.language], attributes);
        int idxVehicleComb = this.getAttributeIndex(this.ATTRIBUTE_VEHUNITTOVEHCOMB_VEHCOMBNO[this.language], attributes);
        int idxVehicleNumber = this.getAttributeIndex(this.ATTRIBUTE_VEHUNITTOVEHCOMB_NUMVEHUNITS[this.language], attributes);
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            String[] parts = StringUtils.explode(line, ';');
            VisumNetwork.VehicleCombination vehicleComb = this.network.vehicleCombinations.get(parts[idxVehicleComb]);
            vehicleComb.vehUnitId = parts[idxVehicleUnit];
            vehicleComb.numOfVehicles = Integer.parseInt(parts[idxVehicleNumber]);
            line = reader.readLine();
        }
    }

    private void readUnknownTable(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            line = reader.readLine();
        }
    }

    private int getAttributeIndex(String attribute, String[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].equals(attribute)) continue;
            return i;
        }
        return -1;
    }
}

