/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.controller;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.controler.Controler;
import org.matsim.core.controler.events.StartupEvent;
import org.matsim.core.controler.listener.StartupListener;
import org.matsim.core.mobsim.framework.Mobsim;
import org.matsim.core.mobsim.qsim.QSim;
import org.matsim.core.population.routes.RouteFactories;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.costcalculators.OnlyTimeDependentTravelDisutilityFactory;
import org.matsim.core.router.costcalculators.TravelDisutilityFactory;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.scoring.functions.OnlyTravelTimeDependentScoringFunctionFactory;
import org.matsim.withinday.controller.WithinDayConfigGroup;
import org.matsim.withinday.controller.WithinDayModule;
import org.matsim.withinday.mobsim.MobsimDataProvider;
import org.matsim.withinday.mobsim.WithinDayEngine;
import org.matsim.withinday.replanning.identifiers.ActivityEndIdentifierFactory;
import org.matsim.withinday.replanning.identifiers.InitialIdentifierImplFactory;
import org.matsim.withinday.replanning.identifiers.LeaveLinkIdentifierFactory;
import org.matsim.withinday.replanning.identifiers.filter.ProbabilityFilterFactory;
import org.matsim.withinday.replanning.identifiers.interfaces.DuringActivityAgentSelector;
import org.matsim.withinday.replanning.identifiers.interfaces.DuringActivityIdentifierFactory;
import org.matsim.withinday.replanning.identifiers.interfaces.DuringLegAgentSelector;
import org.matsim.withinday.replanning.identifiers.interfaces.DuringLegIdentifierFactory;
import org.matsim.withinday.replanning.identifiers.interfaces.InitialIdentifier;
import org.matsim.withinday.replanning.identifiers.interfaces.InitialIdentifierFactory;
import org.matsim.withinday.replanning.identifiers.tools.ActivityReplanningMap;
import org.matsim.withinday.replanning.identifiers.tools.LinkReplanningMap;
import org.matsim.withinday.replanning.replanners.CurrentLegReplannerFactory;
import org.matsim.withinday.replanning.replanners.InitialReplannerFactory;
import org.matsim.withinday.replanning.replanners.NextLegReplannerFactory;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayDuringActivityReplannerFactory;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayDuringLegReplannerFactory;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayInitialReplannerFactory;

@Singleton
public final class ExampleWithinDayController
implements StartupListener {
    private double pInitialReplanning = 0.0;
    private double pDuringActivityReplanning = 1.0;
    private double pDuringLegReplanning = 0.1;
    private InitialIdentifierFactory initialIdentifierFactory;
    private DuringActivityIdentifierFactory duringActivityIdentifierFactory;
    private DuringLegIdentifierFactory duringLegIdentifierFactory;
    private InitialIdentifier initialIdentifier;
    private DuringActivityAgentSelector duringActivityIdentifier;
    private DuringLegAgentSelector duringLegIdentifier;
    private WithinDayInitialReplannerFactory initialReplannerFactory;
    private WithinDayDuringActivityReplannerFactory duringActivityReplannerFactory;
    private WithinDayDuringLegReplannerFactory duringLegReplannerFactory;
    private ProbabilityFilterFactory initialProbabilityFilterFactory;
    private ProbabilityFilterFactory duringActivityProbabilityFilterFactory;
    private ProbabilityFilterFactory duringLegProbabilityFilterFactory;
    @Inject
    private Scenario scenario;
    @Inject
    private Provider<TripRouter> tripRouterProvider;
    @Inject
    private MobsimDataProvider mobsimDataProvider;
    @Inject
    private WithinDayEngine withinDayEngine;
    @Inject
    private ActivityReplanningMap activityReplanningMap;
    @Inject
    private LinkReplanningMap linkReplanningMap;
    @Inject
    private LeastCostPathCalculatorFactory pathCalculatorFactory;
    @Inject
    private Map<String, TravelDisutilityFactory> travelDisutilityFactories;
    @Inject
    private Map<String, TravelTime> travelTimes;
    @Inject
    private Mobsim mobsim;

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("No argument given!");
            System.out.println("Usage: Controler config-file");
            System.out.println();
            System.exit(-1);
        }
        Config config = ConfigUtils.loadConfig(args[0], new WithinDayConfigGroup());
        config.controler().setRoutingAlgorithmType(ControlerConfigGroup.RoutingAlgorithmType.Dijkstra);
        Scenario scenario = ScenarioUtils.loadScenario(config);
        Controler controler = new Controler(scenario);
        ExampleWithinDayController.configure(controler);
        controler.run();
    }

    static void configure(Controler controler) {
        controler.addOverridingModule(new AbstractModule(){

            @Override
            public void install() {
                this.install(new WithinDayModule());
                this.addControlerListenerBinding().to(ExampleWithinDayController.class);
                this.addTravelDisutilityFactoryBinding("car").toInstance(new OnlyTimeDependentTravelDisutilityFactory());
                this.bindScoringFunctionFactory().toInstance(new OnlyTravelTimeDependentScoringFunctionFactory());
            }
        });
    }

    @Override
    public void notifyStartup(StartupEvent event) {
        this.initReplanners();
    }

    private void initReplanners() {
        RouteFactories routeFactory = this.scenario.getPopulation().getFactory().getRouteFactories();
        Network network = this.scenario.getNetwork();
        TravelTime travelTime = this.travelTimes.get("car");
        TravelDisutilityFactory travelDisutilityFactory = this.travelDisutilityFactories.get("car");
        TravelDisutility travelDisutility = travelDisutilityFactory.createTravelDisutility(travelTime);
        LeastCostPathCalculator pathCalculator = this.pathCalculatorFactory.createPathCalculator(network, travelDisutility, travelTime);
        this.initialIdentifierFactory = new InitialIdentifierImplFactory(this.mobsimDataProvider);
        this.initialProbabilityFilterFactory = new ProbabilityFilterFactory(this.pInitialReplanning);
        this.initialIdentifierFactory.addAgentFilterFactory(this.initialProbabilityFilterFactory);
        this.initialIdentifier = this.initialIdentifierFactory.createIdentifier();
        this.initialReplannerFactory = new InitialReplannerFactory(this.scenario, this.withinDayEngine, this.tripRouterProvider);
        this.initialReplannerFactory.addIdentifier(this.initialIdentifier);
        this.withinDayEngine.addIntialReplannerFactory(this.initialReplannerFactory);
        this.duringActivityIdentifierFactory = new ActivityEndIdentifierFactory(this.activityReplanningMap);
        this.duringActivityProbabilityFilterFactory = new ProbabilityFilterFactory(this.pDuringActivityReplanning);
        this.duringActivityIdentifierFactory.addAgentFilterFactory(this.duringActivityProbabilityFilterFactory);
        this.duringActivityIdentifier = this.duringActivityIdentifierFactory.createIdentifier();
        this.duringActivityReplannerFactory = new NextLegReplannerFactory(this.scenario, this.withinDayEngine, this.tripRouterProvider, (QSim)this.mobsim);
        this.duringActivityReplannerFactory.addIdentifier(this.duringActivityIdentifier);
        this.withinDayEngine.addDuringActivityReplannerFactory(this.duringActivityReplannerFactory);
        this.duringLegIdentifierFactory = new LeaveLinkIdentifierFactory(this.linkReplanningMap, this.mobsimDataProvider);
        this.duringLegProbabilityFilterFactory = new ProbabilityFilterFactory(this.pDuringLegReplanning);
        this.duringLegIdentifierFactory.addAgentFilterFactory(this.duringLegProbabilityFilterFactory);
        this.duringLegIdentifier = this.duringLegIdentifierFactory.createIdentifier();
        this.duringLegReplannerFactory = new CurrentLegReplannerFactory(this.scenario, this.withinDayEngine, pathCalculator, routeFactory);
        this.duringLegReplannerFactory.addIdentifier(this.duringLegIdentifier);
        this.withinDayEngine.addDuringLegReplannerFactory(this.duringLegReplannerFactory);
    }
}

