/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.controller;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationWriter;
import org.matsim.core.config.Config;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.events.AfterMobsimEvent;
import org.matsim.core.controler.listener.AfterMobsimListener;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.agents.PersonDriverAgentImpl;
import org.matsim.core.mobsim.qsim.agents.WithinDayAgentUtils;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.withinday.controller.ExecutedPlansService;
import org.matsim.withinday.mobsim.MobsimDataProvider;

@Singleton
public class ExecutedPlansServiceImpl
implements AfterMobsimListener,
ExecutedPlansService {
    private static final Logger log = Logger.getLogger(ExecutedPlansServiceImpl.class);
    public static final String EXECUTEDPLANSFILE = "executedPlans.xml.gz";
    private Population experiencedPopulation;
    private Scenario scenario;
    private MobsimDataProvider mobsimDataProvider;
    private OutputDirectoryHierarchy controlerIO;

    @Inject
    ExecutedPlansServiceImpl(Scenario scenario, MobsimDataProvider mobsimDataProvider, OutputDirectoryHierarchy controlerIO) {
        this.scenario = scenario;
        this.mobsimDataProvider = mobsimDataProvider;
        this.controlerIO = controlerIO;
    }

    @Override
    public void notifyAfterMobsim(AfterMobsimEvent event) {
        Gbl.assertNotNull(this.scenario);
        Config config = this.scenario.getConfig();
        Scenario experiencedScenario = ScenarioUtils.createScenario(config);
        this.experiencedPopulation = experiencedScenario.getPopulation();
        for (Person person : this.scenario.getPopulation().getPersons().values()) {
            MobsimAgent agent = this.mobsimDataProvider.getAgent(person.getId());
            if (agent == null || !(agent instanceof PersonDriverAgentImpl)) {
                this.experiencedPopulation.addPerson(person);
                continue;
            }
            Person experiencedPerson = this.experiencedPopulation.getFactory().createPerson(person.getId());
            Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
            experiencedPerson.addPlan(plan);
            experiencedPerson.setSelectedPlan(plan);
            PersonUtils.setAge(experiencedPerson, PersonUtils.getAge(person));
            PersonUtils.setCarAvail(experiencedPerson, PersonUtils.getCarAvail(person));
            PersonUtils.setEmployed(experiencedPerson, PersonUtils.isEmployed(person));
            PersonUtils.setLicence(experiencedPerson, PersonUtils.getLicense(person));
            PersonUtils.setSex(experiencedPerson, PersonUtils.getSex(person));
            this.experiencedPopulation.addPerson(experiencedPerson);
        }
        String outputFile = this.controlerIO.getIterationFilename(event.getIteration(), EXECUTEDPLANSFILE);
        this.writeExecutedPlans(outputFile);
    }

    @Override
    public void writeExecutedPlans(String outputFile) {
        Config config = this.scenario.getConfig();
        String inputCRS = config.plans().getInputCRS();
        String internalCRS = config.global().getCoordinateSystem();
        if (inputCRS == null) {
            new PopulationWriter(this.experiencedPopulation, this.scenario.getNetwork()).write(outputFile);
        } else {
            log.info("re-projecting \"experienced\" population from " + internalCRS + " to " + inputCRS + " for export");
            CoordinateTransformation transformation = TransformationFactory.getCoordinateTransformation(internalCRS, inputCRS);
            new PopulationWriter(transformation, this.experiencedPopulation, this.scenario.getNetwork()).write(outputFile);
        }
    }

    @Override
    public Map<Id<Person>, Plan> getExecutedPlans() {
        HashMap<Id<Person>, Plan> map = new HashMap<Id<Person>, Plan>();
        for (Person person : this.experiencedPopulation.getPersons().values()) {
            map.put(person.getId(), (Plan)person.getSelectedPlan());
        }
        return map;
    }
}

