/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.controler.events.StartupEvent;
import org.matsim.core.controler.listener.StartupListener;
import org.matsim.core.mobsim.framework.listeners.FixedOrderSimulationListener;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.costcalculators.TravelDisutilityFactory;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.TravelTime;
import org.matsim.pt.router.TransitRouter;
import org.matsim.withinday.mobsim.MobsimDataProvider;
import org.matsim.withinday.mobsim.WithinDayEngine;
import org.matsim.withinday.replanning.identifiers.tools.ActivityReplanningMap;
import org.matsim.withinday.replanning.identifiers.tools.LinkReplanningMap;
import org.matsim.withinday.trafficmonitoring.EarliestLinkExitTimeProvider;
import org.matsim.withinday.trafficmonitoring.WithinDayTravelTime;

public class WithinDayControlerListener
implements StartupListener {
    private static final Logger log = Logger.getLogger(WithinDayControlerListener.class);
    private int numReplanningThreads = 0;
    @Inject
    private WithinDayTravelTime withinDayTravelTime;
    @Inject
    private ActivityReplanningMap activityReplanningMap;
    @Inject
    private LinkReplanningMap linkReplanningMap;
    @Inject
    private MobsimDataProvider mobsimDataProvider;
    @Inject
    private EarliestLinkExitTimeProvider earliestLinkExitTimeProvider;
    @Inject
    private EventsManager eventsManager;
    @Inject
    private Scenario scenario;
    @Inject
    private WithinDayEngine withinDayEngine;
    @Inject
    private FixedOrderSimulationListener fosl;
    private final Map<String, TravelTime> multiModalTravelTimes = new HashMap<String, TravelTime>();

    public void setNumberOfReplanningThreads(int threads) {
        throw new RuntimeException(this.getClass().toString() + " configuration has already been locked!");
    }

    public void setTravelDisutilityFactory(TravelDisutilityFactory travelDisutilityFactory) {
        throw new RuntimeException(this.getClass().toString() + " configuration has already been locked!");
    }

    public void setLeastCostPathCalculatorFactory(LeastCostPathCalculatorFactory leastCostPathCalculatorFactory) {
        throw new RuntimeException(this.getClass().toString() + " configuration has already been locked!");
    }

    public void setTransitRouterFactory(Provider<TransitRouter> transitRouterFactory) {
        throw new RuntimeException(this.getClass().toString() + " configuration has already been locked!");
    }

    public void setModesAnalyzedByWithinDayTravelTime(Set<String> modes) {
        throw new RuntimeException(this.getClass().toString() + " configuration has already been locked!");
    }

    public Map<String, TravelTime> getMultiModalTravelTimes() {
        return Collections.unmodifiableMap(this.multiModalTravelTimes);
    }

    public void addMultiModalTravelTimes(Map<String, TravelTime> multiModalTravelTimes) {
        for (Map.Entry<String, TravelTime> entry : multiModalTravelTimes.entrySet()) {
            this.addMultiModalTravelTime(entry.getKey(), entry.getValue());
        }
    }

    public void addMultiModalTravelTime(String mode, TravelTime travelTime) {
        throw new RuntimeException(this.getClass().toString() + " configuration has already been locked!");
    }

    public WithinDayTravelTime getWithinDayTravelTime() {
        return this.withinDayTravelTime;
    }

    public EarliestLinkExitTimeProvider getEarliestLinkExitTimeProvider() {
        return this.earliestLinkExitTimeProvider;
    }

    public void setWithinDayTripRouterFactory(Provider<TripRouter> tripRouterFactory) {
        throw new RuntimeException(this.getClass().toString() + " configuration has already been locked!");
    }

    public FixedOrderSimulationListener getFixedOrderSimulationListener() {
        return this.fosl;
    }

    @Override
    public void notifyStartup(StartupEvent event) {
        this.initWithinDayEngine(this.numReplanningThreads);
        this.createAndInitMobsimDataProvider();
        this.createAndInitActivityReplanningMap();
        this.createAndInitLinkReplanningMap();
    }

    private void initWithinDayEngine(int numOfThreads) {
        log.info("Initialize WithinDayEngine");
    }

    private void createAndInitMobsimDataProvider() {
        this.getFixedOrderSimulationListener().addSimulationListener(this.mobsimDataProvider);
    }

    private void createAndInitActivityReplanningMap() {
        this.fosl.addSimulationListener(this.activityReplanningMap);
    }

    private void createAndInitLinkReplanningMap() {
        this.fosl.addSimulationListener(this.linkReplanningMap);
    }
}

