/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.controller;

import com.google.inject.Provides;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.mobsim.framework.Mobsim;
import org.matsim.core.mobsim.framework.listeners.FixedOrderSimulationListener;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.trafficmonitoring.FreeSpeedTravelTime;
import org.matsim.withinday.controller.WithinDayControlerListener;
import org.matsim.withinday.mobsim.MobsimDataProvider;
import org.matsim.withinday.mobsim.WithinDayEngine;
import org.matsim.withinday.mobsim.WithinDayQSimFactory;
import org.matsim.withinday.replanning.identifiers.tools.ActivityReplanningMap;
import org.matsim.withinday.replanning.identifiers.tools.LinkReplanningMap;
import org.matsim.withinday.trafficmonitoring.EarliestLinkExitTimeProvider;
import org.matsim.withinday.trafficmonitoring.WithinDayTravelTimeModule;

public class WithinDayModule
extends AbstractModule {
    @Override
    public void install() {
        this.install(new WithinDayTravelTimeModule());
        this.bind(WithinDayEngine.class);
        this.bind(Mobsim.class).toProvider(WithinDayQSimFactory.class);
        this.bind(FixedOrderSimulationListener.class).asEagerSingleton();
        this.bind(WithinDayControlerListener.class).asEagerSingleton();
        this.addControlerListenerBinding().to(WithinDayControlerListener.class);
        this.bind(MobsimDataProvider.class).asEagerSingleton();
        this.bind(ActivityReplanningMap.class).asEagerSingleton();
        this.bind(LinkReplanningMap.class).asEagerSingleton();
        this.bind(EarliestLinkExitTimeProvider.class).asEagerSingleton();
    }

    @Provides
    @Named(value="lowerBound")
    Map<String, TravelTime> provideEarliestLinkExitTravelTimes(Map<String, TravelTime> travelTimes) {
        HashMap<String, TravelTime> earliestLinkExitTravelTimes = new HashMap<String, TravelTime>();
        earliestLinkExitTravelTimes.putAll(travelTimes);
        earliestLinkExitTravelTimes.put("car", new FreeSpeedTravelTime());
        return earliestLinkExitTravelTimes;
    }
}

