/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.mobsim;

import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.mobsim.framework.DriverAgent;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.events.MobsimInitializedEvent;
import org.matsim.core.mobsim.framework.listeners.MobsimInitializedListener;
import org.matsim.core.mobsim.qsim.QSim;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.vehicles.Vehicle;

@Singleton
public final class MobsimDataProvider
implements MobsimInitializedListener {
    private QSim qSim;

    @Inject
    MobsimDataProvider() {
    }

    @Override
    public final void notifyMobsimInitialized(MobsimInitializedEvent e) {
        this.qSim = (QSim)e.getQueueSimulation();
    }

    public final Map<Id<Person>, MobsimAgent> getAgents() {
        return this.qSim.getAgents();
    }

    public final MobsimAgent getAgent(Id<Person> agentId) {
        return this.getAgents().get(agentId);
    }

    public final Map<Id<Vehicle>, MobsimVehicle> getVehicles() {
        return this.qSim.getVehicles();
    }

    public final MobsimVehicle getVehicle(Id<Vehicle> vehicleId) {
        return this.getVehicles().get(vehicleId);
    }

    public final Collection<MobsimVehicle> getEnrouteVehiclesOnLink(Id<Link> linkId) {
        return this.qSim.getNetsimNetwork().getNetsimLink(linkId).getAllNonParkedVehicles();
    }

    public final MobsimVehicle getDriversVehicle(Id<Person> driverId) {
        MobsimAgent mobsimAgent = this.getAgents().get(driverId);
        if (mobsimAgent == null) {
            return null;
        }
        DriverAgent driver = (DriverAgent)((Object)mobsimAgent);
        return driver.getVehicle();
    }

    public final MobsimAgent getVehiclesDriver(Id<Vehicle> vehicleId) {
        MobsimVehicle mobsimVehicle = this.getVehicles().get(vehicleId);
        if (mobsimVehicle == null) {
            return null;
        }
        return mobsimVehicle.getDriver();
    }
}

