/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.mobsim;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.mobsim.qsim.ActivityEndRescheduler;
import org.matsim.core.mobsim.qsim.ActivityEndReschedulerProvider;
import org.matsim.core.mobsim.qsim.InternalInterface;
import org.matsim.core.mobsim.qsim.interfaces.MobsimEngine;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.withinday.mobsim.DuringActivityReplanningModule;
import org.matsim.withinday.mobsim.DuringLegReplanningModule;
import org.matsim.withinday.mobsim.InitialReplanningModule;
import org.matsim.withinday.replanning.parallel.ParallelDuringActivityReplanner;
import org.matsim.withinday.replanning.parallel.ParallelDuringLegReplanner;
import org.matsim.withinday.replanning.parallel.ParallelInitialReplanner;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayDuringActivityReplannerFactory;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayDuringLegReplannerFactory;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayInitialReplannerFactory;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayReplannerFactory;

@Singleton
public class WithinDayEngine
implements MobsimEngine,
ActivityEndReschedulerProvider {
    private static final Logger log = Logger.getLogger(WithinDayEngine.class);
    private final EventsManager eventsManager;
    private boolean initialReplanning = true;
    private boolean duringActivityReplanning = true;
    private boolean duringLegReplanning = true;
    private boolean initialReplanningPerformed = false;
    private InitialReplanningModule initialReplanningModule;
    private DuringActivityReplanningModule duringActivityReplanningModule;
    private DuringLegReplanningModule duringLegReplanningModule;
    private ParallelInitialReplanner parallelInitialReplanner;
    private ParallelDuringActivityReplanner parallelDuringActivityReplanner;
    private ParallelDuringLegReplanner parallelDuringLegReplanner;
    private Map<WithinDayDuringActivityReplannerFactory, Tuple<Double, Double>> duringActivityReplannerFactory;
    private Map<WithinDayDuringLegReplannerFactory, Tuple<Double, Double>> duringLegReplannerFactory;
    private InternalInterface internalInterface;

    @Inject
    public WithinDayEngine(EventsManager eventsManager, GlobalConfigGroup globalConfigGroup) {
        this.eventsManager = eventsManager;
        this.duringActivityReplannerFactory = new LinkedHashMap<WithinDayDuringActivityReplannerFactory, Tuple<Double, Double>>();
        this.duringLegReplannerFactory = new LinkedHashMap<WithinDayDuringLegReplannerFactory, Tuple<Double, Double>>();
        log.info("Initialize Parallel Replanning Modules");
        this.parallelInitialReplanner = new ParallelInitialReplanner(globalConfigGroup.getNumberOfThreads(), eventsManager);
        this.parallelDuringActivityReplanner = new ParallelDuringActivityReplanner(globalConfigGroup.getNumberOfThreads(), eventsManager);
        this.parallelDuringLegReplanner = new ParallelDuringLegReplanner(globalConfigGroup.getNumberOfThreads(), eventsManager);
        log.info("Initialize Replanning Modules");
        this.initialReplanningModule = new InitialReplanningModule(this.parallelInitialReplanner);
        this.duringActivityReplanningModule = new DuringActivityReplanningModule(this.parallelDuringActivityReplanner);
        this.duringLegReplanningModule = new DuringLegReplanningModule(this.parallelDuringLegReplanner);
    }

    public void doInitialReplanning(boolean value) {
        this.initialReplanning = value;
    }

    public boolean isInitialReplanning() {
        return this.initialReplanning;
    }

    public void doDuringActivityReplanning(boolean value) {
        this.duringActivityReplanning = value;
    }

    public boolean isDuringActivityReplanning() {
        return this.duringActivityReplanning;
    }

    public void doDuringLegReplanning(boolean value) {
        this.duringLegReplanning = value;
    }

    public boolean isDuringLegReplanning() {
        return this.duringLegReplanning;
    }

    public void addIntialReplannerFactory(WithinDayInitialReplannerFactory factory) {
        this.parallelInitialReplanner.addWithinDayReplannerFactory(factory);
    }

    public void addDuringActivityReplannerFactory(WithinDayDuringActivityReplannerFactory factory) {
        this.parallelDuringActivityReplanner.addWithinDayReplannerFactory(factory);
    }

    public void addDuringLegReplannerFactory(WithinDayDuringLegReplannerFactory factory) {
        this.parallelDuringLegReplanner.addWithinDayReplannerFactory(factory);
    }

    public void removeInitialReplannerFactory(WithinDayInitialReplannerFactory factory) {
        this.parallelInitialReplanner.removeWithinDayReplannerFactory(factory);
    }

    public void removeDuringActivityReplannerFactory(WithinDayDuringActivityReplannerFactory factory) {
        this.parallelDuringActivityReplanner.removeWithinDayReplannerFactory(factory);
    }

    public void removeDuringLegReplannerFactory(WithinDayDuringLegReplannerFactory factory) {
        this.parallelDuringLegReplanner.removeWithinDayReplannerFactory(factory);
    }

    public void addTimedDuringActivityReplannerFactory(WithinDayDuringActivityReplannerFactory factory, double startReplanning, double endReplanning) {
        Tuple<Double, Double> tuple = new Tuple<Double, Double>(startReplanning, endReplanning);
        this.duringActivityReplannerFactory.put(factory, tuple);
    }

    public void addTimedDuringLegReplannerFactory(WithinDayDuringLegReplannerFactory factory, double startReplanning, double endReplanning) {
        Tuple<Double, Double> tuple = new Tuple<Double, Double>(startReplanning, endReplanning);
        this.duringLegReplannerFactory.put(factory, tuple);
    }

    @Override
    public void doSimStep(double time) {
        if (!this.initialReplanningPerformed && this.isInitialReplanning()) {
            this.initialReplanningModule.doReplanning(Double.NEGATIVE_INFINITY);
            this.initialReplanningPerformed = true;
        }
        for (Map.Entry<WithinDayDuringActivityReplannerFactory, Tuple<Double, Double>> entry : this.duringActivityReplannerFactory.entrySet()) {
            if (entry.getValue().getFirst() == time) {
                this.parallelDuringActivityReplanner.addWithinDayReplannerFactory((WithinDayReplannerFactory)entry.getKey());
            }
            if (entry.getValue().getSecond() != time) continue;
            this.parallelDuringActivityReplanner.removeWithinDayReplannerFactory((WithinDayReplannerFactory)entry.getKey());
        }
        for (Map.Entry<WithinDayReplannerFactory, Tuple<Double, Double>> entry : this.duringLegReplannerFactory.entrySet()) {
            if (entry.getValue().getFirst() == time) {
                this.parallelDuringLegReplanner.addWithinDayReplannerFactory(entry.getKey());
            }
            if (entry.getValue().getSecond() != time) continue;
            this.parallelDuringLegReplanner.removeWithinDayReplannerFactory(entry.getKey());
        }
        if (this.isDuringActivityReplanning()) {
            this.duringActivityReplanningModule.doReplanning(time);
        }
        if (this.isDuringLegReplanning()) {
            this.duringLegReplanningModule.doReplanning(time);
        }
    }

    @Override
    public void onPrepareSim() {
        this.parallelInitialReplanner.onPrepareSim();
        this.parallelDuringActivityReplanner.onPrepareSim();
        this.parallelDuringLegReplanner.onPrepareSim();
        this.parallelInitialReplanner.resetReplanners();
        this.parallelDuringActivityReplanner.resetReplanners();
        this.parallelDuringLegReplanner.resetReplanners();
        this.initialReplanningPerformed = false;
    }

    @Override
    public void afterSim() {
        this.parallelInitialReplanner.afterSim();
        this.parallelDuringActivityReplanner.afterSim();
        this.parallelDuringLegReplanner.afterSim();
    }

    @Override
    public void setInternalInterface(InternalInterface internalInterface) {
        this.internalInterface = internalInterface;
    }

    @Override
    public ActivityEndRescheduler getActivityRescheduler() {
        return this.internalInterface.getMobsim();
    }
}

