/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.mobsim;

import com.google.inject.Provider;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.mobsim.framework.Mobsim;
import org.matsim.core.mobsim.framework.listeners.FixedOrderSimulationListener;
import org.matsim.core.mobsim.qsim.QSimBuilder;
import org.matsim.withinday.mobsim.WithinDayEngine;
import org.matsim.withinday.mobsim.WithinDayQSimModule;
import org.matsim.withinday.trafficmonitoring.WithinDayTravelTime;

public class WithinDayQSimFactory
implements Provider<Mobsim> {
    private static final Logger log = Logger.getLogger(WithinDayQSimFactory.class);
    private final Scenario scenario;
    private final EventsManager eventsManager;
    private final WithinDayEngine withinDayEngine;
    private final FixedOrderSimulationListener fixedOrderSimulationListener;
    private final WithinDayTravelTime withinDayTravelTime;

    @Inject
    WithinDayQSimFactory(Scenario scenario, EventsManager eventsManager, WithinDayEngine withinDayEngine, FixedOrderSimulationListener fixedOrderSimulationListener, WithinDayTravelTime WithinDayTravelTime2) {
        this.scenario = scenario;
        this.eventsManager = eventsManager;
        this.withinDayEngine = withinDayEngine;
        this.fixedOrderSimulationListener = fixedOrderSimulationListener;
        this.withinDayTravelTime = WithinDayTravelTime2;
    }

    @Override
    public Mobsim get() {
        Config config = this.scenario.getConfig();
        log.info("Adding WithinDayEngine to Mobsim.");
        return new QSimBuilder(config).useDefaults().addQSimModule(new WithinDayQSimModule(this.withinDayEngine, this.fixedOrderSimulationListener, this.withinDayTravelTime)).configureQSimComponents(WithinDayQSimModule::configureComponents).build(this.scenario, this.eventsManager);
    }
}

