/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.identifiers.filter;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.mobsim.framework.DriverAgent;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.withinday.replanning.identifiers.interfaces.AgentFilter;

public class ActivityStartingFilter
implements AgentFilter {
    private final Map<Id<Person>, MobsimAgent> agents;

    ActivityStartingFilter(Map<Id<Person>, MobsimAgent> agents) {
        this.agents = agents;
    }

    @Override
    public void applyAgentFilter(Set<Id<Person>> set, double time) {
        Iterator<Id<Person>> iter = set.iterator();
        while (iter.hasNext()) {
            Id<Person> id = iter.next();
            if (this.applyAgentFilter(id, time)) continue;
            iter.remove();
        }
    }

    @Override
    public boolean applyAgentFilter(Id<Person> id, double time) {
        MobsimAgent agent = this.agents.get(id);
        if (agent.getState() != MobsimAgent.State.LEG) {
            return false;
        }
        DriverAgent driver = (DriverAgent)((Object)agent);
        return !driver.isWantingToArriveOnCurrentLink();
    }
}

