/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.identifiers.filter;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.withinday.replanning.identifiers.interfaces.AgentFilter;

public class AgentTypeFilter
implements AgentFilter {
    private final Map<Id<Person>, MobsimAgent> agents;
    private final Set<Class<?>> includedAgentTypes;

    AgentTypeFilter(Map<Id<Person>, MobsimAgent> agents, Set<Class<?>> includedAgentTypes) {
        this.agents = agents;
        this.includedAgentTypes = includedAgentTypes;
    }

    @Override
    public void applyAgentFilter(Set<Id<Person>> set, double time) {
        Iterator<Id<Person>> iter = set.iterator();
        while (iter.hasNext()) {
            Id<Person> id = iter.next();
            if (this.applyAgentFilter(id, time)) continue;
            iter.remove();
        }
    }

    @Override
    public boolean applyAgentFilter(Id<Person> id, double time) {
        MobsimAgent agent = this.agents.get(id);
        return this.includedAgentTypes.contains(agent.getClass());
    }
}

