/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.identifiers.filter;

import java.util.Iterator;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.utils.misc.Time;
import org.matsim.withinday.replanning.identifiers.interfaces.AgentFilter;
import org.matsim.withinday.trafficmonitoring.EarliestLinkExitTimeProvider;

public class EarliestLinkExitTimeFilter
implements AgentFilter {
    private final EarliestLinkExitTimeProvider earliestLinkExitTimeProvider;

    EarliestLinkExitTimeFilter(EarliestLinkExitTimeProvider earliestLinkExitTimeProvider) {
        this.earliestLinkExitTimeProvider = earliestLinkExitTimeProvider;
    }

    @Override
    public void applyAgentFilter(Set<Id<Person>> set, double time) {
        Iterator<Id<Person>> iter = set.iterator();
        while (iter.hasNext()) {
            Id<Person> id = iter.next();
            if (this.applyAgentFilter(id, time)) continue;
            iter.remove();
        }
    }

    @Override
    public boolean applyAgentFilter(Id<Person> id, double time) {
        Double earliestLinkExitTime = this.earliestLinkExitTimeProvider.getEarliestLinkExitTime(id);
        if (Time.isUndefinedTime(earliestLinkExitTime)) {
            return false;
        }
        return !(earliestLinkExitTime <= time);
    }
}

