/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.identifiers.filter;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.agents.WithinDayAgentUtils;
import org.matsim.withinday.replanning.identifiers.interfaces.AgentFilter;

public class NextTransportModeFilter
implements AgentFilter {
    private final Map<Id<Person>, MobsimAgent> agents;
    private final Set<String> modes;

    NextTransportModeFilter(Map<Id<Person>, MobsimAgent> agents, Set<String> modes) {
        this.agents = agents;
        this.modes = modes;
    }

    @Override
    public void applyAgentFilter(Set<Id<Person>> set, double time) {
        Iterator<Id<Person>> iter = set.iterator();
        while (iter.hasNext()) {
            Id<Person> id = iter.next();
            if (this.applyAgentFilter(id, time)) continue;
            iter.remove();
        }
    }

    @Override
    public boolean applyAgentFilter(Id<Person> id, double time) {
        MobsimAgent agent = this.agents.get(id);
        if (agent.getState() != MobsimAgent.State.ACTIVITY) {
            return false;
        }
        int planElementIndex = WithinDayAgentUtils.getCurrentPlanElementIndex(agent);
        List<PlanElement> planElements = WithinDayAgentUtils.getModifiablePlan(agent).getPlanElements();
        List<PlanElement> subList = planElements.subList(planElementIndex, planElements.size());
        for (PlanElement planElement : subList) {
            if (!(planElement instanceof Leg)) continue;
            Leg leg = (Leg)planElement;
            return this.modes.contains(leg.getMode());
        }
        return false;
    }
}

