/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.identifiers.filter;

import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.withinday.replanning.identifiers.interfaces.AgentFilter;

public class ProbabilityFilter
implements AgentFilter {
    private final Random random = MatsimRandom.getLocalInstance();
    private final double replanningProbability;

    ProbabilityFilter(double replanningProbability) {
        this.replanningProbability = replanningProbability;
    }

    @Override
    public void applyAgentFilter(Set<Id<Person>> set, double time) {
        Iterator<Id<Person>> iter = set.iterator();
        while (iter.hasNext()) {
            Id<Person> id = iter.next();
            if (this.applyAgentFilter(id, time)) continue;
            iter.remove();
        }
    }

    @Override
    public boolean applyAgentFilter(Id<Person> id, double time) {
        this.random.setSeed((long)id.hashCode() + (long)time);
        double rand = this.random.nextDouble();
        return !(rand > this.replanningProbability);
    }
}

