/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.identifiers.interfaces;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.withinday.replanning.identifiers.interfaces.AgentFilter;
import org.matsim.withinday.replanning.identifiers.interfaces.AgentSelectorFactory;

public abstract class AgentSelector {
    private AgentSelectorFactory identifierFactory;
    private final Set<AgentFilter> agentFilters = new LinkedHashSet<AgentFilter>();

    public abstract Set<MobsimAgent> getAgentsToReplan(double var1);

    public final void addAgentFilter(AgentFilter agentFilter) {
        this.agentFilters.add(agentFilter);
    }

    public final boolean removeAgentFilter(AgentFilter agentFilter) {
        return this.agentFilters.remove(agentFilter);
    }

    public final Set<AgentFilter> getAgentFilters() {
        return Collections.unmodifiableSet(this.agentFilters);
    }

    public final void applyFilters(Set<Id<Person>> set, double time) {
        for (AgentFilter agentFilter : this.agentFilters) {
            agentFilter.applyAgentFilter(set, time);
        }
    }

    public final boolean applyFilters(Id<Person> id, double time) {
        for (AgentFilter agentFilter : this.agentFilters) {
            if (agentFilter.applyAgentFilter(id, time)) continue;
            return false;
        }
        return true;
    }

    public final void setAgentSelectorFactory(AgentSelectorFactory factory) {
        this.identifierFactory = factory;
    }

    public final AgentSelectorFactory getAgentSelectorFactory() {
        return this.identifierFactory;
    }
}

