/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.identifiers.interfaces;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.matsim.withinday.replanning.identifiers.interfaces.AgentFilterFactory;
import org.matsim.withinday.replanning.identifiers.interfaces.AgentSelector;

public abstract class AgentSelectorFactory {
    private final Set<AgentFilterFactory> agentFilterFactories = new LinkedHashSet<AgentFilterFactory>();

    public abstract AgentSelector createIdentifier();

    protected final void addAgentFiltersToIdentifier(AgentSelector identifier) {
        for (AgentFilterFactory agentFilterFactory : this.agentFilterFactories) {
            identifier.addAgentFilter(agentFilterFactory.createAgentFilter());
        }
    }

    public final void addAgentFilterFactory(AgentFilterFactory agentFilterFactory) {
        this.agentFilterFactories.add(agentFilterFactory);
    }

    public final boolean removeAgentFilterFactory(AgentFilterFactory agentFilterFactory) {
        return this.agentFilterFactories.remove(agentFilterFactory);
    }

    public final Set<AgentFilterFactory> getAgentFilterFactories() {
        return Collections.unmodifiableSet(this.agentFilterFactories);
    }
}

