/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.identifiers.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.ActivityStartEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.handler.ActivityEndEventHandler;
import org.matsim.api.core.v01.events.handler.ActivityStartEventHandler;
import org.matsim.api.core.v01.events.handler.PersonStuckEventHandler;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.MobsimTimer;
import org.matsim.core.mobsim.framework.events.MobsimAfterSimStepEvent;
import org.matsim.core.mobsim.framework.events.MobsimInitializedEvent;
import org.matsim.core.mobsim.framework.listeners.MobsimAfterSimStepListener;
import org.matsim.core.mobsim.framework.listeners.MobsimInitializedListener;
import org.matsim.core.mobsim.qsim.QSim;
import org.matsim.withinday.events.ReplanningEvent;
import org.matsim.withinday.events.handler.ReplanningEventHandler;
import org.matsim.withinday.mobsim.MobsimDataProvider;

public class ActivityReplanningMap
implements PersonStuckEventHandler,
ActivityStartEventHandler,
ActivityEndEventHandler,
ReplanningEventHandler,
MobsimInitializedListener,
MobsimAfterSimStepListener {
    private static final Logger log = Logger.getLogger(ActivityReplanningMap.class);
    private final MobsimDataProvider mobsimDataProvider;
    private final Map<Id<Person>, MobsimAgent> startingAgents;
    private final Map<Id<Person>, Double> activityEndTimes;
    private final Map<Integer, Map<Id<Person>, MobsimAgent>> activityPerformingAgents;
    double simStartTime = Double.NEGATIVE_INFINITY;
    double timeStepSize = Double.NEGATIVE_INFINITY;

    @Inject
    public ActivityReplanningMap(MobsimDataProvider mobsimDataProvider, EventsManager eventsManager) {
        eventsManager.addHandler(this);
        log.info("Note that the ActivityReplanningMap has to be registered as an EventHandler and a SimulationListener!");
        this.mobsimDataProvider = mobsimDataProvider;
        this.startingAgents = new HashMap<Id<Person>, MobsimAgent>();
        this.activityEndTimes = new HashMap<Id<Person>, Double>();
        this.activityPerformingAgents = new ConcurrentHashMap<Integer, Map<Id<Person>, MobsimAgent>>();
    }

    @Override
    public void notifyMobsimInitialized(MobsimInitializedEvent e) {
        MobsimTimer mobsimTimer = ((QSim)e.getQueueSimulation()).getSimTimer();
        this.simStartTime = mobsimTimer.getSimStartTime();
        this.timeStepSize = mobsimTimer.getSimTimestepSize();
        this.activityPerformingAgents.clear();
        for (MobsimAgent mobsimAgent : this.mobsimDataProvider.getAgents().values()) {
            double activityEndTime = mobsimAgent.getActivityEndTime();
            this.activityEndTimes.put(mobsimAgent.getId(), activityEndTime);
            int bin = this.getTimeBin(activityEndTime);
            Map<Id<Person>, MobsimAgent> map = this.getMapForTimeBin(bin);
            map.put(mobsimAgent.getId(), mobsimAgent);
        }
    }

    @Override
    public void notifyMobsimAfterSimStep(MobsimAfterSimStepEvent e) {
        double now = e.getSimulationTime();
        for (MobsimAgent mobsimAgent : this.startingAgents.values()) {
            double departureTime = mobsimAgent.getActivityEndTime();
            if (departureTime >= now) {
                this.activityEndTimes.put(mobsimAgent.getId(), departureTime);
                int bin = this.getTimeBin(mobsimAgent.getActivityEndTime());
                Map<Id<Person>, MobsimAgent> map = this.getMapForTimeBin(bin);
                map.put(mobsimAgent.getId(), mobsimAgent);
                continue;
            }
            log.warn("Departure time is in the past - ignoring activity!");
        }
        this.startingAgents.clear();
        this.activityPerformingAgents.remove(this.getTimeBin(now));
    }

    int getTimeBin(double time) {
        double timeAfterSimStart = time - this.simStartTime;
        if (timeAfterSimStart <= 0.0) {
            return 0;
        }
        int bin = (int)(timeAfterSimStart / this.timeStepSize);
        if (timeAfterSimStart % this.timeStepSize != 0.0) {
            ++bin;
        }
        return bin;
    }

    private Map<Id<Person>, MobsimAgent> getMapForTimeBin(int bin) {
        Map<Id<Person>, MobsimAgent> map = this.activityPerformingAgents.get(bin);
        if (map == null) {
            map = new HashMap<Id<Person>, MobsimAgent>();
            this.activityPerformingAgents.put(bin, map);
        }
        return map;
    }

    @Override
    public void handleEvent(ActivityStartEvent event) {
        Id<Person> agentId = event.getPersonId();
        this.startingAgents.put(agentId, this.mobsimDataProvider.getAgent(agentId));
    }

    @Override
    public void handleEvent(ActivityEndEvent event) {
        Id<Person> agentId = event.getPersonId();
        this.startingAgents.remove(agentId);
        Double activityEndTime = this.activityEndTimes.remove(agentId);
        if (activityEndTime != null) {
            Map<Id<Person>, MobsimAgent> map = this.getMapForTimeBin(this.getTimeBin(activityEndTime));
            map.remove(agentId);
        }
    }

    @Override
    public void handleEvent(PersonStuckEvent event) {
    }

    @Override
    public void handleEvent(ReplanningEvent event) {
        Double activityEndTime = this.activityEndTimes.get(event.getPersonId());
        if (activityEndTime != null) {
            MobsimAgent agent = this.mobsimDataProvider.getAgent(event.getPersonId());
            if (activityEndTime.doubleValue() != agent.getActivityEndTime()) {
                this.activityEndTimes.put(agent.getId(), agent.getActivityEndTime());
                Map<Id<Person>, MobsimAgent> map = this.getMapForTimeBin(this.getTimeBin(activityEndTime));
                map.remove(agent.getId());
                map = this.getMapForTimeBin(this.getTimeBin(agent.getActivityEndTime()));
                map.put(agent.getId(), agent);
            }
        }
    }

    public Set<Id<Person>> getActivityPerformingAgents() {
        return Collections.unmodifiableSet(this.activityEndTimes.keySet());
    }

    public Collection<MobsimAgent> getActivityEndingAgents(double time) {
        return Collections.unmodifiableCollection(this.getMapForTimeBin(this.getTimeBin(time)).values());
    }

    @Override
    public void reset(int iteration) {
        this.startingAgents.clear();
        this.activityEndTimes.clear();
    }
}

