/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.identifiers.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.ActivityStartEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.handler.ActivityEndEventHandler;
import org.matsim.api.core.v01.events.handler.ActivityStartEventHandler;
import org.matsim.api.core.v01.events.handler.PersonStuckEventHandler;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.mobsim.framework.events.MobsimAfterSimStepEvent;
import org.matsim.core.mobsim.framework.listeners.MobsimAfterSimStepListener;
import org.matsim.withinday.trafficmonitoring.EarliestLinkExitTimeProvider;

public class LinkReplanningMap
implements PersonStuckEventHandler,
ActivityStartEventHandler,
ActivityEndEventHandler,
MobsimAfterSimStepListener {
    private static final Logger log = Logger.getLogger(LinkReplanningMap.class);
    private final EarliestLinkExitTimeProvider earliestLinkExitTimeProvider;
    private final Set<Id<Person>> legJustStartedAgents;
    private double currentTime = 0.0;

    @Inject
    public LinkReplanningMap(EarliestLinkExitTimeProvider earliestLinkExitTimeProvider, EventsManager eventsManager) {
        eventsManager.addHandler(this);
        log.info("Note that the LinkReplanningMap has to be registered as an EventHandler and a SimulationListener!");
        this.earliestLinkExitTimeProvider = earliestLinkExitTimeProvider;
        this.legJustStartedAgents = new HashSet<Id<Person>>();
    }

    @Override
    public void handleEvent(PersonStuckEvent event) {
        this.legJustStartedAgents.remove(event.getPersonId());
    }

    @Override
    public void handleEvent(ActivityEndEvent event) {
        this.checkTime(event.getTime());
        this.legJustStartedAgents.add(event.getPersonId());
    }

    @Override
    public void handleEvent(ActivityStartEvent event) {
        this.legJustStartedAgents.remove(event.getPersonId());
    }

    @Override
    public void notifyMobsimAfterSimStep(MobsimAfterSimStepEvent e) {
        this.checkTime(e.getSimulationTime());
    }

    private void checkTime(double time) {
        if (time > this.currentTime) {
            this.currentTime = time;
            this.legJustStartedAgents.clear();
        }
    }

    @Override
    public void reset(int iteration) {
        this.currentTime = 0.0;
        this.legJustStartedAgents.clear();
    }

    public Set<Id<Person>> getReplanningAgents(double time) {
        Set<Id<Person>> set = this.earliestLinkExitTimeProvider.getEarliestLinkExitTimesPerTimeStep(time);
        if (set != null) {
            return Collections.unmodifiableSet(set);
        }
        return new HashSet<Id<Person>>();
    }

    public Set<Id<Person>> getUnrestrictedReplanningAgents(double time) {
        return this.filterAgents(time, TimeFilterMode.UNRESTRICTED);
    }

    public Set<Id<Person>> getRestrictedReplanningAgents(double time) {
        return this.filterAgents(time, TimeFilterMode.RESTRICTED);
    }

    private Set<Id<Person>> filterAgents(double time, TimeFilterMode timeMode) {
        HashSet<Id<Person>> set = new HashSet<Id<Person>>();
        Set<Map.Entry<Double, Set<Id<Person>>>> entries = this.earliestLinkExitTimeProvider.getEarliestLinkExitTimesPerTimeStep().entrySet();
        for (Map.Entry<Double, Set<Id<Person>>> entry : entries) {
            double earliestLinkExitTime = entry.getKey();
            if (timeMode == TimeFilterMode.RESTRICTED) {
                if (time <= earliestLinkExitTime) {
                    continue;
                }
            } else if (timeMode == TimeFilterMode.UNRESTRICTED) {
                if (time > earliestLinkExitTime) {
                    continue;
                }
            } else {
                throw new RuntimeException("Unexpected TimeFilterMode was found: " + timeMode.toString());
            }
            set.addAll((Collection<Id<Person>>)entry.getValue());
        }
        return set;
    }

    public Set<Id<Person>> getLegPerformingAgents() {
        return Collections.unmodifiableSet(this.earliestLinkExitTimeProvider.getEarliestLinkExitTimes().keySet());
    }

    public Set<Id<Person>> getLegStartedAgents() {
        return Collections.unmodifiableSet(this.legJustStartedAgents);
    }

    private static enum TimeFilterMode {
        EXACT,
        RESTRICTED,
        UNRESTRICTED;

    }
}

