/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.parallel;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.withinday.replanning.identifiers.interfaces.AgentSelector;
import org.matsim.withinday.replanning.parallel.ReplanningRunnable;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayReplanner;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayReplannerFactory;
import org.matsim.withinday.replanning.replanners.tools.ReplanningTask;

public abstract class ParallelReplanner<T extends WithinDayReplannerFactory<? extends AgentSelector>> {
    private static final Logger log = Logger.getLogger(ParallelReplanner.class);
    private final boolean shareReplannerQueue = true;
    protected final EventsManager eventsManager;
    protected int numOfThreads;
    protected Set<T> replannerFactories = new LinkedHashSet<T>();
    protected ReplanningRunnable[] replanningRunnables;
    protected String replannerName;
    protected int roundRobin = 0;
    private int lastRoundRobin = 0;
    protected AtomicBoolean hadException;
    protected ExceptionHandler uncaughtExceptionHandler;
    protected CyclicBarrier timeStepStartBarrier;
    protected CyclicBarrier betweenReplannerBarrier;
    protected CyclicBarrier timeStepEndBarrier;
    protected boolean simIsRunning = false;

    public ParallelReplanner(int numOfThreads, EventsManager eventsManager) {
        this.setNumberOfThreads(numOfThreads);
        this.eventsManager = eventsManager;
    }

    public final void init(String replannerName) {
        this.replannerName = replannerName;
        this.replanningRunnables = new InternalReplanningRunnable[this.numOfThreads];
        this.timeStepStartBarrier = new CyclicBarrier(this.numOfThreads + 1);
        this.betweenReplannerBarrier = new CyclicBarrier(this.numOfThreads);
        this.timeStepEndBarrier = new CyclicBarrier(this.numOfThreads + 1);
        for (int i = 0; i < this.numOfThreads; ++i) {
            InternalReplanningRunnable replanningRunnable = new InternalReplanningRunnable(replannerName + " Thread" + i + " replanned plans: ");
            replanningRunnable.setCyclicTimeStepStartBarrier(this.timeStepStartBarrier);
            replanningRunnable.setBetweenReplannerBarrier(this.betweenReplannerBarrier);
            replanningRunnable.setCyclicTimeStepEndBarrier(this.timeStepEndBarrier);
            replanningRunnable.setEventsManager(this.eventsManager);
            this.replanningRunnables[i] = replanningRunnable;
        }
    }

    public final void onPrepareSim() {
        Thread replanningThread;
        int i;
        for (WithinDayReplannerFactory factory : this.replannerFactories) {
            LinkedBlockingQueue<ReplanningTask> queue = new LinkedBlockingQueue<ReplanningTask>();
            for (ReplanningRunnable replanningRunnable : this.replanningRunnables) {
                WithinDayReplanner<AgentSelector> newInstance = factory.createReplanner();
                replanningRunnable.addWithinDayReplanner(newInstance, queue);
            }
        }
        this.hadException = new AtomicBoolean(false);
        this.uncaughtExceptionHandler = new ExceptionHandler(this.hadException, this.timeStepStartBarrier, this.betweenReplannerBarrier, this.timeStepEndBarrier);
        Thread[] replanningThreads = new Thread[this.numOfThreads];
        for (i = 0; i < this.numOfThreads; ++i) {
            replanningThread = new Thread(this.replanningRunnables[i]);
            Thread.setDefaultUncaughtExceptionHandler(this.uncaughtExceptionHandler);
            replanningThread.setName(this.replannerName + i);
            replanningThreads[i] = replanningThread;
        }
        for (i = 0; i < this.numOfThreads; ++i) {
            this.replanningRunnables[i].beforeSim();
            replanningThread = replanningThreads[i];
            replanningThread.setDaemon(true);
            replanningThread.start();
        }
        this.simIsRunning = true;
        try {
            this.timeStepEndBarrier.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (BrokenBarrierException e) {
            throw new RuntimeException(e);
        }
    }

    public final void run(double time) {
        if (this.lastRoundRobin == this.roundRobin) {
            return;
        }
        this.lastRoundRobin = this.roundRobin;
        if (this.hadException.get()) {
            return;
        }
        try {
            for (ReplanningRunnable replanningRunnable : this.replanningRunnables) {
                replanningRunnable.setTime(time);
            }
            this.timeStepStartBarrier.await();
            this.timeStepEndBarrier.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (BrokenBarrierException e) {
            throw new RuntimeException(e);
        }
    }

    public final void afterSim() {
        this.simIsRunning = false;
        if (this.hadException.get()) {
            throw new RuntimeException("Exception while replanning. Cannot guarantee that all replanning operations have been fully processed.");
        }
        this.roundRobin = 0;
        this.lastRoundRobin = 0;
        for (ReplanningRunnable runnable : this.replanningRunnables) {
            runnable.afterSim();
            for (WithinDayReplannerFactory factory : this.replannerFactories) {
                runnable.removeWithinDayReplanner(factory.getId());
            }
        }
        try {
            this.timeStepStartBarrier.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (BrokenBarrierException e) {
            throw new RuntimeException(e);
        }
    }

    public final void addWithinDayReplannerFactory(T factory) {
        this.replannerFactories.add(factory);
        if (this.simIsRunning) {
            LinkedBlockingQueue<ReplanningTask> queue = new LinkedBlockingQueue<ReplanningTask>();
            for (ReplanningRunnable replanningRunnable : this.replanningRunnables) {
                WithinDayReplanner<AgentSelector> newInstance = ((WithinDayReplannerFactory)factory).createReplanner();
                replanningRunnable.addWithinDayReplanner(newInstance, queue);
            }
        }
    }

    public final void removeWithinDayReplannerFactory(T factory) {
        this.replannerFactories.remove(factory);
        for (ReplanningRunnable replanningRunnable : this.replanningRunnables) {
            replanningRunnable.removeWithinDayReplanner(((WithinDayReplannerFactory)factory).getId());
        }
    }

    public final void resetReplanners() {
        for (ReplanningRunnable replanningRunnable : this.replanningRunnables) {
            replanningRunnable.resetReplanners();
        }
    }

    public final Set<T> getWithinDayReplannerFactories() {
        return Collections.unmodifiableSet(this.replannerFactories);
    }

    public final void addReplanningTask(ReplanningTask replanningTask) {
        this.replanningRunnables[this.roundRobin % this.numOfThreads].addReplanningTask(replanningTask);
        ++this.roundRobin;
    }

    private final void setNumberOfThreads(int numberOfThreads) {
        this.numOfThreads = Math.max(numberOfThreads, 1);
        log.info("Using " + this.numOfThreads + " threads for parallel within-day replanning.");
        if (this.numOfThreads > Runtime.getRuntime().availableProcessors()) {
            log.warn("The number of parallel running replanning threads is bigger than the number of available CPUs/Cores!");
        }
    }

    private static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final AtomicBoolean hadException;
        private final CyclicBarrier timeStepStartBarrier;
        private final CyclicBarrier betweenReplannerBarrier;
        private final CyclicBarrier timeStepEndBarrier;

        public ExceptionHandler(AtomicBoolean hadException, CyclicBarrier timeStepStartBarrier, CyclicBarrier betweenReplannerBarrier, CyclicBarrier timeStepEndBarrier) {
            this.hadException = hadException;
            this.timeStepStartBarrier = timeStepStartBarrier;
            this.betweenReplannerBarrier = betweenReplannerBarrier;
            this.timeStepEndBarrier = timeStepEndBarrier;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.hadException.set(true);
            log.error("Thread " + t.getName() + " died with exception while replanning.", e);
            this.timeStepStartBarrier.reset();
            this.betweenReplannerBarrier.reset();
            this.timeStepEndBarrier.reset();
        }
    }

    static final class InternalReplanningRunnable
    extends ReplanningRunnable {
        public InternalReplanningRunnable(String counterText) {
            super(counterText);
        }
    }
}

