/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.parallel;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.utils.misc.Counter;
import org.matsim.core.utils.misc.Time;
import org.matsim.withinday.events.ReplanningEvent;
import org.matsim.withinday.replanning.identifiers.interfaces.AgentSelector;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayReplanner;
import org.matsim.withinday.replanning.replanners.tools.ReplanningTask;

public abstract class ReplanningRunnable
implements Runnable {
    private static final Logger log = Logger.getLogger(ReplanningRunnable.class);
    private Counter counter;
    private double time = 0.0;
    private volatile boolean simulationRunning = false;
    protected Map<Id<WithinDayReplanner>, WithinDayReplanner<? extends AgentSelector>> withinDayReplanners = new HashMap<Id<WithinDayReplanner>, WithinDayReplanner<? extends AgentSelector>>();
    protected Map<Id<WithinDayReplanner>, Queue<ReplanningTask>> replanningTasks = new TreeMap<Id<WithinDayReplanner>, Queue<ReplanningTask>>();
    protected EventsManager eventsManager;
    protected CyclicBarrier timeStepStartBarrier;
    protected CyclicBarrier betweenReplannerBarrier;
    protected CyclicBarrier timeStepEndBarrier;

    public ReplanningRunnable(String counterText) {
        this.counter = new Counter(counterText);
    }

    public final void setEventsManager(EventsManager eventsManager) {
        this.eventsManager = eventsManager;
    }

    public final void setTime(double time) {
        this.time = time;
    }

    public final void setCyclicTimeStepStartBarrier(CyclicBarrier barrier) {
        this.timeStepStartBarrier = barrier;
    }

    public final void setBetweenReplannerBarrier(CyclicBarrier barrier) {
        this.betweenReplannerBarrier = barrier;
    }

    public final void setCyclicTimeStepEndBarrier(CyclicBarrier barrier) {
        this.timeStepEndBarrier = barrier;
    }

    public final void addReplanningTask(ReplanningTask replanningTask) {
        Queue<ReplanningTask> queue = this.replanningTasks.get(replanningTask.getWithinDayReplannerId());
        queue.add(replanningTask);
    }

    public final void addWithinDayReplanner(WithinDayReplanner<? extends AgentSelector> withinDayReplanner, Queue<ReplanningTask> queue) {
        this.withinDayReplanners.put(withinDayReplanner.getId(), withinDayReplanner);
        this.replanningTasks.put(withinDayReplanner.getId(), queue);
    }

    public final void removeWithinDayReplanner(Id<WithinDayReplanner> replannerId) {
        this.withinDayReplanners.remove(replannerId);
        this.replanningTasks.remove(replannerId);
    }

    public final void resetReplanners() {
        this.counter.reset();
        for (WithinDayReplanner<? extends AgentSelector> withinDayReplanner : this.withinDayReplanners.values()) {
            withinDayReplanner.reset();
        }
    }

    public final void beforeSim() {
        this.simulationRunning = true;
    }

    public final void afterSim() {
        this.simulationRunning = false;
    }

    private void doReplanning() throws InterruptedException, BrokenBarrierException {
        for (Map.Entry<Id<WithinDayReplanner>, Queue<ReplanningTask>> entry : this.replanningTasks.entrySet()) {
            ReplanningTask replanningTask;
            Id<WithinDayReplanner> withinDayReplannerId = entry.getKey();
            Queue<ReplanningTask> queue = entry.getValue();
            WithinDayReplanner<? extends AgentSelector> withinDayReplanner = this.withinDayReplanners.get(withinDayReplannerId);
            if (withinDayReplannerId == null) {
                log.error("WithinDayReplanner Id is null!");
                continue;
            }
            if (withinDayReplanner == null) {
                log.error("WithinDayReplanner is null!");
                continue;
            }
            withinDayReplanner.setTime(this.time);
            while ((replanningTask = queue.poll()) != null) {
                MobsimAgent withinDayAgent = replanningTask.getAgentToReplan();
                if (withinDayAgent == null) {
                    log.error("WithinDayAgent is null!");
                    continue;
                }
                boolean replanningSuccessful = withinDayReplanner.doReplanning(withinDayAgent);
                if (!replanningSuccessful) {
                    log.error("Replanning was not successful! Replanner " + withinDayReplanner.getClass().toString() + ", time " + Time.writeTime(this.time) + ", agent " + withinDayAgent.getId());
                    continue;
                }
                if (this.eventsManager != null) {
                    ReplanningEvent replanningEvent = new ReplanningEvent(this.time, withinDayAgent.getId(), withinDayReplanner.getClass().getSimpleName());
                    this.eventsManager.processEvent(replanningEvent);
                }
                this.counter.incCounter();
            }
            this.betweenReplannerBarrier.await();
        }
    }

    @Override
    public final void run() {
        while (this.simulationRunning) {
            try {
                this.timeStepEndBarrier.await();
                this.timeStepStartBarrier.await();
                if (!this.simulationRunning) {
                    Gbl.printCurrentThreadCpuTime();
                    return;
                }
                this.doReplanning();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

