/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.replanners;

import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.ActivityEndRescheduler;
import org.matsim.core.mobsim.qsim.agents.WithinDayAgentUtils;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayDuringLegReplanner;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayReplanner;
import org.matsim.withinday.utils.EditRoutes;

public class CurrentLegReplanner
extends WithinDayDuringLegReplanner {
    private final LeastCostPathCalculator pathCalculator;
    private final PopulationFactory populationFactory;

    CurrentLegReplanner(Id<WithinDayReplanner> id, Scenario scenario, ActivityEndRescheduler internalInterface, LeastCostPathCalculator pathCalculator) {
        super(id, scenario, internalInterface);
        this.pathCalculator = pathCalculator;
        this.populationFactory = scenario.getPopulation().getFactory();
    }

    @Override
    public boolean doReplanning(MobsimAgent withinDayAgent) {
        Plan executedPlan = WithinDayAgentUtils.getModifiablePlan(withinDayAgent);
        if (executedPlan == null) {
            return false;
        }
        PlanElement currentPlanElement = WithinDayAgentUtils.getCurrentPlanElement(withinDayAgent);
        if (!(currentPlanElement instanceof Leg)) {
            return false;
        }
        Leg currentLeg = (Leg)currentPlanElement;
        int currentLinkIndex = WithinDayAgentUtils.getCurrentRouteLinkIdIndex(withinDayAgent);
        EditRoutes editRoutes = new EditRoutes(this.scenario.getNetwork(), this.pathCalculator, this.populationFactory);
        editRoutes.replanCurrentLegRoute(currentLeg, executedPlan.getPerson(), currentLinkIndex, this.time);
        WithinDayAgentUtils.resetCaches(withinDayAgent);
        return true;
    }
}

