/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.replanners;

import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.ActivityEndRescheduler;
import org.matsim.core.mobsim.qsim.QSim;
import org.matsim.core.mobsim.qsim.agents.WithinDayAgentUtils;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.TripStructureUtils;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayDuringActivityReplanner;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayReplanner;
import org.matsim.withinday.utils.EditTrips;

public class NextLegReplanner
extends WithinDayDuringActivityReplanner {
    private final TripRouter tripRouter;
    private final QSim qsim;

    NextLegReplanner(Id<WithinDayReplanner> id, Scenario scenario, ActivityEndRescheduler internalInterface, TripRouter tripRouter, QSim qsim) {
        super(id, scenario, internalInterface);
        this.tripRouter = tripRouter;
        this.qsim = qsim;
    }

    @Override
    public boolean doReplanning(MobsimAgent withinDayAgent) {
        Plan executedPlan = WithinDayAgentUtils.getModifiablePlan(withinDayAgent);
        if (executedPlan == null) {
            return false;
        }
        Activity currentActivity = (Activity)WithinDayAgentUtils.getCurrentPlanElement(withinDayAgent);
        TripStructureUtils.Trip trip = TripStructureUtils.findTripStartingAtActivity(currentActivity, executedPlan, this.tripRouter.getStageActivityTypes());
        if (trip == null) {
            return false;
        }
        String mainMode = this.tripRouter.getMainModeIdentifier().identifyMainMode(trip.getTripElements());
        double departureTime = TripStructureUtils.getDepartureTime(trip);
        new EditTrips(this.tripRouter, this.scenario, null).replanFutureTrip(trip, executedPlan, mainMode, departureTime);
        return true;
    }
}

