/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.replanning.replanners.interfaces;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.core.mobsim.qsim.ActivityEndReschedulerProvider;
import org.matsim.withinday.replanning.identifiers.interfaces.AgentSelector;
import org.matsim.withinday.replanning.replanners.interfaces.WithinDayReplanner;
import org.matsim.withinday.replanning.replanners.tools.ReplanningIdGenerator;

public abstract class WithinDayReplannerFactory<T extends AgentSelector> {
    private final ActivityEndReschedulerProvider withinDayEngine;
    private Id<WithinDayReplanner> id;
    private Set<T> identifiers = new HashSet<T>();

    public WithinDayReplannerFactory(ActivityEndReschedulerProvider withinDayEngine) {
        this.withinDayEngine = withinDayEngine;
        this.id = ReplanningIdGenerator.getNextId();
    }

    public abstract WithinDayReplanner<? extends AgentSelector> createReplanner();

    public final ActivityEndReschedulerProvider getWithinDayEngine() {
        return this.withinDayEngine;
    }

    public final Id<WithinDayReplanner> getId() {
        return this.id;
    }

    public final boolean addIdentifier(T identifier) {
        return this.identifiers.add(identifier);
    }

    public final boolean removeIdentifier(T identifier) {
        return this.identifiers.remove(identifier);
    }

    public final Set<T> getIdentifers() {
        return Collections.unmodifiableSet(this.identifiers);
    }
}

