/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.trafficmonitoring;

import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.router.priorityqueue.HasIndex;
import org.matsim.withinday.trafficmonitoring.MapBasedTravelTimeInfoProvider;
import org.matsim.withinday.trafficmonitoring.TravelTimeInfoProvider;
import org.matsim.withinday.trafficmonitoring.WithinDayTravelTime;

public class ArrayBasedTravelTimeInfoProvider
implements TravelTimeInfoProvider {
    private final WithinDayTravelTime.TravelTimeInfo[] arrayLinkData;
    private final TravelTimeInfoProvider delegate;

    public ArrayBasedTravelTimeInfoProvider(Map<Id<Link>, WithinDayTravelTime.TravelTimeInfo> linkData, Network network) {
        this.delegate = new MapBasedTravelTimeInfoProvider(linkData);
        this.arrayLinkData = new WithinDayTravelTime.TravelTimeInfo[linkData.size()];
    }

    @Override
    public WithinDayTravelTime.TravelTimeInfo getTravelTimeInfo(Id<Link> linkId) {
        return this.delegate.getTravelTimeInfo(linkId);
    }

    @Override
    public WithinDayTravelTime.TravelTimeInfo getTravelTimeInfo(Link link) {
        if (link instanceof HasIndex) {
            int index = ((HasIndex)((Object)link)).getArrayIndex();
            WithinDayTravelTime.TravelTimeInfo data = this.arrayLinkData[index];
            if (data == null) {
                this.arrayLinkData[index] = data = this.delegate.getTravelTimeInfo(link);
            }
            return data;
        }
        return this.delegate.getTravelTimeInfo(link);
    }
}

