/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.trafficmonitoring;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.events.handler.LinkEnterEventHandler;
import org.matsim.api.core.v01.events.handler.LinkLeaveEventHandler;
import org.matsim.api.core.v01.events.handler.PersonArrivalEventHandler;
import org.matsim.api.core.v01.events.handler.PersonDepartureEventHandler;
import org.matsim.api.core.v01.events.handler.PersonStuckEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleEntersTrafficEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleLeavesTrafficEventHandler;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.events.algorithms.Vehicle2DriverEventHandler;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.trafficmonitoring.FreeSpeedTravelTime;
import org.matsim.withinday.trafficmonitoring.TransportModeProvider;

public class EarliestLinkExitTimeProvider
implements LinkEnterEventHandler,
LinkLeaveEventHandler,
PersonArrivalEventHandler,
PersonDepartureEventHandler,
PersonStuckEventHandler,
VehicleEntersTrafficEventHandler,
VehicleLeavesTrafficEventHandler {
    private static final Logger log = Logger.getLogger(EarliestLinkExitTimeProvider.class);
    private final TransportModeProvider transportModeProvider;
    private final Scenario scenario;
    private final Map<String, TravelTime> multiModalTravelTimes;
    private final TravelTime freeSpeedTravelTime;
    private final Map<Id<Person>, Double> earliestLinkExitTimes = new ConcurrentHashMap<Id<Person>, Double>();
    private final Map<Double, Set<Id<Person>>> earliestLinkExitTimesPerTimeStep = new ConcurrentHashMap<Double, Set<Id<Person>>>();
    private Vehicle2DriverEventHandler delegate = new Vehicle2DriverEventHandler();

    public EarliestLinkExitTimeProvider(Scenario scenario, EventsManager eventsManager) {
        this(scenario, null, eventsManager);
        log.info("Note: no map containing TravelTime objects for all simulated modes is given. Therefore use free speed car travel time as minimal link travel time for all modes.");
    }

    @Inject
    public EarliestLinkExitTimeProvider(Scenario scenario, @Named(value="lowerBound") Map<String, TravelTime> multiModalTravelTimes, EventsManager eventsManager) {
        this.scenario = scenario;
        eventsManager.addHandler(this);
        this.multiModalTravelTimes = multiModalTravelTimes;
        this.transportModeProvider = new TransportModeProvider();
        this.freeSpeedTravelTime = new FreeSpeedTravelTime();
    }

    public TransportModeProvider getTransportModeProvider() {
        return this.transportModeProvider;
    }

    public double getEarliestLinkExitTime(Id<Person> agentId) {
        Double earliestExitTime = this.earliestLinkExitTimes.get(agentId);
        if (earliestExitTime == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return earliestExitTime;
    }

    public Map<Id<Person>, Double> getEarliestLinkExitTimes() {
        return Collections.unmodifiableMap(this.earliestLinkExitTimes);
    }

    public Set<Id<Person>> getEarliestLinkExitTimesPerTimeStep(double time) {
        Set<Id<Person>> set = this.earliestLinkExitTimesPerTimeStep.get(time);
        if (set != null) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    public Map<Double, Set<Id<Person>>> getEarliestLinkExitTimesPerTimeStep() {
        return Collections.unmodifiableMap(this.earliestLinkExitTimesPerTimeStep);
    }

    @Override
    public void reset(int iteration) {
        this.transportModeProvider.reset(iteration);
        this.earliestLinkExitTimes.clear();
        this.earliestLinkExitTimesPerTimeStep.clear();
    }

    @Override
    public void handleEvent(PersonArrivalEvent event) {
        this.transportModeProvider.handleEvent(event);
        this.removeEarliestLinkExitTimesAtTime(event.getPersonId());
    }

    @Override
    public void handleEvent(LinkEnterEvent event) {
        double earliestExitTime;
        Id<Person> driverId = this.delegate.getDriverOfVehicle(event.getVehicleId());
        String transportMode = this.transportModeProvider.getTransportMode(driverId);
        double now = event.getTime();
        Link link = this.scenario.getNetwork().getLinks().get(event.getLinkId());
        Person person = this.scenario.getPopulation().getPersons().get(driverId);
        if (this.multiModalTravelTimes != null) {
            if (transportMode == null) {
                throw new RuntimeException("Agent " + driverId.toString() + " is currently not performing a leg. Aborting!");
            }
            TravelTime travelTime = this.multiModalTravelTimes.get(transportMode);
            if (travelTime == null) {
                throw new RuntimeException("No TravelTime object was found for mode " + transportMode + ". Aborting!");
            }
            earliestExitTime = Math.floor(now + travelTime.getLinkTravelTime(link, now, person, null));
        } else {
            earliestExitTime = Math.floor(now + this.freeSpeedTravelTime.getLinkTravelTime(link, now, person, null));
        }
        this.handleAddEarliestLinkExitTime(driverId, earliestExitTime);
    }

    @Override
    public void handleEvent(LinkLeaveEvent event) {
        this.removeEarliestLinkExitTimesAtTime(this.delegate.getDriverOfVehicle(event.getVehicleId()));
    }

    @Override
    public void handleEvent(PersonDepartureEvent event) {
        this.transportModeProvider.handleEvent(event);
        this.handleAddEarliestLinkExitTime(event.getPersonId(), event.getTime());
    }

    @Override
    public void handleEvent(PersonStuckEvent event) {
        this.transportModeProvider.handleEvent(event);
        this.removeEarliestLinkExitTimesAtTime(event.getPersonId());
    }

    private void handleAddEarliestLinkExitTime(Id<Person> agentId, double earliestExitTime) {
        this.earliestLinkExitTimes.put(agentId, earliestExitTime);
        Set<Id<Person>> earliestLinkExitTimesAtTime = this.earliestLinkExitTimesPerTimeStep.get(earliestExitTime);
        if (earliestLinkExitTimesAtTime == null) {
            earliestLinkExitTimesAtTime = new HashSet<Id<Person>>();
            this.earliestLinkExitTimesPerTimeStep.put(earliestExitTime, earliestLinkExitTimesAtTime);
        }
        earliestLinkExitTimesAtTime.add(agentId);
    }

    private void removeEarliestLinkExitTimesAtTime(Id<Person> agentId) {
        Set<Id<Person>> earliestLinkExitTimesAtTime;
        Double earliestExitTime = this.earliestLinkExitTimes.remove(agentId);
        if (earliestExitTime != null && (earliestLinkExitTimesAtTime = this.earliestLinkExitTimesPerTimeStep.get(earliestExitTime)) != null) {
            earliestLinkExitTimesAtTime.remove(agentId);
            if (earliestLinkExitTimesAtTime.isEmpty()) {
                this.earliestLinkExitTimesPerTimeStep.remove(earliestExitTime);
            }
        }
    }

    @Override
    public void handleEvent(VehicleLeavesTrafficEvent event) {
        this.delegate.handleEvent(event);
    }

    @Override
    public void handleEvent(VehicleEntersTrafficEvent event) {
        this.delegate.handleEvent(event);
    }
}

