/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.trafficmonitoring;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.events.handler.LinkEnterEventHandler;
import org.matsim.api.core.v01.events.handler.PersonArrivalEventHandler;
import org.matsim.api.core.v01.events.handler.PersonStuckEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleEntersTrafficEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleLeavesTrafficEventHandler;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.events.algorithms.Vehicle2DriverEventHandler;
import org.matsim.core.mobsim.framework.events.MobsimAfterSimStepEvent;
import org.matsim.core.mobsim.framework.listeners.MobsimAfterSimStepListener;

public class LinkEnteredProvider
implements LinkEnterEventHandler,
PersonArrivalEventHandler,
PersonStuckEventHandler,
MobsimAfterSimStepListener,
VehicleEntersTrafficEventHandler,
VehicleLeavesTrafficEventHandler {
    private Map<Id<Person>, Id<Link>> linkEnteredAgents = new ConcurrentHashMap<Id<Person>, Id<Link>>();
    private Map<Id<Person>, Id<Link>> lastTimeStepLinkEnteredAgents = new ConcurrentHashMap<Id<Person>, Id<Link>>();
    private Vehicle2DriverEventHandler delegate = new Vehicle2DriverEventHandler();

    public Map<Id<Person>, Id<Link>> getLinkEnteredAgentsInLastTimeStep() {
        return Collections.unmodifiableMap(this.lastTimeStepLinkEnteredAgents);
    }

    @Override
    public void reset(int iteration) {
        this.linkEnteredAgents.clear();
        this.lastTimeStepLinkEnteredAgents.clear();
        this.delegate.reset(iteration);
    }

    @Override
    public void handleEvent(PersonStuckEvent event) {
        this.linkEnteredAgents.remove(event.getPersonId());
    }

    @Override
    public void handleEvent(PersonArrivalEvent event) {
        this.linkEnteredAgents.remove(event.getPersonId());
    }

    @Override
    public void handleEvent(LinkEnterEvent event) {
        this.linkEnteredAgents.put(this.delegate.getDriverOfVehicle(event.getVehicleId()), event.getLinkId());
    }

    @Override
    public void notifyMobsimAfterSimStep(MobsimAfterSimStepEvent e) {
        this.lastTimeStepLinkEnteredAgents = this.linkEnteredAgents;
        this.linkEnteredAgents = new ConcurrentHashMap<Id<Person>, Id<Link>>();
    }

    @Override
    public void handleEvent(VehicleLeavesTrafficEvent event) {
        this.delegate.handleEvent(event);
    }

    @Override
    public void handleEvent(VehicleEntersTrafficEvent event) {
        this.delegate.handleEvent(event);
    }
}

