/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.trafficmonitoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.events.handler.LinkEnterEventHandler;
import org.matsim.api.core.v01.events.handler.LinkLeaveEventHandler;
import org.matsim.api.core.v01.events.handler.PersonStuckEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleEntersTrafficEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleLeavesTrafficEventHandler;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.events.MobsimAfterSimStepEvent;
import org.matsim.core.mobsim.framework.events.MobsimBeforeCleanupEvent;
import org.matsim.core.mobsim.framework.events.MobsimBeforeSimStepEvent;
import org.matsim.core.mobsim.framework.events.MobsimInitializedEvent;
import org.matsim.core.mobsim.framework.listeners.MobsimAfterSimStepListener;
import org.matsim.core.mobsim.framework.listeners.MobsimBeforeCleanupListener;
import org.matsim.core.mobsim.framework.listeners.MobsimBeforeSimStepListener;
import org.matsim.core.mobsim.framework.listeners.MobsimInitializedListener;
import org.matsim.core.mobsim.qsim.QSim;
import org.matsim.core.network.NetworkChangeEvent;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.utils.misc.Counter;
import org.matsim.core.utils.misc.Time;
import org.matsim.vehicles.Vehicle;
import org.matsim.withinday.trafficmonitoring.ArrayBasedTravelTimeInfoProvider;
import org.matsim.withinday.trafficmonitoring.TravelTimeInfoProvider;

@Singleton
public class WithinDayTravelTime
implements TravelTime,
LinkEnterEventHandler,
LinkLeaveEventHandler,
PersonStuckEventHandler,
VehicleLeavesTrafficEventHandler,
VehicleEntersTrafficEventHandler,
MobsimInitializedListener,
MobsimBeforeSimStepListener,
MobsimAfterSimStepListener,
MobsimBeforeCleanupListener {
    private static final Logger log = Logger.getLogger(WithinDayTravelTime.class);
    private Network network;
    private Map<Id<Vehicle>, TripBin> regularActiveTrips;
    private Map<Id<Link>, TravelTimeInfo> travelTimeInfos;
    private TravelTimeInfoProvider travelTimeInfoProvider;
    private TreeMap<Double, Map<Link, Double>> changedLinksByTime;
    private CyclicBarrier startBarrier;
    private CyclicBarrier endBarrier;
    private UpdateMeanTravelTimesRunnable[] updateMeanTravelTimesRunnables;
    private final int numOfThreads;
    private final int infoTimeStep = 3600;
    private int nextInfoTime = 0;
    private Set<Id<Vehicle>> vehiclesToFilter;
    private final Set<String> analyzedModes;
    private final boolean filterModes;
    private boolean problem = true;
    private int resetCnt = 0;
    private double now = Double.NEGATIVE_INFINITY;

    @Inject
    WithinDayTravelTime(Scenario scenario) {
        this(scenario, null);
    }

    public WithinDayTravelTime(Scenario scenario, Set<String> analyzedModes) {
        this.network = scenario.getNetwork();
        this.numOfThreads = scenario.getConfig().global().getNumberOfThreads();
        if (analyzedModes == null || analyzedModes.size() == 0) {
            this.filterModes = false;
            this.analyzedModes = null;
        } else {
            this.analyzedModes = new HashSet<String>(analyzedModes);
            this.filterModes = true;
        }
        this.init();
    }

    private void init() {
        this.regularActiveTrips = new HashMap<Id<Vehicle>, TripBin>();
        this.travelTimeInfos = new ConcurrentHashMap<Id<Link>, TravelTimeInfo>();
        this.changedLinksByTime = new TreeMap();
        this.vehiclesToFilter = new HashSet<Id<Vehicle>>();
        for (Link link : this.network.getLinks().values()) {
            TravelTimeInfo travelTimeInfo = new TravelTimeInfo();
            this.travelTimeInfos.put(link.getId(), travelTimeInfo);
        }
        this.travelTimeInfoProvider = new ArrayBasedTravelTimeInfoProvider(this.travelTimeInfos, this.network);
        Queue<NetworkChangeEvent> networkChangeEvents = NetworkUtils.getNetworkChangeEvents(this.network);
        if (networkChangeEvents != null) {
            for (NetworkChangeEvent networkChangeEvent : networkChangeEvents) {
                this.addNetworkChangeEventToLocalDataStructure(networkChangeEvent);
            }
        }
    }

    private void addNetworkChangeEventToLocalDataStructure(NetworkChangeEvent networkChangeEvent) {
        NetworkChangeEvent.ChangeValue freespeedChange = networkChangeEvent.getFreespeedChange();
        if (freespeedChange != null) {
            double startTime = networkChangeEvent.getStartTime();
            Map newLinkSpeedsAtThisTime = this.changedLinksByTime.computeIfAbsent(startTime, k -> new HashMap());
            for (Link link : networkChangeEvent.getLinks()) {
                double newSpeed;
                switch (freespeedChange.getType()) {
                    case ABSOLUTE_IN_SI_UNITS: {
                        newSpeed = freespeedChange.getValue();
                        break;
                    }
                    case FACTOR: {
                        newSpeed = link.getFreespeed() * freespeedChange.getValue();
                        break;
                    }
                    case OFFSET_IN_SI_UNITS: {
                        newSpeed = link.getFreespeed() + freespeedChange.getValue();
                        break;
                    }
                    default: {
                        throw new RuntimeException("change event type not implemented");
                    }
                }
                if (startTime > 0.0) {
                    log.debug("registering a change event for time=" + startTime + "; linkId=" + link.getId());
                }
                newLinkSpeedsAtThisTime.put(link, newSpeed);
            }
        }
    }

    public final void addNetworkChangeEvent(NetworkChangeEvent networkChangeEvent) {
        this.addNetworkChangeEventToLocalDataStructure(networkChangeEvent);
    }

    @Override
    public double getLinkTravelTime(Link link, double time, Person person, Vehicle vehicle) {
        double travelTime = this.travelTimeInfoProvider.getTravelTimeInfo((Link)link).travelTime;
        return travelTime;
    }

    @Override
    public void reset(int iteration) {
        this.init();
        ++this.resetCnt;
        if (this.resetCnt > 1 && this.problem) {
            throw new RuntimeException("using WithinDayTravelTime, but mobsim notifications not called between two resets.  Did you really add this as a mobsim listener?");
        }
    }

    @Override
    public void handleEvent(LinkEnterEvent event) {
        if (this.filterModes && this.vehiclesToFilter.contains(event.getVehicleId())) {
            return;
        }
        Id<Vehicle> vehicleId = event.getVehicleId();
        double time = event.getTime();
        TripBin tripBin = new TripBin();
        tripBin.enterTime = time;
        this.regularActiveTrips.put(vehicleId, tripBin);
    }

    @Override
    public void handleEvent(LinkLeaveEvent event) {
        Id<Link> linkId = event.getLinkId();
        Id<Vehicle> vehicleId = event.getVehicleId();
        double time = event.getTime();
        TripBin tripBin = this.regularActiveTrips.remove(vehicleId);
        if (tripBin != null) {
            tripBin.leaveTime = time;
            double tripTime = tripBin.leaveTime - tripBin.enterTime;
            TravelTimeInfo travelTimeInfo = this.travelTimeInfoProvider.getTravelTimeInfo(linkId);
            travelTimeInfo.tripBins.add(tripBin);
            travelTimeInfo.addedTravelTimes += tripTime;
            ++travelTimeInfo.addedTrips;
            travelTimeInfo.checkActiveState();
            travelTimeInfo.checkBinSize(tripTime);
        }
    }

    @Override
    public void handleEvent(PersonStuckEvent event) {
    }

    @Override
    public void handleEvent(VehicleLeavesTrafficEvent event) {
        Id<Vehicle> vehicleId = event.getVehicleId();
        this.regularActiveTrips.remove(vehicleId);
        if (this.filterModes) {
            this.vehiclesToFilter.remove(event.getVehicleId());
        }
    }

    @Override
    public void handleEvent(VehicleEntersTrafficEvent event) {
        if (this.filterModes && !this.analyzedModes.contains(event.getNetworkMode())) {
            this.vehiclesToFilter.add(event.getVehicleId());
        }
    }

    @Override
    public void notifyMobsimInitialized(MobsimInitializedEvent e) {
        this.problem = false;
        if (e.getQueueSimulation() instanceof QSim) {
            double simStartTime = ((QSim)e.getQueueSimulation()).getSimTimer().getSimStartTime();
            this.nextInfoTime = (int)(Math.floor(simStartTime / (double)this.infoTimeStep) * (double)this.infoTimeStep);
        }
        for (Link link : this.network.getLinks().values()) {
            double freeSpeedTravelTime = link.getLength() / link.getFreespeed(Double.NEGATIVE_INFINITY);
            TravelTimeInfo travelTimeInfo = this.travelTimeInfoProvider.getTravelTimeInfo(link);
            travelTimeInfo.travelTime = freeSpeedTravelTime;
            travelTimeInfo.init(freeSpeedTravelTime);
        }
        this.initParallelThreads();
    }

    @Override
    public void notifyMobsimAfterSimStep(MobsimAfterSimStepEvent e) {
        this.problem = false;
        while (!this.changedLinksByTime.isEmpty() && this.changedLinksByTime.firstKey() <= e.getSimulationTime()) {
            Map<Link, Double> map = this.changedLinksByTime.pollFirstEntry().getValue();
            for (Map.Entry<Link, Double> link2speed : map.entrySet()) {
                Link link = link2speed.getKey();
                double freeSpeedTravelTime = link.getLength() / link2speed.getValue();
                if (e.getSimulationTime() > ((QSim)e.getQueueSimulation()).getSimTimer().getSimStartTime()) {
                    log.debug("time=" + e.getSimulationTime() + "; network change event for link=" + link.getId() + "; new ttime=" + freeSpeedTravelTime);
                }
                TravelTimeInfo travelTimeInfo = this.travelTimeInfoProvider.getTravelTimeInfo(link);
                travelTimeInfo.init(freeSpeedTravelTime);
                travelTimeInfo.checkActiveState();
            }
        }
    }

    @Override
    public void notifyMobsimBeforeSimStep(MobsimBeforeSimStepEvent e) {
        this.problem = false;
        this.now = e.getSimulationTime();
        this.run(e.getSimulationTime());
        this.printInfo(e.getSimulationTime());
    }

    @Override
    public void notifyMobsimBeforeCleanup(MobsimBeforeCleanupEvent e) {
        this.problem = false;
        for (UpdateMeanTravelTimesRunnable runnable : this.updateMeanTravelTimesRunnables) {
            runnable.afterSim();
        }
        try {
            this.startBarrier.await();
        }
        catch (InterruptedException | BrokenBarrierException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void printInfo(double time) {
        if (time >= (double)this.nextInfoTime) {
            int activeLinks = 0;
            for (UpdateMeanTravelTimesRunnable runnable : this.updateMeanTravelTimesRunnables) {
                activeLinks += runnable.getActiveLinksCount();
            }
            log.info("WithinDayTravelTime at " + Time.writeTime(time) + " #links=" + activeLinks);
            this.nextInfoTime += this.infoTimeStep;
        }
    }

    private void run(double time) {
        try {
            for (UpdateMeanTravelTimesRunnable updateMeanTravelTimesRunnable : this.updateMeanTravelTimesRunnables) {
                updateMeanTravelTimesRunnable.setTime(time);
            }
            this.startBarrier.await();
            this.endBarrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            throw new RuntimeException(e);
        }
    }

    private void initParallelThreads() {
        this.startBarrier = new CyclicBarrier(this.numOfThreads + 1);
        this.endBarrier = new CyclicBarrier(this.numOfThreads + 1);
        Thread[] threads = new Thread[this.numOfThreads];
        this.updateMeanTravelTimesRunnables = new UpdateMeanTravelTimesRunnable[this.numOfThreads];
        for (int i = 0; i < this.numOfThreads; ++i) {
            UpdateMeanTravelTimesRunnable updateMeanTravelTimesRunnable = new UpdateMeanTravelTimesRunnable();
            updateMeanTravelTimesRunnable.setStartBarrier(this.startBarrier);
            updateMeanTravelTimesRunnable.setEndBarrier(this.endBarrier);
            this.updateMeanTravelTimesRunnables[i] = updateMeanTravelTimesRunnable;
            Thread thread = new Thread(updateMeanTravelTimesRunnable);
            thread.setName("UpdateMeanTravelTimes" + i);
            thread.setDaemon(true);
            threads[i] = thread;
            thread.start();
        }
        int roundRobin = 0;
        for (TravelTimeInfo travelTimeInfo : this.travelTimeInfos.values()) {
            travelTimeInfo.runnable = this.updateMeanTravelTimesRunnables[roundRobin % this.numOfThreads];
            ++roundRobin;
        }
        try {
            this.endBarrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            throw new RuntimeException(e);
        }
    }

    private static class UpdateMeanTravelTimesRunnable
    implements Runnable {
        private volatile boolean simulationRunning = true;
        private CyclicBarrier startBarrier = null;
        private CyclicBarrier endBarrier = null;
        private double time = Double.NEGATIVE_INFINITY;
        private Collection<TravelTimeInfo> activeTravelTimeInfos = new ArrayList<TravelTimeInfo>();

        public void setStartBarrier(CyclicBarrier cyclicBarrier) {
            this.startBarrier = cyclicBarrier;
        }

        public void setEndBarrier(CyclicBarrier cyclicBarrier) {
            this.endBarrier = cyclicBarrier;
        }

        public void setTime(double t) {
            this.time = t;
        }

        public void addTravelTimeInfo(TravelTimeInfo travelTimeInfo) {
            this.activeTravelTimeInfos.add(travelTimeInfo);
        }

        public int getActiveLinksCount() {
            return this.activeTravelTimeInfos.size();
        }

        public void afterSim() {
            this.simulationRunning = false;
        }

        @Override
        public void run() {
            try {
                block2: while (true) {
                    this.endBarrier.await();
                    this.startBarrier.await();
                    if (!this.simulationRunning) {
                        Gbl.printCurrentThreadCpuTime();
                        return;
                    }
                    Iterator<TravelTimeInfo> iter = this.activeTravelTimeInfos.iterator();
                    while (true) {
                        if (!iter.hasNext()) continue block2;
                        TravelTimeInfo travelTimeInfo = iter.next();
                        this.calcBinTravelTime(this.time, travelTimeInfo);
                        if (travelTimeInfo.tripBins.size() != 0) continue;
                        travelTimeInfo.isActive = false;
                        travelTimeInfo.travelTime = travelTimeInfo.freeSpeedTravelTime;
                        iter.remove();
                    }
                    break;
                }
            }
            catch (InterruptedException | BrokenBarrierException e) {
                throw new RuntimeException(e);
            }
        }

        private void calcBinTravelTime(double time, TravelTimeInfo travelTimeInfo) {
            double removedTravelTimes = 0.0;
            List<TripBin> tripBins = travelTimeInfo.tripBins;
            Iterator<TripBin> iter = tripBins.iterator();
            while (iter.hasNext()) {
                TripBin tripBin = iter.next();
                if (!(tripBin.leaveTime + travelTimeInfo.dynamicBinSize < time)) break;
                double travelTime = tripBin.leaveTime - tripBin.enterTime;
                removedTravelTimes += travelTime;
                iter.remove();
            }
            travelTimeInfo.sumTravelTimes = travelTimeInfo.sumTravelTimes - removedTravelTimes + travelTimeInfo.addedTravelTimes;
            travelTimeInfo.addedTravelTimes = 0.0;
            double meanTravelTime = travelTimeInfo.freeSpeedTravelTime;
            if (!tripBins.isEmpty()) {
                meanTravelTime = travelTimeInfo.sumTravelTimes / (double)tripBins.size();
            }
            travelTimeInfo.travelTime = meanTravelTime < travelTimeInfo.freeSpeedTravelTime ? travelTimeInfo.freeSpeedTravelTime : meanTravelTime;
        }
    }

    static class TravelTimeInfo {
        UpdateMeanTravelTimesRunnable runnable;
        List<TripBin> tripBins = new ArrayList<TripBin>();
        boolean isActive = false;
        int addedTrips = 0;
        double addedTravelTimes = 0.0;
        double sumTravelTimes = 0.0;
        double freeSpeedTravelTime = Double.MAX_VALUE;
        double travelTime = Double.MAX_VALUE;
        double dynamicBinSize = 0.0;
        static Counter enlarge = new Counter("WithinDayTravelTime: enlarged time bin size: ");
        static Counter shrink = new Counter("WithinDayTravelTime: shrunk time bin size: ");

        TravelTimeInfo() {
        }

        void init(double freeSpeedTravelTime) {
            this.freeSpeedTravelTime = freeSpeedTravelTime;
            this.dynamicBinSize = freeSpeedTravelTime * 2.5;
        }

        void checkActiveState() {
            if (!this.isActive) {
                this.isActive = true;
                this.runnable.addTravelTimeInfo(this);
            }
        }

        void checkBinSize(double tripTime) {
            if (tripTime > this.dynamicBinSize) {
                this.dynamicBinSize = tripTime * 2.0;
                enlarge.incCounter();
            } else if (tripTime * 3.0 < this.dynamicBinSize) {
                this.dynamicBinSize = tripTime * 3.0;
                shrink.incCounter();
            }
        }
    }

    private static class TripBin {
        double enterTime;
        double leaveTime;

        private TripBin() {
        }
    }
}

