/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.utils;

import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.PlanAgent;
import org.matsim.core.mobsim.qsim.QSim;
import org.matsim.core.mobsim.qsim.agents.WithinDayAgentUtils;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.TripStructureUtils;
import org.matsim.withinday.utils.EditTrips;
import org.matsim.withinday.utils.ReplanningException;

public final class EditPlans {
    private static final Logger log = Logger.getLogger(EditPlans.class);
    private final TripRouter tripRouter;
    private final QSim mobsim;
    private final EditTrips editTrips;
    private final PopulationFactory pf;

    @Deprecated
    public EditPlans(QSim mobsim, TripRouter tripRouter, EditTrips editTrips, PopulationFactory pf) {
        this(mobsim, tripRouter, editTrips);
    }

    @Deprecated
    public EditPlans(QSim mobsim, TripRouter tripRouter, EditTrips editTrips, Scenario sc) {
        this(mobsim, tripRouter, editTrips);
    }

    public EditPlans(QSim mobsim, TripRouter tripRouter, EditTrips editTrips) {
        this.mobsim = mobsim;
        Gbl.assertNotNull(this.mobsim);
        this.tripRouter = tripRouter;
        Gbl.assertNotNull(this.tripRouter);
        this.editTrips = editTrips;
        Gbl.assertNotNull(this.editTrips);
        this.pf = mobsim.getScenario().getPopulation().getFactory();
        Gbl.assertNotNull(this.pf);
    }

    public boolean addActivityAtEnd(MobsimAgent agent, Activity activity, String routingMode) {
        log.debug("entering addActivityAtEnd with routingMode=" + routingMode);
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        List<PlanElement> planElements = plan.getPlanElements();
        boolean retVal1 = false;
        if (this.isAtRealActivity(agent)) {
            retVal1 = planElements.add(this.pf.createLeg(routingMode));
        }
        boolean retVal = planElements.add(activity);
        if (!this.isAtRealActivity(agent)) {
            retVal1 = this.editTrips.replanCurrentTrip(agent, this.mobsim.getSimTimer().getTimeOfDay(), routingMode);
        }
        WithinDayAgentUtils.resetCaches(agent);
        this.mobsim.rescheduleActivityEnd(agent);
        return retVal1 && retVal;
    }

    public PlanElement removeActivity(MobsimAgent agent, int index, String mode) {
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        List<PlanElement> planElements = plan.getPlanElements();
        EditPlans.checkIfNotInPastOrCurrent(agent, index);
        TripStructureUtils.Trip tripBefore = TripStructureUtils.findTripEndingAtActivity((Activity)planElements.get(index), plan, this.tripRouter.getStageActivityTypes());
        TripStructureUtils.Trip tripAfter = TripStructureUtils.findTripStartingAtActivity((Activity)planElements.get(index), plan, this.tripRouter.getStageActivityTypes());
        if (mode == null) {
            String mainModeAfter;
            String mainModeBefore = this.tripRouter.getMainModeIdentifier().identifyMainMode(tripBefore.getTripElements());
            if (mainModeBefore.equals(mainModeAfter = this.tripRouter.getMainModeIdentifier().identifyMainMode(tripAfter.getTripElements()))) {
                mode = mainModeBefore;
            } else {
                throw new ReplanningException("mode not given and mode before removed activity != mode after removed activity; don't know which mode to use");
            }
        }
        PlanElement pe = planElements.remove(index);
        if (EditPlans.checkIfTripHasAlreadyStarted(agent, tripBefore.getTripElements())) {
            this.editTrips.replanCurrentTrip(agent, this.mobsim.getSimTimer().getTimeOfDay(), mode);
        } else {
            this.editTrips.insertEmptyTrip(plan, tripBefore.getOriginActivity(), tripAfter.getDestinationActivity(), mode);
        }
        WithinDayAgentUtils.resetCaches(agent);
        this.mobsim.rescheduleActivityEnd(agent);
        return pe;
    }

    public final void rescheduleActivityEndtime(MobsimAgent agent, int index, double newEndTime) {
        Activity activity = (Activity)WithinDayAgentUtils.getModifiablePlan(agent).getPlanElements().get(index);
        activity.setEndTime(newEndTime);
        WithinDayAgentUtils.resetCaches(agent);
        WithinDayAgentUtils.rescheduleActivityEnd(agent, this.mobsim);
    }

    public final Activity replaceActivity(MobsimAgent agent, int index, Activity newAct, String upstreamMode, String downstreamMode) {
        System.err.println("here310");
        WithinDayAgentUtils.printPlan(agent);
        System.err.println("here320");
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        WithinDayAgentUtils.printPlan(plan);
        System.err.println("here330");
        List<PlanElement> planElements = plan.getPlanElements();
        if (!(planElements.get(index) instanceof Activity)) {
            throw new ReplanningException("trying to replace a non-activity in the plan by an activity; this is not possible");
        }
        Activity origAct = (Activity)planElements.get(index);
        this.checkIfNotStageActivity(origAct);
        EditPlans.checkIfNotInPastOrCurrent(agent, index);
        planElements.set(index, newAct);
        System.err.println("here340");
        WithinDayAgentUtils.printPlan(plan);
        if (index > 0) {
            TripStructureUtils.Trip tripBeforeAct = TripStructureUtils.findTripEndingAtActivity(newAct, plan, this.tripRouter.getStageActivityTypes());
            Gbl.assertNotNull(tripBeforeAct);
            List<PlanElement> currentTripElements = tripBeforeAct.getTripElements();
            String currentMode = this.tripRouter.getMainModeIdentifier().identifyMainMode(currentTripElements);
            if (EditPlans.checkIfTripHasAlreadyStarted(agent, currentTripElements)) {
                EditPlans.checkIfSameMode(upstreamMode, currentMode);
                this.editTrips.replanCurrentTrip(agent, this.mobsim.getSimTimer().getTimeOfDay(), currentMode);
            } else {
                if (upstreamMode == null) {
                    upstreamMode = currentMode;
                }
                this.editTrips.insertEmptyTrip(plan, tripBeforeAct.getOriginActivity(), newAct, upstreamMode);
            }
        }
        if (index < planElements.size() - 1) {
            TripStructureUtils.Trip tripAfterAct = TripStructureUtils.findTripStartingAtActivity(origAct, plan, this.tripRouter.getStageActivityTypes());
            Gbl.assertIf(tripAfterAct != null);
            if (downstreamMode == null) {
                String currentMainMode = this.tripRouter.getMainModeIdentifier().identifyMainMode(tripAfterAct.getTripElements());
                EditTrips.insertEmptyTrip(plan, newAct, tripAfterAct.getDestinationActivity(), currentMainMode, this.pf);
            } else {
                EditTrips.insertEmptyTrip(plan, newAct, tripAfterAct.getDestinationActivity(), downstreamMode, this.pf);
            }
        }
        WithinDayAgentUtils.resetCaches(agent);
        this.mobsim.rescheduleActivityEnd(agent);
        return origAct;
    }

    public void insertActivity(MobsimAgent agent, int index, Activity activity, String upstreamMode, String downstreamMode) {
        Activity actAfter;
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        List<PlanElement> planElements = plan.getPlanElements();
        EditPlans.checkIfNotInPastOrCurrent(agent, index);
        planElements.add(index, activity);
        Activity actBefore = this.findRealActBefore(agent, index);
        if (actBefore != null) {
            if (WithinDayAgentUtils.indexOfPlanElement(agent, actBefore) < WithinDayAgentUtils.getCurrentPlanElementIndex(agent)) {
                this.editTrips.replanCurrentTrip(agent, this.mobsim.getSimTimer().getTimeOfDay(), upstreamMode);
            } else {
                EditTrips.insertEmptyTrip(plan, actBefore, activity, upstreamMode, this.pf);
            }
        }
        if ((actAfter = this.findRealActAfter(agent, index)) != null) {
            EditTrips.insertEmptyTrip(plan, activity, actAfter, downstreamMode, this.pf);
        }
        WithinDayAgentUtils.resetCaches(agent);
        this.mobsim.rescheduleActivityEnd(agent);
    }

    public PlanElement removeActivity(MobsimAgent agent, int index) {
        return this.removeActivity(agent, index, null);
    }

    public final Activity replaceActivity(MobsimAgent agent, int index, Activity newAct) {
        return this.replaceActivity(agent, index, newAct, null, null);
    }

    public void insertActivity(MobsimAgent agent, int index, Activity activity) {
        String mode = this.tripRouter.getMainModeIdentifier().identifyMainMode(this.editTrips.findCurrentTrip(agent).getTripElements());
        this.insertActivity(agent, index, activity, mode, mode);
    }

    private void checkIfNotStageActivity(Activity origAct) {
        if (this.tripRouter.getStageActivityTypes().isStageActivity(origAct.getType())) {
            throw new ReplanningException("trying to replace a helper activity (stage activity) by a real activity; this is not possible");
        }
    }

    private static boolean checkIfTripHasAlreadyStarted(MobsimAgent agent, List<PlanElement> currentTripElements) {
        return currentTripElements.contains(((PlanAgent)((Object)agent)).getCurrentPlanElement());
    }

    private static void checkIfNotInPastOrCurrent(MobsimAgent agent, int index) {
        Integer currentIndex = WithinDayAgentUtils.getCurrentPlanElementIndex(agent);
        if (index <= currentIndex) {
            throw new ReplanningException("trying to replace an activity that lies in the past or is current; this is not possible");
        }
    }

    private static void checkIfSameMode(String upstreamMode, String currentMode) {
        if (upstreamMode != null && !upstreamMode.equals(currentMode)) {
            throw new ReplanningException("cannot change mode in trip that has already started.  Don't set the mode in the request, or somehow make the agent to abort the current trip first.");
        }
    }

    public Activity findRealActAfter(MobsimAgent agent, int index) {
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        List<PlanElement> planElements = plan.getPlanElements();
        return (Activity)planElements.get(this.findIndexOfRealActAfter(agent, index));
    }

    public int findIndexOfRealActAfter(MobsimAgent agent, int index) {
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        List<PlanElement> planElements = plan.getPlanElements();
        int theIndex = -1;
        for (int ii = planElements.size() - 1; ii > index; --ii) {
            if (!(planElements.get(ii) instanceof Activity)) continue;
            Activity act = (Activity)planElements.get(ii);
            if (this.tripRouter.getStageActivityTypes().isStageActivity(act.getType())) continue;
            theIndex = ii;
        }
        return theIndex;
    }

    public Activity findRealActBefore(MobsimAgent agent, int index) {
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        List<PlanElement> planElements = plan.getPlanElements();
        Activity prevAct = null;
        for (int ii = 0; ii < index; ++ii) {
            if (!(planElements.get(ii) instanceof Activity)) continue;
            Activity act = (Activity)planElements.get(ii);
            if (this.tripRouter.getStageActivityTypes().isStageActivity(act.getType())) continue;
            prevAct = act;
        }
        return prevAct;
    }

    public void rescheduleActivityEnd(MobsimAgent agent) {
        this.mobsim.rescheduleActivityEnd(agent);
    }

    public boolean isAtRealActivity(MobsimAgent agent) {
        PlanElement pe = WithinDayAgentUtils.getCurrentPlanElement(agent);
        return this.isRealActivity(pe);
    }

    public boolean isRealActivity(PlanElement pe) {
        return pe instanceof Activity && !this.tripRouter.getStageActivityTypes().isStageActivity(((Activity)pe).getType());
    }

    public String getModeOfCurrentOrNextTrip(MobsimAgent agent) {
        TripStructureUtils.Trip trip;
        if (this.isAtRealActivity(agent)) {
            Activity activity = (Activity)WithinDayAgentUtils.getCurrentPlanElement(agent);
            trip = this.editTrips.findTripAfterActivity(WithinDayAgentUtils.getModifiablePlan(agent), activity);
        } else {
            trip = this.editTrips.findCurrentTrip(agent);
        }
        return this.tripRouter.getMainModeIdentifier().identifyMainMode(trip.getTripElements());
    }

    public void flushEverythingBeyondCurrent(MobsimAgent agent) {
        List<PlanElement> pes = WithinDayAgentUtils.getModifiablePlan(agent).getPlanElements();
        Integer index = WithinDayAgentUtils.getCurrentPlanElementIndex(agent);
        for (int ii = pes.size() - 1; ii > index; --ii) {
            pes.remove(ii);
        }
    }

    public void rescheduleCurrentActivityEndtime(MobsimAgent agent, double newEndTime) {
        Integer index = WithinDayAgentUtils.getCurrentPlanElementIndex(agent);
        this.rescheduleActivityEndtime(agent, index, newEndTime);
    }

    public Activity createFinalActivity(String type, Id<Link> newLinkId) {
        Activity newAct = this.pf.createActivityFromLinkId(type, newLinkId);
        newAct.setEndTime(Double.POSITIVE_INFINITY);
        return newAct;
    }

    public static Integer getCurrentPlanElementIndex(MobsimAgent agent) {
        return WithinDayAgentUtils.getCurrentPlanElementIndex(agent);
    }
}

