/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.mobsim.framework.HasPerson;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.agents.WithinDayAgentUtils;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteFactories;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.router.LinkWrapperFacility;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.vehicles.Vehicle;

public final class EditRoutes {
    private static final Logger log = Logger.getLogger(EditRoutes.class);
    private Network network;
    private LeastCostPathCalculator pathCalculator;
    private RouteFactories routeFactories;

    @Deprecated
    public EditRoutes() {
    }

    public EditRoutes(Network network, LeastCostPathCalculator pathCalculator, PopulationFactory popFactory) {
        this.network = network;
        this.pathCalculator = pathCalculator;
        this.routeFactories = popFactory.getRouteFactories();
    }

    @Deprecated
    public boolean relocateFutureLegRoute(Leg leg, Id<Link> fromLinkId, Id<Link> toLinkId, Person person) {
        double starttime;
        Node endNode;
        Link fromLink = this.network.getLinks().get(fromLinkId);
        Link toLink = this.network.getLinks().get(toLinkId);
        Vehicle vehicle = null;
        Node startNode = fromLink.getToNode();
        LeastCostPathCalculator.Path path = this.pathCalculator.calcLeastCostPath(startNode, endNode = toLink.getFromNode(), starttime = leg.getDepartureTime(), person, vehicle);
        if (path == null) {
            throw new RuntimeException("No route found from node " + startNode.getId() + " to node " + endNode.getId() + ".");
        }
        NetworkRoute route = this.routeFactories.createRoute(NetworkRoute.class, fromLink.getId(), toLink.getId());
        route.setLinkIds(fromLink.getId(), NetworkUtils.getLinkIds(path.links), toLink.getId());
        route.setTravelTime((int)path.travelTime);
        route.setTravelCost(path.travelCost);
        route.setDistance(RouteUtils.calcDistance(route, 1.0, 1.0, this.network));
        leg.setRoute(route);
        return true;
    }

    public final void replanCurrentLeg(MobsimAgent agent, double now) {
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        PlanElement pe = plan.getPlanElements().get(WithinDayAgentUtils.getCurrentPlanElementIndex(agent));
        if (!(pe instanceof Leg)) {
            return;
        }
        int currentLinkIndex = WithinDayAgentUtils.getCurrentRouteLinkIdIndex(agent);
        this.replanCurrentLegRoute((Leg)pe, ((HasPerson)((Object)agent)).getPerson(), currentLinkIndex, now);
        WithinDayAgentUtils.resetCaches(agent);
    }

    @Deprecated
    public static boolean relocateFutureLegRoute(Leg leg, Id<Link> fromLinkId, Id<Link> toLinkId, Person person, Network network, TripRouter tripRouter) {
        Link fromLink = network.getLinks().get(fromLinkId);
        Link toLink = network.getLinks().get(toLinkId);
        LinkWrapperFacility fromFacility = new LinkWrapperFacility(fromLink);
        LinkWrapperFacility toFacility = new LinkWrapperFacility(toLink);
        List<? extends PlanElement> planElements = tripRouter.calcRoute(leg.getMode(), fromFacility, toFacility, leg.getDepartureTime(), person);
        if (planElements.size() != 1) {
            throw new RuntimeException("Expected a list of PlanElements containing exactly one element, but the returned list contained " + planElements.size() + " elements.");
        }
        Leg newLeg = (Leg)planElements.get(0);
        leg.setTravelTime(newLeg.getTravelTime());
        leg.setRoute(newLeg.getRoute());
        return true;
    }

    public boolean replanFutureLegRoute(Leg leg, Person person) {
        return this.relocateFutureLegRoute(leg, leg.getRoute().getStartLinkId(), leg.getRoute().getEndLinkId(), person);
    }

    @Deprecated
    public boolean relocateCurrentLegRoute(Leg leg, Person person, int currentLinkIndex, Id<Link> toLinkId, double time) {
        Route route = leg.getRoute();
        if (!(route instanceof NetworkRoute)) {
            log.warn("route not instance of NetworkRoute");
            return false;
        }
        NetworkRoute oldRoute = (NetworkRoute)route;
        List<Id<Link>> oldLinkIds = EditRoutes.getRouteLinkIds(oldRoute);
        Id<Link> currentLinkId = oldLinkIds.get(currentLinkIndex);
        Link startLink = this.network.getLinks().get(currentLinkId);
        Link endLink = this.network.getLinks().get(toLinkId);
        Vehicle vehicle = null;
        LeastCostPathCalculator.Path path = this.pathCalculator.calcLeastCostPath(startLink.getToNode(), endLink.getFromNode(), time, person, vehicle);
        EditRoutes.spliceNewPathIntoOldRoute(currentLinkIndex, toLinkId, oldRoute, NetworkUtils.getLinkIds(path.links), currentLinkId);
        return true;
    }

    static void spliceNewPathIntoOldRoute(int currentLinkIndex, Id<Link> toLinkId, NetworkRoute oldRoute, List<Id<Link>> newLinksIds, Id<Link> currentLinkId) {
        List<Id<Link>> oldLinkIds = oldRoute.getLinkIds();
        ArrayList<Id<Link>> resultingLinkIds = new ArrayList<Id<Link>>();
        if (currentLinkIndex > 0) {
            resultingLinkIds.addAll(oldLinkIds.subList(0, currentLinkIndex - 1));
        }
        if (!oldRoute.getStartLinkId().equals(currentLinkId)) {
            resultingLinkIds.add(currentLinkId);
        }
        if (resultingLinkIds.size() > 0 && newLinksIds.size() > 0 && ((Id)resultingLinkIds.get(resultingLinkIds.size() - 1)).equals(newLinksIds.get(newLinksIds.size() - 1))) {
            resultingLinkIds.remove(resultingLinkIds.size() - 1);
        }
        resultingLinkIds.addAll(newLinksIds);
        StringBuilder strb = new StringBuilder();
        for (int ii = Math.max(0, currentLinkIndex - 2); ii < Math.min(resultingLinkIds.size(), currentLinkIndex + 3); ++ii) {
            strb.append("-");
            strb.append(resultingLinkIds.get(ii));
            strb.append("-");
        }
        log.info("linkIds at join: " + strb);
        oldRoute.setLinkIds(oldRoute.getStartLinkId(), resultingLinkIds, toLinkId);
    }

    public boolean replanCurrentLegRoute(Leg leg, Person person, int currentLinkIndex, double time) {
        Route route = leg.getRoute();
        if (!(route instanceof NetworkRoute)) {
            log.warn("route not instance of NetworkRoute");
            return false;
        }
        return this.relocateCurrentLegRoute(leg, person, currentLinkIndex, route.getEndLinkId(), time);
    }

    public final LeastCostPathCalculator getPathCalculator() {
        return this.pathCalculator;
    }

    private static List<Id<Link>> getRouteLinkIds(Route route) {
        ArrayList<Id<Link>> linkIds = new ArrayList<Id<Link>>();
        if (!(route instanceof NetworkRoute)) {
            throw new RuntimeException("Currently only NetworkRoutes are supported for Within-Day Replanning!");
        }
        NetworkRoute networkRoute = (NetworkRoute)route;
        linkIds.add(networkRoute.getStartLinkId());
        linkIds.addAll(networkRoute.getLinkIds());
        linkIds.add(networkRoute.getEndLinkId());
        return linkIds;
    }
}

