/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.withinday.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.AgentTracker;
import org.matsim.core.mobsim.qsim.InternalInterface;
import org.matsim.core.mobsim.qsim.agents.WithinDayAgentUtils;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.pt.PTPassengerAgent;
import org.matsim.core.mobsim.qsim.pt.TransitDriverAgent;
import org.matsim.core.mobsim.qsim.pt.TransitDriverAgentImpl;
import org.matsim.core.mobsim.qsim.pt.TransitStopAgentTracker;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.GenericRouteImpl;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.router.PlanRouter;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.TripStructureUtils;
import org.matsim.facilities.FacilitiesUtils;
import org.matsim.facilities.Facility;
import org.matsim.pt.routes.ExperimentalTransitRoute;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.withinday.events.ReplanningEvent;
import org.matsim.withinday.utils.EditRoutes;
import org.matsim.withinday.utils.ReplanningException;

public final class EditTrips {
    private static final Logger log = Logger.getLogger(EditTrips.class);
    private final TripRouter tripRouter;
    private final PopulationFactory pf;
    private final InternalInterface internalInterface;
    private Scenario scenario;
    private TransitStopAgentTracker transitAgentTracker;
    private EventsManager eventsManager;

    public EditTrips(TripRouter tripRouter, Scenario scenario, InternalInterface internalInterface) {
        if (internalInterface == null) {
            log.warn("InternalInterface is null. Replanning of pt/transit legs will not work properly and will likely fail.");
        } else {
            this.eventsManager = internalInterface.getMobsim().getEventsManager();
            for (AgentTracker tracker : internalInterface.getMobsim().getAgentTrackers()) {
                if (!(tracker instanceof TransitStopAgentTracker)) continue;
                this.transitAgentTracker = (TransitStopAgentTracker)tracker;
                break;
            }
        }
        this.tripRouter = tripRouter;
        this.scenario = scenario;
        this.pf = scenario.getPopulation().getFactory();
        this.internalInterface = internalInterface;
        if (this.transitAgentTracker == null) {
            log.warn("no TransitStopAgentTracker found in qsim. Replanning of pt/transit legs will not work properly and will likely fail.");
        }
    }

    public final TripStructureUtils.Trip findCurrentTrip(MobsimAgent agent) {
        PlanElement pe = WithinDayAgentUtils.getCurrentPlanElement(agent);
        return this.findTripAtPlanElement(agent, pe);
    }

    public TripStructureUtils.Trip findTripAtPlanElement(MobsimAgent agent, PlanElement pe) {
        List<TripStructureUtils.Trip> trips = TripStructureUtils.getTrips(WithinDayAgentUtils.getModifiablePlan(agent), this.tripRouter.getStageActivityTypes());
        for (TripStructureUtils.Trip trip : trips) {
            for (PlanElement te : trip.getTripElements()) {
                if (te != pe) continue;
                return trip;
            }
        }
        throw new ReplanningException("trip not found");
    }

    public TripStructureUtils.Trip findTripAtPlanElementIndex(MobsimAgent agent, int index) {
        return this.findTripAtPlanElement(agent, WithinDayAgentUtils.getModifiablePlan(agent).getPlanElements().get(index));
    }

    public final boolean replanCurrentTrip(MobsimAgent agent, double now, String routingMode) {
        log.debug("entering replanCurrentTrip with routingMode=" + routingMode);
        TripStructureUtils.Trip trip = this.findCurrentTrip(agent);
        PlanElement currentPlanElement = WithinDayAgentUtils.getCurrentPlanElement(agent);
        List<PlanElement> tripElements = trip.getTripElements();
        int tripElementsIndex = tripElements.indexOf(currentPlanElement);
        if (currentPlanElement instanceof Activity) {
            this.replanCurrentTripFromStageActivity(trip, tripElementsIndex, routingMode, now, agent);
        } else {
            this.replanCurrentTripFromLeg(trip.getDestinationActivity(), currentPlanElement, routingMode, now, agent);
        }
        if (this.eventsManager != null) {
            ReplanningEvent replanningEvent = new ReplanningEvent(now, agent.getId(), "EditTrips.replanCurrentTrip");
            this.eventsManager.processEvent(replanningEvent);
        }
        WithinDayAgentUtils.resetCaches(agent);
        return true;
    }

    private void replanCurrentTripFromLeg(Activity newAct, PlanElement currentPlanElement, String routingMode, double now, MobsimAgent agent) {
        log.debug("entering replanCurrentTripFromLeg for agent" + agent.getId());
        Leg currentLeg = (Leg)currentPlanElement;
        if (currentLeg.getRoute() instanceof NetworkRoute) {
            this.replanCurrentLegWithNetworkRoute(newAct, routingMode, currentLeg, now, agent);
        } else if (currentLeg.getRoute() instanceof ExperimentalTransitRoute) {
            this.replanCurrentLegWithTransitRoute(newAct, routingMode, currentLeg, now, agent);
        } else if (currentLeg.getRoute() instanceof GenericRouteImpl) {
            this.replanCurrentLegWithGenericRoute(newAct, routingMode, currentLeg, now, agent);
        } else {
            throw new ReplanningException("not implemented for the route type of the current leg");
        }
        WithinDayAgentUtils.resetCaches(agent);
    }

    private void replanCurrentLegWithNetworkRoute(Activity newAct, String mainMode, Leg currentLeg, double now, MobsimAgent agent) {
        log.debug("entering replanCurrentLegWithNetworkRoute for agent" + agent.getId());
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        List<PlanElement> planElements = plan.getPlanElements();
        Person person = plan.getPerson();
        Link currentLink = this.scenario.getNetwork().getLinks().get(agent.getCurrentLinkId());
        Facility currentLocationFacility = FacilitiesUtils.wrapLink(currentLink);
        List<? extends PlanElement> newTripElements = this.newTripToNewActivity(currentLocationFacility, newAct, mainMode, now, person);
        Gbl.assertIf(!((Leg)newTripElements.get(1)).getMode().equals("non_network_walk"));
        EditTrips.replaceRemainderOfCurrentRoute(currentLeg, newTripElements, agent);
        int pos = WithinDayAgentUtils.getCurrentPlanElementIndex(agent) + 1;
        while (!planElements.get(pos).equals(newAct)) {
            planElements.remove(pos);
        }
        for (int ijk = 1; ijk < newTripElements.size(); ++ijk) {
            planElements.add(pos, newTripElements.get(ijk));
        }
        WithinDayAgentUtils.resetCaches(agent);
    }

    /*
     * WARNING - void declaration
     */
    private void replanCurrentLegWithTransitRoute(Activity newAct, String routingMode, Leg currentLeg, double now, MobsimAgent agent) {
        void var17_22;
        log.debug("entering replanCurrentLegWithTransitRoute for agentId=" + agent.getId());
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        List<PlanElement> planElements = plan.getPlanElements();
        Person person = plan.getPerson();
        if (!(agent instanceof PTPassengerAgent)) {
            throw new RuntimeException("transit leg, but agent is not an PTPassengerAgent: not implemented! agent id: " + agent.getId());
        }
        PTPassengerAgent ptPassengerAgent = (PTPassengerAgent)((Object)agent);
        MobsimVehicle mobsimVehicle = ptPassengerAgent.getVehicle();
        ExperimentalTransitRoute oldPtRoute = (ExperimentalTransitRoute)currentLeg.getRoute();
        boolean wantsToLeaveStop = false;
        TransitStopFacility currentOrNextStop = null;
        List<? extends PlanElement> newTripElements = null;
        if (mobsimVehicle == null) {
            ExperimentalTransitRoute experimentalTransitRoute;
            Leg newPtLeg;
            currentOrNextStop = this.scenario.getTransitSchedule().getFacilities().get(oldPtRoute.getAccessStopId());
            log.debug("agent with ID=" + agent.getId() + " is waiting at a stop=" + currentOrNextStop);
            newTripElements = this.newTripToNewActivity(currentOrNextStop, newAct, routingMode, now, person);
            Gbl.assertIf(newTripElements.get(0) instanceof Leg);
            wantsToLeaveStop = true;
            if (newTripElements.size() >= 2 && (newPtLeg = (Leg)newTripElements.get(2)).getRoute() instanceof ExperimentalTransitRoute && (experimentalTransitRoute = (ExperimentalTransitRoute)newPtLeg.getRoute()).getAccessStopId().equals(currentOrNextStop.getId())) {
                log.debug("agent with ID=" + agent.getId() + " will wait for vehicle departing at the same stop facility.");
                currentLeg.setRoute(new ExperimentalTransitRoute(this.scenario.getTransitSchedule().getFacilities().get(oldPtRoute.getAccessStopId()), this.scenario.getTransitSchedule().getFacilities().get(experimentalTransitRoute.getEgressStopId()), experimentalTransitRoute.getLineId(), experimentalTransitRoute.getRouteId()));
                newTripElements.remove(0);
                newTripElements.remove(0);
                newTripElements.remove(0);
                wantsToLeaveStop = false;
                WithinDayAgentUtils.resetCaches(agent);
            }
            if (wantsToLeaveStop) {
                log.debug("agent with ID=" + agent.getId() + " will leave the stop facility.");
                newTripElements = this.defaultMergeOldAndNewCurrentPtLeg(currentLeg, newTripElements, agent, currentOrNextStop, oldPtRoute);
            }
        } else {
            ExperimentalTransitRoute newPtRoute;
            Leg firstPtLeg;
            log.debug("agent with ID=" + agent.getId() + " is on a vehicle");
            TransitDriverAgent driver = (TransitDriverAgent)mobsimVehicle.getDriver();
            currentOrNextStop = driver.getNextTransitStop();
            if (!(driver instanceof TransitDriverAgentImpl)) {
                throw new RuntimeException("transit driver is not a TransitDriverAgentImpl, not implemented!");
            }
            TransitDriverAgentImpl driverImpl = (TransitDriverAgentImpl)driver;
            double departureFirstTransitRouteStop = driverImpl.getDeparture().getDepartureTime();
            double arrivalOffsetNextTransitRouteStop = driverImpl.getTransitRoute().getStop(currentOrNextStop).getArrivalOffset();
            double d = departureFirstTransitRouteStop + arrivalOffsetNextTransitRouteStop;
            log.debug("agent with ID=" + agent.getId() + " is re-routed from next stop " + currentOrNextStop.getId() + " scheduled arrival at " + d);
            newTripElements = this.newTripToNewActivity(currentOrNextStop, newAct, routingMode, d, person);
            boolean agentStaysOnSameVehicle = false;
            if (newTripElements.size() >= 2 && (firstPtLeg = (Leg)newTripElements.get(2)).getRoute() instanceof ExperimentalTransitRoute && (newPtRoute = (ExperimentalTransitRoute)firstPtLeg.getRoute()).getAccessStopId().equals(currentOrNextStop.getId()) && oldPtRoute.getLineId().equals(newPtRoute.getLineId()) && (oldPtRoute.getRouteId().equals(newPtRoute.getRouteId()) || this.transitRouteLaterStopsAt(oldPtRoute.getLineId(), oldPtRoute.getRouteId(), currentOrNextStop.getId(), newPtRoute.getEgressStopId()))) {
                currentLeg.setRoute(new ExperimentalTransitRoute(this.scenario.getTransitSchedule().getFacilities().get(oldPtRoute.getAccessStopId()), this.scenario.getTransitSchedule().getFacilities().get(newPtRoute.getEgressStopId()), oldPtRoute.getLineId(), oldPtRoute.getRouteId()));
                newTripElements.remove(0);
                newTripElements.remove(0);
                newTripElements.remove(0);
                WithinDayAgentUtils.resetCaches(agent);
                agentStaysOnSameVehicle = true;
            }
            if (!agentStaysOnSameVehicle) {
                newTripElements = this.defaultMergeOldAndNewCurrentPtLeg(currentLeg, newTripElements, agent, currentOrNextStop, oldPtRoute);
            }
        }
        log.debug("");
        log.debug("newTrip for agentId=" + agent.getId());
        for (PlanElement planElement : newTripElements) {
            log.debug(planElement);
        }
        log.debug("");
        int pos = WithinDayAgentUtils.getCurrentPlanElementIndex(agent) + 1;
        while (!planElements.get(pos).equals(newAct)) {
            planElements.remove(pos);
        }
        boolean bl = false;
        while (var17_22 < newTripElements.size()) {
            planElements.add(pos + var17_22, newTripElements.get((int)var17_22));
            ++var17_22;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (PlanElement planElement : planElements) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append("---");
            }
            if (planElement instanceof Leg) {
                stringBuilder.append(((Leg)planElement).getMode());
                continue;
            }
            if (!(planElement instanceof Activity)) continue;
            stringBuilder.append(((Activity)planElement).getType());
        }
        log.debug("");
        log.debug("agent" + agent.getId() + " new plan: " + stringBuilder.toString());
        log.debug("");
        log.debug("agent" + agent.getId() + " new plan: ");
        for (PlanElement planElement : planElements) {
            log.debug(planElement);
        }
        log.debug("");
        WithinDayAgentUtils.resetCaches(agent);
        if (wantsToLeaveStop) {
            if (this.transitAgentTracker == null) {
                log.error("Replanning a pt/transit leg, but there is no TransitStopAgentTracker found in qsim. Failing...");
                throw new RuntimeException("no TransitStopAgentTracker found in qsim");
            }
            this.transitAgentTracker.removeAgentFromStop(ptPassengerAgent, currentOrNextStop.getId());
            ((MobsimAgent)((Object)ptPassengerAgent)).endLegAndComputeNextState(now);
            this.internalInterface.arrangeNextAgentState((MobsimAgent)((Object)ptPassengerAgent));
        }
        PopulationUtils.putPersonAttribute(person, "marker", true);
    }

    private void replanCurrentLegWithGenericRoute(Activity newAct, String routingMode, Leg currentLeg, double now, MobsimAgent agent) {
        double departureTime;
        Facility toFacility;
        Facility fromFacility;
        TripStructureUtils.Trip trip;
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        int currPosPlanElements = WithinDayAgentUtils.getCurrentPlanElementIndex(agent);
        Activity nextAct = (Activity)plan.getPlanElements().get(currPosPlanElements + 1);
        if (this.tripRouter.getStageActivityTypes().isStageActivity(nextAct.getType())) {
            double departureTimeAccordingToPlannedActivityEnd;
            trip = this.findCurrentTrip(agent);
            fromFacility = FacilitiesUtils.toFacility(nextAct, this.scenario.getActivityFacilities());
            toFacility = FacilitiesUtils.toFacility(trip.getDestinationActivity(), this.scenario.getActivityFacilities());
            Activity previousActivity = (Activity)plan.getPlanElements().get(currPosPlanElements - 1);
            departureTime = now + 0.5 * currentLeg.getTravelTime();
            if (Double.isFinite(previousActivity.getEndTime()) && previousActivity.getEndTime() < now && (departureTimeAccordingToPlannedActivityEnd = previousActivity.getEndTime() + currentLeg.getTravelTime()) > now) {
                departureTime = departureTimeAccordingToPlannedActivityEnd;
            }
        } else {
            return;
        }
        List<? extends PlanElement> newTrip = this.tripRouter.calcRoute(routingMode, fromFacility, toFacility, departureTime, plan.getPerson());
        TripRouter.insertTrip(plan, nextAct, newTrip, trip.getDestinationActivity());
        WithinDayAgentUtils.resetCaches(agent);
    }

    private List<? extends PlanElement> newTripToNewActivity(Facility currentLocationFacility, Activity newAct, String mainMode, double now, Person person) {
        log.debug("entering newTripToNewActivity");
        Facility toFacility = FacilitiesUtils.toFacility(newAct, this.scenario.getActivityFacilities());
        return this.tripRouter.calcRoute(mainMode, currentLocationFacility, toFacility, now, person);
    }

    private void replanCurrentTripFromStageActivity(TripStructureUtils.Trip trip, int tripElementsIndex, String mainMode, double now, MobsimAgent agent) {
        log.debug("entering replanCurrentTripFromStageActivity for agent" + agent.getId());
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        List<PlanElement> planElements = plan.getPlanElements();
        Person person = plan.getPerson();
        if (!(trip.getTripElements().get(tripElementsIndex) instanceof Activity)) {
            throw new RuntimeException("Expected a stage activity as current plan element");
        }
        Activity currentStageActivity = (Activity)trip.getTripElements().get(tripElementsIndex);
        Facility currentLocationFacility = FacilitiesUtils.toFacility(currentStageActivity, this.scenario.getActivityFacilities());
        List<? extends PlanElement> newTripElements = this.newTripToNewActivity(currentLocationFacility, trip.getDestinationActivity(), mainMode, now, person);
        int pos = WithinDayAgentUtils.getCurrentPlanElementIndex(agent) + 1;
        while (!planElements.get(pos).equals(trip.getDestinationActivity())) {
            planElements.remove(pos);
        }
        for (int ijk = 1; ijk < newTripElements.size(); ++ijk) {
            planElements.add(pos + ijk, newTripElements.get(ijk));
        }
        WithinDayAgentUtils.resetCaches(agent);
    }

    public static boolean insertEmptyTrip(Plan plan, Activity fromActivity, Activity toActivity, String mainMode, PopulationFactory pf) {
        List<Leg> list = Collections.singletonList(pf.createLeg(mainMode));
        TripRouter.insertTrip(plan, fromActivity, list, toActivity);
        return true;
    }

    public final boolean insertEmptyTrip(Plan plan, Activity fromActivity, Activity toActivity, String mainMode) {
        return EditTrips.insertEmptyTrip(plan, fromActivity, toActivity, mainMode, this.pf);
    }

    public final List<? extends PlanElement> replanFutureTrip(TripStructureUtils.Trip trip, Plan plan, String mainMode) {
        double departureTime = PlanRouter.calcEndOfActivity(trip.getOriginActivity(), plan, this.tripRouter.getConfig());
        return this.replanFutureTrip(trip, plan, mainMode, departureTime);
    }

    public final List<? extends PlanElement> replanFutureTrip(TripStructureUtils.Trip trip, Plan plan, String routingMode, double departureTime) {
        return EditTrips.replanFutureTrip(trip, plan, routingMode, departureTime, this.tripRouter, this.scenario);
    }

    private static void replaceRemainderOfCurrentRoute(Leg currentLeg, List<? extends PlanElement> newTrip, MobsimAgent agent) {
        Leg newCurrentLeg = (Leg)newTrip.get(0);
        Gbl.assertNotNull(newCurrentLeg);
        NetworkRoute oldNWRoute = (NetworkRoute)currentLeg.getRoute();
        Integer currentRouteLinkIdIndex = WithinDayAgentUtils.getCurrentRouteLinkIdIndex(agent);
        NetworkRoute newNWRoute = (NetworkRoute)newCurrentLeg.getRoute();
        List<Id<Link>> newLinksIds = newNWRoute.getLinkIds().subList(0, newNWRoute.getLinkIds().size());
        EditRoutes.spliceNewPathIntoOldRoute(currentRouteLinkIdIndex, newNWRoute.getEndLinkId(), oldNWRoute, newLinksIds, agent.getCurrentLinkId());
        WithinDayAgentUtils.resetCaches(agent);
    }

    private List<PlanElement> defaultMergeOldAndNewCurrentPtLeg(Leg currentLeg, List<? extends PlanElement> newTrip, MobsimAgent agent, TransitStopFacility nextStop, ExperimentalTransitRoute oldPtRoute) {
        Leg newCurrentLeg = (Leg)newTrip.get(0);
        ArrayList<PlanElement> newPlanElementsAfterMerge = new ArrayList<PlanElement>();
        if (newCurrentLeg.getRoute() instanceof ExperimentalTransitRoute) {
            throw new RuntimeException("not implemented");
        }
        currentLeg.setRoute(new ExperimentalTransitRoute(this.scenario.getTransitSchedule().getFacilities().get(oldPtRoute.getAccessStopId()), nextStop, oldPtRoute.getLineId(), oldPtRoute.getRouteId()));
        Activity act = PopulationUtils.createActivityFromCoordAndLinkId("pt interaction", nextStop.getCoord(), nextStop.getLinkId());
        act.setMaximumDuration(0.0);
        newPlanElementsAfterMerge.add(act);
        for (int ijk = 0; ijk < newTrip.size(); ++ijk) {
            newPlanElementsAfterMerge.add(newPlanElementsAfterMerge.size(), newTrip.get(ijk));
        }
        WithinDayAgentUtils.resetCaches(agent);
        return newPlanElementsAfterMerge;
    }

    private boolean transitRouteLaterStopsAt(Id<TransitLine> lineId, Id<TransitRoute> routeId, Id<TransitStopFacility> currentStopId, Id<TransitStopFacility> egressStopId) {
        boolean afterCurrentStop = false;
        for (TransitRouteStop stop : this.scenario.getTransitSchedule().getTransitLines().get(lineId).getRoutes().get(routeId).getStops()) {
            if (currentStopId.equals(stop.getStopFacility().getId())) {
                afterCurrentStop = true;
            }
            if (!afterCurrentStop || !egressStopId.equals(stop.getStopFacility().getId())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static List<? extends PlanElement> replanFutureTrip(TripStructureUtils.Trip trip, Plan plan, String routingMode, double departureTime, TripRouter tripRouter, Scenario scenario) {
        log.debug("entering replanFutureTrip for agentid=" + plan.getPerson().getId());
        Person person = plan.getPerson();
        Facility fromFacility = FacilitiesUtils.toFacility(trip.getOriginActivity(), scenario.getActivityFacilities());
        Facility toFacility = FacilitiesUtils.toFacility(trip.getDestinationActivity(), scenario.getActivityFacilities());
        List<? extends PlanElement> newTrip = tripRouter.calcRoute(routingMode, fromFacility, toFacility, departureTime, person);
        TripRouter.insertTrip(plan, trip.getOriginActivity(), newTrip, trip.getDestinationActivity());
        return newTrip;
    }

    @Deprecated
    public static List<? extends PlanElement> relocateFutureTrip(TripStructureUtils.Trip trip, Plan plan, String mainMode, double departureTime, TripRouter tripRouter, Scenario scenario) {
        return EditTrips.replanFutureTrip(trip, plan, mainMode, departureTime, tripRouter, scenario);
    }

    public StageActivityTypes getStageActivities() {
        return this.tripRouter.getStageActivityTypes();
    }

    public TripStructureUtils.Trip findTripAfterActivity(Plan plan, Activity activity) {
        return TripStructureUtils.findTripStartingAtActivity(activity, plan, this.tripRouter.getStageActivityTypes());
    }
}

