import sys
import argparse
if __name__ == "__main__":
    from emulator import Emulator
    from assembler import Assembler
else:
    from .emulator import Emulator
    from .assembler import Assembler

def main():
    parser = argparse.ArgumentParser(prog='pythonRSC', description="An emulator for the RSC architecture written in Python.")
    parser.add_argument('mode', choices=["debug", "run", "assemble"])
    parser.add_argument('filein', help="your microcode file which contains instructions")
    parser.add_argument('-o', required="assemble" in sys.argv, help="the output file path for the assembler generated bytecode", type=str)
    parser.add_argument('-cfg', action='store_true', help="indicates if you wish to see the control flow graph")
    args = parser.parse_args(sys.argv[1:])
    asm_obj = Assembler(args.filein)
    if args.o:
        asm_obj.logisim_format(args.o)
    else:
        debug_val = True if args.mode == "debug" else False
        emulator = Emulator(asm_obj, debug_val, args.cfg)
        emulator.start()

if __name__ == "__main__":
    main()