"""
Полный русский интерфейс для Python
"""

# ==================== ОСНОВНЫЕ ФУНКЦИИ ====================    
def Напечатать(*аргументы, sep=' ', end='\n', file=None, flush=False):
    """Аналог print()"""
    print(*аргументы, sep=sep, end=end, file=file, flush=flush)

def Ввод(приглашение):
    """Аналог input()"""
    return input(приглашение)

def Длина(объект):
    """Аналог len()"""
    return len(объект)

def Тип(объект):
    """Аналог type()"""
    return type(объект)

def Диапазон(*аргументы):
    """Аналог range()"""
    return range(*аргументы)

def Список(итерируемый=None):
    """Аналог list()"""
    return list(итерируемый) if итерируемый is not None else []

def Словарь(**kwargs):
    """Аналог dict()"""
    return dict(**kwargs)

def Множество(итерируемый=None):
    """Аналог set()"""
    return set(итерируемый) if итерируемый is not None else set()

def Кортеж(итерируемый=None):
    """Аналог tuple()"""
    return tuple(итерируемый) if итерируемый is not None else ()

def Строка(объект=''):
    """Аналог str()"""
    return str(объект)

def Целое(объект=0):
    """Аналог int()"""
    return int(объект)

def Дробное(объект=0.0):
    """Аналог float()"""
    return float(объект)

def Логическое(объект=False):
    """Аналог bool()"""
    return bool(объект)

# ==================== МАТЕМАТИЧЕСКИЕ ФУНКЦИИ ====================
def Сумма(итерируемый, start=0):
    """Аналог sum()"""
    return sum(итерируемый, start)

def Максимум(*аргументы):
    """Аналог max()"""
    return max(*аргументы)

def Минимум(*аргументы):
    """Аналог min()"""
    return min(*аргументы)

def Абсолютное(число):
    """Аналог abs()"""
    return abs(число)

def Округлить(число, ndigits=0):
    """Аналог round()"""
    return round(число, ndigits)

def Степень(основание, степень):
    """Аналог pow()"""
    return pow(основание, степень)

# ==================== РИСОВАНИЕ В КОНСОЛИ ====================
def Линия(длина=20, символ='-'):
    """Рисует горизонтальную линию"""
    Напечатать(символ * длина)

def Прямоугольник(ширина=10, высота=5, символ='*'):
    """Рисует прямоугольник"""
    for i in range(высота):
        if i == 0 or i == высота - 1:
            Напечатать(символ * ширина)
        else:
            Напечатать(символ + ' ' * (ширина - 2) + символ)

def Треугольник(высота=5, символ='*'):
    """Рисует треугольник"""
    for i in range(1, высота + 1):
        Напечатать(' ' * (высота - i) + символ * (2*i - 1))

def Рамка(текст, символ='#'):
    """Обрамляет текст в рамку"""
    длина = len(текст) + 4
    Линия(длина, символ)
    Напечатать(f"{символ} {текст} {символ}")
    Линия(длина, символ)

def ПрогрессБар(процент, длина=20, fill='█', empty='░'):
    """Рисует прогресс-бар"""
    filled = int(длина * процент / 100)
    bar = fill * filled + empty * (длина - filled)
    Напечатать(f"[{bar}] {процент}%")

def ОчиститьЭкран():
    """Очищает экран консоли"""
    import os
    os.system('cls' if os.name == 'nt' else 'clear')

# ==================== РАБОТА С ФАЙЛАМИ ====================
def ОткрытьФайл(путь, режим='r', кодировка='utf-8'):
    """Аналог open()"""
    return open(путь, режим, encoding=кодировка)

def ПрочитатьФайл(путь, кодировка='utf-8'):
    """Читает весь файл"""
    with open(путь, 'r', encoding=кодировка) as файл:
        return файл.read()

def ЗаписатьВФайл(путь, содержимое, кодировка='utf-8'):
    """Записывает в файл"""
    with open(путь, 'w', encoding=кодировка) as файл:
        файл.write(содержимое)

# ==================== СИСТЕМНЫЕ ФУНКЦИИ ====================
def Импортировать(модуль):
    """Аналог import"""
    return __import__(модуль)

def Выполнить(код):
    """Аналог exec()"""
    exec(код)

def Вычислить(выражение):
    """Аналог eval()"""
    return eval(выражение)

def Выйти(код=0):
    """Аналог exit()"""
    exit(код)

# ==================== СПЕЦИАЛЬНЫЕ СИМВОЛЫ ====================
СИМВОЛЫ = {
    'квадрат': '■',
    'круг': '●',
    'ромб': '◆',
    'сердце': '♥',
    'звезда': '★',
    'галочка': '✓',
    'крестик': '✗',
    'стрелка_вверх': '↑',
    'стрелка_вниз': '↓',
    'стрелка_влево': '←',
    'стрелка_вправо': '→'
}

# ==================== КОНСТАНТЫ ====================
ПИ = 3.141592653589793
Е = 2.718281828459045
ИСТИНА = True
ЛОЖЬ = False
НЕТ = None

# ==================== ЭКСПОРТ ВСЕГО ====================
__all__ = [
    # Основные функции
    'Напечатать', 'Ввести', 'Длина', 'Тип', 'Диапазон', 'Список', 
    'Словарь', 'Множество', 'Кортеж', 'Строка', 'Целое', 'Дробное', 'Логическое',
    
    # Математические
    'Сумма', 'Максимум', 'Минимум', 'Абсолютное', 'Округлить', 'Степень',
    
    # Рисование
    'Линия', 'Прямоугольник', 'Треугольник', 'Рамка', 'ПрогрессБар', 'ОчиститьЭкран',
    
    # Файлы
    'ОткрытьФайл', 'ПрочитатьФайл', 'ЗаписатьВФайл',
    
    # Системные
    'Импортировать', 'Выполнить', 'Вычислить', 'Выйти',
    
    # Символы и константы
    'СИМВОЛЫ', 'ПИ', 'Е', 'ИСТИНА', 'ЛОЖЬ', 'НЕТ'
]
