import setuptools 

__version__ = '0.0.1'

setuptools.setup(
    name='PythonX27', 
    
    version=__version__, 
    description=u'PythonX27 is a powerful and intuitive module that extends the standard functions of Python by adding unique capabilities. With PythonX27, developers can perform complex tasks with greater precision and efficiency, alleviating concerns about the limitations of standard libraries. Designed with a focus on performance and ease of use, PythonX27 is an ideal choice for both professionals and newcomers.', 
    long_description=u"""PythonX27 is an extension for Python that offers developers innovative functions and solutions that are not available in the standard libraries. It was created to enhance the performance and accuracy of various tasks while maintaining an intuitive interface that easily integrates into existing projects.
Key benefits of PythonX27 include:
Enhanced Functions: PythonX27 provides functions that simplify the resolution of complex tasks, making them more accessible and efficient. You can expect unique data processing methods, algorithms, and utilities that significantly accelerate development.
High Accuracy: The module ensures high accuracy in calculations and data processing, which is especially important for tasks requiring strict adherence to conditions and criteria. PythonX27 includes validation mechanisms that minimize the risk of errors.
Ease of Use: PythonX27 has been designed with a focus on convenience and simplicity. Its interface is intuitive, allowing developers to quickly get accustomed to the library and start working right away.
Compatibility: PythonX27 easily integrates with existing Python projects, ensuring full compatibility with other libraries and tools. You can add PythonX27 functionality to your applications without the need for significant code changes.
Active Support and Development: The developer community is actively working on enhancing PythonX27, offering updates and new features based on user feedback. You can expect continuous development and support for your library.
With PythonX27, you gain a reliable tool for realizing your ideas, one that not only simplifies the development process but also opens up new horizons of possibilities.""", 
    
    author='Creatorofpythonx',
    author_email='organisator.bibliotek.py@gmail.com',

    license="""Permissions: You are free to use, modify, distribute, and incorporate PythonX27 into your projects, both commercial and non-commercial, as long as you retain the copyright notice and this license in all copies or substantial portions of the library.

Conditions:

You must provide attribution to the original authors of PythonX27 in any distributed software that uses this library.
Any modifications to PythonX27 must be documented and made clear.
Limitations: You may not use PythonX27 for any unlawful, harmful, or malicious purposes, including but not limited to:

Activities that could harm individuals or groups.
Development of malicious software or tools.
Any form of discrimination or harassment.
Disclaimer: The authors are not liable for any damages resulting from the use of PythonX27, whether direct or indirect.

By using PythonX27, you agree to the terms of this license.

===THIS MODULE IS UNDER DEVELOPMENT===
""", 
    packages=['PythonX27'], 
    classifiers=[
        'License :: OSI Approved :: Apache Software License', 
        'Operating System :: OS Independent',
        'Intended Audience :: End Users/Desktop', 
        'Intended Audience :: Developers',
        'Programming Language :: Python', 
        'Programming Language :: Python :: 3', 
        'Programming Language :: Python :: 3.12', 
        'Programming Language :: Python :: Implementation :: PyPy',
        'Programming Language :: Python :: Implementation :: CPython'
    ]

)