# mypy: ignore-errors
# Autogenerated schema file
# Tool: https://github.com/koxudaxi/datamodel-code-generator .

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field
from typing_extensions import Literal


class AcceptedResponse(BaseModel):
    """
    Response for the accepted trained model creation.

    Parameters
    ----------
    guid : GUID
        GUID of the trained model
    """

    model_config = ConfigDict(
        extra='allow',
    )
    training_parameters_guid: str = Field(..., title='Training Parameters Guid')
    dataset_guid: str = Field(..., title='Dataset Guid')
    qcog_version: str = Field(..., title='Qcog Version')
    guid: str = Field(..., title='Guid')


class OptimizationMethod(Enum):
    ADAM = 'ADAM'


class AdamOptimizationParameters(BaseModel):
    """
    Parameters for Adam optimization.

    Parameters
    ----------
    iterations : int
        This is how many gradient descent steps will be made before considering
        the state to have converged. Having more iterations and a lower
        learning rate corresponds to a better path through the energy
        landscape. So if you were to take 10 steps at `1e-3` learning rate that
        is more accurate, as we recompute our gradient 10 times, than a single
        step of `1e-2` learning rate. The recommended range is 3-10.

    step_size : float, default=1e-3
        The learning rate for the ADAM algorithm. This is the starting point
        which it will decay from. fixed and does not decay during optimization.
        Recommended values are around `1e-3`.

    epsilon : float, default=1e-8
        A small parameter that is used for numerical stability in the ADAM
        algorithm. Recommended values are around `1e-8`.

    first_moment_decay : float, default=0.9
        The first moment decay, eseentially scaling a term that is linear in
        the gradient. Recommended values are around `0.9`.


    second_moment_decay : float, default=0.999
        The second moment decay, essentially scaling a term that is
        quadratic in the gradient. Recommended values are around 0.999.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    optimization_method: Literal['ADAM'] = Field('ADAM', title='Optimization Method')
    iterations: int = Field(..., title='Iterations')
    step_size: Optional[float] = Field(0.001, title='Step Size')
    epsilon: Optional[float] = Field('1e-08', title='Epsilon')
    first_moment_decay: Optional[float] = Field(0.9, title='First Moment Decay')
    second_moment_decay: Optional[float] = Field(0.999, title='Second Moment Decay')


class StateMethod(Enum):
    EIGH = 'EIGH'


class EIGHStateParameters(BaseModel):
    """
    EIGH state method takes no parameters.

    ----------
    """

    model_config = ConfigDict(
        extra='allow',
    )
    learning_rate_axes: Optional[float] = Field(0.0, title='Learning Rate Axes')
    normalize_axes: Optional[bool] = Field(True, title='Normalize Axes')
    state_method: Literal['EIGH'] = Field('EIGH', title='State Method')


class StateMethod1(Enum):
    EIGS = 'EIGS'


class EIGSStateParameters(BaseModel):
    """
    EIGS state method takes no parameters.

    ----------
    """

    model_config = ConfigDict(
        extra='allow',
    )
    learning_rate_axes: Optional[float] = Field(0.0, title='Learning Rate Axes')
    normalize_axes: Optional[bool] = Field(True, title='Normalize Axes')
    state_method: Literal['EIGS'] = Field('EIGS', title='State Method')


class OptimizationMethod2(Enum):
    GRAD = 'GRAD'


class GradOptimizationParameters(BaseModel):
    """
    Parameters for gradient descent optimization.

    Parameters
    ----------
    iterations : int
        This is how many gradient descent steps will be made before considering
        the state to have converged. Having more iterations and a lower
        learning rate corresponds to a better path through the energy
        landscape. So if you were to take 10 steps at `1e-3` learning rate that
        is more accurate, as we recompute our gradient 10 times, than a single
        step of `1e-2` learning rate. The recommended range is 3-10.

    learning_rate : float
        The learning rate for the gradient descent algorithm.
        This is fixed and does not decay during optimization.
        Recommended values are around `1e-3`.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    optimization_method: Literal['GRAD'] = Field('GRAD', title='Optimization Method')
    iterations: int = Field(..., title='Iterations')
    learning_rate: float = Field(..., title='Learning Rate')


class StateMethod2(Enum):
    GRAD = 'GRAD'


class GradStateParameters(BaseModel):
    """
    Parameters for gradient descent optimization.

    ----------

    iterations : int
        This is how many gradient descent steps will be made before considering
        the state to have converged. Having more iterations and a lower
        learning rate corresponds to a better path through the energy
        landscape. So if you were to take 10 steps at `1e-3` learning rate
        that is more accurate, as we recompute our gradient 10 times, than a
        single step of `1e-2` learning rate. The recommended range is 3-10.

    learning_rate : float
        The learning rate for the gradient descent algorithm.
        This is fixed and does not decay during optimization. Recommended
        values are around `1e-3`.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    learning_rate_axes: Optional[float] = Field(0.0, title='Learning Rate Axes')
    normalize_axes: Optional[bool] = Field(True, title='Normalize Axes')
    iterations: int = Field(..., title='Iterations')
    learning_rate: float = Field(..., title='Learning Rate')
    state_method: Literal['GRAD'] = Field('GRAD', title='State Method')


class StateMethod3(Enum):
    LOBPCG_FAST = 'LOBPCG_FAST'


class LOBPCGFastStateParameters(BaseModel):
    """
    Parameters for the LOBPCG_FAST state method.

    Parameters
    ----------
    iterations : int
        The maximum number of iterations to run the LOBPCG algorithm for.
        You should think of this as a
        maximum number of internal iterations that are made to attempt the
        states to converge to within the tolerance. Both parameters work
        together, so if your tolerance is very large then you will need
        few iterations, so even if you set iteration count to 100 if it
        only takes 5 to converge to your tolerance only 5 iterations will
        be done. If your tolerance is very low but the iteration count is
        low then the algorithm will stop after the iteration count is
        reached, regardless of the tolerance. A good recommended range is
        5-20, noting that the more iterations you do the more accurate the
        state will be, but the more computationally expensive it will be.

    tol : float, default=0.2
        The tolerance for the LOBPCG algorithm. This is a relative tolerance
        and not an absolute one, so the units are arbitrary. Generally 0.2
        which is the default is a very loose tolerance. If you want to have
        the output from this method close to one of the more exact solvers
        then try `1e-4 -> 1e-8` for the tolerance. As per the above
        discussion you should also increase your iterations if you are
        decreasing your tolerance. The tolerance and iterations are more
        important for inference as the model will only pass over that data
        once.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    learning_rate_axes: Optional[float] = Field(0.0, title='Learning Rate Axes')
    normalize_axes: Optional[bool] = Field(True, title='Normalize Axes')
    iterations: int = Field(..., title='Iterations')
    tol: Optional[float] = Field(0.2, title='Tol')
    state_method: Literal['LOBPCG_FAST'] = Field('LOBPCG_FAST', title='State Method')


class StateMethod4(Enum):
    LOBPCB = 'LOBPCB'


class LOBPCGStateParameters(BaseModel):
    """
    Parameters for the LOBPCG state method.

    Parameters
    ----------
    iterations : int
        You should think of this as a maximum number of internal iterations
        that are made to attempt the states to converge to within the
        tolerance. Both parameters work together, so if your tolerance
        is very large then you will need few iterations, so even if you
        set iteration count to 100 if it only takes 5 to converge to your
        tolerance only 5 iterations will be done. If your tolerance is very
        low but the iteration count is low then the algorithm will stop
        after the iteration count is reached, regardless of the tolerance.
        A good recommended range is 5-20, noting that the more iterations
        you do the more accurate the state will be, but the more
        computationally expensive it will be.

    tol : float, default=0.2
        This is a relative tolerance and not an absolute one, so the units are
        arbitrary. Generally 0.2 which is the default is a very loose
        tolerance. If you want to have the output from this method close to
        one of the more exact solvers then try `1e-4 -> 1e-8` for the
        tolerance. As per the above discussion you should also increase your
        iterations if you are decreasing your tolerance. The tolerance and
        iterations are more important for inference as the model will only
        pass over that data once.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    learning_rate_axes: Optional[float] = Field(0.0, title='Learning Rate Axes')
    normalize_axes: Optional[bool] = Field(True, title='Normalize Axes')
    iterations: int = Field(..., title='Iterations')
    tol: Optional[float] = Field(0.2, title='Tol')
    state_method: Literal['LOBPCB'] = Field('LOBPCB', title='State Method')


class Model(Enum):
    """
    List of available models.
    """

    pauli = 'pauli'
    ensemble = 'ensemble'
    general = 'general'


class ModelName(Enum):
    ensemble = 'ensemble'


class ModelEnsembleParameters(BaseModel):
    """
    Parameters for the ensemble model.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    operators: List[str] = Field(..., title='Operators')
    dim: int = Field(..., title='Dim')
    num_axes: int = Field(..., title='Num Axes')
    sigma_sq: Union[float, Dict[str, float]] = Field(..., title='Sigma Sq')
    sigma_sq_optimization_kwargs: Dict[str, Any] = Field(
        ..., title='Sigma Sq Optimization Kwargs'
    )
    seed: int = Field(..., title='Seed')
    target_operators: List[str] = Field(..., title='Target Operators')
    model_name: Literal['ensemble'] = Field('ensemble', title='Model Name')


class ModelName1(Enum):
    general = 'general'


class ModelGeneralParameters(BaseModel):
    """
    Parameters for the general model.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    operators: List[str] = Field(..., title='Operators')
    dims: int = Field(..., title='Dims')
    sigma_sq: Union[float, Dict[str, float]] = Field(..., title='Sigma Sq')
    seed: int = Field(..., title='Seed')
    target_operators: List[str] = Field(..., title='Target Operators')
    model_name: Literal['general'] = Field('general', title='Model Name')


class ModelName2(Enum):
    pauli = 'pauli'


class ModelPauliParameters(BaseModel):
    """
    Parameters for the Pauli model.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    operators: List[str] = Field(..., title='Operators')
    qbits: int = Field(..., title='Qbits')
    pauli_weight: int = Field(..., title='Pauli Weight')
    sigma_sq: Union[float, Dict[str, float]] = Field(..., title='Sigma Sq')
    sigma_sq_optimization_kwargs: Dict[str, Any] = Field(
        ..., title='Sigma Sq Optimization Kwargs'
    )
    seed: int = Field(..., title='Seed')
    target_operators: List[str] = Field(..., title='Target Operators')
    model_name: Literal['pauli'] = Field('pauli', title='Model Name')


class StateMethod5(Enum):
    NP_EIGH = 'NP_EIGH'


class NPEIGHStateParameters(BaseModel):
    """
    NP_EIGH state method takes no parameters.

    ----------
    """

    model_config = ConfigDict(
        extra='allow',
    )
    learning_rate_axes: Optional[float] = Field(0.0, title='Learning Rate Axes')
    normalize_axes: Optional[bool] = Field(True, title='Normalize Axes')
    state_method: Literal['NP_EIGH'] = Field('NP_EIGH', title='State Method')


class OptimizationMethodModel(Enum):
    """
    Enum definition for the optimization methods.
    """

    GRAD = 'GRAD'
    ADAM = 'ADAM'
    ANALYTIC = 'ANALYTIC'


class StateMethod6(Enum):
    POWER_ITER = 'POWER_ITER'


class PowerIterStateParameters(BaseModel):
    """
    Parameters for the POWER_ITER state method.

    Parameters
    ----------
    iterations: int
        The maximum number of iterations to run the LOBPCG algorithm for.
        You should think of this as a
        maximum number of internal iterations that are made to attempt the
        states to converge to within the tolerance. Both parameters work
        together, so if your tolerance is very large then you will need
        few iterations, so even if you set iteration count to 100 if it
        only takes 5 to converge to your tolerance only 5 iterations will
        be done. If your tolerance is very low but the iteration count is
        low then the algorithm will stop after the iteration count is
        reached, regardless of the tolerance. A good recommended range is
        5-20, noting that the more iterations you do the more accurate the
        state will be, but the more computationally expensive it will be.

    tol : float, default=0.2
        The tolerance for the LOBPCG algorithm. This is a relative tolerance
        and not an absolute one, so the units are arbitrary. Generally 0.2
        which is the default is a very loose tolerance. If you want to have
        the output from this method close to one of the more exact solvers
        then try `1e-4 -> 1e-8` for the tolerance. As per the above
        discussion you should also increase your iterations if you are
        decreasing your tolerance. The tolerance and iterations are more
        important for inference as the model will only pass over that data
        once.

    max_eig_iter : int, default=5
        The number of iterations to execute to find the largest eigenvalue,
        which is used as a parameter in a spectral shift to find the
        smallest eigenvalue. 5 is generally a good default.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    learning_rate_axes: Optional[float] = Field(0.0, title='Learning Rate Axes')
    normalize_axes: Optional[bool] = Field(True, title='Normalize Axes')
    iterations: int = Field(..., title='Iterations')
    tol: Optional[float] = Field(0.2, title='Tol')
    max_eig_iter: Optional[int] = Field(5, title='Max Eig Iter')
    state_method: Literal['POWER_ITER'] = Field('POWER_ITER', title='State Method')


class TrainingStatus(Enum):
    """
    Enum for training status.
    """

    pending = 'pending'
    processing = 'processing'
    failed = 'failed'
    completed = 'completed'
    canceled = 'canceled'
    canceled_pending = 'canceled_pending'
    unknown = 'unknown'


class ValidationError(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    loc: List[Union[str, int]] = Field(..., title='Location')
    msg: str = Field(..., title='Message')
    type: str = Field(..., title='Error Type')


class AppSchemasDataPayloadDataPayloadInput(BaseModel):
    """
    Endpoint Input to create a dataset.

    Parameters
    ----------
    format : str
        Format of the dataset

    source : str
        Source of the dataset

    project_guid : GUID
        GUID of the project

    data : str
        Data of the dataset serialized as a string
    """

    model_config = ConfigDict(
        extra='allow',
    )
    format: str = Field(..., title='Format')
    source: str = Field(..., title='Source')
    project_guid: Optional[str] = Field(None, title='Project Guid')
    data: str = Field(..., title='Data')


class AppSchemasDataPayloadDataPayloadResponse(BaseModel):
    """
    API Response for a dataset.

    Parameters
    ----------
    guid : GUID
        GUID of the dataset

    format : str
        Format of the dataset

    source : str
        Source of the dataset

    project_guid : GUID
        GUID of the project
    """

    model_config = ConfigDict(
        extra='allow',
    )
    format: str = Field(..., title='Format')
    source: str = Field(..., title='Source')
    project_guid: Optional[str] = Field(None, title='Project Guid')
    guid: str = Field(..., title='Guid')


class AppSchemasInferenceInferencePayloadInput(BaseModel):
    """
    API Input to perform the inference.

    Parameters
    ----------
    data : str
        Data to perform the inference on in serialized format.

    parameters : StateParams
        State optimization parameters.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    data: str = Field(..., title='Data')
    parameters: Union[
        LOBPCGFastStateParameters,
        PowerIterStateParameters,
        EIGHStateParameters,
        EIGSStateParameters,
        NPEIGHStateParameters,
        GradStateParameters,
        LOBPCGStateParameters,
    ] = Field(..., title='Parameters')


class AppSchemasInferenceInferencePayloadResponse(BaseModel):
    """
    Response for the inference.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    response: Dict[str, Any] = Field(..., title='Response')


class AppSchemasProjectProjectPayloadInput(BaseModel):
    """
    Endpoint Input to create a project.

    Parameters
    ----------
    bucket_name : str
        Name of the S3 bucket

    name : str
        Name of the project

    org : str
        Name of the organization

    api_secret_name : str
        Name of the API secret
    """

    model_config = ConfigDict(
        extra='allow',
    )
    bucket_name: str = Field(..., title='Bucket Name')
    name: str = Field(..., title='Name')
    org: str = Field(..., title='Org')
    api_secret_name: str = Field(..., title='Api Secret Name')


class AppSchemasProjectProjectPayloadResponse(BaseModel):
    """
    Response for the created project.

    Parameters
    ----------
    guid : GUID
        GUID of the project

    bucket_name : str
        Name of the S3 bucket

    name : str
        Name of the project

    org : str
        Name of the organization

    api_secret_name : str
        Name of the API secret
    """

    model_config = ConfigDict(
        extra='allow',
    )
    bucket_name: str = Field(..., title='Bucket Name')
    name: str = Field(..., title='Name')
    org: str = Field(..., title='Org')
    api_secret_name: str = Field(..., title='Api Secret Name')
    guid: str = Field(..., title='Guid')


class AppSchemasTrainTrainedModelPayloadInput(BaseModel):
    """
    Endpoint Input to create a trained model.

    Parameters
    ----------
    training_parameters_guid : GUID
        GUID of the training parameters

    dataset_guid : GUID
        GUID of the dataset

    qcog_version : str
        Version of the QCoG used for training

    project_guid : GUID
        GUID of the project
    """

    model_config = ConfigDict(
        extra='allow',
    )
    training_parameters_guid: str = Field(..., title='Training Parameters Guid')
    dataset_guid: str = Field(..., title='Dataset Guid')
    qcog_version: str = Field(..., title='Qcog Version')
    project_guid: Optional[str] = Field(None, title='Project Guid')


class AppSchemasTrainTrainedModelPayloadResponse(BaseModel):
    """
    Response for the trained model creation.

    Parameters
    ----------
    guid : GUID
        GUID of the trained model

    status : str
        Status of the trained model
    """

    model_config = ConfigDict(
        extra='allow',
    )
    training_parameters_guid: str = Field(..., title='Training Parameters Guid')
    dataset_guid: str = Field(..., title='Dataset Guid')
    qcog_version: str = Field(..., title='Qcog Version')
    guid: str = Field(..., title='Guid')
    status: TrainingStatus
    loss: Optional[List[List[Union[float, int, Any]]]] = Field(None, title='Loss')


class AnalyticOptimizationParameters(BaseModel):
    """
    Analytic optimizer.

    The analytic optimizer is a closed form solution to the internal
    weight matrix in our model. The analytic optimizer takes no parameters.

    ----------
    """

    model_config = ConfigDict(
        extra='allow',
    )
    optimization_method: Optional[OptimizationMethodModel] = 'ANALYTIC'


class HTTPValidationError(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    detail: Optional[List[ValidationError]] = Field(None, title='Detail')


class TrainingParametersInput(BaseModel):
    """
    Parameters for training a model.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    batch_size: int = Field(..., title='Batch Size')
    num_passes: int = Field(..., title='Num Passes')
    model: Union[
        ModelGeneralParameters, ModelEnsembleParameters, ModelPauliParameters
    ] = Field(..., title='Model')
    weight_optimization_kwargs: Union[
        GradOptimizationParameters,
        AdamOptimizationParameters,
        AnalyticOptimizationParameters,
    ] = Field(..., title='Weight Optimization Kwargs')
    state_kwargs: Union[
        LOBPCGFastStateParameters,
        PowerIterStateParameters,
        EIGHStateParameters,
        EIGSStateParameters,
        NPEIGHStateParameters,
        GradStateParameters,
        LOBPCGStateParameters,
    ] = Field(..., title='State Kwargs')


class TrainingParametersOutput(BaseModel):
    """
    Parameters for training a model.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    batch_size: int = Field(..., title='Batch Size')
    num_passes: int = Field(..., title='Num Passes')
    model: Union[
        ModelGeneralParameters, ModelEnsembleParameters, ModelPauliParameters
    ] = Field(..., title='Model')
    weight_optimization_kwargs: Union[
        GradOptimizationParameters,
        AdamOptimizationParameters,
        AnalyticOptimizationParameters,
    ] = Field(..., title='Weight Optimization Kwargs')
    state_kwargs: Union[
        LOBPCGFastStateParameters,
        PowerIterStateParameters,
        EIGHStateParameters,
        EIGSStateParameters,
        NPEIGHStateParameters,
        GradStateParameters,
        LOBPCGStateParameters,
    ] = Field(..., title='State Kwargs')


class AppSchemasParametersTrainingParametersPayloadInput(BaseModel):
    """
    Endpoint Input to create a trained model.

    Parameters
    ----------
    batch_size : int
        Batch size for the training data.

    num_passes : int
        Number of passes over the training data.

    model : Model
        Model to train.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    parameters: TrainingParametersInput
    model: Model
    artifact_filename: Optional[str] = Field(None, title='Artifact Filename')
    project_guid: Optional[str] = Field(None, title='Project Guid')


class AppSchemasParametersTrainingParametersPayloadResponse(BaseModel):
    """
    API response for the Model api.
    """

    model_config = ConfigDict(
        extra='allow',
    )
    guid: str = Field(..., title='Guid')
    model: Model
    parameters: TrainingParametersOutput
