"""
Do not import this file, it has no exports.
It is only here to represent the structure of the rust source code 1:1
"""

from typing import List, Optional


class RegisterData:
    """
    Values present in a register that are one of a set of variants.

    Variants:
        - ``i8``: Corresponds to the Quil `BIT` or `OCTET` types.
        - ``i16``: Corresponds to the Quil `INTEGER` type.
        - ``f64``: Corresponds to the Quil `REAL` type.
        - ``complex32``: Results containing complex numbers.

    Methods (each per variant):
        - ``is_*``: if the underlying values are that type.
        - ``as_*``: if the underlying values are that type, then those values, otherwise ``None``.
        - ``to_*``: the underlying values as that type, raises ``ValueError`` if they are not.
        - ``from_*``: wrap underlying values as this enum type.

    """
    
    def is_i8(self) -> bool: ...
    def is_i16(self) -> bool: ...
    def is_f64(self) -> bool: ...
    def is_complex32(self) -> bool: ...

    def as_i8(self) -> Optional[List[List[int]]]: ...
    def as_i16(self) -> Optional[List[List[int]]]: ...
    def as_f64(self) -> Optional[List[List[float]]]: ...
    def as_complex32(self) -> Optional[List[List[complex]]]: ...

    def to_i8(self) -> List[List[int]]: ...
    def to_i16(self) -> List[List[int]]: ...
    def to_f64(self) -> List[List[float]]: ...
    def to_complex32(self) -> List[List[complex]]: ...

    @staticmethod
    def from_i8(inner: List[List[int]]) -> "RegisterData": ...
    @staticmethod
    def from_i16(inner: List[List[int]]) -> "RegisterData": ...
    @staticmethod
    def from_f64(inner: List[List[float]]) -> "RegisterData": ...
    @staticmethod
    def from_complex32(inner: List[List[complex]]) -> "RegisterData": ...
