# quantitative-trading-python-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0
- Package version: 1.0.0
- Generator version: 7.12.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import quantitative_trading_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import quantitative_trading_python_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import quantitative_trading_python_client
from quantitative_trading_python_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:8080
# See configuration.py for a list of all supported configuration parameters.
configuration = quantitative_trading_python_client.Configuration(
    host = "http://localhost:8080"
)



# Enter a context with an instance of the API client
with quantitative_trading_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = quantitative_trading_python_client.MarketDataControllerApi(api_client)

    try:
        api_response = api_instance.get_stocks()
        print("The response of MarketDataControllerApi->get_stocks:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling MarketDataControllerApi->get_stocks: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MarketDataControllerApi* | [**get_stocks**](docs/MarketDataControllerApi.md#get_stocks) | **POST** /api/v1/getStocks | 
*PortfolioControllerApi* | [**liquidate_portfolio**](docs/PortfolioControllerApi.md#liquidate_portfolio) | **POST** /api/v1/liquidatePortfolio | 
*PortfolioControllerApi* | [**order_history**](docs/PortfolioControllerApi.md#order_history) | **GET** /api/v1/orderHistory | 
*PortfolioControllerApi* | [**portfolio_history**](docs/PortfolioControllerApi.md#portfolio_history) | **GET** /api/v1/portfolioHistory | 
*PortfolioControllerApi* | [**rebalance_portfolio**](docs/PortfolioControllerApi.md#rebalance_portfolio) | **POST** /api/v1/rebalancePortfolio | 


## Documentation For Models

 - [AccountDto](docs/AccountDto.md)
 - [OrderDto](docs/OrderDto.md)
 - [PortfolioDto](docs/PortfolioDto.md)
 - [PositionDto](docs/PositionDto.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




