from typing import Callable

class QueueOperation:
    def __init__(self, queue_path: str): ...
    def init_db(self) -> None: ...
    def enqueue(self, message: dict) -> str: ...
    def dequeue(self, size: int = 1) -> list[dict]: ...
    def get_queue_length(self) -> int: ...
    def get_completed_messages(self) -> list[dict]: ...
    def get_result(self, id: str) -> dict: ...
    def update_status(self, id: str, status: str) -> None: ...
    def update_result(self, id: str, result: str) -> None: ...
    def delete_message(self, id: str) -> None: ...
    def clean_expired_messages(self) -> None: ...
    def clean_old_messages(self, days: int) -> None: ...
    def remove_expired_messages(self, days: int) -> None: ...

class ShardedQueueOperation:
    @property
    def db_dir(self) -> str: ...
    def __init__(self, shard_num: int, queue_name: str): ...
    def _get_shard_index(self, message_id: str) -> int: ...
    def enqueue(self, message: dict) -> str: ...
    def dequeue(self, size: int = 1) -> list[dict]: ...
    def get_queue_length(self) -> int: ...
    def get_completed_messages(self) -> list[dict]: ...
    def get_result(self, id: str) -> dict: ...
    def update_status(self, id: str, status: str) -> None: ...
    def update_result(self, id: str, result: str) -> None: ...
    def delete_message(self, id: str) -> None: ...
    def clean_expired_messages(self) -> None: ...
    def clean_old_messages(self, days: int) -> None: ...
    def remove_expired_messages(self, days: int) -> None: ...

class TaskMounter:
    def __init__(self, task_mounter_class: type): ...
    def get_task_list(self) -> list[str]: ...
    def get_task_function(self, task_name: str) -> Callable: ...
