import quickfix as fix

class Message(fix.Message):
	def __init__(self):
		fix.Message.__init__(self)
		self.getHeader().setField( fix.BeginString("FIXT.1.1") )
		self.getHeader().setField( fix.ApplVerID("9") )

class IOI(Message):
	def __init__(self):
		Message.__init__(self)
		self.getHeader().setField( fix.MsgType("6") )

	class NoSecurityAltID(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 455
			order[1] = 456
			order[2] = 2957
			order[3] = 0
			fix.Group.__init__(self, 454, 455, order)

	class NoSecondaryAssetClasses(fix.Group):
		def __init__(self):
			order = fix.IntArray(5)
			order[0] = 1977
			order[1] = 1978
			order[2] = 1979
			order[3] = 2741
			order[4] = 0
			fix.Group.__init__(self, 1976, 1977, order)

	class NoAssetAttributes(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 2305
			order[1] = 2306
			order[2] = 2307
			order[3] = 0
			fix.Group.__init__(self, 2304, 2305, order)

	class NoEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(11)
			order[0] = 865
			order[1] = 866
			order[2] = 1145
			order[3] = 1827
			order[4] = 1826
			order[5] = 2340
			order[6] = 867
			order[7] = 868
			order[8] = 1578
			order[9] = 1579
			order[10] = 0
			fix.Group.__init__(self, 864, 865, order)

	class NoInstrumentParties(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1019
			order[1] = 1050
			order[2] = 1051
			order[3] = 2378
			order[4] = 1052
			order[5] = 0
			fix.Group.__init__(self, 1018, 1019, order)

		class NoInstrumentPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 1053
				order[1] = 1054
				order[2] = 0
				fix.Group.__init__(self, 1052, 1053, order)

	class NoComplexEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(53)
			order[0] = 1484
			order[1] = 2117
			order[2] = 2118
			order[3] = 2119
			order[4] = 1485
			order[5] = 2120
			order[6] = 2121
			order[7] = 2122
			order[8] = 2941
			order[9] = 1486
			order[10] = 2123
			order[11] = 1487
			order[12] = 1488
			order[13] = 1489
			order[14] = 1490
			order[15] = 1491
			order[16] = 2124
			order[17] = 2942
			order[18] = 2125
			order[19] = 2943
			order[20] = 2126
			order[21] = 2127
			order[22] = 2407
			order[23] = 2408
			order[24] = 2128
			order[25] = 2129
			order[26] = 2130
			order[27] = 2131
			order[28] = 2132
			order[29] = 41013
			order[30] = 41020
			order[31] = 41021
			order[32] = 41022
			order[33] = 41023
			order[34] = 41024
			order[35] = 41025
			order[36] = 41026
			order[37] = 41027
			order[38] = 41028
			order[39] = 41010
			order[40] = 2133
			order[41] = 2134
			order[42] = 2135
			order[43] = 2136
			order[44] = 2137
			order[45] = 41029
			order[46] = 40997
			order[47] = 2597
			order[48] = 2598
			order[49] = 2599
			order[50] = 2138
			order[51] = 2139
			order[52] = 0
			fix.Group.__init__(self, 1483, 1484, order)

		class NoComplexEventDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 1492
				order[1] = 1493
				order[2] = 1494
				order[3] = 0
				fix.Group.__init__(self, 1491, 1492, order)

			class NoComplexEventTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1495
					order[1] = 1496
					order[2] = 0
					fix.Group.__init__(self, 1494, 1495, order)

		class NoComplexEventRateSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 41014
				order[1] = 41015
				order[2] = 41016
				order[3] = 41017
				order[4] = 0
				fix.Group.__init__(self, 41013, 41014, order)

		class NoComplexEventDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41019
				order[1] = 0
				fix.Group.__init__(self, 41018, 41019, order)

		class NoComplexEventPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41011
				order[1] = 41012
				order[2] = 41031
				order[3] = 41007
				order[4] = 40994
				order[5] = 0
				fix.Group.__init__(self, 41010, 41011, order)

			class NoComplexEventSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41032
					order[1] = 41033
					order[2] = 41034
					order[3] = 41035
					order[4] = 41036
					order[5] = 0
					fix.Group.__init__(self, 41031, 41032, order)

			class NoComplexEventPeriodDateTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41008
					order[1] = 41009
					order[2] = 0
					fix.Group.__init__(self, 41007, 41008, order)

			class NoComplexEventAveragingObservations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40995
					order[1] = 40996
					order[2] = 0
					fix.Group.__init__(self, 40994, 40995, order)

		class NoComplexEventCreditEventSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41030
				order[1] = 0
				fix.Group.__init__(self, 41029, 41030, order)

		class NoComplexEventCreditEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40998
				order[1] = 40999
				order[2] = 41000
				order[3] = 41001
				order[4] = 41002
				order[5] = 41003
				order[6] = 41004
				order[7] = 41005
				order[8] = 0
				fix.Group.__init__(self, 40997, 40998, order)

			class NoComplexEventCreditEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41006
					order[1] = 0
					fix.Group.__init__(self, 41005, 41006, order)

	class NoBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40471
			order[1] = 0
			fix.Group.__init__(self, 40278, 40471, order)

	class NoPricingDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41231
			order[1] = 0
			fix.Group.__init__(self, 41230, 41231, order)

	class NoMarketDisruptionEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41093
			order[1] = 40991
			order[2] = 0
			fix.Group.__init__(self, 41092, 41093, order)

	class NoMarketDisruptionFallbacks(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41095
			order[1] = 40992
			order[2] = 0
			fix.Group.__init__(self, 41094, 41095, order)

	class NoMarketDisruptionFallbackReferencePrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(10)
			order[0] = 41097
			order[1] = 41098
			order[2] = 41099
			order[3] = 41100
			order[4] = 41101
			order[5] = 41102
			order[6] = 41103
			order[7] = 41104
			order[8] = 41105
			order[9] = 0
			fix.Group.__init__(self, 41096, 41097, order)

	class NoSettlMethodElectionDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 42776
			order[1] = 0
			fix.Group.__init__(self, 42775, 42776, order)

	class NoOptionExerciseBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41117
			order[1] = 0
			fix.Group.__init__(self, 41116, 41117, order)

	class NoOptionExerciseDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41138
			order[1] = 41139
			order[2] = 0
			fix.Group.__init__(self, 41137, 41138, order)

	class NoOptionExerciseExpirationDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41141
			order[1] = 0
			fix.Group.__init__(self, 41140, 41141, order)

	class NoOptionExerciseExpirationDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41153
			order[1] = 41154
			order[2] = 0
			fix.Group.__init__(self, 41152, 41153, order)

	class NoStreams(fix.Group):
		def __init__(self):
			order = fix.IntArray(135)
			order[0] = 40050
			order[1] = 41303
			order[2] = 40051
			order[3] = 42784
			order[4] = 42785
			order[5] = 40052
			order[6] = 40053
			order[7] = 41305
			order[8] = 40054
			order[9] = 40055
			order[10] = 42786
			order[11] = 42787
			order[12] = 41306
			order[13] = 41307
			order[14] = 41308
			order[15] = 41309
			order[16] = 41310
			order[17] = 41311
			order[18] = 41251
			order[19] = 41252
			order[20] = 41253
			order[21] = 41254
			order[22] = 41255
			order[23] = 41256
			order[24] = 41257
			order[25] = 42587
			order[26] = 41258
			order[27] = 41259
			order[28] = 41260
			order[29] = 41261
			order[30] = 41262
			order[31] = 41263
			order[32] = 41264
			order[33] = 41265
			order[34] = 41266
			order[35] = 41267
			order[36] = 41268
			order[37] = 41269
			order[38] = 41270
			order[39] = 41271
			order[40] = 41272
			order[41] = 41273
			order[42] = 41274
			order[43] = 41275
			order[44] = 41276
			order[45] = 40907
			order[46] = 40908
			order[47] = 40910
			order[48] = 40911
			order[49] = 40912
			order[50] = 40913
			order[51] = 40914
			order[52] = 40065
			order[53] = 40066
			order[54] = 40068
			order[55] = 40069
			order[56] = 40070
			order[57] = 40071
			order[58] = 40072
			order[59] = 41244
			order[60] = 41245
			order[61] = 40073
			order[62] = 40075
			order[63] = 40076
			order[64] = 40078
			order[65] = 40079
			order[66] = 40080
			order[67] = 40081
			order[68] = 40082
			order[69] = 40083
			order[70] = 40084
			order[71] = 41246
			order[72] = 41247
			order[73] = 41248
			order[74] = 40738
			order[75] = 40739
			order[76] = 40740
			order[77] = 42600
			order[78] = 40741
			order[79] = 40742
			order[80] = 43106
			order[81] = 40743
			order[82] = 40744
			order[83] = 40745
			order[84] = 40746
			order[85] = 40747
			order[86] = 42601
			order[87] = 42602
			order[88] = 42603
			order[89] = 42604
			order[90] = 40748
			order[91] = 40749
			order[92] = 40750
			order[93] = 41180
			order[94] = 41181
			order[95] = 41182
			order[96] = 41183
			order[97] = 41184
			order[98] = 41185
			order[99] = 41186
			order[100] = 42605
			order[101] = 40828
			order[102] = 40872
			order[103] = 41058
			order[104] = 41059
			order[105] = 41060
			order[106] = 41061
			order[107] = 41062
			order[108] = 42192
			order[109] = 42193
			order[110] = 41063
			order[111] = 41064
			order[112] = 41065
			order[113] = 41066
			order[114] = 41067
			order[115] = 41218
			order[116] = 41068
			order[117] = 41069
			order[118] = 41070
			order[119] = 41071
			order[120] = 41072
			order[121] = 41073
			order[122] = 41074
			order[123] = 41075
			order[124] = 41076
			order[125] = 41077
			order[126] = 41078
			order[127] = 41079
			order[128] = 41080
			order[129] = 43094
			order[130] = 41037
			order[131] = 40056
			order[132] = 40982
			order[133] = 40983
			order[134] = 0
			fix.Group.__init__(self, 40049, 40050, order)

		class NoStreamCommodityAltIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41278
				order[1] = 41279
				order[2] = 0
				fix.Group.__init__(self, 41277, 41278, order)

		class NoStreamAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41238
				order[1] = 41239
				order[2] = 41240
				order[3] = 0
				fix.Group.__init__(self, 41237, 41238, order)

		class NoStreamCommodityDataSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41281
				order[1] = 41282
				order[2] = 0
				fix.Group.__init__(self, 41280, 41281, order)

		class NoStreamCommoditySettlBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41250
				order[1] = 0
				fix.Group.__init__(self, 41249, 41250, order)

		class NoStreamCommoditySettlPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41290
				order[1] = 41291
				order[2] = 41292
				order[3] = 41293
				order[4] = 41294
				order[5] = 41295
				order[6] = 41296
				order[7] = 41297
				order[8] = 41298
				order[9] = 41299
				order[10] = 41300
				order[11] = 41283
				order[12] = 41301
				order[13] = 41302
				order[14] = 0
				fix.Group.__init__(self, 41289, 41290, order)

			class NoStreamCommoditySettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41284
					order[1] = 41285
					order[2] = 41286
					order[3] = 0
					fix.Group.__init__(self, 41283, 41284, order)

				class NoStreamCommoditySettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41287
						order[1] = 41288
						order[2] = 41588
						order[3] = 0
						fix.Group.__init__(self, 41286, 41287, order)

		class NoStreamEffectiveDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40909
				order[1] = 0
				fix.Group.__init__(self, 40960, 40909, order)

		class NoStreamTerminationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40067
				order[1] = 0
				fix.Group.__init__(self, 40961, 40067, order)

		class NoStreamCalculationPeriodBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40074
				order[1] = 0
				fix.Group.__init__(self, 40958, 40074, order)

		class NoStreamCalculationPeriodDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41242
				order[1] = 41243
				order[2] = 0
				fix.Group.__init__(self, 41241, 41242, order)

		class NoStreamFirstPeriodStartDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40077
				order[1] = 0
				fix.Group.__init__(self, 40959, 40077, order)

		class NoPaymentStreamPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40752
				order[1] = 0
				fix.Group.__init__(self, 40947, 40752, order)

		class NoPaymentStreamPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41221
				order[1] = 41222
				order[2] = 0
				fix.Group.__init__(self, 41220, 41221, order)

		class NoPaymentStreamResetDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40763
				order[1] = 0
				fix.Group.__init__(self, 40948, 40763, order)

		class NoPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40769
				order[1] = 0
				fix.Group.__init__(self, 40949, 40769, order)

		class NoPaymentStreamFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40776
				order[1] = 0
				fix.Group.__init__(self, 40950, 40776, order)

		class NoPaymentStreamFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42661
				order[1] = 42662
				order[2] = 0
				fix.Group.__init__(self, 42660, 42661, order)

		class NoPaymentStreamPricingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41193
				order[1] = 0
				fix.Group.__init__(self, 41192, 41193, order)

		class NoPaymentStreamPricingDays(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41228
				order[1] = 41229
				order[2] = 0
				fix.Group.__init__(self, 41227, 41228, order)

		class NoPaymentStreamPricingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41225
				order[1] = 41226
				order[2] = 0
				fix.Group.__init__(self, 41224, 41225, order)

		class NoPaymentStreamFormulas(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 43109
				order[1] = 42684
				order[2] = 42685
				order[3] = 0
				fix.Group.__init__(self, 42683, 43109, order)

		class NoDividendPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(21)
				order[0] = 42275
				order[1] = 42276
				order[2] = 42277
				order[3] = 42278
				order[4] = 42279
				order[5] = 42280
				order[6] = 42294
				order[7] = 42281
				order[8] = 42282
				order[9] = 42283
				order[10] = 42284
				order[11] = 42285
				order[12] = 42286
				order[13] = 42287
				order[14] = 42288
				order[15] = 42289
				order[16] = 42290
				order[17] = 42291
				order[18] = 42292
				order[19] = 42293
				order[20] = 0
				fix.Group.__init__(self, 42274, 42275, order)

			class NoDividendPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42295
					order[1] = 0
					fix.Group.__init__(self, 42294, 42295, order)

		class NoDividendFXTriggerDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42273
				order[1] = 0
				fix.Group.__init__(self, 42272, 42273, order)

		class NoDividendAccrualPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42237
				order[1] = 0
				fix.Group.__init__(self, 42236, 42237, order)

		class NoReturnRates(fix.Group):
			def __init__(self):
				order = fix.IntArray(30)
				order[0] = 42736
				order[1] = 42737
				order[2] = 42738
				order[3] = 42739
				order[4] = 42740
				order[5] = 42741
				order[6] = 42765
				order[7] = 42731
				order[8] = 42742
				order[9] = 42743
				order[10] = 42744
				order[11] = 42745
				order[12] = 42746
				order[13] = 42747
				order[14] = 42748
				order[15] = 42749
				order[16] = 42750
				order[17] = 42751
				order[18] = 42752
				order[19] = 42753
				order[20] = 42761
				order[21] = 42754
				order[22] = 42755
				order[23] = 42709
				order[24] = 42756
				order[25] = 42757
				order[26] = 42758
				order[27] = 42759
				order[28] = 42760
				order[29] = 0
				fix.Group.__init__(self, 42735, 42736, order)

			class NoReturnRatePrices(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 42766
					order[1] = 42767
					order[2] = 42768
					order[3] = 42769
					order[4] = 0
					fix.Group.__init__(self, 42765, 42766, order)

			class NoReturnRateFXConversions(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42732
					order[1] = 42733
					order[2] = 42734
					order[3] = 0
					fix.Group.__init__(self, 42731, 42732, order)

			class NoReturnRateInformationSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42762
					order[1] = 42763
					order[2] = 42764
					order[3] = 0
					fix.Group.__init__(self, 42761, 42762, order)

			class NoReturnRateDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(24)
					order[0] = 42710
					order[1] = 42772
					order[2] = 42711
					order[3] = 42712
					order[4] = 42713
					order[5] = 42714
					order[6] = 42715
					order[7] = 42716
					order[8] = 42717
					order[9] = 42718
					order[10] = 42719
					order[11] = 42720
					order[12] = 42721
					order[13] = 42722
					order[14] = 42723
					order[15] = 42724
					order[16] = 42725
					order[17] = 42726
					order[18] = 42727
					order[19] = 42728
					order[20] = 42729
					order[21] = 42730
					order[22] = 42770
					order[23] = 0
					fix.Group.__init__(self, 42709, 42710, order)

				class NoReturnRateValuationDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42773
						order[1] = 42774
						order[2] = 0
						fix.Group.__init__(self, 42772, 42773, order)

				class NoReturnRateValuationDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42771
						order[1] = 0
						fix.Group.__init__(self, 42770, 42771, order)

		class NoPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42621
				order[1] = 0
				fix.Group.__init__(self, 42620, 42621, order)

		class NoPaymentStreamCompoundingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42607
				order[1] = 42608
				order[2] = 0
				fix.Group.__init__(self, 42606, 42607, order)

		class NoPaymentStreamNonDeliverableFixingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40819
				order[1] = 0
				fix.Group.__init__(self, 40946, 40819, order)

		class NoNonDeliverableFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40826
				order[1] = 40827
				order[2] = 0
				fix.Group.__init__(self, 40825, 40826, order)

		class NoSettlRateFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40086
				order[1] = 40373
				order[2] = 40655
				order[3] = 40088
				order[4] = 40089
				order[5] = 0
				fix.Group.__init__(self, 40085, 40086, order)

		class NoPaymentSchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(58)
				order[0] = 40829
				order[1] = 41164
				order[2] = 41165
				order[3] = 40830
				order[4] = 40831
				order[5] = 40832
				order[6] = 40833
				order[7] = 40834
				order[8] = 40835
				order[9] = 40836
				order[10] = 40837
				order[11] = 40838
				order[12] = 40839
				order[13] = 41166
				order[14] = 41167
				order[15] = 41168
				order[16] = 41169
				order[17] = 40840
				order[18] = 40841
				order[19] = 40842
				order[20] = 40843
				order[21] = 41170
				order[22] = 41171
				order[23] = 41172
				order[24] = 41173
				order[25] = 40844
				order[26] = 40845
				order[27] = 40846
				order[28] = 40847
				order[29] = 40848
				order[30] = 40849
				order[31] = 40868
				order[32] = 40850
				order[33] = 40851
				order[34] = 40852
				order[35] = 40853
				order[36] = 40977
				order[37] = 40855
				order[38] = 40856
				order[39] = 40857
				order[40] = 41174
				order[41] = 41175
				order[42] = 40858
				order[43] = 41161
				order[44] = 41176
				order[45] = 41177
				order[46] = 41178
				order[47] = 41179
				order[48] = 40859
				order[49] = 40860
				order[50] = 40861
				order[51] = 40862
				order[52] = 40945
				order[53] = 40864
				order[54] = 40865
				order[55] = 40866
				order[56] = 40867
				order[57] = 0
				fix.Group.__init__(self, 40828, 40829, order)

			class NoPaymentScheduleRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 40869
					order[1] = 40870
					order[2] = 40871
					order[3] = 0
					fix.Group.__init__(self, 40868, 40869, order)

			class NoPaymentScheduleFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40854
					order[1] = 0
					fix.Group.__init__(self, 40977, 40854, order)

			class NoPaymentScheduleFixingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41162
					order[1] = 41163
					order[2] = 0
					fix.Group.__init__(self, 41161, 41162, order)

			class NoPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40863
					order[1] = 0
					fix.Group.__init__(self, 40945, 40863, order)

		class NoPaymentStubs(fix.Group):
			def __init__(self):
				order = fix.IntArray(44)
				order[0] = 40873
				order[1] = 40874
				order[2] = 42698
				order[3] = 42699
				order[4] = 42700
				order[5] = 42701
				order[6] = 42702
				order[7] = 42703
				order[8] = 42704
				order[9] = 42689
				order[10] = 42690
				order[11] = 42691
				order[12] = 42692
				order[13] = 42693
				order[14] = 42694
				order[15] = 42695
				order[16] = 40875
				order[17] = 40876
				order[18] = 40877
				order[19] = 40878
				order[20] = 40879
				order[21] = 40880
				order[22] = 40881
				order[23] = 40882
				order[24] = 40883
				order[25] = 40884
				order[26] = 40885
				order[27] = 40886
				order[28] = 40887
				order[29] = 40888
				order[30] = 40889
				order[31] = 40890
				order[32] = 40891
				order[33] = 40892
				order[34] = 40893
				order[35] = 40894
				order[36] = 40895
				order[37] = 40896
				order[38] = 40897
				order[39] = 40898
				order[40] = 40899
				order[41] = 40900
				order[42] = 40901
				order[43] = 0
				fix.Group.__init__(self, 40872, 40873, order)

			class NoPaymentStubStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42706
					order[1] = 0
					fix.Group.__init__(self, 42705, 42706, order)

			class NoPaymentStubEndDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42697
					order[1] = 0
					fix.Group.__init__(self, 42696, 42697, order)

		class NoDeliveryStreamCommoditySources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41086
				order[1] = 0
				fix.Group.__init__(self, 41085, 41086, order)

		class NoDeliveryStreamCycles(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41082
				order[1] = 41083
				order[2] = 41084
				order[3] = 0
				fix.Group.__init__(self, 41081, 41082, order)

		class NoDeliverySchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41038
				order[1] = 41039
				order[2] = 41040
				order[3] = 41041
				order[4] = 41042
				order[5] = 41043
				order[6] = 41044
				order[7] = 41045
				order[8] = 41046
				order[9] = 41047
				order[10] = 41048
				order[11] = 41049
				order[12] = 41050
				order[13] = 41051
				order[14] = 0
				fix.Group.__init__(self, 41037, 41038, order)

			class NoDeliveryScheduleSettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41052
					order[1] = 41053
					order[2] = 41054
					order[3] = 0
					fix.Group.__init__(self, 41051, 41052, order)

				class NoDeliveryScheduleSettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41055
						order[1] = 41056
						order[2] = 41057
						order[3] = 0
						fix.Group.__init__(self, 41054, 41055, order)

	class NoProvisions(fix.Group):
		def __init__(self):
			order = fix.IntArray(79)
			order[0] = 40091
			order[1] = 40092
			order[2] = 40093
			order[3] = 40957
			order[4] = 40095
			order[5] = 40096
			order[6] = 40097
			order[7] = 42707
			order[8] = 42708
			order[9] = 40098
			order[10] = 40099
			order[11] = 40100
			order[12] = 40114
			order[13] = 40115
			order[14] = 40116
			order[15] = 40118
			order[16] = 40119
			order[17] = 40120
			order[18] = 40121
			order[19] = 40122
			order[20] = 40123
			order[21] = 40125
			order[22] = 40126
			order[23] = 40127
			order[24] = 40128
			order[25] = 40129
			order[26] = 40130
			order[27] = 40131
			order[28] = 40132
			order[29] = 40133
			order[30] = 40134
			order[31] = 40135
			order[32] = 40136
			order[33] = 40137
			order[34] = 40138
			order[35] = 40139
			order[36] = 40140
			order[37] = 40141
			order[38] = 40145
			order[39] = 40146
			order[40] = 40148
			order[41] = 40149
			order[42] = 40150
			order[43] = 40151
			order[44] = 40152
			order[45] = 40153
			order[46] = 40154
			order[47] = 40155
			order[48] = 40156
			order[49] = 40158
			order[50] = 40159
			order[51] = 40160
			order[52] = 40161
			order[53] = 40162
			order[54] = 40101
			order[55] = 40102
			order[56] = 40103
			order[57] = 40104
			order[58] = 40105
			order[59] = 40106
			order[60] = 40107
			order[61] = 40163
			order[62] = 40165
			order[63] = 40166
			order[64] = 40167
			order[65] = 40168
			order[66] = 40169
			order[67] = 40170
			order[68] = 40108
			order[69] = 40109
			order[70] = 40110
			order[71] = 40111
			order[72] = 40112
			order[73] = 41406
			order[74] = 40113
			order[75] = 40986
			order[76] = 40987
			order[77] = 40174
			order[78] = 0
			fix.Group.__init__(self, 40090, 40091, order)

		class NoProvisionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40094
				order[1] = 0
				fix.Group.__init__(self, 40957, 40094, order)

		class NoProvisionCashSettlValueDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40117
				order[1] = 0
				fix.Group.__init__(self, 40953, 40117, order)

		class NoProvisionOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40124
				order[1] = 0
				fix.Group.__init__(self, 40954, 40124, order)

		class NoProvisionOptionExerciseFixedDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40143
				order[1] = 40144
				order[2] = 0
				fix.Group.__init__(self, 40142, 40143, order)

		class NoProvisionOptionExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40147
				order[1] = 0
				fix.Group.__init__(self, 40955, 40147, order)

		class NoProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40157
				order[1] = 0
				fix.Group.__init__(self, 40956, 40157, order)

		class NoProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40164
				order[1] = 0
				fix.Group.__init__(self, 40952, 40164, order)

		class NoProvisionCashSettlPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40172
				order[1] = 40173
				order[2] = 0
				fix.Group.__init__(self, 40171, 40172, order)

		class NoProvisionPartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40175
				order[1] = 40176
				order[2] = 40177
				order[3] = 2385
				order[4] = 40178
				order[5] = 0
				fix.Group.__init__(self, 40174, 40175, order)

			class NoProvisionPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40179
					order[1] = 40180
					order[2] = 0
					fix.Group.__init__(self, 40178, 40179, order)

	class NoAdditionalTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40020
			order[1] = 40021
			order[2] = 40000
			order[3] = 0
			fix.Group.__init__(self, 40019, 40020, order)

		class NoAdditionalTermBondRefs(fix.Group):
			def __init__(self):
				order = fix.IntArray(19)
				order[0] = 40001
				order[1] = 40002
				order[2] = 40003
				order[3] = 40004
				order[4] = 40005
				order[5] = 40006
				order[6] = 40007
				order[7] = 40008
				order[8] = 40009
				order[9] = 40010
				order[10] = 40011
				order[11] = 40012
				order[12] = 40013
				order[13] = 40014
				order[14] = 40015
				order[15] = 40016
				order[16] = 40017
				order[17] = 40018
				order[18] = 0
				fix.Group.__init__(self, 40000, 40001, order)

	class NoProtectionTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(12)
			order[0] = 40182
			order[1] = 40183
			order[2] = 40184
			order[3] = 40185
			order[4] = 40186
			order[5] = 40187
			order[6] = 40188
			order[7] = 40951
			order[8] = 40191
			order[9] = 40201
			order[10] = 40190
			order[11] = 0
			fix.Group.__init__(self, 40181, 40182, order)

		class NoProtectionTermEventNewsSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40189
				order[1] = 0
				fix.Group.__init__(self, 40951, 40189, order)

		class NoProtectionTermEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40192
				order[1] = 40193
				order[2] = 40194
				order[3] = 40195
				order[4] = 40196
				order[5] = 40197
				order[6] = 40198
				order[7] = 40199
				order[8] = 0
				fix.Group.__init__(self, 40191, 40192, order)

			class NoProtectionTermEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40200
					order[1] = 0
					fix.Group.__init__(self, 40199, 40200, order)

		class NoProtectionTermObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40202
				order[1] = 40203
				order[2] = 0
				fix.Group.__init__(self, 40201, 40202, order)

	class NoCashSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(29)
			order[0] = 40023
			order[1] = 40024
			order[2] = 40916
			order[3] = 40917
			order[4] = 40025
			order[5] = 40026
			order[6] = 40027
			order[7] = 40028
			order[8] = 40029
			order[9] = 40030
			order[10] = 40031
			order[11] = 40277
			order[12] = 42216
			order[13] = 42217
			order[14] = 40033
			order[15] = 40034
			order[16] = 42207
			order[17] = 42208
			order[18] = 42209
			order[19] = 42210
			order[20] = 42211
			order[21] = 42212
			order[22] = 42213
			order[23] = 40035
			order[24] = 40036
			order[25] = 40037
			order[26] = 40038
			order[27] = 40039
			order[28] = 0
			fix.Group.__init__(self, 40022, 40023, order)

		class NoCashSettlDealers(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40032
				order[1] = 0
				fix.Group.__init__(self, 40277, 40032, order)

		class NoCashSettlDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42215
				order[1] = 0
				fix.Group.__init__(self, 42214, 42215, order)

	class NoPhysicalSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 40209
			order[1] = 40205
			order[2] = 40206
			order[3] = 40207
			order[4] = 40208
			order[5] = 0
			fix.Group.__init__(self, 40204, 40209, order)

		class NoPhysicalSettlDeliverableObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40210
				order[1] = 40211
				order[2] = 0
				fix.Group.__init__(self, 40209, 40210, order)

	class NoExtraordinaryEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 42297
			order[1] = 42298
			order[2] = 0
			fix.Group.__init__(self, 42296, 42297, order)

	class NoInstrAttrib(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 871
			order[1] = 872
			order[2] = 0
			fix.Group.__init__(self, 870, 871, order)

	class NoIndexRollMonths(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 2733
			order[1] = 0
			fix.Group.__init__(self, 2734, 2733, order)

	class NoReferenceDataDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 2747
			order[1] = 2748
			order[2] = 0
			fix.Group.__init__(self, 2746, 2747, order)

	class NoPartyIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 448
			order[1] = 447
			order[2] = 452
			order[3] = 2376
			order[4] = 802
			order[5] = 0
			fix.Group.__init__(self, 453, 448, order)

		class NoPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 523
				order[1] = 803
				order[2] = 0
				fix.Group.__init__(self, 802, 523, order)

	class NoContractualDefinitions(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40041
			order[1] = 0
			fix.Group.__init__(self, 40040, 40041, order)

	class NoFinancingTermSupplements(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 40047
			order[1] = 40048
			order[2] = 0
			fix.Group.__init__(self, 40046, 40047, order)

	class NoContractualMatrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40043
			order[1] = 40044
			order[2] = 40045
			order[3] = 0
			fix.Group.__init__(self, 40042, 40043, order)

	class NoUnderlyings(fix.Group):
		def __init__(self):
			order = fix.IntArray(188)
			order[0] = 311
			order[1] = 312
			order[2] = 309
			order[3] = 305
			order[4] = 2874
			order[5] = 462
			order[6] = 463
			order[7] = 2894
			order[8] = 310
			order[9] = 763
			order[10] = 313
			order[11] = 542
			order[12] = 1213
			order[13] = 1837
			order[14] = 241
			order[15] = 1453
			order[16] = 1454
			order[17] = 2614
			order[18] = 2615
			order[19] = 2921
			order[20] = 2616
			order[21] = 2617
			order[22] = 2619
			order[23] = 1455
			order[24] = 1456
			order[25] = 1459
			order[26] = 1460
			order[27] = 242
			order[28] = 243
			order[29] = 244
			order[30] = 245
			order[31] = 246
			order[32] = 256
			order[33] = 595
			order[34] = 592
			order[35] = 593
			order[36] = 594
			order[37] = 247
			order[38] = 316
			order[39] = 941
			order[40] = 2917
			order[41] = 317
			order[42] = 436
			order[43] = 1437
			order[44] = 2363
			order[45] = 1441
			order[46] = 998
			order[47] = 1423
			order[48] = 1718
			order[49] = 2918
			order[50] = 1424
			order[51] = 1425
			order[52] = 1719
			order[53] = 2919
			order[54] = 1000
			order[55] = 1419
			order[56] = 1526
			order[57] = 2920
			order[58] = 435
			order[59] = 308
			order[60] = 306
			order[61] = 362
			order[62] = 363
			order[63] = 2742
			order[64] = 2720
			order[65] = 2721
			order[66] = 2722
			order[67] = 2723
			order[68] = 2724
			order[69] = 307
			order[70] = 364
			order[71] = 365
			order[72] = 877
			order[73] = 878
			order[74] = 972
			order[75] = 318
			order[76] = 2916
			order[77] = 879
			order[78] = 975
			order[79] = 973
			order[80] = 974
			order[81] = 810
			order[82] = 882
			order[83] = 883
			order[84] = 884
			order[85] = 885
			order[86] = 886
			order[87] = 2885
			order[88] = 2886
			order[89] = 1044
			order[90] = 1045
			order[91] = 1046
			order[92] = 1038
			order[93] = 1039
			order[94] = 315
			order[95] = 2683
			order[96] = 2687
			order[97] = 1988
			order[98] = 1989
			order[99] = 1990
			order[100] = 1991
			order[101] = 1992
			order[102] = 1993
			order[103] = 2881
			order[104] = 1994
			order[105] = 1995
			order[106] = 1996
			order[107] = 1997
			order[108] = 2620
			order[109] = 2621
			order[110] = 1998
			order[111] = 1999
			order[112] = 2000
			order[113] = 2003
			order[114] = 2004
			order[115] = 2005
			order[116] = 2006
			order[117] = 2284
			order[118] = 2285
			order[119] = 2286
			order[120] = 2287
			order[121] = 2288
			order[122] = 2007
			order[123] = 2008
			order[124] = 2009
			order[125] = 2010
			order[126] = 2011
			order[127] = 2012
			order[128] = 2491
			order[129] = 2013
			order[130] = 2014
			order[131] = 2015
			order[132] = 2744
			order[133] = 2016
			order[134] = 2289
			order[135] = 2017
			order[136] = 2018
			order[137] = 2019
			order[138] = 2020
			order[139] = 2021
			order[140] = 2022
			order[141] = 2290
			order[142] = 2622
			order[143] = 2291
			order[144] = 2623
			order[145] = 2292
			order[146] = 2023
			order[147] = 2024
			order[148] = 2025
			order[149] = 2026
			order[150] = 2027
			order[151] = 2028
			order[152] = 2029
			order[153] = 2757
			order[154] = 2030
			order[155] = 2031
			order[156] = 2293
			order[157] = 2294
			order[158] = 2032
			order[159] = 2033
			order[160] = 2034
			order[161] = 2035
			order[162] = 2036
			order[163] = 2037
			order[164] = 2038
			order[165] = 2039
			order[166] = 2040
			order[167] = 2041
			order[168] = 2042
			order[169] = 2043
			order[170] = 2044
			order[171] = 41314
			order[172] = 41315
			order[173] = 2295
			order[174] = 2296
			order[175] = 2297
			order[176] = 2756
			order[177] = 2298
			order[178] = 2299
			order[179] = 2624
			order[180] = 2625
			order[181] = 2626
			order[182] = 2627
			order[183] = 2628
			order[184] = 2629
			order[185] = 2630
			order[186] = 2631
			order[187] = 0
			fix.Group.__init__(self, 711, 311, order)

		class NoUnderlyingSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 458
				order[1] = 459
				order[2] = 2959
				order[3] = 0
				fix.Group.__init__(self, 457, 458, order)

		class NoUnderlyingStips(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 888
				order[1] = 889
				order[2] = 0
				fix.Group.__init__(self, 887, 888, order)

		class NoUndlyInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1059
				order[1] = 1060
				order[2] = 1061
				order[3] = 2391
				order[4] = 1062
				order[5] = 0
				fix.Group.__init__(self, 1058, 1059, order)

			class NoUndlyInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1063
					order[1] = 1064
					order[2] = 0
					fix.Group.__init__(self, 1062, 1063, order)

		class NoUnderlyingEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 1982
				order[1] = 1983
				order[2] = 1984
				order[3] = 1985
				order[4] = 1986
				order[5] = 2342
				order[6] = 1987
				order[7] = 2071
				order[8] = 2072
				order[9] = 2073
				order[10] = 0
				fix.Group.__init__(self, 1981, 1982, order)

		class NoUnderlyingSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2081
				order[1] = 2082
				order[2] = 2083
				order[3] = 2745
				order[4] = 0
				fix.Group.__init__(self, 2080, 2081, order)

		class NoUnderlyingAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2313
				order[1] = 2314
				order[2] = 2315
				order[3] = 0
				fix.Group.__init__(self, 2312, 2313, order)

		class NoUnderlyingComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2046
				order[1] = 2261
				order[2] = 2262
				order[3] = 2263
				order[4] = 2047
				order[5] = 2264
				order[6] = 2265
				order[7] = 2266
				order[8] = 2947
				order[9] = 2048
				order[10] = 2267
				order[11] = 2049
				order[12] = 2050
				order[13] = 2051
				order[14] = 2052
				order[15] = 2053
				order[16] = 2268
				order[17] = 2948
				order[18] = 2269
				order[19] = 2949
				order[20] = 2270
				order[21] = 2271
				order[22] = 2419
				order[23] = 2420
				order[24] = 2272
				order[25] = 2273
				order[26] = 2274
				order[27] = 2275
				order[28] = 2276
				order[29] = 41732
				order[30] = 41739
				order[31] = 41740
				order[32] = 41741
				order[33] = 41742
				order[34] = 41743
				order[35] = 41744
				order[36] = 41745
				order[37] = 41746
				order[38] = 41747
				order[39] = 41729
				order[40] = 2277
				order[41] = 2278
				order[42] = 2279
				order[43] = 2280
				order[44] = 2281
				order[45] = 41748
				order[46] = 41716
				order[47] = 2611
				order[48] = 2612
				order[49] = 2613
				order[50] = 2282
				order[51] = 2283
				order[52] = 0
				fix.Group.__init__(self, 2045, 2046, order)

			class NoUnderlyingComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2054
					order[1] = 2055
					order[2] = 2056
					order[3] = 0
					fix.Group.__init__(self, 2053, 2054, order)

				class NoUnderlyingComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2057
						order[1] = 2058
						order[2] = 0
						fix.Group.__init__(self, 2056, 2057, order)

			class NoUnderlyingComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41733
					order[1] = 41734
					order[2] = 41735
					order[3] = 41736
					order[4] = 0
					fix.Group.__init__(self, 41732, 41733, order)

			class NoUnderlyingComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41738
					order[1] = 0
					fix.Group.__init__(self, 41737, 41738, order)

			class NoUnderlyingComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41730
					order[1] = 41731
					order[2] = 41750
					order[3] = 41726
					order[4] = 41713
					order[5] = 0
					fix.Group.__init__(self, 41729, 41730, order)

				class NoUnderlyingComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41751
						order[1] = 41752
						order[2] = 41753
						order[3] = 41754
						order[4] = 41755
						order[5] = 0
						fix.Group.__init__(self, 41750, 41751, order)

				class NoUnderlyingComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41727
						order[1] = 41728
						order[2] = 0
						fix.Group.__init__(self, 41726, 41727, order)

				class NoUnderlyingComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41714
						order[1] = 41715
						order[2] = 0
						fix.Group.__init__(self, 41713, 41714, order)

			class NoUnderlyingComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41749
					order[1] = 0
					fix.Group.__init__(self, 41748, 41749, order)

			class NoUnderlyingComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41717
					order[1] = 41718
					order[2] = 41719
					order[3] = 41720
					order[4] = 41721
					order[5] = 41722
					order[6] = 41723
					order[7] = 41724
					order[8] = 0
					fix.Group.__init__(self, 41716, 41717, order)

				class NoUnderlyingComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41725
						order[1] = 0
						fix.Group.__init__(self, 41724, 41725, order)

		class NoUnderlyingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40963
				order[1] = 0
				fix.Group.__init__(self, 40962, 40963, order)

		class NoUnderlyingPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41948
				order[1] = 0
				fix.Group.__init__(self, 41947, 41948, order)

		class NoUnderlyingMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41865
				order[1] = 41338
				order[2] = 0
				fix.Group.__init__(self, 41864, 41865, order)

		class NoUnderlyingMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41867
				order[1] = 41339
				order[2] = 0
				fix.Group.__init__(self, 41866, 41867, order)

		class NoUnderlyingMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41869
				order[1] = 41870
				order[2] = 41871
				order[3] = 41872
				order[4] = 41873
				order[5] = 41874
				order[6] = 41875
				order[7] = 41876
				order[8] = 41877
				order[9] = 0
				fix.Group.__init__(self, 41868, 41869, order)

		class NoUnderlyingSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 43075
				order[1] = 0
				fix.Group.__init__(self, 43074, 43075, order)

		class NoUnderlyingOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41821
				order[1] = 0
				fix.Group.__init__(self, 41820, 41821, order)

		class NoUnderlyingOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41842
				order[1] = 41843
				order[2] = 0
				fix.Group.__init__(self, 41841, 41842, order)

		class NoUnderlyingOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41845
				order[1] = 0
				fix.Group.__init__(self, 41844, 41845, order)

		class NoUnderlyingOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41857
				order[1] = 41858
				order[2] = 0
				fix.Group.__init__(self, 41856, 41857, order)

		class NoUnderlyingStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40541
				order[1] = 42016
				order[2] = 40542
				order[3] = 43083
				order[4] = 43084
				order[5] = 40543
				order[6] = 40544
				order[7] = 42018
				order[8] = 40545
				order[9] = 40546
				order[10] = 43085
				order[11] = 43086
				order[12] = 42019
				order[13] = 42020
				order[14] = 42021
				order[15] = 42022
				order[16] = 42023
				order[17] = 42024
				order[18] = 41964
				order[19] = 41965
				order[20] = 41966
				order[21] = 41967
				order[22] = 41968
				order[23] = 41969
				order[24] = 41970
				order[25] = 42589
				order[26] = 41971
				order[27] = 41972
				order[28] = 41973
				order[29] = 41974
				order[30] = 41975
				order[31] = 41976
				order[32] = 41977
				order[33] = 41978
				order[34] = 41979
				order[35] = 41980
				order[36] = 41981
				order[37] = 41982
				order[38] = 41983
				order[39] = 41984
				order[40] = 41985
				order[41] = 41986
				order[42] = 41987
				order[43] = 41988
				order[44] = 41989
				order[45] = 40057
				order[46] = 40058
				order[47] = 40060
				order[48] = 40061
				order[49] = 40062
				order[50] = 40063
				order[51] = 40064
				order[52] = 40548
				order[53] = 40549
				order[54] = 40551
				order[55] = 40552
				order[56] = 40553
				order[57] = 40554
				order[58] = 40555
				order[59] = 41957
				order[60] = 41958
				order[61] = 40556
				order[62] = 40558
				order[63] = 40559
				order[64] = 40561
				order[65] = 40562
				order[66] = 40563
				order[67] = 40564
				order[68] = 40565
				order[69] = 40566
				order[70] = 40567
				order[71] = 41959
				order[72] = 41960
				order[73] = 41961
				order[74] = 40568
				order[75] = 40569
				order[76] = 40570
				order[77] = 42895
				order[78] = 40571
				order[79] = 40572
				order[80] = 43107
				order[81] = 40573
				order[82] = 40574
				order[83] = 40575
				order[84] = 40576
				order[85] = 40577
				order[86] = 42896
				order[87] = 42897
				order[88] = 42898
				order[89] = 42899
				order[90] = 40578
				order[91] = 40579
				order[92] = 40580
				order[93] = 41897
				order[94] = 41898
				order[95] = 41899
				order[96] = 41900
				order[97] = 41901
				order[98] = 41902
				order[99] = 41903
				order[100] = 42900
				order[101] = 40664
				order[102] = 40708
				order[103] = 41777
				order[104] = 41778
				order[105] = 41779
				order[106] = 41780
				order[107] = 41781
				order[108] = 42196
				order[109] = 42197
				order[110] = 41782
				order[111] = 41783
				order[112] = 41784
				order[113] = 41785
				order[114] = 41786
				order[115] = 41587
				order[116] = 41787
				order[117] = 41788
				order[118] = 41789
				order[119] = 41790
				order[120] = 41791
				order[121] = 41792
				order[122] = 41793
				order[123] = 41794
				order[124] = 41795
				order[125] = 41796
				order[126] = 41797
				order[127] = 41798
				order[128] = 41799
				order[129] = 43096
				order[130] = 41756
				order[131] = 40547
				order[132] = 40988
				order[133] = 40989
				order[134] = 0
				fix.Group.__init__(self, 40540, 40541, order)

			class NoUnderlyingStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41991
					order[1] = 41992
					order[2] = 0
					fix.Group.__init__(self, 41990, 41991, order)

			class NoUnderlyingStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41801
					order[1] = 41802
					order[2] = 41803
					order[3] = 0
					fix.Group.__init__(self, 41800, 41801, order)

			class NoUnderlyingStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41994
					order[1] = 41995
					order[2] = 0
					fix.Group.__init__(self, 41993, 41994, order)

			class NoUnderlyingStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41963
					order[1] = 0
					fix.Group.__init__(self, 41962, 41963, order)

			class NoUnderlyingStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 42003
					order[1] = 42004
					order[2] = 42005
					order[3] = 42006
					order[4] = 42007
					order[5] = 42008
					order[6] = 42009
					order[7] = 42010
					order[8] = 42011
					order[9] = 42012
					order[10] = 42013
					order[11] = 41996
					order[12] = 42014
					order[13] = 42015
					order[14] = 0
					fix.Group.__init__(self, 42002, 42003, order)

				class NoUnderlyingStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41997
						order[1] = 41998
						order[2] = 41999
						order[3] = 0
						fix.Group.__init__(self, 41996, 41997, order)

					class NoUnderlyingStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 42000
							order[1] = 42001
							order[2] = 41936
							order[3] = 0
							fix.Group.__init__(self, 41999, 42000, order)

			class NoUnderlyingStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40059
					order[1] = 0
					fix.Group.__init__(self, 40975, 40059, order)

			class NoUnderlyingStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40550
					order[1] = 0
					fix.Group.__init__(self, 40976, 40550, order)

			class NoUnderlyingStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40557
					order[1] = 0
					fix.Group.__init__(self, 40973, 40557, order)

			class NoUnderlyingStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41955
					order[1] = 41956
					order[2] = 0
					fix.Group.__init__(self, 41954, 41955, order)

			class NoUnderlyingStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40560
					order[1] = 0
					fix.Group.__init__(self, 40974, 40560, order)

			class NoUnderlyingPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40582
					order[1] = 0
					fix.Group.__init__(self, 40969, 40582, order)

			class NoUnderlyingPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41938
					order[1] = 41939
					order[2] = 0
					fix.Group.__init__(self, 41937, 41938, order)

			class NoUnderlyingPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40594
					order[1] = 0
					fix.Group.__init__(self, 40970, 40594, order)

			class NoUnderlyingPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40600
					order[1] = 0
					fix.Group.__init__(self, 40971, 40600, order)

			class NoUnderlyingPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40607
					order[1] = 0
					fix.Group.__init__(self, 40972, 40607, order)

			class NoUnderlyingPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42956
					order[1] = 42957
					order[2] = 0
					fix.Group.__init__(self, 42955, 42956, order)

			class NoUnderlyingPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41910
					order[1] = 0
					fix.Group.__init__(self, 41909, 41910, order)

			class NoUnderlyingPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41945
					order[1] = 41946
					order[2] = 0
					fix.Group.__init__(self, 41944, 41945, order)

			class NoUnderlyingPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41942
					order[1] = 41943
					order[2] = 0
					fix.Group.__init__(self, 41941, 41942, order)

			class NoUnderlyingPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43111
					order[1] = 42982
					order[2] = 42983
					order[3] = 0
					fix.Group.__init__(self, 42981, 43111, order)

			class NoUnderlyingDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42863
					order[1] = 42864
					order[2] = 42865
					order[3] = 42866
					order[4] = 42867
					order[5] = 42868
					order[6] = 42882
					order[7] = 42869
					order[8] = 42870
					order[9] = 42871
					order[10] = 42872
					order[11] = 42873
					order[12] = 42874
					order[13] = 42875
					order[14] = 42876
					order[15] = 42877
					order[16] = 42878
					order[17] = 42879
					order[18] = 42880
					order[19] = 42881
					order[20] = 0
					fix.Group.__init__(self, 42862, 42863, order)

				class NoUnderlyingDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42883
						order[1] = 0
						fix.Group.__init__(self, 42882, 42883, order)

			class NoUnderlyingDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42854
					order[1] = 0
					fix.Group.__init__(self, 42853, 42854, order)

			class NoUnderlyingDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42800
					order[1] = 0
					fix.Group.__init__(self, 42799, 42800, order)

			class NoUnderlyingReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 43035
					order[1] = 43036
					order[2] = 43037
					order[3] = 43038
					order[4] = 43039
					order[5] = 43040
					order[6] = 43064
					order[7] = 43030
					order[8] = 43041
					order[9] = 43042
					order[10] = 43043
					order[11] = 43044
					order[12] = 43045
					order[13] = 43046
					order[14] = 43047
					order[15] = 43048
					order[16] = 43049
					order[17] = 43050
					order[18] = 43051
					order[19] = 43052
					order[20] = 43060
					order[21] = 43053
					order[22] = 43054
					order[23] = 43008
					order[24] = 43055
					order[25] = 43056
					order[26] = 43057
					order[27] = 43058
					order[28] = 43059
					order[29] = 0
					fix.Group.__init__(self, 43034, 43035, order)

				class NoUnderlyingReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 43065
						order[1] = 43066
						order[2] = 43067
						order[3] = 43068
						order[4] = 0
						fix.Group.__init__(self, 43064, 43065, order)

				class NoUnderlyingReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43031
						order[1] = 43032
						order[2] = 43033
						order[3] = 0
						fix.Group.__init__(self, 43030, 43031, order)

				class NoUnderlyingReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43061
						order[1] = 43062
						order[2] = 43063
						order[3] = 0
						fix.Group.__init__(self, 43060, 43061, order)

				class NoUnderlyingReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 43009
						order[1] = 43071
						order[2] = 43010
						order[3] = 43011
						order[4] = 43012
						order[5] = 43013
						order[6] = 43014
						order[7] = 43015
						order[8] = 43016
						order[9] = 43017
						order[10] = 43018
						order[11] = 43019
						order[12] = 43020
						order[13] = 43021
						order[14] = 43022
						order[15] = 43023
						order[16] = 43024
						order[17] = 43025
						order[18] = 43026
						order[19] = 43027
						order[20] = 43028
						order[21] = 43029
						order[22] = 43069
						order[23] = 0
						fix.Group.__init__(self, 43008, 43009, order)

					class NoUnderlyingReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 43072
							order[1] = 43073
							order[2] = 0
							fix.Group.__init__(self, 43071, 43072, order)

					class NoUnderlyingReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 43070
							order[1] = 0
							fix.Group.__init__(self, 43069, 43070, order)

			class NoUnderlyingPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42916
					order[1] = 0
					fix.Group.__init__(self, 42915, 42916, order)

			class NoUnderlyingPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42902
					order[1] = 42903
					order[2] = 0
					fix.Group.__init__(self, 42901, 42902, order)

			class NoUnderlyingPaymentStreamNonDeliverableFixingDatesBizCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40650
					order[1] = 0
					fix.Group.__init__(self, 40968, 40650, order)

			class NoUnderlyingNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40657
					order[1] = 40658
					order[2] = 0
					fix.Group.__init__(self, 40656, 40657, order)

			class NoUnderlyingSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40660
					order[1] = 40904
					order[2] = 40915
					order[3] = 40662
					order[4] = 40663
					order[5] = 0
					fix.Group.__init__(self, 40659, 40660, order)

			class NoUnderlyingPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40665
					order[1] = 41881
					order[2] = 41882
					order[3] = 40666
					order[4] = 40667
					order[5] = 40668
					order[6] = 40669
					order[7] = 40670
					order[8] = 40671
					order[9] = 40672
					order[10] = 40673
					order[11] = 40674
					order[12] = 40675
					order[13] = 41883
					order[14] = 41884
					order[15] = 41885
					order[16] = 41886
					order[17] = 40676
					order[18] = 40677
					order[19] = 40678
					order[20] = 40679
					order[21] = 41887
					order[22] = 41888
					order[23] = 41889
					order[24] = 41890
					order[25] = 40680
					order[26] = 40681
					order[27] = 40682
					order[28] = 40683
					order[29] = 40684
					order[30] = 40685
					order[31] = 40704
					order[32] = 40686
					order[33] = 40687
					order[34] = 40688
					order[35] = 40689
					order[36] = 40966
					order[37] = 40691
					order[38] = 40692
					order[39] = 40693
					order[40] = 41891
					order[41] = 41892
					order[42] = 40694
					order[43] = 41878
					order[44] = 41893
					order[45] = 41894
					order[46] = 41895
					order[47] = 41896
					order[48] = 40695
					order[49] = 40696
					order[50] = 40697
					order[51] = 40698
					order[52] = 40967
					order[53] = 40700
					order[54] = 40701
					order[55] = 40702
					order[56] = 40703
					order[57] = 0
					fix.Group.__init__(self, 40664, 40665, order)

				class NoUnderlyingPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40705
						order[1] = 40706
						order[2] = 40707
						order[3] = 0
						fix.Group.__init__(self, 40704, 40705, order)

				class NoUnderlyingPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40690
						order[1] = 0
						fix.Group.__init__(self, 40966, 40690, order)

				class NoUnderlyingPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41879
						order[1] = 41880
						order[2] = 0
						fix.Group.__init__(self, 41878, 41879, order)

				class NoUnderlyingPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40699
						order[1] = 0
						fix.Group.__init__(self, 40967, 40699, order)

			class NoUnderlyingPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40709
					order[1] = 40710
					order[2] = 42993
					order[3] = 42994
					order[4] = 42995
					order[5] = 42996
					order[6] = 42997
					order[7] = 42998
					order[8] = 42999
					order[9] = 42984
					order[10] = 42985
					order[11] = 42986
					order[12] = 42987
					order[13] = 42988
					order[14] = 42989
					order[15] = 42990
					order[16] = 40711
					order[17] = 40712
					order[18] = 40713
					order[19] = 40714
					order[20] = 40715
					order[21] = 40716
					order[22] = 40717
					order[23] = 40718
					order[24] = 40719
					order[25] = 40720
					order[26] = 40721
					order[27] = 40722
					order[28] = 40723
					order[29] = 40724
					order[30] = 40725
					order[31] = 40726
					order[32] = 40727
					order[33] = 40728
					order[34] = 40729
					order[35] = 40730
					order[36] = 40731
					order[37] = 40732
					order[38] = 40733
					order[39] = 40734
					order[40] = 40735
					order[41] = 40736
					order[42] = 40737
					order[43] = 0
					fix.Group.__init__(self, 40708, 40709, order)

				class NoUnderlyingPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 43001
						order[1] = 0
						fix.Group.__init__(self, 43000, 43001, order)

				class NoUnderlyingPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42992
						order[1] = 0
						fix.Group.__init__(self, 42991, 42992, order)

			class NoUnderlyingDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41809
					order[1] = 0
					fix.Group.__init__(self, 41808, 41809, order)

			class NoUnderlyingDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41805
					order[1] = 41806
					order[2] = 41807
					order[3] = 0
					fix.Group.__init__(self, 41804, 41805, order)

			class NoUnderlyingDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41757
					order[1] = 41758
					order[2] = 41759
					order[3] = 41760
					order[4] = 41761
					order[5] = 41762
					order[6] = 41763
					order[7] = 41764
					order[8] = 41765
					order[9] = 41766
					order[10] = 41767
					order[11] = 41768
					order[12] = 41769
					order[13] = 41770
					order[14] = 0
					fix.Group.__init__(self, 41756, 41757, order)

				class NoUnderlyingDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41771
						order[1] = 41772
						order[2] = 41773
						order[3] = 0
						fix.Group.__init__(self, 41770, 41771, order)

					class NoUnderlyingDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41774
							order[1] = 41775
							order[2] = 41776
							order[3] = 0
							fix.Group.__init__(self, 41773, 41774, order)

		class NoUnderlyingProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 42150
				order[1] = 42151
				order[2] = 42152
				order[3] = 42190
				order[4] = 42153
				order[5] = 42154
				order[6] = 42155
				order[7] = 43002
				order[8] = 43003
				order[9] = 42156
				order[10] = 42157
				order[11] = 42158
				order[12] = 42104
				order[13] = 42105
				order[14] = 42106
				order[15] = 42107
				order[16] = 42108
				order[17] = 42109
				order[18] = 42110
				order[19] = 42111
				order[20] = 42115
				order[21] = 42116
				order[22] = 42117
				order[23] = 42118
				order[24] = 42119
				order[25] = 42120
				order[26] = 42121
				order[27] = 42122
				order[28] = 42123
				order[29] = 42124
				order[30] = 42125
				order[31] = 42126
				order[32] = 42127
				order[33] = 42128
				order[34] = 42129
				order[35] = 42130
				order[36] = 42131
				order[37] = 42132
				order[38] = 42133
				order[39] = 42134
				order[40] = 42135
				order[41] = 42136
				order[42] = 42137
				order[43] = 42138
				order[44] = 42139
				order[45] = 42140
				order[46] = 42141
				order[47] = 42142
				order[48] = 42143
				order[49] = 42144
				order[50] = 42145
				order[51] = 42146
				order[52] = 42147
				order[53] = 42148
				order[54] = 42159
				order[55] = 42160
				order[56] = 42161
				order[57] = 42162
				order[58] = 42163
				order[59] = 42164
				order[60] = 42165
				order[61] = 42092
				order[62] = 42093
				order[63] = 42094
				order[64] = 42095
				order[65] = 42096
				order[66] = 42097
				order[67] = 42098
				order[68] = 42166
				order[69] = 42167
				order[70] = 42168
				order[71] = 42169
				order[72] = 42102
				order[73] = 42103
				order[74] = 42170
				order[75] = 42171
				order[76] = 42172
				order[77] = 42173
				order[78] = 0
				fix.Group.__init__(self, 42149, 42150, order)

			class NoUnderlyingProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42191
					order[1] = 0
					fix.Group.__init__(self, 42190, 42191, order)

			class NoUnderlyingProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42183
					order[1] = 0
					fix.Group.__init__(self, 42182, 42183, order)

			class NoUnderlyingProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42185
					order[1] = 0
					fix.Group.__init__(self, 42184, 42185, order)

			class NoUnderlyingProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42113
					order[1] = 42114
					order[2] = 0
					fix.Group.__init__(self, 42112, 42113, order)

			class NoUnderlyingProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42187
					order[1] = 0
					fix.Group.__init__(self, 42186, 42187, order)

			class NoUnderlyingProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42189
					order[1] = 0
					fix.Group.__init__(self, 42188, 42189, order)

			class NoUnderlyingProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42181
					order[1] = 0
					fix.Group.__init__(self, 42180, 42181, order)

			class NoUnderlyingProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42100
					order[1] = 42101
					order[2] = 0
					fix.Group.__init__(self, 42099, 42100, order)

			class NoUnderlyingProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 42174
					order[1] = 42175
					order[2] = 42176
					order[3] = 40918
					order[4] = 42177
					order[5] = 0
					fix.Group.__init__(self, 42173, 42174, order)

				class NoUnderlyingProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42178
						order[1] = 42179
						order[2] = 0
						fix.Group.__init__(self, 42177, 42178, order)

		class NoUnderlyingAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 42037
				order[1] = 42038
				order[2] = 41340
				order[3] = 0
				fix.Group.__init__(self, 42036, 42037, order)

			class NoUnderlyingAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41341
					order[1] = 41701
					order[2] = 41709
					order[3] = 41710
					order[4] = 41711
					order[5] = 41712
					order[6] = 42017
					order[7] = 42025
					order[8] = 42026
					order[9] = 42027
					order[10] = 42028
					order[11] = 42029
					order[12] = 42030
					order[13] = 42031
					order[14] = 42032
					order[15] = 42033
					order[16] = 42034
					order[17] = 42035
					order[18] = 0
					fix.Group.__init__(self, 41340, 41341, order)

		class NoUnderlyingProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 42069
				order[1] = 42070
				order[2] = 42071
				order[3] = 42072
				order[4] = 42073
				order[5] = 42074
				order[6] = 42075
				order[7] = 42090
				order[8] = 42077
				order[9] = 42087
				order[10] = 42076
				order[11] = 0
				fix.Group.__init__(self, 42068, 42069, order)

			class NoUnderlyingProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42091
					order[1] = 0
					fix.Group.__init__(self, 42090, 42091, order)

			class NoUnderlyingProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 42078
					order[1] = 42079
					order[2] = 42080
					order[3] = 42081
					order[4] = 42082
					order[5] = 42083
					order[6] = 42084
					order[7] = 42085
					order[8] = 0
					fix.Group.__init__(self, 42077, 42078, order)

				class NoUnderlyingProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42086
						order[1] = 0
						fix.Group.__init__(self, 42085, 42086, order)

			class NoUnderlyingProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42088
					order[1] = 42089
					order[2] = 0
					fix.Group.__init__(self, 42087, 42088, order)

		class NoUnderlyingCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 42042
				order[1] = 42043
				order[2] = 42044
				order[3] = 42045
				order[4] = 42046
				order[5] = 42047
				order[6] = 42048
				order[7] = 42049
				order[8] = 42050
				order[9] = 42051
				order[10] = 42052
				order[11] = 42039
				order[12] = 42797
				order[13] = 42798
				order[14] = 42053
				order[15] = 42054
				order[16] = 42790
				order[17] = 42791
				order[18] = 42792
				order[19] = 42793
				order[20] = 42794
				order[21] = 42795
				order[22] = 42796
				order[23] = 42055
				order[24] = 42056
				order[25] = 42057
				order[26] = 42058
				order[27] = 42059
				order[28] = 0
				fix.Group.__init__(self, 42041, 42042, order)

			class NoUnderlyingCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42040
					order[1] = 0
					fix.Group.__init__(self, 42039, 42040, order)

			class NoUnderlyingCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42789
					order[1] = 0
					fix.Group.__init__(self, 42788, 42789, order)

		class NoUnderlyingPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 42065
				order[1] = 42061
				order[2] = 42062
				order[3] = 42063
				order[4] = 42064
				order[5] = 0
				fix.Group.__init__(self, 42060, 42065, order)

			class NoUnderlyingPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42066
					order[1] = 42067
					order[2] = 0
					fix.Group.__init__(self, 42065, 42066, order)

		class NoUnderlyingRateSpreadSteps(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 43006
				order[1] = 43007
				order[2] = 0
				fix.Group.__init__(self, 43005, 43006, order)

		class NoUnderlyingDividendPayments(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 42856
				order[1] = 42857
				order[2] = 42858
				order[3] = 42859
				order[4] = 0
				fix.Group.__init__(self, 42855, 42856, order)

		class NoUnderlyingExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42885
				order[1] = 42886
				order[2] = 0
				fix.Group.__init__(self, 42884, 42885, order)

	class NoRelatedInstruments(fix.Group):
		def __init__(self):
			order = fix.IntArray(11)
			order[0] = 1648
			order[1] = 1649
			order[2] = 1650
			order[3] = 1651
			order[4] = 1652
			order[5] = 1653
			order[6] = 2413
			order[7] = 2414
			order[8] = 2415
			order[9] = 2417
			order[10] = 0
			fix.Group.__init__(self, 1647, 1648, order)

	class NoStipulations(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 233
			order[1] = 234
			order[2] = 0
			fix.Group.__init__(self, 232, 233, order)

	class NoLegs(fix.Group):
		def __init__(self):
			order = fix.IntArray(155)
			order[0] = 600
			order[1] = 601
			order[2] = 602
			order[3] = 603
			order[4] = 1788
			order[5] = 607
			order[6] = 1594
			order[7] = 608
			order[8] = 2893
			order[9] = 609
			order[10] = 764
			order[11] = 610
			order[12] = 611
			order[13] = 1212
			order[14] = 2146
			order[15] = 2147
			order[16] = 2148
			order[17] = 248
			order[18] = 2149
			order[19] = 2150
			order[20] = 2151
			order[21] = 2152
			order[22] = 2153
			order[23] = 2154
			order[24] = 2155
			order[25] = 2348
			order[26] = 2067
			order[27] = 2068
			order[28] = 2069
			order[29] = 2739
			order[30] = 2070
			order[31] = 2156
			order[32] = 2157
			order[33] = 2158
			order[34] = 2159
			order[35] = 2160
			order[36] = 2161
			order[37] = 2162
			order[38] = 2163
			order[39] = 2164
			order[40] = 2165
			order[41] = 2880
			order[42] = 2166
			order[43] = 2167
			order[44] = 2168
			order[45] = 2169
			order[46] = 2170
			order[47] = 2171
			order[48] = 2172
			order[49] = 2173
			order[50] = 2174
			order[51] = 2175
			order[52] = 2176
			order[53] = 2177
			order[54] = 2178
			order[55] = 2179
			order[56] = 2180
			order[57] = 249
			order[58] = 250
			order[59] = 251
			order[60] = 252
			order[61] = 253
			order[62] = 257
			order[63] = 599
			order[64] = 596
			order[65] = 597
			order[66] = 598
			order[67] = 254
			order[68] = 612
			order[69] = 942
			order[70] = 2908
			order[71] = 2181
			order[72] = 2182
			order[73] = 2183
			order[74] = 2184
			order[75] = 2604
			order[76] = 2185
			order[77] = 2605
			order[78] = 2186
			order[79] = 2187
			order[80] = 2188
			order[81] = 2189
			order[82] = 613
			order[83] = 614
			order[84] = 1436
			order[85] = 2354
			order[86] = 1440
			order[87] = 2190
			order[88] = 2191
			order[89] = 999
			order[90] = 1224
			order[91] = 1720
			order[92] = 2909
			order[93] = 1421
			order[94] = 1422
			order[95] = 1721
			order[96] = 2910
			order[97] = 2192
			order[98] = 1001
			order[99] = 1420
			order[100] = 2193
			order[101] = 2194
			order[102] = 2755
			order[103] = 2195
			order[104] = 2196
			order[105] = 2197
			order[106] = 2198
			order[107] = 1528
			order[108] = 2911
			order[109] = 2199
			order[110] = 2200
			order[111] = 2201
			order[112] = 2202
			order[113] = 2203
			order[114] = 615
			order[115] = 616
			order[116] = 2205
			order[117] = 2206
			order[118] = 617
			order[119] = 618
			order[120] = 619
			order[121] = 2740
			order[122] = 2717
			order[123] = 2718
			order[124] = 2719
			order[125] = 620
			order[126] = 621
			order[127] = 622
			order[128] = 2207
			order[129] = 2208
			order[130] = 623
			order[131] = 624
			order[132] = 556
			order[133] = 2898
			order[134] = 740
			order[135] = 739
			order[136] = 955
			order[137] = 956
			order[138] = 1358
			order[139] = 2682
			order[140] = 2686
			order[141] = 1017
			order[142] = 566
			order[143] = 2209
			order[144] = 2211
			order[145] = 2212
			order[146] = 2213
			order[147] = 2754
			order[148] = 2214
			order[149] = 2215
			order[150] = 2606
			order[151] = 2607
			order[152] = 682
			order[153] = 683
			order[154] = 0
			fix.Group.__init__(self, 555, 600, order)

		class NoLegSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 605
				order[1] = 606
				order[2] = 2958
				order[3] = 0
				fix.Group.__init__(self, 604, 605, order)

		class NoLegSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2077
				order[1] = 2078
				order[2] = 2079
				order[3] = 2743
				order[4] = 0
				fix.Group.__init__(self, 2076, 2077, order)

		class NoLegAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2309
				order[1] = 2310
				order[2] = 2311
				order[3] = 0
				fix.Group.__init__(self, 2308, 2309, order)

		class NoLegEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 2060
				order[1] = 2061
				order[2] = 2062
				order[3] = 2063
				order[4] = 2064
				order[5] = 2341
				order[6] = 2065
				order[7] = 2066
				order[8] = 2074
				order[9] = 2075
				order[10] = 0
				fix.Group.__init__(self, 2059, 2060, order)

		class NoLegInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 2255
				order[1] = 2256
				order[2] = 2257
				order[3] = 2379
				order[4] = 2258
				order[5] = 0
				fix.Group.__init__(self, 2254, 2255, order)

			class NoLegInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 2259
					order[1] = 2260
					order[2] = 0
					fix.Group.__init__(self, 2258, 2259, order)

		class NoLegComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2219
				order[1] = 2220
				order[2] = 2221
				order[3] = 2222
				order[4] = 2223
				order[5] = 2224
				order[6] = 2225
				order[7] = 2226
				order[8] = 2944
				order[9] = 2227
				order[10] = 2228
				order[11] = 2229
				order[12] = 2230
				order[13] = 2231
				order[14] = 2232
				order[15] = 2250
				order[16] = 2233
				order[17] = 2945
				order[18] = 2234
				order[19] = 2946
				order[20] = 2235
				order[21] = 2236
				order[22] = 2409
				order[23] = 2410
				order[24] = 2237
				order[25] = 2238
				order[26] = 2239
				order[27] = 2240
				order[28] = 2241
				order[29] = 41382
				order[30] = 41389
				order[31] = 41390
				order[32] = 41391
				order[33] = 41392
				order[34] = 41393
				order[35] = 41394
				order[36] = 41395
				order[37] = 41396
				order[38] = 41397
				order[39] = 41379
				order[40] = 2242
				order[41] = 2243
				order[42] = 2244
				order[43] = 2245
				order[44] = 2246
				order[45] = 41398
				order[46] = 41366
				order[47] = 2608
				order[48] = 2609
				order[49] = 2610
				order[50] = 2248
				order[51] = 2249
				order[52] = 0
				fix.Group.__init__(self, 2218, 2219, order)

			class NoLegComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2251
					order[1] = 2252
					order[2] = 2253
					order[3] = 0
					fix.Group.__init__(self, 2250, 2251, order)

				class NoLegComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2204
						order[1] = 2247
						order[2] = 0
						fix.Group.__init__(self, 2253, 2204, order)

			class NoLegComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41383
					order[1] = 41384
					order[2] = 41385
					order[3] = 41386
					order[4] = 0
					fix.Group.__init__(self, 41382, 41383, order)

			class NoLegComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41388
					order[1] = 0
					fix.Group.__init__(self, 41387, 41388, order)

			class NoLegComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41380
					order[1] = 41381
					order[2] = 41400
					order[3] = 41376
					order[4] = 41363
					order[5] = 0
					fix.Group.__init__(self, 41379, 41380, order)

				class NoLegComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41401
						order[1] = 41402
						order[2] = 41403
						order[3] = 41404
						order[4] = 41405
						order[5] = 0
						fix.Group.__init__(self, 41400, 41401, order)

				class NoLegComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41377
						order[1] = 41378
						order[2] = 0
						fix.Group.__init__(self, 41376, 41377, order)

				class NoLegComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41364
						order[1] = 41365
						order[2] = 0
						fix.Group.__init__(self, 41363, 41364, order)

			class NoLegComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41399
					order[1] = 0
					fix.Group.__init__(self, 41398, 41399, order)

			class NoLegComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41367
					order[1] = 41368
					order[2] = 41369
					order[3] = 41370
					order[4] = 41371
					order[5] = 41372
					order[6] = 41373
					order[7] = 41374
					order[8] = 0
					fix.Group.__init__(self, 41366, 41367, order)

				class NoLegComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41375
						order[1] = 0
						fix.Group.__init__(self, 41374, 41375, order)

		class NoLegBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40924
				order[1] = 0
				fix.Group.__init__(self, 40923, 40924, order)

		class NoLegPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41608
				order[1] = 0
				fix.Group.__init__(self, 41607, 41608, order)

		class NoLegMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41468
				order[1] = 40223
				order[2] = 0
				fix.Group.__init__(self, 41467, 41468, order)

		class NoLegMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41470
				order[1] = 40990
				order[2] = 0
				fix.Group.__init__(self, 41469, 41470, order)

		class NoLegMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41472
				order[1] = 41473
				order[2] = 41474
				order[3] = 41475
				order[4] = 41476
				order[5] = 41477
				order[6] = 41478
				order[7] = 41479
				order[8] = 41480
				order[9] = 0
				fix.Group.__init__(self, 41471, 41472, order)

		class NoLegSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42582
				order[1] = 0
				fix.Group.__init__(self, 42581, 42582, order)

		class NoLegOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41492
				order[1] = 0
				fix.Group.__init__(self, 41491, 41492, order)

		class NoLegOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41513
				order[1] = 41514
				order[2] = 0
				fix.Group.__init__(self, 41512, 41513, order)

		class NoLegOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41516
				order[1] = 0
				fix.Group.__init__(self, 41515, 41516, order)

		class NoLegOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41528
				order[1] = 41529
				order[2] = 0
				fix.Group.__init__(self, 41527, 41528, order)

		class NoLegStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40242
				order[1] = 41700
				order[2] = 40243
				order[3] = 42583
				order[4] = 42584
				order[5] = 40244
				order[6] = 40245
				order[7] = 41702
				order[8] = 40246
				order[9] = 40247
				order[10] = 42585
				order[11] = 42586
				order[12] = 41703
				order[13] = 41704
				order[14] = 41705
				order[15] = 41706
				order[16] = 41707
				order[17] = 41708
				order[18] = 41648
				order[19] = 41649
				order[20] = 41650
				order[21] = 41651
				order[22] = 41652
				order[23] = 41653
				order[24] = 41654
				order[25] = 42588
				order[26] = 41655
				order[27] = 41656
				order[28] = 41657
				order[29] = 41658
				order[30] = 41659
				order[31] = 41660
				order[32] = 41661
				order[33] = 41662
				order[34] = 41663
				order[35] = 41664
				order[36] = 41665
				order[37] = 41666
				order[38] = 41667
				order[39] = 41668
				order[40] = 41669
				order[41] = 41670
				order[42] = 41671
				order[43] = 41672
				order[44] = 41673
				order[45] = 40249
				order[46] = 40250
				order[47] = 40252
				order[48] = 40253
				order[49] = 40254
				order[50] = 40255
				order[51] = 40256
				order[52] = 40257
				order[53] = 40258
				order[54] = 40260
				order[55] = 40261
				order[56] = 40262
				order[57] = 40263
				order[58] = 40264
				order[59] = 41641
				order[60] = 41642
				order[61] = 40265
				order[62] = 40267
				order[63] = 40268
				order[64] = 40270
				order[65] = 40271
				order[66] = 40272
				order[67] = 40273
				order[68] = 40274
				order[69] = 40275
				order[70] = 40276
				order[71] = 41643
				order[72] = 41644
				order[73] = 41645
				order[74] = 40279
				order[75] = 40280
				order[76] = 40281
				order[77] = 42399
				order[78] = 40282
				order[79] = 40283
				order[80] = 43108
				order[81] = 40284
				order[82] = 40285
				order[83] = 40286
				order[84] = 40287
				order[85] = 40288
				order[86] = 42400
				order[87] = 42401
				order[88] = 42402
				order[89] = 42403
				order[90] = 40289
				order[91] = 40290
				order[92] = 40291
				order[93] = 41549
				order[94] = 41550
				order[95] = 41551
				order[96] = 41552
				order[97] = 41553
				order[98] = 41554
				order[99] = 41555
				order[100] = 42404
				order[101] = 40374
				order[102] = 40418
				order[103] = 41429
				order[104] = 41430
				order[105] = 41431
				order[106] = 41432
				order[107] = 41433
				order[108] = 42194
				order[109] = 42195
				order[110] = 41434
				order[111] = 41435
				order[112] = 41436
				order[113] = 41437
				order[114] = 41438
				order[115] = 41219
				order[116] = 41439
				order[117] = 41440
				order[118] = 41441
				order[119] = 41442
				order[120] = 41443
				order[121] = 41444
				order[122] = 41445
				order[123] = 41446
				order[124] = 41447
				order[125] = 41448
				order[126] = 41449
				order[127] = 41450
				order[128] = 41451
				order[129] = 43095
				order[130] = 41408
				order[131] = 40248
				order[132] = 40978
				order[133] = 40979
				order[134] = 0
				fix.Group.__init__(self, 40241, 40242, order)

			class NoLegStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41675
					order[1] = 41676
					order[2] = 0
					fix.Group.__init__(self, 41674, 41675, order)

			class NoLegStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41453
					order[1] = 41454
					order[2] = 41455
					order[3] = 0
					fix.Group.__init__(self, 41452, 41453, order)

			class NoLegStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41678
					order[1] = 41679
					order[2] = 0
					fix.Group.__init__(self, 41677, 41678, order)

			class NoLegStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41647
					order[1] = 0
					fix.Group.__init__(self, 41646, 41647, order)

			class NoLegStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41687
					order[1] = 41688
					order[2] = 41689
					order[3] = 41690
					order[4] = 41691
					order[5] = 41692
					order[6] = 41693
					order[7] = 41694
					order[8] = 41695
					order[9] = 41696
					order[10] = 41697
					order[11] = 41680
					order[12] = 41698
					order[13] = 41699
					order[14] = 0
					fix.Group.__init__(self, 41686, 41687, order)

				class NoLegStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41681
						order[1] = 41682
						order[2] = 41683
						order[3] = 0
						fix.Group.__init__(self, 41680, 41681, order)

					class NoLegStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41684
							order[1] = 41685
							order[2] = 41935
							order[3] = 0
							fix.Group.__init__(self, 41683, 41684, order)

			class NoLegStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40251
					order[1] = 0
					fix.Group.__init__(self, 40942, 40251, order)

			class NoLegStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40259
					order[1] = 0
					fix.Group.__init__(self, 40943, 40259, order)

			class NoLegStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40266
					order[1] = 0
					fix.Group.__init__(self, 40940, 40266, order)

			class NoLegStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41639
					order[1] = 41640
					order[2] = 0
					fix.Group.__init__(self, 41638, 41639, order)

			class NoLegStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40269
					order[1] = 0
					fix.Group.__init__(self, 40941, 40269, order)

			class NoLegPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40293
					order[1] = 0
					fix.Group.__init__(self, 40930, 40293, order)

			class NoLegPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41590
					order[1] = 41591
					order[2] = 0
					fix.Group.__init__(self, 41589, 41590, order)

			class NoLegPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40305
					order[1] = 0
					fix.Group.__init__(self, 40931, 40305, order)

			class NoLegPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40311
					order[1] = 0
					fix.Group.__init__(self, 40932, 40311, order)

			class NoLegPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40318
					order[1] = 0
					fix.Group.__init__(self, 40933, 40318, order)

			class NoLegPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42460
					order[1] = 42461
					order[2] = 0
					fix.Group.__init__(self, 42459, 42460, order)

			class NoLegPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41562
					order[1] = 0
					fix.Group.__init__(self, 41561, 41562, order)

			class NoLegPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41597
					order[1] = 41598
					order[2] = 0
					fix.Group.__init__(self, 41596, 41597, order)

			class NoLegPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41594
					order[1] = 41595
					order[2] = 0
					fix.Group.__init__(self, 41593, 41594, order)

			class NoLegPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43110
					order[1] = 42486
					order[2] = 42487
					order[3] = 0
					fix.Group.__init__(self, 42485, 43110, order)

			class NoLegDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42367
					order[1] = 42368
					order[2] = 42369
					order[3] = 42370
					order[4] = 42371
					order[5] = 42372
					order[6] = 42386
					order[7] = 42373
					order[8] = 42374
					order[9] = 42375
					order[10] = 42376
					order[11] = 42377
					order[12] = 42378
					order[13] = 42379
					order[14] = 42380
					order[15] = 42381
					order[16] = 42382
					order[17] = 42383
					order[18] = 42384
					order[19] = 42385
					order[20] = 0
					fix.Group.__init__(self, 42366, 42367, order)

				class NoLegDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42387
						order[1] = 0
						fix.Group.__init__(self, 42386, 42387, order)

			class NoLegDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42365
					order[1] = 0
					fix.Group.__init__(self, 42364, 42365, order)

			class NoLegDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42311
					order[1] = 0
					fix.Group.__init__(self, 42310, 42311, order)

			class NoLegReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 42535
					order[1] = 42536
					order[2] = 42537
					order[3] = 42538
					order[4] = 42539
					order[5] = 42540
					order[6] = 42564
					order[7] = 42530
					order[8] = 42541
					order[9] = 42542
					order[10] = 42543
					order[11] = 42544
					order[12] = 42545
					order[13] = 42546
					order[14] = 42547
					order[15] = 42548
					order[16] = 42549
					order[17] = 42550
					order[18] = 42551
					order[19] = 42552
					order[20] = 42560
					order[21] = 42553
					order[22] = 42554
					order[23] = 42508
					order[24] = 42555
					order[25] = 42556
					order[26] = 42557
					order[27] = 42558
					order[28] = 42559
					order[29] = 0
					fix.Group.__init__(self, 42534, 42535, order)

				class NoLegReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 42565
						order[1] = 42566
						order[2] = 42567
						order[3] = 42568
						order[4] = 0
						fix.Group.__init__(self, 42564, 42565, order)

				class NoLegReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42531
						order[1] = 42532
						order[2] = 42533
						order[3] = 0
						fix.Group.__init__(self, 42530, 42531, order)

				class NoLegReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42561
						order[1] = 42562
						order[2] = 42563
						order[3] = 0
						fix.Group.__init__(self, 42560, 42561, order)

				class NoLegReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 42509
						order[1] = 42571
						order[2] = 42510
						order[3] = 42511
						order[4] = 42512
						order[5] = 42513
						order[6] = 42514
						order[7] = 42515
						order[8] = 42516
						order[9] = 42517
						order[10] = 42518
						order[11] = 42519
						order[12] = 42520
						order[13] = 42521
						order[14] = 42522
						order[15] = 42523
						order[16] = 42524
						order[17] = 42525
						order[18] = 42526
						order[19] = 42527
						order[20] = 42528
						order[21] = 42529
						order[22] = 42569
						order[23] = 0
						fix.Group.__init__(self, 42508, 42509, order)

					class NoLegReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 42572
							order[1] = 42573
							order[2] = 0
							fix.Group.__init__(self, 42571, 42572, order)

					class NoLegReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 42570
							order[1] = 0
							fix.Group.__init__(self, 42569, 42570, order)

			class NoLegPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42420
					order[1] = 0
					fix.Group.__init__(self, 42419, 42420, order)

			class NoLegPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42406
					order[1] = 42407
					order[2] = 0
					fix.Group.__init__(self, 42405, 42406, order)

			class NoLegPaymentStreamNonDeliverableFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40361
					order[1] = 0
					fix.Group.__init__(self, 40929, 40361, order)

			class NoLegNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40368
					order[1] = 40369
					order[2] = 0
					fix.Group.__init__(self, 40367, 40368, order)

			class NoLegSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40903
					order[1] = 40366
					order[2] = 40370
					order[3] = 40905
					order[4] = 40906
					order[5] = 0
					fix.Group.__init__(self, 40902, 40903, order)

			class NoLegPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40375
					order[1] = 41533
					order[2] = 41534
					order[3] = 40376
					order[4] = 40377
					order[5] = 40378
					order[6] = 40379
					order[7] = 40380
					order[8] = 40381
					order[9] = 40382
					order[10] = 40383
					order[11] = 40384
					order[12] = 40385
					order[13] = 41535
					order[14] = 41536
					order[15] = 41537
					order[16] = 41538
					order[17] = 40386
					order[18] = 40387
					order[19] = 40388
					order[20] = 40389
					order[21] = 41539
					order[22] = 41540
					order[23] = 41541
					order[24] = 41542
					order[25] = 40390
					order[26] = 40391
					order[27] = 40392
					order[28] = 40393
					order[29] = 40394
					order[30] = 40395
					order[31] = 40414
					order[32] = 40396
					order[33] = 40397
					order[34] = 40398
					order[35] = 40399
					order[36] = 40927
					order[37] = 40401
					order[38] = 40402
					order[39] = 40403
					order[40] = 41543
					order[41] = 41544
					order[42] = 40404
					order[43] = 41530
					order[44] = 41545
					order[45] = 41546
					order[46] = 41547
					order[47] = 41548
					order[48] = 40405
					order[49] = 40406
					order[50] = 40407
					order[51] = 40408
					order[52] = 40928
					order[53] = 40410
					order[54] = 40411
					order[55] = 40412
					order[56] = 40413
					order[57] = 0
					fix.Group.__init__(self, 40374, 40375, order)

				class NoLegPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40415
						order[1] = 40416
						order[2] = 40417
						order[3] = 0
						fix.Group.__init__(self, 40414, 40415, order)

				class NoLegPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40400
						order[1] = 0
						fix.Group.__init__(self, 40927, 40400, order)

				class NoLegPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41531
						order[1] = 41532
						order[2] = 0
						fix.Group.__init__(self, 41530, 41531, order)

				class NoLegPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40409
						order[1] = 0
						fix.Group.__init__(self, 40928, 40409, order)

			class NoLegPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40419
					order[1] = 40420
					order[2] = 42497
					order[3] = 42498
					order[4] = 42499
					order[5] = 42500
					order[6] = 42501
					order[7] = 42502
					order[8] = 42503
					order[9] = 42488
					order[10] = 42489
					order[11] = 42490
					order[12] = 42491
					order[13] = 42492
					order[14] = 42493
					order[15] = 42494
					order[16] = 40421
					order[17] = 40422
					order[18] = 40423
					order[19] = 40424
					order[20] = 40425
					order[21] = 40426
					order[22] = 40427
					order[23] = 40428
					order[24] = 40429
					order[25] = 40430
					order[26] = 40431
					order[27] = 40432
					order[28] = 40433
					order[29] = 40434
					order[30] = 40435
					order[31] = 40436
					order[32] = 40437
					order[33] = 40438
					order[34] = 40439
					order[35] = 40440
					order[36] = 40441
					order[37] = 40442
					order[38] = 40443
					order[39] = 40444
					order[40] = 40445
					order[41] = 40446
					order[42] = 40447
					order[43] = 0
					fix.Group.__init__(self, 40418, 40419, order)

				class NoLegPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42505
						order[1] = 0
						fix.Group.__init__(self, 42504, 42505, order)

				class NoLegPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42496
						order[1] = 0
						fix.Group.__init__(self, 42495, 42496, order)

			class NoLegDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41461
					order[1] = 0
					fix.Group.__init__(self, 41460, 41461, order)

			class NoLegDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41457
					order[1] = 41458
					order[2] = 41459
					order[3] = 0
					fix.Group.__init__(self, 41456, 41457, order)

			class NoLegDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41409
					order[1] = 41410
					order[2] = 41411
					order[3] = 41412
					order[4] = 41413
					order[5] = 41414
					order[6] = 41415
					order[7] = 41416
					order[8] = 41417
					order[9] = 41418
					order[10] = 41419
					order[11] = 41420
					order[12] = 41421
					order[13] = 41422
					order[14] = 0
					fix.Group.__init__(self, 41408, 41409, order)

				class NoLegDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41423
						order[1] = 41424
						order[2] = 41425
						order[3] = 0
						fix.Group.__init__(self, 41422, 41423, order)

					class NoLegDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41426
							order[1] = 41427
							order[2] = 41428
							order[3] = 0
							fix.Group.__init__(self, 41425, 41426, order)

		class NoLegProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 40449
				order[1] = 40450
				order[2] = 40451
				order[3] = 40939
				order[4] = 40453
				order[5] = 40454
				order[6] = 40455
				order[7] = 42506
				order[8] = 42507
				order[9] = 40456
				order[10] = 40457
				order[11] = 40458
				order[12] = 40524
				order[13] = 40525
				order[14] = 40526
				order[15] = 40528
				order[16] = 40529
				order[17] = 40530
				order[18] = 40531
				order[19] = 40532
				order[20] = 40476
				order[21] = 40478
				order[22] = 40479
				order[23] = 40480
				order[24] = 40481
				order[25] = 40482
				order[26] = 40483
				order[27] = 40484
				order[28] = 40485
				order[29] = 40486
				order[30] = 40487
				order[31] = 40488
				order[32] = 40489
				order[33] = 40490
				order[34] = 40491
				order[35] = 40492
				order[36] = 40493
				order[37] = 40494
				order[38] = 40498
				order[39] = 40499
				order[40] = 40501
				order[41] = 40502
				order[42] = 40503
				order[43] = 40504
				order[44] = 40505
				order[45] = 40506
				order[46] = 40507
				order[47] = 40508
				order[48] = 40509
				order[49] = 40511
				order[50] = 40512
				order[51] = 40513
				order[52] = 40514
				order[53] = 40515
				order[54] = 40459
				order[55] = 40460
				order[56] = 40461
				order[57] = 40462
				order[58] = 40463
				order[59] = 40464
				order[60] = 40465
				order[61] = 40516
				order[62] = 40518
				order[63] = 40519
				order[64] = 40520
				order[65] = 40521
				order[66] = 40522
				order[67] = 40523
				order[68] = 40466
				order[69] = 40467
				order[70] = 40468
				order[71] = 40469
				order[72] = 40470
				order[73] = 41407
				order[74] = 40472
				order[75] = 40980
				order[76] = 40981
				order[77] = 40533
				order[78] = 0
				fix.Group.__init__(self, 40448, 40449, order)

			class NoLegProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40452
					order[1] = 0
					fix.Group.__init__(self, 40939, 40452, order)

			class NoLegProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40527
					order[1] = 0
					fix.Group.__init__(self, 40935, 40527, order)

			class NoLegProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40477
					order[1] = 0
					fix.Group.__init__(self, 40936, 40477, order)

			class NoLegProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40496
					order[1] = 40497
					order[2] = 0
					fix.Group.__init__(self, 40495, 40496, order)

			class NoLegProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40500
					order[1] = 0
					fix.Group.__init__(self, 40937, 40500, order)

			class NoLegProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40510
					order[1] = 0
					fix.Group.__init__(self, 40938, 40510, order)

			class NoLegProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40517
					order[1] = 0
					fix.Group.__init__(self, 40934, 40517, order)

			class NoLegProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40474
					order[1] = 40475
					order[2] = 0
					fix.Group.__init__(self, 40473, 40474, order)

			class NoLegProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40534
					order[1] = 40535
					order[2] = 40536
					order[3] = 2380
					order[4] = 40537
					order[5] = 0
					fix.Group.__init__(self, 40533, 40534, order)

				class NoLegProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40538
						order[1] = 40539
						order[2] = 0
						fix.Group.__init__(self, 40537, 40538, order)

		class NoLegAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41336
				order[1] = 41337
				order[2] = 41316
				order[3] = 0
				fix.Group.__init__(self, 41335, 41336, order)

			class NoLegAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41317
					order[1] = 41318
					order[2] = 41319
					order[3] = 41320
					order[4] = 41321
					order[5] = 41322
					order[6] = 41323
					order[7] = 41324
					order[8] = 41325
					order[9] = 41326
					order[10] = 41327
					order[11] = 41328
					order[12] = 41329
					order[13] = 41330
					order[14] = 41331
					order[15] = 41332
					order[16] = 41333
					order[17] = 41334
					order[18] = 0
					fix.Group.__init__(self, 41316, 41317, order)

		class NoLegProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 41618
				order[1] = 41619
				order[2] = 41620
				order[3] = 41621
				order[4] = 41622
				order[5] = 41623
				order[6] = 41624
				order[7] = 41614
				order[8] = 41625
				order[9] = 41635
				order[10] = 41617
				order[11] = 0
				fix.Group.__init__(self, 41616, 41618, order)

			class NoLegProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41615
					order[1] = 0
					fix.Group.__init__(self, 41614, 41615, order)

			class NoLegProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41626
					order[1] = 41627
					order[2] = 41628
					order[3] = 41629
					order[4] = 41630
					order[5] = 41631
					order[6] = 41632
					order[7] = 41633
					order[8] = 0
					fix.Group.__init__(self, 41625, 41626, order)

				class NoLegProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41634
						order[1] = 0
						fix.Group.__init__(self, 41633, 41634, order)

			class NoLegProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41636
					order[1] = 41637
					order[2] = 0
					fix.Group.__init__(self, 41635, 41636, order)

		class NoLegCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 41345
				order[1] = 41346
				order[2] = 41347
				order[3] = 41348
				order[4] = 41349
				order[5] = 41350
				order[6] = 41351
				order[7] = 41352
				order[8] = 41353
				order[9] = 41354
				order[10] = 41355
				order[11] = 41342
				order[12] = 42308
				order[13] = 42309
				order[14] = 41356
				order[15] = 41357
				order[16] = 42299
				order[17] = 42300
				order[18] = 42301
				order[19] = 42302
				order[20] = 42303
				order[21] = 42304
				order[22] = 42305
				order[23] = 41358
				order[24] = 41359
				order[25] = 41360
				order[26] = 41361
				order[27] = 41362
				order[28] = 0
				fix.Group.__init__(self, 41344, 41345, order)

			class NoLegCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41343
					order[1] = 0
					fix.Group.__init__(self, 41342, 41343, order)

			class NoLegCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42307
					order[1] = 0
					fix.Group.__init__(self, 42306, 42307, order)

		class NoLegPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41604
				order[1] = 41601
				order[2] = 41602
				order[3] = 41603
				order[4] = 41600
				order[5] = 0
				fix.Group.__init__(self, 41599, 41604, order)

			class NoLegPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41605
					order[1] = 41606
					order[2] = 0
					fix.Group.__init__(self, 41604, 41605, order)

		class NoLegExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42389
				order[1] = 42390
				order[2] = 0
				fix.Group.__init__(self, 42388, 42389, order)

		class NoLegStipulations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 688
				order[1] = 689
				order[2] = 0
				fix.Group.__init__(self, 683, 688, order)

	class NoPriceQualifiers(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 2710
			order[1] = 0
			fix.Group.__init__(self, 2709, 2710, order)

	class NoIOIQualifiers(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 104
			order[1] = 0
			fix.Group.__init__(self, 199, 104, order)

	class NoRoutingIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 216
			order[1] = 217
			order[2] = 0
			fix.Group.__init__(self, 215, 216, order)

	class NoRelativeValues(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 2530
			order[1] = 2531
			order[2] = 2532
			order[3] = 0
			fix.Group.__init__(self, 2529, 2530, order)

class Advertisement(Message):
	def __init__(self):
		Message.__init__(self)
		self.getHeader().setField( fix.MsgType("7") )

	class NoSecurityAltID(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 455
			order[1] = 456
			order[2] = 2957
			order[3] = 0
			fix.Group.__init__(self, 454, 455, order)

	class NoSecondaryAssetClasses(fix.Group):
		def __init__(self):
			order = fix.IntArray(5)
			order[0] = 1977
			order[1] = 1978
			order[2] = 1979
			order[3] = 2741
			order[4] = 0
			fix.Group.__init__(self, 1976, 1977, order)

	class NoAssetAttributes(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 2305
			order[1] = 2306
			order[2] = 2307
			order[3] = 0
			fix.Group.__init__(self, 2304, 2305, order)

	class NoEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(11)
			order[0] = 865
			order[1] = 866
			order[2] = 1145
			order[3] = 1827
			order[4] = 1826
			order[5] = 2340
			order[6] = 867
			order[7] = 868
			order[8] = 1578
			order[9] = 1579
			order[10] = 0
			fix.Group.__init__(self, 864, 865, order)

	class NoInstrumentParties(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1019
			order[1] = 1050
			order[2] = 1051
			order[3] = 2378
			order[4] = 1052
			order[5] = 0
			fix.Group.__init__(self, 1018, 1019, order)

		class NoInstrumentPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 1053
				order[1] = 1054
				order[2] = 0
				fix.Group.__init__(self, 1052, 1053, order)

	class NoComplexEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(53)
			order[0] = 1484
			order[1] = 2117
			order[2] = 2118
			order[3] = 2119
			order[4] = 1485
			order[5] = 2120
			order[6] = 2121
			order[7] = 2122
			order[8] = 2941
			order[9] = 1486
			order[10] = 2123
			order[11] = 1487
			order[12] = 1488
			order[13] = 1489
			order[14] = 1490
			order[15] = 1491
			order[16] = 2124
			order[17] = 2942
			order[18] = 2125
			order[19] = 2943
			order[20] = 2126
			order[21] = 2127
			order[22] = 2407
			order[23] = 2408
			order[24] = 2128
			order[25] = 2129
			order[26] = 2130
			order[27] = 2131
			order[28] = 2132
			order[29] = 41013
			order[30] = 41020
			order[31] = 41021
			order[32] = 41022
			order[33] = 41023
			order[34] = 41024
			order[35] = 41025
			order[36] = 41026
			order[37] = 41027
			order[38] = 41028
			order[39] = 41010
			order[40] = 2133
			order[41] = 2134
			order[42] = 2135
			order[43] = 2136
			order[44] = 2137
			order[45] = 41029
			order[46] = 40997
			order[47] = 2597
			order[48] = 2598
			order[49] = 2599
			order[50] = 2138
			order[51] = 2139
			order[52] = 0
			fix.Group.__init__(self, 1483, 1484, order)

		class NoComplexEventDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 1492
				order[1] = 1493
				order[2] = 1494
				order[3] = 0
				fix.Group.__init__(self, 1491, 1492, order)

			class NoComplexEventTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1495
					order[1] = 1496
					order[2] = 0
					fix.Group.__init__(self, 1494, 1495, order)

		class NoComplexEventRateSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 41014
				order[1] = 41015
				order[2] = 41016
				order[3] = 41017
				order[4] = 0
				fix.Group.__init__(self, 41013, 41014, order)

		class NoComplexEventDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41019
				order[1] = 0
				fix.Group.__init__(self, 41018, 41019, order)

		class NoComplexEventPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41011
				order[1] = 41012
				order[2] = 41031
				order[3] = 41007
				order[4] = 40994
				order[5] = 0
				fix.Group.__init__(self, 41010, 41011, order)

			class NoComplexEventSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41032
					order[1] = 41033
					order[2] = 41034
					order[3] = 41035
					order[4] = 41036
					order[5] = 0
					fix.Group.__init__(self, 41031, 41032, order)

			class NoComplexEventPeriodDateTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41008
					order[1] = 41009
					order[2] = 0
					fix.Group.__init__(self, 41007, 41008, order)

			class NoComplexEventAveragingObservations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40995
					order[1] = 40996
					order[2] = 0
					fix.Group.__init__(self, 40994, 40995, order)

		class NoComplexEventCreditEventSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41030
				order[1] = 0
				fix.Group.__init__(self, 41029, 41030, order)

		class NoComplexEventCreditEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40998
				order[1] = 40999
				order[2] = 41000
				order[3] = 41001
				order[4] = 41002
				order[5] = 41003
				order[6] = 41004
				order[7] = 41005
				order[8] = 0
				fix.Group.__init__(self, 40997, 40998, order)

			class NoComplexEventCreditEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41006
					order[1] = 0
					fix.Group.__init__(self, 41005, 41006, order)

	class NoBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40471
			order[1] = 0
			fix.Group.__init__(self, 40278, 40471, order)

	class NoPricingDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41231
			order[1] = 0
			fix.Group.__init__(self, 41230, 41231, order)

	class NoMarketDisruptionEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41093
			order[1] = 40991
			order[2] = 0
			fix.Group.__init__(self, 41092, 41093, order)

	class NoMarketDisruptionFallbacks(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41095
			order[1] = 40992
			order[2] = 0
			fix.Group.__init__(self, 41094, 41095, order)

	class NoMarketDisruptionFallbackReferencePrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(10)
			order[0] = 41097
			order[1] = 41098
			order[2] = 41099
			order[3] = 41100
			order[4] = 41101
			order[5] = 41102
			order[6] = 41103
			order[7] = 41104
			order[8] = 41105
			order[9] = 0
			fix.Group.__init__(self, 41096, 41097, order)

	class NoSettlMethodElectionDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 42776
			order[1] = 0
			fix.Group.__init__(self, 42775, 42776, order)

	class NoOptionExerciseBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41117
			order[1] = 0
			fix.Group.__init__(self, 41116, 41117, order)

	class NoOptionExerciseDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41138
			order[1] = 41139
			order[2] = 0
			fix.Group.__init__(self, 41137, 41138, order)

	class NoOptionExerciseExpirationDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41141
			order[1] = 0
			fix.Group.__init__(self, 41140, 41141, order)

	class NoOptionExerciseExpirationDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41153
			order[1] = 41154
			order[2] = 0
			fix.Group.__init__(self, 41152, 41153, order)

	class NoStreams(fix.Group):
		def __init__(self):
			order = fix.IntArray(135)
			order[0] = 40050
			order[1] = 41303
			order[2] = 40051
			order[3] = 42784
			order[4] = 42785
			order[5] = 40052
			order[6] = 40053
			order[7] = 41305
			order[8] = 40054
			order[9] = 40055
			order[10] = 42786
			order[11] = 42787
			order[12] = 41306
			order[13] = 41307
			order[14] = 41308
			order[15] = 41309
			order[16] = 41310
			order[17] = 41311
			order[18] = 41251
			order[19] = 41252
			order[20] = 41253
			order[21] = 41254
			order[22] = 41255
			order[23] = 41256
			order[24] = 41257
			order[25] = 42587
			order[26] = 41258
			order[27] = 41259
			order[28] = 41260
			order[29] = 41261
			order[30] = 41262
			order[31] = 41263
			order[32] = 41264
			order[33] = 41265
			order[34] = 41266
			order[35] = 41267
			order[36] = 41268
			order[37] = 41269
			order[38] = 41270
			order[39] = 41271
			order[40] = 41272
			order[41] = 41273
			order[42] = 41274
			order[43] = 41275
			order[44] = 41276
			order[45] = 40907
			order[46] = 40908
			order[47] = 40910
			order[48] = 40911
			order[49] = 40912
			order[50] = 40913
			order[51] = 40914
			order[52] = 40065
			order[53] = 40066
			order[54] = 40068
			order[55] = 40069
			order[56] = 40070
			order[57] = 40071
			order[58] = 40072
			order[59] = 41244
			order[60] = 41245
			order[61] = 40073
			order[62] = 40075
			order[63] = 40076
			order[64] = 40078
			order[65] = 40079
			order[66] = 40080
			order[67] = 40081
			order[68] = 40082
			order[69] = 40083
			order[70] = 40084
			order[71] = 41246
			order[72] = 41247
			order[73] = 41248
			order[74] = 40738
			order[75] = 40739
			order[76] = 40740
			order[77] = 42600
			order[78] = 40741
			order[79] = 40742
			order[80] = 43106
			order[81] = 40743
			order[82] = 40744
			order[83] = 40745
			order[84] = 40746
			order[85] = 40747
			order[86] = 42601
			order[87] = 42602
			order[88] = 42603
			order[89] = 42604
			order[90] = 40748
			order[91] = 40749
			order[92] = 40750
			order[93] = 41180
			order[94] = 41181
			order[95] = 41182
			order[96] = 41183
			order[97] = 41184
			order[98] = 41185
			order[99] = 41186
			order[100] = 42605
			order[101] = 40828
			order[102] = 40872
			order[103] = 41058
			order[104] = 41059
			order[105] = 41060
			order[106] = 41061
			order[107] = 41062
			order[108] = 42192
			order[109] = 42193
			order[110] = 41063
			order[111] = 41064
			order[112] = 41065
			order[113] = 41066
			order[114] = 41067
			order[115] = 41218
			order[116] = 41068
			order[117] = 41069
			order[118] = 41070
			order[119] = 41071
			order[120] = 41072
			order[121] = 41073
			order[122] = 41074
			order[123] = 41075
			order[124] = 41076
			order[125] = 41077
			order[126] = 41078
			order[127] = 41079
			order[128] = 41080
			order[129] = 43094
			order[130] = 41037
			order[131] = 40056
			order[132] = 40982
			order[133] = 40983
			order[134] = 0
			fix.Group.__init__(self, 40049, 40050, order)

		class NoStreamCommodityAltIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41278
				order[1] = 41279
				order[2] = 0
				fix.Group.__init__(self, 41277, 41278, order)

		class NoStreamAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41238
				order[1] = 41239
				order[2] = 41240
				order[3] = 0
				fix.Group.__init__(self, 41237, 41238, order)

		class NoStreamCommodityDataSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41281
				order[1] = 41282
				order[2] = 0
				fix.Group.__init__(self, 41280, 41281, order)

		class NoStreamCommoditySettlBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41250
				order[1] = 0
				fix.Group.__init__(self, 41249, 41250, order)

		class NoStreamCommoditySettlPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41290
				order[1] = 41291
				order[2] = 41292
				order[3] = 41293
				order[4] = 41294
				order[5] = 41295
				order[6] = 41296
				order[7] = 41297
				order[8] = 41298
				order[9] = 41299
				order[10] = 41300
				order[11] = 41283
				order[12] = 41301
				order[13] = 41302
				order[14] = 0
				fix.Group.__init__(self, 41289, 41290, order)

			class NoStreamCommoditySettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41284
					order[1] = 41285
					order[2] = 41286
					order[3] = 0
					fix.Group.__init__(self, 41283, 41284, order)

				class NoStreamCommoditySettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41287
						order[1] = 41288
						order[2] = 41588
						order[3] = 0
						fix.Group.__init__(self, 41286, 41287, order)

		class NoStreamEffectiveDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40909
				order[1] = 0
				fix.Group.__init__(self, 40960, 40909, order)

		class NoStreamTerminationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40067
				order[1] = 0
				fix.Group.__init__(self, 40961, 40067, order)

		class NoStreamCalculationPeriodBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40074
				order[1] = 0
				fix.Group.__init__(self, 40958, 40074, order)

		class NoStreamCalculationPeriodDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41242
				order[1] = 41243
				order[2] = 0
				fix.Group.__init__(self, 41241, 41242, order)

		class NoStreamFirstPeriodStartDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40077
				order[1] = 0
				fix.Group.__init__(self, 40959, 40077, order)

		class NoPaymentStreamPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40752
				order[1] = 0
				fix.Group.__init__(self, 40947, 40752, order)

		class NoPaymentStreamPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41221
				order[1] = 41222
				order[2] = 0
				fix.Group.__init__(self, 41220, 41221, order)

		class NoPaymentStreamResetDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40763
				order[1] = 0
				fix.Group.__init__(self, 40948, 40763, order)

		class NoPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40769
				order[1] = 0
				fix.Group.__init__(self, 40949, 40769, order)

		class NoPaymentStreamFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40776
				order[1] = 0
				fix.Group.__init__(self, 40950, 40776, order)

		class NoPaymentStreamFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42661
				order[1] = 42662
				order[2] = 0
				fix.Group.__init__(self, 42660, 42661, order)

		class NoPaymentStreamPricingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41193
				order[1] = 0
				fix.Group.__init__(self, 41192, 41193, order)

		class NoPaymentStreamPricingDays(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41228
				order[1] = 41229
				order[2] = 0
				fix.Group.__init__(self, 41227, 41228, order)

		class NoPaymentStreamPricingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41225
				order[1] = 41226
				order[2] = 0
				fix.Group.__init__(self, 41224, 41225, order)

		class NoPaymentStreamFormulas(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 43109
				order[1] = 42684
				order[2] = 42685
				order[3] = 0
				fix.Group.__init__(self, 42683, 43109, order)

		class NoDividendPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(21)
				order[0] = 42275
				order[1] = 42276
				order[2] = 42277
				order[3] = 42278
				order[4] = 42279
				order[5] = 42280
				order[6] = 42294
				order[7] = 42281
				order[8] = 42282
				order[9] = 42283
				order[10] = 42284
				order[11] = 42285
				order[12] = 42286
				order[13] = 42287
				order[14] = 42288
				order[15] = 42289
				order[16] = 42290
				order[17] = 42291
				order[18] = 42292
				order[19] = 42293
				order[20] = 0
				fix.Group.__init__(self, 42274, 42275, order)

			class NoDividendPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42295
					order[1] = 0
					fix.Group.__init__(self, 42294, 42295, order)

		class NoDividendFXTriggerDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42273
				order[1] = 0
				fix.Group.__init__(self, 42272, 42273, order)

		class NoDividendAccrualPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42237
				order[1] = 0
				fix.Group.__init__(self, 42236, 42237, order)

		class NoReturnRates(fix.Group):
			def __init__(self):
				order = fix.IntArray(30)
				order[0] = 42736
				order[1] = 42737
				order[2] = 42738
				order[3] = 42739
				order[4] = 42740
				order[5] = 42741
				order[6] = 42765
				order[7] = 42731
				order[8] = 42742
				order[9] = 42743
				order[10] = 42744
				order[11] = 42745
				order[12] = 42746
				order[13] = 42747
				order[14] = 42748
				order[15] = 42749
				order[16] = 42750
				order[17] = 42751
				order[18] = 42752
				order[19] = 42753
				order[20] = 42761
				order[21] = 42754
				order[22] = 42755
				order[23] = 42709
				order[24] = 42756
				order[25] = 42757
				order[26] = 42758
				order[27] = 42759
				order[28] = 42760
				order[29] = 0
				fix.Group.__init__(self, 42735, 42736, order)

			class NoReturnRatePrices(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 42766
					order[1] = 42767
					order[2] = 42768
					order[3] = 42769
					order[4] = 0
					fix.Group.__init__(self, 42765, 42766, order)

			class NoReturnRateFXConversions(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42732
					order[1] = 42733
					order[2] = 42734
					order[3] = 0
					fix.Group.__init__(self, 42731, 42732, order)

			class NoReturnRateInformationSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42762
					order[1] = 42763
					order[2] = 42764
					order[3] = 0
					fix.Group.__init__(self, 42761, 42762, order)

			class NoReturnRateDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(24)
					order[0] = 42710
					order[1] = 42772
					order[2] = 42711
					order[3] = 42712
					order[4] = 42713
					order[5] = 42714
					order[6] = 42715
					order[7] = 42716
					order[8] = 42717
					order[9] = 42718
					order[10] = 42719
					order[11] = 42720
					order[12] = 42721
					order[13] = 42722
					order[14] = 42723
					order[15] = 42724
					order[16] = 42725
					order[17] = 42726
					order[18] = 42727
					order[19] = 42728
					order[20] = 42729
					order[21] = 42730
					order[22] = 42770
					order[23] = 0
					fix.Group.__init__(self, 42709, 42710, order)

				class NoReturnRateValuationDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42773
						order[1] = 42774
						order[2] = 0
						fix.Group.__init__(self, 42772, 42773, order)

				class NoReturnRateValuationDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42771
						order[1] = 0
						fix.Group.__init__(self, 42770, 42771, order)

		class NoPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42621
				order[1] = 0
				fix.Group.__init__(self, 42620, 42621, order)

		class NoPaymentStreamCompoundingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42607
				order[1] = 42608
				order[2] = 0
				fix.Group.__init__(self, 42606, 42607, order)

		class NoPaymentStreamNonDeliverableFixingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40819
				order[1] = 0
				fix.Group.__init__(self, 40946, 40819, order)

		class NoNonDeliverableFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40826
				order[1] = 40827
				order[2] = 0
				fix.Group.__init__(self, 40825, 40826, order)

		class NoSettlRateFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40086
				order[1] = 40373
				order[2] = 40655
				order[3] = 40088
				order[4] = 40089
				order[5] = 0
				fix.Group.__init__(self, 40085, 40086, order)

		class NoPaymentSchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(58)
				order[0] = 40829
				order[1] = 41164
				order[2] = 41165
				order[3] = 40830
				order[4] = 40831
				order[5] = 40832
				order[6] = 40833
				order[7] = 40834
				order[8] = 40835
				order[9] = 40836
				order[10] = 40837
				order[11] = 40838
				order[12] = 40839
				order[13] = 41166
				order[14] = 41167
				order[15] = 41168
				order[16] = 41169
				order[17] = 40840
				order[18] = 40841
				order[19] = 40842
				order[20] = 40843
				order[21] = 41170
				order[22] = 41171
				order[23] = 41172
				order[24] = 41173
				order[25] = 40844
				order[26] = 40845
				order[27] = 40846
				order[28] = 40847
				order[29] = 40848
				order[30] = 40849
				order[31] = 40868
				order[32] = 40850
				order[33] = 40851
				order[34] = 40852
				order[35] = 40853
				order[36] = 40977
				order[37] = 40855
				order[38] = 40856
				order[39] = 40857
				order[40] = 41174
				order[41] = 41175
				order[42] = 40858
				order[43] = 41161
				order[44] = 41176
				order[45] = 41177
				order[46] = 41178
				order[47] = 41179
				order[48] = 40859
				order[49] = 40860
				order[50] = 40861
				order[51] = 40862
				order[52] = 40945
				order[53] = 40864
				order[54] = 40865
				order[55] = 40866
				order[56] = 40867
				order[57] = 0
				fix.Group.__init__(self, 40828, 40829, order)

			class NoPaymentScheduleRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 40869
					order[1] = 40870
					order[2] = 40871
					order[3] = 0
					fix.Group.__init__(self, 40868, 40869, order)

			class NoPaymentScheduleFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40854
					order[1] = 0
					fix.Group.__init__(self, 40977, 40854, order)

			class NoPaymentScheduleFixingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41162
					order[1] = 41163
					order[2] = 0
					fix.Group.__init__(self, 41161, 41162, order)

			class NoPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40863
					order[1] = 0
					fix.Group.__init__(self, 40945, 40863, order)

		class NoPaymentStubs(fix.Group):
			def __init__(self):
				order = fix.IntArray(44)
				order[0] = 40873
				order[1] = 40874
				order[2] = 42698
				order[3] = 42699
				order[4] = 42700
				order[5] = 42701
				order[6] = 42702
				order[7] = 42703
				order[8] = 42704
				order[9] = 42689
				order[10] = 42690
				order[11] = 42691
				order[12] = 42692
				order[13] = 42693
				order[14] = 42694
				order[15] = 42695
				order[16] = 40875
				order[17] = 40876
				order[18] = 40877
				order[19] = 40878
				order[20] = 40879
				order[21] = 40880
				order[22] = 40881
				order[23] = 40882
				order[24] = 40883
				order[25] = 40884
				order[26] = 40885
				order[27] = 40886
				order[28] = 40887
				order[29] = 40888
				order[30] = 40889
				order[31] = 40890
				order[32] = 40891
				order[33] = 40892
				order[34] = 40893
				order[35] = 40894
				order[36] = 40895
				order[37] = 40896
				order[38] = 40897
				order[39] = 40898
				order[40] = 40899
				order[41] = 40900
				order[42] = 40901
				order[43] = 0
				fix.Group.__init__(self, 40872, 40873, order)

			class NoPaymentStubStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42706
					order[1] = 0
					fix.Group.__init__(self, 42705, 42706, order)

			class NoPaymentStubEndDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42697
					order[1] = 0
					fix.Group.__init__(self, 42696, 42697, order)

		class NoDeliveryStreamCommoditySources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41086
				order[1] = 0
				fix.Group.__init__(self, 41085, 41086, order)

		class NoDeliveryStreamCycles(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41082
				order[1] = 41083
				order[2] = 41084
				order[3] = 0
				fix.Group.__init__(self, 41081, 41082, order)

		class NoDeliverySchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41038
				order[1] = 41039
				order[2] = 41040
				order[3] = 41041
				order[4] = 41042
				order[5] = 41043
				order[6] = 41044
				order[7] = 41045
				order[8] = 41046
				order[9] = 41047
				order[10] = 41048
				order[11] = 41049
				order[12] = 41050
				order[13] = 41051
				order[14] = 0
				fix.Group.__init__(self, 41037, 41038, order)

			class NoDeliveryScheduleSettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41052
					order[1] = 41053
					order[2] = 41054
					order[3] = 0
					fix.Group.__init__(self, 41051, 41052, order)

				class NoDeliveryScheduleSettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41055
						order[1] = 41056
						order[2] = 41057
						order[3] = 0
						fix.Group.__init__(self, 41054, 41055, order)

	class NoProvisions(fix.Group):
		def __init__(self):
			order = fix.IntArray(79)
			order[0] = 40091
			order[1] = 40092
			order[2] = 40093
			order[3] = 40957
			order[4] = 40095
			order[5] = 40096
			order[6] = 40097
			order[7] = 42707
			order[8] = 42708
			order[9] = 40098
			order[10] = 40099
			order[11] = 40100
			order[12] = 40114
			order[13] = 40115
			order[14] = 40116
			order[15] = 40118
			order[16] = 40119
			order[17] = 40120
			order[18] = 40121
			order[19] = 40122
			order[20] = 40123
			order[21] = 40125
			order[22] = 40126
			order[23] = 40127
			order[24] = 40128
			order[25] = 40129
			order[26] = 40130
			order[27] = 40131
			order[28] = 40132
			order[29] = 40133
			order[30] = 40134
			order[31] = 40135
			order[32] = 40136
			order[33] = 40137
			order[34] = 40138
			order[35] = 40139
			order[36] = 40140
			order[37] = 40141
			order[38] = 40145
			order[39] = 40146
			order[40] = 40148
			order[41] = 40149
			order[42] = 40150
			order[43] = 40151
			order[44] = 40152
			order[45] = 40153
			order[46] = 40154
			order[47] = 40155
			order[48] = 40156
			order[49] = 40158
			order[50] = 40159
			order[51] = 40160
			order[52] = 40161
			order[53] = 40162
			order[54] = 40101
			order[55] = 40102
			order[56] = 40103
			order[57] = 40104
			order[58] = 40105
			order[59] = 40106
			order[60] = 40107
			order[61] = 40163
			order[62] = 40165
			order[63] = 40166
			order[64] = 40167
			order[65] = 40168
			order[66] = 40169
			order[67] = 40170
			order[68] = 40108
			order[69] = 40109
			order[70] = 40110
			order[71] = 40111
			order[72] = 40112
			order[73] = 41406
			order[74] = 40113
			order[75] = 40986
			order[76] = 40987
			order[77] = 40174
			order[78] = 0
			fix.Group.__init__(self, 40090, 40091, order)

		class NoProvisionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40094
				order[1] = 0
				fix.Group.__init__(self, 40957, 40094, order)

		class NoProvisionCashSettlValueDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40117
				order[1] = 0
				fix.Group.__init__(self, 40953, 40117, order)

		class NoProvisionOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40124
				order[1] = 0
				fix.Group.__init__(self, 40954, 40124, order)

		class NoProvisionOptionExerciseFixedDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40143
				order[1] = 40144
				order[2] = 0
				fix.Group.__init__(self, 40142, 40143, order)

		class NoProvisionOptionExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40147
				order[1] = 0
				fix.Group.__init__(self, 40955, 40147, order)

		class NoProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40157
				order[1] = 0
				fix.Group.__init__(self, 40956, 40157, order)

		class NoProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40164
				order[1] = 0
				fix.Group.__init__(self, 40952, 40164, order)

		class NoProvisionCashSettlPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40172
				order[1] = 40173
				order[2] = 0
				fix.Group.__init__(self, 40171, 40172, order)

		class NoProvisionPartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40175
				order[1] = 40176
				order[2] = 40177
				order[3] = 2385
				order[4] = 40178
				order[5] = 0
				fix.Group.__init__(self, 40174, 40175, order)

			class NoProvisionPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40179
					order[1] = 40180
					order[2] = 0
					fix.Group.__init__(self, 40178, 40179, order)

	class NoAdditionalTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40020
			order[1] = 40021
			order[2] = 40000
			order[3] = 0
			fix.Group.__init__(self, 40019, 40020, order)

		class NoAdditionalTermBondRefs(fix.Group):
			def __init__(self):
				order = fix.IntArray(19)
				order[0] = 40001
				order[1] = 40002
				order[2] = 40003
				order[3] = 40004
				order[4] = 40005
				order[5] = 40006
				order[6] = 40007
				order[7] = 40008
				order[8] = 40009
				order[9] = 40010
				order[10] = 40011
				order[11] = 40012
				order[12] = 40013
				order[13] = 40014
				order[14] = 40015
				order[15] = 40016
				order[16] = 40017
				order[17] = 40018
				order[18] = 0
				fix.Group.__init__(self, 40000, 40001, order)

	class NoProtectionTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(12)
			order[0] = 40182
			order[1] = 40183
			order[2] = 40184
			order[3] = 40185
			order[4] = 40186
			order[5] = 40187
			order[6] = 40188
			order[7] = 40951
			order[8] = 40191
			order[9] = 40201
			order[10] = 40190
			order[11] = 0
			fix.Group.__init__(self, 40181, 40182, order)

		class NoProtectionTermEventNewsSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40189
				order[1] = 0
				fix.Group.__init__(self, 40951, 40189, order)

		class NoProtectionTermEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40192
				order[1] = 40193
				order[2] = 40194
				order[3] = 40195
				order[4] = 40196
				order[5] = 40197
				order[6] = 40198
				order[7] = 40199
				order[8] = 0
				fix.Group.__init__(self, 40191, 40192, order)

			class NoProtectionTermEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40200
					order[1] = 0
					fix.Group.__init__(self, 40199, 40200, order)

		class NoProtectionTermObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40202
				order[1] = 40203
				order[2] = 0
				fix.Group.__init__(self, 40201, 40202, order)

	class NoCashSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(29)
			order[0] = 40023
			order[1] = 40024
			order[2] = 40916
			order[3] = 40917
			order[4] = 40025
			order[5] = 40026
			order[6] = 40027
			order[7] = 40028
			order[8] = 40029
			order[9] = 40030
			order[10] = 40031
			order[11] = 40277
			order[12] = 42216
			order[13] = 42217
			order[14] = 40033
			order[15] = 40034
			order[16] = 42207
			order[17] = 42208
			order[18] = 42209
			order[19] = 42210
			order[20] = 42211
			order[21] = 42212
			order[22] = 42213
			order[23] = 40035
			order[24] = 40036
			order[25] = 40037
			order[26] = 40038
			order[27] = 40039
			order[28] = 0
			fix.Group.__init__(self, 40022, 40023, order)

		class NoCashSettlDealers(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40032
				order[1] = 0
				fix.Group.__init__(self, 40277, 40032, order)

		class NoCashSettlDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42215
				order[1] = 0
				fix.Group.__init__(self, 42214, 42215, order)

	class NoPhysicalSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 40209
			order[1] = 40205
			order[2] = 40206
			order[3] = 40207
			order[4] = 40208
			order[5] = 0
			fix.Group.__init__(self, 40204, 40209, order)

		class NoPhysicalSettlDeliverableObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40210
				order[1] = 40211
				order[2] = 0
				fix.Group.__init__(self, 40209, 40210, order)

	class NoExtraordinaryEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 42297
			order[1] = 42298
			order[2] = 0
			fix.Group.__init__(self, 42296, 42297, order)

	class NoInstrAttrib(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 871
			order[1] = 872
			order[2] = 0
			fix.Group.__init__(self, 870, 871, order)

	class NoIndexRollMonths(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 2733
			order[1] = 0
			fix.Group.__init__(self, 2734, 2733, order)

	class NoReferenceDataDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 2747
			order[1] = 2748
			order[2] = 0
			fix.Group.__init__(self, 2746, 2747, order)

	class NoContractualDefinitions(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40041
			order[1] = 0
			fix.Group.__init__(self, 40040, 40041, order)

	class NoFinancingTermSupplements(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 40047
			order[1] = 40048
			order[2] = 0
			fix.Group.__init__(self, 40046, 40047, order)

	class NoContractualMatrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40043
			order[1] = 40044
			order[2] = 40045
			order[3] = 0
			fix.Group.__init__(self, 40042, 40043, order)

	class NoLegs(fix.Group):
		def __init__(self):
			order = fix.IntArray(176)
			order[0] = 600
			order[1] = 601
			order[2] = 602
			order[3] = 603
			order[4] = 1788
			order[5] = 607
			order[6] = 1594
			order[7] = 608
			order[8] = 2893
			order[9] = 609
			order[10] = 764
			order[11] = 610
			order[12] = 611
			order[13] = 1212
			order[14] = 2146
			order[15] = 2147
			order[16] = 2148
			order[17] = 248
			order[18] = 2149
			order[19] = 2150
			order[20] = 2151
			order[21] = 2152
			order[22] = 2153
			order[23] = 2154
			order[24] = 2155
			order[25] = 2348
			order[26] = 2067
			order[27] = 2068
			order[28] = 2069
			order[29] = 2739
			order[30] = 2070
			order[31] = 2156
			order[32] = 2157
			order[33] = 2158
			order[34] = 2159
			order[35] = 2160
			order[36] = 2161
			order[37] = 2162
			order[38] = 2163
			order[39] = 2164
			order[40] = 2165
			order[41] = 2880
			order[42] = 2166
			order[43] = 2167
			order[44] = 2168
			order[45] = 2169
			order[46] = 2170
			order[47] = 2171
			order[48] = 2172
			order[49] = 2173
			order[50] = 2174
			order[51] = 2175
			order[52] = 2176
			order[53] = 2177
			order[54] = 2178
			order[55] = 2179
			order[56] = 2180
			order[57] = 249
			order[58] = 250
			order[59] = 251
			order[60] = 252
			order[61] = 253
			order[62] = 257
			order[63] = 599
			order[64] = 596
			order[65] = 597
			order[66] = 598
			order[67] = 254
			order[68] = 612
			order[69] = 942
			order[70] = 2908
			order[71] = 2181
			order[72] = 2182
			order[73] = 2183
			order[74] = 2184
			order[75] = 2604
			order[76] = 2185
			order[77] = 2605
			order[78] = 2186
			order[79] = 2187
			order[80] = 2188
			order[81] = 2189
			order[82] = 613
			order[83] = 614
			order[84] = 1436
			order[85] = 2354
			order[86] = 1440
			order[87] = 2190
			order[88] = 2191
			order[89] = 999
			order[90] = 1224
			order[91] = 1720
			order[92] = 2909
			order[93] = 1421
			order[94] = 1422
			order[95] = 1721
			order[96] = 2910
			order[97] = 2192
			order[98] = 1001
			order[99] = 1420
			order[100] = 2193
			order[101] = 2194
			order[102] = 2755
			order[103] = 2195
			order[104] = 2196
			order[105] = 2197
			order[106] = 2198
			order[107] = 1528
			order[108] = 2911
			order[109] = 2199
			order[110] = 2200
			order[111] = 2201
			order[112] = 2202
			order[113] = 2203
			order[114] = 615
			order[115] = 616
			order[116] = 2205
			order[117] = 2206
			order[118] = 617
			order[119] = 618
			order[120] = 619
			order[121] = 2740
			order[122] = 2717
			order[123] = 2718
			order[124] = 2719
			order[125] = 620
			order[126] = 621
			order[127] = 622
			order[128] = 2207
			order[129] = 2208
			order[130] = 623
			order[131] = 624
			order[132] = 556
			order[133] = 2898
			order[134] = 740
			order[135] = 739
			order[136] = 955
			order[137] = 956
			order[138] = 1358
			order[139] = 2682
			order[140] = 2686
			order[141] = 1017
			order[142] = 566
			order[143] = 2209
			order[144] = 2211
			order[145] = 2212
			order[146] = 2213
			order[147] = 2754
			order[148] = 2214
			order[149] = 2215
			order[150] = 2606
			order[151] = 2607
			order[152] = 2497
			order[153] = 2498
			order[154] = 2499
			order[155] = 2496
			order[156] = 2495
			order[157] = 2953
			order[158] = 2511
			order[159] = 2510
			order[160] = 2512
			order[161] = 2509
			order[162] = 2500
			order[163] = 2502
			order[164] = 2501
			order[165] = 2503
			order[166] = 2507
			order[167] = 2505
			order[168] = 2494
			order[169] = 2493
			order[170] = 2514
			order[171] = 2513
			order[172] = 2506
			order[173] = 2504
			order[174] = 2508
			order[175] = 0
			fix.Group.__init__(self, 555, 600, order)

		class NoLegSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 605
				order[1] = 606
				order[2] = 2958
				order[3] = 0
				fix.Group.__init__(self, 604, 605, order)

		class NoLegSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2077
				order[1] = 2078
				order[2] = 2079
				order[3] = 2743
				order[4] = 0
				fix.Group.__init__(self, 2076, 2077, order)

		class NoLegAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2309
				order[1] = 2310
				order[2] = 2311
				order[3] = 0
				fix.Group.__init__(self, 2308, 2309, order)

		class NoLegEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 2060
				order[1] = 2061
				order[2] = 2062
				order[3] = 2063
				order[4] = 2064
				order[5] = 2341
				order[6] = 2065
				order[7] = 2066
				order[8] = 2074
				order[9] = 2075
				order[10] = 0
				fix.Group.__init__(self, 2059, 2060, order)

		class NoLegInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 2255
				order[1] = 2256
				order[2] = 2257
				order[3] = 2379
				order[4] = 2258
				order[5] = 0
				fix.Group.__init__(self, 2254, 2255, order)

			class NoLegInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 2259
					order[1] = 2260
					order[2] = 0
					fix.Group.__init__(self, 2258, 2259, order)

		class NoLegComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2219
				order[1] = 2220
				order[2] = 2221
				order[3] = 2222
				order[4] = 2223
				order[5] = 2224
				order[6] = 2225
				order[7] = 2226
				order[8] = 2944
				order[9] = 2227
				order[10] = 2228
				order[11] = 2229
				order[12] = 2230
				order[13] = 2231
				order[14] = 2232
				order[15] = 2250
				order[16] = 2233
				order[17] = 2945
				order[18] = 2234
				order[19] = 2946
				order[20] = 2235
				order[21] = 2236
				order[22] = 2409
				order[23] = 2410
				order[24] = 2237
				order[25] = 2238
				order[26] = 2239
				order[27] = 2240
				order[28] = 2241
				order[29] = 41382
				order[30] = 41389
				order[31] = 41390
				order[32] = 41391
				order[33] = 41392
				order[34] = 41393
				order[35] = 41394
				order[36] = 41395
				order[37] = 41396
				order[38] = 41397
				order[39] = 41379
				order[40] = 2242
				order[41] = 2243
				order[42] = 2244
				order[43] = 2245
				order[44] = 2246
				order[45] = 41398
				order[46] = 41366
				order[47] = 2608
				order[48] = 2609
				order[49] = 2610
				order[50] = 2248
				order[51] = 2249
				order[52] = 0
				fix.Group.__init__(self, 2218, 2219, order)

			class NoLegComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2251
					order[1] = 2252
					order[2] = 2253
					order[3] = 0
					fix.Group.__init__(self, 2250, 2251, order)

				class NoLegComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2204
						order[1] = 2247
						order[2] = 0
						fix.Group.__init__(self, 2253, 2204, order)

			class NoLegComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41383
					order[1] = 41384
					order[2] = 41385
					order[3] = 41386
					order[4] = 0
					fix.Group.__init__(self, 41382, 41383, order)

			class NoLegComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41388
					order[1] = 0
					fix.Group.__init__(self, 41387, 41388, order)

			class NoLegComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41380
					order[1] = 41381
					order[2] = 41400
					order[3] = 41376
					order[4] = 41363
					order[5] = 0
					fix.Group.__init__(self, 41379, 41380, order)

				class NoLegComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41401
						order[1] = 41402
						order[2] = 41403
						order[3] = 41404
						order[4] = 41405
						order[5] = 0
						fix.Group.__init__(self, 41400, 41401, order)

				class NoLegComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41377
						order[1] = 41378
						order[2] = 0
						fix.Group.__init__(self, 41376, 41377, order)

				class NoLegComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41364
						order[1] = 41365
						order[2] = 0
						fix.Group.__init__(self, 41363, 41364, order)

			class NoLegComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41399
					order[1] = 0
					fix.Group.__init__(self, 41398, 41399, order)

			class NoLegComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41367
					order[1] = 41368
					order[2] = 41369
					order[3] = 41370
					order[4] = 41371
					order[5] = 41372
					order[6] = 41373
					order[7] = 41374
					order[8] = 0
					fix.Group.__init__(self, 41366, 41367, order)

				class NoLegComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41375
						order[1] = 0
						fix.Group.__init__(self, 41374, 41375, order)

		class NoLegBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40924
				order[1] = 0
				fix.Group.__init__(self, 40923, 40924, order)

		class NoLegPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41608
				order[1] = 0
				fix.Group.__init__(self, 41607, 41608, order)

		class NoLegMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41468
				order[1] = 40223
				order[2] = 0
				fix.Group.__init__(self, 41467, 41468, order)

		class NoLegMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41470
				order[1] = 40990
				order[2] = 0
				fix.Group.__init__(self, 41469, 41470, order)

		class NoLegMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41472
				order[1] = 41473
				order[2] = 41474
				order[3] = 41475
				order[4] = 41476
				order[5] = 41477
				order[6] = 41478
				order[7] = 41479
				order[8] = 41480
				order[9] = 0
				fix.Group.__init__(self, 41471, 41472, order)

		class NoLegSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42582
				order[1] = 0
				fix.Group.__init__(self, 42581, 42582, order)

		class NoLegOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41492
				order[1] = 0
				fix.Group.__init__(self, 41491, 41492, order)

		class NoLegOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41513
				order[1] = 41514
				order[2] = 0
				fix.Group.__init__(self, 41512, 41513, order)

		class NoLegOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41516
				order[1] = 0
				fix.Group.__init__(self, 41515, 41516, order)

		class NoLegOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41528
				order[1] = 41529
				order[2] = 0
				fix.Group.__init__(self, 41527, 41528, order)

		class NoLegStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40242
				order[1] = 41700
				order[2] = 40243
				order[3] = 42583
				order[4] = 42584
				order[5] = 40244
				order[6] = 40245
				order[7] = 41702
				order[8] = 40246
				order[9] = 40247
				order[10] = 42585
				order[11] = 42586
				order[12] = 41703
				order[13] = 41704
				order[14] = 41705
				order[15] = 41706
				order[16] = 41707
				order[17] = 41708
				order[18] = 41648
				order[19] = 41649
				order[20] = 41650
				order[21] = 41651
				order[22] = 41652
				order[23] = 41653
				order[24] = 41654
				order[25] = 42588
				order[26] = 41655
				order[27] = 41656
				order[28] = 41657
				order[29] = 41658
				order[30] = 41659
				order[31] = 41660
				order[32] = 41661
				order[33] = 41662
				order[34] = 41663
				order[35] = 41664
				order[36] = 41665
				order[37] = 41666
				order[38] = 41667
				order[39] = 41668
				order[40] = 41669
				order[41] = 41670
				order[42] = 41671
				order[43] = 41672
				order[44] = 41673
				order[45] = 40249
				order[46] = 40250
				order[47] = 40252
				order[48] = 40253
				order[49] = 40254
				order[50] = 40255
				order[51] = 40256
				order[52] = 40257
				order[53] = 40258
				order[54] = 40260
				order[55] = 40261
				order[56] = 40262
				order[57] = 40263
				order[58] = 40264
				order[59] = 41641
				order[60] = 41642
				order[61] = 40265
				order[62] = 40267
				order[63] = 40268
				order[64] = 40270
				order[65] = 40271
				order[66] = 40272
				order[67] = 40273
				order[68] = 40274
				order[69] = 40275
				order[70] = 40276
				order[71] = 41643
				order[72] = 41644
				order[73] = 41645
				order[74] = 40279
				order[75] = 40280
				order[76] = 40281
				order[77] = 42399
				order[78] = 40282
				order[79] = 40283
				order[80] = 43108
				order[81] = 40284
				order[82] = 40285
				order[83] = 40286
				order[84] = 40287
				order[85] = 40288
				order[86] = 42400
				order[87] = 42401
				order[88] = 42402
				order[89] = 42403
				order[90] = 40289
				order[91] = 40290
				order[92] = 40291
				order[93] = 41549
				order[94] = 41550
				order[95] = 41551
				order[96] = 41552
				order[97] = 41553
				order[98] = 41554
				order[99] = 41555
				order[100] = 42404
				order[101] = 40374
				order[102] = 40418
				order[103] = 41429
				order[104] = 41430
				order[105] = 41431
				order[106] = 41432
				order[107] = 41433
				order[108] = 42194
				order[109] = 42195
				order[110] = 41434
				order[111] = 41435
				order[112] = 41436
				order[113] = 41437
				order[114] = 41438
				order[115] = 41219
				order[116] = 41439
				order[117] = 41440
				order[118] = 41441
				order[119] = 41442
				order[120] = 41443
				order[121] = 41444
				order[122] = 41445
				order[123] = 41446
				order[124] = 41447
				order[125] = 41448
				order[126] = 41449
				order[127] = 41450
				order[128] = 41451
				order[129] = 43095
				order[130] = 41408
				order[131] = 40248
				order[132] = 40978
				order[133] = 40979
				order[134] = 0
				fix.Group.__init__(self, 40241, 40242, order)

			class NoLegStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41675
					order[1] = 41676
					order[2] = 0
					fix.Group.__init__(self, 41674, 41675, order)

			class NoLegStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41453
					order[1] = 41454
					order[2] = 41455
					order[3] = 0
					fix.Group.__init__(self, 41452, 41453, order)

			class NoLegStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41678
					order[1] = 41679
					order[2] = 0
					fix.Group.__init__(self, 41677, 41678, order)

			class NoLegStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41647
					order[1] = 0
					fix.Group.__init__(self, 41646, 41647, order)

			class NoLegStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41687
					order[1] = 41688
					order[2] = 41689
					order[3] = 41690
					order[4] = 41691
					order[5] = 41692
					order[6] = 41693
					order[7] = 41694
					order[8] = 41695
					order[9] = 41696
					order[10] = 41697
					order[11] = 41680
					order[12] = 41698
					order[13] = 41699
					order[14] = 0
					fix.Group.__init__(self, 41686, 41687, order)

				class NoLegStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41681
						order[1] = 41682
						order[2] = 41683
						order[3] = 0
						fix.Group.__init__(self, 41680, 41681, order)

					class NoLegStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41684
							order[1] = 41685
							order[2] = 41935
							order[3] = 0
							fix.Group.__init__(self, 41683, 41684, order)

			class NoLegStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40251
					order[1] = 0
					fix.Group.__init__(self, 40942, 40251, order)

			class NoLegStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40259
					order[1] = 0
					fix.Group.__init__(self, 40943, 40259, order)

			class NoLegStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40266
					order[1] = 0
					fix.Group.__init__(self, 40940, 40266, order)

			class NoLegStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41639
					order[1] = 41640
					order[2] = 0
					fix.Group.__init__(self, 41638, 41639, order)

			class NoLegStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40269
					order[1] = 0
					fix.Group.__init__(self, 40941, 40269, order)

			class NoLegPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40293
					order[1] = 0
					fix.Group.__init__(self, 40930, 40293, order)

			class NoLegPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41590
					order[1] = 41591
					order[2] = 0
					fix.Group.__init__(self, 41589, 41590, order)

			class NoLegPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40305
					order[1] = 0
					fix.Group.__init__(self, 40931, 40305, order)

			class NoLegPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40311
					order[1] = 0
					fix.Group.__init__(self, 40932, 40311, order)

			class NoLegPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40318
					order[1] = 0
					fix.Group.__init__(self, 40933, 40318, order)

			class NoLegPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42460
					order[1] = 42461
					order[2] = 0
					fix.Group.__init__(self, 42459, 42460, order)

			class NoLegPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41562
					order[1] = 0
					fix.Group.__init__(self, 41561, 41562, order)

			class NoLegPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41597
					order[1] = 41598
					order[2] = 0
					fix.Group.__init__(self, 41596, 41597, order)

			class NoLegPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41594
					order[1] = 41595
					order[2] = 0
					fix.Group.__init__(self, 41593, 41594, order)

			class NoLegPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43110
					order[1] = 42486
					order[2] = 42487
					order[3] = 0
					fix.Group.__init__(self, 42485, 43110, order)

			class NoLegDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42367
					order[1] = 42368
					order[2] = 42369
					order[3] = 42370
					order[4] = 42371
					order[5] = 42372
					order[6] = 42386
					order[7] = 42373
					order[8] = 42374
					order[9] = 42375
					order[10] = 42376
					order[11] = 42377
					order[12] = 42378
					order[13] = 42379
					order[14] = 42380
					order[15] = 42381
					order[16] = 42382
					order[17] = 42383
					order[18] = 42384
					order[19] = 42385
					order[20] = 0
					fix.Group.__init__(self, 42366, 42367, order)

				class NoLegDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42387
						order[1] = 0
						fix.Group.__init__(self, 42386, 42387, order)

			class NoLegDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42365
					order[1] = 0
					fix.Group.__init__(self, 42364, 42365, order)

			class NoLegDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42311
					order[1] = 0
					fix.Group.__init__(self, 42310, 42311, order)

			class NoLegReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 42535
					order[1] = 42536
					order[2] = 42537
					order[3] = 42538
					order[4] = 42539
					order[5] = 42540
					order[6] = 42564
					order[7] = 42530
					order[8] = 42541
					order[9] = 42542
					order[10] = 42543
					order[11] = 42544
					order[12] = 42545
					order[13] = 42546
					order[14] = 42547
					order[15] = 42548
					order[16] = 42549
					order[17] = 42550
					order[18] = 42551
					order[19] = 42552
					order[20] = 42560
					order[21] = 42553
					order[22] = 42554
					order[23] = 42508
					order[24] = 42555
					order[25] = 42556
					order[26] = 42557
					order[27] = 42558
					order[28] = 42559
					order[29] = 0
					fix.Group.__init__(self, 42534, 42535, order)

				class NoLegReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 42565
						order[1] = 42566
						order[2] = 42567
						order[3] = 42568
						order[4] = 0
						fix.Group.__init__(self, 42564, 42565, order)

				class NoLegReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42531
						order[1] = 42532
						order[2] = 42533
						order[3] = 0
						fix.Group.__init__(self, 42530, 42531, order)

				class NoLegReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42561
						order[1] = 42562
						order[2] = 42563
						order[3] = 0
						fix.Group.__init__(self, 42560, 42561, order)

				class NoLegReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 42509
						order[1] = 42571
						order[2] = 42510
						order[3] = 42511
						order[4] = 42512
						order[5] = 42513
						order[6] = 42514
						order[7] = 42515
						order[8] = 42516
						order[9] = 42517
						order[10] = 42518
						order[11] = 42519
						order[12] = 42520
						order[13] = 42521
						order[14] = 42522
						order[15] = 42523
						order[16] = 42524
						order[17] = 42525
						order[18] = 42526
						order[19] = 42527
						order[20] = 42528
						order[21] = 42529
						order[22] = 42569
						order[23] = 0
						fix.Group.__init__(self, 42508, 42509, order)

					class NoLegReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 42572
							order[1] = 42573
							order[2] = 0
							fix.Group.__init__(self, 42571, 42572, order)

					class NoLegReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 42570
							order[1] = 0
							fix.Group.__init__(self, 42569, 42570, order)

			class NoLegPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42420
					order[1] = 0
					fix.Group.__init__(self, 42419, 42420, order)

			class NoLegPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42406
					order[1] = 42407
					order[2] = 0
					fix.Group.__init__(self, 42405, 42406, order)

			class NoLegPaymentStreamNonDeliverableFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40361
					order[1] = 0
					fix.Group.__init__(self, 40929, 40361, order)

			class NoLegNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40368
					order[1] = 40369
					order[2] = 0
					fix.Group.__init__(self, 40367, 40368, order)

			class NoLegSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40903
					order[1] = 40366
					order[2] = 40370
					order[3] = 40905
					order[4] = 40906
					order[5] = 0
					fix.Group.__init__(self, 40902, 40903, order)

			class NoLegPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40375
					order[1] = 41533
					order[2] = 41534
					order[3] = 40376
					order[4] = 40377
					order[5] = 40378
					order[6] = 40379
					order[7] = 40380
					order[8] = 40381
					order[9] = 40382
					order[10] = 40383
					order[11] = 40384
					order[12] = 40385
					order[13] = 41535
					order[14] = 41536
					order[15] = 41537
					order[16] = 41538
					order[17] = 40386
					order[18] = 40387
					order[19] = 40388
					order[20] = 40389
					order[21] = 41539
					order[22] = 41540
					order[23] = 41541
					order[24] = 41542
					order[25] = 40390
					order[26] = 40391
					order[27] = 40392
					order[28] = 40393
					order[29] = 40394
					order[30] = 40395
					order[31] = 40414
					order[32] = 40396
					order[33] = 40397
					order[34] = 40398
					order[35] = 40399
					order[36] = 40927
					order[37] = 40401
					order[38] = 40402
					order[39] = 40403
					order[40] = 41543
					order[41] = 41544
					order[42] = 40404
					order[43] = 41530
					order[44] = 41545
					order[45] = 41546
					order[46] = 41547
					order[47] = 41548
					order[48] = 40405
					order[49] = 40406
					order[50] = 40407
					order[51] = 40408
					order[52] = 40928
					order[53] = 40410
					order[54] = 40411
					order[55] = 40412
					order[56] = 40413
					order[57] = 0
					fix.Group.__init__(self, 40374, 40375, order)

				class NoLegPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40415
						order[1] = 40416
						order[2] = 40417
						order[3] = 0
						fix.Group.__init__(self, 40414, 40415, order)

				class NoLegPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40400
						order[1] = 0
						fix.Group.__init__(self, 40927, 40400, order)

				class NoLegPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41531
						order[1] = 41532
						order[2] = 0
						fix.Group.__init__(self, 41530, 41531, order)

				class NoLegPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40409
						order[1] = 0
						fix.Group.__init__(self, 40928, 40409, order)

			class NoLegPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40419
					order[1] = 40420
					order[2] = 42497
					order[3] = 42498
					order[4] = 42499
					order[5] = 42500
					order[6] = 42501
					order[7] = 42502
					order[8] = 42503
					order[9] = 42488
					order[10] = 42489
					order[11] = 42490
					order[12] = 42491
					order[13] = 42492
					order[14] = 42493
					order[15] = 42494
					order[16] = 40421
					order[17] = 40422
					order[18] = 40423
					order[19] = 40424
					order[20] = 40425
					order[21] = 40426
					order[22] = 40427
					order[23] = 40428
					order[24] = 40429
					order[25] = 40430
					order[26] = 40431
					order[27] = 40432
					order[28] = 40433
					order[29] = 40434
					order[30] = 40435
					order[31] = 40436
					order[32] = 40437
					order[33] = 40438
					order[34] = 40439
					order[35] = 40440
					order[36] = 40441
					order[37] = 40442
					order[38] = 40443
					order[39] = 40444
					order[40] = 40445
					order[41] = 40446
					order[42] = 40447
					order[43] = 0
					fix.Group.__init__(self, 40418, 40419, order)

				class NoLegPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42505
						order[1] = 0
						fix.Group.__init__(self, 42504, 42505, order)

				class NoLegPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42496
						order[1] = 0
						fix.Group.__init__(self, 42495, 42496, order)

			class NoLegDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41461
					order[1] = 0
					fix.Group.__init__(self, 41460, 41461, order)

			class NoLegDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41457
					order[1] = 41458
					order[2] = 41459
					order[3] = 0
					fix.Group.__init__(self, 41456, 41457, order)

			class NoLegDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41409
					order[1] = 41410
					order[2] = 41411
					order[3] = 41412
					order[4] = 41413
					order[5] = 41414
					order[6] = 41415
					order[7] = 41416
					order[8] = 41417
					order[9] = 41418
					order[10] = 41419
					order[11] = 41420
					order[12] = 41421
					order[13] = 41422
					order[14] = 0
					fix.Group.__init__(self, 41408, 41409, order)

				class NoLegDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41423
						order[1] = 41424
						order[2] = 41425
						order[3] = 0
						fix.Group.__init__(self, 41422, 41423, order)

					class NoLegDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41426
							order[1] = 41427
							order[2] = 41428
							order[3] = 0
							fix.Group.__init__(self, 41425, 41426, order)

		class NoLegProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 40449
				order[1] = 40450
				order[2] = 40451
				order[3] = 40939
				order[4] = 40453
				order[5] = 40454
				order[6] = 40455
				order[7] = 42506
				order[8] = 42507
				order[9] = 40456
				order[10] = 40457
				order[11] = 40458
				order[12] = 40524
				order[13] = 40525
				order[14] = 40526
				order[15] = 40528
				order[16] = 40529
				order[17] = 40530
				order[18] = 40531
				order[19] = 40532
				order[20] = 40476
				order[21] = 40478
				order[22] = 40479
				order[23] = 40480
				order[24] = 40481
				order[25] = 40482
				order[26] = 40483
				order[27] = 40484
				order[28] = 40485
				order[29] = 40486
				order[30] = 40487
				order[31] = 40488
				order[32] = 40489
				order[33] = 40490
				order[34] = 40491
				order[35] = 40492
				order[36] = 40493
				order[37] = 40494
				order[38] = 40498
				order[39] = 40499
				order[40] = 40501
				order[41] = 40502
				order[42] = 40503
				order[43] = 40504
				order[44] = 40505
				order[45] = 40506
				order[46] = 40507
				order[47] = 40508
				order[48] = 40509
				order[49] = 40511
				order[50] = 40512
				order[51] = 40513
				order[52] = 40514
				order[53] = 40515
				order[54] = 40459
				order[55] = 40460
				order[56] = 40461
				order[57] = 40462
				order[58] = 40463
				order[59] = 40464
				order[60] = 40465
				order[61] = 40516
				order[62] = 40518
				order[63] = 40519
				order[64] = 40520
				order[65] = 40521
				order[66] = 40522
				order[67] = 40523
				order[68] = 40466
				order[69] = 40467
				order[70] = 40468
				order[71] = 40469
				order[72] = 40470
				order[73] = 41407
				order[74] = 40472
				order[75] = 40980
				order[76] = 40981
				order[77] = 40533
				order[78] = 0
				fix.Group.__init__(self, 40448, 40449, order)

			class NoLegProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40452
					order[1] = 0
					fix.Group.__init__(self, 40939, 40452, order)

			class NoLegProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40527
					order[1] = 0
					fix.Group.__init__(self, 40935, 40527, order)

			class NoLegProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40477
					order[1] = 0
					fix.Group.__init__(self, 40936, 40477, order)

			class NoLegProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40496
					order[1] = 40497
					order[2] = 0
					fix.Group.__init__(self, 40495, 40496, order)

			class NoLegProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40500
					order[1] = 0
					fix.Group.__init__(self, 40937, 40500, order)

			class NoLegProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40510
					order[1] = 0
					fix.Group.__init__(self, 40938, 40510, order)

			class NoLegProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40517
					order[1] = 0
					fix.Group.__init__(self, 40934, 40517, order)

			class NoLegProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40474
					order[1] = 40475
					order[2] = 0
					fix.Group.__init__(self, 40473, 40474, order)

			class NoLegProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40534
					order[1] = 40535
					order[2] = 40536
					order[3] = 2380
					order[4] = 40537
					order[5] = 0
					fix.Group.__init__(self, 40533, 40534, order)

				class NoLegProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40538
						order[1] = 40539
						order[2] = 0
						fix.Group.__init__(self, 40537, 40538, order)

		class NoLegAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41336
				order[1] = 41337
				order[2] = 41316
				order[3] = 0
				fix.Group.__init__(self, 41335, 41336, order)

			class NoLegAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41317
					order[1] = 41318
					order[2] = 41319
					order[3] = 41320
					order[4] = 41321
					order[5] = 41322
					order[6] = 41323
					order[7] = 41324
					order[8] = 41325
					order[9] = 41326
					order[10] = 41327
					order[11] = 41328
					order[12] = 41329
					order[13] = 41330
					order[14] = 41331
					order[15] = 41332
					order[16] = 41333
					order[17] = 41334
					order[18] = 0
					fix.Group.__init__(self, 41316, 41317, order)

		class NoLegProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 41618
				order[1] = 41619
				order[2] = 41620
				order[3] = 41621
				order[4] = 41622
				order[5] = 41623
				order[6] = 41624
				order[7] = 41614
				order[8] = 41625
				order[9] = 41635
				order[10] = 41617
				order[11] = 0
				fix.Group.__init__(self, 41616, 41618, order)

			class NoLegProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41615
					order[1] = 0
					fix.Group.__init__(self, 41614, 41615, order)

			class NoLegProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41626
					order[1] = 41627
					order[2] = 41628
					order[3] = 41629
					order[4] = 41630
					order[5] = 41631
					order[6] = 41632
					order[7] = 41633
					order[8] = 0
					fix.Group.__init__(self, 41625, 41626, order)

				class NoLegProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41634
						order[1] = 0
						fix.Group.__init__(self, 41633, 41634, order)

			class NoLegProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41636
					order[1] = 41637
					order[2] = 0
					fix.Group.__init__(self, 41635, 41636, order)

		class NoLegCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 41345
				order[1] = 41346
				order[2] = 41347
				order[3] = 41348
				order[4] = 41349
				order[5] = 41350
				order[6] = 41351
				order[7] = 41352
				order[8] = 41353
				order[9] = 41354
				order[10] = 41355
				order[11] = 41342
				order[12] = 42308
				order[13] = 42309
				order[14] = 41356
				order[15] = 41357
				order[16] = 42299
				order[17] = 42300
				order[18] = 42301
				order[19] = 42302
				order[20] = 42303
				order[21] = 42304
				order[22] = 42305
				order[23] = 41358
				order[24] = 41359
				order[25] = 41360
				order[26] = 41361
				order[27] = 41362
				order[28] = 0
				fix.Group.__init__(self, 41344, 41345, order)

			class NoLegCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41343
					order[1] = 0
					fix.Group.__init__(self, 41342, 41343, order)

			class NoLegCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42307
					order[1] = 0
					fix.Group.__init__(self, 42306, 42307, order)

		class NoLegPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41604
				order[1] = 41601
				order[2] = 41602
				order[3] = 41603
				order[4] = 41600
				order[5] = 0
				fix.Group.__init__(self, 41599, 41604, order)

			class NoLegPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41605
					order[1] = 41606
					order[2] = 0
					fix.Group.__init__(self, 41604, 41605, order)

		class NoLegExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42389
				order[1] = 42390
				order[2] = 0
				fix.Group.__init__(self, 42388, 42389, order)

		class NoLegContractualDefinitions(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42199
				order[1] = 0
				fix.Group.__init__(self, 42198, 42199, order)

		class NoLegFinancingTermSupplements(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42201
				order[1] = 42202
				order[2] = 0
				fix.Group.__init__(self, 42200, 42201, order)

		class NoLegContractualMatrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 42204
				order[1] = 42205
				order[2] = 42206
				order[3] = 0
				fix.Group.__init__(self, 42203, 42204, order)

	class NoUnderlyings(fix.Group):
		def __init__(self):
			order = fix.IntArray(188)
			order[0] = 311
			order[1] = 312
			order[2] = 309
			order[3] = 305
			order[4] = 2874
			order[5] = 462
			order[6] = 463
			order[7] = 2894
			order[8] = 310
			order[9] = 763
			order[10] = 313
			order[11] = 542
			order[12] = 1213
			order[13] = 1837
			order[14] = 241
			order[15] = 1453
			order[16] = 1454
			order[17] = 2614
			order[18] = 2615
			order[19] = 2921
			order[20] = 2616
			order[21] = 2617
			order[22] = 2619
			order[23] = 1455
			order[24] = 1456
			order[25] = 1459
			order[26] = 1460
			order[27] = 242
			order[28] = 243
			order[29] = 244
			order[30] = 245
			order[31] = 246
			order[32] = 256
			order[33] = 595
			order[34] = 592
			order[35] = 593
			order[36] = 594
			order[37] = 247
			order[38] = 316
			order[39] = 941
			order[40] = 2917
			order[41] = 317
			order[42] = 436
			order[43] = 1437
			order[44] = 2363
			order[45] = 1441
			order[46] = 998
			order[47] = 1423
			order[48] = 1718
			order[49] = 2918
			order[50] = 1424
			order[51] = 1425
			order[52] = 1719
			order[53] = 2919
			order[54] = 1000
			order[55] = 1419
			order[56] = 1526
			order[57] = 2920
			order[58] = 435
			order[59] = 308
			order[60] = 306
			order[61] = 362
			order[62] = 363
			order[63] = 2742
			order[64] = 2720
			order[65] = 2721
			order[66] = 2722
			order[67] = 2723
			order[68] = 2724
			order[69] = 307
			order[70] = 364
			order[71] = 365
			order[72] = 877
			order[73] = 878
			order[74] = 972
			order[75] = 318
			order[76] = 2916
			order[77] = 879
			order[78] = 975
			order[79] = 973
			order[80] = 974
			order[81] = 810
			order[82] = 882
			order[83] = 883
			order[84] = 884
			order[85] = 885
			order[86] = 886
			order[87] = 2885
			order[88] = 2886
			order[89] = 1044
			order[90] = 1045
			order[91] = 1046
			order[92] = 1038
			order[93] = 1039
			order[94] = 315
			order[95] = 2683
			order[96] = 2687
			order[97] = 1988
			order[98] = 1989
			order[99] = 1990
			order[100] = 1991
			order[101] = 1992
			order[102] = 1993
			order[103] = 2881
			order[104] = 1994
			order[105] = 1995
			order[106] = 1996
			order[107] = 1997
			order[108] = 2620
			order[109] = 2621
			order[110] = 1998
			order[111] = 1999
			order[112] = 2000
			order[113] = 2003
			order[114] = 2004
			order[115] = 2005
			order[116] = 2006
			order[117] = 2284
			order[118] = 2285
			order[119] = 2286
			order[120] = 2287
			order[121] = 2288
			order[122] = 2007
			order[123] = 2008
			order[124] = 2009
			order[125] = 2010
			order[126] = 2011
			order[127] = 2012
			order[128] = 2491
			order[129] = 2013
			order[130] = 2014
			order[131] = 2015
			order[132] = 2744
			order[133] = 2016
			order[134] = 2289
			order[135] = 2017
			order[136] = 2018
			order[137] = 2019
			order[138] = 2020
			order[139] = 2021
			order[140] = 2022
			order[141] = 2290
			order[142] = 2622
			order[143] = 2291
			order[144] = 2623
			order[145] = 2292
			order[146] = 2023
			order[147] = 2024
			order[148] = 2025
			order[149] = 2026
			order[150] = 2027
			order[151] = 2028
			order[152] = 2029
			order[153] = 2757
			order[154] = 2030
			order[155] = 2031
			order[156] = 2293
			order[157] = 2294
			order[158] = 2032
			order[159] = 2033
			order[160] = 2034
			order[161] = 2035
			order[162] = 2036
			order[163] = 2037
			order[164] = 2038
			order[165] = 2039
			order[166] = 2040
			order[167] = 2041
			order[168] = 2042
			order[169] = 2043
			order[170] = 2044
			order[171] = 41314
			order[172] = 41315
			order[173] = 2295
			order[174] = 2296
			order[175] = 2297
			order[176] = 2756
			order[177] = 2298
			order[178] = 2299
			order[179] = 2624
			order[180] = 2625
			order[181] = 2626
			order[182] = 2627
			order[183] = 2628
			order[184] = 2629
			order[185] = 2630
			order[186] = 2631
			order[187] = 0
			fix.Group.__init__(self, 711, 311, order)

		class NoUnderlyingSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 458
				order[1] = 459
				order[2] = 2959
				order[3] = 0
				fix.Group.__init__(self, 457, 458, order)

		class NoUnderlyingStips(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 888
				order[1] = 889
				order[2] = 0
				fix.Group.__init__(self, 887, 888, order)

		class NoUndlyInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1059
				order[1] = 1060
				order[2] = 1061
				order[3] = 2391
				order[4] = 1062
				order[5] = 0
				fix.Group.__init__(self, 1058, 1059, order)

			class NoUndlyInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1063
					order[1] = 1064
					order[2] = 0
					fix.Group.__init__(self, 1062, 1063, order)

		class NoUnderlyingEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 1982
				order[1] = 1983
				order[2] = 1984
				order[3] = 1985
				order[4] = 1986
				order[5] = 2342
				order[6] = 1987
				order[7] = 2071
				order[8] = 2072
				order[9] = 2073
				order[10] = 0
				fix.Group.__init__(self, 1981, 1982, order)

		class NoUnderlyingSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2081
				order[1] = 2082
				order[2] = 2083
				order[3] = 2745
				order[4] = 0
				fix.Group.__init__(self, 2080, 2081, order)

		class NoUnderlyingAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2313
				order[1] = 2314
				order[2] = 2315
				order[3] = 0
				fix.Group.__init__(self, 2312, 2313, order)

		class NoUnderlyingComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2046
				order[1] = 2261
				order[2] = 2262
				order[3] = 2263
				order[4] = 2047
				order[5] = 2264
				order[6] = 2265
				order[7] = 2266
				order[8] = 2947
				order[9] = 2048
				order[10] = 2267
				order[11] = 2049
				order[12] = 2050
				order[13] = 2051
				order[14] = 2052
				order[15] = 2053
				order[16] = 2268
				order[17] = 2948
				order[18] = 2269
				order[19] = 2949
				order[20] = 2270
				order[21] = 2271
				order[22] = 2419
				order[23] = 2420
				order[24] = 2272
				order[25] = 2273
				order[26] = 2274
				order[27] = 2275
				order[28] = 2276
				order[29] = 41732
				order[30] = 41739
				order[31] = 41740
				order[32] = 41741
				order[33] = 41742
				order[34] = 41743
				order[35] = 41744
				order[36] = 41745
				order[37] = 41746
				order[38] = 41747
				order[39] = 41729
				order[40] = 2277
				order[41] = 2278
				order[42] = 2279
				order[43] = 2280
				order[44] = 2281
				order[45] = 41748
				order[46] = 41716
				order[47] = 2611
				order[48] = 2612
				order[49] = 2613
				order[50] = 2282
				order[51] = 2283
				order[52] = 0
				fix.Group.__init__(self, 2045, 2046, order)

			class NoUnderlyingComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2054
					order[1] = 2055
					order[2] = 2056
					order[3] = 0
					fix.Group.__init__(self, 2053, 2054, order)

				class NoUnderlyingComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2057
						order[1] = 2058
						order[2] = 0
						fix.Group.__init__(self, 2056, 2057, order)

			class NoUnderlyingComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41733
					order[1] = 41734
					order[2] = 41735
					order[3] = 41736
					order[4] = 0
					fix.Group.__init__(self, 41732, 41733, order)

			class NoUnderlyingComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41738
					order[1] = 0
					fix.Group.__init__(self, 41737, 41738, order)

			class NoUnderlyingComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41730
					order[1] = 41731
					order[2] = 41750
					order[3] = 41726
					order[4] = 41713
					order[5] = 0
					fix.Group.__init__(self, 41729, 41730, order)

				class NoUnderlyingComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41751
						order[1] = 41752
						order[2] = 41753
						order[3] = 41754
						order[4] = 41755
						order[5] = 0
						fix.Group.__init__(self, 41750, 41751, order)

				class NoUnderlyingComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41727
						order[1] = 41728
						order[2] = 0
						fix.Group.__init__(self, 41726, 41727, order)

				class NoUnderlyingComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41714
						order[1] = 41715
						order[2] = 0
						fix.Group.__init__(self, 41713, 41714, order)

			class NoUnderlyingComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41749
					order[1] = 0
					fix.Group.__init__(self, 41748, 41749, order)

			class NoUnderlyingComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41717
					order[1] = 41718
					order[2] = 41719
					order[3] = 41720
					order[4] = 41721
					order[5] = 41722
					order[6] = 41723
					order[7] = 41724
					order[8] = 0
					fix.Group.__init__(self, 41716, 41717, order)

				class NoUnderlyingComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41725
						order[1] = 0
						fix.Group.__init__(self, 41724, 41725, order)

		class NoUnderlyingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40963
				order[1] = 0
				fix.Group.__init__(self, 40962, 40963, order)

		class NoUnderlyingPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41948
				order[1] = 0
				fix.Group.__init__(self, 41947, 41948, order)

		class NoUnderlyingMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41865
				order[1] = 41338
				order[2] = 0
				fix.Group.__init__(self, 41864, 41865, order)

		class NoUnderlyingMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41867
				order[1] = 41339
				order[2] = 0
				fix.Group.__init__(self, 41866, 41867, order)

		class NoUnderlyingMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41869
				order[1] = 41870
				order[2] = 41871
				order[3] = 41872
				order[4] = 41873
				order[5] = 41874
				order[6] = 41875
				order[7] = 41876
				order[8] = 41877
				order[9] = 0
				fix.Group.__init__(self, 41868, 41869, order)

		class NoUnderlyingSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 43075
				order[1] = 0
				fix.Group.__init__(self, 43074, 43075, order)

		class NoUnderlyingOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41821
				order[1] = 0
				fix.Group.__init__(self, 41820, 41821, order)

		class NoUnderlyingOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41842
				order[1] = 41843
				order[2] = 0
				fix.Group.__init__(self, 41841, 41842, order)

		class NoUnderlyingOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41845
				order[1] = 0
				fix.Group.__init__(self, 41844, 41845, order)

		class NoUnderlyingOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41857
				order[1] = 41858
				order[2] = 0
				fix.Group.__init__(self, 41856, 41857, order)

		class NoUnderlyingStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40541
				order[1] = 42016
				order[2] = 40542
				order[3] = 43083
				order[4] = 43084
				order[5] = 40543
				order[6] = 40544
				order[7] = 42018
				order[8] = 40545
				order[9] = 40546
				order[10] = 43085
				order[11] = 43086
				order[12] = 42019
				order[13] = 42020
				order[14] = 42021
				order[15] = 42022
				order[16] = 42023
				order[17] = 42024
				order[18] = 41964
				order[19] = 41965
				order[20] = 41966
				order[21] = 41967
				order[22] = 41968
				order[23] = 41969
				order[24] = 41970
				order[25] = 42589
				order[26] = 41971
				order[27] = 41972
				order[28] = 41973
				order[29] = 41974
				order[30] = 41975
				order[31] = 41976
				order[32] = 41977
				order[33] = 41978
				order[34] = 41979
				order[35] = 41980
				order[36] = 41981
				order[37] = 41982
				order[38] = 41983
				order[39] = 41984
				order[40] = 41985
				order[41] = 41986
				order[42] = 41987
				order[43] = 41988
				order[44] = 41989
				order[45] = 40057
				order[46] = 40058
				order[47] = 40060
				order[48] = 40061
				order[49] = 40062
				order[50] = 40063
				order[51] = 40064
				order[52] = 40548
				order[53] = 40549
				order[54] = 40551
				order[55] = 40552
				order[56] = 40553
				order[57] = 40554
				order[58] = 40555
				order[59] = 41957
				order[60] = 41958
				order[61] = 40556
				order[62] = 40558
				order[63] = 40559
				order[64] = 40561
				order[65] = 40562
				order[66] = 40563
				order[67] = 40564
				order[68] = 40565
				order[69] = 40566
				order[70] = 40567
				order[71] = 41959
				order[72] = 41960
				order[73] = 41961
				order[74] = 40568
				order[75] = 40569
				order[76] = 40570
				order[77] = 42895
				order[78] = 40571
				order[79] = 40572
				order[80] = 43107
				order[81] = 40573
				order[82] = 40574
				order[83] = 40575
				order[84] = 40576
				order[85] = 40577
				order[86] = 42896
				order[87] = 42897
				order[88] = 42898
				order[89] = 42899
				order[90] = 40578
				order[91] = 40579
				order[92] = 40580
				order[93] = 41897
				order[94] = 41898
				order[95] = 41899
				order[96] = 41900
				order[97] = 41901
				order[98] = 41902
				order[99] = 41903
				order[100] = 42900
				order[101] = 40664
				order[102] = 40708
				order[103] = 41777
				order[104] = 41778
				order[105] = 41779
				order[106] = 41780
				order[107] = 41781
				order[108] = 42196
				order[109] = 42197
				order[110] = 41782
				order[111] = 41783
				order[112] = 41784
				order[113] = 41785
				order[114] = 41786
				order[115] = 41587
				order[116] = 41787
				order[117] = 41788
				order[118] = 41789
				order[119] = 41790
				order[120] = 41791
				order[121] = 41792
				order[122] = 41793
				order[123] = 41794
				order[124] = 41795
				order[125] = 41796
				order[126] = 41797
				order[127] = 41798
				order[128] = 41799
				order[129] = 43096
				order[130] = 41756
				order[131] = 40547
				order[132] = 40988
				order[133] = 40989
				order[134] = 0
				fix.Group.__init__(self, 40540, 40541, order)

			class NoUnderlyingStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41991
					order[1] = 41992
					order[2] = 0
					fix.Group.__init__(self, 41990, 41991, order)

			class NoUnderlyingStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41801
					order[1] = 41802
					order[2] = 41803
					order[3] = 0
					fix.Group.__init__(self, 41800, 41801, order)

			class NoUnderlyingStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41994
					order[1] = 41995
					order[2] = 0
					fix.Group.__init__(self, 41993, 41994, order)

			class NoUnderlyingStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41963
					order[1] = 0
					fix.Group.__init__(self, 41962, 41963, order)

			class NoUnderlyingStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 42003
					order[1] = 42004
					order[2] = 42005
					order[3] = 42006
					order[4] = 42007
					order[5] = 42008
					order[6] = 42009
					order[7] = 42010
					order[8] = 42011
					order[9] = 42012
					order[10] = 42013
					order[11] = 41996
					order[12] = 42014
					order[13] = 42015
					order[14] = 0
					fix.Group.__init__(self, 42002, 42003, order)

				class NoUnderlyingStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41997
						order[1] = 41998
						order[2] = 41999
						order[3] = 0
						fix.Group.__init__(self, 41996, 41997, order)

					class NoUnderlyingStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 42000
							order[1] = 42001
							order[2] = 41936
							order[3] = 0
							fix.Group.__init__(self, 41999, 42000, order)

			class NoUnderlyingStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40059
					order[1] = 0
					fix.Group.__init__(self, 40975, 40059, order)

			class NoUnderlyingStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40550
					order[1] = 0
					fix.Group.__init__(self, 40976, 40550, order)

			class NoUnderlyingStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40557
					order[1] = 0
					fix.Group.__init__(self, 40973, 40557, order)

			class NoUnderlyingStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41955
					order[1] = 41956
					order[2] = 0
					fix.Group.__init__(self, 41954, 41955, order)

			class NoUnderlyingStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40560
					order[1] = 0
					fix.Group.__init__(self, 40974, 40560, order)

			class NoUnderlyingPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40582
					order[1] = 0
					fix.Group.__init__(self, 40969, 40582, order)

			class NoUnderlyingPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41938
					order[1] = 41939
					order[2] = 0
					fix.Group.__init__(self, 41937, 41938, order)

			class NoUnderlyingPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40594
					order[1] = 0
					fix.Group.__init__(self, 40970, 40594, order)

			class NoUnderlyingPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40600
					order[1] = 0
					fix.Group.__init__(self, 40971, 40600, order)

			class NoUnderlyingPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40607
					order[1] = 0
					fix.Group.__init__(self, 40972, 40607, order)

			class NoUnderlyingPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42956
					order[1] = 42957
					order[2] = 0
					fix.Group.__init__(self, 42955, 42956, order)

			class NoUnderlyingPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41910
					order[1] = 0
					fix.Group.__init__(self, 41909, 41910, order)

			class NoUnderlyingPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41945
					order[1] = 41946
					order[2] = 0
					fix.Group.__init__(self, 41944, 41945, order)

			class NoUnderlyingPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41942
					order[1] = 41943
					order[2] = 0
					fix.Group.__init__(self, 41941, 41942, order)

			class NoUnderlyingPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43111
					order[1] = 42982
					order[2] = 42983
					order[3] = 0
					fix.Group.__init__(self, 42981, 43111, order)

			class NoUnderlyingDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42863
					order[1] = 42864
					order[2] = 42865
					order[3] = 42866
					order[4] = 42867
					order[5] = 42868
					order[6] = 42882
					order[7] = 42869
					order[8] = 42870
					order[9] = 42871
					order[10] = 42872
					order[11] = 42873
					order[12] = 42874
					order[13] = 42875
					order[14] = 42876
					order[15] = 42877
					order[16] = 42878
					order[17] = 42879
					order[18] = 42880
					order[19] = 42881
					order[20] = 0
					fix.Group.__init__(self, 42862, 42863, order)

				class NoUnderlyingDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42883
						order[1] = 0
						fix.Group.__init__(self, 42882, 42883, order)

			class NoUnderlyingDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42854
					order[1] = 0
					fix.Group.__init__(self, 42853, 42854, order)

			class NoUnderlyingDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42800
					order[1] = 0
					fix.Group.__init__(self, 42799, 42800, order)

			class NoUnderlyingReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 43035
					order[1] = 43036
					order[2] = 43037
					order[3] = 43038
					order[4] = 43039
					order[5] = 43040
					order[6] = 43064
					order[7] = 43030
					order[8] = 43041
					order[9] = 43042
					order[10] = 43043
					order[11] = 43044
					order[12] = 43045
					order[13] = 43046
					order[14] = 43047
					order[15] = 43048
					order[16] = 43049
					order[17] = 43050
					order[18] = 43051
					order[19] = 43052
					order[20] = 43060
					order[21] = 43053
					order[22] = 43054
					order[23] = 43008
					order[24] = 43055
					order[25] = 43056
					order[26] = 43057
					order[27] = 43058
					order[28] = 43059
					order[29] = 0
					fix.Group.__init__(self, 43034, 43035, order)

				class NoUnderlyingReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 43065
						order[1] = 43066
						order[2] = 43067
						order[3] = 43068
						order[4] = 0
						fix.Group.__init__(self, 43064, 43065, order)

				class NoUnderlyingReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43031
						order[1] = 43032
						order[2] = 43033
						order[3] = 0
						fix.Group.__init__(self, 43030, 43031, order)

				class NoUnderlyingReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43061
						order[1] = 43062
						order[2] = 43063
						order[3] = 0
						fix.Group.__init__(self, 43060, 43061, order)

				class NoUnderlyingReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 43009
						order[1] = 43071
						order[2] = 43010
						order[3] = 43011
						order[4] = 43012
						order[5] = 43013
						order[6] = 43014
						order[7] = 43015
						order[8] = 43016
						order[9] = 43017
						order[10] = 43018
						order[11] = 43019
						order[12] = 43020
						order[13] = 43021
						order[14] = 43022
						order[15] = 43023
						order[16] = 43024
						order[17] = 43025
						order[18] = 43026
						order[19] = 43027
						order[20] = 43028
						order[21] = 43029
						order[22] = 43069
						order[23] = 0
						fix.Group.__init__(self, 43008, 43009, order)

					class NoUnderlyingReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 43072
							order[1] = 43073
							order[2] = 0
							fix.Group.__init__(self, 43071, 43072, order)

					class NoUnderlyingReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 43070
							order[1] = 0
							fix.Group.__init__(self, 43069, 43070, order)

			class NoUnderlyingPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42916
					order[1] = 0
					fix.Group.__init__(self, 42915, 42916, order)

			class NoUnderlyingPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42902
					order[1] = 42903
					order[2] = 0
					fix.Group.__init__(self, 42901, 42902, order)

			class NoUnderlyingPaymentStreamNonDeliverableFixingDatesBizCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40650
					order[1] = 0
					fix.Group.__init__(self, 40968, 40650, order)

			class NoUnderlyingNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40657
					order[1] = 40658
					order[2] = 0
					fix.Group.__init__(self, 40656, 40657, order)

			class NoUnderlyingSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40660
					order[1] = 40904
					order[2] = 40915
					order[3] = 40662
					order[4] = 40663
					order[5] = 0
					fix.Group.__init__(self, 40659, 40660, order)

			class NoUnderlyingPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40665
					order[1] = 41881
					order[2] = 41882
					order[3] = 40666
					order[4] = 40667
					order[5] = 40668
					order[6] = 40669
					order[7] = 40670
					order[8] = 40671
					order[9] = 40672
					order[10] = 40673
					order[11] = 40674
					order[12] = 40675
					order[13] = 41883
					order[14] = 41884
					order[15] = 41885
					order[16] = 41886
					order[17] = 40676
					order[18] = 40677
					order[19] = 40678
					order[20] = 40679
					order[21] = 41887
					order[22] = 41888
					order[23] = 41889
					order[24] = 41890
					order[25] = 40680
					order[26] = 40681
					order[27] = 40682
					order[28] = 40683
					order[29] = 40684
					order[30] = 40685
					order[31] = 40704
					order[32] = 40686
					order[33] = 40687
					order[34] = 40688
					order[35] = 40689
					order[36] = 40966
					order[37] = 40691
					order[38] = 40692
					order[39] = 40693
					order[40] = 41891
					order[41] = 41892
					order[42] = 40694
					order[43] = 41878
					order[44] = 41893
					order[45] = 41894
					order[46] = 41895
					order[47] = 41896
					order[48] = 40695
					order[49] = 40696
					order[50] = 40697
					order[51] = 40698
					order[52] = 40967
					order[53] = 40700
					order[54] = 40701
					order[55] = 40702
					order[56] = 40703
					order[57] = 0
					fix.Group.__init__(self, 40664, 40665, order)

				class NoUnderlyingPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40705
						order[1] = 40706
						order[2] = 40707
						order[3] = 0
						fix.Group.__init__(self, 40704, 40705, order)

				class NoUnderlyingPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40690
						order[1] = 0
						fix.Group.__init__(self, 40966, 40690, order)

				class NoUnderlyingPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41879
						order[1] = 41880
						order[2] = 0
						fix.Group.__init__(self, 41878, 41879, order)

				class NoUnderlyingPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40699
						order[1] = 0
						fix.Group.__init__(self, 40967, 40699, order)

			class NoUnderlyingPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40709
					order[1] = 40710
					order[2] = 42993
					order[3] = 42994
					order[4] = 42995
					order[5] = 42996
					order[6] = 42997
					order[7] = 42998
					order[8] = 42999
					order[9] = 42984
					order[10] = 42985
					order[11] = 42986
					order[12] = 42987
					order[13] = 42988
					order[14] = 42989
					order[15] = 42990
					order[16] = 40711
					order[17] = 40712
					order[18] = 40713
					order[19] = 40714
					order[20] = 40715
					order[21] = 40716
					order[22] = 40717
					order[23] = 40718
					order[24] = 40719
					order[25] = 40720
					order[26] = 40721
					order[27] = 40722
					order[28] = 40723
					order[29] = 40724
					order[30] = 40725
					order[31] = 40726
					order[32] = 40727
					order[33] = 40728
					order[34] = 40729
					order[35] = 40730
					order[36] = 40731
					order[37] = 40732
					order[38] = 40733
					order[39] = 40734
					order[40] = 40735
					order[41] = 40736
					order[42] = 40737
					order[43] = 0
					fix.Group.__init__(self, 40708, 40709, order)

				class NoUnderlyingPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 43001
						order[1] = 0
						fix.Group.__init__(self, 43000, 43001, order)

				class NoUnderlyingPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42992
						order[1] = 0
						fix.Group.__init__(self, 42991, 42992, order)

			class NoUnderlyingDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41809
					order[1] = 0
					fix.Group.__init__(self, 41808, 41809, order)

			class NoUnderlyingDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41805
					order[1] = 41806
					order[2] = 41807
					order[3] = 0
					fix.Group.__init__(self, 41804, 41805, order)

			class NoUnderlyingDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41757
					order[1] = 41758
					order[2] = 41759
					order[3] = 41760
					order[4] = 41761
					order[5] = 41762
					order[6] = 41763
					order[7] = 41764
					order[8] = 41765
					order[9] = 41766
					order[10] = 41767
					order[11] = 41768
					order[12] = 41769
					order[13] = 41770
					order[14] = 0
					fix.Group.__init__(self, 41756, 41757, order)

				class NoUnderlyingDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41771
						order[1] = 41772
						order[2] = 41773
						order[3] = 0
						fix.Group.__init__(self, 41770, 41771, order)

					class NoUnderlyingDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41774
							order[1] = 41775
							order[2] = 41776
							order[3] = 0
							fix.Group.__init__(self, 41773, 41774, order)

		class NoUnderlyingProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 42150
				order[1] = 42151
				order[2] = 42152
				order[3] = 42190
				order[4] = 42153
				order[5] = 42154
				order[6] = 42155
				order[7] = 43002
				order[8] = 43003
				order[9] = 42156
				order[10] = 42157
				order[11] = 42158
				order[12] = 42104
				order[13] = 42105
				order[14] = 42106
				order[15] = 42107
				order[16] = 42108
				order[17] = 42109
				order[18] = 42110
				order[19] = 42111
				order[20] = 42115
				order[21] = 42116
				order[22] = 42117
				order[23] = 42118
				order[24] = 42119
				order[25] = 42120
				order[26] = 42121
				order[27] = 42122
				order[28] = 42123
				order[29] = 42124
				order[30] = 42125
				order[31] = 42126
				order[32] = 42127
				order[33] = 42128
				order[34] = 42129
				order[35] = 42130
				order[36] = 42131
				order[37] = 42132
				order[38] = 42133
				order[39] = 42134
				order[40] = 42135
				order[41] = 42136
				order[42] = 42137
				order[43] = 42138
				order[44] = 42139
				order[45] = 42140
				order[46] = 42141
				order[47] = 42142
				order[48] = 42143
				order[49] = 42144
				order[50] = 42145
				order[51] = 42146
				order[52] = 42147
				order[53] = 42148
				order[54] = 42159
				order[55] = 42160
				order[56] = 42161
				order[57] = 42162
				order[58] = 42163
				order[59] = 42164
				order[60] = 42165
				order[61] = 42092
				order[62] = 42093
				order[63] = 42094
				order[64] = 42095
				order[65] = 42096
				order[66] = 42097
				order[67] = 42098
				order[68] = 42166
				order[69] = 42167
				order[70] = 42168
				order[71] = 42169
				order[72] = 42102
				order[73] = 42103
				order[74] = 42170
				order[75] = 42171
				order[76] = 42172
				order[77] = 42173
				order[78] = 0
				fix.Group.__init__(self, 42149, 42150, order)

			class NoUnderlyingProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42191
					order[1] = 0
					fix.Group.__init__(self, 42190, 42191, order)

			class NoUnderlyingProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42183
					order[1] = 0
					fix.Group.__init__(self, 42182, 42183, order)

			class NoUnderlyingProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42185
					order[1] = 0
					fix.Group.__init__(self, 42184, 42185, order)

			class NoUnderlyingProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42113
					order[1] = 42114
					order[2] = 0
					fix.Group.__init__(self, 42112, 42113, order)

			class NoUnderlyingProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42187
					order[1] = 0
					fix.Group.__init__(self, 42186, 42187, order)

			class NoUnderlyingProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42189
					order[1] = 0
					fix.Group.__init__(self, 42188, 42189, order)

			class NoUnderlyingProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42181
					order[1] = 0
					fix.Group.__init__(self, 42180, 42181, order)

			class NoUnderlyingProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42100
					order[1] = 42101
					order[2] = 0
					fix.Group.__init__(self, 42099, 42100, order)

			class NoUnderlyingProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 42174
					order[1] = 42175
					order[2] = 42176
					order[3] = 40918
					order[4] = 42177
					order[5] = 0
					fix.Group.__init__(self, 42173, 42174, order)

				class NoUnderlyingProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42178
						order[1] = 42179
						order[2] = 0
						fix.Group.__init__(self, 42177, 42178, order)

		class NoUnderlyingAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 42037
				order[1] = 42038
				order[2] = 41340
				order[3] = 0
				fix.Group.__init__(self, 42036, 42037, order)

			class NoUnderlyingAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41341
					order[1] = 41701
					order[2] = 41709
					order[3] = 41710
					order[4] = 41711
					order[5] = 41712
					order[6] = 42017
					order[7] = 42025
					order[8] = 42026
					order[9] = 42027
					order[10] = 42028
					order[11] = 42029
					order[12] = 42030
					order[13] = 42031
					order[14] = 42032
					order[15] = 42033
					order[16] = 42034
					order[17] = 42035
					order[18] = 0
					fix.Group.__init__(self, 41340, 41341, order)

		class NoUnderlyingProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 42069
				order[1] = 42070
				order[2] = 42071
				order[3] = 42072
				order[4] = 42073
				order[5] = 42074
				order[6] = 42075
				order[7] = 42090
				order[8] = 42077
				order[9] = 42087
				order[10] = 42076
				order[11] = 0
				fix.Group.__init__(self, 42068, 42069, order)

			class NoUnderlyingProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42091
					order[1] = 0
					fix.Group.__init__(self, 42090, 42091, order)

			class NoUnderlyingProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 42078
					order[1] = 42079
					order[2] = 42080
					order[3] = 42081
					order[4] = 42082
					order[5] = 42083
					order[6] = 42084
					order[7] = 42085
					order[8] = 0
					fix.Group.__init__(self, 42077, 42078, order)

				class NoUnderlyingProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42086
						order[1] = 0
						fix.Group.__init__(self, 42085, 42086, order)

			class NoUnderlyingProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42088
					order[1] = 42089
					order[2] = 0
					fix.Group.__init__(self, 42087, 42088, order)

		class NoUnderlyingCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 42042
				order[1] = 42043
				order[2] = 42044
				order[3] = 42045
				order[4] = 42046
				order[5] = 42047
				order[6] = 42048
				order[7] = 42049
				order[8] = 42050
				order[9] = 42051
				order[10] = 42052
				order[11] = 42039
				order[12] = 42797
				order[13] = 42798
				order[14] = 42053
				order[15] = 42054
				order[16] = 42790
				order[17] = 42791
				order[18] = 42792
				order[19] = 42793
				order[20] = 42794
				order[21] = 42795
				order[22] = 42796
				order[23] = 42055
				order[24] = 42056
				order[25] = 42057
				order[26] = 42058
				order[27] = 42059
				order[28] = 0
				fix.Group.__init__(self, 42041, 42042, order)

			class NoUnderlyingCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42040
					order[1] = 0
					fix.Group.__init__(self, 42039, 42040, order)

			class NoUnderlyingCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42789
					order[1] = 0
					fix.Group.__init__(self, 42788, 42789, order)

		class NoUnderlyingPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 42065
				order[1] = 42061
				order[2] = 42062
				order[3] = 42063
				order[4] = 42064
				order[5] = 0
				fix.Group.__init__(self, 42060, 42065, order)

			class NoUnderlyingPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42066
					order[1] = 42067
					order[2] = 0
					fix.Group.__init__(self, 42065, 42066, order)

		class NoUnderlyingRateSpreadSteps(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 43006
				order[1] = 43007
				order[2] = 0
				fix.Group.__init__(self, 43005, 43006, order)

		class NoUnderlyingDividendPayments(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 42856
				order[1] = 42857
				order[2] = 42858
				order[3] = 42859
				order[4] = 0
				fix.Group.__init__(self, 42855, 42856, order)

		class NoUnderlyingExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42885
				order[1] = 42886
				order[2] = 0
				fix.Group.__init__(self, 42884, 42885, order)

	class NoRelatedInstruments(fix.Group):
		def __init__(self):
			order = fix.IntArray(11)
			order[0] = 1648
			order[1] = 1649
			order[2] = 1650
			order[3] = 1651
			order[4] = 1652
			order[5] = 1653
			order[6] = 2413
			order[7] = 2414
			order[8] = 2415
			order[9] = 2417
			order[10] = 0
			fix.Group.__init__(self, 1647, 1648, order)

	class NoRoutingIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 216
			order[1] = 217
			order[2] = 0
			fix.Group.__init__(self, 215, 216, order)

class ExecutionReport(Message):
	def __init__(self):
		Message.__init__(self)
		self.getHeader().setField( fix.MsgType("8") )

	class NoPartyIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 448
			order[1] = 447
			order[2] = 452
			order[3] = 2376
			order[4] = 802
			order[5] = 0
			fix.Group.__init__(self, 453, 448, order)

		class NoPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 523
				order[1] = 803
				order[2] = 0
				fix.Group.__init__(self, 802, 523, order)

	class NoTargetPartyIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1462
			order[1] = 1463
			order[2] = 1464
			order[3] = 1818
			order[4] = 2433
			order[5] = 0
			fix.Group.__init__(self, 1461, 1462, order)

		class NoTargetPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 2434
				order[1] = 2435
				order[2] = 0
				fix.Group.__init__(self, 2433, 2434, order)

	class NoContraBrokers(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 375
			order[1] = 337
			order[2] = 437
			order[3] = 438
			order[4] = 655
			order[5] = 0
			fix.Group.__init__(self, 382, 375, order)

	class NoRegulatoryTradeIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(7)
			order[0] = 1903
			order[1] = 1905
			order[2] = 1904
			order[3] = 1906
			order[4] = 2411
			order[5] = 2397
			order[6] = 0
			fix.Group.__init__(self, 1907, 1903, order)

	class NoAllocs(fix.Group):
		def __init__(self):
			order = fix.IntArray(14)
			order[0] = 79
			order[1] = 661
			order[2] = 736
			order[3] = 2927
			order[4] = 467
			order[5] = 2727
			order[6] = 539
			order[7] = 209
			order[8] = 80
			order[9] = 1752
			order[10] = 1753
			order[11] = 1754
			order[12] = 1755
			order[13] = 0
			fix.Group.__init__(self, 78, 79, order)

		class NoNestedPartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 524
				order[1] = 525
				order[2] = 538
				order[3] = 2384
				order[4] = 804
				order[5] = 0
				fix.Group.__init__(self, 539, 524, order)

			class NoNestedPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 545
					order[1] = 805
					order[2] = 0
					fix.Group.__init__(self, 804, 545, order)

	class NoSecurityAltID(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 455
			order[1] = 456
			order[2] = 2957
			order[3] = 0
			fix.Group.__init__(self, 454, 455, order)

	class NoSecondaryAssetClasses(fix.Group):
		def __init__(self):
			order = fix.IntArray(5)
			order[0] = 1977
			order[1] = 1978
			order[2] = 1979
			order[3] = 2741
			order[4] = 0
			fix.Group.__init__(self, 1976, 1977, order)

	class NoAssetAttributes(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 2305
			order[1] = 2306
			order[2] = 2307
			order[3] = 0
			fix.Group.__init__(self, 2304, 2305, order)

	class NoEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(11)
			order[0] = 865
			order[1] = 866
			order[2] = 1145
			order[3] = 1827
			order[4] = 1826
			order[5] = 2340
			order[6] = 867
			order[7] = 868
			order[8] = 1578
			order[9] = 1579
			order[10] = 0
			fix.Group.__init__(self, 864, 865, order)

	class NoInstrumentParties(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1019
			order[1] = 1050
			order[2] = 1051
			order[3] = 2378
			order[4] = 1052
			order[5] = 0
			fix.Group.__init__(self, 1018, 1019, order)

		class NoInstrumentPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 1053
				order[1] = 1054
				order[2] = 0
				fix.Group.__init__(self, 1052, 1053, order)

	class NoComplexEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(53)
			order[0] = 1484
			order[1] = 2117
			order[2] = 2118
			order[3] = 2119
			order[4] = 1485
			order[5] = 2120
			order[6] = 2121
			order[7] = 2122
			order[8] = 2941
			order[9] = 1486
			order[10] = 2123
			order[11] = 1487
			order[12] = 1488
			order[13] = 1489
			order[14] = 1490
			order[15] = 1491
			order[16] = 2124
			order[17] = 2942
			order[18] = 2125
			order[19] = 2943
			order[20] = 2126
			order[21] = 2127
			order[22] = 2407
			order[23] = 2408
			order[24] = 2128
			order[25] = 2129
			order[26] = 2130
			order[27] = 2131
			order[28] = 2132
			order[29] = 41013
			order[30] = 41020
			order[31] = 41021
			order[32] = 41022
			order[33] = 41023
			order[34] = 41024
			order[35] = 41025
			order[36] = 41026
			order[37] = 41027
			order[38] = 41028
			order[39] = 41010
			order[40] = 2133
			order[41] = 2134
			order[42] = 2135
			order[43] = 2136
			order[44] = 2137
			order[45] = 41029
			order[46] = 40997
			order[47] = 2597
			order[48] = 2598
			order[49] = 2599
			order[50] = 2138
			order[51] = 2139
			order[52] = 0
			fix.Group.__init__(self, 1483, 1484, order)

		class NoComplexEventDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 1492
				order[1] = 1493
				order[2] = 1494
				order[3] = 0
				fix.Group.__init__(self, 1491, 1492, order)

			class NoComplexEventTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1495
					order[1] = 1496
					order[2] = 0
					fix.Group.__init__(self, 1494, 1495, order)

		class NoComplexEventRateSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 41014
				order[1] = 41015
				order[2] = 41016
				order[3] = 41017
				order[4] = 0
				fix.Group.__init__(self, 41013, 41014, order)

		class NoComplexEventDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41019
				order[1] = 0
				fix.Group.__init__(self, 41018, 41019, order)

		class NoComplexEventPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41011
				order[1] = 41012
				order[2] = 41031
				order[3] = 41007
				order[4] = 40994
				order[5] = 0
				fix.Group.__init__(self, 41010, 41011, order)

			class NoComplexEventSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41032
					order[1] = 41033
					order[2] = 41034
					order[3] = 41035
					order[4] = 41036
					order[5] = 0
					fix.Group.__init__(self, 41031, 41032, order)

			class NoComplexEventPeriodDateTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41008
					order[1] = 41009
					order[2] = 0
					fix.Group.__init__(self, 41007, 41008, order)

			class NoComplexEventAveragingObservations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40995
					order[1] = 40996
					order[2] = 0
					fix.Group.__init__(self, 40994, 40995, order)

		class NoComplexEventCreditEventSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41030
				order[1] = 0
				fix.Group.__init__(self, 41029, 41030, order)

		class NoComplexEventCreditEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40998
				order[1] = 40999
				order[2] = 41000
				order[3] = 41001
				order[4] = 41002
				order[5] = 41003
				order[6] = 41004
				order[7] = 41005
				order[8] = 0
				fix.Group.__init__(self, 40997, 40998, order)

			class NoComplexEventCreditEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41006
					order[1] = 0
					fix.Group.__init__(self, 41005, 41006, order)

	class NoBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40471
			order[1] = 0
			fix.Group.__init__(self, 40278, 40471, order)

	class NoPricingDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41231
			order[1] = 0
			fix.Group.__init__(self, 41230, 41231, order)

	class NoMarketDisruptionEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41093
			order[1] = 40991
			order[2] = 0
			fix.Group.__init__(self, 41092, 41093, order)

	class NoMarketDisruptionFallbacks(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41095
			order[1] = 40992
			order[2] = 0
			fix.Group.__init__(self, 41094, 41095, order)

	class NoMarketDisruptionFallbackReferencePrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(10)
			order[0] = 41097
			order[1] = 41098
			order[2] = 41099
			order[3] = 41100
			order[4] = 41101
			order[5] = 41102
			order[6] = 41103
			order[7] = 41104
			order[8] = 41105
			order[9] = 0
			fix.Group.__init__(self, 41096, 41097, order)

	class NoSettlMethodElectionDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 42776
			order[1] = 0
			fix.Group.__init__(self, 42775, 42776, order)

	class NoOptionExerciseBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41117
			order[1] = 0
			fix.Group.__init__(self, 41116, 41117, order)

	class NoOptionExerciseDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41138
			order[1] = 41139
			order[2] = 0
			fix.Group.__init__(self, 41137, 41138, order)

	class NoOptionExerciseExpirationDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41141
			order[1] = 0
			fix.Group.__init__(self, 41140, 41141, order)

	class NoOptionExerciseExpirationDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41153
			order[1] = 41154
			order[2] = 0
			fix.Group.__init__(self, 41152, 41153, order)

	class NoStreams(fix.Group):
		def __init__(self):
			order = fix.IntArray(135)
			order[0] = 40050
			order[1] = 41303
			order[2] = 40051
			order[3] = 42784
			order[4] = 42785
			order[5] = 40052
			order[6] = 40053
			order[7] = 41305
			order[8] = 40054
			order[9] = 40055
			order[10] = 42786
			order[11] = 42787
			order[12] = 41306
			order[13] = 41307
			order[14] = 41308
			order[15] = 41309
			order[16] = 41310
			order[17] = 41311
			order[18] = 41251
			order[19] = 41252
			order[20] = 41253
			order[21] = 41254
			order[22] = 41255
			order[23] = 41256
			order[24] = 41257
			order[25] = 42587
			order[26] = 41258
			order[27] = 41259
			order[28] = 41260
			order[29] = 41261
			order[30] = 41262
			order[31] = 41263
			order[32] = 41264
			order[33] = 41265
			order[34] = 41266
			order[35] = 41267
			order[36] = 41268
			order[37] = 41269
			order[38] = 41270
			order[39] = 41271
			order[40] = 41272
			order[41] = 41273
			order[42] = 41274
			order[43] = 41275
			order[44] = 41276
			order[45] = 40907
			order[46] = 40908
			order[47] = 40910
			order[48] = 40911
			order[49] = 40912
			order[50] = 40913
			order[51] = 40914
			order[52] = 40065
			order[53] = 40066
			order[54] = 40068
			order[55] = 40069
			order[56] = 40070
			order[57] = 40071
			order[58] = 40072
			order[59] = 41244
			order[60] = 41245
			order[61] = 40073
			order[62] = 40075
			order[63] = 40076
			order[64] = 40078
			order[65] = 40079
			order[66] = 40080
			order[67] = 40081
			order[68] = 40082
			order[69] = 40083
			order[70] = 40084
			order[71] = 41246
			order[72] = 41247
			order[73] = 41248
			order[74] = 40738
			order[75] = 40739
			order[76] = 40740
			order[77] = 42600
			order[78] = 40741
			order[79] = 40742
			order[80] = 43106
			order[81] = 40743
			order[82] = 40744
			order[83] = 40745
			order[84] = 40746
			order[85] = 40747
			order[86] = 42601
			order[87] = 42602
			order[88] = 42603
			order[89] = 42604
			order[90] = 40748
			order[91] = 40749
			order[92] = 40750
			order[93] = 41180
			order[94] = 41181
			order[95] = 41182
			order[96] = 41183
			order[97] = 41184
			order[98] = 41185
			order[99] = 41186
			order[100] = 42605
			order[101] = 40828
			order[102] = 40872
			order[103] = 41058
			order[104] = 41059
			order[105] = 41060
			order[106] = 41061
			order[107] = 41062
			order[108] = 42192
			order[109] = 42193
			order[110] = 41063
			order[111] = 41064
			order[112] = 41065
			order[113] = 41066
			order[114] = 41067
			order[115] = 41218
			order[116] = 41068
			order[117] = 41069
			order[118] = 41070
			order[119] = 41071
			order[120] = 41072
			order[121] = 41073
			order[122] = 41074
			order[123] = 41075
			order[124] = 41076
			order[125] = 41077
			order[126] = 41078
			order[127] = 41079
			order[128] = 41080
			order[129] = 43094
			order[130] = 41037
			order[131] = 40056
			order[132] = 40982
			order[133] = 40983
			order[134] = 0
			fix.Group.__init__(self, 40049, 40050, order)

		class NoStreamCommodityAltIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41278
				order[1] = 41279
				order[2] = 0
				fix.Group.__init__(self, 41277, 41278, order)

		class NoStreamAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41238
				order[1] = 41239
				order[2] = 41240
				order[3] = 0
				fix.Group.__init__(self, 41237, 41238, order)

		class NoStreamCommodityDataSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41281
				order[1] = 41282
				order[2] = 0
				fix.Group.__init__(self, 41280, 41281, order)

		class NoStreamCommoditySettlBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41250
				order[1] = 0
				fix.Group.__init__(self, 41249, 41250, order)

		class NoStreamCommoditySettlPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41290
				order[1] = 41291
				order[2] = 41292
				order[3] = 41293
				order[4] = 41294
				order[5] = 41295
				order[6] = 41296
				order[7] = 41297
				order[8] = 41298
				order[9] = 41299
				order[10] = 41300
				order[11] = 41283
				order[12] = 41301
				order[13] = 41302
				order[14] = 0
				fix.Group.__init__(self, 41289, 41290, order)

			class NoStreamCommoditySettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41284
					order[1] = 41285
					order[2] = 41286
					order[3] = 0
					fix.Group.__init__(self, 41283, 41284, order)

				class NoStreamCommoditySettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41287
						order[1] = 41288
						order[2] = 41588
						order[3] = 0
						fix.Group.__init__(self, 41286, 41287, order)

		class NoStreamEffectiveDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40909
				order[1] = 0
				fix.Group.__init__(self, 40960, 40909, order)

		class NoStreamTerminationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40067
				order[1] = 0
				fix.Group.__init__(self, 40961, 40067, order)

		class NoStreamCalculationPeriodBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40074
				order[1] = 0
				fix.Group.__init__(self, 40958, 40074, order)

		class NoStreamCalculationPeriodDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41242
				order[1] = 41243
				order[2] = 0
				fix.Group.__init__(self, 41241, 41242, order)

		class NoStreamFirstPeriodStartDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40077
				order[1] = 0
				fix.Group.__init__(self, 40959, 40077, order)

		class NoPaymentStreamPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40752
				order[1] = 0
				fix.Group.__init__(self, 40947, 40752, order)

		class NoPaymentStreamPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41221
				order[1] = 41222
				order[2] = 0
				fix.Group.__init__(self, 41220, 41221, order)

		class NoPaymentStreamResetDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40763
				order[1] = 0
				fix.Group.__init__(self, 40948, 40763, order)

		class NoPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40769
				order[1] = 0
				fix.Group.__init__(self, 40949, 40769, order)

		class NoPaymentStreamFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40776
				order[1] = 0
				fix.Group.__init__(self, 40950, 40776, order)

		class NoPaymentStreamFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42661
				order[1] = 42662
				order[2] = 0
				fix.Group.__init__(self, 42660, 42661, order)

		class NoPaymentStreamPricingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41193
				order[1] = 0
				fix.Group.__init__(self, 41192, 41193, order)

		class NoPaymentStreamPricingDays(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41228
				order[1] = 41229
				order[2] = 0
				fix.Group.__init__(self, 41227, 41228, order)

		class NoPaymentStreamPricingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41225
				order[1] = 41226
				order[2] = 0
				fix.Group.__init__(self, 41224, 41225, order)

		class NoPaymentStreamFormulas(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 43109
				order[1] = 42684
				order[2] = 42685
				order[3] = 0
				fix.Group.__init__(self, 42683, 43109, order)

		class NoDividendPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(21)
				order[0] = 42275
				order[1] = 42276
				order[2] = 42277
				order[3] = 42278
				order[4] = 42279
				order[5] = 42280
				order[6] = 42294
				order[7] = 42281
				order[8] = 42282
				order[9] = 42283
				order[10] = 42284
				order[11] = 42285
				order[12] = 42286
				order[13] = 42287
				order[14] = 42288
				order[15] = 42289
				order[16] = 42290
				order[17] = 42291
				order[18] = 42292
				order[19] = 42293
				order[20] = 0
				fix.Group.__init__(self, 42274, 42275, order)

			class NoDividendPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42295
					order[1] = 0
					fix.Group.__init__(self, 42294, 42295, order)

		class NoDividendFXTriggerDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42273
				order[1] = 0
				fix.Group.__init__(self, 42272, 42273, order)

		class NoDividendAccrualPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42237
				order[1] = 0
				fix.Group.__init__(self, 42236, 42237, order)

		class NoReturnRates(fix.Group):
			def __init__(self):
				order = fix.IntArray(30)
				order[0] = 42736
				order[1] = 42737
				order[2] = 42738
				order[3] = 42739
				order[4] = 42740
				order[5] = 42741
				order[6] = 42765
				order[7] = 42731
				order[8] = 42742
				order[9] = 42743
				order[10] = 42744
				order[11] = 42745
				order[12] = 42746
				order[13] = 42747
				order[14] = 42748
				order[15] = 42749
				order[16] = 42750
				order[17] = 42751
				order[18] = 42752
				order[19] = 42753
				order[20] = 42761
				order[21] = 42754
				order[22] = 42755
				order[23] = 42709
				order[24] = 42756
				order[25] = 42757
				order[26] = 42758
				order[27] = 42759
				order[28] = 42760
				order[29] = 0
				fix.Group.__init__(self, 42735, 42736, order)

			class NoReturnRatePrices(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 42766
					order[1] = 42767
					order[2] = 42768
					order[3] = 42769
					order[4] = 0
					fix.Group.__init__(self, 42765, 42766, order)

			class NoReturnRateFXConversions(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42732
					order[1] = 42733
					order[2] = 42734
					order[3] = 0
					fix.Group.__init__(self, 42731, 42732, order)

			class NoReturnRateInformationSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42762
					order[1] = 42763
					order[2] = 42764
					order[3] = 0
					fix.Group.__init__(self, 42761, 42762, order)

			class NoReturnRateDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(24)
					order[0] = 42710
					order[1] = 42772
					order[2] = 42711
					order[3] = 42712
					order[4] = 42713
					order[5] = 42714
					order[6] = 42715
					order[7] = 42716
					order[8] = 42717
					order[9] = 42718
					order[10] = 42719
					order[11] = 42720
					order[12] = 42721
					order[13] = 42722
					order[14] = 42723
					order[15] = 42724
					order[16] = 42725
					order[17] = 42726
					order[18] = 42727
					order[19] = 42728
					order[20] = 42729
					order[21] = 42730
					order[22] = 42770
					order[23] = 0
					fix.Group.__init__(self, 42709, 42710, order)

				class NoReturnRateValuationDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42773
						order[1] = 42774
						order[2] = 0
						fix.Group.__init__(self, 42772, 42773, order)

				class NoReturnRateValuationDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42771
						order[1] = 0
						fix.Group.__init__(self, 42770, 42771, order)

		class NoPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42621
				order[1] = 0
				fix.Group.__init__(self, 42620, 42621, order)

		class NoPaymentStreamCompoundingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42607
				order[1] = 42608
				order[2] = 0
				fix.Group.__init__(self, 42606, 42607, order)

		class NoPaymentStreamNonDeliverableFixingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40819
				order[1] = 0
				fix.Group.__init__(self, 40946, 40819, order)

		class NoNonDeliverableFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40826
				order[1] = 40827
				order[2] = 0
				fix.Group.__init__(self, 40825, 40826, order)

		class NoSettlRateFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40086
				order[1] = 40373
				order[2] = 40655
				order[3] = 40088
				order[4] = 40089
				order[5] = 0
				fix.Group.__init__(self, 40085, 40086, order)

		class NoPaymentSchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(58)
				order[0] = 40829
				order[1] = 41164
				order[2] = 41165
				order[3] = 40830
				order[4] = 40831
				order[5] = 40832
				order[6] = 40833
				order[7] = 40834
				order[8] = 40835
				order[9] = 40836
				order[10] = 40837
				order[11] = 40838
				order[12] = 40839
				order[13] = 41166
				order[14] = 41167
				order[15] = 41168
				order[16] = 41169
				order[17] = 40840
				order[18] = 40841
				order[19] = 40842
				order[20] = 40843
				order[21] = 41170
				order[22] = 41171
				order[23] = 41172
				order[24] = 41173
				order[25] = 40844
				order[26] = 40845
				order[27] = 40846
				order[28] = 40847
				order[29] = 40848
				order[30] = 40849
				order[31] = 40868
				order[32] = 40850
				order[33] = 40851
				order[34] = 40852
				order[35] = 40853
				order[36] = 40977
				order[37] = 40855
				order[38] = 40856
				order[39] = 40857
				order[40] = 41174
				order[41] = 41175
				order[42] = 40858
				order[43] = 41161
				order[44] = 41176
				order[45] = 41177
				order[46] = 41178
				order[47] = 41179
				order[48] = 40859
				order[49] = 40860
				order[50] = 40861
				order[51] = 40862
				order[52] = 40945
				order[53] = 40864
				order[54] = 40865
				order[55] = 40866
				order[56] = 40867
				order[57] = 0
				fix.Group.__init__(self, 40828, 40829, order)

			class NoPaymentScheduleRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 40869
					order[1] = 40870
					order[2] = 40871
					order[3] = 0
					fix.Group.__init__(self, 40868, 40869, order)

			class NoPaymentScheduleFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40854
					order[1] = 0
					fix.Group.__init__(self, 40977, 40854, order)

			class NoPaymentScheduleFixingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41162
					order[1] = 41163
					order[2] = 0
					fix.Group.__init__(self, 41161, 41162, order)

			class NoPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40863
					order[1] = 0
					fix.Group.__init__(self, 40945, 40863, order)

		class NoPaymentStubs(fix.Group):
			def __init__(self):
				order = fix.IntArray(44)
				order[0] = 40873
				order[1] = 40874
				order[2] = 42698
				order[3] = 42699
				order[4] = 42700
				order[5] = 42701
				order[6] = 42702
				order[7] = 42703
				order[8] = 42704
				order[9] = 42689
				order[10] = 42690
				order[11] = 42691
				order[12] = 42692
				order[13] = 42693
				order[14] = 42694
				order[15] = 42695
				order[16] = 40875
				order[17] = 40876
				order[18] = 40877
				order[19] = 40878
				order[20] = 40879
				order[21] = 40880
				order[22] = 40881
				order[23] = 40882
				order[24] = 40883
				order[25] = 40884
				order[26] = 40885
				order[27] = 40886
				order[28] = 40887
				order[29] = 40888
				order[30] = 40889
				order[31] = 40890
				order[32] = 40891
				order[33] = 40892
				order[34] = 40893
				order[35] = 40894
				order[36] = 40895
				order[37] = 40896
				order[38] = 40897
				order[39] = 40898
				order[40] = 40899
				order[41] = 40900
				order[42] = 40901
				order[43] = 0
				fix.Group.__init__(self, 40872, 40873, order)

			class NoPaymentStubStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42706
					order[1] = 0
					fix.Group.__init__(self, 42705, 42706, order)

			class NoPaymentStubEndDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42697
					order[1] = 0
					fix.Group.__init__(self, 42696, 42697, order)

		class NoDeliveryStreamCommoditySources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41086
				order[1] = 0
				fix.Group.__init__(self, 41085, 41086, order)

		class NoDeliveryStreamCycles(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41082
				order[1] = 41083
				order[2] = 41084
				order[3] = 0
				fix.Group.__init__(self, 41081, 41082, order)

		class NoDeliverySchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41038
				order[1] = 41039
				order[2] = 41040
				order[3] = 41041
				order[4] = 41042
				order[5] = 41043
				order[6] = 41044
				order[7] = 41045
				order[8] = 41046
				order[9] = 41047
				order[10] = 41048
				order[11] = 41049
				order[12] = 41050
				order[13] = 41051
				order[14] = 0
				fix.Group.__init__(self, 41037, 41038, order)

			class NoDeliveryScheduleSettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41052
					order[1] = 41053
					order[2] = 41054
					order[3] = 0
					fix.Group.__init__(self, 41051, 41052, order)

				class NoDeliveryScheduleSettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41055
						order[1] = 41056
						order[2] = 41057
						order[3] = 0
						fix.Group.__init__(self, 41054, 41055, order)

	class NoProvisions(fix.Group):
		def __init__(self):
			order = fix.IntArray(79)
			order[0] = 40091
			order[1] = 40092
			order[2] = 40093
			order[3] = 40957
			order[4] = 40095
			order[5] = 40096
			order[6] = 40097
			order[7] = 42707
			order[8] = 42708
			order[9] = 40098
			order[10] = 40099
			order[11] = 40100
			order[12] = 40114
			order[13] = 40115
			order[14] = 40116
			order[15] = 40118
			order[16] = 40119
			order[17] = 40120
			order[18] = 40121
			order[19] = 40122
			order[20] = 40123
			order[21] = 40125
			order[22] = 40126
			order[23] = 40127
			order[24] = 40128
			order[25] = 40129
			order[26] = 40130
			order[27] = 40131
			order[28] = 40132
			order[29] = 40133
			order[30] = 40134
			order[31] = 40135
			order[32] = 40136
			order[33] = 40137
			order[34] = 40138
			order[35] = 40139
			order[36] = 40140
			order[37] = 40141
			order[38] = 40145
			order[39] = 40146
			order[40] = 40148
			order[41] = 40149
			order[42] = 40150
			order[43] = 40151
			order[44] = 40152
			order[45] = 40153
			order[46] = 40154
			order[47] = 40155
			order[48] = 40156
			order[49] = 40158
			order[50] = 40159
			order[51] = 40160
			order[52] = 40161
			order[53] = 40162
			order[54] = 40101
			order[55] = 40102
			order[56] = 40103
			order[57] = 40104
			order[58] = 40105
			order[59] = 40106
			order[60] = 40107
			order[61] = 40163
			order[62] = 40165
			order[63] = 40166
			order[64] = 40167
			order[65] = 40168
			order[66] = 40169
			order[67] = 40170
			order[68] = 40108
			order[69] = 40109
			order[70] = 40110
			order[71] = 40111
			order[72] = 40112
			order[73] = 41406
			order[74] = 40113
			order[75] = 40986
			order[76] = 40987
			order[77] = 40174
			order[78] = 0
			fix.Group.__init__(self, 40090, 40091, order)

		class NoProvisionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40094
				order[1] = 0
				fix.Group.__init__(self, 40957, 40094, order)

		class NoProvisionCashSettlValueDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40117
				order[1] = 0
				fix.Group.__init__(self, 40953, 40117, order)

		class NoProvisionOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40124
				order[1] = 0
				fix.Group.__init__(self, 40954, 40124, order)

		class NoProvisionOptionExerciseFixedDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40143
				order[1] = 40144
				order[2] = 0
				fix.Group.__init__(self, 40142, 40143, order)

		class NoProvisionOptionExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40147
				order[1] = 0
				fix.Group.__init__(self, 40955, 40147, order)

		class NoProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40157
				order[1] = 0
				fix.Group.__init__(self, 40956, 40157, order)

		class NoProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40164
				order[1] = 0
				fix.Group.__init__(self, 40952, 40164, order)

		class NoProvisionCashSettlPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40172
				order[1] = 40173
				order[2] = 0
				fix.Group.__init__(self, 40171, 40172, order)

		class NoProvisionPartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40175
				order[1] = 40176
				order[2] = 40177
				order[3] = 2385
				order[4] = 40178
				order[5] = 0
				fix.Group.__init__(self, 40174, 40175, order)

			class NoProvisionPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40179
					order[1] = 40180
					order[2] = 0
					fix.Group.__init__(self, 40178, 40179, order)

	class NoAdditionalTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40020
			order[1] = 40021
			order[2] = 40000
			order[3] = 0
			fix.Group.__init__(self, 40019, 40020, order)

		class NoAdditionalTermBondRefs(fix.Group):
			def __init__(self):
				order = fix.IntArray(19)
				order[0] = 40001
				order[1] = 40002
				order[2] = 40003
				order[3] = 40004
				order[4] = 40005
				order[5] = 40006
				order[6] = 40007
				order[7] = 40008
				order[8] = 40009
				order[9] = 40010
				order[10] = 40011
				order[11] = 40012
				order[12] = 40013
				order[13] = 40014
				order[14] = 40015
				order[15] = 40016
				order[16] = 40017
				order[17] = 40018
				order[18] = 0
				fix.Group.__init__(self, 40000, 40001, order)

	class NoProtectionTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(12)
			order[0] = 40182
			order[1] = 40183
			order[2] = 40184
			order[3] = 40185
			order[4] = 40186
			order[5] = 40187
			order[6] = 40188
			order[7] = 40951
			order[8] = 40191
			order[9] = 40201
			order[10] = 40190
			order[11] = 0
			fix.Group.__init__(self, 40181, 40182, order)

		class NoProtectionTermEventNewsSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40189
				order[1] = 0
				fix.Group.__init__(self, 40951, 40189, order)

		class NoProtectionTermEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40192
				order[1] = 40193
				order[2] = 40194
				order[3] = 40195
				order[4] = 40196
				order[5] = 40197
				order[6] = 40198
				order[7] = 40199
				order[8] = 0
				fix.Group.__init__(self, 40191, 40192, order)

			class NoProtectionTermEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40200
					order[1] = 0
					fix.Group.__init__(self, 40199, 40200, order)

		class NoProtectionTermObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40202
				order[1] = 40203
				order[2] = 0
				fix.Group.__init__(self, 40201, 40202, order)

	class NoCashSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(29)
			order[0] = 40023
			order[1] = 40024
			order[2] = 40916
			order[3] = 40917
			order[4] = 40025
			order[5] = 40026
			order[6] = 40027
			order[7] = 40028
			order[8] = 40029
			order[9] = 40030
			order[10] = 40031
			order[11] = 40277
			order[12] = 42216
			order[13] = 42217
			order[14] = 40033
			order[15] = 40034
			order[16] = 42207
			order[17] = 42208
			order[18] = 42209
			order[19] = 42210
			order[20] = 42211
			order[21] = 42212
			order[22] = 42213
			order[23] = 40035
			order[24] = 40036
			order[25] = 40037
			order[26] = 40038
			order[27] = 40039
			order[28] = 0
			fix.Group.__init__(self, 40022, 40023, order)

		class NoCashSettlDealers(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40032
				order[1] = 0
				fix.Group.__init__(self, 40277, 40032, order)

		class NoCashSettlDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42215
				order[1] = 0
				fix.Group.__init__(self, 42214, 42215, order)

	class NoPhysicalSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 40209
			order[1] = 40205
			order[2] = 40206
			order[3] = 40207
			order[4] = 40208
			order[5] = 0
			fix.Group.__init__(self, 40204, 40209, order)

		class NoPhysicalSettlDeliverableObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40210
				order[1] = 40211
				order[2] = 0
				fix.Group.__init__(self, 40209, 40210, order)

	class NoExtraordinaryEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 42297
			order[1] = 42298
			order[2] = 0
			fix.Group.__init__(self, 42296, 42297, order)

	class NoContractualDefinitions(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40041
			order[1] = 0
			fix.Group.__init__(self, 40040, 40041, order)

	class NoFinancingTermSupplements(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 40047
			order[1] = 40048
			order[2] = 0
			fix.Group.__init__(self, 40046, 40047, order)

	class NoContractualMatrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40043
			order[1] = 40044
			order[2] = 40045
			order[3] = 0
			fix.Group.__init__(self, 40042, 40043, order)

	class NoUnderlyings(fix.Group):
		def __init__(self):
			order = fix.IntArray(188)
			order[0] = 311
			order[1] = 312
			order[2] = 309
			order[3] = 305
			order[4] = 2874
			order[5] = 462
			order[6] = 463
			order[7] = 2894
			order[8] = 310
			order[9] = 763
			order[10] = 313
			order[11] = 542
			order[12] = 1213
			order[13] = 1837
			order[14] = 241
			order[15] = 1453
			order[16] = 1454
			order[17] = 2614
			order[18] = 2615
			order[19] = 2921
			order[20] = 2616
			order[21] = 2617
			order[22] = 2619
			order[23] = 1455
			order[24] = 1456
			order[25] = 1459
			order[26] = 1460
			order[27] = 242
			order[28] = 243
			order[29] = 244
			order[30] = 245
			order[31] = 246
			order[32] = 256
			order[33] = 595
			order[34] = 592
			order[35] = 593
			order[36] = 594
			order[37] = 247
			order[38] = 316
			order[39] = 941
			order[40] = 2917
			order[41] = 317
			order[42] = 436
			order[43] = 1437
			order[44] = 2363
			order[45] = 1441
			order[46] = 998
			order[47] = 1423
			order[48] = 1718
			order[49] = 2918
			order[50] = 1424
			order[51] = 1425
			order[52] = 1719
			order[53] = 2919
			order[54] = 1000
			order[55] = 1419
			order[56] = 1526
			order[57] = 2920
			order[58] = 435
			order[59] = 308
			order[60] = 306
			order[61] = 362
			order[62] = 363
			order[63] = 2742
			order[64] = 2720
			order[65] = 2721
			order[66] = 2722
			order[67] = 2723
			order[68] = 2724
			order[69] = 307
			order[70] = 364
			order[71] = 365
			order[72] = 877
			order[73] = 878
			order[74] = 972
			order[75] = 318
			order[76] = 2916
			order[77] = 879
			order[78] = 975
			order[79] = 973
			order[80] = 974
			order[81] = 810
			order[82] = 882
			order[83] = 883
			order[84] = 884
			order[85] = 885
			order[86] = 886
			order[87] = 2885
			order[88] = 2886
			order[89] = 1044
			order[90] = 1045
			order[91] = 1046
			order[92] = 1038
			order[93] = 1039
			order[94] = 315
			order[95] = 2683
			order[96] = 2687
			order[97] = 1988
			order[98] = 1989
			order[99] = 1990
			order[100] = 1991
			order[101] = 1992
			order[102] = 1993
			order[103] = 2881
			order[104] = 1994
			order[105] = 1995
			order[106] = 1996
			order[107] = 1997
			order[108] = 2620
			order[109] = 2621
			order[110] = 1998
			order[111] = 1999
			order[112] = 2000
			order[113] = 2003
			order[114] = 2004
			order[115] = 2005
			order[116] = 2006
			order[117] = 2284
			order[118] = 2285
			order[119] = 2286
			order[120] = 2287
			order[121] = 2288
			order[122] = 2007
			order[123] = 2008
			order[124] = 2009
			order[125] = 2010
			order[126] = 2011
			order[127] = 2012
			order[128] = 2491
			order[129] = 2013
			order[130] = 2014
			order[131] = 2015
			order[132] = 2744
			order[133] = 2016
			order[134] = 2289
			order[135] = 2017
			order[136] = 2018
			order[137] = 2019
			order[138] = 2020
			order[139] = 2021
			order[140] = 2022
			order[141] = 2290
			order[142] = 2622
			order[143] = 2291
			order[144] = 2623
			order[145] = 2292
			order[146] = 2023
			order[147] = 2024
			order[148] = 2025
			order[149] = 2026
			order[150] = 2027
			order[151] = 2028
			order[152] = 2029
			order[153] = 2757
			order[154] = 2030
			order[155] = 2031
			order[156] = 2293
			order[157] = 2294
			order[158] = 2032
			order[159] = 2033
			order[160] = 2034
			order[161] = 2035
			order[162] = 2036
			order[163] = 2037
			order[164] = 2038
			order[165] = 2039
			order[166] = 2040
			order[167] = 2041
			order[168] = 2042
			order[169] = 2043
			order[170] = 2044
			order[171] = 41314
			order[172] = 41315
			order[173] = 2295
			order[174] = 2296
			order[175] = 2297
			order[176] = 2756
			order[177] = 2298
			order[178] = 2299
			order[179] = 2624
			order[180] = 2625
			order[181] = 2626
			order[182] = 2627
			order[183] = 2628
			order[184] = 2629
			order[185] = 2630
			order[186] = 2631
			order[187] = 0
			fix.Group.__init__(self, 711, 311, order)

		class NoUnderlyingSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 458
				order[1] = 459
				order[2] = 2959
				order[3] = 0
				fix.Group.__init__(self, 457, 458, order)

		class NoUnderlyingStips(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 888
				order[1] = 889
				order[2] = 0
				fix.Group.__init__(self, 887, 888, order)

		class NoUndlyInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1059
				order[1] = 1060
				order[2] = 1061
				order[3] = 2391
				order[4] = 1062
				order[5] = 0
				fix.Group.__init__(self, 1058, 1059, order)

			class NoUndlyInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1063
					order[1] = 1064
					order[2] = 0
					fix.Group.__init__(self, 1062, 1063, order)

		class NoUnderlyingEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 1982
				order[1] = 1983
				order[2] = 1984
				order[3] = 1985
				order[4] = 1986
				order[5] = 2342
				order[6] = 1987
				order[7] = 2071
				order[8] = 2072
				order[9] = 2073
				order[10] = 0
				fix.Group.__init__(self, 1981, 1982, order)

		class NoUnderlyingSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2081
				order[1] = 2082
				order[2] = 2083
				order[3] = 2745
				order[4] = 0
				fix.Group.__init__(self, 2080, 2081, order)

		class NoUnderlyingAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2313
				order[1] = 2314
				order[2] = 2315
				order[3] = 0
				fix.Group.__init__(self, 2312, 2313, order)

		class NoUnderlyingComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2046
				order[1] = 2261
				order[2] = 2262
				order[3] = 2263
				order[4] = 2047
				order[5] = 2264
				order[6] = 2265
				order[7] = 2266
				order[8] = 2947
				order[9] = 2048
				order[10] = 2267
				order[11] = 2049
				order[12] = 2050
				order[13] = 2051
				order[14] = 2052
				order[15] = 2053
				order[16] = 2268
				order[17] = 2948
				order[18] = 2269
				order[19] = 2949
				order[20] = 2270
				order[21] = 2271
				order[22] = 2419
				order[23] = 2420
				order[24] = 2272
				order[25] = 2273
				order[26] = 2274
				order[27] = 2275
				order[28] = 2276
				order[29] = 41732
				order[30] = 41739
				order[31] = 41740
				order[32] = 41741
				order[33] = 41742
				order[34] = 41743
				order[35] = 41744
				order[36] = 41745
				order[37] = 41746
				order[38] = 41747
				order[39] = 41729
				order[40] = 2277
				order[41] = 2278
				order[42] = 2279
				order[43] = 2280
				order[44] = 2281
				order[45] = 41748
				order[46] = 41716
				order[47] = 2611
				order[48] = 2612
				order[49] = 2613
				order[50] = 2282
				order[51] = 2283
				order[52] = 0
				fix.Group.__init__(self, 2045, 2046, order)

			class NoUnderlyingComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2054
					order[1] = 2055
					order[2] = 2056
					order[3] = 0
					fix.Group.__init__(self, 2053, 2054, order)

				class NoUnderlyingComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2057
						order[1] = 2058
						order[2] = 0
						fix.Group.__init__(self, 2056, 2057, order)

			class NoUnderlyingComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41733
					order[1] = 41734
					order[2] = 41735
					order[3] = 41736
					order[4] = 0
					fix.Group.__init__(self, 41732, 41733, order)

			class NoUnderlyingComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41738
					order[1] = 0
					fix.Group.__init__(self, 41737, 41738, order)

			class NoUnderlyingComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41730
					order[1] = 41731
					order[2] = 41750
					order[3] = 41726
					order[4] = 41713
					order[5] = 0
					fix.Group.__init__(self, 41729, 41730, order)

				class NoUnderlyingComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41751
						order[1] = 41752
						order[2] = 41753
						order[3] = 41754
						order[4] = 41755
						order[5] = 0
						fix.Group.__init__(self, 41750, 41751, order)

				class NoUnderlyingComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41727
						order[1] = 41728
						order[2] = 0
						fix.Group.__init__(self, 41726, 41727, order)

				class NoUnderlyingComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41714
						order[1] = 41715
						order[2] = 0
						fix.Group.__init__(self, 41713, 41714, order)

			class NoUnderlyingComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41749
					order[1] = 0
					fix.Group.__init__(self, 41748, 41749, order)

			class NoUnderlyingComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41717
					order[1] = 41718
					order[2] = 41719
					order[3] = 41720
					order[4] = 41721
					order[5] = 41722
					order[6] = 41723
					order[7] = 41724
					order[8] = 0
					fix.Group.__init__(self, 41716, 41717, order)

				class NoUnderlyingComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41725
						order[1] = 0
						fix.Group.__init__(self, 41724, 41725, order)

		class NoUnderlyingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40963
				order[1] = 0
				fix.Group.__init__(self, 40962, 40963, order)

		class NoUnderlyingPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41948
				order[1] = 0
				fix.Group.__init__(self, 41947, 41948, order)

		class NoUnderlyingMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41865
				order[1] = 41338
				order[2] = 0
				fix.Group.__init__(self, 41864, 41865, order)

		class NoUnderlyingMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41867
				order[1] = 41339
				order[2] = 0
				fix.Group.__init__(self, 41866, 41867, order)

		class NoUnderlyingMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41869
				order[1] = 41870
				order[2] = 41871
				order[3] = 41872
				order[4] = 41873
				order[5] = 41874
				order[6] = 41875
				order[7] = 41876
				order[8] = 41877
				order[9] = 0
				fix.Group.__init__(self, 41868, 41869, order)

		class NoUnderlyingSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 43075
				order[1] = 0
				fix.Group.__init__(self, 43074, 43075, order)

		class NoUnderlyingOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41821
				order[1] = 0
				fix.Group.__init__(self, 41820, 41821, order)

		class NoUnderlyingOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41842
				order[1] = 41843
				order[2] = 0
				fix.Group.__init__(self, 41841, 41842, order)

		class NoUnderlyingOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41845
				order[1] = 0
				fix.Group.__init__(self, 41844, 41845, order)

		class NoUnderlyingOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41857
				order[1] = 41858
				order[2] = 0
				fix.Group.__init__(self, 41856, 41857, order)

		class NoUnderlyingStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40541
				order[1] = 42016
				order[2] = 40542
				order[3] = 43083
				order[4] = 43084
				order[5] = 40543
				order[6] = 40544
				order[7] = 42018
				order[8] = 40545
				order[9] = 40546
				order[10] = 43085
				order[11] = 43086
				order[12] = 42019
				order[13] = 42020
				order[14] = 42021
				order[15] = 42022
				order[16] = 42023
				order[17] = 42024
				order[18] = 41964
				order[19] = 41965
				order[20] = 41966
				order[21] = 41967
				order[22] = 41968
				order[23] = 41969
				order[24] = 41970
				order[25] = 42589
				order[26] = 41971
				order[27] = 41972
				order[28] = 41973
				order[29] = 41974
				order[30] = 41975
				order[31] = 41976
				order[32] = 41977
				order[33] = 41978
				order[34] = 41979
				order[35] = 41980
				order[36] = 41981
				order[37] = 41982
				order[38] = 41983
				order[39] = 41984
				order[40] = 41985
				order[41] = 41986
				order[42] = 41987
				order[43] = 41988
				order[44] = 41989
				order[45] = 40057
				order[46] = 40058
				order[47] = 40060
				order[48] = 40061
				order[49] = 40062
				order[50] = 40063
				order[51] = 40064
				order[52] = 40548
				order[53] = 40549
				order[54] = 40551
				order[55] = 40552
				order[56] = 40553
				order[57] = 40554
				order[58] = 40555
				order[59] = 41957
				order[60] = 41958
				order[61] = 40556
				order[62] = 40558
				order[63] = 40559
				order[64] = 40561
				order[65] = 40562
				order[66] = 40563
				order[67] = 40564
				order[68] = 40565
				order[69] = 40566
				order[70] = 40567
				order[71] = 41959
				order[72] = 41960
				order[73] = 41961
				order[74] = 40568
				order[75] = 40569
				order[76] = 40570
				order[77] = 42895
				order[78] = 40571
				order[79] = 40572
				order[80] = 43107
				order[81] = 40573
				order[82] = 40574
				order[83] = 40575
				order[84] = 40576
				order[85] = 40577
				order[86] = 42896
				order[87] = 42897
				order[88] = 42898
				order[89] = 42899
				order[90] = 40578
				order[91] = 40579
				order[92] = 40580
				order[93] = 41897
				order[94] = 41898
				order[95] = 41899
				order[96] = 41900
				order[97] = 41901
				order[98] = 41902
				order[99] = 41903
				order[100] = 42900
				order[101] = 40664
				order[102] = 40708
				order[103] = 41777
				order[104] = 41778
				order[105] = 41779
				order[106] = 41780
				order[107] = 41781
				order[108] = 42196
				order[109] = 42197
				order[110] = 41782
				order[111] = 41783
				order[112] = 41784
				order[113] = 41785
				order[114] = 41786
				order[115] = 41587
				order[116] = 41787
				order[117] = 41788
				order[118] = 41789
				order[119] = 41790
				order[120] = 41791
				order[121] = 41792
				order[122] = 41793
				order[123] = 41794
				order[124] = 41795
				order[125] = 41796
				order[126] = 41797
				order[127] = 41798
				order[128] = 41799
				order[129] = 43096
				order[130] = 41756
				order[131] = 40547
				order[132] = 40988
				order[133] = 40989
				order[134] = 0
				fix.Group.__init__(self, 40540, 40541, order)

			class NoUnderlyingStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41991
					order[1] = 41992
					order[2] = 0
					fix.Group.__init__(self, 41990, 41991, order)

			class NoUnderlyingStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41801
					order[1] = 41802
					order[2] = 41803
					order[3] = 0
					fix.Group.__init__(self, 41800, 41801, order)

			class NoUnderlyingStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41994
					order[1] = 41995
					order[2] = 0
					fix.Group.__init__(self, 41993, 41994, order)

			class NoUnderlyingStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41963
					order[1] = 0
					fix.Group.__init__(self, 41962, 41963, order)

			class NoUnderlyingStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 42003
					order[1] = 42004
					order[2] = 42005
					order[3] = 42006
					order[4] = 42007
					order[5] = 42008
					order[6] = 42009
					order[7] = 42010
					order[8] = 42011
					order[9] = 42012
					order[10] = 42013
					order[11] = 41996
					order[12] = 42014
					order[13] = 42015
					order[14] = 0
					fix.Group.__init__(self, 42002, 42003, order)

				class NoUnderlyingStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41997
						order[1] = 41998
						order[2] = 41999
						order[3] = 0
						fix.Group.__init__(self, 41996, 41997, order)

					class NoUnderlyingStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 42000
							order[1] = 42001
							order[2] = 41936
							order[3] = 0
							fix.Group.__init__(self, 41999, 42000, order)

			class NoUnderlyingStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40059
					order[1] = 0
					fix.Group.__init__(self, 40975, 40059, order)

			class NoUnderlyingStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40550
					order[1] = 0
					fix.Group.__init__(self, 40976, 40550, order)

			class NoUnderlyingStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40557
					order[1] = 0
					fix.Group.__init__(self, 40973, 40557, order)

			class NoUnderlyingStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41955
					order[1] = 41956
					order[2] = 0
					fix.Group.__init__(self, 41954, 41955, order)

			class NoUnderlyingStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40560
					order[1] = 0
					fix.Group.__init__(self, 40974, 40560, order)

			class NoUnderlyingPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40582
					order[1] = 0
					fix.Group.__init__(self, 40969, 40582, order)

			class NoUnderlyingPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41938
					order[1] = 41939
					order[2] = 0
					fix.Group.__init__(self, 41937, 41938, order)

			class NoUnderlyingPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40594
					order[1] = 0
					fix.Group.__init__(self, 40970, 40594, order)

			class NoUnderlyingPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40600
					order[1] = 0
					fix.Group.__init__(self, 40971, 40600, order)

			class NoUnderlyingPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40607
					order[1] = 0
					fix.Group.__init__(self, 40972, 40607, order)

			class NoUnderlyingPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42956
					order[1] = 42957
					order[2] = 0
					fix.Group.__init__(self, 42955, 42956, order)

			class NoUnderlyingPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41910
					order[1] = 0
					fix.Group.__init__(self, 41909, 41910, order)

			class NoUnderlyingPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41945
					order[1] = 41946
					order[2] = 0
					fix.Group.__init__(self, 41944, 41945, order)

			class NoUnderlyingPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41942
					order[1] = 41943
					order[2] = 0
					fix.Group.__init__(self, 41941, 41942, order)

			class NoUnderlyingPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43111
					order[1] = 42982
					order[2] = 42983
					order[3] = 0
					fix.Group.__init__(self, 42981, 43111, order)

			class NoUnderlyingDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42863
					order[1] = 42864
					order[2] = 42865
					order[3] = 42866
					order[4] = 42867
					order[5] = 42868
					order[6] = 42882
					order[7] = 42869
					order[8] = 42870
					order[9] = 42871
					order[10] = 42872
					order[11] = 42873
					order[12] = 42874
					order[13] = 42875
					order[14] = 42876
					order[15] = 42877
					order[16] = 42878
					order[17] = 42879
					order[18] = 42880
					order[19] = 42881
					order[20] = 0
					fix.Group.__init__(self, 42862, 42863, order)

				class NoUnderlyingDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42883
						order[1] = 0
						fix.Group.__init__(self, 42882, 42883, order)

			class NoUnderlyingDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42854
					order[1] = 0
					fix.Group.__init__(self, 42853, 42854, order)

			class NoUnderlyingDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42800
					order[1] = 0
					fix.Group.__init__(self, 42799, 42800, order)

			class NoUnderlyingReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 43035
					order[1] = 43036
					order[2] = 43037
					order[3] = 43038
					order[4] = 43039
					order[5] = 43040
					order[6] = 43064
					order[7] = 43030
					order[8] = 43041
					order[9] = 43042
					order[10] = 43043
					order[11] = 43044
					order[12] = 43045
					order[13] = 43046
					order[14] = 43047
					order[15] = 43048
					order[16] = 43049
					order[17] = 43050
					order[18] = 43051
					order[19] = 43052
					order[20] = 43060
					order[21] = 43053
					order[22] = 43054
					order[23] = 43008
					order[24] = 43055
					order[25] = 43056
					order[26] = 43057
					order[27] = 43058
					order[28] = 43059
					order[29] = 0
					fix.Group.__init__(self, 43034, 43035, order)

				class NoUnderlyingReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 43065
						order[1] = 43066
						order[2] = 43067
						order[3] = 43068
						order[4] = 0
						fix.Group.__init__(self, 43064, 43065, order)

				class NoUnderlyingReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43031
						order[1] = 43032
						order[2] = 43033
						order[3] = 0
						fix.Group.__init__(self, 43030, 43031, order)

				class NoUnderlyingReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43061
						order[1] = 43062
						order[2] = 43063
						order[3] = 0
						fix.Group.__init__(self, 43060, 43061, order)

				class NoUnderlyingReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 43009
						order[1] = 43071
						order[2] = 43010
						order[3] = 43011
						order[4] = 43012
						order[5] = 43013
						order[6] = 43014
						order[7] = 43015
						order[8] = 43016
						order[9] = 43017
						order[10] = 43018
						order[11] = 43019
						order[12] = 43020
						order[13] = 43021
						order[14] = 43022
						order[15] = 43023
						order[16] = 43024
						order[17] = 43025
						order[18] = 43026
						order[19] = 43027
						order[20] = 43028
						order[21] = 43029
						order[22] = 43069
						order[23] = 0
						fix.Group.__init__(self, 43008, 43009, order)

					class NoUnderlyingReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 43072
							order[1] = 43073
							order[2] = 0
							fix.Group.__init__(self, 43071, 43072, order)

					class NoUnderlyingReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 43070
							order[1] = 0
							fix.Group.__init__(self, 43069, 43070, order)

			class NoUnderlyingPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42916
					order[1] = 0
					fix.Group.__init__(self, 42915, 42916, order)

			class NoUnderlyingPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42902
					order[1] = 42903
					order[2] = 0
					fix.Group.__init__(self, 42901, 42902, order)

			class NoUnderlyingPaymentStreamNonDeliverableFixingDatesBizCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40650
					order[1] = 0
					fix.Group.__init__(self, 40968, 40650, order)

			class NoUnderlyingNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40657
					order[1] = 40658
					order[2] = 0
					fix.Group.__init__(self, 40656, 40657, order)

			class NoUnderlyingSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40660
					order[1] = 40904
					order[2] = 40915
					order[3] = 40662
					order[4] = 40663
					order[5] = 0
					fix.Group.__init__(self, 40659, 40660, order)

			class NoUnderlyingPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40665
					order[1] = 41881
					order[2] = 41882
					order[3] = 40666
					order[4] = 40667
					order[5] = 40668
					order[6] = 40669
					order[7] = 40670
					order[8] = 40671
					order[9] = 40672
					order[10] = 40673
					order[11] = 40674
					order[12] = 40675
					order[13] = 41883
					order[14] = 41884
					order[15] = 41885
					order[16] = 41886
					order[17] = 40676
					order[18] = 40677
					order[19] = 40678
					order[20] = 40679
					order[21] = 41887
					order[22] = 41888
					order[23] = 41889
					order[24] = 41890
					order[25] = 40680
					order[26] = 40681
					order[27] = 40682
					order[28] = 40683
					order[29] = 40684
					order[30] = 40685
					order[31] = 40704
					order[32] = 40686
					order[33] = 40687
					order[34] = 40688
					order[35] = 40689
					order[36] = 40966
					order[37] = 40691
					order[38] = 40692
					order[39] = 40693
					order[40] = 41891
					order[41] = 41892
					order[42] = 40694
					order[43] = 41878
					order[44] = 41893
					order[45] = 41894
					order[46] = 41895
					order[47] = 41896
					order[48] = 40695
					order[49] = 40696
					order[50] = 40697
					order[51] = 40698
					order[52] = 40967
					order[53] = 40700
					order[54] = 40701
					order[55] = 40702
					order[56] = 40703
					order[57] = 0
					fix.Group.__init__(self, 40664, 40665, order)

				class NoUnderlyingPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40705
						order[1] = 40706
						order[2] = 40707
						order[3] = 0
						fix.Group.__init__(self, 40704, 40705, order)

				class NoUnderlyingPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40690
						order[1] = 0
						fix.Group.__init__(self, 40966, 40690, order)

				class NoUnderlyingPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41879
						order[1] = 41880
						order[2] = 0
						fix.Group.__init__(self, 41878, 41879, order)

				class NoUnderlyingPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40699
						order[1] = 0
						fix.Group.__init__(self, 40967, 40699, order)

			class NoUnderlyingPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40709
					order[1] = 40710
					order[2] = 42993
					order[3] = 42994
					order[4] = 42995
					order[5] = 42996
					order[6] = 42997
					order[7] = 42998
					order[8] = 42999
					order[9] = 42984
					order[10] = 42985
					order[11] = 42986
					order[12] = 42987
					order[13] = 42988
					order[14] = 42989
					order[15] = 42990
					order[16] = 40711
					order[17] = 40712
					order[18] = 40713
					order[19] = 40714
					order[20] = 40715
					order[21] = 40716
					order[22] = 40717
					order[23] = 40718
					order[24] = 40719
					order[25] = 40720
					order[26] = 40721
					order[27] = 40722
					order[28] = 40723
					order[29] = 40724
					order[30] = 40725
					order[31] = 40726
					order[32] = 40727
					order[33] = 40728
					order[34] = 40729
					order[35] = 40730
					order[36] = 40731
					order[37] = 40732
					order[38] = 40733
					order[39] = 40734
					order[40] = 40735
					order[41] = 40736
					order[42] = 40737
					order[43] = 0
					fix.Group.__init__(self, 40708, 40709, order)

				class NoUnderlyingPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 43001
						order[1] = 0
						fix.Group.__init__(self, 43000, 43001, order)

				class NoUnderlyingPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42992
						order[1] = 0
						fix.Group.__init__(self, 42991, 42992, order)

			class NoUnderlyingDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41809
					order[1] = 0
					fix.Group.__init__(self, 41808, 41809, order)

			class NoUnderlyingDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41805
					order[1] = 41806
					order[2] = 41807
					order[3] = 0
					fix.Group.__init__(self, 41804, 41805, order)

			class NoUnderlyingDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41757
					order[1] = 41758
					order[2] = 41759
					order[3] = 41760
					order[4] = 41761
					order[5] = 41762
					order[6] = 41763
					order[7] = 41764
					order[8] = 41765
					order[9] = 41766
					order[10] = 41767
					order[11] = 41768
					order[12] = 41769
					order[13] = 41770
					order[14] = 0
					fix.Group.__init__(self, 41756, 41757, order)

				class NoUnderlyingDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41771
						order[1] = 41772
						order[2] = 41773
						order[3] = 0
						fix.Group.__init__(self, 41770, 41771, order)

					class NoUnderlyingDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41774
							order[1] = 41775
							order[2] = 41776
							order[3] = 0
							fix.Group.__init__(self, 41773, 41774, order)

		class NoUnderlyingProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 42150
				order[1] = 42151
				order[2] = 42152
				order[3] = 42190
				order[4] = 42153
				order[5] = 42154
				order[6] = 42155
				order[7] = 43002
				order[8] = 43003
				order[9] = 42156
				order[10] = 42157
				order[11] = 42158
				order[12] = 42104
				order[13] = 42105
				order[14] = 42106
				order[15] = 42107
				order[16] = 42108
				order[17] = 42109
				order[18] = 42110
				order[19] = 42111
				order[20] = 42115
				order[21] = 42116
				order[22] = 42117
				order[23] = 42118
				order[24] = 42119
				order[25] = 42120
				order[26] = 42121
				order[27] = 42122
				order[28] = 42123
				order[29] = 42124
				order[30] = 42125
				order[31] = 42126
				order[32] = 42127
				order[33] = 42128
				order[34] = 42129
				order[35] = 42130
				order[36] = 42131
				order[37] = 42132
				order[38] = 42133
				order[39] = 42134
				order[40] = 42135
				order[41] = 42136
				order[42] = 42137
				order[43] = 42138
				order[44] = 42139
				order[45] = 42140
				order[46] = 42141
				order[47] = 42142
				order[48] = 42143
				order[49] = 42144
				order[50] = 42145
				order[51] = 42146
				order[52] = 42147
				order[53] = 42148
				order[54] = 42159
				order[55] = 42160
				order[56] = 42161
				order[57] = 42162
				order[58] = 42163
				order[59] = 42164
				order[60] = 42165
				order[61] = 42092
				order[62] = 42093
				order[63] = 42094
				order[64] = 42095
				order[65] = 42096
				order[66] = 42097
				order[67] = 42098
				order[68] = 42166
				order[69] = 42167
				order[70] = 42168
				order[71] = 42169
				order[72] = 42102
				order[73] = 42103
				order[74] = 42170
				order[75] = 42171
				order[76] = 42172
				order[77] = 42173
				order[78] = 0
				fix.Group.__init__(self, 42149, 42150, order)

			class NoUnderlyingProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42191
					order[1] = 0
					fix.Group.__init__(self, 42190, 42191, order)

			class NoUnderlyingProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42183
					order[1] = 0
					fix.Group.__init__(self, 42182, 42183, order)

			class NoUnderlyingProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42185
					order[1] = 0
					fix.Group.__init__(self, 42184, 42185, order)

			class NoUnderlyingProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42113
					order[1] = 42114
					order[2] = 0
					fix.Group.__init__(self, 42112, 42113, order)

			class NoUnderlyingProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42187
					order[1] = 0
					fix.Group.__init__(self, 42186, 42187, order)

			class NoUnderlyingProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42189
					order[1] = 0
					fix.Group.__init__(self, 42188, 42189, order)

			class NoUnderlyingProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42181
					order[1] = 0
					fix.Group.__init__(self, 42180, 42181, order)

			class NoUnderlyingProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42100
					order[1] = 42101
					order[2] = 0
					fix.Group.__init__(self, 42099, 42100, order)

			class NoUnderlyingProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 42174
					order[1] = 42175
					order[2] = 42176
					order[3] = 40918
					order[4] = 42177
					order[5] = 0
					fix.Group.__init__(self, 42173, 42174, order)

				class NoUnderlyingProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42178
						order[1] = 42179
						order[2] = 0
						fix.Group.__init__(self, 42177, 42178, order)

		class NoUnderlyingAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 42037
				order[1] = 42038
				order[2] = 41340
				order[3] = 0
				fix.Group.__init__(self, 42036, 42037, order)

			class NoUnderlyingAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41341
					order[1] = 41701
					order[2] = 41709
					order[3] = 41710
					order[4] = 41711
					order[5] = 41712
					order[6] = 42017
					order[7] = 42025
					order[8] = 42026
					order[9] = 42027
					order[10] = 42028
					order[11] = 42029
					order[12] = 42030
					order[13] = 42031
					order[14] = 42032
					order[15] = 42033
					order[16] = 42034
					order[17] = 42035
					order[18] = 0
					fix.Group.__init__(self, 41340, 41341, order)

		class NoUnderlyingProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 42069
				order[1] = 42070
				order[2] = 42071
				order[3] = 42072
				order[4] = 42073
				order[5] = 42074
				order[6] = 42075
				order[7] = 42090
				order[8] = 42077
				order[9] = 42087
				order[10] = 42076
				order[11] = 0
				fix.Group.__init__(self, 42068, 42069, order)

			class NoUnderlyingProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42091
					order[1] = 0
					fix.Group.__init__(self, 42090, 42091, order)

			class NoUnderlyingProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 42078
					order[1] = 42079
					order[2] = 42080
					order[3] = 42081
					order[4] = 42082
					order[5] = 42083
					order[6] = 42084
					order[7] = 42085
					order[8] = 0
					fix.Group.__init__(self, 42077, 42078, order)

				class NoUnderlyingProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42086
						order[1] = 0
						fix.Group.__init__(self, 42085, 42086, order)

			class NoUnderlyingProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42088
					order[1] = 42089
					order[2] = 0
					fix.Group.__init__(self, 42087, 42088, order)

		class NoUnderlyingCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 42042
				order[1] = 42043
				order[2] = 42044
				order[3] = 42045
				order[4] = 42046
				order[5] = 42047
				order[6] = 42048
				order[7] = 42049
				order[8] = 42050
				order[9] = 42051
				order[10] = 42052
				order[11] = 42039
				order[12] = 42797
				order[13] = 42798
				order[14] = 42053
				order[15] = 42054
				order[16] = 42790
				order[17] = 42791
				order[18] = 42792
				order[19] = 42793
				order[20] = 42794
				order[21] = 42795
				order[22] = 42796
				order[23] = 42055
				order[24] = 42056
				order[25] = 42057
				order[26] = 42058
				order[27] = 42059
				order[28] = 0
				fix.Group.__init__(self, 42041, 42042, order)

			class NoUnderlyingCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42040
					order[1] = 0
					fix.Group.__init__(self, 42039, 42040, order)

			class NoUnderlyingCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42789
					order[1] = 0
					fix.Group.__init__(self, 42788, 42789, order)

		class NoUnderlyingPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 42065
				order[1] = 42061
				order[2] = 42062
				order[3] = 42063
				order[4] = 42064
				order[5] = 0
				fix.Group.__init__(self, 42060, 42065, order)

			class NoUnderlyingPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42066
					order[1] = 42067
					order[2] = 0
					fix.Group.__init__(self, 42065, 42066, order)

		class NoUnderlyingRateSpreadSteps(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 43006
				order[1] = 43007
				order[2] = 0
				fix.Group.__init__(self, 43005, 43006, order)

		class NoUnderlyingDividendPayments(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 42856
				order[1] = 42857
				order[2] = 42858
				order[3] = 42859
				order[4] = 0
				fix.Group.__init__(self, 42855, 42856, order)

		class NoUnderlyingExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42885
				order[1] = 42886
				order[2] = 0
				fix.Group.__init__(self, 42884, 42885, order)

	class NoPayments(fix.Group):
		def __init__(self):
			order = fix.IntArray(41)
			order[0] = 40213
			order[1] = 40993
			order[2] = 40214
			order[3] = 40215
			order[4] = 43087
			order[5] = 40216
			order[6] = 40217
			order[7] = 42598
			order[8] = 42599
			order[9] = 43097
			order[10] = 43098
			order[11] = 43100
			order[12] = 43099
			order[13] = 43101
			order[14] = 43105
			order[15] = 43104
			order[16] = 43103
			order[17] = 43102
			order[18] = 40218
			order[19] = 40919
			order[20] = 41155
			order[21] = 40219
			order[22] = 40220
			order[23] = 40944
			order[24] = 41156
			order[25] = 41157
			order[26] = 41158
			order[27] = 41159
			order[28] = 40222
			order[29] = 41160
			order[30] = 40224
			order[31] = 40225
			order[32] = 40226
			order[33] = 40227
			order[34] = 492
			order[35] = 40230
			order[36] = 41304
			order[37] = 40229
			order[38] = 40984
			order[39] = 40985
			order[40] = 0
			fix.Group.__init__(self, 40212, 40213, order)

		class NoPaymentBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40221
				order[1] = 0
				fix.Group.__init__(self, 40944, 40221, order)

		class NoPaymentSettls(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 40231
				order[1] = 40232
				order[2] = 40233
				order[3] = 0
				fix.Group.__init__(self, 40230, 40231, order)

			class NoPaymentSettlPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40234
					order[1] = 40235
					order[2] = 40236
					order[3] = 40237
					order[4] = 40238
					order[5] = 0
					fix.Group.__init__(self, 40233, 40234, order)

				class NoPaymentSettlPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40239
						order[1] = 40240
						order[2] = 0
						fix.Group.__init__(self, 40238, 40239, order)

	class NoStipulations(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 233
			order[1] = 234
			order[2] = 0
			fix.Group.__init__(self, 232, 233, order)

	class NoPriceQualifiers(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 2710
			order[1] = 0
			fix.Group.__init__(self, 2709, 2710, order)

	class NoStrategyParameters(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 958
			order[1] = 959
			order[2] = 960
			order[3] = 0
			fix.Group.__init__(self, 957, 958, order)

	class NoOrderAttributes(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 2594
			order[1] = 2595
			order[2] = 0
			fix.Group.__init__(self, 2593, 2594, order)

	class NoLimitAmts(fix.Group):
		def __init__(self):
			order = fix.IntArray(9)
			order[0] = 1631
			order[1] = 1632
			order[2] = 1633
			order[3] = 2394
			order[4] = 2395
			order[5] = 1634
			order[6] = 2935
			order[7] = 2396
			order[8] = 0
			fix.Group.__init__(self, 1630, 1631, order)

	class NoFills(fix.Group):
		def __init__(self):
			order = fix.IntArray(10)
			order[0] = 1363
			order[1] = 1364
			order[2] = 1365
			order[3] = 2673
			order[4] = 2674
			order[5] = 1443
			order[6] = 1622
			order[7] = 1623
			order[8] = 1414
			order[9] = 0
			fix.Group.__init__(self, 1362, 1363, order)

		class NoNested4PartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1415
				order[1] = 1416
				order[2] = 1417
				order[3] = 2383
				order[4] = 1413
				order[5] = 0
				fix.Group.__init__(self, 1414, 1415, order)

			class NoNested4PartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1412
					order[1] = 1411
					order[2] = 0
					fix.Group.__init__(self, 1413, 1412, order)

	class NoOrderEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(8)
			order[0] = 1796
			order[1] = 1797
			order[2] = 1798
			order[3] = 1799
			order[4] = 1800
			order[5] = 1801
			order[6] = 1802
			order[7] = 0
			fix.Group.__init__(self, 1795, 1796, order)

	class NoCommissions(fix.Group):
		def __init__(self):
			order = fix.IntArray(17)
			order[0] = 2640
			order[1] = 2641
			order[2] = 2725
			order[3] = 2642
			order[4] = 2643
			order[5] = 2923
			order[6] = 2644
			order[7] = 2645
			order[8] = 2924
			order[9] = 2646
			order[10] = 2647
			order[11] = 2648
			order[12] = 2649
			order[13] = 2650
			order[14] = 2651
			order[15] = 2652
			order[16] = 0
			fix.Group.__init__(self, 2639, 2640, order)

	class NoRelativeValues(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 2530
			order[1] = 2531
			order[2] = 2532
			order[3] = 0
			fix.Group.__init__(self, 2529, 2530, order)

	class NoRateSources(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1446
			order[1] = 1447
			order[2] = 1448
			order[3] = 2412
			order[4] = 2796
			order[5] = 0
			fix.Group.__init__(self, 1445, 1446, order)

	class NoValueChecks(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 1869
			order[1] = 1870
			order[2] = 0
			fix.Group.__init__(self, 1868, 1869, order)

	class NoMatchInst(fix.Group):
		def __init__(self):
			order = fix.IntArray(5)
			order[0] = 1625
			order[1] = 1673
			order[2] = 1626
			order[3] = 1627
			order[4] = 0
			fix.Group.__init__(self, 1624, 1625, order)

	class NoDisclosureInstructions(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 1813
			order[1] = 1814
			order[2] = 0
			fix.Group.__init__(self, 1812, 1813, order)

	class NoContAmts(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 519
			order[1] = 520
			order[2] = 521
			order[3] = 0
			fix.Group.__init__(self, 518, 519, order)

	class NoLegs(fix.Group):
		def __init__(self):
			order = fix.IntArray(181)
			order[0] = 600
			order[1] = 601
			order[2] = 602
			order[3] = 603
			order[4] = 1788
			order[5] = 607
			order[6] = 1594
			order[7] = 608
			order[8] = 2893
			order[9] = 609
			order[10] = 764
			order[11] = 610
			order[12] = 611
			order[13] = 1212
			order[14] = 2146
			order[15] = 2147
			order[16] = 2148
			order[17] = 248
			order[18] = 2149
			order[19] = 2150
			order[20] = 2151
			order[21] = 2152
			order[22] = 2153
			order[23] = 2154
			order[24] = 2155
			order[25] = 2348
			order[26] = 2067
			order[27] = 2068
			order[28] = 2069
			order[29] = 2739
			order[30] = 2070
			order[31] = 2156
			order[32] = 2157
			order[33] = 2158
			order[34] = 2159
			order[35] = 2160
			order[36] = 2161
			order[37] = 2162
			order[38] = 2163
			order[39] = 2164
			order[40] = 2165
			order[41] = 2880
			order[42] = 2166
			order[43] = 2167
			order[44] = 2168
			order[45] = 2169
			order[46] = 2170
			order[47] = 2171
			order[48] = 2172
			order[49] = 2173
			order[50] = 2174
			order[51] = 2175
			order[52] = 2176
			order[53] = 2177
			order[54] = 2178
			order[55] = 2179
			order[56] = 2180
			order[57] = 249
			order[58] = 250
			order[59] = 251
			order[60] = 252
			order[61] = 253
			order[62] = 257
			order[63] = 599
			order[64] = 596
			order[65] = 597
			order[66] = 598
			order[67] = 254
			order[68] = 612
			order[69] = 942
			order[70] = 2908
			order[71] = 2181
			order[72] = 2182
			order[73] = 2183
			order[74] = 2184
			order[75] = 2604
			order[76] = 2185
			order[77] = 2605
			order[78] = 2186
			order[79] = 2187
			order[80] = 2188
			order[81] = 2189
			order[82] = 613
			order[83] = 614
			order[84] = 1436
			order[85] = 2354
			order[86] = 1440
			order[87] = 2190
			order[88] = 2191
			order[89] = 999
			order[90] = 1224
			order[91] = 1720
			order[92] = 2909
			order[93] = 1421
			order[94] = 1422
			order[95] = 1721
			order[96] = 2910
			order[97] = 2192
			order[98] = 1001
			order[99] = 1420
			order[100] = 2193
			order[101] = 2194
			order[102] = 2755
			order[103] = 2195
			order[104] = 2196
			order[105] = 2197
			order[106] = 2198
			order[107] = 1528
			order[108] = 2911
			order[109] = 2199
			order[110] = 2200
			order[111] = 2201
			order[112] = 2202
			order[113] = 2203
			order[114] = 615
			order[115] = 616
			order[116] = 2205
			order[117] = 2206
			order[118] = 617
			order[119] = 618
			order[120] = 619
			order[121] = 2740
			order[122] = 2717
			order[123] = 2718
			order[124] = 2719
			order[125] = 620
			order[126] = 621
			order[127] = 622
			order[128] = 2207
			order[129] = 2208
			order[130] = 623
			order[131] = 624
			order[132] = 556
			order[133] = 2898
			order[134] = 740
			order[135] = 739
			order[136] = 955
			order[137] = 956
			order[138] = 1358
			order[139] = 2682
			order[140] = 2686
			order[141] = 1017
			order[142] = 566
			order[143] = 2209
			order[144] = 2211
			order[145] = 2212
			order[146] = 2213
			order[147] = 2754
			order[148] = 2214
			order[149] = 2215
			order[150] = 2606
			order[151] = 2607
			order[152] = 685
			order[153] = 687
			order[154] = 2346
			order[155] = 690
			order[156] = 683
			order[157] = 1366
			order[158] = 670
			order[159] = 2680
			order[160] = 1817
			order[161] = 564
			order[162] = 565
			order[163] = 948
			order[164] = 654
			order[165] = 587
			order[166] = 588
			order[167] = 637
			order[168] = 675
			order[169] = 2900
			order[170] = 1073
			order[171] = 1074
			order[172] = 1075
			order[173] = 1689
			order[174] = 1379
			order[175] = 1381
			order[176] = 1383
			order[177] = 1384
			order[178] = 1418
			order[179] = 2421
			order[180] = 0
			fix.Group.__init__(self, 555, 600, order)

		class NoLegSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 605
				order[1] = 606
				order[2] = 2958
				order[3] = 0
				fix.Group.__init__(self, 604, 605, order)

		class NoLegSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2077
				order[1] = 2078
				order[2] = 2079
				order[3] = 2743
				order[4] = 0
				fix.Group.__init__(self, 2076, 2077, order)

		class NoLegAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2309
				order[1] = 2310
				order[2] = 2311
				order[3] = 0
				fix.Group.__init__(self, 2308, 2309, order)

		class NoLegEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 2060
				order[1] = 2061
				order[2] = 2062
				order[3] = 2063
				order[4] = 2064
				order[5] = 2341
				order[6] = 2065
				order[7] = 2066
				order[8] = 2074
				order[9] = 2075
				order[10] = 0
				fix.Group.__init__(self, 2059, 2060, order)

		class NoLegInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 2255
				order[1] = 2256
				order[2] = 2257
				order[3] = 2379
				order[4] = 2258
				order[5] = 0
				fix.Group.__init__(self, 2254, 2255, order)

			class NoLegInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 2259
					order[1] = 2260
					order[2] = 0
					fix.Group.__init__(self, 2258, 2259, order)

		class NoLegComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2219
				order[1] = 2220
				order[2] = 2221
				order[3] = 2222
				order[4] = 2223
				order[5] = 2224
				order[6] = 2225
				order[7] = 2226
				order[8] = 2944
				order[9] = 2227
				order[10] = 2228
				order[11] = 2229
				order[12] = 2230
				order[13] = 2231
				order[14] = 2232
				order[15] = 2250
				order[16] = 2233
				order[17] = 2945
				order[18] = 2234
				order[19] = 2946
				order[20] = 2235
				order[21] = 2236
				order[22] = 2409
				order[23] = 2410
				order[24] = 2237
				order[25] = 2238
				order[26] = 2239
				order[27] = 2240
				order[28] = 2241
				order[29] = 41382
				order[30] = 41389
				order[31] = 41390
				order[32] = 41391
				order[33] = 41392
				order[34] = 41393
				order[35] = 41394
				order[36] = 41395
				order[37] = 41396
				order[38] = 41397
				order[39] = 41379
				order[40] = 2242
				order[41] = 2243
				order[42] = 2244
				order[43] = 2245
				order[44] = 2246
				order[45] = 41398
				order[46] = 41366
				order[47] = 2608
				order[48] = 2609
				order[49] = 2610
				order[50] = 2248
				order[51] = 2249
				order[52] = 0
				fix.Group.__init__(self, 2218, 2219, order)

			class NoLegComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2251
					order[1] = 2252
					order[2] = 2253
					order[3] = 0
					fix.Group.__init__(self, 2250, 2251, order)

				class NoLegComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2204
						order[1] = 2247
						order[2] = 0
						fix.Group.__init__(self, 2253, 2204, order)

			class NoLegComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41383
					order[1] = 41384
					order[2] = 41385
					order[3] = 41386
					order[4] = 0
					fix.Group.__init__(self, 41382, 41383, order)

			class NoLegComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41388
					order[1] = 0
					fix.Group.__init__(self, 41387, 41388, order)

			class NoLegComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41380
					order[1] = 41381
					order[2] = 41400
					order[3] = 41376
					order[4] = 41363
					order[5] = 0
					fix.Group.__init__(self, 41379, 41380, order)

				class NoLegComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41401
						order[1] = 41402
						order[2] = 41403
						order[3] = 41404
						order[4] = 41405
						order[5] = 0
						fix.Group.__init__(self, 41400, 41401, order)

				class NoLegComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41377
						order[1] = 41378
						order[2] = 0
						fix.Group.__init__(self, 41376, 41377, order)

				class NoLegComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41364
						order[1] = 41365
						order[2] = 0
						fix.Group.__init__(self, 41363, 41364, order)

			class NoLegComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41399
					order[1] = 0
					fix.Group.__init__(self, 41398, 41399, order)

			class NoLegComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41367
					order[1] = 41368
					order[2] = 41369
					order[3] = 41370
					order[4] = 41371
					order[5] = 41372
					order[6] = 41373
					order[7] = 41374
					order[8] = 0
					fix.Group.__init__(self, 41366, 41367, order)

				class NoLegComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41375
						order[1] = 0
						fix.Group.__init__(self, 41374, 41375, order)

		class NoLegBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40924
				order[1] = 0
				fix.Group.__init__(self, 40923, 40924, order)

		class NoLegPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41608
				order[1] = 0
				fix.Group.__init__(self, 41607, 41608, order)

		class NoLegMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41468
				order[1] = 40223
				order[2] = 0
				fix.Group.__init__(self, 41467, 41468, order)

		class NoLegMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41470
				order[1] = 40990
				order[2] = 0
				fix.Group.__init__(self, 41469, 41470, order)

		class NoLegMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41472
				order[1] = 41473
				order[2] = 41474
				order[3] = 41475
				order[4] = 41476
				order[5] = 41477
				order[6] = 41478
				order[7] = 41479
				order[8] = 41480
				order[9] = 0
				fix.Group.__init__(self, 41471, 41472, order)

		class NoLegSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42582
				order[1] = 0
				fix.Group.__init__(self, 42581, 42582, order)

		class NoLegOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41492
				order[1] = 0
				fix.Group.__init__(self, 41491, 41492, order)

		class NoLegOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41513
				order[1] = 41514
				order[2] = 0
				fix.Group.__init__(self, 41512, 41513, order)

		class NoLegOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41516
				order[1] = 0
				fix.Group.__init__(self, 41515, 41516, order)

		class NoLegOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41528
				order[1] = 41529
				order[2] = 0
				fix.Group.__init__(self, 41527, 41528, order)

		class NoLegStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40242
				order[1] = 41700
				order[2] = 40243
				order[3] = 42583
				order[4] = 42584
				order[5] = 40244
				order[6] = 40245
				order[7] = 41702
				order[8] = 40246
				order[9] = 40247
				order[10] = 42585
				order[11] = 42586
				order[12] = 41703
				order[13] = 41704
				order[14] = 41705
				order[15] = 41706
				order[16] = 41707
				order[17] = 41708
				order[18] = 41648
				order[19] = 41649
				order[20] = 41650
				order[21] = 41651
				order[22] = 41652
				order[23] = 41653
				order[24] = 41654
				order[25] = 42588
				order[26] = 41655
				order[27] = 41656
				order[28] = 41657
				order[29] = 41658
				order[30] = 41659
				order[31] = 41660
				order[32] = 41661
				order[33] = 41662
				order[34] = 41663
				order[35] = 41664
				order[36] = 41665
				order[37] = 41666
				order[38] = 41667
				order[39] = 41668
				order[40] = 41669
				order[41] = 41670
				order[42] = 41671
				order[43] = 41672
				order[44] = 41673
				order[45] = 40249
				order[46] = 40250
				order[47] = 40252
				order[48] = 40253
				order[49] = 40254
				order[50] = 40255
				order[51] = 40256
				order[52] = 40257
				order[53] = 40258
				order[54] = 40260
				order[55] = 40261
				order[56] = 40262
				order[57] = 40263
				order[58] = 40264
				order[59] = 41641
				order[60] = 41642
				order[61] = 40265
				order[62] = 40267
				order[63] = 40268
				order[64] = 40270
				order[65] = 40271
				order[66] = 40272
				order[67] = 40273
				order[68] = 40274
				order[69] = 40275
				order[70] = 40276
				order[71] = 41643
				order[72] = 41644
				order[73] = 41645
				order[74] = 40279
				order[75] = 40280
				order[76] = 40281
				order[77] = 42399
				order[78] = 40282
				order[79] = 40283
				order[80] = 43108
				order[81] = 40284
				order[82] = 40285
				order[83] = 40286
				order[84] = 40287
				order[85] = 40288
				order[86] = 42400
				order[87] = 42401
				order[88] = 42402
				order[89] = 42403
				order[90] = 40289
				order[91] = 40290
				order[92] = 40291
				order[93] = 41549
				order[94] = 41550
				order[95] = 41551
				order[96] = 41552
				order[97] = 41553
				order[98] = 41554
				order[99] = 41555
				order[100] = 42404
				order[101] = 40374
				order[102] = 40418
				order[103] = 41429
				order[104] = 41430
				order[105] = 41431
				order[106] = 41432
				order[107] = 41433
				order[108] = 42194
				order[109] = 42195
				order[110] = 41434
				order[111] = 41435
				order[112] = 41436
				order[113] = 41437
				order[114] = 41438
				order[115] = 41219
				order[116] = 41439
				order[117] = 41440
				order[118] = 41441
				order[119] = 41442
				order[120] = 41443
				order[121] = 41444
				order[122] = 41445
				order[123] = 41446
				order[124] = 41447
				order[125] = 41448
				order[126] = 41449
				order[127] = 41450
				order[128] = 41451
				order[129] = 43095
				order[130] = 41408
				order[131] = 40248
				order[132] = 40978
				order[133] = 40979
				order[134] = 0
				fix.Group.__init__(self, 40241, 40242, order)

			class NoLegStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41675
					order[1] = 41676
					order[2] = 0
					fix.Group.__init__(self, 41674, 41675, order)

			class NoLegStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41453
					order[1] = 41454
					order[2] = 41455
					order[3] = 0
					fix.Group.__init__(self, 41452, 41453, order)

			class NoLegStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41678
					order[1] = 41679
					order[2] = 0
					fix.Group.__init__(self, 41677, 41678, order)

			class NoLegStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41647
					order[1] = 0
					fix.Group.__init__(self, 41646, 41647, order)

			class NoLegStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41687
					order[1] = 41688
					order[2] = 41689
					order[3] = 41690
					order[4] = 41691
					order[5] = 41692
					order[6] = 41693
					order[7] = 41694
					order[8] = 41695
					order[9] = 41696
					order[10] = 41697
					order[11] = 41680
					order[12] = 41698
					order[13] = 41699
					order[14] = 0
					fix.Group.__init__(self, 41686, 41687, order)

				class NoLegStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41681
						order[1] = 41682
						order[2] = 41683
						order[3] = 0
						fix.Group.__init__(self, 41680, 41681, order)

					class NoLegStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41684
							order[1] = 41685
							order[2] = 41935
							order[3] = 0
							fix.Group.__init__(self, 41683, 41684, order)

			class NoLegStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40251
					order[1] = 0
					fix.Group.__init__(self, 40942, 40251, order)

			class NoLegStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40259
					order[1] = 0
					fix.Group.__init__(self, 40943, 40259, order)

			class NoLegStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40266
					order[1] = 0
					fix.Group.__init__(self, 40940, 40266, order)

			class NoLegStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41639
					order[1] = 41640
					order[2] = 0
					fix.Group.__init__(self, 41638, 41639, order)

			class NoLegStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40269
					order[1] = 0
					fix.Group.__init__(self, 40941, 40269, order)

			class NoLegPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40293
					order[1] = 0
					fix.Group.__init__(self, 40930, 40293, order)

			class NoLegPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41590
					order[1] = 41591
					order[2] = 0
					fix.Group.__init__(self, 41589, 41590, order)

			class NoLegPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40305
					order[1] = 0
					fix.Group.__init__(self, 40931, 40305, order)

			class NoLegPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40311
					order[1] = 0
					fix.Group.__init__(self, 40932, 40311, order)

			class NoLegPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40318
					order[1] = 0
					fix.Group.__init__(self, 40933, 40318, order)

			class NoLegPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42460
					order[1] = 42461
					order[2] = 0
					fix.Group.__init__(self, 42459, 42460, order)

			class NoLegPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41562
					order[1] = 0
					fix.Group.__init__(self, 41561, 41562, order)

			class NoLegPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41597
					order[1] = 41598
					order[2] = 0
					fix.Group.__init__(self, 41596, 41597, order)

			class NoLegPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41594
					order[1] = 41595
					order[2] = 0
					fix.Group.__init__(self, 41593, 41594, order)

			class NoLegPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43110
					order[1] = 42486
					order[2] = 42487
					order[3] = 0
					fix.Group.__init__(self, 42485, 43110, order)

			class NoLegDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42367
					order[1] = 42368
					order[2] = 42369
					order[3] = 42370
					order[4] = 42371
					order[5] = 42372
					order[6] = 42386
					order[7] = 42373
					order[8] = 42374
					order[9] = 42375
					order[10] = 42376
					order[11] = 42377
					order[12] = 42378
					order[13] = 42379
					order[14] = 42380
					order[15] = 42381
					order[16] = 42382
					order[17] = 42383
					order[18] = 42384
					order[19] = 42385
					order[20] = 0
					fix.Group.__init__(self, 42366, 42367, order)

				class NoLegDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42387
						order[1] = 0
						fix.Group.__init__(self, 42386, 42387, order)

			class NoLegDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42365
					order[1] = 0
					fix.Group.__init__(self, 42364, 42365, order)

			class NoLegDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42311
					order[1] = 0
					fix.Group.__init__(self, 42310, 42311, order)

			class NoLegReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 42535
					order[1] = 42536
					order[2] = 42537
					order[3] = 42538
					order[4] = 42539
					order[5] = 42540
					order[6] = 42564
					order[7] = 42530
					order[8] = 42541
					order[9] = 42542
					order[10] = 42543
					order[11] = 42544
					order[12] = 42545
					order[13] = 42546
					order[14] = 42547
					order[15] = 42548
					order[16] = 42549
					order[17] = 42550
					order[18] = 42551
					order[19] = 42552
					order[20] = 42560
					order[21] = 42553
					order[22] = 42554
					order[23] = 42508
					order[24] = 42555
					order[25] = 42556
					order[26] = 42557
					order[27] = 42558
					order[28] = 42559
					order[29] = 0
					fix.Group.__init__(self, 42534, 42535, order)

				class NoLegReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 42565
						order[1] = 42566
						order[2] = 42567
						order[3] = 42568
						order[4] = 0
						fix.Group.__init__(self, 42564, 42565, order)

				class NoLegReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42531
						order[1] = 42532
						order[2] = 42533
						order[3] = 0
						fix.Group.__init__(self, 42530, 42531, order)

				class NoLegReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42561
						order[1] = 42562
						order[2] = 42563
						order[3] = 0
						fix.Group.__init__(self, 42560, 42561, order)

				class NoLegReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 42509
						order[1] = 42571
						order[2] = 42510
						order[3] = 42511
						order[4] = 42512
						order[5] = 42513
						order[6] = 42514
						order[7] = 42515
						order[8] = 42516
						order[9] = 42517
						order[10] = 42518
						order[11] = 42519
						order[12] = 42520
						order[13] = 42521
						order[14] = 42522
						order[15] = 42523
						order[16] = 42524
						order[17] = 42525
						order[18] = 42526
						order[19] = 42527
						order[20] = 42528
						order[21] = 42529
						order[22] = 42569
						order[23] = 0
						fix.Group.__init__(self, 42508, 42509, order)

					class NoLegReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 42572
							order[1] = 42573
							order[2] = 0
							fix.Group.__init__(self, 42571, 42572, order)

					class NoLegReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 42570
							order[1] = 0
							fix.Group.__init__(self, 42569, 42570, order)

			class NoLegPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42420
					order[1] = 0
					fix.Group.__init__(self, 42419, 42420, order)

			class NoLegPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42406
					order[1] = 42407
					order[2] = 0
					fix.Group.__init__(self, 42405, 42406, order)

			class NoLegPaymentStreamNonDeliverableFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40361
					order[1] = 0
					fix.Group.__init__(self, 40929, 40361, order)

			class NoLegNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40368
					order[1] = 40369
					order[2] = 0
					fix.Group.__init__(self, 40367, 40368, order)

			class NoLegSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40903
					order[1] = 40366
					order[2] = 40370
					order[3] = 40905
					order[4] = 40906
					order[5] = 0
					fix.Group.__init__(self, 40902, 40903, order)

			class NoLegPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40375
					order[1] = 41533
					order[2] = 41534
					order[3] = 40376
					order[4] = 40377
					order[5] = 40378
					order[6] = 40379
					order[7] = 40380
					order[8] = 40381
					order[9] = 40382
					order[10] = 40383
					order[11] = 40384
					order[12] = 40385
					order[13] = 41535
					order[14] = 41536
					order[15] = 41537
					order[16] = 41538
					order[17] = 40386
					order[18] = 40387
					order[19] = 40388
					order[20] = 40389
					order[21] = 41539
					order[22] = 41540
					order[23] = 41541
					order[24] = 41542
					order[25] = 40390
					order[26] = 40391
					order[27] = 40392
					order[28] = 40393
					order[29] = 40394
					order[30] = 40395
					order[31] = 40414
					order[32] = 40396
					order[33] = 40397
					order[34] = 40398
					order[35] = 40399
					order[36] = 40927
					order[37] = 40401
					order[38] = 40402
					order[39] = 40403
					order[40] = 41543
					order[41] = 41544
					order[42] = 40404
					order[43] = 41530
					order[44] = 41545
					order[45] = 41546
					order[46] = 41547
					order[47] = 41548
					order[48] = 40405
					order[49] = 40406
					order[50] = 40407
					order[51] = 40408
					order[52] = 40928
					order[53] = 40410
					order[54] = 40411
					order[55] = 40412
					order[56] = 40413
					order[57] = 0
					fix.Group.__init__(self, 40374, 40375, order)

				class NoLegPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40415
						order[1] = 40416
						order[2] = 40417
						order[3] = 0
						fix.Group.__init__(self, 40414, 40415, order)

				class NoLegPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40400
						order[1] = 0
						fix.Group.__init__(self, 40927, 40400, order)

				class NoLegPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41531
						order[1] = 41532
						order[2] = 0
						fix.Group.__init__(self, 41530, 41531, order)

				class NoLegPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40409
						order[1] = 0
						fix.Group.__init__(self, 40928, 40409, order)

			class NoLegPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40419
					order[1] = 40420
					order[2] = 42497
					order[3] = 42498
					order[4] = 42499
					order[5] = 42500
					order[6] = 42501
					order[7] = 42502
					order[8] = 42503
					order[9] = 42488
					order[10] = 42489
					order[11] = 42490
					order[12] = 42491
					order[13] = 42492
					order[14] = 42493
					order[15] = 42494
					order[16] = 40421
					order[17] = 40422
					order[18] = 40423
					order[19] = 40424
					order[20] = 40425
					order[21] = 40426
					order[22] = 40427
					order[23] = 40428
					order[24] = 40429
					order[25] = 40430
					order[26] = 40431
					order[27] = 40432
					order[28] = 40433
					order[29] = 40434
					order[30] = 40435
					order[31] = 40436
					order[32] = 40437
					order[33] = 40438
					order[34] = 40439
					order[35] = 40440
					order[36] = 40441
					order[37] = 40442
					order[38] = 40443
					order[39] = 40444
					order[40] = 40445
					order[41] = 40446
					order[42] = 40447
					order[43] = 0
					fix.Group.__init__(self, 40418, 40419, order)

				class NoLegPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42505
						order[1] = 0
						fix.Group.__init__(self, 42504, 42505, order)

				class NoLegPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42496
						order[1] = 0
						fix.Group.__init__(self, 42495, 42496, order)

			class NoLegDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41461
					order[1] = 0
					fix.Group.__init__(self, 41460, 41461, order)

			class NoLegDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41457
					order[1] = 41458
					order[2] = 41459
					order[3] = 0
					fix.Group.__init__(self, 41456, 41457, order)

			class NoLegDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41409
					order[1] = 41410
					order[2] = 41411
					order[3] = 41412
					order[4] = 41413
					order[5] = 41414
					order[6] = 41415
					order[7] = 41416
					order[8] = 41417
					order[9] = 41418
					order[10] = 41419
					order[11] = 41420
					order[12] = 41421
					order[13] = 41422
					order[14] = 0
					fix.Group.__init__(self, 41408, 41409, order)

				class NoLegDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41423
						order[1] = 41424
						order[2] = 41425
						order[3] = 0
						fix.Group.__init__(self, 41422, 41423, order)

					class NoLegDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41426
							order[1] = 41427
							order[2] = 41428
							order[3] = 0
							fix.Group.__init__(self, 41425, 41426, order)

		class NoLegProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 40449
				order[1] = 40450
				order[2] = 40451
				order[3] = 40939
				order[4] = 40453
				order[5] = 40454
				order[6] = 40455
				order[7] = 42506
				order[8] = 42507
				order[9] = 40456
				order[10] = 40457
				order[11] = 40458
				order[12] = 40524
				order[13] = 40525
				order[14] = 40526
				order[15] = 40528
				order[16] = 40529
				order[17] = 40530
				order[18] = 40531
				order[19] = 40532
				order[20] = 40476
				order[21] = 40478
				order[22] = 40479
				order[23] = 40480
				order[24] = 40481
				order[25] = 40482
				order[26] = 40483
				order[27] = 40484
				order[28] = 40485
				order[29] = 40486
				order[30] = 40487
				order[31] = 40488
				order[32] = 40489
				order[33] = 40490
				order[34] = 40491
				order[35] = 40492
				order[36] = 40493
				order[37] = 40494
				order[38] = 40498
				order[39] = 40499
				order[40] = 40501
				order[41] = 40502
				order[42] = 40503
				order[43] = 40504
				order[44] = 40505
				order[45] = 40506
				order[46] = 40507
				order[47] = 40508
				order[48] = 40509
				order[49] = 40511
				order[50] = 40512
				order[51] = 40513
				order[52] = 40514
				order[53] = 40515
				order[54] = 40459
				order[55] = 40460
				order[56] = 40461
				order[57] = 40462
				order[58] = 40463
				order[59] = 40464
				order[60] = 40465
				order[61] = 40516
				order[62] = 40518
				order[63] = 40519
				order[64] = 40520
				order[65] = 40521
				order[66] = 40522
				order[67] = 40523
				order[68] = 40466
				order[69] = 40467
				order[70] = 40468
				order[71] = 40469
				order[72] = 40470
				order[73] = 41407
				order[74] = 40472
				order[75] = 40980
				order[76] = 40981
				order[77] = 40533
				order[78] = 0
				fix.Group.__init__(self, 40448, 40449, order)

			class NoLegProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40452
					order[1] = 0
					fix.Group.__init__(self, 40939, 40452, order)

			class NoLegProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40527
					order[1] = 0
					fix.Group.__init__(self, 40935, 40527, order)

			class NoLegProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40477
					order[1] = 0
					fix.Group.__init__(self, 40936, 40477, order)

			class NoLegProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40496
					order[1] = 40497
					order[2] = 0
					fix.Group.__init__(self, 40495, 40496, order)

			class NoLegProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40500
					order[1] = 0
					fix.Group.__init__(self, 40937, 40500, order)

			class NoLegProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40510
					order[1] = 0
					fix.Group.__init__(self, 40938, 40510, order)

			class NoLegProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40517
					order[1] = 0
					fix.Group.__init__(self, 40934, 40517, order)

			class NoLegProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40474
					order[1] = 40475
					order[2] = 0
					fix.Group.__init__(self, 40473, 40474, order)

			class NoLegProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40534
					order[1] = 40535
					order[2] = 40536
					order[3] = 2380
					order[4] = 40537
					order[5] = 0
					fix.Group.__init__(self, 40533, 40534, order)

				class NoLegProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40538
						order[1] = 40539
						order[2] = 0
						fix.Group.__init__(self, 40537, 40538, order)

		class NoLegAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41336
				order[1] = 41337
				order[2] = 41316
				order[3] = 0
				fix.Group.__init__(self, 41335, 41336, order)

			class NoLegAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41317
					order[1] = 41318
					order[2] = 41319
					order[3] = 41320
					order[4] = 41321
					order[5] = 41322
					order[6] = 41323
					order[7] = 41324
					order[8] = 41325
					order[9] = 41326
					order[10] = 41327
					order[11] = 41328
					order[12] = 41329
					order[13] = 41330
					order[14] = 41331
					order[15] = 41332
					order[16] = 41333
					order[17] = 41334
					order[18] = 0
					fix.Group.__init__(self, 41316, 41317, order)

		class NoLegProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 41618
				order[1] = 41619
				order[2] = 41620
				order[3] = 41621
				order[4] = 41622
				order[5] = 41623
				order[6] = 41624
				order[7] = 41614
				order[8] = 41625
				order[9] = 41635
				order[10] = 41617
				order[11] = 0
				fix.Group.__init__(self, 41616, 41618, order)

			class NoLegProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41615
					order[1] = 0
					fix.Group.__init__(self, 41614, 41615, order)

			class NoLegProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41626
					order[1] = 41627
					order[2] = 41628
					order[3] = 41629
					order[4] = 41630
					order[5] = 41631
					order[6] = 41632
					order[7] = 41633
					order[8] = 0
					fix.Group.__init__(self, 41625, 41626, order)

				class NoLegProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41634
						order[1] = 0
						fix.Group.__init__(self, 41633, 41634, order)

			class NoLegProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41636
					order[1] = 41637
					order[2] = 0
					fix.Group.__init__(self, 41635, 41636, order)

		class NoLegCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 41345
				order[1] = 41346
				order[2] = 41347
				order[3] = 41348
				order[4] = 41349
				order[5] = 41350
				order[6] = 41351
				order[7] = 41352
				order[8] = 41353
				order[9] = 41354
				order[10] = 41355
				order[11] = 41342
				order[12] = 42308
				order[13] = 42309
				order[14] = 41356
				order[15] = 41357
				order[16] = 42299
				order[17] = 42300
				order[18] = 42301
				order[19] = 42302
				order[20] = 42303
				order[21] = 42304
				order[22] = 42305
				order[23] = 41358
				order[24] = 41359
				order[25] = 41360
				order[26] = 41361
				order[27] = 41362
				order[28] = 0
				fix.Group.__init__(self, 41344, 41345, order)

			class NoLegCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41343
					order[1] = 0
					fix.Group.__init__(self, 41342, 41343, order)

			class NoLegCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42307
					order[1] = 0
					fix.Group.__init__(self, 42306, 42307, order)

		class NoLegPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41604
				order[1] = 41601
				order[2] = 41602
				order[3] = 41603
				order[4] = 41600
				order[5] = 0
				fix.Group.__init__(self, 41599, 41604, order)

			class NoLegPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41605
					order[1] = 41606
					order[2] = 0
					fix.Group.__init__(self, 41604, 41605, order)

		class NoLegExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42389
				order[1] = 42390
				order[2] = 0
				fix.Group.__init__(self, 42388, 42389, order)

		class NoLegStipulations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 688
				order[1] = 689
				order[2] = 0
				fix.Group.__init__(self, 683, 688, order)

		class NoLegAllocs(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 671
				order[1] = 672
				order[2] = 756
				order[3] = 673
				order[4] = 674
				order[5] = 1367
				order[6] = 2928
				order[7] = 1756
				order[8] = 1757
				order[9] = 1758
				order[10] = 1759
				order[11] = 0
				fix.Group.__init__(self, 670, 671, order)

			class NoNested2PartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 757
					order[1] = 758
					order[2] = 759
					order[3] = 2381
					order[4] = 806
					order[5] = 0
					fix.Group.__init__(self, 756, 757, order)

				class NoNested2PartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 760
						order[1] = 807
						order[2] = 0
						fix.Group.__init__(self, 806, 760, order)

		class NoNested3PartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 949
				order[1] = 950
				order[2] = 951
				order[3] = 2382
				order[4] = 952
				order[5] = 0
				fix.Group.__init__(self, 948, 949, order)

			class NoNested3PartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 953
					order[1] = 954
					order[2] = 0
					fix.Group.__init__(self, 952, 953, order)

	class NoMiscFees(fix.Group):
		def __init__(self):
			order = fix.IntArray(10)
			order[0] = 137
			order[1] = 138
			order[2] = 139
			order[3] = 2712
			order[4] = 2633
			order[5] = 891
			order[6] = 2216
			order[7] = 2217
			order[8] = 2713
			order[9] = 0
			fix.Group.__init__(self, 136, 137, order)

		class NoMiscFeeSubTypes(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 2634
				order[1] = 2635
				order[2] = 2636
				order[3] = 2637
				order[4] = 2638
				order[5] = 0
				fix.Group.__init__(self, 2633, 2634, order)

	class NoTrdRegTimestamps(fix.Group):
		def __init__(self):
			order = fix.IntArray(13)
			order[0] = 769
			order[1] = 770
			order[2] = 771
			order[3] = 2839
			order[4] = 1033
			order[5] = 1034
			order[6] = 1035
			order[7] = 1727
			order[8] = 2831
			order[9] = 2832
			order[10] = 2833
			order[11] = 2834
			order[12] = 0
			fix.Group.__init__(self, 768, 769, order)

	class NoTrdRegPublications(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 2669
			order[1] = 2670
			order[2] = 0
			fix.Group.__init__(self, 2668, 2669, order)

	class NoTradePriceConditions(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 1839
			order[1] = 0
			fix.Group.__init__(self, 1838, 1839, order)

	class NoOrders(fix.Group):
		def __init__(self):
			order = fix.IntArray(7)
			order[0] = 2887
			order[1] = 2888
			order[2] = 2836
			order[3] = 2889
			order[4] = 2890
			order[5] = 2835
			order[6] = 0
			fix.Group.__init__(self, 73, 2887, order)

class OrderCancelReject(Message):
	def __init__(self):
		Message.__init__(self)
		self.getHeader().setField( fix.MsgType("9") )

	class NoPartyIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 448
			order[1] = 447
			order[2] = 452
			order[3] = 2376
			order[4] = 802
			order[5] = 0
			fix.Group.__init__(self, 453, 448, order)

		class NoPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 523
				order[1] = 803
				order[2] = 0
				fix.Group.__init__(self, 802, 523, order)

class News(Message):
	def __init__(self):
		Message.__init__(self)
		self.getHeader().setField( fix.MsgType("B") )

	class NoNewsRefIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 1476
			order[1] = 1477
			order[2] = 0
			fix.Group.__init__(self, 1475, 1476, order)

	class NoRoutingIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 216
			order[1] = 217
			order[2] = 0
			fix.Group.__init__(self, 215, 216, order)

	class NoRelatedSym(fix.Group):
		def __init__(self):
			order = fix.IntArray(183)
			order[0] = 55
			order[1] = 65
			order[2] = 48
			order[3] = 22
			order[4] = 460
			order[5] = 1227
			order[6] = 1151
			order[7] = 461
			order[8] = 2891
			order[9] = 167
			order[10] = 762
			order[11] = 200
			order[12] = 541
			order[13] = 1079
			order[14] = 966
			order[15] = 1049
			order[16] = 965
			order[17] = 224
			order[18] = 1449
			order[19] = 1450
			order[20] = 1451
			order[21] = 1452
			order[22] = 1457
			order[23] = 1458
			order[24] = 1739
			order[25] = 2210
			order[26] = 1938
			order[27] = 1939
			order[28] = 1940
			order[29] = 2735
			order[30] = 1941
			order[31] = 1575
			order[32] = 1942
			order[33] = 1943
			order[34] = 1944
			order[35] = 1945
			order[36] = 1946
			order[37] = 1947
			order[38] = 1948
			order[39] = 1949
			order[40] = 1950
			order[41] = 2879
			order[42] = 1951
			order[43] = 1952
			order[44] = 1953
			order[45] = 1954
			order[46] = 1955
			order[47] = 1956
			order[48] = 1957
			order[49] = 1958
			order[50] = 1959
			order[51] = 1960
			order[52] = 1577
			order[53] = 1580
			order[54] = 1581
			order[55] = 1678
			order[56] = 1697
			order[57] = 225
			order[58] = 239
			order[59] = 226
			order[60] = 227
			order[61] = 228
			order[62] = 255
			order[63] = 543
			order[64] = 470
			order[65] = 471
			order[66] = 472
			order[67] = 240
			order[68] = 202
			order[69] = 2578
			order[70] = 2577
			order[71] = 947
			order[72] = 2904
			order[73] = 967
			order[74] = 968
			order[75] = 1698
			order[76] = 1866
			order[77] = 2600
			order[78] = 2001
			order[79] = 2601
			order[80] = 1478
			order[81] = 1479
			order[82] = 1480
			order[83] = 1481
			order[84] = 206
			order[85] = 231
			order[86] = 1435
			order[87] = 2353
			order[88] = 1439
			order[89] = 969
			order[90] = 1146
			order[91] = 996
			order[92] = 1147
			order[93] = 1716
			order[94] = 2905
			order[95] = 1191
			order[96] = 1192
			order[97] = 1717
			order[98] = 2906
			order[99] = 1193
			order[100] = 2579
			order[101] = 1194
			order[102] = 1482
			order[103] = 1195
			order[104] = 2753
			order[105] = 1196
			order[106] = 1197
			order[107] = 2002
			order[108] = 2140
			order[109] = 1524
			order[110] = 2907
			order[111] = 1198
			order[112] = 1199
			order[113] = 1200
			order[114] = 201
			order[115] = 2681
			order[116] = 2685
			order[117] = 1244
			order[118] = 1242
			order[119] = 2575
			order[120] = 2574
			order[121] = 997
			order[122] = 223
			order[123] = 207
			order[124] = 970
			order[125] = 971
			order[126] = 106
			order[127] = 348
			order[128] = 349
			order[129] = 2737
			order[130] = 2714
			order[131] = 2715
			order[132] = 2716
			order[133] = 107
			order[134] = 350
			order[135] = 351
			order[136] = 691
			order[137] = 667
			order[138] = 875
			order[139] = 876
			order[140] = 873
			order[141] = 874
			order[142] = 1687
			order[143] = 1787
			order[144] = 2141
			order[145] = 2142
			order[146] = 2143
			order[147] = 2752
			order[148] = 2144
			order[149] = 2145
			order[150] = 2576
			order[151] = 2962
			order[152] = 2602
			order[153] = 2603
			order[154] = 668
			order[155] = 869
			order[156] = 2736
			order[157] = 2738
			order[158] = 913
			order[159] = 914
			order[160] = 1961
			order[161] = 915
			order[162] = 918
			order[163] = 2952
			order[164] = 1962
			order[165] = 1963
			order[166] = 1964
			order[167] = 1965
			order[168] = 1966
			order[169] = 1967
			order[170] = 1968
			order[171] = 1969
			order[172] = 1970
			order[173] = 1513
			order[174] = 1525
			order[175] = 1527
			order[176] = 788
			order[177] = 916
			order[178] = 917
			order[179] = 919
			order[180] = 898
			order[181] = 1647
			order[182] = 0
			fix.Group.__init__(self, 146, 55, order)

		class NoSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 455
				order[1] = 456
				order[2] = 2957
				order[3] = 0
				fix.Group.__init__(self, 454, 455, order)

		class NoSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 1977
				order[1] = 1978
				order[2] = 1979
				order[3] = 2741
				order[4] = 0
				fix.Group.__init__(self, 1976, 1977, order)

		class NoAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2305
				order[1] = 2306
				order[2] = 2307
				order[3] = 0
				fix.Group.__init__(self, 2304, 2305, order)

		class NoEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 865
				order[1] = 866
				order[2] = 1145
				order[3] = 1827
				order[4] = 1826
				order[5] = 2340
				order[6] = 867
				order[7] = 868
				order[8] = 1578
				order[9] = 1579
				order[10] = 0
				fix.Group.__init__(self, 864, 865, order)

		class NoInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1019
				order[1] = 1050
				order[2] = 1051
				order[3] = 2378
				order[4] = 1052
				order[5] = 0
				fix.Group.__init__(self, 1018, 1019, order)

			class NoInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1053
					order[1] = 1054
					order[2] = 0
					fix.Group.__init__(self, 1052, 1053, order)

		class NoComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 1484
				order[1] = 2117
				order[2] = 2118
				order[3] = 2119
				order[4] = 1485
				order[5] = 2120
				order[6] = 2121
				order[7] = 2122
				order[8] = 2941
				order[9] = 1486
				order[10] = 2123
				order[11] = 1487
				order[12] = 1488
				order[13] = 1489
				order[14] = 1490
				order[15] = 1491
				order[16] = 2124
				order[17] = 2942
				order[18] = 2125
				order[19] = 2943
				order[20] = 2126
				order[21] = 2127
				order[22] = 2407
				order[23] = 2408
				order[24] = 2128
				order[25] = 2129
				order[26] = 2130
				order[27] = 2131
				order[28] = 2132
				order[29] = 41013
				order[30] = 41020
				order[31] = 41021
				order[32] = 41022
				order[33] = 41023
				order[34] = 41024
				order[35] = 41025
				order[36] = 41026
				order[37] = 41027
				order[38] = 41028
				order[39] = 41010
				order[40] = 2133
				order[41] = 2134
				order[42] = 2135
				order[43] = 2136
				order[44] = 2137
				order[45] = 41029
				order[46] = 40997
				order[47] = 2597
				order[48] = 2598
				order[49] = 2599
				order[50] = 2138
				order[51] = 2139
				order[52] = 0
				fix.Group.__init__(self, 1483, 1484, order)

			class NoComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 1492
					order[1] = 1493
					order[2] = 1494
					order[3] = 0
					fix.Group.__init__(self, 1491, 1492, order)

				class NoComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 1495
						order[1] = 1496
						order[2] = 0
						fix.Group.__init__(self, 1494, 1495, order)

			class NoComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41014
					order[1] = 41015
					order[2] = 41016
					order[3] = 41017
					order[4] = 0
					fix.Group.__init__(self, 41013, 41014, order)

			class NoComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41019
					order[1] = 0
					fix.Group.__init__(self, 41018, 41019, order)

			class NoComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41011
					order[1] = 41012
					order[2] = 41031
					order[3] = 41007
					order[4] = 40994
					order[5] = 0
					fix.Group.__init__(self, 41010, 41011, order)

				class NoComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41032
						order[1] = 41033
						order[2] = 41034
						order[3] = 41035
						order[4] = 41036
						order[5] = 0
						fix.Group.__init__(self, 41031, 41032, order)

				class NoComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41008
						order[1] = 41009
						order[2] = 0
						fix.Group.__init__(self, 41007, 41008, order)

				class NoComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40995
						order[1] = 40996
						order[2] = 0
						fix.Group.__init__(self, 40994, 40995, order)

			class NoComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41030
					order[1] = 0
					fix.Group.__init__(self, 41029, 41030, order)

			class NoComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 40998
					order[1] = 40999
					order[2] = 41000
					order[3] = 41001
					order[4] = 41002
					order[5] = 41003
					order[6] = 41004
					order[7] = 41005
					order[8] = 0
					fix.Group.__init__(self, 40997, 40998, order)

				class NoComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41006
						order[1] = 0
						fix.Group.__init__(self, 41005, 41006, order)

		class NoBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40471
				order[1] = 0
				fix.Group.__init__(self, 40278, 40471, order)

		class NoPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41231
				order[1] = 0
				fix.Group.__init__(self, 41230, 41231, order)

		class NoMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41093
				order[1] = 40991
				order[2] = 0
				fix.Group.__init__(self, 41092, 41093, order)

		class NoMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41095
				order[1] = 40992
				order[2] = 0
				fix.Group.__init__(self, 41094, 41095, order)

		class NoMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41097
				order[1] = 41098
				order[2] = 41099
				order[3] = 41100
				order[4] = 41101
				order[5] = 41102
				order[6] = 41103
				order[7] = 41104
				order[8] = 41105
				order[9] = 0
				fix.Group.__init__(self, 41096, 41097, order)

		class NoSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42776
				order[1] = 0
				fix.Group.__init__(self, 42775, 42776, order)

		class NoOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41117
				order[1] = 0
				fix.Group.__init__(self, 41116, 41117, order)

		class NoOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41138
				order[1] = 41139
				order[2] = 0
				fix.Group.__init__(self, 41137, 41138, order)

		class NoOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41141
				order[1] = 0
				fix.Group.__init__(self, 41140, 41141, order)

		class NoOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41153
				order[1] = 41154
				order[2] = 0
				fix.Group.__init__(self, 41152, 41153, order)

		class NoStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40050
				order[1] = 41303
				order[2] = 40051
				order[3] = 42784
				order[4] = 42785
				order[5] = 40052
				order[6] = 40053
				order[7] = 41305
				order[8] = 40054
				order[9] = 40055
				order[10] = 42786
				order[11] = 42787
				order[12] = 41306
				order[13] = 41307
				order[14] = 41308
				order[15] = 41309
				order[16] = 41310
				order[17] = 41311
				order[18] = 41251
				order[19] = 41252
				order[20] = 41253
				order[21] = 41254
				order[22] = 41255
				order[23] = 41256
				order[24] = 41257
				order[25] = 42587
				order[26] = 41258
				order[27] = 41259
				order[28] = 41260
				order[29] = 41261
				order[30] = 41262
				order[31] = 41263
				order[32] = 41264
				order[33] = 41265
				order[34] = 41266
				order[35] = 41267
				order[36] = 41268
				order[37] = 41269
				order[38] = 41270
				order[39] = 41271
				order[40] = 41272
				order[41] = 41273
				order[42] = 41274
				order[43] = 41275
				order[44] = 41276
				order[45] = 40907
				order[46] = 40908
				order[47] = 40910
				order[48] = 40911
				order[49] = 40912
				order[50] = 40913
				order[51] = 40914
				order[52] = 40065
				order[53] = 40066
				order[54] = 40068
				order[55] = 40069
				order[56] = 40070
				order[57] = 40071
				order[58] = 40072
				order[59] = 41244
				order[60] = 41245
				order[61] = 40073
				order[62] = 40075
				order[63] = 40076
				order[64] = 40078
				order[65] = 40079
				order[66] = 40080
				order[67] = 40081
				order[68] = 40082
				order[69] = 40083
				order[70] = 40084
				order[71] = 41246
				order[72] = 41247
				order[73] = 41248
				order[74] = 40738
				order[75] = 40739
				order[76] = 40740
				order[77] = 42600
				order[78] = 40741
				order[79] = 40742
				order[80] = 43106
				order[81] = 40743
				order[82] = 40744
				order[83] = 40745
				order[84] = 40746
				order[85] = 40747
				order[86] = 42601
				order[87] = 42602
				order[88] = 42603
				order[89] = 42604
				order[90] = 40748
				order[91] = 40749
				order[92] = 40750
				order[93] = 41180
				order[94] = 41181
				order[95] = 41182
				order[96] = 41183
				order[97] = 41184
				order[98] = 41185
				order[99] = 41186
				order[100] = 42605
				order[101] = 40828
				order[102] = 40872
				order[103] = 41058
				order[104] = 41059
				order[105] = 41060
				order[106] = 41061
				order[107] = 41062
				order[108] = 42192
				order[109] = 42193
				order[110] = 41063
				order[111] = 41064
				order[112] = 41065
				order[113] = 41066
				order[114] = 41067
				order[115] = 41218
				order[116] = 41068
				order[117] = 41069
				order[118] = 41070
				order[119] = 41071
				order[120] = 41072
				order[121] = 41073
				order[122] = 41074
				order[123] = 41075
				order[124] = 41076
				order[125] = 41077
				order[126] = 41078
				order[127] = 41079
				order[128] = 41080
				order[129] = 43094
				order[130] = 41037
				order[131] = 40056
				order[132] = 40982
				order[133] = 40983
				order[134] = 0
				fix.Group.__init__(self, 40049, 40050, order)

			class NoStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41278
					order[1] = 41279
					order[2] = 0
					fix.Group.__init__(self, 41277, 41278, order)

			class NoStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41238
					order[1] = 41239
					order[2] = 41240
					order[3] = 0
					fix.Group.__init__(self, 41237, 41238, order)

			class NoStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41281
					order[1] = 41282
					order[2] = 0
					fix.Group.__init__(self, 41280, 41281, order)

			class NoStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41250
					order[1] = 0
					fix.Group.__init__(self, 41249, 41250, order)

			class NoStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41290
					order[1] = 41291
					order[2] = 41292
					order[3] = 41293
					order[4] = 41294
					order[5] = 41295
					order[6] = 41296
					order[7] = 41297
					order[8] = 41298
					order[9] = 41299
					order[10] = 41300
					order[11] = 41283
					order[12] = 41301
					order[13] = 41302
					order[14] = 0
					fix.Group.__init__(self, 41289, 41290, order)

				class NoStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41284
						order[1] = 41285
						order[2] = 41286
						order[3] = 0
						fix.Group.__init__(self, 41283, 41284, order)

					class NoStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41287
							order[1] = 41288
							order[2] = 41588
							order[3] = 0
							fix.Group.__init__(self, 41286, 41287, order)

			class NoStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40909
					order[1] = 0
					fix.Group.__init__(self, 40960, 40909, order)

			class NoStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40067
					order[1] = 0
					fix.Group.__init__(self, 40961, 40067, order)

			class NoStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40074
					order[1] = 0
					fix.Group.__init__(self, 40958, 40074, order)

			class NoStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41242
					order[1] = 41243
					order[2] = 0
					fix.Group.__init__(self, 41241, 41242, order)

			class NoStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40077
					order[1] = 0
					fix.Group.__init__(self, 40959, 40077, order)

			class NoPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40752
					order[1] = 0
					fix.Group.__init__(self, 40947, 40752, order)

			class NoPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41221
					order[1] = 41222
					order[2] = 0
					fix.Group.__init__(self, 41220, 41221, order)

			class NoPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40763
					order[1] = 0
					fix.Group.__init__(self, 40948, 40763, order)

			class NoPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40769
					order[1] = 0
					fix.Group.__init__(self, 40949, 40769, order)

			class NoPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40776
					order[1] = 0
					fix.Group.__init__(self, 40950, 40776, order)

			class NoPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42661
					order[1] = 42662
					order[2] = 0
					fix.Group.__init__(self, 42660, 42661, order)

			class NoPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41193
					order[1] = 0
					fix.Group.__init__(self, 41192, 41193, order)

			class NoPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41228
					order[1] = 41229
					order[2] = 0
					fix.Group.__init__(self, 41227, 41228, order)

			class NoPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41225
					order[1] = 41226
					order[2] = 0
					fix.Group.__init__(self, 41224, 41225, order)

			class NoPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43109
					order[1] = 42684
					order[2] = 42685
					order[3] = 0
					fix.Group.__init__(self, 42683, 43109, order)

			class NoDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42275
					order[1] = 42276
					order[2] = 42277
					order[3] = 42278
					order[4] = 42279
					order[5] = 42280
					order[6] = 42294
					order[7] = 42281
					order[8] = 42282
					order[9] = 42283
					order[10] = 42284
					order[11] = 42285
					order[12] = 42286
					order[13] = 42287
					order[14] = 42288
					order[15] = 42289
					order[16] = 42290
					order[17] = 42291
					order[18] = 42292
					order[19] = 42293
					order[20] = 0
					fix.Group.__init__(self, 42274, 42275, order)

				class NoDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42295
						order[1] = 0
						fix.Group.__init__(self, 42294, 42295, order)

			class NoDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42273
					order[1] = 0
					fix.Group.__init__(self, 42272, 42273, order)

			class NoDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42237
					order[1] = 0
					fix.Group.__init__(self, 42236, 42237, order)

			class NoReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 42736
					order[1] = 42737
					order[2] = 42738
					order[3] = 42739
					order[4] = 42740
					order[5] = 42741
					order[6] = 42765
					order[7] = 42731
					order[8] = 42742
					order[9] = 42743
					order[10] = 42744
					order[11] = 42745
					order[12] = 42746
					order[13] = 42747
					order[14] = 42748
					order[15] = 42749
					order[16] = 42750
					order[17] = 42751
					order[18] = 42752
					order[19] = 42753
					order[20] = 42761
					order[21] = 42754
					order[22] = 42755
					order[23] = 42709
					order[24] = 42756
					order[25] = 42757
					order[26] = 42758
					order[27] = 42759
					order[28] = 42760
					order[29] = 0
					fix.Group.__init__(self, 42735, 42736, order)

				class NoReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 42766
						order[1] = 42767
						order[2] = 42768
						order[3] = 42769
						order[4] = 0
						fix.Group.__init__(self, 42765, 42766, order)

				class NoReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42732
						order[1] = 42733
						order[2] = 42734
						order[3] = 0
						fix.Group.__init__(self, 42731, 42732, order)

				class NoReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42762
						order[1] = 42763
						order[2] = 42764
						order[3] = 0
						fix.Group.__init__(self, 42761, 42762, order)

				class NoReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 42710
						order[1] = 42772
						order[2] = 42711
						order[3] = 42712
						order[4] = 42713
						order[5] = 42714
						order[6] = 42715
						order[7] = 42716
						order[8] = 42717
						order[9] = 42718
						order[10] = 42719
						order[11] = 42720
						order[12] = 42721
						order[13] = 42722
						order[14] = 42723
						order[15] = 42724
						order[16] = 42725
						order[17] = 42726
						order[18] = 42727
						order[19] = 42728
						order[20] = 42729
						order[21] = 42730
						order[22] = 42770
						order[23] = 0
						fix.Group.__init__(self, 42709, 42710, order)

					class NoReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 42773
							order[1] = 42774
							order[2] = 0
							fix.Group.__init__(self, 42772, 42773, order)

					class NoReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 42771
							order[1] = 0
							fix.Group.__init__(self, 42770, 42771, order)

			class NoPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42621
					order[1] = 0
					fix.Group.__init__(self, 42620, 42621, order)

			class NoPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42607
					order[1] = 42608
					order[2] = 0
					fix.Group.__init__(self, 42606, 42607, order)

			class NoPaymentStreamNonDeliverableFixingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40819
					order[1] = 0
					fix.Group.__init__(self, 40946, 40819, order)

			class NoNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40826
					order[1] = 40827
					order[2] = 0
					fix.Group.__init__(self, 40825, 40826, order)

			class NoSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40086
					order[1] = 40373
					order[2] = 40655
					order[3] = 40088
					order[4] = 40089
					order[5] = 0
					fix.Group.__init__(self, 40085, 40086, order)

			class NoPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40829
					order[1] = 41164
					order[2] = 41165
					order[3] = 40830
					order[4] = 40831
					order[5] = 40832
					order[6] = 40833
					order[7] = 40834
					order[8] = 40835
					order[9] = 40836
					order[10] = 40837
					order[11] = 40838
					order[12] = 40839
					order[13] = 41166
					order[14] = 41167
					order[15] = 41168
					order[16] = 41169
					order[17] = 40840
					order[18] = 40841
					order[19] = 40842
					order[20] = 40843
					order[21] = 41170
					order[22] = 41171
					order[23] = 41172
					order[24] = 41173
					order[25] = 40844
					order[26] = 40845
					order[27] = 40846
					order[28] = 40847
					order[29] = 40848
					order[30] = 40849
					order[31] = 40868
					order[32] = 40850
					order[33] = 40851
					order[34] = 40852
					order[35] = 40853
					order[36] = 40977
					order[37] = 40855
					order[38] = 40856
					order[39] = 40857
					order[40] = 41174
					order[41] = 41175
					order[42] = 40858
					order[43] = 41161
					order[44] = 41176
					order[45] = 41177
					order[46] = 41178
					order[47] = 41179
					order[48] = 40859
					order[49] = 40860
					order[50] = 40861
					order[51] = 40862
					order[52] = 40945
					order[53] = 40864
					order[54] = 40865
					order[55] = 40866
					order[56] = 40867
					order[57] = 0
					fix.Group.__init__(self, 40828, 40829, order)

				class NoPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40869
						order[1] = 40870
						order[2] = 40871
						order[3] = 0
						fix.Group.__init__(self, 40868, 40869, order)

				class NoPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40854
						order[1] = 0
						fix.Group.__init__(self, 40977, 40854, order)

				class NoPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41162
						order[1] = 41163
						order[2] = 0
						fix.Group.__init__(self, 41161, 41162, order)

				class NoPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40863
						order[1] = 0
						fix.Group.__init__(self, 40945, 40863, order)

			class NoPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40873
					order[1] = 40874
					order[2] = 42698
					order[3] = 42699
					order[4] = 42700
					order[5] = 42701
					order[6] = 42702
					order[7] = 42703
					order[8] = 42704
					order[9] = 42689
					order[10] = 42690
					order[11] = 42691
					order[12] = 42692
					order[13] = 42693
					order[14] = 42694
					order[15] = 42695
					order[16] = 40875
					order[17] = 40876
					order[18] = 40877
					order[19] = 40878
					order[20] = 40879
					order[21] = 40880
					order[22] = 40881
					order[23] = 40882
					order[24] = 40883
					order[25] = 40884
					order[26] = 40885
					order[27] = 40886
					order[28] = 40887
					order[29] = 40888
					order[30] = 40889
					order[31] = 40890
					order[32] = 40891
					order[33] = 40892
					order[34] = 40893
					order[35] = 40894
					order[36] = 40895
					order[37] = 40896
					order[38] = 40897
					order[39] = 40898
					order[40] = 40899
					order[41] = 40900
					order[42] = 40901
					order[43] = 0
					fix.Group.__init__(self, 40872, 40873, order)

				class NoPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42706
						order[1] = 0
						fix.Group.__init__(self, 42705, 42706, order)

				class NoPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42697
						order[1] = 0
						fix.Group.__init__(self, 42696, 42697, order)

			class NoDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41086
					order[1] = 0
					fix.Group.__init__(self, 41085, 41086, order)

			class NoDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41082
					order[1] = 41083
					order[2] = 41084
					order[3] = 0
					fix.Group.__init__(self, 41081, 41082, order)

			class NoDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41038
					order[1] = 41039
					order[2] = 41040
					order[3] = 41041
					order[4] = 41042
					order[5] = 41043
					order[6] = 41044
					order[7] = 41045
					order[8] = 41046
					order[9] = 41047
					order[10] = 41048
					order[11] = 41049
					order[12] = 41050
					order[13] = 41051
					order[14] = 0
					fix.Group.__init__(self, 41037, 41038, order)

				class NoDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41052
						order[1] = 41053
						order[2] = 41054
						order[3] = 0
						fix.Group.__init__(self, 41051, 41052, order)

					class NoDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41055
							order[1] = 41056
							order[2] = 41057
							order[3] = 0
							fix.Group.__init__(self, 41054, 41055, order)

		class NoProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 40091
				order[1] = 40092
				order[2] = 40093
				order[3] = 40957
				order[4] = 40095
				order[5] = 40096
				order[6] = 40097
				order[7] = 42707
				order[8] = 42708
				order[9] = 40098
				order[10] = 40099
				order[11] = 40100
				order[12] = 40114
				order[13] = 40115
				order[14] = 40116
				order[15] = 40118
				order[16] = 40119
				order[17] = 40120
				order[18] = 40121
				order[19] = 40122
				order[20] = 40123
				order[21] = 40125
				order[22] = 40126
				order[23] = 40127
				order[24] = 40128
				order[25] = 40129
				order[26] = 40130
				order[27] = 40131
				order[28] = 40132
				order[29] = 40133
				order[30] = 40134
				order[31] = 40135
				order[32] = 40136
				order[33] = 40137
				order[34] = 40138
				order[35] = 40139
				order[36] = 40140
				order[37] = 40141
				order[38] = 40145
				order[39] = 40146
				order[40] = 40148
				order[41] = 40149
				order[42] = 40150
				order[43] = 40151
				order[44] = 40152
				order[45] = 40153
				order[46] = 40154
				order[47] = 40155
				order[48] = 40156
				order[49] = 40158
				order[50] = 40159
				order[51] = 40160
				order[52] = 40161
				order[53] = 40162
				order[54] = 40101
				order[55] = 40102
				order[56] = 40103
				order[57] = 40104
				order[58] = 40105
				order[59] = 40106
				order[60] = 40107
				order[61] = 40163
				order[62] = 40165
				order[63] = 40166
				order[64] = 40167
				order[65] = 40168
				order[66] = 40169
				order[67] = 40170
				order[68] = 40108
				order[69] = 40109
				order[70] = 40110
				order[71] = 40111
				order[72] = 40112
				order[73] = 41406
				order[74] = 40113
				order[75] = 40986
				order[76] = 40987
				order[77] = 40174
				order[78] = 0
				fix.Group.__init__(self, 40090, 40091, order)

			class NoProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40094
					order[1] = 0
					fix.Group.__init__(self, 40957, 40094, order)

			class NoProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40117
					order[1] = 0
					fix.Group.__init__(self, 40953, 40117, order)

			class NoProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40124
					order[1] = 0
					fix.Group.__init__(self, 40954, 40124, order)

			class NoProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40143
					order[1] = 40144
					order[2] = 0
					fix.Group.__init__(self, 40142, 40143, order)

			class NoProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40147
					order[1] = 0
					fix.Group.__init__(self, 40955, 40147, order)

			class NoProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40157
					order[1] = 0
					fix.Group.__init__(self, 40956, 40157, order)

			class NoProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40164
					order[1] = 0
					fix.Group.__init__(self, 40952, 40164, order)

			class NoProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40172
					order[1] = 40173
					order[2] = 0
					fix.Group.__init__(self, 40171, 40172, order)

			class NoProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40175
					order[1] = 40176
					order[2] = 40177
					order[3] = 2385
					order[4] = 40178
					order[5] = 0
					fix.Group.__init__(self, 40174, 40175, order)

				class NoProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40179
						order[1] = 40180
						order[2] = 0
						fix.Group.__init__(self, 40178, 40179, order)

		class NoAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 40020
				order[1] = 40021
				order[2] = 40000
				order[3] = 0
				fix.Group.__init__(self, 40019, 40020, order)

			class NoAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 40001
					order[1] = 40002
					order[2] = 40003
					order[3] = 40004
					order[4] = 40005
					order[5] = 40006
					order[6] = 40007
					order[7] = 40008
					order[8] = 40009
					order[9] = 40010
					order[10] = 40011
					order[11] = 40012
					order[12] = 40013
					order[13] = 40014
					order[14] = 40015
					order[15] = 40016
					order[16] = 40017
					order[17] = 40018
					order[18] = 0
					fix.Group.__init__(self, 40000, 40001, order)

		class NoProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 40182
				order[1] = 40183
				order[2] = 40184
				order[3] = 40185
				order[4] = 40186
				order[5] = 40187
				order[6] = 40188
				order[7] = 40951
				order[8] = 40191
				order[9] = 40201
				order[10] = 40190
				order[11] = 0
				fix.Group.__init__(self, 40181, 40182, order)

			class NoProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40189
					order[1] = 0
					fix.Group.__init__(self, 40951, 40189, order)

			class NoProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 40192
					order[1] = 40193
					order[2] = 40194
					order[3] = 40195
					order[4] = 40196
					order[5] = 40197
					order[6] = 40198
					order[7] = 40199
					order[8] = 0
					fix.Group.__init__(self, 40191, 40192, order)

				class NoProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40200
						order[1] = 0
						fix.Group.__init__(self, 40199, 40200, order)

			class NoProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40202
					order[1] = 40203
					order[2] = 0
					fix.Group.__init__(self, 40201, 40202, order)

		class NoCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 40023
				order[1] = 40024
				order[2] = 40916
				order[3] = 40917
				order[4] = 40025
				order[5] = 40026
				order[6] = 40027
				order[7] = 40028
				order[8] = 40029
				order[9] = 40030
				order[10] = 40031
				order[11] = 40277
				order[12] = 42216
				order[13] = 42217
				order[14] = 40033
				order[15] = 40034
				order[16] = 42207
				order[17] = 42208
				order[18] = 42209
				order[19] = 42210
				order[20] = 42211
				order[21] = 42212
				order[22] = 42213
				order[23] = 40035
				order[24] = 40036
				order[25] = 40037
				order[26] = 40038
				order[27] = 40039
				order[28] = 0
				fix.Group.__init__(self, 40022, 40023, order)

			class NoCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40032
					order[1] = 0
					fix.Group.__init__(self, 40277, 40032, order)

			class NoCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42215
					order[1] = 0
					fix.Group.__init__(self, 42214, 42215, order)

		class NoPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40209
				order[1] = 40205
				order[2] = 40206
				order[3] = 40207
				order[4] = 40208
				order[5] = 0
				fix.Group.__init__(self, 40204, 40209, order)

			class NoPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40210
					order[1] = 40211
					order[2] = 0
					fix.Group.__init__(self, 40209, 40210, order)

		class NoExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42297
				order[1] = 42298
				order[2] = 0
				fix.Group.__init__(self, 42296, 42297, order)

		class NoInstrAttrib(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 871
				order[1] = 872
				order[2] = 0
				fix.Group.__init__(self, 870, 871, order)

		class NoIndexRollMonths(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 2733
				order[1] = 0
				fix.Group.__init__(self, 2734, 2733, order)

		class NoReferenceDataDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 2747
				order[1] = 2748
				order[2] = 0
				fix.Group.__init__(self, 2746, 2747, order)

		class NoContractualDefinitions(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40041
				order[1] = 0
				fix.Group.__init__(self, 40040, 40041, order)

		class NoFinancingTermSupplements(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40047
				order[1] = 40048
				order[2] = 0
				fix.Group.__init__(self, 40046, 40047, order)

		class NoContractualMatrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 40043
				order[1] = 40044
				order[2] = 40045
				order[3] = 0
				fix.Group.__init__(self, 40042, 40043, order)

		class NoRelatedInstruments(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 1648
				order[1] = 1649
				order[2] = 1650
				order[3] = 1651
				order[4] = 1652
				order[5] = 1653
				order[6] = 2413
				order[7] = 2414
				order[8] = 2415
				order[9] = 2417
				order[10] = 0
				fix.Group.__init__(self, 1647, 1648, order)

	class NoLegs(fix.Group):
		def __init__(self):
			order = fix.IntArray(176)
			order[0] = 600
			order[1] = 601
			order[2] = 602
			order[3] = 603
			order[4] = 1788
			order[5] = 607
			order[6] = 1594
			order[7] = 608
			order[8] = 2893
			order[9] = 609
			order[10] = 764
			order[11] = 610
			order[12] = 611
			order[13] = 1212
			order[14] = 2146
			order[15] = 2147
			order[16] = 2148
			order[17] = 248
			order[18] = 2149
			order[19] = 2150
			order[20] = 2151
			order[21] = 2152
			order[22] = 2153
			order[23] = 2154
			order[24] = 2155
			order[25] = 2348
			order[26] = 2067
			order[27] = 2068
			order[28] = 2069
			order[29] = 2739
			order[30] = 2070
			order[31] = 2156
			order[32] = 2157
			order[33] = 2158
			order[34] = 2159
			order[35] = 2160
			order[36] = 2161
			order[37] = 2162
			order[38] = 2163
			order[39] = 2164
			order[40] = 2165
			order[41] = 2880
			order[42] = 2166
			order[43] = 2167
			order[44] = 2168
			order[45] = 2169
			order[46] = 2170
			order[47] = 2171
			order[48] = 2172
			order[49] = 2173
			order[50] = 2174
			order[51] = 2175
			order[52] = 2176
			order[53] = 2177
			order[54] = 2178
			order[55] = 2179
			order[56] = 2180
			order[57] = 249
			order[58] = 250
			order[59] = 251
			order[60] = 252
			order[61] = 253
			order[62] = 257
			order[63] = 599
			order[64] = 596
			order[65] = 597
			order[66] = 598
			order[67] = 254
			order[68] = 612
			order[69] = 942
			order[70] = 2908
			order[71] = 2181
			order[72] = 2182
			order[73] = 2183
			order[74] = 2184
			order[75] = 2604
			order[76] = 2185
			order[77] = 2605
			order[78] = 2186
			order[79] = 2187
			order[80] = 2188
			order[81] = 2189
			order[82] = 613
			order[83] = 614
			order[84] = 1436
			order[85] = 2354
			order[86] = 1440
			order[87] = 2190
			order[88] = 2191
			order[89] = 999
			order[90] = 1224
			order[91] = 1720
			order[92] = 2909
			order[93] = 1421
			order[94] = 1422
			order[95] = 1721
			order[96] = 2910
			order[97] = 2192
			order[98] = 1001
			order[99] = 1420
			order[100] = 2193
			order[101] = 2194
			order[102] = 2755
			order[103] = 2195
			order[104] = 2196
			order[105] = 2197
			order[106] = 2198
			order[107] = 1528
			order[108] = 2911
			order[109] = 2199
			order[110] = 2200
			order[111] = 2201
			order[112] = 2202
			order[113] = 2203
			order[114] = 615
			order[115] = 616
			order[116] = 2205
			order[117] = 2206
			order[118] = 617
			order[119] = 618
			order[120] = 619
			order[121] = 2740
			order[122] = 2717
			order[123] = 2718
			order[124] = 2719
			order[125] = 620
			order[126] = 621
			order[127] = 622
			order[128] = 2207
			order[129] = 2208
			order[130] = 623
			order[131] = 624
			order[132] = 556
			order[133] = 2898
			order[134] = 740
			order[135] = 739
			order[136] = 955
			order[137] = 956
			order[138] = 1358
			order[139] = 2682
			order[140] = 2686
			order[141] = 1017
			order[142] = 566
			order[143] = 2209
			order[144] = 2211
			order[145] = 2212
			order[146] = 2213
			order[147] = 2754
			order[148] = 2214
			order[149] = 2215
			order[150] = 2606
			order[151] = 2607
			order[152] = 2497
			order[153] = 2498
			order[154] = 2499
			order[155] = 2496
			order[156] = 2495
			order[157] = 2953
			order[158] = 2511
			order[159] = 2510
			order[160] = 2512
			order[161] = 2509
			order[162] = 2500
			order[163] = 2502
			order[164] = 2501
			order[165] = 2503
			order[166] = 2507
			order[167] = 2505
			order[168] = 2494
			order[169] = 2493
			order[170] = 2514
			order[171] = 2513
			order[172] = 2506
			order[173] = 2504
			order[174] = 2508
			order[175] = 0
			fix.Group.__init__(self, 555, 600, order)

		class NoLegSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 605
				order[1] = 606
				order[2] = 2958
				order[3] = 0
				fix.Group.__init__(self, 604, 605, order)

		class NoLegSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2077
				order[1] = 2078
				order[2] = 2079
				order[3] = 2743
				order[4] = 0
				fix.Group.__init__(self, 2076, 2077, order)

		class NoLegAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2309
				order[1] = 2310
				order[2] = 2311
				order[3] = 0
				fix.Group.__init__(self, 2308, 2309, order)

		class NoLegEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 2060
				order[1] = 2061
				order[2] = 2062
				order[3] = 2063
				order[4] = 2064
				order[5] = 2341
				order[6] = 2065
				order[7] = 2066
				order[8] = 2074
				order[9] = 2075
				order[10] = 0
				fix.Group.__init__(self, 2059, 2060, order)

		class NoLegInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 2255
				order[1] = 2256
				order[2] = 2257
				order[3] = 2379
				order[4] = 2258
				order[5] = 0
				fix.Group.__init__(self, 2254, 2255, order)

			class NoLegInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 2259
					order[1] = 2260
					order[2] = 0
					fix.Group.__init__(self, 2258, 2259, order)

		class NoLegComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2219
				order[1] = 2220
				order[2] = 2221
				order[3] = 2222
				order[4] = 2223
				order[5] = 2224
				order[6] = 2225
				order[7] = 2226
				order[8] = 2944
				order[9] = 2227
				order[10] = 2228
				order[11] = 2229
				order[12] = 2230
				order[13] = 2231
				order[14] = 2232
				order[15] = 2250
				order[16] = 2233
				order[17] = 2945
				order[18] = 2234
				order[19] = 2946
				order[20] = 2235
				order[21] = 2236
				order[22] = 2409
				order[23] = 2410
				order[24] = 2237
				order[25] = 2238
				order[26] = 2239
				order[27] = 2240
				order[28] = 2241
				order[29] = 41382
				order[30] = 41389
				order[31] = 41390
				order[32] = 41391
				order[33] = 41392
				order[34] = 41393
				order[35] = 41394
				order[36] = 41395
				order[37] = 41396
				order[38] = 41397
				order[39] = 41379
				order[40] = 2242
				order[41] = 2243
				order[42] = 2244
				order[43] = 2245
				order[44] = 2246
				order[45] = 41398
				order[46] = 41366
				order[47] = 2608
				order[48] = 2609
				order[49] = 2610
				order[50] = 2248
				order[51] = 2249
				order[52] = 0
				fix.Group.__init__(self, 2218, 2219, order)

			class NoLegComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2251
					order[1] = 2252
					order[2] = 2253
					order[3] = 0
					fix.Group.__init__(self, 2250, 2251, order)

				class NoLegComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2204
						order[1] = 2247
						order[2] = 0
						fix.Group.__init__(self, 2253, 2204, order)

			class NoLegComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41383
					order[1] = 41384
					order[2] = 41385
					order[3] = 41386
					order[4] = 0
					fix.Group.__init__(self, 41382, 41383, order)

			class NoLegComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41388
					order[1] = 0
					fix.Group.__init__(self, 41387, 41388, order)

			class NoLegComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41380
					order[1] = 41381
					order[2] = 41400
					order[3] = 41376
					order[4] = 41363
					order[5] = 0
					fix.Group.__init__(self, 41379, 41380, order)

				class NoLegComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41401
						order[1] = 41402
						order[2] = 41403
						order[3] = 41404
						order[4] = 41405
						order[5] = 0
						fix.Group.__init__(self, 41400, 41401, order)

				class NoLegComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41377
						order[1] = 41378
						order[2] = 0
						fix.Group.__init__(self, 41376, 41377, order)

				class NoLegComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41364
						order[1] = 41365
						order[2] = 0
						fix.Group.__init__(self, 41363, 41364, order)

			class NoLegComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41399
					order[1] = 0
					fix.Group.__init__(self, 41398, 41399, order)

			class NoLegComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41367
					order[1] = 41368
					order[2] = 41369
					order[3] = 41370
					order[4] = 41371
					order[5] = 41372
					order[6] = 41373
					order[7] = 41374
					order[8] = 0
					fix.Group.__init__(self, 41366, 41367, order)

				class NoLegComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41375
						order[1] = 0
						fix.Group.__init__(self, 41374, 41375, order)

		class NoLegBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40924
				order[1] = 0
				fix.Group.__init__(self, 40923, 40924, order)

		class NoLegPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41608
				order[1] = 0
				fix.Group.__init__(self, 41607, 41608, order)

		class NoLegMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41468
				order[1] = 40223
				order[2] = 0
				fix.Group.__init__(self, 41467, 41468, order)

		class NoLegMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41470
				order[1] = 40990
				order[2] = 0
				fix.Group.__init__(self, 41469, 41470, order)

		class NoLegMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41472
				order[1] = 41473
				order[2] = 41474
				order[3] = 41475
				order[4] = 41476
				order[5] = 41477
				order[6] = 41478
				order[7] = 41479
				order[8] = 41480
				order[9] = 0
				fix.Group.__init__(self, 41471, 41472, order)

		class NoLegSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42582
				order[1] = 0
				fix.Group.__init__(self, 42581, 42582, order)

		class NoLegOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41492
				order[1] = 0
				fix.Group.__init__(self, 41491, 41492, order)

		class NoLegOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41513
				order[1] = 41514
				order[2] = 0
				fix.Group.__init__(self, 41512, 41513, order)

		class NoLegOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41516
				order[1] = 0
				fix.Group.__init__(self, 41515, 41516, order)

		class NoLegOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41528
				order[1] = 41529
				order[2] = 0
				fix.Group.__init__(self, 41527, 41528, order)

		class NoLegStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40242
				order[1] = 41700
				order[2] = 40243
				order[3] = 42583
				order[4] = 42584
				order[5] = 40244
				order[6] = 40245
				order[7] = 41702
				order[8] = 40246
				order[9] = 40247
				order[10] = 42585
				order[11] = 42586
				order[12] = 41703
				order[13] = 41704
				order[14] = 41705
				order[15] = 41706
				order[16] = 41707
				order[17] = 41708
				order[18] = 41648
				order[19] = 41649
				order[20] = 41650
				order[21] = 41651
				order[22] = 41652
				order[23] = 41653
				order[24] = 41654
				order[25] = 42588
				order[26] = 41655
				order[27] = 41656
				order[28] = 41657
				order[29] = 41658
				order[30] = 41659
				order[31] = 41660
				order[32] = 41661
				order[33] = 41662
				order[34] = 41663
				order[35] = 41664
				order[36] = 41665
				order[37] = 41666
				order[38] = 41667
				order[39] = 41668
				order[40] = 41669
				order[41] = 41670
				order[42] = 41671
				order[43] = 41672
				order[44] = 41673
				order[45] = 40249
				order[46] = 40250
				order[47] = 40252
				order[48] = 40253
				order[49] = 40254
				order[50] = 40255
				order[51] = 40256
				order[52] = 40257
				order[53] = 40258
				order[54] = 40260
				order[55] = 40261
				order[56] = 40262
				order[57] = 40263
				order[58] = 40264
				order[59] = 41641
				order[60] = 41642
				order[61] = 40265
				order[62] = 40267
				order[63] = 40268
				order[64] = 40270
				order[65] = 40271
				order[66] = 40272
				order[67] = 40273
				order[68] = 40274
				order[69] = 40275
				order[70] = 40276
				order[71] = 41643
				order[72] = 41644
				order[73] = 41645
				order[74] = 40279
				order[75] = 40280
				order[76] = 40281
				order[77] = 42399
				order[78] = 40282
				order[79] = 40283
				order[80] = 43108
				order[81] = 40284
				order[82] = 40285
				order[83] = 40286
				order[84] = 40287
				order[85] = 40288
				order[86] = 42400
				order[87] = 42401
				order[88] = 42402
				order[89] = 42403
				order[90] = 40289
				order[91] = 40290
				order[92] = 40291
				order[93] = 41549
				order[94] = 41550
				order[95] = 41551
				order[96] = 41552
				order[97] = 41553
				order[98] = 41554
				order[99] = 41555
				order[100] = 42404
				order[101] = 40374
				order[102] = 40418
				order[103] = 41429
				order[104] = 41430
				order[105] = 41431
				order[106] = 41432
				order[107] = 41433
				order[108] = 42194
				order[109] = 42195
				order[110] = 41434
				order[111] = 41435
				order[112] = 41436
				order[113] = 41437
				order[114] = 41438
				order[115] = 41219
				order[116] = 41439
				order[117] = 41440
				order[118] = 41441
				order[119] = 41442
				order[120] = 41443
				order[121] = 41444
				order[122] = 41445
				order[123] = 41446
				order[124] = 41447
				order[125] = 41448
				order[126] = 41449
				order[127] = 41450
				order[128] = 41451
				order[129] = 43095
				order[130] = 41408
				order[131] = 40248
				order[132] = 40978
				order[133] = 40979
				order[134] = 0
				fix.Group.__init__(self, 40241, 40242, order)

			class NoLegStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41675
					order[1] = 41676
					order[2] = 0
					fix.Group.__init__(self, 41674, 41675, order)

			class NoLegStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41453
					order[1] = 41454
					order[2] = 41455
					order[3] = 0
					fix.Group.__init__(self, 41452, 41453, order)

			class NoLegStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41678
					order[1] = 41679
					order[2] = 0
					fix.Group.__init__(self, 41677, 41678, order)

			class NoLegStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41647
					order[1] = 0
					fix.Group.__init__(self, 41646, 41647, order)

			class NoLegStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41687
					order[1] = 41688
					order[2] = 41689
					order[3] = 41690
					order[4] = 41691
					order[5] = 41692
					order[6] = 41693
					order[7] = 41694
					order[8] = 41695
					order[9] = 41696
					order[10] = 41697
					order[11] = 41680
					order[12] = 41698
					order[13] = 41699
					order[14] = 0
					fix.Group.__init__(self, 41686, 41687, order)

				class NoLegStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41681
						order[1] = 41682
						order[2] = 41683
						order[3] = 0
						fix.Group.__init__(self, 41680, 41681, order)

					class NoLegStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41684
							order[1] = 41685
							order[2] = 41935
							order[3] = 0
							fix.Group.__init__(self, 41683, 41684, order)

			class NoLegStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40251
					order[1] = 0
					fix.Group.__init__(self, 40942, 40251, order)

			class NoLegStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40259
					order[1] = 0
					fix.Group.__init__(self, 40943, 40259, order)

			class NoLegStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40266
					order[1] = 0
					fix.Group.__init__(self, 40940, 40266, order)

			class NoLegStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41639
					order[1] = 41640
					order[2] = 0
					fix.Group.__init__(self, 41638, 41639, order)

			class NoLegStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40269
					order[1] = 0
					fix.Group.__init__(self, 40941, 40269, order)

			class NoLegPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40293
					order[1] = 0
					fix.Group.__init__(self, 40930, 40293, order)

			class NoLegPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41590
					order[1] = 41591
					order[2] = 0
					fix.Group.__init__(self, 41589, 41590, order)

			class NoLegPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40305
					order[1] = 0
					fix.Group.__init__(self, 40931, 40305, order)

			class NoLegPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40311
					order[1] = 0
					fix.Group.__init__(self, 40932, 40311, order)

			class NoLegPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40318
					order[1] = 0
					fix.Group.__init__(self, 40933, 40318, order)

			class NoLegPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42460
					order[1] = 42461
					order[2] = 0
					fix.Group.__init__(self, 42459, 42460, order)

			class NoLegPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41562
					order[1] = 0
					fix.Group.__init__(self, 41561, 41562, order)

			class NoLegPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41597
					order[1] = 41598
					order[2] = 0
					fix.Group.__init__(self, 41596, 41597, order)

			class NoLegPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41594
					order[1] = 41595
					order[2] = 0
					fix.Group.__init__(self, 41593, 41594, order)

			class NoLegPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43110
					order[1] = 42486
					order[2] = 42487
					order[3] = 0
					fix.Group.__init__(self, 42485, 43110, order)

			class NoLegDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42367
					order[1] = 42368
					order[2] = 42369
					order[3] = 42370
					order[4] = 42371
					order[5] = 42372
					order[6] = 42386
					order[7] = 42373
					order[8] = 42374
					order[9] = 42375
					order[10] = 42376
					order[11] = 42377
					order[12] = 42378
					order[13] = 42379
					order[14] = 42380
					order[15] = 42381
					order[16] = 42382
					order[17] = 42383
					order[18] = 42384
					order[19] = 42385
					order[20] = 0
					fix.Group.__init__(self, 42366, 42367, order)

				class NoLegDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42387
						order[1] = 0
						fix.Group.__init__(self, 42386, 42387, order)

			class NoLegDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42365
					order[1] = 0
					fix.Group.__init__(self, 42364, 42365, order)

			class NoLegDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42311
					order[1] = 0
					fix.Group.__init__(self, 42310, 42311, order)

			class NoLegReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 42535
					order[1] = 42536
					order[2] = 42537
					order[3] = 42538
					order[4] = 42539
					order[5] = 42540
					order[6] = 42564
					order[7] = 42530
					order[8] = 42541
					order[9] = 42542
					order[10] = 42543
					order[11] = 42544
					order[12] = 42545
					order[13] = 42546
					order[14] = 42547
					order[15] = 42548
					order[16] = 42549
					order[17] = 42550
					order[18] = 42551
					order[19] = 42552
					order[20] = 42560
					order[21] = 42553
					order[22] = 42554
					order[23] = 42508
					order[24] = 42555
					order[25] = 42556
					order[26] = 42557
					order[27] = 42558
					order[28] = 42559
					order[29] = 0
					fix.Group.__init__(self, 42534, 42535, order)

				class NoLegReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 42565
						order[1] = 42566
						order[2] = 42567
						order[3] = 42568
						order[4] = 0
						fix.Group.__init__(self, 42564, 42565, order)

				class NoLegReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42531
						order[1] = 42532
						order[2] = 42533
						order[3] = 0
						fix.Group.__init__(self, 42530, 42531, order)

				class NoLegReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42561
						order[1] = 42562
						order[2] = 42563
						order[3] = 0
						fix.Group.__init__(self, 42560, 42561, order)

				class NoLegReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 42509
						order[1] = 42571
						order[2] = 42510
						order[3] = 42511
						order[4] = 42512
						order[5] = 42513
						order[6] = 42514
						order[7] = 42515
						order[8] = 42516
						order[9] = 42517
						order[10] = 42518
						order[11] = 42519
						order[12] = 42520
						order[13] = 42521
						order[14] = 42522
						order[15] = 42523
						order[16] = 42524
						order[17] = 42525
						order[18] = 42526
						order[19] = 42527
						order[20] = 42528
						order[21] = 42529
						order[22] = 42569
						order[23] = 0
						fix.Group.__init__(self, 42508, 42509, order)

					class NoLegReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 42572
							order[1] = 42573
							order[2] = 0
							fix.Group.__init__(self, 42571, 42572, order)

					class NoLegReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 42570
							order[1] = 0
							fix.Group.__init__(self, 42569, 42570, order)

			class NoLegPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42420
					order[1] = 0
					fix.Group.__init__(self, 42419, 42420, order)

			class NoLegPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42406
					order[1] = 42407
					order[2] = 0
					fix.Group.__init__(self, 42405, 42406, order)

			class NoLegPaymentStreamNonDeliverableFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40361
					order[1] = 0
					fix.Group.__init__(self, 40929, 40361, order)

			class NoLegNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40368
					order[1] = 40369
					order[2] = 0
					fix.Group.__init__(self, 40367, 40368, order)

			class NoLegSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40903
					order[1] = 40366
					order[2] = 40370
					order[3] = 40905
					order[4] = 40906
					order[5] = 0
					fix.Group.__init__(self, 40902, 40903, order)

			class NoLegPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40375
					order[1] = 41533
					order[2] = 41534
					order[3] = 40376
					order[4] = 40377
					order[5] = 40378
					order[6] = 40379
					order[7] = 40380
					order[8] = 40381
					order[9] = 40382
					order[10] = 40383
					order[11] = 40384
					order[12] = 40385
					order[13] = 41535
					order[14] = 41536
					order[15] = 41537
					order[16] = 41538
					order[17] = 40386
					order[18] = 40387
					order[19] = 40388
					order[20] = 40389
					order[21] = 41539
					order[22] = 41540
					order[23] = 41541
					order[24] = 41542
					order[25] = 40390
					order[26] = 40391
					order[27] = 40392
					order[28] = 40393
					order[29] = 40394
					order[30] = 40395
					order[31] = 40414
					order[32] = 40396
					order[33] = 40397
					order[34] = 40398
					order[35] = 40399
					order[36] = 40927
					order[37] = 40401
					order[38] = 40402
					order[39] = 40403
					order[40] = 41543
					order[41] = 41544
					order[42] = 40404
					order[43] = 41530
					order[44] = 41545
					order[45] = 41546
					order[46] = 41547
					order[47] = 41548
					order[48] = 40405
					order[49] = 40406
					order[50] = 40407
					order[51] = 40408
					order[52] = 40928
					order[53] = 40410
					order[54] = 40411
					order[55] = 40412
					order[56] = 40413
					order[57] = 0
					fix.Group.__init__(self, 40374, 40375, order)

				class NoLegPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40415
						order[1] = 40416
						order[2] = 40417
						order[3] = 0
						fix.Group.__init__(self, 40414, 40415, order)

				class NoLegPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40400
						order[1] = 0
						fix.Group.__init__(self, 40927, 40400, order)

				class NoLegPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41531
						order[1] = 41532
						order[2] = 0
						fix.Group.__init__(self, 41530, 41531, order)

				class NoLegPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40409
						order[1] = 0
						fix.Group.__init__(self, 40928, 40409, order)

			class NoLegPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40419
					order[1] = 40420
					order[2] = 42497
					order[3] = 42498
					order[4] = 42499
					order[5] = 42500
					order[6] = 42501
					order[7] = 42502
					order[8] = 42503
					order[9] = 42488
					order[10] = 42489
					order[11] = 42490
					order[12] = 42491
					order[13] = 42492
					order[14] = 42493
					order[15] = 42494
					order[16] = 40421
					order[17] = 40422
					order[18] = 40423
					order[19] = 40424
					order[20] = 40425
					order[21] = 40426
					order[22] = 40427
					order[23] = 40428
					order[24] = 40429
					order[25] = 40430
					order[26] = 40431
					order[27] = 40432
					order[28] = 40433
					order[29] = 40434
					order[30] = 40435
					order[31] = 40436
					order[32] = 40437
					order[33] = 40438
					order[34] = 40439
					order[35] = 40440
					order[36] = 40441
					order[37] = 40442
					order[38] = 40443
					order[39] = 40444
					order[40] = 40445
					order[41] = 40446
					order[42] = 40447
					order[43] = 0
					fix.Group.__init__(self, 40418, 40419, order)

				class NoLegPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42505
						order[1] = 0
						fix.Group.__init__(self, 42504, 42505, order)

				class NoLegPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42496
						order[1] = 0
						fix.Group.__init__(self, 42495, 42496, order)

			class NoLegDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41461
					order[1] = 0
					fix.Group.__init__(self, 41460, 41461, order)

			class NoLegDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41457
					order[1] = 41458
					order[2] = 41459
					order[3] = 0
					fix.Group.__init__(self, 41456, 41457, order)

			class NoLegDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41409
					order[1] = 41410
					order[2] = 41411
					order[3] = 41412
					order[4] = 41413
					order[5] = 41414
					order[6] = 41415
					order[7] = 41416
					order[8] = 41417
					order[9] = 41418
					order[10] = 41419
					order[11] = 41420
					order[12] = 41421
					order[13] = 41422
					order[14] = 0
					fix.Group.__init__(self, 41408, 41409, order)

				class NoLegDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41423
						order[1] = 41424
						order[2] = 41425
						order[3] = 0
						fix.Group.__init__(self, 41422, 41423, order)

					class NoLegDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41426
							order[1] = 41427
							order[2] = 41428
							order[3] = 0
							fix.Group.__init__(self, 41425, 41426, order)

		class NoLegProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 40449
				order[1] = 40450
				order[2] = 40451
				order[3] = 40939
				order[4] = 40453
				order[5] = 40454
				order[6] = 40455
				order[7] = 42506
				order[8] = 42507
				order[9] = 40456
				order[10] = 40457
				order[11] = 40458
				order[12] = 40524
				order[13] = 40525
				order[14] = 40526
				order[15] = 40528
				order[16] = 40529
				order[17] = 40530
				order[18] = 40531
				order[19] = 40532
				order[20] = 40476
				order[21] = 40478
				order[22] = 40479
				order[23] = 40480
				order[24] = 40481
				order[25] = 40482
				order[26] = 40483
				order[27] = 40484
				order[28] = 40485
				order[29] = 40486
				order[30] = 40487
				order[31] = 40488
				order[32] = 40489
				order[33] = 40490
				order[34] = 40491
				order[35] = 40492
				order[36] = 40493
				order[37] = 40494
				order[38] = 40498
				order[39] = 40499
				order[40] = 40501
				order[41] = 40502
				order[42] = 40503
				order[43] = 40504
				order[44] = 40505
				order[45] = 40506
				order[46] = 40507
				order[47] = 40508
				order[48] = 40509
				order[49] = 40511
				order[50] = 40512
				order[51] = 40513
				order[52] = 40514
				order[53] = 40515
				order[54] = 40459
				order[55] = 40460
				order[56] = 40461
				order[57] = 40462
				order[58] = 40463
				order[59] = 40464
				order[60] = 40465
				order[61] = 40516
				order[62] = 40518
				order[63] = 40519
				order[64] = 40520
				order[65] = 40521
				order[66] = 40522
				order[67] = 40523
				order[68] = 40466
				order[69] = 40467
				order[70] = 40468
				order[71] = 40469
				order[72] = 40470
				order[73] = 41407
				order[74] = 40472
				order[75] = 40980
				order[76] = 40981
				order[77] = 40533
				order[78] = 0
				fix.Group.__init__(self, 40448, 40449, order)

			class NoLegProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40452
					order[1] = 0
					fix.Group.__init__(self, 40939, 40452, order)

			class NoLegProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40527
					order[1] = 0
					fix.Group.__init__(self, 40935, 40527, order)

			class NoLegProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40477
					order[1] = 0
					fix.Group.__init__(self, 40936, 40477, order)

			class NoLegProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40496
					order[1] = 40497
					order[2] = 0
					fix.Group.__init__(self, 40495, 40496, order)

			class NoLegProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40500
					order[1] = 0
					fix.Group.__init__(self, 40937, 40500, order)

			class NoLegProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40510
					order[1] = 0
					fix.Group.__init__(self, 40938, 40510, order)

			class NoLegProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40517
					order[1] = 0
					fix.Group.__init__(self, 40934, 40517, order)

			class NoLegProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40474
					order[1] = 40475
					order[2] = 0
					fix.Group.__init__(self, 40473, 40474, order)

			class NoLegProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40534
					order[1] = 40535
					order[2] = 40536
					order[3] = 2380
					order[4] = 40537
					order[5] = 0
					fix.Group.__init__(self, 40533, 40534, order)

				class NoLegProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40538
						order[1] = 40539
						order[2] = 0
						fix.Group.__init__(self, 40537, 40538, order)

		class NoLegAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41336
				order[1] = 41337
				order[2] = 41316
				order[3] = 0
				fix.Group.__init__(self, 41335, 41336, order)

			class NoLegAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41317
					order[1] = 41318
					order[2] = 41319
					order[3] = 41320
					order[4] = 41321
					order[5] = 41322
					order[6] = 41323
					order[7] = 41324
					order[8] = 41325
					order[9] = 41326
					order[10] = 41327
					order[11] = 41328
					order[12] = 41329
					order[13] = 41330
					order[14] = 41331
					order[15] = 41332
					order[16] = 41333
					order[17] = 41334
					order[18] = 0
					fix.Group.__init__(self, 41316, 41317, order)

		class NoLegProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 41618
				order[1] = 41619
				order[2] = 41620
				order[3] = 41621
				order[4] = 41622
				order[5] = 41623
				order[6] = 41624
				order[7] = 41614
				order[8] = 41625
				order[9] = 41635
				order[10] = 41617
				order[11] = 0
				fix.Group.__init__(self, 41616, 41618, order)

			class NoLegProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41615
					order[1] = 0
					fix.Group.__init__(self, 41614, 41615, order)

			class NoLegProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41626
					order[1] = 41627
					order[2] = 41628
					order[3] = 41629
					order[4] = 41630
					order[5] = 41631
					order[6] = 41632
					order[7] = 41633
					order[8] = 0
					fix.Group.__init__(self, 41625, 41626, order)

				class NoLegProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41634
						order[1] = 0
						fix.Group.__init__(self, 41633, 41634, order)

			class NoLegProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41636
					order[1] = 41637
					order[2] = 0
					fix.Group.__init__(self, 41635, 41636, order)

		class NoLegCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 41345
				order[1] = 41346
				order[2] = 41347
				order[3] = 41348
				order[4] = 41349
				order[5] = 41350
				order[6] = 41351
				order[7] = 41352
				order[8] = 41353
				order[9] = 41354
				order[10] = 41355
				order[11] = 41342
				order[12] = 42308
				order[13] = 42309
				order[14] = 41356
				order[15] = 41357
				order[16] = 42299
				order[17] = 42300
				order[18] = 42301
				order[19] = 42302
				order[20] = 42303
				order[21] = 42304
				order[22] = 42305
				order[23] = 41358
				order[24] = 41359
				order[25] = 41360
				order[26] = 41361
				order[27] = 41362
				order[28] = 0
				fix.Group.__init__(self, 41344, 41345, order)

			class NoLegCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41343
					order[1] = 0
					fix.Group.__init__(self, 41342, 41343, order)

			class NoLegCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42307
					order[1] = 0
					fix.Group.__init__(self, 42306, 42307, order)

		class NoLegPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41604
				order[1] = 41601
				order[2] = 41602
				order[3] = 41603
				order[4] = 41600
				order[5] = 0
				fix.Group.__init__(self, 41599, 41604, order)

			class NoLegPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41605
					order[1] = 41606
					order[2] = 0
					fix.Group.__init__(self, 41604, 41605, order)

		class NoLegExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42389
				order[1] = 42390
				order[2] = 0
				fix.Group.__init__(self, 42388, 42389, order)

		class NoLegContractualDefinitions(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42199
				order[1] = 0
				fix.Group.__init__(self, 42198, 42199, order)

		class NoLegFinancingTermSupplements(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42201
				order[1] = 42202
				order[2] = 0
				fix.Group.__init__(self, 42200, 42201, order)

		class NoLegContractualMatrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 42204
				order[1] = 42205
				order[2] = 42206
				order[3] = 0
				fix.Group.__init__(self, 42203, 42204, order)

	class NoUnderlyings(fix.Group):
		def __init__(self):
			order = fix.IntArray(188)
			order[0] = 311
			order[1] = 312
			order[2] = 309
			order[3] = 305
			order[4] = 2874
			order[5] = 462
			order[6] = 463
			order[7] = 2894
			order[8] = 310
			order[9] = 763
			order[10] = 313
			order[11] = 542
			order[12] = 1213
			order[13] = 1837
			order[14] = 241
			order[15] = 1453
			order[16] = 1454
			order[17] = 2614
			order[18] = 2615
			order[19] = 2921
			order[20] = 2616
			order[21] = 2617
			order[22] = 2619
			order[23] = 1455
			order[24] = 1456
			order[25] = 1459
			order[26] = 1460
			order[27] = 242
			order[28] = 243
			order[29] = 244
			order[30] = 245
			order[31] = 246
			order[32] = 256
			order[33] = 595
			order[34] = 592
			order[35] = 593
			order[36] = 594
			order[37] = 247
			order[38] = 316
			order[39] = 941
			order[40] = 2917
			order[41] = 317
			order[42] = 436
			order[43] = 1437
			order[44] = 2363
			order[45] = 1441
			order[46] = 998
			order[47] = 1423
			order[48] = 1718
			order[49] = 2918
			order[50] = 1424
			order[51] = 1425
			order[52] = 1719
			order[53] = 2919
			order[54] = 1000
			order[55] = 1419
			order[56] = 1526
			order[57] = 2920
			order[58] = 435
			order[59] = 308
			order[60] = 306
			order[61] = 362
			order[62] = 363
			order[63] = 2742
			order[64] = 2720
			order[65] = 2721
			order[66] = 2722
			order[67] = 2723
			order[68] = 2724
			order[69] = 307
			order[70] = 364
			order[71] = 365
			order[72] = 877
			order[73] = 878
			order[74] = 972
			order[75] = 318
			order[76] = 2916
			order[77] = 879
			order[78] = 975
			order[79] = 973
			order[80] = 974
			order[81] = 810
			order[82] = 882
			order[83] = 883
			order[84] = 884
			order[85] = 885
			order[86] = 886
			order[87] = 2885
			order[88] = 2886
			order[89] = 1044
			order[90] = 1045
			order[91] = 1046
			order[92] = 1038
			order[93] = 1039
			order[94] = 315
			order[95] = 2683
			order[96] = 2687
			order[97] = 1988
			order[98] = 1989
			order[99] = 1990
			order[100] = 1991
			order[101] = 1992
			order[102] = 1993
			order[103] = 2881
			order[104] = 1994
			order[105] = 1995
			order[106] = 1996
			order[107] = 1997
			order[108] = 2620
			order[109] = 2621
			order[110] = 1998
			order[111] = 1999
			order[112] = 2000
			order[113] = 2003
			order[114] = 2004
			order[115] = 2005
			order[116] = 2006
			order[117] = 2284
			order[118] = 2285
			order[119] = 2286
			order[120] = 2287
			order[121] = 2288
			order[122] = 2007
			order[123] = 2008
			order[124] = 2009
			order[125] = 2010
			order[126] = 2011
			order[127] = 2012
			order[128] = 2491
			order[129] = 2013
			order[130] = 2014
			order[131] = 2015
			order[132] = 2744
			order[133] = 2016
			order[134] = 2289
			order[135] = 2017
			order[136] = 2018
			order[137] = 2019
			order[138] = 2020
			order[139] = 2021
			order[140] = 2022
			order[141] = 2290
			order[142] = 2622
			order[143] = 2291
			order[144] = 2623
			order[145] = 2292
			order[146] = 2023
			order[147] = 2024
			order[148] = 2025
			order[149] = 2026
			order[150] = 2027
			order[151] = 2028
			order[152] = 2029
			order[153] = 2757
			order[154] = 2030
			order[155] = 2031
			order[156] = 2293
			order[157] = 2294
			order[158] = 2032
			order[159] = 2033
			order[160] = 2034
			order[161] = 2035
			order[162] = 2036
			order[163] = 2037
			order[164] = 2038
			order[165] = 2039
			order[166] = 2040
			order[167] = 2041
			order[168] = 2042
			order[169] = 2043
			order[170] = 2044
			order[171] = 41314
			order[172] = 41315
			order[173] = 2295
			order[174] = 2296
			order[175] = 2297
			order[176] = 2756
			order[177] = 2298
			order[178] = 2299
			order[179] = 2624
			order[180] = 2625
			order[181] = 2626
			order[182] = 2627
			order[183] = 2628
			order[184] = 2629
			order[185] = 2630
			order[186] = 2631
			order[187] = 0
			fix.Group.__init__(self, 711, 311, order)

		class NoUnderlyingSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 458
				order[1] = 459
				order[2] = 2959
				order[3] = 0
				fix.Group.__init__(self, 457, 458, order)

		class NoUnderlyingStips(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 888
				order[1] = 889
				order[2] = 0
				fix.Group.__init__(self, 887, 888, order)

		class NoUndlyInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1059
				order[1] = 1060
				order[2] = 1061
				order[3] = 2391
				order[4] = 1062
				order[5] = 0
				fix.Group.__init__(self, 1058, 1059, order)

			class NoUndlyInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1063
					order[1] = 1064
					order[2] = 0
					fix.Group.__init__(self, 1062, 1063, order)

		class NoUnderlyingEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 1982
				order[1] = 1983
				order[2] = 1984
				order[3] = 1985
				order[4] = 1986
				order[5] = 2342
				order[6] = 1987
				order[7] = 2071
				order[8] = 2072
				order[9] = 2073
				order[10] = 0
				fix.Group.__init__(self, 1981, 1982, order)

		class NoUnderlyingSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2081
				order[1] = 2082
				order[2] = 2083
				order[3] = 2745
				order[4] = 0
				fix.Group.__init__(self, 2080, 2081, order)

		class NoUnderlyingAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2313
				order[1] = 2314
				order[2] = 2315
				order[3] = 0
				fix.Group.__init__(self, 2312, 2313, order)

		class NoUnderlyingComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2046
				order[1] = 2261
				order[2] = 2262
				order[3] = 2263
				order[4] = 2047
				order[5] = 2264
				order[6] = 2265
				order[7] = 2266
				order[8] = 2947
				order[9] = 2048
				order[10] = 2267
				order[11] = 2049
				order[12] = 2050
				order[13] = 2051
				order[14] = 2052
				order[15] = 2053
				order[16] = 2268
				order[17] = 2948
				order[18] = 2269
				order[19] = 2949
				order[20] = 2270
				order[21] = 2271
				order[22] = 2419
				order[23] = 2420
				order[24] = 2272
				order[25] = 2273
				order[26] = 2274
				order[27] = 2275
				order[28] = 2276
				order[29] = 41732
				order[30] = 41739
				order[31] = 41740
				order[32] = 41741
				order[33] = 41742
				order[34] = 41743
				order[35] = 41744
				order[36] = 41745
				order[37] = 41746
				order[38] = 41747
				order[39] = 41729
				order[40] = 2277
				order[41] = 2278
				order[42] = 2279
				order[43] = 2280
				order[44] = 2281
				order[45] = 41748
				order[46] = 41716
				order[47] = 2611
				order[48] = 2612
				order[49] = 2613
				order[50] = 2282
				order[51] = 2283
				order[52] = 0
				fix.Group.__init__(self, 2045, 2046, order)

			class NoUnderlyingComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2054
					order[1] = 2055
					order[2] = 2056
					order[3] = 0
					fix.Group.__init__(self, 2053, 2054, order)

				class NoUnderlyingComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2057
						order[1] = 2058
						order[2] = 0
						fix.Group.__init__(self, 2056, 2057, order)

			class NoUnderlyingComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41733
					order[1] = 41734
					order[2] = 41735
					order[3] = 41736
					order[4] = 0
					fix.Group.__init__(self, 41732, 41733, order)

			class NoUnderlyingComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41738
					order[1] = 0
					fix.Group.__init__(self, 41737, 41738, order)

			class NoUnderlyingComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41730
					order[1] = 41731
					order[2] = 41750
					order[3] = 41726
					order[4] = 41713
					order[5] = 0
					fix.Group.__init__(self, 41729, 41730, order)

				class NoUnderlyingComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41751
						order[1] = 41752
						order[2] = 41753
						order[3] = 41754
						order[4] = 41755
						order[5] = 0
						fix.Group.__init__(self, 41750, 41751, order)

				class NoUnderlyingComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41727
						order[1] = 41728
						order[2] = 0
						fix.Group.__init__(self, 41726, 41727, order)

				class NoUnderlyingComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41714
						order[1] = 41715
						order[2] = 0
						fix.Group.__init__(self, 41713, 41714, order)

			class NoUnderlyingComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41749
					order[1] = 0
					fix.Group.__init__(self, 41748, 41749, order)

			class NoUnderlyingComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41717
					order[1] = 41718
					order[2] = 41719
					order[3] = 41720
					order[4] = 41721
					order[5] = 41722
					order[6] = 41723
					order[7] = 41724
					order[8] = 0
					fix.Group.__init__(self, 41716, 41717, order)

				class NoUnderlyingComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41725
						order[1] = 0
						fix.Group.__init__(self, 41724, 41725, order)

		class NoUnderlyingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40963
				order[1] = 0
				fix.Group.__init__(self, 40962, 40963, order)

		class NoUnderlyingPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41948
				order[1] = 0
				fix.Group.__init__(self, 41947, 41948, order)

		class NoUnderlyingMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41865
				order[1] = 41338
				order[2] = 0
				fix.Group.__init__(self, 41864, 41865, order)

		class NoUnderlyingMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41867
				order[1] = 41339
				order[2] = 0
				fix.Group.__init__(self, 41866, 41867, order)

		class NoUnderlyingMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41869
				order[1] = 41870
				order[2] = 41871
				order[3] = 41872
				order[4] = 41873
				order[5] = 41874
				order[6] = 41875
				order[7] = 41876
				order[8] = 41877
				order[9] = 0
				fix.Group.__init__(self, 41868, 41869, order)

		class NoUnderlyingSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 43075
				order[1] = 0
				fix.Group.__init__(self, 43074, 43075, order)

		class NoUnderlyingOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41821
				order[1] = 0
				fix.Group.__init__(self, 41820, 41821, order)

		class NoUnderlyingOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41842
				order[1] = 41843
				order[2] = 0
				fix.Group.__init__(self, 41841, 41842, order)

		class NoUnderlyingOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41845
				order[1] = 0
				fix.Group.__init__(self, 41844, 41845, order)

		class NoUnderlyingOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41857
				order[1] = 41858
				order[2] = 0
				fix.Group.__init__(self, 41856, 41857, order)

		class NoUnderlyingStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40541
				order[1] = 42016
				order[2] = 40542
				order[3] = 43083
				order[4] = 43084
				order[5] = 40543
				order[6] = 40544
				order[7] = 42018
				order[8] = 40545
				order[9] = 40546
				order[10] = 43085
				order[11] = 43086
				order[12] = 42019
				order[13] = 42020
				order[14] = 42021
				order[15] = 42022
				order[16] = 42023
				order[17] = 42024
				order[18] = 41964
				order[19] = 41965
				order[20] = 41966
				order[21] = 41967
				order[22] = 41968
				order[23] = 41969
				order[24] = 41970
				order[25] = 42589
				order[26] = 41971
				order[27] = 41972
				order[28] = 41973
				order[29] = 41974
				order[30] = 41975
				order[31] = 41976
				order[32] = 41977
				order[33] = 41978
				order[34] = 41979
				order[35] = 41980
				order[36] = 41981
				order[37] = 41982
				order[38] = 41983
				order[39] = 41984
				order[40] = 41985
				order[41] = 41986
				order[42] = 41987
				order[43] = 41988
				order[44] = 41989
				order[45] = 40057
				order[46] = 40058
				order[47] = 40060
				order[48] = 40061
				order[49] = 40062
				order[50] = 40063
				order[51] = 40064
				order[52] = 40548
				order[53] = 40549
				order[54] = 40551
				order[55] = 40552
				order[56] = 40553
				order[57] = 40554
				order[58] = 40555
				order[59] = 41957
				order[60] = 41958
				order[61] = 40556
				order[62] = 40558
				order[63] = 40559
				order[64] = 40561
				order[65] = 40562
				order[66] = 40563
				order[67] = 40564
				order[68] = 40565
				order[69] = 40566
				order[70] = 40567
				order[71] = 41959
				order[72] = 41960
				order[73] = 41961
				order[74] = 40568
				order[75] = 40569
				order[76] = 40570
				order[77] = 42895
				order[78] = 40571
				order[79] = 40572
				order[80] = 43107
				order[81] = 40573
				order[82] = 40574
				order[83] = 40575
				order[84] = 40576
				order[85] = 40577
				order[86] = 42896
				order[87] = 42897
				order[88] = 42898
				order[89] = 42899
				order[90] = 40578
				order[91] = 40579
				order[92] = 40580
				order[93] = 41897
				order[94] = 41898
				order[95] = 41899
				order[96] = 41900
				order[97] = 41901
				order[98] = 41902
				order[99] = 41903
				order[100] = 42900
				order[101] = 40664
				order[102] = 40708
				order[103] = 41777
				order[104] = 41778
				order[105] = 41779
				order[106] = 41780
				order[107] = 41781
				order[108] = 42196
				order[109] = 42197
				order[110] = 41782
				order[111] = 41783
				order[112] = 41784
				order[113] = 41785
				order[114] = 41786
				order[115] = 41587
				order[116] = 41787
				order[117] = 41788
				order[118] = 41789
				order[119] = 41790
				order[120] = 41791
				order[121] = 41792
				order[122] = 41793
				order[123] = 41794
				order[124] = 41795
				order[125] = 41796
				order[126] = 41797
				order[127] = 41798
				order[128] = 41799
				order[129] = 43096
				order[130] = 41756
				order[131] = 40547
				order[132] = 40988
				order[133] = 40989
				order[134] = 0
				fix.Group.__init__(self, 40540, 40541, order)

			class NoUnderlyingStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41991
					order[1] = 41992
					order[2] = 0
					fix.Group.__init__(self, 41990, 41991, order)

			class NoUnderlyingStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41801
					order[1] = 41802
					order[2] = 41803
					order[3] = 0
					fix.Group.__init__(self, 41800, 41801, order)

			class NoUnderlyingStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41994
					order[1] = 41995
					order[2] = 0
					fix.Group.__init__(self, 41993, 41994, order)

			class NoUnderlyingStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41963
					order[1] = 0
					fix.Group.__init__(self, 41962, 41963, order)

			class NoUnderlyingStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 42003
					order[1] = 42004
					order[2] = 42005
					order[3] = 42006
					order[4] = 42007
					order[5] = 42008
					order[6] = 42009
					order[7] = 42010
					order[8] = 42011
					order[9] = 42012
					order[10] = 42013
					order[11] = 41996
					order[12] = 42014
					order[13] = 42015
					order[14] = 0
					fix.Group.__init__(self, 42002, 42003, order)

				class NoUnderlyingStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41997
						order[1] = 41998
						order[2] = 41999
						order[3] = 0
						fix.Group.__init__(self, 41996, 41997, order)

					class NoUnderlyingStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 42000
							order[1] = 42001
							order[2] = 41936
							order[3] = 0
							fix.Group.__init__(self, 41999, 42000, order)

			class NoUnderlyingStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40059
					order[1] = 0
					fix.Group.__init__(self, 40975, 40059, order)

			class NoUnderlyingStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40550
					order[1] = 0
					fix.Group.__init__(self, 40976, 40550, order)

			class NoUnderlyingStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40557
					order[1] = 0
					fix.Group.__init__(self, 40973, 40557, order)

			class NoUnderlyingStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41955
					order[1] = 41956
					order[2] = 0
					fix.Group.__init__(self, 41954, 41955, order)

			class NoUnderlyingStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40560
					order[1] = 0
					fix.Group.__init__(self, 40974, 40560, order)

			class NoUnderlyingPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40582
					order[1] = 0
					fix.Group.__init__(self, 40969, 40582, order)

			class NoUnderlyingPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41938
					order[1] = 41939
					order[2] = 0
					fix.Group.__init__(self, 41937, 41938, order)

			class NoUnderlyingPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40594
					order[1] = 0
					fix.Group.__init__(self, 40970, 40594, order)

			class NoUnderlyingPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40600
					order[1] = 0
					fix.Group.__init__(self, 40971, 40600, order)

			class NoUnderlyingPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40607
					order[1] = 0
					fix.Group.__init__(self, 40972, 40607, order)

			class NoUnderlyingPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42956
					order[1] = 42957
					order[2] = 0
					fix.Group.__init__(self, 42955, 42956, order)

			class NoUnderlyingPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41910
					order[1] = 0
					fix.Group.__init__(self, 41909, 41910, order)

			class NoUnderlyingPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41945
					order[1] = 41946
					order[2] = 0
					fix.Group.__init__(self, 41944, 41945, order)

			class NoUnderlyingPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41942
					order[1] = 41943
					order[2] = 0
					fix.Group.__init__(self, 41941, 41942, order)

			class NoUnderlyingPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43111
					order[1] = 42982
					order[2] = 42983
					order[3] = 0
					fix.Group.__init__(self, 42981, 43111, order)

			class NoUnderlyingDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42863
					order[1] = 42864
					order[2] = 42865
					order[3] = 42866
					order[4] = 42867
					order[5] = 42868
					order[6] = 42882
					order[7] = 42869
					order[8] = 42870
					order[9] = 42871
					order[10] = 42872
					order[11] = 42873
					order[12] = 42874
					order[13] = 42875
					order[14] = 42876
					order[15] = 42877
					order[16] = 42878
					order[17] = 42879
					order[18] = 42880
					order[19] = 42881
					order[20] = 0
					fix.Group.__init__(self, 42862, 42863, order)

				class NoUnderlyingDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42883
						order[1] = 0
						fix.Group.__init__(self, 42882, 42883, order)

			class NoUnderlyingDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42854
					order[1] = 0
					fix.Group.__init__(self, 42853, 42854, order)

			class NoUnderlyingDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42800
					order[1] = 0
					fix.Group.__init__(self, 42799, 42800, order)

			class NoUnderlyingReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 43035
					order[1] = 43036
					order[2] = 43037
					order[3] = 43038
					order[4] = 43039
					order[5] = 43040
					order[6] = 43064
					order[7] = 43030
					order[8] = 43041
					order[9] = 43042
					order[10] = 43043
					order[11] = 43044
					order[12] = 43045
					order[13] = 43046
					order[14] = 43047
					order[15] = 43048
					order[16] = 43049
					order[17] = 43050
					order[18] = 43051
					order[19] = 43052
					order[20] = 43060
					order[21] = 43053
					order[22] = 43054
					order[23] = 43008
					order[24] = 43055
					order[25] = 43056
					order[26] = 43057
					order[27] = 43058
					order[28] = 43059
					order[29] = 0
					fix.Group.__init__(self, 43034, 43035, order)

				class NoUnderlyingReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 43065
						order[1] = 43066
						order[2] = 43067
						order[3] = 43068
						order[4] = 0
						fix.Group.__init__(self, 43064, 43065, order)

				class NoUnderlyingReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43031
						order[1] = 43032
						order[2] = 43033
						order[3] = 0
						fix.Group.__init__(self, 43030, 43031, order)

				class NoUnderlyingReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43061
						order[1] = 43062
						order[2] = 43063
						order[3] = 0
						fix.Group.__init__(self, 43060, 43061, order)

				class NoUnderlyingReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 43009
						order[1] = 43071
						order[2] = 43010
						order[3] = 43011
						order[4] = 43012
						order[5] = 43013
						order[6] = 43014
						order[7] = 43015
						order[8] = 43016
						order[9] = 43017
						order[10] = 43018
						order[11] = 43019
						order[12] = 43020
						order[13] = 43021
						order[14] = 43022
						order[15] = 43023
						order[16] = 43024
						order[17] = 43025
						order[18] = 43026
						order[19] = 43027
						order[20] = 43028
						order[21] = 43029
						order[22] = 43069
						order[23] = 0
						fix.Group.__init__(self, 43008, 43009, order)

					class NoUnderlyingReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 43072
							order[1] = 43073
							order[2] = 0
							fix.Group.__init__(self, 43071, 43072, order)

					class NoUnderlyingReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 43070
							order[1] = 0
							fix.Group.__init__(self, 43069, 43070, order)

			class NoUnderlyingPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42916
					order[1] = 0
					fix.Group.__init__(self, 42915, 42916, order)

			class NoUnderlyingPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42902
					order[1] = 42903
					order[2] = 0
					fix.Group.__init__(self, 42901, 42902, order)

			class NoUnderlyingPaymentStreamNonDeliverableFixingDatesBizCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40650
					order[1] = 0
					fix.Group.__init__(self, 40968, 40650, order)

			class NoUnderlyingNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40657
					order[1] = 40658
					order[2] = 0
					fix.Group.__init__(self, 40656, 40657, order)

			class NoUnderlyingSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40660
					order[1] = 40904
					order[2] = 40915
					order[3] = 40662
					order[4] = 40663
					order[5] = 0
					fix.Group.__init__(self, 40659, 40660, order)

			class NoUnderlyingPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40665
					order[1] = 41881
					order[2] = 41882
					order[3] = 40666
					order[4] = 40667
					order[5] = 40668
					order[6] = 40669
					order[7] = 40670
					order[8] = 40671
					order[9] = 40672
					order[10] = 40673
					order[11] = 40674
					order[12] = 40675
					order[13] = 41883
					order[14] = 41884
					order[15] = 41885
					order[16] = 41886
					order[17] = 40676
					order[18] = 40677
					order[19] = 40678
					order[20] = 40679
					order[21] = 41887
					order[22] = 41888
					order[23] = 41889
					order[24] = 41890
					order[25] = 40680
					order[26] = 40681
					order[27] = 40682
					order[28] = 40683
					order[29] = 40684
					order[30] = 40685
					order[31] = 40704
					order[32] = 40686
					order[33] = 40687
					order[34] = 40688
					order[35] = 40689
					order[36] = 40966
					order[37] = 40691
					order[38] = 40692
					order[39] = 40693
					order[40] = 41891
					order[41] = 41892
					order[42] = 40694
					order[43] = 41878
					order[44] = 41893
					order[45] = 41894
					order[46] = 41895
					order[47] = 41896
					order[48] = 40695
					order[49] = 40696
					order[50] = 40697
					order[51] = 40698
					order[52] = 40967
					order[53] = 40700
					order[54] = 40701
					order[55] = 40702
					order[56] = 40703
					order[57] = 0
					fix.Group.__init__(self, 40664, 40665, order)

				class NoUnderlyingPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40705
						order[1] = 40706
						order[2] = 40707
						order[3] = 0
						fix.Group.__init__(self, 40704, 40705, order)

				class NoUnderlyingPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40690
						order[1] = 0
						fix.Group.__init__(self, 40966, 40690, order)

				class NoUnderlyingPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41879
						order[1] = 41880
						order[2] = 0
						fix.Group.__init__(self, 41878, 41879, order)

				class NoUnderlyingPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40699
						order[1] = 0
						fix.Group.__init__(self, 40967, 40699, order)

			class NoUnderlyingPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40709
					order[1] = 40710
					order[2] = 42993
					order[3] = 42994
					order[4] = 42995
					order[5] = 42996
					order[6] = 42997
					order[7] = 42998
					order[8] = 42999
					order[9] = 42984
					order[10] = 42985
					order[11] = 42986
					order[12] = 42987
					order[13] = 42988
					order[14] = 42989
					order[15] = 42990
					order[16] = 40711
					order[17] = 40712
					order[18] = 40713
					order[19] = 40714
					order[20] = 40715
					order[21] = 40716
					order[22] = 40717
					order[23] = 40718
					order[24] = 40719
					order[25] = 40720
					order[26] = 40721
					order[27] = 40722
					order[28] = 40723
					order[29] = 40724
					order[30] = 40725
					order[31] = 40726
					order[32] = 40727
					order[33] = 40728
					order[34] = 40729
					order[35] = 40730
					order[36] = 40731
					order[37] = 40732
					order[38] = 40733
					order[39] = 40734
					order[40] = 40735
					order[41] = 40736
					order[42] = 40737
					order[43] = 0
					fix.Group.__init__(self, 40708, 40709, order)

				class NoUnderlyingPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 43001
						order[1] = 0
						fix.Group.__init__(self, 43000, 43001, order)

				class NoUnderlyingPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42992
						order[1] = 0
						fix.Group.__init__(self, 42991, 42992, order)

			class NoUnderlyingDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41809
					order[1] = 0
					fix.Group.__init__(self, 41808, 41809, order)

			class NoUnderlyingDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41805
					order[1] = 41806
					order[2] = 41807
					order[3] = 0
					fix.Group.__init__(self, 41804, 41805, order)

			class NoUnderlyingDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41757
					order[1] = 41758
					order[2] = 41759
					order[3] = 41760
					order[4] = 41761
					order[5] = 41762
					order[6] = 41763
					order[7] = 41764
					order[8] = 41765
					order[9] = 41766
					order[10] = 41767
					order[11] = 41768
					order[12] = 41769
					order[13] = 41770
					order[14] = 0
					fix.Group.__init__(self, 41756, 41757, order)

				class NoUnderlyingDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41771
						order[1] = 41772
						order[2] = 41773
						order[3] = 0
						fix.Group.__init__(self, 41770, 41771, order)

					class NoUnderlyingDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41774
							order[1] = 41775
							order[2] = 41776
							order[3] = 0
							fix.Group.__init__(self, 41773, 41774, order)

		class NoUnderlyingProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 42150
				order[1] = 42151
				order[2] = 42152
				order[3] = 42190
				order[4] = 42153
				order[5] = 42154
				order[6] = 42155
				order[7] = 43002
				order[8] = 43003
				order[9] = 42156
				order[10] = 42157
				order[11] = 42158
				order[12] = 42104
				order[13] = 42105
				order[14] = 42106
				order[15] = 42107
				order[16] = 42108
				order[17] = 42109
				order[18] = 42110
				order[19] = 42111
				order[20] = 42115
				order[21] = 42116
				order[22] = 42117
				order[23] = 42118
				order[24] = 42119
				order[25] = 42120
				order[26] = 42121
				order[27] = 42122
				order[28] = 42123
				order[29] = 42124
				order[30] = 42125
				order[31] = 42126
				order[32] = 42127
				order[33] = 42128
				order[34] = 42129
				order[35] = 42130
				order[36] = 42131
				order[37] = 42132
				order[38] = 42133
				order[39] = 42134
				order[40] = 42135
				order[41] = 42136
				order[42] = 42137
				order[43] = 42138
				order[44] = 42139
				order[45] = 42140
				order[46] = 42141
				order[47] = 42142
				order[48] = 42143
				order[49] = 42144
				order[50] = 42145
				order[51] = 42146
				order[52] = 42147
				order[53] = 42148
				order[54] = 42159
				order[55] = 42160
				order[56] = 42161
				order[57] = 42162
				order[58] = 42163
				order[59] = 42164
				order[60] = 42165
				order[61] = 42092
				order[62] = 42093
				order[63] = 42094
				order[64] = 42095
				order[65] = 42096
				order[66] = 42097
				order[67] = 42098
				order[68] = 42166
				order[69] = 42167
				order[70] = 42168
				order[71] = 42169
				order[72] = 42102
				order[73] = 42103
				order[74] = 42170
				order[75] = 42171
				order[76] = 42172
				order[77] = 42173
				order[78] = 0
				fix.Group.__init__(self, 42149, 42150, order)

			class NoUnderlyingProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42191
					order[1] = 0
					fix.Group.__init__(self, 42190, 42191, order)

			class NoUnderlyingProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42183
					order[1] = 0
					fix.Group.__init__(self, 42182, 42183, order)

			class NoUnderlyingProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42185
					order[1] = 0
					fix.Group.__init__(self, 42184, 42185, order)

			class NoUnderlyingProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42113
					order[1] = 42114
					order[2] = 0
					fix.Group.__init__(self, 42112, 42113, order)

			class NoUnderlyingProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42187
					order[1] = 0
					fix.Group.__init__(self, 42186, 42187, order)

			class NoUnderlyingProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42189
					order[1] = 0
					fix.Group.__init__(self, 42188, 42189, order)

			class NoUnderlyingProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42181
					order[1] = 0
					fix.Group.__init__(self, 42180, 42181, order)

			class NoUnderlyingProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42100
					order[1] = 42101
					order[2] = 0
					fix.Group.__init__(self, 42099, 42100, order)

			class NoUnderlyingProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 42174
					order[1] = 42175
					order[2] = 42176
					order[3] = 40918
					order[4] = 42177
					order[5] = 0
					fix.Group.__init__(self, 42173, 42174, order)

				class NoUnderlyingProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42178
						order[1] = 42179
						order[2] = 0
						fix.Group.__init__(self, 42177, 42178, order)

		class NoUnderlyingAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 42037
				order[1] = 42038
				order[2] = 41340
				order[3] = 0
				fix.Group.__init__(self, 42036, 42037, order)

			class NoUnderlyingAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41341
					order[1] = 41701
					order[2] = 41709
					order[3] = 41710
					order[4] = 41711
					order[5] = 41712
					order[6] = 42017
					order[7] = 42025
					order[8] = 42026
					order[9] = 42027
					order[10] = 42028
					order[11] = 42029
					order[12] = 42030
					order[13] = 42031
					order[14] = 42032
					order[15] = 42033
					order[16] = 42034
					order[17] = 42035
					order[18] = 0
					fix.Group.__init__(self, 41340, 41341, order)

		class NoUnderlyingProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 42069
				order[1] = 42070
				order[2] = 42071
				order[3] = 42072
				order[4] = 42073
				order[5] = 42074
				order[6] = 42075
				order[7] = 42090
				order[8] = 42077
				order[9] = 42087
				order[10] = 42076
				order[11] = 0
				fix.Group.__init__(self, 42068, 42069, order)

			class NoUnderlyingProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42091
					order[1] = 0
					fix.Group.__init__(self, 42090, 42091, order)

			class NoUnderlyingProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 42078
					order[1] = 42079
					order[2] = 42080
					order[3] = 42081
					order[4] = 42082
					order[5] = 42083
					order[6] = 42084
					order[7] = 42085
					order[8] = 0
					fix.Group.__init__(self, 42077, 42078, order)

				class NoUnderlyingProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42086
						order[1] = 0
						fix.Group.__init__(self, 42085, 42086, order)

			class NoUnderlyingProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42088
					order[1] = 42089
					order[2] = 0
					fix.Group.__init__(self, 42087, 42088, order)

		class NoUnderlyingCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 42042
				order[1] = 42043
				order[2] = 42044
				order[3] = 42045
				order[4] = 42046
				order[5] = 42047
				order[6] = 42048
				order[7] = 42049
				order[8] = 42050
				order[9] = 42051
				order[10] = 42052
				order[11] = 42039
				order[12] = 42797
				order[13] = 42798
				order[14] = 42053
				order[15] = 42054
				order[16] = 42790
				order[17] = 42791
				order[18] = 42792
				order[19] = 42793
				order[20] = 42794
				order[21] = 42795
				order[22] = 42796
				order[23] = 42055
				order[24] = 42056
				order[25] = 42057
				order[26] = 42058
				order[27] = 42059
				order[28] = 0
				fix.Group.__init__(self, 42041, 42042, order)

			class NoUnderlyingCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42040
					order[1] = 0
					fix.Group.__init__(self, 42039, 42040, order)

			class NoUnderlyingCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42789
					order[1] = 0
					fix.Group.__init__(self, 42788, 42789, order)

		class NoUnderlyingPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 42065
				order[1] = 42061
				order[2] = 42062
				order[3] = 42063
				order[4] = 42064
				order[5] = 0
				fix.Group.__init__(self, 42060, 42065, order)

			class NoUnderlyingPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42066
					order[1] = 42067
					order[2] = 0
					fix.Group.__init__(self, 42065, 42066, order)

		class NoUnderlyingRateSpreadSteps(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 43006
				order[1] = 43007
				order[2] = 0
				fix.Group.__init__(self, 43005, 43006, order)

		class NoUnderlyingDividendPayments(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 42856
				order[1] = 42857
				order[2] = 42858
				order[3] = 42859
				order[4] = 0
				fix.Group.__init__(self, 42855, 42856, order)

		class NoUnderlyingExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42885
				order[1] = 42886
				order[2] = 0
				fix.Group.__init__(self, 42884, 42885, order)

	class NoLinesOfText(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 58
			order[1] = 354
			order[2] = 355
			order[3] = 0
			fix.Group.__init__(self, 33, 58, order)

class Email(Message):
	def __init__(self):
		Message.__init__(self)
		self.getHeader().setField( fix.MsgType("C") )

	class NoRoutingIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 216
			order[1] = 217
			order[2] = 0
			fix.Group.__init__(self, 215, 216, order)

	class NoRelatedSym(fix.Group):
		def __init__(self):
			order = fix.IntArray(183)
			order[0] = 55
			order[1] = 65
			order[2] = 48
			order[3] = 22
			order[4] = 460
			order[5] = 1227
			order[6] = 1151
			order[7] = 461
			order[8] = 2891
			order[9] = 167
			order[10] = 762
			order[11] = 200
			order[12] = 541
			order[13] = 1079
			order[14] = 966
			order[15] = 1049
			order[16] = 965
			order[17] = 224
			order[18] = 1449
			order[19] = 1450
			order[20] = 1451
			order[21] = 1452
			order[22] = 1457
			order[23] = 1458
			order[24] = 1739
			order[25] = 2210
			order[26] = 1938
			order[27] = 1939
			order[28] = 1940
			order[29] = 2735
			order[30] = 1941
			order[31] = 1575
			order[32] = 1942
			order[33] = 1943
			order[34] = 1944
			order[35] = 1945
			order[36] = 1946
			order[37] = 1947
			order[38] = 1948
			order[39] = 1949
			order[40] = 1950
			order[41] = 2879
			order[42] = 1951
			order[43] = 1952
			order[44] = 1953
			order[45] = 1954
			order[46] = 1955
			order[47] = 1956
			order[48] = 1957
			order[49] = 1958
			order[50] = 1959
			order[51] = 1960
			order[52] = 1577
			order[53] = 1580
			order[54] = 1581
			order[55] = 1678
			order[56] = 1697
			order[57] = 225
			order[58] = 239
			order[59] = 226
			order[60] = 227
			order[61] = 228
			order[62] = 255
			order[63] = 543
			order[64] = 470
			order[65] = 471
			order[66] = 472
			order[67] = 240
			order[68] = 202
			order[69] = 2578
			order[70] = 2577
			order[71] = 947
			order[72] = 2904
			order[73] = 967
			order[74] = 968
			order[75] = 1698
			order[76] = 1866
			order[77] = 2600
			order[78] = 2001
			order[79] = 2601
			order[80] = 1478
			order[81] = 1479
			order[82] = 1480
			order[83] = 1481
			order[84] = 206
			order[85] = 231
			order[86] = 1435
			order[87] = 2353
			order[88] = 1439
			order[89] = 969
			order[90] = 1146
			order[91] = 996
			order[92] = 1147
			order[93] = 1716
			order[94] = 2905
			order[95] = 1191
			order[96] = 1192
			order[97] = 1717
			order[98] = 2906
			order[99] = 1193
			order[100] = 2579
			order[101] = 1194
			order[102] = 1482
			order[103] = 1195
			order[104] = 2753
			order[105] = 1196
			order[106] = 1197
			order[107] = 2002
			order[108] = 2140
			order[109] = 1524
			order[110] = 2907
			order[111] = 1198
			order[112] = 1199
			order[113] = 1200
			order[114] = 201
			order[115] = 2681
			order[116] = 2685
			order[117] = 1244
			order[118] = 1242
			order[119] = 2575
			order[120] = 2574
			order[121] = 997
			order[122] = 223
			order[123] = 207
			order[124] = 970
			order[125] = 971
			order[126] = 106
			order[127] = 348
			order[128] = 349
			order[129] = 2737
			order[130] = 2714
			order[131] = 2715
			order[132] = 2716
			order[133] = 107
			order[134] = 350
			order[135] = 351
			order[136] = 691
			order[137] = 667
			order[138] = 875
			order[139] = 876
			order[140] = 873
			order[141] = 874
			order[142] = 1687
			order[143] = 1787
			order[144] = 2141
			order[145] = 2142
			order[146] = 2143
			order[147] = 2752
			order[148] = 2144
			order[149] = 2145
			order[150] = 2576
			order[151] = 2962
			order[152] = 2602
			order[153] = 2603
			order[154] = 668
			order[155] = 869
			order[156] = 2736
			order[157] = 2738
			order[158] = 913
			order[159] = 914
			order[160] = 1961
			order[161] = 915
			order[162] = 918
			order[163] = 2952
			order[164] = 1962
			order[165] = 1963
			order[166] = 1964
			order[167] = 1965
			order[168] = 1966
			order[169] = 1967
			order[170] = 1968
			order[171] = 1969
			order[172] = 1970
			order[173] = 1513
			order[174] = 1525
			order[175] = 1527
			order[176] = 788
			order[177] = 916
			order[178] = 917
			order[179] = 919
			order[180] = 898
			order[181] = 1647
			order[182] = 0
			fix.Group.__init__(self, 146, 55, order)

		class NoSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 455
				order[1] = 456
				order[2] = 2957
				order[3] = 0
				fix.Group.__init__(self, 454, 455, order)

		class NoSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 1977
				order[1] = 1978
				order[2] = 1979
				order[3] = 2741
				order[4] = 0
				fix.Group.__init__(self, 1976, 1977, order)

		class NoAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2305
				order[1] = 2306
				order[2] = 2307
				order[3] = 0
				fix.Group.__init__(self, 2304, 2305, order)

		class NoEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 865
				order[1] = 866
				order[2] = 1145
				order[3] = 1827
				order[4] = 1826
				order[5] = 2340
				order[6] = 867
				order[7] = 868
				order[8] = 1578
				order[9] = 1579
				order[10] = 0
				fix.Group.__init__(self, 864, 865, order)

		class NoInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1019
				order[1] = 1050
				order[2] = 1051
				order[3] = 2378
				order[4] = 1052
				order[5] = 0
				fix.Group.__init__(self, 1018, 1019, order)

			class NoInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1053
					order[1] = 1054
					order[2] = 0
					fix.Group.__init__(self, 1052, 1053, order)

		class NoComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 1484
				order[1] = 2117
				order[2] = 2118
				order[3] = 2119
				order[4] = 1485
				order[5] = 2120
				order[6] = 2121
				order[7] = 2122
				order[8] = 2941
				order[9] = 1486
				order[10] = 2123
				order[11] = 1487
				order[12] = 1488
				order[13] = 1489
				order[14] = 1490
				order[15] = 1491
				order[16] = 2124
				order[17] = 2942
				order[18] = 2125
				order[19] = 2943
				order[20] = 2126
				order[21] = 2127
				order[22] = 2407
				order[23] = 2408
				order[24] = 2128
				order[25] = 2129
				order[26] = 2130
				order[27] = 2131
				order[28] = 2132
				order[29] = 41013
				order[30] = 41020
				order[31] = 41021
				order[32] = 41022
				order[33] = 41023
				order[34] = 41024
				order[35] = 41025
				order[36] = 41026
				order[37] = 41027
				order[38] = 41028
				order[39] = 41010
				order[40] = 2133
				order[41] = 2134
				order[42] = 2135
				order[43] = 2136
				order[44] = 2137
				order[45] = 41029
				order[46] = 40997
				order[47] = 2597
				order[48] = 2598
				order[49] = 2599
				order[50] = 2138
				order[51] = 2139
				order[52] = 0
				fix.Group.__init__(self, 1483, 1484, order)

			class NoComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 1492
					order[1] = 1493
					order[2] = 1494
					order[3] = 0
					fix.Group.__init__(self, 1491, 1492, order)

				class NoComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 1495
						order[1] = 1496
						order[2] = 0
						fix.Group.__init__(self, 1494, 1495, order)

			class NoComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41014
					order[1] = 41015
					order[2] = 41016
					order[3] = 41017
					order[4] = 0
					fix.Group.__init__(self, 41013, 41014, order)

			class NoComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41019
					order[1] = 0
					fix.Group.__init__(self, 41018, 41019, order)

			class NoComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41011
					order[1] = 41012
					order[2] = 41031
					order[3] = 41007
					order[4] = 40994
					order[5] = 0
					fix.Group.__init__(self, 41010, 41011, order)

				class NoComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41032
						order[1] = 41033
						order[2] = 41034
						order[3] = 41035
						order[4] = 41036
						order[5] = 0
						fix.Group.__init__(self, 41031, 41032, order)

				class NoComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41008
						order[1] = 41009
						order[2] = 0
						fix.Group.__init__(self, 41007, 41008, order)

				class NoComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40995
						order[1] = 40996
						order[2] = 0
						fix.Group.__init__(self, 40994, 40995, order)

			class NoComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41030
					order[1] = 0
					fix.Group.__init__(self, 41029, 41030, order)

			class NoComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 40998
					order[1] = 40999
					order[2] = 41000
					order[3] = 41001
					order[4] = 41002
					order[5] = 41003
					order[6] = 41004
					order[7] = 41005
					order[8] = 0
					fix.Group.__init__(self, 40997, 40998, order)

				class NoComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41006
						order[1] = 0
						fix.Group.__init__(self, 41005, 41006, order)

		class NoBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40471
				order[1] = 0
				fix.Group.__init__(self, 40278, 40471, order)

		class NoPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41231
				order[1] = 0
				fix.Group.__init__(self, 41230, 41231, order)

		class NoMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41093
				order[1] = 40991
				order[2] = 0
				fix.Group.__init__(self, 41092, 41093, order)

		class NoMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41095
				order[1] = 40992
				order[2] = 0
				fix.Group.__init__(self, 41094, 41095, order)

		class NoMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41097
				order[1] = 41098
				order[2] = 41099
				order[3] = 41100
				order[4] = 41101
				order[5] = 41102
				order[6] = 41103
				order[7] = 41104
				order[8] = 41105
				order[9] = 0
				fix.Group.__init__(self, 41096, 41097, order)

		class NoSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42776
				order[1] = 0
				fix.Group.__init__(self, 42775, 42776, order)

		class NoOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41117
				order[1] = 0
				fix.Group.__init__(self, 41116, 41117, order)

		class NoOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41138
				order[1] = 41139
				order[2] = 0
				fix.Group.__init__(self, 41137, 41138, order)

		class NoOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41141
				order[1] = 0
				fix.Group.__init__(self, 41140, 41141, order)

		class NoOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41153
				order[1] = 41154
				order[2] = 0
				fix.Group.__init__(self, 41152, 41153, order)

		class NoStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40050
				order[1] = 41303
				order[2] = 40051
				order[3] = 42784
				order[4] = 42785
				order[5] = 40052
				order[6] = 40053
				order[7] = 41305
				order[8] = 40054
				order[9] = 40055
				order[10] = 42786
				order[11] = 42787
				order[12] = 41306
				order[13] = 41307
				order[14] = 41308
				order[15] = 41309
				order[16] = 41310
				order[17] = 41311
				order[18] = 41251
				order[19] = 41252
				order[20] = 41253
				order[21] = 41254
				order[22] = 41255
				order[23] = 41256
				order[24] = 41257
				order[25] = 42587
				order[26] = 41258
				order[27] = 41259
				order[28] = 41260
				order[29] = 41261
				order[30] = 41262
				order[31] = 41263
				order[32] = 41264
				order[33] = 41265
				order[34] = 41266
				order[35] = 41267
				order[36] = 41268
				order[37] = 41269
				order[38] = 41270
				order[39] = 41271
				order[40] = 41272
				order[41] = 41273
				order[42] = 41274
				order[43] = 41275
				order[44] = 41276
				order[45] = 40907
				order[46] = 40908
				order[47] = 40910
				order[48] = 40911
				order[49] = 40912
				order[50] = 40913
				order[51] = 40914
				order[52] = 40065
				order[53] = 40066
				order[54] = 40068
				order[55] = 40069
				order[56] = 40070
				order[57] = 40071
				order[58] = 40072
				order[59] = 41244
				order[60] = 41245
				order[61] = 40073
				order[62] = 40075
				order[63] = 40076
				order[64] = 40078
				order[65] = 40079
				order[66] = 40080
				order[67] = 40081
				order[68] = 40082
				order[69] = 40083
				order[70] = 40084
				order[71] = 41246
				order[72] = 41247
				order[73] = 41248
				order[74] = 40738
				order[75] = 40739
				order[76] = 40740
				order[77] = 42600
				order[78] = 40741
				order[79] = 40742
				order[80] = 43106
				order[81] = 40743
				order[82] = 40744
				order[83] = 40745
				order[84] = 40746
				order[85] = 40747
				order[86] = 42601
				order[87] = 42602
				order[88] = 42603
				order[89] = 42604
				order[90] = 40748
				order[91] = 40749
				order[92] = 40750
				order[93] = 41180
				order[94] = 41181
				order[95] = 41182
				order[96] = 41183
				order[97] = 41184
				order[98] = 41185
				order[99] = 41186
				order[100] = 42605
				order[101] = 40828
				order[102] = 40872
				order[103] = 41058
				order[104] = 41059
				order[105] = 41060
				order[106] = 41061
				order[107] = 41062
				order[108] = 42192
				order[109] = 42193
				order[110] = 41063
				order[111] = 41064
				order[112] = 41065
				order[113] = 41066
				order[114] = 41067
				order[115] = 41218
				order[116] = 41068
				order[117] = 41069
				order[118] = 41070
				order[119] = 41071
				order[120] = 41072
				order[121] = 41073
				order[122] = 41074
				order[123] = 41075
				order[124] = 41076
				order[125] = 41077
				order[126] = 41078
				order[127] = 41079
				order[128] = 41080
				order[129] = 43094
				order[130] = 41037
				order[131] = 40056
				order[132] = 40982
				order[133] = 40983
				order[134] = 0
				fix.Group.__init__(self, 40049, 40050, order)

			class NoStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41278
					order[1] = 41279
					order[2] = 0
					fix.Group.__init__(self, 41277, 41278, order)

			class NoStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41238
					order[1] = 41239
					order[2] = 41240
					order[3] = 0
					fix.Group.__init__(self, 41237, 41238, order)

			class NoStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41281
					order[1] = 41282
					order[2] = 0
					fix.Group.__init__(self, 41280, 41281, order)

			class NoStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41250
					order[1] = 0
					fix.Group.__init__(self, 41249, 41250, order)

			class NoStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41290
					order[1] = 41291
					order[2] = 41292
					order[3] = 41293
					order[4] = 41294
					order[5] = 41295
					order[6] = 41296
					order[7] = 41297
					order[8] = 41298
					order[9] = 41299
					order[10] = 41300
					order[11] = 41283
					order[12] = 41301
					order[13] = 41302
					order[14] = 0
					fix.Group.__init__(self, 41289, 41290, order)

				class NoStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41284
						order[1] = 41285
						order[2] = 41286
						order[3] = 0
						fix.Group.__init__(self, 41283, 41284, order)

					class NoStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41287
							order[1] = 41288
							order[2] = 41588
							order[3] = 0
							fix.Group.__init__(self, 41286, 41287, order)

			class NoStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40909
					order[1] = 0
					fix.Group.__init__(self, 40960, 40909, order)

			class NoStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40067
					order[1] = 0
					fix.Group.__init__(self, 40961, 40067, order)

			class NoStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40074
					order[1] = 0
					fix.Group.__init__(self, 40958, 40074, order)

			class NoStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41242
					order[1] = 41243
					order[2] = 0
					fix.Group.__init__(self, 41241, 41242, order)

			class NoStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40077
					order[1] = 0
					fix.Group.__init__(self, 40959, 40077, order)

			class NoPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40752
					order[1] = 0
					fix.Group.__init__(self, 40947, 40752, order)

			class NoPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41221
					order[1] = 41222
					order[2] = 0
					fix.Group.__init__(self, 41220, 41221, order)

			class NoPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40763
					order[1] = 0
					fix.Group.__init__(self, 40948, 40763, order)

			class NoPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40769
					order[1] = 0
					fix.Group.__init__(self, 40949, 40769, order)

			class NoPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40776
					order[1] = 0
					fix.Group.__init__(self, 40950, 40776, order)

			class NoPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42661
					order[1] = 42662
					order[2] = 0
					fix.Group.__init__(self, 42660, 42661, order)

			class NoPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41193
					order[1] = 0
					fix.Group.__init__(self, 41192, 41193, order)

			class NoPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41228
					order[1] = 41229
					order[2] = 0
					fix.Group.__init__(self, 41227, 41228, order)

			class NoPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41225
					order[1] = 41226
					order[2] = 0
					fix.Group.__init__(self, 41224, 41225, order)

			class NoPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43109
					order[1] = 42684
					order[2] = 42685
					order[3] = 0
					fix.Group.__init__(self, 42683, 43109, order)

			class NoDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42275
					order[1] = 42276
					order[2] = 42277
					order[3] = 42278
					order[4] = 42279
					order[5] = 42280
					order[6] = 42294
					order[7] = 42281
					order[8] = 42282
					order[9] = 42283
					order[10] = 42284
					order[11] = 42285
					order[12] = 42286
					order[13] = 42287
					order[14] = 42288
					order[15] = 42289
					order[16] = 42290
					order[17] = 42291
					order[18] = 42292
					order[19] = 42293
					order[20] = 0
					fix.Group.__init__(self, 42274, 42275, order)

				class NoDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42295
						order[1] = 0
						fix.Group.__init__(self, 42294, 42295, order)

			class NoDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42273
					order[1] = 0
					fix.Group.__init__(self, 42272, 42273, order)

			class NoDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42237
					order[1] = 0
					fix.Group.__init__(self, 42236, 42237, order)

			class NoReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 42736
					order[1] = 42737
					order[2] = 42738
					order[3] = 42739
					order[4] = 42740
					order[5] = 42741
					order[6] = 42765
					order[7] = 42731
					order[8] = 42742
					order[9] = 42743
					order[10] = 42744
					order[11] = 42745
					order[12] = 42746
					order[13] = 42747
					order[14] = 42748
					order[15] = 42749
					order[16] = 42750
					order[17] = 42751
					order[18] = 42752
					order[19] = 42753
					order[20] = 42761
					order[21] = 42754
					order[22] = 42755
					order[23] = 42709
					order[24] = 42756
					order[25] = 42757
					order[26] = 42758
					order[27] = 42759
					order[28] = 42760
					order[29] = 0
					fix.Group.__init__(self, 42735, 42736, order)

				class NoReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 42766
						order[1] = 42767
						order[2] = 42768
						order[3] = 42769
						order[4] = 0
						fix.Group.__init__(self, 42765, 42766, order)

				class NoReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42732
						order[1] = 42733
						order[2] = 42734
						order[3] = 0
						fix.Group.__init__(self, 42731, 42732, order)

				class NoReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42762
						order[1] = 42763
						order[2] = 42764
						order[3] = 0
						fix.Group.__init__(self, 42761, 42762, order)

				class NoReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 42710
						order[1] = 42772
						order[2] = 42711
						order[3] = 42712
						order[4] = 42713
						order[5] = 42714
						order[6] = 42715
						order[7] = 42716
						order[8] = 42717
						order[9] = 42718
						order[10] = 42719
						order[11] = 42720
						order[12] = 42721
						order[13] = 42722
						order[14] = 42723
						order[15] = 42724
						order[16] = 42725
						order[17] = 42726
						order[18] = 42727
						order[19] = 42728
						order[20] = 42729
						order[21] = 42730
						order[22] = 42770
						order[23] = 0
						fix.Group.__init__(self, 42709, 42710, order)

					class NoReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 42773
							order[1] = 42774
							order[2] = 0
							fix.Group.__init__(self, 42772, 42773, order)

					class NoReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 42771
							order[1] = 0
							fix.Group.__init__(self, 42770, 42771, order)

			class NoPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42621
					order[1] = 0
					fix.Group.__init__(self, 42620, 42621, order)

			class NoPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42607
					order[1] = 42608
					order[2] = 0
					fix.Group.__init__(self, 42606, 42607, order)

			class NoPaymentStreamNonDeliverableFixingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40819
					order[1] = 0
					fix.Group.__init__(self, 40946, 40819, order)

			class NoNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40826
					order[1] = 40827
					order[2] = 0
					fix.Group.__init__(self, 40825, 40826, order)

			class NoSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40086
					order[1] = 40373
					order[2] = 40655
					order[3] = 40088
					order[4] = 40089
					order[5] = 0
					fix.Group.__init__(self, 40085, 40086, order)

			class NoPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40829
					order[1] = 41164
					order[2] = 41165
					order[3] = 40830
					order[4] = 40831
					order[5] = 40832
					order[6] = 40833
					order[7] = 40834
					order[8] = 40835
					order[9] = 40836
					order[10] = 40837
					order[11] = 40838
					order[12] = 40839
					order[13] = 41166
					order[14] = 41167
					order[15] = 41168
					order[16] = 41169
					order[17] = 40840
					order[18] = 40841
					order[19] = 40842
					order[20] = 40843
					order[21] = 41170
					order[22] = 41171
					order[23] = 41172
					order[24] = 41173
					order[25] = 40844
					order[26] = 40845
					order[27] = 40846
					order[28] = 40847
					order[29] = 40848
					order[30] = 40849
					order[31] = 40868
					order[32] = 40850
					order[33] = 40851
					order[34] = 40852
					order[35] = 40853
					order[36] = 40977
					order[37] = 40855
					order[38] = 40856
					order[39] = 40857
					order[40] = 41174
					order[41] = 41175
					order[42] = 40858
					order[43] = 41161
					order[44] = 41176
					order[45] = 41177
					order[46] = 41178
					order[47] = 41179
					order[48] = 40859
					order[49] = 40860
					order[50] = 40861
					order[51] = 40862
					order[52] = 40945
					order[53] = 40864
					order[54] = 40865
					order[55] = 40866
					order[56] = 40867
					order[57] = 0
					fix.Group.__init__(self, 40828, 40829, order)

				class NoPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40869
						order[1] = 40870
						order[2] = 40871
						order[3] = 0
						fix.Group.__init__(self, 40868, 40869, order)

				class NoPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40854
						order[1] = 0
						fix.Group.__init__(self, 40977, 40854, order)

				class NoPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41162
						order[1] = 41163
						order[2] = 0
						fix.Group.__init__(self, 41161, 41162, order)

				class NoPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40863
						order[1] = 0
						fix.Group.__init__(self, 40945, 40863, order)

			class NoPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40873
					order[1] = 40874
					order[2] = 42698
					order[3] = 42699
					order[4] = 42700
					order[5] = 42701
					order[6] = 42702
					order[7] = 42703
					order[8] = 42704
					order[9] = 42689
					order[10] = 42690
					order[11] = 42691
					order[12] = 42692
					order[13] = 42693
					order[14] = 42694
					order[15] = 42695
					order[16] = 40875
					order[17] = 40876
					order[18] = 40877
					order[19] = 40878
					order[20] = 40879
					order[21] = 40880
					order[22] = 40881
					order[23] = 40882
					order[24] = 40883
					order[25] = 40884
					order[26] = 40885
					order[27] = 40886
					order[28] = 40887
					order[29] = 40888
					order[30] = 40889
					order[31] = 40890
					order[32] = 40891
					order[33] = 40892
					order[34] = 40893
					order[35] = 40894
					order[36] = 40895
					order[37] = 40896
					order[38] = 40897
					order[39] = 40898
					order[40] = 40899
					order[41] = 40900
					order[42] = 40901
					order[43] = 0
					fix.Group.__init__(self, 40872, 40873, order)

				class NoPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42706
						order[1] = 0
						fix.Group.__init__(self, 42705, 42706, order)

				class NoPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42697
						order[1] = 0
						fix.Group.__init__(self, 42696, 42697, order)

			class NoDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41086
					order[1] = 0
					fix.Group.__init__(self, 41085, 41086, order)

			class NoDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41082
					order[1] = 41083
					order[2] = 41084
					order[3] = 0
					fix.Group.__init__(self, 41081, 41082, order)

			class NoDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41038
					order[1] = 41039
					order[2] = 41040
					order[3] = 41041
					order[4] = 41042
					order[5] = 41043
					order[6] = 41044
					order[7] = 41045
					order[8] = 41046
					order[9] = 41047
					order[10] = 41048
					order[11] = 41049
					order[12] = 41050
					order[13] = 41051
					order[14] = 0
					fix.Group.__init__(self, 41037, 41038, order)

				class NoDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41052
						order[1] = 41053
						order[2] = 41054
						order[3] = 0
						fix.Group.__init__(self, 41051, 41052, order)

					class NoDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41055
							order[1] = 41056
							order[2] = 41057
							order[3] = 0
							fix.Group.__init__(self, 41054, 41055, order)

		class NoProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 40091
				order[1] = 40092
				order[2] = 40093
				order[3] = 40957
				order[4] = 40095
				order[5] = 40096
				order[6] = 40097
				order[7] = 42707
				order[8] = 42708
				order[9] = 40098
				order[10] = 40099
				order[11] = 40100
				order[12] = 40114
				order[13] = 40115
				order[14] = 40116
				order[15] = 40118
				order[16] = 40119
				order[17] = 40120
				order[18] = 40121
				order[19] = 40122
				order[20] = 40123
				order[21] = 40125
				order[22] = 40126
				order[23] = 40127
				order[24] = 40128
				order[25] = 40129
				order[26] = 40130
				order[27] = 40131
				order[28] = 40132
				order[29] = 40133
				order[30] = 40134
				order[31] = 40135
				order[32] = 40136
				order[33] = 40137
				order[34] = 40138
				order[35] = 40139
				order[36] = 40140
				order[37] = 40141
				order[38] = 40145
				order[39] = 40146
				order[40] = 40148
				order[41] = 40149
				order[42] = 40150
				order[43] = 40151
				order[44] = 40152
				order[45] = 40153
				order[46] = 40154
				order[47] = 40155
				order[48] = 40156
				order[49] = 40158
				order[50] = 40159
				order[51] = 40160
				order[52] = 40161
				order[53] = 40162
				order[54] = 40101
				order[55] = 40102
				order[56] = 40103
				order[57] = 40104
				order[58] = 40105
				order[59] = 40106
				order[60] = 40107
				order[61] = 40163
				order[62] = 40165
				order[63] = 40166
				order[64] = 40167
				order[65] = 40168
				order[66] = 40169
				order[67] = 40170
				order[68] = 40108
				order[69] = 40109
				order[70] = 40110
				order[71] = 40111
				order[72] = 40112
				order[73] = 41406
				order[74] = 40113
				order[75] = 40986
				order[76] = 40987
				order[77] = 40174
				order[78] = 0
				fix.Group.__init__(self, 40090, 40091, order)

			class NoProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40094
					order[1] = 0
					fix.Group.__init__(self, 40957, 40094, order)

			class NoProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40117
					order[1] = 0
					fix.Group.__init__(self, 40953, 40117, order)

			class NoProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40124
					order[1] = 0
					fix.Group.__init__(self, 40954, 40124, order)

			class NoProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40143
					order[1] = 40144
					order[2] = 0
					fix.Group.__init__(self, 40142, 40143, order)

			class NoProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40147
					order[1] = 0
					fix.Group.__init__(self, 40955, 40147, order)

			class NoProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40157
					order[1] = 0
					fix.Group.__init__(self, 40956, 40157, order)

			class NoProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40164
					order[1] = 0
					fix.Group.__init__(self, 40952, 40164, order)

			class NoProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40172
					order[1] = 40173
					order[2] = 0
					fix.Group.__init__(self, 40171, 40172, order)

			class NoProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40175
					order[1] = 40176
					order[2] = 40177
					order[3] = 2385
					order[4] = 40178
					order[5] = 0
					fix.Group.__init__(self, 40174, 40175, order)

				class NoProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40179
						order[1] = 40180
						order[2] = 0
						fix.Group.__init__(self, 40178, 40179, order)

		class NoAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 40020
				order[1] = 40021
				order[2] = 40000
				order[3] = 0
				fix.Group.__init__(self, 40019, 40020, order)

			class NoAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 40001
					order[1] = 40002
					order[2] = 40003
					order[3] = 40004
					order[4] = 40005
					order[5] = 40006
					order[6] = 40007
					order[7] = 40008
					order[8] = 40009
					order[9] = 40010
					order[10] = 40011
					order[11] = 40012
					order[12] = 40013
					order[13] = 40014
					order[14] = 40015
					order[15] = 40016
					order[16] = 40017
					order[17] = 40018
					order[18] = 0
					fix.Group.__init__(self, 40000, 40001, order)

		class NoProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 40182
				order[1] = 40183
				order[2] = 40184
				order[3] = 40185
				order[4] = 40186
				order[5] = 40187
				order[6] = 40188
				order[7] = 40951
				order[8] = 40191
				order[9] = 40201
				order[10] = 40190
				order[11] = 0
				fix.Group.__init__(self, 40181, 40182, order)

			class NoProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40189
					order[1] = 0
					fix.Group.__init__(self, 40951, 40189, order)

			class NoProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 40192
					order[1] = 40193
					order[2] = 40194
					order[3] = 40195
					order[4] = 40196
					order[5] = 40197
					order[6] = 40198
					order[7] = 40199
					order[8] = 0
					fix.Group.__init__(self, 40191, 40192, order)

				class NoProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40200
						order[1] = 0
						fix.Group.__init__(self, 40199, 40200, order)

			class NoProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40202
					order[1] = 40203
					order[2] = 0
					fix.Group.__init__(self, 40201, 40202, order)

		class NoCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 40023
				order[1] = 40024
				order[2] = 40916
				order[3] = 40917
				order[4] = 40025
				order[5] = 40026
				order[6] = 40027
				order[7] = 40028
				order[8] = 40029
				order[9] = 40030
				order[10] = 40031
				order[11] = 40277
				order[12] = 42216
				order[13] = 42217
				order[14] = 40033
				order[15] = 40034
				order[16] = 42207
				order[17] = 42208
				order[18] = 42209
				order[19] = 42210
				order[20] = 42211
				order[21] = 42212
				order[22] = 42213
				order[23] = 40035
				order[24] = 40036
				order[25] = 40037
				order[26] = 40038
				order[27] = 40039
				order[28] = 0
				fix.Group.__init__(self, 40022, 40023, order)

			class NoCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40032
					order[1] = 0
					fix.Group.__init__(self, 40277, 40032, order)

			class NoCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42215
					order[1] = 0
					fix.Group.__init__(self, 42214, 42215, order)

		class NoPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40209
				order[1] = 40205
				order[2] = 40206
				order[3] = 40207
				order[4] = 40208
				order[5] = 0
				fix.Group.__init__(self, 40204, 40209, order)

			class NoPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40210
					order[1] = 40211
					order[2] = 0
					fix.Group.__init__(self, 40209, 40210, order)

		class NoExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42297
				order[1] = 42298
				order[2] = 0
				fix.Group.__init__(self, 42296, 42297, order)

		class NoInstrAttrib(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 871
				order[1] = 872
				order[2] = 0
				fix.Group.__init__(self, 870, 871, order)

		class NoIndexRollMonths(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 2733
				order[1] = 0
				fix.Group.__init__(self, 2734, 2733, order)

		class NoReferenceDataDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 2747
				order[1] = 2748
				order[2] = 0
				fix.Group.__init__(self, 2746, 2747, order)

		class NoContractualDefinitions(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40041
				order[1] = 0
				fix.Group.__init__(self, 40040, 40041, order)

		class NoFinancingTermSupplements(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40047
				order[1] = 40048
				order[2] = 0
				fix.Group.__init__(self, 40046, 40047, order)

		class NoContractualMatrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 40043
				order[1] = 40044
				order[2] = 40045
				order[3] = 0
				fix.Group.__init__(self, 40042, 40043, order)

		class NoRelatedInstruments(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 1648
				order[1] = 1649
				order[2] = 1650
				order[3] = 1651
				order[4] = 1652
				order[5] = 1653
				order[6] = 2413
				order[7] = 2414
				order[8] = 2415
				order[9] = 2417
				order[10] = 0
				fix.Group.__init__(self, 1647, 1648, order)

	class NoUnderlyings(fix.Group):
		def __init__(self):
			order = fix.IntArray(188)
			order[0] = 311
			order[1] = 312
			order[2] = 309
			order[3] = 305
			order[4] = 2874
			order[5] = 462
			order[6] = 463
			order[7] = 2894
			order[8] = 310
			order[9] = 763
			order[10] = 313
			order[11] = 542
			order[12] = 1213
			order[13] = 1837
			order[14] = 241
			order[15] = 1453
			order[16] = 1454
			order[17] = 2614
			order[18] = 2615
			order[19] = 2921
			order[20] = 2616
			order[21] = 2617
			order[22] = 2619
			order[23] = 1455
			order[24] = 1456
			order[25] = 1459
			order[26] = 1460
			order[27] = 242
			order[28] = 243
			order[29] = 244
			order[30] = 245
			order[31] = 246
			order[32] = 256
			order[33] = 595
			order[34] = 592
			order[35] = 593
			order[36] = 594
			order[37] = 247
			order[38] = 316
			order[39] = 941
			order[40] = 2917
			order[41] = 317
			order[42] = 436
			order[43] = 1437
			order[44] = 2363
			order[45] = 1441
			order[46] = 998
			order[47] = 1423
			order[48] = 1718
			order[49] = 2918
			order[50] = 1424
			order[51] = 1425
			order[52] = 1719
			order[53] = 2919
			order[54] = 1000
			order[55] = 1419
			order[56] = 1526
			order[57] = 2920
			order[58] = 435
			order[59] = 308
			order[60] = 306
			order[61] = 362
			order[62] = 363
			order[63] = 2742
			order[64] = 2720
			order[65] = 2721
			order[66] = 2722
			order[67] = 2723
			order[68] = 2724
			order[69] = 307
			order[70] = 364
			order[71] = 365
			order[72] = 877
			order[73] = 878
			order[74] = 972
			order[75] = 318
			order[76] = 2916
			order[77] = 879
			order[78] = 975
			order[79] = 973
			order[80] = 974
			order[81] = 810
			order[82] = 882
			order[83] = 883
			order[84] = 884
			order[85] = 885
			order[86] = 886
			order[87] = 2885
			order[88] = 2886
			order[89] = 1044
			order[90] = 1045
			order[91] = 1046
			order[92] = 1038
			order[93] = 1039
			order[94] = 315
			order[95] = 2683
			order[96] = 2687
			order[97] = 1988
			order[98] = 1989
			order[99] = 1990
			order[100] = 1991
			order[101] = 1992
			order[102] = 1993
			order[103] = 2881
			order[104] = 1994
			order[105] = 1995
			order[106] = 1996
			order[107] = 1997
			order[108] = 2620
			order[109] = 2621
			order[110] = 1998
			order[111] = 1999
			order[112] = 2000
			order[113] = 2003
			order[114] = 2004
			order[115] = 2005
			order[116] = 2006
			order[117] = 2284
			order[118] = 2285
			order[119] = 2286
			order[120] = 2287
			order[121] = 2288
			order[122] = 2007
			order[123] = 2008
			order[124] = 2009
			order[125] = 2010
			order[126] = 2011
			order[127] = 2012
			order[128] = 2491
			order[129] = 2013
			order[130] = 2014
			order[131] = 2015
			order[132] = 2744
			order[133] = 2016
			order[134] = 2289
			order[135] = 2017
			order[136] = 2018
			order[137] = 2019
			order[138] = 2020
			order[139] = 2021
			order[140] = 2022
			order[141] = 2290
			order[142] = 2622
			order[143] = 2291
			order[144] = 2623
			order[145] = 2292
			order[146] = 2023
			order[147] = 2024
			order[148] = 2025
			order[149] = 2026
			order[150] = 2027
			order[151] = 2028
			order[152] = 2029
			order[153] = 2757
			order[154] = 2030
			order[155] = 2031
			order[156] = 2293
			order[157] = 2294
			order[158] = 2032
			order[159] = 2033
			order[160] = 2034
			order[161] = 2035
			order[162] = 2036
			order[163] = 2037
			order[164] = 2038
			order[165] = 2039
			order[166] = 2040
			order[167] = 2041
			order[168] = 2042
			order[169] = 2043
			order[170] = 2044
			order[171] = 41314
			order[172] = 41315
			order[173] = 2295
			order[174] = 2296
			order[175] = 2297
			order[176] = 2756
			order[177] = 2298
			order[178] = 2299
			order[179] = 2624
			order[180] = 2625
			order[181] = 2626
			order[182] = 2627
			order[183] = 2628
			order[184] = 2629
			order[185] = 2630
			order[186] = 2631
			order[187] = 0
			fix.Group.__init__(self, 711, 311, order)

		class NoUnderlyingSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 458
				order[1] = 459
				order[2] = 2959
				order[3] = 0
				fix.Group.__init__(self, 457, 458, order)

		class NoUnderlyingStips(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 888
				order[1] = 889
				order[2] = 0
				fix.Group.__init__(self, 887, 888, order)

		class NoUndlyInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1059
				order[1] = 1060
				order[2] = 1061
				order[3] = 2391
				order[4] = 1062
				order[5] = 0
				fix.Group.__init__(self, 1058, 1059, order)

			class NoUndlyInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1063
					order[1] = 1064
					order[2] = 0
					fix.Group.__init__(self, 1062, 1063, order)

		class NoUnderlyingEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 1982
				order[1] = 1983
				order[2] = 1984
				order[3] = 1985
				order[4] = 1986
				order[5] = 2342
				order[6] = 1987
				order[7] = 2071
				order[8] = 2072
				order[9] = 2073
				order[10] = 0
				fix.Group.__init__(self, 1981, 1982, order)

		class NoUnderlyingSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2081
				order[1] = 2082
				order[2] = 2083
				order[3] = 2745
				order[4] = 0
				fix.Group.__init__(self, 2080, 2081, order)

		class NoUnderlyingAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2313
				order[1] = 2314
				order[2] = 2315
				order[3] = 0
				fix.Group.__init__(self, 2312, 2313, order)

		class NoUnderlyingComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2046
				order[1] = 2261
				order[2] = 2262
				order[3] = 2263
				order[4] = 2047
				order[5] = 2264
				order[6] = 2265
				order[7] = 2266
				order[8] = 2947
				order[9] = 2048
				order[10] = 2267
				order[11] = 2049
				order[12] = 2050
				order[13] = 2051
				order[14] = 2052
				order[15] = 2053
				order[16] = 2268
				order[17] = 2948
				order[18] = 2269
				order[19] = 2949
				order[20] = 2270
				order[21] = 2271
				order[22] = 2419
				order[23] = 2420
				order[24] = 2272
				order[25] = 2273
				order[26] = 2274
				order[27] = 2275
				order[28] = 2276
				order[29] = 41732
				order[30] = 41739
				order[31] = 41740
				order[32] = 41741
				order[33] = 41742
				order[34] = 41743
				order[35] = 41744
				order[36] = 41745
				order[37] = 41746
				order[38] = 41747
				order[39] = 41729
				order[40] = 2277
				order[41] = 2278
				order[42] = 2279
				order[43] = 2280
				order[44] = 2281
				order[45] = 41748
				order[46] = 41716
				order[47] = 2611
				order[48] = 2612
				order[49] = 2613
				order[50] = 2282
				order[51] = 2283
				order[52] = 0
				fix.Group.__init__(self, 2045, 2046, order)

			class NoUnderlyingComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2054
					order[1] = 2055
					order[2] = 2056
					order[3] = 0
					fix.Group.__init__(self, 2053, 2054, order)

				class NoUnderlyingComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2057
						order[1] = 2058
						order[2] = 0
						fix.Group.__init__(self, 2056, 2057, order)

			class NoUnderlyingComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41733
					order[1] = 41734
					order[2] = 41735
					order[3] = 41736
					order[4] = 0
					fix.Group.__init__(self, 41732, 41733, order)

			class NoUnderlyingComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41738
					order[1] = 0
					fix.Group.__init__(self, 41737, 41738, order)

			class NoUnderlyingComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41730
					order[1] = 41731
					order[2] = 41750
					order[3] = 41726
					order[4] = 41713
					order[5] = 0
					fix.Group.__init__(self, 41729, 41730, order)

				class NoUnderlyingComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41751
						order[1] = 41752
						order[2] = 41753
						order[3] = 41754
						order[4] = 41755
						order[5] = 0
						fix.Group.__init__(self, 41750, 41751, order)

				class NoUnderlyingComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41727
						order[1] = 41728
						order[2] = 0
						fix.Group.__init__(self, 41726, 41727, order)

				class NoUnderlyingComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41714
						order[1] = 41715
						order[2] = 0
						fix.Group.__init__(self, 41713, 41714, order)

			class NoUnderlyingComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41749
					order[1] = 0
					fix.Group.__init__(self, 41748, 41749, order)

			class NoUnderlyingComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41717
					order[1] = 41718
					order[2] = 41719
					order[3] = 41720
					order[4] = 41721
					order[5] = 41722
					order[6] = 41723
					order[7] = 41724
					order[8] = 0
					fix.Group.__init__(self, 41716, 41717, order)

				class NoUnderlyingComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41725
						order[1] = 0
						fix.Group.__init__(self, 41724, 41725, order)

		class NoUnderlyingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40963
				order[1] = 0
				fix.Group.__init__(self, 40962, 40963, order)

		class NoUnderlyingPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41948
				order[1] = 0
				fix.Group.__init__(self, 41947, 41948, order)

		class NoUnderlyingMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41865
				order[1] = 41338
				order[2] = 0
				fix.Group.__init__(self, 41864, 41865, order)

		class NoUnderlyingMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41867
				order[1] = 41339
				order[2] = 0
				fix.Group.__init__(self, 41866, 41867, order)

		class NoUnderlyingMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41869
				order[1] = 41870
				order[2] = 41871
				order[3] = 41872
				order[4] = 41873
				order[5] = 41874
				order[6] = 41875
				order[7] = 41876
				order[8] = 41877
				order[9] = 0
				fix.Group.__init__(self, 41868, 41869, order)

		class NoUnderlyingSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 43075
				order[1] = 0
				fix.Group.__init__(self, 43074, 43075, order)

		class NoUnderlyingOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41821
				order[1] = 0
				fix.Group.__init__(self, 41820, 41821, order)

		class NoUnderlyingOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41842
				order[1] = 41843
				order[2] = 0
				fix.Group.__init__(self, 41841, 41842, order)

		class NoUnderlyingOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41845
				order[1] = 0
				fix.Group.__init__(self, 41844, 41845, order)

		class NoUnderlyingOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41857
				order[1] = 41858
				order[2] = 0
				fix.Group.__init__(self, 41856, 41857, order)

		class NoUnderlyingStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40541
				order[1] = 42016
				order[2] = 40542
				order[3] = 43083
				order[4] = 43084
				order[5] = 40543
				order[6] = 40544
				order[7] = 42018
				order[8] = 40545
				order[9] = 40546
				order[10] = 43085
				order[11] = 43086
				order[12] = 42019
				order[13] = 42020
				order[14] = 42021
				order[15] = 42022
				order[16] = 42023
				order[17] = 42024
				order[18] = 41964
				order[19] = 41965
				order[20] = 41966
				order[21] = 41967
				order[22] = 41968
				order[23] = 41969
				order[24] = 41970
				order[25] = 42589
				order[26] = 41971
				order[27] = 41972
				order[28] = 41973
				order[29] = 41974
				order[30] = 41975
				order[31] = 41976
				order[32] = 41977
				order[33] = 41978
				order[34] = 41979
				order[35] = 41980
				order[36] = 41981
				order[37] = 41982
				order[38] = 41983
				order[39] = 41984
				order[40] = 41985
				order[41] = 41986
				order[42] = 41987
				order[43] = 41988
				order[44] = 41989
				order[45] = 40057
				order[46] = 40058
				order[47] = 40060
				order[48] = 40061
				order[49] = 40062
				order[50] = 40063
				order[51] = 40064
				order[52] = 40548
				order[53] = 40549
				order[54] = 40551
				order[55] = 40552
				order[56] = 40553
				order[57] = 40554
				order[58] = 40555
				order[59] = 41957
				order[60] = 41958
				order[61] = 40556
				order[62] = 40558
				order[63] = 40559
				order[64] = 40561
				order[65] = 40562
				order[66] = 40563
				order[67] = 40564
				order[68] = 40565
				order[69] = 40566
				order[70] = 40567
				order[71] = 41959
				order[72] = 41960
				order[73] = 41961
				order[74] = 40568
				order[75] = 40569
				order[76] = 40570
				order[77] = 42895
				order[78] = 40571
				order[79] = 40572
				order[80] = 43107
				order[81] = 40573
				order[82] = 40574
				order[83] = 40575
				order[84] = 40576
				order[85] = 40577
				order[86] = 42896
				order[87] = 42897
				order[88] = 42898
				order[89] = 42899
				order[90] = 40578
				order[91] = 40579
				order[92] = 40580
				order[93] = 41897
				order[94] = 41898
				order[95] = 41899
				order[96] = 41900
				order[97] = 41901
				order[98] = 41902
				order[99] = 41903
				order[100] = 42900
				order[101] = 40664
				order[102] = 40708
				order[103] = 41777
				order[104] = 41778
				order[105] = 41779
				order[106] = 41780
				order[107] = 41781
				order[108] = 42196
				order[109] = 42197
				order[110] = 41782
				order[111] = 41783
				order[112] = 41784
				order[113] = 41785
				order[114] = 41786
				order[115] = 41587
				order[116] = 41787
				order[117] = 41788
				order[118] = 41789
				order[119] = 41790
				order[120] = 41791
				order[121] = 41792
				order[122] = 41793
				order[123] = 41794
				order[124] = 41795
				order[125] = 41796
				order[126] = 41797
				order[127] = 41798
				order[128] = 41799
				order[129] = 43096
				order[130] = 41756
				order[131] = 40547
				order[132] = 40988
				order[133] = 40989
				order[134] = 0
				fix.Group.__init__(self, 40540, 40541, order)

			class NoUnderlyingStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41991
					order[1] = 41992
					order[2] = 0
					fix.Group.__init__(self, 41990, 41991, order)

			class NoUnderlyingStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41801
					order[1] = 41802
					order[2] = 41803
					order[3] = 0
					fix.Group.__init__(self, 41800, 41801, order)

			class NoUnderlyingStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41994
					order[1] = 41995
					order[2] = 0
					fix.Group.__init__(self, 41993, 41994, order)

			class NoUnderlyingStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41963
					order[1] = 0
					fix.Group.__init__(self, 41962, 41963, order)

			class NoUnderlyingStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 42003
					order[1] = 42004
					order[2] = 42005
					order[3] = 42006
					order[4] = 42007
					order[5] = 42008
					order[6] = 42009
					order[7] = 42010
					order[8] = 42011
					order[9] = 42012
					order[10] = 42013
					order[11] = 41996
					order[12] = 42014
					order[13] = 42015
					order[14] = 0
					fix.Group.__init__(self, 42002, 42003, order)

				class NoUnderlyingStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41997
						order[1] = 41998
						order[2] = 41999
						order[3] = 0
						fix.Group.__init__(self, 41996, 41997, order)

					class NoUnderlyingStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 42000
							order[1] = 42001
							order[2] = 41936
							order[3] = 0
							fix.Group.__init__(self, 41999, 42000, order)

			class NoUnderlyingStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40059
					order[1] = 0
					fix.Group.__init__(self, 40975, 40059, order)

			class NoUnderlyingStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40550
					order[1] = 0
					fix.Group.__init__(self, 40976, 40550, order)

			class NoUnderlyingStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40557
					order[1] = 0
					fix.Group.__init__(self, 40973, 40557, order)

			class NoUnderlyingStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41955
					order[1] = 41956
					order[2] = 0
					fix.Group.__init__(self, 41954, 41955, order)

			class NoUnderlyingStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40560
					order[1] = 0
					fix.Group.__init__(self, 40974, 40560, order)

			class NoUnderlyingPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40582
					order[1] = 0
					fix.Group.__init__(self, 40969, 40582, order)

			class NoUnderlyingPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41938
					order[1] = 41939
					order[2] = 0
					fix.Group.__init__(self, 41937, 41938, order)

			class NoUnderlyingPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40594
					order[1] = 0
					fix.Group.__init__(self, 40970, 40594, order)

			class NoUnderlyingPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40600
					order[1] = 0
					fix.Group.__init__(self, 40971, 40600, order)

			class NoUnderlyingPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40607
					order[1] = 0
					fix.Group.__init__(self, 40972, 40607, order)

			class NoUnderlyingPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42956
					order[1] = 42957
					order[2] = 0
					fix.Group.__init__(self, 42955, 42956, order)

			class NoUnderlyingPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41910
					order[1] = 0
					fix.Group.__init__(self, 41909, 41910, order)

			class NoUnderlyingPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41945
					order[1] = 41946
					order[2] = 0
					fix.Group.__init__(self, 41944, 41945, order)

			class NoUnderlyingPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41942
					order[1] = 41943
					order[2] = 0
					fix.Group.__init__(self, 41941, 41942, order)

			class NoUnderlyingPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43111
					order[1] = 42982
					order[2] = 42983
					order[3] = 0
					fix.Group.__init__(self, 42981, 43111, order)

			class NoUnderlyingDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42863
					order[1] = 42864
					order[2] = 42865
					order[3] = 42866
					order[4] = 42867
					order[5] = 42868
					order[6] = 42882
					order[7] = 42869
					order[8] = 42870
					order[9] = 42871
					order[10] = 42872
					order[11] = 42873
					order[12] = 42874
					order[13] = 42875
					order[14] = 42876
					order[15] = 42877
					order[16] = 42878
					order[17] = 42879
					order[18] = 42880
					order[19] = 42881
					order[20] = 0
					fix.Group.__init__(self, 42862, 42863, order)

				class NoUnderlyingDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42883
						order[1] = 0
						fix.Group.__init__(self, 42882, 42883, order)

			class NoUnderlyingDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42854
					order[1] = 0
					fix.Group.__init__(self, 42853, 42854, order)

			class NoUnderlyingDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42800
					order[1] = 0
					fix.Group.__init__(self, 42799, 42800, order)

			class NoUnderlyingReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 43035
					order[1] = 43036
					order[2] = 43037
					order[3] = 43038
					order[4] = 43039
					order[5] = 43040
					order[6] = 43064
					order[7] = 43030
					order[8] = 43041
					order[9] = 43042
					order[10] = 43043
					order[11] = 43044
					order[12] = 43045
					order[13] = 43046
					order[14] = 43047
					order[15] = 43048
					order[16] = 43049
					order[17] = 43050
					order[18] = 43051
					order[19] = 43052
					order[20] = 43060
					order[21] = 43053
					order[22] = 43054
					order[23] = 43008
					order[24] = 43055
					order[25] = 43056
					order[26] = 43057
					order[27] = 43058
					order[28] = 43059
					order[29] = 0
					fix.Group.__init__(self, 43034, 43035, order)

				class NoUnderlyingReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 43065
						order[1] = 43066
						order[2] = 43067
						order[3] = 43068
						order[4] = 0
						fix.Group.__init__(self, 43064, 43065, order)

				class NoUnderlyingReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43031
						order[1] = 43032
						order[2] = 43033
						order[3] = 0
						fix.Group.__init__(self, 43030, 43031, order)

				class NoUnderlyingReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43061
						order[1] = 43062
						order[2] = 43063
						order[3] = 0
						fix.Group.__init__(self, 43060, 43061, order)

				class NoUnderlyingReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 43009
						order[1] = 43071
						order[2] = 43010
						order[3] = 43011
						order[4] = 43012
						order[5] = 43013
						order[6] = 43014
						order[7] = 43015
						order[8] = 43016
						order[9] = 43017
						order[10] = 43018
						order[11] = 43019
						order[12] = 43020
						order[13] = 43021
						order[14] = 43022
						order[15] = 43023
						order[16] = 43024
						order[17] = 43025
						order[18] = 43026
						order[19] = 43027
						order[20] = 43028
						order[21] = 43029
						order[22] = 43069
						order[23] = 0
						fix.Group.__init__(self, 43008, 43009, order)

					class NoUnderlyingReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 43072
							order[1] = 43073
							order[2] = 0
							fix.Group.__init__(self, 43071, 43072, order)

					class NoUnderlyingReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 43070
							order[1] = 0
							fix.Group.__init__(self, 43069, 43070, order)

			class NoUnderlyingPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42916
					order[1] = 0
					fix.Group.__init__(self, 42915, 42916, order)

			class NoUnderlyingPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42902
					order[1] = 42903
					order[2] = 0
					fix.Group.__init__(self, 42901, 42902, order)

			class NoUnderlyingPaymentStreamNonDeliverableFixingDatesBizCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40650
					order[1] = 0
					fix.Group.__init__(self, 40968, 40650, order)

			class NoUnderlyingNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40657
					order[1] = 40658
					order[2] = 0
					fix.Group.__init__(self, 40656, 40657, order)

			class NoUnderlyingSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40660
					order[1] = 40904
					order[2] = 40915
					order[3] = 40662
					order[4] = 40663
					order[5] = 0
					fix.Group.__init__(self, 40659, 40660, order)

			class NoUnderlyingPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40665
					order[1] = 41881
					order[2] = 41882
					order[3] = 40666
					order[4] = 40667
					order[5] = 40668
					order[6] = 40669
					order[7] = 40670
					order[8] = 40671
					order[9] = 40672
					order[10] = 40673
					order[11] = 40674
					order[12] = 40675
					order[13] = 41883
					order[14] = 41884
					order[15] = 41885
					order[16] = 41886
					order[17] = 40676
					order[18] = 40677
					order[19] = 40678
					order[20] = 40679
					order[21] = 41887
					order[22] = 41888
					order[23] = 41889
					order[24] = 41890
					order[25] = 40680
					order[26] = 40681
					order[27] = 40682
					order[28] = 40683
					order[29] = 40684
					order[30] = 40685
					order[31] = 40704
					order[32] = 40686
					order[33] = 40687
					order[34] = 40688
					order[35] = 40689
					order[36] = 40966
					order[37] = 40691
					order[38] = 40692
					order[39] = 40693
					order[40] = 41891
					order[41] = 41892
					order[42] = 40694
					order[43] = 41878
					order[44] = 41893
					order[45] = 41894
					order[46] = 41895
					order[47] = 41896
					order[48] = 40695
					order[49] = 40696
					order[50] = 40697
					order[51] = 40698
					order[52] = 40967
					order[53] = 40700
					order[54] = 40701
					order[55] = 40702
					order[56] = 40703
					order[57] = 0
					fix.Group.__init__(self, 40664, 40665, order)

				class NoUnderlyingPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40705
						order[1] = 40706
						order[2] = 40707
						order[3] = 0
						fix.Group.__init__(self, 40704, 40705, order)

				class NoUnderlyingPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40690
						order[1] = 0
						fix.Group.__init__(self, 40966, 40690, order)

				class NoUnderlyingPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41879
						order[1] = 41880
						order[2] = 0
						fix.Group.__init__(self, 41878, 41879, order)

				class NoUnderlyingPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40699
						order[1] = 0
						fix.Group.__init__(self, 40967, 40699, order)

			class NoUnderlyingPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40709
					order[1] = 40710
					order[2] = 42993
					order[3] = 42994
					order[4] = 42995
					order[5] = 42996
					order[6] = 42997
					order[7] = 42998
					order[8] = 42999
					order[9] = 42984
					order[10] = 42985
					order[11] = 42986
					order[12] = 42987
					order[13] = 42988
					order[14] = 42989
					order[15] = 42990
					order[16] = 40711
					order[17] = 40712
					order[18] = 40713
					order[19] = 40714
					order[20] = 40715
					order[21] = 40716
					order[22] = 40717
					order[23] = 40718
					order[24] = 40719
					order[25] = 40720
					order[26] = 40721
					order[27] = 40722
					order[28] = 40723
					order[29] = 40724
					order[30] = 40725
					order[31] = 40726
					order[32] = 40727
					order[33] = 40728
					order[34] = 40729
					order[35] = 40730
					order[36] = 40731
					order[37] = 40732
					order[38] = 40733
					order[39] = 40734
					order[40] = 40735
					order[41] = 40736
					order[42] = 40737
					order[43] = 0
					fix.Group.__init__(self, 40708, 40709, order)

				class NoUnderlyingPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 43001
						order[1] = 0
						fix.Group.__init__(self, 43000, 43001, order)

				class NoUnderlyingPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42992
						order[1] = 0
						fix.Group.__init__(self, 42991, 42992, order)

			class NoUnderlyingDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41809
					order[1] = 0
					fix.Group.__init__(self, 41808, 41809, order)

			class NoUnderlyingDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41805
					order[1] = 41806
					order[2] = 41807
					order[3] = 0
					fix.Group.__init__(self, 41804, 41805, order)

			class NoUnderlyingDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41757
					order[1] = 41758
					order[2] = 41759
					order[3] = 41760
					order[4] = 41761
					order[5] = 41762
					order[6] = 41763
					order[7] = 41764
					order[8] = 41765
					order[9] = 41766
					order[10] = 41767
					order[11] = 41768
					order[12] = 41769
					order[13] = 41770
					order[14] = 0
					fix.Group.__init__(self, 41756, 41757, order)

				class NoUnderlyingDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41771
						order[1] = 41772
						order[2] = 41773
						order[3] = 0
						fix.Group.__init__(self, 41770, 41771, order)

					class NoUnderlyingDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41774
							order[1] = 41775
							order[2] = 41776
							order[3] = 0
							fix.Group.__init__(self, 41773, 41774, order)

		class NoUnderlyingProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 42150
				order[1] = 42151
				order[2] = 42152
				order[3] = 42190
				order[4] = 42153
				order[5] = 42154
				order[6] = 42155
				order[7] = 43002
				order[8] = 43003
				order[9] = 42156
				order[10] = 42157
				order[11] = 42158
				order[12] = 42104
				order[13] = 42105
				order[14] = 42106
				order[15] = 42107
				order[16] = 42108
				order[17] = 42109
				order[18] = 42110
				order[19] = 42111
				order[20] = 42115
				order[21] = 42116
				order[22] = 42117
				order[23] = 42118
				order[24] = 42119
				order[25] = 42120
				order[26] = 42121
				order[27] = 42122
				order[28] = 42123
				order[29] = 42124
				order[30] = 42125
				order[31] = 42126
				order[32] = 42127
				order[33] = 42128
				order[34] = 42129
				order[35] = 42130
				order[36] = 42131
				order[37] = 42132
				order[38] = 42133
				order[39] = 42134
				order[40] = 42135
				order[41] = 42136
				order[42] = 42137
				order[43] = 42138
				order[44] = 42139
				order[45] = 42140
				order[46] = 42141
				order[47] = 42142
				order[48] = 42143
				order[49] = 42144
				order[50] = 42145
				order[51] = 42146
				order[52] = 42147
				order[53] = 42148
				order[54] = 42159
				order[55] = 42160
				order[56] = 42161
				order[57] = 42162
				order[58] = 42163
				order[59] = 42164
				order[60] = 42165
				order[61] = 42092
				order[62] = 42093
				order[63] = 42094
				order[64] = 42095
				order[65] = 42096
				order[66] = 42097
				order[67] = 42098
				order[68] = 42166
				order[69] = 42167
				order[70] = 42168
				order[71] = 42169
				order[72] = 42102
				order[73] = 42103
				order[74] = 42170
				order[75] = 42171
				order[76] = 42172
				order[77] = 42173
				order[78] = 0
				fix.Group.__init__(self, 42149, 42150, order)

			class NoUnderlyingProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42191
					order[1] = 0
					fix.Group.__init__(self, 42190, 42191, order)

			class NoUnderlyingProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42183
					order[1] = 0
					fix.Group.__init__(self, 42182, 42183, order)

			class NoUnderlyingProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42185
					order[1] = 0
					fix.Group.__init__(self, 42184, 42185, order)

			class NoUnderlyingProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42113
					order[1] = 42114
					order[2] = 0
					fix.Group.__init__(self, 42112, 42113, order)

			class NoUnderlyingProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42187
					order[1] = 0
					fix.Group.__init__(self, 42186, 42187, order)

			class NoUnderlyingProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42189
					order[1] = 0
					fix.Group.__init__(self, 42188, 42189, order)

			class NoUnderlyingProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42181
					order[1] = 0
					fix.Group.__init__(self, 42180, 42181, order)

			class NoUnderlyingProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42100
					order[1] = 42101
					order[2] = 0
					fix.Group.__init__(self, 42099, 42100, order)

			class NoUnderlyingProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 42174
					order[1] = 42175
					order[2] = 42176
					order[3] = 40918
					order[4] = 42177
					order[5] = 0
					fix.Group.__init__(self, 42173, 42174, order)

				class NoUnderlyingProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42178
						order[1] = 42179
						order[2] = 0
						fix.Group.__init__(self, 42177, 42178, order)

		class NoUnderlyingAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 42037
				order[1] = 42038
				order[2] = 41340
				order[3] = 0
				fix.Group.__init__(self, 42036, 42037, order)

			class NoUnderlyingAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41341
					order[1] = 41701
					order[2] = 41709
					order[3] = 41710
					order[4] = 41711
					order[5] = 41712
					order[6] = 42017
					order[7] = 42025
					order[8] = 42026
					order[9] = 42027
					order[10] = 42028
					order[11] = 42029
					order[12] = 42030
					order[13] = 42031
					order[14] = 42032
					order[15] = 42033
					order[16] = 42034
					order[17] = 42035
					order[18] = 0
					fix.Group.__init__(self, 41340, 41341, order)

		class NoUnderlyingProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 42069
				order[1] = 42070
				order[2] = 42071
				order[3] = 42072
				order[4] = 42073
				order[5] = 42074
				order[6] = 42075
				order[7] = 42090
				order[8] = 42077
				order[9] = 42087
				order[10] = 42076
				order[11] = 0
				fix.Group.__init__(self, 42068, 42069, order)

			class NoUnderlyingProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42091
					order[1] = 0
					fix.Group.__init__(self, 42090, 42091, order)

			class NoUnderlyingProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 42078
					order[1] = 42079
					order[2] = 42080
					order[3] = 42081
					order[4] = 42082
					order[5] = 42083
					order[6] = 42084
					order[7] = 42085
					order[8] = 0
					fix.Group.__init__(self, 42077, 42078, order)

				class NoUnderlyingProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42086
						order[1] = 0
						fix.Group.__init__(self, 42085, 42086, order)

			class NoUnderlyingProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42088
					order[1] = 42089
					order[2] = 0
					fix.Group.__init__(self, 42087, 42088, order)

		class NoUnderlyingCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 42042
				order[1] = 42043
				order[2] = 42044
				order[3] = 42045
				order[4] = 42046
				order[5] = 42047
				order[6] = 42048
				order[7] = 42049
				order[8] = 42050
				order[9] = 42051
				order[10] = 42052
				order[11] = 42039
				order[12] = 42797
				order[13] = 42798
				order[14] = 42053
				order[15] = 42054
				order[16] = 42790
				order[17] = 42791
				order[18] = 42792
				order[19] = 42793
				order[20] = 42794
				order[21] = 42795
				order[22] = 42796
				order[23] = 42055
				order[24] = 42056
				order[25] = 42057
				order[26] = 42058
				order[27] = 42059
				order[28] = 0
				fix.Group.__init__(self, 42041, 42042, order)

			class NoUnderlyingCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42040
					order[1] = 0
					fix.Group.__init__(self, 42039, 42040, order)

			class NoUnderlyingCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42789
					order[1] = 0
					fix.Group.__init__(self, 42788, 42789, order)

		class NoUnderlyingPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 42065
				order[1] = 42061
				order[2] = 42062
				order[3] = 42063
				order[4] = 42064
				order[5] = 0
				fix.Group.__init__(self, 42060, 42065, order)

			class NoUnderlyingPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42066
					order[1] = 42067
					order[2] = 0
					fix.Group.__init__(self, 42065, 42066, order)

		class NoUnderlyingRateSpreadSteps(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 43006
				order[1] = 43007
				order[2] = 0
				fix.Group.__init__(self, 43005, 43006, order)

		class NoUnderlyingDividendPayments(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 42856
				order[1] = 42857
				order[2] = 42858
				order[3] = 42859
				order[4] = 0
				fix.Group.__init__(self, 42855, 42856, order)

		class NoUnderlyingExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42885
				order[1] = 42886
				order[2] = 0
				fix.Group.__init__(self, 42884, 42885, order)

	class NoLegs(fix.Group):
		def __init__(self):
			order = fix.IntArray(176)
			order[0] = 600
			order[1] = 601
			order[2] = 602
			order[3] = 603
			order[4] = 1788
			order[5] = 607
			order[6] = 1594
			order[7] = 608
			order[8] = 2893
			order[9] = 609
			order[10] = 764
			order[11] = 610
			order[12] = 611
			order[13] = 1212
			order[14] = 2146
			order[15] = 2147
			order[16] = 2148
			order[17] = 248
			order[18] = 2149
			order[19] = 2150
			order[20] = 2151
			order[21] = 2152
			order[22] = 2153
			order[23] = 2154
			order[24] = 2155
			order[25] = 2348
			order[26] = 2067
			order[27] = 2068
			order[28] = 2069
			order[29] = 2739
			order[30] = 2070
			order[31] = 2156
			order[32] = 2157
			order[33] = 2158
			order[34] = 2159
			order[35] = 2160
			order[36] = 2161
			order[37] = 2162
			order[38] = 2163
			order[39] = 2164
			order[40] = 2165
			order[41] = 2880
			order[42] = 2166
			order[43] = 2167
			order[44] = 2168
			order[45] = 2169
			order[46] = 2170
			order[47] = 2171
			order[48] = 2172
			order[49] = 2173
			order[50] = 2174
			order[51] = 2175
			order[52] = 2176
			order[53] = 2177
			order[54] = 2178
			order[55] = 2179
			order[56] = 2180
			order[57] = 249
			order[58] = 250
			order[59] = 251
			order[60] = 252
			order[61] = 253
			order[62] = 257
			order[63] = 599
			order[64] = 596
			order[65] = 597
			order[66] = 598
			order[67] = 254
			order[68] = 612
			order[69] = 942
			order[70] = 2908
			order[71] = 2181
			order[72] = 2182
			order[73] = 2183
			order[74] = 2184
			order[75] = 2604
			order[76] = 2185
			order[77] = 2605
			order[78] = 2186
			order[79] = 2187
			order[80] = 2188
			order[81] = 2189
			order[82] = 613
			order[83] = 614
			order[84] = 1436
			order[85] = 2354
			order[86] = 1440
			order[87] = 2190
			order[88] = 2191
			order[89] = 999
			order[90] = 1224
			order[91] = 1720
			order[92] = 2909
			order[93] = 1421
			order[94] = 1422
			order[95] = 1721
			order[96] = 2910
			order[97] = 2192
			order[98] = 1001
			order[99] = 1420
			order[100] = 2193
			order[101] = 2194
			order[102] = 2755
			order[103] = 2195
			order[104] = 2196
			order[105] = 2197
			order[106] = 2198
			order[107] = 1528
			order[108] = 2911
			order[109] = 2199
			order[110] = 2200
			order[111] = 2201
			order[112] = 2202
			order[113] = 2203
			order[114] = 615
			order[115] = 616
			order[116] = 2205
			order[117] = 2206
			order[118] = 617
			order[119] = 618
			order[120] = 619
			order[121] = 2740
			order[122] = 2717
			order[123] = 2718
			order[124] = 2719
			order[125] = 620
			order[126] = 621
			order[127] = 622
			order[128] = 2207
			order[129] = 2208
			order[130] = 623
			order[131] = 624
			order[132] = 556
			order[133] = 2898
			order[134] = 740
			order[135] = 739
			order[136] = 955
			order[137] = 956
			order[138] = 1358
			order[139] = 2682
			order[140] = 2686
			order[141] = 1017
			order[142] = 566
			order[143] = 2209
			order[144] = 2211
			order[145] = 2212
			order[146] = 2213
			order[147] = 2754
			order[148] = 2214
			order[149] = 2215
			order[150] = 2606
			order[151] = 2607
			order[152] = 2497
			order[153] = 2498
			order[154] = 2499
			order[155] = 2496
			order[156] = 2495
			order[157] = 2953
			order[158] = 2511
			order[159] = 2510
			order[160] = 2512
			order[161] = 2509
			order[162] = 2500
			order[163] = 2502
			order[164] = 2501
			order[165] = 2503
			order[166] = 2507
			order[167] = 2505
			order[168] = 2494
			order[169] = 2493
			order[170] = 2514
			order[171] = 2513
			order[172] = 2506
			order[173] = 2504
			order[174] = 2508
			order[175] = 0
			fix.Group.__init__(self, 555, 600, order)

		class NoLegSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 605
				order[1] = 606
				order[2] = 2958
				order[3] = 0
				fix.Group.__init__(self, 604, 605, order)

		class NoLegSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2077
				order[1] = 2078
				order[2] = 2079
				order[3] = 2743
				order[4] = 0
				fix.Group.__init__(self, 2076, 2077, order)

		class NoLegAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2309
				order[1] = 2310
				order[2] = 2311
				order[3] = 0
				fix.Group.__init__(self, 2308, 2309, order)

		class NoLegEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 2060
				order[1] = 2061
				order[2] = 2062
				order[3] = 2063
				order[4] = 2064
				order[5] = 2341
				order[6] = 2065
				order[7] = 2066
				order[8] = 2074
				order[9] = 2075
				order[10] = 0
				fix.Group.__init__(self, 2059, 2060, order)

		class NoLegInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 2255
				order[1] = 2256
				order[2] = 2257
				order[3] = 2379
				order[4] = 2258
				order[5] = 0
				fix.Group.__init__(self, 2254, 2255, order)

			class NoLegInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 2259
					order[1] = 2260
					order[2] = 0
					fix.Group.__init__(self, 2258, 2259, order)

		class NoLegComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2219
				order[1] = 2220
				order[2] = 2221
				order[3] = 2222
				order[4] = 2223
				order[5] = 2224
				order[6] = 2225
				order[7] = 2226
				order[8] = 2944
				order[9] = 2227
				order[10] = 2228
				order[11] = 2229
				order[12] = 2230
				order[13] = 2231
				order[14] = 2232
				order[15] = 2250
				order[16] = 2233
				order[17] = 2945
				order[18] = 2234
				order[19] = 2946
				order[20] = 2235
				order[21] = 2236
				order[22] = 2409
				order[23] = 2410
				order[24] = 2237
				order[25] = 2238
				order[26] = 2239
				order[27] = 2240
				order[28] = 2241
				order[29] = 41382
				order[30] = 41389
				order[31] = 41390
				order[32] = 41391
				order[33] = 41392
				order[34] = 41393
				order[35] = 41394
				order[36] = 41395
				order[37] = 41396
				order[38] = 41397
				order[39] = 41379
				order[40] = 2242
				order[41] = 2243
				order[42] = 2244
				order[43] = 2245
				order[44] = 2246
				order[45] = 41398
				order[46] = 41366
				order[47] = 2608
				order[48] = 2609
				order[49] = 2610
				order[50] = 2248
				order[51] = 2249
				order[52] = 0
				fix.Group.__init__(self, 2218, 2219, order)

			class NoLegComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2251
					order[1] = 2252
					order[2] = 2253
					order[3] = 0
					fix.Group.__init__(self, 2250, 2251, order)

				class NoLegComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2204
						order[1] = 2247
						order[2] = 0
						fix.Group.__init__(self, 2253, 2204, order)

			class NoLegComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41383
					order[1] = 41384
					order[2] = 41385
					order[3] = 41386
					order[4] = 0
					fix.Group.__init__(self, 41382, 41383, order)

			class NoLegComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41388
					order[1] = 0
					fix.Group.__init__(self, 41387, 41388, order)

			class NoLegComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41380
					order[1] = 41381
					order[2] = 41400
					order[3] = 41376
					order[4] = 41363
					order[5] = 0
					fix.Group.__init__(self, 41379, 41380, order)

				class NoLegComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41401
						order[1] = 41402
						order[2] = 41403
						order[3] = 41404
						order[4] = 41405
						order[5] = 0
						fix.Group.__init__(self, 41400, 41401, order)

				class NoLegComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41377
						order[1] = 41378
						order[2] = 0
						fix.Group.__init__(self, 41376, 41377, order)

				class NoLegComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41364
						order[1] = 41365
						order[2] = 0
						fix.Group.__init__(self, 41363, 41364, order)

			class NoLegComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41399
					order[1] = 0
					fix.Group.__init__(self, 41398, 41399, order)

			class NoLegComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41367
					order[1] = 41368
					order[2] = 41369
					order[3] = 41370
					order[4] = 41371
					order[5] = 41372
					order[6] = 41373
					order[7] = 41374
					order[8] = 0
					fix.Group.__init__(self, 41366, 41367, order)

				class NoLegComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41375
						order[1] = 0
						fix.Group.__init__(self, 41374, 41375, order)

		class NoLegBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40924
				order[1] = 0
				fix.Group.__init__(self, 40923, 40924, order)

		class NoLegPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41608
				order[1] = 0
				fix.Group.__init__(self, 41607, 41608, order)

		class NoLegMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41468
				order[1] = 40223
				order[2] = 0
				fix.Group.__init__(self, 41467, 41468, order)

		class NoLegMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41470
				order[1] = 40990
				order[2] = 0
				fix.Group.__init__(self, 41469, 41470, order)

		class NoLegMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41472
				order[1] = 41473
				order[2] = 41474
				order[3] = 41475
				order[4] = 41476
				order[5] = 41477
				order[6] = 41478
				order[7] = 41479
				order[8] = 41480
				order[9] = 0
				fix.Group.__init__(self, 41471, 41472, order)

		class NoLegSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42582
				order[1] = 0
				fix.Group.__init__(self, 42581, 42582, order)

		class NoLegOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41492
				order[1] = 0
				fix.Group.__init__(self, 41491, 41492, order)

		class NoLegOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41513
				order[1] = 41514
				order[2] = 0
				fix.Group.__init__(self, 41512, 41513, order)

		class NoLegOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41516
				order[1] = 0
				fix.Group.__init__(self, 41515, 41516, order)

		class NoLegOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41528
				order[1] = 41529
				order[2] = 0
				fix.Group.__init__(self, 41527, 41528, order)

		class NoLegStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40242
				order[1] = 41700
				order[2] = 40243
				order[3] = 42583
				order[4] = 42584
				order[5] = 40244
				order[6] = 40245
				order[7] = 41702
				order[8] = 40246
				order[9] = 40247
				order[10] = 42585
				order[11] = 42586
				order[12] = 41703
				order[13] = 41704
				order[14] = 41705
				order[15] = 41706
				order[16] = 41707
				order[17] = 41708
				order[18] = 41648
				order[19] = 41649
				order[20] = 41650
				order[21] = 41651
				order[22] = 41652
				order[23] = 41653
				order[24] = 41654
				order[25] = 42588
				order[26] = 41655
				order[27] = 41656
				order[28] = 41657
				order[29] = 41658
				order[30] = 41659
				order[31] = 41660
				order[32] = 41661
				order[33] = 41662
				order[34] = 41663
				order[35] = 41664
				order[36] = 41665
				order[37] = 41666
				order[38] = 41667
				order[39] = 41668
				order[40] = 41669
				order[41] = 41670
				order[42] = 41671
				order[43] = 41672
				order[44] = 41673
				order[45] = 40249
				order[46] = 40250
				order[47] = 40252
				order[48] = 40253
				order[49] = 40254
				order[50] = 40255
				order[51] = 40256
				order[52] = 40257
				order[53] = 40258
				order[54] = 40260
				order[55] = 40261
				order[56] = 40262
				order[57] = 40263
				order[58] = 40264
				order[59] = 41641
				order[60] = 41642
				order[61] = 40265
				order[62] = 40267
				order[63] = 40268
				order[64] = 40270
				order[65] = 40271
				order[66] = 40272
				order[67] = 40273
				order[68] = 40274
				order[69] = 40275
				order[70] = 40276
				order[71] = 41643
				order[72] = 41644
				order[73] = 41645
				order[74] = 40279
				order[75] = 40280
				order[76] = 40281
				order[77] = 42399
				order[78] = 40282
				order[79] = 40283
				order[80] = 43108
				order[81] = 40284
				order[82] = 40285
				order[83] = 40286
				order[84] = 40287
				order[85] = 40288
				order[86] = 42400
				order[87] = 42401
				order[88] = 42402
				order[89] = 42403
				order[90] = 40289
				order[91] = 40290
				order[92] = 40291
				order[93] = 41549
				order[94] = 41550
				order[95] = 41551
				order[96] = 41552
				order[97] = 41553
				order[98] = 41554
				order[99] = 41555
				order[100] = 42404
				order[101] = 40374
				order[102] = 40418
				order[103] = 41429
				order[104] = 41430
				order[105] = 41431
				order[106] = 41432
				order[107] = 41433
				order[108] = 42194
				order[109] = 42195
				order[110] = 41434
				order[111] = 41435
				order[112] = 41436
				order[113] = 41437
				order[114] = 41438
				order[115] = 41219
				order[116] = 41439
				order[117] = 41440
				order[118] = 41441
				order[119] = 41442
				order[120] = 41443
				order[121] = 41444
				order[122] = 41445
				order[123] = 41446
				order[124] = 41447
				order[125] = 41448
				order[126] = 41449
				order[127] = 41450
				order[128] = 41451
				order[129] = 43095
				order[130] = 41408
				order[131] = 40248
				order[132] = 40978
				order[133] = 40979
				order[134] = 0
				fix.Group.__init__(self, 40241, 40242, order)

			class NoLegStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41675
					order[1] = 41676
					order[2] = 0
					fix.Group.__init__(self, 41674, 41675, order)

			class NoLegStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41453
					order[1] = 41454
					order[2] = 41455
					order[3] = 0
					fix.Group.__init__(self, 41452, 41453, order)

			class NoLegStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41678
					order[1] = 41679
					order[2] = 0
					fix.Group.__init__(self, 41677, 41678, order)

			class NoLegStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41647
					order[1] = 0
					fix.Group.__init__(self, 41646, 41647, order)

			class NoLegStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41687
					order[1] = 41688
					order[2] = 41689
					order[3] = 41690
					order[4] = 41691
					order[5] = 41692
					order[6] = 41693
					order[7] = 41694
					order[8] = 41695
					order[9] = 41696
					order[10] = 41697
					order[11] = 41680
					order[12] = 41698
					order[13] = 41699
					order[14] = 0
					fix.Group.__init__(self, 41686, 41687, order)

				class NoLegStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41681
						order[1] = 41682
						order[2] = 41683
						order[3] = 0
						fix.Group.__init__(self, 41680, 41681, order)

					class NoLegStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41684
							order[1] = 41685
							order[2] = 41935
							order[3] = 0
							fix.Group.__init__(self, 41683, 41684, order)

			class NoLegStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40251
					order[1] = 0
					fix.Group.__init__(self, 40942, 40251, order)

			class NoLegStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40259
					order[1] = 0
					fix.Group.__init__(self, 40943, 40259, order)

			class NoLegStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40266
					order[1] = 0
					fix.Group.__init__(self, 40940, 40266, order)

			class NoLegStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41639
					order[1] = 41640
					order[2] = 0
					fix.Group.__init__(self, 41638, 41639, order)

			class NoLegStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40269
					order[1] = 0
					fix.Group.__init__(self, 40941, 40269, order)

			class NoLegPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40293
					order[1] = 0
					fix.Group.__init__(self, 40930, 40293, order)

			class NoLegPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41590
					order[1] = 41591
					order[2] = 0
					fix.Group.__init__(self, 41589, 41590, order)

			class NoLegPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40305
					order[1] = 0
					fix.Group.__init__(self, 40931, 40305, order)

			class NoLegPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40311
					order[1] = 0
					fix.Group.__init__(self, 40932, 40311, order)

			class NoLegPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40318
					order[1] = 0
					fix.Group.__init__(self, 40933, 40318, order)

			class NoLegPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42460
					order[1] = 42461
					order[2] = 0
					fix.Group.__init__(self, 42459, 42460, order)

			class NoLegPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41562
					order[1] = 0
					fix.Group.__init__(self, 41561, 41562, order)

			class NoLegPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41597
					order[1] = 41598
					order[2] = 0
					fix.Group.__init__(self, 41596, 41597, order)

			class NoLegPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41594
					order[1] = 41595
					order[2] = 0
					fix.Group.__init__(self, 41593, 41594, order)

			class NoLegPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43110
					order[1] = 42486
					order[2] = 42487
					order[3] = 0
					fix.Group.__init__(self, 42485, 43110, order)

			class NoLegDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42367
					order[1] = 42368
					order[2] = 42369
					order[3] = 42370
					order[4] = 42371
					order[5] = 42372
					order[6] = 42386
					order[7] = 42373
					order[8] = 42374
					order[9] = 42375
					order[10] = 42376
					order[11] = 42377
					order[12] = 42378
					order[13] = 42379
					order[14] = 42380
					order[15] = 42381
					order[16] = 42382
					order[17] = 42383
					order[18] = 42384
					order[19] = 42385
					order[20] = 0
					fix.Group.__init__(self, 42366, 42367, order)

				class NoLegDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42387
						order[1] = 0
						fix.Group.__init__(self, 42386, 42387, order)

			class NoLegDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42365
					order[1] = 0
					fix.Group.__init__(self, 42364, 42365, order)

			class NoLegDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42311
					order[1] = 0
					fix.Group.__init__(self, 42310, 42311, order)

			class NoLegReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 42535
					order[1] = 42536
					order[2] = 42537
					order[3] = 42538
					order[4] = 42539
					order[5] = 42540
					order[6] = 42564
					order[7] = 42530
					order[8] = 42541
					order[9] = 42542
					order[10] = 42543
					order[11] = 42544
					order[12] = 42545
					order[13] = 42546
					order[14] = 42547
					order[15] = 42548
					order[16] = 42549
					order[17] = 42550
					order[18] = 42551
					order[19] = 42552
					order[20] = 42560
					order[21] = 42553
					order[22] = 42554
					order[23] = 42508
					order[24] = 42555
					order[25] = 42556
					order[26] = 42557
					order[27] = 42558
					order[28] = 42559
					order[29] = 0
					fix.Group.__init__(self, 42534, 42535, order)

				class NoLegReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 42565
						order[1] = 42566
						order[2] = 42567
						order[3] = 42568
						order[4] = 0
						fix.Group.__init__(self, 42564, 42565, order)

				class NoLegReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42531
						order[1] = 42532
						order[2] = 42533
						order[3] = 0
						fix.Group.__init__(self, 42530, 42531, order)

				class NoLegReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42561
						order[1] = 42562
						order[2] = 42563
						order[3] = 0
						fix.Group.__init__(self, 42560, 42561, order)

				class NoLegReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 42509
						order[1] = 42571
						order[2] = 42510
						order[3] = 42511
						order[4] = 42512
						order[5] = 42513
						order[6] = 42514
						order[7] = 42515
						order[8] = 42516
						order[9] = 42517
						order[10] = 42518
						order[11] = 42519
						order[12] = 42520
						order[13] = 42521
						order[14] = 42522
						order[15] = 42523
						order[16] = 42524
						order[17] = 42525
						order[18] = 42526
						order[19] = 42527
						order[20] = 42528
						order[21] = 42529
						order[22] = 42569
						order[23] = 0
						fix.Group.__init__(self, 42508, 42509, order)

					class NoLegReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 42572
							order[1] = 42573
							order[2] = 0
							fix.Group.__init__(self, 42571, 42572, order)

					class NoLegReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 42570
							order[1] = 0
							fix.Group.__init__(self, 42569, 42570, order)

			class NoLegPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42420
					order[1] = 0
					fix.Group.__init__(self, 42419, 42420, order)

			class NoLegPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42406
					order[1] = 42407
					order[2] = 0
					fix.Group.__init__(self, 42405, 42406, order)

			class NoLegPaymentStreamNonDeliverableFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40361
					order[1] = 0
					fix.Group.__init__(self, 40929, 40361, order)

			class NoLegNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40368
					order[1] = 40369
					order[2] = 0
					fix.Group.__init__(self, 40367, 40368, order)

			class NoLegSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40903
					order[1] = 40366
					order[2] = 40370
					order[3] = 40905
					order[4] = 40906
					order[5] = 0
					fix.Group.__init__(self, 40902, 40903, order)

			class NoLegPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40375
					order[1] = 41533
					order[2] = 41534
					order[3] = 40376
					order[4] = 40377
					order[5] = 40378
					order[6] = 40379
					order[7] = 40380
					order[8] = 40381
					order[9] = 40382
					order[10] = 40383
					order[11] = 40384
					order[12] = 40385
					order[13] = 41535
					order[14] = 41536
					order[15] = 41537
					order[16] = 41538
					order[17] = 40386
					order[18] = 40387
					order[19] = 40388
					order[20] = 40389
					order[21] = 41539
					order[22] = 41540
					order[23] = 41541
					order[24] = 41542
					order[25] = 40390
					order[26] = 40391
					order[27] = 40392
					order[28] = 40393
					order[29] = 40394
					order[30] = 40395
					order[31] = 40414
					order[32] = 40396
					order[33] = 40397
					order[34] = 40398
					order[35] = 40399
					order[36] = 40927
					order[37] = 40401
					order[38] = 40402
					order[39] = 40403
					order[40] = 41543
					order[41] = 41544
					order[42] = 40404
					order[43] = 41530
					order[44] = 41545
					order[45] = 41546
					order[46] = 41547
					order[47] = 41548
					order[48] = 40405
					order[49] = 40406
					order[50] = 40407
					order[51] = 40408
					order[52] = 40928
					order[53] = 40410
					order[54] = 40411
					order[55] = 40412
					order[56] = 40413
					order[57] = 0
					fix.Group.__init__(self, 40374, 40375, order)

				class NoLegPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40415
						order[1] = 40416
						order[2] = 40417
						order[3] = 0
						fix.Group.__init__(self, 40414, 40415, order)

				class NoLegPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40400
						order[1] = 0
						fix.Group.__init__(self, 40927, 40400, order)

				class NoLegPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41531
						order[1] = 41532
						order[2] = 0
						fix.Group.__init__(self, 41530, 41531, order)

				class NoLegPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40409
						order[1] = 0
						fix.Group.__init__(self, 40928, 40409, order)

			class NoLegPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40419
					order[1] = 40420
					order[2] = 42497
					order[3] = 42498
					order[4] = 42499
					order[5] = 42500
					order[6] = 42501
					order[7] = 42502
					order[8] = 42503
					order[9] = 42488
					order[10] = 42489
					order[11] = 42490
					order[12] = 42491
					order[13] = 42492
					order[14] = 42493
					order[15] = 42494
					order[16] = 40421
					order[17] = 40422
					order[18] = 40423
					order[19] = 40424
					order[20] = 40425
					order[21] = 40426
					order[22] = 40427
					order[23] = 40428
					order[24] = 40429
					order[25] = 40430
					order[26] = 40431
					order[27] = 40432
					order[28] = 40433
					order[29] = 40434
					order[30] = 40435
					order[31] = 40436
					order[32] = 40437
					order[33] = 40438
					order[34] = 40439
					order[35] = 40440
					order[36] = 40441
					order[37] = 40442
					order[38] = 40443
					order[39] = 40444
					order[40] = 40445
					order[41] = 40446
					order[42] = 40447
					order[43] = 0
					fix.Group.__init__(self, 40418, 40419, order)

				class NoLegPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42505
						order[1] = 0
						fix.Group.__init__(self, 42504, 42505, order)

				class NoLegPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42496
						order[1] = 0
						fix.Group.__init__(self, 42495, 42496, order)

			class NoLegDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41461
					order[1] = 0
					fix.Group.__init__(self, 41460, 41461, order)

			class NoLegDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41457
					order[1] = 41458
					order[2] = 41459
					order[3] = 0
					fix.Group.__init__(self, 41456, 41457, order)

			class NoLegDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41409
					order[1] = 41410
					order[2] = 41411
					order[3] = 41412
					order[4] = 41413
					order[5] = 41414
					order[6] = 41415
					order[7] = 41416
					order[8] = 41417
					order[9] = 41418
					order[10] = 41419
					order[11] = 41420
					order[12] = 41421
					order[13] = 41422
					order[14] = 0
					fix.Group.__init__(self, 41408, 41409, order)

				class NoLegDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41423
						order[1] = 41424
						order[2] = 41425
						order[3] = 0
						fix.Group.__init__(self, 41422, 41423, order)

					class NoLegDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41426
							order[1] = 41427
							order[2] = 41428
							order[3] = 0
							fix.Group.__init__(self, 41425, 41426, order)

		class NoLegProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 40449
				order[1] = 40450
				order[2] = 40451
				order[3] = 40939
				order[4] = 40453
				order[5] = 40454
				order[6] = 40455
				order[7] = 42506
				order[8] = 42507
				order[9] = 40456
				order[10] = 40457
				order[11] = 40458
				order[12] = 40524
				order[13] = 40525
				order[14] = 40526
				order[15] = 40528
				order[16] = 40529
				order[17] = 40530
				order[18] = 40531
				order[19] = 40532
				order[20] = 40476
				order[21] = 40478
				order[22] = 40479
				order[23] = 40480
				order[24] = 40481
				order[25] = 40482
				order[26] = 40483
				order[27] = 40484
				order[28] = 40485
				order[29] = 40486
				order[30] = 40487
				order[31] = 40488
				order[32] = 40489
				order[33] = 40490
				order[34] = 40491
				order[35] = 40492
				order[36] = 40493
				order[37] = 40494
				order[38] = 40498
				order[39] = 40499
				order[40] = 40501
				order[41] = 40502
				order[42] = 40503
				order[43] = 40504
				order[44] = 40505
				order[45] = 40506
				order[46] = 40507
				order[47] = 40508
				order[48] = 40509
				order[49] = 40511
				order[50] = 40512
				order[51] = 40513
				order[52] = 40514
				order[53] = 40515
				order[54] = 40459
				order[55] = 40460
				order[56] = 40461
				order[57] = 40462
				order[58] = 40463
				order[59] = 40464
				order[60] = 40465
				order[61] = 40516
				order[62] = 40518
				order[63] = 40519
				order[64] = 40520
				order[65] = 40521
				order[66] = 40522
				order[67] = 40523
				order[68] = 40466
				order[69] = 40467
				order[70] = 40468
				order[71] = 40469
				order[72] = 40470
				order[73] = 41407
				order[74] = 40472
				order[75] = 40980
				order[76] = 40981
				order[77] = 40533
				order[78] = 0
				fix.Group.__init__(self, 40448, 40449, order)

			class NoLegProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40452
					order[1] = 0
					fix.Group.__init__(self, 40939, 40452, order)

			class NoLegProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40527
					order[1] = 0
					fix.Group.__init__(self, 40935, 40527, order)

			class NoLegProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40477
					order[1] = 0
					fix.Group.__init__(self, 40936, 40477, order)

			class NoLegProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40496
					order[1] = 40497
					order[2] = 0
					fix.Group.__init__(self, 40495, 40496, order)

			class NoLegProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40500
					order[1] = 0
					fix.Group.__init__(self, 40937, 40500, order)

			class NoLegProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40510
					order[1] = 0
					fix.Group.__init__(self, 40938, 40510, order)

			class NoLegProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40517
					order[1] = 0
					fix.Group.__init__(self, 40934, 40517, order)

			class NoLegProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40474
					order[1] = 40475
					order[2] = 0
					fix.Group.__init__(self, 40473, 40474, order)

			class NoLegProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40534
					order[1] = 40535
					order[2] = 40536
					order[3] = 2380
					order[4] = 40537
					order[5] = 0
					fix.Group.__init__(self, 40533, 40534, order)

				class NoLegProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40538
						order[1] = 40539
						order[2] = 0
						fix.Group.__init__(self, 40537, 40538, order)

		class NoLegAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41336
				order[1] = 41337
				order[2] = 41316
				order[3] = 0
				fix.Group.__init__(self, 41335, 41336, order)

			class NoLegAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41317
					order[1] = 41318
					order[2] = 41319
					order[3] = 41320
					order[4] = 41321
					order[5] = 41322
					order[6] = 41323
					order[7] = 41324
					order[8] = 41325
					order[9] = 41326
					order[10] = 41327
					order[11] = 41328
					order[12] = 41329
					order[13] = 41330
					order[14] = 41331
					order[15] = 41332
					order[16] = 41333
					order[17] = 41334
					order[18] = 0
					fix.Group.__init__(self, 41316, 41317, order)

		class NoLegProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 41618
				order[1] = 41619
				order[2] = 41620
				order[3] = 41621
				order[4] = 41622
				order[5] = 41623
				order[6] = 41624
				order[7] = 41614
				order[8] = 41625
				order[9] = 41635
				order[10] = 41617
				order[11] = 0
				fix.Group.__init__(self, 41616, 41618, order)

			class NoLegProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41615
					order[1] = 0
					fix.Group.__init__(self, 41614, 41615, order)

			class NoLegProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41626
					order[1] = 41627
					order[2] = 41628
					order[3] = 41629
					order[4] = 41630
					order[5] = 41631
					order[6] = 41632
					order[7] = 41633
					order[8] = 0
					fix.Group.__init__(self, 41625, 41626, order)

				class NoLegProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41634
						order[1] = 0
						fix.Group.__init__(self, 41633, 41634, order)

			class NoLegProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41636
					order[1] = 41637
					order[2] = 0
					fix.Group.__init__(self, 41635, 41636, order)

		class NoLegCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 41345
				order[1] = 41346
				order[2] = 41347
				order[3] = 41348
				order[4] = 41349
				order[5] = 41350
				order[6] = 41351
				order[7] = 41352
				order[8] = 41353
				order[9] = 41354
				order[10] = 41355
				order[11] = 41342
				order[12] = 42308
				order[13] = 42309
				order[14] = 41356
				order[15] = 41357
				order[16] = 42299
				order[17] = 42300
				order[18] = 42301
				order[19] = 42302
				order[20] = 42303
				order[21] = 42304
				order[22] = 42305
				order[23] = 41358
				order[24] = 41359
				order[25] = 41360
				order[26] = 41361
				order[27] = 41362
				order[28] = 0
				fix.Group.__init__(self, 41344, 41345, order)

			class NoLegCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41343
					order[1] = 0
					fix.Group.__init__(self, 41342, 41343, order)

			class NoLegCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42307
					order[1] = 0
					fix.Group.__init__(self, 42306, 42307, order)

		class NoLegPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41604
				order[1] = 41601
				order[2] = 41602
				order[3] = 41603
				order[4] = 41600
				order[5] = 0
				fix.Group.__init__(self, 41599, 41604, order)

			class NoLegPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41605
					order[1] = 41606
					order[2] = 0
					fix.Group.__init__(self, 41604, 41605, order)

		class NoLegExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42389
				order[1] = 42390
				order[2] = 0
				fix.Group.__init__(self, 42388, 42389, order)

		class NoLegContractualDefinitions(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42199
				order[1] = 0
				fix.Group.__init__(self, 42198, 42199, order)

		class NoLegFinancingTermSupplements(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42201
				order[1] = 42202
				order[2] = 0
				fix.Group.__init__(self, 42200, 42201, order)

		class NoLegContractualMatrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 42204
				order[1] = 42205
				order[2] = 42206
				order[3] = 0
				fix.Group.__init__(self, 42203, 42204, order)

	class NoLinesOfText(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 58
			order[1] = 354
			order[2] = 355
			order[3] = 0
			fix.Group.__init__(self, 33, 58, order)

	class NoAttachments(fix.Group):
		def __init__(self):
			order = fix.IntArray(10)
			order[0] = 2105
			order[1] = 2106
			order[2] = 2107
			order[3] = 2108
			order[4] = 2109
			order[5] = 2110
			order[6] = 2111
			order[7] = 2112
			order[8] = 2113
			order[9] = 0
			fix.Group.__init__(self, 2104, 2105, order)

		class NoAttachmentKeywords(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 2114
				order[1] = 0
				fix.Group.__init__(self, 2113, 2114, order)

class NewOrderSingle(Message):
	def __init__(self):
		Message.__init__(self)
		self.getHeader().setField( fix.MsgType("D") )

	class NoPartyIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 448
			order[1] = 447
			order[2] = 452
			order[3] = 2376
			order[4] = 802
			order[5] = 0
			fix.Group.__init__(self, 453, 448, order)

		class NoPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 523
				order[1] = 803
				order[2] = 0
				fix.Group.__init__(self, 802, 523, order)

	class NoTargetPartyIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1462
			order[1] = 1463
			order[2] = 1464
			order[3] = 1818
			order[4] = 2433
			order[5] = 0
			fix.Group.__init__(self, 1461, 1462, order)

		class NoTargetPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 2434
				order[1] = 2435
				order[2] = 0
				fix.Group.__init__(self, 2433, 2434, order)

	class NoAllocs(fix.Group):
		def __init__(self):
			order = fix.IntArray(14)
			order[0] = 79
			order[1] = 661
			order[2] = 736
			order[3] = 2927
			order[4] = 467
			order[5] = 2727
			order[6] = 539
			order[7] = 209
			order[8] = 80
			order[9] = 1752
			order[10] = 1753
			order[11] = 1754
			order[12] = 1755
			order[13] = 0
			fix.Group.__init__(self, 78, 79, order)

		class NoNestedPartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 524
				order[1] = 525
				order[2] = 538
				order[3] = 2384
				order[4] = 804
				order[5] = 0
				fix.Group.__init__(self, 539, 524, order)

			class NoNestedPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 545
					order[1] = 805
					order[2] = 0
					fix.Group.__init__(self, 804, 545, order)

	class NoValueChecks(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 1869
			order[1] = 1870
			order[2] = 0
			fix.Group.__init__(self, 1868, 1869, order)

	class NoMatchInst(fix.Group):
		def __init__(self):
			order = fix.IntArray(5)
			order[0] = 1625
			order[1] = 1673
			order[2] = 1626
			order[3] = 1627
			order[4] = 0
			fix.Group.__init__(self, 1624, 1625, order)

	class NoDisclosureInstructions(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 1813
			order[1] = 1814
			order[2] = 0
			fix.Group.__init__(self, 1812, 1813, order)

	class NoTradingSessions(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 336
			order[1] = 625
			order[2] = 0
			fix.Group.__init__(self, 386, 336, order)

	class NoSecurityAltID(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 455
			order[1] = 456
			order[2] = 2957
			order[3] = 0
			fix.Group.__init__(self, 454, 455, order)

	class NoSecondaryAssetClasses(fix.Group):
		def __init__(self):
			order = fix.IntArray(5)
			order[0] = 1977
			order[1] = 1978
			order[2] = 1979
			order[3] = 2741
			order[4] = 0
			fix.Group.__init__(self, 1976, 1977, order)

	class NoAssetAttributes(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 2305
			order[1] = 2306
			order[2] = 2307
			order[3] = 0
			fix.Group.__init__(self, 2304, 2305, order)

	class NoEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(11)
			order[0] = 865
			order[1] = 866
			order[2] = 1145
			order[3] = 1827
			order[4] = 1826
			order[5] = 2340
			order[6] = 867
			order[7] = 868
			order[8] = 1578
			order[9] = 1579
			order[10] = 0
			fix.Group.__init__(self, 864, 865, order)

	class NoInstrumentParties(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1019
			order[1] = 1050
			order[2] = 1051
			order[3] = 2378
			order[4] = 1052
			order[5] = 0
			fix.Group.__init__(self, 1018, 1019, order)

		class NoInstrumentPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 1053
				order[1] = 1054
				order[2] = 0
				fix.Group.__init__(self, 1052, 1053, order)

	class NoComplexEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(53)
			order[0] = 1484
			order[1] = 2117
			order[2] = 2118
			order[3] = 2119
			order[4] = 1485
			order[5] = 2120
			order[6] = 2121
			order[7] = 2122
			order[8] = 2941
			order[9] = 1486
			order[10] = 2123
			order[11] = 1487
			order[12] = 1488
			order[13] = 1489
			order[14] = 1490
			order[15] = 1491
			order[16] = 2124
			order[17] = 2942
			order[18] = 2125
			order[19] = 2943
			order[20] = 2126
			order[21] = 2127
			order[22] = 2407
			order[23] = 2408
			order[24] = 2128
			order[25] = 2129
			order[26] = 2130
			order[27] = 2131
			order[28] = 2132
			order[29] = 41013
			order[30] = 41020
			order[31] = 41021
			order[32] = 41022
			order[33] = 41023
			order[34] = 41024
			order[35] = 41025
			order[36] = 41026
			order[37] = 41027
			order[38] = 41028
			order[39] = 41010
			order[40] = 2133
			order[41] = 2134
			order[42] = 2135
			order[43] = 2136
			order[44] = 2137
			order[45] = 41029
			order[46] = 40997
			order[47] = 2597
			order[48] = 2598
			order[49] = 2599
			order[50] = 2138
			order[51] = 2139
			order[52] = 0
			fix.Group.__init__(self, 1483, 1484, order)

		class NoComplexEventDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 1492
				order[1] = 1493
				order[2] = 1494
				order[3] = 0
				fix.Group.__init__(self, 1491, 1492, order)

			class NoComplexEventTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1495
					order[1] = 1496
					order[2] = 0
					fix.Group.__init__(self, 1494, 1495, order)

		class NoComplexEventRateSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 41014
				order[1] = 41015
				order[2] = 41016
				order[3] = 41017
				order[4] = 0
				fix.Group.__init__(self, 41013, 41014, order)

		class NoComplexEventDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41019
				order[1] = 0
				fix.Group.__init__(self, 41018, 41019, order)

		class NoComplexEventPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41011
				order[1] = 41012
				order[2] = 41031
				order[3] = 41007
				order[4] = 40994
				order[5] = 0
				fix.Group.__init__(self, 41010, 41011, order)

			class NoComplexEventSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41032
					order[1] = 41033
					order[2] = 41034
					order[3] = 41035
					order[4] = 41036
					order[5] = 0
					fix.Group.__init__(self, 41031, 41032, order)

			class NoComplexEventPeriodDateTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41008
					order[1] = 41009
					order[2] = 0
					fix.Group.__init__(self, 41007, 41008, order)

			class NoComplexEventAveragingObservations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40995
					order[1] = 40996
					order[2] = 0
					fix.Group.__init__(self, 40994, 40995, order)

		class NoComplexEventCreditEventSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41030
				order[1] = 0
				fix.Group.__init__(self, 41029, 41030, order)

		class NoComplexEventCreditEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40998
				order[1] = 40999
				order[2] = 41000
				order[3] = 41001
				order[4] = 41002
				order[5] = 41003
				order[6] = 41004
				order[7] = 41005
				order[8] = 0
				fix.Group.__init__(self, 40997, 40998, order)

			class NoComplexEventCreditEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41006
					order[1] = 0
					fix.Group.__init__(self, 41005, 41006, order)

	class NoBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40471
			order[1] = 0
			fix.Group.__init__(self, 40278, 40471, order)

	class NoPricingDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41231
			order[1] = 0
			fix.Group.__init__(self, 41230, 41231, order)

	class NoMarketDisruptionEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41093
			order[1] = 40991
			order[2] = 0
			fix.Group.__init__(self, 41092, 41093, order)

	class NoMarketDisruptionFallbacks(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41095
			order[1] = 40992
			order[2] = 0
			fix.Group.__init__(self, 41094, 41095, order)

	class NoMarketDisruptionFallbackReferencePrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(10)
			order[0] = 41097
			order[1] = 41098
			order[2] = 41099
			order[3] = 41100
			order[4] = 41101
			order[5] = 41102
			order[6] = 41103
			order[7] = 41104
			order[8] = 41105
			order[9] = 0
			fix.Group.__init__(self, 41096, 41097, order)

	class NoSettlMethodElectionDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 42776
			order[1] = 0
			fix.Group.__init__(self, 42775, 42776, order)

	class NoOptionExerciseBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41117
			order[1] = 0
			fix.Group.__init__(self, 41116, 41117, order)

	class NoOptionExerciseDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41138
			order[1] = 41139
			order[2] = 0
			fix.Group.__init__(self, 41137, 41138, order)

	class NoOptionExerciseExpirationDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41141
			order[1] = 0
			fix.Group.__init__(self, 41140, 41141, order)

	class NoOptionExerciseExpirationDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41153
			order[1] = 41154
			order[2] = 0
			fix.Group.__init__(self, 41152, 41153, order)

	class NoStreams(fix.Group):
		def __init__(self):
			order = fix.IntArray(135)
			order[0] = 40050
			order[1] = 41303
			order[2] = 40051
			order[3] = 42784
			order[4] = 42785
			order[5] = 40052
			order[6] = 40053
			order[7] = 41305
			order[8] = 40054
			order[9] = 40055
			order[10] = 42786
			order[11] = 42787
			order[12] = 41306
			order[13] = 41307
			order[14] = 41308
			order[15] = 41309
			order[16] = 41310
			order[17] = 41311
			order[18] = 41251
			order[19] = 41252
			order[20] = 41253
			order[21] = 41254
			order[22] = 41255
			order[23] = 41256
			order[24] = 41257
			order[25] = 42587
			order[26] = 41258
			order[27] = 41259
			order[28] = 41260
			order[29] = 41261
			order[30] = 41262
			order[31] = 41263
			order[32] = 41264
			order[33] = 41265
			order[34] = 41266
			order[35] = 41267
			order[36] = 41268
			order[37] = 41269
			order[38] = 41270
			order[39] = 41271
			order[40] = 41272
			order[41] = 41273
			order[42] = 41274
			order[43] = 41275
			order[44] = 41276
			order[45] = 40907
			order[46] = 40908
			order[47] = 40910
			order[48] = 40911
			order[49] = 40912
			order[50] = 40913
			order[51] = 40914
			order[52] = 40065
			order[53] = 40066
			order[54] = 40068
			order[55] = 40069
			order[56] = 40070
			order[57] = 40071
			order[58] = 40072
			order[59] = 41244
			order[60] = 41245
			order[61] = 40073
			order[62] = 40075
			order[63] = 40076
			order[64] = 40078
			order[65] = 40079
			order[66] = 40080
			order[67] = 40081
			order[68] = 40082
			order[69] = 40083
			order[70] = 40084
			order[71] = 41246
			order[72] = 41247
			order[73] = 41248
			order[74] = 40738
			order[75] = 40739
			order[76] = 40740
			order[77] = 42600
			order[78] = 40741
			order[79] = 40742
			order[80] = 43106
			order[81] = 40743
			order[82] = 40744
			order[83] = 40745
			order[84] = 40746
			order[85] = 40747
			order[86] = 42601
			order[87] = 42602
			order[88] = 42603
			order[89] = 42604
			order[90] = 40748
			order[91] = 40749
			order[92] = 40750
			order[93] = 41180
			order[94] = 41181
			order[95] = 41182
			order[96] = 41183
			order[97] = 41184
			order[98] = 41185
			order[99] = 41186
			order[100] = 42605
			order[101] = 40828
			order[102] = 40872
			order[103] = 41058
			order[104] = 41059
			order[105] = 41060
			order[106] = 41061
			order[107] = 41062
			order[108] = 42192
			order[109] = 42193
			order[110] = 41063
			order[111] = 41064
			order[112] = 41065
			order[113] = 41066
			order[114] = 41067
			order[115] = 41218
			order[116] = 41068
			order[117] = 41069
			order[118] = 41070
			order[119] = 41071
			order[120] = 41072
			order[121] = 41073
			order[122] = 41074
			order[123] = 41075
			order[124] = 41076
			order[125] = 41077
			order[126] = 41078
			order[127] = 41079
			order[128] = 41080
			order[129] = 43094
			order[130] = 41037
			order[131] = 40056
			order[132] = 40982
			order[133] = 40983
			order[134] = 0
			fix.Group.__init__(self, 40049, 40050, order)

		class NoStreamCommodityAltIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41278
				order[1] = 41279
				order[2] = 0
				fix.Group.__init__(self, 41277, 41278, order)

		class NoStreamAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41238
				order[1] = 41239
				order[2] = 41240
				order[3] = 0
				fix.Group.__init__(self, 41237, 41238, order)

		class NoStreamCommodityDataSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41281
				order[1] = 41282
				order[2] = 0
				fix.Group.__init__(self, 41280, 41281, order)

		class NoStreamCommoditySettlBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41250
				order[1] = 0
				fix.Group.__init__(self, 41249, 41250, order)

		class NoStreamCommoditySettlPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41290
				order[1] = 41291
				order[2] = 41292
				order[3] = 41293
				order[4] = 41294
				order[5] = 41295
				order[6] = 41296
				order[7] = 41297
				order[8] = 41298
				order[9] = 41299
				order[10] = 41300
				order[11] = 41283
				order[12] = 41301
				order[13] = 41302
				order[14] = 0
				fix.Group.__init__(self, 41289, 41290, order)

			class NoStreamCommoditySettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41284
					order[1] = 41285
					order[2] = 41286
					order[3] = 0
					fix.Group.__init__(self, 41283, 41284, order)

				class NoStreamCommoditySettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41287
						order[1] = 41288
						order[2] = 41588
						order[3] = 0
						fix.Group.__init__(self, 41286, 41287, order)

		class NoStreamEffectiveDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40909
				order[1] = 0
				fix.Group.__init__(self, 40960, 40909, order)

		class NoStreamTerminationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40067
				order[1] = 0
				fix.Group.__init__(self, 40961, 40067, order)

		class NoStreamCalculationPeriodBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40074
				order[1] = 0
				fix.Group.__init__(self, 40958, 40074, order)

		class NoStreamCalculationPeriodDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41242
				order[1] = 41243
				order[2] = 0
				fix.Group.__init__(self, 41241, 41242, order)

		class NoStreamFirstPeriodStartDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40077
				order[1] = 0
				fix.Group.__init__(self, 40959, 40077, order)

		class NoPaymentStreamPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40752
				order[1] = 0
				fix.Group.__init__(self, 40947, 40752, order)

		class NoPaymentStreamPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41221
				order[1] = 41222
				order[2] = 0
				fix.Group.__init__(self, 41220, 41221, order)

		class NoPaymentStreamResetDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40763
				order[1] = 0
				fix.Group.__init__(self, 40948, 40763, order)

		class NoPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40769
				order[1] = 0
				fix.Group.__init__(self, 40949, 40769, order)

		class NoPaymentStreamFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40776
				order[1] = 0
				fix.Group.__init__(self, 40950, 40776, order)

		class NoPaymentStreamFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42661
				order[1] = 42662
				order[2] = 0
				fix.Group.__init__(self, 42660, 42661, order)

		class NoPaymentStreamPricingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41193
				order[1] = 0
				fix.Group.__init__(self, 41192, 41193, order)

		class NoPaymentStreamPricingDays(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41228
				order[1] = 41229
				order[2] = 0
				fix.Group.__init__(self, 41227, 41228, order)

		class NoPaymentStreamPricingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41225
				order[1] = 41226
				order[2] = 0
				fix.Group.__init__(self, 41224, 41225, order)

		class NoPaymentStreamFormulas(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 43109
				order[1] = 42684
				order[2] = 42685
				order[3] = 0
				fix.Group.__init__(self, 42683, 43109, order)

		class NoDividendPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(21)
				order[0] = 42275
				order[1] = 42276
				order[2] = 42277
				order[3] = 42278
				order[4] = 42279
				order[5] = 42280
				order[6] = 42294
				order[7] = 42281
				order[8] = 42282
				order[9] = 42283
				order[10] = 42284
				order[11] = 42285
				order[12] = 42286
				order[13] = 42287
				order[14] = 42288
				order[15] = 42289
				order[16] = 42290
				order[17] = 42291
				order[18] = 42292
				order[19] = 42293
				order[20] = 0
				fix.Group.__init__(self, 42274, 42275, order)

			class NoDividendPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42295
					order[1] = 0
					fix.Group.__init__(self, 42294, 42295, order)

		class NoDividendFXTriggerDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42273
				order[1] = 0
				fix.Group.__init__(self, 42272, 42273, order)

		class NoDividendAccrualPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42237
				order[1] = 0
				fix.Group.__init__(self, 42236, 42237, order)

		class NoReturnRates(fix.Group):
			def __init__(self):
				order = fix.IntArray(30)
				order[0] = 42736
				order[1] = 42737
				order[2] = 42738
				order[3] = 42739
				order[4] = 42740
				order[5] = 42741
				order[6] = 42765
				order[7] = 42731
				order[8] = 42742
				order[9] = 42743
				order[10] = 42744
				order[11] = 42745
				order[12] = 42746
				order[13] = 42747
				order[14] = 42748
				order[15] = 42749
				order[16] = 42750
				order[17] = 42751
				order[18] = 42752
				order[19] = 42753
				order[20] = 42761
				order[21] = 42754
				order[22] = 42755
				order[23] = 42709
				order[24] = 42756
				order[25] = 42757
				order[26] = 42758
				order[27] = 42759
				order[28] = 42760
				order[29] = 0
				fix.Group.__init__(self, 42735, 42736, order)

			class NoReturnRatePrices(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 42766
					order[1] = 42767
					order[2] = 42768
					order[3] = 42769
					order[4] = 0
					fix.Group.__init__(self, 42765, 42766, order)

			class NoReturnRateFXConversions(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42732
					order[1] = 42733
					order[2] = 42734
					order[3] = 0
					fix.Group.__init__(self, 42731, 42732, order)

			class NoReturnRateInformationSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42762
					order[1] = 42763
					order[2] = 42764
					order[3] = 0
					fix.Group.__init__(self, 42761, 42762, order)

			class NoReturnRateDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(24)
					order[0] = 42710
					order[1] = 42772
					order[2] = 42711
					order[3] = 42712
					order[4] = 42713
					order[5] = 42714
					order[6] = 42715
					order[7] = 42716
					order[8] = 42717
					order[9] = 42718
					order[10] = 42719
					order[11] = 42720
					order[12] = 42721
					order[13] = 42722
					order[14] = 42723
					order[15] = 42724
					order[16] = 42725
					order[17] = 42726
					order[18] = 42727
					order[19] = 42728
					order[20] = 42729
					order[21] = 42730
					order[22] = 42770
					order[23] = 0
					fix.Group.__init__(self, 42709, 42710, order)

				class NoReturnRateValuationDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42773
						order[1] = 42774
						order[2] = 0
						fix.Group.__init__(self, 42772, 42773, order)

				class NoReturnRateValuationDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42771
						order[1] = 0
						fix.Group.__init__(self, 42770, 42771, order)

		class NoPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42621
				order[1] = 0
				fix.Group.__init__(self, 42620, 42621, order)

		class NoPaymentStreamCompoundingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42607
				order[1] = 42608
				order[2] = 0
				fix.Group.__init__(self, 42606, 42607, order)

		class NoPaymentStreamNonDeliverableFixingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40819
				order[1] = 0
				fix.Group.__init__(self, 40946, 40819, order)

		class NoNonDeliverableFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40826
				order[1] = 40827
				order[2] = 0
				fix.Group.__init__(self, 40825, 40826, order)

		class NoSettlRateFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40086
				order[1] = 40373
				order[2] = 40655
				order[3] = 40088
				order[4] = 40089
				order[5] = 0
				fix.Group.__init__(self, 40085, 40086, order)

		class NoPaymentSchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(58)
				order[0] = 40829
				order[1] = 41164
				order[2] = 41165
				order[3] = 40830
				order[4] = 40831
				order[5] = 40832
				order[6] = 40833
				order[7] = 40834
				order[8] = 40835
				order[9] = 40836
				order[10] = 40837
				order[11] = 40838
				order[12] = 40839
				order[13] = 41166
				order[14] = 41167
				order[15] = 41168
				order[16] = 41169
				order[17] = 40840
				order[18] = 40841
				order[19] = 40842
				order[20] = 40843
				order[21] = 41170
				order[22] = 41171
				order[23] = 41172
				order[24] = 41173
				order[25] = 40844
				order[26] = 40845
				order[27] = 40846
				order[28] = 40847
				order[29] = 40848
				order[30] = 40849
				order[31] = 40868
				order[32] = 40850
				order[33] = 40851
				order[34] = 40852
				order[35] = 40853
				order[36] = 40977
				order[37] = 40855
				order[38] = 40856
				order[39] = 40857
				order[40] = 41174
				order[41] = 41175
				order[42] = 40858
				order[43] = 41161
				order[44] = 41176
				order[45] = 41177
				order[46] = 41178
				order[47] = 41179
				order[48] = 40859
				order[49] = 40860
				order[50] = 40861
				order[51] = 40862
				order[52] = 40945
				order[53] = 40864
				order[54] = 40865
				order[55] = 40866
				order[56] = 40867
				order[57] = 0
				fix.Group.__init__(self, 40828, 40829, order)

			class NoPaymentScheduleRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 40869
					order[1] = 40870
					order[2] = 40871
					order[3] = 0
					fix.Group.__init__(self, 40868, 40869, order)

			class NoPaymentScheduleFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40854
					order[1] = 0
					fix.Group.__init__(self, 40977, 40854, order)

			class NoPaymentScheduleFixingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41162
					order[1] = 41163
					order[2] = 0
					fix.Group.__init__(self, 41161, 41162, order)

			class NoPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40863
					order[1] = 0
					fix.Group.__init__(self, 40945, 40863, order)

		class NoPaymentStubs(fix.Group):
			def __init__(self):
				order = fix.IntArray(44)
				order[0] = 40873
				order[1] = 40874
				order[2] = 42698
				order[3] = 42699
				order[4] = 42700
				order[5] = 42701
				order[6] = 42702
				order[7] = 42703
				order[8] = 42704
				order[9] = 42689
				order[10] = 42690
				order[11] = 42691
				order[12] = 42692
				order[13] = 42693
				order[14] = 42694
				order[15] = 42695
				order[16] = 40875
				order[17] = 40876
				order[18] = 40877
				order[19] = 40878
				order[20] = 40879
				order[21] = 40880
				order[22] = 40881
				order[23] = 40882
				order[24] = 40883
				order[25] = 40884
				order[26] = 40885
				order[27] = 40886
				order[28] = 40887
				order[29] = 40888
				order[30] = 40889
				order[31] = 40890
				order[32] = 40891
				order[33] = 40892
				order[34] = 40893
				order[35] = 40894
				order[36] = 40895
				order[37] = 40896
				order[38] = 40897
				order[39] = 40898
				order[40] = 40899
				order[41] = 40900
				order[42] = 40901
				order[43] = 0
				fix.Group.__init__(self, 40872, 40873, order)

			class NoPaymentStubStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42706
					order[1] = 0
					fix.Group.__init__(self, 42705, 42706, order)

			class NoPaymentStubEndDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42697
					order[1] = 0
					fix.Group.__init__(self, 42696, 42697, order)

		class NoDeliveryStreamCommoditySources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41086
				order[1] = 0
				fix.Group.__init__(self, 41085, 41086, order)

		class NoDeliveryStreamCycles(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41082
				order[1] = 41083
				order[2] = 41084
				order[3] = 0
				fix.Group.__init__(self, 41081, 41082, order)

		class NoDeliverySchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41038
				order[1] = 41039
				order[2] = 41040
				order[3] = 41041
				order[4] = 41042
				order[5] = 41043
				order[6] = 41044
				order[7] = 41045
				order[8] = 41046
				order[9] = 41047
				order[10] = 41048
				order[11] = 41049
				order[12] = 41050
				order[13] = 41051
				order[14] = 0
				fix.Group.__init__(self, 41037, 41038, order)

			class NoDeliveryScheduleSettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41052
					order[1] = 41053
					order[2] = 41054
					order[3] = 0
					fix.Group.__init__(self, 41051, 41052, order)

				class NoDeliveryScheduleSettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41055
						order[1] = 41056
						order[2] = 41057
						order[3] = 0
						fix.Group.__init__(self, 41054, 41055, order)

	class NoProvisions(fix.Group):
		def __init__(self):
			order = fix.IntArray(79)
			order[0] = 40091
			order[1] = 40092
			order[2] = 40093
			order[3] = 40957
			order[4] = 40095
			order[5] = 40096
			order[6] = 40097
			order[7] = 42707
			order[8] = 42708
			order[9] = 40098
			order[10] = 40099
			order[11] = 40100
			order[12] = 40114
			order[13] = 40115
			order[14] = 40116
			order[15] = 40118
			order[16] = 40119
			order[17] = 40120
			order[18] = 40121
			order[19] = 40122
			order[20] = 40123
			order[21] = 40125
			order[22] = 40126
			order[23] = 40127
			order[24] = 40128
			order[25] = 40129
			order[26] = 40130
			order[27] = 40131
			order[28] = 40132
			order[29] = 40133
			order[30] = 40134
			order[31] = 40135
			order[32] = 40136
			order[33] = 40137
			order[34] = 40138
			order[35] = 40139
			order[36] = 40140
			order[37] = 40141
			order[38] = 40145
			order[39] = 40146
			order[40] = 40148
			order[41] = 40149
			order[42] = 40150
			order[43] = 40151
			order[44] = 40152
			order[45] = 40153
			order[46] = 40154
			order[47] = 40155
			order[48] = 40156
			order[49] = 40158
			order[50] = 40159
			order[51] = 40160
			order[52] = 40161
			order[53] = 40162
			order[54] = 40101
			order[55] = 40102
			order[56] = 40103
			order[57] = 40104
			order[58] = 40105
			order[59] = 40106
			order[60] = 40107
			order[61] = 40163
			order[62] = 40165
			order[63] = 40166
			order[64] = 40167
			order[65] = 40168
			order[66] = 40169
			order[67] = 40170
			order[68] = 40108
			order[69] = 40109
			order[70] = 40110
			order[71] = 40111
			order[72] = 40112
			order[73] = 41406
			order[74] = 40113
			order[75] = 40986
			order[76] = 40987
			order[77] = 40174
			order[78] = 0
			fix.Group.__init__(self, 40090, 40091, order)

		class NoProvisionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40094
				order[1] = 0
				fix.Group.__init__(self, 40957, 40094, order)

		class NoProvisionCashSettlValueDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40117
				order[1] = 0
				fix.Group.__init__(self, 40953, 40117, order)

		class NoProvisionOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40124
				order[1] = 0
				fix.Group.__init__(self, 40954, 40124, order)

		class NoProvisionOptionExerciseFixedDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40143
				order[1] = 40144
				order[2] = 0
				fix.Group.__init__(self, 40142, 40143, order)

		class NoProvisionOptionExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40147
				order[1] = 0
				fix.Group.__init__(self, 40955, 40147, order)

		class NoProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40157
				order[1] = 0
				fix.Group.__init__(self, 40956, 40157, order)

		class NoProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40164
				order[1] = 0
				fix.Group.__init__(self, 40952, 40164, order)

		class NoProvisionCashSettlPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40172
				order[1] = 40173
				order[2] = 0
				fix.Group.__init__(self, 40171, 40172, order)

		class NoProvisionPartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40175
				order[1] = 40176
				order[2] = 40177
				order[3] = 2385
				order[4] = 40178
				order[5] = 0
				fix.Group.__init__(self, 40174, 40175, order)

			class NoProvisionPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40179
					order[1] = 40180
					order[2] = 0
					fix.Group.__init__(self, 40178, 40179, order)

	class NoAdditionalTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40020
			order[1] = 40021
			order[2] = 40000
			order[3] = 0
			fix.Group.__init__(self, 40019, 40020, order)

		class NoAdditionalTermBondRefs(fix.Group):
			def __init__(self):
				order = fix.IntArray(19)
				order[0] = 40001
				order[1] = 40002
				order[2] = 40003
				order[3] = 40004
				order[4] = 40005
				order[5] = 40006
				order[6] = 40007
				order[7] = 40008
				order[8] = 40009
				order[9] = 40010
				order[10] = 40011
				order[11] = 40012
				order[12] = 40013
				order[13] = 40014
				order[14] = 40015
				order[15] = 40016
				order[16] = 40017
				order[17] = 40018
				order[18] = 0
				fix.Group.__init__(self, 40000, 40001, order)

	class NoProtectionTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(12)
			order[0] = 40182
			order[1] = 40183
			order[2] = 40184
			order[3] = 40185
			order[4] = 40186
			order[5] = 40187
			order[6] = 40188
			order[7] = 40951
			order[8] = 40191
			order[9] = 40201
			order[10] = 40190
			order[11] = 0
			fix.Group.__init__(self, 40181, 40182, order)

		class NoProtectionTermEventNewsSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40189
				order[1] = 0
				fix.Group.__init__(self, 40951, 40189, order)

		class NoProtectionTermEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40192
				order[1] = 40193
				order[2] = 40194
				order[3] = 40195
				order[4] = 40196
				order[5] = 40197
				order[6] = 40198
				order[7] = 40199
				order[8] = 0
				fix.Group.__init__(self, 40191, 40192, order)

			class NoProtectionTermEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40200
					order[1] = 0
					fix.Group.__init__(self, 40199, 40200, order)

		class NoProtectionTermObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40202
				order[1] = 40203
				order[2] = 0
				fix.Group.__init__(self, 40201, 40202, order)

	class NoCashSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(29)
			order[0] = 40023
			order[1] = 40024
			order[2] = 40916
			order[3] = 40917
			order[4] = 40025
			order[5] = 40026
			order[6] = 40027
			order[7] = 40028
			order[8] = 40029
			order[9] = 40030
			order[10] = 40031
			order[11] = 40277
			order[12] = 42216
			order[13] = 42217
			order[14] = 40033
			order[15] = 40034
			order[16] = 42207
			order[17] = 42208
			order[18] = 42209
			order[19] = 42210
			order[20] = 42211
			order[21] = 42212
			order[22] = 42213
			order[23] = 40035
			order[24] = 40036
			order[25] = 40037
			order[26] = 40038
			order[27] = 40039
			order[28] = 0
			fix.Group.__init__(self, 40022, 40023, order)

		class NoCashSettlDealers(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40032
				order[1] = 0
				fix.Group.__init__(self, 40277, 40032, order)

		class NoCashSettlDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42215
				order[1] = 0
				fix.Group.__init__(self, 42214, 42215, order)

	class NoPhysicalSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 40209
			order[1] = 40205
			order[2] = 40206
			order[3] = 40207
			order[4] = 40208
			order[5] = 0
			fix.Group.__init__(self, 40204, 40209, order)

		class NoPhysicalSettlDeliverableObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40210
				order[1] = 40211
				order[2] = 0
				fix.Group.__init__(self, 40209, 40210, order)

	class NoExtraordinaryEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 42297
			order[1] = 42298
			order[2] = 0
			fix.Group.__init__(self, 42296, 42297, order)

	class NoContractualDefinitions(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40041
			order[1] = 0
			fix.Group.__init__(self, 40040, 40041, order)

	class NoFinancingTermSupplements(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 40047
			order[1] = 40048
			order[2] = 0
			fix.Group.__init__(self, 40046, 40047, order)

	class NoContractualMatrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40043
			order[1] = 40044
			order[2] = 40045
			order[3] = 0
			fix.Group.__init__(self, 40042, 40043, order)

	class NoUnderlyings(fix.Group):
		def __init__(self):
			order = fix.IntArray(188)
			order[0] = 311
			order[1] = 312
			order[2] = 309
			order[3] = 305
			order[4] = 2874
			order[5] = 462
			order[6] = 463
			order[7] = 2894
			order[8] = 310
			order[9] = 763
			order[10] = 313
			order[11] = 542
			order[12] = 1213
			order[13] = 1837
			order[14] = 241
			order[15] = 1453
			order[16] = 1454
			order[17] = 2614
			order[18] = 2615
			order[19] = 2921
			order[20] = 2616
			order[21] = 2617
			order[22] = 2619
			order[23] = 1455
			order[24] = 1456
			order[25] = 1459
			order[26] = 1460
			order[27] = 242
			order[28] = 243
			order[29] = 244
			order[30] = 245
			order[31] = 246
			order[32] = 256
			order[33] = 595
			order[34] = 592
			order[35] = 593
			order[36] = 594
			order[37] = 247
			order[38] = 316
			order[39] = 941
			order[40] = 2917
			order[41] = 317
			order[42] = 436
			order[43] = 1437
			order[44] = 2363
			order[45] = 1441
			order[46] = 998
			order[47] = 1423
			order[48] = 1718
			order[49] = 2918
			order[50] = 1424
			order[51] = 1425
			order[52] = 1719
			order[53] = 2919
			order[54] = 1000
			order[55] = 1419
			order[56] = 1526
			order[57] = 2920
			order[58] = 435
			order[59] = 308
			order[60] = 306
			order[61] = 362
			order[62] = 363
			order[63] = 2742
			order[64] = 2720
			order[65] = 2721
			order[66] = 2722
			order[67] = 2723
			order[68] = 2724
			order[69] = 307
			order[70] = 364
			order[71] = 365
			order[72] = 877
			order[73] = 878
			order[74] = 972
			order[75] = 318
			order[76] = 2916
			order[77] = 879
			order[78] = 975
			order[79] = 973
			order[80] = 974
			order[81] = 810
			order[82] = 882
			order[83] = 883
			order[84] = 884
			order[85] = 885
			order[86] = 886
			order[87] = 2885
			order[88] = 2886
			order[89] = 1044
			order[90] = 1045
			order[91] = 1046
			order[92] = 1038
			order[93] = 1039
			order[94] = 315
			order[95] = 2683
			order[96] = 2687
			order[97] = 1988
			order[98] = 1989
			order[99] = 1990
			order[100] = 1991
			order[101] = 1992
			order[102] = 1993
			order[103] = 2881
			order[104] = 1994
			order[105] = 1995
			order[106] = 1996
			order[107] = 1997
			order[108] = 2620
			order[109] = 2621
			order[110] = 1998
			order[111] = 1999
			order[112] = 2000
			order[113] = 2003
			order[114] = 2004
			order[115] = 2005
			order[116] = 2006
			order[117] = 2284
			order[118] = 2285
			order[119] = 2286
			order[120] = 2287
			order[121] = 2288
			order[122] = 2007
			order[123] = 2008
			order[124] = 2009
			order[125] = 2010
			order[126] = 2011
			order[127] = 2012
			order[128] = 2491
			order[129] = 2013
			order[130] = 2014
			order[131] = 2015
			order[132] = 2744
			order[133] = 2016
			order[134] = 2289
			order[135] = 2017
			order[136] = 2018
			order[137] = 2019
			order[138] = 2020
			order[139] = 2021
			order[140] = 2022
			order[141] = 2290
			order[142] = 2622
			order[143] = 2291
			order[144] = 2623
			order[145] = 2292
			order[146] = 2023
			order[147] = 2024
			order[148] = 2025
			order[149] = 2026
			order[150] = 2027
			order[151] = 2028
			order[152] = 2029
			order[153] = 2757
			order[154] = 2030
			order[155] = 2031
			order[156] = 2293
			order[157] = 2294
			order[158] = 2032
			order[159] = 2033
			order[160] = 2034
			order[161] = 2035
			order[162] = 2036
			order[163] = 2037
			order[164] = 2038
			order[165] = 2039
			order[166] = 2040
			order[167] = 2041
			order[168] = 2042
			order[169] = 2043
			order[170] = 2044
			order[171] = 41314
			order[172] = 41315
			order[173] = 2295
			order[174] = 2296
			order[175] = 2297
			order[176] = 2756
			order[177] = 2298
			order[178] = 2299
			order[179] = 2624
			order[180] = 2625
			order[181] = 2626
			order[182] = 2627
			order[183] = 2628
			order[184] = 2629
			order[185] = 2630
			order[186] = 2631
			order[187] = 0
			fix.Group.__init__(self, 711, 311, order)

		class NoUnderlyingSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 458
				order[1] = 459
				order[2] = 2959
				order[3] = 0
				fix.Group.__init__(self, 457, 458, order)

		class NoUnderlyingStips(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 888
				order[1] = 889
				order[2] = 0
				fix.Group.__init__(self, 887, 888, order)

		class NoUndlyInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1059
				order[1] = 1060
				order[2] = 1061
				order[3] = 2391
				order[4] = 1062
				order[5] = 0
				fix.Group.__init__(self, 1058, 1059, order)

			class NoUndlyInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1063
					order[1] = 1064
					order[2] = 0
					fix.Group.__init__(self, 1062, 1063, order)

		class NoUnderlyingEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 1982
				order[1] = 1983
				order[2] = 1984
				order[3] = 1985
				order[4] = 1986
				order[5] = 2342
				order[6] = 1987
				order[7] = 2071
				order[8] = 2072
				order[9] = 2073
				order[10] = 0
				fix.Group.__init__(self, 1981, 1982, order)

		class NoUnderlyingSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2081
				order[1] = 2082
				order[2] = 2083
				order[3] = 2745
				order[4] = 0
				fix.Group.__init__(self, 2080, 2081, order)

		class NoUnderlyingAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2313
				order[1] = 2314
				order[2] = 2315
				order[3] = 0
				fix.Group.__init__(self, 2312, 2313, order)

		class NoUnderlyingComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2046
				order[1] = 2261
				order[2] = 2262
				order[3] = 2263
				order[4] = 2047
				order[5] = 2264
				order[6] = 2265
				order[7] = 2266
				order[8] = 2947
				order[9] = 2048
				order[10] = 2267
				order[11] = 2049
				order[12] = 2050
				order[13] = 2051
				order[14] = 2052
				order[15] = 2053
				order[16] = 2268
				order[17] = 2948
				order[18] = 2269
				order[19] = 2949
				order[20] = 2270
				order[21] = 2271
				order[22] = 2419
				order[23] = 2420
				order[24] = 2272
				order[25] = 2273
				order[26] = 2274
				order[27] = 2275
				order[28] = 2276
				order[29] = 41732
				order[30] = 41739
				order[31] = 41740
				order[32] = 41741
				order[33] = 41742
				order[34] = 41743
				order[35] = 41744
				order[36] = 41745
				order[37] = 41746
				order[38] = 41747
				order[39] = 41729
				order[40] = 2277
				order[41] = 2278
				order[42] = 2279
				order[43] = 2280
				order[44] = 2281
				order[45] = 41748
				order[46] = 41716
				order[47] = 2611
				order[48] = 2612
				order[49] = 2613
				order[50] = 2282
				order[51] = 2283
				order[52] = 0
				fix.Group.__init__(self, 2045, 2046, order)

			class NoUnderlyingComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2054
					order[1] = 2055
					order[2] = 2056
					order[3] = 0
					fix.Group.__init__(self, 2053, 2054, order)

				class NoUnderlyingComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2057
						order[1] = 2058
						order[2] = 0
						fix.Group.__init__(self, 2056, 2057, order)

			class NoUnderlyingComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41733
					order[1] = 41734
					order[2] = 41735
					order[3] = 41736
					order[4] = 0
					fix.Group.__init__(self, 41732, 41733, order)

			class NoUnderlyingComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41738
					order[1] = 0
					fix.Group.__init__(self, 41737, 41738, order)

			class NoUnderlyingComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41730
					order[1] = 41731
					order[2] = 41750
					order[3] = 41726
					order[4] = 41713
					order[5] = 0
					fix.Group.__init__(self, 41729, 41730, order)

				class NoUnderlyingComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41751
						order[1] = 41752
						order[2] = 41753
						order[3] = 41754
						order[4] = 41755
						order[5] = 0
						fix.Group.__init__(self, 41750, 41751, order)

				class NoUnderlyingComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41727
						order[1] = 41728
						order[2] = 0
						fix.Group.__init__(self, 41726, 41727, order)

				class NoUnderlyingComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41714
						order[1] = 41715
						order[2] = 0
						fix.Group.__init__(self, 41713, 41714, order)

			class NoUnderlyingComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41749
					order[1] = 0
					fix.Group.__init__(self, 41748, 41749, order)

			class NoUnderlyingComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41717
					order[1] = 41718
					order[2] = 41719
					order[3] = 41720
					order[4] = 41721
					order[5] = 41722
					order[6] = 41723
					order[7] = 41724
					order[8] = 0
					fix.Group.__init__(self, 41716, 41717, order)

				class NoUnderlyingComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41725
						order[1] = 0
						fix.Group.__init__(self, 41724, 41725, order)

		class NoUnderlyingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40963
				order[1] = 0
				fix.Group.__init__(self, 40962, 40963, order)

		class NoUnderlyingPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41948
				order[1] = 0
				fix.Group.__init__(self, 41947, 41948, order)

		class NoUnderlyingMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41865
				order[1] = 41338
				order[2] = 0
				fix.Group.__init__(self, 41864, 41865, order)

		class NoUnderlyingMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41867
				order[1] = 41339
				order[2] = 0
				fix.Group.__init__(self, 41866, 41867, order)

		class NoUnderlyingMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41869
				order[1] = 41870
				order[2] = 41871
				order[3] = 41872
				order[4] = 41873
				order[5] = 41874
				order[6] = 41875
				order[7] = 41876
				order[8] = 41877
				order[9] = 0
				fix.Group.__init__(self, 41868, 41869, order)

		class NoUnderlyingSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 43075
				order[1] = 0
				fix.Group.__init__(self, 43074, 43075, order)

		class NoUnderlyingOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41821
				order[1] = 0
				fix.Group.__init__(self, 41820, 41821, order)

		class NoUnderlyingOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41842
				order[1] = 41843
				order[2] = 0
				fix.Group.__init__(self, 41841, 41842, order)

		class NoUnderlyingOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41845
				order[1] = 0
				fix.Group.__init__(self, 41844, 41845, order)

		class NoUnderlyingOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41857
				order[1] = 41858
				order[2] = 0
				fix.Group.__init__(self, 41856, 41857, order)

		class NoUnderlyingStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40541
				order[1] = 42016
				order[2] = 40542
				order[3] = 43083
				order[4] = 43084
				order[5] = 40543
				order[6] = 40544
				order[7] = 42018
				order[8] = 40545
				order[9] = 40546
				order[10] = 43085
				order[11] = 43086
				order[12] = 42019
				order[13] = 42020
				order[14] = 42021
				order[15] = 42022
				order[16] = 42023
				order[17] = 42024
				order[18] = 41964
				order[19] = 41965
				order[20] = 41966
				order[21] = 41967
				order[22] = 41968
				order[23] = 41969
				order[24] = 41970
				order[25] = 42589
				order[26] = 41971
				order[27] = 41972
				order[28] = 41973
				order[29] = 41974
				order[30] = 41975
				order[31] = 41976
				order[32] = 41977
				order[33] = 41978
				order[34] = 41979
				order[35] = 41980
				order[36] = 41981
				order[37] = 41982
				order[38] = 41983
				order[39] = 41984
				order[40] = 41985
				order[41] = 41986
				order[42] = 41987
				order[43] = 41988
				order[44] = 41989
				order[45] = 40057
				order[46] = 40058
				order[47] = 40060
				order[48] = 40061
				order[49] = 40062
				order[50] = 40063
				order[51] = 40064
				order[52] = 40548
				order[53] = 40549
				order[54] = 40551
				order[55] = 40552
				order[56] = 40553
				order[57] = 40554
				order[58] = 40555
				order[59] = 41957
				order[60] = 41958
				order[61] = 40556
				order[62] = 40558
				order[63] = 40559
				order[64] = 40561
				order[65] = 40562
				order[66] = 40563
				order[67] = 40564
				order[68] = 40565
				order[69] = 40566
				order[70] = 40567
				order[71] = 41959
				order[72] = 41960
				order[73] = 41961
				order[74] = 40568
				order[75] = 40569
				order[76] = 40570
				order[77] = 42895
				order[78] = 40571
				order[79] = 40572
				order[80] = 43107
				order[81] = 40573
				order[82] = 40574
				order[83] = 40575
				order[84] = 40576
				order[85] = 40577
				order[86] = 42896
				order[87] = 42897
				order[88] = 42898
				order[89] = 42899
				order[90] = 40578
				order[91] = 40579
				order[92] = 40580
				order[93] = 41897
				order[94] = 41898
				order[95] = 41899
				order[96] = 41900
				order[97] = 41901
				order[98] = 41902
				order[99] = 41903
				order[100] = 42900
				order[101] = 40664
				order[102] = 40708
				order[103] = 41777
				order[104] = 41778
				order[105] = 41779
				order[106] = 41780
				order[107] = 41781
				order[108] = 42196
				order[109] = 42197
				order[110] = 41782
				order[111] = 41783
				order[112] = 41784
				order[113] = 41785
				order[114] = 41786
				order[115] = 41587
				order[116] = 41787
				order[117] = 41788
				order[118] = 41789
				order[119] = 41790
				order[120] = 41791
				order[121] = 41792
				order[122] = 41793
				order[123] = 41794
				order[124] = 41795
				order[125] = 41796
				order[126] = 41797
				order[127] = 41798
				order[128] = 41799
				order[129] = 43096
				order[130] = 41756
				order[131] = 40547
				order[132] = 40988
				order[133] = 40989
				order[134] = 0
				fix.Group.__init__(self, 40540, 40541, order)

			class NoUnderlyingStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41991
					order[1] = 41992
					order[2] = 0
					fix.Group.__init__(self, 41990, 41991, order)

			class NoUnderlyingStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41801
					order[1] = 41802
					order[2] = 41803
					order[3] = 0
					fix.Group.__init__(self, 41800, 41801, order)

			class NoUnderlyingStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41994
					order[1] = 41995
					order[2] = 0
					fix.Group.__init__(self, 41993, 41994, order)

			class NoUnderlyingStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41963
					order[1] = 0
					fix.Group.__init__(self, 41962, 41963, order)

			class NoUnderlyingStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 42003
					order[1] = 42004
					order[2] = 42005
					order[3] = 42006
					order[4] = 42007
					order[5] = 42008
					order[6] = 42009
					order[7] = 42010
					order[8] = 42011
					order[9] = 42012
					order[10] = 42013
					order[11] = 41996
					order[12] = 42014
					order[13] = 42015
					order[14] = 0
					fix.Group.__init__(self, 42002, 42003, order)

				class NoUnderlyingStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41997
						order[1] = 41998
						order[2] = 41999
						order[3] = 0
						fix.Group.__init__(self, 41996, 41997, order)

					class NoUnderlyingStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 42000
							order[1] = 42001
							order[2] = 41936
							order[3] = 0
							fix.Group.__init__(self, 41999, 42000, order)

			class NoUnderlyingStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40059
					order[1] = 0
					fix.Group.__init__(self, 40975, 40059, order)

			class NoUnderlyingStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40550
					order[1] = 0
					fix.Group.__init__(self, 40976, 40550, order)

			class NoUnderlyingStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40557
					order[1] = 0
					fix.Group.__init__(self, 40973, 40557, order)

			class NoUnderlyingStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41955
					order[1] = 41956
					order[2] = 0
					fix.Group.__init__(self, 41954, 41955, order)

			class NoUnderlyingStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40560
					order[1] = 0
					fix.Group.__init__(self, 40974, 40560, order)

			class NoUnderlyingPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40582
					order[1] = 0
					fix.Group.__init__(self, 40969, 40582, order)

			class NoUnderlyingPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41938
					order[1] = 41939
					order[2] = 0
					fix.Group.__init__(self, 41937, 41938, order)

			class NoUnderlyingPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40594
					order[1] = 0
					fix.Group.__init__(self, 40970, 40594, order)

			class NoUnderlyingPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40600
					order[1] = 0
					fix.Group.__init__(self, 40971, 40600, order)

			class NoUnderlyingPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40607
					order[1] = 0
					fix.Group.__init__(self, 40972, 40607, order)

			class NoUnderlyingPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42956
					order[1] = 42957
					order[2] = 0
					fix.Group.__init__(self, 42955, 42956, order)

			class NoUnderlyingPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41910
					order[1] = 0
					fix.Group.__init__(self, 41909, 41910, order)

			class NoUnderlyingPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41945
					order[1] = 41946
					order[2] = 0
					fix.Group.__init__(self, 41944, 41945, order)

			class NoUnderlyingPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41942
					order[1] = 41943
					order[2] = 0
					fix.Group.__init__(self, 41941, 41942, order)

			class NoUnderlyingPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43111
					order[1] = 42982
					order[2] = 42983
					order[3] = 0
					fix.Group.__init__(self, 42981, 43111, order)

			class NoUnderlyingDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42863
					order[1] = 42864
					order[2] = 42865
					order[3] = 42866
					order[4] = 42867
					order[5] = 42868
					order[6] = 42882
					order[7] = 42869
					order[8] = 42870
					order[9] = 42871
					order[10] = 42872
					order[11] = 42873
					order[12] = 42874
					order[13] = 42875
					order[14] = 42876
					order[15] = 42877
					order[16] = 42878
					order[17] = 42879
					order[18] = 42880
					order[19] = 42881
					order[20] = 0
					fix.Group.__init__(self, 42862, 42863, order)

				class NoUnderlyingDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42883
						order[1] = 0
						fix.Group.__init__(self, 42882, 42883, order)

			class NoUnderlyingDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42854
					order[1] = 0
					fix.Group.__init__(self, 42853, 42854, order)

			class NoUnderlyingDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42800
					order[1] = 0
					fix.Group.__init__(self, 42799, 42800, order)

			class NoUnderlyingReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 43035
					order[1] = 43036
					order[2] = 43037
					order[3] = 43038
					order[4] = 43039
					order[5] = 43040
					order[6] = 43064
					order[7] = 43030
					order[8] = 43041
					order[9] = 43042
					order[10] = 43043
					order[11] = 43044
					order[12] = 43045
					order[13] = 43046
					order[14] = 43047
					order[15] = 43048
					order[16] = 43049
					order[17] = 43050
					order[18] = 43051
					order[19] = 43052
					order[20] = 43060
					order[21] = 43053
					order[22] = 43054
					order[23] = 43008
					order[24] = 43055
					order[25] = 43056
					order[26] = 43057
					order[27] = 43058
					order[28] = 43059
					order[29] = 0
					fix.Group.__init__(self, 43034, 43035, order)

				class NoUnderlyingReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 43065
						order[1] = 43066
						order[2] = 43067
						order[3] = 43068
						order[4] = 0
						fix.Group.__init__(self, 43064, 43065, order)

				class NoUnderlyingReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43031
						order[1] = 43032
						order[2] = 43033
						order[3] = 0
						fix.Group.__init__(self, 43030, 43031, order)

				class NoUnderlyingReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43061
						order[1] = 43062
						order[2] = 43063
						order[3] = 0
						fix.Group.__init__(self, 43060, 43061, order)

				class NoUnderlyingReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 43009
						order[1] = 43071
						order[2] = 43010
						order[3] = 43011
						order[4] = 43012
						order[5] = 43013
						order[6] = 43014
						order[7] = 43015
						order[8] = 43016
						order[9] = 43017
						order[10] = 43018
						order[11] = 43019
						order[12] = 43020
						order[13] = 43021
						order[14] = 43022
						order[15] = 43023
						order[16] = 43024
						order[17] = 43025
						order[18] = 43026
						order[19] = 43027
						order[20] = 43028
						order[21] = 43029
						order[22] = 43069
						order[23] = 0
						fix.Group.__init__(self, 43008, 43009, order)

					class NoUnderlyingReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 43072
							order[1] = 43073
							order[2] = 0
							fix.Group.__init__(self, 43071, 43072, order)

					class NoUnderlyingReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 43070
							order[1] = 0
							fix.Group.__init__(self, 43069, 43070, order)

			class NoUnderlyingPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42916
					order[1] = 0
					fix.Group.__init__(self, 42915, 42916, order)

			class NoUnderlyingPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42902
					order[1] = 42903
					order[2] = 0
					fix.Group.__init__(self, 42901, 42902, order)

			class NoUnderlyingPaymentStreamNonDeliverableFixingDatesBizCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40650
					order[1] = 0
					fix.Group.__init__(self, 40968, 40650, order)

			class NoUnderlyingNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40657
					order[1] = 40658
					order[2] = 0
					fix.Group.__init__(self, 40656, 40657, order)

			class NoUnderlyingSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40660
					order[1] = 40904
					order[2] = 40915
					order[3] = 40662
					order[4] = 40663
					order[5] = 0
					fix.Group.__init__(self, 40659, 40660, order)

			class NoUnderlyingPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40665
					order[1] = 41881
					order[2] = 41882
					order[3] = 40666
					order[4] = 40667
					order[5] = 40668
					order[6] = 40669
					order[7] = 40670
					order[8] = 40671
					order[9] = 40672
					order[10] = 40673
					order[11] = 40674
					order[12] = 40675
					order[13] = 41883
					order[14] = 41884
					order[15] = 41885
					order[16] = 41886
					order[17] = 40676
					order[18] = 40677
					order[19] = 40678
					order[20] = 40679
					order[21] = 41887
					order[22] = 41888
					order[23] = 41889
					order[24] = 41890
					order[25] = 40680
					order[26] = 40681
					order[27] = 40682
					order[28] = 40683
					order[29] = 40684
					order[30] = 40685
					order[31] = 40704
					order[32] = 40686
					order[33] = 40687
					order[34] = 40688
					order[35] = 40689
					order[36] = 40966
					order[37] = 40691
					order[38] = 40692
					order[39] = 40693
					order[40] = 41891
					order[41] = 41892
					order[42] = 40694
					order[43] = 41878
					order[44] = 41893
					order[45] = 41894
					order[46] = 41895
					order[47] = 41896
					order[48] = 40695
					order[49] = 40696
					order[50] = 40697
					order[51] = 40698
					order[52] = 40967
					order[53] = 40700
					order[54] = 40701
					order[55] = 40702
					order[56] = 40703
					order[57] = 0
					fix.Group.__init__(self, 40664, 40665, order)

				class NoUnderlyingPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40705
						order[1] = 40706
						order[2] = 40707
						order[3] = 0
						fix.Group.__init__(self, 40704, 40705, order)

				class NoUnderlyingPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40690
						order[1] = 0
						fix.Group.__init__(self, 40966, 40690, order)

				class NoUnderlyingPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41879
						order[1] = 41880
						order[2] = 0
						fix.Group.__init__(self, 41878, 41879, order)

				class NoUnderlyingPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40699
						order[1] = 0
						fix.Group.__init__(self, 40967, 40699, order)

			class NoUnderlyingPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40709
					order[1] = 40710
					order[2] = 42993
					order[3] = 42994
					order[4] = 42995
					order[5] = 42996
					order[6] = 42997
					order[7] = 42998
					order[8] = 42999
					order[9] = 42984
					order[10] = 42985
					order[11] = 42986
					order[12] = 42987
					order[13] = 42988
					order[14] = 42989
					order[15] = 42990
					order[16] = 40711
					order[17] = 40712
					order[18] = 40713
					order[19] = 40714
					order[20] = 40715
					order[21] = 40716
					order[22] = 40717
					order[23] = 40718
					order[24] = 40719
					order[25] = 40720
					order[26] = 40721
					order[27] = 40722
					order[28] = 40723
					order[29] = 40724
					order[30] = 40725
					order[31] = 40726
					order[32] = 40727
					order[33] = 40728
					order[34] = 40729
					order[35] = 40730
					order[36] = 40731
					order[37] = 40732
					order[38] = 40733
					order[39] = 40734
					order[40] = 40735
					order[41] = 40736
					order[42] = 40737
					order[43] = 0
					fix.Group.__init__(self, 40708, 40709, order)

				class NoUnderlyingPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 43001
						order[1] = 0
						fix.Group.__init__(self, 43000, 43001, order)

				class NoUnderlyingPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42992
						order[1] = 0
						fix.Group.__init__(self, 42991, 42992, order)

			class NoUnderlyingDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41809
					order[1] = 0
					fix.Group.__init__(self, 41808, 41809, order)

			class NoUnderlyingDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41805
					order[1] = 41806
					order[2] = 41807
					order[3] = 0
					fix.Group.__init__(self, 41804, 41805, order)

			class NoUnderlyingDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41757
					order[1] = 41758
					order[2] = 41759
					order[3] = 41760
					order[4] = 41761
					order[5] = 41762
					order[6] = 41763
					order[7] = 41764
					order[8] = 41765
					order[9] = 41766
					order[10] = 41767
					order[11] = 41768
					order[12] = 41769
					order[13] = 41770
					order[14] = 0
					fix.Group.__init__(self, 41756, 41757, order)

				class NoUnderlyingDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41771
						order[1] = 41772
						order[2] = 41773
						order[3] = 0
						fix.Group.__init__(self, 41770, 41771, order)

					class NoUnderlyingDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41774
							order[1] = 41775
							order[2] = 41776
							order[3] = 0
							fix.Group.__init__(self, 41773, 41774, order)

		class NoUnderlyingProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 42150
				order[1] = 42151
				order[2] = 42152
				order[3] = 42190
				order[4] = 42153
				order[5] = 42154
				order[6] = 42155
				order[7] = 43002
				order[8] = 43003
				order[9] = 42156
				order[10] = 42157
				order[11] = 42158
				order[12] = 42104
				order[13] = 42105
				order[14] = 42106
				order[15] = 42107
				order[16] = 42108
				order[17] = 42109
				order[18] = 42110
				order[19] = 42111
				order[20] = 42115
				order[21] = 42116
				order[22] = 42117
				order[23] = 42118
				order[24] = 42119
				order[25] = 42120
				order[26] = 42121
				order[27] = 42122
				order[28] = 42123
				order[29] = 42124
				order[30] = 42125
				order[31] = 42126
				order[32] = 42127
				order[33] = 42128
				order[34] = 42129
				order[35] = 42130
				order[36] = 42131
				order[37] = 42132
				order[38] = 42133
				order[39] = 42134
				order[40] = 42135
				order[41] = 42136
				order[42] = 42137
				order[43] = 42138
				order[44] = 42139
				order[45] = 42140
				order[46] = 42141
				order[47] = 42142
				order[48] = 42143
				order[49] = 42144
				order[50] = 42145
				order[51] = 42146
				order[52] = 42147
				order[53] = 42148
				order[54] = 42159
				order[55] = 42160
				order[56] = 42161
				order[57] = 42162
				order[58] = 42163
				order[59] = 42164
				order[60] = 42165
				order[61] = 42092
				order[62] = 42093
				order[63] = 42094
				order[64] = 42095
				order[65] = 42096
				order[66] = 42097
				order[67] = 42098
				order[68] = 42166
				order[69] = 42167
				order[70] = 42168
				order[71] = 42169
				order[72] = 42102
				order[73] = 42103
				order[74] = 42170
				order[75] = 42171
				order[76] = 42172
				order[77] = 42173
				order[78] = 0
				fix.Group.__init__(self, 42149, 42150, order)

			class NoUnderlyingProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42191
					order[1] = 0
					fix.Group.__init__(self, 42190, 42191, order)

			class NoUnderlyingProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42183
					order[1] = 0
					fix.Group.__init__(self, 42182, 42183, order)

			class NoUnderlyingProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42185
					order[1] = 0
					fix.Group.__init__(self, 42184, 42185, order)

			class NoUnderlyingProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42113
					order[1] = 42114
					order[2] = 0
					fix.Group.__init__(self, 42112, 42113, order)

			class NoUnderlyingProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42187
					order[1] = 0
					fix.Group.__init__(self, 42186, 42187, order)

			class NoUnderlyingProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42189
					order[1] = 0
					fix.Group.__init__(self, 42188, 42189, order)

			class NoUnderlyingProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42181
					order[1] = 0
					fix.Group.__init__(self, 42180, 42181, order)

			class NoUnderlyingProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42100
					order[1] = 42101
					order[2] = 0
					fix.Group.__init__(self, 42099, 42100, order)

			class NoUnderlyingProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 42174
					order[1] = 42175
					order[2] = 42176
					order[3] = 40918
					order[4] = 42177
					order[5] = 0
					fix.Group.__init__(self, 42173, 42174, order)

				class NoUnderlyingProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42178
						order[1] = 42179
						order[2] = 0
						fix.Group.__init__(self, 42177, 42178, order)

		class NoUnderlyingAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 42037
				order[1] = 42038
				order[2] = 41340
				order[3] = 0
				fix.Group.__init__(self, 42036, 42037, order)

			class NoUnderlyingAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41341
					order[1] = 41701
					order[2] = 41709
					order[3] = 41710
					order[4] = 41711
					order[5] = 41712
					order[6] = 42017
					order[7] = 42025
					order[8] = 42026
					order[9] = 42027
					order[10] = 42028
					order[11] = 42029
					order[12] = 42030
					order[13] = 42031
					order[14] = 42032
					order[15] = 42033
					order[16] = 42034
					order[17] = 42035
					order[18] = 0
					fix.Group.__init__(self, 41340, 41341, order)

		class NoUnderlyingProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 42069
				order[1] = 42070
				order[2] = 42071
				order[3] = 42072
				order[4] = 42073
				order[5] = 42074
				order[6] = 42075
				order[7] = 42090
				order[8] = 42077
				order[9] = 42087
				order[10] = 42076
				order[11] = 0
				fix.Group.__init__(self, 42068, 42069, order)

			class NoUnderlyingProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42091
					order[1] = 0
					fix.Group.__init__(self, 42090, 42091, order)

			class NoUnderlyingProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 42078
					order[1] = 42079
					order[2] = 42080
					order[3] = 42081
					order[4] = 42082
					order[5] = 42083
					order[6] = 42084
					order[7] = 42085
					order[8] = 0
					fix.Group.__init__(self, 42077, 42078, order)

				class NoUnderlyingProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42086
						order[1] = 0
						fix.Group.__init__(self, 42085, 42086, order)

			class NoUnderlyingProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42088
					order[1] = 42089
					order[2] = 0
					fix.Group.__init__(self, 42087, 42088, order)

		class NoUnderlyingCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 42042
				order[1] = 42043
				order[2] = 42044
				order[3] = 42045
				order[4] = 42046
				order[5] = 42047
				order[6] = 42048
				order[7] = 42049
				order[8] = 42050
				order[9] = 42051
				order[10] = 42052
				order[11] = 42039
				order[12] = 42797
				order[13] = 42798
				order[14] = 42053
				order[15] = 42054
				order[16] = 42790
				order[17] = 42791
				order[18] = 42792
				order[19] = 42793
				order[20] = 42794
				order[21] = 42795
				order[22] = 42796
				order[23] = 42055
				order[24] = 42056
				order[25] = 42057
				order[26] = 42058
				order[27] = 42059
				order[28] = 0
				fix.Group.__init__(self, 42041, 42042, order)

			class NoUnderlyingCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42040
					order[1] = 0
					fix.Group.__init__(self, 42039, 42040, order)

			class NoUnderlyingCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42789
					order[1] = 0
					fix.Group.__init__(self, 42788, 42789, order)

		class NoUnderlyingPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 42065
				order[1] = 42061
				order[2] = 42062
				order[3] = 42063
				order[4] = 42064
				order[5] = 0
				fix.Group.__init__(self, 42060, 42065, order)

			class NoUnderlyingPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42066
					order[1] = 42067
					order[2] = 0
					fix.Group.__init__(self, 42065, 42066, order)

		class NoUnderlyingRateSpreadSteps(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 43006
				order[1] = 43007
				order[2] = 0
				fix.Group.__init__(self, 43005, 43006, order)

		class NoUnderlyingDividendPayments(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 42856
				order[1] = 42857
				order[2] = 42858
				order[3] = 42859
				order[4] = 0
				fix.Group.__init__(self, 42855, 42856, order)

		class NoUnderlyingExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42885
				order[1] = 42886
				order[2] = 0
				fix.Group.__init__(self, 42884, 42885, order)

	class NoStipulations(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 233
			order[1] = 234
			order[2] = 0
			fix.Group.__init__(self, 232, 233, order)

	class NoCommissions(fix.Group):
		def __init__(self):
			order = fix.IntArray(17)
			order[0] = 2640
			order[1] = 2641
			order[2] = 2725
			order[3] = 2642
			order[4] = 2643
			order[5] = 2923
			order[6] = 2644
			order[7] = 2645
			order[8] = 2924
			order[9] = 2646
			order[10] = 2647
			order[11] = 2648
			order[12] = 2649
			order[13] = 2650
			order[14] = 2651
			order[15] = 2652
			order[16] = 0
			fix.Group.__init__(self, 2639, 2640, order)

	class NoOrderAttributes(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 2594
			order[1] = 2595
			order[2] = 0
			fix.Group.__init__(self, 2593, 2594, order)

	class NoRateSources(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1446
			order[1] = 1447
			order[2] = 1448
			order[3] = 2412
			order[4] = 2796
			order[5] = 0
			fix.Group.__init__(self, 1445, 1446, order)

	class NoStrategyParameters(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 958
			order[1] = 959
			order[2] = 960
			order[3] = 0
			fix.Group.__init__(self, 957, 958, order)

	class NoTrdRegTimestamps(fix.Group):
		def __init__(self):
			order = fix.IntArray(13)
			order[0] = 769
			order[1] = 770
			order[2] = 771
			order[3] = 2839
			order[4] = 1033
			order[5] = 1034
			order[6] = 1035
			order[7] = 1727
			order[8] = 2831
			order[9] = 2832
			order[10] = 2833
			order[11] = 2834
			order[12] = 0
			fix.Group.__init__(self, 768, 769, order)

	class NoTrdRegPublications(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 2669
			order[1] = 2670
			order[2] = 0
			fix.Group.__init__(self, 2668, 2669, order)

class NewOrderList(Message):
	def __init__(self):
		Message.__init__(self)
		self.getHeader().setField( fix.MsgType("E") )

	class NoRootPartyIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1117
			order[1] = 1118
			order[2] = 1119
			order[3] = 2388
			order[4] = 1120
			order[5] = 0
			fix.Group.__init__(self, 1116, 1117, order)

		class NoRootPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 1121
				order[1] = 1122
				order[2] = 0
				fix.Group.__init__(self, 1120, 1121, order)

	class NoOrders(fix.Group):
		def __init__(self):
			order = fix.IntArray(314)
			order[0] = 11
			order[1] = 526
			order[2] = 67
			order[3] = 583
			order[4] = 160
			order[5] = 453
			order[6] = 229
			order[7] = 75
			order[8] = 1
			order[9] = 660
			order[10] = 581
			order[11] = 589
			order[12] = 590
			order[13] = 70
			order[14] = 591
			order[15] = 78
			order[16] = 63
			order[17] = 64
			order[18] = 544
			order[19] = 635
			order[20] = 21
			order[21] = 18
			order[22] = 110
			order[23] = 1089
			order[24] = 1090
			order[25] = 1138
			order[26] = 1082
			order[27] = 1608
			order[28] = 2828
			order[29] = 1083
			order[30] = 1084
			order[31] = 1085
			order[32] = 1086
			order[33] = 1087
			order[34] = 1088
			order[35] = 111
			order[36] = 100
			order[37] = 1133
			order[38] = 386
			order[39] = 81
			order[40] = 55
			order[41] = 65
			order[42] = 48
			order[43] = 22
			order[44] = 460
			order[45] = 1227
			order[46] = 1151
			order[47] = 461
			order[48] = 2891
			order[49] = 167
			order[50] = 762
			order[51] = 200
			order[52] = 541
			order[53] = 1079
			order[54] = 966
			order[55] = 1049
			order[56] = 965
			order[57] = 224
			order[58] = 1449
			order[59] = 1450
			order[60] = 1451
			order[61] = 1452
			order[62] = 1457
			order[63] = 1458
			order[64] = 1739
			order[65] = 2210
			order[66] = 1938
			order[67] = 1939
			order[68] = 1940
			order[69] = 2735
			order[70] = 1941
			order[71] = 1575
			order[72] = 1942
			order[73] = 1943
			order[74] = 1944
			order[75] = 1945
			order[76] = 1946
			order[77] = 1947
			order[78] = 1948
			order[79] = 1949
			order[80] = 1950
			order[81] = 2879
			order[82] = 1951
			order[83] = 1952
			order[84] = 1953
			order[85] = 1954
			order[86] = 1955
			order[87] = 1956
			order[88] = 1957
			order[89] = 1958
			order[90] = 1959
			order[91] = 1960
			order[92] = 1577
			order[93] = 1580
			order[94] = 1581
			order[95] = 1678
			order[96] = 1697
			order[97] = 225
			order[98] = 239
			order[99] = 226
			order[100] = 227
			order[101] = 228
			order[102] = 255
			order[103] = 543
			order[104] = 470
			order[105] = 471
			order[106] = 472
			order[107] = 240
			order[108] = 202
			order[109] = 2578
			order[110] = 2577
			order[111] = 947
			order[112] = 2904
			order[113] = 967
			order[114] = 968
			order[115] = 1698
			order[116] = 1866
			order[117] = 2600
			order[118] = 2001
			order[119] = 2601
			order[120] = 1478
			order[121] = 1479
			order[122] = 1480
			order[123] = 1481
			order[124] = 206
			order[125] = 231
			order[126] = 1435
			order[127] = 2353
			order[128] = 1439
			order[129] = 969
			order[130] = 1146
			order[131] = 996
			order[132] = 1147
			order[133] = 1716
			order[134] = 2905
			order[135] = 1191
			order[136] = 1192
			order[137] = 1717
			order[138] = 2906
			order[139] = 1193
			order[140] = 2579
			order[141] = 1194
			order[142] = 1482
			order[143] = 1195
			order[144] = 2753
			order[145] = 1196
			order[146] = 1197
			order[147] = 2002
			order[148] = 2140
			order[149] = 1524
			order[150] = 2907
			order[151] = 1198
			order[152] = 1199
			order[153] = 1200
			order[154] = 201
			order[155] = 2681
			order[156] = 2685
			order[157] = 1244
			order[158] = 1242
			order[159] = 2575
			order[160] = 2574
			order[161] = 997
			order[162] = 223
			order[163] = 207
			order[164] = 970
			order[165] = 971
			order[166] = 106
			order[167] = 348
			order[168] = 349
			order[169] = 2737
			order[170] = 2714
			order[171] = 2715
			order[172] = 2716
			order[173] = 107
			order[174] = 350
			order[175] = 351
			order[176] = 691
			order[177] = 667
			order[178] = 875
			order[179] = 876
			order[180] = 873
			order[181] = 874
			order[182] = 1687
			order[183] = 1787
			order[184] = 2141
			order[185] = 2142
			order[186] = 2143
			order[187] = 2752
			order[188] = 2144
			order[189] = 2145
			order[190] = 2576
			order[191] = 2962
			order[192] = 2602
			order[193] = 2603
			order[194] = 711
			order[195] = 140
			order[196] = 54
			order[197] = 2102
			order[198] = 1688
			order[199] = 401
			order[200] = 114
			order[201] = 60
			order[202] = 232
			order[203] = 854
			order[204] = 38
			order[205] = 152
			order[206] = 516
			order[207] = 468
			order[208] = 469
			order[209] = 40
			order[210] = 423
			order[211] = 44
			order[212] = 1092
			order[213] = 99
			order[214] = 1100
			order[215] = 1101
			order[216] = 1628
			order[217] = 1102
			order[218] = 1103
			order[219] = 1104
			order[220] = 1105
			order[221] = 1106
			order[222] = 1107
			order[223] = 1108
			order[224] = 1109
			order[225] = 1110
			order[226] = 1111
			order[227] = 1112
			order[228] = 1113
			order[229] = 1114
			order[230] = 218
			order[231] = 220
			order[232] = 2950
			order[233] = 221
			order[234] = 222
			order[235] = 662
			order[236] = 663
			order[237] = 699
			order[238] = 761
			order[239] = 235
			order[240] = 236
			order[241] = 701
			order[242] = 696
			order[243] = 697
			order[244] = 698
			order[245] = 15
			order[246] = 2897
			order[247] = 376
			order[248] = 2404
			order[249] = 2351
			order[250] = 2352
			order[251] = 377
			order[252] = 23
			order[253] = 117
			order[254] = 1080
			order[255] = 1081
			order[256] = 59
			order[257] = 168
			order[258] = 432
			order[259] = 126
			order[260] = 427
			order[261] = 1629
			order[262] = 1916
			order[263] = 12
			order[264] = 13
			order[265] = 479
			order[266] = 2922
			order[267] = 1233
			order[268] = 1238
			order[269] = 497
			order[270] = 2639
			order[271] = 528
			order[272] = 529
			order[273] = 1091
			order[274] = 582
			order[275] = 2593
			order[276] = 121
			order[277] = 120
			order[278] = 2899
			order[279] = 775
			order[280] = 58
			order[281] = 354
			order[282] = 355
			order[283] = 193
			order[284] = 192
			order[285] = 640
			order[286] = 77
			order[287] = 203
			order[288] = 210
			order[289] = 211
			order[290] = 1094
			order[291] = 835
			order[292] = 836
			order[293] = 837
			order[294] = 838
			order[295] = 840
			order[296] = 1096
			order[297] = 1097
			order[298] = 1098
			order[299] = 1099
			order[300] = 388
			order[301] = 389
			order[302] = 841
			order[303] = 842
			order[304] = 843
			order[305] = 844
			order[306] = 846
			order[307] = 847
			order[308] = 957
			order[309] = 848
			order[310] = 849
			order[311] = 494
			order[312] = 1028
			order[313] = 0
			fix.Group.__init__(self, 73, 11, order)

		class NoPartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 448
				order[1] = 447
				order[2] = 452
				order[3] = 2376
				order[4] = 802
				order[5] = 0
				fix.Group.__init__(self, 453, 448, order)

			class NoPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 523
					order[1] = 803
					order[2] = 0
					fix.Group.__init__(self, 802, 523, order)

		class NoAllocs(fix.Group):
			def __init__(self):
				order = fix.IntArray(14)
				order[0] = 79
				order[1] = 661
				order[2] = 736
				order[3] = 2927
				order[4] = 467
				order[5] = 2727
				order[6] = 539
				order[7] = 209
				order[8] = 80
				order[9] = 1752
				order[10] = 1753
				order[11] = 1754
				order[12] = 1755
				order[13] = 0
				fix.Group.__init__(self, 78, 79, order)

			class NoNestedPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 524
					order[1] = 525
					order[2] = 538
					order[3] = 2384
					order[4] = 804
					order[5] = 0
					fix.Group.__init__(self, 539, 524, order)

				class NoNestedPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 545
						order[1] = 805
						order[2] = 0
						fix.Group.__init__(self, 804, 545, order)

		class NoTradingSessions(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 336
				order[1] = 625
				order[2] = 0
				fix.Group.__init__(self, 386, 336, order)

		class NoSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 455
				order[1] = 456
				order[2] = 2957
				order[3] = 0
				fix.Group.__init__(self, 454, 455, order)

		class NoSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 1977
				order[1] = 1978
				order[2] = 1979
				order[3] = 2741
				order[4] = 0
				fix.Group.__init__(self, 1976, 1977, order)

		class NoAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2305
				order[1] = 2306
				order[2] = 2307
				order[3] = 0
				fix.Group.__init__(self, 2304, 2305, order)

		class NoEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 865
				order[1] = 866
				order[2] = 1145
				order[3] = 1827
				order[4] = 1826
				order[5] = 2340
				order[6] = 867
				order[7] = 868
				order[8] = 1578
				order[9] = 1579
				order[10] = 0
				fix.Group.__init__(self, 864, 865, order)

		class NoInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1019
				order[1] = 1050
				order[2] = 1051
				order[3] = 2378
				order[4] = 1052
				order[5] = 0
				fix.Group.__init__(self, 1018, 1019, order)

			class NoInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1053
					order[1] = 1054
					order[2] = 0
					fix.Group.__init__(self, 1052, 1053, order)

		class NoComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 1484
				order[1] = 2117
				order[2] = 2118
				order[3] = 2119
				order[4] = 1485
				order[5] = 2120
				order[6] = 2121
				order[7] = 2122
				order[8] = 2941
				order[9] = 1486
				order[10] = 2123
				order[11] = 1487
				order[12] = 1488
				order[13] = 1489
				order[14] = 1490
				order[15] = 1491
				order[16] = 2124
				order[17] = 2942
				order[18] = 2125
				order[19] = 2943
				order[20] = 2126
				order[21] = 2127
				order[22] = 2407
				order[23] = 2408
				order[24] = 2128
				order[25] = 2129
				order[26] = 2130
				order[27] = 2131
				order[28] = 2132
				order[29] = 41013
				order[30] = 41020
				order[31] = 41021
				order[32] = 41022
				order[33] = 41023
				order[34] = 41024
				order[35] = 41025
				order[36] = 41026
				order[37] = 41027
				order[38] = 41028
				order[39] = 41010
				order[40] = 2133
				order[41] = 2134
				order[42] = 2135
				order[43] = 2136
				order[44] = 2137
				order[45] = 41029
				order[46] = 40997
				order[47] = 2597
				order[48] = 2598
				order[49] = 2599
				order[50] = 2138
				order[51] = 2139
				order[52] = 0
				fix.Group.__init__(self, 1483, 1484, order)

			class NoComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 1492
					order[1] = 1493
					order[2] = 1494
					order[3] = 0
					fix.Group.__init__(self, 1491, 1492, order)

				class NoComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 1495
						order[1] = 1496
						order[2] = 0
						fix.Group.__init__(self, 1494, 1495, order)

			class NoComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41014
					order[1] = 41015
					order[2] = 41016
					order[3] = 41017
					order[4] = 0
					fix.Group.__init__(self, 41013, 41014, order)

			class NoComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41019
					order[1] = 0
					fix.Group.__init__(self, 41018, 41019, order)

			class NoComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41011
					order[1] = 41012
					order[2] = 41031
					order[3] = 41007
					order[4] = 40994
					order[5] = 0
					fix.Group.__init__(self, 41010, 41011, order)

				class NoComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41032
						order[1] = 41033
						order[2] = 41034
						order[3] = 41035
						order[4] = 41036
						order[5] = 0
						fix.Group.__init__(self, 41031, 41032, order)

				class NoComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41008
						order[1] = 41009
						order[2] = 0
						fix.Group.__init__(self, 41007, 41008, order)

				class NoComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40995
						order[1] = 40996
						order[2] = 0
						fix.Group.__init__(self, 40994, 40995, order)

			class NoComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41030
					order[1] = 0
					fix.Group.__init__(self, 41029, 41030, order)

			class NoComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 40998
					order[1] = 40999
					order[2] = 41000
					order[3] = 41001
					order[4] = 41002
					order[5] = 41003
					order[6] = 41004
					order[7] = 41005
					order[8] = 0
					fix.Group.__init__(self, 40997, 40998, order)

				class NoComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41006
						order[1] = 0
						fix.Group.__init__(self, 41005, 41006, order)

		class NoBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40471
				order[1] = 0
				fix.Group.__init__(self, 40278, 40471, order)

		class NoPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41231
				order[1] = 0
				fix.Group.__init__(self, 41230, 41231, order)

		class NoMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41093
				order[1] = 40991
				order[2] = 0
				fix.Group.__init__(self, 41092, 41093, order)

		class NoMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41095
				order[1] = 40992
				order[2] = 0
				fix.Group.__init__(self, 41094, 41095, order)

		class NoMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41097
				order[1] = 41098
				order[2] = 41099
				order[3] = 41100
				order[4] = 41101
				order[5] = 41102
				order[6] = 41103
				order[7] = 41104
				order[8] = 41105
				order[9] = 0
				fix.Group.__init__(self, 41096, 41097, order)

		class NoSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42776
				order[1] = 0
				fix.Group.__init__(self, 42775, 42776, order)

		class NoOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41117
				order[1] = 0
				fix.Group.__init__(self, 41116, 41117, order)

		class NoOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41138
				order[1] = 41139
				order[2] = 0
				fix.Group.__init__(self, 41137, 41138, order)

		class NoOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41141
				order[1] = 0
				fix.Group.__init__(self, 41140, 41141, order)

		class NoOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41153
				order[1] = 41154
				order[2] = 0
				fix.Group.__init__(self, 41152, 41153, order)

		class NoStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40050
				order[1] = 41303
				order[2] = 40051
				order[3] = 42784
				order[4] = 42785
				order[5] = 40052
				order[6] = 40053
				order[7] = 41305
				order[8] = 40054
				order[9] = 40055
				order[10] = 42786
				order[11] = 42787
				order[12] = 41306
				order[13] = 41307
				order[14] = 41308
				order[15] = 41309
				order[16] = 41310
				order[17] = 41311
				order[18] = 41251
				order[19] = 41252
				order[20] = 41253
				order[21] = 41254
				order[22] = 41255
				order[23] = 41256
				order[24] = 41257
				order[25] = 42587
				order[26] = 41258
				order[27] = 41259
				order[28] = 41260
				order[29] = 41261
				order[30] = 41262
				order[31] = 41263
				order[32] = 41264
				order[33] = 41265
				order[34] = 41266
				order[35] = 41267
				order[36] = 41268
				order[37] = 41269
				order[38] = 41270
				order[39] = 41271
				order[40] = 41272
				order[41] = 41273
				order[42] = 41274
				order[43] = 41275
				order[44] = 41276
				order[45] = 40907
				order[46] = 40908
				order[47] = 40910
				order[48] = 40911
				order[49] = 40912
				order[50] = 40913
				order[51] = 40914
				order[52] = 40065
				order[53] = 40066
				order[54] = 40068
				order[55] = 40069
				order[56] = 40070
				order[57] = 40071
				order[58] = 40072
				order[59] = 41244
				order[60] = 41245
				order[61] = 40073
				order[62] = 40075
				order[63] = 40076
				order[64] = 40078
				order[65] = 40079
				order[66] = 40080
				order[67] = 40081
				order[68] = 40082
				order[69] = 40083
				order[70] = 40084
				order[71] = 41246
				order[72] = 41247
				order[73] = 41248
				order[74] = 40738
				order[75] = 40739
				order[76] = 40740
				order[77] = 42600
				order[78] = 40741
				order[79] = 40742
				order[80] = 43106
				order[81] = 40743
				order[82] = 40744
				order[83] = 40745
				order[84] = 40746
				order[85] = 40747
				order[86] = 42601
				order[87] = 42602
				order[88] = 42603
				order[89] = 42604
				order[90] = 40748
				order[91] = 40749
				order[92] = 40750
				order[93] = 41180
				order[94] = 41181
				order[95] = 41182
				order[96] = 41183
				order[97] = 41184
				order[98] = 41185
				order[99] = 41186
				order[100] = 42605
				order[101] = 40828
				order[102] = 40872
				order[103] = 41058
				order[104] = 41059
				order[105] = 41060
				order[106] = 41061
				order[107] = 41062
				order[108] = 42192
				order[109] = 42193
				order[110] = 41063
				order[111] = 41064
				order[112] = 41065
				order[113] = 41066
				order[114] = 41067
				order[115] = 41218
				order[116] = 41068
				order[117] = 41069
				order[118] = 41070
				order[119] = 41071
				order[120] = 41072
				order[121] = 41073
				order[122] = 41074
				order[123] = 41075
				order[124] = 41076
				order[125] = 41077
				order[126] = 41078
				order[127] = 41079
				order[128] = 41080
				order[129] = 43094
				order[130] = 41037
				order[131] = 40056
				order[132] = 40982
				order[133] = 40983
				order[134] = 0
				fix.Group.__init__(self, 40049, 40050, order)

			class NoStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41278
					order[1] = 41279
					order[2] = 0
					fix.Group.__init__(self, 41277, 41278, order)

			class NoStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41238
					order[1] = 41239
					order[2] = 41240
					order[3] = 0
					fix.Group.__init__(self, 41237, 41238, order)

			class NoStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41281
					order[1] = 41282
					order[2] = 0
					fix.Group.__init__(self, 41280, 41281, order)

			class NoStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41250
					order[1] = 0
					fix.Group.__init__(self, 41249, 41250, order)

			class NoStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41290
					order[1] = 41291
					order[2] = 41292
					order[3] = 41293
					order[4] = 41294
					order[5] = 41295
					order[6] = 41296
					order[7] = 41297
					order[8] = 41298
					order[9] = 41299
					order[10] = 41300
					order[11] = 41283
					order[12] = 41301
					order[13] = 41302
					order[14] = 0
					fix.Group.__init__(self, 41289, 41290, order)

				class NoStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41284
						order[1] = 41285
						order[2] = 41286
						order[3] = 0
						fix.Group.__init__(self, 41283, 41284, order)

					class NoStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41287
							order[1] = 41288
							order[2] = 41588
							order[3] = 0
							fix.Group.__init__(self, 41286, 41287, order)

			class NoStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40909
					order[1] = 0
					fix.Group.__init__(self, 40960, 40909, order)

			class NoStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40067
					order[1] = 0
					fix.Group.__init__(self, 40961, 40067, order)

			class NoStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40074
					order[1] = 0
					fix.Group.__init__(self, 40958, 40074, order)

			class NoStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41242
					order[1] = 41243
					order[2] = 0
					fix.Group.__init__(self, 41241, 41242, order)

			class NoStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40077
					order[1] = 0
					fix.Group.__init__(self, 40959, 40077, order)

			class NoPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40752
					order[1] = 0
					fix.Group.__init__(self, 40947, 40752, order)

			class NoPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41221
					order[1] = 41222
					order[2] = 0
					fix.Group.__init__(self, 41220, 41221, order)

			class NoPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40763
					order[1] = 0
					fix.Group.__init__(self, 40948, 40763, order)

			class NoPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40769
					order[1] = 0
					fix.Group.__init__(self, 40949, 40769, order)

			class NoPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40776
					order[1] = 0
					fix.Group.__init__(self, 40950, 40776, order)

			class NoPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42661
					order[1] = 42662
					order[2] = 0
					fix.Group.__init__(self, 42660, 42661, order)

			class NoPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41193
					order[1] = 0
					fix.Group.__init__(self, 41192, 41193, order)

			class NoPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41228
					order[1] = 41229
					order[2] = 0
					fix.Group.__init__(self, 41227, 41228, order)

			class NoPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41225
					order[1] = 41226
					order[2] = 0
					fix.Group.__init__(self, 41224, 41225, order)

			class NoPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43109
					order[1] = 42684
					order[2] = 42685
					order[3] = 0
					fix.Group.__init__(self, 42683, 43109, order)

			class NoDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42275
					order[1] = 42276
					order[2] = 42277
					order[3] = 42278
					order[4] = 42279
					order[5] = 42280
					order[6] = 42294
					order[7] = 42281
					order[8] = 42282
					order[9] = 42283
					order[10] = 42284
					order[11] = 42285
					order[12] = 42286
					order[13] = 42287
					order[14] = 42288
					order[15] = 42289
					order[16] = 42290
					order[17] = 42291
					order[18] = 42292
					order[19] = 42293
					order[20] = 0
					fix.Group.__init__(self, 42274, 42275, order)

				class NoDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42295
						order[1] = 0
						fix.Group.__init__(self, 42294, 42295, order)

			class NoDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42273
					order[1] = 0
					fix.Group.__init__(self, 42272, 42273, order)

			class NoDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42237
					order[1] = 0
					fix.Group.__init__(self, 42236, 42237, order)

			class NoReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 42736
					order[1] = 42737
					order[2] = 42738
					order[3] = 42739
					order[4] = 42740
					order[5] = 42741
					order[6] = 42765
					order[7] = 42731
					order[8] = 42742
					order[9] = 42743
					order[10] = 42744
					order[11] = 42745
					order[12] = 42746
					order[13] = 42747
					order[14] = 42748
					order[15] = 42749
					order[16] = 42750
					order[17] = 42751
					order[18] = 42752
					order[19] = 42753
					order[20] = 42761
					order[21] = 42754
					order[22] = 42755
					order[23] = 42709
					order[24] = 42756
					order[25] = 42757
					order[26] = 42758
					order[27] = 42759
					order[28] = 42760
					order[29] = 0
					fix.Group.__init__(self, 42735, 42736, order)

				class NoReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 42766
						order[1] = 42767
						order[2] = 42768
						order[3] = 42769
						order[4] = 0
						fix.Group.__init__(self, 42765, 42766, order)

				class NoReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42732
						order[1] = 42733
						order[2] = 42734
						order[3] = 0
						fix.Group.__init__(self, 42731, 42732, order)

				class NoReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 42762
						order[1] = 42763
						order[2] = 42764
						order[3] = 0
						fix.Group.__init__(self, 42761, 42762, order)

				class NoReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 42710
						order[1] = 42772
						order[2] = 42711
						order[3] = 42712
						order[4] = 42713
						order[5] = 42714
						order[6] = 42715
						order[7] = 42716
						order[8] = 42717
						order[9] = 42718
						order[10] = 42719
						order[11] = 42720
						order[12] = 42721
						order[13] = 42722
						order[14] = 42723
						order[15] = 42724
						order[16] = 42725
						order[17] = 42726
						order[18] = 42727
						order[19] = 42728
						order[20] = 42729
						order[21] = 42730
						order[22] = 42770
						order[23] = 0
						fix.Group.__init__(self, 42709, 42710, order)

					class NoReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 42773
							order[1] = 42774
							order[2] = 0
							fix.Group.__init__(self, 42772, 42773, order)

					class NoReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 42771
							order[1] = 0
							fix.Group.__init__(self, 42770, 42771, order)

			class NoPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42621
					order[1] = 0
					fix.Group.__init__(self, 42620, 42621, order)

			class NoPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42607
					order[1] = 42608
					order[2] = 0
					fix.Group.__init__(self, 42606, 42607, order)

			class NoPaymentStreamNonDeliverableFixingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40819
					order[1] = 0
					fix.Group.__init__(self, 40946, 40819, order)

			class NoNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40826
					order[1] = 40827
					order[2] = 0
					fix.Group.__init__(self, 40825, 40826, order)

			class NoSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40086
					order[1] = 40373
					order[2] = 40655
					order[3] = 40088
					order[4] = 40089
					order[5] = 0
					fix.Group.__init__(self, 40085, 40086, order)

			class NoPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40829
					order[1] = 41164
					order[2] = 41165
					order[3] = 40830
					order[4] = 40831
					order[5] = 40832
					order[6] = 40833
					order[7] = 40834
					order[8] = 40835
					order[9] = 40836
					order[10] = 40837
					order[11] = 40838
					order[12] = 40839
					order[13] = 41166
					order[14] = 41167
					order[15] = 41168
					order[16] = 41169
					order[17] = 40840
					order[18] = 40841
					order[19] = 40842
					order[20] = 40843
					order[21] = 41170
					order[22] = 41171
					order[23] = 41172
					order[24] = 41173
					order[25] = 40844
					order[26] = 40845
					order[27] = 40846
					order[28] = 40847
					order[29] = 40848
					order[30] = 40849
					order[31] = 40868
					order[32] = 40850
					order[33] = 40851
					order[34] = 40852
					order[35] = 40853
					order[36] = 40977
					order[37] = 40855
					order[38] = 40856
					order[39] = 40857
					order[40] = 41174
					order[41] = 41175
					order[42] = 40858
					order[43] = 41161
					order[44] = 41176
					order[45] = 41177
					order[46] = 41178
					order[47] = 41179
					order[48] = 40859
					order[49] = 40860
					order[50] = 40861
					order[51] = 40862
					order[52] = 40945
					order[53] = 40864
					order[54] = 40865
					order[55] = 40866
					order[56] = 40867
					order[57] = 0
					fix.Group.__init__(self, 40828, 40829, order)

				class NoPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40869
						order[1] = 40870
						order[2] = 40871
						order[3] = 0
						fix.Group.__init__(self, 40868, 40869, order)

				class NoPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40854
						order[1] = 0
						fix.Group.__init__(self, 40977, 40854, order)

				class NoPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41162
						order[1] = 41163
						order[2] = 0
						fix.Group.__init__(self, 41161, 41162, order)

				class NoPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40863
						order[1] = 0
						fix.Group.__init__(self, 40945, 40863, order)

			class NoPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40873
					order[1] = 40874
					order[2] = 42698
					order[3] = 42699
					order[4] = 42700
					order[5] = 42701
					order[6] = 42702
					order[7] = 42703
					order[8] = 42704
					order[9] = 42689
					order[10] = 42690
					order[11] = 42691
					order[12] = 42692
					order[13] = 42693
					order[14] = 42694
					order[15] = 42695
					order[16] = 40875
					order[17] = 40876
					order[18] = 40877
					order[19] = 40878
					order[20] = 40879
					order[21] = 40880
					order[22] = 40881
					order[23] = 40882
					order[24] = 40883
					order[25] = 40884
					order[26] = 40885
					order[27] = 40886
					order[28] = 40887
					order[29] = 40888
					order[30] = 40889
					order[31] = 40890
					order[32] = 40891
					order[33] = 40892
					order[34] = 40893
					order[35] = 40894
					order[36] = 40895
					order[37] = 40896
					order[38] = 40897
					order[39] = 40898
					order[40] = 40899
					order[41] = 40900
					order[42] = 40901
					order[43] = 0
					fix.Group.__init__(self, 40872, 40873, order)

				class NoPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42706
						order[1] = 0
						fix.Group.__init__(self, 42705, 42706, order)

				class NoPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42697
						order[1] = 0
						fix.Group.__init__(self, 42696, 42697, order)

			class NoDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41086
					order[1] = 0
					fix.Group.__init__(self, 41085, 41086, order)

			class NoDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41082
					order[1] = 41083
					order[2] = 41084
					order[3] = 0
					fix.Group.__init__(self, 41081, 41082, order)

			class NoDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41038
					order[1] = 41039
					order[2] = 41040
					order[3] = 41041
					order[4] = 41042
					order[5] = 41043
					order[6] = 41044
					order[7] = 41045
					order[8] = 41046
					order[9] = 41047
					order[10] = 41048
					order[11] = 41049
					order[12] = 41050
					order[13] = 41051
					order[14] = 0
					fix.Group.__init__(self, 41037, 41038, order)

				class NoDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41052
						order[1] = 41053
						order[2] = 41054
						order[3] = 0
						fix.Group.__init__(self, 41051, 41052, order)

					class NoDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41055
							order[1] = 41056
							order[2] = 41057
							order[3] = 0
							fix.Group.__init__(self, 41054, 41055, order)

		class NoProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 40091
				order[1] = 40092
				order[2] = 40093
				order[3] = 40957
				order[4] = 40095
				order[5] = 40096
				order[6] = 40097
				order[7] = 42707
				order[8] = 42708
				order[9] = 40098
				order[10] = 40099
				order[11] = 40100
				order[12] = 40114
				order[13] = 40115
				order[14] = 40116
				order[15] = 40118
				order[16] = 40119
				order[17] = 40120
				order[18] = 40121
				order[19] = 40122
				order[20] = 40123
				order[21] = 40125
				order[22] = 40126
				order[23] = 40127
				order[24] = 40128
				order[25] = 40129
				order[26] = 40130
				order[27] = 40131
				order[28] = 40132
				order[29] = 40133
				order[30] = 40134
				order[31] = 40135
				order[32] = 40136
				order[33] = 40137
				order[34] = 40138
				order[35] = 40139
				order[36] = 40140
				order[37] = 40141
				order[38] = 40145
				order[39] = 40146
				order[40] = 40148
				order[41] = 40149
				order[42] = 40150
				order[43] = 40151
				order[44] = 40152
				order[45] = 40153
				order[46] = 40154
				order[47] = 40155
				order[48] = 40156
				order[49] = 40158
				order[50] = 40159
				order[51] = 40160
				order[52] = 40161
				order[53] = 40162
				order[54] = 40101
				order[55] = 40102
				order[56] = 40103
				order[57] = 40104
				order[58] = 40105
				order[59] = 40106
				order[60] = 40107
				order[61] = 40163
				order[62] = 40165
				order[63] = 40166
				order[64] = 40167
				order[65] = 40168
				order[66] = 40169
				order[67] = 40170
				order[68] = 40108
				order[69] = 40109
				order[70] = 40110
				order[71] = 40111
				order[72] = 40112
				order[73] = 41406
				order[74] = 40113
				order[75] = 40986
				order[76] = 40987
				order[77] = 40174
				order[78] = 0
				fix.Group.__init__(self, 40090, 40091, order)

			class NoProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40094
					order[1] = 0
					fix.Group.__init__(self, 40957, 40094, order)

			class NoProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40117
					order[1] = 0
					fix.Group.__init__(self, 40953, 40117, order)

			class NoProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40124
					order[1] = 0
					fix.Group.__init__(self, 40954, 40124, order)

			class NoProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40143
					order[1] = 40144
					order[2] = 0
					fix.Group.__init__(self, 40142, 40143, order)

			class NoProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40147
					order[1] = 0
					fix.Group.__init__(self, 40955, 40147, order)

			class NoProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40157
					order[1] = 0
					fix.Group.__init__(self, 40956, 40157, order)

			class NoProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40164
					order[1] = 0
					fix.Group.__init__(self, 40952, 40164, order)

			class NoProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40172
					order[1] = 40173
					order[2] = 0
					fix.Group.__init__(self, 40171, 40172, order)

			class NoProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40175
					order[1] = 40176
					order[2] = 40177
					order[3] = 2385
					order[4] = 40178
					order[5] = 0
					fix.Group.__init__(self, 40174, 40175, order)

				class NoProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40179
						order[1] = 40180
						order[2] = 0
						fix.Group.__init__(self, 40178, 40179, order)

		class NoAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 40020
				order[1] = 40021
				order[2] = 40000
				order[3] = 0
				fix.Group.__init__(self, 40019, 40020, order)

			class NoAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 40001
					order[1] = 40002
					order[2] = 40003
					order[3] = 40004
					order[4] = 40005
					order[5] = 40006
					order[6] = 40007
					order[7] = 40008
					order[8] = 40009
					order[9] = 40010
					order[10] = 40011
					order[11] = 40012
					order[12] = 40013
					order[13] = 40014
					order[14] = 40015
					order[15] = 40016
					order[16] = 40017
					order[17] = 40018
					order[18] = 0
					fix.Group.__init__(self, 40000, 40001, order)

		class NoProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 40182
				order[1] = 40183
				order[2] = 40184
				order[3] = 40185
				order[4] = 40186
				order[5] = 40187
				order[6] = 40188
				order[7] = 40951
				order[8] = 40191
				order[9] = 40201
				order[10] = 40190
				order[11] = 0
				fix.Group.__init__(self, 40181, 40182, order)

			class NoProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40189
					order[1] = 0
					fix.Group.__init__(self, 40951, 40189, order)

			class NoProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 40192
					order[1] = 40193
					order[2] = 40194
					order[3] = 40195
					order[4] = 40196
					order[5] = 40197
					order[6] = 40198
					order[7] = 40199
					order[8] = 0
					fix.Group.__init__(self, 40191, 40192, order)

				class NoProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40200
						order[1] = 0
						fix.Group.__init__(self, 40199, 40200, order)

			class NoProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40202
					order[1] = 40203
					order[2] = 0
					fix.Group.__init__(self, 40201, 40202, order)

		class NoCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 40023
				order[1] = 40024
				order[2] = 40916
				order[3] = 40917
				order[4] = 40025
				order[5] = 40026
				order[6] = 40027
				order[7] = 40028
				order[8] = 40029
				order[9] = 40030
				order[10] = 40031
				order[11] = 40277
				order[12] = 42216
				order[13] = 42217
				order[14] = 40033
				order[15] = 40034
				order[16] = 42207
				order[17] = 42208
				order[18] = 42209
				order[19] = 42210
				order[20] = 42211
				order[21] = 42212
				order[22] = 42213
				order[23] = 40035
				order[24] = 40036
				order[25] = 40037
				order[26] = 40038
				order[27] = 40039
				order[28] = 0
				fix.Group.__init__(self, 40022, 40023, order)

			class NoCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40032
					order[1] = 0
					fix.Group.__init__(self, 40277, 40032, order)

			class NoCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42215
					order[1] = 0
					fix.Group.__init__(self, 42214, 42215, order)

		class NoPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40209
				order[1] = 40205
				order[2] = 40206
				order[3] = 40207
				order[4] = 40208
				order[5] = 0
				fix.Group.__init__(self, 40204, 40209, order)

			class NoPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40210
					order[1] = 40211
					order[2] = 0
					fix.Group.__init__(self, 40209, 40210, order)

		class NoExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42297
				order[1] = 42298
				order[2] = 0
				fix.Group.__init__(self, 42296, 42297, order)

		class NoUnderlyings(fix.Group):
			def __init__(self):
				order = fix.IntArray(188)
				order[0] = 311
				order[1] = 312
				order[2] = 309
				order[3] = 305
				order[4] = 2874
				order[5] = 462
				order[6] = 463
				order[7] = 2894
				order[8] = 310
				order[9] = 763
				order[10] = 313
				order[11] = 542
				order[12] = 1213
				order[13] = 1837
				order[14] = 241
				order[15] = 1453
				order[16] = 1454
				order[17] = 2614
				order[18] = 2615
				order[19] = 2921
				order[20] = 2616
				order[21] = 2617
				order[22] = 2619
				order[23] = 1455
				order[24] = 1456
				order[25] = 1459
				order[26] = 1460
				order[27] = 242
				order[28] = 243
				order[29] = 244
				order[30] = 245
				order[31] = 246
				order[32] = 256
				order[33] = 595
				order[34] = 592
				order[35] = 593
				order[36] = 594
				order[37] = 247
				order[38] = 316
				order[39] = 941
				order[40] = 2917
				order[41] = 317
				order[42] = 436
				order[43] = 1437
				order[44] = 2363
				order[45] = 1441
				order[46] = 998
				order[47] = 1423
				order[48] = 1718
				order[49] = 2918
				order[50] = 1424
				order[51] = 1425
				order[52] = 1719
				order[53] = 2919
				order[54] = 1000
				order[55] = 1419
				order[56] = 1526
				order[57] = 2920
				order[58] = 435
				order[59] = 308
				order[60] = 306
				order[61] = 362
				order[62] = 363
				order[63] = 2742
				order[64] = 2720
				order[65] = 2721
				order[66] = 2722
				order[67] = 2723
				order[68] = 2724
				order[69] = 307
				order[70] = 364
				order[71] = 365
				order[72] = 877
				order[73] = 878
				order[74] = 972
				order[75] = 318
				order[76] = 2916
				order[77] = 879
				order[78] = 975
				order[79] = 973
				order[80] = 974
				order[81] = 810
				order[82] = 882
				order[83] = 883
				order[84] = 884
				order[85] = 885
				order[86] = 886
				order[87] = 2885
				order[88] = 2886
				order[89] = 1044
				order[90] = 1045
				order[91] = 1046
				order[92] = 1038
				order[93] = 1039
				order[94] = 315
				order[95] = 2683
				order[96] = 2687
				order[97] = 1988
				order[98] = 1989
				order[99] = 1990
				order[100] = 1991
				order[101] = 1992
				order[102] = 1993
				order[103] = 2881
				order[104] = 1994
				order[105] = 1995
				order[106] = 1996
				order[107] = 1997
				order[108] = 2620
				order[109] = 2621
				order[110] = 1998
				order[111] = 1999
				order[112] = 2000
				order[113] = 2003
				order[114] = 2004
				order[115] = 2005
				order[116] = 2006
				order[117] = 2284
				order[118] = 2285
				order[119] = 2286
				order[120] = 2287
				order[121] = 2288
				order[122] = 2007
				order[123] = 2008
				order[124] = 2009
				order[125] = 2010
				order[126] = 2011
				order[127] = 2012
				order[128] = 2491
				order[129] = 2013
				order[130] = 2014
				order[131] = 2015
				order[132] = 2744
				order[133] = 2016
				order[134] = 2289
				order[135] = 2017
				order[136] = 2018
				order[137] = 2019
				order[138] = 2020
				order[139] = 2021
				order[140] = 2022
				order[141] = 2290
				order[142] = 2622
				order[143] = 2291
				order[144] = 2623
				order[145] = 2292
				order[146] = 2023
				order[147] = 2024
				order[148] = 2025
				order[149] = 2026
				order[150] = 2027
				order[151] = 2028
				order[152] = 2029
				order[153] = 2757
				order[154] = 2030
				order[155] = 2031
				order[156] = 2293
				order[157] = 2294
				order[158] = 2032
				order[159] = 2033
				order[160] = 2034
				order[161] = 2035
				order[162] = 2036
				order[163] = 2037
				order[164] = 2038
				order[165] = 2039
				order[166] = 2040
				order[167] = 2041
				order[168] = 2042
				order[169] = 2043
				order[170] = 2044
				order[171] = 41314
				order[172] = 41315
				order[173] = 2295
				order[174] = 2296
				order[175] = 2297
				order[176] = 2756
				order[177] = 2298
				order[178] = 2299
				order[179] = 2624
				order[180] = 2625
				order[181] = 2626
				order[182] = 2627
				order[183] = 2628
				order[184] = 2629
				order[185] = 2630
				order[186] = 2631
				order[187] = 0
				fix.Group.__init__(self, 711, 311, order)

			class NoUnderlyingSecurityAltID(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 458
					order[1] = 459
					order[2] = 2959
					order[3] = 0
					fix.Group.__init__(self, 457, 458, order)

			class NoUnderlyingStips(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 888
					order[1] = 889
					order[2] = 0
					fix.Group.__init__(self, 887, 888, order)

			class NoUndlyInstrumentParties(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 1059
					order[1] = 1060
					order[2] = 1061
					order[3] = 2391
					order[4] = 1062
					order[5] = 0
					fix.Group.__init__(self, 1058, 1059, order)

				class NoUndlyInstrumentPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 1063
						order[1] = 1064
						order[2] = 0
						fix.Group.__init__(self, 1062, 1063, order)

			class NoUnderlyingEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(11)
					order[0] = 1982
					order[1] = 1983
					order[2] = 1984
					order[3] = 1985
					order[4] = 1986
					order[5] = 2342
					order[6] = 1987
					order[7] = 2071
					order[8] = 2072
					order[9] = 2073
					order[10] = 0
					fix.Group.__init__(self, 1981, 1982, order)

			class NoUnderlyingSecondaryAssetClasses(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 2081
					order[1] = 2082
					order[2] = 2083
					order[3] = 2745
					order[4] = 0
					fix.Group.__init__(self, 2080, 2081, order)

			class NoUnderlyingAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2313
					order[1] = 2314
					order[2] = 2315
					order[3] = 0
					fix.Group.__init__(self, 2312, 2313, order)

			class NoUnderlyingComplexEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(53)
					order[0] = 2046
					order[1] = 2261
					order[2] = 2262
					order[3] = 2263
					order[4] = 2047
					order[5] = 2264
					order[6] = 2265
					order[7] = 2266
					order[8] = 2947
					order[9] = 2048
					order[10] = 2267
					order[11] = 2049
					order[12] = 2050
					order[13] = 2051
					order[14] = 2052
					order[15] = 2053
					order[16] = 2268
					order[17] = 2948
					order[18] = 2269
					order[19] = 2949
					order[20] = 2270
					order[21] = 2271
					order[22] = 2419
					order[23] = 2420
					order[24] = 2272
					order[25] = 2273
					order[26] = 2274
					order[27] = 2275
					order[28] = 2276
					order[29] = 41732
					order[30] = 41739
					order[31] = 41740
					order[32] = 41741
					order[33] = 41742
					order[34] = 41743
					order[35] = 41744
					order[36] = 41745
					order[37] = 41746
					order[38] = 41747
					order[39] = 41729
					order[40] = 2277
					order[41] = 2278
					order[42] = 2279
					order[43] = 2280
					order[44] = 2281
					order[45] = 41748
					order[46] = 41716
					order[47] = 2611
					order[48] = 2612
					order[49] = 2613
					order[50] = 2282
					order[51] = 2283
					order[52] = 0
					fix.Group.__init__(self, 2045, 2046, order)

				class NoUnderlyingComplexEventDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 2054
						order[1] = 2055
						order[2] = 2056
						order[3] = 0
						fix.Group.__init__(self, 2053, 2054, order)

					class NoUnderlyingComplexEventTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 2057
							order[1] = 2058
							order[2] = 0
							fix.Group.__init__(self, 2056, 2057, order)

				class NoUnderlyingComplexEventRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 41733
						order[1] = 41734
						order[2] = 41735
						order[3] = 41736
						order[4] = 0
						fix.Group.__init__(self, 41732, 41733, order)

				class NoUnderlyingComplexEventDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41738
						order[1] = 0
						fix.Group.__init__(self, 41737, 41738, order)

				class NoUnderlyingComplexEventPeriods(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41730
						order[1] = 41731
						order[2] = 41750
						order[3] = 41726
						order[4] = 41713
						order[5] = 0
						fix.Group.__init__(self, 41729, 41730, order)

					class NoUnderlyingComplexEventSchedules(fix.Group):
						def __init__(self):
							order = fix.IntArray(6)
							order[0] = 41751
							order[1] = 41752
							order[2] = 41753
							order[3] = 41754
							order[4] = 41755
							order[5] = 0
							fix.Group.__init__(self, 41750, 41751, order)

					class NoUnderlyingComplexEventPeriodDateTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 41727
							order[1] = 41728
							order[2] = 0
							fix.Group.__init__(self, 41726, 41727, order)

					class NoUnderlyingComplexEventAveragingObservations(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 41714
							order[1] = 41715
							order[2] = 0
							fix.Group.__init__(self, 41713, 41714, order)

				class NoUnderlyingComplexEventCreditEventSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41749
						order[1] = 0
						fix.Group.__init__(self, 41748, 41749, order)

				class NoUnderlyingComplexEventCreditEvents(fix.Group):
					def __init__(self):
						order = fix.IntArray(9)
						order[0] = 41717
						order[1] = 41718
						order[2] = 41719
						order[3] = 41720
						order[4] = 41721
						order[5] = 41722
						order[6] = 41723
						order[7] = 41724
						order[8] = 0
						fix.Group.__init__(self, 41716, 41717, order)

					class NoUnderlyingComplexEventCreditEventQualifiers(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 41725
							order[1] = 0
							fix.Group.__init__(self, 41724, 41725, order)

			class NoUnderlyingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40963
					order[1] = 0
					fix.Group.__init__(self, 40962, 40963, order)

			class NoUnderlyingPricingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41948
					order[1] = 0
					fix.Group.__init__(self, 41947, 41948, order)

			class NoUnderlyingMarketDisruptionEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41865
					order[1] = 41338
					order[2] = 0
					fix.Group.__init__(self, 41864, 41865, order)

			class NoUnderlyingMarketDisruptionFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41867
					order[1] = 41339
					order[2] = 0
					fix.Group.__init__(self, 41866, 41867, order)

			class NoUnderlyingMarketDisruptionFallbackReferencePrices(fix.Group):
				def __init__(self):
					order = fix.IntArray(10)
					order[0] = 41869
					order[1] = 41870
					order[2] = 41871
					order[3] = 41872
					order[4] = 41873
					order[5] = 41874
					order[6] = 41875
					order[7] = 41876
					order[8] = 41877
					order[9] = 0
					fix.Group.__init__(self, 41868, 41869, order)

			class NoUnderlyingSettlMethodElectionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 43075
					order[1] = 0
					fix.Group.__init__(self, 43074, 43075, order)

			class NoUnderlyingOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41821
					order[1] = 0
					fix.Group.__init__(self, 41820, 41821, order)

			class NoUnderlyingOptionExerciseDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41842
					order[1] = 41843
					order[2] = 0
					fix.Group.__init__(self, 41841, 41842, order)

			class NoUnderlyingOptionExerciseExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41845
					order[1] = 0
					fix.Group.__init__(self, 41844, 41845, order)

			class NoUnderlyingOptionExerciseExpirationDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41857
					order[1] = 41858
					order[2] = 0
					fix.Group.__init__(self, 41856, 41857, order)

			class NoUnderlyingStreams(fix.Group):
				def __init__(self):
					order = fix.IntArray(135)
					order[0] = 40541
					order[1] = 42016
					order[2] = 40542
					order[3] = 43083
					order[4] = 43084
					order[5] = 40543
					order[6] = 40544
					order[7] = 42018
					order[8] = 40545
					order[9] = 40546
					order[10] = 43085
					order[11] = 43086
					order[12] = 42019
					order[13] = 42020
					order[14] = 42021
					order[15] = 42022
					order[16] = 42023
					order[17] = 42024
					order[18] = 41964
					order[19] = 41965
					order[20] = 41966
					order[21] = 41967
					order[22] = 41968
					order[23] = 41969
					order[24] = 41970
					order[25] = 42589
					order[26] = 41971
					order[27] = 41972
					order[28] = 41973
					order[29] = 41974
					order[30] = 41975
					order[31] = 41976
					order[32] = 41977
					order[33] = 41978
					order[34] = 41979
					order[35] = 41980
					order[36] = 41981
					order[37] = 41982
					order[38] = 41983
					order[39] = 41984
					order[40] = 41985
					order[41] = 41986
					order[42] = 41987
					order[43] = 41988
					order[44] = 41989
					order[45] = 40057
					order[46] = 40058
					order[47] = 40060
					order[48] = 40061
					order[49] = 40062
					order[50] = 40063
					order[51] = 40064
					order[52] = 40548
					order[53] = 40549
					order[54] = 40551
					order[55] = 40552
					order[56] = 40553
					order[57] = 40554
					order[58] = 40555
					order[59] = 41957
					order[60] = 41958
					order[61] = 40556
					order[62] = 40558
					order[63] = 40559
					order[64] = 40561
					order[65] = 40562
					order[66] = 40563
					order[67] = 40564
					order[68] = 40565
					order[69] = 40566
					order[70] = 40567
					order[71] = 41959
					order[72] = 41960
					order[73] = 41961
					order[74] = 40568
					order[75] = 40569
					order[76] = 40570
					order[77] = 42895
					order[78] = 40571
					order[79] = 40572
					order[80] = 43107
					order[81] = 40573
					order[82] = 40574
					order[83] = 40575
					order[84] = 40576
					order[85] = 40577
					order[86] = 42896
					order[87] = 42897
					order[88] = 42898
					order[89] = 42899
					order[90] = 40578
					order[91] = 40579
					order[92] = 40580
					order[93] = 41897
					order[94] = 41898
					order[95] = 41899
					order[96] = 41900
					order[97] = 41901
					order[98] = 41902
					order[99] = 41903
					order[100] = 42900
					order[101] = 40664
					order[102] = 40708
					order[103] = 41777
					order[104] = 41778
					order[105] = 41779
					order[106] = 41780
					order[107] = 41781
					order[108] = 42196
					order[109] = 42197
					order[110] = 41782
					order[111] = 41783
					order[112] = 41784
					order[113] = 41785
					order[114] = 41786
					order[115] = 41587
					order[116] = 41787
					order[117] = 41788
					order[118] = 41789
					order[119] = 41790
					order[120] = 41791
					order[121] = 41792
					order[122] = 41793
					order[123] = 41794
					order[124] = 41795
					order[125] = 41796
					order[126] = 41797
					order[127] = 41798
					order[128] = 41799
					order[129] = 43096
					order[130] = 41756
					order[131] = 40547
					order[132] = 40988
					order[133] = 40989
					order[134] = 0
					fix.Group.__init__(self, 40540, 40541, order)

				class NoUnderlyingStreamCommodityAltIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41991
						order[1] = 41992
						order[2] = 0
						fix.Group.__init__(self, 41990, 41991, order)

				class NoUnderlyingStreamAssetAttributes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41801
						order[1] = 41802
						order[2] = 41803
						order[3] = 0
						fix.Group.__init__(self, 41800, 41801, order)

				class NoUnderlyingStreamCommodityDataSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41994
						order[1] = 41995
						order[2] = 0
						fix.Group.__init__(self, 41993, 41994, order)

				class NoUnderlyingStreamCommoditySettlBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41963
						order[1] = 0
						fix.Group.__init__(self, 41962, 41963, order)

				class NoUnderlyingStreamCommoditySettlPeriods(fix.Group):
					def __init__(self):
						order = fix.IntArray(15)
						order[0] = 42003
						order[1] = 42004
						order[2] = 42005
						order[3] = 42006
						order[4] = 42007
						order[5] = 42008
						order[6] = 42009
						order[7] = 42010
						order[8] = 42011
						order[9] = 42012
						order[10] = 42013
						order[11] = 41996
						order[12] = 42014
						order[13] = 42015
						order[14] = 0
						fix.Group.__init__(self, 42002, 42003, order)

					class NoUnderlyingStreamCommoditySettlDays(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41997
							order[1] = 41998
							order[2] = 41999
							order[3] = 0
							fix.Group.__init__(self, 41996, 41997, order)

						class NoUnderlyingStreamCommoditySettlTimes(fix.Group):
							def __init__(self):
								order = fix.IntArray(4)
								order[0] = 42000
								order[1] = 42001
								order[2] = 41936
								order[3] = 0
								fix.Group.__init__(self, 41999, 42000, order)

				class NoUnderlyingStreamEffectiveDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40059
						order[1] = 0
						fix.Group.__init__(self, 40975, 40059, order)

				class NoUnderlyingStreamTerminationDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40550
						order[1] = 0
						fix.Group.__init__(self, 40976, 40550, order)

				class NoUnderlyingStreamCalculationPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40557
						order[1] = 0
						fix.Group.__init__(self, 40973, 40557, order)

				class NoUnderlyingStreamCalculationPeriodDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41955
						order[1] = 41956
						order[2] = 0
						fix.Group.__init__(self, 41954, 41955, order)

				class NoUnderlyingStreamFirstPeriodStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40560
						order[1] = 0
						fix.Group.__init__(self, 40974, 40560, order)

				class NoUnderlyingPaymentStreamPaymentDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40582
						order[1] = 0
						fix.Group.__init__(self, 40969, 40582, order)

				class NoUnderlyingPaymentStreamPaymentDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41938
						order[1] = 41939
						order[2] = 0
						fix.Group.__init__(self, 41937, 41938, order)

				class NoUnderlyingPaymentStreamResetDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40594
						order[1] = 0
						fix.Group.__init__(self, 40970, 40594, order)

				class NoUnderlyingPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40600
						order[1] = 0
						fix.Group.__init__(self, 40971, 40600, order)

				class NoUnderlyingPaymentStreamFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40607
						order[1] = 0
						fix.Group.__init__(self, 40972, 40607, order)

				class NoUnderlyingPaymentStreamFixingDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42956
						order[1] = 42957
						order[2] = 0
						fix.Group.__init__(self, 42955, 42956, order)

				class NoUnderlyingPaymentStreamPricingBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41910
						order[1] = 0
						fix.Group.__init__(self, 41909, 41910, order)

				class NoUnderlyingPaymentStreamPricingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41945
						order[1] = 41946
						order[2] = 0
						fix.Group.__init__(self, 41944, 41945, order)

				class NoUnderlyingPaymentStreamPricingDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41942
						order[1] = 41943
						order[2] = 0
						fix.Group.__init__(self, 41941, 41942, order)

				class NoUnderlyingPaymentStreamFormulas(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43111
						order[1] = 42982
						order[2] = 42983
						order[3] = 0
						fix.Group.__init__(self, 42981, 43111, order)

				class NoUnderlyingDividendPeriods(fix.Group):
					def __init__(self):
						order = fix.IntArray(21)
						order[0] = 42863
						order[1] = 42864
						order[2] = 42865
						order[3] = 42866
						order[4] = 42867
						order[5] = 42868
						order[6] = 42882
						order[7] = 42869
						order[8] = 42870
						order[9] = 42871
						order[10] = 42872
						order[11] = 42873
						order[12] = 42874
						order[13] = 42875
						order[14] = 42876
						order[15] = 42877
						order[16] = 42878
						order[17] = 42879
						order[18] = 42880
						order[19] = 42881
						order[20] = 0
						fix.Group.__init__(self, 42862, 42863, order)

					class NoUnderlyingDividendPeriodBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 42883
							order[1] = 0
							fix.Group.__init__(self, 42882, 42883, order)

				class NoUnderlyingDividendFXTriggerDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42854
						order[1] = 0
						fix.Group.__init__(self, 42853, 42854, order)

				class NoUnderlyingDividendAccrualPaymentDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42800
						order[1] = 0
						fix.Group.__init__(self, 42799, 42800, order)

				class NoUnderlyingReturnRates(fix.Group):
					def __init__(self):
						order = fix.IntArray(30)
						order[0] = 43035
						order[1] = 43036
						order[2] = 43037
						order[3] = 43038
						order[4] = 43039
						order[5] = 43040
						order[6] = 43064
						order[7] = 43030
						order[8] = 43041
						order[9] = 43042
						order[10] = 43043
						order[11] = 43044
						order[12] = 43045
						order[13] = 43046
						order[14] = 43047
						order[15] = 43048
						order[16] = 43049
						order[17] = 43050
						order[18] = 43051
						order[19] = 43052
						order[20] = 43060
						order[21] = 43053
						order[22] = 43054
						order[23] = 43008
						order[24] = 43055
						order[25] = 43056
						order[26] = 43057
						order[27] = 43058
						order[28] = 43059
						order[29] = 0
						fix.Group.__init__(self, 43034, 43035, order)

					class NoUnderlyingReturnRatePrices(fix.Group):
						def __init__(self):
							order = fix.IntArray(5)
							order[0] = 43065
							order[1] = 43066
							order[2] = 43067
							order[3] = 43068
							order[4] = 0
							fix.Group.__init__(self, 43064, 43065, order)

					class NoUnderlyingReturnRateFXConversions(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 43031
							order[1] = 43032
							order[2] = 43033
							order[3] = 0
							fix.Group.__init__(self, 43030, 43031, order)

					class NoUnderlyingReturnRateInformationSources(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 43061
							order[1] = 43062
							order[2] = 43063
							order[3] = 0
							fix.Group.__init__(self, 43060, 43061, order)

					class NoUnderlyingReturnRateDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(24)
							order[0] = 43009
							order[1] = 43071
							order[2] = 43010
							order[3] = 43011
							order[4] = 43012
							order[5] = 43013
							order[6] = 43014
							order[7] = 43015
							order[8] = 43016
							order[9] = 43017
							order[10] = 43018
							order[11] = 43019
							order[12] = 43020
							order[13] = 43021
							order[14] = 43022
							order[15] = 43023
							order[16] = 43024
							order[17] = 43025
							order[18] = 43026
							order[19] = 43027
							order[20] = 43028
							order[21] = 43029
							order[22] = 43069
							order[23] = 0
							fix.Group.__init__(self, 43008, 43009, order)

						class NoUnderlyingReturnRateValuationDates(fix.Group):
							def __init__(self):
								order = fix.IntArray(3)
								order[0] = 43072
								order[1] = 43073
								order[2] = 0
								fix.Group.__init__(self, 43071, 43072, order)

						class NoUnderlyingReturnRateValuationDateBusinessCenters(fix.Group):
							def __init__(self):
								order = fix.IntArray(2)
								order[0] = 43070
								order[1] = 0
								fix.Group.__init__(self, 43069, 43070, order)

				class NoUnderlyingPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42916
						order[1] = 0
						fix.Group.__init__(self, 42915, 42916, order)

				class NoUnderlyingPaymentStreamCompoundingDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42902
						order[1] = 42903
						order[2] = 0
						fix.Group.__init__(self, 42901, 42902, order)

				class NoUnderlyingPaymentStreamNonDeliverableFixingDatesBizCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40650
						order[1] = 0
						fix.Group.__init__(self, 40968, 40650, order)

				class NoUnderlyingNonDeliverableFixingDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 40657
						order[1] = 40658
						order[2] = 0
						fix.Group.__init__(self, 40656, 40657, order)

				class NoUnderlyingSettlRateFallbacks(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 40660
						order[1] = 40904
						order[2] = 40915
						order[3] = 40662
						order[4] = 40663
						order[5] = 0
						fix.Group.__init__(self, 40659, 40660, order)

				class NoUnderlyingPaymentSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(58)
						order[0] = 40665
						order[1] = 41881
						order[2] = 41882
						order[3] = 40666
						order[4] = 40667
						order[5] = 40668
						order[6] = 40669
						order[7] = 40670
						order[8] = 40671
						order[9] = 40672
						order[10] = 40673
						order[11] = 40674
						order[12] = 40675
						order[13] = 41883
						order[14] = 41884
						order[15] = 41885
						order[16] = 41886
						order[17] = 40676
						order[18] = 40677
						order[19] = 40678
						order[20] = 40679
						order[21] = 41887
						order[22] = 41888
						order[23] = 41889
						order[24] = 41890
						order[25] = 40680
						order[26] = 40681
						order[27] = 40682
						order[28] = 40683
						order[29] = 40684
						order[30] = 40685
						order[31] = 40704
						order[32] = 40686
						order[33] = 40687
						order[34] = 40688
						order[35] = 40689
						order[36] = 40966
						order[37] = 40691
						order[38] = 40692
						order[39] = 40693
						order[40] = 41891
						order[41] = 41892
						order[42] = 40694
						order[43] = 41878
						order[44] = 41893
						order[45] = 41894
						order[46] = 41895
						order[47] = 41896
						order[48] = 40695
						order[49] = 40696
						order[50] = 40697
						order[51] = 40698
						order[52] = 40967
						order[53] = 40700
						order[54] = 40701
						order[55] = 40702
						order[56] = 40703
						order[57] = 0
						fix.Group.__init__(self, 40664, 40665, order)

					class NoUnderlyingPaymentScheduleRateSources(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 40705
							order[1] = 40706
							order[2] = 40707
							order[3] = 0
							fix.Group.__init__(self, 40704, 40705, order)

					class NoUnderlyingPaymentScheduleFixingDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 40690
							order[1] = 0
							fix.Group.__init__(self, 40966, 40690, order)

					class NoUnderlyingPaymentScheduleFixingDays(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 41879
							order[1] = 41880
							order[2] = 0
							fix.Group.__init__(self, 41878, 41879, order)

					class NoUnderlyingPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 40699
							order[1] = 0
							fix.Group.__init__(self, 40967, 40699, order)

				class NoUnderlyingPaymentStubs(fix.Group):
					def __init__(self):
						order = fix.IntArray(44)
						order[0] = 40709
						order[1] = 40710
						order[2] = 42993
						order[3] = 42994
						order[4] = 42995
						order[5] = 42996
						order[6] = 42997
						order[7] = 42998
						order[8] = 42999
						order[9] = 42984
						order[10] = 42985
						order[11] = 42986
						order[12] = 42987
						order[13] = 42988
						order[14] = 42989
						order[15] = 42990
						order[16] = 40711
						order[17] = 40712
						order[18] = 40713
						order[19] = 40714
						order[20] = 40715
						order[21] = 40716
						order[22] = 40717
						order[23] = 40718
						order[24] = 40719
						order[25] = 40720
						order[26] = 40721
						order[27] = 40722
						order[28] = 40723
						order[29] = 40724
						order[30] = 40725
						order[31] = 40726
						order[32] = 40727
						order[33] = 40728
						order[34] = 40729
						order[35] = 40730
						order[36] = 40731
						order[37] = 40732
						order[38] = 40733
						order[39] = 40734
						order[40] = 40735
						order[41] = 40736
						order[42] = 40737
						order[43] = 0
						fix.Group.__init__(self, 40708, 40709, order)

					class NoUnderlyingPaymentStubStartDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 43001
							order[1] = 0
							fix.Group.__init__(self, 43000, 43001, order)

					class NoUnderlyingPaymentStubEndDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 42992
							order[1] = 0
							fix.Group.__init__(self, 42991, 42992, order)

				class NoUnderlyingDeliveryStreamCommoditySources(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41809
						order[1] = 0
						fix.Group.__init__(self, 41808, 41809, order)

				class NoUnderlyingDeliveryStreamCycles(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41805
						order[1] = 41806
						order[2] = 41807
						order[3] = 0
						fix.Group.__init__(self, 41804, 41805, order)

				class NoUnderlyingDeliverySchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(15)
						order[0] = 41757
						order[1] = 41758
						order[2] = 41759
						order[3] = 41760
						order[4] = 41761
						order[5] = 41762
						order[6] = 41763
						order[7] = 41764
						order[8] = 41765
						order[9] = 41766
						order[10] = 41767
						order[11] = 41768
						order[12] = 41769
						order[13] = 41770
						order[14] = 0
						fix.Group.__init__(self, 41756, 41757, order)

					class NoUnderlyingDeliveryScheduleSettlDays(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41771
							order[1] = 41772
							order[2] = 41773
							order[3] = 0
							fix.Group.__init__(self, 41770, 41771, order)

						class NoUnderlyingDeliveryScheduleSettlTimes(fix.Group):
							def __init__(self):
								order = fix.IntArray(4)
								order[0] = 41774
								order[1] = 41775
								order[2] = 41776
								order[3] = 0
								fix.Group.__init__(self, 41773, 41774, order)

			class NoUnderlyingProvisions(fix.Group):
				def __init__(self):
					order = fix.IntArray(79)
					order[0] = 42150
					order[1] = 42151
					order[2] = 42152
					order[3] = 42190
					order[4] = 42153
					order[5] = 42154
					order[6] = 42155
					order[7] = 43002
					order[8] = 43003
					order[9] = 42156
					order[10] = 42157
					order[11] = 42158
					order[12] = 42104
					order[13] = 42105
					order[14] = 42106
					order[15] = 42107
					order[16] = 42108
					order[17] = 42109
					order[18] = 42110
					order[19] = 42111
					order[20] = 42115
					order[21] = 42116
					order[22] = 42117
					order[23] = 42118
					order[24] = 42119
					order[25] = 42120
					order[26] = 42121
					order[27] = 42122
					order[28] = 42123
					order[29] = 42124
					order[30] = 42125
					order[31] = 42126
					order[32] = 42127
					order[33] = 42128
					order[34] = 42129
					order[35] = 42130
					order[36] = 42131
					order[37] = 42132
					order[38] = 42133
					order[39] = 42134
					order[40] = 42135
					order[41] = 42136
					order[42] = 42137
					order[43] = 42138
					order[44] = 42139
					order[45] = 42140
					order[46] = 42141
					order[47] = 42142
					order[48] = 42143
					order[49] = 42144
					order[50] = 42145
					order[51] = 42146
					order[52] = 42147
					order[53] = 42148
					order[54] = 42159
					order[55] = 42160
					order[56] = 42161
					order[57] = 42162
					order[58] = 42163
					order[59] = 42164
					order[60] = 42165
					order[61] = 42092
					order[62] = 42093
					order[63] = 42094
					order[64] = 42095
					order[65] = 42096
					order[66] = 42097
					order[67] = 42098
					order[68] = 42166
					order[69] = 42167
					order[70] = 42168
					order[71] = 42169
					order[72] = 42102
					order[73] = 42103
					order[74] = 42170
					order[75] = 42171
					order[76] = 42172
					order[77] = 42173
					order[78] = 0
					fix.Group.__init__(self, 42149, 42150, order)

				class NoUnderlyingProvisionDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42191
						order[1] = 0
						fix.Group.__init__(self, 42190, 42191, order)

				class NoUnderlyingProvisionCashSettlValueDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42183
						order[1] = 0
						fix.Group.__init__(self, 42182, 42183, order)

				class NoUnderlyingProvisionOptionExerciseBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42185
						order[1] = 0
						fix.Group.__init__(self, 42184, 42185, order)

				class NoUnderlyingProvisionOptionExerciseFixedDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42113
						order[1] = 42114
						order[2] = 0
						fix.Group.__init__(self, 42112, 42113, order)

				class NoUnderlyingProvisionOptionExpirationDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42187
						order[1] = 0
						fix.Group.__init__(self, 42186, 42187, order)

				class NoUnderlyingProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42189
						order[1] = 0
						fix.Group.__init__(self, 42188, 42189, order)

				class NoUnderlyingProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42181
						order[1] = 0
						fix.Group.__init__(self, 42180, 42181, order)

				class NoUnderlyingProvisionCashSettlPaymentDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42100
						order[1] = 42101
						order[2] = 0
						fix.Group.__init__(self, 42099, 42100, order)

				class NoUnderlyingProvisionPartyIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 42174
						order[1] = 42175
						order[2] = 42176
						order[3] = 40918
						order[4] = 42177
						order[5] = 0
						fix.Group.__init__(self, 42173, 42174, order)

					class NoUnderlyingProvisionPartySubIDs(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 42178
							order[1] = 42179
							order[2] = 0
							fix.Group.__init__(self, 42177, 42178, order)

			class NoUnderlyingAdditionalTerms(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42037
					order[1] = 42038
					order[2] = 41340
					order[3] = 0
					fix.Group.__init__(self, 42036, 42037, order)

				class NoUnderlyingAdditionalTermBondRefs(fix.Group):
					def __init__(self):
						order = fix.IntArray(19)
						order[0] = 41341
						order[1] = 41701
						order[2] = 41709
						order[3] = 41710
						order[4] = 41711
						order[5] = 41712
						order[6] = 42017
						order[7] = 42025
						order[8] = 42026
						order[9] = 42027
						order[10] = 42028
						order[11] = 42029
						order[12] = 42030
						order[13] = 42031
						order[14] = 42032
						order[15] = 42033
						order[16] = 42034
						order[17] = 42035
						order[18] = 0
						fix.Group.__init__(self, 41340, 41341, order)

			class NoUnderlyingProtectionTerms(fix.Group):
				def __init__(self):
					order = fix.IntArray(12)
					order[0] = 42069
					order[1] = 42070
					order[2] = 42071
					order[3] = 42072
					order[4] = 42073
					order[5] = 42074
					order[6] = 42075
					order[7] = 42090
					order[8] = 42077
					order[9] = 42087
					order[10] = 42076
					order[11] = 0
					fix.Group.__init__(self, 42068, 42069, order)

				class NoUnderlyingProtectionTermEventNewsSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42091
						order[1] = 0
						fix.Group.__init__(self, 42090, 42091, order)

				class NoUnderlyingProtectionTermEvents(fix.Group):
					def __init__(self):
						order = fix.IntArray(9)
						order[0] = 42078
						order[1] = 42079
						order[2] = 42080
						order[3] = 42081
						order[4] = 42082
						order[5] = 42083
						order[6] = 42084
						order[7] = 42085
						order[8] = 0
						fix.Group.__init__(self, 42077, 42078, order)

					class NoUnderlyingProtectionTermEventQualifiers(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 42086
							order[1] = 0
							fix.Group.__init__(self, 42085, 42086, order)

				class NoUnderlyingProtectionTermObligations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42088
						order[1] = 42089
						order[2] = 0
						fix.Group.__init__(self, 42087, 42088, order)

			class NoUnderlyingCashSettlTerms(fix.Group):
				def __init__(self):
					order = fix.IntArray(29)
					order[0] = 42042
					order[1] = 42043
					order[2] = 42044
					order[3] = 42045
					order[4] = 42046
					order[5] = 42047
					order[6] = 42048
					order[7] = 42049
					order[8] = 42050
					order[9] = 42051
					order[10] = 42052
					order[11] = 42039
					order[12] = 42797
					order[13] = 42798
					order[14] = 42053
					order[15] = 42054
					order[16] = 42790
					order[17] = 42791
					order[18] = 42792
					order[19] = 42793
					order[20] = 42794
					order[21] = 42795
					order[22] = 42796
					order[23] = 42055
					order[24] = 42056
					order[25] = 42057
					order[26] = 42058
					order[27] = 42059
					order[28] = 0
					fix.Group.__init__(self, 42041, 42042, order)

				class NoUnderlyingCashSettlDealers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42040
						order[1] = 0
						fix.Group.__init__(self, 42039, 42040, order)

				class NoUnderlyingCashSettlDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42789
						order[1] = 0
						fix.Group.__init__(self, 42788, 42789, order)

			class NoUnderlyingPhysicalSettlTerms(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 42065
					order[1] = 42061
					order[2] = 42062
					order[3] = 42063
					order[4] = 42064
					order[5] = 0
					fix.Group.__init__(self, 42060, 42065, order)

				class NoUnderlyingPhysicalSettlDeliverableObligations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42066
						order[1] = 42067
						order[2] = 0
						fix.Group.__init__(self, 42065, 42066, order)

			class NoUnderlyingRateSpreadSteps(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 43006
					order[1] = 43007
					order[2] = 0
					fix.Group.__init__(self, 43005, 43006, order)

			class NoUnderlyingDividendPayments(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 42856
					order[1] = 42857
					order[2] = 42858
					order[3] = 42859
					order[4] = 0
					fix.Group.__init__(self, 42855, 42856, order)

			class NoUnderlyingExtraordinaryEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42885
					order[1] = 42886
					order[2] = 0
					fix.Group.__init__(self, 42884, 42885, order)

		class NoStipulations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 233
				order[1] = 234
				order[2] = 0
				fix.Group.__init__(self, 232, 233, order)

		class NoCommissions(fix.Group):
			def __init__(self):
				order = fix.IntArray(17)
				order[0] = 2640
				order[1] = 2641
				order[2] = 2725
				order[3] = 2642
				order[4] = 2643
				order[5] = 2923
				order[6] = 2644
				order[7] = 2645
				order[8] = 2924
				order[9] = 2646
				order[10] = 2647
				order[11] = 2648
				order[12] = 2649
				order[13] = 2650
				order[14] = 2651
				order[15] = 2652
				order[16] = 0
				fix.Group.__init__(self, 2639, 2640, order)

		class NoOrderAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 2594
				order[1] = 2595
				order[2] = 0
				fix.Group.__init__(self, 2593, 2594, order)

		class NoStrategyParameters(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 958
				order[1] = 959
				order[2] = 960
				order[3] = 0
				fix.Group.__init__(self, 957, 958, order)

class OrderCancelRequest(Message):
	def __init__(self):
		Message.__init__(self)
		self.getHeader().setField( fix.MsgType("F") )

	class NoPartyIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 448
			order[1] = 447
			order[2] = 452
			order[3] = 2376
			order[4] = 802
			order[5] = 0
			fix.Group.__init__(self, 453, 448, order)

		class NoPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 523
				order[1] = 803
				order[2] = 0
				fix.Group.__init__(self, 802, 523, order)

	class NoSecurityAltID(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 455
			order[1] = 456
			order[2] = 2957
			order[3] = 0
			fix.Group.__init__(self, 454, 455, order)

	class NoSecondaryAssetClasses(fix.Group):
		def __init__(self):
			order = fix.IntArray(5)
			order[0] = 1977
			order[1] = 1978
			order[2] = 1979
			order[3] = 2741
			order[4] = 0
			fix.Group.__init__(self, 1976, 1977, order)

	class NoAssetAttributes(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 2305
			order[1] = 2306
			order[2] = 2307
			order[3] = 0
			fix.Group.__init__(self, 2304, 2305, order)

	class NoEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(11)
			order[0] = 865
			order[1] = 866
			order[2] = 1145
			order[3] = 1827
			order[4] = 1826
			order[5] = 2340
			order[6] = 867
			order[7] = 868
			order[8] = 1578
			order[9] = 1579
			order[10] = 0
			fix.Group.__init__(self, 864, 865, order)

	class NoInstrumentParties(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1019
			order[1] = 1050
			order[2] = 1051
			order[3] = 2378
			order[4] = 1052
			order[5] = 0
			fix.Group.__init__(self, 1018, 1019, order)

		class NoInstrumentPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 1053
				order[1] = 1054
				order[2] = 0
				fix.Group.__init__(self, 1052, 1053, order)

	class NoComplexEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(53)
			order[0] = 1484
			order[1] = 2117
			order[2] = 2118
			order[3] = 2119
			order[4] = 1485
			order[5] = 2120
			order[6] = 2121
			order[7] = 2122
			order[8] = 2941
			order[9] = 1486
			order[10] = 2123
			order[11] = 1487
			order[12] = 1488
			order[13] = 1489
			order[14] = 1490
			order[15] = 1491
			order[16] = 2124
			order[17] = 2942
			order[18] = 2125
			order[19] = 2943
			order[20] = 2126
			order[21] = 2127
			order[22] = 2407
			order[23] = 2408
			order[24] = 2128
			order[25] = 2129
			order[26] = 2130
			order[27] = 2131
			order[28] = 2132
			order[29] = 41013
			order[30] = 41020
			order[31] = 41021
			order[32] = 41022
			order[33] = 41023
			order[34] = 41024
			order[35] = 41025
			order[36] = 41026
			order[37] = 41027
			order[38] = 41028
			order[39] = 41010
			order[40] = 2133
			order[41] = 2134
			order[42] = 2135
			order[43] = 2136
			order[44] = 2137
			order[45] = 41029
			order[46] = 40997
			order[47] = 2597
			order[48] = 2598
			order[49] = 2599
			order[50] = 2138
			order[51] = 2139
			order[52] = 0
			fix.Group.__init__(self, 1483, 1484, order)

		class NoComplexEventDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 1492
				order[1] = 1493
				order[2] = 1494
				order[3] = 0
				fix.Group.__init__(self, 1491, 1492, order)

			class NoComplexEventTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1495
					order[1] = 1496
					order[2] = 0
					fix.Group.__init__(self, 1494, 1495, order)

		class NoComplexEventRateSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 41014
				order[1] = 41015
				order[2] = 41016
				order[3] = 41017
				order[4] = 0
				fix.Group.__init__(self, 41013, 41014, order)

		class NoComplexEventDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41019
				order[1] = 0
				fix.Group.__init__(self, 41018, 41019, order)

		class NoComplexEventPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41011
				order[1] = 41012
				order[2] = 41031
				order[3] = 41007
				order[4] = 40994
				order[5] = 0
				fix.Group.__init__(self, 41010, 41011, order)

			class NoComplexEventSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41032
					order[1] = 41033
					order[2] = 41034
					order[3] = 41035
					order[4] = 41036
					order[5] = 0
					fix.Group.__init__(self, 41031, 41032, order)

			class NoComplexEventPeriodDateTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41008
					order[1] = 41009
					order[2] = 0
					fix.Group.__init__(self, 41007, 41008, order)

			class NoComplexEventAveragingObservations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40995
					order[1] = 40996
					order[2] = 0
					fix.Group.__init__(self, 40994, 40995, order)

		class NoComplexEventCreditEventSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41030
				order[1] = 0
				fix.Group.__init__(self, 41029, 41030, order)

		class NoComplexEventCreditEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40998
				order[1] = 40999
				order[2] = 41000
				order[3] = 41001
				order[4] = 41002
				order[5] = 41003
				order[6] = 41004
				order[7] = 41005
				order[8] = 0
				fix.Group.__init__(self, 40997, 40998, order)

			class NoComplexEventCreditEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41006
					order[1] = 0
					fix.Group.__init__(self, 41005, 41006, order)

	class NoBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40471
			order[1] = 0
			fix.Group.__init__(self, 40278, 40471, order)

	class NoPricingDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41231
			order[1] = 0
			fix.Group.__init__(self, 41230, 41231, order)

	class NoMarketDisruptionEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41093
			order[1] = 40991
			order[2] = 0
			fix.Group.__init__(self, 41092, 41093, order)

	class NoMarketDisruptionFallbacks(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41095
			order[1] = 40992
			order[2] = 0
			fix.Group.__init__(self, 41094, 41095, order)

	class NoMarketDisruptionFallbackReferencePrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(10)
			order[0] = 41097
			order[1] = 41098
			order[2] = 41099
			order[3] = 41100
			order[4] = 41101
			order[5] = 41102
			order[6] = 41103
			order[7] = 41104
			order[8] = 41105
			order[9] = 0
			fix.Group.__init__(self, 41096, 41097, order)

	class NoSettlMethodElectionDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 42776
			order[1] = 0
			fix.Group.__init__(self, 42775, 42776, order)

	class NoOptionExerciseBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41117
			order[1] = 0
			fix.Group.__init__(self, 41116, 41117, order)

	class NoOptionExerciseDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41138
			order[1] = 41139
			order[2] = 0
			fix.Group.__init__(self, 41137, 41138, order)

	class NoOptionExerciseExpirationDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41141
			order[1] = 0
			fix.Group.__init__(self, 41140, 41141, order)

	class NoOptionExerciseExpirationDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41153
			order[1] = 41154
			order[2] = 0
			fix.Group.__init__(self, 41152, 41153, order)

	class NoStreams(fix.Group):
		def __init__(self):
			order = fix.IntArray(135)
			order[0] = 40050
			order[1] = 41303
			order[2] = 40051
			order[3] = 42784
			order[4] = 42785
			order[5] = 40052
			order[6] = 40053
			order[7] = 41305
			order[8] = 40054
			order[9] = 40055
			order[10] = 42786
			order[11] = 42787
			order[12] = 41306
			order[13] = 41307
			order[14] = 41308
			order[15] = 41309
			order[16] = 41310
			order[17] = 41311
			order[18] = 41251
			order[19] = 41252
			order[20] = 41253
			order[21] = 41254
			order[22] = 41255
			order[23] = 41256
			order[24] = 41257
			order[25] = 42587
			order[26] = 41258
			order[27] = 41259
			order[28] = 41260
			order[29] = 41261
			order[30] = 41262
			order[31] = 41263
			order[32] = 41264
			order[33] = 41265
			order[34] = 41266
			order[35] = 41267
			order[36] = 41268
			order[37] = 41269
			order[38] = 41270
			order[39] = 41271
			order[40] = 41272
			order[41] = 41273
			order[42] = 41274
			order[43] = 41275
			order[44] = 41276
			order[45] = 40907
			order[46] = 40908
			order[47] = 40910
			order[48] = 40911
			order[49] = 40912
			order[50] = 40913
			order[51] = 40914
			order[52] = 40065
			order[53] = 40066
			order[54] = 40068
			order[55] = 40069
			order[56] = 40070
			order[57] = 40071
			order[58] = 40072
			order[59] = 41244
			order[60] = 41245
			order[61] = 40073
			order[62] = 40075
			order[63] = 40076
			order[64] = 40078
			order[65] = 40079
			order[66] = 40080
			order[67] = 40081
			order[68] = 40082
			order[69] = 40083
			order[70] = 40084
			order[71] = 41246
			order[72] = 41247
			order[73] = 41248
			order[74] = 40738
			order[75] = 40739
			order[76] = 40740
			order[77] = 42600
			order[78] = 40741
			order[79] = 40742
			order[80] = 43106
			order[81] = 40743
			order[82] = 40744
			order[83] = 40745
			order[84] = 40746
			order[85] = 40747
			order[86] = 42601
			order[87] = 42602
			order[88] = 42603
			order[89] = 42604
			order[90] = 40748
			order[91] = 40749
			order[92] = 40750
			order[93] = 41180
			order[94] = 41181
			order[95] = 41182
			order[96] = 41183
			order[97] = 41184
			order[98] = 41185
			order[99] = 41186
			order[100] = 42605
			order[101] = 40828
			order[102] = 40872
			order[103] = 41058
			order[104] = 41059
			order[105] = 41060
			order[106] = 41061
			order[107] = 41062
			order[108] = 42192
			order[109] = 42193
			order[110] = 41063
			order[111] = 41064
			order[112] = 41065
			order[113] = 41066
			order[114] = 41067
			order[115] = 41218
			order[116] = 41068
			order[117] = 41069
			order[118] = 41070
			order[119] = 41071
			order[120] = 41072
			order[121] = 41073
			order[122] = 41074
			order[123] = 41075
			order[124] = 41076
			order[125] = 41077
			order[126] = 41078
			order[127] = 41079
			order[128] = 41080
			order[129] = 43094
			order[130] = 41037
			order[131] = 40056
			order[132] = 40982
			order[133] = 40983
			order[134] = 0
			fix.Group.__init__(self, 40049, 40050, order)

		class NoStreamCommodityAltIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41278
				order[1] = 41279
				order[2] = 0
				fix.Group.__init__(self, 41277, 41278, order)

		class NoStreamAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41238
				order[1] = 41239
				order[2] = 41240
				order[3] = 0
				fix.Group.__init__(self, 41237, 41238, order)

		class NoStreamCommodityDataSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41281
				order[1] = 41282
				order[2] = 0
				fix.Group.__init__(self, 41280, 41281, order)

		class NoStreamCommoditySettlBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41250
				order[1] = 0
				fix.Group.__init__(self, 41249, 41250, order)

		class NoStreamCommoditySettlPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41290
				order[1] = 41291
				order[2] = 41292
				order[3] = 41293
				order[4] = 41294
				order[5] = 41295
				order[6] = 41296
				order[7] = 41297
				order[8] = 41298
				order[9] = 41299
				order[10] = 41300
				order[11] = 41283
				order[12] = 41301
				order[13] = 41302
				order[14] = 0
				fix.Group.__init__(self, 41289, 41290, order)

			class NoStreamCommoditySettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41284
					order[1] = 41285
					order[2] = 41286
					order[3] = 0
					fix.Group.__init__(self, 41283, 41284, order)

				class NoStreamCommoditySettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41287
						order[1] = 41288
						order[2] = 41588
						order[3] = 0
						fix.Group.__init__(self, 41286, 41287, order)

		class NoStreamEffectiveDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40909
				order[1] = 0
				fix.Group.__init__(self, 40960, 40909, order)

		class NoStreamTerminationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40067
				order[1] = 0
				fix.Group.__init__(self, 40961, 40067, order)

		class NoStreamCalculationPeriodBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40074
				order[1] = 0
				fix.Group.__init__(self, 40958, 40074, order)

		class NoStreamCalculationPeriodDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41242
				order[1] = 41243
				order[2] = 0
				fix.Group.__init__(self, 41241, 41242, order)

		class NoStreamFirstPeriodStartDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40077
				order[1] = 0
				fix.Group.__init__(self, 40959, 40077, order)

		class NoPaymentStreamPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40752
				order[1] = 0
				fix.Group.__init__(self, 40947, 40752, order)

		class NoPaymentStreamPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41221
				order[1] = 41222
				order[2] = 0
				fix.Group.__init__(self, 41220, 41221, order)

		class NoPaymentStreamResetDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40763
				order[1] = 0
				fix.Group.__init__(self, 40948, 40763, order)

		class NoPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40769
				order[1] = 0
				fix.Group.__init__(self, 40949, 40769, order)

		class NoPaymentStreamFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40776
				order[1] = 0
				fix.Group.__init__(self, 40950, 40776, order)

		class NoPaymentStreamFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42661
				order[1] = 42662
				order[2] = 0
				fix.Group.__init__(self, 42660, 42661, order)

		class NoPaymentStreamPricingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41193
				order[1] = 0
				fix.Group.__init__(self, 41192, 41193, order)

		class NoPaymentStreamPricingDays(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41228
				order[1] = 41229
				order[2] = 0
				fix.Group.__init__(self, 41227, 41228, order)

		class NoPaymentStreamPricingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41225
				order[1] = 41226
				order[2] = 0
				fix.Group.__init__(self, 41224, 41225, order)

		class NoPaymentStreamFormulas(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 43109
				order[1] = 42684
				order[2] = 42685
				order[3] = 0
				fix.Group.__init__(self, 42683, 43109, order)

		class NoDividendPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(21)
				order[0] = 42275
				order[1] = 42276
				order[2] = 42277
				order[3] = 42278
				order[4] = 42279
				order[5] = 42280
				order[6] = 42294
				order[7] = 42281
				order[8] = 42282
				order[9] = 42283
				order[10] = 42284
				order[11] = 42285
				order[12] = 42286
				order[13] = 42287
				order[14] = 42288
				order[15] = 42289
				order[16] = 42290
				order[17] = 42291
				order[18] = 42292
				order[19] = 42293
				order[20] = 0
				fix.Group.__init__(self, 42274, 42275, order)

			class NoDividendPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42295
					order[1] = 0
					fix.Group.__init__(self, 42294, 42295, order)

		class NoDividendFXTriggerDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42273
				order[1] = 0
				fix.Group.__init__(self, 42272, 42273, order)

		class NoDividendAccrualPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42237
				order[1] = 0
				fix.Group.__init__(self, 42236, 42237, order)

		class NoReturnRates(fix.Group):
			def __init__(self):
				order = fix.IntArray(30)
				order[0] = 42736
				order[1] = 42737
				order[2] = 42738
				order[3] = 42739
				order[4] = 42740
				order[5] = 42741
				order[6] = 42765
				order[7] = 42731
				order[8] = 42742
				order[9] = 42743
				order[10] = 42744
				order[11] = 42745
				order[12] = 42746
				order[13] = 42747
				order[14] = 42748
				order[15] = 42749
				order[16] = 42750
				order[17] = 42751
				order[18] = 42752
				order[19] = 42753
				order[20] = 42761
				order[21] = 42754
				order[22] = 42755
				order[23] = 42709
				order[24] = 42756
				order[25] = 42757
				order[26] = 42758
				order[27] = 42759
				order[28] = 42760
				order[29] = 0
				fix.Group.__init__(self, 42735, 42736, order)

			class NoReturnRatePrices(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 42766
					order[1] = 42767
					order[2] = 42768
					order[3] = 42769
					order[4] = 0
					fix.Group.__init__(self, 42765, 42766, order)

			class NoReturnRateFXConversions(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42732
					order[1] = 42733
					order[2] = 42734
					order[3] = 0
					fix.Group.__init__(self, 42731, 42732, order)

			class NoReturnRateInformationSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42762
					order[1] = 42763
					order[2] = 42764
					order[3] = 0
					fix.Group.__init__(self, 42761, 42762, order)

			class NoReturnRateDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(24)
					order[0] = 42710
					order[1] = 42772
					order[2] = 42711
					order[3] = 42712
					order[4] = 42713
					order[5] = 42714
					order[6] = 42715
					order[7] = 42716
					order[8] = 42717
					order[9] = 42718
					order[10] = 42719
					order[11] = 42720
					order[12] = 42721
					order[13] = 42722
					order[14] = 42723
					order[15] = 42724
					order[16] = 42725
					order[17] = 42726
					order[18] = 42727
					order[19] = 42728
					order[20] = 42729
					order[21] = 42730
					order[22] = 42770
					order[23] = 0
					fix.Group.__init__(self, 42709, 42710, order)

				class NoReturnRateValuationDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42773
						order[1] = 42774
						order[2] = 0
						fix.Group.__init__(self, 42772, 42773, order)

				class NoReturnRateValuationDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42771
						order[1] = 0
						fix.Group.__init__(self, 42770, 42771, order)

		class NoPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42621
				order[1] = 0
				fix.Group.__init__(self, 42620, 42621, order)

		class NoPaymentStreamCompoundingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42607
				order[1] = 42608
				order[2] = 0
				fix.Group.__init__(self, 42606, 42607, order)

		class NoPaymentStreamNonDeliverableFixingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40819
				order[1] = 0
				fix.Group.__init__(self, 40946, 40819, order)

		class NoNonDeliverableFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40826
				order[1] = 40827
				order[2] = 0
				fix.Group.__init__(self, 40825, 40826, order)

		class NoSettlRateFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40086
				order[1] = 40373
				order[2] = 40655
				order[3] = 40088
				order[4] = 40089
				order[5] = 0
				fix.Group.__init__(self, 40085, 40086, order)

		class NoPaymentSchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(58)
				order[0] = 40829
				order[1] = 41164
				order[2] = 41165
				order[3] = 40830
				order[4] = 40831
				order[5] = 40832
				order[6] = 40833
				order[7] = 40834
				order[8] = 40835
				order[9] = 40836
				order[10] = 40837
				order[11] = 40838
				order[12] = 40839
				order[13] = 41166
				order[14] = 41167
				order[15] = 41168
				order[16] = 41169
				order[17] = 40840
				order[18] = 40841
				order[19] = 40842
				order[20] = 40843
				order[21] = 41170
				order[22] = 41171
				order[23] = 41172
				order[24] = 41173
				order[25] = 40844
				order[26] = 40845
				order[27] = 40846
				order[28] = 40847
				order[29] = 40848
				order[30] = 40849
				order[31] = 40868
				order[32] = 40850
				order[33] = 40851
				order[34] = 40852
				order[35] = 40853
				order[36] = 40977
				order[37] = 40855
				order[38] = 40856
				order[39] = 40857
				order[40] = 41174
				order[41] = 41175
				order[42] = 40858
				order[43] = 41161
				order[44] = 41176
				order[45] = 41177
				order[46] = 41178
				order[47] = 41179
				order[48] = 40859
				order[49] = 40860
				order[50] = 40861
				order[51] = 40862
				order[52] = 40945
				order[53] = 40864
				order[54] = 40865
				order[55] = 40866
				order[56] = 40867
				order[57] = 0
				fix.Group.__init__(self, 40828, 40829, order)

			class NoPaymentScheduleRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 40869
					order[1] = 40870
					order[2] = 40871
					order[3] = 0
					fix.Group.__init__(self, 40868, 40869, order)

			class NoPaymentScheduleFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40854
					order[1] = 0
					fix.Group.__init__(self, 40977, 40854, order)

			class NoPaymentScheduleFixingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41162
					order[1] = 41163
					order[2] = 0
					fix.Group.__init__(self, 41161, 41162, order)

			class NoPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40863
					order[1] = 0
					fix.Group.__init__(self, 40945, 40863, order)

		class NoPaymentStubs(fix.Group):
			def __init__(self):
				order = fix.IntArray(44)
				order[0] = 40873
				order[1] = 40874
				order[2] = 42698
				order[3] = 42699
				order[4] = 42700
				order[5] = 42701
				order[6] = 42702
				order[7] = 42703
				order[8] = 42704
				order[9] = 42689
				order[10] = 42690
				order[11] = 42691
				order[12] = 42692
				order[13] = 42693
				order[14] = 42694
				order[15] = 42695
				order[16] = 40875
				order[17] = 40876
				order[18] = 40877
				order[19] = 40878
				order[20] = 40879
				order[21] = 40880
				order[22] = 40881
				order[23] = 40882
				order[24] = 40883
				order[25] = 40884
				order[26] = 40885
				order[27] = 40886
				order[28] = 40887
				order[29] = 40888
				order[30] = 40889
				order[31] = 40890
				order[32] = 40891
				order[33] = 40892
				order[34] = 40893
				order[35] = 40894
				order[36] = 40895
				order[37] = 40896
				order[38] = 40897
				order[39] = 40898
				order[40] = 40899
				order[41] = 40900
				order[42] = 40901
				order[43] = 0
				fix.Group.__init__(self, 40872, 40873, order)

			class NoPaymentStubStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42706
					order[1] = 0
					fix.Group.__init__(self, 42705, 42706, order)

			class NoPaymentStubEndDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42697
					order[1] = 0
					fix.Group.__init__(self, 42696, 42697, order)

		class NoDeliveryStreamCommoditySources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41086
				order[1] = 0
				fix.Group.__init__(self, 41085, 41086, order)

		class NoDeliveryStreamCycles(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41082
				order[1] = 41083
				order[2] = 41084
				order[3] = 0
				fix.Group.__init__(self, 41081, 41082, order)

		class NoDeliverySchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41038
				order[1] = 41039
				order[2] = 41040
				order[3] = 41041
				order[4] = 41042
				order[5] = 41043
				order[6] = 41044
				order[7] = 41045
				order[8] = 41046
				order[9] = 41047
				order[10] = 41048
				order[11] = 41049
				order[12] = 41050
				order[13] = 41051
				order[14] = 0
				fix.Group.__init__(self, 41037, 41038, order)

			class NoDeliveryScheduleSettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41052
					order[1] = 41053
					order[2] = 41054
					order[3] = 0
					fix.Group.__init__(self, 41051, 41052, order)

				class NoDeliveryScheduleSettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41055
						order[1] = 41056
						order[2] = 41057
						order[3] = 0
						fix.Group.__init__(self, 41054, 41055, order)

	class NoProvisions(fix.Group):
		def __init__(self):
			order = fix.IntArray(79)
			order[0] = 40091
			order[1] = 40092
			order[2] = 40093
			order[3] = 40957
			order[4] = 40095
			order[5] = 40096
			order[6] = 40097
			order[7] = 42707
			order[8] = 42708
			order[9] = 40098
			order[10] = 40099
			order[11] = 40100
			order[12] = 40114
			order[13] = 40115
			order[14] = 40116
			order[15] = 40118
			order[16] = 40119
			order[17] = 40120
			order[18] = 40121
			order[19] = 40122
			order[20] = 40123
			order[21] = 40125
			order[22] = 40126
			order[23] = 40127
			order[24] = 40128
			order[25] = 40129
			order[26] = 40130
			order[27] = 40131
			order[28] = 40132
			order[29] = 40133
			order[30] = 40134
			order[31] = 40135
			order[32] = 40136
			order[33] = 40137
			order[34] = 40138
			order[35] = 40139
			order[36] = 40140
			order[37] = 40141
			order[38] = 40145
			order[39] = 40146
			order[40] = 40148
			order[41] = 40149
			order[42] = 40150
			order[43] = 40151
			order[44] = 40152
			order[45] = 40153
			order[46] = 40154
			order[47] = 40155
			order[48] = 40156
			order[49] = 40158
			order[50] = 40159
			order[51] = 40160
			order[52] = 40161
			order[53] = 40162
			order[54] = 40101
			order[55] = 40102
			order[56] = 40103
			order[57] = 40104
			order[58] = 40105
			order[59] = 40106
			order[60] = 40107
			order[61] = 40163
			order[62] = 40165
			order[63] = 40166
			order[64] = 40167
			order[65] = 40168
			order[66] = 40169
			order[67] = 40170
			order[68] = 40108
			order[69] = 40109
			order[70] = 40110
			order[71] = 40111
			order[72] = 40112
			order[73] = 41406
			order[74] = 40113
			order[75] = 40986
			order[76] = 40987
			order[77] = 40174
			order[78] = 0
			fix.Group.__init__(self, 40090, 40091, order)

		class NoProvisionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40094
				order[1] = 0
				fix.Group.__init__(self, 40957, 40094, order)

		class NoProvisionCashSettlValueDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40117
				order[1] = 0
				fix.Group.__init__(self, 40953, 40117, order)

		class NoProvisionOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40124
				order[1] = 0
				fix.Group.__init__(self, 40954, 40124, order)

		class NoProvisionOptionExerciseFixedDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40143
				order[1] = 40144
				order[2] = 0
				fix.Group.__init__(self, 40142, 40143, order)

		class NoProvisionOptionExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40147
				order[1] = 0
				fix.Group.__init__(self, 40955, 40147, order)

		class NoProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40157
				order[1] = 0
				fix.Group.__init__(self, 40956, 40157, order)

		class NoProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40164
				order[1] = 0
				fix.Group.__init__(self, 40952, 40164, order)

		class NoProvisionCashSettlPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40172
				order[1] = 40173
				order[2] = 0
				fix.Group.__init__(self, 40171, 40172, order)

		class NoProvisionPartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40175
				order[1] = 40176
				order[2] = 40177
				order[3] = 2385
				order[4] = 40178
				order[5] = 0
				fix.Group.__init__(self, 40174, 40175, order)

			class NoProvisionPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40179
					order[1] = 40180
					order[2] = 0
					fix.Group.__init__(self, 40178, 40179, order)

	class NoAdditionalTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40020
			order[1] = 40021
			order[2] = 40000
			order[3] = 0
			fix.Group.__init__(self, 40019, 40020, order)

		class NoAdditionalTermBondRefs(fix.Group):
			def __init__(self):
				order = fix.IntArray(19)
				order[0] = 40001
				order[1] = 40002
				order[2] = 40003
				order[3] = 40004
				order[4] = 40005
				order[5] = 40006
				order[6] = 40007
				order[7] = 40008
				order[8] = 40009
				order[9] = 40010
				order[10] = 40011
				order[11] = 40012
				order[12] = 40013
				order[13] = 40014
				order[14] = 40015
				order[15] = 40016
				order[16] = 40017
				order[17] = 40018
				order[18] = 0
				fix.Group.__init__(self, 40000, 40001, order)

	class NoProtectionTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(12)
			order[0] = 40182
			order[1] = 40183
			order[2] = 40184
			order[3] = 40185
			order[4] = 40186
			order[5] = 40187
			order[6] = 40188
			order[7] = 40951
			order[8] = 40191
			order[9] = 40201
			order[10] = 40190
			order[11] = 0
			fix.Group.__init__(self, 40181, 40182, order)

		class NoProtectionTermEventNewsSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40189
				order[1] = 0
				fix.Group.__init__(self, 40951, 40189, order)

		class NoProtectionTermEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40192
				order[1] = 40193
				order[2] = 40194
				order[3] = 40195
				order[4] = 40196
				order[5] = 40197
				order[6] = 40198
				order[7] = 40199
				order[8] = 0
				fix.Group.__init__(self, 40191, 40192, order)

			class NoProtectionTermEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40200
					order[1] = 0
					fix.Group.__init__(self, 40199, 40200, order)

		class NoProtectionTermObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40202
				order[1] = 40203
				order[2] = 0
				fix.Group.__init__(self, 40201, 40202, order)

	class NoCashSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(29)
			order[0] = 40023
			order[1] = 40024
			order[2] = 40916
			order[3] = 40917
			order[4] = 40025
			order[5] = 40026
			order[6] = 40027
			order[7] = 40028
			order[8] = 40029
			order[9] = 40030
			order[10] = 40031
			order[11] = 40277
			order[12] = 42216
			order[13] = 42217
			order[14] = 40033
			order[15] = 40034
			order[16] = 42207
			order[17] = 42208
			order[18] = 42209
			order[19] = 42210
			order[20] = 42211
			order[21] = 42212
			order[22] = 42213
			order[23] = 40035
			order[24] = 40036
			order[25] = 40037
			order[26] = 40038
			order[27] = 40039
			order[28] = 0
			fix.Group.__init__(self, 40022, 40023, order)

		class NoCashSettlDealers(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40032
				order[1] = 0
				fix.Group.__init__(self, 40277, 40032, order)

		class NoCashSettlDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42215
				order[1] = 0
				fix.Group.__init__(self, 42214, 42215, order)

	class NoPhysicalSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 40209
			order[1] = 40205
			order[2] = 40206
			order[3] = 40207
			order[4] = 40208
			order[5] = 0
			fix.Group.__init__(self, 40204, 40209, order)

		class NoPhysicalSettlDeliverableObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40210
				order[1] = 40211
				order[2] = 0
				fix.Group.__init__(self, 40209, 40210, order)

	class NoExtraordinaryEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 42297
			order[1] = 42298
			order[2] = 0
			fix.Group.__init__(self, 42296, 42297, order)

	class NoContractualDefinitions(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40041
			order[1] = 0
			fix.Group.__init__(self, 40040, 40041, order)

	class NoFinancingTermSupplements(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 40047
			order[1] = 40048
			order[2] = 0
			fix.Group.__init__(self, 40046, 40047, order)

	class NoContractualMatrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40043
			order[1] = 40044
			order[2] = 40045
			order[3] = 0
			fix.Group.__init__(self, 40042, 40043, order)

	class NoUnderlyings(fix.Group):
		def __init__(self):
			order = fix.IntArray(188)
			order[0] = 311
			order[1] = 312
			order[2] = 309
			order[3] = 305
			order[4] = 2874
			order[5] = 462
			order[6] = 463
			order[7] = 2894
			order[8] = 310
			order[9] = 763
			order[10] = 313
			order[11] = 542
			order[12] = 1213
			order[13] = 1837
			order[14] = 241
			order[15] = 1453
			order[16] = 1454
			order[17] = 2614
			order[18] = 2615
			order[19] = 2921
			order[20] = 2616
			order[21] = 2617
			order[22] = 2619
			order[23] = 1455
			order[24] = 1456
			order[25] = 1459
			order[26] = 1460
			order[27] = 242
			order[28] = 243
			order[29] = 244
			order[30] = 245
			order[31] = 246
			order[32] = 256
			order[33] = 595
			order[34] = 592
			order[35] = 593
			order[36] = 594
			order[37] = 247
			order[38] = 316
			order[39] = 941
			order[40] = 2917
			order[41] = 317
			order[42] = 436
			order[43] = 1437
			order[44] = 2363
			order[45] = 1441
			order[46] = 998
			order[47] = 1423
			order[48] = 1718
			order[49] = 2918
			order[50] = 1424
			order[51] = 1425
			order[52] = 1719
			order[53] = 2919
			order[54] = 1000
			order[55] = 1419
			order[56] = 1526
			order[57] = 2920
			order[58] = 435
			order[59] = 308
			order[60] = 306
			order[61] = 362
			order[62] = 363
			order[63] = 2742
			order[64] = 2720
			order[65] = 2721
			order[66] = 2722
			order[67] = 2723
			order[68] = 2724
			order[69] = 307
			order[70] = 364
			order[71] = 365
			order[72] = 877
			order[73] = 878
			order[74] = 972
			order[75] = 318
			order[76] = 2916
			order[77] = 879
			order[78] = 975
			order[79] = 973
			order[80] = 974
			order[81] = 810
			order[82] = 882
			order[83] = 883
			order[84] = 884
			order[85] = 885
			order[86] = 886
			order[87] = 2885
			order[88] = 2886
			order[89] = 1044
			order[90] = 1045
			order[91] = 1046
			order[92] = 1038
			order[93] = 1039
			order[94] = 315
			order[95] = 2683
			order[96] = 2687
			order[97] = 1988
			order[98] = 1989
			order[99] = 1990
			order[100] = 1991
			order[101] = 1992
			order[102] = 1993
			order[103] = 2881
			order[104] = 1994
			order[105] = 1995
			order[106] = 1996
			order[107] = 1997
			order[108] = 2620
			order[109] = 2621
			order[110] = 1998
			order[111] = 1999
			order[112] = 2000
			order[113] = 2003
			order[114] = 2004
			order[115] = 2005
			order[116] = 2006
			order[117] = 2284
			order[118] = 2285
			order[119] = 2286
			order[120] = 2287
			order[121] = 2288
			order[122] = 2007
			order[123] = 2008
			order[124] = 2009
			order[125] = 2010
			order[126] = 2011
			order[127] = 2012
			order[128] = 2491
			order[129] = 2013
			order[130] = 2014
			order[131] = 2015
			order[132] = 2744
			order[133] = 2016
			order[134] = 2289
			order[135] = 2017
			order[136] = 2018
			order[137] = 2019
			order[138] = 2020
			order[139] = 2021
			order[140] = 2022
			order[141] = 2290
			order[142] = 2622
			order[143] = 2291
			order[144] = 2623
			order[145] = 2292
			order[146] = 2023
			order[147] = 2024
			order[148] = 2025
			order[149] = 2026
			order[150] = 2027
			order[151] = 2028
			order[152] = 2029
			order[153] = 2757
			order[154] = 2030
			order[155] = 2031
			order[156] = 2293
			order[157] = 2294
			order[158] = 2032
			order[159] = 2033
			order[160] = 2034
			order[161] = 2035
			order[162] = 2036
			order[163] = 2037
			order[164] = 2038
			order[165] = 2039
			order[166] = 2040
			order[167] = 2041
			order[168] = 2042
			order[169] = 2043
			order[170] = 2044
			order[171] = 41314
			order[172] = 41315
			order[173] = 2295
			order[174] = 2296
			order[175] = 2297
			order[176] = 2756
			order[177] = 2298
			order[178] = 2299
			order[179] = 2624
			order[180] = 2625
			order[181] = 2626
			order[182] = 2627
			order[183] = 2628
			order[184] = 2629
			order[185] = 2630
			order[186] = 2631
			order[187] = 0
			fix.Group.__init__(self, 711, 311, order)

		class NoUnderlyingSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 458
				order[1] = 459
				order[2] = 2959
				order[3] = 0
				fix.Group.__init__(self, 457, 458, order)

		class NoUnderlyingStips(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 888
				order[1] = 889
				order[2] = 0
				fix.Group.__init__(self, 887, 888, order)

		class NoUndlyInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1059
				order[1] = 1060
				order[2] = 1061
				order[3] = 2391
				order[4] = 1062
				order[5] = 0
				fix.Group.__init__(self, 1058, 1059, order)

			class NoUndlyInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1063
					order[1] = 1064
					order[2] = 0
					fix.Group.__init__(self, 1062, 1063, order)

		class NoUnderlyingEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 1982
				order[1] = 1983
				order[2] = 1984
				order[3] = 1985
				order[4] = 1986
				order[5] = 2342
				order[6] = 1987
				order[7] = 2071
				order[8] = 2072
				order[9] = 2073
				order[10] = 0
				fix.Group.__init__(self, 1981, 1982, order)

		class NoUnderlyingSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2081
				order[1] = 2082
				order[2] = 2083
				order[3] = 2745
				order[4] = 0
				fix.Group.__init__(self, 2080, 2081, order)

		class NoUnderlyingAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2313
				order[1] = 2314
				order[2] = 2315
				order[3] = 0
				fix.Group.__init__(self, 2312, 2313, order)

		class NoUnderlyingComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2046
				order[1] = 2261
				order[2] = 2262
				order[3] = 2263
				order[4] = 2047
				order[5] = 2264
				order[6] = 2265
				order[7] = 2266
				order[8] = 2947
				order[9] = 2048
				order[10] = 2267
				order[11] = 2049
				order[12] = 2050
				order[13] = 2051
				order[14] = 2052
				order[15] = 2053
				order[16] = 2268
				order[17] = 2948
				order[18] = 2269
				order[19] = 2949
				order[20] = 2270
				order[21] = 2271
				order[22] = 2419
				order[23] = 2420
				order[24] = 2272
				order[25] = 2273
				order[26] = 2274
				order[27] = 2275
				order[28] = 2276
				order[29] = 41732
				order[30] = 41739
				order[31] = 41740
				order[32] = 41741
				order[33] = 41742
				order[34] = 41743
				order[35] = 41744
				order[36] = 41745
				order[37] = 41746
				order[38] = 41747
				order[39] = 41729
				order[40] = 2277
				order[41] = 2278
				order[42] = 2279
				order[43] = 2280
				order[44] = 2281
				order[45] = 41748
				order[46] = 41716
				order[47] = 2611
				order[48] = 2612
				order[49] = 2613
				order[50] = 2282
				order[51] = 2283
				order[52] = 0
				fix.Group.__init__(self, 2045, 2046, order)

			class NoUnderlyingComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2054
					order[1] = 2055
					order[2] = 2056
					order[3] = 0
					fix.Group.__init__(self, 2053, 2054, order)

				class NoUnderlyingComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2057
						order[1] = 2058
						order[2] = 0
						fix.Group.__init__(self, 2056, 2057, order)

			class NoUnderlyingComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41733
					order[1] = 41734
					order[2] = 41735
					order[3] = 41736
					order[4] = 0
					fix.Group.__init__(self, 41732, 41733, order)

			class NoUnderlyingComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41738
					order[1] = 0
					fix.Group.__init__(self, 41737, 41738, order)

			class NoUnderlyingComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41730
					order[1] = 41731
					order[2] = 41750
					order[3] = 41726
					order[4] = 41713
					order[5] = 0
					fix.Group.__init__(self, 41729, 41730, order)

				class NoUnderlyingComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41751
						order[1] = 41752
						order[2] = 41753
						order[3] = 41754
						order[4] = 41755
						order[5] = 0
						fix.Group.__init__(self, 41750, 41751, order)

				class NoUnderlyingComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41727
						order[1] = 41728
						order[2] = 0
						fix.Group.__init__(self, 41726, 41727, order)

				class NoUnderlyingComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41714
						order[1] = 41715
						order[2] = 0
						fix.Group.__init__(self, 41713, 41714, order)

			class NoUnderlyingComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41749
					order[1] = 0
					fix.Group.__init__(self, 41748, 41749, order)

			class NoUnderlyingComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41717
					order[1] = 41718
					order[2] = 41719
					order[3] = 41720
					order[4] = 41721
					order[5] = 41722
					order[6] = 41723
					order[7] = 41724
					order[8] = 0
					fix.Group.__init__(self, 41716, 41717, order)

				class NoUnderlyingComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41725
						order[1] = 0
						fix.Group.__init__(self, 41724, 41725, order)

		class NoUnderlyingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40963
				order[1] = 0
				fix.Group.__init__(self, 40962, 40963, order)

		class NoUnderlyingPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41948
				order[1] = 0
				fix.Group.__init__(self, 41947, 41948, order)

		class NoUnderlyingMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41865
				order[1] = 41338
				order[2] = 0
				fix.Group.__init__(self, 41864, 41865, order)

		class NoUnderlyingMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41867
				order[1] = 41339
				order[2] = 0
				fix.Group.__init__(self, 41866, 41867, order)

		class NoUnderlyingMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41869
				order[1] = 41870
				order[2] = 41871
				order[3] = 41872
				order[4] = 41873
				order[5] = 41874
				order[6] = 41875
				order[7] = 41876
				order[8] = 41877
				order[9] = 0
				fix.Group.__init__(self, 41868, 41869, order)

		class NoUnderlyingSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 43075
				order[1] = 0
				fix.Group.__init__(self, 43074, 43075, order)

		class NoUnderlyingOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41821
				order[1] = 0
				fix.Group.__init__(self, 41820, 41821, order)

		class NoUnderlyingOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41842
				order[1] = 41843
				order[2] = 0
				fix.Group.__init__(self, 41841, 41842, order)

		class NoUnderlyingOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41845
				order[1] = 0
				fix.Group.__init__(self, 41844, 41845, order)

		class NoUnderlyingOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41857
				order[1] = 41858
				order[2] = 0
				fix.Group.__init__(self, 41856, 41857, order)

		class NoUnderlyingStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40541
				order[1] = 42016
				order[2] = 40542
				order[3] = 43083
				order[4] = 43084
				order[5] = 40543
				order[6] = 40544
				order[7] = 42018
				order[8] = 40545
				order[9] = 40546
				order[10] = 43085
				order[11] = 43086
				order[12] = 42019
				order[13] = 42020
				order[14] = 42021
				order[15] = 42022
				order[16] = 42023
				order[17] = 42024
				order[18] = 41964
				order[19] = 41965
				order[20] = 41966
				order[21] = 41967
				order[22] = 41968
				order[23] = 41969
				order[24] = 41970
				order[25] = 42589
				order[26] = 41971
				order[27] = 41972
				order[28] = 41973
				order[29] = 41974
				order[30] = 41975
				order[31] = 41976
				order[32] = 41977
				order[33] = 41978
				order[34] = 41979
				order[35] = 41980
				order[36] = 41981
				order[37] = 41982
				order[38] = 41983
				order[39] = 41984
				order[40] = 41985
				order[41] = 41986
				order[42] = 41987
				order[43] = 41988
				order[44] = 41989
				order[45] = 40057
				order[46] = 40058
				order[47] = 40060
				order[48] = 40061
				order[49] = 40062
				order[50] = 40063
				order[51] = 40064
				order[52] = 40548
				order[53] = 40549
				order[54] = 40551
				order[55] = 40552
				order[56] = 40553
				order[57] = 40554
				order[58] = 40555
				order[59] = 41957
				order[60] = 41958
				order[61] = 40556
				order[62] = 40558
				order[63] = 40559
				order[64] = 40561
				order[65] = 40562
				order[66] = 40563
				order[67] = 40564
				order[68] = 40565
				order[69] = 40566
				order[70] = 40567
				order[71] = 41959
				order[72] = 41960
				order[73] = 41961
				order[74] = 40568
				order[75] = 40569
				order[76] = 40570
				order[77] = 42895
				order[78] = 40571
				order[79] = 40572
				order[80] = 43107
				order[81] = 40573
				order[82] = 40574
				order[83] = 40575
				order[84] = 40576
				order[85] = 40577
				order[86] = 42896
				order[87] = 42897
				order[88] = 42898
				order[89] = 42899
				order[90] = 40578
				order[91] = 40579
				order[92] = 40580
				order[93] = 41897
				order[94] = 41898
				order[95] = 41899
				order[96] = 41900
				order[97] = 41901
				order[98] = 41902
				order[99] = 41903
				order[100] = 42900
				order[101] = 40664
				order[102] = 40708
				order[103] = 41777
				order[104] = 41778
				order[105] = 41779
				order[106] = 41780
				order[107] = 41781
				order[108] = 42196
				order[109] = 42197
				order[110] = 41782
				order[111] = 41783
				order[112] = 41784
				order[113] = 41785
				order[114] = 41786
				order[115] = 41587
				order[116] = 41787
				order[117] = 41788
				order[118] = 41789
				order[119] = 41790
				order[120] = 41791
				order[121] = 41792
				order[122] = 41793
				order[123] = 41794
				order[124] = 41795
				order[125] = 41796
				order[126] = 41797
				order[127] = 41798
				order[128] = 41799
				order[129] = 43096
				order[130] = 41756
				order[131] = 40547
				order[132] = 40988
				order[133] = 40989
				order[134] = 0
				fix.Group.__init__(self, 40540, 40541, order)

			class NoUnderlyingStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41991
					order[1] = 41992
					order[2] = 0
					fix.Group.__init__(self, 41990, 41991, order)

			class NoUnderlyingStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41801
					order[1] = 41802
					order[2] = 41803
					order[3] = 0
					fix.Group.__init__(self, 41800, 41801, order)

			class NoUnderlyingStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41994
					order[1] = 41995
					order[2] = 0
					fix.Group.__init__(self, 41993, 41994, order)

			class NoUnderlyingStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41963
					order[1] = 0
					fix.Group.__init__(self, 41962, 41963, order)

			class NoUnderlyingStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 42003
					order[1] = 42004
					order[2] = 42005
					order[3] = 42006
					order[4] = 42007
					order[5] = 42008
					order[6] = 42009
					order[7] = 42010
					order[8] = 42011
					order[9] = 42012
					order[10] = 42013
					order[11] = 41996
					order[12] = 42014
					order[13] = 42015
					order[14] = 0
					fix.Group.__init__(self, 42002, 42003, order)

				class NoUnderlyingStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41997
						order[1] = 41998
						order[2] = 41999
						order[3] = 0
						fix.Group.__init__(self, 41996, 41997, order)

					class NoUnderlyingStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 42000
							order[1] = 42001
							order[2] = 41936
							order[3] = 0
							fix.Group.__init__(self, 41999, 42000, order)

			class NoUnderlyingStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40059
					order[1] = 0
					fix.Group.__init__(self, 40975, 40059, order)

			class NoUnderlyingStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40550
					order[1] = 0
					fix.Group.__init__(self, 40976, 40550, order)

			class NoUnderlyingStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40557
					order[1] = 0
					fix.Group.__init__(self, 40973, 40557, order)

			class NoUnderlyingStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41955
					order[1] = 41956
					order[2] = 0
					fix.Group.__init__(self, 41954, 41955, order)

			class NoUnderlyingStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40560
					order[1] = 0
					fix.Group.__init__(self, 40974, 40560, order)

			class NoUnderlyingPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40582
					order[1] = 0
					fix.Group.__init__(self, 40969, 40582, order)

			class NoUnderlyingPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41938
					order[1] = 41939
					order[2] = 0
					fix.Group.__init__(self, 41937, 41938, order)

			class NoUnderlyingPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40594
					order[1] = 0
					fix.Group.__init__(self, 40970, 40594, order)

			class NoUnderlyingPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40600
					order[1] = 0
					fix.Group.__init__(self, 40971, 40600, order)

			class NoUnderlyingPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40607
					order[1] = 0
					fix.Group.__init__(self, 40972, 40607, order)

			class NoUnderlyingPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42956
					order[1] = 42957
					order[2] = 0
					fix.Group.__init__(self, 42955, 42956, order)

			class NoUnderlyingPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41910
					order[1] = 0
					fix.Group.__init__(self, 41909, 41910, order)

			class NoUnderlyingPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41945
					order[1] = 41946
					order[2] = 0
					fix.Group.__init__(self, 41944, 41945, order)

			class NoUnderlyingPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41942
					order[1] = 41943
					order[2] = 0
					fix.Group.__init__(self, 41941, 41942, order)

			class NoUnderlyingPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43111
					order[1] = 42982
					order[2] = 42983
					order[3] = 0
					fix.Group.__init__(self, 42981, 43111, order)

			class NoUnderlyingDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42863
					order[1] = 42864
					order[2] = 42865
					order[3] = 42866
					order[4] = 42867
					order[5] = 42868
					order[6] = 42882
					order[7] = 42869
					order[8] = 42870
					order[9] = 42871
					order[10] = 42872
					order[11] = 42873
					order[12] = 42874
					order[13] = 42875
					order[14] = 42876
					order[15] = 42877
					order[16] = 42878
					order[17] = 42879
					order[18] = 42880
					order[19] = 42881
					order[20] = 0
					fix.Group.__init__(self, 42862, 42863, order)

				class NoUnderlyingDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42883
						order[1] = 0
						fix.Group.__init__(self, 42882, 42883, order)

			class NoUnderlyingDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42854
					order[1] = 0
					fix.Group.__init__(self, 42853, 42854, order)

			class NoUnderlyingDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42800
					order[1] = 0
					fix.Group.__init__(self, 42799, 42800, order)

			class NoUnderlyingReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 43035
					order[1] = 43036
					order[2] = 43037
					order[3] = 43038
					order[4] = 43039
					order[5] = 43040
					order[6] = 43064
					order[7] = 43030
					order[8] = 43041
					order[9] = 43042
					order[10] = 43043
					order[11] = 43044
					order[12] = 43045
					order[13] = 43046
					order[14] = 43047
					order[15] = 43048
					order[16] = 43049
					order[17] = 43050
					order[18] = 43051
					order[19] = 43052
					order[20] = 43060
					order[21] = 43053
					order[22] = 43054
					order[23] = 43008
					order[24] = 43055
					order[25] = 43056
					order[26] = 43057
					order[27] = 43058
					order[28] = 43059
					order[29] = 0
					fix.Group.__init__(self, 43034, 43035, order)

				class NoUnderlyingReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 43065
						order[1] = 43066
						order[2] = 43067
						order[3] = 43068
						order[4] = 0
						fix.Group.__init__(self, 43064, 43065, order)

				class NoUnderlyingReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43031
						order[1] = 43032
						order[2] = 43033
						order[3] = 0
						fix.Group.__init__(self, 43030, 43031, order)

				class NoUnderlyingReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43061
						order[1] = 43062
						order[2] = 43063
						order[3] = 0
						fix.Group.__init__(self, 43060, 43061, order)

				class NoUnderlyingReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 43009
						order[1] = 43071
						order[2] = 43010
						order[3] = 43011
						order[4] = 43012
						order[5] = 43013
						order[6] = 43014
						order[7] = 43015
						order[8] = 43016
						order[9] = 43017
						order[10] = 43018
						order[11] = 43019
						order[12] = 43020
						order[13] = 43021
						order[14] = 43022
						order[15] = 43023
						order[16] = 43024
						order[17] = 43025
						order[18] = 43026
						order[19] = 43027
						order[20] = 43028
						order[21] = 43029
						order[22] = 43069
						order[23] = 0
						fix.Group.__init__(self, 43008, 43009, order)

					class NoUnderlyingReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 43072
							order[1] = 43073
							order[2] = 0
							fix.Group.__init__(self, 43071, 43072, order)

					class NoUnderlyingReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 43070
							order[1] = 0
							fix.Group.__init__(self, 43069, 43070, order)

			class NoUnderlyingPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42916
					order[1] = 0
					fix.Group.__init__(self, 42915, 42916, order)

			class NoUnderlyingPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42902
					order[1] = 42903
					order[2] = 0
					fix.Group.__init__(self, 42901, 42902, order)

			class NoUnderlyingPaymentStreamNonDeliverableFixingDatesBizCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40650
					order[1] = 0
					fix.Group.__init__(self, 40968, 40650, order)

			class NoUnderlyingNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40657
					order[1] = 40658
					order[2] = 0
					fix.Group.__init__(self, 40656, 40657, order)

			class NoUnderlyingSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40660
					order[1] = 40904
					order[2] = 40915
					order[3] = 40662
					order[4] = 40663
					order[5] = 0
					fix.Group.__init__(self, 40659, 40660, order)

			class NoUnderlyingPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40665
					order[1] = 41881
					order[2] = 41882
					order[3] = 40666
					order[4] = 40667
					order[5] = 40668
					order[6] = 40669
					order[7] = 40670
					order[8] = 40671
					order[9] = 40672
					order[10] = 40673
					order[11] = 40674
					order[12] = 40675
					order[13] = 41883
					order[14] = 41884
					order[15] = 41885
					order[16] = 41886
					order[17] = 40676
					order[18] = 40677
					order[19] = 40678
					order[20] = 40679
					order[21] = 41887
					order[22] = 41888
					order[23] = 41889
					order[24] = 41890
					order[25] = 40680
					order[26] = 40681
					order[27] = 40682
					order[28] = 40683
					order[29] = 40684
					order[30] = 40685
					order[31] = 40704
					order[32] = 40686
					order[33] = 40687
					order[34] = 40688
					order[35] = 40689
					order[36] = 40966
					order[37] = 40691
					order[38] = 40692
					order[39] = 40693
					order[40] = 41891
					order[41] = 41892
					order[42] = 40694
					order[43] = 41878
					order[44] = 41893
					order[45] = 41894
					order[46] = 41895
					order[47] = 41896
					order[48] = 40695
					order[49] = 40696
					order[50] = 40697
					order[51] = 40698
					order[52] = 40967
					order[53] = 40700
					order[54] = 40701
					order[55] = 40702
					order[56] = 40703
					order[57] = 0
					fix.Group.__init__(self, 40664, 40665, order)

				class NoUnderlyingPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40705
						order[1] = 40706
						order[2] = 40707
						order[3] = 0
						fix.Group.__init__(self, 40704, 40705, order)

				class NoUnderlyingPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40690
						order[1] = 0
						fix.Group.__init__(self, 40966, 40690, order)

				class NoUnderlyingPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41879
						order[1] = 41880
						order[2] = 0
						fix.Group.__init__(self, 41878, 41879, order)

				class NoUnderlyingPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40699
						order[1] = 0
						fix.Group.__init__(self, 40967, 40699, order)

			class NoUnderlyingPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40709
					order[1] = 40710
					order[2] = 42993
					order[3] = 42994
					order[4] = 42995
					order[5] = 42996
					order[6] = 42997
					order[7] = 42998
					order[8] = 42999
					order[9] = 42984
					order[10] = 42985
					order[11] = 42986
					order[12] = 42987
					order[13] = 42988
					order[14] = 42989
					order[15] = 42990
					order[16] = 40711
					order[17] = 40712
					order[18] = 40713
					order[19] = 40714
					order[20] = 40715
					order[21] = 40716
					order[22] = 40717
					order[23] = 40718
					order[24] = 40719
					order[25] = 40720
					order[26] = 40721
					order[27] = 40722
					order[28] = 40723
					order[29] = 40724
					order[30] = 40725
					order[31] = 40726
					order[32] = 40727
					order[33] = 40728
					order[34] = 40729
					order[35] = 40730
					order[36] = 40731
					order[37] = 40732
					order[38] = 40733
					order[39] = 40734
					order[40] = 40735
					order[41] = 40736
					order[42] = 40737
					order[43] = 0
					fix.Group.__init__(self, 40708, 40709, order)

				class NoUnderlyingPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 43001
						order[1] = 0
						fix.Group.__init__(self, 43000, 43001, order)

				class NoUnderlyingPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42992
						order[1] = 0
						fix.Group.__init__(self, 42991, 42992, order)

			class NoUnderlyingDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41809
					order[1] = 0
					fix.Group.__init__(self, 41808, 41809, order)

			class NoUnderlyingDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41805
					order[1] = 41806
					order[2] = 41807
					order[3] = 0
					fix.Group.__init__(self, 41804, 41805, order)

			class NoUnderlyingDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41757
					order[1] = 41758
					order[2] = 41759
					order[3] = 41760
					order[4] = 41761
					order[5] = 41762
					order[6] = 41763
					order[7] = 41764
					order[8] = 41765
					order[9] = 41766
					order[10] = 41767
					order[11] = 41768
					order[12] = 41769
					order[13] = 41770
					order[14] = 0
					fix.Group.__init__(self, 41756, 41757, order)

				class NoUnderlyingDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41771
						order[1] = 41772
						order[2] = 41773
						order[3] = 0
						fix.Group.__init__(self, 41770, 41771, order)

					class NoUnderlyingDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41774
							order[1] = 41775
							order[2] = 41776
							order[3] = 0
							fix.Group.__init__(self, 41773, 41774, order)

		class NoUnderlyingProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 42150
				order[1] = 42151
				order[2] = 42152
				order[3] = 42190
				order[4] = 42153
				order[5] = 42154
				order[6] = 42155
				order[7] = 43002
				order[8] = 43003
				order[9] = 42156
				order[10] = 42157
				order[11] = 42158
				order[12] = 42104
				order[13] = 42105
				order[14] = 42106
				order[15] = 42107
				order[16] = 42108
				order[17] = 42109
				order[18] = 42110
				order[19] = 42111
				order[20] = 42115
				order[21] = 42116
				order[22] = 42117
				order[23] = 42118
				order[24] = 42119
				order[25] = 42120
				order[26] = 42121
				order[27] = 42122
				order[28] = 42123
				order[29] = 42124
				order[30] = 42125
				order[31] = 42126
				order[32] = 42127
				order[33] = 42128
				order[34] = 42129
				order[35] = 42130
				order[36] = 42131
				order[37] = 42132
				order[38] = 42133
				order[39] = 42134
				order[40] = 42135
				order[41] = 42136
				order[42] = 42137
				order[43] = 42138
				order[44] = 42139
				order[45] = 42140
				order[46] = 42141
				order[47] = 42142
				order[48] = 42143
				order[49] = 42144
				order[50] = 42145
				order[51] = 42146
				order[52] = 42147
				order[53] = 42148
				order[54] = 42159
				order[55] = 42160
				order[56] = 42161
				order[57] = 42162
				order[58] = 42163
				order[59] = 42164
				order[60] = 42165
				order[61] = 42092
				order[62] = 42093
				order[63] = 42094
				order[64] = 42095
				order[65] = 42096
				order[66] = 42097
				order[67] = 42098
				order[68] = 42166
				order[69] = 42167
				order[70] = 42168
				order[71] = 42169
				order[72] = 42102
				order[73] = 42103
				order[74] = 42170
				order[75] = 42171
				order[76] = 42172
				order[77] = 42173
				order[78] = 0
				fix.Group.__init__(self, 42149, 42150, order)

			class NoUnderlyingProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42191
					order[1] = 0
					fix.Group.__init__(self, 42190, 42191, order)

			class NoUnderlyingProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42183
					order[1] = 0
					fix.Group.__init__(self, 42182, 42183, order)

			class NoUnderlyingProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42185
					order[1] = 0
					fix.Group.__init__(self, 42184, 42185, order)

			class NoUnderlyingProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42113
					order[1] = 42114
					order[2] = 0
					fix.Group.__init__(self, 42112, 42113, order)

			class NoUnderlyingProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42187
					order[1] = 0
					fix.Group.__init__(self, 42186, 42187, order)

			class NoUnderlyingProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42189
					order[1] = 0
					fix.Group.__init__(self, 42188, 42189, order)

			class NoUnderlyingProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42181
					order[1] = 0
					fix.Group.__init__(self, 42180, 42181, order)

			class NoUnderlyingProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42100
					order[1] = 42101
					order[2] = 0
					fix.Group.__init__(self, 42099, 42100, order)

			class NoUnderlyingProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 42174
					order[1] = 42175
					order[2] = 42176
					order[3] = 40918
					order[4] = 42177
					order[5] = 0
					fix.Group.__init__(self, 42173, 42174, order)

				class NoUnderlyingProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42178
						order[1] = 42179
						order[2] = 0
						fix.Group.__init__(self, 42177, 42178, order)

		class NoUnderlyingAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 42037
				order[1] = 42038
				order[2] = 41340
				order[3] = 0
				fix.Group.__init__(self, 42036, 42037, order)

			class NoUnderlyingAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41341
					order[1] = 41701
					order[2] = 41709
					order[3] = 41710
					order[4] = 41711
					order[5] = 41712
					order[6] = 42017
					order[7] = 42025
					order[8] = 42026
					order[9] = 42027
					order[10] = 42028
					order[11] = 42029
					order[12] = 42030
					order[13] = 42031
					order[14] = 42032
					order[15] = 42033
					order[16] = 42034
					order[17] = 42035
					order[18] = 0
					fix.Group.__init__(self, 41340, 41341, order)

		class NoUnderlyingProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 42069
				order[1] = 42070
				order[2] = 42071
				order[3] = 42072
				order[4] = 42073
				order[5] = 42074
				order[6] = 42075
				order[7] = 42090
				order[8] = 42077
				order[9] = 42087
				order[10] = 42076
				order[11] = 0
				fix.Group.__init__(self, 42068, 42069, order)

			class NoUnderlyingProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42091
					order[1] = 0
					fix.Group.__init__(self, 42090, 42091, order)

			class NoUnderlyingProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 42078
					order[1] = 42079
					order[2] = 42080
					order[3] = 42081
					order[4] = 42082
					order[5] = 42083
					order[6] = 42084
					order[7] = 42085
					order[8] = 0
					fix.Group.__init__(self, 42077, 42078, order)

				class NoUnderlyingProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42086
						order[1] = 0
						fix.Group.__init__(self, 42085, 42086, order)

			class NoUnderlyingProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42088
					order[1] = 42089
					order[2] = 0
					fix.Group.__init__(self, 42087, 42088, order)

		class NoUnderlyingCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 42042
				order[1] = 42043
				order[2] = 42044
				order[3] = 42045
				order[4] = 42046
				order[5] = 42047
				order[6] = 42048
				order[7] = 42049
				order[8] = 42050
				order[9] = 42051
				order[10] = 42052
				order[11] = 42039
				order[12] = 42797
				order[13] = 42798
				order[14] = 42053
				order[15] = 42054
				order[16] = 42790
				order[17] = 42791
				order[18] = 42792
				order[19] = 42793
				order[20] = 42794
				order[21] = 42795
				order[22] = 42796
				order[23] = 42055
				order[24] = 42056
				order[25] = 42057
				order[26] = 42058
				order[27] = 42059
				order[28] = 0
				fix.Group.__init__(self, 42041, 42042, order)

			class NoUnderlyingCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42040
					order[1] = 0
					fix.Group.__init__(self, 42039, 42040, order)

			class NoUnderlyingCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42789
					order[1] = 0
					fix.Group.__init__(self, 42788, 42789, order)

		class NoUnderlyingPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 42065
				order[1] = 42061
				order[2] = 42062
				order[3] = 42063
				order[4] = 42064
				order[5] = 0
				fix.Group.__init__(self, 42060, 42065, order)

			class NoUnderlyingPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42066
					order[1] = 42067
					order[2] = 0
					fix.Group.__init__(self, 42065, 42066, order)

		class NoUnderlyingRateSpreadSteps(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 43006
				order[1] = 43007
				order[2] = 0
				fix.Group.__init__(self, 43005, 43006, order)

		class NoUnderlyingDividendPayments(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 42856
				order[1] = 42857
				order[2] = 42858
				order[3] = 42859
				order[4] = 0
				fix.Group.__init__(self, 42855, 42856, order)

		class NoUnderlyingExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42885
				order[1] = 42886
				order[2] = 0
				fix.Group.__init__(self, 42884, 42885, order)

class OrderCancelReplaceRequest(Message):
	def __init__(self):
		Message.__init__(self)
		self.getHeader().setField( fix.MsgType("G") )

	class NoPartyIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 448
			order[1] = 447
			order[2] = 452
			order[3] = 2376
			order[4] = 802
			order[5] = 0
			fix.Group.__init__(self, 453, 448, order)

		class NoPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 523
				order[1] = 803
				order[2] = 0
				fix.Group.__init__(self, 802, 523, order)

	class NoTargetPartyIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1462
			order[1] = 1463
			order[2] = 1464
			order[3] = 1818
			order[4] = 2433
			order[5] = 0
			fix.Group.__init__(self, 1461, 1462, order)

		class NoTargetPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 2434
				order[1] = 2435
				order[2] = 0
				fix.Group.__init__(self, 2433, 2434, order)

	class NoAllocs(fix.Group):
		def __init__(self):
			order = fix.IntArray(14)
			order[0] = 79
			order[1] = 661
			order[2] = 736
			order[3] = 2927
			order[4] = 467
			order[5] = 2727
			order[6] = 539
			order[7] = 209
			order[8] = 80
			order[9] = 1752
			order[10] = 1753
			order[11] = 1754
			order[12] = 1755
			order[13] = 0
			fix.Group.__init__(self, 78, 79, order)

		class NoNestedPartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 524
				order[1] = 525
				order[2] = 538
				order[3] = 2384
				order[4] = 804
				order[5] = 0
				fix.Group.__init__(self, 539, 524, order)

			class NoNestedPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 545
					order[1] = 805
					order[2] = 0
					fix.Group.__init__(self, 804, 545, order)

	class NoValueChecks(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 1869
			order[1] = 1870
			order[2] = 0
			fix.Group.__init__(self, 1868, 1869, order)

	class NoMatchInst(fix.Group):
		def __init__(self):
			order = fix.IntArray(5)
			order[0] = 1625
			order[1] = 1673
			order[2] = 1626
			order[3] = 1627
			order[4] = 0
			fix.Group.__init__(self, 1624, 1625, order)

	class NoDisclosureInstructions(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 1813
			order[1] = 1814
			order[2] = 0
			fix.Group.__init__(self, 1812, 1813, order)

	class NoTradingSessions(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 336
			order[1] = 625
			order[2] = 0
			fix.Group.__init__(self, 386, 336, order)

	class NoSecurityAltID(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 455
			order[1] = 456
			order[2] = 2957
			order[3] = 0
			fix.Group.__init__(self, 454, 455, order)

	class NoSecondaryAssetClasses(fix.Group):
		def __init__(self):
			order = fix.IntArray(5)
			order[0] = 1977
			order[1] = 1978
			order[2] = 1979
			order[3] = 2741
			order[4] = 0
			fix.Group.__init__(self, 1976, 1977, order)

	class NoAssetAttributes(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 2305
			order[1] = 2306
			order[2] = 2307
			order[3] = 0
			fix.Group.__init__(self, 2304, 2305, order)

	class NoEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(11)
			order[0] = 865
			order[1] = 866
			order[2] = 1145
			order[3] = 1827
			order[4] = 1826
			order[5] = 2340
			order[6] = 867
			order[7] = 868
			order[8] = 1578
			order[9] = 1579
			order[10] = 0
			fix.Group.__init__(self, 864, 865, order)

	class NoInstrumentParties(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1019
			order[1] = 1050
			order[2] = 1051
			order[3] = 2378
			order[4] = 1052
			order[5] = 0
			fix.Group.__init__(self, 1018, 1019, order)

		class NoInstrumentPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 1053
				order[1] = 1054
				order[2] = 0
				fix.Group.__init__(self, 1052, 1053, order)

	class NoComplexEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(53)
			order[0] = 1484
			order[1] = 2117
			order[2] = 2118
			order[3] = 2119
			order[4] = 1485
			order[5] = 2120
			order[6] = 2121
			order[7] = 2122
			order[8] = 2941
			order[9] = 1486
			order[10] = 2123
			order[11] = 1487
			order[12] = 1488
			order[13] = 1489
			order[14] = 1490
			order[15] = 1491
			order[16] = 2124
			order[17] = 2942
			order[18] = 2125
			order[19] = 2943
			order[20] = 2126
			order[21] = 2127
			order[22] = 2407
			order[23] = 2408
			order[24] = 2128
			order[25] = 2129
			order[26] = 2130
			order[27] = 2131
			order[28] = 2132
			order[29] = 41013
			order[30] = 41020
			order[31] = 41021
			order[32] = 41022
			order[33] = 41023
			order[34] = 41024
			order[35] = 41025
			order[36] = 41026
			order[37] = 41027
			order[38] = 41028
			order[39] = 41010
			order[40] = 2133
			order[41] = 2134
			order[42] = 2135
			order[43] = 2136
			order[44] = 2137
			order[45] = 41029
			order[46] = 40997
			order[47] = 2597
			order[48] = 2598
			order[49] = 2599
			order[50] = 2138
			order[51] = 2139
			order[52] = 0
			fix.Group.__init__(self, 1483, 1484, order)

		class NoComplexEventDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 1492
				order[1] = 1493
				order[2] = 1494
				order[3] = 0
				fix.Group.__init__(self, 1491, 1492, order)

			class NoComplexEventTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1495
					order[1] = 1496
					order[2] = 0
					fix.Group.__init__(self, 1494, 1495, order)

		class NoComplexEventRateSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 41014
				order[1] = 41015
				order[2] = 41016
				order[3] = 41017
				order[4] = 0
				fix.Group.__init__(self, 41013, 41014, order)

		class NoComplexEventDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41019
				order[1] = 0
				fix.Group.__init__(self, 41018, 41019, order)

		class NoComplexEventPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41011
				order[1] = 41012
				order[2] = 41031
				order[3] = 41007
				order[4] = 40994
				order[5] = 0
				fix.Group.__init__(self, 41010, 41011, order)

			class NoComplexEventSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41032
					order[1] = 41033
					order[2] = 41034
					order[3] = 41035
					order[4] = 41036
					order[5] = 0
					fix.Group.__init__(self, 41031, 41032, order)

			class NoComplexEventPeriodDateTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41008
					order[1] = 41009
					order[2] = 0
					fix.Group.__init__(self, 41007, 41008, order)

			class NoComplexEventAveragingObservations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40995
					order[1] = 40996
					order[2] = 0
					fix.Group.__init__(self, 40994, 40995, order)

		class NoComplexEventCreditEventSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41030
				order[1] = 0
				fix.Group.__init__(self, 41029, 41030, order)

		class NoComplexEventCreditEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40998
				order[1] = 40999
				order[2] = 41000
				order[3] = 41001
				order[4] = 41002
				order[5] = 41003
				order[6] = 41004
				order[7] = 41005
				order[8] = 0
				fix.Group.__init__(self, 40997, 40998, order)

			class NoComplexEventCreditEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41006
					order[1] = 0
					fix.Group.__init__(self, 41005, 41006, order)

	class NoBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40471
			order[1] = 0
			fix.Group.__init__(self, 40278, 40471, order)

	class NoPricingDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41231
			order[1] = 0
			fix.Group.__init__(self, 41230, 41231, order)

	class NoMarketDisruptionEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41093
			order[1] = 40991
			order[2] = 0
			fix.Group.__init__(self, 41092, 41093, order)

	class NoMarketDisruptionFallbacks(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41095
			order[1] = 40992
			order[2] = 0
			fix.Group.__init__(self, 41094, 41095, order)

	class NoMarketDisruptionFallbackReferencePrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(10)
			order[0] = 41097
			order[1] = 41098
			order[2] = 41099
			order[3] = 41100
			order[4] = 41101
			order[5] = 41102
			order[6] = 41103
			order[7] = 41104
			order[8] = 41105
			order[9] = 0
			fix.Group.__init__(self, 41096, 41097, order)

	class NoSettlMethodElectionDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 42776
			order[1] = 0
			fix.Group.__init__(self, 42775, 42776, order)

	class NoOptionExerciseBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41117
			order[1] = 0
			fix.Group.__init__(self, 41116, 41117, order)

	class NoOptionExerciseDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41138
			order[1] = 41139
			order[2] = 0
			fix.Group.__init__(self, 41137, 41138, order)

	class NoOptionExerciseExpirationDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41141
			order[1] = 0
			fix.Group.__init__(self, 41140, 41141, order)

	class NoOptionExerciseExpirationDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41153
			order[1] = 41154
			order[2] = 0
			fix.Group.__init__(self, 41152, 41153, order)

	class NoStreams(fix.Group):
		def __init__(self):
			order = fix.IntArray(135)
			order[0] = 40050
			order[1] = 41303
			order[2] = 40051
			order[3] = 42784
			order[4] = 42785
			order[5] = 40052
			order[6] = 40053
			order[7] = 41305
			order[8] = 40054
			order[9] = 40055
			order[10] = 42786
			order[11] = 42787
			order[12] = 41306
			order[13] = 41307
			order[14] = 41308
			order[15] = 41309
			order[16] = 41310
			order[17] = 41311
			order[18] = 41251
			order[19] = 41252
			order[20] = 41253
			order[21] = 41254
			order[22] = 41255
			order[23] = 41256
			order[24] = 41257
			order[25] = 42587
			order[26] = 41258
			order[27] = 41259
			order[28] = 41260
			order[29] = 41261
			order[30] = 41262
			order[31] = 41263
			order[32] = 41264
			order[33] = 41265
			order[34] = 41266
			order[35] = 41267
			order[36] = 41268
			order[37] = 41269
			order[38] = 41270
			order[39] = 41271
			order[40] = 41272
			order[41] = 41273
			order[42] = 41274
			order[43] = 41275
			order[44] = 41276
			order[45] = 40907
			order[46] = 40908
			order[47] = 40910
			order[48] = 40911
			order[49] = 40912
			order[50] = 40913
			order[51] = 40914
			order[52] = 40065
			order[53] = 40066
			order[54] = 40068
			order[55] = 40069
			order[56] = 40070
			order[57] = 40071
			order[58] = 40072
			order[59] = 41244
			order[60] = 41245
			order[61] = 40073
			order[62] = 40075
			order[63] = 40076
			order[64] = 40078
			order[65] = 40079
			order[66] = 40080
			order[67] = 40081
			order[68] = 40082
			order[69] = 40083
			order[70] = 40084
			order[71] = 41246
			order[72] = 41247
			order[73] = 41248
			order[74] = 40738
			order[75] = 40739
			order[76] = 40740
			order[77] = 42600
			order[78] = 40741
			order[79] = 40742
			order[80] = 43106
			order[81] = 40743
			order[82] = 40744
			order[83] = 40745
			order[84] = 40746
			order[85] = 40747
			order[86] = 42601
			order[87] = 42602
			order[88] = 42603
			order[89] = 42604
			order[90] = 40748
			order[91] = 40749
			order[92] = 40750
			order[93] = 41180
			order[94] = 41181
			order[95] = 41182
			order[96] = 41183
			order[97] = 41184
			order[98] = 41185
			order[99] = 41186
			order[100] = 42605
			order[101] = 40828
			order[102] = 40872
			order[103] = 41058
			order[104] = 41059
			order[105] = 41060
			order[106] = 41061
			order[107] = 41062
			order[108] = 42192
			order[109] = 42193
			order[110] = 41063
			order[111] = 41064
			order[112] = 41065
			order[113] = 41066
			order[114] = 41067
			order[115] = 41218
			order[116] = 41068
			order[117] = 41069
			order[118] = 41070
			order[119] = 41071
			order[120] = 41072
			order[121] = 41073
			order[122] = 41074
			order[123] = 41075
			order[124] = 41076
			order[125] = 41077
			order[126] = 41078
			order[127] = 41079
			order[128] = 41080
			order[129] = 43094
			order[130] = 41037
			order[131] = 40056
			order[132] = 40982
			order[133] = 40983
			order[134] = 0
			fix.Group.__init__(self, 40049, 40050, order)

		class NoStreamCommodityAltIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41278
				order[1] = 41279
				order[2] = 0
				fix.Group.__init__(self, 41277, 41278, order)

		class NoStreamAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41238
				order[1] = 41239
				order[2] = 41240
				order[3] = 0
				fix.Group.__init__(self, 41237, 41238, order)

		class NoStreamCommodityDataSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41281
				order[1] = 41282
				order[2] = 0
				fix.Group.__init__(self, 41280, 41281, order)

		class NoStreamCommoditySettlBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41250
				order[1] = 0
				fix.Group.__init__(self, 41249, 41250, order)

		class NoStreamCommoditySettlPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41290
				order[1] = 41291
				order[2] = 41292
				order[3] = 41293
				order[4] = 41294
				order[5] = 41295
				order[6] = 41296
				order[7] = 41297
				order[8] = 41298
				order[9] = 41299
				order[10] = 41300
				order[11] = 41283
				order[12] = 41301
				order[13] = 41302
				order[14] = 0
				fix.Group.__init__(self, 41289, 41290, order)

			class NoStreamCommoditySettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41284
					order[1] = 41285
					order[2] = 41286
					order[3] = 0
					fix.Group.__init__(self, 41283, 41284, order)

				class NoStreamCommoditySettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41287
						order[1] = 41288
						order[2] = 41588
						order[3] = 0
						fix.Group.__init__(self, 41286, 41287, order)

		class NoStreamEffectiveDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40909
				order[1] = 0
				fix.Group.__init__(self, 40960, 40909, order)

		class NoStreamTerminationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40067
				order[1] = 0
				fix.Group.__init__(self, 40961, 40067, order)

		class NoStreamCalculationPeriodBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40074
				order[1] = 0
				fix.Group.__init__(self, 40958, 40074, order)

		class NoStreamCalculationPeriodDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41242
				order[1] = 41243
				order[2] = 0
				fix.Group.__init__(self, 41241, 41242, order)

		class NoStreamFirstPeriodStartDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40077
				order[1] = 0
				fix.Group.__init__(self, 40959, 40077, order)

		class NoPaymentStreamPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40752
				order[1] = 0
				fix.Group.__init__(self, 40947, 40752, order)

		class NoPaymentStreamPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41221
				order[1] = 41222
				order[2] = 0
				fix.Group.__init__(self, 41220, 41221, order)

		class NoPaymentStreamResetDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40763
				order[1] = 0
				fix.Group.__init__(self, 40948, 40763, order)

		class NoPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40769
				order[1] = 0
				fix.Group.__init__(self, 40949, 40769, order)

		class NoPaymentStreamFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40776
				order[1] = 0
				fix.Group.__init__(self, 40950, 40776, order)

		class NoPaymentStreamFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42661
				order[1] = 42662
				order[2] = 0
				fix.Group.__init__(self, 42660, 42661, order)

		class NoPaymentStreamPricingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41193
				order[1] = 0
				fix.Group.__init__(self, 41192, 41193, order)

		class NoPaymentStreamPricingDays(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41228
				order[1] = 41229
				order[2] = 0
				fix.Group.__init__(self, 41227, 41228, order)

		class NoPaymentStreamPricingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41225
				order[1] = 41226
				order[2] = 0
				fix.Group.__init__(self, 41224, 41225, order)

		class NoPaymentStreamFormulas(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 43109
				order[1] = 42684
				order[2] = 42685
				order[3] = 0
				fix.Group.__init__(self, 42683, 43109, order)

		class NoDividendPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(21)
				order[0] = 42275
				order[1] = 42276
				order[2] = 42277
				order[3] = 42278
				order[4] = 42279
				order[5] = 42280
				order[6] = 42294
				order[7] = 42281
				order[8] = 42282
				order[9] = 42283
				order[10] = 42284
				order[11] = 42285
				order[12] = 42286
				order[13] = 42287
				order[14] = 42288
				order[15] = 42289
				order[16] = 42290
				order[17] = 42291
				order[18] = 42292
				order[19] = 42293
				order[20] = 0
				fix.Group.__init__(self, 42274, 42275, order)

			class NoDividendPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42295
					order[1] = 0
					fix.Group.__init__(self, 42294, 42295, order)

		class NoDividendFXTriggerDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42273
				order[1] = 0
				fix.Group.__init__(self, 42272, 42273, order)

		class NoDividendAccrualPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42237
				order[1] = 0
				fix.Group.__init__(self, 42236, 42237, order)

		class NoReturnRates(fix.Group):
			def __init__(self):
				order = fix.IntArray(30)
				order[0] = 42736
				order[1] = 42737
				order[2] = 42738
				order[3] = 42739
				order[4] = 42740
				order[5] = 42741
				order[6] = 42765
				order[7] = 42731
				order[8] = 42742
				order[9] = 42743
				order[10] = 42744
				order[11] = 42745
				order[12] = 42746
				order[13] = 42747
				order[14] = 42748
				order[15] = 42749
				order[16] = 42750
				order[17] = 42751
				order[18] = 42752
				order[19] = 42753
				order[20] = 42761
				order[21] = 42754
				order[22] = 42755
				order[23] = 42709
				order[24] = 42756
				order[25] = 42757
				order[26] = 42758
				order[27] = 42759
				order[28] = 42760
				order[29] = 0
				fix.Group.__init__(self, 42735, 42736, order)

			class NoReturnRatePrices(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 42766
					order[1] = 42767
					order[2] = 42768
					order[3] = 42769
					order[4] = 0
					fix.Group.__init__(self, 42765, 42766, order)

			class NoReturnRateFXConversions(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42732
					order[1] = 42733
					order[2] = 42734
					order[3] = 0
					fix.Group.__init__(self, 42731, 42732, order)

			class NoReturnRateInformationSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42762
					order[1] = 42763
					order[2] = 42764
					order[3] = 0
					fix.Group.__init__(self, 42761, 42762, order)

			class NoReturnRateDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(24)
					order[0] = 42710
					order[1] = 42772
					order[2] = 42711
					order[3] = 42712
					order[4] = 42713
					order[5] = 42714
					order[6] = 42715
					order[7] = 42716
					order[8] = 42717
					order[9] = 42718
					order[10] = 42719
					order[11] = 42720
					order[12] = 42721
					order[13] = 42722
					order[14] = 42723
					order[15] = 42724
					order[16] = 42725
					order[17] = 42726
					order[18] = 42727
					order[19] = 42728
					order[20] = 42729
					order[21] = 42730
					order[22] = 42770
					order[23] = 0
					fix.Group.__init__(self, 42709, 42710, order)

				class NoReturnRateValuationDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42773
						order[1] = 42774
						order[2] = 0
						fix.Group.__init__(self, 42772, 42773, order)

				class NoReturnRateValuationDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42771
						order[1] = 0
						fix.Group.__init__(self, 42770, 42771, order)

		class NoPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42621
				order[1] = 0
				fix.Group.__init__(self, 42620, 42621, order)

		class NoPaymentStreamCompoundingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42607
				order[1] = 42608
				order[2] = 0
				fix.Group.__init__(self, 42606, 42607, order)

		class NoPaymentStreamNonDeliverableFixingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40819
				order[1] = 0
				fix.Group.__init__(self, 40946, 40819, order)

		class NoNonDeliverableFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40826
				order[1] = 40827
				order[2] = 0
				fix.Group.__init__(self, 40825, 40826, order)

		class NoSettlRateFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40086
				order[1] = 40373
				order[2] = 40655
				order[3] = 40088
				order[4] = 40089
				order[5] = 0
				fix.Group.__init__(self, 40085, 40086, order)

		class NoPaymentSchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(58)
				order[0] = 40829
				order[1] = 41164
				order[2] = 41165
				order[3] = 40830
				order[4] = 40831
				order[5] = 40832
				order[6] = 40833
				order[7] = 40834
				order[8] = 40835
				order[9] = 40836
				order[10] = 40837
				order[11] = 40838
				order[12] = 40839
				order[13] = 41166
				order[14] = 41167
				order[15] = 41168
				order[16] = 41169
				order[17] = 40840
				order[18] = 40841
				order[19] = 40842
				order[20] = 40843
				order[21] = 41170
				order[22] = 41171
				order[23] = 41172
				order[24] = 41173
				order[25] = 40844
				order[26] = 40845
				order[27] = 40846
				order[28] = 40847
				order[29] = 40848
				order[30] = 40849
				order[31] = 40868
				order[32] = 40850
				order[33] = 40851
				order[34] = 40852
				order[35] = 40853
				order[36] = 40977
				order[37] = 40855
				order[38] = 40856
				order[39] = 40857
				order[40] = 41174
				order[41] = 41175
				order[42] = 40858
				order[43] = 41161
				order[44] = 41176
				order[45] = 41177
				order[46] = 41178
				order[47] = 41179
				order[48] = 40859
				order[49] = 40860
				order[50] = 40861
				order[51] = 40862
				order[52] = 40945
				order[53] = 40864
				order[54] = 40865
				order[55] = 40866
				order[56] = 40867
				order[57] = 0
				fix.Group.__init__(self, 40828, 40829, order)

			class NoPaymentScheduleRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 40869
					order[1] = 40870
					order[2] = 40871
					order[3] = 0
					fix.Group.__init__(self, 40868, 40869, order)

			class NoPaymentScheduleFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40854
					order[1] = 0
					fix.Group.__init__(self, 40977, 40854, order)

			class NoPaymentScheduleFixingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41162
					order[1] = 41163
					order[2] = 0
					fix.Group.__init__(self, 41161, 41162, order)

			class NoPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40863
					order[1] = 0
					fix.Group.__init__(self, 40945, 40863, order)

		class NoPaymentStubs(fix.Group):
			def __init__(self):
				order = fix.IntArray(44)
				order[0] = 40873
				order[1] = 40874
				order[2] = 42698
				order[3] = 42699
				order[4] = 42700
				order[5] = 42701
				order[6] = 42702
				order[7] = 42703
				order[8] = 42704
				order[9] = 42689
				order[10] = 42690
				order[11] = 42691
				order[12] = 42692
				order[13] = 42693
				order[14] = 42694
				order[15] = 42695
				order[16] = 40875
				order[17] = 40876
				order[18] = 40877
				order[19] = 40878
				order[20] = 40879
				order[21] = 40880
				order[22] = 40881
				order[23] = 40882
				order[24] = 40883
				order[25] = 40884
				order[26] = 40885
				order[27] = 40886
				order[28] = 40887
				order[29] = 40888
				order[30] = 40889
				order[31] = 40890
				order[32] = 40891
				order[33] = 40892
				order[34] = 40893
				order[35] = 40894
				order[36] = 40895
				order[37] = 40896
				order[38] = 40897
				order[39] = 40898
				order[40] = 40899
				order[41] = 40900
				order[42] = 40901
				order[43] = 0
				fix.Group.__init__(self, 40872, 40873, order)

			class NoPaymentStubStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42706
					order[1] = 0
					fix.Group.__init__(self, 42705, 42706, order)

			class NoPaymentStubEndDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42697
					order[1] = 0
					fix.Group.__init__(self, 42696, 42697, order)

		class NoDeliveryStreamCommoditySources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41086
				order[1] = 0
				fix.Group.__init__(self, 41085, 41086, order)

		class NoDeliveryStreamCycles(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41082
				order[1] = 41083
				order[2] = 41084
				order[3] = 0
				fix.Group.__init__(self, 41081, 41082, order)

		class NoDeliverySchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41038
				order[1] = 41039
				order[2] = 41040
				order[3] = 41041
				order[4] = 41042
				order[5] = 41043
				order[6] = 41044
				order[7] = 41045
				order[8] = 41046
				order[9] = 41047
				order[10] = 41048
				order[11] = 41049
				order[12] = 41050
				order[13] = 41051
				order[14] = 0
				fix.Group.__init__(self, 41037, 41038, order)

			class NoDeliveryScheduleSettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41052
					order[1] = 41053
					order[2] = 41054
					order[3] = 0
					fix.Group.__init__(self, 41051, 41052, order)

				class NoDeliveryScheduleSettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41055
						order[1] = 41056
						order[2] = 41057
						order[3] = 0
						fix.Group.__init__(self, 41054, 41055, order)

	class NoProvisions(fix.Group):
		def __init__(self):
			order = fix.IntArray(79)
			order[0] = 40091
			order[1] = 40092
			order[2] = 40093
			order[3] = 40957
			order[4] = 40095
			order[5] = 40096
			order[6] = 40097
			order[7] = 42707
			order[8] = 42708
			order[9] = 40098
			order[10] = 40099
			order[11] = 40100
			order[12] = 40114
			order[13] = 40115
			order[14] = 40116
			order[15] = 40118
			order[16] = 40119
			order[17] = 40120
			order[18] = 40121
			order[19] = 40122
			order[20] = 40123
			order[21] = 40125
			order[22] = 40126
			order[23] = 40127
			order[24] = 40128
			order[25] = 40129
			order[26] = 40130
			order[27] = 40131
			order[28] = 40132
			order[29] = 40133
			order[30] = 40134
			order[31] = 40135
			order[32] = 40136
			order[33] = 40137
			order[34] = 40138
			order[35] = 40139
			order[36] = 40140
			order[37] = 40141
			order[38] = 40145
			order[39] = 40146
			order[40] = 40148
			order[41] = 40149
			order[42] = 40150
			order[43] = 40151
			order[44] = 40152
			order[45] = 40153
			order[46] = 40154
			order[47] = 40155
			order[48] = 40156
			order[49] = 40158
			order[50] = 40159
			order[51] = 40160
			order[52] = 40161
			order[53] = 40162
			order[54] = 40101
			order[55] = 40102
			order[56] = 40103
			order[57] = 40104
			order[58] = 40105
			order[59] = 40106
			order[60] = 40107
			order[61] = 40163
			order[62] = 40165
			order[63] = 40166
			order[64] = 40167
			order[65] = 40168
			order[66] = 40169
			order[67] = 40170
			order[68] = 40108
			order[69] = 40109
			order[70] = 40110
			order[71] = 40111
			order[72] = 40112
			order[73] = 41406
			order[74] = 40113
			order[75] = 40986
			order[76] = 40987
			order[77] = 40174
			order[78] = 0
			fix.Group.__init__(self, 40090, 40091, order)

		class NoProvisionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40094
				order[1] = 0
				fix.Group.__init__(self, 40957, 40094, order)

		class NoProvisionCashSettlValueDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40117
				order[1] = 0
				fix.Group.__init__(self, 40953, 40117, order)

		class NoProvisionOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40124
				order[1] = 0
				fix.Group.__init__(self, 40954, 40124, order)

		class NoProvisionOptionExerciseFixedDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40143
				order[1] = 40144
				order[2] = 0
				fix.Group.__init__(self, 40142, 40143, order)

		class NoProvisionOptionExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40147
				order[1] = 0
				fix.Group.__init__(self, 40955, 40147, order)

		class NoProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40157
				order[1] = 0
				fix.Group.__init__(self, 40956, 40157, order)

		class NoProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40164
				order[1] = 0
				fix.Group.__init__(self, 40952, 40164, order)

		class NoProvisionCashSettlPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40172
				order[1] = 40173
				order[2] = 0
				fix.Group.__init__(self, 40171, 40172, order)

		class NoProvisionPartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40175
				order[1] = 40176
				order[2] = 40177
				order[3] = 2385
				order[4] = 40178
				order[5] = 0
				fix.Group.__init__(self, 40174, 40175, order)

			class NoProvisionPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40179
					order[1] = 40180
					order[2] = 0
					fix.Group.__init__(self, 40178, 40179, order)

	class NoAdditionalTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40020
			order[1] = 40021
			order[2] = 40000
			order[3] = 0
			fix.Group.__init__(self, 40019, 40020, order)

		class NoAdditionalTermBondRefs(fix.Group):
			def __init__(self):
				order = fix.IntArray(19)
				order[0] = 40001
				order[1] = 40002
				order[2] = 40003
				order[3] = 40004
				order[4] = 40005
				order[5] = 40006
				order[6] = 40007
				order[7] = 40008
				order[8] = 40009
				order[9] = 40010
				order[10] = 40011
				order[11] = 40012
				order[12] = 40013
				order[13] = 40014
				order[14] = 40015
				order[15] = 40016
				order[16] = 40017
				order[17] = 40018
				order[18] = 0
				fix.Group.__init__(self, 40000, 40001, order)

	class NoProtectionTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(12)
			order[0] = 40182
			order[1] = 40183
			order[2] = 40184
			order[3] = 40185
			order[4] = 40186
			order[5] = 40187
			order[6] = 40188
			order[7] = 40951
			order[8] = 40191
			order[9] = 40201
			order[10] = 40190
			order[11] = 0
			fix.Group.__init__(self, 40181, 40182, order)

		class NoProtectionTermEventNewsSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40189
				order[1] = 0
				fix.Group.__init__(self, 40951, 40189, order)

		class NoProtectionTermEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40192
				order[1] = 40193
				order[2] = 40194
				order[3] = 40195
				order[4] = 40196
				order[5] = 40197
				order[6] = 40198
				order[7] = 40199
				order[8] = 0
				fix.Group.__init__(self, 40191, 40192, order)

			class NoProtectionTermEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40200
					order[1] = 0
					fix.Group.__init__(self, 40199, 40200, order)

		class NoProtectionTermObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40202
				order[1] = 40203
				order[2] = 0
				fix.Group.__init__(self, 40201, 40202, order)

	class NoCashSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(29)
			order[0] = 40023
			order[1] = 40024
			order[2] = 40916
			order[3] = 40917
			order[4] = 40025
			order[5] = 40026
			order[6] = 40027
			order[7] = 40028
			order[8] = 40029
			order[9] = 40030
			order[10] = 40031
			order[11] = 40277
			order[12] = 42216
			order[13] = 42217
			order[14] = 40033
			order[15] = 40034
			order[16] = 42207
			order[17] = 42208
			order[18] = 42209
			order[19] = 42210
			order[20] = 42211
			order[21] = 42212
			order[22] = 42213
			order[23] = 40035
			order[24] = 40036
			order[25] = 40037
			order[26] = 40038
			order[27] = 40039
			order[28] = 0
			fix.Group.__init__(self, 40022, 40023, order)

		class NoCashSettlDealers(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40032
				order[1] = 0
				fix.Group.__init__(self, 40277, 40032, order)

		class NoCashSettlDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42215
				order[1] = 0
				fix.Group.__init__(self, 42214, 42215, order)

	class NoPhysicalSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 40209
			order[1] = 40205
			order[2] = 40206
			order[3] = 40207
			order[4] = 40208
			order[5] = 0
			fix.Group.__init__(self, 40204, 40209, order)

		class NoPhysicalSettlDeliverableObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40210
				order[1] = 40211
				order[2] = 0
				fix.Group.__init__(self, 40209, 40210, order)

	class NoExtraordinaryEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 42297
			order[1] = 42298
			order[2] = 0
			fix.Group.__init__(self, 42296, 42297, order)

	class NoContractualDefinitions(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40041
			order[1] = 0
			fix.Group.__init__(self, 40040, 40041, order)

	class NoFinancingTermSupplements(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 40047
			order[1] = 40048
			order[2] = 0
			fix.Group.__init__(self, 40046, 40047, order)

	class NoContractualMatrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40043
			order[1] = 40044
			order[2] = 40045
			order[3] = 0
			fix.Group.__init__(self, 40042, 40043, order)

	class NoUnderlyings(fix.Group):
		def __init__(self):
			order = fix.IntArray(188)
			order[0] = 311
			order[1] = 312
			order[2] = 309
			order[3] = 305
			order[4] = 2874
			order[5] = 462
			order[6] = 463
			order[7] = 2894
			order[8] = 310
			order[9] = 763
			order[10] = 313
			order[11] = 542
			order[12] = 1213
			order[13] = 1837
			order[14] = 241
			order[15] = 1453
			order[16] = 1454
			order[17] = 2614
			order[18] = 2615
			order[19] = 2921
			order[20] = 2616
			order[21] = 2617
			order[22] = 2619
			order[23] = 1455
			order[24] = 1456
			order[25] = 1459
			order[26] = 1460
			order[27] = 242
			order[28] = 243
			order[29] = 244
			order[30] = 245
			order[31] = 246
			order[32] = 256
			order[33] = 595
			order[34] = 592
			order[35] = 593
			order[36] = 594
			order[37] = 247
			order[38] = 316
			order[39] = 941
			order[40] = 2917
			order[41] = 317
			order[42] = 436
			order[43] = 1437
			order[44] = 2363
			order[45] = 1441
			order[46] = 998
			order[47] = 1423
			order[48] = 1718
			order[49] = 2918
			order[50] = 1424
			order[51] = 1425
			order[52] = 1719
			order[53] = 2919
			order[54] = 1000
			order[55] = 1419
			order[56] = 1526
			order[57] = 2920
			order[58] = 435
			order[59] = 308
			order[60] = 306
			order[61] = 362
			order[62] = 363
			order[63] = 2742
			order[64] = 2720
			order[65] = 2721
			order[66] = 2722
			order[67] = 2723
			order[68] = 2724
			order[69] = 307
			order[70] = 364
			order[71] = 365
			order[72] = 877
			order[73] = 878
			order[74] = 972
			order[75] = 318
			order[76] = 2916
			order[77] = 879
			order[78] = 975
			order[79] = 973
			order[80] = 974
			order[81] = 810
			order[82] = 882
			order[83] = 883
			order[84] = 884
			order[85] = 885
			order[86] = 886
			order[87] = 2885
			order[88] = 2886
			order[89] = 1044
			order[90] = 1045
			order[91] = 1046
			order[92] = 1038
			order[93] = 1039
			order[94] = 315
			order[95] = 2683
			order[96] = 2687
			order[97] = 1988
			order[98] = 1989
			order[99] = 1990
			order[100] = 1991
			order[101] = 1992
			order[102] = 1993
			order[103] = 2881
			order[104] = 1994
			order[105] = 1995
			order[106] = 1996
			order[107] = 1997
			order[108] = 2620
			order[109] = 2621
			order[110] = 1998
			order[111] = 1999
			order[112] = 2000
			order[113] = 2003
			order[114] = 2004
			order[115] = 2005
			order[116] = 2006
			order[117] = 2284
			order[118] = 2285
			order[119] = 2286
			order[120] = 2287
			order[121] = 2288
			order[122] = 2007
			order[123] = 2008
			order[124] = 2009
			order[125] = 2010
			order[126] = 2011
			order[127] = 2012
			order[128] = 2491
			order[129] = 2013
			order[130] = 2014
			order[131] = 2015
			order[132] = 2744
			order[133] = 2016
			order[134] = 2289
			order[135] = 2017
			order[136] = 2018
			order[137] = 2019
			order[138] = 2020
			order[139] = 2021
			order[140] = 2022
			order[141] = 2290
			order[142] = 2622
			order[143] = 2291
			order[144] = 2623
			order[145] = 2292
			order[146] = 2023
			order[147] = 2024
			order[148] = 2025
			order[149] = 2026
			order[150] = 2027
			order[151] = 2028
			order[152] = 2029
			order[153] = 2757
			order[154] = 2030
			order[155] = 2031
			order[156] = 2293
			order[157] = 2294
			order[158] = 2032
			order[159] = 2033
			order[160] = 2034
			order[161] = 2035
			order[162] = 2036
			order[163] = 2037
			order[164] = 2038
			order[165] = 2039
			order[166] = 2040
			order[167] = 2041
			order[168] = 2042
			order[169] = 2043
			order[170] = 2044
			order[171] = 41314
			order[172] = 41315
			order[173] = 2295
			order[174] = 2296
			order[175] = 2297
			order[176] = 2756
			order[177] = 2298
			order[178] = 2299
			order[179] = 2624
			order[180] = 2625
			order[181] = 2626
			order[182] = 2627
			order[183] = 2628
			order[184] = 2629
			order[185] = 2630
			order[186] = 2631
			order[187] = 0
			fix.Group.__init__(self, 711, 311, order)

		class NoUnderlyingSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 458
				order[1] = 459
				order[2] = 2959
				order[3] = 0
				fix.Group.__init__(self, 457, 458, order)

		class NoUnderlyingStips(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 888
				order[1] = 889
				order[2] = 0
				fix.Group.__init__(self, 887, 888, order)

		class NoUndlyInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1059
				order[1] = 1060
				order[2] = 1061
				order[3] = 2391
				order[4] = 1062
				order[5] = 0
				fix.Group.__init__(self, 1058, 1059, order)

			class NoUndlyInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1063
					order[1] = 1064
					order[2] = 0
					fix.Group.__init__(self, 1062, 1063, order)

		class NoUnderlyingEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 1982
				order[1] = 1983
				order[2] = 1984
				order[3] = 1985
				order[4] = 1986
				order[5] = 2342
				order[6] = 1987
				order[7] = 2071
				order[8] = 2072
				order[9] = 2073
				order[10] = 0
				fix.Group.__init__(self, 1981, 1982, order)

		class NoUnderlyingSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2081
				order[1] = 2082
				order[2] = 2083
				order[3] = 2745
				order[4] = 0
				fix.Group.__init__(self, 2080, 2081, order)

		class NoUnderlyingAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2313
				order[1] = 2314
				order[2] = 2315
				order[3] = 0
				fix.Group.__init__(self, 2312, 2313, order)

		class NoUnderlyingComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2046
				order[1] = 2261
				order[2] = 2262
				order[3] = 2263
				order[4] = 2047
				order[5] = 2264
				order[6] = 2265
				order[7] = 2266
				order[8] = 2947
				order[9] = 2048
				order[10] = 2267
				order[11] = 2049
				order[12] = 2050
				order[13] = 2051
				order[14] = 2052
				order[15] = 2053
				order[16] = 2268
				order[17] = 2948
				order[18] = 2269
				order[19] = 2949
				order[20] = 2270
				order[21] = 2271
				order[22] = 2419
				order[23] = 2420
				order[24] = 2272
				order[25] = 2273
				order[26] = 2274
				order[27] = 2275
				order[28] = 2276
				order[29] = 41732
				order[30] = 41739
				order[31] = 41740
				order[32] = 41741
				order[33] = 41742
				order[34] = 41743
				order[35] = 41744
				order[36] = 41745
				order[37] = 41746
				order[38] = 41747
				order[39] = 41729
				order[40] = 2277
				order[41] = 2278
				order[42] = 2279
				order[43] = 2280
				order[44] = 2281
				order[45] = 41748
				order[46] = 41716
				order[47] = 2611
				order[48] = 2612
				order[49] = 2613
				order[50] = 2282
				order[51] = 2283
				order[52] = 0
				fix.Group.__init__(self, 2045, 2046, order)

			class NoUnderlyingComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2054
					order[1] = 2055
					order[2] = 2056
					order[3] = 0
					fix.Group.__init__(self, 2053, 2054, order)

				class NoUnderlyingComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2057
						order[1] = 2058
						order[2] = 0
						fix.Group.__init__(self, 2056, 2057, order)

			class NoUnderlyingComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41733
					order[1] = 41734
					order[2] = 41735
					order[3] = 41736
					order[4] = 0
					fix.Group.__init__(self, 41732, 41733, order)

			class NoUnderlyingComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41738
					order[1] = 0
					fix.Group.__init__(self, 41737, 41738, order)

			class NoUnderlyingComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41730
					order[1] = 41731
					order[2] = 41750
					order[3] = 41726
					order[4] = 41713
					order[5] = 0
					fix.Group.__init__(self, 41729, 41730, order)

				class NoUnderlyingComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41751
						order[1] = 41752
						order[2] = 41753
						order[3] = 41754
						order[4] = 41755
						order[5] = 0
						fix.Group.__init__(self, 41750, 41751, order)

				class NoUnderlyingComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41727
						order[1] = 41728
						order[2] = 0
						fix.Group.__init__(self, 41726, 41727, order)

				class NoUnderlyingComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41714
						order[1] = 41715
						order[2] = 0
						fix.Group.__init__(self, 41713, 41714, order)

			class NoUnderlyingComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41749
					order[1] = 0
					fix.Group.__init__(self, 41748, 41749, order)

			class NoUnderlyingComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41717
					order[1] = 41718
					order[2] = 41719
					order[3] = 41720
					order[4] = 41721
					order[5] = 41722
					order[6] = 41723
					order[7] = 41724
					order[8] = 0
					fix.Group.__init__(self, 41716, 41717, order)

				class NoUnderlyingComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41725
						order[1] = 0
						fix.Group.__init__(self, 41724, 41725, order)

		class NoUnderlyingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40963
				order[1] = 0
				fix.Group.__init__(self, 40962, 40963, order)

		class NoUnderlyingPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41948
				order[1] = 0
				fix.Group.__init__(self, 41947, 41948, order)

		class NoUnderlyingMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41865
				order[1] = 41338
				order[2] = 0
				fix.Group.__init__(self, 41864, 41865, order)

		class NoUnderlyingMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41867
				order[1] = 41339
				order[2] = 0
				fix.Group.__init__(self, 41866, 41867, order)

		class NoUnderlyingMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41869
				order[1] = 41870
				order[2] = 41871
				order[3] = 41872
				order[4] = 41873
				order[5] = 41874
				order[6] = 41875
				order[7] = 41876
				order[8] = 41877
				order[9] = 0
				fix.Group.__init__(self, 41868, 41869, order)

		class NoUnderlyingSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 43075
				order[1] = 0
				fix.Group.__init__(self, 43074, 43075, order)

		class NoUnderlyingOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41821
				order[1] = 0
				fix.Group.__init__(self, 41820, 41821, order)

		class NoUnderlyingOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41842
				order[1] = 41843
				order[2] = 0
				fix.Group.__init__(self, 41841, 41842, order)

		class NoUnderlyingOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41845
				order[1] = 0
				fix.Group.__init__(self, 41844, 41845, order)

		class NoUnderlyingOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41857
				order[1] = 41858
				order[2] = 0
				fix.Group.__init__(self, 41856, 41857, order)

		class NoUnderlyingStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40541
				order[1] = 42016
				order[2] = 40542
				order[3] = 43083
				order[4] = 43084
				order[5] = 40543
				order[6] = 40544
				order[7] = 42018
				order[8] = 40545
				order[9] = 40546
				order[10] = 43085
				order[11] = 43086
				order[12] = 42019
				order[13] = 42020
				order[14] = 42021
				order[15] = 42022
				order[16] = 42023
				order[17] = 42024
				order[18] = 41964
				order[19] = 41965
				order[20] = 41966
				order[21] = 41967
				order[22] = 41968
				order[23] = 41969
				order[24] = 41970
				order[25] = 42589
				order[26] = 41971
				order[27] = 41972
				order[28] = 41973
				order[29] = 41974
				order[30] = 41975
				order[31] = 41976
				order[32] = 41977
				order[33] = 41978
				order[34] = 41979
				order[35] = 41980
				order[36] = 41981
				order[37] = 41982
				order[38] = 41983
				order[39] = 41984
				order[40] = 41985
				order[41] = 41986
				order[42] = 41987
				order[43] = 41988
				order[44] = 41989
				order[45] = 40057
				order[46] = 40058
				order[47] = 40060
				order[48] = 40061
				order[49] = 40062
				order[50] = 40063
				order[51] = 40064
				order[52] = 40548
				order[53] = 40549
				order[54] = 40551
				order[55] = 40552
				order[56] = 40553
				order[57] = 40554
				order[58] = 40555
				order[59] = 41957
				order[60] = 41958
				order[61] = 40556
				order[62] = 40558
				order[63] = 40559
				order[64] = 40561
				order[65] = 40562
				order[66] = 40563
				order[67] = 40564
				order[68] = 40565
				order[69] = 40566
				order[70] = 40567
				order[71] = 41959
				order[72] = 41960
				order[73] = 41961
				order[74] = 40568
				order[75] = 40569
				order[76] = 40570
				order[77] = 42895
				order[78] = 40571
				order[79] = 40572
				order[80] = 43107
				order[81] = 40573
				order[82] = 40574
				order[83] = 40575
				order[84] = 40576
				order[85] = 40577
				order[86] = 42896
				order[87] = 42897
				order[88] = 42898
				order[89] = 42899
				order[90] = 40578
				order[91] = 40579
				order[92] = 40580
				order[93] = 41897
				order[94] = 41898
				order[95] = 41899
				order[96] = 41900
				order[97] = 41901
				order[98] = 41902
				order[99] = 41903
				order[100] = 42900
				order[101] = 40664
				order[102] = 40708
				order[103] = 41777
				order[104] = 41778
				order[105] = 41779
				order[106] = 41780
				order[107] = 41781
				order[108] = 42196
				order[109] = 42197
				order[110] = 41782
				order[111] = 41783
				order[112] = 41784
				order[113] = 41785
				order[114] = 41786
				order[115] = 41587
				order[116] = 41787
				order[117] = 41788
				order[118] = 41789
				order[119] = 41790
				order[120] = 41791
				order[121] = 41792
				order[122] = 41793
				order[123] = 41794
				order[124] = 41795
				order[125] = 41796
				order[126] = 41797
				order[127] = 41798
				order[128] = 41799
				order[129] = 43096
				order[130] = 41756
				order[131] = 40547
				order[132] = 40988
				order[133] = 40989
				order[134] = 0
				fix.Group.__init__(self, 40540, 40541, order)

			class NoUnderlyingStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41991
					order[1] = 41992
					order[2] = 0
					fix.Group.__init__(self, 41990, 41991, order)

			class NoUnderlyingStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41801
					order[1] = 41802
					order[2] = 41803
					order[3] = 0
					fix.Group.__init__(self, 41800, 41801, order)

			class NoUnderlyingStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41994
					order[1] = 41995
					order[2] = 0
					fix.Group.__init__(self, 41993, 41994, order)

			class NoUnderlyingStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41963
					order[1] = 0
					fix.Group.__init__(self, 41962, 41963, order)

			class NoUnderlyingStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 42003
					order[1] = 42004
					order[2] = 42005
					order[3] = 42006
					order[4] = 42007
					order[5] = 42008
					order[6] = 42009
					order[7] = 42010
					order[8] = 42011
					order[9] = 42012
					order[10] = 42013
					order[11] = 41996
					order[12] = 42014
					order[13] = 42015
					order[14] = 0
					fix.Group.__init__(self, 42002, 42003, order)

				class NoUnderlyingStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41997
						order[1] = 41998
						order[2] = 41999
						order[3] = 0
						fix.Group.__init__(self, 41996, 41997, order)

					class NoUnderlyingStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 42000
							order[1] = 42001
							order[2] = 41936
							order[3] = 0
							fix.Group.__init__(self, 41999, 42000, order)

			class NoUnderlyingStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40059
					order[1] = 0
					fix.Group.__init__(self, 40975, 40059, order)

			class NoUnderlyingStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40550
					order[1] = 0
					fix.Group.__init__(self, 40976, 40550, order)

			class NoUnderlyingStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40557
					order[1] = 0
					fix.Group.__init__(self, 40973, 40557, order)

			class NoUnderlyingStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41955
					order[1] = 41956
					order[2] = 0
					fix.Group.__init__(self, 41954, 41955, order)

			class NoUnderlyingStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40560
					order[1] = 0
					fix.Group.__init__(self, 40974, 40560, order)

			class NoUnderlyingPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40582
					order[1] = 0
					fix.Group.__init__(self, 40969, 40582, order)

			class NoUnderlyingPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41938
					order[1] = 41939
					order[2] = 0
					fix.Group.__init__(self, 41937, 41938, order)

			class NoUnderlyingPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40594
					order[1] = 0
					fix.Group.__init__(self, 40970, 40594, order)

			class NoUnderlyingPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40600
					order[1] = 0
					fix.Group.__init__(self, 40971, 40600, order)

			class NoUnderlyingPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40607
					order[1] = 0
					fix.Group.__init__(self, 40972, 40607, order)

			class NoUnderlyingPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42956
					order[1] = 42957
					order[2] = 0
					fix.Group.__init__(self, 42955, 42956, order)

			class NoUnderlyingPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41910
					order[1] = 0
					fix.Group.__init__(self, 41909, 41910, order)

			class NoUnderlyingPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41945
					order[1] = 41946
					order[2] = 0
					fix.Group.__init__(self, 41944, 41945, order)

			class NoUnderlyingPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41942
					order[1] = 41943
					order[2] = 0
					fix.Group.__init__(self, 41941, 41942, order)

			class NoUnderlyingPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43111
					order[1] = 42982
					order[2] = 42983
					order[3] = 0
					fix.Group.__init__(self, 42981, 43111, order)

			class NoUnderlyingDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42863
					order[1] = 42864
					order[2] = 42865
					order[3] = 42866
					order[4] = 42867
					order[5] = 42868
					order[6] = 42882
					order[7] = 42869
					order[8] = 42870
					order[9] = 42871
					order[10] = 42872
					order[11] = 42873
					order[12] = 42874
					order[13] = 42875
					order[14] = 42876
					order[15] = 42877
					order[16] = 42878
					order[17] = 42879
					order[18] = 42880
					order[19] = 42881
					order[20] = 0
					fix.Group.__init__(self, 42862, 42863, order)

				class NoUnderlyingDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42883
						order[1] = 0
						fix.Group.__init__(self, 42882, 42883, order)

			class NoUnderlyingDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42854
					order[1] = 0
					fix.Group.__init__(self, 42853, 42854, order)

			class NoUnderlyingDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42800
					order[1] = 0
					fix.Group.__init__(self, 42799, 42800, order)

			class NoUnderlyingReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 43035
					order[1] = 43036
					order[2] = 43037
					order[3] = 43038
					order[4] = 43039
					order[5] = 43040
					order[6] = 43064
					order[7] = 43030
					order[8] = 43041
					order[9] = 43042
					order[10] = 43043
					order[11] = 43044
					order[12] = 43045
					order[13] = 43046
					order[14] = 43047
					order[15] = 43048
					order[16] = 43049
					order[17] = 43050
					order[18] = 43051
					order[19] = 43052
					order[20] = 43060
					order[21] = 43053
					order[22] = 43054
					order[23] = 43008
					order[24] = 43055
					order[25] = 43056
					order[26] = 43057
					order[27] = 43058
					order[28] = 43059
					order[29] = 0
					fix.Group.__init__(self, 43034, 43035, order)

				class NoUnderlyingReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 43065
						order[1] = 43066
						order[2] = 43067
						order[3] = 43068
						order[4] = 0
						fix.Group.__init__(self, 43064, 43065, order)

				class NoUnderlyingReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43031
						order[1] = 43032
						order[2] = 43033
						order[3] = 0
						fix.Group.__init__(self, 43030, 43031, order)

				class NoUnderlyingReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43061
						order[1] = 43062
						order[2] = 43063
						order[3] = 0
						fix.Group.__init__(self, 43060, 43061, order)

				class NoUnderlyingReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 43009
						order[1] = 43071
						order[2] = 43010
						order[3] = 43011
						order[4] = 43012
						order[5] = 43013
						order[6] = 43014
						order[7] = 43015
						order[8] = 43016
						order[9] = 43017
						order[10] = 43018
						order[11] = 43019
						order[12] = 43020
						order[13] = 43021
						order[14] = 43022
						order[15] = 43023
						order[16] = 43024
						order[17] = 43025
						order[18] = 43026
						order[19] = 43027
						order[20] = 43028
						order[21] = 43029
						order[22] = 43069
						order[23] = 0
						fix.Group.__init__(self, 43008, 43009, order)

					class NoUnderlyingReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 43072
							order[1] = 43073
							order[2] = 0
							fix.Group.__init__(self, 43071, 43072, order)

					class NoUnderlyingReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 43070
							order[1] = 0
							fix.Group.__init__(self, 43069, 43070, order)

			class NoUnderlyingPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42916
					order[1] = 0
					fix.Group.__init__(self, 42915, 42916, order)

			class NoUnderlyingPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42902
					order[1] = 42903
					order[2] = 0
					fix.Group.__init__(self, 42901, 42902, order)

			class NoUnderlyingPaymentStreamNonDeliverableFixingDatesBizCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40650
					order[1] = 0
					fix.Group.__init__(self, 40968, 40650, order)

			class NoUnderlyingNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40657
					order[1] = 40658
					order[2] = 0
					fix.Group.__init__(self, 40656, 40657, order)

			class NoUnderlyingSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40660
					order[1] = 40904
					order[2] = 40915
					order[3] = 40662
					order[4] = 40663
					order[5] = 0
					fix.Group.__init__(self, 40659, 40660, order)

			class NoUnderlyingPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40665
					order[1] = 41881
					order[2] = 41882
					order[3] = 40666
					order[4] = 40667
					order[5] = 40668
					order[6] = 40669
					order[7] = 40670
					order[8] = 40671
					order[9] = 40672
					order[10] = 40673
					order[11] = 40674
					order[12] = 40675
					order[13] = 41883
					order[14] = 41884
					order[15] = 41885
					order[16] = 41886
					order[17] = 40676
					order[18] = 40677
					order[19] = 40678
					order[20] = 40679
					order[21] = 41887
					order[22] = 41888
					order[23] = 41889
					order[24] = 41890
					order[25] = 40680
					order[26] = 40681
					order[27] = 40682
					order[28] = 40683
					order[29] = 40684
					order[30] = 40685
					order[31] = 40704
					order[32] = 40686
					order[33] = 40687
					order[34] = 40688
					order[35] = 40689
					order[36] = 40966
					order[37] = 40691
					order[38] = 40692
					order[39] = 40693
					order[40] = 41891
					order[41] = 41892
					order[42] = 40694
					order[43] = 41878
					order[44] = 41893
					order[45] = 41894
					order[46] = 41895
					order[47] = 41896
					order[48] = 40695
					order[49] = 40696
					order[50] = 40697
					order[51] = 40698
					order[52] = 40967
					order[53] = 40700
					order[54] = 40701
					order[55] = 40702
					order[56] = 40703
					order[57] = 0
					fix.Group.__init__(self, 40664, 40665, order)

				class NoUnderlyingPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40705
						order[1] = 40706
						order[2] = 40707
						order[3] = 0
						fix.Group.__init__(self, 40704, 40705, order)

				class NoUnderlyingPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40690
						order[1] = 0
						fix.Group.__init__(self, 40966, 40690, order)

				class NoUnderlyingPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41879
						order[1] = 41880
						order[2] = 0
						fix.Group.__init__(self, 41878, 41879, order)

				class NoUnderlyingPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40699
						order[1] = 0
						fix.Group.__init__(self, 40967, 40699, order)

			class NoUnderlyingPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40709
					order[1] = 40710
					order[2] = 42993
					order[3] = 42994
					order[4] = 42995
					order[5] = 42996
					order[6] = 42997
					order[7] = 42998
					order[8] = 42999
					order[9] = 42984
					order[10] = 42985
					order[11] = 42986
					order[12] = 42987
					order[13] = 42988
					order[14] = 42989
					order[15] = 42990
					order[16] = 40711
					order[17] = 40712
					order[18] = 40713
					order[19] = 40714
					order[20] = 40715
					order[21] = 40716
					order[22] = 40717
					order[23] = 40718
					order[24] = 40719
					order[25] = 40720
					order[26] = 40721
					order[27] = 40722
					order[28] = 40723
					order[29] = 40724
					order[30] = 40725
					order[31] = 40726
					order[32] = 40727
					order[33] = 40728
					order[34] = 40729
					order[35] = 40730
					order[36] = 40731
					order[37] = 40732
					order[38] = 40733
					order[39] = 40734
					order[40] = 40735
					order[41] = 40736
					order[42] = 40737
					order[43] = 0
					fix.Group.__init__(self, 40708, 40709, order)

				class NoUnderlyingPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 43001
						order[1] = 0
						fix.Group.__init__(self, 43000, 43001, order)

				class NoUnderlyingPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42992
						order[1] = 0
						fix.Group.__init__(self, 42991, 42992, order)

			class NoUnderlyingDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41809
					order[1] = 0
					fix.Group.__init__(self, 41808, 41809, order)

			class NoUnderlyingDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41805
					order[1] = 41806
					order[2] = 41807
					order[3] = 0
					fix.Group.__init__(self, 41804, 41805, order)

			class NoUnderlyingDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41757
					order[1] = 41758
					order[2] = 41759
					order[3] = 41760
					order[4] = 41761
					order[5] = 41762
					order[6] = 41763
					order[7] = 41764
					order[8] = 41765
					order[9] = 41766
					order[10] = 41767
					order[11] = 41768
					order[12] = 41769
					order[13] = 41770
					order[14] = 0
					fix.Group.__init__(self, 41756, 41757, order)

				class NoUnderlyingDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41771
						order[1] = 41772
						order[2] = 41773
						order[3] = 0
						fix.Group.__init__(self, 41770, 41771, order)

					class NoUnderlyingDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41774
							order[1] = 41775
							order[2] = 41776
							order[3] = 0
							fix.Group.__init__(self, 41773, 41774, order)

		class NoUnderlyingProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 42150
				order[1] = 42151
				order[2] = 42152
				order[3] = 42190
				order[4] = 42153
				order[5] = 42154
				order[6] = 42155
				order[7] = 43002
				order[8] = 43003
				order[9] = 42156
				order[10] = 42157
				order[11] = 42158
				order[12] = 42104
				order[13] = 42105
				order[14] = 42106
				order[15] = 42107
				order[16] = 42108
				order[17] = 42109
				order[18] = 42110
				order[19] = 42111
				order[20] = 42115
				order[21] = 42116
				order[22] = 42117
				order[23] = 42118
				order[24] = 42119
				order[25] = 42120
				order[26] = 42121
				order[27] = 42122
				order[28] = 42123
				order[29] = 42124
				order[30] = 42125
				order[31] = 42126
				order[32] = 42127
				order[33] = 42128
				order[34] = 42129
				order[35] = 42130
				order[36] = 42131
				order[37] = 42132
				order[38] = 42133
				order[39] = 42134
				order[40] = 42135
				order[41] = 42136
				order[42] = 42137
				order[43] = 42138
				order[44] = 42139
				order[45] = 42140
				order[46] = 42141
				order[47] = 42142
				order[48] = 42143
				order[49] = 42144
				order[50] = 42145
				order[51] = 42146
				order[52] = 42147
				order[53] = 42148
				order[54] = 42159
				order[55] = 42160
				order[56] = 42161
				order[57] = 42162
				order[58] = 42163
				order[59] = 42164
				order[60] = 42165
				order[61] = 42092
				order[62] = 42093
				order[63] = 42094
				order[64] = 42095
				order[65] = 42096
				order[66] = 42097
				order[67] = 42098
				order[68] = 42166
				order[69] = 42167
				order[70] = 42168
				order[71] = 42169
				order[72] = 42102
				order[73] = 42103
				order[74] = 42170
				order[75] = 42171
				order[76] = 42172
				order[77] = 42173
				order[78] = 0
				fix.Group.__init__(self, 42149, 42150, order)

			class NoUnderlyingProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42191
					order[1] = 0
					fix.Group.__init__(self, 42190, 42191, order)

			class NoUnderlyingProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42183
					order[1] = 0
					fix.Group.__init__(self, 42182, 42183, order)

			class NoUnderlyingProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42185
					order[1] = 0
					fix.Group.__init__(self, 42184, 42185, order)

			class NoUnderlyingProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42113
					order[1] = 42114
					order[2] = 0
					fix.Group.__init__(self, 42112, 42113, order)

			class NoUnderlyingProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42187
					order[1] = 0
					fix.Group.__init__(self, 42186, 42187, order)

			class NoUnderlyingProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42189
					order[1] = 0
					fix.Group.__init__(self, 42188, 42189, order)

			class NoUnderlyingProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42181
					order[1] = 0
					fix.Group.__init__(self, 42180, 42181, order)

			class NoUnderlyingProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42100
					order[1] = 42101
					order[2] = 0
					fix.Group.__init__(self, 42099, 42100, order)

			class NoUnderlyingProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 42174
					order[1] = 42175
					order[2] = 42176
					order[3] = 40918
					order[4] = 42177
					order[5] = 0
					fix.Group.__init__(self, 42173, 42174, order)

				class NoUnderlyingProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42178
						order[1] = 42179
						order[2] = 0
						fix.Group.__init__(self, 42177, 42178, order)

		class NoUnderlyingAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 42037
				order[1] = 42038
				order[2] = 41340
				order[3] = 0
				fix.Group.__init__(self, 42036, 42037, order)

			class NoUnderlyingAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41341
					order[1] = 41701
					order[2] = 41709
					order[3] = 41710
					order[4] = 41711
					order[5] = 41712
					order[6] = 42017
					order[7] = 42025
					order[8] = 42026
					order[9] = 42027
					order[10] = 42028
					order[11] = 42029
					order[12] = 42030
					order[13] = 42031
					order[14] = 42032
					order[15] = 42033
					order[16] = 42034
					order[17] = 42035
					order[18] = 0
					fix.Group.__init__(self, 41340, 41341, order)

		class NoUnderlyingProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 42069
				order[1] = 42070
				order[2] = 42071
				order[3] = 42072
				order[4] = 42073
				order[5] = 42074
				order[6] = 42075
				order[7] = 42090
				order[8] = 42077
				order[9] = 42087
				order[10] = 42076
				order[11] = 0
				fix.Group.__init__(self, 42068, 42069, order)

			class NoUnderlyingProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42091
					order[1] = 0
					fix.Group.__init__(self, 42090, 42091, order)

			class NoUnderlyingProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 42078
					order[1] = 42079
					order[2] = 42080
					order[3] = 42081
					order[4] = 42082
					order[5] = 42083
					order[6] = 42084
					order[7] = 42085
					order[8] = 0
					fix.Group.__init__(self, 42077, 42078, order)

				class NoUnderlyingProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42086
						order[1] = 0
						fix.Group.__init__(self, 42085, 42086, order)

			class NoUnderlyingProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42088
					order[1] = 42089
					order[2] = 0
					fix.Group.__init__(self, 42087, 42088, order)

		class NoUnderlyingCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 42042
				order[1] = 42043
				order[2] = 42044
				order[3] = 42045
				order[4] = 42046
				order[5] = 42047
				order[6] = 42048
				order[7] = 42049
				order[8] = 42050
				order[9] = 42051
				order[10] = 42052
				order[11] = 42039
				order[12] = 42797
				order[13] = 42798
				order[14] = 42053
				order[15] = 42054
				order[16] = 42790
				order[17] = 42791
				order[18] = 42792
				order[19] = 42793
				order[20] = 42794
				order[21] = 42795
				order[22] = 42796
				order[23] = 42055
				order[24] = 42056
				order[25] = 42057
				order[26] = 42058
				order[27] = 42059
				order[28] = 0
				fix.Group.__init__(self, 42041, 42042, order)

			class NoUnderlyingCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42040
					order[1] = 0
					fix.Group.__init__(self, 42039, 42040, order)

			class NoUnderlyingCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42789
					order[1] = 0
					fix.Group.__init__(self, 42788, 42789, order)

		class NoUnderlyingPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 42065
				order[1] = 42061
				order[2] = 42062
				order[3] = 42063
				order[4] = 42064
				order[5] = 0
				fix.Group.__init__(self, 42060, 42065, order)

			class NoUnderlyingPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42066
					order[1] = 42067
					order[2] = 0
					fix.Group.__init__(self, 42065, 42066, order)

		class NoUnderlyingRateSpreadSteps(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 43006
				order[1] = 43007
				order[2] = 0
				fix.Group.__init__(self, 43005, 43006, order)

		class NoUnderlyingDividendPayments(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 42856
				order[1] = 42857
				order[2] = 42858
				order[3] = 42859
				order[4] = 0
				fix.Group.__init__(self, 42855, 42856, order)

		class NoUnderlyingExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42885
				order[1] = 42886
				order[2] = 0
				fix.Group.__init__(self, 42884, 42885, order)

	class NoStipulations(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 233
			order[1] = 234
			order[2] = 0
			fix.Group.__init__(self, 232, 233, order)

	class NoStrategyParameters(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 958
			order[1] = 959
			order[2] = 960
			order[3] = 0
			fix.Group.__init__(self, 957, 958, order)

	class NoCommissions(fix.Group):
		def __init__(self):
			order = fix.IntArray(17)
			order[0] = 2640
			order[1] = 2641
			order[2] = 2725
			order[3] = 2642
			order[4] = 2643
			order[5] = 2923
			order[6] = 2644
			order[7] = 2645
			order[8] = 2924
			order[9] = 2646
			order[10] = 2647
			order[11] = 2648
			order[12] = 2649
			order[13] = 2650
			order[14] = 2651
			order[15] = 2652
			order[16] = 0
			fix.Group.__init__(self, 2639, 2640, order)

	class NoOrderAttributes(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 2594
			order[1] = 2595
			order[2] = 0
			fix.Group.__init__(self, 2593, 2594, order)

	class NoRateSources(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1446
			order[1] = 1447
			order[2] = 1448
			order[3] = 2412
			order[4] = 2796
			order[5] = 0
			fix.Group.__init__(self, 1445, 1446, order)

	class NoTrdRegTimestamps(fix.Group):
		def __init__(self):
			order = fix.IntArray(13)
			order[0] = 769
			order[1] = 770
			order[2] = 771
			order[3] = 2839
			order[4] = 1033
			order[5] = 1034
			order[6] = 1035
			order[7] = 1727
			order[8] = 2831
			order[9] = 2832
			order[10] = 2833
			order[11] = 2834
			order[12] = 0
			fix.Group.__init__(self, 768, 769, order)

class OrderStatusRequest(Message):
	def __init__(self):
		Message.__init__(self)
		self.getHeader().setField( fix.MsgType("H") )

	class NoPartyIDs(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 448
			order[1] = 447
			order[2] = 452
			order[3] = 2376
			order[4] = 802
			order[5] = 0
			fix.Group.__init__(self, 453, 448, order)

		class NoPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 523
				order[1] = 803
				order[2] = 0
				fix.Group.__init__(self, 802, 523, order)

	class NoSecurityAltID(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 455
			order[1] = 456
			order[2] = 2957
			order[3] = 0
			fix.Group.__init__(self, 454, 455, order)

	class NoSecondaryAssetClasses(fix.Group):
		def __init__(self):
			order = fix.IntArray(5)
			order[0] = 1977
			order[1] = 1978
			order[2] = 1979
			order[3] = 2741
			order[4] = 0
			fix.Group.__init__(self, 1976, 1977, order)

	class NoAssetAttributes(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 2305
			order[1] = 2306
			order[2] = 2307
			order[3] = 0
			fix.Group.__init__(self, 2304, 2305, order)

	class NoEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(11)
			order[0] = 865
			order[1] = 866
			order[2] = 1145
			order[3] = 1827
			order[4] = 1826
			order[5] = 2340
			order[6] = 867
			order[7] = 868
			order[8] = 1578
			order[9] = 1579
			order[10] = 0
			fix.Group.__init__(self, 864, 865, order)

	class NoInstrumentParties(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1019
			order[1] = 1050
			order[2] = 1051
			order[3] = 2378
			order[4] = 1052
			order[5] = 0
			fix.Group.__init__(self, 1018, 1019, order)

		class NoInstrumentPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 1053
				order[1] = 1054
				order[2] = 0
				fix.Group.__init__(self, 1052, 1053, order)

	class NoComplexEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(53)
			order[0] = 1484
			order[1] = 2117
			order[2] = 2118
			order[3] = 2119
			order[4] = 1485
			order[5] = 2120
			order[6] = 2121
			order[7] = 2122
			order[8] = 2941
			order[9] = 1486
			order[10] = 2123
			order[11] = 1487
			order[12] = 1488
			order[13] = 1489
			order[14] = 1490
			order[15] = 1491
			order[16] = 2124
			order[17] = 2942
			order[18] = 2125
			order[19] = 2943
			order[20] = 2126
			order[21] = 2127
			order[22] = 2407
			order[23] = 2408
			order[24] = 2128
			order[25] = 2129
			order[26] = 2130
			order[27] = 2131
			order[28] = 2132
			order[29] = 41013
			order[30] = 41020
			order[31] = 41021
			order[32] = 41022
			order[33] = 41023
			order[34] = 41024
			order[35] = 41025
			order[36] = 41026
			order[37] = 41027
			order[38] = 41028
			order[39] = 41010
			order[40] = 2133
			order[41] = 2134
			order[42] = 2135
			order[43] = 2136
			order[44] = 2137
			order[45] = 41029
			order[46] = 40997
			order[47] = 2597
			order[48] = 2598
			order[49] = 2599
			order[50] = 2138
			order[51] = 2139
			order[52] = 0
			fix.Group.__init__(self, 1483, 1484, order)

		class NoComplexEventDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 1492
				order[1] = 1493
				order[2] = 1494
				order[3] = 0
				fix.Group.__init__(self, 1491, 1492, order)

			class NoComplexEventTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1495
					order[1] = 1496
					order[2] = 0
					fix.Group.__init__(self, 1494, 1495, order)

		class NoComplexEventRateSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 41014
				order[1] = 41015
				order[2] = 41016
				order[3] = 41017
				order[4] = 0
				fix.Group.__init__(self, 41013, 41014, order)

		class NoComplexEventDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41019
				order[1] = 0
				fix.Group.__init__(self, 41018, 41019, order)

		class NoComplexEventPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41011
				order[1] = 41012
				order[2] = 41031
				order[3] = 41007
				order[4] = 40994
				order[5] = 0
				fix.Group.__init__(self, 41010, 41011, order)

			class NoComplexEventSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41032
					order[1] = 41033
					order[2] = 41034
					order[3] = 41035
					order[4] = 41036
					order[5] = 0
					fix.Group.__init__(self, 41031, 41032, order)

			class NoComplexEventPeriodDateTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41008
					order[1] = 41009
					order[2] = 0
					fix.Group.__init__(self, 41007, 41008, order)

			class NoComplexEventAveragingObservations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40995
					order[1] = 40996
					order[2] = 0
					fix.Group.__init__(self, 40994, 40995, order)

		class NoComplexEventCreditEventSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41030
				order[1] = 0
				fix.Group.__init__(self, 41029, 41030, order)

		class NoComplexEventCreditEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40998
				order[1] = 40999
				order[2] = 41000
				order[3] = 41001
				order[4] = 41002
				order[5] = 41003
				order[6] = 41004
				order[7] = 41005
				order[8] = 0
				fix.Group.__init__(self, 40997, 40998, order)

			class NoComplexEventCreditEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41006
					order[1] = 0
					fix.Group.__init__(self, 41005, 41006, order)

	class NoBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40471
			order[1] = 0
			fix.Group.__init__(self, 40278, 40471, order)

	class NoPricingDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41231
			order[1] = 0
			fix.Group.__init__(self, 41230, 41231, order)

	class NoMarketDisruptionEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41093
			order[1] = 40991
			order[2] = 0
			fix.Group.__init__(self, 41092, 41093, order)

	class NoMarketDisruptionFallbacks(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41095
			order[1] = 40992
			order[2] = 0
			fix.Group.__init__(self, 41094, 41095, order)

	class NoMarketDisruptionFallbackReferencePrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(10)
			order[0] = 41097
			order[1] = 41098
			order[2] = 41099
			order[3] = 41100
			order[4] = 41101
			order[5] = 41102
			order[6] = 41103
			order[7] = 41104
			order[8] = 41105
			order[9] = 0
			fix.Group.__init__(self, 41096, 41097, order)

	class NoSettlMethodElectionDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 42776
			order[1] = 0
			fix.Group.__init__(self, 42775, 42776, order)

	class NoOptionExerciseBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41117
			order[1] = 0
			fix.Group.__init__(self, 41116, 41117, order)

	class NoOptionExerciseDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41138
			order[1] = 41139
			order[2] = 0
			fix.Group.__init__(self, 41137, 41138, order)

	class NoOptionExerciseExpirationDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41141
			order[1] = 0
			fix.Group.__init__(self, 41140, 41141, order)

	class NoOptionExerciseExpirationDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41153
			order[1] = 41154
			order[2] = 0
			fix.Group.__init__(self, 41152, 41153, order)

	class NoStreams(fix.Group):
		def __init__(self):
			order = fix.IntArray(135)
			order[0] = 40050
			order[1] = 41303
			order[2] = 40051
			order[3] = 42784
			order[4] = 42785
			order[5] = 40052
			order[6] = 40053
			order[7] = 41305
			order[8] = 40054
			order[9] = 40055
			order[10] = 42786
			order[11] = 42787
			order[12] = 41306
			order[13] = 41307
			order[14] = 41308
			order[15] = 41309
			order[16] = 41310
			order[17] = 41311
			order[18] = 41251
			order[19] = 41252
			order[20] = 41253
			order[21] = 41254
			order[22] = 41255
			order[23] = 41256
			order[24] = 41257
			order[25] = 42587
			order[26] = 41258
			order[27] = 41259
			order[28] = 41260
			order[29] = 41261
			order[30] = 41262
			order[31] = 41263
			order[32] = 41264
			order[33] = 41265
			order[34] = 41266
			order[35] = 41267
			order[36] = 41268
			order[37] = 41269
			order[38] = 41270
			order[39] = 41271
			order[40] = 41272
			order[41] = 41273
			order[42] = 41274
			order[43] = 41275
			order[44] = 41276
			order[45] = 40907
			order[46] = 40908
			order[47] = 40910
			order[48] = 40911
			order[49] = 40912
			order[50] = 40913
			order[51] = 40914
			order[52] = 40065
			order[53] = 40066
			order[54] = 40068
			order[55] = 40069
			order[56] = 40070
			order[57] = 40071
			order[58] = 40072
			order[59] = 41244
			order[60] = 41245
			order[61] = 40073
			order[62] = 40075
			order[63] = 40076
			order[64] = 40078
			order[65] = 40079
			order[66] = 40080
			order[67] = 40081
			order[68] = 40082
			order[69] = 40083
			order[70] = 40084
			order[71] = 41246
			order[72] = 41247
			order[73] = 41248
			order[74] = 40738
			order[75] = 40739
			order[76] = 40740
			order[77] = 42600
			order[78] = 40741
			order[79] = 40742
			order[80] = 43106
			order[81] = 40743
			order[82] = 40744
			order[83] = 40745
			order[84] = 40746
			order[85] = 40747
			order[86] = 42601
			order[87] = 42602
			order[88] = 42603
			order[89] = 42604
			order[90] = 40748
			order[91] = 40749
			order[92] = 40750
			order[93] = 41180
			order[94] = 41181
			order[95] = 41182
			order[96] = 41183
			order[97] = 41184
			order[98] = 41185
			order[99] = 41186
			order[100] = 42605
			order[101] = 40828
			order[102] = 40872
			order[103] = 41058
			order[104] = 41059
			order[105] = 41060
			order[106] = 41061
			order[107] = 41062
			order[108] = 42192
			order[109] = 42193
			order[110] = 41063
			order[111] = 41064
			order[112] = 41065
			order[113] = 41066
			order[114] = 41067
			order[115] = 41218
			order[116] = 41068
			order[117] = 41069
			order[118] = 41070
			order[119] = 41071
			order[120] = 41072
			order[121] = 41073
			order[122] = 41074
			order[123] = 41075
			order[124] = 41076
			order[125] = 41077
			order[126] = 41078
			order[127] = 41079
			order[128] = 41080
			order[129] = 43094
			order[130] = 41037
			order[131] = 40056
			order[132] = 40982
			order[133] = 40983
			order[134] = 0
			fix.Group.__init__(self, 40049, 40050, order)

		class NoStreamCommodityAltIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41278
				order[1] = 41279
				order[2] = 0
				fix.Group.__init__(self, 41277, 41278, order)

		class NoStreamAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41238
				order[1] = 41239
				order[2] = 41240
				order[3] = 0
				fix.Group.__init__(self, 41237, 41238, order)

		class NoStreamCommodityDataSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41281
				order[1] = 41282
				order[2] = 0
				fix.Group.__init__(self, 41280, 41281, order)

		class NoStreamCommoditySettlBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41250
				order[1] = 0
				fix.Group.__init__(self, 41249, 41250, order)

		class NoStreamCommoditySettlPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41290
				order[1] = 41291
				order[2] = 41292
				order[3] = 41293
				order[4] = 41294
				order[5] = 41295
				order[6] = 41296
				order[7] = 41297
				order[8] = 41298
				order[9] = 41299
				order[10] = 41300
				order[11] = 41283
				order[12] = 41301
				order[13] = 41302
				order[14] = 0
				fix.Group.__init__(self, 41289, 41290, order)

			class NoStreamCommoditySettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41284
					order[1] = 41285
					order[2] = 41286
					order[3] = 0
					fix.Group.__init__(self, 41283, 41284, order)

				class NoStreamCommoditySettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41287
						order[1] = 41288
						order[2] = 41588
						order[3] = 0
						fix.Group.__init__(self, 41286, 41287, order)

		class NoStreamEffectiveDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40909
				order[1] = 0
				fix.Group.__init__(self, 40960, 40909, order)

		class NoStreamTerminationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40067
				order[1] = 0
				fix.Group.__init__(self, 40961, 40067, order)

		class NoStreamCalculationPeriodBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40074
				order[1] = 0
				fix.Group.__init__(self, 40958, 40074, order)

		class NoStreamCalculationPeriodDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41242
				order[1] = 41243
				order[2] = 0
				fix.Group.__init__(self, 41241, 41242, order)

		class NoStreamFirstPeriodStartDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40077
				order[1] = 0
				fix.Group.__init__(self, 40959, 40077, order)

		class NoPaymentStreamPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40752
				order[1] = 0
				fix.Group.__init__(self, 40947, 40752, order)

		class NoPaymentStreamPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41221
				order[1] = 41222
				order[2] = 0
				fix.Group.__init__(self, 41220, 41221, order)

		class NoPaymentStreamResetDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40763
				order[1] = 0
				fix.Group.__init__(self, 40948, 40763, order)

		class NoPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40769
				order[1] = 0
				fix.Group.__init__(self, 40949, 40769, order)

		class NoPaymentStreamFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40776
				order[1] = 0
				fix.Group.__init__(self, 40950, 40776, order)

		class NoPaymentStreamFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42661
				order[1] = 42662
				order[2] = 0
				fix.Group.__init__(self, 42660, 42661, order)

		class NoPaymentStreamPricingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41193
				order[1] = 0
				fix.Group.__init__(self, 41192, 41193, order)

		class NoPaymentStreamPricingDays(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41228
				order[1] = 41229
				order[2] = 0
				fix.Group.__init__(self, 41227, 41228, order)

		class NoPaymentStreamPricingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41225
				order[1] = 41226
				order[2] = 0
				fix.Group.__init__(self, 41224, 41225, order)

		class NoPaymentStreamFormulas(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 43109
				order[1] = 42684
				order[2] = 42685
				order[3] = 0
				fix.Group.__init__(self, 42683, 43109, order)

		class NoDividendPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(21)
				order[0] = 42275
				order[1] = 42276
				order[2] = 42277
				order[3] = 42278
				order[4] = 42279
				order[5] = 42280
				order[6] = 42294
				order[7] = 42281
				order[8] = 42282
				order[9] = 42283
				order[10] = 42284
				order[11] = 42285
				order[12] = 42286
				order[13] = 42287
				order[14] = 42288
				order[15] = 42289
				order[16] = 42290
				order[17] = 42291
				order[18] = 42292
				order[19] = 42293
				order[20] = 0
				fix.Group.__init__(self, 42274, 42275, order)

			class NoDividendPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42295
					order[1] = 0
					fix.Group.__init__(self, 42294, 42295, order)

		class NoDividendFXTriggerDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42273
				order[1] = 0
				fix.Group.__init__(self, 42272, 42273, order)

		class NoDividendAccrualPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42237
				order[1] = 0
				fix.Group.__init__(self, 42236, 42237, order)

		class NoReturnRates(fix.Group):
			def __init__(self):
				order = fix.IntArray(30)
				order[0] = 42736
				order[1] = 42737
				order[2] = 42738
				order[3] = 42739
				order[4] = 42740
				order[5] = 42741
				order[6] = 42765
				order[7] = 42731
				order[8] = 42742
				order[9] = 42743
				order[10] = 42744
				order[11] = 42745
				order[12] = 42746
				order[13] = 42747
				order[14] = 42748
				order[15] = 42749
				order[16] = 42750
				order[17] = 42751
				order[18] = 42752
				order[19] = 42753
				order[20] = 42761
				order[21] = 42754
				order[22] = 42755
				order[23] = 42709
				order[24] = 42756
				order[25] = 42757
				order[26] = 42758
				order[27] = 42759
				order[28] = 42760
				order[29] = 0
				fix.Group.__init__(self, 42735, 42736, order)

			class NoReturnRatePrices(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 42766
					order[1] = 42767
					order[2] = 42768
					order[3] = 42769
					order[4] = 0
					fix.Group.__init__(self, 42765, 42766, order)

			class NoReturnRateFXConversions(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42732
					order[1] = 42733
					order[2] = 42734
					order[3] = 0
					fix.Group.__init__(self, 42731, 42732, order)

			class NoReturnRateInformationSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42762
					order[1] = 42763
					order[2] = 42764
					order[3] = 0
					fix.Group.__init__(self, 42761, 42762, order)

			class NoReturnRateDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(24)
					order[0] = 42710
					order[1] = 42772
					order[2] = 42711
					order[3] = 42712
					order[4] = 42713
					order[5] = 42714
					order[6] = 42715
					order[7] = 42716
					order[8] = 42717
					order[9] = 42718
					order[10] = 42719
					order[11] = 42720
					order[12] = 42721
					order[13] = 42722
					order[14] = 42723
					order[15] = 42724
					order[16] = 42725
					order[17] = 42726
					order[18] = 42727
					order[19] = 42728
					order[20] = 42729
					order[21] = 42730
					order[22] = 42770
					order[23] = 0
					fix.Group.__init__(self, 42709, 42710, order)

				class NoReturnRateValuationDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42773
						order[1] = 42774
						order[2] = 0
						fix.Group.__init__(self, 42772, 42773, order)

				class NoReturnRateValuationDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42771
						order[1] = 0
						fix.Group.__init__(self, 42770, 42771, order)

		class NoPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42621
				order[1] = 0
				fix.Group.__init__(self, 42620, 42621, order)

		class NoPaymentStreamCompoundingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42607
				order[1] = 42608
				order[2] = 0
				fix.Group.__init__(self, 42606, 42607, order)

		class NoPaymentStreamNonDeliverableFixingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40819
				order[1] = 0
				fix.Group.__init__(self, 40946, 40819, order)

		class NoNonDeliverableFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40826
				order[1] = 40827
				order[2] = 0
				fix.Group.__init__(self, 40825, 40826, order)

		class NoSettlRateFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40086
				order[1] = 40373
				order[2] = 40655
				order[3] = 40088
				order[4] = 40089
				order[5] = 0
				fix.Group.__init__(self, 40085, 40086, order)

		class NoPaymentSchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(58)
				order[0] = 40829
				order[1] = 41164
				order[2] = 41165
				order[3] = 40830
				order[4] = 40831
				order[5] = 40832
				order[6] = 40833
				order[7] = 40834
				order[8] = 40835
				order[9] = 40836
				order[10] = 40837
				order[11] = 40838
				order[12] = 40839
				order[13] = 41166
				order[14] = 41167
				order[15] = 41168
				order[16] = 41169
				order[17] = 40840
				order[18] = 40841
				order[19] = 40842
				order[20] = 40843
				order[21] = 41170
				order[22] = 41171
				order[23] = 41172
				order[24] = 41173
				order[25] = 40844
				order[26] = 40845
				order[27] = 40846
				order[28] = 40847
				order[29] = 40848
				order[30] = 40849
				order[31] = 40868
				order[32] = 40850
				order[33] = 40851
				order[34] = 40852
				order[35] = 40853
				order[36] = 40977
				order[37] = 40855
				order[38] = 40856
				order[39] = 40857
				order[40] = 41174
				order[41] = 41175
				order[42] = 40858
				order[43] = 41161
				order[44] = 41176
				order[45] = 41177
				order[46] = 41178
				order[47] = 41179
				order[48] = 40859
				order[49] = 40860
				order[50] = 40861
				order[51] = 40862
				order[52] = 40945
				order[53] = 40864
				order[54] = 40865
				order[55] = 40866
				order[56] = 40867
				order[57] = 0
				fix.Group.__init__(self, 40828, 40829, order)

			class NoPaymentScheduleRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 40869
					order[1] = 40870
					order[2] = 40871
					order[3] = 0
					fix.Group.__init__(self, 40868, 40869, order)

			class NoPaymentScheduleFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40854
					order[1] = 0
					fix.Group.__init__(self, 40977, 40854, order)

			class NoPaymentScheduleFixingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41162
					order[1] = 41163
					order[2] = 0
					fix.Group.__init__(self, 41161, 41162, order)

			class NoPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40863
					order[1] = 0
					fix.Group.__init__(self, 40945, 40863, order)

		class NoPaymentStubs(fix.Group):
			def __init__(self):
				order = fix.IntArray(44)
				order[0] = 40873
				order[1] = 40874
				order[2] = 42698
				order[3] = 42699
				order[4] = 42700
				order[5] = 42701
				order[6] = 42702
				order[7] = 42703
				order[8] = 42704
				order[9] = 42689
				order[10] = 42690
				order[11] = 42691
				order[12] = 42692
				order[13] = 42693
				order[14] = 42694
				order[15] = 42695
				order[16] = 40875
				order[17] = 40876
				order[18] = 40877
				order[19] = 40878
				order[20] = 40879
				order[21] = 40880
				order[22] = 40881
				order[23] = 40882
				order[24] = 40883
				order[25] = 40884
				order[26] = 40885
				order[27] = 40886
				order[28] = 40887
				order[29] = 40888
				order[30] = 40889
				order[31] = 40890
				order[32] = 40891
				order[33] = 40892
				order[34] = 40893
				order[35] = 40894
				order[36] = 40895
				order[37] = 40896
				order[38] = 40897
				order[39] = 40898
				order[40] = 40899
				order[41] = 40900
				order[42] = 40901
				order[43] = 0
				fix.Group.__init__(self, 40872, 40873, order)

			class NoPaymentStubStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42706
					order[1] = 0
					fix.Group.__init__(self, 42705, 42706, order)

			class NoPaymentStubEndDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42697
					order[1] = 0
					fix.Group.__init__(self, 42696, 42697, order)

		class NoDeliveryStreamCommoditySources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41086
				order[1] = 0
				fix.Group.__init__(self, 41085, 41086, order)

		class NoDeliveryStreamCycles(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41082
				order[1] = 41083
				order[2] = 41084
				order[3] = 0
				fix.Group.__init__(self, 41081, 41082, order)

		class NoDeliverySchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41038
				order[1] = 41039
				order[2] = 41040
				order[3] = 41041
				order[4] = 41042
				order[5] = 41043
				order[6] = 41044
				order[7] = 41045
				order[8] = 41046
				order[9] = 41047
				order[10] = 41048
				order[11] = 41049
				order[12] = 41050
				order[13] = 41051
				order[14] = 0
				fix.Group.__init__(self, 41037, 41038, order)

			class NoDeliveryScheduleSettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41052
					order[1] = 41053
					order[2] = 41054
					order[3] = 0
					fix.Group.__init__(self, 41051, 41052, order)

				class NoDeliveryScheduleSettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41055
						order[1] = 41056
						order[2] = 41057
						order[3] = 0
						fix.Group.__init__(self, 41054, 41055, order)

	class NoProvisions(fix.Group):
		def __init__(self):
			order = fix.IntArray(79)
			order[0] = 40091
			order[1] = 40092
			order[2] = 40093
			order[3] = 40957
			order[4] = 40095
			order[5] = 40096
			order[6] = 40097
			order[7] = 42707
			order[8] = 42708
			order[9] = 40098
			order[10] = 40099
			order[11] = 40100
			order[12] = 40114
			order[13] = 40115
			order[14] = 40116
			order[15] = 40118
			order[16] = 40119
			order[17] = 40120
			order[18] = 40121
			order[19] = 40122
			order[20] = 40123
			order[21] = 40125
			order[22] = 40126
			order[23] = 40127
			order[24] = 40128
			order[25] = 40129
			order[26] = 40130
			order[27] = 40131
			order[28] = 40132
			order[29] = 40133
			order[30] = 40134
			order[31] = 40135
			order[32] = 40136
			order[33] = 40137
			order[34] = 40138
			order[35] = 40139
			order[36] = 40140
			order[37] = 40141
			order[38] = 40145
			order[39] = 40146
			order[40] = 40148
			order[41] = 40149
			order[42] = 40150
			order[43] = 40151
			order[44] = 40152
			order[45] = 40153
			order[46] = 40154
			order[47] = 40155
			order[48] = 40156
			order[49] = 40158
			order[50] = 40159
			order[51] = 40160
			order[52] = 40161
			order[53] = 40162
			order[54] = 40101
			order[55] = 40102
			order[56] = 40103
			order[57] = 40104
			order[58] = 40105
			order[59] = 40106
			order[60] = 40107
			order[61] = 40163
			order[62] = 40165
			order[63] = 40166
			order[64] = 40167
			order[65] = 40168
			order[66] = 40169
			order[67] = 40170
			order[68] = 40108
			order[69] = 40109
			order[70] = 40110
			order[71] = 40111
			order[72] = 40112
			order[73] = 41406
			order[74] = 40113
			order[75] = 40986
			order[76] = 40987
			order[77] = 40174
			order[78] = 0
			fix.Group.__init__(self, 40090, 40091, order)

		class NoProvisionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40094
				order[1] = 0
				fix.Group.__init__(self, 40957, 40094, order)

		class NoProvisionCashSettlValueDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40117
				order[1] = 0
				fix.Group.__init__(self, 40953, 40117, order)

		class NoProvisionOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40124
				order[1] = 0
				fix.Group.__init__(self, 40954, 40124, order)

		class NoProvisionOptionExerciseFixedDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40143
				order[1] = 40144
				order[2] = 0
				fix.Group.__init__(self, 40142, 40143, order)

		class NoProvisionOptionExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40147
				order[1] = 0
				fix.Group.__init__(self, 40955, 40147, order)

		class NoProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40157
				order[1] = 0
				fix.Group.__init__(self, 40956, 40157, order)

		class NoProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40164
				order[1] = 0
				fix.Group.__init__(self, 40952, 40164, order)

		class NoProvisionCashSettlPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40172
				order[1] = 40173
				order[2] = 0
				fix.Group.__init__(self, 40171, 40172, order)

		class NoProvisionPartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40175
				order[1] = 40176
				order[2] = 40177
				order[3] = 2385
				order[4] = 40178
				order[5] = 0
				fix.Group.__init__(self, 40174, 40175, order)

			class NoProvisionPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40179
					order[1] = 40180
					order[2] = 0
					fix.Group.__init__(self, 40178, 40179, order)

	class NoAdditionalTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40020
			order[1] = 40021
			order[2] = 40000
			order[3] = 0
			fix.Group.__init__(self, 40019, 40020, order)

		class NoAdditionalTermBondRefs(fix.Group):
			def __init__(self):
				order = fix.IntArray(19)
				order[0] = 40001
				order[1] = 40002
				order[2] = 40003
				order[3] = 40004
				order[4] = 40005
				order[5] = 40006
				order[6] = 40007
				order[7] = 40008
				order[8] = 40009
				order[9] = 40010
				order[10] = 40011
				order[11] = 40012
				order[12] = 40013
				order[13] = 40014
				order[14] = 40015
				order[15] = 40016
				order[16] = 40017
				order[17] = 40018
				order[18] = 0
				fix.Group.__init__(self, 40000, 40001, order)

	class NoProtectionTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(12)
			order[0] = 40182
			order[1] = 40183
			order[2] = 40184
			order[3] = 40185
			order[4] = 40186
			order[5] = 40187
			order[6] = 40188
			order[7] = 40951
			order[8] = 40191
			order[9] = 40201
			order[10] = 40190
			order[11] = 0
			fix.Group.__init__(self, 40181, 40182, order)

		class NoProtectionTermEventNewsSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40189
				order[1] = 0
				fix.Group.__init__(self, 40951, 40189, order)

		class NoProtectionTermEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40192
				order[1] = 40193
				order[2] = 40194
				order[3] = 40195
				order[4] = 40196
				order[5] = 40197
				order[6] = 40198
				order[7] = 40199
				order[8] = 0
				fix.Group.__init__(self, 40191, 40192, order)

			class NoProtectionTermEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40200
					order[1] = 0
					fix.Group.__init__(self, 40199, 40200, order)

		class NoProtectionTermObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40202
				order[1] = 40203
				order[2] = 0
				fix.Group.__init__(self, 40201, 40202, order)

	class NoCashSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(29)
			order[0] = 40023
			order[1] = 40024
			order[2] = 40916
			order[3] = 40917
			order[4] = 40025
			order[5] = 40026
			order[6] = 40027
			order[7] = 40028
			order[8] = 40029
			order[9] = 40030
			order[10] = 40031
			order[11] = 40277
			order[12] = 42216
			order[13] = 42217
			order[14] = 40033
			order[15] = 40034
			order[16] = 42207
			order[17] = 42208
			order[18] = 42209
			order[19] = 42210
			order[20] = 42211
			order[21] = 42212
			order[22] = 42213
			order[23] = 40035
			order[24] = 40036
			order[25] = 40037
			order[26] = 40038
			order[27] = 40039
			order[28] = 0
			fix.Group.__init__(self, 40022, 40023, order)

		class NoCashSettlDealers(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40032
				order[1] = 0
				fix.Group.__init__(self, 40277, 40032, order)

		class NoCashSettlDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42215
				order[1] = 0
				fix.Group.__init__(self, 42214, 42215, order)

	class NoPhysicalSettlTerms(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 40209
			order[1] = 40205
			order[2] = 40206
			order[3] = 40207
			order[4] = 40208
			order[5] = 0
			fix.Group.__init__(self, 40204, 40209, order)

		class NoPhysicalSettlDeliverableObligations(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40210
				order[1] = 40211
				order[2] = 0
				fix.Group.__init__(self, 40209, 40210, order)

	class NoExtraordinaryEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 42297
			order[1] = 42298
			order[2] = 0
			fix.Group.__init__(self, 42296, 42297, order)

	class NoContractualDefinitions(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40041
			order[1] = 0
			fix.Group.__init__(self, 40040, 40041, order)

	class NoFinancingTermSupplements(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 40047
			order[1] = 40048
			order[2] = 0
			fix.Group.__init__(self, 40046, 40047, order)

	class NoContractualMatrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 40043
			order[1] = 40044
			order[2] = 40045
			order[3] = 0
			fix.Group.__init__(self, 40042, 40043, order)

	class NoUnderlyings(fix.Group):
		def __init__(self):
			order = fix.IntArray(188)
			order[0] = 311
			order[1] = 312
			order[2] = 309
			order[3] = 305
			order[4] = 2874
			order[5] = 462
			order[6] = 463
			order[7] = 2894
			order[8] = 310
			order[9] = 763
			order[10] = 313
			order[11] = 542
			order[12] = 1213
			order[13] = 1837
			order[14] = 241
			order[15] = 1453
			order[16] = 1454
			order[17] = 2614
			order[18] = 2615
			order[19] = 2921
			order[20] = 2616
			order[21] = 2617
			order[22] = 2619
			order[23] = 1455
			order[24] = 1456
			order[25] = 1459
			order[26] = 1460
			order[27] = 242
			order[28] = 243
			order[29] = 244
			order[30] = 245
			order[31] = 246
			order[32] = 256
			order[33] = 595
			order[34] = 592
			order[35] = 593
			order[36] = 594
			order[37] = 247
			order[38] = 316
			order[39] = 941
			order[40] = 2917
			order[41] = 317
			order[42] = 436
			order[43] = 1437
			order[44] = 2363
			order[45] = 1441
			order[46] = 998
			order[47] = 1423
			order[48] = 1718
			order[49] = 2918
			order[50] = 1424
			order[51] = 1425
			order[52] = 1719
			order[53] = 2919
			order[54] = 1000
			order[55] = 1419
			order[56] = 1526
			order[57] = 2920
			order[58] = 435
			order[59] = 308
			order[60] = 306
			order[61] = 362
			order[62] = 363
			order[63] = 2742
			order[64] = 2720
			order[65] = 2721
			order[66] = 2722
			order[67] = 2723
			order[68] = 2724
			order[69] = 307
			order[70] = 364
			order[71] = 365
			order[72] = 877
			order[73] = 878
			order[74] = 972
			order[75] = 318
			order[76] = 2916
			order[77] = 879
			order[78] = 975
			order[79] = 973
			order[80] = 974
			order[81] = 810
			order[82] = 882
			order[83] = 883
			order[84] = 884
			order[85] = 885
			order[86] = 886
			order[87] = 2885
			order[88] = 2886
			order[89] = 1044
			order[90] = 1045
			order[91] = 1046
			order[92] = 1038
			order[93] = 1039
			order[94] = 315
			order[95] = 2683
			order[96] = 2687
			order[97] = 1988
			order[98] = 1989
			order[99] = 1990
			order[100] = 1991
			order[101] = 1992
			order[102] = 1993
			order[103] = 2881
			order[104] = 1994
			order[105] = 1995
			order[106] = 1996
			order[107] = 1997
			order[108] = 2620
			order[109] = 2621
			order[110] = 1998
			order[111] = 1999
			order[112] = 2000
			order[113] = 2003
			order[114] = 2004
			order[115] = 2005
			order[116] = 2006
			order[117] = 2284
			order[118] = 2285
			order[119] = 2286
			order[120] = 2287
			order[121] = 2288
			order[122] = 2007
			order[123] = 2008
			order[124] = 2009
			order[125] = 2010
			order[126] = 2011
			order[127] = 2012
			order[128] = 2491
			order[129] = 2013
			order[130] = 2014
			order[131] = 2015
			order[132] = 2744
			order[133] = 2016
			order[134] = 2289
			order[135] = 2017
			order[136] = 2018
			order[137] = 2019
			order[138] = 2020
			order[139] = 2021
			order[140] = 2022
			order[141] = 2290
			order[142] = 2622
			order[143] = 2291
			order[144] = 2623
			order[145] = 2292
			order[146] = 2023
			order[147] = 2024
			order[148] = 2025
			order[149] = 2026
			order[150] = 2027
			order[151] = 2028
			order[152] = 2029
			order[153] = 2757
			order[154] = 2030
			order[155] = 2031
			order[156] = 2293
			order[157] = 2294
			order[158] = 2032
			order[159] = 2033
			order[160] = 2034
			order[161] = 2035
			order[162] = 2036
			order[163] = 2037
			order[164] = 2038
			order[165] = 2039
			order[166] = 2040
			order[167] = 2041
			order[168] = 2042
			order[169] = 2043
			order[170] = 2044
			order[171] = 41314
			order[172] = 41315
			order[173] = 2295
			order[174] = 2296
			order[175] = 2297
			order[176] = 2756
			order[177] = 2298
			order[178] = 2299
			order[179] = 2624
			order[180] = 2625
			order[181] = 2626
			order[182] = 2627
			order[183] = 2628
			order[184] = 2629
			order[185] = 2630
			order[186] = 2631
			order[187] = 0
			fix.Group.__init__(self, 711, 311, order)

		class NoUnderlyingSecurityAltID(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 458
				order[1] = 459
				order[2] = 2959
				order[3] = 0
				fix.Group.__init__(self, 457, 458, order)

		class NoUnderlyingStips(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 888
				order[1] = 889
				order[2] = 0
				fix.Group.__init__(self, 887, 888, order)

		class NoUndlyInstrumentParties(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 1059
				order[1] = 1060
				order[2] = 1061
				order[3] = 2391
				order[4] = 1062
				order[5] = 0
				fix.Group.__init__(self, 1058, 1059, order)

			class NoUndlyInstrumentPartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1063
					order[1] = 1064
					order[2] = 0
					fix.Group.__init__(self, 1062, 1063, order)

		class NoUnderlyingEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(11)
				order[0] = 1982
				order[1] = 1983
				order[2] = 1984
				order[3] = 1985
				order[4] = 1986
				order[5] = 2342
				order[6] = 1987
				order[7] = 2071
				order[8] = 2072
				order[9] = 2073
				order[10] = 0
				fix.Group.__init__(self, 1981, 1982, order)

		class NoUnderlyingSecondaryAssetClasses(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 2081
				order[1] = 2082
				order[2] = 2083
				order[3] = 2745
				order[4] = 0
				fix.Group.__init__(self, 2080, 2081, order)

		class NoUnderlyingAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 2313
				order[1] = 2314
				order[2] = 2315
				order[3] = 0
				fix.Group.__init__(self, 2312, 2313, order)

		class NoUnderlyingComplexEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(53)
				order[0] = 2046
				order[1] = 2261
				order[2] = 2262
				order[3] = 2263
				order[4] = 2047
				order[5] = 2264
				order[6] = 2265
				order[7] = 2266
				order[8] = 2947
				order[9] = 2048
				order[10] = 2267
				order[11] = 2049
				order[12] = 2050
				order[13] = 2051
				order[14] = 2052
				order[15] = 2053
				order[16] = 2268
				order[17] = 2948
				order[18] = 2269
				order[19] = 2949
				order[20] = 2270
				order[21] = 2271
				order[22] = 2419
				order[23] = 2420
				order[24] = 2272
				order[25] = 2273
				order[26] = 2274
				order[27] = 2275
				order[28] = 2276
				order[29] = 41732
				order[30] = 41739
				order[31] = 41740
				order[32] = 41741
				order[33] = 41742
				order[34] = 41743
				order[35] = 41744
				order[36] = 41745
				order[37] = 41746
				order[38] = 41747
				order[39] = 41729
				order[40] = 2277
				order[41] = 2278
				order[42] = 2279
				order[43] = 2280
				order[44] = 2281
				order[45] = 41748
				order[46] = 41716
				order[47] = 2611
				order[48] = 2612
				order[49] = 2613
				order[50] = 2282
				order[51] = 2283
				order[52] = 0
				fix.Group.__init__(self, 2045, 2046, order)

			class NoUnderlyingComplexEventDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 2054
					order[1] = 2055
					order[2] = 2056
					order[3] = 0
					fix.Group.__init__(self, 2053, 2054, order)

				class NoUnderlyingComplexEventTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 2057
						order[1] = 2058
						order[2] = 0
						fix.Group.__init__(self, 2056, 2057, order)

			class NoUnderlyingComplexEventRateSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 41733
					order[1] = 41734
					order[2] = 41735
					order[3] = 41736
					order[4] = 0
					fix.Group.__init__(self, 41732, 41733, order)

			class NoUnderlyingComplexEventDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41738
					order[1] = 0
					fix.Group.__init__(self, 41737, 41738, order)

			class NoUnderlyingComplexEventPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41730
					order[1] = 41731
					order[2] = 41750
					order[3] = 41726
					order[4] = 41713
					order[5] = 0
					fix.Group.__init__(self, 41729, 41730, order)

				class NoUnderlyingComplexEventSchedules(fix.Group):
					def __init__(self):
						order = fix.IntArray(6)
						order[0] = 41751
						order[1] = 41752
						order[2] = 41753
						order[3] = 41754
						order[4] = 41755
						order[5] = 0
						fix.Group.__init__(self, 41750, 41751, order)

				class NoUnderlyingComplexEventPeriodDateTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41727
						order[1] = 41728
						order[2] = 0
						fix.Group.__init__(self, 41726, 41727, order)

				class NoUnderlyingComplexEventAveragingObservations(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41714
						order[1] = 41715
						order[2] = 0
						fix.Group.__init__(self, 41713, 41714, order)

			class NoUnderlyingComplexEventCreditEventSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41749
					order[1] = 0
					fix.Group.__init__(self, 41748, 41749, order)

			class NoUnderlyingComplexEventCreditEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 41717
					order[1] = 41718
					order[2] = 41719
					order[3] = 41720
					order[4] = 41721
					order[5] = 41722
					order[6] = 41723
					order[7] = 41724
					order[8] = 0
					fix.Group.__init__(self, 41716, 41717, order)

				class NoUnderlyingComplexEventCreditEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 41725
						order[1] = 0
						fix.Group.__init__(self, 41724, 41725, order)

		class NoUnderlyingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40963
				order[1] = 0
				fix.Group.__init__(self, 40962, 40963, order)

		class NoUnderlyingPricingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41948
				order[1] = 0
				fix.Group.__init__(self, 41947, 41948, order)

		class NoUnderlyingMarketDisruptionEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41865
				order[1] = 41338
				order[2] = 0
				fix.Group.__init__(self, 41864, 41865, order)

		class NoUnderlyingMarketDisruptionFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41867
				order[1] = 41339
				order[2] = 0
				fix.Group.__init__(self, 41866, 41867, order)

		class NoUnderlyingMarketDisruptionFallbackReferencePrices(fix.Group):
			def __init__(self):
				order = fix.IntArray(10)
				order[0] = 41869
				order[1] = 41870
				order[2] = 41871
				order[3] = 41872
				order[4] = 41873
				order[5] = 41874
				order[6] = 41875
				order[7] = 41876
				order[8] = 41877
				order[9] = 0
				fix.Group.__init__(self, 41868, 41869, order)

		class NoUnderlyingSettlMethodElectionDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 43075
				order[1] = 0
				fix.Group.__init__(self, 43074, 43075, order)

		class NoUnderlyingOptionExerciseBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41821
				order[1] = 0
				fix.Group.__init__(self, 41820, 41821, order)

		class NoUnderlyingOptionExerciseDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41842
				order[1] = 41843
				order[2] = 0
				fix.Group.__init__(self, 41841, 41842, order)

		class NoUnderlyingOptionExerciseExpirationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41845
				order[1] = 0
				fix.Group.__init__(self, 41844, 41845, order)

		class NoUnderlyingOptionExerciseExpirationDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41857
				order[1] = 41858
				order[2] = 0
				fix.Group.__init__(self, 41856, 41857, order)

		class NoUnderlyingStreams(fix.Group):
			def __init__(self):
				order = fix.IntArray(135)
				order[0] = 40541
				order[1] = 42016
				order[2] = 40542
				order[3] = 43083
				order[4] = 43084
				order[5] = 40543
				order[6] = 40544
				order[7] = 42018
				order[8] = 40545
				order[9] = 40546
				order[10] = 43085
				order[11] = 43086
				order[12] = 42019
				order[13] = 42020
				order[14] = 42021
				order[15] = 42022
				order[16] = 42023
				order[17] = 42024
				order[18] = 41964
				order[19] = 41965
				order[20] = 41966
				order[21] = 41967
				order[22] = 41968
				order[23] = 41969
				order[24] = 41970
				order[25] = 42589
				order[26] = 41971
				order[27] = 41972
				order[28] = 41973
				order[29] = 41974
				order[30] = 41975
				order[31] = 41976
				order[32] = 41977
				order[33] = 41978
				order[34] = 41979
				order[35] = 41980
				order[36] = 41981
				order[37] = 41982
				order[38] = 41983
				order[39] = 41984
				order[40] = 41985
				order[41] = 41986
				order[42] = 41987
				order[43] = 41988
				order[44] = 41989
				order[45] = 40057
				order[46] = 40058
				order[47] = 40060
				order[48] = 40061
				order[49] = 40062
				order[50] = 40063
				order[51] = 40064
				order[52] = 40548
				order[53] = 40549
				order[54] = 40551
				order[55] = 40552
				order[56] = 40553
				order[57] = 40554
				order[58] = 40555
				order[59] = 41957
				order[60] = 41958
				order[61] = 40556
				order[62] = 40558
				order[63] = 40559
				order[64] = 40561
				order[65] = 40562
				order[66] = 40563
				order[67] = 40564
				order[68] = 40565
				order[69] = 40566
				order[70] = 40567
				order[71] = 41959
				order[72] = 41960
				order[73] = 41961
				order[74] = 40568
				order[75] = 40569
				order[76] = 40570
				order[77] = 42895
				order[78] = 40571
				order[79] = 40572
				order[80] = 43107
				order[81] = 40573
				order[82] = 40574
				order[83] = 40575
				order[84] = 40576
				order[85] = 40577
				order[86] = 42896
				order[87] = 42897
				order[88] = 42898
				order[89] = 42899
				order[90] = 40578
				order[91] = 40579
				order[92] = 40580
				order[93] = 41897
				order[94] = 41898
				order[95] = 41899
				order[96] = 41900
				order[97] = 41901
				order[98] = 41902
				order[99] = 41903
				order[100] = 42900
				order[101] = 40664
				order[102] = 40708
				order[103] = 41777
				order[104] = 41778
				order[105] = 41779
				order[106] = 41780
				order[107] = 41781
				order[108] = 42196
				order[109] = 42197
				order[110] = 41782
				order[111] = 41783
				order[112] = 41784
				order[113] = 41785
				order[114] = 41786
				order[115] = 41587
				order[116] = 41787
				order[117] = 41788
				order[118] = 41789
				order[119] = 41790
				order[120] = 41791
				order[121] = 41792
				order[122] = 41793
				order[123] = 41794
				order[124] = 41795
				order[125] = 41796
				order[126] = 41797
				order[127] = 41798
				order[128] = 41799
				order[129] = 43096
				order[130] = 41756
				order[131] = 40547
				order[132] = 40988
				order[133] = 40989
				order[134] = 0
				fix.Group.__init__(self, 40540, 40541, order)

			class NoUnderlyingStreamCommodityAltIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41991
					order[1] = 41992
					order[2] = 0
					fix.Group.__init__(self, 41990, 41991, order)

			class NoUnderlyingStreamAssetAttributes(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41801
					order[1] = 41802
					order[2] = 41803
					order[3] = 0
					fix.Group.__init__(self, 41800, 41801, order)

			class NoUnderlyingStreamCommodityDataSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41994
					order[1] = 41995
					order[2] = 0
					fix.Group.__init__(self, 41993, 41994, order)

			class NoUnderlyingStreamCommoditySettlBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41963
					order[1] = 0
					fix.Group.__init__(self, 41962, 41963, order)

			class NoUnderlyingStreamCommoditySettlPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 42003
					order[1] = 42004
					order[2] = 42005
					order[3] = 42006
					order[4] = 42007
					order[5] = 42008
					order[6] = 42009
					order[7] = 42010
					order[8] = 42011
					order[9] = 42012
					order[10] = 42013
					order[11] = 41996
					order[12] = 42014
					order[13] = 42015
					order[14] = 0
					fix.Group.__init__(self, 42002, 42003, order)

				class NoUnderlyingStreamCommoditySettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41997
						order[1] = 41998
						order[2] = 41999
						order[3] = 0
						fix.Group.__init__(self, 41996, 41997, order)

					class NoUnderlyingStreamCommoditySettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 42000
							order[1] = 42001
							order[2] = 41936
							order[3] = 0
							fix.Group.__init__(self, 41999, 42000, order)

			class NoUnderlyingStreamEffectiveDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40059
					order[1] = 0
					fix.Group.__init__(self, 40975, 40059, order)

			class NoUnderlyingStreamTerminationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40550
					order[1] = 0
					fix.Group.__init__(self, 40976, 40550, order)

			class NoUnderlyingStreamCalculationPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40557
					order[1] = 0
					fix.Group.__init__(self, 40973, 40557, order)

			class NoUnderlyingStreamCalculationPeriodDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41955
					order[1] = 41956
					order[2] = 0
					fix.Group.__init__(self, 41954, 41955, order)

			class NoUnderlyingStreamFirstPeriodStartDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40560
					order[1] = 0
					fix.Group.__init__(self, 40974, 40560, order)

			class NoUnderlyingPaymentStreamPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40582
					order[1] = 0
					fix.Group.__init__(self, 40969, 40582, order)

			class NoUnderlyingPaymentStreamPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41938
					order[1] = 41939
					order[2] = 0
					fix.Group.__init__(self, 41937, 41938, order)

			class NoUnderlyingPaymentStreamResetDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40594
					order[1] = 0
					fix.Group.__init__(self, 40970, 40594, order)

			class NoUnderlyingPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40600
					order[1] = 0
					fix.Group.__init__(self, 40971, 40600, order)

			class NoUnderlyingPaymentStreamFixingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40607
					order[1] = 0
					fix.Group.__init__(self, 40972, 40607, order)

			class NoUnderlyingPaymentStreamFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42956
					order[1] = 42957
					order[2] = 0
					fix.Group.__init__(self, 42955, 42956, order)

			class NoUnderlyingPaymentStreamPricingBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41910
					order[1] = 0
					fix.Group.__init__(self, 41909, 41910, order)

			class NoUnderlyingPaymentStreamPricingDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41945
					order[1] = 41946
					order[2] = 0
					fix.Group.__init__(self, 41944, 41945, order)

			class NoUnderlyingPaymentStreamPricingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41942
					order[1] = 41943
					order[2] = 0
					fix.Group.__init__(self, 41941, 41942, order)

			class NoUnderlyingPaymentStreamFormulas(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 43111
					order[1] = 42982
					order[2] = 42983
					order[3] = 0
					fix.Group.__init__(self, 42981, 43111, order)

			class NoUnderlyingDividendPeriods(fix.Group):
				def __init__(self):
					order = fix.IntArray(21)
					order[0] = 42863
					order[1] = 42864
					order[2] = 42865
					order[3] = 42866
					order[4] = 42867
					order[5] = 42868
					order[6] = 42882
					order[7] = 42869
					order[8] = 42870
					order[9] = 42871
					order[10] = 42872
					order[11] = 42873
					order[12] = 42874
					order[13] = 42875
					order[14] = 42876
					order[15] = 42877
					order[16] = 42878
					order[17] = 42879
					order[18] = 42880
					order[19] = 42881
					order[20] = 0
					fix.Group.__init__(self, 42862, 42863, order)

				class NoUnderlyingDividendPeriodBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42883
						order[1] = 0
						fix.Group.__init__(self, 42882, 42883, order)

			class NoUnderlyingDividendFXTriggerDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42854
					order[1] = 0
					fix.Group.__init__(self, 42853, 42854, order)

			class NoUnderlyingDividendAccrualPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42800
					order[1] = 0
					fix.Group.__init__(self, 42799, 42800, order)

			class NoUnderlyingReturnRates(fix.Group):
				def __init__(self):
					order = fix.IntArray(30)
					order[0] = 43035
					order[1] = 43036
					order[2] = 43037
					order[3] = 43038
					order[4] = 43039
					order[5] = 43040
					order[6] = 43064
					order[7] = 43030
					order[8] = 43041
					order[9] = 43042
					order[10] = 43043
					order[11] = 43044
					order[12] = 43045
					order[13] = 43046
					order[14] = 43047
					order[15] = 43048
					order[16] = 43049
					order[17] = 43050
					order[18] = 43051
					order[19] = 43052
					order[20] = 43060
					order[21] = 43053
					order[22] = 43054
					order[23] = 43008
					order[24] = 43055
					order[25] = 43056
					order[26] = 43057
					order[27] = 43058
					order[28] = 43059
					order[29] = 0
					fix.Group.__init__(self, 43034, 43035, order)

				class NoUnderlyingReturnRatePrices(fix.Group):
					def __init__(self):
						order = fix.IntArray(5)
						order[0] = 43065
						order[1] = 43066
						order[2] = 43067
						order[3] = 43068
						order[4] = 0
						fix.Group.__init__(self, 43064, 43065, order)

				class NoUnderlyingReturnRateFXConversions(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43031
						order[1] = 43032
						order[2] = 43033
						order[3] = 0
						fix.Group.__init__(self, 43030, 43031, order)

				class NoUnderlyingReturnRateInformationSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 43061
						order[1] = 43062
						order[2] = 43063
						order[3] = 0
						fix.Group.__init__(self, 43060, 43061, order)

				class NoUnderlyingReturnRateDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(24)
						order[0] = 43009
						order[1] = 43071
						order[2] = 43010
						order[3] = 43011
						order[4] = 43012
						order[5] = 43013
						order[6] = 43014
						order[7] = 43015
						order[8] = 43016
						order[9] = 43017
						order[10] = 43018
						order[11] = 43019
						order[12] = 43020
						order[13] = 43021
						order[14] = 43022
						order[15] = 43023
						order[16] = 43024
						order[17] = 43025
						order[18] = 43026
						order[19] = 43027
						order[20] = 43028
						order[21] = 43029
						order[22] = 43069
						order[23] = 0
						fix.Group.__init__(self, 43008, 43009, order)

					class NoUnderlyingReturnRateValuationDates(fix.Group):
						def __init__(self):
							order = fix.IntArray(3)
							order[0] = 43072
							order[1] = 43073
							order[2] = 0
							fix.Group.__init__(self, 43071, 43072, order)

					class NoUnderlyingReturnRateValuationDateBusinessCenters(fix.Group):
						def __init__(self):
							order = fix.IntArray(2)
							order[0] = 43070
							order[1] = 0
							fix.Group.__init__(self, 43069, 43070, order)

			class NoUnderlyingPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42916
					order[1] = 0
					fix.Group.__init__(self, 42915, 42916, order)

			class NoUnderlyingPaymentStreamCompoundingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42902
					order[1] = 42903
					order[2] = 0
					fix.Group.__init__(self, 42901, 42902, order)

			class NoUnderlyingPaymentStreamNonDeliverableFixingDatesBizCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 40650
					order[1] = 0
					fix.Group.__init__(self, 40968, 40650, order)

			class NoUnderlyingNonDeliverableFixingDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40657
					order[1] = 40658
					order[2] = 0
					fix.Group.__init__(self, 40656, 40657, order)

			class NoUnderlyingSettlRateFallbacks(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 40660
					order[1] = 40904
					order[2] = 40915
					order[3] = 40662
					order[4] = 40663
					order[5] = 0
					fix.Group.__init__(self, 40659, 40660, order)

			class NoUnderlyingPaymentSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(58)
					order[0] = 40665
					order[1] = 41881
					order[2] = 41882
					order[3] = 40666
					order[4] = 40667
					order[5] = 40668
					order[6] = 40669
					order[7] = 40670
					order[8] = 40671
					order[9] = 40672
					order[10] = 40673
					order[11] = 40674
					order[12] = 40675
					order[13] = 41883
					order[14] = 41884
					order[15] = 41885
					order[16] = 41886
					order[17] = 40676
					order[18] = 40677
					order[19] = 40678
					order[20] = 40679
					order[21] = 41887
					order[22] = 41888
					order[23] = 41889
					order[24] = 41890
					order[25] = 40680
					order[26] = 40681
					order[27] = 40682
					order[28] = 40683
					order[29] = 40684
					order[30] = 40685
					order[31] = 40704
					order[32] = 40686
					order[33] = 40687
					order[34] = 40688
					order[35] = 40689
					order[36] = 40966
					order[37] = 40691
					order[38] = 40692
					order[39] = 40693
					order[40] = 41891
					order[41] = 41892
					order[42] = 40694
					order[43] = 41878
					order[44] = 41893
					order[45] = 41894
					order[46] = 41895
					order[47] = 41896
					order[48] = 40695
					order[49] = 40696
					order[50] = 40697
					order[51] = 40698
					order[52] = 40967
					order[53] = 40700
					order[54] = 40701
					order[55] = 40702
					order[56] = 40703
					order[57] = 0
					fix.Group.__init__(self, 40664, 40665, order)

				class NoUnderlyingPaymentScheduleRateSources(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 40705
						order[1] = 40706
						order[2] = 40707
						order[3] = 0
						fix.Group.__init__(self, 40704, 40705, order)

				class NoUnderlyingPaymentScheduleFixingDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40690
						order[1] = 0
						fix.Group.__init__(self, 40966, 40690, order)

				class NoUnderlyingPaymentScheduleFixingDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 41879
						order[1] = 41880
						order[2] = 0
						fix.Group.__init__(self, 41878, 41879, order)

				class NoUnderlyingPaymentScheduleInterimExchangeDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 40699
						order[1] = 0
						fix.Group.__init__(self, 40967, 40699, order)

			class NoUnderlyingPaymentStubs(fix.Group):
				def __init__(self):
					order = fix.IntArray(44)
					order[0] = 40709
					order[1] = 40710
					order[2] = 42993
					order[3] = 42994
					order[4] = 42995
					order[5] = 42996
					order[6] = 42997
					order[7] = 42998
					order[8] = 42999
					order[9] = 42984
					order[10] = 42985
					order[11] = 42986
					order[12] = 42987
					order[13] = 42988
					order[14] = 42989
					order[15] = 42990
					order[16] = 40711
					order[17] = 40712
					order[18] = 40713
					order[19] = 40714
					order[20] = 40715
					order[21] = 40716
					order[22] = 40717
					order[23] = 40718
					order[24] = 40719
					order[25] = 40720
					order[26] = 40721
					order[27] = 40722
					order[28] = 40723
					order[29] = 40724
					order[30] = 40725
					order[31] = 40726
					order[32] = 40727
					order[33] = 40728
					order[34] = 40729
					order[35] = 40730
					order[36] = 40731
					order[37] = 40732
					order[38] = 40733
					order[39] = 40734
					order[40] = 40735
					order[41] = 40736
					order[42] = 40737
					order[43] = 0
					fix.Group.__init__(self, 40708, 40709, order)

				class NoUnderlyingPaymentStubStartDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 43001
						order[1] = 0
						fix.Group.__init__(self, 43000, 43001, order)

				class NoUnderlyingPaymentStubEndDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42992
						order[1] = 0
						fix.Group.__init__(self, 42991, 42992, order)

			class NoUnderlyingDeliveryStreamCommoditySources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41809
					order[1] = 0
					fix.Group.__init__(self, 41808, 41809, order)

			class NoUnderlyingDeliveryStreamCycles(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41805
					order[1] = 41806
					order[2] = 41807
					order[3] = 0
					fix.Group.__init__(self, 41804, 41805, order)

			class NoUnderlyingDeliverySchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(15)
					order[0] = 41757
					order[1] = 41758
					order[2] = 41759
					order[3] = 41760
					order[4] = 41761
					order[5] = 41762
					order[6] = 41763
					order[7] = 41764
					order[8] = 41765
					order[9] = 41766
					order[10] = 41767
					order[11] = 41768
					order[12] = 41769
					order[13] = 41770
					order[14] = 0
					fix.Group.__init__(self, 41756, 41757, order)

				class NoUnderlyingDeliveryScheduleSettlDays(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41771
						order[1] = 41772
						order[2] = 41773
						order[3] = 0
						fix.Group.__init__(self, 41770, 41771, order)

					class NoUnderlyingDeliveryScheduleSettlTimes(fix.Group):
						def __init__(self):
							order = fix.IntArray(4)
							order[0] = 41774
							order[1] = 41775
							order[2] = 41776
							order[3] = 0
							fix.Group.__init__(self, 41773, 41774, order)

		class NoUnderlyingProvisions(fix.Group):
			def __init__(self):
				order = fix.IntArray(79)
				order[0] = 42150
				order[1] = 42151
				order[2] = 42152
				order[3] = 42190
				order[4] = 42153
				order[5] = 42154
				order[6] = 42155
				order[7] = 43002
				order[8] = 43003
				order[9] = 42156
				order[10] = 42157
				order[11] = 42158
				order[12] = 42104
				order[13] = 42105
				order[14] = 42106
				order[15] = 42107
				order[16] = 42108
				order[17] = 42109
				order[18] = 42110
				order[19] = 42111
				order[20] = 42115
				order[21] = 42116
				order[22] = 42117
				order[23] = 42118
				order[24] = 42119
				order[25] = 42120
				order[26] = 42121
				order[27] = 42122
				order[28] = 42123
				order[29] = 42124
				order[30] = 42125
				order[31] = 42126
				order[32] = 42127
				order[33] = 42128
				order[34] = 42129
				order[35] = 42130
				order[36] = 42131
				order[37] = 42132
				order[38] = 42133
				order[39] = 42134
				order[40] = 42135
				order[41] = 42136
				order[42] = 42137
				order[43] = 42138
				order[44] = 42139
				order[45] = 42140
				order[46] = 42141
				order[47] = 42142
				order[48] = 42143
				order[49] = 42144
				order[50] = 42145
				order[51] = 42146
				order[52] = 42147
				order[53] = 42148
				order[54] = 42159
				order[55] = 42160
				order[56] = 42161
				order[57] = 42162
				order[58] = 42163
				order[59] = 42164
				order[60] = 42165
				order[61] = 42092
				order[62] = 42093
				order[63] = 42094
				order[64] = 42095
				order[65] = 42096
				order[66] = 42097
				order[67] = 42098
				order[68] = 42166
				order[69] = 42167
				order[70] = 42168
				order[71] = 42169
				order[72] = 42102
				order[73] = 42103
				order[74] = 42170
				order[75] = 42171
				order[76] = 42172
				order[77] = 42173
				order[78] = 0
				fix.Group.__init__(self, 42149, 42150, order)

			class NoUnderlyingProvisionDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42191
					order[1] = 0
					fix.Group.__init__(self, 42190, 42191, order)

			class NoUnderlyingProvisionCashSettlValueDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42183
					order[1] = 0
					fix.Group.__init__(self, 42182, 42183, order)

			class NoUnderlyingProvisionOptionExerciseBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42185
					order[1] = 0
					fix.Group.__init__(self, 42184, 42185, order)

			class NoUnderlyingProvisionOptionExerciseFixedDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42113
					order[1] = 42114
					order[2] = 0
					fix.Group.__init__(self, 42112, 42113, order)

			class NoUnderlyingProvisionOptionExpirationDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42187
					order[1] = 0
					fix.Group.__init__(self, 42186, 42187, order)

			class NoUnderlyingProvisionOptionRelevantUnderlyingDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42189
					order[1] = 0
					fix.Group.__init__(self, 42188, 42189, order)

			class NoUnderlyingProvisionCashSettlPaymentDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42181
					order[1] = 0
					fix.Group.__init__(self, 42180, 42181, order)

			class NoUnderlyingProvisionCashSettlPaymentDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42100
					order[1] = 42101
					order[2] = 0
					fix.Group.__init__(self, 42099, 42100, order)

			class NoUnderlyingProvisionPartyIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 42174
					order[1] = 42175
					order[2] = 42176
					order[3] = 40918
					order[4] = 42177
					order[5] = 0
					fix.Group.__init__(self, 42173, 42174, order)

				class NoUnderlyingProvisionPartySubIDs(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42178
						order[1] = 42179
						order[2] = 0
						fix.Group.__init__(self, 42177, 42178, order)

		class NoUnderlyingAdditionalTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 42037
				order[1] = 42038
				order[2] = 41340
				order[3] = 0
				fix.Group.__init__(self, 42036, 42037, order)

			class NoUnderlyingAdditionalTermBondRefs(fix.Group):
				def __init__(self):
					order = fix.IntArray(19)
					order[0] = 41341
					order[1] = 41701
					order[2] = 41709
					order[3] = 41710
					order[4] = 41711
					order[5] = 41712
					order[6] = 42017
					order[7] = 42025
					order[8] = 42026
					order[9] = 42027
					order[10] = 42028
					order[11] = 42029
					order[12] = 42030
					order[13] = 42031
					order[14] = 42032
					order[15] = 42033
					order[16] = 42034
					order[17] = 42035
					order[18] = 0
					fix.Group.__init__(self, 41340, 41341, order)

		class NoUnderlyingProtectionTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(12)
				order[0] = 42069
				order[1] = 42070
				order[2] = 42071
				order[3] = 42072
				order[4] = 42073
				order[5] = 42074
				order[6] = 42075
				order[7] = 42090
				order[8] = 42077
				order[9] = 42087
				order[10] = 42076
				order[11] = 0
				fix.Group.__init__(self, 42068, 42069, order)

			class NoUnderlyingProtectionTermEventNewsSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42091
					order[1] = 0
					fix.Group.__init__(self, 42090, 42091, order)

			class NoUnderlyingProtectionTermEvents(fix.Group):
				def __init__(self):
					order = fix.IntArray(9)
					order[0] = 42078
					order[1] = 42079
					order[2] = 42080
					order[3] = 42081
					order[4] = 42082
					order[5] = 42083
					order[6] = 42084
					order[7] = 42085
					order[8] = 0
					fix.Group.__init__(self, 42077, 42078, order)

				class NoUnderlyingProtectionTermEventQualifiers(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42086
						order[1] = 0
						fix.Group.__init__(self, 42085, 42086, order)

			class NoUnderlyingProtectionTermObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42088
					order[1] = 42089
					order[2] = 0
					fix.Group.__init__(self, 42087, 42088, order)

		class NoUnderlyingCashSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(29)
				order[0] = 42042
				order[1] = 42043
				order[2] = 42044
				order[3] = 42045
				order[4] = 42046
				order[5] = 42047
				order[6] = 42048
				order[7] = 42049
				order[8] = 42050
				order[9] = 42051
				order[10] = 42052
				order[11] = 42039
				order[12] = 42797
				order[13] = 42798
				order[14] = 42053
				order[15] = 42054
				order[16] = 42790
				order[17] = 42791
				order[18] = 42792
				order[19] = 42793
				order[20] = 42794
				order[21] = 42795
				order[22] = 42796
				order[23] = 42055
				order[24] = 42056
				order[25] = 42057
				order[26] = 42058
				order[27] = 42059
				order[28] = 0
				fix.Group.__init__(self, 42041, 42042, order)

			class NoUnderlyingCashSettlDealers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42040
					order[1] = 0
					fix.Group.__init__(self, 42039, 42040, order)

			class NoUnderlyingCashSettlDateBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42789
					order[1] = 0
					fix.Group.__init__(self, 42788, 42789, order)

		class NoUnderlyingPhysicalSettlTerms(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 42065
				order[1] = 42061
				order[2] = 42062
				order[3] = 42063
				order[4] = 42064
				order[5] = 0
				fix.Group.__init__(self, 42060, 42065, order)

			class NoUnderlyingPhysicalSettlDeliverableObligations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 42066
					order[1] = 42067
					order[2] = 0
					fix.Group.__init__(self, 42065, 42066, order)

		class NoUnderlyingRateSpreadSteps(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 43006
				order[1] = 43007
				order[2] = 0
				fix.Group.__init__(self, 43005, 43006, order)

		class NoUnderlyingDividendPayments(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 42856
				order[1] = 42857
				order[2] = 42858
				order[3] = 42859
				order[4] = 0
				fix.Group.__init__(self, 42855, 42856, order)

		class NoUnderlyingExtraordinaryEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42885
				order[1] = 42886
				order[2] = 0
				fix.Group.__init__(self, 42884, 42885, order)

class AllocationInstruction(Message):
	def __init__(self):
		Message.__init__(self)
		self.getHeader().setField( fix.MsgType("J") )

	class NoOrders(fix.Group):
		def __init__(self):
			order = fix.IntArray(11)
			order[0] = 11
			order[1] = 37
			order[2] = 198
			order[3] = 526
			order[4] = 66
			order[5] = 756
			order[6] = 38
			order[7] = 799
			order[8] = 800
			order[9] = 40
			order[10] = 0
			fix.Group.__init__(self, 73, 11, order)

		class NoNested2PartyIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 757
				order[1] = 758
				order[2] = 759
				order[3] = 2381
				order[4] = 806
				order[5] = 0
				fix.Group.__init__(self, 756, 757, order)

			class NoNested2PartySubIDs(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 760
					order[1] = 807
					order[2] = 0
					fix.Group.__init__(self, 806, 760, order)

	class NoExecs(fix.Group):
		def __init__(self):
			order = fix.IntArray(14)
			order[0] = 32
			order[1] = 17
			order[2] = 527
			order[3] = 31
			order[4] = 669
			order[5] = 29
			order[6] = 1003
			order[7] = 1041
			order[8] = 880
			order[9] = 2749
			order[10] = 2524
			order[11] = 2668
			order[12] = 1838
			order[13] = 0
			fix.Group.__init__(self, 124, 32, order)

		class NoTrdRegPublications(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 2669
				order[1] = 2670
				order[2] = 0
				fix.Group.__init__(self, 2668, 2669, order)

		class NoTradePriceConditions(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 1839
				order[1] = 0
				fix.Group.__init__(self, 1838, 1839, order)

	class NoSecurityAltID(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 455
			order[1] = 456
			order[2] = 2957
			order[3] = 0
			fix.Group.__init__(self, 454, 455, order)

	class NoSecondaryAssetClasses(fix.Group):
		def __init__(self):
			order = fix.IntArray(5)
			order[0] = 1977
			order[1] = 1978
			order[2] = 1979
			order[3] = 2741
			order[4] = 0
			fix.Group.__init__(self, 1976, 1977, order)

	class NoAssetAttributes(fix.Group):
		def __init__(self):
			order = fix.IntArray(4)
			order[0] = 2305
			order[1] = 2306
			order[2] = 2307
			order[3] = 0
			fix.Group.__init__(self, 2304, 2305, order)

	class NoEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(11)
			order[0] = 865
			order[1] = 866
			order[2] = 1145
			order[3] = 1827
			order[4] = 1826
			order[5] = 2340
			order[6] = 867
			order[7] = 868
			order[8] = 1578
			order[9] = 1579
			order[10] = 0
			fix.Group.__init__(self, 864, 865, order)

	class NoInstrumentParties(fix.Group):
		def __init__(self):
			order = fix.IntArray(6)
			order[0] = 1019
			order[1] = 1050
			order[2] = 1051
			order[3] = 2378
			order[4] = 1052
			order[5] = 0
			fix.Group.__init__(self, 1018, 1019, order)

		class NoInstrumentPartySubIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 1053
				order[1] = 1054
				order[2] = 0
				fix.Group.__init__(self, 1052, 1053, order)

	class NoComplexEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(53)
			order[0] = 1484
			order[1] = 2117
			order[2] = 2118
			order[3] = 2119
			order[4] = 1485
			order[5] = 2120
			order[6] = 2121
			order[7] = 2122
			order[8] = 2941
			order[9] = 1486
			order[10] = 2123
			order[11] = 1487
			order[12] = 1488
			order[13] = 1489
			order[14] = 1490
			order[15] = 1491
			order[16] = 2124
			order[17] = 2942
			order[18] = 2125
			order[19] = 2943
			order[20] = 2126
			order[21] = 2127
			order[22] = 2407
			order[23] = 2408
			order[24] = 2128
			order[25] = 2129
			order[26] = 2130
			order[27] = 2131
			order[28] = 2132
			order[29] = 41013
			order[30] = 41020
			order[31] = 41021
			order[32] = 41022
			order[33] = 41023
			order[34] = 41024
			order[35] = 41025
			order[36] = 41026
			order[37] = 41027
			order[38] = 41028
			order[39] = 41010
			order[40] = 2133
			order[41] = 2134
			order[42] = 2135
			order[43] = 2136
			order[44] = 2137
			order[45] = 41029
			order[46] = 40997
			order[47] = 2597
			order[48] = 2598
			order[49] = 2599
			order[50] = 2138
			order[51] = 2139
			order[52] = 0
			fix.Group.__init__(self, 1483, 1484, order)

		class NoComplexEventDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 1492
				order[1] = 1493
				order[2] = 1494
				order[3] = 0
				fix.Group.__init__(self, 1491, 1492, order)

			class NoComplexEventTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 1495
					order[1] = 1496
					order[2] = 0
					fix.Group.__init__(self, 1494, 1495, order)

		class NoComplexEventRateSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(5)
				order[0] = 41014
				order[1] = 41015
				order[2] = 41016
				order[3] = 41017
				order[4] = 0
				fix.Group.__init__(self, 41013, 41014, order)

		class NoComplexEventDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41019
				order[1] = 0
				fix.Group.__init__(self, 41018, 41019, order)

		class NoComplexEventPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 41011
				order[1] = 41012
				order[2] = 41031
				order[3] = 41007
				order[4] = 40994
				order[5] = 0
				fix.Group.__init__(self, 41010, 41011, order)

			class NoComplexEventSchedules(fix.Group):
				def __init__(self):
					order = fix.IntArray(6)
					order[0] = 41032
					order[1] = 41033
					order[2] = 41034
					order[3] = 41035
					order[4] = 41036
					order[5] = 0
					fix.Group.__init__(self, 41031, 41032, order)

			class NoComplexEventPeriodDateTimes(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 41008
					order[1] = 41009
					order[2] = 0
					fix.Group.__init__(self, 41007, 41008, order)

			class NoComplexEventAveragingObservations(fix.Group):
				def __init__(self):
					order = fix.IntArray(3)
					order[0] = 40995
					order[1] = 40996
					order[2] = 0
					fix.Group.__init__(self, 40994, 40995, order)

		class NoComplexEventCreditEventSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41030
				order[1] = 0
				fix.Group.__init__(self, 41029, 41030, order)

		class NoComplexEventCreditEvents(fix.Group):
			def __init__(self):
				order = fix.IntArray(9)
				order[0] = 40998
				order[1] = 40999
				order[2] = 41000
				order[3] = 41001
				order[4] = 41002
				order[5] = 41003
				order[6] = 41004
				order[7] = 41005
				order[8] = 0
				fix.Group.__init__(self, 40997, 40998, order)

			class NoComplexEventCreditEventQualifiers(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 41006
					order[1] = 0
					fix.Group.__init__(self, 41005, 41006, order)

	class NoBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 40471
			order[1] = 0
			fix.Group.__init__(self, 40278, 40471, order)

	class NoPricingDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41231
			order[1] = 0
			fix.Group.__init__(self, 41230, 41231, order)

	class NoMarketDisruptionEvents(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41093
			order[1] = 40991
			order[2] = 0
			fix.Group.__init__(self, 41092, 41093, order)

	class NoMarketDisruptionFallbacks(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41095
			order[1] = 40992
			order[2] = 0
			fix.Group.__init__(self, 41094, 41095, order)

	class NoMarketDisruptionFallbackReferencePrices(fix.Group):
		def __init__(self):
			order = fix.IntArray(10)
			order[0] = 41097
			order[1] = 41098
			order[2] = 41099
			order[3] = 41100
			order[4] = 41101
			order[5] = 41102
			order[6] = 41103
			order[7] = 41104
			order[8] = 41105
			order[9] = 0
			fix.Group.__init__(self, 41096, 41097, order)

	class NoSettlMethodElectionDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 42776
			order[1] = 0
			fix.Group.__init__(self, 42775, 42776, order)

	class NoOptionExerciseBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41117
			order[1] = 0
			fix.Group.__init__(self, 41116, 41117, order)

	class NoOptionExerciseDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41138
			order[1] = 41139
			order[2] = 0
			fix.Group.__init__(self, 41137, 41138, order)

	class NoOptionExerciseExpirationDateBusinessCenters(fix.Group):
		def __init__(self):
			order = fix.IntArray(2)
			order[0] = 41141
			order[1] = 0
			fix.Group.__init__(self, 41140, 41141, order)

	class NoOptionExerciseExpirationDates(fix.Group):
		def __init__(self):
			order = fix.IntArray(3)
			order[0] = 41153
			order[1] = 41154
			order[2] = 0
			fix.Group.__init__(self, 41152, 41153, order)

	class NoStreams(fix.Group):
		def __init__(self):
			order = fix.IntArray(135)
			order[0] = 40050
			order[1] = 41303
			order[2] = 40051
			order[3] = 42784
			order[4] = 42785
			order[5] = 40052
			order[6] = 40053
			order[7] = 41305
			order[8] = 40054
			order[9] = 40055
			order[10] = 42786
			order[11] = 42787
			order[12] = 41306
			order[13] = 41307
			order[14] = 41308
			order[15] = 41309
			order[16] = 41310
			order[17] = 41311
			order[18] = 41251
			order[19] = 41252
			order[20] = 41253
			order[21] = 41254
			order[22] = 41255
			order[23] = 41256
			order[24] = 41257
			order[25] = 42587
			order[26] = 41258
			order[27] = 41259
			order[28] = 41260
			order[29] = 41261
			order[30] = 41262
			order[31] = 41263
			order[32] = 41264
			order[33] = 41265
			order[34] = 41266
			order[35] = 41267
			order[36] = 41268
			order[37] = 41269
			order[38] = 41270
			order[39] = 41271
			order[40] = 41272
			order[41] = 41273
			order[42] = 41274
			order[43] = 41275
			order[44] = 41276
			order[45] = 40907
			order[46] = 40908
			order[47] = 40910
			order[48] = 40911
			order[49] = 40912
			order[50] = 40913
			order[51] = 40914
			order[52] = 40065
			order[53] = 40066
			order[54] = 40068
			order[55] = 40069
			order[56] = 40070
			order[57] = 40071
			order[58] = 40072
			order[59] = 41244
			order[60] = 41245
			order[61] = 40073
			order[62] = 40075
			order[63] = 40076
			order[64] = 40078
			order[65] = 40079
			order[66] = 40080
			order[67] = 40081
			order[68] = 40082
			order[69] = 40083
			order[70] = 40084
			order[71] = 41246
			order[72] = 41247
			order[73] = 41248
			order[74] = 40738
			order[75] = 40739
			order[76] = 40740
			order[77] = 42600
			order[78] = 40741
			order[79] = 40742
			order[80] = 43106
			order[81] = 40743
			order[82] = 40744
			order[83] = 40745
			order[84] = 40746
			order[85] = 40747
			order[86] = 42601
			order[87] = 42602
			order[88] = 42603
			order[89] = 42604
			order[90] = 40748
			order[91] = 40749
			order[92] = 40750
			order[93] = 41180
			order[94] = 41181
			order[95] = 41182
			order[96] = 41183
			order[97] = 41184
			order[98] = 41185
			order[99] = 41186
			order[100] = 42605
			order[101] = 40828
			order[102] = 40872
			order[103] = 41058
			order[104] = 41059
			order[105] = 41060
			order[106] = 41061
			order[107] = 41062
			order[108] = 42192
			order[109] = 42193
			order[110] = 41063
			order[111] = 41064
			order[112] = 41065
			order[113] = 41066
			order[114] = 41067
			order[115] = 41218
			order[116] = 41068
			order[117] = 41069
			order[118] = 41070
			order[119] = 41071
			order[120] = 41072
			order[121] = 41073
			order[122] = 41074
			order[123] = 41075
			order[124] = 41076
			order[125] = 41077
			order[126] = 41078
			order[127] = 41079
			order[128] = 41080
			order[129] = 43094
			order[130] = 41037
			order[131] = 40056
			order[132] = 40982
			order[133] = 40983
			order[134] = 0
			fix.Group.__init__(self, 40049, 40050, order)

		class NoStreamCommodityAltIDs(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41278
				order[1] = 41279
				order[2] = 0
				fix.Group.__init__(self, 41277, 41278, order)

		class NoStreamAssetAttributes(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 41238
				order[1] = 41239
				order[2] = 41240
				order[3] = 0
				fix.Group.__init__(self, 41237, 41238, order)

		class NoStreamCommodityDataSources(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41281
				order[1] = 41282
				order[2] = 0
				fix.Group.__init__(self, 41280, 41281, order)

		class NoStreamCommoditySettlBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41250
				order[1] = 0
				fix.Group.__init__(self, 41249, 41250, order)

		class NoStreamCommoditySettlPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(15)
				order[0] = 41290
				order[1] = 41291
				order[2] = 41292
				order[3] = 41293
				order[4] = 41294
				order[5] = 41295
				order[6] = 41296
				order[7] = 41297
				order[8] = 41298
				order[9] = 41299
				order[10] = 41300
				order[11] = 41283
				order[12] = 41301
				order[13] = 41302
				order[14] = 0
				fix.Group.__init__(self, 41289, 41290, order)

			class NoStreamCommoditySettlDays(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 41284
					order[1] = 41285
					order[2] = 41286
					order[3] = 0
					fix.Group.__init__(self, 41283, 41284, order)

				class NoStreamCommoditySettlTimes(fix.Group):
					def __init__(self):
						order = fix.IntArray(4)
						order[0] = 41287
						order[1] = 41288
						order[2] = 41588
						order[3] = 0
						fix.Group.__init__(self, 41286, 41287, order)

		class NoStreamEffectiveDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40909
				order[1] = 0
				fix.Group.__init__(self, 40960, 40909, order)

		class NoStreamTerminationDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40067
				order[1] = 0
				fix.Group.__init__(self, 40961, 40067, order)

		class NoStreamCalculationPeriodBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40074
				order[1] = 0
				fix.Group.__init__(self, 40958, 40074, order)

		class NoStreamCalculationPeriodDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41242
				order[1] = 41243
				order[2] = 0
				fix.Group.__init__(self, 41241, 41242, order)

		class NoStreamFirstPeriodStartDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40077
				order[1] = 0
				fix.Group.__init__(self, 40959, 40077, order)

		class NoPaymentStreamPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40752
				order[1] = 0
				fix.Group.__init__(self, 40947, 40752, order)

		class NoPaymentStreamPaymentDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41221
				order[1] = 41222
				order[2] = 0
				fix.Group.__init__(self, 41220, 41221, order)

		class NoPaymentStreamResetDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40763
				order[1] = 0
				fix.Group.__init__(self, 40948, 40763, order)

		class NoPaymentStreamInitialFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40769
				order[1] = 0
				fix.Group.__init__(self, 40949, 40769, order)

		class NoPaymentStreamFixingDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40776
				order[1] = 0
				fix.Group.__init__(self, 40950, 40776, order)

		class NoPaymentStreamFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42661
				order[1] = 42662
				order[2] = 0
				fix.Group.__init__(self, 42660, 42661, order)

		class NoPaymentStreamPricingBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 41193
				order[1] = 0
				fix.Group.__init__(self, 41192, 41193, order)

		class NoPaymentStreamPricingDays(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41228
				order[1] = 41229
				order[2] = 0
				fix.Group.__init__(self, 41227, 41228, order)

		class NoPaymentStreamPricingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 41225
				order[1] = 41226
				order[2] = 0
				fix.Group.__init__(self, 41224, 41225, order)

		class NoPaymentStreamFormulas(fix.Group):
			def __init__(self):
				order = fix.IntArray(4)
				order[0] = 43109
				order[1] = 42684
				order[2] = 42685
				order[3] = 0
				fix.Group.__init__(self, 42683, 43109, order)

		class NoDividendPeriods(fix.Group):
			def __init__(self):
				order = fix.IntArray(21)
				order[0] = 42275
				order[1] = 42276
				order[2] = 42277
				order[3] = 42278
				order[4] = 42279
				order[5] = 42280
				order[6] = 42294
				order[7] = 42281
				order[8] = 42282
				order[9] = 42283
				order[10] = 42284
				order[11] = 42285
				order[12] = 42286
				order[13] = 42287
				order[14] = 42288
				order[15] = 42289
				order[16] = 42290
				order[17] = 42291
				order[18] = 42292
				order[19] = 42293
				order[20] = 0
				fix.Group.__init__(self, 42274, 42275, order)

			class NoDividendPeriodBusinessCenters(fix.Group):
				def __init__(self):
					order = fix.IntArray(2)
					order[0] = 42295
					order[1] = 0
					fix.Group.__init__(self, 42294, 42295, order)

		class NoDividendFXTriggerDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42273
				order[1] = 0
				fix.Group.__init__(self, 42272, 42273, order)

		class NoDividendAccrualPaymentDateBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42237
				order[1] = 0
				fix.Group.__init__(self, 42236, 42237, order)

		class NoReturnRates(fix.Group):
			def __init__(self):
				order = fix.IntArray(30)
				order[0] = 42736
				order[1] = 42737
				order[2] = 42738
				order[3] = 42739
				order[4] = 42740
				order[5] = 42741
				order[6] = 42765
				order[7] = 42731
				order[8] = 42742
				order[9] = 42743
				order[10] = 42744
				order[11] = 42745
				order[12] = 42746
				order[13] = 42747
				order[14] = 42748
				order[15] = 42749
				order[16] = 42750
				order[17] = 42751
				order[18] = 42752
				order[19] = 42753
				order[20] = 42761
				order[21] = 42754
				order[22] = 42755
				order[23] = 42709
				order[24] = 42756
				order[25] = 42757
				order[26] = 42758
				order[27] = 42759
				order[28] = 42760
				order[29] = 0
				fix.Group.__init__(self, 42735, 42736, order)

			class NoReturnRatePrices(fix.Group):
				def __init__(self):
					order = fix.IntArray(5)
					order[0] = 42766
					order[1] = 42767
					order[2] = 42768
					order[3] = 42769
					order[4] = 0
					fix.Group.__init__(self, 42765, 42766, order)

			class NoReturnRateFXConversions(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42732
					order[1] = 42733
					order[2] = 42734
					order[3] = 0
					fix.Group.__init__(self, 42731, 42732, order)

			class NoReturnRateInformationSources(fix.Group):
				def __init__(self):
					order = fix.IntArray(4)
					order[0] = 42762
					order[1] = 42763
					order[2] = 42764
					order[3] = 0
					fix.Group.__init__(self, 42761, 42762, order)

			class NoReturnRateDates(fix.Group):
				def __init__(self):
					order = fix.IntArray(24)
					order[0] = 42710
					order[1] = 42772
					order[2] = 42711
					order[3] = 42712
					order[4] = 42713
					order[5] = 42714
					order[6] = 42715
					order[7] = 42716
					order[8] = 42717
					order[9] = 42718
					order[10] = 42719
					order[11] = 42720
					order[12] = 42721
					order[13] = 42722
					order[14] = 42723
					order[15] = 42724
					order[16] = 42725
					order[17] = 42726
					order[18] = 42727
					order[19] = 42728
					order[20] = 42729
					order[21] = 42730
					order[22] = 42770
					order[23] = 0
					fix.Group.__init__(self, 42709, 42710, order)

				class NoReturnRateValuationDates(fix.Group):
					def __init__(self):
						order = fix.IntArray(3)
						order[0] = 42773
						order[1] = 42774
						order[2] = 0
						fix.Group.__init__(self, 42772, 42773, order)

				class NoReturnRateValuationDateBusinessCenters(fix.Group):
					def __init__(self):
						order = fix.IntArray(2)
						order[0] = 42771
						order[1] = 0
						fix.Group.__init__(self, 42770, 42771, order)

		class NoPaymentStreamCompoundingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 42621
				order[1] = 0
				fix.Group.__init__(self, 42620, 42621, order)

		class NoPaymentStreamCompoundingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 42607
				order[1] = 42608
				order[2] = 0
				fix.Group.__init__(self, 42606, 42607, order)

		class NoPaymentStreamNonDeliverableFixingDatesBusinessCenters(fix.Group):
			def __init__(self):
				order = fix.IntArray(2)
				order[0] = 40819
				order[1] = 0
				fix.Group.__init__(self, 40946, 40819, order)

		class NoNonDeliverableFixingDates(fix.Group):
			def __init__(self):
				order = fix.IntArray(3)
				order[0] = 40826
				order[1] = 40827
				order[2] = 0
				fix.Group.__init__(self, 40825, 40826, order)

		class NoSettlRateFallbacks(fix.Group):
			def __init__(self):
				order = fix.IntArray(6)
				order[0] = 40086
				order[1] = 40373
				order[2] = 40655
				order[3] = 40088
				order[4] = 40089
				order[5] = 0
				fix.Group.__init__(self, 40085, 40086, order)

		class NoPaymentSchedules(fix.Group):
			def __init__(self):
				order = fix.IntArray(58)
				order[0] = 40829
				order[1] = 41164
				order[2] = 41165
				order[3] = 40830
				order[4] = 40831
				order[5] = 40832
				order[6] = 40833
				order[7] = 40834
				order[8] = 40835
				order[9] = 40836
				order[10] = 40837
				order[11] = 40838
				order[12] = 40839
				order[13] = 41166
				order[14] = 41167
				order[15] = 41168
				order[16] = 41169
				order[17] = 40840
				order[18] = 40841
				order[19] = 40842
				order[20] = 40843
				order[21] = 41170
				order[22] = 41171
				order[23] = 41172
				order[24] = 41173
				order[25] = 40844
				order[26] = 40845
				order[27] = 40846
				order[28] = 40847
				order[29] = 40848
				order[30] = 40849
				order[31] = 40868
				order[32] = 40850
				order[33] = 40851
				order[34] = 40852
				order[35] = 40853
				order[36] = 40977
				order[37] = 40855
				order[38] = 40856
				order[39] = 40857
				order[40] = 41174
				order[41] = 41175
				order[42] = 40858
				order[43] = 41161
				order[44] = 41176
				order[45] = 41177
				order[46] = 41178
				order[47] = 41179
				order[48] = 40859
				order[49] = 40860
				order[50] = 40861
				order[51] = 40862
				order[52] = 40945
				order[53] = 40864
				order[54] = 40865
				order[55] = 40866
				order[56] = 40867
				order[57] = 0
				fix.Group.__init__(self, 40828, 40829, order)

			class NoPaymentScheduleRateSources(fix.Group):
				de