#ifndef FIX_FIELDS_H
#define FIX_FIELDS_H

#include "Field.h"
#include "FixCommonFields.h"

#undef Yield

#ifdef ReplaceText
#ifdef _MSC_VER
#pragma push_macro("ReplaceText")
#else
#pragma push("ReplaceText")
#endif
#undef ReplaceText
#endif

namespace FIX {
DEFINE_SEQNUM(BeginSeqNo);
DEFINE_LENGTH(BodyLength);
DEFINE_CHECKSUM(CheckSum);
DEFINE_SEQNUM(EndSeqNo);
DEFINE_SEQNUM(MsgSeqNum);
DEFINE_STRING(MsgType);
DEFINE_SEQNUM(NewSeqNo);
DEFINE_BOOLEAN(PossDupFlag);
DEFINE_SEQNUM(RefSeqNum);
DEFINE_STRING(SenderSubID);
DEFINE_UTCTIMESTAMP(SendingTime);
DEFINE_STRING(TargetSubID);
DEFINE_STRING(Text);
DEFINE_DATA(Signature);
DEFINE_LENGTH(SecureDataLen);
DEFINE_DATA(SecureData);
DEFINE_LENGTH(SignatureLength);
DEFINE_LENGTH(RawDataLength);
DEFINE_DATA(RawData);
DEFINE_BOOLEAN(PossResend);
DEFINE_INT(EncryptMethod);
DEFINE_INT(HeartBtInt);
DEFINE_STRING(TestReqID);
DEFINE_STRING(OnBehalfOfCompID);
DEFINE_STRING(OnBehalfOfSubID);
DEFINE_UTCTIMESTAMP(OrigSendingTime);
DEFINE_BOOLEAN(GapFillFlag);
DEFINE_STRING(DeliverToCompID);
DEFINE_STRING(DeliverToSubID);
DEFINE_BOOLEAN(ResetSeqNumFlag);
DEFINE_STRING(SenderLocationID);
DEFINE_STRING(TargetLocationID);
DEFINE_STRING(OnBehalfOfLocationID);
DEFINE_STRING(DeliverToLocationID);
DEFINE_LENGTH(XmlDataLen);
DEFINE_DATA(XmlData);
DEFINE_STRING(MessageEncoding);
DEFINE_LENGTH(EncodedTextLen);
DEFINE_DATA(EncodedText);
DEFINE_SEQNUM(LastMsgSeqNumProcessed);
DEFINE_INT(RefTagID);
DEFINE_STRING(RefMsgType);
DEFINE_INT(SessionRejectReason);
DEFINE_LENGTH(MaxMessageSize);
DEFINE_BOOLEAN(TestMessageIndicator);
DEFINE_STRING(Username);
DEFINE_STRING(Password);
DEFINE_NUMINGROUP(NoHops);
DEFINE_STRING(HopCompID);
DEFINE_UTCTIMESTAMP(HopSendingTime);
DEFINE_SEQNUM(HopRefID);
DEFINE_SEQNUM(NextExpectedMsgSeqNum);
DEFINE_STRING(NewPassword);
DEFINE_STRING(ApplVerID);
DEFINE_STRING(CstmApplVerID);
DEFINE_STRING(RefApplVerID);
DEFINE_STRING(RefCstmApplVerID);
DEFINE_STRING(DefaultApplVerID);
DEFINE_INT(ApplExtID);
DEFINE_INT(EncryptedPasswordMethod);
DEFINE_LENGTH(EncryptedPasswordLen);
DEFINE_DATA(EncryptedPassword);
DEFINE_LENGTH(EncryptedNewPasswordLen);
DEFINE_DATA(EncryptedNewPassword);
DEFINE_INT(RefApplExtID);
DEFINE_INT(DefaultApplExtID);
DEFINE_STRING(DefaultCstmApplVerID);
DEFINE_INT(SessionStatus);
DEFINE_STRING(Account);
DEFINE_STRING(AdvId);
DEFINE_STRING(AdvRefID);
DEFINE_CHAR(AdvSide);
DEFINE_STRING(AdvTransType);
DEFINE_PRICE(AvgPx);
DEFINE_STRING(ClOrdID);
DEFINE_AMT(Commission);
DEFINE_CHAR(CommType);
DEFINE_QTY(CumQty);
DEFINE_CURRENCY(Currency);
DEFINE_STRING(ExecID);
DEFINE_MULTIPLECHARVALUE(ExecInst);
DEFINE_STRING(ExecRefID);
DEFINE_CHAR(ExecTransType);
DEFINE_CHAR(HandlInst);
DEFINE_STRING(IDSource);
DEFINE_STRING(IOIid);
DEFINE_CHAR(IOIOthSvc);
DEFINE_CHAR(IOIQltyInd);
DEFINE_STRING(IOIRefID);
DEFINE_STRING(IOIShares);
DEFINE_CHAR(IOITransType);
DEFINE_CHAR(LastCapacity);
DEFINE_EXCHANGE(LastMkt);
DEFINE_PRICE(LastPx);
DEFINE_QTY(LastShares);
DEFINE_NUMINGROUP(LinesOfText);
DEFINE_STRING(OrderID);
DEFINE_QTY(OrderQty);
DEFINE_CHAR(OrdStatus);
DEFINE_CHAR(OrdType);
DEFINE_STRING(OrigClOrdID);
DEFINE_UTCTIMESTAMP(OrigTime);
DEFINE_PRICE(Price);
DEFINE_STRING(RelatdSym);
DEFINE_CHAR(Rule80A);
DEFINE_STRING(SecurityID);
DEFINE_QTY(Shares);
DEFINE_CHAR(Side);
DEFINE_STRING(Symbol);
DEFINE_CHAR(TimeInForce);
DEFINE_UTCTIMESTAMP(TransactTime);
DEFINE_CHAR(Urgency);
DEFINE_UTCTIMESTAMP(ValidUntilTime);
DEFINE_CHAR(SettlmntTyp);
DEFINE_LOCALMKTDATE(FutSettDate);
DEFINE_STRING(SymbolSfx);
DEFINE_STRING(ListID);
DEFINE_INT(ListSeqNo);
DEFINE_INT(ListNoOrds);
DEFINE_STRING(ListExecInst);
DEFINE_STRING(AllocID);
DEFINE_CHAR(AllocTransType);
DEFINE_STRING(RefAllocID);
DEFINE_NUMINGROUP(NoOrders);
DEFINE_INT(AvgPrxPrecision);
DEFINE_LOCALMKTDATE(TradeDate);
DEFINE_STRING(ExecBroker);
DEFINE_CHAR(OpenClose);
DEFINE_NUMINGROUP(NoAllocs);
DEFINE_STRING(AllocAccount);
DEFINE_QTY(AllocShares);
DEFINE_CHAR(ProcessCode);
DEFINE_INT(NoRpts);
DEFINE_INT(RptSeq);
DEFINE_QTY(CxlQty);
DEFINE_NUMINGROUP(NoDlvyInst);
DEFINE_STRING(DlvyInst);
DEFINE_INT(AllocStatus);
DEFINE_INT(AllocRejCode);
DEFINE_STRING(BrokerOfCredit);
DEFINE_CHAR(EmailType);
DEFINE_PRICE(StopPx);
DEFINE_EXCHANGE(ExDestination);
DEFINE_INT(CxlRejReason);
DEFINE_INT(OrdRejReason);
DEFINE_CHAR(IOIQualifier);
DEFINE_STRING(WaveNo);
DEFINE_STRING(Issuer);
DEFINE_STRING(SecurityDesc);
DEFINE_STRING(ClientID);
DEFINE_QTY(MinQty);
DEFINE_QTY(MaxFloor);
DEFINE_BOOLEAN(ReportToExch);
DEFINE_BOOLEAN(LocateReqd);
DEFINE_STRING(QuoteID);
DEFINE_AMT(NetMoney);
DEFINE_AMT(SettlCurrAmt);
DEFINE_CURRENCY(SettlCurrency);
DEFINE_BOOLEAN(ForexReq);
DEFINE_NUMINGROUP(NoExecs);
DEFINE_CHAR(CxlType);
DEFINE_UTCTIMESTAMP(ExpireTime);
DEFINE_CHAR(DKReason);
DEFINE_BOOLEAN(IOINaturalFlag);
DEFINE_STRING(QuoteReqID);
DEFINE_PRICE(BidPx);
DEFINE_PRICE(OfferPx);
DEFINE_QTY(BidSize);
DEFINE_QTY(OfferSize);
DEFINE_NUMINGROUP(NoMiscFees);
DEFINE_AMT(MiscFeeAmt);
DEFINE_CURRENCY(MiscFeeCurr);
DEFINE_STRING(MiscFeeType);
DEFINE_PRICE(PrevClosePx);
DEFINE_NUMINGROUP(NoRelatedSym);
DEFINE_STRING(Subject);
DEFINE_STRING(Headline);
DEFINE_STRING(URLLink);
DEFINE_CHAR(ExecType);
DEFINE_QTY(LeavesQty);
DEFINE_QTY(CashOrderQty);
DEFINE_PRICE(AllocAvgPx);
DEFINE_AMT(AllocNetMoney);
DEFINE_FLOAT(SettlCurrFxRate);
DEFINE_CHAR(SettlCurrFxRateCalc);
DEFINE_INT(NumDaysInterest);
DEFINE_PERCENTAGE(AccruedInterestRate);
DEFINE_AMT(AccruedInterestAmt);
DEFINE_CHAR(SettlInstMode);
DEFINE_STRING(AllocText);
DEFINE_STRING(SettlInstID);
DEFINE_CHAR(SettlInstTransType);
DEFINE_STRING(EmailThreadID);
DEFINE_CHAR(SettlInstSource);
DEFINE_STRING(SettlLocation);
DEFINE_STRING(SecurityType);
DEFINE_UTCTIMESTAMP(EffectiveTime);
DEFINE_INT(StandInstDbType);
DEFINE_STRING(StandInstDbName);
DEFINE_STRING(StandInstDbID);
DEFINE_INT(SettlDeliveryType);
DEFINE_STRING(SettlDepositoryCode);
DEFINE_STRING(SettlBrkrCode);
DEFINE_STRING(SettlInstCode);
DEFINE_STRING(SecuritySettlAgentName);
DEFINE_STRING(SecuritySettlAgentCode);
DEFINE_STRING(SecuritySettlAgentAcctNum);
DEFINE_STRING(SecuritySettlAgentAcctName);
DEFINE_STRING(SecuritySettlAgentContactName);
DEFINE_STRING(SecuritySettlAgentContactPhone);
DEFINE_STRING(CashSettlAgentName);
DEFINE_STRING(CashSettlAgentCode);
DEFINE_STRING(CashSettlAgentAcctNum);
DEFINE_STRING(CashSettlAgentAcctName);
DEFINE_STRING(CashSettlAgentContactName);
DEFINE_STRING(CashSettlAgentContactPhone);
DEFINE_PRICE(BidSpotRate);
DEFINE_PRICEOFFSET(BidForwardPoints);
DEFINE_PRICE(OfferSpotRate);
DEFINE_PRICEOFFSET(OfferForwardPoints);
DEFINE_QTY(OrderQty2);
DEFINE_LOCALMKTDATE(FutSettDate2);
DEFINE_PRICE(LastSpotRate);
DEFINE_PRICEOFFSET(LastForwardPoints);
DEFINE_STRING(AllocLinkID);
DEFINE_INT(AllocLinkType);
DEFINE_STRING(SecondaryOrderID);
DEFINE_NUMINGROUP(NoIOIQualifiers);
DEFINE_MONTHYEAR(MaturityMonthYear);
DEFINE_INT(PutOrCall);
DEFINE_PRICE(StrikePrice);
DEFINE_INT(CoveredOrUncovered);
DEFINE_INT(CustomerOrFirm);
DEFINE_DAYOFMONTH(MaturityDay);
DEFINE_CHAR(OptAttribute);
DEFINE_EXCHANGE(SecurityExchange);
DEFINE_BOOLEAN(NotifyBrokerOfCredit);
DEFINE_INT(AllocHandlInst);
DEFINE_QTY(MaxShow);
DEFINE_PRICEOFFSET(PegDifference);
DEFINE_LOCALMKTDATE(SendingDate);
DEFINE_INT(TotNoOrders);
DEFINE_STRING(SettlInstRefID);
DEFINE_NUMINGROUP(NoRoutingIDs);
DEFINE_INT(RoutingType);
DEFINE_STRING(RoutingID);
DEFINE_PRICEOFFSET(SpreadToBenchmark);
DEFINE_CHAR(Benchmark);
DEFINE_PERCENTAGE(CouponRate);
DEFINE_FLOAT(ContractMultiplier);
DEFINE_STRING(MDReqID);
DEFINE_CHAR(SubscriptionRequestType);
DEFINE_INT(MarketDepth);
DEFINE_INT(MDUpdateType);
DEFINE_BOOLEAN(AggregatedBook);
DEFINE_NUMINGROUP(NoMDEntryTypes);
DEFINE_NUMINGROUP(NoMDEntries);
DEFINE_CHAR(MDEntryType);
DEFINE_PRICE(MDEntryPx);
DEFINE_QTY(MDEntrySize);
DEFINE_UTCDATEONLY(MDEntryDate);
DEFINE_UTCTIMEONLY(MDEntryTime);
DEFINE_CHAR(TickDirection);
DEFINE_EXCHANGE(MDMkt);
DEFINE_MULTIPLESTRINGVALUE(QuoteCondition);
DEFINE_MULTIPLESTRINGVALUE(TradeCondition);
DEFINE_STRING(MDEntryID);
DEFINE_CHAR(MDUpdateAction);
DEFINE_STRING(MDEntryRefID);
DEFINE_CHAR(MDReqRejReason);
DEFINE_STRING(MDEntryOriginator);
DEFINE_STRING(LocationID);
DEFINE_STRING(DeskID);
DEFINE_CHAR(DeleteReason);
DEFINE_MULTIPLEVALUESTRING(OpenCloseSettleFlag);
DEFINE_INT(SellerDays);
DEFINE_STRING(MDEntryBuyer);
DEFINE_STRING(MDEntrySeller);
DEFINE_INT(MDEntryPositionNo);
DEFINE_MULTIPLECHARVALUE(FinancialStatus);
DEFINE_MULTIPLECHARVALUE(CorporateAction);
DEFINE_QTY(DefBidSize);
DEFINE_QTY(DefOfferSize);
DEFINE_NUMINGROUP(NoQuoteEntries);
DEFINE_NUMINGROUP(NoQuoteSets);
DEFINE_INT(QuoteAckStatus);
DEFINE_INT(QuoteCancelType);
DEFINE_STRING(QuoteEntryID);
DEFINE_INT(QuoteRejectReason);
DEFINE_INT(QuoteResponseLevel);
DEFINE_STRING(QuoteSetID);
DEFINE_INT(QuoteRequestType);
DEFINE_INT(TotQuoteEntries);
DEFINE_STRING(UnderlyingIDSource);
DEFINE_STRING(UnderlyingIssuer);
DEFINE_STRING(UnderlyingSecurityDesc);
DEFINE_EXCHANGE(UnderlyingSecurityExchange);
DEFINE_STRING(UnderlyingSecurityID);
DEFINE_STRING(UnderlyingSecurityType);
DEFINE_STRING(UnderlyingSymbol);
DEFINE_STRING(UnderlyingSymbolSfx);
DEFINE_MONTHYEAR(UnderlyingMaturityMonthYear);
DEFINE_DAYOFMONTH(UnderlyingMaturityDay);
DEFINE_INT(UnderlyingPutOrCall);
DEFINE_PRICE(UnderlyingStrikePrice);
DEFINE_CHAR(UnderlyingOptAttribute);
DEFINE_CURRENCY(UnderlyingCurrency);
DEFINE_QTY(RatioQty);
DEFINE_STRING(SecurityReqID);
DEFINE_INT(SecurityRequestType);
DEFINE_STRING(SecurityResponseID);
DEFINE_INT(SecurityResponseType);
DEFINE_STRING(SecurityStatusReqID);
DEFINE_BOOLEAN(UnsolicitedIndicator);
DEFINE_INT(SecurityTradingStatus);
DEFINE_CHAR(HaltReasonChar);
DEFINE_BOOLEAN(InViewOfCommon);
DEFINE_BOOLEAN(DueToRelated);
DEFINE_QTY(BuyVolume);
DEFINE_QTY(SellVolume);
DEFINE_PRICE(HighPx);
DEFINE_PRICE(LowPx);
DEFINE_INT(Adjustment);
DEFINE_STRING(TradSesReqID);
DEFINE_STRING(TradingSessionID);
DEFINE_STRING(ContraTrader);
DEFINE_INT(TradSesMethod);
DEFINE_INT(TradSesMode);
DEFINE_INT(TradSesStatus);
DEFINE_UTCTIMESTAMP(TradSesStartTime);
DEFINE_UTCTIMESTAMP(TradSesOpenTime);
DEFINE_UTCTIMESTAMP(TradSesPreCloseTime);
DEFINE_UTCTIMESTAMP(TradSesCloseTime);
DEFINE_UTCTIMESTAMP(TradSesEndTime);
DEFINE_INT(NumberOfOrders);
DEFINE_LENGTH(EncodedIssuerLen);
DEFINE_DATA(EncodedIssuer);
DEFINE_LENGTH(EncodedSecurityDescLen);
DEFINE_DATA(EncodedSecurityDesc);
DEFINE_LENGTH(EncodedListExecInstLen);
DEFINE_DATA(EncodedListExecInst);
DEFINE_LENGTH(EncodedSubjectLen);
DEFINE_DATA(EncodedSubject);
DEFINE_LENGTH(EncodedHeadlineLen);
DEFINE_DATA(EncodedHeadline);
DEFINE_LENGTH(EncodedAllocTextLen);
DEFINE_DATA(EncodedAllocText);
DEFINE_LENGTH(EncodedUnderlyingIssuerLen);
DEFINE_DATA(EncodedUnderlyingIssuer);
DEFINE_LENGTH(EncodedUnderlyingSecurityDescLen);
DEFINE_DATA(EncodedUnderlyingSecurityDesc);
DEFINE_PRICE(AllocPrice);
DEFINE_UTCTIMESTAMP(QuoteSetValidUntilTime);
DEFINE_INT(QuoteEntryRejectReason);
DEFINE_UTCTIMESTAMP(OnBehalfOfSendingTime);
DEFINE_CHAR(BidRequestTransType);
DEFINE_STRING(ContraBroker);
DEFINE_STRING(ComplianceID);
DEFINE_BOOLEAN(SolicitedFlag);
DEFINE_INT(ExecRestatementReason);
DEFINE_STRING(BusinessRejectRefID);
DEFINE_INT(BusinessRejectReason);
DEFINE_AMT(GrossTradeAmt);
DEFINE_NUMINGROUP(NoContraBrokers);
DEFINE_NUMINGROUP(NoMsgTypes);
DEFINE_CHAR(MsgDirection);
DEFINE_NUMINGROUP(NoTradingSessions);
DEFINE_QTY(TotalVolumeTraded);
DEFINE_CHAR(DiscretionInst);
DEFINE_PRICEOFFSET(DiscretionOffset);
DEFINE_STRING(BidID);
DEFINE_STRING(ClientBidID);
DEFINE_STRING(ListName);
DEFINE_INT(TotalNumSecurities);
DEFINE_INT(BidType);
DEFINE_INT(NumTickets);
DEFINE_AMT(SideValue1);
DEFINE_AMT(SideValue2);
DEFINE_NUMINGROUP(NoBidDescriptors);
DEFINE_INT(BidDescriptorType);
DEFINE_STRING(BidDescriptor);
DEFINE_INT(SideValueInd);
DEFINE_PERCENTAGE(LiquidityPctLow);
DEFINE_PERCENTAGE(LiquidityPctHigh);
DEFINE_AMT(LiquidityValue);
DEFINE_PERCENTAGE(EFPTrackingError);
DEFINE_AMT(FairValue);
DEFINE_PERCENTAGE(OutsideIndexPct);
DEFINE_AMT(ValueOfFutures);
DEFINE_INT(LiquidityIndType);
DEFINE_PERCENTAGE(WtAverageLiquidity);
DEFINE_BOOLEAN(ExchangeForPhysical);
DEFINE_AMT(OutMainCntryUIndex);
DEFINE_PERCENTAGE(CrossPercent);
DEFINE_INT(ProgRptReqs);
DEFINE_INT(ProgPeriodInterval);
DEFINE_INT(IncTaxInd);
DEFINE_INT(NumBidders);
DEFINE_CHAR(TradeType);
DEFINE_CHAR(BasisPxType);
DEFINE_NUMINGROUP(NoBidComponents);
DEFINE_COUNTRY(Country);
DEFINE_INT(TotNoStrikes);
DEFINE_INT(PriceType);
DEFINE_QTY(DayOrderQty);
DEFINE_QTY(DayCumQty);
DEFINE_PRICE(DayAvgPx);
DEFINE_INT(GTBookingInst);
DEFINE_NUMINGROUP(NoStrikes);
DEFINE_INT(ListStatusType);
DEFINE_INT(NetGrossInd);
DEFINE_INT(ListOrderStatus);
DEFINE_LOCALMKTDATE(ExpireDate);
DEFINE_CHAR(ListExecInstType);
DEFINE_CHAR(CxlRejResponseTo);
DEFINE_PERCENTAGE(UnderlyingCouponRate);
DEFINE_FLOAT(UnderlyingContractMultiplier);
DEFINE_QTY(ContraTradeQty);
DEFINE_UTCTIMESTAMP(ContraTradeTime);
DEFINE_STRING(ClearingFirm);
DEFINE_STRING(ClearingAccount);
DEFINE_INT(LiquidityNumSecurities);
DEFINE_CHAR(MultiLegReportingType);
DEFINE_UTCTIMESTAMP(StrikeTime);
DEFINE_STRING(ListStatusText);
DEFINE_LENGTH(EncodedListStatusTextLen);
DEFINE_DATA(EncodedListStatusText);
DEFINE_STRING(SecurityIDSource);
DEFINE_STRING(IOIQty);
DEFINE_QTY(LastQty);
DEFINE_QTY(Quantity);
DEFINE_CHAR(PositionEffect);
DEFINE_QTY(AllocQty);
DEFINE_PRICEOFFSET(Spread);
DEFINE_CURRENCY(BenchmarkCurveCurrency);
DEFINE_STRING(BenchmarkCurveName);
DEFINE_STRING(BenchmarkCurvePoint);
DEFINE_LOCALMKTDATE(CouponPaymentDate);
DEFINE_LOCALMKTDATE(IssueDate);
DEFINE_INT(RepurchaseTerm);
DEFINE_PERCENTAGE(RepurchaseRate);
DEFINE_FLOAT(Factor);
DEFINE_LOCALMKTDATE(TradeOriginationDate);
DEFINE_LOCALMKTDATE(ExDate);
DEFINE_NUMINGROUP(NoStipulations);
DEFINE_STRING(StipulationType);
DEFINE_STRING(StipulationValue);
DEFINE_STRING(YieldType);
DEFINE_PERCENTAGE(Yield);
DEFINE_AMT(TotalTakedown);
DEFINE_AMT(Concession);
DEFINE_STRING(RepoCollateralSecurityType);
DEFINE_LOCALMKTDATE(RedemptionDate);
DEFINE_LOCALMKTDATE(UnderlyingCouponPaymentDate);
DEFINE_LOCALMKTDATE(UnderlyingIssueDate);
DEFINE_STRING(UnderlyingRepoCollateralSecurityType);
DEFINE_INT(UnderlyingRepurchaseTerm);
DEFINE_PERCENTAGE(UnderlyingRepurchaseRate);
DEFINE_FLOAT(UnderlyingFactor);
DEFINE_LOCALMKTDATE(UnderlyingRedemptionDate);
DEFINE_LOCALMKTDATE(LegCouponPaymentDate);
DEFINE_LOCALMKTDATE(LegIssueDate);
DEFINE_STRING(LegRepoCollateralSecurityType);
DEFINE_INT(LegRepurchaseTerm);
DEFINE_PERCENTAGE(LegRepurchaseRate);
DEFINE_FLOAT(LegFactor);
DEFINE_LOCALMKTDATE(LegRedemptionDate);
DEFINE_STRING(CreditRating);
DEFINE_STRING(UnderlyingCreditRating);
DEFINE_STRING(LegCreditRating);
DEFINE_BOOLEAN(TradedFlatSwitch);
DEFINE_LOCALMKTDATE(BasisFeatureDate);
DEFINE_PRICE(BasisFeaturePrice);
DEFINE_INT(QuoteStatus);
DEFINE_STRING(UnderlyingSecurityIDSource);
DEFINE_CHAR(PartyIDSource);
DEFINE_STRING(PartyID);
DEFINE_UTCDATE(TotalVolumeTradedDate);
DEFINE_UTCTIMEONLY(TotalVolumeTradedTime);
DEFINE_PRICEOFFSET(NetChgPrevDay);
DEFINE_INT(PartyRole);
DEFINE_NUMINGROUP(NoPartyIDs);
DEFINE_NUMINGROUP(NoSecurityAltID);
DEFINE_STRING(SecurityAltID);
DEFINE_STRING(SecurityAltIDSource);
DEFINE_NUMINGROUP(NoUnderlyingSecurityAltID);
DEFINE_STRING(UnderlyingSecurityAltID);
DEFINE_STRING(UnderlyingSecurityAltIDSource);
DEFINE_INT(Product);
DEFINE_STRING(CFICode);
DEFINE_INT(UnderlyingProduct);
DEFINE_STRING(UnderlyingCFICode);
DEFINE_INT(QuantityType);
DEFINE_STRING(BookingRefID);
DEFINE_STRING(IndividualAllocID);
DEFINE_CHAR(RoundingDirection);
DEFINE_FLOAT(RoundingModulus);
DEFINE_COUNTRY(CountryOfIssue);
DEFINE_STRING(StateOrProvinceOfIssue);
DEFINE_STRING(LocaleOfIssue);
DEFINE_NUMINGROUP(NoRegistDtls);
DEFINE_STRING(MailingDtls);
DEFINE_COUNTRY(InvestorCountryOfResidence);
DEFINE_STRING(PaymentRef);
DEFINE_INT(DistribPaymentMethod);
DEFINE_CURRENCY(CashDistribCurr);
DEFINE_CURRENCY(CommCurrency);
DEFINE_CHAR(CancellationRights);
DEFINE_CHAR(MoneyLaunderingStatus);
DEFINE_STRING(MailingInst);
DEFINE_UTCTIMESTAMP(TransBkdTime);
DEFINE_CHAR(ExecPriceType);
DEFINE_FLOAT(ExecPriceAdjustment);
DEFINE_LOCALMKTDATE(DateOfBirth);
DEFINE_INT(TradeReportTransType);
DEFINE_STRING(CardHolderName);
DEFINE_STRING(CardNumber);
DEFINE_LOCALMKTDATE(CardExpDate);
DEFINE_STRING(CardIssNo);
DEFINE_INT(PaymentMethod);
DEFINE_STRING(RegistAcctType);
DEFINE_STRING(Designation);
DEFINE_INT(TaxAdvantageType);
DEFINE_STRING(RegistRejReasonText);
DEFINE_CHAR(FundRenewWaiv);
DEFINE_STRING(CashDistribAgentName);
DEFINE_STRING(CashDistribAgentCode);
DEFINE_STRING(CashDistribAgentAcctNumber);
DEFINE_STRING(CashDistribPayRef);
DEFINE_LOCALMKTDATE(CardStartDate);
DEFINE_LOCALMKTDATE(PaymentDate);
DEFINE_STRING(PaymentRemitterID);
DEFINE_CHAR(RegistStatus);
DEFINE_INT(RegistRejReasonCode);
DEFINE_STRING(RegistRefID);
DEFINE_STRING(RegistDetls);
DEFINE_NUMINGROUP(NoDistribInsts);
DEFINE_STRING(RegistEmail);
DEFINE_PERCENTAGE(DistribPercentage);
DEFINE_STRING(RegistID);
DEFINE_CHAR(RegistTransType);
DEFINE_UTCTIMESTAMP(ExecValuationPoint);
DEFINE_PERCENTAGE(OrderPercent);
DEFINE_CHAR(OwnershipType);
DEFINE_NUMINGROUP(NoContAmts);
DEFINE_INT(ContAmtType);
DEFINE_FLOAT(ContAmtValue);
DEFINE_CURRENCY(ContAmtCurr);
DEFINE_INT(OwnerType);
DEFINE_STRING(PartySubID);
DEFINE_STRING(NestedPartyID);
DEFINE_CHAR(NestedPartyIDSource);
DEFINE_STRING(SecondaryClOrdID);
DEFINE_STRING(SecondaryExecID);
DEFINE_CHAR(OrderCapacity);
DEFINE_MULTIPLECHARVALUE(OrderRestrictions);
DEFINE_CHAR(MassCancelRequestType);
DEFINE_CHAR(MassCancelResponse);
DEFINE_INT(MassCancelRejectReason);
DEFINE_INT(TotalAffectedOrders);
DEFINE_NUMINGROUP(NoAffectedOrders);
DEFINE_STRING(AffectedOrderID);
DEFINE_STRING(AffectedSecondaryOrderID);
DEFINE_INT(QuoteType);
DEFINE_INT(NestedPartyRole);
DEFINE_NUMINGROUP(NoNestedPartyIDs);
DEFINE_AMT(TotalAccruedInterestAmt);
DEFINE_LOCALMKTDATE(MaturityDate);
DEFINE_LOCALMKTDATE(UnderlyingMaturityDate);
DEFINE_STRING(InstrRegistry);
DEFINE_CHAR(CashMargin);
DEFINE_STRING(NestedPartySubID);
DEFINE_MULTIPLECHARVALUE(Scope);
DEFINE_BOOLEAN(MDImplicitDelete);
DEFINE_STRING(CrossID);
DEFINE_INT(CrossType);
DEFINE_INT(CrossPrioritization);
DEFINE_STRING(OrigCrossID);
DEFINE_NUMINGROUP(NoSides);
DEFINE_NUMINGROUP(NoLegs);
DEFINE_CURRENCY(LegCurrency);
DEFINE_INT(TotalNumSecurityTypes);
DEFINE_NUMINGROUP(NoSecurityTypes);
DEFINE_INT(SecurityListRequestType);
DEFINE_INT(SecurityRequestResult);
DEFINE_QTY(RoundLot);
DEFINE_QTY(MinTradeVol);
DEFINE_INT(MultiLegRptTypeReq);
DEFINE_CHAR(LegPositionEffect);
DEFINE_INT(LegCoveredOrUncovered);
DEFINE_PRICE(LegPrice);
DEFINE_INT(TradSesStatusRejReason);
DEFINE_STRING(TradeRequestID);
DEFINE_INT(TradeRequestType);
DEFINE_BOOLEAN(PreviouslyReported);
DEFINE_STRING(TradeReportID);
DEFINE_STRING(TradeReportRefID);
DEFINE_CHAR(MatchStatus);
DEFINE_STRING(MatchType);
DEFINE_BOOLEAN(OddLot);
DEFINE_NUMINGROUP(NoClearingInstructions);
DEFINE_INT(ClearingInstruction);
DEFINE_STRING(TradeInputSource);
DEFINE_STRING(TradeInputDevice);
DEFINE_NUMINGROUP(NoDates);
DEFINE_INT(AccountType);
DEFINE_INT(CustOrderCapacity);
DEFINE_STRING(ClOrdLinkID);
DEFINE_STRING(MassStatusReqID);
DEFINE_INT(MassStatusReqType);
DEFINE_UTCTIMESTAMP(OrigOrdModTime);
DEFINE_CHAR(LegSettlmntTyp);
DEFINE_LOCALMKTDATE(LegFutSettDate);
DEFINE_CHAR(DayBookingInst);
DEFINE_CHAR(BookingUnit);
DEFINE_CHAR(PreallocMethod);
DEFINE_COUNTRY(UnderlyingCountryOfIssue);
DEFINE_STRING(UnderlyingStateOrProvinceOfIssue);
DEFINE_STRING(UnderlyingLocaleOfIssue);
DEFINE_STRING(UnderlyingInstrRegistry);
DEFINE_COUNTRY(LegCountryOfIssue);
DEFINE_STRING(LegStateOrProvinceOfIssue);
DEFINE_STRING(LegLocaleOfIssue);
DEFINE_STRING(LegInstrRegistry);
DEFINE_STRING(LegSymbol);
DEFINE_STRING(LegSymbolSfx);
DEFINE_STRING(LegSecurityID);
DEFINE_STRING(LegSecurityIDSource);
DEFINE_NUMINGROUP(NoLegSecurityAltID);
DEFINE_STRING(LegSecurityAltID);
DEFINE_STRING(LegSecurityAltIDSource);
DEFINE_INT(LegProduct);
DEFINE_STRING(LegCFICode);
DEFINE_STRING(LegSecurityType);
DEFINE_MONTHYEAR(LegMaturityMonthYear);
DEFINE_LOCALMKTDATE(LegMaturityDate);
DEFINE_PRICE(LegStrikePrice);
DEFINE_CHAR(LegOptAttribute);
DEFINE_FLOAT(LegContractMultiplier);
DEFINE_PERCENTAGE(LegCouponRate);
DEFINE_EXCHANGE(LegSecurityExchange);
DEFINE_STRING(LegIssuer);
DEFINE_LENGTH(EncodedLegIssuerLen);
DEFINE_DATA(EncodedLegIssuer);
DEFINE_STRING(LegSecurityDesc);
DEFINE_LENGTH(EncodedLegSecurityDescLen);
DEFINE_DATA(EncodedLegSecurityDesc);
DEFINE_FLOAT(LegRatioQty);
DEFINE_CHAR(LegSide);
DEFINE_STRING(TradingSessionSubID);
DEFINE_INT(AllocType);
DEFINE_PRICE(MidPx);
DEFINE_PERCENTAGE(BidYield);
DEFINE_PERCENTAGE(MidYield);
DEFINE_PERCENTAGE(OfferYield);
DEFINE_STRING(ClearingFeeIndicator);
DEFINE_BOOLEAN(WorkingIndicator);
DEFINE_PRICE(LegLastPx);
DEFINE_INT(PriorityIndicator);
DEFINE_PRICEOFFSET(PriceImprovement);
DEFINE_PRICE(Price2);
DEFINE_PRICEOFFSET(LastForwardPoints2);
DEFINE_PRICEOFFSET(BidForwardPoints2);
DEFINE_PRICEOFFSET(OfferForwardPoints2);
DEFINE_STRING(RFQReqID);
DEFINE_PRICE(MktBidPx);
DEFINE_PRICE(MktOfferPx);
DEFINE_QTY(MinBidSize);
DEFINE_QTY(MinOfferSize);
DEFINE_STRING(QuoteStatusReqID);
DEFINE_BOOLEAN(LegalConfirm);
DEFINE_PRICE(UnderlyingLastPx);
DEFINE_QTY(UnderlyingLastQty);
DEFINE_STRING(LegRefID);
DEFINE_STRING(ContraLegRefID);
DEFINE_FLOAT(SettlCurrBidFxRate);
DEFINE_FLOAT(SettlCurrOfferFxRate);
DEFINE_INT(QuoteRequestRejectReason);
DEFINE_STRING(SideComplianceID);
DEFINE_STRING(IOIID);
DEFINE_NUMINGROUP(NoLinesOfText);
DEFINE_STRING(SettlType);
DEFINE_LOCALMKTDATE(SettlDate);
DEFINE_INT(AvgPxPrecision);
DEFINE_LOCALMKTDATE(SettlDate2);
DEFINE_FLOAT(PegOffsetValue);
DEFINE_MULTIPLECHARVALUE(OpenCloseSettlFlag);
DEFINE_INT(TotNoQuoteEntries);
DEFINE_FLOAT(DiscretionOffsetValue);
DEFINE_INT(TotNoRelatedSym);
DEFINE_CHAR(BidTradeType);
DEFINE_STRING(CardIssNum);
DEFINE_STRING(CashDistribAgentAcctName);
DEFINE_STRING(RegistDtls);
DEFINE_INT(TotNoSecurityTypes);
DEFINE_STRING(LegSettlType);
DEFINE_LOCALMKTDATE(LegSettlDate);
DEFINE_INT(AcctIDSource);
DEFINE_INT(AllocAcctIDSource);
DEFINE_PRICE(BenchmarkPrice);
DEFINE_INT(BenchmarkPriceType);
DEFINE_STRING(ConfirmID);
DEFINE_INT(ConfirmStatus);
DEFINE_INT(ConfirmTransType);
DEFINE_MONTHYEAR(ContractSettlMonth);
DEFINE_INT(DeliveryForm);
DEFINE_PRICE(LastParPx);
DEFINE_NUMINGROUP(NoLegAllocs);
DEFINE_STRING(LegAllocAccount);
DEFINE_STRING(LegIndividualAllocID);
DEFINE_QTY(LegAllocQty);
DEFINE_INT(LegAllocAcctIDSource);
DEFINE_CURRENCY(LegSettlCurrency);
DEFINE_CURRENCY(LegBenchmarkCurveCurrency);
DEFINE_STRING(LegBenchmarkCurveName);
DEFINE_STRING(LegBenchmarkCurvePoint);
DEFINE_PRICE(LegBenchmarkPrice);
DEFINE_INT(LegBenchmarkPriceType);
DEFINE_PRICE(LegBidPx);
DEFINE_STRING(LegIOIQty);
DEFINE_NUMINGROUP(NoLegStipulations);
DEFINE_PRICE(LegOfferPx);
DEFINE_INT(LegPriceType);
DEFINE_QTY(LegQty);
DEFINE_STRING(LegStipulationType);
DEFINE_STRING(LegStipulationValue);
DEFINE_INT(LegSwapType);
DEFINE_STRING(Pool);
DEFINE_INT(QuotePriceType);
DEFINE_STRING(QuoteRespID);
DEFINE_INT(QuoteRespType);
DEFINE_CHAR(QuoteQualifier);
DEFINE_LOCALMKTDATE(YieldRedemptionDate);
DEFINE_PRICE(YieldRedemptionPrice);
DEFINE_INT(YieldRedemptionPriceType);
DEFINE_STRING(BenchmarkSecurityID);
DEFINE_BOOLEAN(ReversalIndicator);
DEFINE_LOCALMKTDATE(YieldCalcDate);
DEFINE_NUMINGROUP(NoPositions);
DEFINE_STRING(PosType);
DEFINE_QTY(LongQty);
DEFINE_QTY(ShortQty);
DEFINE_INT(PosQtyStatus);
DEFINE_STRING(PosAmtType);
DEFINE_AMT(PosAmt);
DEFINE_INT(PosTransType);
DEFINE_STRING(PosReqID);
DEFINE_NUMINGROUP(NoUnderlyings);
DEFINE_INT(PosMaintAction);
DEFINE_STRING(OrigPosReqRefID);
DEFINE_STRING(PosMaintRptRefID);
DEFINE_LOCALMKTDATE(ClearingBusinessDate);
DEFINE_STRING(SettlSessID);
DEFINE_STRING(SettlSessSubID);
DEFINE_INT(AdjustmentType);
DEFINE_BOOLEAN(ContraryInstructionIndicator);
DEFINE_BOOLEAN(PriorSpreadIndicator);
DEFINE_STRING(PosMaintRptID);
DEFINE_INT(PosMaintStatus);
DEFINE_INT(PosMaintResult);
DEFINE_INT(PosReqType);
DEFINE_INT(ResponseTransportType);
DEFINE_STRING(ResponseDestination);
DEFINE_INT(TotalNumPosReports);
DEFINE_INT(PosReqResult);
DEFINE_INT(PosReqStatus);
DEFINE_PRICE(SettlPrice);
DEFINE_INT(SettlPriceType);
DEFINE_PRICE(UnderlyingSettlPrice);
DEFINE_INT(UnderlyingSettlPriceType);
DEFINE_PRICE(PriorSettlPrice);
DEFINE_NUMINGROUP(NoQuoteQualifiers);
DEFINE_CURRENCY(AllocSettlCurrency);
DEFINE_AMT(AllocSettlCurrAmt);
DEFINE_AMT(InterestAtMaturity);
DEFINE_LOCALMKTDATE(LegDatedDate);
DEFINE_STRING(LegPool);
DEFINE_AMT(AllocInterestAtMaturity);
DEFINE_AMT(AllocAccruedInterestAmt);
DEFINE_LOCALMKTDATE(DeliveryDate);
DEFINE_CHAR(AssignmentMethod);
DEFINE_QTY(AssignmentUnit);
DEFINE_AMT(OpenInterest);
DEFINE_CHAR(ExerciseMethod);
DEFINE_INT(TotNumTradeReports);
DEFINE_INT(TradeRequestResult);
DEFINE_INT(TradeRequestStatus);
DEFINE_INT(TradeReportRejectReason);
DEFINE_INT(SideMultiLegReportingType);
DEFINE_NUMINGROUP(NoPosAmt);
DEFINE_BOOLEAN(AutoAcceptIndicator);
DEFINE_STRING(AllocReportID);
DEFINE_NUMINGROUP(NoNested2PartyIDs);
DEFINE_STRING(Nested2PartyID);
DEFINE_CHAR(Nested2PartyIDSource);
DEFINE_INT(Nested2PartyRole);
DEFINE_STRING(Nested2PartySubID);
DEFINE_STRING(BenchmarkSecurityIDSource);
DEFINE_STRING(SecuritySubType);
DEFINE_STRING(UnderlyingSecuritySubType);
DEFINE_STRING(LegSecuritySubType);
DEFINE_PERCENTAGE(AllowableOneSidednessPct);
DEFINE_AMT(AllowableOneSidednessValue);
DEFINE_CURRENCY(AllowableOneSidednessCurr);
DEFINE_NUMINGROUP(NoTrdRegTimestamps);
DEFINE_UTCTIMESTAMP(TrdRegTimestamp);
DEFINE_INT(TrdRegTimestampType);
DEFINE_STRING(TrdRegTimestampOrigin);
DEFINE_STRING(ConfirmRefID);
DEFINE_INT(ConfirmType);
DEFINE_INT(ConfirmRejReason);
DEFINE_INT(BookingType);
DEFINE_INT(IndividualAllocRejCode);
DEFINE_STRING(SettlInstMsgID);
DEFINE_NUMINGROUP(NoSettlInst);
DEFINE_UTCTIMESTAMP(LastUpdateTime);
DEFINE_INT(AllocSettlInstType);
DEFINE_NUMINGROUP(NoSettlPartyIDs);
DEFINE_STRING(SettlPartyID);
DEFINE_CHAR(SettlPartyIDSource);
DEFINE_INT(SettlPartyRole);
DEFINE_STRING(SettlPartySubID);
DEFINE_INT(SettlPartySubIDType);
DEFINE_CHAR(DlvyInstType);
DEFINE_INT(TerminationType);
DEFINE_STRING(OrdStatusReqID);
DEFINE_STRING(SettlInstReqID);
DEFINE_INT(SettlInstReqRejCode);
DEFINE_STRING(SecondaryAllocID);
DEFINE_INT(AllocReportType);
DEFINE_STRING(AllocReportRefID);
DEFINE_INT(AllocCancReplaceReason);
DEFINE_BOOLEAN(CopyMsgIndicator);
DEFINE_INT(AllocAccountType);
DEFINE_PRICE(OrderAvgPx);
DEFINE_QTY(OrderBookingQty);
DEFINE_NUMINGROUP(NoSettlPartySubIDs);
DEFINE_NUMINGROUP(NoPartySubIDs);
DEFINE_INT(PartySubIDType);
DEFINE_NUMINGROUP(NoNestedPartySubIDs);
DEFINE_INT(NestedPartySubIDType);
DEFINE_NUMINGROUP(NoNested2PartySubIDs);
DEFINE_INT(Nested2PartySubIDType);
DEFINE_INT(AllocIntermedReqType);
DEFINE_PRICE(UnderlyingPx);
DEFINE_FLOAT(PriceDelta);
DEFINE_INT(ApplQueueMax);
DEFINE_INT(ApplQueueDepth);
DEFINE_INT(ApplQueueResolution);
DEFINE_INT(ApplQueueAction);
DEFINE_NUMINGROUP(NoAltMDSource);
DEFINE_STRING(AltMDSourceID);
DEFINE_STRING(SecondaryTradeReportID);
DEFINE_INT(AvgPxIndicator);
DEFINE_STRING(TradeLinkID);
DEFINE_STRING(OrderInputDevice);
DEFINE_STRING(UnderlyingTradingSessionID);
DEFINE_STRING(UnderlyingTradingSessionSubID);
DEFINE_STRING(TradeLegRefID);
DEFINE_STRING(ExchangeRule);
DEFINE_INT(TradeAllocIndicator);
DEFINE_INT(ExpirationCycle);
DEFINE_INT(TrdType);
DEFINE_INT(TrdSubType);
DEFINE_STRING(TransferReason);
DEFINE_INT(TotNumAssignmentReports);
DEFINE_STRING(AsgnRptID);
DEFINE_PRICEOFFSET(ThresholdAmount);
DEFINE_INT(PegMoveType);
DEFINE_INT(PegOffsetType);
DEFINE_INT(PegLimitType);
DEFINE_INT(PegRoundDirection);
DEFINE_PRICE(PeggedPrice);
DEFINE_INT(PegScope);
DEFINE_INT(DiscretionMoveType);
DEFINE_INT(DiscretionOffsetType);
DEFINE_INT(DiscretionLimitType);
DEFINE_INT(DiscretionRoundDirection);
DEFINE_PRICE(DiscretionPrice);
DEFINE_INT(DiscretionScope);
DEFINE_INT(TargetStrategy);
DEFINE_STRING(TargetStrategyParameters);
DEFINE_PERCENTAGE(ParticipationRate);
DEFINE_FLOAT(TargetStrategyPerformance);
DEFINE_INT(LastLiquidityInd);
DEFINE_BOOLEAN(PublishTrdIndicator);
DEFINE_INT(ShortSaleReason);
DEFINE_INT(QtyType);
DEFINE_INT(SecondaryTrdType);
DEFINE_INT(TradeReportType);
DEFINE_INT(AllocNoOrdersType);
DEFINE_AMT(SharedCommission);
DEFINE_STRING(ConfirmReqID);
DEFINE_PRICE(AvgParPx);
DEFINE_PRICE(ReportedPx);
DEFINE_NUMINGROUP(NoCapacities);
DEFINE_QTY(OrderCapacityQty);
DEFINE_NUMINGROUP(NoEvents);
DEFINE_INT(EventType);
DEFINE_LOCALMKTDATE(EventDate);
DEFINE_PRICE(EventPx);
DEFINE_STRING(EventText);
DEFINE_PERCENTAGE(PctAtRisk);
DEFINE_NUMINGROUP(NoInstrAttrib);
DEFINE_INT(InstrAttribType);
DEFINE_STRING(InstrAttribValue);
DEFINE_LOCALMKTDATE(DatedDate);
DEFINE_LOCALMKTDATE(InterestAccrualDate);
DEFINE_INT(CPProgram);
DEFINE_STRING(CPRegType);
DEFINE_INT(UnderlyingCPProgram);
DEFINE_STRING(UnderlyingCPRegType);
DEFINE_QTY(UnderlyingQty);
DEFINE_STRING(TrdMatchID);
DEFINE_STRING(SecondaryTradeReportRefID);
DEFINE_PRICE(UnderlyingDirtyPrice);
DEFINE_PRICE(UnderlyingEndPrice);
DEFINE_AMT(UnderlyingStartValue);
DEFINE_AMT(UnderlyingCurrentValue);
DEFINE_AMT(UnderlyingEndValue);
DEFINE_NUMINGROUP(NoUnderlyingStips);
DEFINE_STRING(UnderlyingStipType);
DEFINE_STRING(UnderlyingStipValue);
DEFINE_AMT(MaturityNetMoney);
DEFINE_INT(MiscFeeBasis);
DEFINE_INT(TotNoAllocs);
DEFINE_BOOLEAN(LastFragment);
DEFINE_STRING(CollReqID);
DEFINE_INT(CollAsgnReason);
DEFINE_INT(CollInquiryQualifier);
DEFINE_NUMINGROUP(NoTrades);
DEFINE_PERCENTAGE(MarginRatio);
DEFINE_AMT(MarginExcess);
DEFINE_AMT(TotalNetValue);
DEFINE_AMT(CashOutstanding);
DEFINE_STRING(CollAsgnID);
DEFINE_INT(CollAsgnTransType);
DEFINE_STRING(CollRespID);
DEFINE_INT(CollAsgnRespType);
DEFINE_INT(CollAsgnRejectReason);
DEFINE_STRING(CollAsgnRefID);
DEFINE_STRING(CollRptID);
DEFINE_STRING(CollInquiryID);
DEFINE_INT(CollStatus);
DEFINE_INT(TotNumReports);
DEFINE_BOOLEAN(LastRptRequested);
DEFINE_STRING(AgreementDesc);
DEFINE_STRING(AgreementID);
DEFINE_LOCALMKTDATE(AgreementDate);
DEFINE_LOCALMKTDATE(StartDate);
DEFINE_LOCALMKTDATE(EndDate);
DEFINE_CURRENCY(AgreementCurrency);
DEFINE_INT(DeliveryType);
DEFINE_AMT(EndAccruedInterestAmt);
DEFINE_AMT(StartCash);
DEFINE_AMT(EndCash);
DEFINE_STRING(UserRequestID);
DEFINE_INT(UserRequestType);
DEFINE_INT(UserStatus);
DEFINE_STRING(UserStatusText);
DEFINE_INT(StatusValue);
DEFINE_STRING(StatusText);
DEFINE_STRING(RefCompID);
DEFINE_STRING(RefSubID);
DEFINE_STRING(NetworkResponseID);
DEFINE_STRING(NetworkRequestID);
DEFINE_STRING(LastNetworkResponseID);
DEFINE_INT(NetworkRequestType);
DEFINE_NUMINGROUP(NoCompIDs);
DEFINE_INT(NetworkStatusResponseType);
DEFINE_NUMINGROUP(NoCollInquiryQualifier);
DEFINE_INT(TrdRptStatus);
DEFINE_INT(AffirmStatus);
DEFINE_CURRENCY(UnderlyingStrikeCurrency);
DEFINE_CURRENCY(LegStrikeCurrency);
DEFINE_STRING(TimeBracket);
DEFINE_INT(CollAction);
DEFINE_INT(CollInquiryStatus);
DEFINE_INT(CollInquiryResult);
DEFINE_CURRENCY(StrikeCurrency);
DEFINE_NUMINGROUP(NoNested3PartyIDs);
DEFINE_STRING(Nested3PartyID);
DEFINE_CHAR(Nested3PartyIDSource);
DEFINE_INT(Nested3PartyRole);
DEFINE_NUMINGROUP(NoNested3PartySubIDs);
DEFINE_STRING(Nested3PartySubID);
DEFINE_INT(Nested3PartySubIDType);
DEFINE_MONTHYEAR(LegContractSettlMonth);
DEFINE_LOCALMKTDATE(LegInterestAccrualDate);
DEFINE_QTY(LegOrderQty);
DEFINE_NUMINGROUP(NoStrategyParameters);
DEFINE_STRING(StrategyParameterName);
DEFINE_INT(StrategyParameterType);
DEFINE_STRING(StrategyParameterValue);
DEFINE_STRING(HostCrossID);
DEFINE_UTCTIMESTAMP(SideTimeInForce);
DEFINE_INT(MDReportID);
DEFINE_INT(SecurityReportID);
DEFINE_STRING(SecurityStatus);
DEFINE_STRING(SettleOnOpenFlag);
DEFINE_FLOAT(StrikeMultiplier);
DEFINE_FLOAT(StrikeValue);
DEFINE_FLOAT(MinPriceIncrement);
DEFINE_INT(PositionLimit);
DEFINE_INT(NTPositionLimit);
DEFINE_PERCENTAGE(UnderlyingAllocationPercent);
DEFINE_AMT(UnderlyingCashAmount);
DEFINE_STRING(UnderlyingCashType);
DEFINE_INT(UnderlyingSettlementType);
DEFINE_LOCALMKTDATE(QuantityDate);
DEFINE_STRING(ContIntRptID);
DEFINE_BOOLEAN(LateIndicator);
DEFINE_STRING(InputSource);
DEFINE_CHAR(SecurityUpdateAction);
DEFINE_NUMINGROUP(NoExpiration);
DEFINE_INT(ExpType);
DEFINE_QTY(ExpQty);
DEFINE_NUMINGROUP(NoUnderlyingAmounts);
DEFINE_AMT(UnderlyingPayAmount);
DEFINE_AMT(UnderlyingCollectAmount);
DEFINE_LOCALMKTDATE(UnderlyingSettlementDate);
DEFINE_STRING(UnderlyingSettlementStatus);
DEFINE_STRING(SecondaryIndividualAllocID);
DEFINE_STRING(LegReportID);
DEFINE_PRICE(RndPx);
DEFINE_INT(IndividualAllocType);
DEFINE_STRING(AllocCustomerCapacity);
DEFINE_STRING(TierCode);
DEFINE_STRING(UnitofMeasure);
DEFINE_STRING(TimeUnit);
DEFINE_STRING(UnderlyingUnitofMeasure);
DEFINE_STRING(LegUnitofMeasure);
DEFINE_STRING(UnderlyingTimeUnit);
DEFINE_STRING(LegTimeUnit);
DEFINE_INT(AllocMethod);
DEFINE_STRING(TradeID);
DEFINE_STRING(SideTradeReportID);
DEFINE_STRING(SideFillStationCd);
DEFINE_STRING(SideReasonCd);
DEFINE_INT(SideTrdSubTyp);
DEFINE_INT(SideQty);
DEFINE_STRING(MessageEventSource);
DEFINE_UTCTIMESTAMP(SideTrdRegTimestamp);
DEFINE_INT(SideTrdRegTimestampType);
DEFINE_STRING(SideTrdRegTimestampSrc);
DEFINE_CHAR(AsOfIndicator);
DEFINE_NUMINGROUP(NoSideTrdRegTS);
DEFINE_FLOAT(LegOptionRatio);
DEFINE_NUMINGROUP(NoInstrumentParties);
DEFINE_STRING(InstrumentPartyID);
DEFINE_QTY(TradeVolume);
DEFINE_INT(MDBookType);
DEFINE_STRING(MDFeedType);
DEFINE_INT(MDPriceLevel);
DEFINE_INT(MDOriginType);
DEFINE_PRICE(FirstPx);
DEFINE_FLOAT(MDEntrySpotRate);
DEFINE_PRICEOFFSET(MDEntryForwardPoints);
DEFINE_BOOLEAN(ManualOrderIndicator);
DEFINE_BOOLEAN(CustDirectedOrder);
DEFINE_STRING(ReceivedDeptID);
DEFINE_MULTIPLESTRINGVALUE(CustOrderHandlingInst);
DEFINE_INT(OrderHandlingInstSource);
DEFINE_STRING(DeskType);
DEFINE_INT(DeskTypeSource);
DEFINE_MULTIPLESTRINGVALUE(DeskOrderHandlingInst);
DEFINE_CHAR(ExecAckStatus);
DEFINE_AMT(UnderlyingDeliveryAmount);
DEFINE_AMT(UnderlyingCapValue);
DEFINE_STRING(UnderlyingSettlMethod);
DEFINE_STRING(SecondaryTradeID);
DEFINE_STRING(FirmTradeID);
DEFINE_STRING(SecondaryFirmTradeID);
DEFINE_INT(CollApplType);
DEFINE_QTY(UnderlyingAdjustedQuantity);
DEFINE_FLOAT(UnderlyingFXRate);
DEFINE_CHAR(UnderlyingFXRateCalc);
DEFINE_CHAR(AllocPositionEffect);
DEFINE_CHAR(DealingCapacity);
DEFINE_CHAR(InstrmtAssignmentMethod);
DEFINE_CHAR(InstrumentPartyIDSource);
DEFINE_INT(InstrumentPartyRole);
DEFINE_NUMINGROUP(NoInstrumentPartySubIDs);
DEFINE_STRING(InstrumentPartySubID);
DEFINE_INT(InstrumentPartySubIDType);
DEFINE_STRING(PositionCurrency);
DEFINE_QTY(CalculatedCcyLastQty);
DEFINE_BOOLEAN(AggressorIndicator);
DEFINE_NUMINGROUP(NoUndlyInstrumentParties);
DEFINE_STRING(UndlyInstrumentPartyID);
DEFINE_CHAR(UndlyInstrumentPartyIDSource);
DEFINE_INT(UndlyInstrumentPartyRole);
DEFINE_NUMINGROUP(NoUndlyInstrumentPartySubIDs);
DEFINE_STRING(UndlyInstrumentPartySubID);
DEFINE_INT(UndlyInstrumentPartySubIDType);
DEFINE_PRICEOFFSET(BidSwapPoints);
DEFINE_PRICEOFFSET(OfferSwapPoints);
DEFINE_PRICEOFFSET(LegBidForwardPoints);
DEFINE_PRICEOFFSET(LegOfferForwardPoints);
DEFINE_PRICEOFFSET(SwapPoints);
DEFINE_INT(MDQuoteType);
DEFINE_PRICEOFFSET(LastSwapPoints);
DEFINE_AMT(SideGrossTradeAmt);
DEFINE_PRICEOFFSET(LegLastForwardPoints);
DEFINE_QTY(LegCalculatedCcyLastQty);
DEFINE_AMT(LegGrossTradeAmt);
DEFINE_TZTIMEONLY(MaturityTime);
DEFINE_STRING(RefOrderID);
DEFINE_CHAR(RefOrderIDSource);
DEFINE_QTY(SecondaryDisplayQty);
DEFINE_CHAR(DisplayWhen);
DEFINE_CHAR(DisplayMethod);
DEFINE_QTY(DisplayLowQty);
DEFINE_QTY(DisplayHighQty);
DEFINE_QTY(DisplayMinIncr);
DEFINE_QTY(RefreshQty);
DEFINE_QTY(MatchIncrement);
DEFINE_INT(MaxPriceLevels);
DEFINE_BOOLEAN(PreTradeAnonymity);
DEFINE_CHAR(PriceProtectionScope);
DEFINE_CHAR(LotType);
DEFINE_INT(PegPriceType);
DEFINE_PRICE(PeggedRefPrice);
DEFINE_STRING(PegSecurityIDSource);
DEFINE_STRING(PegSecurityID);
DEFINE_STRING(PegSymbol);
DEFINE_STRING(PegSecurityDesc);
DEFINE_CHAR(TriggerType);
DEFINE_CHAR(TriggerAction);
DEFINE_PRICE(TriggerPrice);
DEFINE_STRING(TriggerSymbol);
DEFINE_STRING(TriggerSecurityID);
DEFINE_STRING(TriggerSecurityIDSource);
DEFINE_STRING(TriggerSecurityDesc);
DEFINE_CHAR(TriggerPriceType);
DEFINE_CHAR(TriggerPriceTypeScope);
DEFINE_CHAR(TriggerPriceDirection);
DEFINE_PRICE(TriggerNewPrice);
DEFINE_CHAR(TriggerOrderType);
DEFINE_QTY(TriggerNewQty);
DEFINE_STRING(TriggerTradingSessionID);
DEFINE_STRING(TriggerTradingSessionSubID);
DEFINE_CHAR(OrderCategory);
DEFINE_NUMINGROUP(NoRootPartyIDs);
DEFINE_STRING(RootPartyID);
DEFINE_CHAR(RootPartyIDSource);
DEFINE_INT(RootPartyRole);
DEFINE_NUMINGROUP(NoRootPartySubIDs);
DEFINE_STRING(RootPartySubID);
DEFINE_INT(RootPartySubIDType);
DEFINE_CHAR(TradeHandlingInstr);
DEFINE_CHAR(OrigTradeHandlingInstr);
DEFINE_LOCALMKTDATE(OrigTradeDate);
DEFINE_STRING(OrigTradeID);
DEFINE_STRING(OrigSecondaryTradeID);
DEFINE_TZTIMESTAMP(TZTransactTime);
DEFINE_CHAR(ExDestinationIDSource);
DEFINE_BOOLEAN(ReportedPxDiff);
DEFINE_STRING(RptSys);
DEFINE_STRING(AllocClearingFeeIndicator);
DEFINE_QTY(DisplayQty);
DEFINE_STRING(ExchangeSpecialInstructions);
DEFINE_INT(ExpirationQtyType);
DEFINE_STRING(UnitOfMeasure);
DEFINE_STRING(UnderlyingUnitOfMeasure);
DEFINE_STRING(LegUnitOfMeasure);
DEFINE_TZTIMEONLY(UnderlyingMaturityTime);
DEFINE_TZTIMEONLY(LegMaturityTime);
DEFINE_QTY(MaxTradeVol);
DEFINE_NUMINGROUP(NoMDFeedTypes);
DEFINE_STRING(MatchAlgorithm);
DEFINE_FLOAT(MaxPriceVariation);
DEFINE_INT(ImpliedMarketIndicator);
DEFINE_UTCTIMESTAMP(EventTime);
DEFINE_AMT(MinPriceIncrementAmount);
DEFINE_QTY(UnitOfMeasureQty);
DEFINE_PRICE(LowLimitPrice);
DEFINE_PRICE(HighLimitPrice);
DEFINE_PRICE(TradingReferencePrice);
DEFINE_STRING(SecurityGroup);
DEFINE_INT(LegNumber);
DEFINE_INT(SettlementCycleNo);
DEFINE_CURRENCY(SideCurrency);
DEFINE_CURRENCY(SideSettlCurrency);
DEFINE_AMT(CcyAmt);
DEFINE_NUMINGROUP(NoSettlDetails);
DEFINE_INT(SettlObligMode);
DEFINE_STRING(SettlObligMsgID);
DEFINE_STRING(SettlObligID);
DEFINE_CHAR(SettlObligTransType);
DEFINE_STRING(SettlObligRefID);
DEFINE_CHAR(SettlObligSource);
DEFINE_NUMINGROUP(NoSettlOblig);
DEFINE_STRING(QuoteMsgID);
DEFINE_INT(QuoteEntryStatus);
DEFINE_INT(TotNoCxldQuotes);
DEFINE_INT(TotNoAccQuotes);
DEFINE_INT(TotNoRejQuotes);
DEFINE_BOOLEAN(PrivateQuote);
DEFINE_INT(RespondentType);
DEFINE_INT(MDSubBookType);
DEFINE_INT(SecurityTradingEvent);
DEFINE_NUMINGROUP(NoStatsIndicators);
DEFINE_INT(StatsType);
DEFINE_NUMINGROUP(NoOfSecSizes);
DEFINE_INT(MDSecSizeType);
DEFINE_QTY(MDSecSize);
DEFINE_STRING(ApplID);
DEFINE_SEQNUM(ApplSeqNum);
DEFINE_SEQNUM(ApplBegSeqNum);
DEFINE_SEQNUM(ApplEndSeqNum);
DEFINE_LENGTH(SecurityXMLLen);
DEFINE_XMLDATA(SecurityXML);
DEFINE_STRING(SecurityXMLSchema);
DEFINE_BOOLEAN(RefreshIndicator);
DEFINE_FLOAT(Volatility);
DEFINE_FLOAT(TimeToExpiration);
DEFINE_FLOAT(RiskFreeRate);
DEFINE_STRING(PriceUnitOfMeasure);
DEFINE_QTY(PriceUnitOfMeasureQty);
DEFINE_STRING(SettlMethod);
DEFINE_INT(ExerciseStyle);
DEFINE_INT(UnderlyingExerciseStyle);
DEFINE_INT(LegExerciseStyle);
DEFINE_AMT(OptPayAmount);
DEFINE_STRING(PriceQuoteMethod);
DEFINE_STRING(FuturesValuationMethod);
DEFINE_INT(ListMethod);
DEFINE_PRICE(CapPrice);
DEFINE_PRICE(FloorPrice);
DEFINE_NUMINGROUP(NoStrikeRules);
DEFINE_PRICE(StartStrikePxRange);
DEFINE_PRICE(EndStrikePxRange);
DEFINE_FLOAT(StrikeIncrement);
DEFINE_NUMINGROUP(NoTickRules);
DEFINE_PRICE(StartTickPriceRange);
DEFINE_PRICE(EndTickPriceRange);
DEFINE_PRICE(TickIncrement);
DEFINE_INT(TickRuleType);
DEFINE_INT(NestedInstrAttribType);
DEFINE_STRING(NestedInstrAttribValue);
DEFINE_STRING(DerivativeSymbol);
DEFINE_STRING(DerivativeSymbolSfx);
DEFINE_STRING(DerivativeSecurityID);
DEFINE_STRING(DerivativeSecurityIDSource);
DEFINE_NUMINGROUP(NoDerivativeSecurityAltID);
DEFINE_STRING(DerivativeSecurityAltID);
DEFINE_STRING(DerivativeSecurityAltIDSource);
DEFINE_PRICE(SecondaryLowLimitPrice);
DEFINE_PRICE(SecondaryHighLimitPrice);
DEFINE_STRING(MaturityRuleID);
DEFINE_STRING(StrikeRuleID);
DEFINE_AMT(DerivativeOptPayAmount);
DEFINE_MONTHYEAR(EndMaturityMonthYear);
DEFINE_STRING(ProductComplex);
DEFINE_STRING(DerivativeProductComplex);
DEFINE_INT(MaturityMonthYearIncrement);
DEFINE_QTY(MinLotSize);
DEFINE_NUMINGROUP(NoExecInstRules);
DEFINE_NUMINGROUP(NoLotTypeRules);
DEFINE_NUMINGROUP(NoMatchRules);
DEFINE_NUMINGROUP(NoMaturityRules);
DEFINE_NUMINGROUP(NoOrdTypeRules);
DEFINE_NUMINGROUP(NoTimeInForceRules);
DEFINE_PRICE(SecondaryTradingReferencePrice);
DEFINE_MONTHYEAR(StartMaturityMonthYear);
DEFINE_BOOLEAN(FlexProductEligibilityIndicator);
DEFINE_BOOLEAN(DerivFlexProductEligibilityIndicator);
DEFINE_BOOLEAN(FlexibleIndicator);
DEFINE_CURRENCY(TradingCurrency);
DEFINE_INT(DerivativeProduct);
DEFINE_STRING(DerivativeSecurityGroup);
DEFINE_STRING(DerivativeCFICode);
DEFINE_STRING(DerivativeSecurityType);
DEFINE_STRING(DerivativeSecuritySubType);
DEFINE_MONTHYEAR(DerivativeMaturityMonthYear);
DEFINE_LOCALMKTDATE(DerivativeMaturityDate);
DEFINE_TZTIMEONLY(DerivativeMaturityTime);
DEFINE_STRING(DerivativeSettleOnOpenFlag);
DEFINE_CHAR(DerivativeInstrmtAssignmentMethod);
DEFINE_STRING(DerivativeSecurityStatus);
DEFINE_STRING(DerivativeInstrRegistry);
DEFINE_COUNTRY(DerivativeCountryOfIssue);
DEFINE_STRING(DerivativeStateOrProvinceOfIssue);
DEFINE_STRING(DerivativeLocaleOfIssue);
DEFINE_PRICE(DerivativeStrikePrice);
DEFINE_CURRENCY(DerivativeStrikeCurrency);
DEFINE_FLOAT(DerivativeStrikeMultiplier);
DEFINE_FLOAT(DerivativeStrikeValue);
DEFINE_CHAR(DerivativeOptAttribute);
DEFINE_FLOAT(DerivativeContractMultiplier);
DEFINE_FLOAT(DerivativeMinPriceIncrement);
DEFINE_AMT(DerivativeMinPriceIncrementAmount);
DEFINE_STRING(DerivativeUnitOfMeasure);
DEFINE_QTY(DerivativeUnitOfMeasureQty);
DEFINE_STRING(DerivativeTimeUnit);
DEFINE_EXCHANGE(DerivativeSecurityExchange);
DEFINE_INT(DerivativePositionLimit);
DEFINE_INT(DerivativeNTPositionLimit);
DEFINE_STRING(DerivativeIssuer);
DEFINE_LOCALMKTDATE(DerivativeIssueDate);
DEFINE_LENGTH(DerivativeEncodedIssuerLen);
DEFINE_DATA(DerivativeEncodedIssuer);
DEFINE_STRING(DerivativeSecurityDesc);
DEFINE_LENGTH(DerivativeEncodedSecurityDescLen);
DEFINE_DATA(DerivativeEncodedSecurityDesc);
DEFINE_LENGTH(DerivativeSecurityXMLLen);
DEFINE_XMLDATA(DerivativeSecurityXML);
DEFINE_STRING(DerivativeSecurityXMLSchema);
DEFINE_MONTHYEAR(DerivativeContractSettlMonth);
DEFINE_NUMINGROUP(NoDerivativeEvents);
DEFINE_INT(DerivativeEventType);
DEFINE_LOCALMKTDATE(DerivativeEventDate);
DEFINE_UTCTIMESTAMP(DerivativeEventTime);
DEFINE_PRICE(DerivativeEventPx);
DEFINE_STRING(DerivativeEventText);
DEFINE_NUMINGROUP(NoDerivativeInstrumentParties);
DEFINE_STRING(DerivativeInstrumentPartyID);
DEFINE_CHAR(DerivativeInstrumentPartyIDSource);
DEFINE_INT(DerivativeInstrumentPartyRole);
DEFINE_NUMINGROUP(NoDerivativeInstrumentPartySubIDs);
DEFINE_STRING(DerivativeInstrumentPartySubID);
DEFINE_INT(DerivativeInstrumentPartySubIDType);
DEFINE_INT(DerivativeExerciseStyle);
DEFINE_STRING(MarketSegmentID);
DEFINE_EXCHANGE(MarketID);
DEFINE_INT(MaturityMonthYearIncrementUnits);
DEFINE_INT(MaturityMonthYearFormat);
DEFINE_INT(StrikeExerciseStyle);
DEFINE_INT(SecondaryPriceLimitType);
DEFINE_INT(PriceLimitType);
DEFINE_MULTIPLECHARVALUE(ExecInstValue);
DEFINE_NUMINGROUP(NoTradingSessionRules);
DEFINE_NUMINGROUP(NoMarketSegments);
DEFINE_NUMINGROUP(NoDerivativeInstrAttrib);
DEFINE_NUMINGROUP(NoNestedInstrAttrib);
DEFINE_INT(DerivativeInstrAttribType);
DEFINE_STRING(DerivativeInstrAttribValue);
DEFINE_STRING(DerivativePriceUnitOfMeasure);
DEFINE_QTY(DerivativePriceUnitOfMeasureQty);
DEFINE_STRING(DerivativeSettlMethod);
DEFINE_STRING(DerivativePriceQuoteMethod);
DEFINE_STRING(DerivativeFuturesValuationMethod);
DEFINE_INT(DerivativeListMethod);
DEFINE_PRICE(DerivativeCapPrice);
DEFINE_PRICE(DerivativeFloorPrice);
DEFINE_INT(DerivativePutOrCall);
DEFINE_CHAR(ListUpdateAction);
DEFINE_INT(LegPutOrCall);
DEFINE_QTY(LegUnitOfMeasureQty);
DEFINE_STRING(LegPriceUnitOfMeasure);
DEFINE_QTY(LegPriceUnitOfMeasureQty);
DEFINE_QTY(UnderlyingUnitOfMeasureQty);
DEFINE_STRING(UnderlyingPriceUnitOfMeasure);
DEFINE_QTY(UnderlyingPriceUnitOfMeasureQty);
DEFINE_STRING(MarketReqID);
DEFINE_STRING(MarketReportID);
DEFINE_CHAR(MarketUpdateAction);
DEFINE_STRING(MarketSegmentDesc);
DEFINE_LENGTH(EncodedMktSegmDescLen);
DEFINE_DATA(EncodedMktSegmDesc);
DEFINE_STRING(ParentMktSegmID);
DEFINE_STRING(TradingSessionDesc);
DEFINE_CHAR(TradSesUpdateAction);
DEFINE_STRING(RejectText);
DEFINE_FLOAT(FeeMultiplier);
DEFINE_STRING(UnderlyingLegSymbol);
DEFINE_STRING(UnderlyingLegSymbolSfx);
DEFINE_STRING(UnderlyingLegSecurityID);
DEFINE_STRING(UnderlyingLegSecurityIDSource);
DEFINE_NUMINGROUP(NoUnderlyingLegSecurityAltID);
DEFINE_STRING(UnderlyingLegSecurityAltID);
DEFINE_STRING(UnderlyingLegSecurityAltIDSource);
DEFINE_STRING(UnderlyingLegSecurityType);
DEFINE_STRING(UnderlyingLegSecuritySubType);
DEFINE_MONTHYEAR(UnderlyingLegMaturityMonthYear);
DEFINE_INT(UnderlyingLegPutOrCall);
DEFINE_PRICE(UnderlyingLegStrikePrice);
DEFINE_STRING(UnderlyingLegSecurityExchange);
DEFINE_NUMINGROUP(NoOfLegUnderlyings);
DEFINE_STRING(UnderlyingLegCFICode);
DEFINE_LOCALMKTDATE(UnderlyingLegMaturityDate);
DEFINE_TZTIMEONLY(UnderlyingLegMaturityTime);
DEFINE_CHAR(UnderlyingLegOptAttribute);
DEFINE_STRING(UnderlyingLegSecurityDesc);
DEFINE_BOOLEAN(DefaultVerIndicator);
DEFINE_NUMINGROUP(NoUsernames);
DEFINE_CURRENCY(LegAllocSettlCurrency);
DEFINE_INT(TotNoFills);
DEFINE_NUMINGROUP(NoFills);
DEFINE_STRING(FillExecID);
DEFINE_PRICE(FillPx);
DEFINE_QTY(FillQty);
DEFINE_STRING(LegAllocID);
DEFINE_INT(TradSesEvent);
DEFINE_STRING(MassActionReportID);
DEFINE_NUMINGROUP(NoNotAffectedOrders);
DEFINE_STRING(NotAffectedOrderID);
DEFINE_STRING(NotAffOrigClOrdID);
DEFINE_INT(MassActionType);
DEFINE_INT(MassActionScope);
DEFINE_INT(MassActionResponse);
DEFINE_INT(MassActionRejectReason);
DEFINE_INT(MultilegModel);
DEFINE_INT(MultilegPriceMethod);
DEFINE_FLOAT(LegVolatility);
DEFINE_PERCENTAGE(DividendYield);
DEFINE_PERCENTAGE(LegDividendYield);
DEFINE_FLOAT(CurrencyRatio);
DEFINE_FLOAT(LegCurrencyRatio);
DEFINE_MULTIPLECHARVALUE(LegExecInst);
DEFINE_INT(ContingencyType);
DEFINE_INT(ListRejectReason);
DEFINE_NUMINGROUP(NoTrdRepIndicators);
DEFINE_INT(TrdRepPartyRole);
DEFINE_BOOLEAN(TrdRepIndicator);
DEFINE_INT(TradePublishIndicator);
DEFINE_STRING(ApplReqID);
DEFINE_INT(ApplReqType);
DEFINE_INT(ApplResponseType);
DEFINE_INT(ApplTotalMessageCount);
DEFINE_SEQNUM(ApplLastSeqNum);
DEFINE_NUMINGROUP(NoApplIDs);
DEFINE_BOOLEAN(ApplResendFlag);
DEFINE_STRING(ApplResponseID);
DEFINE_INT(ApplResponseError);
DEFINE_STRING(RefApplID);
DEFINE_STRING(ApplReportID);
DEFINE_SEQNUM(RefApplLastSeqNum);
DEFINE_SEQNUM(ApplNewSeqNum);
DEFINE_INT(ApplReportType);
DEFINE_INT(Nested4PartySubIDType);
DEFINE_STRING(Nested4PartySubID);
DEFINE_NUMINGROUP(NoNested4PartySubIDs);
DEFINE_NUMINGROUP(NoNested4PartyIDs);
DEFINE_STRING(Nested4PartyID);
DEFINE_CHAR(Nested4PartyIDSource);
DEFINE_INT(Nested4PartyRole);
DEFINE_QTY(LegLastQty);
DEFINE_INT(HaltReasonInt);
DEFINE_INT(SideTrdSubType);
DEFINE_QTY(SideLastQty);
DEFINE_STRING(UnderlyingInstrumentPartyID);
DEFINE_CHAR(UnderlyingInstrumentPartyIDSource);
DEFINE_INT(UnderlyingInstrumentPartyRole);
DEFINE_STRING(UnderlyingInstrumentPartySubID);
DEFINE_INT(UnderlyingInstrumentPartySubIDType);
DEFINE_AMT(OptPayoutAmount);
DEFINE_STRING(ValuationMethod);
DEFINE_STRING(DerivativeValuationMethod);
DEFINE_STRING(SideExecID);
DEFINE_INT(OrderDelay);
DEFINE_INT(OrderDelayUnit);
DEFINE_CHAR(VenueType);
DEFINE_INT(RefOrdIDReason);
DEFINE_INT(OrigCustOrderCapacity);
DEFINE_STRING(RefApplReqID);
DEFINE_INT(ModelType);
DEFINE_INT(ContractMultiplierUnit);
DEFINE_INT(LegContractMultiplierUnit);
DEFINE_INT(UnderlyingContractMultiplierUnit);
DEFINE_INT(DerivativeContractMultiplierUnit);
DEFINE_INT(FlowScheduleType);
DEFINE_INT(LegFlowScheduleType);
DEFINE_INT(UnderlyingFlowScheduleType);
DEFINE_INT(DerivativeFlowScheduleType);
DEFINE_INT(FillLiquidityInd);
DEFINE_INT(SideLiquidityInd);
DEFINE_NUMINGROUP(NoRateSources);
DEFINE_INT(RateSource);
DEFINE_INT(RateSourceType);
DEFINE_STRING(ReferencePage);
DEFINE_STRING(RestructuringType);
DEFINE_STRING(Seniority);
DEFINE_PERCENTAGE(NotionalPercentageOutstanding);
DEFINE_PERCENTAGE(OriginalNotionalPercentageOutstanding);
DEFINE_STRING(UnderlyingRestructuringType);
DEFINE_STRING(UnderlyingSeniority);
DEFINE_PERCENTAGE(UnderlyingNotionalPercentageOutstanding);
DEFINE_PERCENTAGE(UnderlyingOriginalNotionalPercentageOutstanding);
DEFINE_PERCENTAGE(AttachmentPoint);
DEFINE_PERCENTAGE(DetachmentPoint);
DEFINE_PERCENTAGE(UnderlyingAttachmentPoint);
DEFINE_PERCENTAGE(UnderlyingDetachmentPoint);
DEFINE_NUMINGROUP(NoTargetPartyIDs);
DEFINE_STRING(TargetPartyID);
DEFINE_CHAR(TargetPartyIDSource);
DEFINE_INT(TargetPartyRole);
DEFINE_STRING(SecurityListID);
DEFINE_STRING(SecurityListRefID);
DEFINE_STRING(SecurityListDesc);
DEFINE_LENGTH(EncodedSecurityListDescLen);
DEFINE_DATA(EncodedSecurityListDesc);
DEFINE_INT(SecurityListType);
DEFINE_INT(SecurityListTypeSource);
DEFINE_STRING(NewsID);
DEFINE_INT(NewsCategory);
DEFINE_LANGUAGE(LanguageCode);
DEFINE_NUMINGROUP(NoNewsRefIDs);
DEFINE_STRING(NewsRefID);
DEFINE_INT(NewsRefType);
DEFINE_INT(StrikePriceDeterminationMethod);
DEFINE_INT(StrikePriceBoundaryMethod);
DEFINE_PERCENTAGE(StrikePriceBoundaryPrecision);
DEFINE_INT(UnderlyingPriceDeterminationMethod);
DEFINE_INT(OptPayoutType);
DEFINE_NUMINGROUP(NoComplexEvents);
DEFINE_INT(ComplexEventType);
DEFINE_AMT(ComplexOptPayoutAmount);
DEFINE_PRICE(ComplexEventPrice);
DEFINE_INT(ComplexEventPriceBoundaryMethod);
DEFINE_PERCENTAGE(ComplexEventPriceBoundaryPrecision);
DEFINE_INT(ComplexEventPriceTimeType);
DEFINE_INT(ComplexEventCondition);
DEFINE_NUMINGROUP(NoComplexEventDates);
DEFINE_UTCDATEONLY(ComplexEventStartDate);
DEFINE_UTCDATEONLY(ComplexEventEndDate);
DEFINE_NUMINGROUP(NoComplexEventTimes);
DEFINE_UTCTIMEONLY(ComplexEventStartTime);
DEFINE_UTCTIMEONLY(ComplexEventEndTime);
DEFINE_STRING(StreamAsgnReqID);
DEFINE_INT(StreamAsgnReqType);
DEFINE_NUMINGROUP(NoAsgnReqs);
DEFINE_STRING(MDStreamID);
DEFINE_STRING(StreamAsgnRptID);
DEFINE_INT(StreamAsgnRejReason);
DEFINE_INT(StreamAsgnAckType);
DEFINE_INT(StreamAsgnType);
DEFINE_UTCTIMESTAMP(RelSymTransactTime);
DEFINE_STRING(FillYieldType);
DEFINE_PERCENTAGE(FillYield);
DEFINE_NUMINGROUP(NoMatchInst);
DEFINE_INT(MatchInst);
DEFINE_TAGNUM(MatchAttribTagID);
DEFINE_STRING(MatchAttribValue);
DEFINE_EXCHANGE(MatchInstMarketID);
DEFINE_INT(TriggerScope);
DEFINE_INT(ExposureDuration);
DEFINE_NUMINGROUP(NoLimitAmts);
DEFINE_INT(LimitAmtType);
DEFINE_AMT(LastLimitAmt);
DEFINE_AMT(LimitAmtRemaining);
DEFINE_CURRENCY(LimitAmtCurrency);
DEFINE_STRING(MarginReqmtInqID);
DEFINE_NUMINGROUP(NoMarginReqmtInqQualifier);
DEFINE_INT(MarginReqmtInqQualifier);
DEFINE_INT(MarginReqmtRptType);
DEFINE_STRING(MarginClass);
DEFINE_INT(MarginReqmtInqStatus);
DEFINE_INT(MarginReqmtInqResult);
DEFINE_STRING(MarginReqmtRptID);
DEFINE_NUMINGROUP(NoMarginAmt);
DEFINE_INT(MarginAmtType);
DEFINE_AMT(MarginAmt);
DEFINE_CURRENCY(MarginAmtCcy);
DEFINE_NUMINGROUP(NoRelatedInstruments);
DEFINE_INT(RelatedInstrumentType);
DEFINE_STRING(RelatedSymbol);
DEFINE_STRING(RelatedSecurityID);
DEFINE_STRING(RelatedSecurityIDSource);
DEFINE_STRING(RelatedSecurityType);
DEFINE_MONTHYEAR(RelatedMaturityMonthYear);
DEFINE_QTY(CoveredQty);
DEFINE_INT(MarketMakerActivity);
DEFINE_STRING(PartyDetailsListRequestID);
DEFINE_NUMINGROUP(NoRequestedPartyRoles);
DEFINE_INT(RequestedPartyRole);
DEFINE_STRING(PartyDetailsListReportID);
DEFINE_INT(RequestResult);
DEFINE_INT(TotNoParties);
DEFINE_NUMINGROUP(NoPartyRelationships);
DEFINE_INT(PartyRelationship);
DEFINE_NUMINGROUP(NoPartyDetailAltID);
DEFINE_STRING(PartyDetailAltID);
DEFINE_CHAR(PartyDetailAltIDSource);
DEFINE_NUMINGROUP(NoPartyDetailAltSubIDs);
DEFINE_STRING(PartyDetailAltSubID);
DEFINE_INT(PartyDetailAltSubIDType);
DEFINE_NUMINGROUP(NoRiskLimitTypes);
DEFINE_INT(RiskLimitType);
DEFINE_AMT(RiskLimitAmount);
DEFINE_CURRENCY(RiskLimitCurrency);
DEFINE_STRING(RiskLimitPlatform);
DEFINE_NUMINGROUP(NoRiskInstrumentScopes);
DEFINE_INT(InstrumentScopeOperator);
DEFINE_STRING(InstrumentScopeSymbol);
DEFINE_STRING(InstrumentScopeSymbolSfx);
DEFINE_STRING(InstrumentScopeSecurityID);
DEFINE_STRING(InstrumentScopeSecurityIDSource);
DEFINE_NUMINGROUP(NoInstrumentScopeSecurityAltID);
DEFINE_STRING(InstrumentScopeSecurityAltID);
DEFINE_STRING(InstrumentScopeSecurityAltIDSource);
DEFINE_INT(InstrumentScopeProduct);
DEFINE_STRING(InstrumentScopeProductComplex);
DEFINE_STRING(InstrumentScopeSecurityGroup);
DEFINE_STRING(InstrumentScopeCFICode);
DEFINE_STRING(InstrumentScopeSecurityType);
DEFINE_STRING(InstrumentScopeSecuritySubType);
DEFINE_MONTHYEAR(InstrumentScopeMaturityMonthYear);
DEFINE_TZTIMEONLY(InstrumentScopeMaturityTime);
DEFINE_STRING(InstrumentScopeRestructuringType);
DEFINE_STRING(InstrumentScopeSeniority);
DEFINE_INT(InstrumentScopePutOrCall);
DEFINE_BOOLEAN(InstrumentScopeFlexibleIndicator);
DEFINE_PERCENTAGE(InstrumentScopeCouponRate);
DEFINE_STRING(InstrumentScopeSecurityDesc);
DEFINE_STRING(InstrumentScopeSettlType);
DEFINE_FLOAT(RiskInstrumentMultiplier);
DEFINE_NUMINGROUP(NoRiskWarningLevels);
DEFINE_PERCENTAGE(RiskWarningLevelPercent);
DEFINE_STRING(RiskWarningLevelName);
DEFINE_NUMINGROUP(NoRelatedPartyDetailID);
DEFINE_STRING(RelatedPartyDetailID);
DEFINE_CHAR(RelatedPartyDetailIDSource);
DEFINE_INT(RelatedPartyDetailRole);
DEFINE_NUMINGROUP(NoRelatedPartyDetailSubIDs);
DEFINE_STRING(RelatedPartyDetailSubID);
DEFINE_INT(RelatedPartyDetailSubIDType);
DEFINE_NUMINGROUP(NoRelatedPartyDetailAltID);
DEFINE_STRING(RelatedPartyDetailAltID);
DEFINE_CHAR(RelatedPartyDetailAltIDSource);
DEFINE_NUMINGROUP(NoRelatedPartyDetailAltSubIDs);
DEFINE_STRING(RelatedPartyDetailAltSubID);
DEFINE_INT(RelatedPartyDetailAltSubIDType);
DEFINE_EXCHANGE(InstrumentScopeSecurityExchange);
DEFINE_LENGTH(InstrumentScopeEncodedSecurityDescLen);
DEFINE_DATA(InstrumentScopeEncodedSecurityDesc);
DEFINE_NUMINGROUP(NoInstrumentScopes);
DEFINE_NUMINGROUP(NoRequestingPartyIDs);
DEFINE_STRING(RequestingPartyID);
DEFINE_CHAR(RequestingPartyIDSource);
DEFINE_INT(RequestingPartyRole);
DEFINE_NUMINGROUP(NoRequestingPartySubIDs);
DEFINE_STRING(RequestingPartySubID);
DEFINE_INT(RequestingPartySubIDType);
DEFINE_LENGTH(EncodedRejectTextLen);
DEFINE_DATA(EncodedRejectText);
DEFINE_STRING(RiskLimitRequestID);
DEFINE_STRING(RiskLimitReportID);
DEFINE_NUMINGROUP(NoRequestedRiskLimitType);
DEFINE_NUMINGROUP(NoRiskLimits);
DEFINE_STRING(RiskLimitID);
DEFINE_NUMINGROUP(NoPartyDetails);
DEFINE_INT(PartyDetailStatus);
DEFINE_INT(PartyDetailRoleQualifier);
DEFINE_INT(RelatedPartyDetailRoleQualifier);
DEFINE_NUMINGROUP(NoPartyUpdates);
DEFINE_NUMINGROUP(NoPartyRiskLimits);
DEFINE_STRING(PartyDetailID);
DEFINE_CHAR(PartyDetailIDSource);
DEFINE_INT(PartyDetailRole);
DEFINE_NUMINGROUP(NoPartyDetailSubIDs);
DEFINE_STRING(PartyDetailSubID);
DEFINE_INT(PartyDetailSubIDType);
DEFINE_INT(SecurityMassTradingStatus);
DEFINE_INT(SecurityMassTradingEvent);
DEFINE_INT(MassHaltReason);
DEFINE_INT(MDSecurityTradingStatus);
DEFINE_STRING(MDSubFeedType);
DEFINE_INT(MDHaltReason);
DEFINE_STRING(SideTradeID);
DEFINE_STRING(SideOrigTradeID);
DEFINE_PRICEOFFSET(DifferentialPrice);
DEFINE_INT(TrdAckStatus);
DEFINE_CURRENCY(PriceQuoteCurrency);
DEFINE_CURRENCY(UnderlyingPriceQuoteCurrency);
DEFINE_CURRENCY(LegPriceQuoteCurrency);
DEFINE_CURRENCY(DerivativePriceQuoteCurrency);
DEFINE_NUMINGROUP(NoSecurityClassifications);
DEFINE_INT(SecurityClassificationReason);
DEFINE_STRING(SecurityClassificationValue);
DEFINE_INT(PosAmtReason);
DEFINE_NUMINGROUP(NoLegPosAmt);
DEFINE_AMT(LegPosAmt);
DEFINE_STRING(LegPosAmtType);
DEFINE_CURRENCY(LegPosCurrency);
DEFINE_INT(LegPosAmtReason);
DEFINE_INT(LegQtyType);
DEFINE_FLOAT(DiscountFactor);
DEFINE_STRING(ParentAllocID);
DEFINE_STRING(LegSecurityGroup);
DEFINE_PRICE(PositionContingentPrice);
DEFINE_PRICE(ClearingTradePrice);
DEFINE_PRICE(SideClearingTradePrice);
DEFINE_INT(SideClearingTradePriceType);
DEFINE_PRICE(SidePriceDifferential);
DEFINE_STRING(FIXEngineName);
DEFINE_STRING(FIXEngineVersion);
DEFINE_STRING(FIXEngineVendor);
DEFINE_STRING(ApplicationSystemName);
DEFINE_STRING(ApplicationSystemVersion);
DEFINE_STRING(ApplicationSystemVendor);
DEFINE_INT(NumOfSimpleInstruments);
DEFINE_INT(SecurityRejectReason);
DEFINE_QTY(InitialDisplayQty);
DEFINE_INT(ThrottleStatus);
DEFINE_NUMINGROUP(NoThrottles);
DEFINE_INT(ThrottleAction);
DEFINE_INT(ThrottleType);
DEFINE_INT(ThrottleNoMsgs);
DEFINE_INT(ThrottleTimeInterval);
DEFINE_INT(ThrottleTimeUnit);
DEFINE_NUMINGROUP(NoThrottleMsgType);
DEFINE_STRING(ThrottleMsgType);
DEFINE_INT(ThrottleInst);
DEFINE_INT(ThrottleCountIndicator);
DEFINE_STRING(AccountSummaryReportID);
DEFINE_NUMINGROUP(NoSettlementAmounts);
DEFINE_AMT(SettlementAmount);
DEFINE_CURRENCY(SettlementAmountCurrency);
DEFINE_NUMINGROUP(NoCollateralAmounts);
DEFINE_AMT(CurrentCollateralAmount);
DEFINE_CURRENCY(CollateralCurrency);
DEFINE_STRING(CollateralType);
DEFINE_NUMINGROUP(NoPayCollects);
DEFINE_AMT(PayAmount);
DEFINE_AMT(CollectAmount);
DEFINE_STRING(PayCollectType);
DEFINE_CURRENCY(PayCollectCurrency);
DEFINE_STRING(PayCollectMarketSegmentID);
DEFINE_STRING(PayCollectMarketID);
DEFINE_STRING(MarginAmountMarketSegmentID);
DEFINE_STRING(MarginAmountMarketID);
DEFINE_STRING(FirmGroupID);
DEFINE_STRING(FirmMnemonic);
DEFINE_STRING(AllocGroupID);
DEFINE_STRING(AvgPxGroupID);
DEFINE_STRING(FirmAllocText);
DEFINE_LENGTH(EncodedFirmAllocTextLen);
DEFINE_DATA(EncodedFirmAllocText);
DEFINE_INT(AllocationRollupInstruction);
DEFINE_QTY(AllocGroupQuantity);
DEFINE_QTY(AllocGroupRemainingQuantity);
DEFINE_INT(AllocReversalStatus);
DEFINE_STRING(ObligationType);
DEFINE_INT(TradePriceNegotiationMethod);
DEFINE_INT(UpfrontPriceType);
DEFINE_PRICE(UpfrontPrice);
DEFINE_PRICE(LastUpfrontPrice);
DEFINE_INT(ShortSaleRestriction);
DEFINE_INT(ShortSaleExemptionReason);
DEFINE_INT(LegShortSaleExemptionReason);
DEFINE_INT(SideShortSaleExemptionReason);
DEFINE_CURRENCY(UnitOfMeasureCurrency);
DEFINE_CURRENCY(PriceUnitOfMeasureCurrency);
DEFINE_CURRENCY(UnderlyingUnitOfMeasureCurrency);
DEFINE_CURRENCY(UnderlyingPriceUnitOfMeasureCurrency);
DEFINE_CURRENCY(LegUnitOfMeasureCurrency);
DEFINE_CURRENCY(LegPriceUnitOfMeasureCurrency);
DEFINE_CURRENCY(DerivativeUnitOfMeasureCurrency);
DEFINE_CURRENCY(DerivativePriceUnitOfMeasureCurrency);
DEFINE_INT(ApplLevelRecoveryIndicator);
DEFINE_STRING(BidMDEntryID);
DEFINE_STRING(OfferMDEntryID);
DEFINE_STRING(BidQuoteID);
DEFINE_STRING(OfferQuoteID);
DEFINE_QTY(TotalBidSize);
DEFINE_QTY(TotalOfferSize);
DEFINE_STRING(SecondaryQuoteID);
DEFINE_STRING(CustodialLotID);
DEFINE_LOCALMKTDATE(VersusPurchaseDate);
DEFINE_PRICE(VersusPurchasePrice);
DEFINE_AMT(CurrentCostBasis);
DEFINE_STRING(LegCustodialLotID);
DEFINE_LOCALMKTDATE(LegVersusPurchaseDate);
DEFINE_PRICE(LegVersusPurchasePrice);
DEFINE_AMT(LegCurrentCostBasis);
DEFINE_INT(RiskLimitRequestType);
DEFINE_INT(RiskLimitRequestResult);
DEFINE_INT(RiskLimitRequestStatus);
DEFINE_INT(RiskLimitStatus);
DEFINE_INT(RiskLimitResult);
DEFINE_PERCENTAGE(RiskLimitUtilizationPercent);
DEFINE_AMT(RiskLimitUtilizationAmount);
DEFINE_INT(RiskLimitAction);
DEFINE_INT(RiskWarningLevelAmount);
DEFINE_INT(RiskWarningLevelAction);
DEFINE_STRING(EntitlementRequestID);
DEFINE_STRING(EntitlementReportID);
DEFINE_NUMINGROUP(NoPartyEntitlements);
DEFINE_NUMINGROUP(NoEntitlements);
DEFINE_BOOLEAN(EntitlementIndicator);
DEFINE_INT(EntitlementType);
DEFINE_STRING(EntitlementID);
DEFINE_NUMINGROUP(NoEntitlementAttrib);
DEFINE_INT(EntitlementAttribType);
DEFINE_INT(EntitlementAttribDatatype);
DEFINE_STRING(EntitlementAttribValue);
DEFINE_CURRENCY(EntitlementAttribCurrency);
DEFINE_LOCALMKTDATE(EntitlementStartDate);
DEFINE_LOCALMKTDATE(EntitlementEndDate);
DEFINE_STRING(EntitlementPlatform);
DEFINE_INT(TradSesControl);
DEFINE_INT(TradeVolType);
DEFINE_INT(RefTickTableID);
DEFINE_STRING(LegID);
DEFINE_NUMINGROUP(NoTargetMarketSegments);
DEFINE_STRING(TargetMarketSegmentID);
DEFINE_NUMINGROUP(NoAffectedMarketSegments);
DEFINE_STRING(AffectedMarketSegmentID);
DEFINE_NUMINGROUP(NoNotAffectedMarketSegments);
DEFINE_STRING(NotAffectedMarketSegmentID);
DEFINE_NUMINGROUP(NoOrderEvents);
DEFINE_INT(OrderEventType);
DEFINE_STRING(OrderEventExecID);
DEFINE_INT(OrderEventReason);
DEFINE_PRICE(OrderEventPx);
DEFINE_QTY(OrderEventQty);
DEFINE_INT(OrderEventLiquidityIndicator);
DEFINE_STRING(OrderEventText);
DEFINE_INT(AuctionType);
DEFINE_PERCENTAGE(AuctionAllocationPct);
DEFINE_INT(AuctionInstruction);
DEFINE_STRING(RefClOrdID);
DEFINE_INT(LockType);
DEFINE_QTY(LockedQty);
DEFINE_QTY(SecondaryLockedQty);
DEFINE_INT(ReleaseInstruction);
DEFINE_QTY(ReleaseQty);
DEFINE_NUMINGROUP(NoDisclosureInstructions);
DEFINE_INT(DisclosureType);
DEFINE_INT(DisclosureInstruction);
DEFINE_INT(TradingCapacity);
DEFINE_INT(ClearingAccountType);
DEFINE_INT(LegClearingAccountType);
DEFINE_INT(TargetPartyRoleQualifier);
DEFINE_PRICE(RelatedHighPrice);
DEFINE_PRICE(RelatedLowPrice);
DEFINE_INT(RelatedPriceSource);
DEFINE_INT(MinQtyMethod);
DEFINE_INT(Triggered);
DEFINE_STRING(AffectedOrigClOrdID);
DEFINE_STRING(NotAffSecondaryOrderID);
DEFINE_NUMINGROUP(NoCrossLegs);
DEFINE_INT(EventTimePeriod);
DEFINE_STRING(EventTimeUnit);
DEFINE_QTY(LastQtyVariance);
DEFINE_INT(OrderOrigination);
DEFINE_STRING(OriginatingDeptID);
DEFINE_STRING(ReceivingDeptID);
DEFINE_STRING(InformationBarrierID);
DEFINE_PRICE(SettlPriceIncrement);
DEFINE_PRICE(SettlPriceSecondaryIncrement);
DEFINE_INT(ClearedIndicator);
DEFINE_INT(ContractRefPosType);
DEFINE_INT(PositionCapacity);
DEFINE_CURRENCY(PosQtyUnitOfMeasureCurrency);
DEFINE_STRING(PosQtyUnitOfMeasure);
DEFINE_MONTHYEAR(UnderlyingContractPriceRefMonth);
DEFINE_NUMINGROUP(NoTradePriceConditions);
DEFINE_INT(TradePriceCondition);
DEFINE_INT(TradeAllocStatus);
DEFINE_NUMINGROUP(NoTradeQtys);
DEFINE_INT(TradeQtyType);
DEFINE_QTY(TradeQty);
DEFINE_NUMINGROUP(NoTradeAllocAmts);
DEFINE_STRING(TradeAllocAmtType);
DEFINE_AMT(TradeAllocAmt);
DEFINE_CURRENCY(TradeAllocCurrency);
DEFINE_INT(TradeAllocGroupInstruction);
DEFINE_INT(OffsetInstruction);
DEFINE_INT(TradeAllocAmtReason);
DEFINE_STRING(StrategyLinkID);
DEFINE_PRICE(SideAvgPx);
DEFINE_INT(SideAvgPxIndicator);
DEFINE_STRING(SideAvgPxGroupID);
DEFINE_NUMINGROUP(NoRelatedTrades);
DEFINE_STRING(RelatedTradeID);
DEFINE_INT(RelatedTradeIDSource);
DEFINE_LOCALMKTDATE(RelatedTradeDate);
DEFINE_EXCHANGE(RelatedTradeMarketID);
DEFINE_QTY(RelatedTradeQuantity);
DEFINE_NUMINGROUP(NoRelatedPositions);
DEFINE_STRING(RelatedPositionID);
DEFINE_INT(RelatedPositionIDSource);
DEFINE_LOCALMKTDATE(RelatedPositionDate);
DEFINE_STRING(OfferID);
DEFINE_NUMINGROUP(NoValueChecks);
DEFINE_INT(ValueCheckType);
DEFINE_INT(ValueCheckAction);
DEFINE_LENGTH(LegSecurityXMLLen);
DEFINE_XMLDATA(LegSecurityXML);
DEFINE_STRING(LegSecurityXMLSchema);
DEFINE_LENGTH(UnderlyingSecurityXMLLen);
DEFINE_XMLDATA(UnderlyingSecurityXML);
DEFINE_STRING(UnderlyingSecurityXMLSchema);
DEFINE_INT(PartyDetailRequestResult);
DEFINE_INT(PartyDetailRequestStatus);
DEFINE_INT(PartyDetailDefinitionStatus);
DEFINE_INT(PartyDetailDefinitionResult);
DEFINE_INT(EntitlementRequestResult);
DEFINE_INT(EntitlementRequestStatus);
DEFINE_INT(EntitlementStatus);
DEFINE_INT(EntitlementResult);
DEFINE_STRING(EntitlementRefID);
DEFINE_STRING(SettlPriceUnitOfMeasure);
DEFINE_CURRENCY(SettlPriceUnitOfMeasureCurrency);
DEFINE_UTCTIMESTAMP(TradeMatchTimestamp);
DEFINE_NUMINGROUP(NoInstrmtMatchSides);
DEFINE_NUMINGROUP(NoTrdMatchSides);
DEFINE_STRING(TrdMatchSubID);
DEFINE_NUMINGROUP(NoLegExecs);
DEFINE_STRING(LegExecID);
DEFINE_STRING(LegTradeID);
DEFINE_STRING(LegTradeReportID);
DEFINE_INT(TradeMatchAckStatus);
DEFINE_INT(TradeMatchRejectReason);
DEFINE_STRING(SideMarketSegmentID);
DEFINE_CHAR(SideVenueType);
DEFINE_STRING(SideExecRefID);
DEFINE_STRING(LegExecRefID);
DEFINE_BOOLEAN(HaircutIndicator);
DEFINE_INT(NumOfCompetitors);
DEFINE_UTCTIMESTAMP(ResponseTime);
DEFINE_UTCTIMESTAMP(QuoteDisplayTime);
DEFINE_INT(ExposureDurationUnit);
DEFINE_PRICE(CoverPrice);
DEFINE_NUMINGROUP(NoClearingAccountTypes);
DEFINE_NUMINGROUP(NoPriceMovements);
DEFINE_NUMINGROUP(NoPriceMovementValues);
DEFINE_FLOAT(PriceMovementValue);
DEFINE_INT(PriceMovementPoint);
DEFINE_INT(PriceMovementType);
DEFINE_LENGTH(EncodedEventTextLen);
DEFINE_DATA(EncodedEventText);
DEFINE_STRING(RegulatoryTradeID);
DEFINE_INT(RegulatoryTradeIDEvent);
DEFINE_STRING(RegulatoryTradeIDSource);
DEFINE_INT(RegulatoryTradeIDType);
DEFINE_NUMINGROUP(NoRegulatoryTradeIDs);
DEFINE_NUMINGROUP(NoAllocRegulatoryTradeIDs);
DEFINE_STRING(AllocRegulatoryTradeID);
DEFINE_STRING(AllocRegulatoryTradeIDSource);
DEFINE_INT(AllocRegulatoryTradeIDEvent);
DEFINE_INT(AllocRegulatoryTradeIDType);
DEFINE_INT(ClearingIntention);
DEFINE_INT(TradeClearingInstruction);
DEFINE_BOOLEAN(BackloadedTradeIndicator);
DEFINE_INT(ConfirmationMethod);
DEFINE_BOOLEAN(MandatoryClearingIndicator);
DEFINE_BOOLEAN(MixedSwapIndicator);
DEFINE_BOOLEAN(OffMarketPriceIndicator);
DEFINE_INT(VerificationMethod);
DEFINE_INT(ClearingRequirementException);
DEFINE_STRING(IRSDirection);
DEFINE_INT(RegulatoryReportType);
DEFINE_BOOLEAN(VoluntaryRegulatoryReport);
DEFINE_INT(TradeCollateralization);
DEFINE_INT(TradeContinuation);
DEFINE_INT(AssetClass);
DEFINE_INT(AssetSubClass);
DEFINE_STRING(AssetType);
DEFINE_STRING(SwapClass);
DEFINE_INT(NthToDefault);
DEFINE_INT(MthToDefault);
DEFINE_STRING(SettledEntityMatrixSource);
DEFINE_LOCALMKTDATE(SettledEntityMatrixPublicationDate);
DEFINE_INT(CouponType);
DEFINE_AMT(TotalIssuedAmount);
DEFINE_INT(CouponFrequencyPeriod);
DEFINE_STRING(CouponFrequencyUnit);
DEFINE_INT(CouponDayCount);
DEFINE_STRING(ConvertibleBondEquityID);
DEFINE_STRING(ConvertibleBondEquityIDSource);
DEFINE_MONTHYEAR(ContractPriceRefMonth);
DEFINE_INT(LienSeniority);
DEFINE_INT(LoanFacility);
DEFINE_INT(ReferenceEntityType);
DEFINE_INT(IndexSeries);
DEFINE_INT(IndexAnnexVersion);
DEFINE_LOCALMKTDATE(IndexAnnexDate);
DEFINE_STRING(IndexAnnexSource);
DEFINE_STRING(AgreementVersion);
DEFINE_STRING(MasterConfirmationDesc);
DEFINE_LOCALMKTDATE(MasterConfirmationDate);
DEFINE_STRING(MasterConfirmationAnnexDesc);
DEFINE_LOCALMKTDATE(MasterConfirmationAnnexDate);
DEFINE_STRING(BrokerConfirmationDesc);
DEFINE_STRING(CreditSupportAgreementDesc);
DEFINE_LOCALMKTDATE(CreditSupportAgreementDate);
DEFINE_STRING(CreditSupportAgreementID);
DEFINE_STRING(GoverningLaw);
DEFINE_NUMINGROUP(NoSideRegulatoryTradeIDs);
DEFINE_STRING(SideRegulatoryTradeID);
DEFINE_STRING(SideRegulatoryTradeIDSource);
DEFINE_INT(SideRegulatoryTradeIDEvent);
DEFINE_INT(SideRegulatoryTradeIDType);
DEFINE_NUMINGROUP(NoSecondaryAssetClasses);
DEFINE_INT(SecondaryAssetClass);
DEFINE_INT(SecondaryAssetSubClass);
DEFINE_STRING(SecondaryAssetType);
DEFINE_INT(BlockTrdAllocIndicator);
DEFINE_NUMINGROUP(NoUnderlyingEvents);
DEFINE_INT(UnderlyingEventType);
DEFINE_LOCALMKTDATE(UnderlyingEventDate);
DEFINE_UTCTIMESTAMP(UnderlyingEventTime);
DEFINE_STRING(UnderlyingEventTimeUnit);
DEFINE_INT(UnderlyingEventTimePeriod);
DEFINE_PRICE(UnderlyingEventPx);
DEFINE_FLOAT(UnderlyingConstituentWeight);
DEFINE_INT(UnderlyingCouponType);
DEFINE_AMT(UnderlyingTotalIssuedAmount);
DEFINE_INT(UnderlyingCouponFrequencyPeriod);
DEFINE_STRING(UnderlyingCouponFrequencyUnit);
DEFINE_INT(UnderlyingCouponDayCount);
DEFINE_STRING(UnderlyingObligationID);
DEFINE_STRING(UnderlyingObligationIDSource);
DEFINE_STRING(UnderlyingEquityID);
DEFINE_STRING(UnderlyingEquityIDSource);
DEFINE_INT(UnderlyingLienSeniority);
DEFINE_INT(UnderlyingLoanFacility);
DEFINE_INT(UnderlyingReferenceEntityType);
DEFINE_XIDREF(UnderlyingProtectionTermXIDRef);
DEFINE_XIDREF(UnderlyingSettlTermXIDRef);
DEFINE_INT(UnderlyingIndexSeries);
DEFINE_INT(UnderlyingIndexAnnexVersion);
DEFINE_LOCALMKTDATE(UnderlyingIndexAnnexDate);
DEFINE_STRING(UnderlyingIndexAnnexSource);
DEFINE_STRING(UnderlyingProductComplex);
DEFINE_STRING(UnderlyingSecurityGroup);
DEFINE_STRING(UnderlyingSettleOnOpenFlag);
DEFINE_CHAR(UnderlyingAssignmentMethod);
DEFINE_STRING(UnderlyingSecurityStatus);
DEFINE_STRING(UnderlyingObligationType);
DEFINE_INT(UnderlyingAssetClass);
DEFINE_INT(UnderlyingAssetSubClass);
DEFINE_STRING(UnderlyingAssetType);
DEFINE_STRING(UnderlyingSwapClass);
DEFINE_INT(UnderlyingNthToDefault);
DEFINE_INT(UnderlyingMthToDefault);
DEFINE_STRING(UnderlyingSettledEntityMatrixSource);
DEFINE_LOCALMKTDATE(UnderlyingSettledEntityMatrixPublicationDate);
DEFINE_FLOAT(UnderlyingStrikeMultiplier);
DEFINE_FLOAT(UnderlyingStrikeValue);
DEFINE_INT(UnderlyingStrikePriceDeterminationMethod);
DEFINE_INT(UnderlyingStrikePriceBoundaryMethod);
DEFINE_PERCENTAGE(UnderlyingStrikePriceBoundaryPrecision);
DEFINE_FLOAT(UnderlyingMinPriceIncrement);
DEFINE_AMT(UnderlyingMinPriceIncrementAmount);
DEFINE_INT(UnderlyingOptPayoutType);
DEFINE_AMT(UnderlyingOptPayoutAmount);
DEFINE_STRING(UnderlyingPriceQuoteMethod);
DEFINE_STRING(UnderlyingValuationMethod);
DEFINE_INT(UnderlyingListMethod);
DEFINE_PRICE(UnderlyingCapPrice);
DEFINE_PRICE(UnderlyingFloorPrice);
DEFINE_BOOLEAN(UnderlyingFlexibleIndicator);
DEFINE_BOOLEAN(UnderlyingFlexProductEligibilityIndicator);
DEFINE_INT(UnderlyingPositionLimit);
DEFINE_INT(UnderlyingNTPositionLimit);
DEFINE_STRING(UnderlyingPool);
DEFINE_MONTHYEAR(UnderlyingContractSettlMonth);
DEFINE_LOCALMKTDATE(UnderlyingDatedDate);
DEFINE_LOCALMKTDATE(UnderlyingInterestAccrualDate);
DEFINE_INT(UnderlyingShortSaleRestriction);
DEFINE_INT(UnderlyingRefTickTableID);
DEFINE_NUMINGROUP(NoUnderlyingComplexEvents);
DEFINE_INT(UnderlyingComplexEventType);
DEFINE_AMT(UnderlyingComplexOptPayoutAmount);
DEFINE_PRICE(UnderlyingComplexEventPrice);
DEFINE_INT(UnderlyingComplexEventPriceBoundaryMethod);
DEFINE_PERCENTAGE(UnderlyingComplexEventPriceBoundaryPrecision);
DEFINE_INT(UnderlyingComplexEventPriceTimeType);
DEFINE_INT(UnderlyingComplexEventCondition);
DEFINE_NUMINGROUP(NoUnderlyingComplexEventDates);
DEFINE_UTCDATEONLY(UnderlyingComplexEventStartDate);
DEFINE_UTCDATEONLY(UnderlyingComplexEventEndDate);
DEFINE_NUMINGROUP(NoUnderlyingComplexEventTimes);
DEFINE_UTCTIMEONLY(UnderlyingComplexEventStartTime);
DEFINE_UTCTIMEONLY(UnderlyingComplexEventEndTime);
DEFINE_NUMINGROUP(NoLegEvents);
DEFINE_INT(LegEventType);
DEFINE_LOCALMKTDATE(LegEventDate);
DEFINE_UTCTIMESTAMP(LegEventTime);
DEFINE_STRING(LegEventTimeUnit);
DEFINE_INT(LegEventTimePeriod);
DEFINE_PRICE(LegEventPx);
DEFINE_STRING(LegEventText);
DEFINE_INT(LegAssetClass);
DEFINE_INT(LegAssetSubClass);
DEFINE_STRING(LegAssetType);
DEFINE_STRING(LegSwapClass);
DEFINE_STRING(UnderlyingEventText);
DEFINE_LENGTH(EncodedUnderlyingEventTextLen);
DEFINE_DATA(EncodedUnderlyingEventText);
DEFINE_LENGTH(EncodedLegEventTextLen);
DEFINE_DATA(EncodedLegEventText);
DEFINE_NUMINGROUP(NoLegSecondaryAssetClasses);
DEFINE_INT(LegSecondaryAssetClass);
DEFINE_INT(LegSecondaryAssetSubClass);
DEFINE_STRING(LegSecondaryAssetType);
DEFINE_NUMINGROUP(NoUnderlyingSecondaryAssetClasses);
DEFINE_INT(UnderlyingSecondaryAssetClass);
DEFINE_INT(UnderlyingSecondaryAssetSubClass);
DEFINE_STRING(UnderlyingSecondaryAssetType);
DEFINE_NUMINGROUP(NoAdditionalTermBondRefs);
DEFINE_STRING(AdditionalTermBondSecurityID);
DEFINE_STRING(AdditionalTermBondSecurityIDSource);
DEFINE_STRING(AdditionalTermBondDesc);
DEFINE_LENGTH(EncodedAdditionalTermBondDescLen);
DEFINE_DATA(EncodedAdditionalTermBondDesc);
DEFINE_CURRENCY(AdditionalTermBondCurrency);
DEFINE_STRING(AdditionalTermBondIssuer);
DEFINE_LENGTH(EncodedAdditionalTermBondIssuerLen);
DEFINE_DATA(EncodedAdditionalTermBondIssuer);
DEFINE_STRING(AdditionalTermBondSeniority);
DEFINE_INT(AdditionalTermBondCouponType);
DEFINE_PERCENTAGE(AdditionalTermBondCouponRate);
DEFINE_LOCALMKTDATE(AdditionalTermBondMaturityDate);
DEFINE_AMT(AdditionalTermBondParValue);
DEFINE_AMT(AdditionalTermBondCurrentTotalIssuedAmount);
DEFINE_INT(AdditionalTermBondCouponFrequencyPeriod);
DEFINE_STRING(AdditionalTermBondCouponFrequencyUnit);
DEFINE_INT(AdditionalTermBondDayCount);
DEFINE_NUMINGROUP(NoAdditionalTerms);
DEFINE_BOOLEAN(AdditionalTermConditionPrecedentBondIndicator);
DEFINE_BOOLEAN(AdditionalTermDiscrepancyClauseIndicator);
DEFINE_NUMINGROUP(NoCashSettlTerms);
DEFINE_CURRENCY(CashSettlCurrency);
DEFINE_INT(CashSettlValuationFirstBusinessDayOffset);
DEFINE_INT(CashSettlValuationSubsequentBusinessDaysOffset);
DEFINE_INT(CashSettlNumOfValuationDates);
DEFINE_LOCALMKTTIME(CashSettlValuationTime);
DEFINE_STRING(CashSettlBusinessCenter);
DEFINE_INT(CashSettlQuoteMethod);
DEFINE_AMT(CashSettlQuoteAmount);
DEFINE_CURRENCY(CashSettlQuoteCurrency);
DEFINE_AMT(CashSettlMinimumQuoteAmount);
DEFINE_CURRENCY(CashSettlMinimumQuoteCurrency);
DEFINE_STRING(CashSettlDealer);
DEFINE_INT(CashSettlBusinessDays);
DEFINE_AMT(CashSettlAmount);
DEFINE_FLOAT(CashSettlRecoveryFactor);
DEFINE_BOOLEAN(CashSettlFixedTermIndicator);
DEFINE_BOOLEAN(CashSettlAccruedInterestIndicator);
DEFINE_INT(CashSettlValuationMethod);
DEFINE_XID(CashSettlTermXID);
DEFINE_NUMINGROUP(NoContractualDefinitions);
DEFINE_STRING(ContractualDefinition);
DEFINE_NUMINGROUP(NoContractualMatrices);
DEFINE_STRING(ContractualMatrixSource);
DEFINE_LOCALMKTDATE(ContractualMatrixDate);
DEFINE_STRING(ContractualMatrixTerm);
DEFINE_NUMINGROUP(NoFinancingTermSupplements);
DEFINE_STRING(FinancingTermSupplementDesc);
DEFINE_LOCALMKTDATE(FinancingTermSupplementDate);
DEFINE_NUMINGROUP(NoStreams);
DEFINE_INT(StreamType);
DEFINE_STRING(StreamDesc);
DEFINE_INT(StreamPaySide);
DEFINE_INT(StreamReceiveSide);
DEFINE_AMT(StreamNotional);
DEFINE_CURRENCY(StreamCurrency);
DEFINE_STRING(StreamText);
DEFINE_LOCALMKTDATE(UnderlyingStreamEffectiveDateUnadjusted);
DEFINE_INT(UnderlyingStreamEffectiveDateBusinessDayConvention);
DEFINE_STRING(UnderlyingStreamEffectiveDateBusinessCenter);
DEFINE_INT(UnderlyingStreamEffectiveDateRelativeTo);
DEFINE_INT(UnderlyingStreamEffectiveDateOffsetPeriod);
DEFINE_STRING(UnderlyingStreamEffectiveDateOffsetUnit);
DEFINE_INT(UnderlyingStreamEffectiveDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingStreamEffectiveDateAdjusted);
DEFINE_LOCALMKTDATE(StreamTerminationDateUnadjusted);
DEFINE_INT(StreamTerminationDateBusinessDayConvention);
DEFINE_STRING(StreamTerminationDateBusinessCenter);
DEFINE_INT(StreamTerminationDateRelativeTo);
DEFINE_INT(StreamTerminationDateOffsetPeriod);
DEFINE_STRING(StreamTerminationDateOffsetUnit);
DEFINE_INT(StreamTerminationDateOffsetDayType);
DEFINE_LOCALMKTDATE(StreamTerminationDateAdjusted);
DEFINE_INT(StreamCalculationPeriodBusinessDayConvention);
DEFINE_STRING(StreamCalculationPeriodBusinessCenter);
DEFINE_LOCALMKTDATE(StreamFirstPeriodStartDateUnadjusted);
DEFINE_INT(StreamFirstPeriodStartDateBusinessDayConvention);
DEFINE_STRING(StreamFirstPeriodStartDateBusinessCenter);
DEFINE_LOCALMKTDATE(StreamFirstPeriodStartDateAdjusted);
DEFINE_LOCALMKTDATE(StreamFirstRegularPeriodStartDateUnadjusted);
DEFINE_LOCALMKTDATE(StreamFirstCompoundingPeriodEndDateUnadjusted);
DEFINE_LOCALMKTDATE(StreamLastRegularPeriodEndDateUnadjusted);
DEFINE_INT(StreamCalculationFrequencyPeriod);
DEFINE_STRING(StreamCalculationFrequencyUnit);
DEFINE_STRING(StreamCalculationRollConvention);
DEFINE_NUMINGROUP(NoSettlRateFallbacks);
DEFINE_INT(SettlRatePostponementMaximumDays);
DEFINE_INT(LegPaymentStreamNonDeliverableSettlRateSource);
DEFINE_BOOLEAN(SettlRatePostponementSurvey);
DEFINE_INT(SettlRatePostponementCalculationAgent);
DEFINE_NUMINGROUP(NoProvisions);
DEFINE_INT(ProvisionType);
DEFINE_LOCALMKTDATE(ProvisionDateUnadjusted);
DEFINE_INT(ProvisionDateBusinessDayConvention);
DEFINE_STRING(ProvisionDateBusinessCenter);
DEFINE_LOCALMKTDATE(ProvisionDateAdjusted);
DEFINE_INT(ProvisionDateTenorPeriod);
DEFINE_STRING(ProvisionDateTenorUnit);
DEFINE_INT(ProvisionCalculationAgent);
DEFINE_INT(ProvisionOptionSinglePartyBuyerSide);
DEFINE_INT(ProvisionOptionSinglePartySellerSide);
DEFINE_INT(ProvisionOptionExerciseStyle);
DEFINE_AMT(ProvisionOptionExerciseMultipleNotional);
DEFINE_AMT(ProvisionOptionExerciseMinimumNotional);
DEFINE_AMT(ProvisionOptionExerciseMaximumNotional);
DEFINE_INT(ProvisionOptionMinimumNumber);
DEFINE_INT(ProvisionOptionMaximumNumber);
DEFINE_BOOLEAN(ProvisionOptionExerciseConfirmation);
DEFINE_INT(ProvisionCashSettlMethod);
DEFINE_CURRENCY(ProvisionCashSettlCurrency);
DEFINE_CURRENCY(ProvisionCashSettlCurrency2);
DEFINE_INT(ProvisionCashSettlQuoteType);
DEFINE_INT(ProvisionCashSettlQuoteSource);
DEFINE_STRING(ProvisionText);
DEFINE_LOCALMKTTIME(ProvisionCashSettlValueTime);
DEFINE_STRING(ProvisionCashSettlValueTimeBusinessCenter);
DEFINE_INT(ProvisionCashSettlValueDateBusinessDayConvention);
DEFINE_STRING(ProvisionCashSettlValueDateBusinessCenter);
DEFINE_INT(ProvisionCashSettlValueDateRelativeTo);
DEFINE_INT(ProvisionCashSettlValueDateOffsetPeriod);
DEFINE_STRING(ProvisionCashSettlValueDateOffsetUnit);
DEFINE_INT(ProvisionCashSettlValueDateOffsetDayType);
DEFINE_LOCALMKTDATE(ProvisionCashSettlValueDateAdjusted);
DEFINE_INT(ProvisionOptionExerciseBusinessDayConvention);
DEFINE_STRING(ProvisionOptionExerciseBusinessCenter);
DEFINE_INT(ProvisionOptionExerciseEarliestDateOffsetPeriod);
DEFINE_STRING(ProvisionOptionExerciseEarliestDateOffsetUnit);
DEFINE_INT(ProvisionOptionExerciseFrequencyPeriod);
DEFINE_STRING(ProvisionOptionExerciseFrequencyUnit);
DEFINE_LOCALMKTDATE(ProvisionOptionExerciseStartDateUnadjusted);
DEFINE_INT(ProvisionOptionExerciseStartDateRelativeTo);
DEFINE_INT(ProvisionOptionExerciseStartDateOffsetPeriod);
DEFINE_STRING(ProvisionOptionExerciseStartDateOffsetUnit);
DEFINE_INT(ProvisionOptionExerciseStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(ProvisionOptionExerciseStartDateAdjusted);
DEFINE_INT(ProvisionOptionExercisePeriodSkip);
DEFINE_LOCALMKTDATE(ProvisionOptionExerciseBoundsFirstDateUnadjusted);
DEFINE_LOCALMKTDATE(ProvisionOptionExerciseBoundsLastDateUnadjusted);
DEFINE_LOCALMKTTIME(ProvisionOptionExerciseEarliestTime);
DEFINE_STRING(ProvisionOptionExerciseEarliestTimeBusinessCenter);
DEFINE_LOCALMKTTIME(ProvisionOptionExerciseLatestTime);
DEFINE_STRING(ProvisionOptionExerciseLatestTimeBusinessCenter);
DEFINE_NUMINGROUP(NoProvisionOptionExerciseFixedDates);
DEFINE_LOCALMKTDATE(ProvisionOptionExerciseFixedDate);
DEFINE_INT(ProvisionOptionExerciseFixedDateType);
DEFINE_LOCALMKTDATE(ProvisionOptionExpirationDateUnadjusted);
DEFINE_INT(ProvisionOptionExpirationDateBusinessDayConvention);
DEFINE_STRING(ProvisionOptionExpirationDateBusinessCenter);
DEFINE_INT(ProvisionOptionExpirationDateRelativeTo);
DEFINE_INT(ProvisionOptionExpirationDateOffsetPeriod);
DEFINE_STRING(ProvisionOptionExpirationDateOffsetUnit);
DEFINE_INT(ProvisionOptionExpirationDateOffsetDayType);
DEFINE_LOCALMKTDATE(ProvisionOptionExpirationDateAdjusted);
DEFINE_LOCALMKTTIME(ProvisionOptionExpirationTime);
DEFINE_STRING(ProvisionOptionExpirationTimeBusinessCenter);
DEFINE_LOCALMKTDATE(ProvisionOptionRelevantUnderlyingDateUnadjusted);
DEFINE_INT(ProvisionOptionRelevantUnderlyingDateBusinessDayConvention);
DEFINE_STRING(ProvisionOptionRelevantUnderlyingDateBusinessCenter);
DEFINE_INT(ProvisionOptionRelevantUnderlyingDateRelativeTo);
DEFINE_INT(ProvisionOptionRelevantUnderlyingDateOffsetPeriod);
DEFINE_STRING(ProvisionOptionRelevantUnderlyingDateOffsetUnit);
DEFINE_INT(ProvisionOptionRelevantUnderlyingDateOffsetDayType);
DEFINE_LOCALMKTDATE(ProvisionOptionRelevantUnderlyingDateAdjusted);
DEFINE_INT(ProvisionCashSettlPaymentDateBusinessDayConvention);
DEFINE_STRING(ProvisionCashSettlPaymentDateBusinessCenter);
DEFINE_INT(ProvisionCashSettlPaymentDateRelativeTo);
DEFINE_INT(ProvisionCashSettlPaymentDateOffsetPeriod);
DEFINE_STRING(ProvisionCashSettlPaymentDateOffsetUnit);
DEFINE_INT(ProvisionCashSettlPaymentDateOffsetDayType);
DEFINE_LOCALMKTDATE(ProvisionCashSettlPaymentDateRangeFirst);
DEFINE_LOCALMKTDATE(ProvisionCashSettlPaymentDateRangeLast);
DEFINE_NUMINGROUP(NoProvisionCashSettlPaymentDates);
DEFINE_LOCALMKTDATE(ProvisionCashSettlPaymentDate);
DEFINE_INT(ProvisionCashSettlPaymentDateType);
DEFINE_NUMINGROUP(NoProvisionPartyIDs);
DEFINE_STRING(ProvisionPartyID);
DEFINE_CHAR(ProvisionPartyIDSource);
DEFINE_INT(ProvisionPartyRole);
DEFINE_NUMINGROUP(NoProvisionPartySubIDs);
DEFINE_STRING(ProvisionPartySubID);
DEFINE_INT(ProvisionPartySubIDType);
DEFINE_NUMINGROUP(NoProtectionTerms);
DEFINE_AMT(ProtectionTermNotional);
DEFINE_CURRENCY(ProtectionTermCurrency);
DEFINE_BOOLEAN(ProtectionTermSellerNotifies);
DEFINE_BOOLEAN(ProtectionTermBuyerNotifies);
DEFINE_STRING(ProtectionTermEventBusinessCenter);
DEFINE_BOOLEAN(ProtectionTermStandardSources);
DEFINE_INT(ProtectionTermEventMinimumSources);
DEFINE_STRING(ProtectionTermEventNewsSource);
DEFINE_XID(ProtectionTermXID);
DEFINE_NUMINGROUP(NoProtectionTermEvents);
DEFINE_STRING(ProtectionTermEventType);
DEFINE_STRING(ProtectionTermEventValue);
DEFINE_CURRENCY(ProtectionTermEventCurrency);
DEFINE_INT(ProtectionTermEventPeriod);
DEFINE_STRING(ProtectionTermEventUnit);
DEFINE_INT(ProtectionTermEventDayType);
DEFINE_STRING(ProtectionTermEventRateSource);
DEFINE_NUMINGROUP(NoProtectionTermEventQualifiers);
DEFINE_CHAR(ProtectionTermEventQualifier);
DEFINE_NUMINGROUP(NoProtectionTermObligations);
DEFINE_STRING(ProtectionTermObligationType);
DEFINE_STRING(ProtectionTermObligationValue);
DEFINE_NUMINGROUP(NoPhysicalSettlTerms);
DEFINE_CURRENCY(PhysicalSettlCurrency);
DEFINE_INT(PhysicalSettlBusinessDays);
DEFINE_INT(PhysicalSettlMaximumBusinessDays);
DEFINE_XID(PhysicalSettlTermXID);
DEFINE_NUMINGROUP(NoPhysicalSettlDeliverableObligations);
DEFINE_STRING(PhysicalSettlDeliverableObligationType);
DEFINE_STRING(PhysicalSettlDeliverableObligationValue);
DEFINE_NUMINGROUP(NoPayments);
DEFINE_INT(PaymentType);
DEFINE_INT(PaymentPaySide);
DEFINE_INT(PaymentReceiveSide);
DEFINE_CURRENCY(PaymentCurrency);
DEFINE_AMT(PaymentAmount);
DEFINE_PRICE(PaymentPrice);
DEFINE_LOCALMKTDATE(PaymentDateUnadjusted);
DEFINE_INT(PaymentBusinessDayConvention);
DEFINE_STRING(PaymentBusinessCenter);
DEFINE_LOCALMKTDATE(PaymentDateAdjusted);
DEFINE_FLOAT(PaymentDiscountFactor);
DEFINE_AMT(PaymentPresentValueAmount);
DEFINE_CURRENCY(PaymentPresentValueCurrency);
DEFINE_INT(PaymentSettlStyle);
DEFINE_STRING(LegPaymentStreamNonDeliverableSettlReferencePage);
DEFINE_STRING(PaymentText);
DEFINE_NUMINGROUP(NoPaymentSettls);
DEFINE_AMT(PaymentSettlAmount);
DEFINE_CURRENCY(PaymentSettlCurrency);
DEFINE_NUMINGROUP(NoPaymentSettlPartyIDs);
DEFINE_STRING(PaymentSettlPartyID);
DEFINE_CHAR(PaymentSettlPartyIDSource);
DEFINE_INT(PaymentSettlPartyRole);
DEFINE_INT(PaymentSettlPartyRoleQualifier);
DEFINE_NUMINGROUP(NoPaymentSettlPartySubIDs);
DEFINE_STRING(PaymentSettlPartySubID);
DEFINE_INT(PaymentSettlPartySubIDType);
DEFINE_NUMINGROUP(NoLegStreams);
DEFINE_INT(LegStreamType);
DEFINE_STRING(LegStreamDesc);
DEFINE_INT(LegStreamPaySide);
DEFINE_INT(LegStreamReceiveSide);
DEFINE_AMT(LegStreamNotional);
DEFINE_CURRENCY(LegStreamCurrency);
DEFINE_STRING(LegStreamText);
DEFINE_LOCALMKTDATE(LegStreamEffectiveDateUnadjusted);
DEFINE_INT(LegStreamEffectiveDateBusinessDayConvention);
DEFINE_STRING(LegStreamEffectiveDateBusinessCenter);
DEFINE_INT(LegStreamEffectiveDateRelativeTo);
DEFINE_INT(LegStreamEffectiveDateOffsetPeriod);
DEFINE_STRING(LegStreamEffectiveDateOffsetUnit);
DEFINE_INT(LegStreamEffectiveDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegStreamEffectiveDateAdjusted);
DEFINE_LOCALMKTDATE(LegStreamTerminationDateUnadjusted);
DEFINE_INT(LegStreamTerminationDateBusinessDayConvention);
DEFINE_STRING(LegStreamTerminationDateBusinessCenter);
DEFINE_INT(LegStreamTerminationDateRelativeTo);
DEFINE_INT(LegStreamTerminationDateOffsetPeriod);
DEFINE_STRING(LegStreamTerminationDateOffsetUnit);
DEFINE_INT(LegStreamTerminationDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegStreamTerminationDateAdjusted);
DEFINE_INT(LegStreamCalculationPeriodBusinessDayConvention);
DEFINE_STRING(LegStreamCalculationPeriodBusinessCenter);
DEFINE_LOCALMKTDATE(LegStreamFirstPeriodStartDateUnadjusted);
DEFINE_INT(LegStreamFirstPeriodStartDateBusinessDayConvention);
DEFINE_STRING(LegStreamFirstPeriodStartDateBusinessCenter);
DEFINE_LOCALMKTDATE(LegStreamFirstPeriodStartDateAdjusted);
DEFINE_LOCALMKTDATE(LegStreamFirstRegularPeriodStartDateUnadjusted);
DEFINE_LOCALMKTDATE(LegStreamFirstCompoundingPeriodEndDateUnadjusted);
DEFINE_LOCALMKTDATE(LegStreamLastRegularPeriodEndDateUnadjusted);
DEFINE_INT(LegStreamCalculationFrequencyPeriod);
DEFINE_STRING(LegStreamCalculationFrequencyUnit);
DEFINE_STRING(LegStreamCalculationRollConvention);
DEFINE_NUMINGROUP(NoCashSettlDealers);
DEFINE_NUMINGROUP(NoBusinessCenters);
DEFINE_INT(LegPaymentStreamType);
DEFINE_INT(LegPaymentStreamMarketRate);
DEFINE_BOOLEAN(LegPaymentStreamDelayIndicator);
DEFINE_CURRENCY(LegPaymentStreamSettlCurrency);
DEFINE_INT(LegPaymentStreamDayCount);
DEFINE_INT(LegPaymentStreamAccrualDays);
DEFINE_INT(LegPaymentStreamDiscountType);
DEFINE_PERCENTAGE(LegPaymentStreamDiscountRate);
DEFINE_INT(LegPaymentStreamDiscountRateDayCount);
DEFINE_INT(LegPaymentStreamCompoundingMethod);
DEFINE_BOOLEAN(LegPaymentStreamInitialPrincipalExchangeIndicator);
DEFINE_BOOLEAN(LegPaymentStreamInterimPrincipalExchangeIndicator);
DEFINE_BOOLEAN(LegPaymentStreamFinalPrincipalExchangeIndicator);
DEFINE_INT(LegPaymentStreamPaymentDateBusinessDayConvention);
DEFINE_STRING(LegPaymentStreamPaymentDateBusinessCenter);
DEFINE_INT(LegPaymentStreamPaymentFrequencyPeriod);
DEFINE_STRING(LegPaymentStreamPaymentFrequencyUnit);
DEFINE_STRING(LegPaymentStreamPaymentRollConvention);
DEFINE_LOCALMKTDATE(LegPaymentStreamFirstPaymentDateUnadjusted);
DEFINE_LOCALMKTDATE(LegPaymentStreamLastRegularPaymentDateUnadjusted);
DEFINE_INT(LegPaymentStreamPaymentDateRelativeTo);
DEFINE_INT(LegPaymentStreamPaymentDateOffsetPeriod);
DEFINE_STRING(LegPaymentStreamPaymentDateOffsetUnit);
DEFINE_INT(LegPaymentStreamPaymentDateOffsetDayType);
DEFINE_INT(LegPaymentStreamResetDateRelativeTo);
DEFINE_INT(LegPaymentStreamResetDateBusinessDayConvention);
DEFINE_STRING(LegPaymentStreamResetDateBusinessCenter);
DEFINE_INT(LegPaymentStreamResetFrequencyPeriod);
DEFINE_STRING(LegPaymentStreamResetFrequencyUnit);
DEFINE_STRING(LegPaymentStreamResetWeeklyRollConvention);
DEFINE_INT(LegPaymentStreamInitialFixingDateRelativeTo);
DEFINE_INT(LegPaymentStreamInitialFixingDateBusinessDayConvention);
DEFINE_STRING(LegPaymentStreamInitialFixingDateBusinessCenter);
DEFINE_INT(LegPaymentStreamInitialFixingDateOffsetPeriod);
DEFINE_STRING(LegPaymentStreamInitialFixingDateOffsetUnit);
DEFINE_INT(LegPaymentStreamInitialFixingDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegPaymentStreamInitialFixingDateAdjusted);
DEFINE_INT(LegPaymentStreamFixingDateRelativeTo);
DEFINE_INT(LegPaymentStreamFixingDateBusinessDayConvention);
DEFINE_STRING(LegPaymentStreamFixingDateBusinessCenter);
DEFINE_INT(LegPaymentStreamFixingDateOffsetPeriod);
DEFINE_STRING(LegPaymentStreamFixingDateOffsetUnit);
DEFINE_INT(LegPaymentStreamFixingDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegPaymentStreamFixingDateAdjusted);
DEFINE_INT(LegPaymentStreamRateCutoffDateOffsetPeriod);
DEFINE_STRING(LegPaymentStreamRateCutoffDateOffsetUnit);
DEFINE_INT(LegPaymentStreamRateCutoffDateOffsetDayType);
DEFINE_PERCENTAGE(LegPaymentStreamRate);
DEFINE_AMT(LegPaymentStreamFixedAmount);
DEFINE_CURRENCY(LegPaymentStreamRateOrAmountCurrency);
DEFINE_AMT(LegPaymentStreamFutureValueNotional);
DEFINE_LOCALMKTDATE(LegPaymentStreamFutureValueDateAdjusted);
DEFINE_STRING(LegPaymentStreamRateIndex);
DEFINE_INT(LegPaymentStreamRateIndexSource);
DEFINE_STRING(LegPaymentStreamRateIndexCurveUnit);
DEFINE_INT(LegPaymentStreamRateIndexCurvePeriod);
DEFINE_FLOAT(LegPaymentStreamRateMultiplier);
DEFINE_PRICEOFFSET(LegPaymentStreamRateSpread);
DEFINE_INT(LegPaymentStreamRateSpreadPositionType);
DEFINE_INT(LegPaymentStreamRateTreatment);
DEFINE_PERCENTAGE(LegPaymentStreamCapRate);
DEFINE_INT(LegPaymentStreamCapRateBuySide);
DEFINE_INT(LegPaymentStreamCapRateSellSide);
DEFINE_PERCENTAGE(LegPaymentStreamFloorRate);
DEFINE_INT(LegPaymentStreamFloorRateBuySide);
DEFINE_INT(LegPaymentStreamFloorRateSellSide);
DEFINE_PERCENTAGE(LegPaymentStreamInitialRate);
DEFINE_CHAR(LegPaymentStreamFinalRateRoundingDirection);
DEFINE_INT(LegPaymentStreamFinalRatePrecision);
DEFINE_INT(LegPaymentStreamAveragingMethod);
DEFINE_INT(LegPaymentStreamNegativeRateTreatment);
DEFINE_INT(LegPaymentStreamInflationLagPeriod);
DEFINE_STRING(LegPaymentStreamInflationLagUnit);
DEFINE_INT(LegPaymentStreamInflationLagDayType);
DEFINE_INT(LegPaymentStreamInflationInterpolationMethod);
DEFINE_INT(LegPaymentStreamInflationIndexSource);
DEFINE_STRING(LegPaymentStreamInflationPublicationSource);
DEFINE_FLOAT(LegPaymentStreamInflationInitialIndexLevel);
DEFINE_BOOLEAN(LegPaymentStreamInflationFallbackBondApplicable);
DEFINE_INT(LegPaymentStreamFRADiscounting);
DEFINE_CURRENCY(LegPaymentStreamNonDeliverableRefCurrency);
DEFINE_INT(LegPaymentStreamNonDeliverableFixingDatesBusinessDayConvention);
DEFINE_STRING(LegPaymentStreamNonDeliverableFixingDatesBusinessCenter);
DEFINE_INT(LegPaymentStreamNonDeliverableFixingDatesRelativeTo);
DEFINE_INT(LegPaymentStreamNonDeliverableFixingDatesOffsetPeriod);
DEFINE_STRING(LegPaymentStreamNonDeliverableFixingDatesOffsetUnit);
DEFINE_INT(LegPaymentStreamNonDeliverableFixingDatesOffsetDayType);
DEFINE_INT(LegSettlRateFallbackRateSource);
DEFINE_NUMINGROUP(NoLegNonDeliverableFixingDates);
DEFINE_LOCALMKTDATE(LegNonDeliverableFixingDate);
DEFINE_INT(LegNonDeliverableFixingDateType);
DEFINE_STRING(LegSettlRateFallbackReferencePage);
DEFINE_INT(PaymentStreamNonDeliverableSettlRateSource);
DEFINE_STRING(PaymentStreamNonDeliverableSettlReferencePage);
DEFINE_INT(SettlRateFallbackRateSource);
DEFINE_NUMINGROUP(NoLegPaymentSchedules);
DEFINE_INT(LegPaymentScheduleType);
DEFINE_INT(LegPaymentScheduleStubType);
DEFINE_LOCALMKTDATE(LegPaymentScheduleStartDateUnadjusted);
DEFINE_LOCALMKTDATE(LegPaymentScheduleEndDateUnadjusted);
DEFINE_INT(LegPaymentSchedulePaySide);
DEFINE_INT(LegPaymentScheduleReceiveSide);
DEFINE_AMT(LegPaymentScheduleNotional);
DEFINE_CURRENCY(LegPaymentScheduleCurrency);
DEFINE_PERCENTAGE(LegPaymentScheduleRate);
DEFINE_FLOAT(LegPaymentScheduleRateMultiplier);
DEFINE_PRICEOFFSET(LegPaymentScheduleRateSpread);
DEFINE_INT(LegPaymentScheduleRateSpreadPositionType);
DEFINE_INT(LegPaymentScheduleRateTreatment);
DEFINE_AMT(LegPaymentScheduleFixedAmount);
DEFINE_CURRENCY(LegPaymentScheduleFixedCurrency);
DEFINE_INT(LegPaymentScheduleStepFrequencyPeriod);
DEFINE_STRING(LegPaymentScheduleStepFrequencyUnit);
DEFINE_AMT(LegPaymentScheduleStepOffsetValue);
DEFINE_PERCENTAGE(LegPaymentScheduleStepRate);
DEFINE_PERCENTAGE(LegPaymentScheduleStepOffsetRate);
DEFINE_INT(LegPaymentScheduleStepRelativeTo);
DEFINE_LOCALMKTDATE(LegPaymentScheduleFixingDateUnadjusted);
DEFINE_FLOAT(LegPaymentScheduleWeight);
DEFINE_INT(LegPaymentScheduleFixingDateRelativeTo);
DEFINE_INT(LegPaymentScheduleFixingDateBusinessDayConvention);
DEFINE_STRING(LegPaymentScheduleFixingDateBusinessCenter);
DEFINE_INT(LegPaymentScheduleFixingDateOffsetPeriod);
DEFINE_STRING(LegPaymentScheduleFixingDateOffsetUnit);
DEFINE_INT(LegPaymentScheduleFixingDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegPaymentScheduleFixingDateAdjusted);
DEFINE_LOCALMKTTIME(LegPaymentScheduleFixingTime);
DEFINE_STRING(LegPaymentScheduleFixingTimeBusinessCenter);
DEFINE_INT(LegPaymentScheduleInterimExchangePaymentDateRelativeTo);
DEFINE_INT(LegPaymentScheduleInterimExchangeDatesBusinessDayConvention);
DEFINE_STRING(LegPaymentScheduleInterimExchangeDatesBusinessCenter);
DEFINE_INT(LegPaymentScheduleInterimExchangeDatesOffsetPeriod);
DEFINE_STRING(LegPaymentScheduleInterimExchangeDatesOffsetUnit);
DEFINE_INT(LegPaymentScheduleInterimExchangeDatesOffsetDayType);
DEFINE_LOCALMKTDATE(LegPaymentScheduleInterimExchangeDateAdjusted);
DEFINE_NUMINGROUP(NoLegPaymentScheduleRateSources);
DEFINE_INT(LegPaymentScheduleRateSource);
DEFINE_INT(LegPaymentScheduleRateSourceType);
DEFINE_STRING(LegPaymentScheduleReferencePage);
DEFINE_NUMINGROUP(NoLegPaymentStubs);
DEFINE_INT(LegPaymentStubType);
DEFINE_INT(LegPaymentStubLength);
DEFINE_PERCENTAGE(LegPaymentStubRate);
DEFINE_AMT(LegPaymentStubFixedAmount);
DEFINE_CURRENCY(LegPaymentStubFixedCurrency);
DEFINE_STRING(LegPaymentStubIndex);
DEFINE_INT(LegPaymentStubIndexSource);
DEFINE_INT(LegPaymentStubIndexCurvePeriod);
DEFINE_STRING(LegPaymentStubIndexCurveUnit);
DEFINE_FLOAT(LegPaymentStubIndexRateMultiplier);
DEFINE_PRICEOFFSET(LegPaymentStubIndexRateSpread);
DEFINE_INT(LegPaymentStubIndexRateSpreadPositionType);
DEFINE_INT(LegPaymentStubIndexRateTreatment);
DEFINE_PERCENTAGE(LegPaymentStubIndexCapRate);
DEFINE_INT(LegPaymentStubIndexCapRateBuySide);
DEFINE_INT(LegPaymentStubIndexCapRateSellSide);
DEFINE_PERCENTAGE(LegPaymentStubIndexFloorRate);
DEFINE_INT(LegPaymentStubIndexFloorRateBuySide);
DEFINE_INT(LegPaymentStubIndexFloorRateSellSide);
DEFINE_STRING(LegPaymentStubIndex2);
DEFINE_INT(LegPaymentStubIndex2Source);
DEFINE_INT(LegPaymentStubIndex2CurvePeriod);
DEFINE_STRING(LegPaymentStubIndex2CurveUnit);
DEFINE_FLOAT(LegPaymentStubIndex2RateMultiplier);
DEFINE_PRICEOFFSET(LegPaymentStubIndex2RateSpread);
DEFINE_INT(LegPaymentStubIndex2RateSpreadPositionType);
DEFINE_INT(LegPaymentStubIndex2RateTreatment);
DEFINE_PERCENTAGE(LegPaymentStubIndex2CapRate);
DEFINE_PERCENTAGE(LegPaymentStubIndex2FloorRate);
DEFINE_NUMINGROUP(NoLegProvisions);
DEFINE_INT(LegProvisionType);
DEFINE_LOCALMKTDATE(LegProvisionDateUnadjusted);
DEFINE_INT(LegProvisionDateBusinessDayConvention);
DEFINE_STRING(LegProvisionDateBusinessCenter);
DEFINE_LOCALMKTDATE(LegProvisionDateAdjusted);
DEFINE_INT(LegProvisionDateTenorPeriod);
DEFINE_STRING(LegProvisionDateTenorUnit);
DEFINE_INT(LegProvisionCalculationAgent);
DEFINE_INT(LegProvisionOptionSinglePartyBuyerSide);
DEFINE_INT(LegProvisionOptionSinglePartySellerSide);
DEFINE_INT(LegProvisionOptionExerciseStyle);
DEFINE_AMT(LegProvisionOptionExerciseMultipleNotional);
DEFINE_AMT(LegProvisionOptionExerciseMinimumNotional);
DEFINE_AMT(LegProvisionOptionExerciseMaximumNotional);
DEFINE_INT(LegProvisionOptionMinimumNumber);
DEFINE_INT(LegProvisionOptionMaximumNumber);
DEFINE_BOOLEAN(LegProvisionOptionExerciseConfirmation);
DEFINE_INT(LegProvisionCashSettlMethod);
DEFINE_CURRENCY(LegProvisionCashSettlCurrency);
DEFINE_CURRENCY(LegProvisionCashSettlCurrency2);
DEFINE_INT(LegProvisionCashSettlQuoteType);
DEFINE_INT(LegProvisionCashSettlQuoteSource);
DEFINE_STRING(BusinessCenter);
DEFINE_STRING(LegProvisionText);
DEFINE_NUMINGROUP(NoLegProvisionCashSettlPaymentDates);
DEFINE_LOCALMKTDATE(LegProvisionCashSettlPaymentDate);
DEFINE_INT(LegProvisionCashSettlPaymentDateType);
DEFINE_INT(LegProvisionOptionExerciseBusinessDayConvention);
DEFINE_STRING(LegProvisionOptionExerciseBusinessCenter);
DEFINE_INT(LegProvisionOptionExerciseEarliestDateOffsetPeriod);
DEFINE_STRING(LegProvisionOptionExerciseEarliestDateOffsetUnit);
DEFINE_INT(LegProvisionOptionExerciseFrequencyPeriod);
DEFINE_STRING(LegProvisionOptionExerciseFrequencyUnit);
DEFINE_LOCALMKTDATE(LegProvisionOptionExerciseStartDateUnadjusted);
DEFINE_INT(LegProvisionOptionExerciseStartDateRelativeTo);
DEFINE_INT(LegProvisionOptionExerciseStartDateOffsetPeriod);
DEFINE_STRING(LegProvisionOptionExerciseStartDateOffsetUnit);
DEFINE_INT(LegProvisionOptionExerciseStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegProvisionOptionExerciseStartDateAdjusted);
DEFINE_INT(LegProvisionOptionExercisePeriodSkip);
DEFINE_LOCALMKTDATE(LegProvisionOptionExerciseBoundsFirstDateUnadjusted);
DEFINE_LOCALMKTDATE(LegProvisionOptionExerciseBoundsLastDateUnadjusted);
DEFINE_LOCALMKTTIME(LegProvisionOptionExerciseEarliestTime);
DEFINE_STRING(LegProvisionOptionExerciseEarliestTimeBusinessCenter);
DEFINE_LOCALMKTTIME(LegProvisionOptionExerciseLatestTime);
DEFINE_STRING(LegProvisionOptionExerciseLatestTimeBusinessCenter);
DEFINE_NUMINGROUP(NoLegProvisionOptionExerciseFixedDates);
DEFINE_LOCALMKTDATE(LegProvisionOptionExerciseFixedDate);
DEFINE_INT(LegProvisionOptionExerciseFixedDateType);
DEFINE_LOCALMKTDATE(LegProvisionOptionExpirationDateUnadjusted);
DEFINE_INT(LegProvisionOptionExpirationDateBusinessDayConvention);
DEFINE_STRING(LegProvisionOptionExpirationDateBusinessCenter);
DEFINE_INT(LegProvisionOptionExpirationDateRelativeTo);
DEFINE_INT(LegProvisionOptionExpirationDateOffsetPeriod);
DEFINE_STRING(LegProvisionOptionExpirationDateOffsetUnit);
DEFINE_INT(LegProvisionOptionExpirationDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegProvisionOptionExpirationDateAdjusted);
DEFINE_LOCALMKTTIME(LegProvisionOptionExpirationTime);
DEFINE_STRING(LegProvisionOptionExpirationTimeBusinessCenter);
DEFINE_LOCALMKTDATE(LegProvisionOptionRelevantUnderlyingDateUnadjusted);
DEFINE_INT(LegProvisionOptionRelevantUnderlyingDateBusinessDayConvention);
DEFINE_STRING(LegProvisionOptionRelevantUnderlyingDateBusinessCenter);
DEFINE_INT(LegProvisionOptionRelevantUnderlyingDateRelativeTo);
DEFINE_INT(LegProvisionOptionRelevantUnderlyingDateOffsetPeriod);
DEFINE_STRING(LegProvisionOptionRelevantUnderlyingDateOffsetUnit);
DEFINE_INT(LegProvisionOptionRelevantUnderlyingDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegProvisionOptionRelevantUnderlyingDateAdjusted);
DEFINE_INT(LegProvisionCashSettlPaymentDateBusinessDayConvention);
DEFINE_STRING(LegProvisionCashSettlPaymentDateBusinessCenter);
DEFINE_INT(LegProvisionCashSettlPaymentDateRelativeTo);
DEFINE_INT(LegProvisionCashSettlPaymentDateOffsetPeriod);
DEFINE_STRING(LegProvisionCashSettlPaymentDateOffsetUnit);
DEFINE_INT(LegProvisionCashSettlPaymentDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegProvisionCashSettlPaymentDateRangeFirst);
DEFINE_LOCALMKTDATE(LegProvisionCashSettlPaymentDateRangeLast);
DEFINE_LOCALMKTTIME(LegProvisionCashSettlValueTime);
DEFINE_STRING(LegProvisionCashSettlValueTimeBusinessCenter);
DEFINE_INT(LegProvisionCashSettlValueDateBusinessDayConvention);
DEFINE_STRING(LegProvisionCashSettlValueDateBusinessCenter);
DEFINE_INT(LegProvisionCashSettlValueDateRelativeTo);
DEFINE_INT(LegProvisionCashSettlValueDateOffsetPeriod);
DEFINE_STRING(LegProvisionCashSettlValueDateOffsetUnit);
DEFINE_INT(LegProvisionCashSettlValueDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegProvisionCashSettlValueDateAdjusted);
DEFINE_NUMINGROUP(NoLegProvisionPartyIDs);
DEFINE_STRING(LegProvisionPartyID);
DEFINE_CHAR(LegProvisionPartyIDSource);
DEFINE_INT(LegProvisionPartyRole);
DEFINE_NUMINGROUP(NoLegProvisionPartySubIDs);
DEFINE_STRING(LegProvisionPartySubID);
DEFINE_INT(LegProvisionPartySubIDType);
DEFINE_NUMINGROUP(NoUnderlyingStreams);
DEFINE_INT(UnderlyingStreamType);
DEFINE_STRING(UnderlyingStreamDesc);
DEFINE_INT(UnderlyingStreamPaySide);
DEFINE_INT(UnderlyingStreamReceiveSide);
DEFINE_AMT(UnderlyingStreamNotional);
DEFINE_CURRENCY(UnderlyingStreamCurrency);
DEFINE_STRING(UnderlyingStreamText);
DEFINE_LOCALMKTDATE(UnderlyingStreamTerminationDateUnadjusted);
DEFINE_INT(UnderlyingStreamTerminationDateBusinessDayConvention);
DEFINE_STRING(UnderlyingStreamTerminationDateBusinessCenter);
DEFINE_INT(UnderlyingStreamTerminationDateRelativeTo);
DEFINE_INT(UnderlyingStreamTerminationDateOffsetPeriod);
DEFINE_STRING(UnderlyingStreamTerminationDateOffsetUnit);
DEFINE_INT(UnderlyingStreamTerminationDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingStreamTerminationDateAdjusted);
DEFINE_INT(UnderlyingStreamCalculationPeriodBusinessDayConvention);
DEFINE_STRING(UnderlyingStreamCalculationPeriodBusinessCenter);
DEFINE_LOCALMKTDATE(UnderlyingStreamFirstPeriodStartDateUnadjusted);
DEFINE_INT(UnderlyingStreamFirstPeriodStartDateBusinessDayConvention);
DEFINE_STRING(UnderlyingStreamFirstPeriodStartDateBusinessCenter);
DEFINE_LOCALMKTDATE(UnderlyingStreamFirstPeriodStartDateAdjusted);
DEFINE_LOCALMKTDATE(UnderlyingStreamFirstRegularPeriodStartDateUnadjusted);
DEFINE_LOCALMKTDATE(UnderlyingStreamFirstCompoundingPeriodEndDateUnadjusted);
DEFINE_LOCALMKTDATE(UnderlyingStreamLastRegularPeriodEndDateUnadjusted);
DEFINE_INT(UnderlyingStreamCalculationFrequencyPeriod);
DEFINE_STRING(UnderlyingStreamCalculationFrequencyUnit);
DEFINE_STRING(UnderlyingStreamCalculationRollConvention);
DEFINE_INT(UnderlyingPaymentStreamType);
DEFINE_INT(UnderlyingPaymentStreamMarketRate);
DEFINE_BOOLEAN(UnderlyingPaymentStreamDelayIndicator);
DEFINE_CURRENCY(UnderlyingPaymentStreamSettlCurrency);
DEFINE_INT(UnderlyingPaymentStreamDayCount);
DEFINE_INT(UnderlyingPaymentStreamAccrualDays);
DEFINE_INT(UnderlyingPaymentStreamDiscountType);
DEFINE_PERCENTAGE(UnderlyingPaymentStreamDiscountRate);
DEFINE_INT(UnderlyingPaymentStreamDiscountRateDayCount);
DEFINE_INT(UnderlyingPaymentStreamCompoundingMethod);
DEFINE_BOOLEAN(UnderlyingPaymentStreamInitialPrincipalExchangeIndicator);
DEFINE_BOOLEAN(UnderlyingPaymentStreamInterimPrincipalExchangeIndicator);
DEFINE_BOOLEAN(UnderlyingPaymentStreamFinalPrincipalExchangeIndicator);
DEFINE_INT(UnderlyingPaymentStreamPaymentDateBusinessDayConvention);
DEFINE_STRING(UnderlyingPaymentStreamPaymentDateBusinessCenter);
DEFINE_INT(UnderlyingPaymentStreamPaymentFrequencyPeriod);
DEFINE_STRING(UnderlyingPaymentStreamPaymentFrequencyUnit);
DEFINE_STRING(UnderlyingPaymentStreamPaymentRollConvention);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamFirstPaymentDateUnadjusted);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamLastRegularPaymentDateUnadjusted);
DEFINE_INT(UnderlyingPaymentStreamPaymentDateRelativeTo);
DEFINE_INT(UnderlyingPaymentStreamPaymentDateOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentStreamPaymentDateOffsetUnit);
DEFINE_INT(UnderlyingPaymentStreamPaymentDateOffsetDayType);
DEFINE_INT(UnderlyingPaymentStreamResetDateRelativeTo);
DEFINE_INT(UnderlyingPaymentStreamResetDateBusinessDayConvention);
DEFINE_STRING(UnderlyingPaymentStreamResetDateBusinessCenter);
DEFINE_INT(UnderlyingPaymentStreamResetFrequencyPeriod);
DEFINE_STRING(UnderlyingPaymentStreamResetFrequencyUnit);
DEFINE_STRING(UnderlyingPaymentStreamResetWeeklyRollConvention);
DEFINE_INT(UnderlyingPaymentStreamInitialFixingDateRelativeTo);
DEFINE_INT(UnderlyingPaymentStreamInitialFixingDateBusinessDayConvention);
DEFINE_STRING(UnderlyingPaymentStreamInitialFixingDateBusinessCenter);
DEFINE_INT(UnderlyingPaymentStreamInitialFixingDateOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentStreamInitialFixingDateOffsetUnit);
DEFINE_INT(UnderlyingPaymentStreamInitialFixingDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamInitialFixingDateAdjusted);
DEFINE_INT(UnderlyingPaymentStreamFixingDateRelativeTo);
DEFINE_INT(UnderlyingPaymentStreamFixingDateBusinessDayConvention);
DEFINE_STRING(UnderlyingPaymentStreamFixingDateBusinessCenter);
DEFINE_INT(UnderlyingPaymentStreamFixingDateOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentStreamFixingDateOffsetUnit);
DEFINE_INT(UnderlyingPaymentStreamFixingDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamFixingDateAdjusted);
DEFINE_INT(UnderlyingPaymentStreamRateCutoffDateOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentStreamRateCutoffDateOffsetUnit);
DEFINE_INT(UnderlyingPaymentStreamRateCutoffDateOffsetDayType);
DEFINE_PERCENTAGE(UnderlyingPaymentStreamRate);
DEFINE_AMT(UnderlyingPaymentStreamFixedAmount);
DEFINE_CURRENCY(UnderlyingPaymentStreamRateOrAmountCurrency);
DEFINE_AMT(UnderlyingPaymentStreamFutureValueNotional);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamFutureValueDateAdjusted);
DEFINE_STRING(UnderlyingPaymentStreamRateIndex);
DEFINE_INT(UnderlyingPaymentStreamRateIndexSource);
DEFINE_STRING(UnderlyingPaymentStreamRateIndexCurveUnit);
DEFINE_INT(UnderlyingPaymentStreamRateIndexCurvePeriod);
DEFINE_FLOAT(UnderlyingPaymentStreamRateMultiplier);
DEFINE_PRICEOFFSET(UnderlyingPaymentStreamRateSpread);
DEFINE_INT(UnderlyingPaymentStreamRateSpreadPositionType);
DEFINE_INT(UnderlyingPaymentStreamRateTreatment);
DEFINE_PERCENTAGE(UnderlyingPaymentStreamCapRate);
DEFINE_INT(UnderlyingPaymentStreamCapRateBuySide);
DEFINE_INT(UnderlyingPaymentStreamCapRateSellSide);
DEFINE_PERCENTAGE(UnderlyingPaymentStreamFloorRate);
DEFINE_INT(UnderlyingPaymentStreamFloorRateBuySide);
DEFINE_INT(UnderlyingPaymentStreamFloorRateSellSide);
DEFINE_PERCENTAGE(UnderlyingPaymentStreamInitialRate);
DEFINE_CHAR(UnderlyingPaymentStreamFinalRateRoundingDirection);
DEFINE_INT(UnderlyingPaymentStreamFinalRatePrecision);
DEFINE_INT(UnderlyingPaymentStreamAveragingMethod);
DEFINE_INT(UnderlyingPaymentStreamNegativeRateTreatment);
DEFINE_INT(UnderlyingPaymentStreamInflationLagPeriod);
DEFINE_STRING(UnderlyingPaymentStreamInflationLagUnit);
DEFINE_INT(UnderlyingPaymentStreamInflationLagDayType);
DEFINE_INT(UnderlyingPaymentStreamInflationInterpolationMethod);
DEFINE_INT(UnderlyingPaymentStreamInflationIndexSource);
DEFINE_STRING(UnderlyingPaymentStreamInflationPublicationSource);
DEFINE_FLOAT(UnderlyingPaymentStreamInflationInitialIndexLevel);
DEFINE_BOOLEAN(UnderlyingPaymentStreamInflationFallbackBondApplicable);
DEFINE_INT(UnderlyingPaymentStreamFRADiscounting);
DEFINE_CURRENCY(UnderlyingPaymentStreamNonDeliverableRefCurrency);
DEFINE_INT(UnderlyingPaymentStreamNonDeliverableFixingDatesBizDayConvention);
DEFINE_STRING(UnderlyingPaymentStreamNonDeliverableFixingDatesBusinessCenter);
DEFINE_INT(UnderlyingPaymentStreamNonDeliverableFixingDatesRelativeTo);
DEFINE_INT(UnderlyingPaymentStreamNonDeliverableFixingDatesOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentStreamNonDeliverableFixingDatesOffsetUnit);
DEFINE_INT(UnderlyingPaymentStreamNonDeliverableFixingDatesOffsetDayType);
DEFINE_STRING(SettlRateFallbackReferencePage);
DEFINE_NUMINGROUP(NoUnderlyingNonDeliverableFixingDates);
DEFINE_LOCALMKTDATE(UnderlyingNonDeliverableFixingDate);
DEFINE_INT(UnderlyingNonDeliverableFixingDateType);
DEFINE_NUMINGROUP(NoUnderlyingSettlRateFallbacks);
DEFINE_INT(UnderlyingSettlRatePostponementMaximumDays);
DEFINE_INT(UnderlyingPaymentStreamNonDeliverableSettlRateSource);
DEFINE_BOOLEAN(UnderlyingSettlRatePostponementSurvey);
DEFINE_INT(UnderlyingSettlRatePostponementCalculationAgent);
DEFINE_NUMINGROUP(NoUnderlyingPaymentSchedules);
DEFINE_INT(UnderlyingPaymentScheduleType);
DEFINE_INT(UnderlyingPaymentScheduleStubType);
DEFINE_LOCALMKTDATE(UnderlyingPaymentScheduleStartDateUnadjusted);
DEFINE_LOCALMKTDATE(UnderlyingPaymentScheduleEndDateUnadjusted);
DEFINE_INT(UnderlyingPaymentSchedulePaySide);
DEFINE_INT(UnderlyingPaymentScheduleReceiveSide);
DEFINE_AMT(UnderlyingPaymentScheduleNotional);
DEFINE_CURRENCY(UnderlyingPaymentScheduleCurrency);
DEFINE_PERCENTAGE(UnderlyingPaymentScheduleRate);
DEFINE_FLOAT(UnderlyingPaymentScheduleRateMultiplier);
DEFINE_PRICEOFFSET(UnderlyingPaymentScheduleRateSpread);
DEFINE_INT(UnderlyingPaymentScheduleRateSpreadPositionType);
DEFINE_INT(UnderlyingPaymentScheduleRateTreatment);
DEFINE_AMT(UnderlyingPaymentScheduleFixedAmount);
DEFINE_CURRENCY(UnderlyingPaymentScheduleFixedCurrency);
DEFINE_INT(UnderlyingPaymentScheduleStepFrequencyPeriod);
DEFINE_STRING(UnderlyingPaymentScheduleStepFrequencyUnit);
DEFINE_AMT(UnderlyingPaymentScheduleStepOffsetValue);
DEFINE_PERCENTAGE(UnderlyingPaymentScheduleStepRate);
DEFINE_PERCENTAGE(UnderlyingPaymentScheduleStepOffsetRate);
DEFINE_INT(UnderlyingPaymentScheduleStepRelativeTo);
DEFINE_LOCALMKTDATE(UnderlyingPaymentScheduleFixingDateUnadjusted);
DEFINE_FLOAT(UnderlyingPaymentScheduleWeight);
DEFINE_INT(UnderlyingPaymentScheduleFixingDateRelativeTo);
DEFINE_INT(UnderlyingPaymentScheduleFixingDateBusinessDayCnvtn);
DEFINE_STRING(UnderlyingPaymentScheduleFixingDateBusinessCenter);
DEFINE_INT(UnderlyingPaymentScheduleFixingDateOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentScheduleFixingDateOffsetUnit);
DEFINE_INT(UnderlyingPaymentScheduleFixingDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingPaymentScheduleFixingDateAdjusted);
DEFINE_LOCALMKTTIME(UnderlyingPaymentScheduleFixingTime);
DEFINE_STRING(UnderlyingPaymentScheduleFixingTimeBusinessCenter);
DEFINE_INT(UnderlyingPaymentScheduleInterimExchangePaymentDateRelativeTo);
DEFINE_INT(UnderlyingPaymentScheduleInterimExchangeDatesBizDayConvention);
DEFINE_STRING(UnderlyingPaymentScheduleInterimExchangeDatesBusinessCenter);
DEFINE_INT(UnderlyingPaymentScheduleInterimExchangeDatesOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentScheduleInterimExchangeDatesOffsetUnit);
DEFINE_INT(UnderlyingPaymentScheduleInterimExchangeDatesOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingPaymentScheduleInterimExchangeDateAdjusted);
DEFINE_NUMINGROUP(NoUnderlyingPaymentScheduleRateSources);
DEFINE_INT(UnderlyingPaymentScheduleRateSource);
DEFINE_INT(UnderlyingPaymentScheduleRateSourceType);
DEFINE_STRING(UnderlyingPaymentScheduleReferencePage);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStubs);
DEFINE_INT(UnderlyingPaymentStubType);
DEFINE_INT(UnderlyingPaymentStubLength);
DEFINE_PERCENTAGE(UnderlyingPaymentStubRate);
DEFINE_AMT(UnderlyingPaymentStubFixedAmount);
DEFINE_CURRENCY(UnderlyingPaymentStubFixedCurrency);
DEFINE_STRING(UnderlyingPaymentStubIndex);
DEFINE_INT(UnderlyingPaymentStubIndexSource);
DEFINE_INT(UnderlyingPaymentStubIndexCurvePeriod);
DEFINE_STRING(UnderlyingPaymentStubIndexCurveUnit);
DEFINE_FLOAT(UnderlyingPaymentStubIndexRateMultiplier);
DEFINE_PRICEOFFSET(UnderlyingPaymentStubIndexRateSpread);
DEFINE_INT(UnderlyingPaymentStubIndexRateSpreadPositionType);
DEFINE_INT(UnderlyingPaymentStubIndexRateTreatment);
DEFINE_PERCENTAGE(UnderlyingPaymentStubIndexCapRate);
DEFINE_INT(UnderlyingPaymentStubIndexCapRateBuySide);
DEFINE_INT(UnderlyingPaymentStubIndexCapRateSellSide);
DEFINE_PERCENTAGE(UnderlyingPaymentStubIndexFloorRate);
DEFINE_INT(UnderlyingPaymentStubIndexFloorRateBuySide);
DEFINE_INT(UnderlyingPaymentStubIndexFloorRateSellSide);
DEFINE_STRING(UnderlyingPaymentStubIndex2);
DEFINE_INT(UnderlyingPaymentStubIndex2Source);
DEFINE_INT(UnderlyingPaymentStubIndex2CurvePeriod);
DEFINE_STRING(UnderlyingPaymentStubIndex2CurveUnit);
DEFINE_FLOAT(UnderlyingPaymentStubIndex2RateMultiplier);
DEFINE_PRICEOFFSET(UnderlyingPaymentStubIndex2RateSpread);
DEFINE_INT(UnderlyingPaymentStubIndex2RateSpreadPositionType);
DEFINE_INT(UnderlyingPaymentStubIndex2RateTreatment);
DEFINE_PERCENTAGE(UnderlyingPaymentStubIndex2CapRate);
DEFINE_PERCENTAGE(UnderlyingPaymentStubIndex2FloorRate);
DEFINE_INT(PaymentStreamType);
DEFINE_INT(PaymentStreamMarketRate);
DEFINE_BOOLEAN(PaymentStreamDelayIndicator);
DEFINE_CURRENCY(PaymentStreamSettlCurrency);
DEFINE_INT(PaymentStreamDayCount);
DEFINE_INT(PaymentStreamAccrualDays);
DEFINE_INT(PaymentStreamDiscountType);
DEFINE_PERCENTAGE(PaymentStreamDiscountRate);
DEFINE_INT(PaymentStreamDiscountRateDayCount);
DEFINE_INT(PaymentStreamCompoundingMethod);
DEFINE_BOOLEAN(PaymentStreamInitialPrincipalExchangeIndicator);
DEFINE_BOOLEAN(PaymentStreamInterimPrincipalExchangeIndicator);
DEFINE_BOOLEAN(PaymentStreamFinalPrincipalExchangeIndicator);
DEFINE_INT(PaymentStreamPaymentDateBusinessDayConvention);
DEFINE_STRING(PaymentStreamPaymentDateBusinessCenter);
DEFINE_INT(PaymentStreamPaymentFrequencyPeriod);
DEFINE_STRING(PaymentStreamPaymentFrequencyUnit);
DEFINE_STRING(PaymentStreamPaymentRollConvention);
DEFINE_LOCALMKTDATE(PaymentStreamFirstPaymentDateUnadjusted);
DEFINE_LOCALMKTDATE(PaymentStreamLastRegularPaymentDateUnadjusted);
DEFINE_INT(PaymentStreamPaymentDateRelativeTo);
DEFINE_INT(PaymentStreamPaymentDateOffsetPeriod);
DEFINE_STRING(PaymentStreamPaymentDateOffsetUnit);
DEFINE_INT(PaymentStreamResetDateRelativeTo);
DEFINE_INT(PaymentStreamResetDateBusinessDayConvention);
DEFINE_STRING(PaymentStreamResetDateBusinessCenter);
DEFINE_INT(PaymentStreamResetFrequencyPeriod);
DEFINE_STRING(PaymentStreamResetFrequencyUnit);
DEFINE_STRING(PaymentStreamResetWeeklyRollConvention);
DEFINE_INT(PaymentStreamInitialFixingDateRelativeTo);
DEFINE_INT(PaymentStreamInitialFixingDateBusinessDayConvention);
DEFINE_STRING(PaymentStreamInitialFixingDateBusinessCenter);
DEFINE_INT(PaymentStreamInitialFixingDateOffsetPeriod);
DEFINE_STRING(PaymentStreamInitialFixingDateOffsetUnit);
DEFINE_INT(PaymentStreamInitialFixingDateOffsetDayType);
DEFINE_LOCALMKTDATE(PaymentStreamInitialFixingDateAdjusted);
DEFINE_INT(PaymentStreamFixingDateRelativeTo);
DEFINE_INT(PaymentStreamFixingDateBusinessDayConvention);
DEFINE_STRING(PaymentStreamFixingDateBusinessCenter);
DEFINE_INT(PaymentStreamFixingDateOffsetPeriod);
DEFINE_STRING(PaymentStreamFixingDateOffsetUnit);
DEFINE_INT(PaymentStreamFixingDateOffsetDayType);
DEFINE_LOCALMKTDATE(PaymentStreamFixingDateAdjusted);
DEFINE_INT(PaymentStreamRateCutoffDateOffsetPeriod);
DEFINE_STRING(PaymentStreamRateCutoffDateOffsetUnit);
DEFINE_INT(PaymentStreamRateCutoffDateOffsetDayType);
DEFINE_PERCENTAGE(PaymentStreamRate);
DEFINE_AMT(PaymentStreamFixedAmount);
DEFINE_CURRENCY(PaymentStreamRateOrAmountCurrency);
DEFINE_AMT(PaymentStreamFutureValueNotional);
DEFINE_LOCALMKTDATE(PaymentStreamFutureValueDateAdjusted);
DEFINE_STRING(PaymentStreamRateIndex);
DEFINE_INT(PaymentStreamRateIndexSource);
DEFINE_STRING(PaymentStreamRateIndexCurveUnit);
DEFINE_INT(PaymentStreamRateIndexCurvePeriod);
DEFINE_FLOAT(PaymentStreamRateMultiplier);
DEFINE_PRICEOFFSET(PaymentStreamRateSpread);
DEFINE_INT(PaymentStreamRateSpreadPositionType);
DEFINE_INT(PaymentStreamRateTreatment);
DEFINE_PERCENTAGE(PaymentStreamCapRate);
DEFINE_INT(PaymentStreamCapRateBuySide);
DEFINE_INT(PaymentStreamCapRateSellSide);
DEFINE_PERCENTAGE(PaymentStreamFloorRate);
DEFINE_INT(PaymentStreamFloorRateBuySide);
DEFINE_INT(PaymentStreamFloorRateSellSide);
DEFINE_PERCENTAGE(PaymentStreamInitialRate);
DEFINE_CHAR(PaymentStreamFinalRateRoundingDirection);
DEFINE_INT(PaymentStreamFinalRatePrecision);
DEFINE_INT(PaymentStreamAveragingMethod);
DEFINE_INT(PaymentStreamNegativeRateTreatment);
DEFINE_INT(PaymentStreamInflationLagPeriod);
DEFINE_STRING(PaymentStreamInflationLagUnit);
DEFINE_INT(PaymentStreamInflationLagDayType);
DEFINE_INT(PaymentStreamInflationInterpolationMethod);
DEFINE_INT(PaymentStreamInflationIndexSource);
DEFINE_STRING(PaymentStreamInflationPublicationSource);
DEFINE_FLOAT(PaymentStreamInflationInitialIndexLevel);
DEFINE_BOOLEAN(PaymentStreamInflationFallbackBondApplicable);
DEFINE_INT(PaymentStreamFRADiscounting);
DEFINE_CURRENCY(PaymentStreamNonDeliverableRefCurrency);
DEFINE_INT(PaymentStreamNonDeliverableFixingDatesBusinessDayConvention);
DEFINE_STRING(PaymentStreamNonDeliverableFixingDatesBusinessCenter);
DEFINE_INT(PaymentStreamNonDeliverableFixingDatesRelativeTo);
DEFINE_INT(PaymentStreamNonDeliverableFixingDatesOffsetPeriod);
DEFINE_STRING(PaymentStreamNonDeliverableFixingDatesOffsetUnit);
DEFINE_INT(PaymentStreamNonDeliverableFixingDatesOffsetDayType);
DEFINE_STRING(UnderlyingPaymentStreamNonDeliverableSettlReferencePage);
DEFINE_NUMINGROUP(NoNonDeliverableFixingDates);
DEFINE_LOCALMKTDATE(NonDeliverableFixingDate);
DEFINE_INT(NonDeliverableFixingDateType);
DEFINE_NUMINGROUP(NoPaymentSchedules);
DEFINE_INT(PaymentScheduleType);
DEFINE_INT(PaymentScheduleStubType);
DEFINE_LOCALMKTDATE(PaymentScheduleStartDateUnadjusted);
DEFINE_LOCALMKTDATE(PaymentScheduleEndDateUnadjusted);
DEFINE_INT(PaymentSchedulePaySide);
DEFINE_INT(PaymentScheduleReceiveSide);
DEFINE_AMT(PaymentScheduleNotional);
DEFINE_CURRENCY(PaymentScheduleCurrency);
DEFINE_PERCENTAGE(PaymentScheduleRate);
DEFINE_FLOAT(PaymentScheduleRateMultiplier);
DEFINE_PRICEOFFSET(PaymentScheduleRateSpread);
DEFINE_INT(PaymentScheduleRateSpreadPositionType);
DEFINE_INT(PaymentScheduleRateTreatment);
DEFINE_AMT(PaymentScheduleFixedAmount);
DEFINE_CURRENCY(PaymentScheduleFixedCurrency);
DEFINE_INT(PaymentScheduleStepFrequencyPeriod);
DEFINE_STRING(PaymentScheduleStepFrequencyUnit);
DEFINE_AMT(PaymentScheduleStepOffsetValue);
DEFINE_PERCENTAGE(PaymentScheduleStepRate);
DEFINE_PERCENTAGE(PaymentScheduleStepOffsetRate);
DEFINE_INT(PaymentScheduleStepRelativeTo);
DEFINE_LOCALMKTDATE(PaymentScheduleFixingDateUnadjusted);
DEFINE_FLOAT(PaymentScheduleWeight);
DEFINE_INT(PaymentScheduleFixingDateRelativeTo);
DEFINE_INT(PaymentScheduleFixingDateBusinessDayConvention);
DEFINE_STRING(PaymentScheduleFixingDateBusinessCenter);
DEFINE_INT(PaymentScheduleFixingDateOffsetPeriod);
DEFINE_STRING(PaymentScheduleFixingDateOffsetUnit);
DEFINE_INT(PaymentScheduleFixingDateOffsetDayType);
DEFINE_LOCALMKTDATE(PaymentScheduleFixingDateAdjusted);
DEFINE_LOCALMKTTIME(PaymentScheduleFixingTime);
DEFINE_STRING(PaymentScheduleFixingTimeBusinessCenter);
DEFINE_INT(PaymentScheduleInterimExchangePaymentDateRelativeTo);
DEFINE_INT(PaymentScheduleInterimExchangeDatesBusinessDayConvention);
DEFINE_STRING(PaymentScheduleInterimExchangeDatesBusinessCenter);
DEFINE_INT(PaymentScheduleInterimExchangeDatesOffsetPeriod);
DEFINE_STRING(PaymentScheduleInterimExchangeDatesOffsetUnit);
DEFINE_INT(PaymentScheduleInterimExchangeDatesOffsetDayType);
DEFINE_LOCALMKTDATE(PaymentScheduleInterimExchangeDateAdjusted);
DEFINE_NUMINGROUP(NoPaymentScheduleRateSources);
DEFINE_INT(PaymentScheduleRateSource);
DEFINE_INT(PaymentScheduleRateSourceType);
DEFINE_STRING(PaymentScheduleReferencePage);
DEFINE_NUMINGROUP(NoPaymentStubs);
DEFINE_INT(PaymentStubType);
DEFINE_INT(PaymentStubLength);
DEFINE_PERCENTAGE(PaymentStubRate);
DEFINE_AMT(PaymentStubFixedAmount);
DEFINE_CURRENCY(PaymentStubFixedCurrency);
DEFINE_STRING(PaymentStubIndex);
DEFINE_INT(PaymentStubIndexSource);
DEFINE_INT(PaymentStubIndexCurvePeriod);
DEFINE_STRING(PaymentStubIndexCurveUnit);
DEFINE_FLOAT(PaymentStubIndexRateMultiplier);
DEFINE_PRICEOFFSET(PaymentStubIndexRateSpread);
DEFINE_INT(PaymentStubIndexRateSpreadPositionType);
DEFINE_INT(PaymentStubIndexRateTreatment);
DEFINE_PERCENTAGE(PaymentStubIndexCapRate);
DEFINE_INT(PaymentStubIndexCapRateBuySide);
DEFINE_INT(PaymentStubIndexCapRateSellSide);
DEFINE_PERCENTAGE(PaymentStubIndexFloorRate);
DEFINE_INT(PaymentStubIndexFloorRateBuySide);
DEFINE_INT(PaymentStubIndexFloorRateSellSide);
DEFINE_STRING(PaymentStubIndex2);
DEFINE_INT(PaymentStubIndex2Source);
DEFINE_INT(PaymentStubIndex2CurvePeriod);
DEFINE_STRING(PaymentStubIndex2CurveUnit);
DEFINE_FLOAT(PaymentStubIndex2RateMultiplier);
DEFINE_PRICEOFFSET(PaymentStubIndex2RateSpread);
DEFINE_INT(PaymentStubIndex2RateSpreadPositionType);
DEFINE_INT(PaymentStubIndex2RateTreatment);
DEFINE_PERCENTAGE(PaymentStubIndex2CapRate);
DEFINE_PERCENTAGE(PaymentStubIndex2FloorRate);
DEFINE_NUMINGROUP(NoLegSettlRateFallbacks);
DEFINE_INT(LegSettlRatePostponementMaximumDays);
DEFINE_INT(UnderlyingSettlRateFallbackRateSource);
DEFINE_BOOLEAN(LegSettlRatePostponementSurvey);
DEFINE_INT(LegSettlRatePostponementCalculationAgent);
DEFINE_LOCALMKTDATE(StreamEffectiveDateUnadjusted);
DEFINE_INT(StreamEffectiveDateBusinessDayConvention);
DEFINE_STRING(StreamEffectiveDateBusinessCenter);
DEFINE_INT(StreamEffectiveDateRelativeTo);
DEFINE_INT(StreamEffectiveDateOffsetPeriod);
DEFINE_STRING(StreamEffectiveDateOffsetUnit);
DEFINE_INT(StreamEffectiveDateOffsetDayType);
DEFINE_LOCALMKTDATE(StreamEffectiveDateAdjusted);
DEFINE_STRING(UnderlyingSettlRateFallbackReferencePage);
DEFINE_INT(PaymentPriceType);
DEFINE_INT(PaymentStreamPaymentDateOffsetDayType);
DEFINE_INT(BusinessDayConvention);
DEFINE_STRING(DateRollConvention);
DEFINE_NUMINGROUP(NoLegBusinessCenters);
DEFINE_STRING(LegBusinessCenter);
DEFINE_INT(LegBusinessDayConvention);
DEFINE_STRING(LegDateRollConvention);
DEFINE_NUMINGROUP(NoLegPaymentScheduleFixingDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegPaymentScheduleInterimExchangeDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegPaymentStreamNonDeliverableFixingDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegPaymentStreamPaymentDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegPaymentStreamResetDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegPaymentStreamInitialFixingDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegPaymentStreamFixingDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegProvisionCashSettlPaymentDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegProvisionCashSettlValueDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegProvisionOptionExerciseBusinessCenters);
DEFINE_NUMINGROUP(NoLegProvisionOptionExpirationDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegProvisionOptionRelevantUnderlyingDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegProvisionDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegStreamCalculationPeriodBusinessCenters);
DEFINE_NUMINGROUP(NoLegStreamFirstPeriodStartDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegStreamEffectiveDateBusinessCenters);
DEFINE_NUMINGROUP(NoLegStreamTerminationDateBusinessCenters);
DEFINE_NUMINGROUP(NoPaymentBusinessCenters);
DEFINE_NUMINGROUP(NoPaymentScheduleInterimExchangeDateBusinessCenters);
DEFINE_NUMINGROUP(NoPaymentStreamNonDeliverableFixingDatesBusinessCenters);
DEFINE_NUMINGROUP(NoPaymentStreamPaymentDateBusinessCenters);
DEFINE_NUMINGROUP(NoPaymentStreamResetDateBusinessCenters);
DEFINE_NUMINGROUP(NoPaymentStreamInitialFixingDateBusinessCenters);
DEFINE_NUMINGROUP(NoPaymentStreamFixingDateBusinessCenters);
DEFINE_NUMINGROUP(NoProtectionTermEventNewsSources);
DEFINE_NUMINGROUP(NoProvisionCashSettlPaymentDateBusinessCenters);
DEFINE_NUMINGROUP(NoProvisionCashSettlValueDateBusinessCenters);
DEFINE_NUMINGROUP(NoProvisionOptionExerciseBusinessCenters);
DEFINE_NUMINGROUP(NoProvisionOptionExpirationDateBusinessCenters);
DEFINE_NUMINGROUP(NoProvisionOptionRelevantUnderlyingDateBusinessCenters);
DEFINE_NUMINGROUP(NoProvisionDateBusinessCenters);
DEFINE_NUMINGROUP(NoStreamCalculationPeriodBusinessCenters);
DEFINE_NUMINGROUP(NoStreamFirstPeriodStartDateBusinessCenters);
DEFINE_NUMINGROUP(NoStreamEffectiveDateBusinessCenters);
DEFINE_NUMINGROUP(NoStreamTerminationDateBusinessCenters);
DEFINE_NUMINGROUP(NoUnderlyingBusinessCenters);
DEFINE_STRING(UnderlyingBusinessCenter);
DEFINE_INT(UnderlyingBusinessDayConvention);
DEFINE_STRING(UnderlyingDateRollConvention);
DEFINE_NUMINGROUP(NoUnderlyingPaymentScheduleFixingDateBusinessCenters);
DEFINE_NUMINGROUP(NoUnderlyingPaymentScheduleInterimExchangeDateBusinessCenters);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamNonDeliverableFixingDatesBizCenters);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamPaymentDateBusinessCenters);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamResetDateBusinessCenters);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamInitialFixingDateBusinessCenters);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamFixingDateBusinessCenters);
DEFINE_NUMINGROUP(NoUnderlyingStreamCalculationPeriodBusinessCenters);
DEFINE_NUMINGROUP(NoUnderlyingStreamFirstPeriodStartDateBusinessCenters);
DEFINE_NUMINGROUP(NoUnderlyingStreamEffectiveDateBusinessCenters);
DEFINE_NUMINGROUP(NoUnderlyingStreamTerminationDateBusinessCenters);
DEFINE_NUMINGROUP(NoPaymentScheduleFixingDateBusinessCenters);
DEFINE_LENGTH(EncodedLegStreamTextLen);
DEFINE_DATA(EncodedLegStreamText);
DEFINE_LENGTH(EncodedLegProvisionTextLen);
DEFINE_DATA(EncodedLegProvisionText);
DEFINE_LENGTH(EncodedStreamTextLen);
DEFINE_DATA(EncodedStreamText);
DEFINE_LENGTH(EncodedPaymentTextLen);
DEFINE_DATA(EncodedPaymentText);
DEFINE_LENGTH(EncodedProvisionTextLen);
DEFINE_DATA(EncodedProvisionText);
DEFINE_LENGTH(EncodedUnderlyingStreamTextLen);
DEFINE_DATA(EncodedUnderlyingStreamText);
DEFINE_STRING(ProvisionCashSettlQuoteReferencePage);
DEFINE_STRING(LegProvisionCashSettlQuoteReferencePage);
DEFINE_MONTHYEAR(EventMonthYear);
DEFINE_MONTHYEAR(LegEventMonthYear);
DEFINE_MONTHYEAR(UnderlyingEventMonthYear);
DEFINE_LOCALMKTDATE(PreviousClearingBusinessDate);
DEFINE_LOCALMKTDATE(ValuationDate);
DEFINE_LOCALMKTTIME(ValuationTime);
DEFINE_STRING(ValuationBusinessCenter);
DEFINE_FLOAT(MarginAmtFXRate);
DEFINE_CHAR(MarginAmtFXRateCalc);
DEFINE_FLOAT(CollateralFXRate);
DEFINE_CHAR(CollateralFXRateCalc);
DEFINE_STRING(CollateralAmountMarketSegmentID);
DEFINE_STRING(CollateralAmountMarketID);
DEFINE_FLOAT(PayCollectFXRate);
DEFINE_CHAR(PayCollectFXRateCalc);
DEFINE_STRING(PosAmtStreamDesc);
DEFINE_FLOAT(PositionFXRate);
DEFINE_CHAR(PositionFXRateCalc);
DEFINE_STRING(PosAmtMarketSegmentID);
DEFINE_STRING(PosAmtMarketID);
DEFINE_BOOLEAN(TerminatedIndicator);
DEFINE_BOOLEAN(ShortMarkingExemptIndicator);
DEFINE_STRING(RelatedRegulatoryTradeIDSource);
DEFINE_NUMINGROUP(NoAttachments);
DEFINE_STRING(AttachmentName);
DEFINE_STRING(AttachmentMediaType);
DEFINE_STRING(AttachmentClassification);
DEFINE_STRING(AttachmentExternalURL);
DEFINE_INT(AttachmentEncodingType);
DEFINE_INT(UnencodedAttachmentLen);
DEFINE_LENGTH(EncodedAttachmentLen);
DEFINE_DATA(EncodedAttachment);
DEFINE_NUMINGROUP(NoAttachmentKeywords);
DEFINE_STRING(AttachmentKeyword);
DEFINE_INT(NegotiationMethod);
DEFINE_UTCTIMESTAMP(NextAuctionTime);
DEFINE_NUMINGROUP(NoAssetAttributes);
DEFINE_STRING(AssetAttributeType);
DEFINE_STRING(AssetAttributeValue);
DEFINE_STRING(AssetAttributeLimit);
DEFINE_FLOAT(CommRate);
DEFINE_STRING(CommUnitOfMeasure);
DEFINE_NUMINGROUP(NoComplexEventAveragingObservations);
DEFINE_INT(ComplexEventAveragingObservationNumber);
DEFINE_FLOAT(ComplexEventAveragingWeight);
DEFINE_NUMINGROUP(NoComplexEventCreditEvents);
DEFINE_STRING(ComplexEventCreditEventType);
DEFINE_STRING(ComplexEventCreditEventValue);
DEFINE_CURRENCY(ComplexEventCreditEventCurrency);
DEFINE_INT(ComplexEventCreditEventPeriod);
DEFINE_STRING(ComplexEventCreditEventUnit);
DEFINE_INT(ComplexEventCreditEventDayType);
DEFINE_INT(ComplexEventCreditEventRateSource);
DEFINE_NUMINGROUP(NoComplexEventCreditEventQualifiers);
DEFINE_CHAR(ComplexEventCreditEventQualifier);
DEFINE_NUMINGROUP(NoComplexEventPeriodDateTimes);
DEFINE_LOCALMKTDATE(ComplexEventPeriodDate);
DEFINE_LOCALMKTTIME(ComplexEventPeriodTime);
DEFINE_NUMINGROUP(NoComplexEventPeriods);
DEFINE_INT(ComplexEventPeriodType);
DEFINE_STRING(ComplexEventBusinessCenter);
DEFINE_NUMINGROUP(NoComplexEventRateSources);
DEFINE_INT(ComplexEventRateSource);
DEFINE_INT(ComplexEventRateSourceType);
DEFINE_STRING(ComplexEventReferencePage);
DEFINE_STRING(ComplexEventReferencePageHeading);
DEFINE_NUMINGROUP(NoComplexEventDateBusinessCenters);
DEFINE_STRING(ComplexEventDateBusinessCenter);
DEFINE_LOCALMKTDATE(ComplexEventDateUnadjusted);
DEFINE_INT(ComplexEventDateRelativeTo);
DEFINE_INT(ComplexEventDateOffsetPeriod);
DEFINE_STRING(ComplexEventDateOffsetUnit);
DEFINE_INT(ComplexEventDateOffsetDayType);
DEFINE_INT(ComplexEventDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(ComplexEventDateAdjusted);
DEFINE_LOCALMKTTIME(ComplexEventFixingTime);
DEFINE_STRING(ComplexEventFixingTimeBusinessCenter);
DEFINE_NUMINGROUP(NoComplexEventCreditEventSources);
DEFINE_STRING(ComplexEventCreditEventSource);
DEFINE_INT(ComplexOptPayoutPaySide);
DEFINE_INT(ComplexOptPayoutReceiveSide);
DEFINE_STRING(ComplexOptPayoutUnderlier);
DEFINE_PERCENTAGE(ComplexOptPayoutPercentage);
DEFINE_INT(ComplexOptPayoutTime);
DEFINE_CURRENCY(ComplexOptPayoutCurrency);
DEFINE_PERCENTAGE(ComplexEventPricePercentage);
DEFINE_CURRENCY(ComplexEventCurrencyOne);
DEFINE_CURRENCY(ComplexEventCurrencyTwo);
DEFINE_INT(ComplexEventQuoteBasis);
DEFINE_FLOAT(ComplexEventFixedFXRate);
DEFINE_STRING(ComplexEventDeterminationMethod);
DEFINE_INT(ComplexEventCalculationAgent);
DEFINE_PRICE(ComplexEventStrikePrice);
DEFINE_FLOAT(ComplexEventStrikeFactor);
DEFINE_INT(ComplexEventStrikeNumberOfOptions);
DEFINE_XIDREF(ComplexEventCreditEventsXIDRef);
DEFINE_INT(ComplexEventCreditEventNotifyingParty);
DEFINE_STRING(ComplexEventCreditEventBusinessCenter);
DEFINE_BOOLEAN(ComplexEventCreditEventStandardSources);
DEFINE_INT(ComplexEventCreditEventMinimumSources);
DEFINE_XID(ComplexEventXID);
DEFINE_XIDREF(ComplexEventXIDRef);
DEFINE_NUMINGROUP(NoComplexEventSchedules);
DEFINE_LOCALMKTDATE(ComplexEventScheduleStartDate);
DEFINE_LOCALMKTDATE(ComplexEventScheduleEndDate);
DEFINE_INT(ComplexEventScheduleFrequencyPeriod);
DEFINE_STRING(ComplexEventScheduleFrequencyUnit);
DEFINE_STRING(ComplexEventScheduleRollConvention);
DEFINE_NUMINGROUP(NoDeliverySchedules);
DEFINE_INT(DeliveryScheduleType);
DEFINE_XID(DeliveryScheduleXID);
DEFINE_QTY(DeliveryScheduleNotional);
DEFINE_STRING(DeliveryScheduleNotionalUnitOfMeasure);
DEFINE_INT(DeliveryScheduleNotionalCommodityFrequency);
DEFINE_FLOAT(DeliveryScheduleNegativeTolerance);
DEFINE_FLOAT(DeliverySchedulePositiveTolerance);
DEFINE_STRING(DeliveryScheduleToleranceUnitOfMeasure);
DEFINE_INT(DeliveryScheduleToleranceType);
DEFINE_COUNTRY(DeliveryScheduleSettlCountry);
DEFINE_STRING(DeliveryScheduleSettlTimeZone);
DEFINE_INT(DeliveryScheduleSettlFlowType);
DEFINE_INT(DeliveryScheduleSettlHolidaysProcessingInstruction);
DEFINE_NUMINGROUP(NoDeliveryScheduleSettlDays);
DEFINE_INT(DeliveryScheduleSettlDay);
DEFINE_INT(DeliveryScheduleSettlTotalHours);
DEFINE_NUMINGROUP(NoDeliveryScheduleSettlTimes);
DEFINE_STRING(DeliveryScheduleSettlStart);
DEFINE_STRING(DeliveryScheduleSettlEnd);
DEFINE_INT(DeliveryScheduleSettlTimeType);
DEFINE_INT(DeliveryStreamType);
DEFINE_STRING(DeliveryStreamPipeline);
DEFINE_STRING(DeliveryStreamEntryPoint);
DEFINE_STRING(DeliveryStreamWithdrawalPoint);
DEFINE_STRING(DeliveryStreamDeliveryPoint);
DEFINE_INT(DeliveryStreamDeliveryRestriction);
DEFINE_STRING(DeliveryStreamDeliveryContingency);
DEFINE_INT(DeliveryStreamDeliveryContingentPartySide);
DEFINE_BOOLEAN(DeliveryStreamDeliverAtSourceIndicator);
DEFINE_STRING(DeliveryStreamRiskApportionment);
DEFINE_STRING(DeliveryStreamRiskApportionmentSource);
DEFINE_STRING(DeliveryStreamTitleTransferLocation);
DEFINE_INT(DeliveryStreamTitleTransferCondition);
DEFINE_STRING(DeliveryStreamImporterOfRecord);
DEFINE_FLOAT(DeliveryStreamNegativeTolerance);
DEFINE_FLOAT(DeliveryStreamPositiveTolerance);
DEFINE_STRING(DeliveryStreamToleranceUnitOfMeasure);
DEFINE_INT(DeliveryStreamToleranceType);
DEFINE_INT(DeliveryStreamToleranceOptionSide);
DEFINE_PERCENTAGE(DeliveryStreamTotalPositiveTolerance);
DEFINE_PERCENTAGE(DeliveryStreamTotalNegativeTolerance);
DEFINE_FLOAT(DeliveryStreamNotionalConversionFactor);
DEFINE_STRING(DeliveryStreamTransportEquipment);
DEFINE_INT(DeliveryStreamElectingPartySide);
DEFINE_NUMINGROUP(NoDeliveryStreamCycles);
DEFINE_STRING(DeliveryStreamCycleDesc);
DEFINE_LENGTH(EncodedDeliveryStreamCycleDescLen);
DEFINE_DATA(EncodedDeliveryStreamCycleDesc);
DEFINE_NUMINGROUP(NoDeliveryStreamCommoditySources);
DEFINE_STRING(DeliveryStreamCommoditySource);
DEFINE_STRING(DocumentationText);
DEFINE_LENGTH(EncodedDocumentationTextLen);
DEFINE_DATA(EncodedDocumentationText);
DEFINE_STRING(SwapSubClass);
DEFINE_STRING(SettlRateIndex);
DEFINE_STRING(SettlRateIndexLocation);
DEFINE_STRING(OptionExpirationDesc);
DEFINE_LENGTH(EncodedOptionExpirationDescLen);
DEFINE_DATA(EncodedOptionExpirationDesc);
DEFINE_STRING(StrikeUnitOfMeasure);
DEFINE_STRING(StrikeIndex);
DEFINE_PRICEOFFSET(StrikeIndexSpread);
DEFINE_STRING(ValuationSource);
DEFINE_STRING(ValuationReferenceModel);
DEFINE_STRING(StrategyType);
DEFINE_BOOLEAN(CommonPricingIndicator);
DEFINE_INT(SettlDisruptionProvision);
DEFINE_CHAR(InstrumentRoundingDirection);
DEFINE_INT(InstrumentRoundingPrecision);
DEFINE_STRING(LegSettleOnOpenFlag);
DEFINE_CHAR(LegInstrmtAssignmentMethod);
DEFINE_STRING(LegSecurityStatus);
DEFINE_STRING(LegRestructuringType);
DEFINE_STRING(LegSeniority);
DEFINE_PERCENTAGE(LegNotionalPercentageOutstanding);
DEFINE_PERCENTAGE(LegOriginalNotionalPercentageOutstanding);
DEFINE_PERCENTAGE(LegAttachmentPoint);
DEFINE_PERCENTAGE(LegDetachmentPoint);
DEFINE_STRING(LegObligationType);
DEFINE_STRING(LegSwapSubClass);
DEFINE_INT(LegNthToDefault);
DEFINE_INT(LegMthToDefault);
DEFINE_STRING(LegSettledEntityMatrixSource);
DEFINE_LOCALMKTDATE(LegSettledEntityMatrixPublicationDate);
DEFINE_INT(LegCouponType);
DEFINE_AMT(LegTotalIssuedAmount);
DEFINE_INT(LegCouponFrequencyPeriod);
DEFINE_STRING(LegCouponFrequencyUnit);
DEFINE_INT(LegCouponDayCount);
DEFINE_STRING(LegConvertibleBondEquityID);
DEFINE_STRING(LegConvertibleBondEquityIDSource);
DEFINE_MONTHYEAR(LegContractPriceRefMonth);
DEFINE_INT(LegLienSeniority);
DEFINE_INT(LegLoanFacility);
DEFINE_INT(LegReferenceEntityType);
DEFINE_INT(LegIndexSeries);
DEFINE_INT(LegIndexAnnexVersion);
DEFINE_LOCALMKTDATE(LegIndexAnnexDate);
DEFINE_STRING(LegIndexAnnexSource);
DEFINE_STRING(LegSettlRateIndex);
DEFINE_STRING(LegSettlRateIndexLocation);
DEFINE_STRING(LegOptionExpirationDesc);
DEFINE_LENGTH(EncodedLegOptionExpirationDescLen);
DEFINE_DATA(EncodedLegOptionExpirationDesc);
DEFINE_FLOAT(LegStrikeMultiplier);
DEFINE_FLOAT(LegStrikeValue);
DEFINE_STRING(LegStrikeUnitOfMeasure);
DEFINE_STRING(LegStrikeIndex);
DEFINE_PRICEOFFSET(LegStrikeIndexSpread);
DEFINE_INT(LegStrikePriceDeterminationMethod);
DEFINE_INT(LegStrikePriceBoundaryMethod);
DEFINE_PERCENTAGE(LegStrikePriceBoundaryPrecision);
DEFINE_INT(LegUnderlyingPriceDeterminationMethod);
DEFINE_FLOAT(LegMinPriceIncrement);
DEFINE_AMT(LegMinPriceIncrementAmount);
DEFINE_STRING(LegSettlMethod);
DEFINE_INT(LegOptPayoutType);
DEFINE_AMT(LegOptPayoutAmount);
DEFINE_STRING(LegPriceQuoteMethod);
DEFINE_STRING(LegValuationMethod);
DEFINE_STRING(LegValuationSource);
DEFINE_STRING(LegValuationReferenceModel);
DEFINE_INT(LegListMethod);
DEFINE_PRICE(LegCapPrice);
DEFINE_PRICE(LegFloorPrice);
DEFINE_BOOLEAN(LegFlexibleIndicator);
DEFINE_BOOLEAN(LegFlexProductEligibilityIndicator);
DEFINE_INT(LegPositionLimit);
DEFINE_INT(LegNTPositionLimit);
DEFINE_INT(LegCPProgram);
DEFINE_STRING(LegCPRegType);
DEFINE_INT(LegShortSaleRestriction);
DEFINE_STRING(LegStrategyType);
DEFINE_BOOLEAN(LegCommonPricingIndicator);
DEFINE_INT(LegSettlDisruptionProvision);
DEFINE_CHAR(LegInstrumentRoundingDirection);
DEFINE_INT(LegInstrumentRoundingPrecision);
DEFINE_INT(MarketDisruptionProvision);
DEFINE_INT(MarketDisruptionFallbackProvision);
DEFINE_INT(MarketDisruptionMaximumDays);
DEFINE_PERCENTAGE(MarketDisruptionMaterialityPercentage);
DEFINE_INT(MarketDisruptionMinimumFuturesContracts);
DEFINE_NUMINGROUP(NoMarketDisruptionEvents);
DEFINE_STRING(MarketDisruptionEvent);
DEFINE_NUMINGROUP(NoMarketDisruptionFallbacks);
DEFINE_STRING(MarketDisruptionFallbackType);
DEFINE_NUMINGROUP(NoMarketDisruptionFallbackReferencePrices);
DEFINE_INT(MarketDisruptionFallbackUnderlierType);
DEFINE_STRING(MarketDisruptionFallbackUnderlierSecurityID);
DEFINE_STRING(MarketDisruptionFallbackUnderlierSecurityIDSource);
DEFINE_STRING(MarketDisruptionFallbackUnderlierSecurityDesc);
DEFINE_LENGTH(EncodedMarketDisruptionFallbackUnderlierSecurityDescLen);
DEFINE_DATA(EncodedMarketDisruptionFallbackUnderlierSecurityDesc);
DEFINE_QTY(MarketDisruptionFallbackOpenUnits);
DEFINE_CURRENCY(MarketDisruptionFallbackBasketCurrency);
DEFINE_FLOAT(MarketDisruptionFallbackBasketDivisor);
DEFINE_PERCENTAGE(MiscFeeRate);
DEFINE_AMT(MiscFeeAmountDue);
DEFINE_STRING(ExerciseDesc);
DEFINE_LENGTH(EncodedExerciseDescLen);
DEFINE_DATA(EncodedExerciseDesc);
DEFINE_BOOLEAN(AutomaticExerciseIndicator);
DEFINE_FLOAT(AutomaticExerciseThresholdRate);
DEFINE_INT(ExerciseConfirmationMethod);
DEFINE_STRING(ManualNoticeBusinessCenter);
DEFINE_BOOLEAN(FallbackExerciseIndicator);
DEFINE_BOOLEAN(LimitedRightToConfirmIndicator);
DEFINE_BOOLEAN(ExerciseSplitTicketIndicator);
DEFINE_NUMINGROUP(NoOptionExerciseBusinessCenters);
DEFINE_STRING(OptionExerciseBusinessCenter);
DEFINE_INT(OptionExerciseBusinessDayConvention);
DEFINE_INT(OptionExerciseEarliestDateOffsetDayType);
DEFINE_INT(OptionExerciseEarliestDateOffsetPeriod);
DEFINE_STRING(OptionExerciseEarliestDateOffsetUnit);
DEFINE_INT(OptionExerciseFrequencyPeriod);
DEFINE_STRING(OptionExerciseFrequencyUnit);
DEFINE_LOCALMKTDATE(OptionExerciseStartDateUnadjusted);
DEFINE_INT(OptionExerciseStartDateRelativeTo);
DEFINE_INT(OptionExerciseStartDateOffsetPeriod);
DEFINE_STRING(OptionExerciseStartDateOffsetUnit);
DEFINE_INT(OptionExerciseStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(OptionExerciseStartDateAdjusted);
DEFINE_INT(OptionExerciseSkip);
DEFINE_LOCALMKTDATE(OptionExerciseNominationDeadline);
DEFINE_LOCALMKTDATE(OptionExerciseFirstDateUnadjusted);
DEFINE_LOCALMKTDATE(OptionExerciseLastDateUnadjusted);
DEFINE_LOCALMKTTIME(OptionExerciseEarliestTime);
DEFINE_LOCALMKTTIME(OptionExerciseLatestTime);
DEFINE_STRING(OptionExerciseTimeBusinessCenter);
DEFINE_NUMINGROUP(NoOptionExerciseDates);
DEFINE_LOCALMKTDATE(OptionExerciseDate);
DEFINE_INT(OptionExerciseDateType);
DEFINE_NUMINGROUP(NoOptionExerciseExpirationDateBusinessCenters);
DEFINE_STRING(OptionExerciseExpirationDateBusinessCenter);
DEFINE_INT(OptionExerciseExpirationDateBusinessDayConvention);
DEFINE_INT(OptionExerciseExpirationDateRelativeTo);
DEFINE_INT(OptionExerciseExpirationDateOffsetPeriod);
DEFINE_STRING(OptionExerciseExpirationDateOffsetUnit);
DEFINE_INT(OptionExerciseExpirationFrequencyPeriod);
DEFINE_STRING(OptionExerciseExpirationFrequencyUnit);
DEFINE_STRING(OptionExerciseExpirationRollConvention);
DEFINE_INT(OptionExerciseExpirationDateOffsetDayType);
DEFINE_LOCALMKTTIME(OptionExerciseExpirationTime);
DEFINE_STRING(OptionExerciseExpirationTimeBusinessCenter);
DEFINE_NUMINGROUP(NoOptionExerciseExpirationDates);
DEFINE_LOCALMKTDATE(OptionExerciseExpirationDate);
DEFINE_INT(OptionExerciseExpirationDateType);
DEFINE_STRING(PaymentUnitOfMeasure);
DEFINE_INT(PaymentDateRelativeTo);
DEFINE_INT(PaymentDateOffsetPeriod);
DEFINE_STRING(PaymentDateOffsetUnit);
DEFINE_INT(PaymentDateOffsetDayType);
DEFINE_INT(PaymentForwardStartType);
DEFINE_NUMINGROUP(NoPaymentScheduleFixingDays);
DEFINE_INT(PaymentScheduleFixingDayOfWeek);
DEFINE_INT(PaymentScheduleFixingDayNumber);
DEFINE_XID(PaymentScheduleXID);
DEFINE_XIDREF(PaymentScheduleXIDRef);
DEFINE_CURRENCY(PaymentScheduleRateCurrency);
DEFINE_STRING(PaymentScheduleRateUnitOfMeasure);
DEFINE_FLOAT(PaymentScheduleRateConversionFactor);
DEFINE_INT(PaymentScheduleRateSpreadType);
DEFINE_PRICE(PaymentScheduleSettlPeriodPrice);
DEFINE_CURRENCY(PaymentScheduleSettlPeriodPriceCurrency);
DEFINE_STRING(PaymentScheduleSettlPeriodPriceUnitOfMeasure);
DEFINE_STRING(PaymentScheduleStepUnitOfMeasure);
DEFINE_INT(PaymentScheduleFixingDayDistribution);
DEFINE_INT(PaymentScheduleFixingDayCount);
DEFINE_INT(PaymentScheduleFixingLagPeriod);
DEFINE_STRING(PaymentScheduleFixingLagUnit);
DEFINE_INT(PaymentScheduleFixingFirstObservationDateOffsetPeriod);
DEFINE_STRING(PaymentScheduleFixingFirstObservationDateOffsetUnit);
DEFINE_BOOLEAN(PaymentStreamFlatRateIndicator);
DEFINE_AMT(PaymentStreamFlatRateAmount);
DEFINE_CURRENCY(PaymentStreamFlatRateCurrency);
DEFINE_AMT(PaymentStreamMaximumPaymentAmount);
DEFINE_CURRENCY(PaymentStreamMaximumPaymentCurrency);
DEFINE_AMT(PaymentStreamMaximumTransactionAmount);
DEFINE_CURRENCY(PaymentStreamMaximumTransactionCurrency);
DEFINE_STRING(PaymentStreamFixedAmountUnitOfMeasure);
DEFINE_AMT(PaymentStreamTotalFixedAmount);
DEFINE_FLOAT(PaymentStreamWorldScaleRate);
DEFINE_PRICE(PaymentStreamContractPrice);
DEFINE_CURRENCY(PaymentStreamContractPriceCurrency);
DEFINE_NUMINGROUP(NoPaymentStreamPricingBusinessCenters);
DEFINE_STRING(PaymentStreamPricingBusinessCenter);
DEFINE_INT(PaymentStreamRateIndex2CurvePeriod);
DEFINE_STRING(PaymentStreamRateIndex2CurveUnit);
DEFINE_STRING(PaymentStreamRateIndexLocation);
DEFINE_QTY(PaymentStreamRateIndexLevel);
DEFINE_STRING(PaymentStreamRateIndexUnitOfMeasure);
DEFINE_INT(PaymentStreamSettlLevel);
DEFINE_QTY(PaymentStreamReferenceLevel);
DEFINE_STRING(PaymentStreamReferenceLevelUnitOfMeasure);
DEFINE_BOOLEAN(PaymentStreamReferenceLevelEqualsZeroIndicator);
DEFINE_CURRENCY(PaymentStreamRateSpreadCurrency);
DEFINE_STRING(PaymentStreamRateSpreadUnitOfMeasure);
DEFINE_FLOAT(PaymentStreamRateConversionFactor);
DEFINE_INT(PaymentStreamRateSpreadType);
DEFINE_PERCENTAGE(PaymentStreamLastResetRate);
DEFINE_PERCENTAGE(PaymentStreamFinalRate);
DEFINE_INT(PaymentStreamCalculationLagPeriod);
DEFINE_STRING(PaymentStreamCalculationLagUnit);
DEFINE_INT(PaymentStreamFirstObservationDateOffsetPeriod);
DEFINE_STRING(PaymentStreamFirstObservationDateOffsetUnit);
DEFINE_INT(PaymentStreamPricingDayType);
DEFINE_INT(PaymentStreamPricingDayDistribution);
DEFINE_INT(PaymentStreamPricingDayCount);
DEFINE_STRING(PaymentStreamPricingBusinessCalendar);
DEFINE_INT(PaymentStreamPricingBusinessDayConvention);
DEFINE_NUMINGROUP(NoPaymentStreamPaymentDates);
DEFINE_LOCALMKTDATE(PaymentStreamPaymentDate);
DEFINE_INT(PaymentStreamPaymentDateType);
DEFINE_BOOLEAN(PaymentStreamMasterAgreementPaymentDatesIndicator);
DEFINE_NUMINGROUP(NoPaymentStreamPricingDates);
DEFINE_LOCALMKTDATE(PaymentStreamPricingDate);
DEFINE_INT(PaymentStreamPricingDateType);
DEFINE_NUMINGROUP(NoPaymentStreamPricingDays);
DEFINE_INT(PaymentStreamPricingDayOfWeek);
DEFINE_INT(PaymentStreamPricingDayNumber);
DEFINE_NUMINGROUP(NoPricingDateBusinessCenters);
DEFINE_STRING(PricingDateBusinessCenter);
DEFINE_LOCALMKTDATE(PricingDateUnadjusted);
DEFINE_INT(PricingDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(PricingDateAdjusted);
DEFINE_LOCALMKTTIME(PricingTime);
DEFINE_STRING(PricingTimeBusinessCenter);
DEFINE_NUMINGROUP(NoStreamAssetAttributes);
DEFINE_STRING(StreamAssetAttributeType);
DEFINE_STRING(StreamAssetAttributeValue);
DEFINE_STRING(StreamAssetAttributeLimit);
DEFINE_NUMINGROUP(NoStreamCalculationPeriodDates);
DEFINE_LOCALMKTDATE(StreamCalculationPeriodDate);
DEFINE_INT(StreamCalculationPeriodDateType);
DEFINE_XID(StreamCalculationPeriodDatesXID);
DEFINE_XIDREF(StreamCalculationPeriodDatesXIDRef);
DEFINE_BOOLEAN(StreamCalculationBalanceOfFirstPeriod);
DEFINE_INT(StreamCalculationCorrectionPeriod);
DEFINE_STRING(StreamCalculationCorrectionUnit);
DEFINE_NUMINGROUP(NoStreamCommoditySettlBusinessCenters);
DEFINE_STRING(StreamCommoditySettlBusinessCenter);
DEFINE_STRING(StreamCommodityBase);
DEFINE_STRING(StreamCommodityType);
DEFINE_STRING(StreamCommoditySecurityID);
DEFINE_STRING(StreamCommoditySecurityIDSource);
DEFINE_STRING(StreamCommodityDesc);
DEFINE_LENGTH(EncodedStreamCommodityDescLen);
DEFINE_DATA(EncodedStreamCommodityDesc);
DEFINE_STRING(StreamCommodityUnitOfMeasure);
DEFINE_CURRENCY(StreamCommodityCurrency);
DEFINE_EXCHANGE(StreamCommodityExchange);
DEFINE_INT(StreamCommodityRateSource);
DEFINE_STRING(StreamCommodityRateReferencePage);
DEFINE_STRING(StreamCommodityRateReferencePageHeading);
DEFINE_STRING(StreamDataProvider);
DEFINE_STRING(StreamCommodityPricingType);
DEFINE_INT(StreamCommodityNearbySettlDayPeriod);
DEFINE_STRING(StreamCommodityNearbySettlDayUnit);
DEFINE_LOCALMKTDATE(StreamCommoditySettlDateUnadjusted);
DEFINE_INT(StreamCommoditySettlDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(StreamCommoditySettlDateAdjusted);
DEFINE_INT(StreamCommoditySettlMonth);
DEFINE_INT(StreamCommoditySettlDateRollPeriod);
DEFINE_STRING(StreamCommoditySettlDateRollUnit);
DEFINE_INT(StreamCommoditySettlDayType);
DEFINE_XID(StreamCommodityXID);
DEFINE_XIDREF(StreamCommodityXIDRef);
DEFINE_NUMINGROUP(NoStreamCommodityAltIDs);
DEFINE_STRING(StreamCommodityAltID);
DEFINE_STRING(StreamCommodityAltIDSource);
DEFINE_NUMINGROUP(NoStreamCommodityDataSources);
DEFINE_STRING(StreamCommodityDataSourceID);
DEFINE_INT(StreamCommodityDataSourceIDType);
DEFINE_NUMINGROUP(NoStreamCommoditySettlDays);
DEFINE_INT(StreamCommoditySettlDay);
DEFINE_INT(StreamCommoditySettlTotalHours);
DEFINE_NUMINGROUP(NoStreamCommoditySettlTimes);
DEFINE_STRING(StreamCommoditySettlStart);
DEFINE_STRING(StreamCommoditySettlEnd);
DEFINE_INT(StreamCommoditySettlTimeType);
DEFINE_NUMINGROUP(NoStreamCommoditySettlPeriods);
DEFINE_COUNTRY(StreamCommoditySettlCountry);
DEFINE_STRING(StreamCommoditySettlTimeZone);
DEFINE_INT(StreamCommoditySettlFlowType);
DEFINE_QTY(StreamCommoditySettlPeriodNotional);
DEFINE_STRING(StreamCommoditySettlPeriodNotionalUnitOfMeasure);
DEFINE_INT(StreamCommoditySettlPeriodFrequencyPeriod);
DEFINE_STRING(StreamCommoditySettlPeriodFrequencyUnit);
DEFINE_PRICE(StreamCommoditySettlPeriodPrice);
DEFINE_STRING(StreamCommoditySettlPeriodPriceUnitOfMeasure);
DEFINE_CURRENCY(StreamCommoditySettlPeriodPriceCurrency);
DEFINE_INT(StreamCommoditySettlHolidaysProcessingInstruction);
DEFINE_XID(StreamCommoditySettlPeriodXID);
DEFINE_XIDREF(StreamCommoditySettlPeriodXIDRef);
DEFINE_XID(StreamXID);
DEFINE_XIDREF(StreamNotionalXIDRef);
DEFINE_INT(StreamNotionalFrequencyPeriod);
DEFINE_STRING(StreamNotionalFrequencyUnit);
DEFINE_INT(StreamNotionalCommodityFrequency);
DEFINE_STRING(StreamNotionalUnitOfMeasure);
DEFINE_QTY(StreamTotalNotional);
DEFINE_STRING(StreamTotalNotionalUnitOfMeasure);
DEFINE_NUMINGROUP(NoMandatoryClearingJurisdictions);
DEFINE_STRING(MandatoryClearingJurisdiction);
DEFINE_QTY(LastQtyChanged);
DEFINE_STRING(TradeVersion);
DEFINE_BOOLEAN(HistoricalReportIndicator);
DEFINE_NUMINGROUP(NoLegAdditionalTermBondRefs);
DEFINE_STRING(LegAdditionalTermBondSecurityID);
DEFINE_STRING(LegAdditionalTermBondSecurityIDSource);
DEFINE_STRING(LegAdditionalTermBondDesc);
DEFINE_LENGTH(EncodedLegAdditionalTermBondDescLen);
DEFINE_DATA(EncodedLegAdditionalTermBondDesc);
DEFINE_CURRENCY(LegAdditionalTermBondCurrency);
DEFINE_STRING(LegAdditionalTermBondIssuer);
DEFINE_LENGTH(EncodedLegAdditionalTermBondIssuerLen);
DEFINE_DATA(EncodedLegAdditionalTermBondIssuer);
DEFINE_STRING(LegAdditionalTermBondSeniority);
DEFINE_INT(LegAdditionalTermBondCouponType);
DEFINE_PERCENTAGE(LegAdditionalTermBondCouponRate);
DEFINE_LOCALMKTDATE(LegAdditionalTermBondMaturityDate);
DEFINE_AMT(LegAdditionalTermBondParValue);
DEFINE_AMT(LegAdditionalTermBondCurrentTotalIssuedAmount);
DEFINE_INT(LegAdditionalTermBondCouponFrequencyPeriod);
DEFINE_STRING(LegAdditionalTermBondCouponFrequencyUnit);
DEFINE_INT(LegAdditionalTermBondDayCount);
DEFINE_NUMINGROUP(NoLegAdditionalTerms);
DEFINE_BOOLEAN(LegAdditionalTermConditionPrecedentBondIndicator);
DEFINE_BOOLEAN(LegAdditionalTermDiscrepancyClauseIndicator);
DEFINE_NUMINGROUP(NoLegAssetAttributes);
DEFINE_STRING(LegAssetAttributeType);
DEFINE_STRING(LegAssetAttributeValue);
DEFINE_STRING(LegAssetAttributeLimit);
DEFINE_NUMINGROUP(NoLegCashSettlDealers);
DEFINE_STRING(LegCashSettlDealer);
DEFINE_NUMINGROUP(NoLegCashSettlTerms);
DEFINE_CURRENCY(LegCashSettlCurrency);
DEFINE_INT(LegCasSettlValuationFirstBusinessDayOffset);
DEFINE_INT(LegCashSettlValuationSubsequentBusinessDaysOffset);
DEFINE_INT(LegCashSettlNumOfValuationDates);
DEFINE_LOCALMKTTIME(LegCashSettlValuationTime);
DEFINE_STRING(LegCashSettlBusinessCenter);
DEFINE_INT(LegCashSettlQuoteMethod);
DEFINE_AMT(LegCashSettlQuoteAmount);
DEFINE_CURRENCY(LegCashSettlQuoteCurrency);
DEFINE_AMT(LegCashSettlMinimumQuoteAmount);
DEFINE_CURRENCY(LegCashSettlMinimumQuoteCurrency);
DEFINE_INT(LegCashSettlBusinessDays);
DEFINE_AMT(LegCashSettlAmount);
DEFINE_FLOAT(LegCashSettlRecoveryFactor);
DEFINE_BOOLEAN(LegCashSettlFixedTermIndicator);
DEFINE_BOOLEAN(LegCashSettlAccruedInterestIndicator);
DEFINE_INT(LegCashSettlValuationMethod);
DEFINE_XID(LegCashSettlTermXID);
DEFINE_NUMINGROUP(NoLegComplexEventAveragingObservations);
DEFINE_INT(LegComplexEventAveragingObservationNumber);
DEFINE_FLOAT(LegComplexEventAveragingWeight);
DEFINE_NUMINGROUP(NoLegComplexEventCreditEvents);
DEFINE_STRING(LegComplexEventCreditEventType);
DEFINE_STRING(LegComplexEventCreditEventValue);
DEFINE_CURRENCY(LegComplexEventCreditEventCurrency);
DEFINE_INT(LegComplexEventCreditEventPeriod);
DEFINE_STRING(LegComplexEventCreditEventUnit);
DEFINE_INT(LegComplexEventCreditEventDayType);
DEFINE_INT(LegComplexEventCreditEventRateSource);
DEFINE_NUMINGROUP(NoLegComplexEventCreditEventQualifiers);
DEFINE_CHAR(LegComplexEventCreditEventQualifier);
DEFINE_NUMINGROUP(NoLegComplexEventPeriodDateTimes);
DEFINE_LOCALMKTDATE(LegComplexEventPeriodDate);
DEFINE_LOCALMKTTIME(LegComplexEventPeriodTime);
DEFINE_NUMINGROUP(NoLegComplexEventPeriods);
DEFINE_INT(LegComplexEventPeriodType);
DEFINE_STRING(LegComplexEventBusinessCenter);
DEFINE_NUMINGROUP(NoLegComplexEventRateSources);
DEFINE_INT(LegComplexEventRateSource);
DEFINE_INT(LegComplexEventRateSourceType);
DEFINE_STRING(LegComplexEventReferencePage);
DEFINE_STRING(LegComplexEvenReferencePageHeading);
DEFINE_NUMINGROUP(NoLegComplexEventDateBusinessCenters);
DEFINE_STRING(LegComplexEventDateBusinessCenter);
DEFINE_LOCALMKTDATE(LegComplexEventDateUnadjusted);
DEFINE_INT(LegComplexEventDateRelativeTo);
DEFINE_INT(LegComplexEventDateOffsetPeriod);
DEFINE_STRING(LegComplexEventDateOffsetUnit);
DEFINE_INT(LegComplexEventDateOffsetDayType);
DEFINE_INT(LegComplexEventDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(LegComplexEventDateAdjusted);
DEFINE_LOCALMKTTIME(LegComplexEventFixingTime);
DEFINE_STRING(LegComplexEventFixingTimeBusinessCenter);
DEFINE_NUMINGROUP(NoLegComplexEventCreditEventSources);
DEFINE_STRING(LegComplexEventCreditEventSource);
DEFINE_NUMINGROUP(NoLegComplexEvents);
DEFINE_INT(LegComplexEventType);
DEFINE_INT(LegComplexOptPayoutPaySide);
DEFINE_INT(LegComplexOptPayoutReceiveSide);
DEFINE_STRING(LegComplexOptPayoutUnderlier);
DEFINE_AMT(LegComplexOptPayoutAmount);
DEFINE_PERCENTAGE(LegComplexOptPayoutPercentage);
DEFINE_INT(LegComplexOptPayoutTime);
DEFINE_CURRENCY(LegComplexOptPayoutCurrency);
DEFINE_PRICE(LegComplexEventPrice);
DEFINE_PERCENTAGE(LegComplexEventPricePercentage);
DEFINE_INT(LegComplexEventPriceBoundaryMethod);
DEFINE_PERCENTAGE(LegComplexEventPriceBoundaryPrecision);
DEFINE_INT(LegComplexEventPriceTimeType);
DEFINE_INT(LegComplexEventCondition);
DEFINE_CURRENCY(LegComplexEventCurrencyOne);
DEFINE_CURRENCY(LegComplexEventCurrencyTwo);
DEFINE_INT(LegComplexEventQuoteBasis);
DEFINE_FLOAT(LegComplexEventFixedFXRate);
DEFINE_STRING(LegComplexEventDeterminationMethod);
DEFINE_INT(LegComplexEventCalculationAgent);
DEFINE_PRICE(LegComplexEventStrikePrice);
DEFINE_FLOAT(LegComplexEventStrikeFactor);
DEFINE_INT(LegComplexEventStrikeNumberOfOptions);
DEFINE_XIDREF(LegComplexEventCreditEventsXIDRef);
DEFINE_INT(LegComplexEventCreditEventNotifyingParty);
DEFINE_STRING(LegComplexEventCreditEventBusinessCenter);
DEFINE_BOOLEAN(LegComplexEventCreditEventStandardSources);
DEFINE_INT(LegComplexEventCreditEventMinimumSources);
DEFINE_XID(LegComplexEventXID);
DEFINE_XIDREF(LegComplexEventXIDRef);
DEFINE_NUMINGROUP(NoLegComplexEventDates);
DEFINE_UTCDATEONLY(LegComplexEventStartDate);
DEFINE_UTCDATEONLY(LegComplexEventEndDate);
DEFINE_NUMINGROUP(NoLegComplexEventTimes);
DEFINE_UTCTIMEONLY(LegComplexEventStartTime);
DEFINE_UTCTIMEONLY(LegComplexEventEndTime);
DEFINE_NUMINGROUP(NoLegComplexEventSchedules);
DEFINE_LOCALMKTDATE(LegComplexEventScheduleStartDate);
DEFINE_LOCALMKTDATE(LegComplexEventScheduleEndDate);
DEFINE_INT(LegComplexEventScheduleFrequencyPeriod);
DEFINE_STRING(LegComplexEventScheduleFrequencyUnit);
DEFINE_STRING(LegComplexEventScheduleRollConvention);
DEFINE_NUMINGROUP(NoLegDeliverySchedules);
DEFINE_INT(LegDeliveryScheduleType);
DEFINE_XID(LegDeliveryScheduleXID);
DEFINE_QTY(LegDeliveryScheduleNotional);
DEFINE_STRING(LegDeliveryScheduleNotionalUnitOfMeasure);
DEFINE_INT(LegDeliveryScheduleNotionalCommodityFrequency);
DEFINE_FLOAT(LegDeliveryScheduleNegativeTolerance);
DEFINE_FLOAT(LegDeliverySchedulePositiveTolerance);
DEFINE_STRING(LegDeliveryScheduleToleranceUnitOfMeasure);
DEFINE_INT(LegDeliveryScheduleToleranceType);
DEFINE_COUNTRY(LegDeliveryScheduleSettlCountry);
DEFINE_STRING(LegDeliveryScheduleSettlTimeZone);
DEFINE_INT(LegDeliveryScheduleSettlFlowType);
DEFINE_INT(LegDeliveryScheduleSettlHolidaysProcessingInstruction);
DEFINE_NUMINGROUP(NoLegDeliveryScheduleSettlDays);
DEFINE_INT(LegDeliveryScheduleSettlDay);
DEFINE_INT(LegDeliveryScheduleSettlTotalHours);
DEFINE_NUMINGROUP(NoLegDeliveryScheduleSettlTimes);
DEFINE_STRING(LegDeliveryScheduleSettlStart);
DEFINE_STRING(LegDeliveryScheduleSettlEnd);
DEFINE_INT(LegDeliveryScheduleSettlTimeType);
DEFINE_INT(LegDeliveryStreamType);
DEFINE_STRING(LegDeliveryStreamPipeline);
DEFINE_STRING(LegDeliveryStreamEntryPoint);
DEFINE_STRING(LegDeliveryStreamWithdrawalPoint);
DEFINE_STRING(LegDeliveryStreamDeliveryPoint);
DEFINE_INT(LegDeliveryStreamDeliveryRestriction);
DEFINE_STRING(LegDeliveryStreamDeliveryContingency);
DEFINE_INT(LegDeliveryStreamDeliveryContingentPartySide);
DEFINE_BOOLEAN(LegDeliveryStreamDeliverAtSourceIndicator);
DEFINE_STRING(LegDeliveryStreamRiskApportionment);
DEFINE_STRING(LegDeliveryStreamRiskApportionmentSource);
DEFINE_STRING(LegDeliveryStreamTitleTransferLocation);
DEFINE_INT(LegDeliveryStreamTitleTransferCondition);
DEFINE_STRING(LegDeliveryStreamImporterOfRecord);
DEFINE_FLOAT(LegDeliveryStreamNegativeTolerance);
DEFINE_FLOAT(LegDeliveryStreamPositiveTolerance);
DEFINE_STRING(LegDeliveryStreamToleranceUnitOfMeasure);
DEFINE_INT(LegDeliveryStreamToleranceType);
DEFINE_INT(LegDeliveryStreamToleranceOptionSide);
DEFINE_PERCENTAGE(LegDeliveryStreamTotalPositiveTolerance);
DEFINE_PERCENTAGE(LegDeliveryStreamTotalNegativeTolerance);
DEFINE_FLOAT(LegDeliveryStreamNotionalConversionFactor);
DEFINE_STRING(LegDeliveryStreamTransportEquipment);
DEFINE_INT(LegDeliveryStreamElectingPartySide);
DEFINE_NUMINGROUP(NoLegStreamAssetAttributes);
DEFINE_STRING(LegStreamAssetAttributeType);
DEFINE_STRING(LegStreamAssetAttributeValue);
DEFINE_STRING(LegStreamAssetAttributeLimit);
DEFINE_NUMINGROUP(NoLegDeliveryStreamCycles);
DEFINE_STRING(LegDeliveryStreamCycleDesc);
DEFINE_LENGTH(EncodedLegDeliveryStreamCycleDescLen);
DEFINE_DATA(EncodedLegDeliveryStreamCycleDesc);
DEFINE_NUMINGROUP(NoLegDeliveryStreamCommoditySources);
DEFINE_STRING(LegDeliveryStreamCommoditySource);
DEFINE_NUMINGROUP(NoLegInstrumentParties);
DEFINE_STRING(LegInstrumentPartyID);
DEFINE_CHAR(LegInstrumentPartyIDSource);
DEFINE_INT(LegInstrumentPartyRole);
DEFINE_NUMINGROUP(NoLegInstrumentPartySubIDs);
DEFINE_STRING(LegInstrumentPartySubID);
DEFINE_INT(LegInstrumentPartySubIDType);
DEFINE_INT(LegMarketDisruptionProvision);
DEFINE_INT(LegMarketDisruptionFallbackProvision);
DEFINE_INT(LegMarketDisruptionMaximumDays);
DEFINE_PERCENTAGE(LegMarketDisruptionMaterialityPercentage);
DEFINE_INT(LegMarketDisruptionMinimumFuturesContracts);
DEFINE_NUMINGROUP(NoLegMarketDisruptionEvents);
DEFINE_STRING(LegMarketDisruptionEvent);
DEFINE_NUMINGROUP(NoLegMarketDisruptionFallbacks);
DEFINE_STRING(LegMarketDisruptionFallbackType);
DEFINE_NUMINGROUP(NoLegMarketDisruptionFallbackReferencePrices);
DEFINE_INT(LegMarketDisruptionFallbackUnderlierType);
DEFINE_STRING(LegMarketDisruptionFallbackUnderlierSecurityID);
DEFINE_STRING(LegMarketDisruptionFallbackUnderlierSecurityIDSource);
DEFINE_STRING(LegMarketDisruptionFallbackUnderlierSecurityDesc);
DEFINE_LENGTH(EncodedLegMarketDisruptionFallbackUnderlierSecurityDescLen);
DEFINE_DATA(EncodedLegMarketDisruptionFallbackUnderlierSecurityDesc);
DEFINE_QTY(LegMarketDisruptionFallbackOpenUnits);
DEFINE_CURRENCY(LegMarketDisruptionFallbackBasketCurrency);
DEFINE_FLOAT(LegMarketDisruptionFallbackBasketDivisor);
DEFINE_STRING(LegExerciseDesc);
DEFINE_LENGTH(EncodedLegExerciseDescLen);
DEFINE_DATA(EncodedLegExerciseDesc);
DEFINE_BOOLEAN(LegAutomaticExerciseIndicator);
DEFINE_FLOAT(LegAutomaticExerciseThresholdRate);
DEFINE_INT(LegExerciseConfirmationMethod);
DEFINE_STRING(LegManualNoticeBusinessCenter);
DEFINE_BOOLEAN(LegFallbackExerciseIndicator);
DEFINE_BOOLEAN(LegLimitRightToConfirmIndicator);
DEFINE_BOOLEAN(LegExerciseSplitTicketIndicator);
DEFINE_NUMINGROUP(NoLegOptionExerciseBusinessCenters);
DEFINE_STRING(LegOptionExerciseBusinessCenter);
DEFINE_INT(LegOptionExerciseBusinessDayConvention);
DEFINE_INT(LegOptionExerciseEarliestDateOffsetDayType);
DEFINE_INT(LegOptionExerciseEarliestDateOffsetPeriod);
DEFINE_STRING(LegOptionExerciseEarliestDateOffsetUnit);
DEFINE_INT(LegOptionExerciseFrequencyPeriod);
DEFINE_STRING(LegOptionExerciseFrequencyUnit);
DEFINE_LOCALMKTDATE(LegOptionExerciseStartDateUnadjusted);
DEFINE_INT(LegOptionExerciseStartDateRelativeTo);
DEFINE_INT(LegOptionExerciseStartDateOffsetPeriod);
DEFINE_STRING(LegOptionExerciseStartDateOffsetUnit);
DEFINE_INT(LegOptionExerciseStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegOptionExerciseStartDateAdjusted);
DEFINE_INT(LegOptionExerciseSkip);
DEFINE_LOCALMKTDATE(LegOptionExerciseNominationDeadline);
DEFINE_LOCALMKTDATE(LegOptionExerciseFirstDateUnadjusted);
DEFINE_LOCALMKTDATE(LegOptionExerciseLastDateUnadjusted);
DEFINE_LOCALMKTTIME(LegOptionExerciseEarliestTime);
DEFINE_LOCALMKTTIME(LegOptionExerciseLatestTime);
DEFINE_STRING(LegOptionExerciseTimeBusinessCenter);
DEFINE_NUMINGROUP(NoLegOptionExerciseDates);
DEFINE_LOCALMKTDATE(LegOptionExerciseDate);
DEFINE_INT(LegOptionExerciseDateType);
DEFINE_NUMINGROUP(NoLegOptionExerciseExpirationDateBusinessCenters);
DEFINE_STRING(LegOptionExerciseExpirationDateBusinessCenter);
DEFINE_INT(LegOptionExerciseExpirationDateBusinessDayConvention);
DEFINE_INT(LegOptionExerciseExpirationDateRelativeTo);
DEFINE_INT(LegOptionExerciseExpirationDateOffsetPeriod);
DEFINE_STRING(LegOptionExerciseExpirationDateOffsetUnit);
DEFINE_INT(LegOptionExerciseExpirationFrequencyPeriod);
DEFINE_STRING(LegOptionExerciseExpirationFrequencyUnit);
DEFINE_STRING(LegOptionExerciseExpirationRollConvention);
DEFINE_INT(LegOptionExerciseExpirationDateOffsetDayType);
DEFINE_LOCALMKTTIME(LegOptionExerciseExpirationTime);
DEFINE_STRING(LegOptionExerciseExpirationTimeBusinessCenter);
DEFINE_NUMINGROUP(NoLegOptionExerciseExpirationDates);
DEFINE_LOCALMKTDATE(LegOptionExerciseExpirationDate);
DEFINE_INT(LegOptionExerciseExpirationDateType);
DEFINE_NUMINGROUP(NoLegPaymentScheduleFixingDays);
DEFINE_INT(LegPaymentScheduleFixingDayOfWeek);
DEFINE_INT(LegPaymentScheduleFixingDayNumber);
DEFINE_XID(LegPaymentScheduleXID);
DEFINE_XIDREF(LegPaymentScheduleXIDRef);
DEFINE_CURRENCY(LegPaymentScheduleRateCurrency);
DEFINE_STRING(LegPaymentScheduleRateUnitOfMeasure);
DEFINE_FLOAT(LegPaymentScheduleRateConversionFactor);
DEFINE_INT(LegPaymentScheduleRateSpreadType);
DEFINE_PRICE(LegPaymentScheduleSettlPeriodPrice);
DEFINE_CURRENCY(LegPaymentScheduleSettlPeriodPriceCurrency);
DEFINE_STRING(LegPaymentScheduleSettlPeriodPriceUnitOfMeasure);
DEFINE_STRING(LegPaymentScheduleStepUnitOfMeasure);
DEFINE_INT(LegPaymentScheduleFixingDayDistribution);
DEFINE_INT(LegPaymentScheduleFixingDayCount);
DEFINE_INT(LegPaymentScheduleFixingLagPeriod);
DEFINE_STRING(LegPaymentScheduleFixingLagUnit);
DEFINE_INT(LegPaymentScheduleFixingFirstObservationDateOffsetPeriod);
DEFINE_STRING(LegPaymentScheduleFixingFirstObservationDateOffsetUnit);
DEFINE_BOOLEAN(LegPaymentStreamFlatRateIndicator);
DEFINE_AMT(LegPaymentStreamFlatRateAmount);
DEFINE_CURRENCY(LegPaymentStreamFlatRateCurrency);
DEFINE_AMT(LegStreamMaximumPaymentAmount);
DEFINE_CURRENCY(LegStreamMaximumPaymentCurrency);
DEFINE_AMT(LegStreamMaximumTransactionAmount);
DEFINE_CURRENCY(LegStreamMaximumTransactionCurrency);
DEFINE_STRING(LegPaymentStreamFixedAmountUnitOfMeasure);
DEFINE_AMT(LegPaymentStreamTotalFixedAmount);
DEFINE_FLOAT(LegPaymentStreamWorldScaleRate);
DEFINE_PRICE(LegPaymentStreamContractPrice);
DEFINE_CURRENCY(LegPaymentStreamContractPriceCurrency);
DEFINE_NUMINGROUP(NoLegPaymentStreamPricingBusinessCenters);
DEFINE_STRING(LegPaymentStreamPricingBusinessCenter);
DEFINE_STRING(LegPaymentStreamRateIndex2CurveUnit);
DEFINE_INT(LegPaymentStreamRateIndex2CurvePeriod);
DEFINE_STRING(LegPaymentStreamRateIndexLocation);
DEFINE_QTY(LegPaymentStreamRateIndexLevel);
DEFINE_STRING(LegPaymentStreamRateIndexUnitOfMeasure);
DEFINE_INT(LegPaymentStreamSettlLevel);
DEFINE_QTY(LegPaymentStreamReferenceLevel);
DEFINE_STRING(LegPaymentStreamReferenceLevelUnitOfMeasure);
DEFINE_BOOLEAN(LegPaymentStreamReferenceLevelEqualsZeroIndicator);
DEFINE_CURRENCY(LegPaymentStreamRateSpreadCurrency);
DEFINE_STRING(LegPaymentStreamRateSpreadUnitOfMeasure);
DEFINE_FLOAT(LegPaymentStreamRateConversionFactor);
DEFINE_INT(LegPaymentStreamRateSpreadType);
DEFINE_PERCENTAGE(LegPaymentStreamLastResetRate);
DEFINE_PERCENTAGE(LegPaymentStreamFinalRate);
DEFINE_INT(LegPaymentStreamCalculationLagPeriod);
DEFINE_STRING(LegPaymentStreamCalculationLagUnit);
DEFINE_INT(LegPaymentStreamFirstObservationDateOffsetPeriod);
DEFINE_STRING(LegPaymentStreamFirstObservationDateOffsetUnit);
DEFINE_INT(LegPaymentStreamPricingDayType);
DEFINE_INT(LegPaymentStreamPricingDayDistribution);
DEFINE_INT(LegPaymentStreamPricingDayCount);
DEFINE_STRING(LegPaymentStreamPricingBusinessCalendar);
DEFINE_INT(LegPaymentStreamPricingBusinessDayConvention);
DEFINE_NUMINGROUP(NoLegPaymentStreamPaymentDates);
DEFINE_LOCALMKTDATE(LegPaymentStreamPaymentDate);
DEFINE_INT(LegPaymentStreamPaymentDateType);
DEFINE_BOOLEAN(LegPaymentStreamMasterAgreementPaymentDatesIndicator);
DEFINE_NUMINGROUP(NoLegPaymentStreamPricingDates);
DEFINE_LOCALMKTDATE(LegPaymentStreamPricingDate);
DEFINE_INT(LegPaymentStreamPricingDateType);
DEFINE_NUMINGROUP(NoLegPaymentStreamPricingDays);
DEFINE_INT(LegPaymentStreamPricingDayOfWeek);
DEFINE_INT(LegPaymentStreamPricingDayNumber);
DEFINE_NUMINGROUP(NoLegPhysicalSettlTerms);
DEFINE_XID(LegPhysicalSettlTermXID);
DEFINE_CURRENCY(LegPhysicalSettlCurency);
DEFINE_INT(LegPhysicalSettlBusinessDays);
DEFINE_INT(LegPhysicalSettlMaximumBusinessDays);
DEFINE_NUMINGROUP(NoLegPhysicalSettlDeliverableObligations);
DEFINE_STRING(LegPhysicalSettlDeliverableObligationType);
DEFINE_STRING(LegPhysicalSettlDeliverableObligationValue);
DEFINE_NUMINGROUP(NoLegPricingDateBusinessCenters);
DEFINE_STRING(LegPricingDateBusinessCenter);
DEFINE_LOCALMKTDATE(LegPricingDateUnadjusted);
DEFINE_INT(LegPricingDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(LegPricingDateAdjusted);
DEFINE_LOCALMKTTIME(LegPricingTime);
DEFINE_STRING(LegPricingTimeBusinessCenter);
DEFINE_NUMINGROUP(NoLegProtectionTermEventNewsSources);
DEFINE_STRING(LegProtectionTermEventNewsSource);
DEFINE_NUMINGROUP(NoLegProtectionTerms);
DEFINE_XID(LegProtectionTermXID);
DEFINE_AMT(LegProtectionTermNotional);
DEFINE_CURRENCY(LegProtectionTermCurrency);
DEFINE_BOOLEAN(LegProtectionTermSellerNotifies);
DEFINE_BOOLEAN(LegProtectionTermBuyerNotifies);
DEFINE_STRING(LegProtectionTermEventBusinessCenter);
DEFINE_BOOLEAN(LegProtectionTermStandardSources);
DEFINE_INT(LegProtectionTermEventMinimumSources);
DEFINE_NUMINGROUP(NoLegProtectionTermEvents);
DEFINE_STRING(LegProtectionTermEventType);
DEFINE_STRING(LegProtectionTermEventValue);
DEFINE_CURRENCY(LegProtectionTermEventCurrency);
DEFINE_INT(LegProtectionTermEventPeriod);
DEFINE_STRING(LegProtectionTermEventUnit);
DEFINE_INT(LegProtectionTermEventDayType);
DEFINE_STRING(LegProtectionTermEventRateSource);
DEFINE_NUMINGROUP(NoLegProtectionTermEventQualifiers);
DEFINE_CHAR(LegProtectionTermEventQualifier);
DEFINE_NUMINGROUP(NoLegProtectionTermObligations);
DEFINE_STRING(LegProtectionTermObligationType);
DEFINE_STRING(LegProtectionTermObligationValue);
DEFINE_NUMINGROUP(NoLegStreamCalculationPeriodDates);
DEFINE_LOCALMKTDATE(LegStreamCalculationPeriodDate);
DEFINE_INT(LegStreamCalculationPeriodDateType);
DEFINE_XID(LegStreamCalculationPeriodDatesXID);
DEFINE_XIDREF(LegStreamCalculationPeriodDatesXIDRef);
DEFINE_BOOLEAN(LegStreamCalculationBalanceOfFirstPeriod);
DEFINE_INT(LegStreamCalculationCorrectionPeriod);
DEFINE_STRING(LegStreamCalculationCorrectionUnit);
DEFINE_NUMINGROUP(NoLegStreamCommoditySettlBusinessCenters);
DEFINE_STRING(LegStreamCommoditySettlBusinessCenter);
DEFINE_STRING(LegStreamCommodityBase);
DEFINE_STRING(LegStreamCommodityType);
DEFINE_STRING(LegStreamCommoditySecurityID);
DEFINE_STRING(LegStreamCommoditySecurityIDSource);
DEFINE_STRING(LegStreamCommodityDesc);
DEFINE_LENGTH(EncodedLegStreamCommodityDescLen);
DEFINE_DATA(EncodedLegStreamCommodityDesc);
DEFINE_STRING(LegStreamCommodityUnitOfMeasure);
DEFINE_CURRENCY(LegStreamCommodityCurrency);
DEFINE_EXCHANGE(LegStreamCommodityExchange);
DEFINE_INT(LegStreamCommodityRateSource);
DEFINE_STRING(LegStreamCommodityRateReferencePage);
DEFINE_STRING(LegStreamCommodityRateReferencePageHeading);
DEFINE_STRING(LegStreamDataProvider);
DEFINE_STRING(LegStreamCommodityPricingType);
DEFINE_INT(LegStreamCommodityNearbySettlDayPeriod);
DEFINE_STRING(LegStreamCommodityNearbySettlDayUnit);
DEFINE_LOCALMKTDATE(LegStreamCommoditySettlDateUnadjusted);
DEFINE_INT(LegStreamCommoditySettlDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(LegStreamCommoditySettlDateAdjusted);
DEFINE_INT(LegStreamCommoditySettlMonth);
DEFINE_INT(LegStreamCommoditySettlDateRollPeriod);
DEFINE_STRING(LegStreamCommoditySettlDateRollUnit);
DEFINE_INT(LegStreamCommoditySettlDayType);
DEFINE_XID(LegStreamCommodityXID);
DEFINE_XIDREF(LegStreamCommodityXIDRef);
DEFINE_NUMINGROUP(NoLegStreamCommodityAltIDs);
DEFINE_STRING(LegStreamCommodityAltID);
DEFINE_STRING(LegStreamCommodityAltIDSource);
DEFINE_NUMINGROUP(NoLegStreamCommodityDataSources);
DEFINE_STRING(LegStreamCommodityDataSourceID);
DEFINE_INT(LegStreamCommodityDataSourceIDType);
DEFINE_NUMINGROUP(NoLegStreamCommoditySettlDays);
DEFINE_INT(LegStreamCommoditySettlDay);
DEFINE_INT(LegStreamCommoditySettlTotalHours);
DEFINE_NUMINGROUP(NoLegStreamCommoditySettlTimes);
DEFINE_STRING(LegStreamCommoditySettlStart);
DEFINE_STRING(LegStreamCommoditySettlEnd);
DEFINE_INT(LegStreamCommoditySettlTimeType);
DEFINE_NUMINGROUP(NoLegStreamCommoditySettlPeriods);
DEFINE_COUNTRY(LegStreamCommoditySettlCountry);
DEFINE_STRING(LegStreamCommoditySettlTimeZone);
DEFINE_INT(LegStreamCommoditySettlFlowType);
DEFINE_QTY(LegStreamCommoditySettlPeriodNotional);
DEFINE_STRING(LegStreamCommoditySettlPeriodNotionalUnitOfMeasure);
DEFINE_INT(LegStreamCommoditySettlPeriodFrequencyPeriod);
DEFINE_STRING(LegStreamCommoditySettlPeriodFrequencyUnit);
DEFINE_PRICE(LegStreamCommoditySettlPeriodPrice);
DEFINE_STRING(LegStreamCommoditySettlPeriodPriceUnitOfMeasure);
DEFINE_CURRENCY(LegStreamCommoditySettlPeriodPriceCurrency);
DEFINE_INT(LegStreamCommoditySettlHolidaysProcessingInstruction);
DEFINE_XID(LegStreamCommoditySettlPeriodXID);
DEFINE_XIDREF(LegStreamCommoditySettlPeriodXIDRef);
DEFINE_XID(LegStreamXID);
DEFINE_XIDREF(LegStreamNotionalXIDRef);
DEFINE_INT(LegStreamNotionalFrequencyPeriod);
DEFINE_STRING(LegStreamNotionalFrequencyUnit);
DEFINE_INT(LegStreamNotionalCommodityFrequency);
DEFINE_STRING(LegStreamNotionalUnitOfMeasure);
DEFINE_QTY(LegStreamTotalNotional);
DEFINE_STRING(LegStreamTotalNotionalUnitOfMeasure);
DEFINE_NUMINGROUP(NoUnderlyingAssetAttributes);
DEFINE_STRING(UnderlyingAssetAttributeType);
DEFINE_STRING(UnderlyingAssetAttributeValue);
DEFINE_STRING(UnderlyingAssetAttributeLimit);
DEFINE_NUMINGROUP(NoUnderlyingComplexEventAveragingObservations);
DEFINE_INT(UnderlyingComplexEventAveragingObservationNumber);
DEFINE_FLOAT(UnderlyingComplexEventAveragingWeight);
DEFINE_NUMINGROUP(NoUnderlyingComplexEventCreditEvents);
DEFINE_STRING(UnderlyingComplexEventCreditEventType);
DEFINE_STRING(UnderlyingComplexEventCreditEventValue);
DEFINE_CURRENCY(UnderlyingComplexEventCreditEventCurrency);
DEFINE_INT(UnderlyingComplexEventCreditEventPeriod);
DEFINE_STRING(UnderlyingComplexEventCreditEventUnit);
DEFINE_INT(UnderlyingComplexEventCreditEventDayType);
DEFINE_INT(UnderlyingComplexEventCreditEventRateSource);
DEFINE_NUMINGROUP(NoUnderlyingComplexEventCreditEventQualifiers);
DEFINE_CHAR(UnderlyingComplexEventCreditEventQualifier);
DEFINE_NUMINGROUP(NoUnderlyingComplexEventPeriodDateTimes);
DEFINE_LOCALMKTDATE(UnderlyingComplexEventPeriodDate);
DEFINE_LOCALMKTTIME(UnderlyingComplexEventPeriodTime);
DEFINE_NUMINGROUP(NoUnderlyingComplexEventPeriods);
DEFINE_INT(UnderlyingComplexEventPeriodType);
DEFINE_STRING(UnderlyingComplexEventBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingComplexEventRateSources);
DEFINE_INT(UnderlyingComplexEventRateSource);
DEFINE_INT(UnderlyingComplexEventRateSourceType);
DEFINE_STRING(UnderlyingComplexEventReferencePage);
DEFINE_STRING(UnderlyingComplexEventReferencePageHeading);
DEFINE_NUMINGROUP(NoUnderlyingComplexEventDateBusinessCenters);
DEFINE_STRING(UnderlyingComplexEventDateBusinessCenter);
DEFINE_LOCALMKTDATE(UnderlyingComplexEventDateUnadjusted);
DEFINE_INT(UnderlyingComplexEventDateRelativeTo);
DEFINE_INT(UnderlyingComplexEventDateOffsetPeriod);
DEFINE_STRING(UnderlyingComplexEventDateOffsetUnit);
DEFINE_INT(UnderlyingComplexEventDateOffsetDayType);
DEFINE_INT(UnderlyingComplexEventDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(UnderlyingComplexEventDateAdjusted);
DEFINE_LOCALMKTTIME(UnderlyingComplexEventFixingTime);
DEFINE_STRING(UnderlyingComplexEventFixingTimeBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingComplexEventCreditEventSources);
DEFINE_STRING(UnderlyingComplexEventCreditEventSource);
DEFINE_INT(UnderlyingComplexOptPayoutPaySide);
DEFINE_INT(UnderlyingComplexOptPayoutReceiveSide);
DEFINE_STRING(UnderlyingComplexOptPayoutUnderlier);
DEFINE_PERCENTAGE(UnderlyingComplexOptPayoutPercentage);
DEFINE_INT(UnderlyingComplexOptPayoutTime);
DEFINE_CURRENCY(UnderlyingComplexOptPayoutCurrency);
DEFINE_PERCENTAGE(UnderlyingComplexEventPricePercentage);
DEFINE_CURRENCY(UnderlyingComplexEventCurrencyOne);
DEFINE_CURRENCY(UnderlyingComplexEventCurrencyTwo);
DEFINE_INT(UnderlyingComplexEventQuoteBasis);
DEFINE_FLOAT(UnderlyingComplexEventFixedFXRate);
DEFINE_STRING(UnderlyingComplexEventDeterminationMethod);
DEFINE_INT(UnderlyingComplexEventCalculationAgent);
DEFINE_PRICE(UnderlyingComplexEventStrikePrice);
DEFINE_FLOAT(UnderlyingComplexEventStrikeFactor);
DEFINE_INT(UnderlyingComplexEventStrikeNumberOfOptions);
DEFINE_XIDREF(UnderlyingComplexEventCreditEventsXIDRef);
DEFINE_INT(UnderlyingComplexEventCreditEventNotifyingParty);
DEFINE_STRING(UnderlyingComplexEventCreditEventBusinessCenter);
DEFINE_BOOLEAN(UnderlyingComplexEventCreditEventStandardSources);
DEFINE_INT(UnderlyingComplexEventCreditEventMinimumSources);
DEFINE_XID(UnderlyingComplexEventXID);
DEFINE_XIDREF(UnderlyingComplexEventXIDRef);
DEFINE_NUMINGROUP(NoUnderlyingComplexEventSchedules);
DEFINE_LOCALMKTDATE(UnderlyingComplexEventScheduleStartDate);
DEFINE_LOCALMKTDATE(UnderlyingComplexEventScheduleEndDate);
DEFINE_INT(UnderlyingComplexEventScheduleFrequencyPeriod);
DEFINE_STRING(UnderlyingComplexEventScheduleFrequencyUnit);
DEFINE_STRING(UnderlyingComplexEventScheduleRollConvention);
DEFINE_NUMINGROUP(NoUnderlyingDeliverySchedules);
DEFINE_INT(UnderlyingDeliveryScheduleType);
DEFINE_XID(UnderlyingDeliveryScheduleXID);
DEFINE_QTY(UnderlyingDeliveryScheduleNotional);
DEFINE_STRING(UnderlyingDeliveryScheduleNotionalUnitOfMeasure);
DEFINE_INT(UnderlyingDeliveryScheduleNotionalCommodityFrequency);
DEFINE_FLOAT(UnderlyingDeliveryScheduleNegativeTolerance);
DEFINE_FLOAT(UnderlyingDeliverySchedulePositiveTolerance);
DEFINE_STRING(UnderlyingDeliveryScheduleToleranceUnitOfMeasure);
DEFINE_INT(UnderlyingDeliveryScheduleToleranceType);
DEFINE_COUNTRY(UnderlyingDeliveryScheduleSettlCountry);
DEFINE_STRING(UnderlyingDeliveryScheduleSettlTimeZone);
DEFINE_INT(UnderlyingDeliveryScheduleSettlFlowType);
DEFINE_INT(UnderlyingDeliveryScheduleSettlHolidaysProcessingInstruction);
DEFINE_NUMINGROUP(NoUnderlyingDeliveryScheduleSettlDays);
DEFINE_INT(UnderlyingDeliveryScheduleSettlDay);
DEFINE_INT(UnderlyingDeliveryScheduleSettlTotalHours);
DEFINE_NUMINGROUP(NoUnderlyingDeliveryScheduleSettlTimes);
DEFINE_STRING(UnderlyingDeliveryScheduleSettlStart);
DEFINE_STRING(UnderlyingDeliveryScheduleSettlEnd);
DEFINE_INT(UnderlyingDeliveryScheduleSettlTimeType);
DEFINE_INT(UnderlyingDeliveryStreamType);
DEFINE_STRING(UnderlyingDeliveryStreamPipeline);
DEFINE_STRING(UnderlyingDeliveryStreamEntryPoint);
DEFINE_STRING(UnderlyingDeliveryStreamWithdrawalPoint);
DEFINE_STRING(UnderlyingDeliveryStreamDeliveryPoint);
DEFINE_INT(UnderlyingDeliveryStreamDeliveryRestriction);
DEFINE_STRING(UnderlyingDeliveryStreamDeliveryContingency);
DEFINE_INT(UnderlyingDeliveryStreamDeliveryContingentPartySide);
DEFINE_BOOLEAN(UnderlyingDeliveryStreamDeliverAtSourceIndicator);
DEFINE_STRING(UnderlyingDeliveryStreamRiskApportionment);
DEFINE_STRING(UnderlyingDeliveryStreamRiskApportionmentSource);
DEFINE_STRING(UnderlyingDeliveryStreamTitleTransferLocation);
DEFINE_INT(UnderlyingDeliveryStreamTitleTransferCondition);
DEFINE_STRING(UnderlyingDeliveryStreamImporterOfRecord);
DEFINE_FLOAT(UnderlyingDeliveryStreamNegativeTolerance);
DEFINE_FLOAT(UnderlyingDeliveryStreamPositiveTolerance);
DEFINE_STRING(UnderlyingDeliveryStreamToleranceUnitOfMeasure);
DEFINE_INT(UnderlyingDeliveryStreamToleranceType);
DEFINE_INT(UnderlyingDeliveryStreamToleranceOptionSide);
DEFINE_PERCENTAGE(UnderlyingDeliveryStreamTotalPositiveTolerance);
DEFINE_PERCENTAGE(UnderlyingDeliveryStreamTotalNegativeTolerance);
DEFINE_FLOAT(UnderlyingDeliveryStreamNotionalConversionFactor);
DEFINE_STRING(UnderlyingDeliveryStreamTransportEquipment);
DEFINE_INT(UnderlyingDeliveryStreamElectingPartySide);
DEFINE_NUMINGROUP(NoUnderlyingStreamAssetAttributes);
DEFINE_STRING(UnderlyingStreamAssetAttributeType);
DEFINE_STRING(UnderlyingStreamAssetAttributeValue);
DEFINE_STRING(UnderlyingStreamAssetAttributeLimit);
DEFINE_NUMINGROUP(NoUnderlyingDeliveryStreamCycles);
DEFINE_STRING(UnderlyingDeliveryStreamCycleDesc);
DEFINE_LENGTH(EncodedUnderlyingDeliveryStreamCycleDescLen);
DEFINE_DATA(EncodedUnderlyingDeliveryStreamCycleDesc);
DEFINE_NUMINGROUP(NoUnderlyingDeliveryStreamCommoditySources);
DEFINE_STRING(UnderlyingDeliveryStreamCommoditySource);
DEFINE_STRING(UnderlyingExerciseDesc);
DEFINE_LENGTH(EncodedUnderlyingExerciseDescLen);
DEFINE_DATA(EncodedUnderlyingExerciseDesc);
DEFINE_BOOLEAN(UnderlyingAutomaticExerciseIndicator);
DEFINE_FLOAT(UnderlyingAutomaticExerciseThresholdRate);
DEFINE_INT(UnderlyingExerciseConfirmationMethod);
DEFINE_STRING(UnderlyingManualNoticeBusinessCenter);
DEFINE_BOOLEAN(UnderlyingFallbackExerciseIndicator);
DEFINE_BOOLEAN(UnderlyingLimitedRightToConfirmIndicator);
DEFINE_BOOLEAN(UnderlyingExerciseSplitTicketIndicator);
DEFINE_NUMINGROUP(NoUnderlyingOptionExerciseBusinessCenters);
DEFINE_STRING(UnderlyingOptionExerciseBusinessCenter);
DEFINE_INT(UnderlyingOptionExerciseBusinessDayConvention);
DEFINE_INT(UnderlyingOptionExerciseEarliestDateOffsetDayType);
DEFINE_INT(UnderlyingOptionExerciseEarliestDateOffsetPeriod);
DEFINE_STRING(UnderlyingOptionExerciseEarliestDateOffsetUnit);
DEFINE_INT(UnderlyingOptionExerciseFrequencyPeriod);
DEFINE_STRING(UnderlyingOptionExerciseFrequencyUnit);
DEFINE_LOCALMKTDATE(UnderlyingOptionExerciseStartDateUnadjusted);
DEFINE_INT(UnderlyingOptionExerciseStartDateRelativeTo);
DEFINE_INT(UnderlyingOptionExerciseStartDateOffsetPeriod);
DEFINE_STRING(UnderlyingOptionExerciseStartDateOffsetUnit);
DEFINE_INT(UnderlyingOptionExerciseStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingOptionExerciseStartDateAdjusted);
DEFINE_INT(UnderlyingOptionExerciseSkip);
DEFINE_LOCALMKTDATE(UnderlyingOptionExerciseNominationDeadline);
DEFINE_LOCALMKTDATE(UnderlyingOptionExerciseFirstDateUnadjusted);
DEFINE_LOCALMKTDATE(UnderlyingOptionExerciseLastDateUnadjusted);
DEFINE_LOCALMKTTIME(UnderlyingOptionExerciseEarliestTime);
DEFINE_LOCALMKTTIME(UnderlyingOptionExerciseLatestTime);
DEFINE_STRING(UnderlyingOptionExerciseTimeBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingOptionExerciseDates);
DEFINE_LOCALMKTDATE(UnderlyingOptionExerciseDate);
DEFINE_INT(UnderlyingOptionExerciseDateType);
DEFINE_NUMINGROUP(NoUnderlyingOptionExerciseExpirationDateBusinessCenters);
DEFINE_STRING(UnderlyingOptionExerciseExpirationDateBusinessCenter);
DEFINE_INT(UnderlyingOptionExerciseExpirationDateBusinessDayConvention);
DEFINE_INT(UnderlyingOptionExerciseExpirationDateRelativeTo);
DEFINE_INT(UnderlyingOptionExerciseExpirationDateOffsetPeriod);
DEFINE_STRING(UnderlyingOptionExerciseExpirationDateOffsetUnit);
DEFINE_INT(UnderlyingOptionExerciseExpirationFrequencyPeriod);
DEFINE_STRING(UnderlyingOptionExerciseExpirationFrequencyUnit);
DEFINE_STRING(UnderlyingOptionExerciseExpirationRollConvention);
DEFINE_INT(UnderlyingOptionExerciseExpirationDateOffsetDayType);
DEFINE_LOCALMKTTIME(UnderlyingOptionExerciseExpirationTime);
DEFINE_STRING(UnderlyingOptionExerciseExpirationTimeBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingOptionExerciseExpirationDates);
DEFINE_LOCALMKTDATE(UnderlyingOptionExerciseExpirationDate);
DEFINE_INT(UnderlyingOptionExerciseExpirationDateType);
DEFINE_STRING(UnderlyingSettlRateIndex);
DEFINE_STRING(UnderlyingSettlRateIndexLocation);
DEFINE_STRING(UnderlyingOptionExpirationDesc);
DEFINE_LENGTH(EncodedUnderlyingOptionExpirationDescLen);
DEFINE_DATA(EncodedUnderlyingOptionExpirationDesc);
DEFINE_STRING(UnderlyingSwapSubClass);
DEFINE_STRING(UnderlyingStrikeUnitOfMeasure);
DEFINE_STRING(UnderlyingStrikeIndex);
DEFINE_PRICEOFFSET(UnderlyingStrikeIndexSpread);
DEFINE_STRING(UnderlyingValuationSource);
DEFINE_STRING(UnderlyingValuationReferenceModel);
DEFINE_STRING(UnderlyingStrategyType);
DEFINE_BOOLEAN(UnderlyingCommonPricingIndicator);
DEFINE_INT(UnderlyingSettlDisruptionProvision);
DEFINE_CHAR(UnderlyingInstrumentRoundingDirection);
DEFINE_INT(UnderlyingInstrumentRoundingPrecision);
DEFINE_INT(UnderlyingMarketDisruptionProvision);
DEFINE_INT(UnderlyingMarketDisruptionFallbackProvision);
DEFINE_INT(UnderlyingMarketDisruptionMaximumDays);
DEFINE_PERCENTAGE(UnderlyingMarketDisruptionMaterialityPercentage);
DEFINE_INT(UnderlyingMarketDisruptionMinimumFuturesContracts);
DEFINE_NUMINGROUP(NoUnderlyingMarketDisruptionEvents);
DEFINE_STRING(UnderlyingMarketDisruptionEvent);
DEFINE_NUMINGROUP(NoUnderlyingMarketDisruptionFallbacks);
DEFINE_STRING(UnderlyingMarketDisruptionFallbackType);
DEFINE_NUMINGROUP(NoUnderlyingMarketDisruptionFallbackReferencePrices);
DEFINE_INT(UnderlyingMarketDisruptionFallbackUnderlierType);
DEFINE_STRING(UnderlyingMarketDisruptionFallbackUnderlierSecurityID);
DEFINE_STRING(UnderlyingMarketDisruptionFallbackUnderlierSecurityIDSource);
DEFINE_STRING(UnderlyingMarketDisruptionFallbackUnderlierSecurityDesc);
DEFINE_LENGTH(EncodedUnderlyingMarketDisruptionFallbackUnderlierSecDescLen);
DEFINE_DATA(EncodedUnderlyingMarketDisruptionFallbackUnderlierSecurityDesc);
DEFINE_QTY(UnderlyingMarketDisruptionFallbackOpenUnits);
DEFINE_CURRENCY(UnderlyingMarketDisruptionFallbackBasketCurrency);
DEFINE_FLOAT(UnderlyingMarketDisruptionFallbackBasketDivisor);
DEFINE_NUMINGROUP(NoUnderlyingPaymentScheduleFixingDays);
DEFINE_INT(UnderlyingPaymentScheduleFixingDayOfWeek);
DEFINE_INT(UnderlyingPaymentScheduleFixingDayNumber);
DEFINE_XID(UnderlyingPaymentScheduleXID);
DEFINE_XIDREF(UnderlyingPaymentScheduleXIDRef);
DEFINE_CURRENCY(UnderlyingPaymentScheduleRateCurrency);
DEFINE_STRING(UnderlyingPaymentScheduleRateUnitOfMeasure);
DEFINE_FLOAT(UnderlyingPaymentScheduleRateConversionFactor);
DEFINE_INT(UnderlyingPaymentScheduleRateSpreadType);
DEFINE_PRICE(UnderlyingPaymentScheduleSettlPeriodPrice);
DEFINE_CURRENCY(UnderlyingPaymentScheduleSettlPeriodPriceCurrency);
DEFINE_STRING(UnderlyingPaymentScheduleSettlPeriodPriceUnitOfMeasure);
DEFINE_STRING(UnderlyingPaymentScheduleStepUnitOfMeasure);
DEFINE_INT(UnderlyingPaymentScheduleFixingDayDistribution);
DEFINE_INT(UnderlyingPaymentScheduleFixingDayCount);
DEFINE_INT(UnderlyingPaymentScheduleFixingLagPeriod);
DEFINE_STRING(UnderlyingPaymentScheduleFixingLagUnit);
DEFINE_INT(UnderlyingPaymentScheduleFixingFirstObservationDateOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentScheduleFixingFirstObservationDateOffsetUnit);
DEFINE_BOOLEAN(UnderlyingPaymentStreamFlatRateIndicator);
DEFINE_AMT(UnderlyingPaymentStreamFlatRateAmount);
DEFINE_CURRENCY(UnderlyingPaymentStreamFlatRateCurrency);
DEFINE_AMT(UnderlyingPaymentStreamMaximumPaymentAmount);
DEFINE_CURRENCY(UnderlyingPaymentStreamMaximumPaymentCurrency);
DEFINE_AMT(UnderlyingPaymentStreamMaximumTransactionAmount);
DEFINE_CURRENCY(UnderlyingPaymentStreamMaximumTransactionCurrency);
DEFINE_STRING(UnderlyingPaymentStreamFixedAmountUnitOfMeasure);
DEFINE_AMT(UnderlyingPaymentStreamTotalFixedAmount);
DEFINE_FLOAT(UnderlyingPaymentStreamWorldScaleRate);
DEFINE_PRICE(UnderlyingPaymentStreamContractPrice);
DEFINE_CURRENCY(UnderlyingPaymentStreamContractPriceCurrency);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamPricingBusinessCenters);
DEFINE_STRING(UnderlyingPaymentStreamPricingBusinessCenter);
DEFINE_STRING(UnderlyingPaymentStreamRateIndex2CurveUnit);
DEFINE_INT(UnderlyingPaymentStreamRateIndex2CurvePeriod);
DEFINE_STRING(UnderlyingPaymentStreamRateIndexLocation);
DEFINE_QTY(UnderlyingPaymentStreamRateIndexLevel);
DEFINE_STRING(UnderlyingPaymentStreamRateIndexUnitOfMeasure);
DEFINE_INT(UnderlyingPaymentStreamSettlLevel);
DEFINE_QTY(UnderlyingPaymentStreamReferenceLevel);
DEFINE_STRING(UnderlyingPaymentStreamReferenceLevelUnitOfMeasure);
DEFINE_BOOLEAN(UnderlyingPaymentStreamReferenceLevelEqualsZeroIndicator);
DEFINE_CURRENCY(UnderlyingPaymentStreamRateSpreadCurrency);
DEFINE_STRING(UnderlyingPaymentStreamRateSpreadUnitOfMeasure);
DEFINE_FLOAT(UnderlyingPaymentStreamRateConversionFactor);
DEFINE_INT(UnderlyingPaymentStreamRateSpreadType);
DEFINE_PERCENTAGE(UnderlyingPaymentStreamLastResetRate);
DEFINE_PERCENTAGE(UnderlyingPaymentStreamFinalRate);
DEFINE_INT(UnderlyingPaymentStreamCalculationLagPeriod);
DEFINE_STRING(UnderlyingPaymentStreamCalculationLagUnit);
DEFINE_INT(UnderlyingPaymentStreamFirstObservationDateOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentStreamFirstObservationDateOffsetUnit);
DEFINE_INT(UnderlyingPaymentStreamPricingDayType);
DEFINE_INT(UnderlyingPaymentStreamPricingDayDistribution);
DEFINE_INT(UnderlyingPaymentStreamPricingDayCount);
DEFINE_STRING(UnderlyingPaymentStreamPricingBusinessCalendar);
DEFINE_INT(UnderlyingPaymentStreamPricingBusinessDayConvention);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamPaymentDates);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamPaymentDate);
DEFINE_INT(UnderlyingPaymentStreamPaymentDateType);
DEFINE_BOOLEAN(UnderlyingPaymentStreamMasterAgreementPaymentDatesIndicator);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamPricingDates);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamPricingDate);
DEFINE_INT(UnderlyingPaymentStreamPricingDateType);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamPricingDays);
DEFINE_INT(UnderlyingPaymentStreamPricingDayOfWeek);
DEFINE_INT(UnderlyingPaymentStreamPricingDayNumber);
DEFINE_NUMINGROUP(NoUnderlyingPricingDateBusinessCenters);
DEFINE_STRING(UnderlyingPricingDateBusinessCenter);
DEFINE_LOCALMKTDATE(UnderlyingPricingDateUnadjusted);
DEFINE_INT(UnderlyingPricingDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(UnderlyingPricingDateAdjusted);
DEFINE_LOCALMKTTIME(UnderlyingPricingTime);
DEFINE_STRING(UnderlyingPricingTimeBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingStreamCalculationPeriodDates);
DEFINE_LOCALMKTDATE(UnderlyingStreamCalculationPeriodDate);
DEFINE_INT(UnderlyingStreamCalculationPeriodDateType);
DEFINE_XID(UnderlyingStreamCalculationPeriodDatesXID);
DEFINE_XIDREF(UnderlyingStreamCalculationPeriodDatesXIDRef);
DEFINE_BOOLEAN(UnderlyingStreamCalculationBalanceOfFirstPeriod);
DEFINE_INT(UnderlyingStreamCalculationCorrectionPeriod);
DEFINE_STRING(UnderlyingStreamCalculationCorrectionUnit);
DEFINE_NUMINGROUP(NoUnderlyingStreamCommoditySettlBusinessCenters);
DEFINE_STRING(UnderlyingStreamCommoditySettlBusinessCenter);
DEFINE_STRING(UnderlyingStreamCommodityBase);
DEFINE_STRING(UnderlyingStreamCommodityType);
DEFINE_STRING(UnderlyingStreamCommoditySecurityID);
DEFINE_STRING(UnderlyingStreamCommoditySecurityIDSource);
DEFINE_STRING(UnderlyingStreamCommodityDesc);
DEFINE_LENGTH(EncodedUnderlyingStreamCommodityDescLen);
DEFINE_DATA(EncodedUnderlyingStreamCommodityDesc);
DEFINE_STRING(UnderlyingStreamCommodityUnitOfMeasure);
DEFINE_CURRENCY(UnderlyingStreamCommodityCurrency);
DEFINE_EXCHANGE(UnderlyingStreamCommodityExchange);
DEFINE_INT(UnderlyingStreamCommodityRateSource);
DEFINE_STRING(UnderlyingStreamCommodityRateReferencePage);
DEFINE_STRING(UnderlyingStreamCommodityRateReferencePageHeading);
DEFINE_STRING(UnderlyingStreamDataProvider);
DEFINE_STRING(UnderlyingStreamCommodityPricingType);
DEFINE_INT(UnderlyingStreamCommodityNearbySettlDayPeriod);
DEFINE_STRING(UnderlyingStreamCommodityNearbySettlDayUnit);
DEFINE_LOCALMKTDATE(UnderlyingStreamCommoditySettlDateUnadjusted);
DEFINE_INT(UnderlyingStreamCommoditySettlDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(UnderlyingStreamCommoditySettlDateAdjusted);
DEFINE_INT(UnderlyingStreamCommoditySettlMonth);
DEFINE_INT(UnderlyingStreamCommoditySettlDateRollPeriod);
DEFINE_STRING(UnderlyingStreamCommoditySettlDateRollUnit);
DEFINE_INT(UnderlyingStreamCommoditySettlDayType);
DEFINE_XID(UnderlyingStreamCommodityXID);
DEFINE_XIDREF(UnderlyingStreamCommodityXIDRef);
DEFINE_NUMINGROUP(NoUnderlyingStreamCommodityAltIDs);
DEFINE_STRING(UnderlyingStreamCommodityAltID);
DEFINE_STRING(UnderlyingStreamCommodityAltIDSource);
DEFINE_NUMINGROUP(NoUnderlyingStreamCommodityDataSources);
DEFINE_STRING(UnderlyingStreamCommodityDataSourceID);
DEFINE_INT(UnderlyingStreamCommodityDataSourceIDType);
DEFINE_NUMINGROUP(NoUnderlyingStreamCommoditySettlDays);
DEFINE_INT(UnderlyingStreamCommoditySettlDay);
DEFINE_INT(UnderlyingStreamCommoditySettlTotalHours);
DEFINE_NUMINGROUP(NoUnderlyingStreamCommoditySettlTimes);
DEFINE_STRING(UnderlyingStreamCommoditySettlStart);
DEFINE_STRING(UnderlyingStreamCommoditySettlEnd);
DEFINE_INT(UnderlyingStreamCommoditySettlTimeType);
DEFINE_NUMINGROUP(NoUnderlyingStreamCommoditySettlPeriods);
DEFINE_COUNTRY(UnderlyingStreamCommoditySettlCountry);
DEFINE_STRING(UnderlyingStreamCommoditySettlTimeZone);
DEFINE_INT(UnderlyingStreamCommoditySettlFlowType);
DEFINE_QTY(UnderlyingStreamCommoditySettlPeriodNotional);
DEFINE_STRING(UnderlyingStreamCommoditySettlPeriodNotionalUnitOfMeasure);
DEFINE_INT(UnderlyingStreamCommoditySettlPeriodFrequencyPeriod);
DEFINE_STRING(UnderlyingStreamCommoditySettlPeriodFrequencyUnit);
DEFINE_PRICE(UnderlyingStreamCommoditySettlPeriodPrice);
DEFINE_STRING(UnderlyingStreamCommoditySettlPeriodPriceUnitOfMeasure);
DEFINE_CURRENCY(UnderlyingStreamCommoditySettlPeriodPriceCurrency);
DEFINE_INT(UnderlyingStreamCommoditySettlHolidaysProcessingInstruction);
DEFINE_XID(UnderlyingStreamCommoditySettlPeriodXID);
DEFINE_XIDREF(UnderlyingStreamCommoditySettlPeriodXIDRef);
DEFINE_XID(UnderlyingStreamXID);
DEFINE_XIDREF(UnderlyingStreamNotionalXIDRef);
DEFINE_INT(UnderlyingStreamNotionalFrequencyPeriod);
DEFINE_STRING(UnderlyingStreamNotionalFrequencyUnit);
DEFINE_INT(UnderlyingStreamNotionalCommodityFrequency);
DEFINE_STRING(UnderlyingStreamNotionalUnitOfMeasure);
DEFINE_QTY(UnderlyingStreamTotalNotional);
DEFINE_STRING(UnderlyingStreamTotalNotionalUnitOfMeasure);
DEFINE_AMT(AllocGrossTradeAmt);
DEFINE_INT(RiskLimitReportStatus);
DEFINE_INT(RiskLimitReportRejectReason);
DEFINE_STRING(RiskLimitCheckRequestID);
DEFINE_STRING(RiskLimitCheckID);
DEFINE_INT(RiskLimitCheckTransType);
DEFINE_INT(RiskLimitCheckType);
DEFINE_INT(RiskLimitCheckRequestRefID);
DEFINE_INT(RiskLimitCheckRequestType);
DEFINE_AMT(RiskLimitCheckAmount);
DEFINE_INT(RiskLimitCheckRequestStatus);
DEFINE_INT(RiskLimitCheckRequestResult);
DEFINE_AMT(RiskLimitApprovedAmount);
DEFINE_STRING(PartyActionRequestID);
DEFINE_INT(PartyActionType);
DEFINE_BOOLEAN(ApplTestMessageIndicator);
DEFINE_STRING(PartyActionReportID);
DEFINE_INT(PartyActionResponse);
DEFINE_INT(PartyActionRejectReason);
DEFINE_STRING(RefRiskLimitCheckID);
DEFINE_INT(RefRiskLimitCheckIDType);
DEFINE_INT(RiskLimitVelocityPeriod);
DEFINE_STRING(RiskLimitVelocityUnit);
DEFINE_INT(RequestingPartyRoleQualifier);
DEFINE_INT(RiskLimitCheckModelType);
DEFINE_INT(RiskLimitCheckStatus);
DEFINE_INT(SideRiskLimitCheckStatus);
DEFINE_NUMINGROUP(NoEntitlementTypes);
DEFINE_PRICE(LegMidPx);
DEFINE_INT(RegulatoryTransactionType);
DEFINE_STRING(BatchID);
DEFINE_INT(BatchTotalMessages);
DEFINE_INT(BatchProcessMode);
DEFINE_STRING(CollateralPortfolioID);
DEFINE_INT(DeliveryStreamDeliveryPointSource);
DEFINE_STRING(DeliveryStreamDeliveryPointDesc);
DEFINE_INT(TradingUnitPeriodMultiplier);
DEFINE_INT(LegTradingUnitPeriodMultiplier);
DEFINE_STRING(LegDeliveryStreamDeliveryPointDesc);
DEFINE_INT(LegDeliveryStreamDeliveryPointSource);
DEFINE_QTY(LegTotalTradeQty);
DEFINE_QTY(LegLastMultipliedQty);
DEFINE_AMT(LegTotalGrossTradeAmt);
DEFINE_QTY(LegTotalTradeMultipliedQty);
DEFINE_STRING(UnderlyingDeliveryStreamDeliveryPointDesc);
DEFINE_INT(UnderlyingDeliveryStreamDeliveryPointSource);
DEFINE_INT(UnderlyingTradingUnitPeriodMultiplier);
DEFINE_INT(PosReportAction);
DEFINE_PRICEOFFSET(SettlForwardPoints);
DEFINE_CHAR(SettlPriceFxRateCalc);
DEFINE_QTY(TotalTradeQty);
DEFINE_QTY(LastMultipliedQty);
DEFINE_AMT(TotalGrossTradeAmt);
DEFINE_QTY(TotalTradeMultipliedQty);
DEFINE_DATA(EncodedTradeContinuationText);
DEFINE_LENGTH(EncodedTradeContinuationTextLen);
DEFINE_BOOLEAN(IntraFirmTradeIndicator);
DEFINE_STRING(TradeContinuationText);
DEFINE_CHAR(TaxonomyType);
DEFINE_INT(PartyRoleQualifier);
DEFINE_INT(DerivativeInstrumentPartyRoleQualifier);
DEFINE_INT(InstrumentPartyRoleQualifier);
DEFINE_INT(LegInstrumentPartyRoleQualifier);
DEFINE_INT(LegProvisionPartyRoleQualifier);
DEFINE_INT(Nested2PartyRoleQualifier);
DEFINE_INT(Nested3PartyRoleQualifier);
DEFINE_INT(Nested4PartyRoleQualifier);
DEFINE_INT(NestedPartyRoleQualifier);
DEFINE_INT(ProvisionPartyRoleQualifier);
DEFINE_INT(RequestedPartyRoleQualifier);
DEFINE_INT(RootPartyRoleQualifier);
DEFINE_INT(SettlPartyRoleQualifier);
DEFINE_INT(UnderlyingInstrumentPartyRoleQualifier);
DEFINE_STRING(AllocRefRiskLimitCheckID);
DEFINE_INT(AllocRefRiskLimitCheckIDType);
DEFINE_AMT(LimitUtilizationAmt);
DEFINE_AMT(LimitAmt);
DEFINE_INT(LimitRole);
DEFINE_INT(RegulatoryTradeIDScope);
DEFINE_INT(SideRegulatoryTradeIDScope);
DEFINE_INT(AllocRegulatoryTradeIDScope);
DEFINE_STRING(AllocRegulatoryLegRefID);
DEFINE_STRING(RegulatoryLegRefID);
DEFINE_STRING(SideRegulatoryLegRefID);
DEFINE_LOCALMKTDATE(EffectiveBusinessDate);
DEFINE_BOOLEAN(ListManualOrderIndicator);
DEFINE_INT(EntitlementSubType);
DEFINE_INT(QuoteModelType);
DEFINE_STRING(ComplianceText);
DEFINE_LENGTH(EncodedComplianceTextLen);
DEFINE_DATA(EncodedComplianceText);
DEFINE_INT(ExecMethod);
DEFINE_INT(PricePrecision);
DEFINE_INT(TradeContingency);
DEFINE_PRICE(ComplexEventSpotRate);
DEFINE_PRICEOFFSET(ComplexEventForwardPoints);
DEFINE_PRICE(LegComplexEventSpotRate);
DEFINE_PRICEOFFSET(LegComplexEventForwardPoints);
DEFINE_STRING(RateSourceReferemcePageHeading);
DEFINE_STRING(RelatedToSecurityID);
DEFINE_STRING(RelatedToSecurityIDSource);
DEFINE_XIDREF(RelatedToStreamXIDRef);
DEFINE_STRING(FirmTradeEventID);
DEFINE_PRICE(UnderlyingComplexEventSpotRate);
DEFINE_PRICEOFFSET(UnderlyingComplexEventForwardPoints);
DEFINE_STRING(LegMarketDisruptionValue);
DEFINE_STRING(LegMarketDisruptionFallbackValue);
DEFINE_STRING(MarketDisruptionValue);
DEFINE_STRING(MarketDisruptionFallbackValue);
DEFINE_INT(PaymentSubType);
DEFINE_STRING(PaymentLegRefID);
DEFINE_STRING(UnderlyingMarketDisruptionValue);
DEFINE_STRING(UnderlyingMarketDisruptionFallbackValue);
DEFINE_NUMINGROUP(NoUnderlyingAdditionalTermBondRefs);
DEFINE_STRING(UnderlyingAdditionalTermBondSecurityID);
DEFINE_STRING(UnderlyingAdditionalTermBondSecurityIDSource);
DEFINE_STRING(UnderlyingAdditionalTermBondDesc);
DEFINE_LENGTH(EncodedUnderlyingAdditionalTermBondDescLen);
DEFINE_DATA(EncodedUnderlyingAdditionalTermBondDesc);
DEFINE_CURRENCY(UnderlyingAdditionalTermBondCurrency);
DEFINE_STRING(UnderlyingAdditionalTermBondIssuer);
DEFINE_LENGTH(EncodedUnderlyingAdditionalTermBondIssuerLen);
DEFINE_DATA(EncodedUnderlyingAdditionalTermBondIssuer);
DEFINE_STRING(UnderlyingAdditionalTermBondSeniority);
DEFINE_INT(UnderlyingAdditionalTermBondCouponType);
DEFINE_PERCENTAGE(UnderlyingAdditionalTermBondCouponRate);
DEFINE_LOCALMKTDATE(UnderlyingAdditionalTermBondMaturityDate);
DEFINE_AMT(UnderlyingAdditionalTermBondParValue);
DEFINE_AMT(UnderlyingAdditionalTermBondCurrentTotalIssuedAmount);
DEFINE_INT(UnderlyingAdditionalTermBondCouponFrequencyPeriod);
DEFINE_STRING(UnderlyingAdditionalTermBondCouponFrequencyUnit);
DEFINE_INT(UnderlyingAdditionalTermBondDayCount);
DEFINE_NUMINGROUP(NoUnderlyingAdditionalTerms);
DEFINE_BOOLEAN(UnderlyingAdditionalTermConditionPrecedentBondIndicator);
DEFINE_BOOLEAN(UnderlyingAdditionalTermDiscrepancyClauseIndicator);
DEFINE_NUMINGROUP(NoUnderlyingCashSettlDealers);
DEFINE_STRING(UnderlyingCashSettlDealer);
DEFINE_NUMINGROUP(NoUnderlyingCashSettlTerms);
DEFINE_CURRENCY(UnderlyingCashSettlCurrency);
DEFINE_INT(UnderlyingCashSettlValuationFirstBusinessDayOffset);
DEFINE_INT(UnderlyingCashSettlValuationSubsequentBusinessDaysOffset);
DEFINE_INT(UnderlyingCashSettlNumOfValuationDates);
DEFINE_LOCALMKTTIME(UnderlyingCashSettlValuationTime);
DEFINE_STRING(UnderlyingCashSettlBusinessCenter);
DEFINE_INT(UnderlyingCashSettlQuoteMethod);
DEFINE_AMT(UnderlyingCashSettlQuoteAmount);
DEFINE_CURRENCY(UnderlyingCashSettlQuoteCurrency);
DEFINE_AMT(UnderlyingCashSettlMinimumQuoteAmount);
DEFINE_CURRENCY(UnderlyingCashSettlMinimumQuoteCurrency);
DEFINE_INT(UnderlyingCashSettlBusinessDays);
DEFINE_AMT(UnderlyingCashSettlAmount);
DEFINE_FLOAT(UnderlyingCashSettlRecoveryFactor);
DEFINE_BOOLEAN(UnderlyingCashSettlFixedTermIndicator);
DEFINE_BOOLEAN(UnderlyingCashSettlAccruedInterestIndicator);
DEFINE_INT(UnderlyingCashSettlValuationMethod);
DEFINE_XID(UnderlyingCashSettlTermXID);
DEFINE_NUMINGROUP(NoUnderlyingPhysicalSettlTerms);
DEFINE_CURRENCY(UnderlyingPhysicalSettlCurrency);
DEFINE_INT(UnderlyingPhysicalSettlBusinessDays);
DEFINE_INT(UnderlyingPhysicalSettlMaximumBusinessDays);
DEFINE_XID(UnderlyingPhysicalSettlTermXID);
DEFINE_NUMINGROUP(NoUnderlyingPhysicalSettlDeliverableObligations);
DEFINE_STRING(UnderlyingPhysicalSettlDeliverableObligationType);
DEFINE_STRING(UnderlyingPhysicalSettlDeliverableObligationValue);
DEFINE_NUMINGROUP(NoUnderlyingProtectionTerms);
DEFINE_AMT(UnderlyingProtectionTermNotional);
DEFINE_CURRENCY(UnderlyingProtectionTermCurrency);
DEFINE_BOOLEAN(UnderlyingProtectionTermSellerNotifies);
DEFINE_BOOLEAN(UnderlyingProtectionTermBuyerNotifies);
DEFINE_STRING(UnderlyingProtectionTermEventBusinessCenter);
DEFINE_BOOLEAN(UnderlyingProtectionTermStandardSources);
DEFINE_INT(UnderlyingProtectionTermEventMinimumSources);
DEFINE_XID(UnderlyingProtectionTermXID);
DEFINE_NUMINGROUP(NoUnderlyingProtectionTermEvents);
DEFINE_STRING(UnderlyingProtectionTermEventType);
DEFINE_STRING(UnderlyingProtectionTermEventValue);
DEFINE_CURRENCY(UnderlyingProtectionTermEventCurrency);
DEFINE_INT(UnderlyingProtectionTermEventPeriod);
DEFINE_STRING(UnderlyingProtectionTermEventUnit);
DEFINE_INT(UnderlyingProtectionTermEventDayType);
DEFINE_STRING(UnderlyingProtectionTermEventRateSource);
DEFINE_NUMINGROUP(NoUnderlyingProtectionTermEventQualifiers);
DEFINE_CHAR(UnderlyingProtectionTermEventQualifier);
DEFINE_NUMINGROUP(NoUnderlyingProtectionTermObligations);
DEFINE_STRING(UnderlyingProtectionTermObligationType);
DEFINE_STRING(UnderlyingProtectionTermObligationValue);
DEFINE_NUMINGROUP(NoUnderlyingProtectionTermEventNewsSources);
DEFINE_STRING(UnderlyingProtectionTermEventNewsSource);
DEFINE_INT(UnderlyingProvisionCashSettlPaymentDateBusinessDayConvention);
DEFINE_INT(UnderlyingProvisionCashSettlPaymentDateRelativeTo);
DEFINE_INT(UnderlyingProvisionCashSettlPaymentDateOffsetPeriod);
DEFINE_STRING(UnderlyingProvisionCashSettlPaymentDateOffsetUnit);
DEFINE_INT(UnderlyingProvisionCashSettlPaymentDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingProvisionCashSettlPaymentDateRangeFirst);
DEFINE_LOCALMKTDATE(UnderlyingProvisionCashSettlPaymentDateRangeLast);
DEFINE_NUMINGROUP(NoUnderlyingProvisionCashSettlPaymentDates);
DEFINE_LOCALMKTDATE(UnderlyingProvisionCashSettlPaymentDate);
DEFINE_INT(UnderlyingProvisionCashSettlPaymentDateType);
DEFINE_INT(UnderlyingProvisionCashSettlQuoteSource);
DEFINE_STRING(UnderlyingProvisionCashSettlQuoteReferencePage);
DEFINE_LOCALMKTTIME(UnderlyingProvisionCashSettlValueTime);
DEFINE_STRING(UnderlyingProvisionCashSettlValueTimeBusinessCenter);
DEFINE_INT(UnderlyingProvisionCashSettlValueDateBusinessDayConvention);
DEFINE_INT(UnderlyingProvisionCashSettlValueDateRelativeTo);
DEFINE_INT(UnderlyingProvisionCashSettlValueDateOffsetPeriod);
DEFINE_STRING(UnderlyingProvisionCashSettlValueDateOffsetUnit);
DEFINE_INT(UnderlyingProvisionCashSettlValueDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingProvisionCashSettlValueDateAdjusted);
DEFINE_NUMINGROUP(NoUnderlyingProvisionOptionExerciseFixedDates);
DEFINE_LOCALMKTDATE(UnderlyingProvisionOptionExerciseFixedDate);
DEFINE_INT(UnderlyingProvisionOptionExerciseFixedDateType);
DEFINE_INT(UnderlyingProvisionOptionExerciseBusinessDayConvention);
DEFINE_INT(UnderlyingProvisionOptionExerciseEarliestDateOffsetPeriod);
DEFINE_STRING(UnderlyingProvisionOptionExerciseEarliestDateOffsetUnit);
DEFINE_INT(UnderlyingProvisionOptionExerciseFrequencyPeriod);
DEFINE_STRING(UnderlyingProvisionOptionExerciseFrequencyUnit);
DEFINE_LOCALMKTDATE(UnderlyingProvisionOptionExerciseStartDateUnadjusted);
DEFINE_INT(UnderlyingProvisionOptionExerciseStartDateRelativeTo);
DEFINE_INT(UnderlyingProvisionOptionExerciseStartDateOffsetPeriod);
DEFINE_STRING(UnderlyingProvisionOptionExerciseStartDateOffsetUnit);
DEFINE_INT(UnderlyingProvisionOptionExerciseStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingProvisionOptionExerciseStartDateAdjusted);
DEFINE_INT(UnderlyingProvisionOptionExercisePeriodSkip);
DEFINE_LOCALMKTDATE(UnderlyingProvisionOptionExerciseBoundsFirstDateUnadjusted);
DEFINE_LOCALMKTDATE(UnderlyingProvisionOptionExerciseBoundsLastDateUnadjusted);
DEFINE_LOCALMKTTIME(UnderlyingProvisionOptionExerciseEarliestTime);
DEFINE_STRING(UnderlyingProvisionOptionExerciseEarliestTimeBusinessCenter);
DEFINE_LOCALMKTTIME(UnderlyingProvisionOptionExerciseLatestTime);
DEFINE_STRING(UnderlyingProvisionOptionExerciseLatestTimeBusinessCenter);
DEFINE_LOCALMKTDATE(UnderlyingProvisionOptionExpirationDateUnadjusted);
DEFINE_INT(UnderlyingProvisionOptionExpirationDateBusinessDayConvention);
DEFINE_INT(UnderlyingProvisionOptionExpirationDateRelativeTo);
DEFINE_INT(UnderlyingProvisionOptionExpirationDateOffsetPeriod);
DEFINE_STRING(UnderlyingProvisionOptionExpirationDateOffsetUnit);
DEFINE_INT(UnderlyingProvisionOptionExpirationDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingProvisionOptionExpirationDateAdjusted);
DEFINE_LOCALMKTTIME(UnderlyingProvisionOptionExpirationTime);
DEFINE_STRING(UnderlyingProvisionOptionExpirationTimeBusinessCenter);
DEFINE_LOCALMKTDATE(UnderlyingProvisionOptionRelevantUnderlyingDateUnadjusted);
DEFINE_INT(UnderlyingProvisionOptionRelevantUnderlyingDateBizDayConvention);
DEFINE_INT(UnderlyingProvisionOptionRelevantUnderlyingDateRelativeTo);
DEFINE_INT(UnderlyingProvisionOptionRelevantUnderlyingDateOffsetPeriod);
DEFINE_STRING(UnderlyingProvisionOptionRelevantUnderlyingDateOffsetUnit);
DEFINE_INT(UnderlyingProvisionOptionRelevantUnderlyingDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingProvisionOptionRelevantUnderlyingDateAdjusted);
DEFINE_NUMINGROUP(NoUnderlyingProvisions);
DEFINE_INT(UnderlyingProvisionType);
DEFINE_LOCALMKTDATE(UnderlyingProvisionDateUnadjusted);
DEFINE_INT(UnderlyingProvisionDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(UnderlyingProvisionDateAdjusted);
DEFINE_INT(UnderlyingProvisionDateTenorPeriod);
DEFINE_STRING(UnderlyingProvisionDateTenorUnit);
DEFINE_INT(UnderlyingProvisionCalculationAgent);
DEFINE_INT(UnderlyingProvisionOptionSinglePartyBuyerSide);
DEFINE_INT(UnderlyingProvisionOptionSinglePartySellerSide);
DEFINE_INT(UnderlyingProvisionOptionExerciseStyle);
DEFINE_AMT(UnderlyingProvisionOptionExerciseMultipleNotional);
DEFINE_AMT(UnderlyingProvisionOptionExerciseMinimumNotional);
DEFINE_AMT(UnderlyingProvisionOptionExerciseMaximumNotional);
DEFINE_INT(UnderlyingProvisionOptionMinimumNumber);
DEFINE_INT(UnderlyingProvisionOptionMaximumNumber);
DEFINE_BOOLEAN(UnderlyingProvisionOptionExerciseConfirmation);
DEFINE_INT(UnderlyingProvisionCashSettlMethod);
DEFINE_CURRENCY(UnderlyingProvisionCashSettlCurrency);
DEFINE_CURRENCY(UnderlyingProvisionCashSettlCurrency2);
DEFINE_INT(UnderlyingProvisionCashSettlQuoteType);
DEFINE_STRING(UnderlyingProvisionText);
DEFINE_LENGTH(EncodedUnderlyingProvisionTextLen);
DEFINE_DATA(EncodedUnderlyingProvisionText);
DEFINE_NUMINGROUP(NoUnderlyingProvisionPartyIDs);
DEFINE_STRING(UnderlyingProvisionPartyID);
DEFINE_CHAR(UnderlyingProvisionPartyIDSource);
DEFINE_INT(UnderlyingProvisionPartyRole);
DEFINE_INT(UnderlyingProvisionPartyRoleQualifier);
DEFINE_NUMINGROUP(NoUnderlyingProvisionPartySubIDs);
DEFINE_STRING(UnderlyingProvisionPartySubID);
DEFINE_INT(UnderlyingProvisionPartySubIDType);
DEFINE_NUMINGROUP(NoUnderlyingProvisionCashSettlPaymentDateBusinessCenters);
DEFINE_STRING(UnderlyingProvisionCashSettlPaymentDateBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingProvisionCashSettlValueDateBusinessCenters);
DEFINE_STRING(UnderlyingProvisionCashSettlValueDateBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingProvisionOptionExerciseBusinessCenters);
DEFINE_STRING(UnderlyingProvisionOptionExerciseBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingProvisionOptionExpirationDateBusinessCenters);
DEFINE_STRING(UnderlyingProvisionOptionExpirationDateBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingProvisionOptionRelevantUnderlyingDateBusinessCenters);
DEFINE_STRING(UnderlyingProvisionOptionRelevantUnderlyingDateBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingProvisionDateBusinessCenters);
DEFINE_STRING(UnderlyingProvisionDateBusinessCenter);
DEFINE_STRING(FillRefID);
DEFINE_INT(OrderRequestID);
DEFINE_STRING(MassOrderRequestID);
DEFINE_STRING(MassOrderReportID);
DEFINE_INT(MassOrderRequestStatus);
DEFINE_INT(MassOrderRequestResult);
DEFINE_INT(OrderResponseLevel);
DEFINE_NUMINGROUP(NoOrderEntries);
DEFINE_CHAR(OrderEntryAction);
DEFINE_INT(OrderEntryID);
DEFINE_INT(ExecTypeReason);
DEFINE_INT(TotNoOrderEntries);
DEFINE_NUMINGROUP(NoTargetPartySubIDs);
DEFINE_STRING(TargetPartySubID);
DEFINE_INT(TargetPartySubIDType);
DEFINE_STRING(TransferInstructionID);
DEFINE_STRING(TransferID);
DEFINE_STRING(TransferReportID);
DEFINE_INT(TransferTransType);
DEFINE_INT(TransferType);
DEFINE_INT(TransferScope);
DEFINE_INT(TransferStatus);
DEFINE_INT(TransferRejectReason);
DEFINE_INT(TransferReportType);
DEFINE_UTCTIMESTAMP(AggressorTime);
DEFINE_CHAR(AggressorSide);
DEFINE_BOOLEAN(FastMarketIndicator);
DEFINE_BOOLEAN(LinkageHandlingIndicator);
DEFINE_INT(NumberOfBuyOrders);
DEFINE_INT(NumberOfSellOrders);
DEFINE_INT(SettlPriceDeterminationMethod);
DEFINE_STRING(MDStatisticReqID);
DEFINE_STRING(MDStatisticRptID);
DEFINE_STRING(MDStatisticName);
DEFINE_STRING(MDStatisticDesc);
DEFINE_INT(MDStatisticType);
DEFINE_INT(MDStatisticScope);
DEFINE_INT(MDStatisticSubScope);
DEFINE_INT(MDStatisticScopeType);
DEFINE_INT(MDStatisticFrequencyPeriod);
DEFINE_INT(MDStatisticFrequencyUnit);
DEFINE_INT(MDStatisticDelayPeriod);
DEFINE_INT(MDStatisticDelayUnit);
DEFINE_INT(MDStatisticIntervalType);
DEFINE_STRING(MDStatisticIntervalTypeUnit);
DEFINE_INT(MDStatisticIntervalPeriod);
DEFINE_INT(MDStatisticIntervalUnit);
DEFINE_UTCTIMESTAMP(MDStatisticStartDate);
DEFINE_UTCTIMESTAMP(MDStatisticEndDate);
DEFINE_UTCTIMEONLY(MDStatisticStartTime);
DEFINE_UTCTIMEONLY(MDStatisticEndTime);
DEFINE_INT(MDStatisticRatioType);
DEFINE_INT(MDStatisticRequestResult);
DEFINE_NUMINGROUP(NoMDStatistics);
DEFINE_STRING(MDStatisticID);
DEFINE_UTCTIMESTAMP(MDStatisticTime);
DEFINE_INT(MDStatisticStatus);
DEFINE_FLOAT(MDStatisticValue);
DEFINE_INT(MDStatisticValueType);
DEFINE_INT(MDStatisticValueUnit);
DEFINE_LENGTH(EncodedMDStatisticDescLen);
DEFINE_DATA(EncodedMDStatisticDesc);
DEFINE_INT(AllocRiskLimitCheckStatus);
DEFINE_INT(AssetGroup);
DEFINE_INT(LegAssetGroup);
DEFINE_STRING(LegContractualDefinition);
DEFINE_NUMINGROUP(NoLegContractualDefinitions);
DEFINE_LOCALMKTDATE(LegContractualMatrixDate);
DEFINE_STRING(LegContractualMatrixSource);
DEFINE_STRING(LegContractualMatrixTerm);
DEFINE_NUMINGROUP(NoLegContractualMatrices);
DEFINE_DATA(EncodedLegDocumentationText);
DEFINE_LENGTH(EncodedLegDocumentationTextLen);
DEFINE_CURRENCY(LegAgreementCurrency);
DEFINE_LOCALMKTDATE(LegAgreementDate);
DEFINE_STRING(LegAgreementDesc);
DEFINE_STRING(LegAgreementID);
DEFINE_STRING(LegAgreementVersion);
DEFINE_STRING(LegBrokerConfirmationDesc);
DEFINE_LOCALMKTDATE(LegCreditSupportAgreementDate);
DEFINE_STRING(LegCreditSupportAgreementDesc);
DEFINE_STRING(LegCreditSupportAgreementID);
DEFINE_INT(LegDeliveryType);
DEFINE_STRING(LegDocumentationText);
DEFINE_LOCALMKTDATE(LegEndDate);
DEFINE_STRING(LegGoverningLaw);
DEFINE_PERCENTAGE(LegMarginRatio);
DEFINE_LOCALMKTDATE(LegMasterConfirmationAnnexDate);
DEFINE_LOCALMKTDATE(LegMasterConfirmationDate);
DEFINE_STRING(LegMasterConfirmationDesc);
DEFINE_STRING(LegMasterConfirmationAnnexDesc);
DEFINE_LOCALMKTDATE(LegStartDate);
DEFINE_INT(LegTerminationType);
DEFINE_LOCALMKTDATE(LegFinancingTermSupplementDate);
DEFINE_STRING(LegFinancingTermSupplementDesc);
DEFINE_NUMINGROUP(NoLegFinancingTermSupplements);
DEFINE_INT(UnderlyingAssetGroup);
DEFINE_STRING(FirmTransactionID);
DEFINE_STRING(TransactionID);
DEFINE_STRING(WireReference);
DEFINE_INT(CollRptRejectReason);
DEFINE_INT(CollRptStatus);
DEFINE_STRING(PackageID);
DEFINE_INT(TradeNumber);
DEFINE_QTY(AllocCalculatedCcyQty);
DEFINE_STRING(CollateralRequestInstruction);
DEFINE_STRING(CollateralRequestLinkID);
DEFINE_INT(CollateralRequestNumber);
DEFINE_INT(TotNumCollateralRequests);
DEFINE_STRING(WarningText);
DEFINE_DATA(EncodedWarningText);
DEFINE_LENGTH(EncodedWarningTextLen);
DEFINE_STRING(LegStreamCommodityDeliveryPricingRegion);
DEFINE_STRING(StreamCommodityDeliveryPricingRegion);
DEFINE_BOOLEAN(AffiliatedFirmsTradeIndicator);
DEFINE_BOOLEAN(InternationalSwapIndicator);
DEFINE_BOOLEAN(MultiAssetSwapIndicator);
DEFINE_STRING(UnderlyingStreamCommodityDeliveryPricingRegion);
DEFINE_NUMINGROUP(NoRelativeValues);
DEFINE_INT(RelativeValueType);
DEFINE_FLOAT(RelativeValue);
DEFINE_INT(RelativeValueSide);
DEFINE_FLOAT(BidSpread);
DEFINE_FLOAT(OfferSpread);
DEFINE_PRICE(ClearingSettlPrice);
DEFINE_INT(MDReportEvent);
DEFINE_INT(MDReportCount);
DEFINE_INT(TotNoMarketSegmentReports);
DEFINE_INT(TotNoInstrumentReports);
DEFINE_INT(TotNoPartyDetailReports);
DEFINE_INT(TotNoEntitlementReports);
DEFINE_INT(TotNoRiskLimitReports);
DEFINE_INT(MarketSegmentStatus);
DEFINE_INT(MarketSegmentType);
DEFINE_INT(MarketSegmentSubType);
DEFINE_NUMINGROUP(NoRelatedMarketSegments);
DEFINE_STRING(RelatedMarketSegmentID);
DEFINE_INT(MarketSegmentRelationship);
DEFINE_NUMINGROUP(NoAuctionTypeRules);
DEFINE_STRING(AuctionTypeProductComplex);
DEFINE_NUMINGROUP(NoPriceRangeRules);
DEFINE_PRICE(StartPriceRange);
DEFINE_PRICE(EndPriceRange);
DEFINE_PRICE(PriceRangeValue);
DEFINE_PERCENTAGE(PriceRangePercentage);
DEFINE_STRING(PriceRangeProductComplex);
DEFINE_STRING(PriceRangeRuleID);
DEFINE_PERCENTAGE(FastMarketPercentage);
DEFINE_NUMINGROUP(NoQuoteSizeRules);
DEFINE_BOOLEAN(QuoteSideIndicator);
DEFINE_NUMINGROUP(NoFlexProductEligibilities);
DEFINE_STRING(FlexProductEligibilityComplex);
DEFINE_INT(NumOfComplexInstruments);
DEFINE_INT(MarketDepthTimeInterval);
DEFINE_INT(MarketDepthTimeIntervalUnit);
DEFINE_INT(MDRecoveryTimeInterval);
DEFINE_INT(MDRecoveryTimeIntervalUnit);
DEFINE_STRING(PrimaryServiceLocationID);
DEFINE_STRING(SecondaryServiceLocationID);
DEFINE_STRING(MatchRuleProductComplex);
DEFINE_INT(CustomerPriority);
DEFINE_STRING(TickRuleProductComplex);
DEFINE_AMT(PreviousAdjustedOpenInterest);
DEFINE_AMT(PreviousUnadjustedOpenInterest);
DEFINE_BOOLEAN(LowExercisePriceOptionIndicator);
DEFINE_BOOLEAN(BlockTradeEligibilityIndicator);
DEFINE_INT(InstrumentPricePrecision);
DEFINE_INT(StrikePricePrecision);
DEFINE_PRICE(OrigStrikePrice);
DEFINE_INT(SettlSubMethod);
DEFINE_NUMINGROUP(NoClearingPriceParameters);
DEFINE_INT(BusinessDayType);
DEFINE_PRICEOFFSET(ClearingPriceOffset);
DEFINE_FLOAT(VegaMultiplier);
DEFINE_INT(AnnualTradingBusinessDays);
DEFINE_INT(TotalTradingBusinessDays);
DEFINE_INT(TradingBusinessDays);
DEFINE_FLOAT(RealizedVariance);
DEFINE_FLOAT(StandardVariance);
DEFINE_PRICE(RelatedClosePrice);
DEFINE_FLOAT(OvernightInterestRate);
DEFINE_FLOAT(AccumulatedReturnModifiedVariationMargin);
DEFINE_INT(CalculationMethod);
DEFINE_NUMINGROUP(NoMiscFeeSubTypes);
DEFINE_STRING(MiscFeeSubType);
DEFINE_AMT(MiscFeeSubTypeAmt);
DEFINE_STRING(MiscFeeSubTypeDesc);
DEFINE_LENGTH(EncodedMiscFeeSubTypeDescLen);
DEFINE_DATA(EncodedMiscFeeSubTypeDesc);
DEFINE_INT(CollateralAmountType);
DEFINE_STRING(PositionID);
DEFINE_STRING(PaymentDesc);
DEFINE_NUMINGROUP(NoCommissions);
DEFINE_AMT(CommissionAmount);
DEFINE_INT(CommissionAmountType);
DEFINE_CHAR(CommissionBasis);
DEFINE_CURRENCY(CommissionCurrency);
DEFINE_STRING(CommissionUnitOfMeasure);
DEFINE_CURRENCY(CommissionUnitOfMeasureCurrency);
DEFINE_FLOAT(CommissionRate);
DEFINE_BOOLEAN(CommissionSharedIndicator);
DEFINE_AMT(CommissionAmountShared);
DEFINE_STRING(CommissionLegRefID);
DEFINE_STRING(CommissionDesc);
DEFINE_LENGTH(EncodedCommissionDescLen);
DEFINE_DATA(EncodedCommissionDesc);
DEFINE_NUMINGROUP(NoAllocCommissions);
DEFINE_AMT(AllocCommissionAmount);
DEFINE_INT(AllocCommissionAmountType);
DEFINE_CHAR(AllocCommissionBasis);
DEFINE_CURRENCY(AllocCommissionCurrency);
DEFINE_STRING(AllocCommissionUnitOfMeasure);
DEFINE_CURRENCY(AllocCommissionUnitOfMeasureCurrency);
DEFINE_FLOAT(AllocCommissionRate);
DEFINE_BOOLEAN(AllocCommissionSharedIndicator);
DEFINE_AMT(AllocCommissionAmountShared);
DEFINE_STRING(AllocCommissionLegRefID);
DEFINE_STRING(AllocCommissionDesc);
DEFINE_LENGTH(EncodedAllocCommissionDescLen);
DEFINE_DATA(EncodedAllocCommissionDesc);
DEFINE_BOOLEAN(DeltaCrossed);
DEFINE_LOCALMKTDATE(CashSettlDateUnadjusted);
DEFINE_INT(CashSettlDateBusinessDayConvention);
DEFINE_INT(CashSettlDateRelativeTo);
DEFINE_INT(CashSettlDateOffsetPeriod);
DEFINE_STRING(CashSettlDateOffsetUnit);
DEFINE_INT(CashSettlDateOffsetDayType);
DEFINE_LOCALMKTDATE(CashSettlDateAdjusted);
DEFINE_NUMINGROUP(NoCashSettlDateBusinessCenters);
DEFINE_STRING(CashSettlDateBusinessCenter);
DEFINE_STRING(CashSettlPriceSource);
DEFINE_INT(CashSettlPriceDefault);
DEFINE_BOOLEAN(ComplexEventFuturesPriceValuation);
DEFINE_BOOLEAN(ComplexEventOptionsPriceValuation);
DEFINE_INT(ComplexEventPVFinalPriceElectionFallback);
DEFINE_STRING(DividendFloatingRateIndex);
DEFINE_INT(DividendFloatingRateIndexCurvePeriod);
DEFINE_STRING(DividendFloatingRateIndexCurveUnit);
DEFINE_FLOAT(DividendFloatingRateMultiplier);
DEFINE_PRICEOFFSET(DividendFloatingRateSpread);
DEFINE_INT(DividendFloatingRateSpreadPositionType);
DEFINE_INT(DividendFloatingRateTreatment);
DEFINE_PERCENTAGE(DividendCapRate);
DEFINE_INT(DividendCapRateBuySide);
DEFINE_INT(DividendCapRateSellSide);
DEFINE_PERCENTAGE(DividendFloorRate);
DEFINE_INT(DividendFloorRateBuySide);
DEFINE_INT(DividendFloorRateSellSide);
DEFINE_PERCENTAGE(DividendInitialRate);
DEFINE_CHAR(DividendFinalRateRoundingDirection);
DEFINE_INT(DividendFinalRatePrecision);
DEFINE_INT(DividendAveragingMethod);
DEFINE_INT(DividendNegativeRateTreatment);
DEFINE_NUMINGROUP(NoDividendAccrualPaymentDateBusinessCenters);
DEFINE_STRING(DividendAccrualPaymentDateBusinessCenter);
DEFINE_INT(DividendAccrualPaymentDateRelativeTo);
DEFINE_INT(DividendAccrualPaymentDateOffsetPeriod);
DEFINE_STRING(DividendAccrualPaymentDateOffsetUnit);
DEFINE_INT(DividendAccrualPaymentDateOffsetDayType);
DEFINE_LOCALMKTDATE(DividendAccrualPaymentDateUnadjusted);
DEFINE_INT(DividendAccrualPaymeentDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(DividendAccrualPaymentDateAdjusted);
DEFINE_BOOLEAN(DividendReinvestmentIndicator);
DEFINE_INT(DividendEntitlementEvent);
DEFINE_INT(DividendAmountType);
DEFINE_STRING(DividendUnderlierRefID);
DEFINE_INT(ExtraordinaryDividendPartySide);
DEFINE_INT(ExtraordinaryDividendAmountType);
DEFINE_CURRENCY(ExtraordinaryDividendCurrency);
DEFINE_STRING(ExtraordinaryDividendDeterminationMethod);
DEFINE_PERCENTAGE(DividendAccrualFixedRate);
DEFINE_INT(DividendCompoundingMethod);
DEFINE_INT(DividendNumOfIndexUnits);
DEFINE_PERCENTAGE(DividendCashPercentage);
DEFINE_PERCENTAGE(DividendCashEquivalentPercentage);
DEFINE_INT(NonCashDividendTreatment);
DEFINE_INT(DividendComposition);
DEFINE_BOOLEAN(SpecialDividendsIndicator);
DEFINE_BOOLEAN(MaterialDividendsIndicator);
DEFINE_BOOLEAN(OptionsExchangeDividendsIndicator);
DEFINE_BOOLEAN(AdditionalDividendsIndicator);
DEFINE_BOOLEAN(AllDividendsIndicator);
DEFINE_INT(DividendFXTriggerDateRelativeTo);
DEFINE_INT(DividendFXTriggerDateOffsetPeriod);
DEFINE_STRING(DividendFXTriggerDateOffsetUnit);
DEFINE_INT(DividendFXTriggerDateOffsetDayType);
DEFINE_LOCALMKTDATE(DividendFXTriggerDateUnadjusted);
DEFINE_INT(DividendFXTriggerDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(DividendFXTriggerDateAdjusted);
DEFINE_NUMINGROUP(NoDividendFXTriggerDateBusinessCenters);
DEFINE_STRING(DividendFXTriggerDateBusinessCenter);
DEFINE_NUMINGROUP(NoDividendPeriods);
DEFINE_INT(DividendPeriodSequence);
DEFINE_LOCALMKTDATE(DividendPeriodStartDateUnadjusted);
DEFINE_LOCALMKTDATE(DividendPeriodEndDateUnadjusted);
DEFINE_STRING(DividendPeriodUnderlierRefID);
DEFINE_PRICE(DividendPeriodStrikePrice);
DEFINE_INT(DividendPeriodBusinessDayConvention);
DEFINE_LOCALMKTDATE(DividendPeriodValuationDateUnadjusted);
DEFINE_INT(DividendPeriodValuationDateRelativeTo);
DEFINE_INT(DividendPeriodValuationDateOffsetPeriod);
DEFINE_STRING(DividendPeriodValuationDateOffsetUnit);
DEFINE_INT(DividendPeriodValuationDateOffsetDayType);
DEFINE_LOCALMKTDATE(DividendPeriodValuationDateAdjusted);
DEFINE_LOCALMKTDATE(DividendPeriodPaymentDateUnadjusted);
DEFINE_INT(DividendPeriodPaymentDateRelativeTo);
DEFINE_INT(DividendPeriodPaymentDateOffsetPeriod);
DEFINE_STRING(DividendPeriodPaymentDateOffsetUnit);
DEFINE_INT(DividendPeriodPaymentDateOffsetDayType);
DEFINE_LOCALMKTDATE(DividendPeriodPaymentDateAdjusted);
DEFINE_XID(DividendPeriodXID);
DEFINE_NUMINGROUP(NoDividendPeriodBusinessCenters);
DEFINE_STRING(DividendPeriodBusinessCenter);
DEFINE_NUMINGROUP(NoExtraordinaryEvents);
DEFINE_STRING(ExtraordinaryEventType);
DEFINE_STRING(ExtraordinaryEventValue);
DEFINE_STRING(StrikeIndexCurvePoint);
DEFINE_INT(StrikeIndexQuote);
DEFINE_INT(ExtraordinaryEventAdjustmentMethod);
DEFINE_BOOLEAN(ExchangeLookAlike);
DEFINE_STRING(LegStrikeIndexCurvePoint);
DEFINE_INT(LegStrikeIndexQuote);
DEFINE_INT(LegExtraordinaryEventAdjustmentMethod);
DEFINE_BOOLEAN(LegExchangeLookAlike);
DEFINE_LOCALMKTDATE(LegCashSettlDateUnadjusted);
DEFINE_INT(LegCashSettlDateBusinessDayConvention);
DEFINE_INT(LegCashSettlDateRelativeTo);
DEFINE_INT(LegCashSettlDateOffsetPeriod);
DEFINE_STRING(LegCashSettlDateOffsetUnit);
DEFINE_INT(LegCashSettlDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegCashSettlDateAdjusted);
DEFINE_NUMINGROUP(NoLegCashSettlDateBusinessCenters);
DEFINE_STRING(LegCashSettlDateBusinessCenter);
DEFINE_STRING(LegCashSettlPriceSource);
DEFINE_INT(LegCashSettlPriceDefault);
DEFINE_BOOLEAN(LegComplexEventFuturesPriceValuation);
DEFINE_BOOLEAN(LegComplexEventOptionsPriceValuation);
DEFINE_INT(LegComplexEventPVFinalPriceElectionFallback);
DEFINE_NUMINGROUP(NoLegDividendAccrualPaymentDateBusinessCenters);
DEFINE_STRING(LegDividendAccrualPaymentDateBusinessCenter);
DEFINE_STRING(LegDividendFloatingRateIndex);
DEFINE_INT(LegDividendFloatingRateIndexCurvePeriod);
DEFINE_STRING(LegDividendFloatingRateIndexCurveUnit);
DEFINE_FLOAT(LegDividendFloatingRateMultiplier);
DEFINE_PRICEOFFSET(LegDividendFloatingRateSpread);
DEFINE_INT(LegDividendFloatingRateSpreadPositionType);
DEFINE_INT(LegDividendFloatingRateTreatment);
DEFINE_PERCENTAGE(LegDividendCapRate);
DEFINE_INT(LegDividendCapRateBuySide);
DEFINE_INT(LegDividendCapRateSellSide);
DEFINE_PERCENTAGE(LegDividendFloorRate);
DEFINE_INT(LegDividendFloorRateBuySide);
DEFINE_INT(LegDividendFloorRateSellSide);
DEFINE_PERCENTAGE(LegDividendInitialRate);
DEFINE_CHAR(LegDividendFinalRateRoundingDirection);
DEFINE_INT(LegDividendFinalRatePrecision);
DEFINE_INT(LegDividendAveragingMethod);
DEFINE_INT(LegDividendNegativeRateTreatment);
DEFINE_INT(LegDividendAccrualPaymentDateRelativeTo);
DEFINE_INT(LegDividendAccrualPaymentDateOffsetPeriod);
DEFINE_STRING(LegDividendAccrualPaymentDateOffsetUnit);
DEFINE_INT(LegDividendAccrualPaymentDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegDividendAccrualPaymentDateUnadjusted);
DEFINE_INT(LegDividendAccrualPaymentDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(LegDividendAccrualPaymentDateAdjusted);
DEFINE_BOOLEAN(LegDividendReinvestmentIndicator);
DEFINE_INT(LegDividendEntitlementEvent);
DEFINE_INT(LegDividendAmountType);
DEFINE_STRING(LegDividendUnderlierRefID);
DEFINE_INT(LegExtraordinaryDividendPartySide);
DEFINE_INT(LegExtraordinaryDividendAmountType);
DEFINE_CURRENCY(LegExtraordinaryDividendCurrency);
DEFINE_STRING(LegExtraordinaryDividendDeterminationMethod);
DEFINE_PERCENTAGE(LegDividendAccrualFixedRate);
DEFINE_INT(LegDividendCompoundingMethod);
DEFINE_INT(LegDividendNumOfIndexUnits);
DEFINE_PERCENTAGE(LegDividendCashPercentage);
DEFINE_PERCENTAGE(LegDividendCashEquivalentPercentage);
DEFINE_INT(LegNonCashDividendTreatment);
DEFINE_INT(LegDividendComposition);
DEFINE_BOOLEAN(LegSpecialDividendsIndicator);
DEFINE_BOOLEAN(LegMaterialDividendsIndicator);
DEFINE_BOOLEAN(LegOptionsExchangeDividendsIndicator);
DEFINE_BOOLEAN(LegAdditionalDividendsIndicator);
DEFINE_BOOLEAN(LegAllDividendsIndicator);
DEFINE_INT(LegDividendFXTriggerDateRelativeTo);
DEFINE_INT(LegDividendFXTriggerDateOffsetPeriod);
DEFINE_STRING(LegDividendFXTriggerDateOffsetUnit);
DEFINE_INT(LegDividendFXTriggerDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegDividendFXTriggerDateUnadjusted);
DEFINE_INT(LegDividendFXTriggerDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(LegDividendFXTriggerDateAdjusted);
DEFINE_NUMINGROUP(NoLegDividendFXTriggerDateBusinessCenters);
DEFINE_STRING(LegDividendFXTriggerDateBusinessCenter);
DEFINE_NUMINGROUP(NoLegDividendPeriods);
DEFINE_INT(LegDividendPeriodSequence);
DEFINE_LOCALMKTDATE(LegDividendPeriodStartDateUnadjusted);
DEFINE_LOCALMKTDATE(LegDividendPeriodEndDateUnadjusted);
DEFINE_STRING(LegDividendPeriodUnderlierRefID);
DEFINE_PRICE(LegDividendPeriodStrikePrice);
DEFINE_INT(LegDividendPeriodBusinessDayConvention);
DEFINE_LOCALMKTDATE(LegDividendPeriodValuationDateUnadjusted);
DEFINE_INT(LegDividendPeriodValuationDateRelativeTo);
DEFINE_INT(LegDividendPeriodValuationDateOffsetPeriod);
DEFINE_STRING(LegDividendPeriodValuationDateOffsetUnit);
DEFINE_INT(LegDividendPeriodValuationDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegDividendPeriodValuationDateAdjusted);
DEFINE_LOCALMKTDATE(LegDividendPeriodPaymentDateUnadjusted);
DEFINE_INT(LegDividendPeriodPaymentDateRelativeTo);
DEFINE_INT(LegDividendPeriodPaymentDateOffsetPeriod);
DEFINE_STRING(LegDividendPeriodPaymentDateOffsetUnit);
DEFINE_INT(LegDividendPeriodPaymentDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegDividendPeriodPaymentDateAdjusted);
DEFINE_XID(LegDividendPeriodXID);
DEFINE_NUMINGROUP(NoLegDividendPeriodBusinessCenters);
DEFINE_STRING(LegDividendPeriodBusinessCenter);
DEFINE_NUMINGROUP(NoLegExtraordinaryEvents);
DEFINE_STRING(LegExtraordinaryEventType);
DEFINE_STRING(LegExtraordinaryEventValue);
DEFINE_INT(LegSettlMethodElectingPartySide);
DEFINE_LOCALMKTDATE(LegMakeWholeDate);
DEFINE_AMT(LegMakeWholeAmount);
DEFINE_STRING(LegMakeWholeBenchmarkCurveName);
DEFINE_STRING(LegMakeWholeBenchmarkCurvePoint);
DEFINE_PRICEOFFSET(LegMakeWholeRecallSpread);
DEFINE_INT(LegMakeWholeBenchmarkQuote);
DEFINE_INT(LegMakeWholeInterpolationMethod);
DEFINE_BOOLEAN(LegPaymentStreamCashSettlIndicator);
DEFINE_XIDREF(LegPaymentStreamCompoundingXIDRef);
DEFINE_PRICEOFFSET(LegPaymentStreamCompoundingSpread);
DEFINE_INT(LegPaymentStreamInterpolationMethod);
DEFINE_INT(LegPaymentStreamInterpolationPeriod);
DEFINE_FLOAT(LegPaymentStreamCompoundingFixedRate);
DEFINE_NUMINGROUP(NoLegPaymentStreamCompoundingDates);
DEFINE_LOCALMKTDATE(LegPaymentStreamCompoundingDate);
DEFINE_INT(LegPaymentStreamCompoundingDateType);
DEFINE_INT(LegPaymentStreamCompoundingDatesBusinessDayConvention);
DEFINE_INT(LegPaymentStreamCompoundingDatesRelativeTo);
DEFINE_INT(LegPaymentStreamCompoundingDatesOffsetPeriod);
DEFINE_STRING(LegPaymentStreamCompoundingDatesOffsetUnit);
DEFINE_INT(LegPaymentStreamCompoundingDatesOffsetDayType);
DEFINE_INT(LegPaymentStreamCompoundingPeriodSkip);
DEFINE_INT(LegPaymentStreamCompoundingFrequencyPeriod);
DEFINE_STRING(LegPaymentStreamCompoundingFrequencyUnit);
DEFINE_STRING(LegPaymentStreamCompoundingRollConvention);
DEFINE_LOCALMKTDATE(LegPaymentStreamBoundsFirstDateUnadjusted);
DEFINE_LOCALMKTDATE(LegPaymentStreamBoundsLastDateUnadjusted);
DEFINE_NUMINGROUP(NoLegPaymentStreamCompoundingDatesBusinessCenters);
DEFINE_STRING(LegPaymentStreamCompoundingDatesBusinessCenter);
DEFINE_LOCALMKTDATE(LegPaymentStreamCompoundingEndDateUnadjusted);
DEFINE_INT(LegPaymentStreamCompoundingEndDateRelativeTo);
DEFINE_INT(LegPaymentStreamCompoundingEndDateOffsetPeriod);
DEFINE_STRING(LegPaymentStreamCompoundingEndDateOffsetUnit);
DEFINE_INT(LegPaymentStreamCompoundingEndDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegPaymentStreamCompoundingEndDateAdjusted);
DEFINE_STRING(LegPaymentStreamCompoundingRateIndex);
DEFINE_INT(LegPaymentStreamCompoundingRateIndexCurvePeriod);
DEFINE_STRING(LegPaymentStreamCompoundingRateIndexCurveUnit);
DEFINE_FLOAT(LegPaymentStreamCompoundingRateMultiplier);
DEFINE_PRICEOFFSET(LegPaymentStreamCompoundingRateSpread);
DEFINE_INT(LegPaymentStreamCompoundingRateSpreadPositionType);
DEFINE_INT(LegPaymentStreamCompoundingRateTreatment);
DEFINE_PERCENTAGE(LegPaymentStreamCompoundingCapRate);
DEFINE_INT(LegPaymentStreamCompoundingCapRateBuySide);
DEFINE_INT(LegPaymentStreamCompoundingCapRateSellSide);
DEFINE_PERCENTAGE(LegPaymentStreamCompoundingFloorRate);
DEFINE_INT(LegPaymentStreamCompoundingFloorRateBuySide);
DEFINE_INT(LegPaymentStreamCompoundingFloorRateSellSide);
DEFINE_PERCENTAGE(LegPaymentStreamCompoundingInitialRate);
DEFINE_CHAR(LegPaymentStreamCompoundingFinalRateRoundingDirection);
DEFINE_INT(LegPaymentStreamCompoundingFinalRatePrecision);
DEFINE_INT(LegPaymentStreamCompoundingAveragingMethod);
DEFINE_INT(LegPaymentStreamCompoundingNegativeRateTreatment);
DEFINE_LOCALMKTDATE(LegPaymentStreamCompoundingStartDateUnadjusted);
DEFINE_INT(LegPaymentStreamCompoundingStartDateRelativeTo);
DEFINE_INT(LegPaymentStreamCompoundingStartDateOffsetPeriod);
DEFINE_STRING(LegPaymentStreamCompoundingStartDateOffsetUnit);
DEFINE_INT(LegPaymentStreamCompoundingStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegPaymentStreamCompoundingStartDateAdjusted);
DEFINE_LENGTH(LegPaymentStreamFormulaImageLength);
DEFINE_DATA(LegPaymentStreamFormulaImage);
DEFINE_LOCALMKTDATE(LegPaymentStreamFinalPricePaymentDateUnadjusted);
DEFINE_INT(LegPaymentStreamFinalPricePaymentDateRelativeTo);
DEFINE_INT(LegPaymentStreamFinalPricePaymentDateOffsetPeriod);
DEFINE_STRING(LegPaymentStreamFinalPricePaymentDateOffsetUnit);
DEFINE_INT(LegPaymentStreamFinalPricePaymentDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegPaymentStreamFinalPricePaymentDateAdjusted);
DEFINE_NUMINGROUP(NoLegPaymentStreamFixingDates);
DEFINE_LOCALMKTDATE(LegPaymentStreamFixingDate);
DEFINE_INT(LegPaymentStreamFixingDateType);
DEFINE_LOCALMKTDATE(LegPaymentStreamFirstObservationDateUnadjusted);
DEFINE_INT(LegPaymentStreamFirstObservationDateRelativeTo);
DEFINE_INT(LegPaymentStreamFirstObservationDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegPaymentStreamFirstObservationDateAdjusted);
DEFINE_STRING(LegPaymentStreamUnderlierRefID);
DEFINE_BOOLEAN(LegReturnRateNotionalReset);
DEFINE_PRICE(LegPaymentStreamLinkInitialLevel);
DEFINE_BOOLEAN(LegPaymentStreamLinkClosingLevelIndicator);
DEFINE_BOOLEAN(LegPaymentStreamLinkExpiringLevelIndicator);
DEFINE_INT(LegPaymentStreamLinkEstimatedTradingDays);
DEFINE_PRICE(LegPaymentStreamLinkStrikePrice);
DEFINE_INT(LegPaymentStreamLinkStrikePriceType);
DEFINE_FLOAT(LegPaymentStreamLinkMaximumBoundary);
DEFINE_FLOAT(LegPaymentStreamLinkMinimumBoundary);
DEFINE_INT(LegPaymentStreamLinkNumberOfDataSeries);
DEFINE_FLOAT(LegPaymentStreamVarianceUnadjustedCap);
DEFINE_INT(LegPaymentStreamRealizedVarianceMethod);
DEFINE_BOOLEAN(LegPaymentStreamDaysAdjustmentIndicator);
DEFINE_STRING(LegPaymentStreamNearestExchangeContractRefID);
DEFINE_FLOAT(LegPaymentStreamVegaNotionalAmount);
DEFINE_CURRENCY(LegPaymentStreamFormulaCurrency);
DEFINE_STRING(LegPaymentStreamFormulaCurrencyDeterminationMethod);
DEFINE_INT(LegPaymentStreamFormulaReferenceAmount);
DEFINE_NUMINGROUP(NoLegPaymentStreamFormulas);
DEFINE_XMLDATA(LegPaymentStreamFormula);
DEFINE_STRING(LegPaymentStreamFormulaDesc);
DEFINE_LOCALMKTDATE(LegPaymentStubEndDateUnadjusted);
DEFINE_INT(LegPaymentStubEndDateBusinessDayConvention);
DEFINE_INT(LegPaymentStubEndDateRelativeTo);
DEFINE_INT(LegPaymentStubEndDateOffsetPeriod);
DEFINE_STRING(LegPaymentStubEndDateOffsetUnit);
DEFINE_INT(LegPaymentStubEndDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegPaymentStubEndDateAdjusted);
DEFINE_NUMINGROUP(NoLegPaymentStubEndDateBusinessCenters);
DEFINE_STRING(LegPaymentStubEndDateBusinessCenter);
DEFINE_LOCALMKTDATE(LegPaymentStubStartDateUnadjusted);
DEFINE_INT(LegPaymentStubStartDateBusinessDayConvention);
DEFINE_INT(LegPaymentStubStartDateRelativeTo);
DEFINE_INT(LegPaymentStubStartDateOffsetPeriod);
DEFINE_STRING(LegPaymentStubStartDateOffsetUnit);
DEFINE_INT(LegPaymentStubStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegPaymentStubStartDateAdjusted);
DEFINE_NUMINGROUP(NoLegPaymentStubStartDateBusinessCenters);
DEFINE_STRING(LegPaymentStubStartDateBusinessCenter);
DEFINE_INT(LegProvisionBreakFeeElection);
DEFINE_PERCENTAGE(LegProvisionBreakFeeRate);
DEFINE_NUMINGROUP(NoLegReturnRateDates);
DEFINE_INT(LegReturnRateDateMode);
DEFINE_INT(LegReturnRateValuationDateRelativeTo);
DEFINE_INT(LegReturnRateValuationDateOffsetPeriod);
DEFINE_STRING(LegReturnRateValuationDateOffsetUnit);
DEFINE_INT(LegReturnRateValuationDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegReturnRateValuationStartDateUnadjusted);
DEFINE_INT(LegReturnRateValuationStartDateRelativeTo);
DEFINE_INT(LegReturnRateValuationStartDateOffsetPeriod);
DEFINE_STRING(LegReturnRateValuationStartDateOffsetUnit);
DEFINE_INT(LegReturnRateValuationStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegReturnRateValuationStartDateAdjusted);
DEFINE_LOCALMKTDATE(LegReturnRateValuationEndDateUnadjusted);
DEFINE_INT(LegReturnRateValuationEndDateRelativeTo);
DEFINE_INT(LegReturnRateValuationEndDateOffsetPeriod);
DEFINE_STRING(LegReturnRateValuationEndDateOffsetUnit);
DEFINE_INT(LegReturnRateValuationEndDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegReturnRateValuationEndDateAdjusted);
DEFINE_INT(LegReturnRateValuationFrequencyPeriod);
DEFINE_STRING(LegReturnRateValuationFrequencyUnit);
DEFINE_STRING(LegReturnRateValuationFrequencyRollConvention);
DEFINE_INT(LegReturnRateValuationDateBusinessDayConvention);
DEFINE_NUMINGROUP(NoLegReturnRateFXConversions);
DEFINE_STRING(LegReturnRateFXCurrencySymbol);
DEFINE_FLOAT(LegReturnRateFXRate);
DEFINE_CHAR(LegReturnRateFXRateCalc);
DEFINE_NUMINGROUP(NoLegReturnRates);
DEFINE_INT(LegReturnRatePriceSequence);
DEFINE_CHAR(LegReturnRateCommissionBasis);
DEFINE_AMT(LegReturnRateCommissionAmount);
DEFINE_CURRENCY(LegReturnRateCommissionCurrency);
DEFINE_AMT(LegReturnRateTotalCommissionPerTrade);
DEFINE_STRING(LegReturnRateDeterminationMethod);
DEFINE_INT(LegReturnRateAmountRelativeTo);
DEFINE_STRING(LegReturnRateQuoteMeasureType);
DEFINE_STRING(LegReturnRateQuoteUnits);
DEFINE_INT(LegReturnRateQuoteMethod);
DEFINE_CURRENCY(LegReturnRateQuoteCurrency);
DEFINE_STRING(LegReturnRateQuoteCurrencyType);
DEFINE_INT(LegReturnRateQuoteTimeType);
DEFINE_LOCALMKTTIME(LegReturnRateQuoteTime);
DEFINE_LOCALMKTDATE(LegReturnRateQuoteDate);
DEFINE_LOCALMKTTIME(LegReturnRateQuoteExpirationTime);
DEFINE_STRING(LegReturnRateQuoteBusinessCenter);
DEFINE_EXCHANGE(LegReturnRateQuoteExchange);
DEFINE_STRING(LegReturnRateQuotePricingModel);
DEFINE_STRING(LegReturnRateCashFlowType);
DEFINE_INT(LegReturnRateValuationTimeType);
DEFINE_LOCALMKTTIME(LegReturnRateValuationTime);
DEFINE_STRING(LegReturnRateValuationTimeBusinessCenter);
DEFINE_INT(LegReturnRateValuationPriceOption);
DEFINE_INT(LegReturnRateFinalPriceFallback);
DEFINE_NUMINGROUP(NoLegReturnRateInformationSources);
DEFINE_INT(LegReturnRateInformationSource);
DEFINE_STRING(LegReturnRateReferencePage);
DEFINE_STRING(LegReturnRateReferencePageHeading);
DEFINE_NUMINGROUP(NoLegReturnRatePrices);
DEFINE_INT(LegReturnRatePriceBasis);
DEFINE_PRICE(LegReturnRatePrice);
DEFINE_CURRENCY(LegReturnRatePriceCurrency);
DEFINE_INT(LegReturnRatePriceType);
DEFINE_NUMINGROUP(NoLegReturnRateValuationDateBusinessCenters);
DEFINE_STRING(LegReturnRateValuationDateBusinessCenter);
DEFINE_NUMINGROUP(NoLegReturnRateValuationDates);
DEFINE_LOCALMKTDATE(LegReturnRateValuationDate);
DEFINE_INT(LegReturnRateValuationDateType);
DEFINE_LOCALMKTDATE(LegSettlMethodElectionDateUnadjusted);
DEFINE_INT(LegSettlMethodElectionDateBusinessDayConvention);
DEFINE_INT(LegSettlMethodElectionDateRelativeTo);
DEFINE_INT(LegSettlMethodElectionDateOffsetPeriod);
DEFINE_STRING(LegSettlMethodElectionDateOffsetUnit);
DEFINE_INT(LegSettlMethodElectionDateOffsetDayType);
DEFINE_LOCALMKTDATE(LegSettlMethodElectionDateAdjusted);
DEFINE_NUMINGROUP(NoLegSettlMethodElectionDateBusinessCenters);
DEFINE_STRING(LegSettlMethodElectionDateBusinessCenter);
DEFINE_STRING(LegStreamVersion);
DEFINE_LOCALMKTDATE(LegStreamVersionEffectiveDate);
DEFINE_STRING(LegStreamNotionalDeterminationMethod);
DEFINE_INT(LegStreamNotionalAdjustments);
DEFINE_INT(SettlMethodElectingPartySide);
DEFINE_LOCALMKTDATE(MakeWholeDate);
DEFINE_AMT(MakeWholeAmount);
DEFINE_STRING(MakeWholeBenchmarkCurveName);
DEFINE_STRING(MakeWholeBenchmarkCurvePoint);
DEFINE_PRICEOFFSET(MakeWholeRecallSpread);
DEFINE_INT(MakeWholeBenchmarkQuote);
DEFINE_INT(MakeWholeInterpolationMethod);
DEFINE_INT(PaymentAmountRelativeTo);
DEFINE_STRING(PaymentAmountDeterminationMethod);
DEFINE_BOOLEAN(PaymentStreamCashSettlIndicator);
DEFINE_XIDREF(PaymentStreamCompoundingXIDRef);
DEFINE_PRICEOFFSET(PaymentStreamCompoundingSpread);
DEFINE_INT(PaymentStreamInterpolationMethod);
DEFINE_INT(PaymentStreamInterpolationPeriod);
DEFINE_FLOAT(PaymentStreamCompoundingFixedRate);
DEFINE_NUMINGROUP(NoPaymentStreamCompoundingDates);
DEFINE_LOCALMKTDATE(PaymentStreamCompoundingDate);
DEFINE_INT(PaymentStreamCompoundingDateType);
DEFINE_INT(PaymentStreamCompoundingDatesBusinessDayConvention);
DEFINE_INT(PaymentStreamCompoundingDatesRelativeTo);
DEFINE_INT(PaymentStreamCompoundingDatesOffsetPeriod);
DEFINE_STRING(PaymentStreamCompoundingDatesOffsetUnit);
DEFINE_INT(PaymentStreamCompoundingDatesOffsetDayType);
DEFINE_INT(PaymentStreamCompoundingPeriodSkip);
DEFINE_INT(PaymentStreamCompoundingFrequencyPeriod);
DEFINE_STRING(PaymentStreamCompoundingFrequencyUnit);
DEFINE_STRING(PaymentStreamCompoundingRollConvention);
DEFINE_LOCALMKTDATE(PaymentStreamBoundsFirstDateUnadjusted);
DEFINE_LOCALMKTDATE(PaymentStreamBoundsLastDateUnadjusted);
DEFINE_NUMINGROUP(NoPaymentStreamCompoundingDatesBusinessCenters);
DEFINE_STRING(PaymentStreamCompoundingDatesBusinessCenter);
DEFINE_LOCALMKTDATE(PaymentStreamCompoundingEndDateUnadjusted);
DEFINE_INT(PaymentStreamCompoundingEndDateRelativeTo);
DEFINE_INT(PaymentStreamCompoundingEndDateOffsetPeriod);
DEFINE_STRING(PaymentStreamCompoundingEndDateOffsetUnit);
DEFINE_INT(PaymentStreamCompoundingEndDateOffsetDayType);
DEFINE_LOCALMKTDATE(PaymentStreamCompoundingEndDateAdjusted);
DEFINE_STRING(PaymentStreamCompoundingRateIndex);
DEFINE_INT(PaymentStreamCompoundingRateIndexCurvePeriod);
DEFINE_STRING(PaymentStreamCompoundingRateIndexCurveUnit);
DEFINE_FLOAT(PaymentStreamCompoundingRateMultiplier);
DEFINE_PRICEOFFSET(PaymentStreamCompoundingRateSpread);
DEFINE_INT(PaymentStreamCompoundingRateSpreadPositionType);
DEFINE_INT(PaymentStreamCompoundingRateTreatment);
DEFINE_PERCENTAGE(PaymentStreamCompoundingCapRate);
DEFINE_INT(PaymentStreamCompoundingCapRateBuySide);
DEFINE_INT(PaymentStreamCompoundingCapRateSellSide);
DEFINE_PERCENTAGE(PaymentStreamCompoundingFloorRate);
DEFINE_INT(PaymentStreamCompoundingFloorRateBuySide);
DEFINE_INT(PaymentStreamCompoundingFloorRateSellSide);
DEFINE_PERCENTAGE(PaymentStreamCompoundingInitialRate);
DEFINE_CHAR(PaymentStreamCompoundingFinalRateRoundingDirection);
DEFINE_INT(PaymentStreamCompoundingFinalRatePrecision);
DEFINE_INT(PaymentStreamCompoundingAveragingMethod);
DEFINE_INT(PaymentStreamCompoundingNegativeRateTreatment);
DEFINE_LOCALMKTDATE(PaymentStreamCompoundingStartDateUnadjusted);
DEFINE_INT(PaymentStreamCompoundingStartDateRelativeTo);
DEFINE_INT(PaymentStreamCompoundingStartDateOffsetPeriod);
DEFINE_STRING(PaymentStreamCompoundingStartDateOffsetUnit);
DEFINE_INT(PaymentStreamCompoundingStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(PaymentStreamCompoundingStartDateAdjusted);
DEFINE_LENGTH(PaymentStreamFormulaImageLength);
DEFINE_DATA(PaymentStreamFormulaImage);
DEFINE_LOCALMKTDATE(PaymentStreamFinalPricePaymentDateUnadjusted);
DEFINE_INT(PaymentStreamFinalPricePaymentDateRelativeTo);
DEFINE_INT(PaymentStreamFinalPricePaymentDateOffsetfPeriod);
DEFINE_STRING(PaymentStreamFinalPricePaymentDateOffsetUnit);
DEFINE_INT(PaymentStreamFinalPricePaymentDateOffsetDayType);
DEFINE_LOCALMKTDATE(PaymentStreamFinalPricePaymentDateAdjusted);
DEFINE_NUMINGROUP(NoPaymentStreamFixingDates);
DEFINE_LOCALMKTDATE(PaymentStreamFixingDate);
DEFINE_INT(PaymentStreamFixingDateType);
DEFINE_LOCALMKTDATE(PaymentStreamFirstObservationDateUnadjusted);
DEFINE_INT(PaymentStreamFirstObservationDateRelativeTo);
DEFINE_INT(PaymentStreamFirstObservationDateOffsetDayType);
DEFINE_LOCALMKTDATE(PaymentStreamFirstObservationDateAdjusted);
DEFINE_STRING(PaymentStreamUnderlierRefID);
DEFINE_BOOLEAN(ReturnRateNotionalReset);
DEFINE_PRICE(PaymentStreamLinkInitialLevel);
DEFINE_BOOLEAN(PaymentStreamLinkClosingLevelIndicator);
DEFINE_BOOLEAN(PaymentStreamLinkExpiringLevelIndicator);
DEFINE_INT(PaymentStreamLinkEstimatedTradingDays);
DEFINE_PRICE(PaymentStreamLinkStrikePrice);
DEFINE_INT(PaymentStreamLinkStrikePriceType);
DEFINE_FLOAT(PaymentStreamLinkMaximumBoundary);
DEFINE_FLOAT(PaymentStreamLinkMinimumBoundary);
DEFINE_INT(PaymentStreamLinkNumberOfDataSeries);
DEFINE_FLOAT(PaymentStreamVarianceUnadjustedCap);
DEFINE_INT(PaymentStreamRealizedVarianceMethod);
DEFINE_BOOLEAN(PaymentStreamDaysAdjustmentIndicator);
DEFINE_STRING(PaymentStreamNearestExchangeContractRefID);
DEFINE_FLOAT(PaymentStreamVegaNotionalAmount);
DEFINE_NUMINGROUP(NoPaymentStreamFormulas);
DEFINE_XMLDATA(PaymentStreamFormula);
DEFINE_STRING(PaymentStreamFormulaDesc);
DEFINE_CURRENCY(PaymentStreamFormulaCurrency);
DEFINE_STRING(PaymentStreamFormulaCurrencyDeterminationMethod);
DEFINE_INT(PaymentStreamFormulaReferenceAmount);
DEFINE_LOCALMKTDATE(PaymentStubEndDateUnadjusted);
DEFINE_INT(PaymentStubEndDateBusinessDayConvention);
DEFINE_INT(PaymentStubEndDateRelativeTo);
DEFINE_INT(PaymentStubEndDateOffsetPeriod);
DEFINE_STRING(PaymentStubEndDateOffsetUnit);
DEFINE_INT(PaymentStubEndDateOffsetDayType);
DEFINE_LOCALMKTDATE(PaymentStubEndDateAdjusted);
DEFINE_NUMINGROUP(NoPaymentStubEndDateBusinessCenters);
DEFINE_STRING(PaymentStubEndDateBusinessCenter);
DEFINE_LOCALMKTDATE(PaymentStubStartDateUnadjusted);
DEFINE_INT(PaymentStubStartDateBusinessDayConvention);
DEFINE_INT(PaymentStubStartDateRelativeTo);
DEFINE_INT(PaymentStubStartDateOffsetPeriod);
DEFINE_STRING(PaymentStubStartDateOffsetUnit);
DEFINE_INT(PaymentStubStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(PaymentStubStartDateAdjusted);
DEFINE_NUMINGROUP(NoPaymentStubStartDateBusinessCenters);
DEFINE_STRING(PaymentStubStartDateBusinessCenter);
DEFINE_INT(ProvisionBreakFeeElection);
DEFINE_PERCENTAGE(ProvisionBreakFeeRate);
DEFINE_XIDREF(RelatedToDividendPeriodXIDRef);
DEFINE_NUMINGROUP(NoReturnRateDates);
DEFINE_INT(ReturnRateDateMode);
DEFINE_INT(ReturnRateValuationDateRelativeTo);
DEFINE_INT(ReturnRateValuationDateOffsetPeriod);
DEFINE_STRING(ReturnRateValuationDateOffsetUnit);
DEFINE_INT(ReturnRateValuationDateOffsetDayType);
DEFINE_LOCALMKTDATE(ReturnRateValuationStartDateUnadjusted);
DEFINE_INT(ReturnRateValuationStartDateRelativeTo);
DEFINE_INT(ReturnRateValuationStartDateOffsetPeriod);
DEFINE_STRING(ReturnRateValuationStartDateOffsetUnit);
DEFINE_INT(ReturnRateValuationStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(ReturnRateValuationStartDateAdjusted);
DEFINE_LOCALMKTDATE(ReturnRateValuationEndDateUnadjusted);
DEFINE_INT(ReturnRateValuationEndDateRelativeTo);
DEFINE_INT(ReturnRateValuationEndDateOffsetPeriod);
DEFINE_STRING(ReturnRateValuationEndDateOffsetUnit);
DEFINE_INT(ReturnRateValuationEndDateOffsetDayType);
DEFINE_LOCALMKTDATE(ReturnRateValuationEndDateAdjusted);
DEFINE_INT(ReturnRateValuationFrequencyPeriod);
DEFINE_STRING(ReturnRateValuationFrequencyUnit);
DEFINE_STRING(ReturnRateValuationFrequencyRollConvention);
DEFINE_INT(ReturnRateValuationDateBusinessDayConvention);
DEFINE_NUMINGROUP(NoReturnRateFXConversions);
DEFINE_STRING(ReturnRateFXCurrencySymbol);
DEFINE_FLOAT(ReturnRateFXRate);
DEFINE_CHAR(ReturnRateFXRateCalc);
DEFINE_NUMINGROUP(NoReturnRates);
DEFINE_INT(ReturnRatePriceSequence);
DEFINE_CHAR(ReturnRateCommissionBasis);
DEFINE_AMT(ReturnRateCommissionAmount);
DEFINE_CURRENCY(ReturnRateCommissionCurrency);
DEFINE_AMT(ReturnRateTotalCommissionPerTrade);
DEFINE_STRING(ReturnRateDeterminationMethod);
DEFINE_INT(ReturnRateAmountRelativeTo);
DEFINE_STRING(ReturnRateQuoteMeasureType);
DEFINE_STRING(ReturnRateQuoteUnits);
DEFINE_INT(ReturnRateQuoteMethod);
DEFINE_CURRENCY(ReturnRateQuoteCurrency);
DEFINE_STRING(ReturnRateQuoteCurrencyType);
DEFINE_INT(ReturnRateQuoteTimeType);
DEFINE_LOCALMKTTIME(ReturnRateQuoteTime);
DEFINE_LOCALMKTDATE(ReturnRateQuoteDate);
DEFINE_LOCALMKTTIME(ReturnRateQuoteExpirationTime);
DEFINE_STRING(ReturnRateQuoteBusinessCenter);
DEFINE_EXCHANGE(ReturnRateQuoteExchange);
DEFINE_STRING(ReturnRateQuotePricingModel);
DEFINE_STRING(ReturnRateCashFlowType);
DEFINE_INT(ReturnRateValuationTimeType);
DEFINE_LOCALMKTTIME(ReturnRateValuationTime);
DEFINE_STRING(ReturnRateValuationTimeBusinessCenter);
DEFINE_INT(ReturnRateValuationPriceOption);
DEFINE_INT(ReturnRateFinalPriceFallback);
DEFINE_NUMINGROUP(NoReturnRateInformationSources);
DEFINE_INT(ReturnRateInformationSource);
DEFINE_STRING(ReturnRateReferencePage);
DEFINE_STRING(ReturnRateReferencePageHeading);
DEFINE_NUMINGROUP(NoReturnRatePrices);
DEFINE_INT(ReturnRatePriceBasis);
DEFINE_PRICE(ReturnRatePrice);
DEFINE_CURRENCY(ReturnRatePriceCurrency);
DEFINE_INT(ReturnRatePriceType);
DEFINE_NUMINGROUP(NoReturnRateValuationDateBusinessCenters);
DEFINE_STRING(ReturnRateValuationDateBusinessCenter);
DEFINE_NUMINGROUP(NoReturnRateValuationDates);
DEFINE_LOCALMKTDATE(ReturnRateValuationDate);
DEFINE_INT(ReturnRateValuationDateType);
DEFINE_NUMINGROUP(NoSettlMethodElectionDateBusinessCenters);
DEFINE_STRING(SettlMethodElectionDateBusinessCenter);
DEFINE_LOCALMKTDATE(SettlMethodElectionDateUnadjusted);
DEFINE_INT(SettlMethodElectionDateBusinessDayConvention);
DEFINE_INT(SettlMethodElectionDateRelativeTo);
DEFINE_INT(SettlMethodElectionDateOffsetPeriod);
DEFINE_STRING(SettlMethodElectionDateOffsetUnit);
DEFINE_INT(SettlMethodElectionDateOffsetDayType);
DEFINE_LOCALMKTDATE(SettlMethodElectionDateAdjusted);
DEFINE_STRING(StreamVersion);
DEFINE_LOCALMKTDATE(StreamVersionEffectiveDate);
DEFINE_STRING(StreamNotionalDeterminationMethod);
DEFINE_INT(StreamNotionalAdjustments);
DEFINE_NUMINGROUP(NoUnderlyingCashSettlDateBusinessCenters);
DEFINE_STRING(UnderlyingCashSettlDateBusinessCenter);
DEFINE_LOCALMKTDATE(UnderlyingCashSettlDateUnadjusted);
DEFINE_INT(UnderlyingCashSettlDateBusinessDayConvention);
DEFINE_INT(UnderlyingCashSettlDateRelativeTo);
DEFINE_INT(UnderlyingCashSettlDateOffsetPeriod);
DEFINE_STRING(UnderlyingCashSettlDateOffsetUnit);
DEFINE_INT(UnderlyingCashSettlDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingCashSettlDateAdjusted);
DEFINE_STRING(UnderlyingCashSettlPriceSource);
DEFINE_INT(UnderlyingCashSettlPriceDefault);
DEFINE_BOOLEAN(UnderlyingComplexEventFuturesPriceValuation);
DEFINE_BOOLEAN(UnderlyingComplexEventOptionsPriceValuation);
DEFINE_INT(UnderlyingComplexEventPVFinalPriceElectionFallback);
DEFINE_NUMINGROUP(NoUnderlyingDividendAccrualPaymentDateBusinessCenters);
DEFINE_STRING(UnderlyingDividendAccrualPaymentDateBusinessCenter);
DEFINE_STRING(UnderlyingDividendFloatingRateIndex);
DEFINE_INT(UnderlyingDividendFloatingRateIndexCurvePeriod);
DEFINE_STRING(UnderlyingDividendFloatingRateIndexCurveUnit);
DEFINE_FLOAT(UnderlyingDividendFloatingRateMultiplier);
DEFINE_PRICEOFFSET(UnderlyingDividendFloatingRateSpread);
DEFINE_INT(UnderlyingDividendFloatingRateSpreadPositionType);
DEFINE_INT(UnderlyingDividendFloatingRateTreatment);
DEFINE_PERCENTAGE(UnderlyingDividendCapRate);
DEFINE_INT(UnderlyingDividendCapRateBuySide);
DEFINE_INT(UnderlyingDividendCapRateSellSide);
DEFINE_PERCENTAGE(UnderlyingDividendFloorRate);
DEFINE_INT(UnderlyingDividendFloorRateBuySide);
DEFINE_INT(UnderlyingDividendFloorRateSellSide);
DEFINE_PERCENTAGE(UnderlyingDividendInitialRate);
DEFINE_CHAR(UnderlyingDividendFinalRateRoundingDirection);
DEFINE_INT(UnderlyingDividendFinalRatePrecision);
DEFINE_INT(UnderlyingDividendAveragingMethod);
DEFINE_INT(UnderlyingDividendNegativeRateTreatment);
DEFINE_INT(UnderlyingDividendAccrualPaymentDateRelativeTo);
DEFINE_INT(UnderlyingDividendAccrualPaymentDateOffsetPeriod);
DEFINE_STRING(UnderlyingDividendAccrualPaymentDateOffsetUnit);
DEFINE_INT(UnderlyingDividendAccrualPaymentDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingDividendAccrualPaymentDateUnadjusted);
DEFINE_INT(UnderlyingDividendAccrualPaymentDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(UnderlyingDividendAccrualPaymentDateAdjusted);
DEFINE_BOOLEAN(UnderlyingDividendReinvestmentIndicator);
DEFINE_INT(UnderlyingDividendEntitlementEvent);
DEFINE_INT(UnderlyingDividendAmountType);
DEFINE_STRING(UnderlyingDividendUnderlierRefID);
DEFINE_INT(UnderlyingExtraordinaryDividendPartySide);
DEFINE_INT(UnderlyingExtraordinaryDividendAmountType);
DEFINE_CURRENCY(UnderlyingExtraordinaryDividendCurrency);
DEFINE_STRING(UnderlyingExtraordinaryDividendDeterminationMethod);
DEFINE_PERCENTAGE(UnderlyingDividendAccrualFixedRate);
DEFINE_INT(UnderlyingDividendCompoundingMethod);
DEFINE_INT(UnderlyingDividendNumOfIndexUnits);
DEFINE_PERCENTAGE(UnderlyingDividendCashPercentage);
DEFINE_PERCENTAGE(UnderlyingDividendCashEquivalentPercentage);
DEFINE_INT(UnderlyingNonCashDividendTreatment);
DEFINE_INT(UnderlyingDividendComposition);
DEFINE_BOOLEAN(UnderlyingSpecialDividendsIndicator);
DEFINE_BOOLEAN(UnderlyingMaterialDividendsIndicator);
DEFINE_BOOLEAN(UnderlyingOptionsExchangeDividendsIndicator);
DEFINE_BOOLEAN(UnderlyingAdditionalDividendsIndicator);
DEFINE_BOOLEAN(UnderlyingAllDividendsIndicator);
DEFINE_INT(UnderlyingDividendFXTriggerDateRelativeTo);
DEFINE_INT(UnderlyingDividendFXTriggerDateOffsetPeriod);
DEFINE_STRING(UnderlyingDividendFXTriggerDateOffsetUnit);
DEFINE_INT(UnderlyingDividendFXTriggerDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingDividendFXTriggerDateUnadjusted);
DEFINE_INT(UnderlyingDividendFXTriggerDateBusinessDayConvention);
DEFINE_LOCALMKTDATE(UnderlyingDividendFXTriggerDateAdjusted);
DEFINE_NUMINGROUP(NoUnderlyingDividendFXTriggerDateBusinessCenters);
DEFINE_STRING(UnderlyingDividendFXTriggerDateBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingDividendPayments);
DEFINE_LOCALMKTDATE(UnderlyingDividendPaymentDate);
DEFINE_AMT(UnderlyingDividendPaymentAmount);
DEFINE_CURRENCY(UnderlyingDividendPaymentCurrency);
DEFINE_AMT(UnderlyingDividendAccruedInterest);
DEFINE_FLOAT(UnderlyingDividendPayoutRatio);
DEFINE_STRING(UnderlyingDividendPayoutConditions);
DEFINE_NUMINGROUP(NoUnderlyingDividendPeriods);
DEFINE_INT(UnderlyingDividendPeriodSequence);
DEFINE_LOCALMKTDATE(UnderlyingDividendPeriodStartDateUnadjusted);
DEFINE_LOCALMKTDATE(UnderlyingDividendPeriodEndDateUnadjusted);
DEFINE_STRING(UnderlyingDividendPeriodUnderlierRefID);
DEFINE_PRICE(UnderlyingDividendPeriodStrikePrice);
DEFINE_INT(UnderlyingDividendPeriodBusinessDayConvention);
DEFINE_LOCALMKTDATE(UnderlyingDividendPeriodValuationDateUnadjusted);
DEFINE_INT(UnderlyingDividendPeriodValuationDateRelativeTo);
DEFINE_INT(UnderlyingDividendPeriodValuationDateOffsetPeriod);
DEFINE_STRING(UnderlyingDividendPeriodValuationDateOffsetUnit);
DEFINE_INT(UnderlyingDividendPeriodValuationDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingDividendPeriodValuationDateAdjusted);
DEFINE_LOCALMKTDATE(UnderlyingDividendPeriodPaymentDateUnadjusted);
DEFINE_INT(UnderlyingDividendPeriodPaymentDateRelativeTo);
DEFINE_INT(UnderlyingDividendPeriodPaymentDateOffsetPeriod);
DEFINE_STRING(UnderlyingDividendPeriodPaymentDateOffsetUnit);
DEFINE_INT(UnderlyingDividendPeriodPaymentDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingDividendPeriodPaymentDateAdjusted);
DEFINE_XID(UnderlyingDividendPeriodXID);
DEFINE_NUMINGROUP(NoUnderlyingDividendPeriodBusinessCenters);
DEFINE_STRING(UnderlyingDividendPeriodBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingExtraordinaryEvents);
DEFINE_STRING(UnderlyingExtraordinaryEventType);
DEFINE_STRING(UnderlyingExtraordinaryEventValue);
DEFINE_AMT(UnderlyingNotional);
DEFINE_CURRENCY(UnderlyingNotionalCurrency);
DEFINE_STRING(UnderlyingNotionalDeterminationMethod);
DEFINE_INT(UnderlyingNotionalAdjustments);
DEFINE_XIDREF(UnderlyingNotionalXIDRef);
DEFINE_STRING(UnderlyingFutureID);
DEFINE_STRING(UnderlyingFutureIDSource);
DEFINE_STRING(UnderlyingStrikeIndexCurvePoint);
DEFINE_INT(UnderlyingStrikeIndexQuote);
DEFINE_INT(UnderlyingExtraordinaryEventAdjustmentMethod);
DEFINE_BOOLEAN(UnderlyingExchangeLookAlike);
DEFINE_AMT(UnderlyingAverageVolumeLimitationPercentage);
DEFINE_INT(UnderlyingAverageVolumeLimitationPeriodDays);
DEFINE_BOOLEAN(UnderlyingDepositoryReceiptIndicator);
DEFINE_QTY(UnderlyingOpenUnits);
DEFINE_FLOAT(UnderlyingBasketDivisor);
DEFINE_XID(UnderlyingInstrumentXID);
DEFINE_INT(UnderlyingSettlMethodElectingPartySide);
DEFINE_LOCALMKTDATE(UnderlyingMakeWholeDate);
DEFINE_AMT(UnderlyingMakeWholeAmount);
DEFINE_STRING(UnderlyingMakeWholeBenchmarkCurveName);
DEFINE_STRING(UnderlyingMakeWholeBenchmarkCurvePoint);
DEFINE_PRICEOFFSET(UnderlyingMakeWholeRecallSpread);
DEFINE_INT(UnderlyingMakeWholeBenchmarkQuote);
DEFINE_INT(UnderlyingMakeWholeInterpolationMethod);
DEFINE_BOOLEAN(UnderlyingPaymentStreamCashSettlIndicator);
DEFINE_XIDREF(UnderlyingPaymentStreamCompoundingXIDRef);
DEFINE_PRICEOFFSET(UnderlyingPaymentStreamCompoundingSpread);
DEFINE_INT(UnderlyingPaymentStreamInterpolationMethod);
DEFINE_INT(UnderlyingPaymentStreamInterpolationPeriod);
DEFINE_FLOAT(UnderlyingPaymentStreamCompoundingFixedRate);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamCompoundingDates);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamCompoundingDate);
DEFINE_INT(UnderlyingPaymentStreamCompoundingDateType);
DEFINE_INT(UnderlyingPaymentStreamCompoundingDatesBusinessDayConvention);
DEFINE_INT(UnderlyingPaymentStreamCompoundingDatesRelativeTo);
DEFINE_INT(UnderlyingPaymentStreamCompoundingDatesOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentStreamCompoundingDatesOffsetUnit);
DEFINE_INT(UnderlyingPaymentStreamCompoundingDatesOffsetDayType);
DEFINE_INT(UnderlyingPaymentStreamCompoundingPeriodSkip);
DEFINE_INT(UnderlyingPaymentStreamCompoundingFrequencyPeriod);
DEFINE_STRING(UnderlyingPaymentStreamCompoundingFrequencyUnit);
DEFINE_STRING(UnderlyingPaymentStreamCompoundingRollConvention);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamBoundsFirstDateUnadjusted);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamBoundsLastDateUnadjusted);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamCompoundingDatesBusinessCenters);
DEFINE_STRING(UnderlyingPaymentStreamCompoundingDatesBusinessCenter);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamCompoundingEndDateUnadjusted);
DEFINE_INT(UnderlyingPaymentStreamCompoundingEndDateRelativeTo);
DEFINE_INT(UnderlyingPaymentStreamCompoundingEndDateOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentStreamCompoundingEndDateOffsetUnit);
DEFINE_INT(UnderlyingPaymentStreamCompoundingEndDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamCompoundingEndDateAdjusted);
DEFINE_STRING(UnderlyingPaymentStreamCompoundingRateIndex);
DEFINE_INT(UnderlyingPaymentStreamCompoundingRateIndexCurvePeriod);
DEFINE_STRING(UnderlyingPaymentStreamCompoundingRateIndexCurveUnit);
DEFINE_FLOAT(UnderlyingPaymentStreamCompoundingRateMultiplier);
DEFINE_PRICEOFFSET(UnderlyingPaymentStreamCompoundingRateSpread);
DEFINE_INT(UnderlyingPaymentStreamCompoundingRateSpreadPositionType);
DEFINE_INT(UnderlyingPaymentStreamCompoundingRateTreatment);
DEFINE_PERCENTAGE(UnderlyingPaymentStreamCompoundingCapRate);
DEFINE_INT(UnderlyingPaymentStreamCompoundingCapRateBuySide);
DEFINE_INT(UnderlyingPaymentStreamCompoundingCapRateSellSide);
DEFINE_PERCENTAGE(UnderlyingPaymentStreamCompoundingFloorRate);
DEFINE_INT(UnderlyingPaymentStreamCompoundingFloorRateBuySide);
DEFINE_INT(UnderlyingPaymentStreamCompoundingFloorRateSellSide);
DEFINE_PERCENTAGE(UnderlyingPaymentStreamCompoundingInitialRate);
DEFINE_CHAR(UnderlyingPaymentStreamCompoundingFinalRateRoundingDirection);
DEFINE_INT(UnderlyingPaymentStreamCompoundingFinalRatePrecision);
DEFINE_INT(UnderlyingPaymentStreamCompoundingAveragingMethod);
DEFINE_INT(UnderlyingPaymentStreamCompoundingNegativeRateTreatment);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamCompoundingStartDateUnadjusted);
DEFINE_INT(UnderlyingPaymentStreamCompoundingStartDateRelativeTo);
DEFINE_INT(UnderlyingPaymentStreamCompoundingStartDateOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentStreamCompoundingStartDateOffsetUnit);
DEFINE_INT(UnderlyingPaymentStreamCompoundingStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamCompoundingStartDateAdjusted);
DEFINE_LENGTH(UnderlyingPaymentStreamFormulaImageLength);
DEFINE_DATA(UnderlyingPaymentStreamFormulaImage);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamFinalPricePaymentDateUnadjusted);
DEFINE_INT(UnderlyingPaymentStreamFinalPricePaymentDateRelativeTo);
DEFINE_INT(UnderlyingPaymentStreamFinalPricePaymentDateOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentStreamFinalPricePaymentDateOffsetUnit);
DEFINE_INT(UnderlyingPaymentStreamFinalPricePaymentDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamFinalPricePaymentDateAdjusted);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamFixingDates);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamFixingDate);
DEFINE_INT(UnderlyingPaymentStreamFixingDateType);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamFirstObservationDateUnadjusted);
DEFINE_INT(UnderlyingPaymentStreamFirstObservationDateRelativeTo);
DEFINE_INT(UnderlyingPaymentStreamFirstObservationDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStreamFirstObservationDateAdjusted);
DEFINE_STRING(UnderlyingPaymentStreamUnderlierRefID);
DEFINE_BOOLEAN(UnderlyingReturnRateNotionalReset);
DEFINE_PRICE(UnderlyingPaymentStreamLinkInitialLevel);
DEFINE_BOOLEAN(UnderlyingPaymentStreamLinkClosingLevelIndicator);
DEFINE_BOOLEAN(UnderlyingPaymentStreamLinkExpiringLevelIndicator);
DEFINE_INT(UnderlyingPaymentStreamLinkEstimatedTradingDays);
DEFINE_PRICE(UnderlyingPaymentStreamLinkStrikePrice);
DEFINE_INT(UnderlyingPaymentStreamLinkStrikePriceType);
DEFINE_FLOAT(UnderlyingPaymentStreamLinkMaximumBoundary);
DEFINE_FLOAT(UnderlyingPaymentStreamLinkMinimumBoundary);
DEFINE_INT(UnderlyingPaymentStreamLinkNumberOfDataSeries);
DEFINE_FLOAT(UnderlyingPaymentStreamVarianceUnadjustedCap);
DEFINE_INT(UnderlyingPaymentStreamRealizedVarianceMethod);
DEFINE_BOOLEAN(UnderlyingPaymentStreamDaysAdjustmentIndicator);
DEFINE_STRING(UnderlyingPaymentStreamNearestExchangeContractRefID);
DEFINE_FLOAT(UnderlyingPaymentStreamVegaNotionalAmount);
DEFINE_CURRENCY(UnderlyingPaymentStreamFormulaCurrency);
DEFINE_STRING(UnderlyingPaymentStreamFormulaCurrencyDeterminationMethod);
DEFINE_INT(UnderlyingPaymentStreamFormulaReferenceAmount);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStreamFormulas);
DEFINE_XMLDATA(UnderlyingPaymentStreamFormula);
DEFINE_STRING(UnderlyingPaymentStreamFormulaDesc);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStubEndDateUnadjusted);
DEFINE_INT(UnderlyingPaymentStubEndDateBusinessDayConvention);
DEFINE_INT(UnderlyingPaymentStubEndDateRelativeTo);
DEFINE_INT(UnderlyingPaymentStubEndDateOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentStubEndDateOffsetUnit);
DEFINE_INT(UnderlyingPaymentStubEndDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStubEndDateAdjusted);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStubEndDateBusinessCenters);
DEFINE_STRING(UnderlyingPaymentStubEndDateBusinessCenter);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStubStartDateUnadjusted);
DEFINE_INT(UnderlyingPaymentStubStartDateBusinessDayConvention);
DEFINE_INT(UnderlyingPaymentStubStartDateRelativeTo);
DEFINE_INT(UnderlyingPaymentStubStartDateOffsetPeriod);
DEFINE_STRING(UnderlyingPaymentStubStartDateOffsetUnit);
DEFINE_INT(UnderlyingPaymentStubStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingPaymentStubStartDateAdjusted);
DEFINE_NUMINGROUP(NoUnderlyingPaymentStubStartDateBusinessCenters);
DEFINE_STRING(UnderlyingPaymentStubStartDateBusinessCenter);
DEFINE_INT(UnderlyingProvisionBreakFeeElection);
DEFINE_PERCENTAGE(UnderlyingProvisionBreakFeeRate);
DEFINE_FLOAT(UnderlyingRateSpreadInitialValue);
DEFINE_NUMINGROUP(NoUnderlyingRateSpreadSteps);
DEFINE_LOCALMKTDATE(UnderlyingRateSpreadStepDate);
DEFINE_FLOAT(UnderlyingRateSpreadStepValue);
DEFINE_NUMINGROUP(NoUnderlyingReturnRateDates);
DEFINE_INT(UnderlyingReturnRateDateMode);
DEFINE_INT(UnderlyingReturnRateValuationDateRelativeTo);
DEFINE_INT(UnderlyingReturnRateValuationDateOffsetPeriod);
DEFINE_STRING(UnderlyingReturnRateValuationDateOffsetUnit);
DEFINE_INT(UnderlyingReturnRateValuationDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingReturnRateValuationStartDateUnadjusted);
DEFINE_INT(UnderlyingReturnRateValuationStartDateRelativeTo);
DEFINE_INT(UnderlyingReturnRateValuationStartDateOffsetPeriod);
DEFINE_STRING(UnderlyingReturnRateValuationStartDateOffsetUnit);
DEFINE_INT(UnderlyingReturnRateValuationStartDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingReturnRateValuationStartDateAdjusted);
DEFINE_LOCALMKTDATE(UnderlyingReturnRateValuationEndDateUnadjusted);
DEFINE_INT(UnderlyingReturnRateValuationEndDateRelativeTo);
DEFINE_INT(UnderlyingReturnRateValuationEndDateOffsetPeriod);
DEFINE_STRING(UnderlyingReturnRateValuationEndDateOffsetUnit);
DEFINE_INT(UnderlyingReturnRateValuationEndDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingReturnRateValuationEndDateAdjusted);
DEFINE_INT(UnderlyingReturnRateValuationFrequencyPeriod);
DEFINE_STRING(UnderlyingReturnRateValuationFrequencyUnit);
DEFINE_STRING(UnderlyingReturnRateValuationFrequencyRollConvention);
DEFINE_INT(UnderlyingReturnRateValuationDateBusinessDayConvention);
DEFINE_NUMINGROUP(NoUnderlyingReturnRateFXConversions);
DEFINE_STRING(UnderlyingReturnRateFXCurrencySymbol);
DEFINE_FLOAT(UnderlyingReturnRateFXRate);
DEFINE_CHAR(UnderlyingReturnRateFXRateCalc);
DEFINE_NUMINGROUP(NoUnderlyingReturnRates);
DEFINE_INT(UnderlyingReturnRatePriceSequence);
DEFINE_CHAR(UnderlyingReturnRateCommissionBasis);
DEFINE_AMT(UnderlyingReturnRateCommissionAmount);
DEFINE_CURRENCY(UnderlyingReturnRateCommissionCurrency);
DEFINE_AMT(UnderlyingReturnRateTotalCommissionPerTrade);
DEFINE_STRING(UnderlyingReturnRateDeterminationMethod);
DEFINE_INT(UnderlyingReturnRateAmountRelativeTo);
DEFINE_STRING(UnderlyingReturnRateQuoteMeasureType);
DEFINE_STRING(UnderlyingReturnRateQuoteUnits);
DEFINE_INT(UnderlyingReturnRateQuoteMethod);
DEFINE_CURRENCY(UnderlyingReturnRateQuoteCurrency);
DEFINE_STRING(UnderlyingReturnRateQuoteCurrencyType);
DEFINE_INT(UnderlyingReturnRateQuoteTimeType);
DEFINE_LOCALMKTDATE(UnderlyingReturnRateQuoteTime);
DEFINE_LOCALMKTDATE(UnderlyingReturnRateQuoteDate);
DEFINE_LOCALMKTTIME(UnderlyingReturnRateQuoteExpirationTime);
DEFINE_STRING(UnderlyingReturnRateQuoteBusinessCenter);
DEFINE_EXCHANGE(UnderlyingReturnRateQuoteExchange);
DEFINE_STRING(UnderlyingReturnRateQuotePricingModel);
DEFINE_STRING(UnderlyingReturnRateCashFlowType);
DEFINE_INT(UnderlyingReturnRateValuationTimeType);
DEFINE_LOCALMKTTIME(UnderlyingReturnRateValuationTime);
DEFINE_STRING(UnderlyingReturnRateValuationTimeBusinessCenter);
DEFINE_INT(UnderlyingReturnRateValuationPriceOption);
DEFINE_INT(UnderlyingReturnRateFinalPriceFallback);
DEFINE_NUMINGROUP(NoUnderlyingReturnRateInformationSources);
DEFINE_INT(UnderlyingReturnRateInformationSource);
DEFINE_STRING(UnderlyingReturnRateReferencePage);
DEFINE_STRING(UnderlyingReturnRateReferencePageHeading);
DEFINE_NUMINGROUP(NoUnderlyingReturnRatePrices);
DEFINE_INT(UnderlyingReturnRatePriceBasis);
DEFINE_PRICE(UnderlyingReturnRatePrice);
DEFINE_CURRENCY(UnderlyingReturnRatePriceCurrency);
DEFINE_INT(UnderlyingReturnRatePriceType);
DEFINE_NUMINGROUP(NoUnderlyingReturnRateValuationDateBusinessCenters);
DEFINE_STRING(UnderlyingReturnRateValuationDateBusinessCenter);
DEFINE_NUMINGROUP(NoUnderlyingReturnRateValuationDates);
DEFINE_LOCALMKTDATE(UnderlyingReturnRateValuationDate);
DEFINE_INT(UnderlyingReturnRateValuationDateType);
DEFINE_NUMINGROUP(NoUnderlyingSettlMethodElectionDateBusinessCenters);
DEFINE_STRING(UnderlyingSettlMethodElectionDateBusinessCenter);
DEFINE_LOCALMKTDATE(UnderlyingSettlMethodElectionDateUnadjusted);
DEFINE_INT(UnderlyingSettlMethodElectionDateBusinessDayConvention);
DEFINE_INT(UnderlyingSettlMethodElectionDateRelativeTo);
DEFINE_INT(UnderlyingSettlMethodElectionDateOffsetPeriod);
DEFINE_STRING(UnderlyingSettlMethodElectionDateOffsetUnit);
DEFINE_INT(UnderlyingSettlMethodElectionDateOffsetDayType);
DEFINE_LOCALMKTDATE(UnderlyingSettlMethodElectionDateAdjusted);
DEFINE_STRING(UnderlyingStreamVersion);
DEFINE_LOCALMKTDATE(UnderlyingStreamVersionEffectiveDate);
DEFINE_STRING(UnderlyingStreamNotionalDeterminationMethod);
DEFINE_INT(UnderlyingStreamNotionalAdjustments);
DEFINE_INT(RemunerationIndicator);
DEFINE_STRING(CompressionGroupID);
DEFINE_STRING(SelfMatchPreventionID);
DEFINE_INT(PartyRiskLimitStatus);
DEFINE_STRING(TradeConfirmationReferenceID);
DEFINE_INT(AlgorithmicTradeIndicator);
DEFINE_NUMINGROUP(NoTrdRegPublications);
DEFINE_INT(TrdRegPublicationType);
DEFINE_INT(TrdRegPublicationReason);
DEFINE_PRICEOFFSET(LegDifferentialPrice);
DEFINE_INT(CrossedIndicator);
DEFINE_NUMINGROUP(NoOrderAttributes);
DEFINE_INT(OrderAttributeType);
DEFINE_STRING(OrderAttributeValue);
DEFINE_INT(TradeReportingIndicator);
DEFINE_INT(SideTradeReportingIndicator);
DEFINE_STRING(CrossRequestID);
DEFINE_STRING(FillMatchID);
DEFINE_STRING(FillMatchSubID);
DEFINE_INT(MassActionReason);
DEFINE_PERCENTAGE(MaximumPriceDeviation);
DEFINE_INT(NotAffectedReason);
DEFINE_INT(TotalNotAffectedOrders);
DEFINE_INT(OrderOwnershipIndicator);
DEFINE_STRING(LegAccount);
DEFINE_INT(InTheMoneyCondition);
DEFINE_INT(LegInTheMoneyCondition);
DEFINE_INT(UnderlyingInTheMoneyCondition);
DEFINE_INT(DerivativeInTheMoneyCondition);
DEFINE_BOOLEAN(ContraryInstructionEligibilityIndicator);
DEFINE_BOOLEAN(LegContraryInstructionEligibilityIndicator);
DEFINE_BOOLEAN(UnderlyingContraryInstructionEligibilityIndicator);
DEFINE_BOOLEAN(DerivativeContraryInstructionEligibilityIndicator);
DEFINE_PRICE(CollateralMarketPrice);
DEFINE_PERCENTAGE(CollateralPercentOverage);
DEFINE_NUMINGROUP(NoSideCollateralAmounts);
DEFINE_STRING(SideCollateralAmountMarketID);
DEFINE_STRING(SideCollateralAmountMarketSegmentID);
DEFINE_INT(SideCollateralAmountType);
DEFINE_CURRENCY(SideCollateralCurrency);
DEFINE_FLOAT(SideCollateralFXRate);
DEFINE_CHAR(SideCollateralFXRateCalc);
DEFINE_PRICE(SideCollateralMarketPrice);
DEFINE_PERCENTAGE(SideCollateralPercentOverage);
DEFINE_STRING(SideCollateralPortfolioID);
DEFINE_STRING(SideCollateralType);
DEFINE_AMT(SideCurrentCollateralAmount);
DEFINE_BOOLEAN(SideHaircutIndicator);
DEFINE_INT(ExDestinationType);
DEFINE_INT(MarketCondition);
DEFINE_NUMINGROUP(NoQuoteAttributes);
DEFINE_INT(QuoteAttributeType);
DEFINE_STRING(QuoteAttributeValue);
DEFINE_NUMINGROUP(NoPriceQualifiers);
DEFINE_INT(PriceQualifier);
DEFINE_INT(MDValueTier);
DEFINE_INT(MiscFeeQualifier);
DEFINE_STRING(MiscFeeDesc);
DEFINE_STRING(FinancialInstrumentFullName);
DEFINE_LENGTH(EncodedFinancialInstrumentFullNameLen);
DEFINE_DATA(EncodedFinancialInstrumentFullName);
DEFINE_STRING(LegFinancialInstrumentFullName);
DEFINE_LENGTH(EncodedLegFinancialInstrumentFullNameLen);
DEFINE_DATA(EncodedLegFinancialInstrumentFullName);
DEFINE_STRING(UnderlyingFinancialInstrumentFullName);
DEFINE_LENGTH(EncodedUnderlyingFinancialInstrumentFullNameLen);
DEFINE_DATA(EncodedUnderlyingFinancialInstrumentFullName);
DEFINE_STRING(UnderlyingIndexCurveUnit);
DEFINE_INT(UnderlyingIndexCurvePeriod);
DEFINE_INT(CommissionAmountSubType);
DEFINE_INT(AllocCommissionAmountSubType);
DEFINE_STRING(AllocLegRefID);
DEFINE_INT(FloatingRateIndexCurvePeriod);
DEFINE_PRICEOFFSET(FloatingRateIndexCurveSpread);
DEFINE_STRING(FloatingRateIndexCurveUnit);
DEFINE_STRING(FloatingRateIndexID);
DEFINE_STRING(FloatingRateIndexIDSource);
DEFINE_STRING(IndexRollMonth);
DEFINE_NUMINGROUP(NoIndexRollMonths);
DEFINE_STRING(AssetSubType);
DEFINE_INT(CommodityFinalPriceType);
DEFINE_STRING(FinancialInstrumentShortName);
DEFINE_LOCALMKTDATE(NextIndexRollDate);
DEFINE_STRING(LegAssetSubType);
DEFINE_STRING(LegFinancialInstrumentShortName);
DEFINE_STRING(LegPaymentStreamRateIndexID);
DEFINE_STRING(LegPaymentStreamRateIndexIDSource);
DEFINE_STRING(LegSecondaryAssetSubType);
DEFINE_STRING(PaymentStreamRateIndexID);
DEFINE_STRING(PaymentStreamRateIndexIDSource);
DEFINE_NUMINGROUP(NoReferenceDataDates);
DEFINE_UTCTIMESTAMP(ReferenceDataDate);
DEFINE_INT(ReferenceDataDateType);
DEFINE_STRING(SecondaryAssetSubType);
DEFINE_STRING(UnderlyingFinancialInstrumentShortName);
DEFINE_STRING(UnderlyingAssetSubType);
DEFINE_STRING(UnderlyingPaymentStreamRateIndexID);
DEFINE_STRING(UnderlyingPaymentStreamRateIndexIDSource);
DEFINE_STRING(UnderlyingSecondaryAssetSubType);
DEFINE_STRING(DeliveryStreamRouteOrCharter);
DEFINE_STRING(LegDeliveryStreamRouteOrCharter);
DEFINE_STRING(UnderlyingDeliveryStreamRouteOrCharter);
DEFINE_UTCTIMESTAMP(ExecutionTimestamp);
DEFINE_PRICE(ReportingPx);
DEFINE_QTY(ReportingQty);
DEFINE_STRING(DeliveryRouteOrCharter);
DEFINE_INT(ReturnTrigger);
DEFINE_STRING(LegDeliveryRouteOrCharter);
DEFINE_INT(LegReturnTrigger);
DEFINE_STRING(UnderlyingDeliveryRouteOrCharter);
DEFINE_INT(UnderlyingReturnTrigger);
DEFINE_STRING(AllocRequestID);
DEFINE_AMT(GroupAmount);
DEFINE_AMT(GroupRemainingAmount);
DEFINE_AMT(AllocGroupAmount);
DEFINE_PRICEOFFSET(PriceMarkup);
DEFINE_INT(AveragePriceType);
DEFINE_UTCTIMESTAMP(AveragePriceStartTime);
DEFINE_UTCTIMESTAMP(AveragePriceEndTime);
DEFINE_PERCENTAGE(OrderPercentOfTotalVolume);
DEFINE_INT(AllocGroupStatus);
DEFINE_INT(AllocRequestStatus);
DEFINE_INT(AllocAvgPxIndicator);
DEFINE_STRING(AllocAvgPxGroupID);
DEFINE_STRING(PreviousAllocGroupID);
DEFINE_NUMINGROUP(NoMatchExceptions);
DEFINE_INT(MatchExceptionType);
DEFINE_INT(MatchExceptionElementType);
DEFINE_STRING(MatchExceptionElementName);
DEFINE_STRING(MatchExceptionAllocValue);
DEFINE_STRING(MatchExceptionConfirmValue);
DEFINE_FLOAT(MatchExceptionToleranceValue);
DEFINE_INT(MatchExceptionToleranceValueType);
DEFINE_STRING(MatchExceptionText);
DEFINE_NUMINGROUP(NoMatchingDataPoints);
DEFINE_INT(MatchingDataPointIndicator);
DEFINE_STRING(MatchingDataPointValue);
DEFINE_INT(MatchingDataPointType);
DEFINE_STRING(MatchingDataPointName);
DEFINE_LENGTH(EncodedMatchExceptionTextLen);
DEFINE_DATA(EncodedMatchExceptionText);
DEFINE_STRING(TradeAggregationRequestID);
DEFINE_STRING(TradeAggregationRequestRefID);
DEFINE_INT(TradeAggregationTransType);
DEFINE_QTY(AggregatedQty);
DEFINE_INT(TradeAggregationRequestStatus);
DEFINE_INT(TradeAggregationRejectReason);
DEFINE_STRING(TradeAggregationReportID);
DEFINE_PRICE(AvgSpotRate);
DEFINE_PRICEOFFSET(AvgForwardPoints);
DEFINE_INT(OffshoreIndicator);
DEFINE_STRING(FXBenchmarkRateFix);
DEFINE_STRING(PayReportID);
DEFINE_INT(PayDisputeReason);
DEFINE_DATA(EncodedReplaceText);
DEFINE_LENGTH(EncodedReplaceTextLen);
DEFINE_STRING(PayReportRefID);
DEFINE_INT(PayReportTransType);
DEFINE_STRING(ReplaceText);
DEFINE_INT(PayReportStatus);
DEFINE_STRING(CancelText);
DEFINE_DATA(EncodedCancelText);
DEFINE_LENGTH(EncodedCancelTextLen);
DEFINE_STRING(PayRequestRefID);
DEFINE_INT(PayRequestTransType);
DEFINE_STRING(PayRequestID);
DEFINE_INT(PayRequestStatus);
DEFINE_DATA(EncodedPostTradePaymentDesc);
DEFINE_LENGTH(EncodedPostTradePaymentDescLen);
DEFINE_STRING(PostTradePaymentAccount);
DEFINE_AMT(PostTradePaymentAmount);
DEFINE_CURRENCY(PostTradePaymentCurrency);
DEFINE_INT(PostTradePaymentDebitOrCredit);
DEFINE_STRING(PostTradePaymentDesc);
DEFINE_STRING(PostTradePaymentID);
DEFINE_STRING(PostTradePaymentLinkID);
DEFINE_INT(PostTradePaymentStatus);
DEFINE_STRING(PostTradePaymentType);
DEFINE_LOCALMKTDATE(PostTradePaymentCalculationDate);
DEFINE_LOCALMKTDATE(PostTradePaymentValueDate);
DEFINE_LOCALMKTDATE(PostTradePaymentFinalValueDate);
DEFINE_PRICE(CurrentDisplayPrice);
DEFINE_BOOLEAN(DuplicateClOrdIDIndicator);
DEFINE_CHAR(EventInitiatorType);
DEFINE_INT(NBBOEntryType);
DEFINE_PRICE(NBBOPrice);
DEFINE_QTY(NBBOQty);
DEFINE_INT(NBBOSource);
DEFINE_STRING(OrderOriginationFirmID);
DEFINE_UTCTIMESTAMP(RelatedOrderTime);
DEFINE_BOOLEAN(SingleQuoteIndicator);
DEFINE_PRICE(CurrentWorkingPrice);
DEFINE_BOOLEAN(TrdRegTimestampManualIndicator);
DEFINE_PERCENTAGE(CollateralReinvestmentRate);
DEFINE_STRING(UnderlyingRefID);
DEFINE_AMT(CollateralReinvestmentAmount);
DEFINE_CURRENCY(CollateralReinvestmentCurrency);
DEFINE_INT(CollateralReinvestmentType);
DEFINE_NUMINGROUP(NoCollateralReinvestments);
DEFINE_INT(FundingSource);
DEFINE_CURRENCY(FundingSourceCurrency);
DEFINE_AMT(FundingSourceMarketValue);
DEFINE_NUMINGROUP(NoFundingSources);
DEFINE_STRING(LegPaymentStreamOtherDayCount);
DEFINE_INT(MarginDirection);
DEFINE_PERCENTAGE(PaymentFixedRate);
DEFINE_STRING(PaymentFloatingRateIndex);
DEFINE_INT(PaymentFloatingRateIndexCurvePeriod);
DEFINE_STRING(PaymentFloatingRateIndexCurveUnit);
DEFINE_PRICEOFFSET(PaymentFloatingRateSpread);
DEFINE_INT(PaymentFrequencyPeriod);
DEFINE_STRING(PaymentFrequencyUnit);
DEFINE_INT(PaymentRateResetFrequencyPeriod);
DEFINE_STRING(PaymentRateResetFrequencyUnit);
DEFINE_STRING(PaymentStreamOtherDayCount);
DEFINE_PERCENTAGE(SideCollateralReinvestmentRate);
DEFINE_STRING(SideUnderlyingRefID);
DEFINE_NUMINGROUP(NoSideCollateralReinvestments);
DEFINE_AMT(SideCollateralReinvestmentAmount);
DEFINE_CURRENCY(SideCollateralReinvestmentCurrency);
DEFINE_INT(SideCollateralReinvestmentType);
DEFINE_LOCALMKTDATE(CollateralizationValueDate);
DEFINE_LOCALMKTDATE(RegulatoryReportTypeBusinessDate);
DEFINE_STRING(ClearingPortfolioID);
DEFINE_NUMINGROUP(NoTransactionAttributes);
DEFINE_INT(TransactionAttributeType);
DEFINE_STRING(TransactionAttributeValue);
DEFINE_STRING(UnderlyingID);
DEFINE_STRING(UnderlyingPaymentStreamOtherDayCount);
DEFINE_PRICE(PosAmtPrice);
DEFINE_INT(PosAmtPriceType);
DEFINE_LOCALMKTDATE(TerminationDate);
DEFINE_STRING(CouponOtherDayCount);
DEFINE_STRING(LegCouponOtherDayCount);
DEFINE_STRING(UnderlyingCouponOtherDayCount);
DEFINE_INT(ContraOrderOrigination);
DEFINE_INT(RoutingArrangmentIndicator);
DEFINE_INT(ContraRoutingArrangmentIndicator);
DEFINE_LENGTH(PaymentStreamFormulaLength);
DEFINE_LENGTH(LegPaymentStreamFormulaLength);
DEFINE_LENGTH(UnderlyingPaymentStreamFormulaLength);
DEFINE_AMT(UnderlyingAccruedInterestAmt);
DEFINE_INT(UnderlyingNumDaysInterest);
DEFINE_STRING(RelatedOrderID);
DEFINE_INT(RelatedOrderIDSource);
DEFINE_QTY(RelatedOrderQty);
DEFINE_INT(OrderRelationship);
DEFINE_STRING(UPICode);
DEFINE_STRING(DerivativeUPICode);
DEFINE_STRING(LegUPICode);
DEFINE_STRING(UnderlyingUPICode);
DEFINE_STRING(InstrumentScopeUPICode);
DEFINE_INT(TertiaryTrdType);
DEFINE_STRING(PaymentStreamRateIndex2);
DEFINE_INT(PaymentStreamRateIndex2Source);
DEFINE_STRING(PaymentStreamRateIndex2ID);
DEFINE_STRING(PaymentStreamRateIndex2IDSource);
DEFINE_STRING(LegPaymentStreamRateIndex2);
DEFINE_INT(LegPaymentStreamRateIndex2Source);
DEFINE_STRING(LegPaymentStreamRateIndex2ID);
DEFINE_STRING(LegPaymentStreamRateIndex2IDSource);
DEFINE_STRING(UnderlyingPaymentStreamRateIndex2);
DEFINE_INT(UnderlyingPaymentStreamRateIndex2Source);
DEFINE_STRING(UnderlyingPaymentStreamRateIndex2ID);
DEFINE_STRING(UnderlyingPaymentStreamRateIndex2IDSource);
DEFINE_STRING(CurrencyCodeSource);
DEFINE_STRING(LegCurrencyCodeSource);
DEFINE_STRING(SettlCurrencyCodeSource);
DEFINE_STRING(LegSettlCurrencyCodeSource);
DEFINE_STRING(SideCurrencyCodeSource);
DEFINE_STRING(SideSettlCurrencyCodeSource);
DEFINE_STRING(SettlementAmountCurrencyCodeSource);
DEFINE_STRING(StrikeCurrencyCodeSource);
DEFINE_STRING(UnitOfMeasureCurrencyCodeSource);
DEFINE_STRING(PriceUnitOfMeasureCurrencyCodeSource);
DEFINE_STRING(PriceQuoteCurrencyCodeSource);
DEFINE_STRING(LegStrikeCurrencyCodeSource);
DEFINE_STRING(LegUnitOfMeasureCurrencyCodeSource);
DEFINE_STRING(LegPriceUnitOfMeasureCurrencyCodeSource);
DEFINE_STRING(LegPriceQuoteCurrencyCodeSource);
DEFINE_STRING(DerivativeStrikeCurrencyCodeSource);
DEFINE_STRING(DerivativeUnitOfMeasureCurrencyCodeSource);
DEFINE_STRING(DerivativePriceUnitOfMeasureCurrencyCodeSource);
DEFINE_STRING(DerivativePriceQuoteCurrencyCodeSource);
DEFINE_STRING(UnderlyingCurrencyCodeSource);
DEFINE_STRING(UnderlyingStrikeCurrencyCodeSource);
DEFINE_STRING(UnderlyingUnitOfMeasureCurrencyCodeSource);
DEFINE_STRING(UnderlyingPriceUnitOfMeasureCurrencyCodeSource);
DEFINE_STRING(UnderlyingPriceQuoteCurrencyCodeSource);
DEFINE_STRING(UnderlyingNotionalCurrencyCodeSource);
DEFINE_STRING(CommCurrencyCodeSource);
DEFINE_STRING(CommissionCurrencyCodeSource);
DEFINE_STRING(CommissionUnitOfMeasureCurrencyCodeSource);
DEFINE_STRING(AllocCommissionCurrencyCodeSource);
DEFINE_STRING(AllocCommissionUnitOfMeasureCurrencyCodeSource);
DEFINE_STRING(AllocSettlCurrencyCodeSource);
DEFINE_STRING(LegAllocSettlCurrencyCodeSource);
DEFINE_STRING(CollateralCurrencyCodeSource);
DEFINE_STRING(SideCollateralCurrencyCodeSource);
DEFINE_STRING(CollateralReinvestmentCurrencyCodeSource);
DEFINE_STRING(SideCollateralReinvestmentCurrencyCodeSource);
DEFINE_STRING(TradeAllocCurrencyCodeSource);
DEFINE_STRING(TradingCurrencyCodeSource);
DEFINE_STRING(LimitAmtCurrencyCodeSource);
DEFINE_STRING(PosQtyUnitOfMeasureCurrencyCodeSource);
DEFINE_STRING(PositionCurrencyCodeSource);
DEFINE_STRING(LegPosCurrencyCodeSource);
DEFINE_STRING(RiskLimitCurrencyCodeSource);
DEFINE_STRING(EntitlementAttribCurrencyCodeSource);
DEFINE_STRING(ComplexOptPayoutCurrencyCodeSource);
DEFINE_STRING(ComplexEventCurrencyOneCodeSource);
DEFINE_STRING(ComplexEventCurrencyTwoCodeSource);
DEFINE_STRING(LegComplexOptPayoutCurrencyCodeSource);
DEFINE_STRING(LegComplexEventCurrencyOneCodeSource);
DEFINE_STRING(LegComplexEventCurrencyTwoCodeSource);
DEFINE_STRING(UnderlyingComplexOptPayoutCurrencyCodeSource);
DEFINE_STRING(UnderlyingComplexEventCurrencyOneCodeSource);
DEFINE_STRING(UnderlyingComplexEventCurrencyTwoCodeSource);
DEFINE_STRING(BenchmarkCurveCurrencyCodeSource);
DEFINE_STRING(LegBenchmarkCurveCurrencyCodeSource);
DEFINE_STRING(AgreementCurrencyCodeSource);
DEFINE_STRING(LegAgreementCurrencyCodeSource);
DEFINE_STRING(FundingSourceCurrencyCodeSource);
DEFINE_STRING(PayCollectCurrencyCodeSource);
DEFINE_STRING(PostTradePaymentCurrencyCodeSource);
DEFINE_INT(SymbolPositionNumber);
DEFINE_INT(LegSymbolPositionNumber);
DEFINE_INT(UnderlyingSymbolPositionNumber);
DEFINE_STRING(SettlPriceUnitOfMeasureCurrencyCodeSource);
DEFINE_BOOLEAN(AnonymousTradeIndicator);
DEFINE_STRING(SecurityReferenceDataSupplement);
DEFINE_INT(MultiJurisdictionReportingIndicator);
DEFINE_INT(SelfMatchPreventionInstruction);
} // namespace FIX

#ifdef ReplaceText
#ifdef _MSC_VER
#pragma pop_macro("ReplaceText")
#else
#pragma pop("ReplaceText")
#endif
#endif

#endif // FIX_FIELDS_H
