#ifndef FIX_VALUES_H
#define FIX_VALUES_H

#include <string>

namespace FIX {
const char MsgType_Heartbeat[] = "0";
const char MsgType_TestRequest[] = "1";
const char MsgType_ResendRequest[] = "2";
const char MsgType_Reject[] = "3";
const char MsgType_SequenceReset[] = "4";
const char MsgType_Logout[] = "5";
const char MsgType_Logon[] = "A";
const char MsgType_XMLnonFIX[] = "n";
const char MsgType_IOI[] = "6";
const char MsgType_Advertisement[] = "7";
const char MsgType_ExecutionReport[] = "8";
const char MsgType_OrderCancelReject[] = "9";
const char MsgType_News[] = "B";
const char MsgType_Email[] = "C";
const char MsgType_NewOrderSingle[] = "D";
const char MsgType_NewOrderList[] = "E";
const char MsgType_OrderCancelRequest[] = "F";
const char MsgType_OrderCancelReplaceRequest[] = "G";
const char MsgType_OrderStatusRequest[] = "H";
const char MsgType_Allocation[] = "J";
const char MsgType_ListCancelRequest[] = "K";
const char MsgType_ListExecute[] = "L";
const char MsgType_ListStatusRequest[] = "M";
const char MsgType_ListStatus[] = "N";
const char MsgType_AllocationInstructionAck[] = "P";
const char MsgType_DontKnowTrade[] = "Q";
const char MsgType_QuoteRequest[] = "R";
const char MsgType_Quote[] = "S";
const char MsgType_SettlementInstructions[] = "T";
const char MsgType_MarketDataRequest[] = "V";
const char MsgType_MarketDataSnapshotFullRefresh[] = "W";
const char MsgType_MarketDataIncrementalRefresh[] = "X";
const char MsgType_MarketDataRequestReject[] = "Y";
const char MsgType_QuoteCancel[] = "Z";
const char MsgType_QuoteStatusRequest[] = "a";
const char MsgType_QuoteAcknowledgement[] = "b";
const char MsgType_SecurityDefinitionRequest[] = "c";
const char MsgType_SecurityDefinition[] = "d";
const char MsgType_SecurityStatusRequest[] = "e";
const char MsgType_SecurityStatus[] = "f";
const char MsgType_TradingSessionStatusRequest[] = "g";
const char MsgType_TradingSessionStatus[] = "h";
const char MsgType_MassQuote[] = "i";
const char MsgType_BusinessMessageReject[] = "j";
const char MsgType_BidRequest[] = "k";
const char MsgType_BidResponse[] = "l";
const char MsgType_ListStrikePrice[] = "m";
const char MsgType_AllocationAck[] = "P";
const char MsgType_MassQuoteAcknowledgement[] = "b";
const char MsgType_RegistrationInstructions[] = "o";
const char MsgType_RegistrationInstructionsResponse[] = "p";
const char MsgType_OrderMassCancelRequest[] = "q";
const char MsgType_OrderMassCancelReport[] = "r";
const char MsgType_NewOrderCross[] = "s";
const char MsgType_CrossOrderCancelReplaceRequest[] = "t";
const char MsgType_CrossOrderCancelRequest[] = "u";
const char MsgType_SecurityTypeRequest[] = "v";
const char MsgType_SecurityTypes[] = "w";
const char MsgType_SecurityListRequest[] = "x";
const char MsgType_SecurityList[] = "y";
const char MsgType_DerivativeSecurityListRequest[] = "z";
const char MsgType_DerivativeSecurityList[] = "AA";
const char MsgType_NewOrderMultileg[] = "AB";
const char MsgType_MultilegOrderCancelReplaceRequest[] = "AC";
const char MsgType_TradeCaptureReportRequest[] = "AD";
const char MsgType_TradeCaptureReport[] = "AE";
const char MsgType_OrderMassStatusRequest[] = "AF";
const char MsgType_QuoteRequestReject[] = "AG";
const char MsgType_RFQRequest[] = "AH";
const char MsgType_QuoteStatusReport[] = "AI";
const char MsgType_AllocationInstruction[] = "J";
const char MsgType_MultilegOrderCancelReplace[] = "AC";
const char MsgType_QuoteResponse[] = "AJ";
const char MsgType_Confirmation[] = "AK";
const char MsgType_PositionMaintenanceRequest[] = "AL";
const char MsgType_PositionMaintenanceReport[] = "AM";
const char MsgType_RequestForPositions[] = "AN";
const char MsgType_RequestForPositionsAck[] = "AO";
const char MsgType_PositionReport[] = "AP";
const char MsgType_TradeCaptureReportRequestAck[] = "AQ";
const char MsgType_TradeCaptureReportAck[] = "AR";
const char MsgType_AllocationReport[] = "AS";
const char MsgType_AllocationReportAck[] = "AT";
const char MsgType_ConfirmationAck[] = "AU";
const char MsgType_SettlementInstructionRequest[] = "AV";
const char MsgType_AssignmentReport[] = "AW";
const char MsgType_CollateralRequest[] = "AX";
const char MsgType_CollateralAssignment[] = "AY";
const char MsgType_CollateralResponse[] = "AZ";
const char MsgType_CollateralReport[] = "BA";
const char MsgType_CollateralInquiry[] = "BB";
const char MsgType_NetworkCounterpartySystemStatusRequest[] = "BC";
const char MsgType_NetworkCounterpartySystemStatusResponse[] = "BD";
const char MsgType_UserRequest[] = "BE";
const char MsgType_UserResponse[] = "BF";
const char MsgType_CollateralInquiryAck[] = "BG";
const char MsgType_ConfirmationRequest[] = "BH";
const char MsgType_ContraryIntentionReport[] = "BO";
const char MsgType_SecurityDefinitionUpdateReport[] = "BP";
const char MsgType_SecurityListUpdateReport[] = "BK";
const char MsgType_AdjustedPositionReport[] = "BL";
const char MsgType_AllocationInstructionAlert[] = "BM";
const char MsgType_ExecutionAcknowledgement[] = "BN";
const char MsgType_TradingSessionList[] = "BJ";
const char MsgType_TradingSessionListRequest[] = "BI";
const char MsgType_SettlementObligationReport[] = "BQ";
const char MsgType_DerivativeSecurityListUpdateReport[] = "BR";
const char MsgType_TradingSessionListUpdateReport[] = "BS";
const char MsgType_MarketDefinitionRequest[] = "BT";
const char MsgType_MarketDefinition[] = "BU";
const char MsgType_MarketDefinitionUpdateReport[] = "BV";
const char MsgType_UserNotification[] = "CB";
const char MsgType_OrderMassActionReport[] = "BZ";
const char MsgType_OrderMassActionRequest[] = "CA";
const char MsgType_ApplicationMessageRequest[] = "BW";
const char MsgType_ApplicationMessageRequestAck[] = "BX";
const char MsgType_ApplicationMessageReport[] = "BY";
const char MsgType_MassQuoteAck[] = "b";
const char MsgType_ExecutionAck[] = "BN";
const char MsgType_StreamAssignmentRequest[] = "CC";
const char MsgType_StreamAssignmentReport[] = "CD";
const char MsgType_StreamAssignmentReportACK[] = "CE";
const char MsgType_MarginRequirementInquiry[] = "CH";
const char MsgType_MarginRequirementInquiryAck[] = "CI";
const char MsgType_MarginRequirementReport[] = "CJ";
const char MsgType_PartyDetailsListRequest[] = "CF";
const char MsgType_PartyDetailsListReport[] = "CG";
const char MsgType_PartyDetailsListUpdateReport[] = "CK";
const char MsgType_PartyRiskLimitsRequest[] = "CL";
const char MsgType_PartyRiskLimitsReport[] = "CM";
const char MsgType_SecurityMassStatusRequest[] = "CN";
const char MsgType_SecurityMassStatus[] = "CO";
const char MsgType_AccountSummaryReport[] = "CQ";
const char MsgType_PartyRiskLimitsUpdateReport[] = "CR";
const char MsgType_PartyRiskLimitsDefinitionRequest[] = "CS";
const char MsgType_PartyRiskLimitsDefinitionRequestAck[] = "CT";
const char MsgType_PartyEntitlementsRequest[] = "CU";
const char MsgType_PartyEntitlementsReport[] = "CV";
const char MsgType_QuoteAck[] = "CW";
const char MsgType_PartyDetailsDefinitionRequest[] = "CX";
const char MsgType_PartyDetailsDefinitionRequestAck[] = "CY";
const char MsgType_PartyEntitlementsUpdateReport[] = "CZ";
const char MsgType_PartyEntitlementsDefinitionRequest[] = "DA";
const char MsgType_PartyEntitlementsDefinitionRequestAck[] = "DB";
const char MsgType_TradeMatchReport[] = "DC";
const char MsgType_TradeMatchReportAck[] = "DD";
const char MsgType_PartyRiskLimitsReportAck[] = "DE";
const char MsgType_PartyRiskLimitCheckRequest[] = "DF";
const char MsgType_PartyRiskLimitCheckRequestAck[] = "DG";
const char MsgType_PartyActionRequest[] = "DH";
const char MsgType_PartyActionReport[] = "DI";
const char MsgType_MassOrder[] = "DJ";
const char MsgType_MassOrderAck[] = "DK";
const char MsgType_PositionTransferInstruction[] = "DL";
const char MsgType_PositionTransferInstructionAck[] = "DM";
const char MsgType_PositionTransferReport[] = "DN";
const char MsgType_MarketDataStatisticsRequest[] = "DO";
const char MsgType_MarketDataStatisticsReport[] = "DP";
const char MsgType_CollateralReportAck[] = "DQ";
const char MsgType_MarketDataReport[] = "DR";
const char MsgType_CrossRequest[] = "DS";
const char MsgType_CrossRequestAck[] = "DT";
const char MsgType_AllocationInstructionAlertRequest[] = "DU";
const char MsgType_AllocationInstructionAlertRequestAck[] = "DV";
const char MsgType_TradeAggregationRequest[] = "DW";
const char MsgType_TradeAggregationReport[] = "DX";
const char MsgType_PayManagementReport[] = "EA";
const char MsgType_PayManagementReportAck[] = "EB";
const char MsgType_PayManagementRequest[] = "DY";
const char MsgType_PayManagementRequestAck[] = "DZ";
const char PossDupFlag_NO = 'N';
const char PossDupFlag_YES = 'Y';
const char PossResend_NO = 'N';
const char PossResend_YES = 'Y';
const int EncryptMethod_NONE_OTHER = 0;
const int EncryptMethod_PKCS = 1;
const int EncryptMethod_DES = 2;
const int EncryptMethod_PKCSDES = 3;
const int EncryptMethod_PGPDES = 4;
const int EncryptMethod_PGPDESMD5 = 5;
const int EncryptMethod_PEMDESMD5 = 6;
const int EncryptMethod_NONE = 0;
const int EncryptMethod_PEM = 6;
const char GapFillFlag_NO = 'N';
const char GapFillFlag_YES = 'Y';
const char ResetSeqNumFlag_NO = 'N';
const char ResetSeqNumFlag_YES = 'Y';
const char MessageEncoding_EUCJP[] = "EUC-JP";
const char MessageEncoding_ISO2022_JP[] = "ISO-2022-JP";
const char MessageEncoding_SHIFT_JIS[] = "Shift_JIS";
const char MessageEncoding_UTF8[] = "UTF-8";
const int SessionRejectReason_INVALID_TAG_NUMBER = 0;
const int SessionRejectReason_REQUIRED_TAG_MISSING = 1;
const int SessionRejectReason_TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE = 2;
const int SessionRejectReason_UNDEFINED_TAG = 3;
const int SessionRejectReason_TAG_SPECIFIED_WITHOUT_A_VALUE = 4;
const int SessionRejectReason_VALUE_IS_INCORRECT = 5;
const int SessionRejectReason_INCORRECT_DATA_FORMAT_FOR_VALUE = 6;
const int SessionRejectReason_DECRYPTION_PROBLEM = 7;
const int SessionRejectReason_SIGNATURE_PROBLEM = 8;
const int SessionRejectReason_COMPID_PROBLEM = 9;
const int SessionRejectReason_SENDINGTIME_ACCURACY_PROBLEM = 10;
const int SessionRejectReason_INVALID_MSGTYPE = 11;
const int SessionRejectReason_XML_VALIDATION_ERROR = 12;
const int SessionRejectReason_TAG_APPEARS_MORE_THAN_ONCE = 13;
const int SessionRejectReason_TAG_SPECIFIED_OUT_OF_REQUIRED_ORDER = 14;
const int SessionRejectReason_REPEATING_GROUP_FIELDS_OUT_OF_ORDER = 15;
const int SessionRejectReason_INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP = 16;
const int SessionRejectReason_NON_DATA_VALUE_INCLUDES_FIELD_DELIMITER = 17;
const int SessionRejectReason_INVALID_UNSUPPORTED_APPLICATION_VERSION = 18;
const int SessionRejectReason_OTHER = 99;
const int SessionRejectReason_SENDING_TIME_ACCURACY_PROBLEM = 10;
const int SessionRejectReason_INVALID_MSG_TYPE = 11;
const int SessionRejectReason_COMP_ID_PROBLEM = 9;
const int SessionRejectReason_NON = 17;
const int SessionRejectReason_INCORRECT_NUM_IN_GROUP_COUNT_FOR_REPEATING_GROUP = 16;
const char TestMessageIndicator_NO = 'N';
const char TestMessageIndicator_YES = 'Y';
const char ApplVerID_FIX27[] = "0";
const char ApplVerID_FIX30[] = "1";
const char ApplVerID_FIX40[] = "2";
const char ApplVerID_FIX41[] = "3";
const char ApplVerID_FIX42[] = "4";
const char ApplVerID_FIX43[] = "5";
const char ApplVerID_FIX44[] = "6";
const char ApplVerID_FIX50[] = "7";
const char ApplVerID_FIX50_SP1[] = "8";
const char ApplVerID_FIX50_SP2[] = "9";
const int SessionStatus_SESSION_ACTIVE = 0;
const int SessionStatus_SESSION_PASSWORD_CHANGED = 1;
const int SessionStatus_SESSION_PASSWORD_DUE_TO_EXPIRE = 2;
const int SessionStatus_NEW_SESSION_PASSWORD_DOES_NOT_COMPLY_WITH_POLICY = 3;
const int SessionStatus_SESSION_LOGOUT_COMPLETE = 4;
const int SessionStatus_INVALID_USERNAME_OR_PASSWORD = 5;
const int SessionStatus_ACCOUNT_LOCKED = 6;
const int SessionStatus_LOGONS_ARE_NOT_ALLOWED_AT_THIS_TIME = 7;
const int SessionStatus_PASSWORD_EXPIRED = 8;
const char AdvSide_BUY = 'B';
const char AdvSide_SELL = 'S';
const char AdvSide_TRADE = 'T';
const char AdvSide_CROSS = 'X';
const char AdvTransType_CANCEL[] = "C";
const char AdvTransType_NEW[] = "N";
const char AdvTransType_REPLACE[] = "R";
const char CommType_PER_UNIT = '1';
const char CommType_PERCENT = '2';
const char CommType_ABSOLUTE = '3';
const char CommType_POINTS_PER_BOND_OR_CONTRACT = '6';
const char CommType_PERCENTAGE_WAIVED_ENHANCED_UNITS = '5';
const char CommType_PERCENTAGE_WAIVED_CASH_DISCOUNT = '4';
const char CommType_BASIS_POINTS = '7';
const char CommType_AMOUNT_PER_CONTRACT = '8';
const char ExecInst_STAY_ON_OFFER_SIDE = '0';
const char ExecInst_NOT_HELD = '1';
const char ExecInst_WORK = '2';
const char ExecInst_GO_ALONG = '3';
const char ExecInst_OVER_THE_DAY = '4';
const char ExecInst_HELD = '5';
const char ExecInst_PARTICIPATE_DO_NOT_INITIATE = '6';
const char ExecInst_STRICT_SCALE = '7';
const char ExecInst_TRY_TO_SCALE = '8';
const char ExecInst_STAY_ON_BID_SIDE = '9';
const char ExecInst_NO_CROSS = 'A';
const char ExecInst_OK_TO_CROSS = 'B';
const char ExecInst_CALL_FIRST = 'C';
const char ExecInst_PERCENT_OF_VOLUME = 'D';
const char ExecInst_DO_NOT_INCREASE = 'E';
const char ExecInst_DO_NOT_REDUCE = 'F';
const char ExecInst_ALL_OR_NONE = 'G';
const char ExecInst_INSTITUTIONS_ONLY = 'I';
const char ExecInst_LAST_PEG = 'L';
const char ExecInst_MID_PRICE_PEG = 'M';
const char ExecInst_NON_NEGOTIABLE = 'N';
const char ExecInst_OPENING_PEG = 'O';
const char ExecInst_MARKET_PEG = 'P';
const char ExecInst_PRIMARY_PEG = 'R';
const char ExecInst_SUSPEND = 'S';
const char ExecInst_CUSTOMER_DISPLAY_INSTRUCTION = 'U';
const char ExecInst_NETTING = 'V';
const char ExecInst_FIXED_PEG_TO_LOCAL_BEST_BID_OR_OFFER_AT_TIME_OF_ORDER = 'T';
const char ExecInst_PEG_TO_VWAP = 'W';
const char ExecInst_TRY_TO_STOP = 'Y';
const char ExecInst_CANCEL_ON_SYSTEM_FAILURE = 'Q';
const char ExecInst_TRADE_ALONG = 'X';
const char ExecInst_REINSTATE_ON_SYSTEM_FAILURE = 'H';
const char ExecInst_REINSTATE_ON_TRADING_HALT = 'J';
const char ExecInst_CANCEL_ON_TRADING_HALT = 'K';
const char ExecInst_CANCEL_IF_NOT_BEST = 'Z';
const char ExecInst_TRAILING_STOP_PEG = 'a';
const char ExecInst_STRICT_LIMIT = 'b';
const char ExecInst_IGNORE_PRICE_VALIDITY_CHECKS = 'c';
const char ExecInst_PEG_TO_LIMIT_PRICE = 'd';
const char ExecInst_WORK_TO_TARGET_STRATEGY = 'e';
const char ExecInst_INTERMARKET_SWEEP = 'f';
const char ExecInst_EXTERNAL_ROUTING_ALLOWED = 'g';
const char ExecInst_EXTERNAL_ROUTING_NOT_ALLOWED = 'h';
const char ExecInst_IMBALANCE_ONLY = 'i';
const char ExecInst_SINGLE_EXECUTION_REQUESTED_FOR_BLOCK_TRADE = 'j';
const char ExecInst_BEST_EXECUTION = 'k';
const char ExecInst_SUSPEND_ON_SYSTEM_FAILURE = 'l';
const char ExecInst_SUSPEND_ON_TRADING_HALT = 'm';
const char ExecInst_REINSTATE_ON_CONNECTION_LOSS = 'n';
const char ExecInst_CANCEL_ON_CONNECTION_LOSS = 'o';
const char ExecInst_SUSPEND_ON_CONNECTION_LOSS = 'p';
const char ExecInst_RELEASE_FROM_SUSPENSION = 'q';
const char ExecInst_EXECUTE_AS_DELTA_NEUTRAL = 'r';
const char ExecInst_EXECUTE_AS_DURATION_NEUTRAL = 's';
const char ExecInst_EXECUTE_AS_FX_NEUTRAL = 't';
const char ExecInst_RELEASE = 'q';
const char ExecInst_MIN_GUARANTEED_FILL_ELIGIBLE = 'u';
const char ExecInst_BYPASS_NON_DISPLAY_LIQUIDITY = 'v';
const char ExecInst_LOCK = 'w';
const char ExecInst_IGNORE_NOTIONAL_VALUE_CHECKS = 'x';
const char ExecInst_TRD_AT_REF_PX = 'y';
const char ExecInst_ALLOW_FACILITATION = 'z';
const char ExecTransType_NEW = '0';
const char ExecTransType_CANCEL = '1';
const char ExecTransType_CORRECT = '2';
const char ExecTransType_STATUS = '3';
const char HandlInst_AUTOMATED_EXECUTION_NO_INTERVENTION = '1';
const char HandlInst_AUTOMATED_EXECUTION_INTERVENTION_OK = '2';
const char HandlInst_MANUAL_ORDER = '3';
const char IDSource_CUSIP[] = "1";
const char IDSource_SEDOL[] = "2";
const char IDSource_QUIK[] = "3";
const char IDSource_ISIN_NUMBER[] = "4";
const char IDSource_RIC_CODE[] = "5";
const char IDSource_ISO_CURRENCY_CODE[] = "6";
const char IDSource_ISO_COUNTRY_CODE[] = "7";
const char IDSource_EXCHANGE_SYMBOL[] = "8";
const char IDSource_CONSOLIDATED_TAPE_ASSOCIATION[] = "9";
const char IOIOthSvc_AUTEX = 'A';
const char IOIOthSvc_BRIDGE = 'B';
const char IOIQltyInd_HIGH = 'H';
const char IOIQltyInd_LOW = 'L';
const char IOIQltyInd_MEDIUM = 'M';
const char IOIShares_LARGE[] = "L";
const char IOIShares_MEDIUM[] = "M";
const char IOIShares_SMALL[] = "S";
const char IOITransType_CANCEL = 'C';
const char IOITransType_NEW = 'N';
const char IOITransType_REPLACE = 'R';
const char LastCapacity_AGENT = '1';
const char LastCapacity_CROSS_AS_AGENT = '2';
const char LastCapacity_CROSS_AS_PRINCIPAL = '3';
const char LastCapacity_PRINCIPAL = '4';
const char LastCapacity_RISKLESS_PRINCIPAL = '5';
const char OrdStatus_NEW = '0';
const char OrdStatus_PARTIALLY_FILLED = '1';
const char OrdStatus_FILLED = '2';
const char OrdStatus_DONE_FOR_DAY = '3';
const char OrdStatus_CANCELED = '4';
const char OrdStatus_REPLACED = '5';
const char OrdStatus_PENDING_CANCEL = '6';
const char OrdStatus_STOPPED = '7';
const char OrdStatus_REJECTED = '8';
const char OrdStatus_SUSPENDED = '9';
const char OrdStatus_PENDING_NEW = 'A';
const char OrdStatus_CALCULATED = 'B';
const char OrdStatus_EXPIRED = 'C';
const char OrdStatus_ACCEPTED_FOR_BIDDING = 'D';
const char OrdStatus_PENDING_REPLACE = 'E';
const char OrdType_MARKET = '1';
const char OrdType_LIMIT = '2';
const char OrdType_STOP = '3';
const char OrdType_STOP_LIMIT = '4';
const char OrdType_MARKET_ON_CLOSE = '5';
const char OrdType_WITH_OR_WITHOUT = '6';
const char OrdType_LIMIT_OR_BETTER = '7';
const char OrdType_LIMIT_WITH_OR_WITHOUT = '8';
const char OrdType_ON_BASIS = '9';
const char OrdType_ON_CLOSE = 'A';
const char OrdType_LIMIT_ON_CLOSE = 'B';
const char OrdType_FOREX_MARKET = 'C';
const char OrdType_PREVIOUSLY_QUOTED = 'D';
const char OrdType_PREVIOUSLY_INDICATED = 'E';
const char OrdType_PEGGED = 'P';
const char OrdType_FOREX_LIMIT = 'F';
const char OrdType_FOREX_SWAP = 'G';
const char OrdType_FOREX_PREVIOUSLY_QUOTED = 'H';
const char OrdType_FUNARI = 'I';
const char OrdType_MARKET_IF_TOUCHED = 'J';
const char OrdType_MARKET_WITH_LEFT_OVER_AS_LIMIT = 'K';
const char OrdType_PREVIOUS_FUND_VALUATION_POINT = 'L';
const char OrdType_NEXT_FUND_VALUATION_POINT = 'M';
const char OrdType_COUNTER_ORDER_SELECTION = 'Q';
const char OrdType_STOP_ON_BID_OR_OFFER = 'R';
const char OrdType_STOP_LIMIT_ON_BID_OR_OFFER = 'S';
const char Rule80A_AGENCY_SINGLE_ORDER = 'A';
const char Rule80A_PROPRIETARY_NON_ALGO = 'C';
const char Rule80A_PROGRAM_ORDER_MEMBER = 'D';
const char Rule80A_INDIVIDUAL_INVESTOR = 'I';
const char Rule80A_PROPRIETARY_ALGO = 'J';
const char Rule80A_AGENCY_ALGO = 'K';
const char Rule80A_PROGRAM_ORDER_OTHER_MEMBER = 'M';
const char Rule80A_AGENT_FOR_OTHER_MEMBER = 'N';
const char Rule80A_AGENCY_INDEX_ARB = 'U';
const char Rule80A_ALL_OTHER_ORDERS_AS_AGENT_FOR_OTHER_MEMBER = 'W';
const char Rule80A_AGENCY_NON_ALGO = 'Y';
const char Rule80A_SHORT_EXEMPT_TRANSACTION_A_TYPE = 'B';
const char Rule80A_SHORT_EXEMPT_TRANSACTION_FOR_PRINCIPAL = 'E';
const char Rule80A_SHORT_EXEMPT_TRANSACTION_W_TYPE = 'F';
const char Rule80A_SHORT_EXEMPT_TRANSACTION_I_TYPE = 'H';
const char Rule80A_SHORT_EXEMPT_TRANSACTION_MEMBER_AFFLIATED = 'L';
const char Rule80A_PROPRIETARY_TRANSACTION_AFFILIATED = 'O';
const char Rule80A_PRINCIPAL = 'P';
const char Rule80A_TRANSACTION_NON_MEMBER = 'R';
const char Rule80A_SPECIALIST_TRADES = 'S';
const char Rule80A_TRANSACTION_UNAFFILIATED_MEMBER = 'T';
const char Rule80A_SHORT_EXEMPT_TRANSACTION_MEMBER_NOT_AFFLIATED = 'X';
const char Rule80A_SHORT_EXEMPT_TRANSACTION_NON_MEMBER = 'Z';
const char Side_BUY = '1';
const char Side_SELL = '2';
const char Side_BUY_MINUS = '3';
const char Side_SELL_PLUS = '4';
const char Side_SELL_SHORT = '5';
const char Side_SELL_SHORT_EXEMPT = '6';
const char Side_UNDISCLOSED = '7';
const char Side_CROSS = '8';
const char Side_CROSS_SHORT = '9';
const char Side_AS_DEFINED = 'B';
const char Side_OPPOSITE = 'C';
const char Side_CROSS_SHORT_EXEMPT = 'A';
const char Side_SUBSCRIBE = 'D';
const char Side_REDEEM = 'E';
const char Side_LEND = 'F';
const char Side_BORROW = 'G';
const char Side_SELL_UNDISCLOSED = 'H';
const char TimeInForce_DAY = '0';
const char TimeInForce_GOOD_TILL_CANCEL = '1';
const char TimeInForce_AT_THE_OPENING = '2';
const char TimeInForce_IMMEDIATE_OR_CANCEL = '3';
const char TimeInForce_FILL_OR_KILL = '4';
const char TimeInForce_GOOD_TILL_CROSSING = '5';
const char TimeInForce_GOOD_TILL_DATE = '6';
const char TimeInForce_AT_THE_CLOSE = '7';
const char TimeInForce_GOOD_THROUGH_CROSSING = '8';
const char TimeInForce_AT_CROSSING = '9';
const char TimeInForce_GOOD_FOR_TIME = 'A';
const char TimeInForce_GOOD_FOR_AUCTION = 'B';
const char TimeInForce_GOOD_FOR_MONTH = 'C';
const char Urgency_NORMAL = '0';
const char Urgency_FLASH = '1';
const char Urgency_BACKGROUND = '2';
const char SettlmntTyp_REGULAR = '0';
const char SettlmntTyp_CASH = '1';
const char SettlmntTyp_NEXT_DAY = '2';
const char SettlmntTyp_T_PLUS2 = '3';
const char SettlmntTyp_T_PLUS3 = '4';
const char SettlmntTyp_T_PLUS4 = '5';
const char SettlmntTyp_FUTURE = '6';
const char SettlmntTyp_WHEN_AND_IF_ISSUED = '7';
const char SettlmntTyp_SELLERS_OPTION = '8';
const char SettlmntTyp_T_PLUS5 = '9';
const char SettlmntTyp_T1 = 'A';
const char SymbolSfx_EUCP_WITH_LUMP_SUM_INTEREST[] = "CD";
const char SymbolSfx_WHEN_ISSUED[] = "WI";
const char AllocTransType_NEW = '0';
const char AllocTransType_REPLACE = '1';
const char AllocTransType_CANCEL = '2';
const char AllocTransType_PRELIMINARY = '3';
const char AllocTransType_CALCULATED = '4';
const char AllocTransType_CALCULATED_WITHOUT_PRELIMINARY = '5';
const char AllocTransType_REVERSAL = '6';
const char OpenClose_CLOSE = 'C';
const char OpenClose_OPEN = 'O';
const char ProcessCode_REGULAR = '0';
const char ProcessCode_SOFT_DOLLAR = '1';
const char ProcessCode_STEP_IN = '2';
const char ProcessCode_STEP_OUT = '3';
const char ProcessCode_SOFT_DOLLAR_STEP_IN = '4';
const char ProcessCode_SOFT_DOLLAR_STEP_OUT = '5';
const char ProcessCode_PLAN_SPONSOR = '6';
const int AllocStatus_ACCEPTED = 0;
const int AllocStatus_BLOCK_LEVEL_REJECT = 1;
const int AllocStatus_ACCOUNT_LEVEL_REJECT = 2;
const int AllocStatus_RECEIVED = 3;
const int AllocStatus_INCOMPLETE = 4;
const int AllocStatus_REJECTED_BY_INTERMEDIARY = 5;
const int AllocStatus_ALLOCATION_PENDING = 6;
const int AllocStatus_REVERSED = 7;
const int AllocStatus_CANCELLED_BY_INTERMEDIARY = 8;
const int AllocStatus_CLAIMED = 9;
const int AllocStatus_REFUSED = 10;
const int AllocStatus_PENDING_GIVE_UP_APPROVAL = 11;
const int AllocStatus_CANCELLED = 12;
const int AllocStatus_PENDING_TAKE_UP_APPROVAL = 13;
const int AllocStatus_REVERSAL_PENDING = 14;
const int AllocRejCode_UNKNOWN_ACCOUNT = 0;
const int AllocRejCode_INCORRECT_QUANTITY = 1;
const int AllocRejCode_INCORRECT_AVERAGEG_PRICE = 2;
const int AllocRejCode_UNKNOWN_EXECUTING_BROKER_MNEMONIC = 3;
const int AllocRejCode_COMMISSION_DIFFERENCE = 4;
const int AllocRejCode_UNKNOWN_ORDER_ID = 5;
const int AllocRejCode_UNKNOWN_LIST_ID = 6;
const int AllocRejCode_OTHER_SEE_TEXT = 7;
const int AllocRejCode_INCORRECT_ALLOCATED_QUANTITY = 8;
const int AllocRejCode_CALCULATION_DIFFERENCE = 9;
const int AllocRejCode_UNKNOWN_OR_STALE_EXEC_ID = 10;
const int AllocRejCode_MISMATCHED_DATA = 11;
const int AllocRejCode_UNKNOWN_CL_ORD_ID = 12;
const int AllocRejCode_WAREHOUSE_REQUEST_REJECTED = 13;
const int AllocRejCode_INCORRECT_AVERAGE_PRICE = 2;
const int AllocRejCode_DUPLICATE_OR_MISSING_INDIVIDUAL_ALLOC_ID = 14;
const int AllocRejCode_TRADE_NOT_RECOGNIZED = 15;
const int AllocRejCode_DUPLICATE_TRADE = 16;
const int AllocRejCode_INCORRECT_OR_MISSING_INSTRUMENT = 17;
const int AllocRejCode_INCORRECT_OR_MISSING_SETTL_DATE = 18;
const int AllocRejCode_INCORRECT_OR_MISSING_FUND_ID_OR_FUND_NAME = 19;
const int AllocRejCode_INCORRECT_OR_MISSING_SETTL_INSTRUCTIONS = 20;
const int AllocRejCode_INCORRECT_OR_MISSING_FEES = 21;
const int AllocRejCode_INCORRECT_OR_MISSING_TAX = 22;
const int AllocRejCode_UNKNOWN_OR_MISSING_PARTY = 23;
const int AllocRejCode_INCORRECT_OR_MISSING_SIDE = 24;
const int AllocRejCode_INCORRECT_OR_MISSING_NET_MONEY = 25;
const int AllocRejCode_INCORRECT_OR_MISSING_TRADE_DATE = 26;
const int AllocRejCode_INCORRECT_OR_MISSING_SETTL_CCY_INSTRUCTIONS = 27;
const int AllocRejCode_INCORRECT_OR_MISSING_PROCESS_CODE = 28;
const int AllocRejCode_OTHER = 99;
const char EmailType_NEW = '0';
const char EmailType_REPLY = '1';
const char EmailType_ADMIN_REPLY = '2';
const char ExDestination_NONE = '0';
const char ExDestination_POSIT = '4';
const int CxlRejReason_TOO_LATE_TO_CANCEL = 0;
const int CxlRejReason_UNKNOWN_ORDER = 1;
const int CxlRejReason_BROKER_CREDIT = 2;
const int CxlRejReason_ORDER_ALREADY_IN_PENDING_STATUS = 3;
const int CxlRejReason_DUPLICATE_CL_ORD_ID = 6;
const int CxlRejReason_ORIG_ORD_MOD_TIME = 5;
const int CxlRejReason_UNABLE_TO_PROCESS_ORDER_MASS_CANCEL_REQUEST = 4;
const int CxlRejReason_OTHER = 99;
const int CxlRejReason_INVALID_PRICE_INCREMENT = 18;
const int CxlRejReason_PRICE_EXCEEDS_CURRENT_PRICE = 7;
const int CxlRejReason_PRICE_EXCEEDS_CURRENT_PRICE_BAND = 8;
const int OrdRejReason_BROKER_CREDIT = 0;
const int OrdRejReason_UNKNOWN_SYMBOL = 1;
const int OrdRejReason_EXCHANGE_CLOSED = 2;
const int OrdRejReason_ORDER_EXCEEDS_LIMIT = 3;
const int OrdRejReason_TOO_LATE_TO_ENTER = 4;
const int OrdRejReason_UNKNOWN_ORDER = 5;
const int OrdRejReason_DUPLICATE_ORDER = 6;
const int OrdRejReason_DUPLICATE_OF_A_VERBALLY_COMMUNICATED_ORDER = 7;
const int OrdRejReason_STALE_ORDER = 8;
const int OrdRejReason_TRADE_ALONG_REQUIRED = 9;
const int OrdRejReason_INVALID_INVESTOR_ID = 10;
const int OrdRejReason_UNSUPPORTED_ORDER_CHARACTERISTIC = 11;
const int OrdRejReason_SURVEILLENCE_OPTION = 12;
const int OrdRejReason_INCORRECT_QUANTITY = 13;
const int OrdRejReason_INCORRECT_ALLOCATED_QUANTITY = 14;
const int OrdRejReason_UNKNOWN_ACCOUNT = 15;
const int OrdRejReason_OTHER = 99;
const int OrdRejReason_INVALID_PRICE_INCREMENT = 18;
const int OrdRejReason_PRICE_EXCEEDS_CURRENT_PRICE_BAND = 16;
const int OrdRejReason_SURVEILLANCE_OPTION = 12;
const int OrdRejReason_REFERENCE_PRICE_NOT_AVAILABLE = 19;
const int OrdRejReason_NOTIONAL_VALUE_EXCEEDS_THRESHOLD = 20;
const int OrdRejReason_ALGORITHM_RISK_THRESHOLD_BREACHED = 21;
const int OrdRejReason_SHORT_SELL_NOT_PERMITTED = 22;
const int OrdRejReason_SHORT_SELL_SECURITY_PRE_BORROW_RESTRICTION = 23;
const int OrdRejReason_SHORT_SELL_ACCOUNT_PRE_BORROW_RESTRICTION = 24;
const int OrdRejReason_INSUFFICIENT_CREDIT_LIMIT = 25;
const int OrdRejReason_EXCEEDED_CLIP_SIZE_LIMIT = 26;
const int OrdRejReason_EXCEEDED_MAX_NOTIONAL_ORDER_AMT = 27;
const int OrdRejReason_EXCEEDED_DV01_PV01_LIMIT = 28;
const int OrdRejReason_EXCEEDED_CS01_LIMIT = 29;
const char IOIQualifier_ALL_OR_NONE = 'A';
const char IOIQualifier_AT_THE_CLOSE = 'C';
const char IOIQualifier_IN_TOUCH_WITH = 'I';
const char IOIQualifier_LIMIT = 'L';
const char IOIQualifier_MORE_BEHIND = 'M';
const char IOIQualifier_AT_THE_OPEN = 'O';
const char IOIQualifier_TAKING_A_POSITION = 'P';
const char IOIQualifier_AT_THE_MARKET = 'Q';
const char IOIQualifier_PORTFOLIO_SHOWN = 'S';
const char IOIQualifier_THROUGH_THE_DAY = 'T';
const char IOIQualifier_VERSUS = 'V';
const char IOIQualifier_INDICATION = 'W';
const char IOIQualifier_CROSSING_OPPORTUNITY = 'X';
const char IOIQualifier_AT_THE_MIDPOINT = 'Y';
const char IOIQualifier_PRE_OPEN = 'Z';
const char IOIQualifier_READY_TO_TRADE = 'R';
const char IOIQualifier_VWAP = 'D';
const char IOIQualifier_MARKET_ON_CLOSE = 'B';
const char IOIQualifier_AXE = 'E';
const char IOIQualifier_AXE_ON_BID = 'F';
const char IOIQualifier_AXE_ON_OFFER = 'G';
const char IOIQualifier_CLIENT_NATURAL_WORKING = 'H';
const char IOIQualifier_POSITION_WANTED = 'J';
const char IOIQualifier_MARKET_MAKING = 'K';
const char IOIQualifier_CLIENT_NATURAL_BLOCK = 'N';
const char IOIQualifier_UNWIND = 'U';
const char IOIQualifier_QUANTITY_NEGOTIABLE = '1';
const char IOIQualifier_ALLOW_LATE_BIDS = '2';
const char IOIQualifier_IMMEDIATE_OR_COUNTER = '3';
const char IOIQualifier_AUTO_TRADE = '4';
const char IOIQualifier_AUTOMATIC_SPOT = 'a';
const char IOIQualifier_PLATFORM_CALCULATED_SPOT = 'b';
const char IOIQualifier_OUTSIDE_SPREAD = 'c';
const char IOIQualifier_DEFERRED_SPOT = 'd';
const char IOIQualifier_NEGOTIATED_SPOT = 'n';
const char ReportToExch_NO = 'N';
const char ReportToExch_YES = 'Y';
const char LocateReqd_NO = 'N';
const char LocateReqd_YES = 'Y';
const char ForexReq_NO = 'N';
const char ForexReq_YES = 'Y';
const char CxlType_FULL_REMAINING_QUANTITY = 'F';
const char CxlType_PARTIAL_CANCEL = 'P';
const char DKReason_UNKNOWN_SYMBOL = 'A';
const char DKReason_WRONG_SIDE = 'B';
const char DKReason_QUANTITY_EXCEEDS_ORDER = 'C';
const char DKReason_NO_MATCHING_ORDER = 'D';
const char DKReason_PRICE_EXCEEDS_LIMIT = 'E';
const char DKReason_OTHER = 'Z';
const char DKReason_CALCULATION_DIFFERENCE = 'F';
const char DKReason_NO_MATCHING_EXECUTION_REPORT = 'G';
const char IOINaturalFlag_NO = 'N';
const char IOINaturalFlag_YES = 'Y';
const char MiscFeeType_REGULATORY[] = "1";
const char MiscFeeType_TAX[] = "2";
const char MiscFeeType_LOCAL_COMMISSION[] = "3";
const char MiscFeeType_EXCHANGE_FEES[] = "4";
const char MiscFeeType_STAMP[] = "5";
const char MiscFeeType_LEVY[] = "6";
const char MiscFeeType_OTHER[] = "7";
const char MiscFeeType_MARKUP[] = "8";
const char MiscFeeType_CONSUMPTION_TAX[] = "9";
const char MiscFeeType_PER_TRANSACTION[] = "10";
const char MiscFeeType_CONVERSION[] = "11";
const char MiscFeeType_AGENT[] = "12";
const char MiscFeeType_TRANSFER_FEE[] = "13";
const char MiscFeeType_SECURITY_LENDING[] = "14";
const char MiscFeeType_TRADE_REPORTING[] = "15";
const char MiscFeeType_TAX_ON_PRINCIPAL_AMOUNT[] = "16";
const char MiscFeeType_TAX_ON_ACCRUED_INTEREST_AMOUNT[] = "17";
const char MiscFeeType_NEW_ISSUANCE_FEE[] = "18";
const char MiscFeeType_SERVICE_FEE[] = "19";
const char MiscFeeType_ODD_LOT_FEE[] = "20";
const char MiscFeeType_AUCTION_FEE[] = "21";
const char MiscFeeType_VALUE_ADDED_TAX[] = "22";
const char MiscFeeType_SALES_TAX[] = "23";
const char MiscFeeType_EXECUTION_FEE[] = "24";
const char MiscFeeType_ORDER_ENTRY_FEE[] = "25";
const char MiscFeeType_ORDER_MODIFICATION_FEE[] = "26";
const char MiscFeeType_ORDERS_CANCELLATION_FEE[] = "27";
const char MiscFeeType_MARKET_DATA_ACCESS_FEE[] = "28";
const char MiscFeeType_MARKET_DATA_TERMINAL_FEE[] = "29";
const char MiscFeeType_MARKET_DATA_VOLUME_FEE[] = "30";
const char MiscFeeType_CLEARING_FEE[] = "31";
const char MiscFeeType_SETTLEMENT_FEE[] = "32";
const char MiscFeeType_REBATES[] = "33";
const char MiscFeeType_DISCOUNTS[] = "34";
const char MiscFeeType_PAYMENTS[] = "35";
const char MiscFeeType_NON_MONETARY_PAYMENTS[] = "36";
const char ExecType_NEW = '0';
const char ExecType_PARTIAL_FILL = '1';
const char ExecType_FILL = '2';
const char ExecType_DONE_FOR_DAY = '3';
const char ExecType_CANCELED = '4';
const char ExecType_REPLACED = '5';
const char ExecType_PENDING_CANCEL = '6';
const char ExecType_STOPPED = '7';
const char ExecType_REJECTED = '8';
const char ExecType_SUSPENDED = '9';
const char ExecType_PENDING_NEW = 'A';
const char ExecType_CALCULATED = 'B';
const char ExecType_EXPIRED = 'C';
const char ExecType_RESTATED = 'D';
const char ExecType_PENDING_REPLACE = 'E';
const char ExecType_TRADE = 'F';
const char ExecType_TRADE_CORRECT = 'G';
const char ExecType_TRADE_CANCEL = 'H';
const char ExecType_ORDER_STATUS = 'I';
const char ExecType_TRADE_IN_A_CLEARING_HOLD = 'J';
const char ExecType_TRADE_HAS_BEEN_RELEASED_TO_CLEARING = 'K';
const char ExecType_TRIGGERED_OR_ACTIVATED_BY_SYSTEM = 'L';
const char ExecType_LOCKED = 'M';
const char ExecType_RELEASED = 'N';
const char SettlCurrFxRateCalc_DIVIDE = 'D';
const char SettlCurrFxRateCalc_MULTIPLY = 'M';
const char SettlInstMode_DEFAULT = '0';
const char SettlInstMode_STANDING_INSTRUCTIONS_PROVIDED = '1';
const char SettlInstMode_SPECIFIC_ALLOCATION_ACCOUNT_OVERRIDING = '2';
const char SettlInstMode_SPECIFIC_ALLOCATION_ACCOUNT_STANDING = '3';
const char SettlInstMode_SPECIFIC_ORDER_FOR_A_SINGLE_ACCOUNT = '4';
const char SettlInstMode_REQUEST_REJECT = '5';
const char SettlInstTransType_CANCEL = 'C';
const char SettlInstTransType_NEW = 'N';
const char SettlInstTransType_REPLACE = 'R';
const char SettlInstTransType_RESTATE = 'T';
const char SettlInstSource_BROKER_CREDIT = '1';
const char SettlInstSource_INSTITUTION = '2';
const char SettlInstSource_INVESTOR = '3';
const char SettlLocation_CEDEL[] = "CED";
const char SettlLocation_DEPOSITORY_TRUST_COMPANY[] = "DTC";
const char SettlLocation_EURO_CLEAR[] = "EUR";
const char SettlLocation_FEDERAL_BOOK_ENTRY[] = "FED";
const char SettlLocation_LOCAL_MARKET_SETTLE_LOCATION[] = "ISO Country Code";
const char SettlLocation_PHYSICAL[] = "PNY";
const char SettlLocation_PARTICIPANT_TRUST_COMPANY[] = "PTC";
const char SecurityType_BANKERS_ACCEPTANCE[] = "BA";
const char SecurityType_CERTIFICATE_OF_DEPOSIT[] = "CD";
const char SecurityType_COLLATERALIZED_MORTGAGE_OBLIGATION[] = "CMO";
const char SecurityType_CORPORATE_BOND[] = "CORP";
const char SecurityType_COMMERCIAL_PAPER[] = "CP";
const char SecurityType_CORPORATE_PRIVATE_PLACEMENT[] = "CPP";
const char SecurityType_COMMON_STOCK[] = "CS";
const char SecurityType_FEDERAL_HOUSING_AUTHORITY[] = "FHA";
const char SecurityType_FEDERAL_HOME_LOAN[] = "FHL";
const char SecurityType_FEDERAL_NATIONAL_MORTGAGE_ASSOCIATION[] = "FN";
const char SecurityType_FOREIGN_EXCHANGE_CONTRACT[] = "FOR";
const char SecurityType_FUTURE[] = "FUT";
const char SecurityType_GOVERNMENT_NATIONAL_MORTGAGE_ASSOCIATION[] = "GN";
const char SecurityType_TREASURIES_AGENCY_DEBENTURE[] = "GOVT";
const char SecurityType_MUTUAL_FUND[] = "MF";
const char SecurityType_MORTGAGE_INTEREST_ONLY[] = "MIO";
const char SecurityType_MORTGAGE_PRINCIPAL_ONLY[] = "MPO";
const char SecurityType_MORTGAGE_PRIVATE_PLACEMENT[] = "MPP";
const char SecurityType_MISCELLANEOUS_PASS_THROUGH[] = "MPT";
const char SecurityType_MUNICIPAL_BOND[] = "MUNI";
const char SecurityType_NO_SECURITY_TYPE[] = "NONE";
const char SecurityType_OPTION[] = "OPT";
const char SecurityType_PREFERRED_STOCK[] = "PS";
const char SecurityType_REPURCHASE_AGREEMENT[] = "RP";
const char SecurityType_REVERSE_REPURCHASE_AGREEMENT[] = "RVRP";
const char SecurityType_STUDENT_LOAN_MARKETING_ASSOCIATION[] = "SL";
const char SecurityType_TIME_DEPOSIT[] = "TD";
const char SecurityType_US_TREASURY_BILL_OLD[] = "USTB";
const char SecurityType_WARRANT[] = "WAR";
const char SecurityType_CATS_TIGERS_AND_LIONS[] = "ZOO";
const char SecurityType_WILDCARD[] = "?";
const char SecurityType_CONVERTIBLE_BOND[] = "CB";
const char SecurityType_IOETTE_MORTGAGE[] = "IET";
const char SecurityType_VARIABLE_RATE_DEMAND_NOTE[] = "VRDN";
const char SecurityType_PLAZOS_FIJOS[] = "PZFJ";
const char SecurityType_PROMISSORY_NOTE[] = "PN";
const char SecurityType_OVERNIGHT[] = "ONITE";
const char SecurityType_MEDIUM_TERM_NOTES[] = "MTN";
const char SecurityType_TAX_EXEMPT_COMMERCIAL_PAPER[] = "TECP";
const char SecurityType_AMENDED[] = "AMENDED";
const char SecurityType_BRIDGE_LOAN[] = "BRIDGE";
const char SecurityType_LETTER_OF_CREDIT[] = "LOFC";
const char SecurityType_SWING_LINE_FACILITY[] = "SWING";
const char SecurityType_DEBTOR_IN_POSSESSION[] = "DINP";
const char SecurityType_DEFAULTED[] = "DEFLTED";
const char SecurityType_WITHDRAWN[] = "WITHDRN";
const char SecurityType_LIQUIDITY_NOTE[] = "LQN";
const char SecurityType_MATURED[] = "MATURED";
const char SecurityType_DEPOSIT_NOTES[] = "DN";
const char SecurityType_RETIRED[] = "RETIRED";
const char SecurityType_BANK_NOTES[] = "BN";
const char SecurityType_BILL_OF_EXCHANGES[] = "BOX";
const char SecurityType_CALL_LOANS[] = "CL";
const char SecurityType_REPLACED[] = "REPLACD";
const char SecurityType_MANDATORY_TENDER[] = "MT";
const char SecurityType_REVOLVER[] = "RVLVTRM";
const char SecurityType_SHORT_TERM_LOAN_NOTE[] = "STN";
const char SecurityType_TO_BE_ANNOUNCED[] = "TBA";
const char SecurityType_OTHER_ANTICIPATION_NOTES[] = "AN";
const char SecurityType_CERTIFICATE_OF_PARTICIPATION[] = "COFP";
const char SecurityType_MORTGAGE_BACKED_SECURITIES[] = "MBS";
const char SecurityType_REVENUE_BONDS[] = "REV";
const char SecurityType_SPECIAL_ASSESSMENT[] = "SPCLA";
const char SecurityType_SPECIAL_OBLIGATION[] = "SPCLO";
const char SecurityType_SPECIAL_TAX[] = "SPCLT";
const char SecurityType_TAX_ANTICIPATION_NOTE[] = "TAN";
const char SecurityType_TAX_ALLOCATION[] = "TAXA";
const char SecurityType_CERTIFICATE_OF_OBLIGATION[] = "COFO";
const char SecurityType_GENERAL_OBLIGATION_BONDS[] = "GO";
const char SecurityType_MULTILEG_INSTRUMENT[] = "MLEG";
const char SecurityType_TAX_REVENUE_ANTICIPATION_NOTE[] = "TRAN";
const char SecurityType_EXTENDED_COMM_NOTE[] = "XCN";
const char SecurityType_AGENCY_POOLS[] = "POOL";
const char SecurityType_ASSET_BACKED_SECURITIES[] = "ABS";
const char SecurityType_CORP[] = "CMBS";
const char SecurityType_REVENUE_ANTICIPATION_NOTE[] = "RAN";
const char SecurityType_REVOLVER_LOAN[] = "RVLV";
const char SecurityType_FEDERAL_AGENCY_COUPON[] = "FAC";
const char SecurityType_FEDERAL_AGENCY_DISCOUNT_NOTE[] = "FADN";
const char SecurityType_PRIVATE_EXPORT_FUNDING[] = "PEF";
const char SecurityType_DUAL_CURRENCY[] = "DUAL";
const char SecurityType_INDEXED_LINKED[] = "XLINKD";
const char SecurityType_YANKEE_CORPORATE_BOND[] = "YANK";
const char SecurityType_BRADY_BOND[] = "BRADY";
const char SecurityType_US_TREASURY_BOND[] = "TBOND";
const char SecurityType_INTEREST_STRIP_FROM_ANY_BOND_OR_NOTE[] = "TINT";
const char SecurityType_TREASURY_INFLATION_PROTECTED_SECURITIES[] = "TIPS";
const char SecurityType_PRINCIPAL_STRIP_OF_A_CALLABLE_BOND_OR_NOTE[] = "TCAL";
const char SecurityType_PRINCIPAL_STRIP_FROM_A_NON_CALLABLE_BOND_OR_NOTE[] = "TPRN";
const char SecurityType_US_TREASURY_NOTE_OLD[] = "UST";
const char SecurityType_TERM_LOAN[] = "TERM";
const char SecurityType_STRUCTURED_NOTES[] = "STRUCT";
const char SecurityType_EURO_SUPRANATIONAL_COUPONS[] = "EUSUPRA";
const char SecurityType_USD_SUPRANATIONAL_COUPONS[] = "SUPRA";
const char SecurityType_EURO_CORPORATE_BOND[] = "EUCORP";
const char SecurityType_EURO_SOVEREIGNS[] = "EUSOV";
const char SecurityType_US_TREASURY_NOTE[] = "TNOTE";
const char SecurityType_US_TREASURY_BILL[] = "TBILL";
const char SecurityType_REPURCHASE[] = "REPO";
const char SecurityType_FORWARD[] = "FORWARD";
const char SecurityType_BUY_SELLBACK[] = "BUYSELL";
const char SecurityType_SECURITIES_LOAN[] = "SECLOAN";
const char SecurityType_SECURITIES_PLEDGE[] = "SECPLEDGE";
const char SecurityType_EURO_CERTIFICATE_OF_DEPOSIT[] = "EUCD";
const char SecurityType_EURO_COMMERCIAL_PAPER[] = "EUCP";
const char SecurityType_YANKEE_CERTIFICATE_OF_DEPOSIT[] = "YCD";
const char SecurityType_PFANDBRIEFE[] = "PFAND";
const char SecurityType_OPTIONS_ON_FUTURES[] = "OOF";
const char SecurityType_OPTIONS_ON_PHYSICAL[] = "OOP";
const char SecurityType_WILDCARD_ENTRY[] = "WLD";
const char SecurityType_CASH[] = "CASH";
const char SecurityType_EURO_CORPORATE_FLOATING_RATE_NOTES[] = "EUFRN";
const char SecurityType_US_CORPORATE_FLOATING_RATE_NOTES[] = "FRN";
const char SecurityType_CREDIT_DEFAULT_SWAP[] = "CDS";
const char SecurityType_INTEREST_RATE_SWAP[] = "IRS";
const char SecurityType_OPTIONS_ON_COMBO[] = "OOC";
const char SecurityType_CANADIAN_TREASURY_NOTES[] = "CAN";
const char SecurityType_CANADIAN_TREASURY_BILLS[] = "CTB";
const char SecurityType_CANADIAN_PROVINCIAL_BONDS[] = "PROV";
const char SecurityType_TREASURY_BILL[] = "TB";
const char SecurityType_BANK_DEPOSITORY_NOTE[] = "BDN";
const char SecurityType_CANADIAN_MONEY_MARKETS[] = "CAMM";
const char SecurityType_SECURED_LIQUIDITY_NOTE[] = "SLQN";
const char SecurityType_TERM_LIQUIDITY_NOTE[] = "TLQN";
const char SecurityType_CANADIAN_MORTGAGE_BONDS[] = "CMB";
const char SecurityType_TAXABLE_MUNICIPAL_CP[] = "TMCP";
const char SecurityType_OFFSHORE_ISSUED_CHINESE_YUAN_CORPORATE_BOND[] = "DIMSUMCORP";
const char SecurityType_PREFERRED_CORPORATE_BOND[] = "PRCORP";
const char SecurityType_NON_DELIVERABLE_FORWARD[] = "FXNDF";
const char SecurityType_FX_SPOT[] = "FXSPOT";
const char SecurityType_FX_FORWARD[] = "FXFWD";
const char SecurityType_FX_SWAP[] = "FXSWAP";
const char SecurityType_NON_DELIVERABLE_SWAP[] = "FXNDS";
const char SecurityType_FX_BANK_NOTE[] = "FXBN";
const char SecurityType_FOREIGN_CURRENCY_DISCOUNT_NOTE[] = "FXDN";
const char SecurityType_CAP[] = "CAP";
const char SecurityType_COLLAR[] = "CLLR";
const char SecurityType_COMMODITY_SWAP[] = "CMDTYSWAP";
const char SecurityType_EXOTIC[] = "EXOTIC";
const char SecurityType_FLOOR[] = "FLR";
const char SecurityType_FRA[] = "FRA";
const char SecurityType_DERIVATIVE_FORWARD[] = "FWD";
const char SecurityType_TOTAL_RETURN_SWAP[] = "TRS";
const char SecurityType_LOAN_LEASE[] = "LOANLEASE";
const char SecurityType_SPOT_FORWARD[] = "SPOTFWD";
const char SecurityType_SWAP_OPTION[] = "SWAPTION";
const char SecurityType_TRANSMISSION[] = "XMISSION";
const char SecurityType_INDEX[] = "INDEX";
const char SecurityType_BOND_BASKET[] = "BDBSKT";
const char SecurityType_CONTRACT_FOR_DIFFERENCE[] = "CFD";
const char SecurityType_CORRELATION_SWAP[] = "CRLTNSWAP";
const char SecurityType_DIVIEND_SWAP[] = "DVDNDSWAP";
const char SecurityType_EQUITY_BASKET[] = "EQBSKT";
const char SecurityType_EQUITY_FORWARD[] = "EQFWD";
const char SecurityType_RETURN_SWAP[] = "RTRNSWAP";
const char SecurityType_VARIANCE_SWAP[] = "VARSWAP";
const char SecurityType_PORTFOLIO_SWAPS[] = "PRTFLIOSWAP";
const char SecurityType_FUTURES_ON_A_SWAP[] = "FUTSWAP";
const char SecurityType_FORWARDS_ON_A_SWAP[] = "FWDSWAP";
const char SecurityType_FORWARD_FREIGHT_AGREEMENT[] = "FWDFRTAGMT";
const char SecurityType_SPREAD_BETTING[] = "SPREADBET";
const char SecurityType_EXCHANGE_TRADED_COMMODITY[] = "ETC";
const char SecurityType_DEPOSITORY_RECEIPTS[] = "DR";
const char SecurityType_DELIVERY_VERSUS_PLEDGE[] = "DVPLDG";
const char SecurityType_COLLATERAL_BASKET[] = "COLLBSKT";
const char SecurityType_STRUCTURED_FINANCE_PRODUCT[] = "SFP";
const char SecurityType_MARGIN_LOAN[] = "MRGNLOAN";
const char SecurityType_OFFSHORE_ISSUED_CHINESE_YUAN_SOVEREIGN_BOND[] = "DIMSUMSOV";
const char SecurityType_SOVEREIGN_BOND[] = "SOV";
const char SecurityType_US_TREASURY_FLOATING_RATE_NOTE[] = "TFRN";
const char SecurityType_BANK_ACCEPTED_BILL[] = "BAB";
const char SecurityType_SHORT_TERM_BANK_NOTE[] = "BNST";
const char SecurityType_CALLABLE_COMMERCIAL_PAPER[] = "CLCP";
const char SecurityType_COMMERCIAL_NOTE[] = "CN";
const char SecurityType_INTEREST_BEARING_COMMERCIAL_PAPER[] = "CPIB";
const char SecurityType_EURO_MEDIUM_TERM_NOTE[] = "EUMTN";
const char SecurityType_EURO_NEGOTIABLE_COMMERCIAL_PAPER[] = "EUNCP";
const char SecurityType_EURO_STRUCTURED_LIQUIDITY_NOTE[] = "EUSTLQN";
const char SecurityType_EURO_TIME_DEPOSIT[] = "EUTD";
const char SecurityType_JUMBO_CERTIFICATE_OF_DEPOSIT[] = "JCD";
const char SecurityType_MONEY_MARKET_FUND[] = "MMF";
const char SecurityType_MASTER_NOTE[] = "MN";
const char SecurityType_NEGOTIABLE_CERTIFICATE_OF_DEPOSIT[] = "NCD";
const char SecurityType_NEGOTIABLE_COMMERCIAL_PAPER[] = "NCP";
const char SecurityType_RETAIL_CERTIFICATE_OF_DEPOSIT[] = "RCD";
const char SecurityType_TERM_DEPOSIT_RECEIPT[] = "TDR";
const char SecurityType_PFANDBRIEF[] = "PFAND";
const char SecurityType_MUNICIPAL_INTEREST_BEARING_COMMERCIAL_PAPER[] = "MCPIB";
const char SecurityType_TAXABLE_MUNICIPAL_BOND[] = "TMB";
const char SecurityType_VARIABLE_RATE_DEMAND_OBLIGATION[] = "VRDO";
const char SecurityType_OTHER[] = "Other";
const char SecurityType_EXCHANGE_TRADED_NOTE[] = "ETN";
const char SecurityType_SECURITIZED_DERIVATIVE[] = "SECDERIV";
const char SecurityType_EXCHANGE_TRADED_FUND[] = "ETF";
const char SecurityType_DIGITAL_ASSET[] = "DIGITAL";
const int StandInstDbType_OTHER = 0;
const int StandInstDbType_DTCSID = 1;
const int StandInstDbType_THOMSON_ALERT = 2;
const int StandInstDbType_A_GLOBAL_CUSTODIAN = 3;
const int StandInstDbType_ACCOUNT_NET = 4;
const int SettlDeliveryType_FREE = 1;
const int SettlDeliveryType_VERSUS = 0;
const int SettlDeliveryType_TRI_PARTY = 2;
const int SettlDeliveryType_HOLD_IN_CUSTODY = 3;
const int AllocLinkType_FX_NETTING = 0;
const int AllocLinkType_FX_SWAP = 1;
const int PutOrCall_PUT = 0;
const int PutOrCall_CALL = 1;
const int PutOrCall_OTHER = 2;
const int PutOrCall_CHOOSER = 3;
const int CoveredOrUncovered_COVERED = 0;
const int CoveredOrUncovered_UNCOVERED = 1;
const int CustomerOrFirm_CUSTOMER = 0;
const int CustomerOrFirm_FIRM = 1;
const char NotifyBrokerOfCredit_NO = 'N';
const char NotifyBrokerOfCredit_YES = 'Y';
const int AllocHandlInst_MATCH = 1;
const int AllocHandlInst_FORWARD = 2;
const int AllocHandlInst_FORWARD_AND_MATCH = 3;
const int AllocHandlInst_AUTO_CLAIM_GIVE_UP = 4;
const int RoutingType_TARGET_FIRM = 1;
const int RoutingType_TARGET_LIST = 2;
const int RoutingType_BLOCK_FIRM = 3;
const int RoutingType_BLOCK_LIST = 4;
const int RoutingType_TARGET_PERSON = 5;
const int RoutingType_BLOCK_PERSON = 6;
const char Benchmark_CURVE = '1';
const char Benchmark_FIVE_YR = '2';
const char Benchmark_OLD5 = '3';
const char Benchmark_TEN_YR = '4';
const char Benchmark_OLD10 = '5';
const char Benchmark_THIRTY_YR = '6';
const char Benchmark_OLD30 = '7';
const char Benchmark_THREE_MOLIBOR = '8';
const char Benchmark_SIX_MOLIBOR = '9';
const char SubscriptionRequestType_SNAPSHOT = '0';
const char SubscriptionRequestType_SNAPSHOT_AND_UPDATES = '1';
const char SubscriptionRequestType_DISABLE_PREVIOUS_SNAPSHOT = '2';
const int MDUpdateType_FULL_REFRESH = 0;
const int MDUpdateType_INCREMENTAL_REFRESH = 1;
const char AggregatedBook_NO = 'N';
const char AggregatedBook_YES = 'Y';
const char MDEntryType_BID = '0';
const char MDEntryType_OFFER = '1';
const char MDEntryType_TRADE = '2';
const char MDEntryType_INDEX_VALUE = '3';
const char MDEntryType_OPENING_PRICE = '4';
const char MDEntryType_CLOSING_PRICE = '5';
const char MDEntryType_SETTLEMENT_PRICE = '6';
const char MDEntryType_TRADING_SESSION_HIGH_PRICE = '7';
const char MDEntryType_TRADING_SESSION_LOW_PRICE = '8';
const char MDEntryType_TRADING_SESSION_VWAP_PRICE = '9';
const char MDEntryType_IMBALANCE = 'A';
const char MDEntryType_TRADE_VOLUME = 'B';
const char MDEntryType_OPEN_INTEREST = 'C';
const char MDEntryType_COMPOSITE_UNDERLYING_PRICE = 'D';
const char MDEntryType_SIMULATED_SELL_PRICE = 'E';
const char MDEntryType_SIMULATED_BUY_PRICE = 'F';
const char MDEntryType_MARGIN_RATE = 'G';
const char MDEntryType_MID_PRICE = 'H';
const char MDEntryType_EMPTY_BOOK = 'J';
const char MDEntryType_SETTLE_HIGH_PRICE = 'K';
const char MDEntryType_SETTLE_LOW_PRICE = 'L';
const char MDEntryType_PRIOR_SETTLE_PRICE = 'M';
const char MDEntryType_SESSION_HIGH_BID = 'N';
const char MDEntryType_SESSION_LOW_OFFER = 'O';
const char MDEntryType_EARLY_PRICES = 'P';
const char MDEntryType_AUCTION_CLEARING_PRICE = 'Q';
const char MDEntryType_SWAP_VALUE_FACTOR = 'S';
const char MDEntryType_DAILY_VALUE_ADJUSTMENT_FOR_LONG_POSITIONS = 'R';
const char MDEntryType_CUMULATIVE_VALUE_ADJUSTMENT_FOR_LONG_POSITIONS = 'T';
const char MDEntryType_DAILY_VALUE_ADJUSTMENT_FOR_SHORT_POSITIONS = 'U';
const char MDEntryType_CUMULATIVE_VALUE_ADJUSTMENT_FOR_SHORT_POSITIONS = 'V';
const char MDEntryType_VWAP = '9';
const char MDEntryType_FIXING_PRICE = 'W';
const char MDEntryType_CASH_RATE = 'X';
const char MDEntryType_RECOVERY_RATE = 'Y';
const char MDEntryType_RECOVERY_RATE_FOR_LONG = 'Z';
const char MDEntryType_RECOVERY_RATE_FOR_SHORT = 'a';
const char MDEntryType_MARKET_BID = 'b';
const char MDEntryType_MARKET_OFFER = 'c';
const char MDEntryType_SHORT_SALE_MIN_PRICE = 'd';
const char MDEntryType_PREVIOUS_CLOSING_PRICE = 'e';
const char MDEntryType_THRESHOLD_LIMIT_PRICE_BANDING = 'g';
const char MDEntryType_DAILY_FINANCING_VALUE = 'h';
const char MDEntryType_ACCRUED_FINANCING_VALUE = 'i';
const char MDEntryType_TWAP = 't';
const char TickDirection_PLUS_TICK = '0';
const char TickDirection_ZERO_PLUS_TICK = '1';
const char TickDirection_MINUS_TICK = '2';
const char TickDirection_ZERO_MINUS_TICK = '3';
const char QuoteCondition_OPEN[] = "A";
const char QuoteCondition_CLOSED[] = "B";
const char QuoteCondition_EXCHANGE_BEST[] = "C";
const char QuoteCondition_CONSOLIDATED_BEST[] = "D";
const char QuoteCondition_LOCKED[] = "E";
const char QuoteCondition_CROSSED[] = "F";
const char QuoteCondition_DEPTH[] = "G";
const char QuoteCondition_FAST_TRADING[] = "H";
const char QuoteCondition_NON_FIRM[] = "I";
const char QuoteCondition_MANUAL[] = "L";
const char QuoteCondition_OUTRIGHT_PRICE[] = "J";
const char QuoteCondition_IMPLIED_PRICE[] = "K";
const char QuoteCondition_DEPTH_ON_OFFER[] = "M";
const char QuoteCondition_DEPTH_ON_BID[] = "N";
const char QuoteCondition_CLOSING[] = "O";
const char QuoteCondition_NEWS_DISSEMINATION[] = "P";
const char QuoteCondition_TRADING_RANGE[] = "Q";
const char QuoteCondition_ORDER_INFLUX[] = "R";
const char QuoteCondition_DUE_TO_RELATED[] = "S";
const char QuoteCondition_NEWS_PENDING[] = "T";
const char QuoteCondition_ADDITIONAL_INFO[] = "U";
const char QuoteCondition_ADDITIONAL_INFO_DUE_TO_RELATED[] = "V";
const char QuoteCondition_RESUME[] = "W";
const char QuoteCondition_VIEW_OF_COMMON[] = "X";
const char QuoteCondition_VOLUME_ALERT[] = "Y";
const char QuoteCondition_ORDER_IMBALANCE[] = "Z";
const char QuoteCondition_EQUIPMENT_CHANGEOVER[] = "a";
const char QuoteCondition_NO_OPEN[] = "b";
const char QuoteCondition_REGULAR_ETH[] = "c";
const char QuoteCondition_AUTOMATIC_EXECUTION[] = "d";
const char QuoteCondition_AUTOMATIC_EXECUTION_ETH[] = "e";
const char QuoteCondition_FAST_MARKET_ETH[] = "f";
const char QuoteCondition_INACTIVE_ETH[] = "g";
const char QuoteCondition_ROTATION[] = "h";
const char QuoteCondition_ROTATION_ETH[] = "i";
const char QuoteCondition_HALT[] = "j";
const char QuoteCondition_HALT_ETH[] = "k";
const char QuoteCondition_DUE_TO_NEWS_DISSEMINATION[] = "l";
const char QuoteCondition_DUE_TO_NEWS_PENDING[] = "m";
const char QuoteCondition_TRADING_RESUME[] = "n";
const char QuoteCondition_OUT_OF_SEQUENCE[] = "o";
const char QuoteCondition_BID_SPECIALIST[] = "p";
const char QuoteCondition_OFFER_SPECIALIST[] = "q";
const char QuoteCondition_BID_OFFER_SPECIALIST[] = "r";
const char QuoteCondition_END_OF_DAY_SAM[] = "s";
const char QuoteCondition_FORBIDDEN_SAM[] = "t";
const char QuoteCondition_FROZEN_SAM[] = "u";
const char QuoteCondition_PRE_OPENING_SAM[] = "v";
const char QuoteCondition_OPENING_SAM[] = "w";
const char QuoteCondition_OPEN_SAM[] = "x";
const char QuoteCondition_SURVEILLANCE_SAM[] = "y";
const char QuoteCondition_SUSPENDED_SAM[] = "z";
const char QuoteCondition_RESERVED_SAM[] = "0";
const char QuoteCondition_NO_ACTIVE_SAM[] = "1";
const char QuoteCondition_RESTRICTED[] = "2";
const char QuoteCondition_REST_OF_BOOK_VWAP[] = "3";
const char QuoteCondition_BETTER_PRICES_IN_CONDITIONAL_ORDERS[] = "4";
const char QuoteCondition_MEDIAN_PRICE[] = "5";
const char QuoteCondition_FULL_CURVE[] = "6";
const char QuoteCondition_FLAT_CURVE[] = "7";
const char TradeCondition_CASH[] = "A";
const char TradeCondition_AVERAGE_PRICE_TRADE[] = "B";
const char TradeCondition_CASH_TRADE[] = "C";
const char TradeCondition_NEXT_DAY[] = "D";
const char TradeCondition_OPENING[] = "E";
const char TradeCondition_INTRADAY_TRADE_DETAIL[] = "F";
const char TradeCondition_RULE127_TRADE[] = "G";
const char TradeCondition_RULE155_TRADE[] = "H";
const char TradeCondition_SOLD_LAST[] = "I";
const char TradeCondition_NEXT_DAY_TRADE[] = "J";
const char TradeCondition_OPENED[] = "K";
const char TradeCondition_SELLER[] = "L";
const char TradeCondition_SOLD[] = "M";
const char TradeCondition_STOPPED_STOCK[] = "N";
const char TradeCondition_IMBALANCE_MORE_BUYERS[] = "P";
const char TradeCondition_IMBALANCE_MORE_SELLERS[] = "Q";
const char TradeCondition_OPENING_PRICE[] = "R";
const char TradeCondition_BARGAIN_CONDITION[] = "S";
const char TradeCondition_CONVERTED_PRICE_INDICATOR[] = "T";
const char TradeCondition_EXCHANGE_LAST[] = "U";
const char TradeCondition_FINAL_PRICE_OF_SESSION[] = "V";
const char TradeCondition_EX_PIT[] = "W";
const char TradeCondition_CROSSED[] = "X";
const char TradeCondition_TRADES_RESULTING_FROM_MANUAL[] = "Y";
const char TradeCondition_TRADES_RESULTING_FROM_INTERMARKET_SWEEP[] = "Z";
const char TradeCondition_VOLUME_ONLY[] = "a";
const char TradeCondition_DIRECT_PLUS[] = "b";
const char TradeCondition_ACQUISITION[] = "c";
const char TradeCondition_BUNCHED[] = "d";
const char TradeCondition_DISTRIBUTION[] = "e";
const char TradeCondition_BUNCHED_SALE[] = "f";
const char TradeCondition_SPLIT_TRADE[] = "g";
const char TradeCondition_CANCEL_STOPPED[] = "h";
const char TradeCondition_CANCEL_ETH[] = "i";
const char TradeCondition_CANCEL_STOPPED_ETH[] = "j";
const char TradeCondition_OUT_OF_SEQUENCE_ETH[] = "k";
const char TradeCondition_CANCEL_LAST_ETH[] = "l";
const char TradeCondition_SOLD_LAST_SALE_ETH[] = "m";
const char TradeCondition_CANCEL_LAST[] = "n";
const char TradeCondition_SOLD_LAST_SALE[] = "o";
const char TradeCondition_CANCEL_OPEN[] = "p";
const char TradeCondition_CANCEL_OPEN_ETH[] = "q";
const char TradeCondition_OPENED_SALE_ETH[] = "r";
const char TradeCondition_CANCEL_ONLY[] = "s";
const char TradeCondition_CANCEL_ONLY_ETH[] = "t";
const char TradeCondition_LATE_OPEN_ETH[] = "u";
const char TradeCondition_AUTO_EXECUTION_ETH[] = "v";
const char TradeCondition_REOPEN[] = "w";
const char TradeCondition_REOPEN_ETH[] = "x";
const char TradeCondition_ADJUSTED[] = "y";
const char TradeCondition_ADJUSTED_ETH[] = "z";
const char TradeCondition_SPREAD[] = "AA";
const char TradeCondition_SPREAD_ETH[] = "AB";
const char TradeCondition_STRADDLE[] = "AC";
const char TradeCondition_STRADDLE_ETH[] = "AD";
const char TradeCondition_STOPPED[] = "AE";
const char TradeCondition_STOPPED_ETH[] = "AF";
const char TradeCondition_REGULAR_ETH[] = "AG";
const char TradeCondition_COMBO[] = "AH";
const char TradeCondition_COMBO_ETH[] = "AI";
const char TradeCondition_OFFICIAL_CLOSING_PRICE[] = "AJ";
const char TradeCondition_PRIOR_REFERENCE_PRICE[] = "AK";
const char TradeCondition_CANCEL[] = "0";
const char TradeCondition_STOPPED_SOLD_LAST[] = "AL";
const char TradeCondition_STOPPED_OUT_OF_SEQUENCE[] = "AM";
const char TradeCondition_OFFICAL_CLOSING_PRICE[] = "AN";
const char TradeCondition_CROSSED_OLD[] = "AO";
const char TradeCondition_FAST_MARKET[] = "AP";
const char TradeCondition_AUTOMATIC_EXECUTION[] = "AQ";
const char TradeCondition_FORM_T[] = "AR";
const char TradeCondition_BASKET_INDEX[] = "AS";
const char TradeCondition_BURST_BASKET[] = "AT";
const char TradeCondition_OUTSIDE_SPREAD[] = "AV";
const char TradeCondition_IMPLIED_TRADE[] = "1";
const char TradeCondition_MARKETPLACE_ENTERED_TRADE[] = "2";
const char TradeCondition_MULT_ASSET_CLASS_MULTILEG_TRADE[] = "3";
const char TradeCondition_MULTILEG_TO_MULTILEG_TRADE[] = "4";
const char TradeCondition_OFFICIAL_CLOSING_PRICE_DUP[] = "AN";
const char TradeCondition_TRADE_THROUGH_EXEMPT[] = "AU";
const char TradeCondition_QUOTE_SPREAD[] = "AV";
const char TradeCondition_LAST_AUCTION_PRICE[] = "AW";
const char TradeCondition_HIGH_PRICE[] = "AX";
const char TradeCondition_LOW_PRICE[] = "AY";
const char TradeCondition_SYSTEMATIC_INTERNALISER[] = "AZ";
const char TradeCondition_AWAY_MARKET[] = "BA";
const char TradeCondition_MIDPOINT_PRICE[] = "BB";
const char TradeCondition_TRADED_BEFORE_ISSUE_DATE[] = "BC";
const char TradeCondition_PREVIOUS_CLOSING_PRICE[] = "BD";
const char TradeCondition_NATIONAL_BEST_BID_OFFER[] = "BE";
const char TradeCondition_MULTI_ASSET_CLASS_MULTILEG_TRADE[] = "3";
const char TradeCondition_SHORT_SALE_MIN_PRICE[] = "5";
const char TradeCondition_BENCHMARK[] = "6";
const char MDUpdateAction_NEW = '0';
const char MDUpdateAction_CHANGE = '1';
const char MDUpdateAction_DELETE = '2';
const char MDUpdateAction_DELETE_THRU = '3';
const char MDUpdateAction_DELETE_FROM = '4';
const char MDUpdateAction_OVERLAY = '5';
const char MDReqRejReason_UNKNOWN_SYMBOL = '0';
const char MDReqRejReason_DUPLICATE_MD_REQ_ID = '1';
const char MDReqRejReason_INSUFFICIENT_BANDWIDTH = '2';
const char MDReqRejReason_INSUFFICIENT_PERMISSIONS = '3';
const char MDReqRejReason_UNSUPPORTED_SUBSCRIPTION_REQUEST_TYPE = '4';
const char MDReqRejReason_UNSUPPORTED_MARKET_DEPTH = '5';
const char MDReqRejReason_UNSUPPORTED_MD_UPDATE_TYPE = '6';
const char MDReqRejReason_UNSUPPORTED_AGGREGATED_BOOK = '7';
const char MDReqRejReason_UNSUPPORTED_MD_ENTRY_TYPE = '8';
const char MDReqRejReason_UNSUPPORTED_MD_IMPLICIT_DELETE = 'C';
const char MDReqRejReason_UNSUPPORTED_OPEN_CLOSE_SETTLE_FLAG = 'B';
const char MDReqRejReason_UNSUPPORTED_SCOPE = 'A';
const char MDReqRejReason_UNSUPPORTED_TRADING_SESSION_ID = '9';
const char MDReqRejReason_INSUFFICIENT_CREDIT = 'D';
const char DeleteReason_CANCELLATION = '0';
const char DeleteReason_ERROR = '1';
const char OpenCloseSettleFlag_DAILY_OPEN = '0';
const char OpenCloseSettleFlag_SESSION_OPEN = '1';
const char OpenCloseSettleFlag_DELIVERY_SETTLEMENT_ENTRY = '2';
const char OpenCloseSettleFlag_EXPECTED_ENTRY = '3';
const char OpenCloseSettleFlag_ENTRY_FROM_PREVIOUS_BUSINESS_DAY = '4';
const char FinancialStatus_BANKRUPT = '1';
const char FinancialStatus_PENDING_DELISTING = '2';
const char FinancialStatus_RESTRICTED = '3';
const char CorporateAction_EX_DIVIDEND = 'A';
const char CorporateAction_EX_DISTRIBUTION = 'B';
const char CorporateAction_EX_RIGHTS = 'C';
const char CorporateAction_NEW = 'D';
const char CorporateAction_EX_INTEREST = 'E';
const char CorporateAction_CASH_DIVIDEND = 'F';
const char CorporateAction_STOCK_DIVIDEND = 'G';
const char CorporateAction_NON_INTEGER_STOCK_SPLIT = 'H';
const char CorporateAction_REVERSE_STOCK_SPLIT = 'I';
const char CorporateAction_STANDARD_INTEGER_STOCK_SPLIT = 'J';
const char CorporateAction_POSITION_CONSOLIDATION = 'K';
const char CorporateAction_LIQUIDATION_REORGANIZATION = 'L';
const char CorporateAction_MERGER_REORGANIZATION = 'M';
const char CorporateAction_RIGHTS_OFFERING = 'N';
const char CorporateAction_SHAREHOLDER_MEETING = 'O';
const char CorporateAction_SPINOFF = 'P';
const char CorporateAction_TENDER_OFFER = 'Q';
const char CorporateAction_WARRANT = 'R';
const char CorporateAction_SPECIAL_ACTION = 'S';
const char CorporateAction_SYMBOL_CONVERSION = 'T';
const char CorporateAction_CUSIP = 'U';
const char CorporateAction_LEAP_ROLLOVER = 'V';
const char CorporateAction_SUCCESSION_EVENT = 'W';
const int QuoteAckStatus_ACCEPTED = 1;
const int QuoteAckStatus_CANCEL_FOR_SYMBOL = 1;
const int QuoteAckStatus_CANCELED_FOR_SECURITY_TYPE = 2;
const int QuoteAckStatus_CANCELED_FOR_UNDERLYING = 3;
const int QuoteAckStatus_CANCELED_ALL = 4;
const int QuoteAckStatus_REJECTED = 2;
const int QuoteAckStatus_RECEIVED_NOT_YET_PROCESSED = 0;
const int QuoteCancelType_CANCEL_FOR_ONE_OR_MORE_SECURITIES = 1;
const int QuoteCancelType_CANCEL_FOR_SECURITY_TYPE = 2;
const int QuoteCancelType_CANCEL_FOR_UNDERLYING_SECURITY = 3;
const int QuoteCancelType_CANCEL_ALL_QUOTES = 4;
const int QuoteCancelType_CANCEL_QUOTE_SPECIFIED_IN_QUOTE_ID = 5;
const int QuoteCancelType_CANCEL_SPECIFIED_SINGLE_QUOTE = 5;
const int QuoteCancelType_CANCEL_BY_TYPE_OF_QUOTE = 6;
const int QuoteCancelType_CANCEL_FOR_SECURITY_ISSUER = 7;
const int QuoteCancelType_CANCEL_FOR_ISSUER_OF_UNDERLYING_SECURITY = 8;
const int QuoteRejectReason_UNKNOWN_SYMBOL = 1;
const int QuoteRejectReason_EXCHANGE = 2;
const int QuoteRejectReason_QUOTE_REQUEST_EXCEEDS_LIMIT = 3;
const int QuoteRejectReason_TOO_LATE_TO_ENTER = 4;
const int QuoteRejectReason_UNKNOWN_QUOTE = 5;
const int QuoteRejectReason_DUPLICATE_QUOTE = 6;
const int QuoteRejectReason_INVALID_BID = 7;
const int QuoteRejectReason_INVALID_PRICE = 8;
const int QuoteRejectReason_NOT_AUTHORIZED_TO_QUOTE_SECURITY = 9;
const int QuoteRejectReason_OTHER = 99;
const int QuoteRejectReason_PRICE_EXCEEDS_CURRENT_PRICE_BAND = 10;
const int QuoteRejectReason_QUOTE_LOCKED = 11;
const int QuoteRejectReason_INVALID_OR_UNKNOWN_SECURITY_ISSUER = 12;
const int QuoteRejectReason_INVALID_OR_UNKNOWN_ISSUER_OF_UNDERLYING_SECURITY = 13;
const int QuoteRejectReason_NOTIONAL_VALUE_EXCEEDS_THRESHOLD = 14;
const int QuoteRejectReason_PRICE_EXCEEDS_CURRENT_PRICE_BAND_DEPR = 15;
const int QuoteRejectReason_REFERENCE_PRICE_NOT_AVAILABLE = 16;
const int QuoteRejectReason_INSUFFICIENT_CREDIT_LIMIT = 17;
const int QuoteRejectReason_EXCEEDED_CLIP_SIZE_LIMIT = 18;
const int QuoteRejectReason_EXCEEDED_MAX_NOTIONAL_ORDER_AMT = 19;
const int QuoteRejectReason_EXCEEDED_DV01_PV01_LIMIT = 20;
const int QuoteRejectReason_EXCEEDED_CS01_LIMIT = 21;
const int QuoteResponseLevel_NO_ACKNOWLEDGEMENT = 0;
const int QuoteResponseLevel_ACKNOWLEDGE_ONLY_NEGATIVE_OR_ERRONEOUS_QUOTES = 1;
const int QuoteResponseLevel_ACKNOWLEDGE_EACH_QUOTE_MESSAGE = 2;
const int QuoteResponseLevel_SUMMARY_ACKNOWLEDGEMENT = 3;
const int QuoteRequestType_MANUAL = 1;
const int QuoteRequestType_AUTOMATIC = 2;
const int QuoteRequestType_CONFIRM_QUOTE = 3;
const int SecurityRequestType_REQUEST_SECURITY_IDENTITY_AND_SPECIFICATIONS = 0;
const int SecurityRequestType_REQUEST_SECURITY_IDENTITY_FOR_SPECIFICATIONS = 1;
const int SecurityRequestType_REQUEST_LIST_SECURITY_TYPES = 2;
const int SecurityRequestType_REQUEST_LIST_SECURITIES = 3;
const int SecurityRequestType_SYMBOL = 4;
const int SecurityRequestType_SECURITY_TYPE_AND_OR_CFI_CODE = 5;
const int SecurityRequestType_PRODUCT = 6;
const int SecurityRequestType_TRADING_SESSION_ID = 7;
const int SecurityRequestType_ALL_SECURITIES = 8;
const int SecurityRequestType_MARKET_ID_OR_MARKET_ID = 9;
const int SecurityResponseType_ACCEPT_AS_IS = 1;
const int SecurityResponseType_ACCEPT_WITH_REVISIONS = 2;
const int SecurityResponseType_LIST_OF_SECURITY_TYPES_RETURNED_PER_REQUEST = 3;
const int SecurityResponseType_LIST_OF_SECURITIES_RETURNED_PER_REQUEST = 4;
const int SecurityResponseType_REJECT_SECURITY_PROPOSAL = 5;
const int SecurityResponseType_CANNOT_MATCH_SELECTION_CRITERIA = 6;
const char UnsolicitedIndicator_NO = 'N';
const char UnsolicitedIndicator_YES = 'Y';
const int SecurityTradingStatus_OPENING_DELAY = 1;
const int SecurityTradingStatus_MARKET_ON_CLOSE_IMBALANCE_SELL = 10;
const int SecurityTradingStatus_NO_MARKET_IMBALANCE = 12;
const int SecurityTradingStatus_NO_MARKET_ON_CLOSE_IMBALANCE = 13;
const int SecurityTradingStatus_ITS_PRE_OPENING = 14;
const int SecurityTradingStatus_NEW_PRICE_INDICATION = 15;
const int SecurityTradingStatus_TRADE_DISSEMINATION_TIME = 16;
const int SecurityTradingStatus_READY_TO_TRADE = 17;
const int SecurityTradingStatus_NOT_AVAILABLE_FOR_TRADING = 18;
const int SecurityTradingStatus_NOT_TRADED_ON_THIS_MARKET = 19;
const int SecurityTradingStatus_TRADING_HALT = 2;
const int SecurityTradingStatus_UNKNOWN_OR_INVALID = 20;
const int SecurityTradingStatus_RESUME = 3;
const int SecurityTradingStatus_NO_OPEN = 4;
const int SecurityTradingStatus_PRICE_INDICATION = 5;
const int SecurityTradingStatus_TRADING_RANGE_INDICATION = 6;
const int SecurityTradingStatus_MARKET_IMBALANCE_BUY = 7;
const int SecurityTradingStatus_MARKET_IMBALANCE_SELL = 8;
const int SecurityTradingStatus_MARKET_ON_CLOSE_IMBALANCE_BUY = 9;
const int SecurityTradingStatus_OPENING_ROTATION = 22;
const int SecurityTradingStatus_PRE_OPEN = 21;
const int SecurityTradingStatus_FAST_MARKET = 23;
const int SecurityTradingStatus_PRE_CROSS = 24;
const int SecurityTradingStatus_CROSS = 25;
const int SecurityTradingStatus_POST_CLOSE = 26;
const int SecurityTradingStatus_NO_CANCEL = 27;
const char HaltReasonChar_NEWS_DISSEMINATION = 'D';
const char HaltReasonChar_ORDER_INFLUX = 'E';
const char HaltReasonChar_ORDER_IMBALANCE = 'I';
const char HaltReasonChar_ADDITIONAL_INFORMATION = 'M';
const char HaltReasonChar_NEWS_PENDING = 'P';
const char HaltReasonChar_EQUIPMENT_CHANGEOVER = 'X';
const char HaltReasonChar_NEW_PENDING = 'P';
const char InViewOfCommon_NO = 'N';
const char InViewOfCommon_YES = 'Y';
const char DueToRelated_NO = 'N';
const char DueToRelated_YES = 'Y';
const int Adjustment_CANCEL = 1;
const int Adjustment_ERROR = 2;
const int Adjustment_CORRECTION = 3;
const char TradingSessionID_DAY[] = "1";
const char TradingSessionID_HALF_DAY[] = "2";
const char TradingSessionID_MORNING[] = "3";
const char TradingSessionID_AFTERNOON[] = "4";
const char TradingSessionID_EVENING[] = "5";
const char TradingSessionID_AFTER_HOURS[] = "6";
const char TradingSessionID_HOLIDAY[] = "7";
const int TradSesMethod_ELECTRONIC = 1;
const int TradSesMethod_OPEN_OUTCRY = 2;
const int TradSesMethod_TWO_PARTY = 3;
const int TradSesMethod_VOICE = 4;
const int TradSesMode_TESTING = 1;
const int TradSesMode_SIMULATED = 2;
const int TradSesMode_PRODUCTION = 3;
const int TradSesStatus_HALTED = 1;
const int TradSesStatus_OPEN = 2;
const int TradSesStatus_CLOSED = 3;
const int TradSesStatus_PRE_OPEN = 4;
const int TradSesStatus_PRE_CLOSE = 5;
const int TradSesStatus_REQUEST_REJECTED = 6;
const int TradSesStatus_UNKNOWN = 0;
const int QuoteEntryRejectReason_UNKNOWN_SYMBOL = 1;
const int QuoteEntryRejectReason_EXCHANGE = 2;
const int QuoteEntryRejectReason_QUOTE_EXCEEDS_LIMIT = 3;
const int QuoteEntryRejectReason_TOO_LATE_TO_ENTER = 4;
const int QuoteEntryRejectReason_UNKNOWN_QUOTE = 5;
const int QuoteEntryRejectReason_DUPLICATE_QUOTE = 6;
const int QuoteEntryRejectReason_INVALID_BID_ASK_SPREAD = 7;
const int QuoteEntryRejectReason_INVALID_PRICE = 8;
const int QuoteEntryRejectReason_NOT_AUTHORIZED_TO_QUOTE_SECURITY = 9;
const char BidRequestTransType_CANCEL = 'C';
const char BidRequestTransType_NEW = 'N';
const char SolicitedFlag_NO = 'N';
const char SolicitedFlag_YES = 'Y';
const int ExecRestatementReason_GT_CORPORATE_ACTION = 0;
const int ExecRestatementReason_GT_RENEWAL = 1;
const int ExecRestatementReason_VERBAL_CHANGE = 2;
const int ExecRestatementReason_REPRICING_OF_ORDER = 3;
const int ExecRestatementReason_BROKER_OPTION = 4;
const int ExecRestatementReason_PARTIAL_DECLINE_OF_ORDER_QTY = 5;
const int ExecRestatementReason_CANCEL_ON_SYSTEM_FAILURE = 7;
const int ExecRestatementReason_MARKET = 8;
const int ExecRestatementReason_CANCEL_ON_TRADING_HALT = 6;
const int ExecRestatementReason_CANCELED = 9;
const int ExecRestatementReason_WAREHOUSE_RECAP = 10;
const int ExecRestatementReason_OTHER = 99;
const int ExecRestatementReason_PEG_REFRESH = 11;
const int ExecRestatementReason_CANCEL_ON_CONNECTION_LOSS = 12;
const int ExecRestatementReason_CANCEL_ON_LOGOUT = 13;
const int ExecRestatementReason_ASSIGN_TIME_PRIORITY = 14;
const int ExecRestatementReason_CANCELLED_FOR_TRADE_PRICE_VIOLATION = 15;
const int ExecRestatementReason_CANCELLED_FOR_CROSS_IMBALANCE = 16;
const int ExecRestatementReason_CXLD_SMP = 17;
const int ExecRestatementReason_CXLD_SMP_AGGRESSIVE = 18;
const int ExecRestatementReason_CXLD_SMP_PASSIVE = 19;
const int ExecRestatementReason_CXLD_SMP_AGGRESSIVE_PASSIVE = 20;
const int BusinessRejectReason_OTHER = 0;
const int BusinessRejectReason_UNKNOWN_ID = 1;
const int BusinessRejectReason_UNKNOWN_SECURITY = 2;
const int BusinessRejectReason_UNSUPPORTED_MESSAGE_TYPE = 3;
const int BusinessRejectReason_APPLICATION_NOT_AVAILABLE = 4;
const int BusinessRejectReason_CONDITIONALLY_REQUIRED_FIELD_MISSING = 5;
const int BusinessRejectReason_DELIVER_TO_FIRM_NOT_AVAILABLE_AT_THIS_TIME = 7;
const int BusinessRejectReason_NOT_AUTHORIZED = 6;
const int BusinessRejectReason_INVALID_PRICE_INCREMENT = 18;
const int BusinessRejectReason_THROTTLE_LIMIT_EXCEEDED = 8;
const int BusinessRejectReason_THROTTLE_LIMIT_EXCEEDED_SESSION_DISCONNECTED = 9;
const int BusinessRejectReason_THROTTLED_MESSAGES_REJECTED_ON_REQUEST = 10;
const char MsgDirection_RECEIVE = 'R';
const char MsgDirection_SEND = 'S';
const char DiscretionInst_RELATED_TO_DISPLAYED_PRICE = '0';
const char DiscretionInst_RELATED_TO_MARKET_PRICE = '1';
const char DiscretionInst_RELATED_TO_PRIMARY_PRICE = '2';
const char DiscretionInst_RELATED_TO_LOCAL_PRIMARY_PRICE = '3';
const char DiscretionInst_RELATED_TO_MIDPOINT_PRICE = '4';
const char DiscretionInst_RELATED_TO_LAST_TRADE_PRICE = '5';
const char DiscretionInst_RELATED_TO_VWAP = '6';
const char DiscretionInst_AVERAGE_PRICE_GUARANTEE = '7';
const int BidType_NON_DISCLOSED = 1;
const int BidType_DISCLOSED = 2;
const int BidType_NO_BIDDING_PROCESS = 3;
const int BidDescriptorType_INDEX = 3;
const int BidDescriptorType_COUNTRY = 2;
const int BidDescriptorType_SECTOR = 1;
const int SideValueInd_SIDE_VALUE1 = 1;
const int SideValueInd_SIDE_VALUE2 = 2;
const int LiquidityIndType_FIVE_DAY_MOVING_AVERAGE = 1;
const int LiquidityIndType_TWENTY_DAY_MOVING_AVERAGE = 2;
const int LiquidityIndType_NORMAL_MARKET_SIZE = 3;
const int LiquidityIndType_OTHER = 4;
const char ExchangeForPhysical_NO = 'N';
const char ExchangeForPhysical_YES = 'Y';
const int ProgRptReqs_BUY_SIDE_REQUESTS = 1;
const int ProgRptReqs_SELL_SIDE_SENDS = 2;
const int ProgRptReqs_REAL_TIME_EXECUTION_REPORTS = 3;
const int IncTaxInd_NET = 1;
const int IncTaxInd_GROSS = 2;
const char TradeType_AGENCY = 'A';
const char TradeType_VWAP_GUARANTEE = 'G';
const char TradeType_GUARANTEED_CLOSE = 'J';
const char TradeType_RISK_TRADE = 'R';
const char BasisPxType_CLOSING_PRICE_AT_MORNING_SESSION = '2';
const char BasisPxType_CLOSING_PRICE = '3';
const char BasisPxType_CURRENT_PRICE = '4';
const char BasisPxType_SQ = '5';
const char BasisPxType_VWAP_THROUGH_A_DAY = '6';
const char BasisPxType_VWAP_THROUGH_A_MORNING_SESSION = '7';
const char BasisPxType_VWAP_THROUGH_AN_AFTERNOON_SESSION = '8';
const char BasisPxType_VWAP_THROUGH_A_DAY_EXCEPT = '9';
const char BasisPxType_VWAP_THROUGH_A_MORNING_SESSION_EXCEPT = 'A';
const char BasisPxType_VWAP_THROUGH_AN_AFTERNOON_SESSION_EXCEPT = 'B';
const char BasisPxType_STRIKE = 'C';
const char BasisPxType_OPEN = 'D';
const char BasisPxType_OTHERS = 'Z';
const int PriceType_PERCENTAGE = 1;
const int PriceType_PER_UNIT = 2;
const int PriceType_FIXED_AMOUNT = 3;
const int PriceType_DISCOUNT = 4;
const int PriceType_SPREAD = 6;
const int PriceType_TED_PRICE = 7;
const int PriceType_TED_YIELD = 8;
const int PriceType_PREMIUM = 5;
const int PriceType_YIELD = 9;
const int PriceType_FIXED_CABINET_TRADE_PRICE = 10;
const int PriceType_VARIABLE_CABINET_TRADE_PRICE = 11;
const int PriceType_PRODUCT_TICKS_IN_HALFS = 13;
const int PriceType_PRODUCT_TICKS_IN_FOURTHS = 14;
const int PriceType_PRODUCT_TICKS_IN_EIGHTS = 15;
const int PriceType_PRODUCT_TICKS_IN_SIXTEENTHS = 16;
const int PriceType_PRODUCT_TICKS_IN_THIRTY_SECONDS = 17;
const int PriceType_PRODUCT_TICKS_IN_SIXTY_FORTHS = 18;
const int PriceType_PRODUCT_TICKS_IN_ONE_TWENTY_EIGHTS = 19;
const int PriceType_PRICE_SPREAD = 12;
const int PriceType_PRODUCT_TICKS_IN_HALVES = 13;
const int PriceType_PRODUCT_TICKS_IN_EIGHTHS = 15;
const int PriceType_PRODUCT_TICKS_IN_SIXTY_FOURTHS = 18;
const int PriceType_PRODUCT_TICKS_IN_ONE_TWENTY_EIGHTHS = 19;
const int PriceType_NORMAL_RATE_REPRESENTATION = 20;
const int PriceType_INVERSE_RATE_REPRESENTATION = 21;
const int PriceType_BASIS_POINTS = 22;
const int PriceType_UPFRONT_POINTS = 23;
const int PriceType_INTEREST_RATE = 24;
const int PriceType_PERCENTAGE_NOTIONAL = 25;
const int GTBookingInst_BOOK_OUT_ALL_TRADES_ON_DAY_OF_EXECUTION = 0;
const int GTBookingInst_ACCUMULATE_UNTIL_FILLED_OR_EXPIRED = 1;
const int GTBookingInst_ACCUMULATE_UNTIL_VERBALLLY_NOTIFIED_OTHERWISE = 2;
const int GTBookingInst_ACCUMULATE_UNTIL_VERBALLY_NOTIFIED_OTHERWISE = 2;
const int ListStatusType_ALERT = 6;
const int ListStatusType_EXEC_STARTED = 4;
const int ListStatusType_TIMED = 3;
const int ListStatusType_RESPONSE = 2;
const int ListStatusType_ACK = 1;
const int ListStatusType_ALL_DONE = 5;
const int NetGrossInd_NET = 1;
const int NetGrossInd_GROSS = 2;
const int ListOrderStatus_CANCELLING = 4;
const int ListOrderStatus_EXECUTING = 3;
const int ListOrderStatus_REJECT = 7;
const int ListOrderStatus_ALL_DONE = 6;
const int ListOrderStatus_ALERT = 5;
const int ListOrderStatus_RECEIVED_FOR_EXECUTION = 2;
const int ListOrderStatus_IN_BIDDING_PROCESS = 1;
const char ListExecInstType_IMMEDIATE = '1';
const char ListExecInstType_WAIT_FOR_INSTRUCTION = '2';
const char ListExecInstType_BUY_DRIVEN_CASH_WITHDRAW = '5';
const char ListExecInstType_BUY_DRIVEN_CASH_TOP_UP = '4';
const char ListExecInstType_SELL_DRIVEN = '3';
const char CxlRejResponseTo_ORDER_CANCEL_REQUEST = '1';
const char CxlRejResponseTo_ORDER_CANCEL = '2';
const char CxlRejResponseTo_ORDER_CANCEL_REPLACE_REQUEST = '2';
const char MultiLegReportingType_SINGLE_SECURITY = '1';
const char MultiLegReportingType_INDIVIDUAL_LEG_OF_A_MULTI_LEG_SECURITY = '2';
const char MultiLegReportingType_MULTI_LEG_SECURITY = '3';
const char SecurityIDSource_SICOVAM[] = "E";
const char SecurityIDSource_SEDOL[] = "2";
const char SecurityIDSource_CUSIP[] = "1";
const char SecurityIDSource_QUIK[] = "3";
const char SecurityIDSource_BELGIAN[] = "F";
const char SecurityIDSource_VALOREN[] = "D";
const char SecurityIDSource_DUTCH[] = "C";
const char SecurityIDSource_WERTPAPIER[] = "B";
const char SecurityIDSource_BLOOMBERG_SYMBOL[] = "A";
const char SecurityIDSource_CONSOLIDATED_TAPE_ASSOCIATION[] = "9";
const char SecurityIDSource_EXCHANGE_SYMBOL[] = "8";
const char SecurityIDSource_ISO_COUNTRY_CODE[] = "7";
const char SecurityIDSource_ISO_CURRENCY_CODE[] = "6";
const char SecurityIDSource_RIC_CODE[] = "5";
const char SecurityIDSource_ISIN_NUMBER[] = "4";
const char SecurityIDSource_COMMON[] = "G";
const char SecurityIDSource_CLEARING_HOUSE[] = "H";
const char SecurityIDSource_ISDA_FP_ML_SPECIFICATION[] = "I";
const char SecurityIDSource_OPTION_PRICE_REPORTING_AUTHORITY[] = "J";
const char SecurityIDSource_ISDA_FP_MLURL[] = "K";
const char SecurityIDSource_LETTER_OF_CREDIT[] = "L";
const char SecurityIDSource_MARKETPLACE_ASSIGNED_IDENTIFIER[] = "M";
const char SecurityIDSource_MARKIT_RED_ENTITY_CLIP[] = "N";
const char SecurityIDSource_MARKIT_RED_PAIR_CLIP[] = "P";
const char SecurityIDSource_CFTC_COMMODITY_CODE[] = "Q";
const char SecurityIDSource_ISDA_COMMODITY_REFERENCE_PRICE[] = "R";
const char SecurityIDSource_FINANCIAL_INSTRUMENT_GLOBAL_IDENTIFIER[] = "S";
const char SecurityIDSource_LEGAL_ENTITY_IDENTIFIER[] = "T";
const char SecurityIDSource_SYNTHETIC[] = "U";
const char SecurityIDSource_FIDESSA_INSTRUMENT_MNEMONIC[] = "V";
const char SecurityIDSource_INDEX_NAME[] = "W";
const char SecurityIDSource_UNIFORM_SYMBOL[] = "X";
const char SecurityIDSource_DIGITAL_TOKEN_IDENTIFIER[] = "Y";
const char IOIQty_LARGE[] = "L";
const char IOIQty_MEDIUM[] = "M";
const char IOIQty_SMALL[] = "S";
const char IOIQty_UNDISCLOSED_QUANTITY[] = "U";
const char PositionEffect_FIFO = 'F';
const char PositionEffect_ROLLED = 'R';
const char PositionEffect_CLOSE = 'C';
const char PositionEffect_OPEN = 'O';
const char PositionEffect_CLOSE_BUT_NOTIFY_ON_OPEN = 'N';
const char PositionEffect_DEFAULT = 'D';
const char BenchmarkCurveName_SWAP[] = "SWAP";
const char BenchmarkCurveName_LIBID[] = "LIBID";
const char BenchmarkCurveName_OTHER[] = "OTHER";
const char BenchmarkCurveName_TREASURY[] = "Treasury";
const char BenchmarkCurveName_EURIBOR[] = "EURIBOR";
const char BenchmarkCurveName_PFANDBRIEFE[] = "Pfandbriefe";
const char BenchmarkCurveName_FUTURE_SWAP[] = "FutureSWAP";
const char BenchmarkCurveName_MUNI_AAA[] = "MuniAAA";
const char BenchmarkCurveName_LIBOR[] = "LIBOR";
const char BenchmarkCurveName_EONIA[] = "EONIA";
const char BenchmarkCurveName_EUREPO[] = "EUREPO";
const char BenchmarkCurveName_SONIA[] = "SONIA";
const char BenchmarkCurveName_FED_FUND_RATE_EFFECTIVE[] = "FEDEFF";
const char BenchmarkCurveName_FED_OPEN[] = "FEDOPEN";
const char BenchmarkCurveName_AUBSW[] = "AUBSW";
const char BenchmarkCurveName_BUBOR[] = "BUBOR";
const char BenchmarkCurveName_CDOR[] = "CDOR";
const char BenchmarkCurveName_CIBOR[] = "CIBOR";
const char BenchmarkCurveName_EONIASWAP[] = "EONIASWAP";
const char BenchmarkCurveName_ESTR[] = "ESTR";
const char BenchmarkCurveName_EURODOLLAR[] = "EURODOLLAR";
const char BenchmarkCurveName_EUROSWISS[] = "EUROSWISS";
const char BenchmarkCurveName_GCFREPO[] = "GCFREPO";
const char BenchmarkCurveName_ISDAFIX[] = "ISDAFIX";
const char BenchmarkCurveName_JIBAR[] = "JIBAR";
const char BenchmarkCurveName_MOSPRIM[] = "MOSPRIM";
const char BenchmarkCurveName_NIBOR[] = "NIBOR";
const char BenchmarkCurveName_PRIBOR[] = "PRIBOR";
const char BenchmarkCurveName_SOFR[] = "SOFR";
const char BenchmarkCurveName_STIBOR[] = "STIBOR";
const char BenchmarkCurveName_TELBOR[] = "TELBOR";
const char BenchmarkCurveName_TIBOR[] = "TIBOR";
const char BenchmarkCurveName_WIBOR[] = "WIBOR";
const char BenchmarkCurveName_AONIA[] = "AONIA";
const char BenchmarkCurveName_AONIAR[] = "AONIA-R";
const char BenchmarkCurveName_BKBM[] = "BKBM";
const char BenchmarkCurveName_CD19_D[] = "CD91D";
const char BenchmarkCurveName_CORRA[] = "CORRA";
const char BenchmarkCurveName_DIRRTN[] = "DIRR-TN";
const char BenchmarkCurveName_EIBOR[] = "EIBOR";
const char BenchmarkCurveName_FIXING_REPO_RATE[] = "FixingRepoRate";
const char BenchmarkCurveName_HIBOR[] = "HIBOR";
const char BenchmarkCurveName_IBR[] = "IBR";
const char BenchmarkCurveName_KLIBOR[] = "KLIBOR";
const char BenchmarkCurveName_MIBOR[] = "MIBOR";
const char BenchmarkCurveName_NZONIA[] = "NZONIA";
const char BenchmarkCurveName_PHIREF[] = "PHIREF";
const char BenchmarkCurveName_REIBOR[] = "REIBOR";
const char BenchmarkCurveName_SAIBOR[] = "SAIBOR";
const char BenchmarkCurveName_SARON[] = "SARON";
const char BenchmarkCurveName_SORA[] = "SORA";
const char BenchmarkCurveName_TLREF[] = "TLREF";
const char BenchmarkCurveName_TIIE[] = "TIIE";
const char BenchmarkCurveName_THBFIX[] = "THBFIX";
const char BenchmarkCurveName_TONAR[] = "TONAR";
const char StipulationType_ABSOLUTE_PREPAYMENT_SPEED[] = "ABS";
const char StipulationType_WEIGHTED_AVERAGE_LOAN_AGE[] = "WALA";
const char StipulationType_WEIGHTED_AVERAGE_MATURITY[] = "WAM";
const char StipulationType_CONSTANT_PREPAYMENT_RATE[] = "CPR";
const char StipulationType_FINAL_CPR_OF_HOME_EQUITY_PREPAYMENT_CURVE[] = "HEP";
const char StipulationType_WEIGHTED_AVERAGE_LIFE_COUPON[] = "WAL";
const char StipulationType_PERCENT_OF_MANUFACTURED_HOUSING_PREPAYMENT_CURVE[] = "MHP";
const char StipulationType_SINGLE_MONTHLY_MORTALITY[] = "SMM";
const char StipulationType_MONTHLY_PREPAYMENT_RATE[] = "MPR";
const char StipulationType_PERCENT_OF_BMA_PREPAYMENT_CURVE[] = "PSA";
const char StipulationType_PERCENT_OF_PROSPECTUS_PREPAYMENT_CURVE[] = "PPC";
const char StipulationType_CONSTANT_PREPAYMENT_PENALTY[] = "CPP";
const char StipulationType_LOT_VARIANCE[] = "LOTVAR";
const char StipulationType_CONSTANT_PREPAYMENT_YIELD[] = "CPY";
const char StipulationType_WEIGHTED_AVERAGE_COUPON[] = "WAC";
const char StipulationType_ISSUE_DATE[] = "ISSUE";
const char StipulationType_MATURITY_YEAR_AND_MONTH[] = "MAT";
const char StipulationType_NUMBER_OF_PIECES[] = "PIECES";
const char StipulationType_POOLS_MAXIMUM[] = "PMAX";
const char StipulationType_POOLS_PER_MILLION[] = "PPM";
const char StipulationType_POOLS_PER_LOT[] = "PPL";
const char StipulationType_POOLS_PER_TRADE[] = "PPT";
const char StipulationType_PRODUCTION_YEAR[] = "PROD";
const char StipulationType_TRADE_VARIANCE[] = "TRDVAR";
const char StipulationType_GEOGRAPHICS[] = "GEOG";
const char StipulationType_ALTERNATIVE_MINIMUM_TAX[] = "AMT";
const char StipulationType_AUTO_REINVESTMENT[] = "AUTOREINV";
const char StipulationType_BANK_QUALIFIED[] = "BANKQUAL";
const char StipulationType_BARGAIN_CONDITIONS[] = "BGNCON";
const char StipulationType_COUPON_RANGE[] = "COUPON";
const char StipulationType_ISO_CURRENCY_CODE[] = "CURRENCY";
const char StipulationType_CUSTOM_START[] = "CUSTOMDATE";
const char StipulationType_VALUATION_DISCOUNT[] = "HAIRCUT";
const char StipulationType_INSURED[] = "INSURED";
const char StipulationType_ISSUER[] = "ISSUER";
const char StipulationType_ISSUE_SIZE_RANGE[] = "ISSUESIZE";
const char StipulationType_LOOKBACK_DAYS[] = "LOOKBACK";
const char StipulationType_EXPLICIT_LOT_IDENTIFIER[] = "LOT";
const char StipulationType_MATURITY_RANGE[] = "MATURITY";
const char StipulationType_MAXIMUM_SUBSTITUTIONS[] = "MAXSUBS";
const char StipulationType_MINIMUM_QUANTITY[] = "MINQTY";
const char StipulationType_MINIMUM_INCREMENT[] = "MININCR";
const char StipulationType_MINIMUM_DENOMINATION[] = "MINDNOM";
const char StipulationType_PAYMENT_FREQUENCY[] = "PAYFREQ";
const char StipulationType_PRICE_RANGE[] = "PRICE";
const char StipulationType_PRICING_FREQUENCY[] = "PRICEFREQ";
const char StipulationType_CALL_PROTECTION[] = "PROTECT";
const char StipulationType_PURPOSE[] = "PURPOSE";
const char StipulationType_BENCHMARK_PRICE_SOURCE[] = "PXSOURCE";
const char StipulationType_RATING_SOURCE_AND_RANGE[] = "RATING";
const char StipulationType_TYPE_OF_REDEMPTION[] = "REDEMPTION";
const char StipulationType_RESTRICTED[] = "RESTRICTED";
const char StipulationType_MARKET_SECTOR[] = "SECTOR";
const char StipulationType_SECURITY_TYPE_INCLUDED_OR_EXCLUDED[] = "SECTYPE";
const char StipulationType_STRUCTURE[] = "STRUCT";
const char StipulationType_SUBSTITUTIONS_FREQUENCY[] = "SUBSFREQ";
const char StipulationType_SUBSTITUTIONS_LEFT[] = "SUBSLEFT";
const char StipulationType_FREEFORM_TEXT[] = "TEXT";
const char StipulationType_WHOLE_POOL[] = "WHOLE";
const char StipulationType_YIELD_RANGE[] = "YIELD";
const char StipulationType_AVERAGE_FICO_SCORE[] = "AVFICO";
const char StipulationType_AVERAGE_LOAN_SIZE[] = "AVSIZE";
const char StipulationType_MAXIMUM_LOAN_BALANCE[] = "MAXBAL";
const char StipulationType_POOL_IDENTIFIER[] = "POOL";
const char StipulationType_TYPE_OF_ROLL_TRADE[] = "ROLLTYPE";
const char StipulationType_REFERENCE_TO_ROLLING_OR_CLOSING_TRADE[] = "REFTRADE";
const char StipulationType_PRINCIPAL_OF_ROLLING_OR_CLOSING_TRADE[] = "REFPRIN";
const char StipulationType_INTEREST_OF_ROLLING_OR_CLOSING_TRADE[] = "REFINT";
const char StipulationType_AVAILABLE_OFFER_QUANTITY_TO_BE_SHOWN_TO_THE_STREET[] = "AVAILQTY";
const char StipulationType_BROKER_CREDIT[] = "BROKERCREDIT";
const char StipulationType_OFFER_PRICE_TO_BE_SHOWN_TO_INTERNAL_BROKERS[] = "INTERNALPX";
const char StipulationType_OFFER_QUANTITY_TO_BE_SHOWN_TO_INTERNAL_BROKERS[] = "INTERNALQTY";
const char StipulationType_THE_MINIMUM_RESIDUAL_OFFER_QUANTITY[] = "LEAVEQTY";
const char StipulationType_MAXIMUM_ORDER_SIZE[] = "MAXORDQTY";
const char StipulationType_ORDER_QUANTITY_INCREMENT[] = "ORDRINCR";
const char StipulationType_PRIMARY_OR_SECONDARY_MARKET_INDICATOR[] = "PRIMARY";
const char StipulationType_BROKER_SALES_CREDIT_OVERRIDE[] = "SALESCREDITOVR";
const char StipulationType_TRADER_CREDIT[] = "TRADERCREDIT";
const char StipulationType_DISCOUNT_RATE[] = "DISCOUNT";
const char StipulationType_YIELD_TO_MATURITY[] = "YTM";
const char StipulationType_ORIGINAL_AMOUNT[] = "ORIGAMT";
const char StipulationType_POOL_EFFECTIVE_DATE[] = "POOLEFFDT";
const char StipulationType_POOL_INITIAL_FACTOR[] = "POOLINITFCTR";
const char StipulationType_TRANCHE[] = "TRANCHE";
const char StipulationType_SUBSTITUTION[] = "SUBSTITUTION";
const char StipulationType_MULTEXCHFLLBCK[] = "MULTEXCHFLLBCK";
const char StipulationType_COMPSECFLLBCK[] = "COMPSECFLLBCK";
const char StipulationType_LOCLJRSDCTN[] = "LOCLJRSDCTN";
const char StipulationType_RELVJRSDCTN[] = "RELVJRSDCTN";
const char StipulationType_INCURRED_RECOVERY[] = "INCURRCVY";
const char StipulationType_ADDITIONAL_TERM[] = "ADDTRM";
const char StipulationType_MODIFIED_EQUITY_DELIVERY[] = "MODEQTYDLVY";
const char StipulationType_NO_REFERENCE_OBLICATION[] = "NOREFOBLIG";
const char StipulationType_UNKNOWN_REFERENCE_OBLIGATION[] = "UNKREFOBLIG";
const char StipulationType_ALL_GUARANTEES[] = "ALLGUARANTEES";
const char StipulationType_REFERENCE_PRICE[] = "REFPX";
const char StipulationType_REFERENCE_POLICY[] = "REFPOLICY";
const char StipulationType_SECURED_LIST[] = "SECRDLIST";
const char StipulationType_INTEREST_PAYOFF_OF_ROLLING_OR_AMENDING_TRADE[] = "PAYOFF";
const char YieldType_TRUE_YIELD[] = "TRUE";
const char YieldType_PREVIOUS_CLOSE_YIELD[] = "PREVCLOSE";
const char YieldType_YIELD_TO_LONGEST_AVERAGE[] = "LONGEST";
const char YieldType_YIELD_TO_LONGEST_AVERAGE_LIFE[] = "LONGAVGLIFE";
const char YieldType_YIELD_TO_MATURITY[] = "MATURITY";
const char YieldType_MARK_TO_MARKET_YIELD[] = "MARK";
const char YieldType_OPEN_AVERAGE_YIELD[] = "OPENAVG";
const char YieldType_YIELD_TO_NEXT_PUT[] = "PUT";
const char YieldType_PROCEEDS_YIELD[] = "PROCEEDS";
const char YieldType_SEMI_ANNUAL_YIELD[] = "SEMIANNUAL";
const char YieldType_YIELD_TO_SHORTEST_AVERAGE_LIFE[] = "SHORTAVGLIFE";
const char YieldType_YIELD_TO_SHORTEST_AVERAGE[] = "SHORTEST";
const char YieldType_SIMPLE_YIELD[] = "SIMPLE";
const char YieldType_YIELD_TO_TENDER_DATE[] = "TENDER";
const char YieldType_YIELD_VALUE_OF32NDS[] = "VALUE1_32";
const char YieldType_YIELD_TO_WORST[] = "WORST";
const char YieldType_TAX_EQUIVALENT_YIELD[] = "TAXEQUIV";
const char YieldType_ANNUAL_YIELD[] = "ANNUAL";
const char YieldType_CLOSING_YIELD_MOST_RECENT_YEAR[] = "LASTYEAR";
const char YieldType_YIELD_TO_NEXT_REFUND[] = "NEXTREFUND";
const char YieldType_AFTER_TAX_YIELD[] = "AFTERTAX";
const char YieldType_YIELD_AT_ISSUE[] = "ATISSUE";
const char YieldType_YIELD_TO_AVERAGE_LIFE[] = "AVGLIFE";
const char YieldType_YIELD_TO_AVERAGE_MATURITY[] = "AVGMATURITY";
const char YieldType_BOOK_YIELD[] = "BOOK";
const char YieldType_YIELD_TO_NEXT_CALL[] = "CALL";
const char YieldType_YIELD_CHANGE_SINCE_CLOSE[] = "CHANGE";
const char YieldType_COMPOUND_YIELD[] = "COMPOUND";
const char YieldType_CURRENT_YIELD[] = "CURRENT";
const char YieldType_TRUE_GROSS_YIELD[] = "GROSS";
const char YieldType_GVNT_EQUIVALENT_YIELD[] = "GOVTEQUIV";
const char YieldType_YIELD_WITH_INFLATION_ASSUMPTION[] = "INFLATION";
const char YieldType_INVERSE_FLOATER_BOND_YIELD[] = "INVERSEFLOATER";
const char YieldType_CLOSING_YIELD_MOST_RECENT_QUARTER[] = "LASTQUARTER";
const char YieldType_MOST_RECENT_CLOSING_YIELD[] = "LASTCLOSE";
const char YieldType_CLOSING_YIELD_MOST_RECENT_MONTH[] = "LASTMONTH";
const char YieldType_CLOSING_YIELD[] = "CLOSE";
const char YieldType_YIELD_VALUE_OF132[] = "VALUE1/32";
const char TradedFlatSwitch_NO = 'N';
const char TradedFlatSwitch_YES = 'Y';
const int QuoteStatus_REMOVED_FROM_MARKET = 6;
const int QuoteStatus_CANCEL_FOR_SYMBOL = 1;
const int QuoteStatus_PENDING = 10;
const int QuoteStatus_QUOTE_NOT_FOUND = 9;
const int QuoteStatus_QUERY = 8;
const int QuoteStatus_EXPIRED = 7;
const int QuoteStatus_REJECTED = 5;
const int QuoteStatus_CANCELED_ALL = 4;
const int QuoteStatus_CANCELED_FOR_UNDERLYING = 3;
const int QuoteStatus_CANCELED_FOR_SECURITY_TYPE = 2;
const int QuoteStatus_ACCEPTED = 0;
const int QuoteStatus_PASS = 11;
const int QuoteStatus_LOCKED_MARKET_WARNING = 12;
const int QuoteStatus_CROSS_MARKET_WARNING = 13;
const int QuoteStatus_CANCELED_DUE_TO_LOCK_MARKET = 14;
const int QuoteStatus_CANCELED_DUE_TO_CROSS_MARKET = 15;
const int QuoteStatus_ACTIVE = 16;
const int QuoteStatus_CANCELED = 17;
const int QuoteStatus_UNSOLICITED_QUOTE_REPLENISHMENT = 18;
const int QuoteStatus_PENDING_END_TRADE = 19;
const int QuoteStatus_TOO_LATE_TO_END = 20;
const int QuoteStatus_TRADED = 21;
const int QuoteStatus_TRADED_AND_REMOVED = 22;
const int QuoteStatus_CONTRACT_TERMINATES = 23;
const char PartyIDSource_CHINESE_INVESTOR_ID = '5';
const char PartyIDSource_US_EMPLOYER_OR_TAX_ID_NUMBER = '8';
const char PartyIDSource_AUSTRALIAN_TAX_FILE_NUMBER = 'A';
const char PartyIDSource_AUSTRALIAN_BUSINESS_NUMBER = '9';
const char PartyIDSource_ISO_COUNTRY_CODE = 'E';
const char PartyIDSource_BIC = 'B';
const char PartyIDSource_US_SOCIAL_SECURITY_NUMBER = '7';
const char PartyIDSource_PROPRIETARY = 'D';
const char PartyIDSource_SETTLEMENT_ENTITY_LOCATION = 'F';
const char PartyIDSource_KOREAN_INVESTOR_ID = '1';
const char PartyIDSource_TAIWANESE_FOREIGN_INVESTOR_ID = '2';
const char PartyIDSource_TAIWANESE_TRADING_ACCT = '3';
const char PartyIDSource_MALAYSIAN_CENTRAL_DEPOSITORY = '4';
const char PartyIDSource_UK_NATIONAL_INSURANCE_OR_PENSION_NUMBER = '6';
const char PartyIDSource_GENERAL_IDENTIFIER = 'C';
const char PartyIDSource_MIC = 'G';
const char PartyIDSource_CSD_PARTICIPANT = 'H';
const char PartyIDSource_ISITC_ACRONYM = 'I';
const char PartyIDSource_TAX_ID = 'J';
const char PartyIDSource_AUSTRALIAN_COMPANY_NUMBER = 'K';
const char PartyIDSource_AUSTRALIAN_REGISTERED_BODY_NUMBER = 'L';
const char PartyIDSource_CFTC_REPORTING_FIRM_IDENTIFIER = 'M';
const char PartyIDSource_LEGAL_ENTITY_IDENTIFIER = 'N';
const char PartyIDSource_INTERIM_IDENTIFIER = 'O';
const char PartyIDSource_SHORT_CODE_IDENTIFIER = 'P';
const char PartyIDSource_NATIONAL_ID_NATURAL_PERSON = 'Q';
const char PartyIDSource_INDIA_PERMANENT_ACCOUNT_NUMBER = 'R';
const char PartyIDSource_FDID = 'S';
const char PartyIDSource_SPSAID = 'T';
const char PartyIDSource_MASTER_SPSAID = 'U';
const int PartyRole_CORRESPONDANT_CLEARING_FIRM = 15;
const int PartyRole_CLIENT_ID = 3;
const int PartyRole_UNDERLYING_CONTRA_FIRM = 20;
const int PartyRole_SPONSORING_FIRM = 19;
const int PartyRole_CONTRA_CLEARING_FIRM = 18;
const int PartyRole_CONTRA_FIRM = 17;
const int PartyRole_EXECUTING_SYSTEM = 16;
const int PartyRole_ENTERING_FIRM = 7;
const int PartyRole_EXECUTING_FIRM = 1;
const int PartyRole_BROKER_OF_CREDIT = 2;
const int PartyRole_INVESTOR_ID = 5;
const int PartyRole_INTRODUCING_FIRM = 6;
const int PartyRole_GIVEUP_CLEARING_FIRM = 97;
const int PartyRole_LOCATE = 8;
const int PartyRole_FUND_MANAGER_CLIENT_ID = 9;
const int PartyRole_SETTLEMENT_LOCATION = 10;
const int PartyRole_ORDER_ORIGINATION_TRADER = 11;
const int PartyRole_EXECUTING_TRADER = 12;
const int PartyRole_ORDER_ORIGINATION_FIRM = 13;
const int PartyRole_CLEARING_FIRM = 4;
const int PartyRole_CLEARING_ORGANIZATION = 21;
const int PartyRole_EXCHANGE = 22;
const int PartyRole_CUSTOMER_ACCOUNT = 24;
const int PartyRole_CORRESPONDENT_CLEARING_ORGANIZATION = 25;
const int PartyRole_CORRESPONDENT_BROKER = 26;
const int PartyRole_BUYER = 27;
const int PartyRole_CUSTODIAN = 28;
const int PartyRole_INTERMEDIARY = 29;
const int PartyRole_AGENT = 30;
const int PartyRole_SUB_CUSTODIAN = 31;
const int PartyRole_BENEFICIARY = 32;
const int PartyRole_INTERESTED_PARTY = 33;
const int PartyRole_REGULATORY_BODY = 34;
const int PartyRole_LIQUIDITY_PROVIDER = 35;
const int PartyRole_ENTERING_TRADER = 36;
const int PartyRole_CONTRA_TRADER = 37;
const int PartyRole_POSITION_ACCOUNT = 38;
const int PartyRole_CONTRA_INVESTOR_ID = 39;
const int PartyRole_TRANSFER_TO_FIRM = 40;
const int PartyRole_CONTRA_POSITION_ACCOUNT = 41;
const int PartyRole_CONTRA_EXCHANGE = 42;
const int PartyRole_INTERNAL_CARRY_ACCOUNT = 43;
const int PartyRole_ORDER_ENTRY_OPERATOR_ID = 44;
const int PartyRole_SECONDARY_ACCOUNT_NUMBER = 45;
const int PartyRole_FOREIGN_FIRM = 46;
const int PartyRole_THIRD_PARTY_ALLOCATION_FIRM = 47;
const int PartyRole_CLAIMING_ACCOUNT = 48;
const int PartyRole_ASSET_MANAGER = 49;
const int PartyRole_PLEDGOR_ACCOUNT = 50;
const int PartyRole_PLEDGEE_ACCOUNT = 51;
const int PartyRole_LARGE_TRADER_REPORTABLE_ACCOUNT = 52;
const int PartyRole_TRADER_MNEMONIC = 53;
const int PartyRole_SENDER_LOCATION = 54;
const int PartyRole_SESSION_ID = 55;
const int PartyRole_ACCEPTABLE_COUNTERPARTY = 56;
const int PartyRole_UNACCEPTABLE_COUNTERPARTY = 57;
const int PartyRole_ENTERING_UNIT = 58;
const int PartyRole_EXECUTING_UNIT = 59;
const int PartyRole_INTRODUCING_BROKER = 60;
const int PartyRole_QUOTE_ORIGINATOR = 61;
const int PartyRole_REPORT_ORIGINATOR = 62;
const int PartyRole_SYSTEMATIC_INTERNALISER = 63;
const int PartyRole_MULTILATERAL_TRADING_FACILITY = 64;
const int PartyRole_REGULATED_MARKET = 65;
const int PartyRole_MARKET_MAKER = 66;
const int PartyRole_INVESTMENT_FIRM = 67;
const int PartyRole_HOST_COMPETENT_AUTHORITY = 68;
const int PartyRole_HOME_COMPETENT_AUTHORITY = 69;
const int PartyRole_COMPETENT_AUTHORITY_LIQUIDITY = 70;
const int PartyRole_COMPETENT_AUTHORITY_TRANSACTION_VENUE = 71;
const int PartyRole_REPORTING_INTERMEDIARY = 72;
const int PartyRole_EXECUTION_VENUE = 73;
const int PartyRole_MARKET_DATA_ENTRY_ORIGINATOR = 74;
const int PartyRole_LOCATION_ID = 75;
const int PartyRole_DESK_ID = 76;
const int PartyRole_MARKET_DATA_MARKET = 77;
const int PartyRole_ALLOCATION_ENTITY = 78;
const int PartyRole_PRIME_BROKER = 79;
const int PartyRole_STEP_OUT_FIRM = 80;
const int PartyRole_BROKER_CLEARING_ID = 81;
const int PartyRole_GIVEUP_CLEARING_FIRM_DEPR = 14;
const int PartyRole_CENTRAL_REGISTRATION_DEPOSITORY = 82;
const int PartyRole_CLEARING_ACCOUNT = 83;
const int PartyRole_ACCEPTABLE_SETTLING_COUNTERPARTY = 84;
const int PartyRole_UNACCEPTABLE_SETTLING_COUNTERPARTY = 85;
const int PartyRole_CLS_MEMBER_BANK = 86;
const int PartyRole_IN_CONCERT_GROUP = 87;
const int PartyRole_IN_CONCERT_CONTROLLING_ENTITY = 88;
const int PartyRole_LARGE_POSITIONS_REPORTING_ACCOUNT = 89;
const int PartyRole_SETTLEMENT_FIRM = 90;
const int PartyRole_SETTLEMENT_ACCOUNT = 91;
const int PartyRole_REPORTING_MARKET_CENTER = 92;
const int PartyRole_RELATED_REPORTING_MARKET_CENTER = 93;
const int PartyRole_AWAY_MARKET = 94;
const int PartyRole_GIVEUP_TRADING_FIRM = 95;
const int PartyRole_TAKEUP_TRADING_FIRM = 96;
const int PartyRole_TAKEUP_CLEARING_FIRM = 98;
const int PartyRole_ORIGINATING_MARKET = 99;
const int PartyRole_MARGIN_ACCOUNT = 100;
const int PartyRole_COLLATERAL_ASSET_ACCOUNT = 101;
const int PartyRole_DATA_REPOSITORY = 102;
const int PartyRole_CALCULATION_AGENT = 103;
const int PartyRole_EXERCISE_NOTICE_SENDER = 104;
const int PartyRole_EXERCISE_NOTICE_RECEIVER = 105;
const int PartyRole_RATE_REFERENCE_BANK = 106;
const int PartyRole_CORRESPONDENT = 107;
const int PartyRole_BENEFICIARY_BANK = 109;
const int PartyRole_BORROWER = 110;
const int PartyRole_PRIMARY_OBLIGATOR = 111;
const int PartyRole_GUARANTOR = 112;
const int PartyRole_EXCLUDED_REFERENCE_ENTITY = 113;
const int PartyRole_DETERMINING_PARTY = 114;
const int PartyRole_HEDGING_PARTY = 115;
const int PartyRole_REPORTING_ENTITY = 116;
const int PartyRole_SALES_PERSON = 117;
const int PartyRole_OPERATOR = 118;
const int PartyRole_CSD = 119;
const int PartyRole_ICSD = 120;
const int PartyRole_TRADING_SUB_ACCOUNT = 121;
const int PartyRole_INVESTMENT_DECISION_MAKER = 122;
const int PartyRole_PUBLISHING_INTERMEDIARY = 123;
const int PartyRole_CSD_PARTICIPANT = 124;
const int PartyRole_ISSUER = 125;
const int PartyRole_CONTRA_CUSTOMER_ACCOUNT = 126;
const int PartyRole_CONTRA_INVESTMENT_DECISION_MAKER = 127;
const int Product_LOAN = 8;
const int Product_OTHER = 12;
const int Product_MUNICIPAL = 11;
const int Product_AGENCY = 1;
const int Product_CORPORATE = 3;
const int Product_CURRENCY = 4;
const int Product_COMMODITY = 2;
const int Product_GOVERNMENT = 6;
const int Product_MORTGAGE = 10;
const int Product_INDEX = 7;
const int Product_MONEYMARKET = 9;
const int Product_EQUITY = 5;
const int Product_FINANCING = 13;
const int QuantityType_CONTRACTS = 6;
const int QuantityType_OTHER = 7;
const int QuantityType_CURRENCY = 5;
const int QuantityType_ORIGINALFACE = 4;
const int QuantityType_CURRENTFACE = 3;
const int QuantityType_BONDS = 2;
const int QuantityType_SHARES = 1;
const int QuantityType_PAR = 8;
const char RoundingDirection_ROUND_TO_NEAREST = '0';
const char RoundingDirection_ROUND_DOWN = '1';
const char RoundingDirection_ROUND_UP = '2';
const int DistribPaymentMethod_CREST = 1;
const int DistribPaymentMethod_NSCC = 2;
const int DistribPaymentMethod_EUROCLEAR = 3;
const int DistribPaymentMethod_CLEARSTREAM = 4;
const int DistribPaymentMethod_CHEQUE = 5;
const int DistribPaymentMethod_TELEGRAPHIC_TRANSFER = 6;
const int DistribPaymentMethod_FED_WIRE = 7;
const int DistribPaymentMethod_DIRECT_CREDIT = 8;
const int DistribPaymentMethod_ACH_CREDIT = 9;
const int DistribPaymentMethod_BPAY = 10;
const int DistribPaymentMethod_HIGH_VALUE_CLEARING_SYSTEM_HVACS = 11;
const int DistribPaymentMethod_REINVEST_IN_FUND = 12;
const int DistribPaymentMethod_OTHER = 999;
const char CancellationRights_NO_WAIVER_AGREEMENT = 'M';
const char CancellationRights_NO_EXECUTION_ONLY = 'N';
const char CancellationRights_YES = 'Y';
const char CancellationRights_NO_INSTITUTIONAL = 'O';
const char MoneyLaunderingStatus_EXEMPT_AUTHORISED = '3';
const char MoneyLaunderingStatus_EXEMPT_MONEY_TYPE = '2';
const char MoneyLaunderingStatus_EXEMPT_BELOW_LIMIT = '1';
const char MoneyLaunderingStatus_PASSED = 'Y';
const char MoneyLaunderingStatus_NOT_CHECKED = 'N';
const char ExecPriceType_SINGLE_PRICE = 'S';
const char ExecPriceType_OFFER_PRICE_MINUS_ADJUSTMENT_AMOUNT = 'Q';
const char ExecPriceType_OFFER_PRICE_MINUS_ADJUSTMENT_PERCENT = 'P';
const char ExecPriceType_OFFER_PRICE = 'O';
const char ExecPriceType_CREATION_PRICE_PLUS_ADJUSTMENT_AMOUNT = 'E';
const char ExecPriceType_CREATION_PRICE_PLUS_ADJUSTMENT_PERCENT = 'D';
const char ExecPriceType_CREATION_PRICE = 'C';
const char ExecPriceType_BID_PRICE = 'B';
const int TradeReportTransType_NEW = 0;
const int TradeReportTransType_REPLACE = 2;
const int TradeReportTransType_CANCEL = 1;
const int TradeReportTransType_RELEASE = 3;
const int TradeReportTransType_REVERSE = 4;
const int TradeReportTransType_CANCEL_DUE_TO_BACK_OUT_OF_TRADE = 5;
const int PaymentMethod_BPAY = 14;
const int PaymentMethod_ACH_CREDIT = 13;
const int PaymentMethod_ACH_DEBIT = 12;
const int PaymentMethod_CREDIT_CARD = 11;
const int PaymentMethod_DIRECT_CREDIT = 10;
const int PaymentMethod_DIRECT_DEBIT = 9;
const int PaymentMethod_DEBIT_CARD = 8;
const int PaymentMethod_FED_WIRE = 7;
const int PaymentMethod_HIGH_VALUE_CLEARING_SYSTEM = 15;
const int PaymentMethod_EUROCLEAR = 3;
const int PaymentMethod_TELEGRAPHIC_TRANSFER = 6;
const int PaymentMethod_CLEARSTREAM = 4;
const int PaymentMethod_CREST = 1;
const int PaymentMethod_NSCC = 2;
const int PaymentMethod_CHEQUE = 5;
const int PaymentMethod_CHIPS = 16;
const int PaymentMethod_SWIFT = 17;
const int PaymentMethod_CHAPS = 18;
const int PaymentMethod_SIC = 19;
const int PaymentMethod_EURO_SIC = 20;
const int PaymentMethod_OTHER = 999;
const int TaxAdvantageType_PROFIT_SHARING_PLAN = 19;
const int TaxAdvantageType_EMPLOYER_PRIOR_YEAR = 11;
const int TaxAdvantageType_EMPLOYER_CURRENT_YEAR = 12;
const int TaxAdvantageType_NON_FUND_PROTOTYPE_IRA = 13;
const int TaxAdvantageType_NON_FUND_QUALIFIED_PLAN = 14;
const int TaxAdvantageType_DEFINED_CONTRIBUTION_PLAN = 15;
const int TaxAdvantageType_EMPLOYEE_CURRENT_YEAR = 10;
const int TaxAdvantageType_IRA_ROLLOVER = 17;
const int TaxAdvantageType_MINI_INSURANCE_ISA = 5;
const int TaxAdvantageType_IRA = 16;
const int TaxAdvantageType_EMPLOYEE_PRIOR_YEAR = 9;
const int TaxAdvantageType_ASSET_TRANSFER = 8;
const int TaxAdvantageType_SELF_DIRECTED_IRA = 21;
const int TaxAdvantageType_CURRENT_YEAR_PAYMENT = 6;
const int TaxAdvantageType_US401_K = 20;
const int TaxAdvantageType_MINI_STOCKS_AND_SHARES_ISA = 4;
const int TaxAdvantageType_MINI_CASH_ISA = 3;
const int TaxAdvantageType_TESSA = 2;
const int TaxAdvantageType_MAXI_ISA = 1;
const int TaxAdvantageType_NONE = 0;
const int TaxAdvantageType_PRIOR_YEAR_PAYMENT = 7;
const int TaxAdvantageType_US457 = 23;
const int TaxAdvantageType_ROTH_IRA_PROTOTYPE = 24;
const int TaxAdvantageType_ROTH_IRA_NON_PROTOTYPE = 25;
const int TaxAdvantageType_ROTH_CONVERSION_IRA_PROTOTYPE = 26;
const int TaxAdvantageType_ROTH_CONVERSION_IRA_NON_PROTOTYPE = 27;
const int TaxAdvantageType_EDUCATION_IRA_PROTOTYPE = 28;
const int TaxAdvantageType_EDUCATION_IRA_NON_PROTOTYPE = 29;
const int TaxAdvantageType_KEOGH = 18;
const int TaxAdvantageType_US403B = 22;
const int TaxAdvantageType_OTHER = 999;
const char FundRenewWaiv_NO = 'N';
const char FundRenewWaiv_YES = 'Y';
const char RegistStatus_ACCEPTED = 'A';
const char RegistStatus_REMINDER = 'N';
const char RegistStatus_REJECTED = 'R';
const char RegistStatus_HELD = 'H';
const int RegistRejReasonCode_INVALID_DISTRIB_INSTNS = 13;
const int RegistRejReasonCode_INVALID_AGENT_CODE = 17;
const int RegistRejReasonCode_INVALID_ACCOUNT_NAME = 16;
const int RegistRejReasonCode_NO_REG_DETAILS = 4;
const int RegistRejReasonCode_INVALID_PAYMENT_METHOD = 15;
const int RegistRejReasonCode_INVALID_PERCENTAGE = 14;
const int RegistRejReasonCode_INVALID_OWNERSHIP_TYPE = 3;
const int RegistRejReasonCode_INVALID_TAX_EXEMPT_TYPE = 2;
const int RegistRejReasonCode_INVALID_COUNTRY = 12;
const int RegistRejReasonCode_INVALID_DATE_OF_BIRTH = 11;
const int RegistRejReasonCode_INVALID_INVESTOR_ID_SOURCE = 10;
const int RegistRejReasonCode_INVALID_INVESTOR_ID = 9;
const int RegistRejReasonCode_INVALID_MAILING_INSTRUCTIONS = 8;
const int RegistRejReasonCode_INVALID_MAILING_DETAILS = 7;
const int RegistRejReasonCode_INVALID_REG_SEQ_NO = 5;
const int RegistRejReasonCode_INVALID_ACCOUNT_TYPE = 1;
const int RegistRejReasonCode_INVALID_ACCOUNT_NUM = 18;
const int RegistRejReasonCode_INVALID_REG_DETAILS = 6;
const int RegistRejReasonCode_OTHER = 99;
const char RegistTransType_CANCEL = '2';
const char RegistTransType_NEW = '0';
const char RegistTransType_REPLACE = '1';
const char OwnershipType_JOINT_INVESTORS = 'J';
const char OwnershipType_TENANTS_IN_COMMON = 'T';
const char OwnershipType_JOINT_TRUSTEES = '2';
const int ContAmtType_NET_SETTLEMENT_AMOUNT = 15;
const int ContAmtType_COMMISSION_AMOUNT = 1;
const int ContAmtType_COMMISSION_PERCENT = 2;
const int ContAmtType_INITIAL_CHARGE_AMOUNT = 3;
const int ContAmtType_INITIAL_CHARGE_PERCENT = 4;
const int ContAmtType_DISCOUNT_AMOUNT = 5;
const int ContAmtType_DISCOUNT_PERCENT = 6;
const int ContAmtType_DILUTION_LEVY_AMOUNT = 7;
const int ContAmtType_DILUTION_LEVY_PERCENT = 8;
const int ContAmtType_EXIT_CHARGE_AMOUNT = 9;
const int ContAmtType_EXIT_CHARGE_PERCENT = 10;
const int ContAmtType_FUND_BASED_RENEWAL_COMMISSION_PERCENT = 11;
const int ContAmtType_PROJECTED_FUND_VALUE = 12;
const int ContAmtType_FUND_BASED_RENEWAL_COMMISSION_ON_FUND = 14;
const int ContAmtType_FUND_BASED_RENEWAL_COMMISSION_ON_ORDER = 13;
const int OwnerType_COMPANY_TRUSTEE = 5;
const int OwnerType_NOMINEE = 13;
const int OwnerType_CORPORATE_BODY = 12;
const int OwnerType_NON_PROFIT_ORGANIZATION = 11;
const int OwnerType_NETWORKING_SUB_ACCOUNT = 10;
const int OwnerType_FIDUCIARIES = 9;
const int OwnerType_TRUSTS = 8;
const int OwnerType_PENSION_PLAN = 6;
const int OwnerType_INDIVIDUAL_TRUSTEE = 4;
const int OwnerType_PUBLIC_COMPANY = 2;
const int OwnerType_PRIVATE_COMPANY = 3;
const int OwnerType_INDIVIDUAL_INVESTOR = 1;
const int OwnerType_CUSTODIAN_UNDER_GIFTS_TO_MINORS_ACT = 7;
const int OwnerType_INSTITUTIONAL_CUSTOMER = 14;
const int OwnerType_COMBINED = 15;
const int OwnerType_MEMBER_FIRM_EMPLOYEE = 16;
const int OwnerType_MARKET_MAKING_ACCOUNT = 17;
const int OwnerType_PROPRIETARY_ACCOUNT = 18;
const int OwnerType_NONBROKER_DEALER = 19;
const int OwnerType_UNKNOWN_BENEFICIAL_OWNER_TYPE = 20;
const int OwnerType_FIRMS_ERROR_ACCOUNT = 21;
const int OwnerType_FIRM_AGENCY_AVERAGE_PRICE_ACCOUNT = 22;
const char OrderCapacity_RISKLESS_PRINCIPAL = 'R';
const char OrderCapacity_INDIVIDUAL = 'I';
const char OrderCapacity_PRINCIPAL = 'P';
const char OrderCapacity_AGENT_FOR_OTHER_MEMBER = 'W';
const char OrderCapacity_AGENCY = 'A';
const char OrderCapacity_PROPRIETARY = 'G';
const char OrderCapacity_MIXED_CAPACITY = 'M';
const char OrderRestrictions_FOREIGN_ENTITY = '7';
const char OrderRestrictions_RISKLESS_ARBITRAGE = 'A';
const char OrderRestrictions_PROGRAM_TRADE = '1';
const char OrderRestrictions_EXTERNAL_MARKET_PARTICIPANT = '8';
const char OrderRestrictions_ACTING_AS_MARKET_MAKER_OR_SPECIALIST_IN_UNDERLYING = '6';
const char OrderRestrictions_ACTING_AS_MARKET_MAKER_OR_SPECIALIST_IN_SECURITY = '5';
const char OrderRestrictions_NON_INDEX_ARBITRAGE = '3';
const char OrderRestrictions_INDEX_ARBITRAGE = '2';
const char OrderRestrictions_COMPETING_MARKET_MAKER = '4';
const char OrderRestrictions_EXTERNAL_INTER_CONNECTED_MARKET_LINKAGE = '9';
const char OrderRestrictions_ISSUER_HOLDING = 'B';
const char OrderRestrictions_ISSUE_PRICE_STABILIZATION = 'C';
const char OrderRestrictions_NON_ALGORITHMIC = 'D';
const char OrderRestrictions_ALGORITHMIC = 'E';
const char OrderRestrictions_CROSS = 'F';
const char OrderRestrictions_INSIDER_ACCOUNT = 'G';
const char OrderRestrictions_SIGNIFICANT_SHAREHOLDER = 'H';
const char OrderRestrictions_NORMAL_COURSE_ISSUER_BID = 'I';
const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_SECURITY = '1';
const char MassCancelRequestType_CANCEL_ALL_ORDERS = '7';
const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_TRADING_SESSION = '6';
const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_SECURITY_TYPE = '5';
const char MassCancelRequestType_CANCEL_ORDERS_FOR_ACFI_CODE = '4';
const char MassCancelRequestType_CANCEL_ORDERS_FOR_AN_UNDERLYING_SECURITY = '2';
const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_PRODUCT = '3';
const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_MARKET = '8';
const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_MARKET_SEGMENT = '9';
const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_SECURITY_GROUP = 'A';
const char MassCancelRequestType_CANCEL_ORDERS_FOR_SECURITY_ISSUER = 'B';
const char MassCancelRequestType_CANCEL_FOR_ISSUER_OF_UNDERLYING_SECURITY = 'C';
const char MassCancelResponse_CANCEL_ORDERS_FOR_A_TRADING_SESSION = '6';
const char MassCancelResponse_CANCEL_REQUEST_REJECTED = '0';
const char MassCancelResponse_CANCEL_ALL_ORDERS = '7';
const char MassCancelResponse_CANCEL_ORDERS_FOR_A_PRODUCT = '3';
const char MassCancelResponse_CANCEL_ORDERS_FOR_A_SECURITY_TYPE = '5';
const char MassCancelResponse_CANCEL_ORDERS_FOR_ACFI_CODE = '4';
const char MassCancelResponse_CANCEL_ORDERS_FOR_A_SECURITY = '1';
const char MassCancelResponse_CANCEL_ORDERS_FOR_AN_UNDERLYING_SECURITY = '2';
const char MassCancelResponse_CANCEL_ORDERS_FOR_A_MARKET = '8';
const char MassCancelResponse_CANCEL_ORDERS_FOR_A_MARKET_SEGMENT = '9';
const char MassCancelResponse_CANCEL_ORDERS_FOR_A_SECURITY_GROUP = 'A';
const char MassCancelResponse_CANCEL_ORDERS_FOR_A_SECURITIES_ISSUER = 'B';
const char MassCancelResponse_CANCEL_ORDERS_FOR_ISSUER_OF_UNDERLYING_SECURITY = 'C';
const int MassCancelRejectReason_INVALID_OR_UNKOWN_UNDERLYING_SECURITY = 2;
const int MassCancelRejectReason_INVALID_OR_UNKNOWN_TRADING_SESSION = 6;
const int MassCancelRejectReason_INVALID_OR_UNKNOWN_SECURITY_TYPE = 5;
const int MassCancelRejectReason_INVALID_OR_UNKNOWN_PRODUCT = 3;
const int MassCancelRejectReason_INVALID_OR_UNKNOWN_SECURITY = 1;
const int MassCancelRejectReason_MASS_CANCEL_NOT_SUPPORTED = 0;
const int MassCancelRejectReason_INVALID_OR_UNKNOWN_CFI_CODE = 4;
const int MassCancelRejectReason_OTHER = 99;
const int MassCancelRejectReason_INVALID_OR_UNKNOWN_MARKET = 7;
const int MassCancelRejectReason_INVALID_OR_UNKOWN_MARKET_SEGMENT = 8;
const int MassCancelRejectReason_INVALID_OR_UNKNOWN_SECURITY_GROUP = 9;
const int MassCancelRejectReason_INVALID_OR_UNKNOWN_UNDERLYING_SECURITY = 2;
const int MassCancelRejectReason_INVALID_OR_UNKNOWN_SECURITY_ISSUER = 10;
const int MassCancelRejectReason_INVALID_OR_UNKNOWN_ISSUER_OF_UNDERLYING_SECURITY = 11;
const int QuoteType_INDICATIVE = 0;
const int QuoteType_TRADEABLE = 1;
const int QuoteType_RESTRICTED_TRADEABLE = 2;
const int QuoteType_COUNTER = 3;
const int QuoteType_INITIALLY_TRADEABLE = 4;
const char CashMargin_MARGIN_OPEN = '2';
const char CashMargin_MARGIN_CLOSE = '3';
const char CashMargin_CASH = '1';
const char Scope_LOCAL_MARKET = '1';
const char Scope_NATIONAL = '2';
const char Scope_GLOBAL = '3';
const char MDImplicitDelete_YES = 'Y';
const char MDImplicitDelete_NO = 'N';
const int CrossType_CROSS_AON = 1;
const int CrossType_CROSS_IOC = 2;
const int CrossType_CROSS_ONE_SIDE = 3;
const int CrossType_CROSS_SAME_PRICE = 4;
const int CrossType_BASIS_CROSS = 5;
const int CrossType_CONTINGENT_CROSS = 6;
const int CrossType_VWAP_CROSS = 7;
const int CrossType_STS_CROSS = 8;
const int CrossType_CUSTOMER_TO_CUSTOMER = 9;
const int CrossPrioritization_SELL_SIDE_IS_PRIORITIZED = 2;
const int CrossPrioritization_NONE = 0;
const int CrossPrioritization_BUY_SIDE_IS_PRIORITIZED = 1;
const char NoSides_ONE_SIDE = '1';
const char NoSides_BOTH_SIDES = '2';
const int SecurityListRequestType_SECURITY_TYPE_AND = 1;
const int SecurityListRequestType_PRODUCT = 2;
const int SecurityListRequestType_TRADING_SESSION_ID = 3;
const int SecurityListRequestType_ALL_SECURITIES = 4;
const int SecurityListRequestType_SYMBOL = 0;
const int SecurityListRequestType_MARKET_ID_OR_MARKET_ID = 5;
const int SecurityRequestResult_INSTRUMENT_DATA_TEMPORARILY_UNAVAILABLE = 4;
const int SecurityRequestResult_VALID_REQUEST = 0;
const int SecurityRequestResult_INVALID_OR_UNSUPPORTED_REQUEST = 1;
const int SecurityRequestResult_REQUEST_FOR_INSTRUMENT_DATA_NOT_SUPPORTED = 5;
const int SecurityRequestResult_NOT_AUTHORIZED_TO_RETRIEVE_INSTRUMENT_DATA = 3;
const int SecurityRequestResult_NO_INSTRUMENTS_FOUND = 2;
const int MultiLegRptTypeReq_REPORT_BY_MULITLEG_SECURITY_ONLY = 0;
const int MultiLegRptTypeReq_REPORT_BY_MULTILEG_SECURITY_AND_INSTRUMENT_LEGS = 1;
const int MultiLegRptTypeReq_REPORT_BY_INSTRUMENT_LEGS_ONLY = 2;
const int TradSesStatusRejReason_UNKNOWN_OR_INVALID_TRADING_SESSION_ID = 1;
const int TradSesStatusRejReason_OTHER = 99;
const int TradeRequestType_ADVISORIES_THAT_MATCH_CRITERIA = 4;
const int TradeRequestType_UNREPORTED_TRADES_THAT_MATCH_CRITERIA = 3;
const int TradeRequestType_UNMATCHED_TRADES_THAT_MATCH_CRITERIA = 2;
const int TradeRequestType_MATCHED_TRADES_MATCHING_CRITERIA = 1;
const int TradeRequestType_ALL_TRADES = 0;
const char PreviouslyReported_NO = 'N';
const char PreviouslyReported_YES = 'Y';
const char MatchStatus_COMPARED = '0';
const char MatchStatus_UNCOMPARED = '1';
const char MatchStatus_ADVISORY_OR_ALERT = '2';
const char MatchStatus_MISMATCHED = '3';
const char MatchType_A5_EXACT_MATCH_SUMMARIZED_QUANTITY[] = "S5";
const char MatchType_EXACT_MATCH_MINUS_BADGES_TIMES[] = "M1";
const char MatchType_ACTM6_MATCH[] = "M6";
const char MatchType_ACT_DEFAULT_AFTER_M2[] = "M5";
const char MatchType_ACT_ACCEPTED_TRADE[] = "M3";
const char MatchType_A2_EXACT_MATCH_SUMMARIZED_QUANTITY[] = "S2";
const char MatchType_A3_EXACT_MATCH_SUMMARIZED_QUANTITY[] = "S3";
const char MatchType_A4_EXACT_MATCH_SUMMARIZED_QUANTITY[] = "S4";
const char MatchType_SUMMARIZED_MATCH_MINUS_BADGES_TIMES[] = "M2";
const char MatchType_EXACT_MATCH_PLUS4_BADGES[] = "A2";
const char MatchType_EXACT_MATCH_PLUS2_BADGES_EXEC_TIME[] = "A3";
const char MatchType_EXACT_MATCH_PLUS2_BADGES[] = "A4";
const char MatchType_STAMPED_ADVISORIES_OR_SPECIALIST_ACCEPTS[] = "AQ";
const char MatchType_OCS_LOCKED_IN[] = "MT";
const char MatchType_ACT_DEFAULT_TRADE[] = "M4";
const char MatchType_EXACT_MATCH_PLUS4_BADGES_EXEC_TIME[] = "A1";
const char MatchType_A1_EXACT_MATCH_SUMMARIZED_QUANTITY[] = "S1";
const char MatchType_EXACT_MATCH_PLUS_EXEC_TIME[] = "A5";
const char MatchType_ONE_PARTY_PRIVATELY_NEGOTIATED_TRADE_REPORT[] = "60";
const char MatchType_TWO_PARTY_PRIVATELY_NEGOTIATED_TRADE_REPORT[] = "61";
const char MatchType_CONTINUOUS_AUTO_MATCH[] = "62";
const char MatchType_CROSS_AUCTION[] = "5";
const char MatchType_COUNTER_ORDER_SELECTION[] = "6";
const char MatchType_CALL_AUCTION[] = "7";
const char MatchType_ONE_PARTY_TRADE_REPORT[] = "1";
const char MatchType_TWO_PARTY_TRADE_REPORT[] = "2";
const char MatchType_CONFIRMED_TRADE_REPORT[] = "3";
const char MatchType_AUTO_MATCH[] = "4";
const char MatchType_ISSUING[] = "8";
const char MatchType_SYSTEMATIC_INTERNALISER[] = "9";
const char MatchType_AUTO_MATCH_LAST_LOOK[] = "10";
const char MatchType_CROSS_AUCTION_LAST_LOOK[] = "11";
const char OddLot_YES = 'Y';
const char OddLot_NO = 'N';
const int ClearingInstruction_MANUAL_MODE = 8;
const int ClearingInstruction_MULTILATERAL_NETTING = 5;
const int ClearingInstruction_AUTOMATIC_POSTING_MODE = 9;
const int ClearingInstruction_BILATERAL_NETTING_ONLY = 2;
const int ClearingInstruction_CLEAR_AGAINST_CENTRAL_COUNTERPARTY = 6;
const int ClearingInstruction_AUTOMATIC_GIVE_UP_MODE = 10;
const int ClearingInstruction_SPECIAL_TRADE = 4;
const int ClearingInstruction_EX_CLEARING = 3;
const int ClearingInstruction_PROCESS_NORMALLY = 0;
const int ClearingInstruction_EXCLUDE_FROM_CENTRAL_COUNTERPARTY = 7;
const int ClearingInstruction_EXCLUDE_FROM_ALL_NETTING = 1;
const int ClearingInstruction_QUALIFIED_SERVICE_REPRESENTATIVE_QSR = 11;
const int ClearingInstruction_CUSTOMER_TRADE = 12;
const int ClearingInstruction_SELF_CLEARING = 13;
const int ClearingInstruction_BUY_IN = 14;
const int AccountType_HOUSE_TRADER = 3;
const int AccountType_HOUSE_TRADER_CROSS_MARGINED = 7;
const int AccountType_CARRIED_NON_CUSTOMER_SIDE_CROSS_MARGINED = 6;
const int AccountType_FLOOR_TRADER = 4;
const int AccountType_CARRIED_NON_CUSTOMER_SIDE = 2;
const int AccountType_CARRIED_CUSTOMER_SIDE = 1;
const int AccountType_JOINT_BACK_OFFICE_ACCOUNT = 8;
const int AccountType_EQUITIES_SPECIALIST = 9;
const int AccountType_OPTIONS_MARKET_MAKER = 10;
const int AccountType_OPTIONS_FIRM_ACCOUNT = 11;
const int AccountType_ACCOUNT_CUSTOMER_NON_CUSTOMER_ORDERS = 12;
const int AccountType_ACCOUNT_ORDERS_MULTIPLE_CUSTOMERS = 13;
const int CustOrderCapacity_MEMBER_TRADING_FOR_THEIR_OWN_ACCOUNT = 1;
const int CustOrderCapacity_CLEARING_FIRM_TRADING_FOR_ITS_PROPRIETARY_ACCOUNT = 2;
const int CustOrderCapacity_MEMBER_TRADING_FOR_ANOTHER_MEMBER = 3;
const int CustOrderCapacity_ALL_OTHER = 4;
const int CustOrderCapacity_RETAIL_CUSTOMER = 5;
const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_A_SECURITY = 1;
const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_AN_UNDERLYING_SECURITY = 2;
const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_A_PRODUCT = 3;
const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_ACFI_CODE = 4;
const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_A_SECURITY_TYPE = 5;
const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_A_TRADING_SESSION = 6;
const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_A_PARTY_ID = 8;
const int MassStatusReqType_STATUS_FOR_ALL_ORDERS = 7;
const int MassStatusReqType_STATUS_FOR_SECURITY_ISSUER = 9;
const int MassStatusReqType_STATUS_FOR_ISSUER_OF_UNDERLYING_SECURITY = 10;
const char DayBookingInst_AUTO = '0';
const char DayBookingInst_SPEAK_WITH_ORDER_INITIATOR_BEFORE_BOOKING = '1';
const char DayBookingInst_ACCUMULATE = '2';
const char BookingUnit_AGGREGATE_PARTIAL_EXECUTIONS_ON_THIS_ORDER = '1';
const char BookingUnit_AGGREGATE_EXECUTIONS_FOR_THIS_SYMBOL = '2';
const char BookingUnit_EACH_PARTIAL_EXECUTION_IS_A_BOOKABLE_UNIT = '0';
const char PreallocMethod_PRO_RATA = '0';
const char PreallocMethod_DO_NOT_PRO_RATA = '1';
const char TradingSessionSubID_PRE_TRADING[] = "1";
const char TradingSessionSubID_OPENING_OR_OPENING_AUCTION[] = "2";
const char TradingSessionSubID_CONTINUOUS[] = "3";
const char TradingSessionSubID_CLOSING_OR_CLOSING_AUCTION[] = "4";
const char TradingSessionSubID_POST_TRADING[] = "5";
const char TradingSessionSubID_INTRADAY_AUCTION[] = "6";
const char TradingSessionSubID_QUIESCENT[] = "7";
const char TradingSessionSubID_SCHEDULED_INTRADAY_AUCTION[] = "6";
const char TradingSessionSubID_ANY_AUCTION[] = "8";
const char TradingSessionSubID_UNSCHEDULED_INTRADAY_AUCTION[] = "9";
const char TradingSessionSubID_OUT_OF_MAIN_SESSION_TRADING[] = "10";
const char TradingSessionSubID_PRIVATE_AUCTION[] = "11";
const char TradingSessionSubID_PUBLIC_AUCTION[] = "12";
const char TradingSessionSubID_GROUP_AUCTION[] = "13";
const int AllocType_BUYSIDE_READY_TO_BOOK = 6;
const int AllocType_PRELIMINARY = 2;
const int AllocType_SELLSIDE_CALCULATED_USING_PRELIMINARY = 3;
const int AllocType_READY_TO_BOOK = 5;
const int AllocType_CALCULATED = 1;
const int AllocType_SELLSIDE_CALCULATED_WITHOUT_PRELIMINARY = 4;
const int AllocType_WAREHOUSE_INSTRUCTION = 7;
const int AllocType_REQUEST_TO_INTERMEDIARY = 8;
const int AllocType_ACCEPT = 9;
const int AllocType_REJECT = 10;
const int AllocType_ACCEPT_PENDING = 11;
const int AllocType_INCOMPLETE_GROUP = 12;
const int AllocType_COMPLETE_GROUP = 13;
const int AllocType_REVERSAL_PENDING = 14;
const int AllocType_REOPEN_GROUP = 15;
const int AllocType_CANCEL_GROUP = 16;
const int AllocType_GIVEUP = 17;
const int AllocType_TAKEUP = 18;
const int AllocType_REFUSE_TAKEUP = 19;
const int AllocType_INITIATE_REVERSAL = 20;
const int AllocType_REVERSE = 21;
const int AllocType_REFUSE_REVERSAL = 22;
const int AllocType_SUB_ALLOCATION_GIVEUP = 23;
const int AllocType_APPROVE_GIVEUP = 24;
const int AllocType_APPROVE_TAKEUP = 25;
const int AllocType_NOTIONAL_VALUE_AVERAGE_PX_GROUP_ALLOC = 26;
const char ClearingFeeIndicator_FIRMS106_H_AND106_J[] = "H";
const char ClearingFeeIndicator_FIFTH_YEAR_DELEGATE[] = "5";
const char ClearingFeeIndicator_FOURTH_YEAR_DELEGATE[] = "4";
const char ClearingFeeIndicator_THIRD_YEAR_DELEGATE[] = "3";
const char ClearingFeeIndicator_SECOND_YEAR_DELEGATE[] = "2";
const char ClearingFeeIndicator_FIRST_YEAR_DELEGATE[] = "1";
const char ClearingFeeIndicator_ALL_OTHER_OWNERSHIP_TYPES[] = "M";
const char ClearingFeeIndicator_GIM[] = "I";
const char ClearingFeeIndicator_SIXTH_YEAR_DELEGATE[] = "9";
const char ClearingFeeIndicator_FULL_AND_ASSOCIATE_MEMBER[] = "F";
const char ClearingFeeIndicator_EQUITY_MEMBER_AND_CLEARING_MEMBER[] = "E";
const char ClearingFeeIndicator_NON_MEMBER_AND_CUSTOMER[] = "C";
const char ClearingFeeIndicator_CBOE_MEMBER[] = "B";
const char ClearingFeeIndicator_LESSEE106_F_EMPLOYEES[] = "L";
const char WorkingIndicator_NO = 'N';
const char WorkingIndicator_YES = 'Y';
const int PriorityIndicator_PRIORITY_UNCHANGED = 0;
const int PriorityIndicator_LOST_PRIORITY_AS_RESULT_OF_ORDER_CHANGE = 1;
const char LegalConfirm_YES = 'Y';
const char LegalConfirm_NO = 'N';
const int QuoteRequestRejectReason_UNKNOWN_SYMBOL = 1;
const int QuoteRequestRejectReason_EXCHANGE = 2;
const int QuoteRequestRejectReason_QUOTE_REQUEST_EXCEEDS_LIMIT = 3;
const int QuoteRequestRejectReason_TOO_LATE_TO_ENTER = 4;
const int QuoteRequestRejectReason_INVALID_PRICE = 5;
const int QuoteRequestRejectReason_NOT_AUTHORIZED_TO_REQUEST_QUOTE = 6;
const int QuoteRequestRejectReason_NO_MATCH_FOR_INQUIRY = 7;
const int QuoteRequestRejectReason_NO_MARKET_FOR_INSTRUMENT = 8;
const int QuoteRequestRejectReason_NO_INVENTORY = 9;
const int QuoteRequestRejectReason_PASS = 10;
const int QuoteRequestRejectReason_OTHER = 99;
const int QuoteRequestRejectReason_INSUFFICIENT_CREDIT = 11;
const int QuoteRequestRejectReason_EXCEEDED_CLIP_SIZE_LIMIT = 12;
const int QuoteRequestRejectReason_EXCEEDED_MAX_NOTIONAL_ORDER_AMT = 13;
const int QuoteRequestRejectReason_EXCEEDED_DV01_PV01_LIMIT = 14;
const int QuoteRequestRejectReason_EXCEEDED_CS01_LIMIT = 15;
const char SettlType_REGULAR[] = "0";
const char SettlType_CASH[] = "1";
const char SettlType_NEXT_DAY[] = "2";
const char SettlType_T_PLUS2[] = "3";
const char SettlType_T_PLUS3[] = "4";
const char SettlType_T_PLUS4[] = "5";
const char SettlType_FUTURE[] = "6";
const char SettlType_WHEN_AND_IF_ISSUED[] = "7";
const char SettlType_SELLERS_OPTION[] = "8";
const char SettlType_T_PLUS5[] = "9";
const char SettlType_BROKEN_DATE[] = "B";
const char SettlType_FX_SPOT_NEXT_SETTLEMENT[] = "C";
const char OpenCloseSettlFlag_DAILY_OPEN = '0';
const char OpenCloseSettlFlag_SESSION_OPEN = '1';
const char OpenCloseSettlFlag_DELIVERY_SETTLEMENT_ENTRY = '2';
const char OpenCloseSettlFlag_EXPECTED_ENTRY = '3';
const char OpenCloseSettlFlag_ENTRY_FROM_PREVIOUS_BUSINESS_DAY = '4';
const char OpenCloseSettlFlag_THEORETICAL_PRICE_VALUE = '5';
const char BidTradeType_RISK_TRADE = 'R';
const char BidTradeType_VWAP_GUARANTEE = 'G';
const char BidTradeType_AGENCY = 'A';
const char BidTradeType_GUARANTEED_CLOSE = 'J';
const int AcctIDSource_BIC = 1;
const int AcctIDSource_SID_CODE = 2;
const int AcctIDSource_TFM = 3;
const int AcctIDSource_OMGEO = 4;
const int AcctIDSource_DTCC_CODE = 5;
const int AcctIDSource_OTHER = 99;
const int AcctIDSource_SPSAID = 6;
const int ConfirmStatus_RECEIVED = 1;
const int ConfirmStatus_MISMATCHED_ACCOUNT = 2;
const int ConfirmStatus_MISSING_SETTLEMENT_INSTRUCTIONS = 3;
const int ConfirmStatus_CONFIRMED = 4;
const int ConfirmStatus_REQUEST_REJECTED = 5;
const int ConfirmTransType_NEW = 0;
const int ConfirmTransType_REPLACE = 1;
const int ConfirmTransType_CANCEL = 2;
const int DeliveryForm_BOOK_ENTRY = 1;
const int DeliveryForm_BEARER = 2;
const int LegSwapType_PAR_FOR_PAR = 1;
const int LegSwapType_MODIFIED_DURATION = 2;
const int LegSwapType_RISK = 4;
const int LegSwapType_PROCEEDS = 5;
const int QuotePriceType_PERCENT = 1;
const int QuotePriceType_PER_SHARE = 2;
const int QuotePriceType_FIXED_AMOUNT = 3;
const int QuotePriceType_DISCOUNT = 4;
const int QuotePriceType_PREMIUM = 5;
const int QuotePriceType_SPREAD = 6;
const int QuotePriceType_TED_PRICE = 7;
const int QuotePriceType_TED_YIELD = 8;
const int QuotePriceType_YIELD_SPREAD = 9;
const int QuotePriceType_YIELD = 10;
const int QuotePriceType_PRICE_SPREAD = 12;
const int QuotePriceType_PRODUCT_TICKS_IN_HALVES = 13;
const int QuotePriceType_PRODUCT_TICKS_IN_FOURTHS = 14;
const int QuotePriceType_PRODUCT_TICKS_IN_EIGHTHS = 15;
const int QuotePriceType_PRODUCT_TICKS_IN_SIXTEENTHS = 16;
const int QuotePriceType_PRODUCT_TICKS_IN_THIRTY_SECONDS = 17;
const int QuotePriceType_PRODUCT_TICKS_IN_SIXTY_FOURTHS = 18;
const int QuotePriceType_PRODUCT_TICKS_IN_ONE_TWENTY_EIGHTHS = 19;
const int QuotePriceType_NORMAL_RATE_REPRESENTATION = 20;
const int QuotePriceType_INVERSE_RATE_REPRESENTATION = 21;
const int QuotePriceType_BASIS_POINTS = 22;
const int QuotePriceType_UP_FRONT_POINTS = 23;
const int QuotePriceType_INTEREST_RATE = 24;
const int QuotePriceType_PERCENTAGE_OF_NOTIONAL = 25;
const int QuoteRespType_HIT = 1;
const int QuoteRespType_COUNTER = 2;
const int QuoteRespType_EXPIRED = 3;
const int QuoteRespType_COVER = 4;
const int QuoteRespType_DONE_AWAY = 5;
const int QuoteRespType_PASS = 6;
const int QuoteRespType_END_TRADE = 7;
const int QuoteRespType_TIMED_OUT = 8;
const int QuoteRespType_TIED = 9;
const int QuoteRespType_TIED_COVER = 10;
const int QuoteRespType_ACCEPT = 11;
const int QuoteRespType_TERMINATE_CONTRACT = 12;
const char PosType_TRANSACTION_QUANTITY[] = "TQ";
const char PosType_INTRA_SPREAD_QTY[] = "IAS";
const char PosType_INTER_SPREAD_QTY[] = "IES";
const char PosType_END_OF_DAY_QTY[] = "FIN";
const char PosType_START_OF_DAY_QTY[] = "SOD";
const char PosType_OPTION_EXERCISE_QTY[] = "EX";
const char PosType_OPTION_ASSIGNMENT[] = "AS";
const char PosType_TRANSACTION_FROM_EXERCISE[] = "TX";
const char PosType_TRANSACTION_FROM_ASSIGNMENT[] = "TA";
const char PosType_PIT_TRADE_QTY[] = "PIT";
const char PosType_TRANSFER_TRADE_QTY[] = "TRF";
const char PosType_ELECTRONIC_TRADE_QTY[] = "ETR";
const char PosType_ALLOCATION_TRADE_QTY[] = "ALC";
const char PosType_ADJUSTMENT_QTY[] = "PA";
const char PosType_AS_OF_TRADE_QTY[] = "ASF";
const char PosType_DELIVERY_QTY[] = "DLV";
const char PosType_TOTAL_TRANSACTION_QTY[] = "TOT";
const char PosType_CROSS_MARGIN_QTY[] = "XM";
const char PosType_INTEGRAL_SPLIT[] = "SPL";
const char PosType_RECEIVE_QUANTITY[] = "RCV";
const char PosType_CORPORATE_ACTION_ADJUSTMENT[] = "CAA";
const char PosType_DELIVERY_NOTICE_QTY[] = "DN";
const char PosType_EXCHANGE_FOR_PHYSICAL_QTY[] = "EP";
const char PosType_PRIVATELY_NEGOTIATED_TRADE_QTY[] = "PNTN";
const char PosType_NET_DELTA_QTY[] = "DLT";
const char PosType_CREDIT_EVENT_ADJUSTMENT[] = "CEA";
const char PosType_SUCCESSION_EVENT_ADJUSTMENT[] = "SEA";
const char PosType_NET_QTY[] = "NET";
const char PosType_GROSS_QTY[] = "GRS";
const char PosType_INTRADAY_QTY[] = "ITD";
const char PosType_GROSS_LONG_NON_DELTA_ADJUSTED_SWAPTION_POSITION[] = "NDAS";
const char PosType_LONG_DELTA_ADJUSTED_PAIRED_SWAPTION_POSITION[] = "DAS";
const char PosType_EXPIRING_QUANTITY[] = "EXP";
const char PosType_QUANTITY_NOT_EXERCISED[] = "UNEX";
const char PosType_REQUESTED_EXERCISE_QUANTITY[] = "REQ";
const char PosType_CASH_FUTURES_EQUIVALENT_QUANTITY[] = "CFE";
const char PosType_LOAN_OR_BORROWED_QUANTITY[] = "SECLN";
const int PosQtyStatus_SUBMITTED = 0;
const int PosQtyStatus_ACCEPTED = 1;
const int PosQtyStatus_REJECTED = 2;
const char PosAmtType_FINAL_MARK_TO_MARKET_AMOUNT[] = "FMTM";
const char PosAmtType_INCREMENTAL_MARK_TO_MARKET_AMOUNT[] = "IMTM";
const char PosAmtType_TRADE_VARIATION_AMOUNT[] = "TVAR";
const char PosAmtType_START_OF_DAY_MARK_TO_MARKET_AMOUNT[] = "SMTM";
const char PosAmtType_PREMIUM_AMOUNT[] = "PREM";
const char PosAmtType_CASH_RESIDUAL_AMOUNT[] = "CRES";
const char PosAmtType_CASH_AMOUNT[] = "CASH";
const char PosAmtType_VALUE_ADJUSTED_AMOUNT[] = "VADJ";
const char PosAmtType_SETTLEMENT_VALUE[] = "SETL";
const char PosAmtType_INITIAL_TRADE_COUPON_AMOUNT[] = "ICPN";
const char PosAmtType_ACCRUED_COUPON_AMOUNT[] = "ACPN";
const char PosAmtType_COUPON_AMOUNT[] = "CPN";
const char PosAmtType_INCREMENTAL_ACCRUED_COUPON[] = "IACPN";
const char PosAmtType_COLLATERALIZED_MARK_TO_MARKET[] = "CMTM";
const char PosAmtType_INCREMENTAL_COLLATERALIZED_MARK_TO_MARKET[] = "ICMTM";
const char PosAmtType_COMPENSATION_AMOUNT[] = "DLV";
const char PosAmtType_TOTAL_BANKED_AMOUNT[] = "BANK";
const char PosAmtType_TOTAL_COLLATERALIZED_AMOUNT[] = "COLAT";
const char PosAmtType_LONG_PAIRED_SWAP_NOTIONAL_VALUE[] = "LSNV";
const char PosAmtType_SHORT_PAIRED_SWAP_NOTIONAL_VALUE[] = "SSNV";
const char PosAmtType_START_OF_DAY_ACCRUED_COUPON[] = "SACPN";
const char PosAmtType_NET_PRESENT_VALUE[] = "NPV";
const char PosAmtType_START_OF_DAY_NET_PRESENT_VALUE[] = "SNPV";
const char PosAmtType_NET_CASH_FLOW[] = "NCF";
const char PosAmtType_PRESENT_VALUE_OF_FEES[] = "PVFEES";
const char PosAmtType_PRESENT_VALUE_ONE_BASIS_POINTS[] = "PV01";
const char PosAmtType_FIVE_YEAR_EQUIVALENT_NOTIONAL[] = "5YREN";
const char PosAmtType_UNDISCOUNTED_MARK_TO_MARKET[] = "UMTM";
const char PosAmtType_MARK_TO_MODEL[] = "MTD";
const char PosAmtType_MARK_TO_MARKET_VARIANCE[] = "VMTM";
const char PosAmtType_MARK_TO_MODEL_VARIANCE[] = "VMTD";
const char PosAmtType_UPFRONT_PAYMENT[] = "UPFRNT";
const char PosAmtType_END_VALE[] = "ENDV";
const char PosAmtType_OUTSTANDING_MARGIN_LOAN[] = "MGNLN";
const char PosAmtType_LOAN_VALUE[] = "LNVL";
const int PosTransType_EXERCISE = 1;
const int PosTransType_DO_NOT_EXERCISE = 2;
const int PosTransType_POSITION_ADJUSTMENT = 3;
const int PosTransType_POSITION_CHANGE_SUBMISSION = 4;
const int PosTransType_PLEDGE = 5;
const int PosTransType_LARGE_TRADER_SUBMISSION = 6;
const int PosTransType_LARGE_POSITIONS_REPORTING_SUBMISSION = 7;
const int PosTransType_LONG_HOLDINGS = 8;
const int PosTransType_INTERNAL_TRANSFER = 9;
const int PosTransType_TRANSFER_OF_FIRM = 10;
const int PosTransType_EXTERNAL_TRANSFER = 11;
const int PosTransType_CORPORATE_ACTION = 12;
const int PosTransType_NOTIFICATION = 13;
const int PosTransType_POSITION_CREATION = 14;
const int PosTransType_CLOSEOUT = 15;
const int PosTransType_REOPEN = 16;
const int PosMaintAction_NEW = 1;
const int PosMaintAction_REPLACE = 2;
const int PosMaintAction_CANCEL = 3;
const int PosMaintAction_REVERSE = 4;
const char SettlSessID_INTRADAY[] = "ITD";
const char SettlSessID_REGULAR_TRADING_HOURS[] = "RTH";
const char SettlSessID_ELECTRONIC_TRADING_HOURS[] = "ETH";
const char SettlSessID_END_OF_DAY[] = "EOD";
const int AdjustmentType_PROCESS_REQUEST_AS_MARGIN_DISPOSITION = 0;
const int AdjustmentType_DELTA_PLUS = 1;
const int AdjustmentType_DELTA_MINUS = 2;
const int AdjustmentType_FINAL = 3;
const int AdjustmentType_CUSTOMER_SPECIFIC_POSITION = 4;
const int PosMaintStatus_ACCEPTED = 0;
const int PosMaintStatus_ACCEPTED_WITH_WARNINGS = 1;
const int PosMaintStatus_REJECTED = 2;
const int PosMaintStatus_COMPLETED = 3;
const int PosMaintStatus_COMPLETED_WITH_WARNINGS = 4;
const int PosMaintResult_SUCCESSFUL_COMPLETION = 0;
const int PosMaintResult_REJECTED = 1;
const int PosMaintResult_OTHER = 99;
const int PosReqType_POSITIONS = 0;
const int PosReqType_TRADES = 1;
const int PosReqType_EXERCISES = 2;
const int PosReqType_ASSIGNMENTS = 3;
const int PosReqType_SETTLEMENT_ACTIVITY = 4;
const int PosReqType_BACKOUT_MESSAGE = 5;
const int PosReqType_DELTA_POSITIONS = 6;
const int PosReqType_NET_POSITION = 7;
const int PosReqType_LARGE_POSITIONS_REPORTING = 8;
const int PosReqType_EXERCISE_POSITION_REPORTING_SUBMISSION = 9;
const int PosReqType_POSITION_LIMIT_REPORTING_SUBMISSING = 10;
const int ResponseTransportType_INBAND = 0;
const int ResponseTransportType_OUT_OF_BAND = 1;
const int PosReqResult_VALID_REQUEST = 0;
const int PosReqResult_INVALID_OR_UNSUPPORTED_REQUEST = 1;
const int PosReqResult_NO_POSITIONS_FOUND_THAT_MATCH_CRITERIA = 2;
const int PosReqResult_NOT_AUTHORIZED_TO_REQUEST_POSITIONS = 3;
const int PosReqResult_REQUEST_FOR_POSITION_NOT_SUPPORTED = 4;
const int PosReqResult_OTHER = 99;
const int PosReqStatus_COMPLETED = 0;
const int PosReqStatus_COMPLETED_WITH_WARNINGS = 1;
const int PosReqStatus_REJECTED = 2;
const int SettlPriceType_FINAL = 1;
const int SettlPriceType_THEORETICAL = 2;
const char AssignmentMethod_RANDOM = 'R';
const char AssignmentMethod_PRO_RATA = 'P';
const char ExerciseMethod_AUTOMATIC = 'A';
const char ExerciseMethod_MANUAL = 'M';
const int TradeRequestResult_SUCCESSFUL = 0;
const int TradeRequestResult_INVALID_OR_UNKNOWN_INSTRUMENT = 1;
const int TradeRequestResult_INVALID_TYPE_OF_TRADE_REQUESTED = 2;
const int TradeRequestResult_INVALID_PARTIES = 3;
const int TradeRequestResult_INVALID_TRANSPORT_TYPE_REQUESTED = 4;
const int TradeRequestResult_INVALID_DESTINATION_REQUESTED = 5;
const int TradeRequestResult_TRADE_REQUEST_TYPE_NOT_SUPPORTED = 8;
const int TradeRequestResult_NOT_AUTHORIZED = 9;
const int TradeRequestResult_OTHER = 99;
const int TradeRequestStatus_ACCEPTED = 0;
const int TradeRequestStatus_COMPLETED = 1;
const int TradeRequestStatus_REJECTED = 2;
const int TradeReportRejectReason_SUCCESSFUL = 0;
const int TradeReportRejectReason_INVALID_PARTY_ONFORMATION = 1;
const int TradeReportRejectReason_UNKNOWN_INSTRUMENT = 2;
const int TradeReportRejectReason_UNAUTHORIZED_TO_REPORT_TRADES = 3;
const int TradeReportRejectReason_INVALID_TRADE_TYPE = 4;
const int TradeReportRejectReason_OTHER = 99;
const int TradeReportRejectReason_INVALID_PARTY_INFORMATION = 1;
const int TradeReportRejectReason_PRICE_EXCEEDS_CURRENT_PRICE_BAND = 5;
const int TradeReportRejectReason_REFERENCE_PRICE_NOT_AVAILABLE = 6;
const int TradeReportRejectReason_NOTIONAL_VALUE_EXCEEDS_THRESHOLD = 7;
const int SideMultiLegReportingType_SINGLE_SECURITY = 1;
const int SideMultiLegReportingType_INDIVIDUAL_LEG_OF_A_MULTILEG_SECURITY = 2;
const int SideMultiLegReportingType_MULTILEG_SECURITY = 3;
const int TrdRegTimestampType_EXECUTION_TIME = 1;
const int TrdRegTimestampType_TIME_IN = 2;
const int TrdRegTimestampType_TIME_OUT = 3;
const int TrdRegTimestampType_BROKER_RECEIPT = 4;
const int TrdRegTimestampType_BROKER_EXECUTION = 5;
const int TrdRegTimestampType_DESK_RECEIPT = 6;
const int TrdRegTimestampType_SUBMISSION_TO_CLEARING = 7;
const int TrdRegTimestampType_TIME_PRIORITY = 8;
const int TrdRegTimestampType_ORDERBOOK_ENTRY_TIME = 9;
const int TrdRegTimestampType_ORDER_SUBMISSION_TIME = 10;
const int TrdRegTimestampType_PUBLICLY_REPORTED = 11;
const int TrdRegTimestampType_PUBLIC_REPORT_UPDATED = 12;
const int TrdRegTimestampType_NON_PUBLICLY_REPORTED = 13;
const int TrdRegTimestampType_NON_PUBLIC_REPORT_UPDATED = 14;
const int TrdRegTimestampType_SUBMITTED_FOR_CONFIRMATION = 15;
const int TrdRegTimestampType_UPDATED_FOR_CONFIRMATION = 16;
const int TrdRegTimestampType_CONFIRMED = 17;
const int TrdRegTimestampType_UPDATED_FOR_CLEARING = 18;
const int TrdRegTimestampType_CLEARED = 19;
const int TrdRegTimestampType_ALLOCATIONS_SUBMITTED = 20;
const int TrdRegTimestampType_ALLOCATIONS_UPDATED = 21;
const int TrdRegTimestampType_ALLOCATIONS_COMPLETED = 22;
const int TrdRegTimestampType_SUBMITTED_TO_REPOSITORY = 23;
const int TrdRegTimestampType_POST_TRD_CONTNTN_EVNT = 24;
const int TrdRegTimestampType_POST_TRADE_VALUATION = 25;
const int TrdRegTimestampType_PREVIOUS_TIME_PRIORITY = 26;
const int TrdRegTimestampType_IDENTIFIER_ASSIGNED = 27;
const int TrdRegTimestampType_PREVIOUS_IDENTIFIER_ASSIGNED = 28;
const int TrdRegTimestampType_ORDER_CANCELLATION_TIME = 29;
const int TrdRegTimestampType_ORDER_MODIFICATION_TIME = 30;
const int TrdRegTimestampType_ORDER_ROUTING_TIME = 31;
const int TrdRegTimestampType_TRADE_CANCELLATION_TIME = 32;
const int TrdRegTimestampType_TRADE_MODIFICATION_TIME = 33;
const int TrdRegTimestampType_REFERENCE_TIME_FOR_NBBO = 34;
const int ConfirmType_STATUS = 1;
const int ConfirmType_CONFIRMATION = 2;
const int ConfirmType_CONFIRMATION_REQUEST_REJECTED = 3;
const int ConfirmRejReason_MISMATCHED_ACCOUNT = 1;
const int ConfirmRejReason_MISSING_SETTLEMENT_INSTRUCTIONS = 2;
const int ConfirmRejReason_OTHER = 99;
const int ConfirmRejReason_UNKNOWN_OR_MISSING_INDIVIDUAL_ALLOC_ID = 3;
const int ConfirmRejReason_TRANSACTION_NOT_RECOGNIZED = 4;
const int ConfirmRejReason_DUPLICATE_TRANSACTION = 5;
const int ConfirmRejReason_INCORRECT_OR_MISSING_INSTRUMENT = 6;
const int ConfirmRejReason_INCORRECT_OR_MISSING_PRICE = 7;
const int ConfirmRejReason_INCORRECT_OR_MISSING_COMMISSION = 8;
const int ConfirmRejReason_INCORRECT_OR_MISSING_SETTL_DATE = 9;
const int ConfirmRejReason_INCORRECT_OR_MISSING_FUND_ID_OR_FUND_NAME = 10;
const int ConfirmRejReason_INCORRECT_OR_MISSING_QUANTITY = 11;
const int ConfirmRejReason_INCORRECT_OR_MISSING_FEES = 12;
const int ConfirmRejReason_INCORRECT_OR_MISSING_TAX = 13;
const int ConfirmRejReason_INCORRECT_OR_MISSING_PARTY = 14;
const int ConfirmRejReason_INCORRECT_OR_MISSING_SIDE = 15;
const int ConfirmRejReason_INCORRECT_OR_MISSING_NET_MONEY = 16;
const int ConfirmRejReason_INCORRECT_OR_MISSING_TRADE_DATE = 17;
const int ConfirmRejReason_INCORRECT_OR_MISSING_SETTL_CCY_INSTRUCTIONS = 18;
const int ConfirmRejReason_INCORRECT_OR_MISSING_CAPACITY = 19;
const int BookingType_REGULAR_BOOKING = 0;
const int BookingType_CFD = 1;
const int BookingType_TOTAL_RETURN_SWAP = 2;
const int AllocSettlInstType_USE_DEFAULT_INSTRUCTIONS = 0;
const int AllocSettlInstType_DERIVE_FROM_PARAMETERS_PROVIDED = 1;
const int AllocSettlInstType_FULL_DETAILS_PROVIDED = 2;
const int AllocSettlInstType_SSIDBI_DS_PROVIDED = 3;
const int AllocSettlInstType_PHONE_FOR_INSTRUCTIONS = 4;
const char DlvyInstType_SECURITIES = 'S';
const char DlvyInstType_CASH = 'C';
const int TerminationType_OVERNIGHT = 1;
const int TerminationType_TERM = 2;
const int TerminationType_FLEXIBLE = 3;
const int TerminationType_OPEN = 4;
const int SettlInstReqRejCode_UNABLE_TO_PROCESS_REQUEST = 0;
const int SettlInstReqRejCode_UNKNOWN_ACCOUNT = 1;
const int SettlInstReqRejCode_NO_MATCHING_SETTLEMENT_INSTRUCTIONS_FOUND = 2;
const int SettlInstReqRejCode_OTHER = 99;
const int AllocReportType_SELLSIDE_CALCULATED_USING_PRELIMINARY = 3;
const int AllocReportType_SELLSIDE_CALCULATED_WITHOUT_PRELIMINARY = 4;
const int AllocReportType_WAREHOUSE_RECAP = 5;
const int AllocReportType_REQUEST_TO_INTERMEDIARY = 8;
const int AllocReportType_PRELIMINARY_REQUEST_TO_INTERMEDIARY = 2;
const int AllocReportType_ACCEPT = 9;
const int AllocReportType_REJECT = 10;
const int AllocReportType_ACCEPT_PENDING = 11;
const int AllocReportType_COMPLETE = 12;
const int AllocReportType_REVERSE_PENDING = 14;
const int AllocReportType_GIVEUP = 15;
const int AllocReportType_TAKEUP = 16;
const int AllocReportType_REVERSAL = 17;
const int AllocReportType_ALLEGED = 18;
const int AllocReportType_SUB_ALLOCATION_GIVEUP = 19;
const int AllocCancReplaceReason_ORIGINAL_DETAILS_INCOMPLETE = 1;
const int AllocCancReplaceReason_CHANGE_IN_UNDERLYING_ORDER_DETAILS = 2;
const int AllocCancReplaceReason_OTHER = 99;
const int AllocCancReplaceReason_CANCELLED_BY_GIVEUP_FIRM = 3;
const int AllocAccountType_CARRIED_CUSTOMER_SIDE = 1;
const int AllocAccountType_CARRIED_NON_CUSTOMER_SIDE = 2;
const int AllocAccountType_HOUSE_TRADER = 3;
const int AllocAccountType_FLOOR_TRADER = 4;
const int AllocAccountType_CARRIED_NON_CUSTOMER_SIDE_CROSS_MARGINED = 6;
const int AllocAccountType_HOUSE_TRADER_CROSS_MARGINED = 7;
const int AllocAccountType_JOINT_BACK_OFFICE_ACCOUNT = 8;
const int PartySubIDType_FIRM = 1;
const int PartySubIDType_PERSON = 2;
const int PartySubIDType_SYSTEM = 3;
const int PartySubIDType_APPLICATION = 4;
const int PartySubIDType_FULL_LEGAL_NAME_OF_FIRM = 5;
const int PartySubIDType_POSTAL_ADDRESS = 6;
const int PartySubIDType_PHONE_NUMBER = 7;
const int PartySubIDType_EMAIL_ADDRESS = 8;
const int PartySubIDType_CONTACT_NAME = 9;
const int PartySubIDType_SECURITIES_ACCOUNT_NUMBER = 10;
const int PartySubIDType_REGISTRATION_NUMBER = 11;
const int PartySubIDType_REGISTERED_ADDRESS_FOR_CONFIRMATION = 12;
const int PartySubIDType_REGULATORY_STATUS = 13;
const int PartySubIDType_REGISTRATION_NAME = 14;
const int PartySubIDType_CASH_ACCOUNT_NUMBER = 15;
const int PartySubIDType_BIC = 16;
const int PartySubIDType_CSD_PARTICIPANT_MEMBER_CODE = 17;
const int PartySubIDType_REGISTERED_ADDRESS = 18;
const int PartySubIDType_FUND_ACCOUNT_NAME = 19;
const int PartySubIDType_TELEX_NUMBER = 20;
const int PartySubIDType_FAX_NUMBER = 21;
const int PartySubIDType_SECURITIES_ACCOUNT_NAME = 22;
const int PartySubIDType_CASH_ACCOUNT_NAME = 23;
const int PartySubIDType_DEPARTMENT = 24;
const int PartySubIDType_LOCATION_DESK = 25;
const int PartySubIDType_POSITION_ACCOUNT_TYPE = 26;
const int PartySubIDType_SECURITY_LOCATE_ID = 27;
const int PartySubIDType_MARKET_MAKER = 28;
const int PartySubIDType_ELIGIBLE_COUNTERPARTY = 29;
const int PartySubIDType_PROFESSIONAL_CLIENT = 30;
const int PartySubIDType_LOCATION = 31;
const int PartySubIDType_EXECUTION_VENUE = 32;
const int PartySubIDType_CURRENCY_DELIVERY_IDENTIFIER = 33;
const int PartySubIDType_ADDRESS_CITY = 34;
const int PartySubIDType_ADDRESS_STATE_OR_PROVINCE = 35;
const int PartySubIDType_ADDRESS_POSTAL_CODE = 36;
const int PartySubIDType_ADDRESS_STREET = 37;
const int PartySubIDType_ADDRESS_ISO_COUNTRY_CODE = 38;
const int PartySubIDType_ISO_COUNTRY_CODE = 39;
const int PartySubIDType_MARKET_SEGMENT = 40;
const int PartySubIDType_CUSTOMER_ACCOUNT_TYPE = 41;
const int PartySubIDType_OMNIBUS_ACCOUNT = 42;
const int PartySubIDType_FUNDS_SEGREGATION_TYPE = 43;
const int PartySubIDType_GUARANTEE_FUND = 44;
const int PartySubIDType_SWAP_DEALER = 45;
const int PartySubIDType_MAJOR_PARTICIPANT = 46;
const int PartySubIDType_FINANCIAL_ENTITY = 47;
const int PartySubIDType_US_PERSON = 48;
const int PartySubIDType_REPORTING_ENTITY_INDICATOR = 49;
const int PartySubIDType_ELECTED_CLEARING_REQUIREMENT_EXCEPTION = 50;
const int PartySubIDType_BUSINESS_CENTER = 51;
const int PartySubIDType_REFERENCE_TEXT = 52;
const int PartySubIDType_SHORT_MARKING_EXEMPT_ACCOUNT = 53;
const int PartySubIDType_PARENT_FIRM_IDENTIFIER = 54;
const int PartySubIDType_PARENT_FIRM_NAME = 55;
const int PartySubIDType_DEAL_IDENTIFIER = 56;
const int PartySubIDType_SYSTEM_TRADE_ID = 57;
const int PartySubIDType_SYSTEM_TRADE_SUB_ID = 58;
const int PartySubIDType_FCM_CODE = 59;
const int PartySubIDType_DLVRY_TRML_CODE = 60;
const int PartySubIDType_VOLNTY_RPT_ENTITY = 61;
const int PartySubIDType_RPT_OBLIG_JURSDCTN = 62;
const int PartySubIDType_VOLNTY_RPT_JURSDCTN = 63;
const int PartySubIDType_COMPANY_ACTIVITIES = 64;
const int PartySubIDType_EE_AREA_DOMICILED = 65;
const int PartySubIDType_CONTRACT_LINKED = 66;
const int PartySubIDType_CONTRACT_ABOVE = 67;
const int PartySubIDType_VOLNTY_RPT_PTY = 68;
const int PartySubIDType_END_USER = 69;
const int PartySubIDType_LOCATION_OR_JURISDICTION = 70;
const int PartySubIDType_DERIVATIVES_DEALER = 71;
const int PartySubIDType_DOMICILE = 72;
const int PartySubIDType_EXEMPT_FROM_RECOGNITION = 73;
const int PartySubIDType_PAYER = 74;
const int PartySubIDType_RECEIVER = 75;
const int PartySubIDType_SYSTEMATIC_INTERNALISER = 76;
const int PartySubIDType_PUBLISHING_ENTITY_INDICATOR = 77;
const int PartySubIDType_FIRST_NAME = 78;
const int PartySubIDType_SURNAME = 79;
const int PartySubIDType_DATE_OF_BIRTH = 80;
const int PartySubIDType_ORDER_TRANSMITTING_FIRM = 81;
const int PartySubIDType_ORDER_TRANSMITTING_FIRM_BUYER = 82;
const int PartySubIDType_ORDER_TRANSMITTER_SELLER = 83;
const int PartySubIDType_LEGAL_ENTITY_IDENTIFIER = 84;
const int PartySubIDType_SUB_SECTOR_CLASSIFICATION = 85;
const int PartySubIDType_PARTY_SIDE = 86;
const int PartySubIDType_LEGAL_REGISTRATION_COUNTRY = 87;
const int AllocIntermedReqType_PENDING_ACCEPT = 1;
const int AllocIntermedReqType_PENDING_RELEASE = 2;
const int AllocIntermedReqType_PENDING_REVERSAL = 3;
const int AllocIntermedReqType_ACCEPT = 4;
const int AllocIntermedReqType_BLOCK_LEVEL_REJECT = 5;
const int AllocIntermedReqType_ACCOUNT_LEVEL_REJECT = 6;
const int ApplQueueResolution_NO_ACTION_TAKEN = 0;
const int ApplQueueResolution_QUEUE_FLUSHED = 1;
const int ApplQueueResolution_OVERLAY_LAST = 2;
const int ApplQueueResolution_END_SESSION = 3;
const int ApplQueueAction_NO_ACTION_TAKEN = 0;
const int ApplQueueAction_QUEUE_FLUSHED = 1;
const int ApplQueueAction_OVERLAY_LAST = 2;
const int ApplQueueAction_END_SESSION = 3;
const int AvgPxIndicator_NO_AVERAGE_PRICING = 0;
const int AvgPxIndicator_TRADE = 1;
const int AvgPxIndicator_LAST_TRADE = 2;
const int AvgPxIndicator_NOTIONAL_VALUE_AVERAGE_PX_GROUP_TRADE = 3;
const int AvgPxIndicator_AVERAGE_PRICED_TRADE = 4;
const int TradeAllocIndicator_ALLOCATION_NOT_REQUIRED = 0;
const int TradeAllocIndicator_ALLOCATION_REQUIRED = 1;
const int TradeAllocIndicator_USE_ALLOCATION_PROVIDED_WITH_THE_TRADE = 2;
const int TradeAllocIndicator_ALLOCATION_GIVE_UP_EXECUTOR = 3;
const int TradeAllocIndicator_ALLOCATION_FROM_EXECUTOR = 4;
const int TradeAllocIndicator_ALLOCATION_TO_CLAIM_ACCOUNT = 5;
const int TradeAllocIndicator_TRADE_SPLIT = 6;
const int ExpirationCycle_EXPIRE_ON_TRADING_SESSION_CLOSE = 0;
const int ExpirationCycle_EXPIRE_ON_TRADING_SESSION_OPEN = 1;
const int ExpirationCycle_SPECIFIED_EXPIRATION = 2;
const int TrdType_REGULAR_TRADE = 0;
const int TrdType_BLOCK_TRADE = 1;
const int TrdType_EFP = 2;
const int TrdType_TRANSFER = 3;
const int TrdType_LATE_TRADE = 4;
const int TrdType_T_TRADE = 5;
const int TrdType_WEIGHTED_AVERAGE_PRICE_TRADE = 6;
const int TrdType_BUNCHED_TRADE = 7;
const int TrdType_LATE_BUNCHED_TRADE = 8;
const int TrdType_PRIOR_REFERENCE_PRICE_TRADE = 9;
const int TrdType_AFTER_HOURS_TRADE = 10;
const int TrdType_EXCHANGE_FOR_RISK = 11;
const int TrdType_EXCHANGE_FOR_SWAP = 12;
const int TrdType_EXCHANGE_OF_FUTURES_FOR = 13;
const int TrdType_EXCHANGE_OF_OPTIONS_FOR_OPTIONS = 14;
const int TrdType_TRADING_AT_SETTLEMENT = 15;
const int TrdType_ALL_OR_NONE = 16;
const int TrdType_FUTURES_LARGE_ORDER_EXECUTION = 17;
const int TrdType_EXCHANGE_OF_FUTURES_FOR_FUTURES = 18;
const int TrdType_OPTION_INTERIM_TRADE = 19;
const int TrdType_OPTION_CABINET_TRADE = 20;
const int TrdType_PRIVATELY_NEGOTIATED_TRADES = 22;
const int TrdType_SUBSTITUTION_OF_FUTURES_FOR_FORWARDS = 23;
const int TrdType_ERROR_TRADE = 24;
const int TrdType_SPECIAL_CUM_DIVIDEND = 25;
const int TrdType_SPECIAL_EX_DIVIDEND = 26;
const int TrdType_SPECIAL_CUM_COUPON = 27;
const int TrdType_SPECIAL_EX_COUPON = 28;
const int TrdType_CASH_SETTLEMENT = 29;
const int TrdType_SPECIAL_PRICE = 30;
const int TrdType_GUARANTEED_DELIVERY = 31;
const int TrdType_SPECIAL_CUM_RIGHTS = 32;
const int TrdType_SPECIAL_EX_RIGHTS = 33;
const int TrdType_SPECIAL_CUM_CAPITAL_REPAYMENTS = 34;
const int TrdType_SPECIAL_EX_CAPITAL_REPAYMENTS = 35;
const int TrdType_SPECIAL_CUM_BONUS = 36;
const int TrdType_SPECIAL_EX_BONUS = 37;
const int TrdType_LARGE_TRADE = 38;
const int TrdType_WORKED_PRINCIPAL_TRADE = 39;
const int TrdType_BLOCK_TRADES = 40;
const int TrdType_NAME_CHANGE = 41;
const int TrdType_PORTFOLIO_TRANSFER = 42;
const int TrdType_PROROGATION_BUY = 43;
const int TrdType_PROROGATION_SELL = 44;
const int TrdType_OPTION_EXERCISE = 45;
const int TrdType_DELTA_NEUTRAL_TRANSACTION = 46;
const int TrdType_FINANCING_TRANSACTION = 47;
const int TrdType_NON_STANDARD_SETTLEMENT = 48;
const int TrdType_DERIVATIVE_RELATED_TRANSACTION = 49;
const int TrdType_PORTFOLIO_TRADE = 50;
const int TrdType_VOLUME_WEIGHTED_AVERAGE_TRADE = 51;
const int TrdType_EXCHANGE_GRANTED_TRADE = 52;
const int TrdType_REPURCHASE_AGREEMENT = 53;
const int TrdType_OTC = 54;
const int TrdType_EXCHANGE_BASIS_FACILITY = 55;
const int TrdType_OPENING_TRADE = 56;
const int TrdType_NETTED_TRADE = 57;
const int TrdType_BLOCK_SWAP_TRADE = 58;
const int TrdType_CREDIT_EVENT_TRADE = 59;
const int TrdType_SUCCESSION_EVENT_TRADE = 60;
const int TrdType_GIVE_UP_GIVE_IN_TRADE = 61;
const int TrdType_DARK_TRADE = 62;
const int TrdType_TECHNICAL_TRADE = 63;
const int TrdType_BENCHMARK = 64;
const int TrdType_PACKAGE_TRADE = 65;
const int TrdType_ROLL_TRADE = 66;
const int TrdSubType_CMTA = 0;
const int TrdSubType_INTERNAL_TRANSFER_OR_ADJUSTMENT = 1;
const int TrdSubType_EXTERNAL_TRANSFER_OR_TRANSFER_OF_ACCOUNT = 2;
const int TrdSubType_REJECT_FOR_SUBMITTING_SIDE = 3;
const int TrdSubType_ADVISORY_FOR_CONTRA_SIDE = 4;
const int TrdSubType_OFFSET_DUE_TO_AN_ALLOCATION = 5;
const int TrdSubType_ONSET_DUE_TO_AN_ALLOCATION = 6;
const int TrdSubType_DIFFERENTIAL_SPREAD = 7;
const int TrdSubType_IMPLIED_SPREAD_LEG_EXECUTED_AGAINST_AN_OUTRIGHT = 8;
const int TrdSubType_TRANSACTION_FROM_EXERCISE = 9;
const int TrdSubType_TRANSACTION_FROM_ASSIGNMENT = 10;
const int TrdSubType_ACATS = 11;
const int TrdSubType_AI = 14;
const int TrdSubType_B = 15;
const int TrdSubType_K = 16;
const int TrdSubType_LC = 17;
const int TrdSubType_M = 18;
const int TrdSubType_N = 19;
const int TrdSubType_NM = 20;
const int TrdSubType_NR = 21;
const int TrdSubType_P = 22;
const int TrdSubType_PA = 23;
const int TrdSubType_PC = 24;
const int TrdSubType_PN = 25;
const int TrdSubType_R = 26;
const int TrdSubType_RO = 27;
const int TrdSubType_RT = 28;
const int TrdSubType_SW = 29;
const int TrdSubType_T = 30;
const int TrdSubType_WN = 31;
const int TrdSubType_WT = 32;
const int TrdSubType_OFF_HOURS_TRADE = 33;
const int TrdSubType_ON_HOURS_TRADE = 34;
const int TrdSubType_OTC_QUOTE = 35;
const int TrdSubType_CONVERTED_SWAP = 36;
const int TrdSubType_CROSSED_TRADE = 37;
const int TrdSubType_INTERIM_PROTECTED_TRADE = 38;
const int TrdSubType_LARGE_IN_SCALE = 39;
const int TrdSubType_WASH_TRADE = 40;
const int TrdSubType_TRADE_AT_SETTLEMENT = 41;
const int TrdSubType_AUCTION_TRADE = 42;
const int TrdSubType_TRADE_AT_MARKER = 43;
const int TrdSubType_CREDIT_DEFAULT = 44;
const int TrdSubType_CREDIT_RESTRUCTURING = 45;
const int TrdSubType_MERGER = 46;
const int TrdSubType_SPIN_OFF = 47;
const int TrdSubType_MULTILATERAL_COMPRESSION = 48;
const int TrdSubType_BALANCING = 50;
const int TrdSubType_BASIS_TRADE_INDEX_CLOSE = 51;
const int TrdSubType_TRADE_AT_CASH_OPEN = 52;
const int TrdSubType_TRD_SUBMIT_VENUE_CLR_SETTL = 53;
const int TrdSubType_BILATERAL_COMPRESSION = 54;
const int PegMoveType_FLOATING = 0;
const int PegMoveType_FIXED = 1;
const int PegOffsetType_PRICE = 0;
const int PegOffsetType_BASIS_POINTS = 1;
const int PegOffsetType_TICKS = 2;
const int PegOffsetType_PRICE_TIER = 3;
const int PegOffsetType_PERCENTAGE = 4;
const int PegLimitType_OR_BETTER = 0;
const int PegLimitType_STRICT = 1;
const int PegLimitType_OR_WORSE = 2;
const int PegRoundDirection_MORE_AGGRESSIVE = 1;
const int PegRoundDirection_MORE_PASSIVE = 2;
const int PegScope_LOCAL = 1;
const int PegScope_NATIONAL = 2;
const int PegScope_GLOBAL = 3;
const int PegScope_NATIONAL_EXCLUDING_LOCAL = 4;
const int DiscretionMoveType_FLOATING = 0;
const int DiscretionMoveType_FIXED = 1;
const int DiscretionOffsetType_PRICE = 0;
const int DiscretionOffsetType_BASIS_POINTS = 1;
const int DiscretionOffsetType_TICKS = 2;
const int DiscretionOffsetType_PRICE_TIER = 3;
const int DiscretionLimitType_OR_BETTER = 0;
const int DiscretionLimitType_STRICT = 1;
const int DiscretionLimitType_OR_WORSE = 2;
const int DiscretionRoundDirection_MORE_AGGRESSIVE = 1;
const int DiscretionRoundDirection_MORE_PASSIVE = 2;
const int DiscretionScope_LOCAL = 1;
const int DiscretionScope_NATIONAL = 2;
const int DiscretionScope_GLOBAL = 3;
const int DiscretionScope_NATIONAL_EXCLUDING_LOCAL = 4;
const int TargetStrategy_VWAP = 1;
const int TargetStrategy_PARTICIPATE = 2;
const int TargetStrategy_MININIZE_MARKET_IMPACT = 3;
const int LastLiquidityInd_ADDED_LIQUIDITY = 1;
const int LastLiquidityInd_REMOVED_LIQUIDITY = 2;
const int LastLiquidityInd_LIQUIDITY_ROUTED_OUT = 3;
const int LastLiquidityInd_AUCTION = 4;
const int LastLiquidityInd_NEITHER_ADDED_NOR_REMOVED_LIQUIDITY = 0;
const int LastLiquidityInd_TRIGGERED_STOP_ORDER = 5;
const int LastLiquidityInd_TRIGGERED_CONTINGENCY_ORDER = 6;
const int LastLiquidityInd_TRIGGERED_MARKET_ORDER = 7;
const int LastLiquidityInd_REMOVED_LIQUIDITY_AFTER_FIRM_ORDER_COMMITMENT = 8;
const int LastLiquidityInd_AUCTION_EXECUTION_AFTER_FIRM_ORDER_COMMITMENT = 9;
const int LastLiquidityInd_UNKNOWN = 10;
const int LastLiquidityInd_OTHER = 11;
const char PublishTrdIndicator_YES = 'Y';
const char PublishTrdIndicator_NO = 'N';
const int ShortSaleReason_DEALER_SOLD_SHORT = 0;
const int ShortSaleReason_DEALER_SOLD_SHORT_EXEMPT = 1;
const int ShortSaleReason_SELLING_CUSTOMER_SOLD_SHORT = 2;
const int ShortSaleReason_SELLING_CUSTOMER_SOLD_SHORT_EXEMPT = 3;
const int ShortSaleReason_QUALIFIED_SERVICE_REPRESENTATIVE = 4;
const int ShortSaleReason_QSR_OR_AGU_CONTRA_SIDE_SOLD_SHORT_EXEMPT = 5;
const int QtyType_UNITS = 0;
const int QtyType_CONTRACTS = 1;
const int QtyType_UNITS_OF_MEASURE_PER_TIME_UNIT = 2;
const int TradeReportType_SUBMIT = 0;
const int TradeReportType_ALLEGED = 1;
const int TradeReportType_ACCEPT = 2;
const int TradeReportType_DECLINE = 3;
const int TradeReportType_ADDENDUM = 4;
const int TradeReportType_NO = 5;
const int TradeReportType_TRADE_REPORT_CANCEL = 6;
const int TradeReportType_LOCKED_IN = 7;
const int TradeReportType_DEFAULTED = 8;
const int TradeReportType_INVALID_CMTA = 9;
const int TradeReportType_PENDED = 10;
const int TradeReportType_ALLEGED_NEW = 11;
const int TradeReportType_ALLEGED_ADDENDUM = 12;
const int TradeReportType_ALLEGED_NO = 13;
const int TradeReportType_ALLEGED_TRADE_REPORT_CANCEL = 14;
const int TradeReportType_ALLEGED_TRADE_BREAK = 15;
const int TradeReportType_VERIFY = 16;
const int TradeReportType_DISPUTE = 17;
const int TradeReportType_NON_MATERIAL_UPDATE = 18;
const int AllocNoOrdersType_NOT_SPECIFIED = 0;
const int AllocNoOrdersType_EXPLICIT_LIST_PROVIDED = 1;
const int EventType_PUT = 1;
const int EventType_CALL = 2;
const int EventType_TENDER = 3;
const int EventType_SINKING_FUND_CALL = 4;
const int EventType_OTHER = 99;
const int EventType_ACTIVATION = 5;
const int EventType_INACTIVIATION = 6;
const int EventType_LAST_ELIGIBLE_TRADE_DATE = 7;
const int EventType_SWAP_START_DATE = 8;
const int EventType_SWAP_END_DATE = 9;
const int EventType_SWAP_ROLL_DATE = 10;
const int EventType_SWAP_NEXT_START_DATE = 11;
const int EventType_SWAP_NEXT_ROLL_DATE = 12;
const int EventType_FIRST_DELIVERY_DATE = 13;
const int EventType_LAST_DELIVERY_DATE = 14;
const int EventType_INITIAL_INVENTORY_DUE_DATE = 15;
const int EventType_FINAL_INVENTORY_DUE_DATE = 16;
const int EventType_FIRST_INTENT_DATE = 17;
const int EventType_LAST_INTENT_DATE = 18;
const int EventType_POSITION_REMOVAL_DATE = 19;
const int EventType_MINIMUM_NOTICE = 20;
const int EventType_DELIVERY_START_TIME = 21;
const int EventType_DELIVERY_END_TIME = 22;
const int EventType_FIRST_NOTICE_DATE = 23;
const int EventType_LAST_NOTICE_DATE = 24;
const int EventType_FIRST_EXERCISE_DATE = 25;
const int EventType_REDEMPTION_DATE = 26;
const int EventType_TRD_CNTNTN_EFCTV_DT = 27;
const int InstrAttribType_FLAT = 1;
const int InstrAttribType_ZERO_COUPON = 2;
const int InstrAttribType_INTEREST_BEARING = 3;
const int InstrAttribType_NO_PERIODIC_PAYMENTS = 4;
const int InstrAttribType_VARIABLE_RATE = 5;
const int InstrAttribType_LESS_FEE_FOR_PUT = 6;
const int InstrAttribType_STEPPED_COUPON = 7;
const int InstrAttribType_COUPON_PERIOD = 8;
const int InstrAttribType_WHEN = 9;
const int InstrAttribType_ORIGINAL_ISSUE_DISCOUNT = 10;
const int InstrAttribType_CALLABLE = 11;
const int InstrAttribType_ESCROWED_TO_MATURITY = 12;
const int InstrAttribType_ESCROWED_TO_REDEMPTION_DATE = 13;
const int InstrAttribType_PRE_REFUNDED = 14;
const int InstrAttribType_IN_DEFAULT = 15;
const int InstrAttribType_UNRATED = 16;
const int InstrAttribType_TAXABLE = 17;
const int InstrAttribType_INDEXED = 18;
const int InstrAttribType_SUBJECT_TO_ALTERNATIVE_MINIMUM_TAX = 19;
const int InstrAttribType_ORIGINAL_ISSUE_DISCOUNT_PRICE = 20;
const int InstrAttribType_CALLABLE_BELOW_MATURITY_VALUE = 21;
const int InstrAttribType_CALLABLE_WITHOUT_NOTICE = 22;
const int InstrAttribType_TEXT = 99;
const int InstrAttribType_PRICE_TICK_RULES_FOR_SECURITY = 23;
const int InstrAttribType_TRADE_TYPE_ELIGIBILITY_DETAILS_FOR_SECURITY = 24;
const int InstrAttribType_INSTRUMENT_DENOMINATOR = 25;
const int InstrAttribType_INSTRUMENT_NUMERATOR = 26;
const int InstrAttribType_INSTRUMENT_PRICE_PRECISION = 27;
const int InstrAttribType_INSTRUMENT_STRIKE_PRICE = 28;
const int InstrAttribType_TRADEABLE_INDICATOR = 29;
const int InstrAttribType_INSTRUMENT_ELIGIBLE_ANON_ORDERS = 30;
const int InstrAttribType_MIN_GUARANTEED_FILL_VOLUME = 31;
const int InstrAttribType_MIN_GUARANTEED_FILL_STATUS = 32;
const int InstrAttribType_TRADE_AT_SETTLEMENT_ELIGIBILITY = 33;
const int InstrAttribType_TEST_INSTRUMENT = 34;
const int InstrAttribType_DUMMY_INSTRUMENT = 35;
const int InstrAttribType_NEGATIVE_SETTLEMENT_PRICE_ELIGIBILITY = 36;
const int InstrAttribType_NEGATIVE_STRIKE_PRICE_ELIGIBILITY = 37;
const int InstrAttribType_US_STD_CONTRACT_IND = 38;
const int InstrAttribType_ADMITTED_TO_TRADING_ON_TRADING_VENUE = 39;
const int InstrAttribType_AVERAGE_DAILY_NOTIONAL_AMOUNT = 40;
const int InstrAttribType_AVERAGE_DAILY_NUMBER_TRADES = 41;
const int CPProgram_PROGRAM3A3 = 1;
const int CPProgram_PROGRAM42 = 2;
const int CPProgram_OTHER = 99;
const int CPProgram_PROGRAM3A2 = 3;
const int CPProgram_PROGRAM3A3_AND3C7 = 4;
const int CPProgram_PROGRAM3A4 = 5;
const int CPProgram_PROGRAM3A5 = 6;
const int CPProgram_PROGRAM3A7 = 7;
const int CPProgram_PROGRAM3C7 = 8;
const int MiscFeeBasis_ABSOLUTE = 0;
const int MiscFeeBasis_PER_UNIT = 1;
const int MiscFeeBasis_PERCENTAGE = 2;
const char LastFragment_YES = 'Y';
const char LastFragment_NO = 'N';
const int CollAsgnReason_INITIAL = 0;
const int CollAsgnReason_SCHEDULED = 1;
const int CollAsgnReason_TIME_WARNING = 2;
const int CollAsgnReason_MARGIN_DEFICIENCY = 3;
const int CollAsgnReason_MARGIN_EXCESS = 4;
const int CollAsgnReason_FORWARD_COLLATERAL_DEMAND = 5;
const int CollAsgnReason_EVENT_OF_DEFAULT = 6;
const int CollAsgnReason_ADVERSE_TAX_EVENT = 7;
const int CollAsgnReason_TRANSFER_DEPOSIT = 8;
const int CollAsgnReason_TRANSFER_WITHDRAWAL = 9;
const int CollAsgnReason_PLEDGE = 10;
const int CollInquiryQualifier_TRADE_DATE = 0;
const int CollInquiryQualifier_GC_INSTRUMENT = 1;
const int CollInquiryQualifier_COLLATERAL_INSTRUMENT = 2;
const int CollInquiryQualifier_SUBSTITUTION_ELIGIBLE = 3;
const int CollInquiryQualifier_NOT_ASSIGNED = 4;
const int CollInquiryQualifier_PARTIALLY_ASSIGNED = 5;
const int CollInquiryQualifier_FULLY_ASSIGNED = 6;
const int CollInquiryQualifier_OUTSTANDING_TRADES = 7;
const int CollAsgnTransType_NEW = 0;
const int CollAsgnTransType_REPLACE = 1;
const int CollAsgnTransType_CANCEL = 2;
const int CollAsgnTransType_RELEASE = 3;
const int CollAsgnTransType_REVERSE = 4;
const int CollAsgnRespType_RECEIVED = 0;
const int CollAsgnRespType_ACCEPTED = 1;
const int CollAsgnRespType_DECLINED = 2;
const int CollAsgnRespType_REJECTED = 3;
const int CollAsgnRespType_TRANSACTION_PENDING = 4;
const int CollAsgnRespType_TRANSACTION_COMPLETED_WITH_WARNING = 5;
const int CollAsgnRejectReason_UNKNOWN_DEAL = 0;
const int CollAsgnRejectReason_UNKNOWN_OR_INVALID_INSTRUMENT = 1;
const int CollAsgnRejectReason_UNAUTHORIZED_TRANSACTION = 2;
const int CollAsgnRejectReason_INSUFFICIENT_COLLATERAL = 3;
const int CollAsgnRejectReason_INVALID_TYPE_OF_COLLATERAL = 4;
const int CollAsgnRejectReason_EXCESSIVE_SUBSTITUTION = 5;
const int CollAsgnRejectReason_OTHER = 99;
const int CollStatus_UNASSIGNED = 0;
const int CollStatus_PARTIALLY_ASSIGNED = 1;
const int CollStatus_ASSIGNMENT_PROPOSED = 2;
const int CollStatus_ASSIGNED = 3;
const int CollStatus_CHALLENGED = 4;
const int CollStatus_REUSED = 5;
const char LastRptRequested_NO = 'N';
const char LastRptRequested_YES = 'Y';
const int DeliveryType_VERSUS_PAYMENT = 0;
const int DeliveryType_FREE = 1;
const int DeliveryType_TRI_PARTY = 2;
const int DeliveryType_HOLD_IN_CUSTODY = 3;
const int DeliveryType_DELIVER_BY_VALUE = 4;
const int UserRequestType_LOG_ON_USER = 1;
const int UserRequestType_LOG_OFF_USER = 2;
const int UserRequestType_CHANGE_PASSWORD_FOR_USER = 3;
const int UserRequestType_REQUEST_INDIVIDUAL_USER_STATUS = 4;
const int UserRequestType_REQUEST_THROTTLE_LIMIT = 5;
const int UserStatus_LOGGED_IN = 1;
const int UserStatus_NOT_LOGGED_IN = 2;
const int UserStatus_USER_NOT_RECOGNISED = 3;
const int UserStatus_PASSWORD_INCORRECT = 4;
const int UserStatus_PASSWORD_CHANGED = 5;
const int UserStatus_OTHER = 6;
const int UserStatus_FORCED_USER_LOGOUT_BY_EXCHANGE = 7;
const int UserStatus_SESSION_SHUTDOWN_WARNING = 8;
const int UserStatus_THROTTLE_PARAMETERS_CHANGED = 9;
const int StatusValue_CONNECTED = 1;
const int StatusValue_NOT_CONNECTED_UNEXPECTED = 2;
const int StatusValue_NOT_CONNECTED_EXPECTED = 3;
const int StatusValue_IN_PROCESS = 4;
const int NetworkRequestType_SNAPSHOT = 1;
const int NetworkRequestType_SUBSCRIBE = 2;
const int NetworkRequestType_STOP_SUBSCRIBING = 4;
const int NetworkRequestType_LEVEL_OF_DETAIL = 8;
const int NetworkStatusResponseType_FULL = 1;
const int NetworkStatusResponseType_INCREMENTAL_UPDATE = 2;
const int TrdRptStatus_ACCEPTED = 0;
const int TrdRptStatus_REJECTED = 1;
const int TrdRptStatus_ACCEPTED_WITH_ERRORS = 3;
const int TrdRptStatus_CANCELLED = 2;
const int TrdRptStatus_PENDING_NEW = 4;
const int TrdRptStatus_PENDING_CANCEL = 5;
const int TrdRptStatus_PENDING_REPLACE = 6;
const int TrdRptStatus_TERMINATED = 7;
const int TrdRptStatus_PENDING_VERIFICATION = 8;
const int TrdRptStatus_DEEMED_VERIFIED = 9;
const int TrdRptStatus_VERIFIED = 10;
const int TrdRptStatus_DISPUTED = 11;
const int AffirmStatus_RECEIVED = 1;
const int AffirmStatus_CONFIRM_REJECTED = 2;
const int AffirmStatus_AFFIRMED = 3;
const int CollAction_RETAIN = 0;
const int CollAction_ADD = 1;
const int CollAction_REMOVE = 2;
const int CollInquiryStatus_ACCEPTED = 0;
const int CollInquiryStatus_ACCEPTED_WITH_WARNINGS = 1;
const int CollInquiryStatus_COMPLETED = 2;
const int CollInquiryStatus_COMPLETED_WITH_WARNINGS = 3;
const int CollInquiryStatus_REJECTED = 4;
const int CollInquiryResult_SUCCESSFUL = 0;
const int CollInquiryResult_INVALID_OR_UNKNOWN_INSTRUMENT = 1;
const int CollInquiryResult_INVALID_OR_UNKNOWN_COLLATERAL_TYPE = 2;
const int CollInquiryResult_INVALID_PARTIES = 3;
const int CollInquiryResult_INVALID_TRANSPORT_TYPE_REQUESTED = 4;
const int CollInquiryResult_INVALID_DESTINATION_REQUESTED = 5;
const int CollInquiryResult_NO_COLLATERAL_FOUND_FOR_THE_TRADE_SPECIFIED = 6;
const int CollInquiryResult_NO_COLLATERAL_FOUND_FOR_THE_ORDER_SPECIFIED = 7;
const int CollInquiryResult_COLLATERAL_INQUIRY_TYPE_NOT_SUPPORTED = 8;
const int CollInquiryResult_UNAUTHORIZED_FOR_COLLATERAL_INQUIRY = 9;
const int CollInquiryResult_OTHER = 99;
const int StrategyParameterType_INT = 1;
const int StrategyParameterType_LENGTH = 2;
const int StrategyParameterType_NUM_IN_GROUP = 3;
const int StrategyParameterType_SEQ_NUM = 4;
const int StrategyParameterType_TAG_NUM = 5;
const int StrategyParameterType_FLOAT = 6;
const int StrategyParameterType_QTY = 7;
const int StrategyParameterType_PRICE = 8;
const int StrategyParameterType_PRICE_OFFSET = 9;
const int StrategyParameterType_AMT = 10;
const int StrategyParameterType_PERCENTAGE = 11;
const int StrategyParameterType_CHAR = 12;
const int StrategyParameterType_BOOLEAN = 13;
const int StrategyParameterType_STRING = 14;
const int StrategyParameterType_MULTIPLE_CHAR_VALUE = 15;
const int StrategyParameterType_CURRENCY = 16;
const int StrategyParameterType_EXCHANGE = 17;
const int StrategyParameterType_MONTH_YEAR = 18;
const int StrategyParameterType_UTC_TIMESTAMP = 19;
const int StrategyParameterType_UTC_TIME_ONLY = 20;
const int StrategyParameterType_LOCAL_MKT_DATE = 21;
const int StrategyParameterType_UTC_DATE_ONLY = 22;
const int StrategyParameterType_DATA = 23;
const int StrategyParameterType_MULTIPLE_STRING_VALUE = 24;
const int StrategyParameterType_COUNTRY = 25;
const int StrategyParameterType_LANGUAGE = 26;
const int StrategyParameterType_TZ_TIME_ONLY = 27;
const int StrategyParameterType_TZ_TIMESTAMP = 28;
const int StrategyParameterType_TENOR = 29;
const char SecurityStatus_ACTIVE[] = "1";
const char SecurityStatus_INACTIVE[] = "2";
const char SecurityStatus_ACTIVE_CLOSING_ORDERS_ONLY[] = "3";
const char SecurityStatus_EXPIRED[] = "4";
const char SecurityStatus_DELISTED[] = "5";
const char SecurityStatus_KNOCKED_OUT[] = "6";
const char SecurityStatus_KNOCK_OUT_REVOKED[] = "7";
const char SecurityStatus_PENDING_EXPIRY[] = "8";
const char SecurityStatus_SUSPENDED[] = "9";
const char SecurityStatus_PUBLISHED[] = "10";
const char SecurityStatus_PENDING_DELETION[] = "11";
const char UnderlyingCashType_FIXED[] = "FIXED";
const char UnderlyingCashType_DIFF[] = "DIFF";
const int UnderlyingSettlementType_T_PLUS1 = 2;
const int UnderlyingSettlementType_T_PLUS3 = 4;
const int UnderlyingSettlementType_T_PLUS4 = 5;
const char SecurityUpdateAction_ADD = 'A';
const char SecurityUpdateAction_DELETE = 'D';
const char SecurityUpdateAction_MODIFY = 'M';
const int ExpType_AUTO_EXERCISE = 1;
const int ExpType_NON_AUTO_EXERCISE = 2;
const int ExpType_FINAL_WILL_BE_EXERCISED = 3;
const int ExpType_CONTRARY_INTENTION = 4;
const int ExpType_DIFFERENCE = 5;
const int IndividualAllocType_SUB_ALLOCATE = 1;
const int IndividualAllocType_THIRD_PARTY_ALLOCATION = 2;
const char UnitofMeasure_BARRELS[] = "Bbl";
const char UnitofMeasure_BILLION_CUBIC_FEET[] = "Bcf";
const char UnitofMeasure_BUSHELS[] = "Bu";
const char UnitofMeasure_POUNDS[] = "lbs";
const char UnitofMeasure_GALLONS[] = "Gal";
const char UnitofMeasure_MILLION_BARRELS[] = "MMbbl";
const char UnitofMeasure_ONE_MILLION_BTU[] = "MMBtu";
const char UnitofMeasure_MEGAWATT_HOURS[] = "MWh";
const char UnitofMeasure_TROY_OUNCES[] = "oz_tr";
const char UnitofMeasure_METRIC_TONS[] = "t";
const char UnitofMeasure_TONS[] = "tn";
const char UnitofMeasure_US_DOLLARS[] = "USD";
const char TimeUnit_HOUR[] = "H";
const char TimeUnit_MINUTE[] = "Min";
const char TimeUnit_SECOND[] = "S";
const char TimeUnit_DAY[] = "D";
const char TimeUnit_WEEK[] = "Wk";
const char TimeUnit_MONTH[] = "Mo";
const char TimeUnit_YEAR[] = "Yr";
const char TimeUnit_QUARTER[] = "Q";
const int AllocMethod_AUTOMATIC = 1;
const int AllocMethod_GUARANTOR = 2;
const int AllocMethod_MANUAL = 3;
const int AllocMethod_BROKER_ASSIGNED = 4;
const char AsOfIndicator_FALSE = '0';
const char AsOfIndicator_TRUE = '1';
const int MDBookType_TOP_OF_BOOK = 1;
const int MDBookType_PRICE_DEPTH = 2;
const int MDBookType_ORDER_DEPTH = 3;
const int MDOriginType_BOOK = 0;
const int MDOriginType_OFF_BOOK = 1;
const int MDOriginType_CROSS = 2;
const int MDOriginType_QUOTE_DRIVEN_MARKET = 3;
const int MDOriginType_DARK_ORDER_BOOK = 4;
const int MDOriginType_AUCTION_DRIVEN_MARKET = 5;
const int MDOriginType_QUOTE_NEGOTIATION = 6;
const int MDOriginType_VOICE_NEGOTIATION = 7;
const int MDOriginType_HYBRID_MARKET = 8;
const char CustOrderHandlingInst_ADD_ON_ORDER[] = "ADD";
const char CustOrderHandlingInst_ALL_OR_NONE[] = "AON";
const char CustOrderHandlingInst_CASH_NOT_HELD[] = "CNH";
const char CustOrderHandlingInst_DIRECTED_ORDER[] = "DIR";
const char CustOrderHandlingInst_EXCHANGE_FOR_PHYSICAL_TRANSACTION[] = "E.W";
const char CustOrderHandlingInst_FILL_OR_KILL[] = "FOK";
const char CustOrderHandlingInst_IMBALANCE_ONLY[] = "IO";
const char CustOrderHandlingInst_IMMEDIATE_OR_CANCEL[] = "IOC";
const char CustOrderHandlingInst_LIMIT_ON_OPEN[] = "LOO";
const char CustOrderHandlingInst_LIMIT_ON_CLOSE[] = "LOC";
const char CustOrderHandlingInst_MARKET_AT_OPEN[] = "MAO";
const char CustOrderHandlingInst_MARKET_AT_CLOSE[] = "MAC";
const char CustOrderHandlingInst_MARKET_ON_OPEN[] = "MOO";
const char CustOrderHandlingInst_MARKET_ON_CLOSE[] = "MOC";
const char CustOrderHandlingInst_MINIMUM_QUANTITY[] = "MQT";
const char CustOrderHandlingInst_NOT_HELD[] = "NH";
const char CustOrderHandlingInst_OVER_THE_DAY[] = "OVD";
const char CustOrderHandlingInst_PEGGED[] = "PEG";
const char CustOrderHandlingInst_RESERVE_SIZE_ORDER[] = "RSV";
const char CustOrderHandlingInst_STOP_STOCK_TRANSACTION[] = "S.W";
const char CustOrderHandlingInst_SCALE[] = "SCL";
const char CustOrderHandlingInst_TIME_ORDER[] = "TMO";
const char CustOrderHandlingInst_TRAILING_STOP[] = "TS";
const char CustOrderHandlingInst_WORK[] = "WRK";
const char CustOrderHandlingInst_PHONE_SIMPLE[] = "A";
const char CustOrderHandlingInst_PHONE_COMPLEX[] = "B";
const char CustOrderHandlingInst_FCM_PROVIDED_SCREEN[] = "C";
const char CustOrderHandlingInst_OTHER_PROVIDED_SCREEN[] = "D";
const char CustOrderHandlingInst_CLIENT_PROVIDED_PLATFORM_CONTROLLED_BY_FCM[] = "E";
const char CustOrderHandlingInst_CLIENT_PROVIDED_PLATFORM_DIRECT_TO_EXCHANGE[] = "F";
const char CustOrderHandlingInst_ALGO_ENGINE[] = "H";
const char CustOrderHandlingInst_PRICE_AT_EXECUTION[] = "J";
const char CustOrderHandlingInst_DESK_ELECTRONIC[] = "W";
const char CustOrderHandlingInst_DESK_PIT[] = "X";
const char CustOrderHandlingInst_CLIENT_ELECTRONIC[] = "Y";
const char CustOrderHandlingInst_CLIENT_PIT[] = "Z";
const char CustOrderHandlingInst_CONDITIONAL_ORDER[] = "CND";
const char CustOrderHandlingInst_DELIVERY_INSTRUCTIONS_CASH[] = "CSH";
const char CustOrderHandlingInst_DISCRETIONARY_LIMIT_ORDER[] = "DLO";
const char CustOrderHandlingInst_INTRA_DAY_CROSS[] = "IDX";
const char CustOrderHandlingInst_INTERMARKET_SWEEP_ORDER[] = "ISO";
const char CustOrderHandlingInst_MERGER_RELATED_TRANSFER_POSITION[] = "MPT";
const char CustOrderHandlingInst_MARKET_TO_LIMIT[] = "MTL";
const char CustOrderHandlingInst_DELIVERY_INSTRUCTIONS_NEXT_DAY[] = "ND";
const char CustOrderHandlingInst_OPTIONS_RELATED_TRANSACTION[] = "OPT";
const char CustOrderHandlingInst_DELIVERY_INSTRUCTIONS_SELLERS_OPTION[] = "SLR";
const char CustOrderHandlingInst_STAY_ON_OFFERSIDE[] = "F0";
const char CustOrderHandlingInst_GO_ALONG[] = "F3";
const char CustOrderHandlingInst_PARTICIPATE_DO_NOT_INITIATE[] = "F6";
const char CustOrderHandlingInst_STRICT_SCALE[] = "F7";
const char CustOrderHandlingInst_TRY_TO_SCALE[] = "F8";
const char CustOrderHandlingInst_STAY_ON_BIDSIDE[] = "F9";
const char CustOrderHandlingInst_NO_CROSS[] = "FA";
const char CustOrderHandlingInst_OK_TO_CROSS[] = "FB";
const char CustOrderHandlingInst_CALL_FIRST[] = "FC";
const char CustOrderHandlingInst_PERCENT_OF_VOLUME[] = "FD";
const char CustOrderHandlingInst_REINSTATE_ON_SYSTEM_FAILURE[] = "FH";
const char CustOrderHandlingInst_INSTITUTION_ONLY[] = "FI";
const char CustOrderHandlingInst_REINSTATE_ON_TRADING_HALT[] = "FJ";
const char CustOrderHandlingInst_CANCEL_ON_TRADING_HALF[] = "FK";
const char CustOrderHandlingInst_LAST_PEG[] = "FL";
const char CustOrderHandlingInst_MID_PRICE_PEG[] = "FM";
const char CustOrderHandlingInst_NON_NEGOTIABLE[] = "FN";
const char CustOrderHandlingInst_OPENING_PEG[] = "FO";
const char CustOrderHandlingInst_MARKET_PEG[] = "FP";
const char CustOrderHandlingInst_CANCEL_ON_SYSTEM_FAILURE[] = "FQ";
const char CustOrderHandlingInst_PRIMARY_PEG[] = "FR";
const char CustOrderHandlingInst_SUSPEND[] = "FS";
const char CustOrderHandlingInst_FIXED_PEG_TO_LOCAL_BBO[] = "FT";
const char CustOrderHandlingInst_PEG_TO_VWAP[] = "FW";
const char CustOrderHandlingInst_TRADE_ALONG[] = "FX";
const char CustOrderHandlingInst_TRY_TO_STOP[] = "FY";
const char CustOrderHandlingInst_CANCEL_IF_NOT_BEST[] = "FZ";
const char CustOrderHandlingInst_STRICT_LIMIT[] = "Fb";
const char CustOrderHandlingInst_IGNORE_PRICE_VALIDITY_CHECKS[] = "Fc";
const char CustOrderHandlingInst_PEG_TO_LIMIT_PRICE[] = "Fd";
const char CustOrderHandlingInst_WORK_TO_TARGET_STRATEGY[] = "Fe";
const char CustOrderHandlingInst_G_ORDER_AND_FCMAP_IOR_FIX[] = "G";
const int OrderHandlingInstSource_NASDOATS = 1;
const int OrderHandlingInstSource_FINRAOATS = 1;
const int OrderHandlingInstSource_FIA_EXECUTION_SOURCE_CODE = 2;
const char DeskType_AGENCY[] = "A";
const char DeskType_ARBITRAGE[] = "AR";
const char DeskType_DERIVATIVES[] = "D";
const char DeskType_INTERNATIONAL[] = "IN";
const char DeskType_INSTITUTIONAL[] = "IS";
const char DeskType_OTHER[] = "O";
const char DeskType_PREFERRED_TRADING[] = "PF";
const char DeskType_PROPRIETARY[] = "PR";
const char DeskType_PROGRAM_TRADING[] = "PT";
const char DeskType_SALES[] = "S";
const char DeskType_TRADING[] = "T";
const char DeskType_BLOCK_TRADING[] = "B";
const char DeskType_CONVERTIBLE_DESK[] = "C";
const char DeskType_CENTRAL_RISK_BOOKS[] = "CR";
const char DeskType_EQUITY_CAPITAL_MARKETS[] = "EC";
const char DeskType_SWAPS[] = "SW";
const char DeskType_TRADING_DESK_SYSTEM[] = "T";
const char DeskType_TREASURY[] = "TR";
const char DeskType_FLOOR_BROKER[] = "FB";
const int DeskTypeSource_NASDOATS = 1;
const int DeskTypeSource_FINRAOATS = 1;
const char DeskOrderHandlingInst_ADD_ON_ORDER[] = "ADD";
const char DeskOrderHandlingInst_ALL_OR_NONE[] = "AON";
const char DeskOrderHandlingInst_CASH_NOT_HELD[] = "CNH";
const char DeskOrderHandlingInst_DIRECTED_ORDER[] = "DIR";
const char DeskOrderHandlingInst_EXCHANGE_FOR_PHYSICAL_TRANSACTION[] = "E.W";
const char DeskOrderHandlingInst_FILL_OR_KILL[] = "FOK";
const char DeskOrderHandlingInst_IMBALANCE_ONLY[] = "IO";
const char DeskOrderHandlingInst_IMMEDIATE_OR_CANCEL[] = "IOC";
const char DeskOrderHandlingInst_LIMIT_ON_OPEN[] = "LOO";
const char DeskOrderHandlingInst_LIMIT_ON_CLOSE[] = "LOC";
const char DeskOrderHandlingInst_MARKET_AT_OPEN[] = "MAO";
const char DeskOrderHandlingInst_MARKET_AT_CLOSE[] = "MAC";
const char DeskOrderHandlingInst_MARKET_ON_OPEN[] = "MOO";
const char DeskOrderHandlingInst_MARKET_ON_CLOSE[] = "MOC";
const char DeskOrderHandlingInst_MINIMUM_QUANTITY[] = "MQT";
const char DeskOrderHandlingInst_NOT_HELD[] = "NH";
const char DeskOrderHandlingInst_OVER_THE_DAY[] = "OVD";
const char DeskOrderHandlingInst_PEGGED[] = "PEG";
const char DeskOrderHandlingInst_RESERVE_SIZE_ORDER[] = "RSV";
const char DeskOrderHandlingInst_STOP_STOCK_TRANSACTION[] = "S.W";
const char DeskOrderHandlingInst_SCALE[] = "SCL";
const char DeskOrderHandlingInst_TIME_ORDER[] = "TMO";
const char DeskOrderHandlingInst_TRAILING_STOP[] = "TS";
const char DeskOrderHandlingInst_WORK[] = "WRK";
const char ExecAckStatus_RECEIVED = '0';
const char ExecAckStatus_ACCEPTED = '1';
const char ExecAckStatus_DON = '2';
const char ExecAckStatus_DONT_KNOW = '2';
const int CollApplType_SPECIFIC_DEPOSIT = 0;
const int CollApplType_GENERAL = 1;
const char UnderlyingFXRateCalc_DIVIDE = 'D';
const char UnderlyingFXRateCalc_MULTIPLY = 'M';
const char AllocPositionEffect_OPEN = 'O';
const char AllocPositionEffect_CLOSE = 'C';
const char AllocPositionEffect_ROLLED = 'R';
const char AllocPositionEffect_FIFO = 'F';
const char DealingCapacity_AGENT = 'A';
const char DealingCapacity_PRINCIPAL = 'P';
const char DealingCapacity_RISKLESS_PRINCIPAL = 'R';
const char InstrmtAssignmentMethod_RANDOM = 'R';
const char InstrmtAssignmentMethod_PRO_RATA = 'P';
const char AggressorIndicator_YES = 'Y';
const char AggressorIndicator_NO = 'N';
const int MDQuoteType_INDICATIVE = 0;
const int MDQuoteType_TRADEABLE = 1;
const int MDQuoteType_RESTRICTED_TRADEABLE = 2;
const int MDQuoteType_COUNTER = 3;
const int MDQuoteType_INDICATIVE_AND_TRADEABLE = 4;
const char RefOrderIDSource_SECONDARY_ORDER_ID = '0';
const char RefOrderIDSource_ORDER_ID = '1';
const char RefOrderIDSource_MD_ENTRY_ID = '2';
const char RefOrderIDSource_QUOTE_ENTRY_ID = '3';
const char RefOrderIDSource_ORIGINAL_ORDER_ID = '4';
const char RefOrderIDSource_QUOTE_ID = '5';
const char RefOrderIDSource_QUOTE_REQ_ID = '6';
const char RefOrderIDSource_PREVIOUS_ORDER_IDENTIFIER = '7';
const char RefOrderIDSource_PREVIOUS_QUOTE_IDENTIFIER = '8';
const char RefOrderIDSource_PARENT_ORDER_IDENTIFIER = '9';
const char RefOrderIDSource_MANUAL_ORDER_IDENTIFIER = 'A';
const char DisplayWhen_IMMEDIATE = '1';
const char DisplayWhen_EXHAUST = '2';
const char DisplayMethod_INITIAL = '1';
const char DisplayMethod_NEW = '2';
const char DisplayMethod_RANDOM = '3';
const char DisplayMethod_UNDISCLOSED = '4';
const char PriceProtectionScope_NONE = '0';
const char PriceProtectionScope_LOCAL = '1';
const char PriceProtectionScope_NATIONAL = '2';
const char PriceProtectionScope_GLOBAL = '3';
const char LotType_ODD_LOT = '1';
const char LotType_ROUND_LOT = '2';
const char LotType_BLOCK_LOT = '3';
const char LotType_ROUND_LOT_BASED_UPON = '4';
const int PegPriceType_LAST_PEG = 1;
const int PegPriceType_MID_PRICE_PEG = 2;
const int PegPriceType_OPENING_PEG = 3;
const int PegPriceType_MARKET_PEG = 4;
const int PegPriceType_PRIMARY_PEG = 5;
const int PegPriceType_FIXED_PEG_TO_LOCAL_BEST_BID_OR_OFFER_AT_TIME_OF_ORDER = 6;
const int PegPriceType_PEG_TO_VWAP = 7;
const int PegPriceType_TRAILING_STOP_PEG = 8;
const int PegPriceType_PEG_TO_LIMIT_PRICE = 9;
const int PegPriceType_SHORT_SALE_MIN_PRICE_PEG = 10;
const char TriggerType_PARTIAL_EXECUTION = '1';
const char TriggerType_SPECIFIED_TRADING_SESSION = '2';
const char TriggerType_NEXT_AUCTION = '3';
const char TriggerType_PRICE_MOVEMENT = '4';
const char TriggerType_ON_ORDER_ENTRY_OR_MODIFICATION = '5';
const char TriggerAction_ACTIVATE = '1';
const char TriggerAction_MODIFY = '2';
const char TriggerAction_CANCEL = '3';
const char TriggerPriceType_BEST_OFFER = '1';
const char TriggerPriceType_LAST_TRADE = '2';
const char TriggerPriceType_BEST_BID = '3';
const char TriggerPriceType_BEST_BID_OR_LAST_TRADE = '4';
const char TriggerPriceType_BEST_OFFER_OR_LAST_TRADE = '5';
const char TriggerPriceType_BEST_MID = '6';
const char TriggerPriceTypeScope_NONE = '0';
const char TriggerPriceTypeScope_LOCAL = '1';
const char TriggerPriceTypeScope_NATIONAL = '2';
const char TriggerPriceTypeScope_GLOBAL = '3';
const char TriggerPriceDirection_UP = 'U';
const char TriggerPriceDirection_DOWN = 'D';
const char TriggerOrderType_MARKET = '1';
const char TriggerOrderType_LIMIT = '2';
const char OrderCategory_ORDER = '1';
const char OrderCategory_QUOTE = '2';
const char OrderCategory_PRIVATELY_NEGOTIATED_TRADE = '3';
const char OrderCategory_MULTILEG_ORDER = '4';
const char OrderCategory_LINKED_ORDER = '5';
const char OrderCategory_QUOTE_REQUEST = '6';
const char OrderCategory_IMPLIED_ORDER = '7';
const char OrderCategory_CROSS_ORDER = '8';
const char OrderCategory_STREAMING_PRICE = '9';
const char OrderCategory_INTERNAL_CROSS_ORDER = 'A';
const char TradeHandlingInstr_TRADE_CONFIRMATION = '0';
const char TradeHandlingInstr_TWO_PARTY_REPORT = '1';
const char TradeHandlingInstr_ONE_PARTY_REPORT_FOR_MATCHING = '2';
const char TradeHandlingInstr_ONE_PARTY_REPORT_FOR_PASS_THROUGH = '3';
const char TradeHandlingInstr_AUTOMATED_FLOOR_ORDER_ROUTING = '4';
const char TradeHandlingInstr_TWO_PARTY_REPORT_FOR_CLAIM = '5';
const char TradeHandlingInstr_ONE_PARTY_REPORT = '6';
const char TradeHandlingInstr_THIRD_PTY_RPT_FOR_PASS_THROUGH = '7';
const char TradeHandlingInstr_ONE_PARTY_REPORT_AUTO_MATCH = '8';
const char ExDestinationIDSource_BIC = 'B';
const char ExDestinationIDSource_GENERAL_IDENTIFIER = 'C';
const char ExDestinationIDSource_PROPRIETARY = 'D';
const char ExDestinationIDSource_ISO_COUNTRY_CODE = 'E';
const char ExDestinationIDSource_MIC = 'G';
const int ExpirationQtyType_AUTO_EXERCISE = 1;
const int ExpirationQtyType_NON_AUTO_EXERCISE = 2;
const int ExpirationQtyType_FINAL_WILL_BE_EXERCISED = 3;
const int ExpirationQtyType_CONTRARY_INTENTION = 4;
const int ExpirationQtyType_DIFFERENCE = 5;
const char UnitOfMeasure_BILLION_CUBIC_FEET[] = "Bcf";
const char UnitOfMeasure_MILLION_BARRELS[] = "MMbbl";
const char UnitOfMeasure_ONE_MILLION_BTU[] = "MMBtu";
const char UnitOfMeasure_MEGAWATT_HOURS[] = "MWh";
const char UnitOfMeasure_BARRELS[] = "Bbl";
const char UnitOfMeasure_BUSHELS[] = "Bu";
const char UnitOfMeasure_POUNDS[] = "lbs";
const char UnitOfMeasure_GALLONS[] = "Gal";
const char UnitOfMeasure_TROY_OUNCES[] = "oz_tr";
const char UnitOfMeasure_METRIC_TONS[] = "t";
const char UnitOfMeasure_TONS[] = "tn";
const char UnitOfMeasure_US_DOLLARS[] = "USD";
const char UnitOfMeasure_CUBIC_METERS[] = "CBM";
const char UnitOfMeasure_GIGAJOULES[] = "GJ";
const char UnitOfMeasure_HEAT_RATE[] = "kHR";
const char UnitOfMeasure_KILOWATT_HOURS[] = "kWh";
const char UnitOfMeasure_MEGA_HEAT_RATE[] = "MHR";
const char UnitOfMeasure_THERMS[] = "thm";
const char UnitOfMeasure_TONS_OF_CARBON_DIOXIDE[] = "tnCO2";
const char UnitOfMeasure_ALLOWANCES[] = "Alw";
const char UnitOfMeasure_BOARD_FEET[] = "BDFT";
const char UnitOfMeasure_CURRENCY[] = "Ccy";
const char UnitOfMeasure_COOLING_DEGREE_DAY[] = "CDD";
const char UnitOfMeasure_CERTIFIED_EMISSIONS_REDUCTION[] = "CER";
const char UnitOfMeasure_CRITICAL_PRECIP_DAY[] = "CPD";
const char UnitOfMeasure_CLIMATE_RESERVE_TONNES[] = "CRT";
const char UnitOfMeasure_HUNDREDWEIGHT[] = "cwt";
const char UnitOfMeasure_DAY[] = "day";
const char UnitOfMeasure_DRY_METRIC_TONS[] = "dt";
const char UnitOfMeasure_ENV_ALLWNC_CERT[] = "EnvAllwnc";
const char UnitOfMeasure_ENVIRONMENTAL_CREDIT[] = "EnvCrd";
const char UnitOfMeasure_ENVIRONMENTAL_OFFSET[] = "EnvOfst";
const char UnitOfMeasure_GRAMS[] = "g";
const char UnitOfMeasure_GROSS_TONS[] = "GT";
const char UnitOfMeasure_HEATING_DEGREE_DAY[] = "HDD";
const char UnitOfMeasure_INDEX_POINT[] = "IPNT";
const char UnitOfMeasure_KILOGRAMS[] = "kg";
const char UnitOfMeasure_KILOLITERS[] = "kL";
const char UnitOfMeasure_KILOWATT_YEAR[] = "kW-a";
const char UnitOfMeasure_KILOWATT_DAY[] = "kW-d";
const char UnitOfMeasure_KILOWATT_HOUR[] = "kW-h";
const char UnitOfMeasure_KILOWATT_MONTH[] = "kW-M";
const char UnitOfMeasure_KILOWATT_MINUTE[] = "kW-min";
const char UnitOfMeasure_LITERS[] = "L";
const char UnitOfMeasure_MEGAWATT_YEAR[] = "MW-a";
const char UnitOfMeasure_MEGAWATT_DAY[] = "MW-d";
const char UnitOfMeasure_MEGAWATT_HOUR[] = "MW-h";
const char UnitOfMeasure_MEGAWATT_MONTH[] = "MW-M";
const char UnitOfMeasure_MEGAWATT_MINUTE[] = "MW-min";
const char UnitOfMeasure_PRINCIPAL_WITH_RELATION_TO_DEBT_INSTRUMENT[] = "PRINC";
const char UnitOfMeasure_ARE[] = "a";
const char UnitOfMeasure_ACRE[] = "ac";
const char UnitOfMeasure_CENTILITER[] = "cL";
const char UnitOfMeasure_CENTIMETER[] = "cM";
const char UnitOfMeasure_DIESEL_GALLON_EQUIVALENT[] = "DGE";
const char UnitOfMeasure_FOOT[] = "ft";
const char UnitOfMeasure_GB_GALLON[] = "Gal_gb";
const char UnitOfMeasure_GASOLINE_GALLON_EQUIVALENT[] = "GGE";
const char UnitOfMeasure_HECTARE[] = "ha";
const char UnitOfMeasure_INCH[] = "in";
const char UnitOfMeasure_KILOMETER[] = "kM";
const char UnitOfMeasure_METER[] = "M";
const char UnitOfMeasure_MILE[] = "mi";
const char UnitOfMeasure_MILLILITER[] = "mL";
const char UnitOfMeasure_MILLIMETER[] = "mM";
const char UnitOfMeasure_US_OUNCE[] = "oz";
const char UnitOfMeasure_PIECE[] = "pc";
const char UnitOfMeasure_US_PINT[] = "pt";
const char UnitOfMeasure_GB_PINT[] = "pt_gb";
const char UnitOfMeasure_US_QUART[] = "qt";
const char UnitOfMeasure_GB_QUART[] = "qt_gb";
const char UnitOfMeasure_SQUARE_CENTIMETER[] = "SqcM";
const char UnitOfMeasure_SQUARE_FOOT[] = "Sqft";
const char UnitOfMeasure_SQUARE_INCH[] = "Sqin";
const char UnitOfMeasure_SQUARE_KILOMETER[] = "SqkM";
const char UnitOfMeasure_SQUARE_METER[] = "SqM";
const char UnitOfMeasure_SQUARE_MILE[] = "Sqmi";
const char UnitOfMeasure_SQUARE_MILLIMETER[] = "SqmM";
const char UnitOfMeasure_SQUARE_YARD[] = "Sqyd";
const char UnitOfMeasure_YARD[] = "yd";
const int ImpliedMarketIndicator_NOT_IMPLIED = 0;
const int ImpliedMarketIndicator_IMPLIED_IN = 1;
const int ImpliedMarketIndicator_IMPLIED_OUT = 2;
const int ImpliedMarketIndicator_BOTH_IMPLIED_IN_AND_IMPLIED_OUT = 3;
const int SettlObligMode_PRELIMINARY = 1;
const int SettlObligMode_FINAL = 2;
const char SettlObligTransType_CANCEL = 'C';
const char SettlObligTransType_NEW = 'N';
const char SettlObligTransType_REPLACE = 'R';
const char SettlObligTransType_RESTATE = 'T';
const char SettlObligSource_INSTRUCTIONS_OF_BROKER = '1';
const char SettlObligSource_INSTRUCTIONS_FOR_INSTITUTION = '2';
const char SettlObligSource_INVESTOR = '3';
const char SettlObligSource_BUYERS_SETTLEMENT_INSTRUCTIONS = '4';
const char SettlObligSource_SELLERS_SETTLEMENT_INSTRUCTIONS = '5';
const int QuoteEntryStatus_ACCEPTED = 0;
const int QuoteEntryStatus_REJECTED = 5;
const int QuoteEntryStatus_REMOVED_FROM_MARKET = 6;
const int QuoteEntryStatus_EXPIRED = 7;
const int QuoteEntryStatus_LOCKED_MARKET_WARNING = 12;
const int QuoteEntryStatus_CROSS_MARKET_WARNING = 13;
const int QuoteEntryStatus_CANCELED_DUE_TO_LOCK_MARKET = 14;
const int QuoteEntryStatus_CANCELED_DUE_TO_CROSS_MARKET = 15;
const int QuoteEntryStatus_ACTIVE = 16;
const char PrivateQuote_YES = 'Y';
const char PrivateQuote_NO = 'N';
const int RespondentType_ALL_MARKET_PARTICIPANTS = 1;
const int RespondentType_SPECIFIED_MARKET_PARTICIPANTS = 2;
const int RespondentType_ALL_MARKET_MAKERS = 3;
const int RespondentType_PRIMARY_MARKET_MAKER = 4;
const int SecurityTradingEvent_ORDER_IMBALANCE = 1;
const int SecurityTradingEvent_TRADING_RESUMES = 2;
const int SecurityTradingEvent_PRICE_VOLATILITY_INTERRUPTION = 3;
const int SecurityTradingEvent_CHANGE_OF_TRADING_SESSION = 4;
const int SecurityTradingEvent_CHANGE_OF_TRADING_SUBSESSION = 5;
const int SecurityTradingEvent_CHANGE_OF_SECURITY_TRADING_STATUS = 6;
const int SecurityTradingEvent_CHANGE_OF_BOOK_TYPE = 7;
const int SecurityTradingEvent_CHANGE_OF_MARKET_DEPTH = 8;
const int SecurityTradingEvent_CORPORATE_ACTION = 9;
const int StatsType_EXCHANGE_LAST = 1;
const int StatsType_HIGH = 2;
const int StatsType_AVERAGE_PRICE = 3;
const int StatsType_TURNOVER = 4;
const int MDSecSizeType_CUSTOMER = 1;
const int MDSecSizeType_CUSTOMER_PROFESSIONAL = 2;
const int MDSecSizeType_DO_NOT_TRADE_THROUGH = 3;
const char SettlMethod_CASH_SETTLEMENT_REQUIRED[] = "C";
const char SettlMethod_PHYSICAL_SETTLEMENT_REQUIRED[] = "P";
const char SettlMethod_ELECTION[] = "E";
const int ExerciseStyle_EUROPEAN = 0;
const int ExerciseStyle_AMERICAN = 1;
const int ExerciseStyle_BERMUDA = 2;
const int ExerciseStyle_OTHER = 99;
const char PriceQuoteMethod_STANDARD[] = "STD";
const char PriceQuoteMethod_INDEX[] = "INX";
const char PriceQuoteMethod_INTEREST_RATE_INDEX[] = "INT";
const char PriceQuoteMethod_PERCENT_OF_PAR[] = "PCTPAR";
const char FuturesValuationMethod_PREMIUM_STYLE[] = "EQTY";
const char FuturesValuationMethod_FUTURES_STYLE_MARK_TO_MARKET[] = "FUT";
const char FuturesValuationMethod_FUTURES_STYLE_WITH_AN_ATTACHED_CASH_ADJUSTMENT[] = "FUTDA";
const int ListMethod_PRE_LISTED_ONLY = 0;
const int ListMethod_USER_REQUESTED = 1;
const int TickRuleType_REGULAR = 0;
const int TickRuleType_VARIABLE = 1;
const int TickRuleType_FIXED = 2;
const int TickRuleType_TRADED_AS_A_SPREAD_LEG = 3;
const int TickRuleType_SETTLED_AS_A_SPREAD_LEG = 4;
const int TickRuleType_REGULAR_TRADING = 0;
const int TickRuleType_VARIABLE_CABINET = 1;
const int TickRuleType_FIXED_CABINET = 2;
const int TickRuleType_TRADED_AS_SPREAD = 5;
const int MaturityMonthYearIncrementUnits_MONTHS = 0;
const int MaturityMonthYearIncrementUnits_DAYS = 1;
const int MaturityMonthYearIncrementUnits_WEEKS = 2;
const int MaturityMonthYearIncrementUnits_YEARS = 3;
const int MaturityMonthYearFormat_YEAR_MONTH_ONLY = 0;
const int MaturityMonthYearFormat_YEAR_MONTH_DAY = 1;
const int MaturityMonthYearFormat_YEAR_MONTH_WEEK = 2;
const int PriceLimitType_PRICE = 0;
const int PriceLimitType_TICKS = 1;
const int PriceLimitType_PERCENTAGE = 2;
const char ListUpdateAction_ADD = 'A';
const char ListUpdateAction_DELETE = 'D';
const char ListUpdateAction_MODIFY = 'M';
const char ListUpdateAction_SNAPSHOT = 'S';
const char MarketUpdateAction_ADD = 'A';
const char MarketUpdateAction_DELETE = 'D';
const char MarketUpdateAction_MODIFY = 'M';
const int TradSesEvent_TRADING_RESUMES = 0;
const int TradSesEvent_CHANGE_OF_TRADING_SESSION = 1;
const int TradSesEvent_CHANGE_OF_TRADING_SUBSESSION = 2;
const int TradSesEvent_CHANGE_OF_TRADING_STATUS = 3;
const int MassActionType_SUSPEND_ORDERS = 1;
const int MassActionType_RELEASE_ORDERS_FROM_SUSPENSION = 2;
const int MassActionType_CANCEL_ORDERS = 3;
const int MassActionScope_ALL_ORDERS_FOR_A_SECURITY = 1;
const int MassActionScope_ALL_ORDERS_FOR_AN_UNDERLYING_SECURITY = 2;
const int MassActionScope_ALL_ORDERS_FOR_A_PRODUCT = 3;
const int MassActionScope_ALL_ORDERS_FOR_ACFI_CODE = 4;
const int MassActionScope_ALL_ORDERS_FOR_A_SECURITY_TYPE = 5;
const int MassActionScope_ALL_ORDERS_FOR_A_TRADING_SESSION = 6;
const int MassActionScope_ALL_ORDERS = 7;
const int MassActionScope_ALL_ORDERS_FOR_A_MARKET = 8;
const int MassActionScope_ALL_ORDERS_FOR_A_MARKET_SEGMENT = 9;
const int MassActionScope_ALL_ORDERS_FOR_A_SECURITY_GROUP = 10;
const int MassActionScope_CANCEL_FOR_SECURITY_ISSUER = 11;
const int MassActionScope_CANCEL_FOR_ISSUER_OF_UNDERLYING_SECURITY = 12;
const int MassActionResponse_REJECTED = 0;
const int MassActionResponse_ACCEPTED = 1;
const int MassActionResponse_COMPLETED = 2;
const int MassActionRejectReason_MASS_ACTION_NOT_SUPPORTED = 0;
const int MassActionRejectReason_INVALID_OR_UNKNOWN_SECURITY = 1;
const int MassActionRejectReason_INVALID_OR_UNKNOWN_UNDERLYING_SECURITY = 2;
const int MassActionRejectReason_INVALID_OR_UNKNOWN_PRODUCT = 3;
const int MassActionRejectReason_INVALID_OR_UNKNOWN_CFI_CODE = 4;
const int MassActionRejectReason_INVALID_OR_UNKNOWN_SECURITY_TYPE = 5;
const int MassActionRejectReason_INVALID_OR_UNKNOWN_TRADING_SESSION = 6;
const int MassActionRejectReason_INVALID_OR_UNKNOWN_MARKET = 7;
const int MassActionRejectReason_INVALID_OR_UNKNOWN_MARKET_SEGMENT = 8;
const int MassActionRejectReason_INVALID_OR_UNKNOWN_SECURITY_GROUP = 9;
const int MassActionRejectReason_OTHER = 99;
const int MassActionRejectReason_INVALID_OR_UNKNOWN_SECURITY_ISSUER = 10;
const int MassActionRejectReason_INVALID_OR_UNKNOWN_ISSUER_OF_UNDERLYING_SECURITY = 11;
const int MultilegModel_PREDEFINED_MULTILEG_SECURITY = 0;
const int MultilegModel_USER_DEFINED_MULTILEG_SECURITY = 1;
const int MultilegModel_USER_DEFINED = 2;
const int MultilegPriceMethod_NET_PRICE = 0;
const int MultilegPriceMethod_REVERSED_NET_PRICE = 1;
const int MultilegPriceMethod_YIELD_DIFFERENCE = 2;
const int MultilegPriceMethod_INDIVIDUAL = 3;
const int MultilegPriceMethod_CONTRACT_WEIGHTED_AVERAGE_PRICE = 4;
const int MultilegPriceMethod_MULTIPLIED_PRICE = 5;
const int ContingencyType_ONE_CANCELS_THE_OTHER = 1;
const int ContingencyType_ONE_TRIGGERS_THE_OTHER = 2;
const int ContingencyType_ONE_UPDATES_THE_OTHER_ABSOLUTE = 3;
const int ContingencyType_ONE_UPDATES_THE_OTHER_PROPORTIONAL = 4;
const int ContingencyType_BID_AND_OFFER = 5;
const int ContingencyType_BID_AND_OFFER_OCO = 6;
const int ListRejectReason_BROKER_CREDIT = 0;
const int ListRejectReason_EXCHANGE_CLOSED = 2;
const int ListRejectReason_TOO_LATE_TO_ENTER = 4;
const int ListRejectReason_UNKNOWN_ORDER = 5;
const int ListRejectReason_DUPLICATE_ORDER = 6;
const int ListRejectReason_UNSUPPORTED_ORDER_CHARACTERISTIC = 11;
const int ListRejectReason_OTHER = 99;
const int TradePublishIndicator_DO_NOT_PUBLISH_TRADE = 0;
const int TradePublishIndicator_PUBLISH_TRADE = 1;
const int TradePublishIndicator_DEFERRED_PUBLICATION = 2;
const int TradePublishIndicator_PUBLISHED = 3;
const int ApplReqType_RETRANSMISSION = 0;
const int ApplReqType_SUBSCRIPTION = 1;
const int ApplReqType_REQUEST_LAST_SEQ_NUM = 2;
const int ApplReqType_REQUEST_APPLICATIONS = 3;
const int ApplReqType_UNSUBSCRIBE = 4;
const int ApplReqType_CANCEL_RETRANSMISSION = 5;
const int ApplReqType_CANCEL_RETRANSMISSION_UNSUBSCRIBE = 6;
const int ApplResponseType_REQUEST_SUCCESSFULLY_PROCESSED = 0;
const int ApplResponseType_APPLICATION_DOES_NOT_EXIST = 1;
const int ApplResponseType_MESSAGES_NOT_AVAILABLE = 2;
const int ApplResponseError_APPLICATION_DOES_NOT_EXIST = 0;
const int ApplResponseError_MESSAGES_REQUESTED_ARE_NOT_AVAILABLE = 1;
const int ApplResponseError_USER_NOT_AUTHORIZED_FOR_APPLICATION = 2;
const int ApplReportType_APPL_SEQ_NUM_RESET = 0;
const int ApplReportType_LAST_MESSAGE_SENT = 1;
const int ApplReportType_APPLICATION_ALIVE = 2;
const int ApplReportType_RESEND_COMPLETE = 3;
const int HaltReasonInt_NEWS_DISSEMINATION = 0;
const int HaltReasonInt_ORDER_INFLUX = 1;
const int HaltReasonInt_ORDER_IMBALANCE = 2;
const int HaltReasonInt_ADDITIONAL_INFORMATION = 3;
const int HaltReasonInt_NEWS_PENDING = 4;
const int HaltReasonInt_EQUIPMENT_CHANGEOVER = 5;
const char ValuationMethod_PREMIUM_STYLE[] = "EQTY";
const char ValuationMethod_FUTURES_STYLE_MARK_TO_MARKET[] = "FUT";
const char ValuationMethod_FUTURES_STYLE_WITH_AN_ATTACHED_CASH_ADJUSTMENT[] = "FUTDA";
const char ValuationMethod_CDS_STYLE_COLLATERALIZATION[] = "CDS";
const char ValuationMethod_CDS_IN_DELIVERY_USE_RECOVERY_RATE_TO_CALCULATE[] = "CDSD";
const int OrderDelayUnit_SECONDS = 0;
const int OrderDelayUnit_TENTHS_OF_A_SECOND = 1;
const int OrderDelayUnit_HUNDREDTHS_OF_A_SECOND = 2;
const int OrderDelayUnit_MILLISECONDS = 3;
const int OrderDelayUnit_MICROSECONDS = 4;
const int OrderDelayUnit_NANOSECONDS = 5;
const int OrderDelayUnit_MINUTES = 10;
const int OrderDelayUnit_HOURS = 11;
const int OrderDelayUnit_DAYS = 12;
const int OrderDelayUnit_WEEKS = 13;
const int OrderDelayUnit_MONTHS = 14;
const int OrderDelayUnit_YEARS = 15;
const char VenueType_ELECTRONIC = 'E';
const char VenueType_PIT = 'P';
const char VenueType_EX_PIT = 'X';
const char VenueType_CLEARING_HOUSE = 'C';
const char VenueType_REGISTERED_MARKET = 'R';
const char VenueType_OFF_MARKET = 'O';
const char VenueType_CENTRAL_LIMIT_ORDER_BOOK = 'B';
const char VenueType_QUOTE_DRIVEN_MARKET = 'Q';
const char VenueType_DARK_ORDER_BOOK = 'D';
const char VenueType_AUCTION_DRIVEN_MARKET = 'A';
const char VenueType_QUOTE_NEGOTIATION = 'N';
const char VenueType_VOICE_NEGOTIATION = 'V';
const char VenueType_HYBRID_MARKET = 'H';
const char VenueType_OTHER_MARKET = 'z';
const int RefOrdIDReason_GTC_FROM_PREVIOUS_DAY = 0;
const int RefOrdIDReason_PARTIAL_FILL_REMAINING = 1;
const int RefOrdIDReason_ORDER_CHANGED = 2;
const int OrigCustOrderCapacity_MEMBER_TRADING_FOR_THEIR_OWN_ACCOUNT = 1;
const int OrigCustOrderCapacity_CLEARING_FIRM_TRADING_FOR_ITS_PROPRIETARY_ACCOUNT = 2;
const int OrigCustOrderCapacity_MEMBER_TRADING_FOR_ANOTHER_MEMBER = 3;
const int OrigCustOrderCapacity_ALL_OTHER = 4;
const int ModelType_UTILITY_PROVIDED_STANDARD_MODEL = 0;
const int ModelType_PROPRIETARY_MODEL = 1;
const int ContractMultiplierUnit_SHARES = 0;
const int ContractMultiplierUnit_HOURS = 1;
const int ContractMultiplierUnit_DAYS = 2;
const int FlowScheduleType_NERC_EASTERN_OFF_PEAK = 0;
const int FlowScheduleType_NERC_WESTERN_OFF_PEAK = 1;
const int FlowScheduleType_NERC_CALENDAR_ALL_DAYS_IN_MONTH = 2;
const int FlowScheduleType_NERC_EASTERN_PEAK = 3;
const int FlowScheduleType_NERC_WESTERN_PEAK = 4;
const int FlowScheduleType_ALL_TIMES = 5;
const int FlowScheduleType_ON_PEAK = 6;
const int FlowScheduleType_OFF_PEAK = 7;
const int FlowScheduleType_BASE = 8;
const int FlowScheduleType_BLOCK = 9;
const int FlowScheduleType_OTHER = 99;
const int RateSource_BLOOMBERG = 0;
const int RateSource_REUTERS = 1;
const int RateSource_TELERATE = 2;
const int RateSource_ISDA_RATE_OPTION = 3;
const int RateSource_OTHER = 99;
const int RateSourceType_PRIMARY = 0;
const int RateSourceType_SECONDARY = 1;
const char RestructuringType_FULL_RESTRUCTURING[] = "FR";
const char RestructuringType_MODIFIED_RESTRUCTURING[] = "MR";
const char RestructuringType_MODIFIED_MOD_RESTRUCTURING[] = "MM";
const char RestructuringType_NO_RESTRUCTURING_SPECIFIED[] = "XR";
const char Seniority_SENIOR_SECURED[] = "SD";
const char Seniority_SENIOR[] = "SR";
const char Seniority_SUBORDINATED[] = "SB";
const char Seniority_JUNIOR[] = "JR";
const char Seniority_MEZZANINE[] = "MZ";
const char Seniority_SENIOR_NON_PREFERRED[] = "SN";
const int SecurityListType_INDUSTRY_CLASSIFICATION = 1;
const int SecurityListType_TRADING_LIST = 2;
const int SecurityListType_MARKET = 3;
const int SecurityListType_NEWSPAPER_LIST = 4;
const int SecurityListTypeSource_ICB = 1;
const int SecurityListTypeSource_NAICS = 2;
const int SecurityListTypeSource_GICS = 3;
const int NewsCategory_COMPANY_NEWS = 0;
const int NewsCategory_MARKETPLACE_NEWS = 1;
const int NewsCategory_FINANCIAL_MARKET_NEWS = 2;
const int NewsCategory_TECHNICAL_NEWS = 3;
const int NewsCategory_OTHER_NEWS = 99;
const int NewsRefType_REPLACEMENT = 0;
const int NewsRefType_OTHER_LANGUAGE = 1;
const int NewsRefType_COMPLIMENTARY = 2;
const int NewsRefType_WITHDRAWAL = 3;
const int StrikePriceDeterminationMethod_FIXED_STRIKE = 1;
const int StrikePriceDeterminationMethod_STRIKE_SET_AT_EXPIRATION = 2;
const int StrikePriceDeterminationMethod_STRIKE_SET_TO_AVERAGE_ACROSS_LIFE = 3;
const int StrikePriceDeterminationMethod_STRIKE_SET_TO_OPTIMAL_VALUE = 4;
const int StrikePriceBoundaryMethod_LESS_THAN = 1;
const int StrikePriceBoundaryMethod_LESS_THAN_OR_EQUAL = 2;
const int StrikePriceBoundaryMethod_EQUAL = 3;
const int StrikePriceBoundaryMethod_GREATER_THAN_OR_EQUAL = 4;
const int StrikePriceBoundaryMethod_GREATER_THAN = 5;
const int UnderlyingPriceDeterminationMethod_REGULAR = 1;
const int UnderlyingPriceDeterminationMethod_SPECIAL_REFERENCE = 2;
const int UnderlyingPriceDeterminationMethod_OPTIMAL_VALUE = 3;
const int UnderlyingPriceDeterminationMethod_AVERAGE_VALUE = 4;
const int OptPayoutType_VANILLA = 1;
const int OptPayoutType_CAPPED = 2;
const int OptPayoutType_BINARY = 3;
const int OptPayoutType_ASIAN = 4;
const int OptPayoutType_BARRIER = 5;
const int OptPayoutType_DIGITAL_BARRIER = 6;
const int OptPayoutType_LOOKBACK = 7;
const int OptPayoutType_OTHER_PATH_DEPENDENT = 8;
const int OptPayoutType_OTHER = 99;
const int ComplexEventType_CAPPED = 1;
const int ComplexEventType_TRIGGER = 2;
const int ComplexEventType_KNOCK_IN_UP = 3;
const int ComplexEventType_KNOCK_IN_DOWN = 4;
const int ComplexEventType_KNOCK_OUT_UP = 5;
const int ComplexEventType_KNOCK_OUT_DOWN = 6;
const int ComplexEventType_UNDERLYING = 7;
const int ComplexEventType_RESET_BARRIER = 8;
const int ComplexEventType_ROLLING_BARRIER = 9;
const int ComplexEventType_ONE_TOUCH = 10;
const int ComplexEventType_NO_TOUCH = 11;
const int ComplexEventType_DBL_ONE_TOUCH = 12;
const int ComplexEventType_DBL_NO_TOUCH = 13;
const int ComplexEventType_FX_COMPOSITE = 14;
const int ComplexEventType_FX_QUANTO = 15;
const int ComplexEventType_FX_CRSS_CCY = 16;
const int ComplexEventType_STRK_SPREAD = 17;
const int ComplexEventType_CLNDR_SPREAD = 18;
const int ComplexEventType_PX_OBSVTN = 19;
const int ComplexEventType_PASS_THROUGH = 20;
const int ComplexEventType_STRK_SCHED = 21;
const int ComplexEventType_EQUITY_VALUATION = 22;
const int ComplexEventType_DIVIDEND_VALUATION = 23;
const int ComplexEventPriceBoundaryMethod_LESS_THAN_COMPLEX_EVENT_PRICE = 1;
const int ComplexEventPriceBoundaryMethod_LESS_THAN_OR_EQUAL_TO_COMPLEX_EVENT_PRICE = 2;
const int ComplexEventPriceBoundaryMethod_EQUAL_TO_COMPLEX_EVENT_PRICE = 3;
const int ComplexEventPriceBoundaryMethod_GREATER_THAN_OR_EQUAL_TO_COMPLEX_EVENT_PRICE = 4;
const int ComplexEventPriceBoundaryMethod_GREATER_THAN_COMPLEX_EVENT_PRICE = 5;
const int ComplexEventPriceTimeType_EXPIRATION = 1;
const int ComplexEventPriceTimeType_IMMEDIATE = 2;
const int ComplexEventPriceTimeType_SPECIFIED_DATE = 3;
const int ComplexEventPriceTimeType_CLOSE = 4;
const int ComplexEventPriceTimeType_OPEN = 5;
const int ComplexEventPriceTimeType_OFFICIAL_SETTL_PRICE = 6;
const int ComplexEventPriceTimeType_DERIVATIVES_CLOSE = 7;
const int ComplexEventPriceTimeType_AS_SPECIFIED_MASTER_CONFIRMATION = 8;
const int ComplexEventCondition_AND = 1;
const int ComplexEventCondition_OR = 2;
const int StreamAsgnReqType_STREAM_ASSIGNMENT_FOR_NEW_CUSTOMER = 1;
const int StreamAsgnReqType_STREAM_ASSIGNMENT_FOR_EXISTING_CUSTOMER = 2;
const int StreamAsgnRejReason_UNKNOWN_CLIENT = 0;
const int StreamAsgnRejReason_EXCEEDS_MAXIMUM_SIZE = 1;
const int StreamAsgnRejReason_UNKNOWN_OR_INVALID_CURRENCY_PAIR = 2;
const int StreamAsgnRejReason_NO_AVAILABLE_STREAM = 3;
const int StreamAsgnRejReason_OTHER = 99;
const int StreamAsgnAckType_ASSIGNMENT_ACCEPTED = 0;
const int StreamAsgnAckType_ASSIGNMENT_REJECTED = 1;
const int StreamAsgnType_ASSIGNMENT = 1;
const int StreamAsgnType_REJECTED = 2;
const int StreamAsgnType_TERMINATE = 3;
const int MatchInst_MATCH = 1;
const int MatchInst_DO_NOT_MATCH = 2;
const int TriggerScope_THIS_ORDER = 0;
const int TriggerScope_OTHER_ORDER = 1;
const int TriggerScope_ALL_OTHER_ORDERS_FOR_GIVEN_SECURITY = 2;
const int TriggerScope_ALL_OTHER_ORDERS_FOR_GIVEN_SECURITY_AND_PRICE = 3;
const int TriggerScope_ALL_OTHER_ORDERS_FOR_GIVEN_SECURITY_AND_SIDE = 4;
const int TriggerScope_ALL_OTHER_ORDERS_FOR_GIVEN_SECURITY_PRICE_AND_SIDE = 5;
const int LimitAmtType_CREDIT_LIMIT = 0;
const int LimitAmtType_GROSS_POSITION_LIMIT = 1;
const int LimitAmtType_NET_POSITION_LIMIT = 2;
const int LimitAmtType_RISK_EXPOSURE_LIMIT = 3;
const int LimitAmtType_LONG_POSITION_LIMIT = 4;
const int LimitAmtType_SHORT_POSITION_LIMIT = 5;
const int MarginReqmtInqQualifier_SUMMARY = 0;
const int MarginReqmtInqQualifier_DETAIL = 1;
const int MarginReqmtInqQualifier_EXCESS_DEFICIT = 2;
const int MarginReqmtInqQualifier_NET_POSITION = 3;
const int MarginReqmtRptType_SUMMARY = 0;
const int MarginReqmtRptType_DETAIL = 1;
const int MarginReqmtRptType_EXCESS_DEFICIT = 2;
const int MarginReqmtInqResult_SUCCESSFUL = 0;
const int MarginReqmtInqResult_INVALID_OR_UNKNOWN_INSTRUMENT = 1;
const int MarginReqmtInqResult_INVALID_OR_UNKNOWN_MARGIN_CLASS = 2;
const int MarginReqmtInqResult_INVALID_PARTIES = 3;
const int MarginReqmtInqResult_INVALID_TRANSPORT_TYPE_REQ = 4;
const int MarginReqmtInqResult_INVALID_DESTINATION_REQ = 5;
const int MarginReqmtInqResult_NO_MARGIN_REQ_FOUND = 6;
const int MarginReqmtInqResult_MARGIN_REQ_INQUIRY_QUALIFIER_NOT_SUPPORTED = 7;
const int MarginReqmtInqResult_UNAUTHORIZED_FOR_MARGIN_REQ_INQUIRY = 8;
const int MarginReqmtInqResult_OTHER = 99;
const int MarginAmtType_ADDITIONAL_MARGIN = 1;
const int MarginAmtType_ADJUSTED_MARGIN = 2;
const int MarginAmtType_UNADJUSTED_MARGIN = 3;
const int MarginAmtType_BINARY_ADD_ON_AMOUNT = 4;
const int MarginAmtType_CASH_BALANCE_AMOUNT = 5;
const int MarginAmtType_CONCENTRATION_MARGIN = 6;
const int MarginAmtType_CORE_MARGIN = 7;
const int MarginAmtType_DELIVERY_MARGIN = 8;
const int MarginAmtType_DISCRETIONARY_MARGIN = 9;
const int MarginAmtType_FUTURES_SPREAD_MARGIN = 10;
const int MarginAmtType_INITIAL_MARGIN = 11;
const int MarginAmtType_LIQUIDATING_MARGIN = 12;
const int MarginAmtType_MARGIN_CALL_AMOUNT = 13;
const int MarginAmtType_MARGIN_DEFICIT_AMOUNT = 14;
const int MarginAmtType_MARGIN_EXCESS_AMOUNT = 15;
const int MarginAmtType_OPTION_PREMIUM_AMOUNT = 16;
const int MarginAmtType_PREMIUM_MARGIN = 17;
const int MarginAmtType_RESERVE_MARGIN = 18;
const int MarginAmtType_SECURITY_COLLATERAL_AMOUNT = 19;
const int MarginAmtType_STRESS_TEST_ADD_ON_AMOUNT = 20;
const int MarginAmtType_SUPER_MARGIN = 21;
const int MarginAmtType_TOTAL_MARGIN = 22;
const int MarginAmtType_VARIATION_MARGIN = 23;
const int MarginAmtType_SECONDARY_VARIATION_MARGIN = 24;
const int MarginAmtType_ROLLED_UP_MARGIN_DEFICIT = 25;
const int MarginAmtType_SPREAD_RESPONSE_MARGIN = 26;
const int MarginAmtType_SYSTEMIC_RISK_MARGIN = 27;
const int MarginAmtType_CURVE_RISK_MARGIN = 28;
const int MarginAmtType_INDEX_SPREAD_RISK_MARGIN = 29;
const int MarginAmtType_SECTOR_RISK_MARGIN = 30;
const int MarginAmtType_JUMP_TO_DEFAULT_RISK_MARGIN = 31;
const int MarginAmtType_BASIS_RISK_MARGIN = 32;
const int MarginAmtType_INTEREST_RATE_RISK_MARGIN = 33;
const int MarginAmtType_JUMP_TO_HEALTH_RISK_MARGIN = 34;
const int MarginAmtType_OTHER_RISK_MARGIN = 35;
const int RelatedInstrumentType_HEDGES_FOR_INSTRUMENT = 1;
const int RelatedInstrumentType_UNDERLIER = 2;
const int RelatedInstrumentType_EQUITY_EQUIVALENT = 3;
const int RelatedInstrumentType_NEAREST_EXCHANGE_TRADED_CONTRACT = 4;
const int RelatedInstrumentType_RETAIL_EQUIVALENT = 5;
const int RelatedInstrumentType_LEG = 6;
const int MarketMakerActivity_NO_PARTICIPATION = 0;
const int MarketMakerActivity_BUY_PARTICIPATION = 1;
const int MarketMakerActivity_SELL_PARTICIPATION = 2;
const int MarketMakerActivity_BOTH_BUY_AND_SELL_PARTICIPATION = 3;
const int RequestResult_VALID_REQUEST = 0;
const int RequestResult_INVALID_OR_UNSUPPORTED_REQUEST = 1;
const int RequestResult_NO_DATA_FOUND = 2;
const int RequestResult_NOT_AUTHORIZED = 3;
const int RequestResult_DATA_TEMPORARILY_UNAVAILABLE = 4;
const int RequestResult_REQUEST_FOR_DATA_NOT_SUPPORTED = 5;
const int RequestResult_OTHER = 99;
const int PartyRelationship_IS_ALSO = 0;
const int PartyRelationship_CLEARS_FOR = 1;
const int PartyRelationship_CLEARS_THROUGH = 2;
const int PartyRelationship_TRADES_FOR = 3;
const int PartyRelationship_TRADES_THROUGH = 4;
const int PartyRelationship_SPONSORS = 5;
const int PartyRelationship_SPONSORED_THROUGH = 6;
const int PartyRelationship_PROVIDES_GUARANTEE_FOR = 7;
const int PartyRelationship_IS_GUARANTEED_BY = 8;
const int PartyRelationship_MEMBER_OF = 9;
const int PartyRelationship_HAS_MEMBERS = 10;
const int PartyRelationship_PROVIDES_MARKETPLACE_FOR = 11;
const int PartyRelationship_PARTICIPANT_OF_MARKETPLACE = 12;
const int PartyRelationship_CARRIES_POSITIONS_FOR = 13;
const int PartyRelationship_POSTS_TRADES_TO = 14;
const int PartyRelationship_ENTERS_TRADES_FOR = 15;
const int PartyRelationship_ENTERS_TRADES_THROUGH = 16;
const int PartyRelationship_PROVIDES_QUOTES_TO = 17;
const int PartyRelationship_REQUESTS_QUOTES_FROM = 18;
const int PartyRelationship_INVESTS_FOR = 19;
const int PartyRelationship_INVESTS_THROUGH = 20;
const int PartyRelationship_BROKERS_TRADES_FOR = 21;
const int PartyRelationship_BROKERS_TRADES_THROUGH = 22;
const int PartyRelationship_PROVIDES_TRADING_SERVICES_FOR = 23;
const int PartyRelationship_USES_TRADING_SERVICES_OF = 24;
const int PartyRelationship_APPROVES_OF = 25;
const int PartyRelationship_APPROVED_BY = 26;
const int PartyRelationship_PARENT_FIRM_FOR = 27;
const int PartyRelationship_SUBSIDIARY_OF = 28;
const int PartyRelationship_REGULATORY_OWNER_OF = 29;
const int PartyRelationship_OWNED_BY_REGULATORY = 30;
const int PartyRelationship_CONTROLS = 31;
const int PartyRelationship_IS_CONTROLLED_BY = 32;
const int PartyRelationship_LEGAL_OWNER_OF = 33;
const int PartyRelationship_OWNED_BY_LEGAL = 34;
const int PartyRelationship_BENEFICIAL_OWNER_OF = 35;
const int PartyRelationship_OWNED_BY_BENEFICIAL = 36;
const int PartyRelationship_SETTLES_FOR = 37;
const int PartyRelationship_SETTLES_THROUGH = 38;
const int RiskLimitType_CREDIT_LIMIT = 0;
const int RiskLimitType_GROSS_LIMIT = 1;
const int RiskLimitType_NET_LIMIT = 2;
const int RiskLimitType_EXPOSURE = 3;
const int RiskLimitType_LONG_LIMIT = 4;
const int RiskLimitType_SHORT_LIMIT = 5;
const int RiskLimitType_CASH_MARGIN = 6;
const int RiskLimitType_ADDITIONAL_MARGIN = 7;
const int RiskLimitType_TOTAL_MARGIN = 8;
const int RiskLimitType_LIMIT_CONSUMED = 9;
const int RiskLimitType_CLIP_SIZE = 10;
const int RiskLimitType_MAX_NOTIONAL_ORDER_SIZE = 11;
const int RiskLimitType_DV01_PV01_LIMIT = 12;
const int RiskLimitType_CS01_LIMIT = 13;
const int RiskLimitType_VOLUME_LIMIT_PER_TIME_PERIOD = 14;
const int RiskLimitType_VOL_FILLED_PCT_ORD_VOL_TM_PERIOD = 15;
const int RiskLimitType_NOTL_FILLED_PCT_NOTL_TM_PERIOD = 16;
const int RiskLimitType_TRANSACTION_EXECUTION_LIMIT_PER_TIME_PERIOD = 17;
const int InstrumentScopeOperator_INCLUDE = 1;
const int InstrumentScopeOperator_EXCLUDE = 2;
const int PartyDetailStatus_ACTIVE = 0;
const int PartyDetailStatus_SUSPENDED = 1;
const int PartyDetailStatus_HALTED = 2;
const int PartyDetailRoleQualifier_FIRM_OR_LEGAL_ENTITY = 23;
const int PartyDetailRoleQualifier_CURRENT = 18;
const int PartyDetailRoleQualifier_NEW = 19;
const int PartyDetailRoleQualifier_NATURAL_PERSON = 24;
const int PartyDetailRoleQualifier_AGENCY = 0;
const int PartyDetailRoleQualifier_PRINCIPAL = 1;
const int PartyDetailRoleQualifier_RISKLESS_PRINCIPAL = 2;
const int PartyDetailRoleQualifier_EXCHANGE_ORDER_SUBMITTER = 30;
const int PartyDetailRoleQualifier_PRIMARY_TRD_REPOSITORY = 9;
const int PartyDetailRoleQualifier_ORIG_TRD_REPOSITORY = 10;
const int PartyDetailRoleQualifier_ADDTNL_INTL_TRD_REPOSITORY = 11;
const int PartyDetailRoleQualifier_ADDTNL_DOMESTIC_TRD_REPOSITORY = 12;
const int PartyDetailRoleQualifier_REGULAR_TRADER = 25;
const int PartyDetailRoleQualifier_HEAD_TRADER = 26;
const int PartyDetailRoleQualifier_SUPERVISOR = 27;
const int PartyDetailRoleQualifier_ALGORITHM = 22;
const int PartyDetailRoleQualifier_RELATED_EXCHANGE = 13;
const int PartyDetailRoleQualifier_OPTIONS_EXCHANGE = 14;
const int PartyDetailRoleQualifier_SPECIFIED_EXCHANGE = 15;
const int PartyDetailRoleQualifier_CONSTITUENT_EXCHANGE = 16;
const int PartyDetailRoleQualifier_BANK = 7;
const int PartyDetailRoleQualifier_HUB = 8;
const int PartyDetailRoleQualifier_TRI_PARTY = 28;
const int PartyDetailRoleQualifier_LENDER = 29;
const int PartyDetailRoleQualifier_GENERAL_CLEARING_MEMBER = 3;
const int PartyDetailRoleQualifier_INDIVIDUAL_CLEARING_MEMBER = 4;
const int PartyDetailRoleQualifier_PREFERRED_MARKET_MAKER = 5;
const int PartyDetailRoleQualifier_DIRECTED_MARKET_MAKER = 6;
const int PartyDetailRoleQualifier_DESIGNATED_SPONSOR = 20;
const int PartyDetailRoleQualifier_SPECIALIST = 21;
const int PartyDetailRoleQualifier_EXEMPT_FROM_TRADE_REPORTING = 17;
const int TrdAckStatus_ACCEPTED = 0;
const int TrdAckStatus_REJECTED = 1;
const int TrdAckStatus_RECEIVED = 2;
const int SecurityClassificationReason_FEE = 0;
const int SecurityClassificationReason_CREDIT_CONTROLS = 1;
const int SecurityClassificationReason_MARGIN = 2;
const int SecurityClassificationReason_ENTITLEMENT_OR_ELIGIBILITY = 3;
const int SecurityClassificationReason_MARKET_DATA = 4;
const int SecurityClassificationReason_ACCOUNT_SELECTION = 5;
const int SecurityClassificationReason_DELIVERY_PROCESS = 6;
const int SecurityClassificationReason_SECTOR = 7;
const int PosAmtReason_OPTIONS_SETTLEMENT = 0;
const int PosAmtReason_PENDING_EROSION_ADJUSTMENT = 1;
const int PosAmtReason_FINAL_EROSION_ADJUSTMENT = 2;
const int PosAmtReason_TEAR_UP_COUPON_AMOUNT = 3;
const int PosAmtReason_PRICE_ALIGNMENT_INTEREST = 4;
const int PosAmtReason_DELIVERY_INVOICE_CHARGES = 5;
const int PosAmtReason_DELIVERY_STORAGE_CHARGES = 6;
const int SideClearingTradePriceType_TRADE_CLEARING_AT_EXECUTION_PRICE = 0;
const int SideClearingTradePriceType_TRADE_CLEARING_AT_ALTERNATE_CLEARING_PRICE = 1;
const int SecurityRejectReason_INVALID_INSTRUMENT_REQUESTED = 1;
const int SecurityRejectReason_INSTRUMENT_ALREADY_EXISTS = 2;
const int SecurityRejectReason_REQUEST_TYPE_NOT_SUPPORTED = 3;
const int SecurityRejectReason_SYSTEM_UNAVAILABLE_FOR_INSTRUMENT_CREATION = 4;
const int SecurityRejectReason_INELIGIBLE_INSTRUMENT_GROUP = 5;
const int SecurityRejectReason_INSTRUMENT_ID_UNAVAILABLE = 6;
const int SecurityRejectReason_INVALID_OR_MISSING_DATA_ON_OPTION_LEG = 7;
const int SecurityRejectReason_INVALID_OR_MISSING_DATA_ON_FUTURE_LEG = 8;
const int SecurityRejectReason_INVALID_OR_MISSING_DATA_ON_FX_LEG = 10;
const int SecurityRejectReason_INVALID_LEG_PRICE_SPECIFIED = 11;
const int SecurityRejectReason_INVALID_INSTRUMENT_STRUCTURE_SPECIFIED = 12;
const int ThrottleStatus_THROTTLE_LIMIT_NOT_EXCEEDED_NOT_QUEUED = 0;
const int ThrottleStatus_QUEUED_DUE_TO_THROTTLE_LIMIT_EXCEEDED = 1;
const int ThrottleAction_QUEUE_INBOUND = 0;
const int ThrottleAction_QUEUE_OUTBOUND = 1;
const int ThrottleAction_REJECT = 2;
const int ThrottleAction_DISCONNECT = 3;
const int ThrottleAction_WARNING = 4;
const int ThrottleType_INBOUND_RATE = 0;
const int ThrottleType_OUTSTANDING_REQUESTS = 1;
const int ThrottleInst_REJECT_IF_THROTTLE_LIMIT_EXCEEDED = 0;
const int ThrottleInst_QUEUE_IF_THROTTLE_LIMIT_EXCEEDED = 1;
const int ThrottleCountIndicator_OUTSTANDING_REQUESTS_UNCHANGED = 0;
const int ThrottleCountIndicator_OUTSTANDING_REQUESTS_DECREASED = 1;
const int AllocationRollupInstruction_ROLLUP = 0;
const int AllocationRollupInstruction_DO_NOT_ROLL_UP = 1;
const int AllocReversalStatus_COMPLETED = 0;
const int AllocReversalStatus_REFUSED = 1;
const int AllocReversalStatus_CANCELLED = 2;
const char ObligationType_BOND[] = "0";
const char ObligationType_CONVERT_BOND[] = "1";
const char ObligationType_MORTGAGE[] = "2";
const char ObligationType_LOAN[] = "3";
const int TradePriceNegotiationMethod_PERCENT_PAR = 0;
const int TradePriceNegotiationMethod_DEAL_SPREAD = 1;
const int TradePriceNegotiationMethod_UPFRONT_PNTS = 2;
const int TradePriceNegotiationMethod_UPFRONT_AMT = 3;
const int TradePriceNegotiationMethod_PAR_UPFRONT_AMT = 4;
const int TradePriceNegotiationMethod_SPREAD_UPFRONT_AMT = 5;
const int TradePriceNegotiationMethod_UPFRONT_PNTS_AMT = 6;
const int UpfrontPriceType_PERCENTAGE = 1;
const int UpfrontPriceType_FIXED_AMOUNT = 3;
const int ShortSaleRestriction_NO_RESTRICTIONS = 0;
const int ShortSaleRestriction_SECURITY_NOT_SHORTABLE = 1;
const int ShortSaleRestriction_SECURITY_NOT_SHORTABLE_AT_OR_BELOW_BEST_BID = 2;
const int ShortSaleRestriction_SECURITY_NOT_SHORTABLE_WITHOUT_PRE_BORROW = 3;
const int ShortSaleExemptionReason_EXEMPTION_REASON_UNKNOWN = 0;
const int ShortSaleExemptionReason_INCOMING_SSE = 1;
const int ShortSaleExemptionReason_ABOVE_NATIONAL_BEST_BID = 2;
const int ShortSaleExemptionReason_DELAYED_DELIVERY = 3;
const int ShortSaleExemptionReason_ODD_LOT = 4;
const int ShortSaleExemptionReason_DOMESTIC_ARBITRAGE = 5;
const int ShortSaleExemptionReason_INTERNATIONAL_ARBITRAGE = 6;
const int ShortSaleExemptionReason_UNDERWRITER_OR_SYNDICATE_DISTRIBUTION = 7;
const int ShortSaleExemptionReason_RISKLESS_PRINCIPAL = 8;
const int ShortSaleExemptionReason_VWAP = 9;
const int ApplLevelRecoveryIndicator_NO_APPL_RECOVERY_NEEDED = 0;
const int ApplLevelRecoveryIndicator_APPL_RECOVERY_NEEDED = 1;
const int RiskLimitRequestType_DEFINITIONS = 1;
const int RiskLimitRequestType_UTILIZATION = 2;
const int RiskLimitRequestType_DEFINITIONS_AND_UTILIZATIONS = 3;
const int RiskLimitRequestResult_SUCCESSFUL = 0;
const int RiskLimitRequestResult_INVALID_PARTY = 1;
const int RiskLimitRequestResult_INVALID_RELATED_PARTY = 2;
const int RiskLimitRequestResult_INVALID_RISK_LIMIT_TYPE = 3;
const int RiskLimitRequestResult_INVALID_RISK_LIMIT_ID = 4;
const int RiskLimitRequestResult_INVALID_RISK_LIMIT_AMOUNT = 5;
const int RiskLimitRequestResult_INVALID_RISK_WARNING_LEVEL_ACTION = 6;
const int RiskLimitRequestResult_INVALID_RISK_INSTRUMENT_SCOPE = 7;
const int RiskLimitRequestResult_RISK_LIMIT_ACTIONS_NOT_SUPPORTED = 8;
const int RiskLimitRequestResult_WARNING_LEVELS_NOT_SUPPORTED = 9;
const int RiskLimitRequestResult_WARNING_LEVEL_ACTIONS_NOT_SUPPORTED = 10;
const int RiskLimitRequestResult_RISK_INSTRUMENT_SCOPE_NOT_SUPPORTED = 11;
const int RiskLimitRequestResult_RISK_LIMIT_NOT_APPROVED_FOR_PARTY = 12;
const int RiskLimitRequestResult_RISK_LIMIT_ALREADY_DEFINED_FOR_PARTY = 13;
const int RiskLimitRequestResult_INSTRUMENT_NOT_APPROVED_FOR_PARTY = 14;
const int RiskLimitRequestResult_NOT_AUTHORIZED = 98;
const int RiskLimitRequestResult_OTHER = 99;
const int RiskLimitAction_QUEUE_INBOUND = 0;
const int RiskLimitAction_QUEUE_OUTBOUND = 1;
const int RiskLimitAction_REJECT = 2;
const int RiskLimitAction_DISCONNECT = 3;
const int RiskLimitAction_WARNING = 4;
const int RiskLimitAction_PING_CREDIT_CHECK_WITH_REVALIDATION = 5;
const int RiskLimitAction_PING_CREDIT_CHECK_NO_REVALIDATION = 6;
const int RiskLimitAction_PUSH_CREDIT_CHECK_WITH_REVALIDATION = 7;
const int RiskLimitAction_PUSH_CREDIT_CHECK_NO_REVALIDATION = 8;
const int RiskLimitAction_SUSPEND = 9;
const int RiskLimitAction_HALT_TRADING = 10;
const int EntitlementType_TRADE = 0;
const int EntitlementType_MAKE_MARKETS = 1;
const int EntitlementType_HOLD_POSITIONS = 2;
const int EntitlementType_PERFORM_GIVE_UPS = 3;
const int EntitlementType_SUBMIT_IO_IS = 4;
const int EntitlementType_SUBSCRIBE_MARKET_DATA = 5;
const int EntitlementType_SHORT_WITH_PRE_BORROW = 6;
const int EntitlementType_SUBMIT_QUOTE_REQUESTS = 7;
const int EntitlementType_RESPOND_TO_QUOTE_REQUESTS = 8;
const int EntitlementAttribDatatype_TENOR = 29;
const int EntitlementAttribDatatype_PATTERN = 32;
const int EntitlementAttribDatatype_RESERVED100_PLUS = 33;
const int EntitlementAttribDatatype_RESERVED1000_PLUS = 34;
const int EntitlementAttribDatatype_RESERVED4000_PLUS = 35;
const int EntitlementAttribDatatype_STRING = 14;
const int EntitlementAttribDatatype_MULTIPLE_CHAR_VALUE = 15;
const int EntitlementAttribDatatype_CURRENCY = 16;
const int EntitlementAttribDatatype_EXCHANGE = 17;
const int EntitlementAttribDatatype_MONTH_YEAR = 18;
const int EntitlementAttribDatatype_UTC_TIMESTAMP = 19;
const int EntitlementAttribDatatype_UTC_TIME_ONLY = 20;
const int EntitlementAttribDatatype_LOCAL_MKT_DATE = 21;
const int EntitlementAttribDatatype_UTC_DATE_ONLY = 22;
const int EntitlementAttribDatatype_DATA = 23;
const int EntitlementAttribDatatype_MULTIPLE_STRING_VALUE = 24;
const int EntitlementAttribDatatype_COUNTRY = 25;
const int EntitlementAttribDatatype_LANGUAGE = 26;
const int EntitlementAttribDatatype_TZ_TIME_ONLY = 27;
const int EntitlementAttribDatatype_TZ_TIMESTAMP = 28;
const int EntitlementAttribDatatype_XML_DATA = 31;
const int EntitlementAttribDatatype_CHAR = 12;
const int EntitlementAttribDatatype_BOOLEAN = 13;
const int EntitlementAttribDatatype_FLOAT = 6;
const int EntitlementAttribDatatype_QTY = 7;
const int EntitlementAttribDatatype_PRICE = 8;
const int EntitlementAttribDatatype_PRICE_OFFSET = 9;
const int EntitlementAttribDatatype_AMT = 10;
const int EntitlementAttribDatatype_PERCENTAGE = 11;
const int EntitlementAttribDatatype_INT = 1;
const int EntitlementAttribDatatype_LENGTH = 2;
const int EntitlementAttribDatatype_NUM_IN_GROUP = 3;
const int EntitlementAttribDatatype_SEQ_NUM = 4;
const int EntitlementAttribDatatype_TAG_NUM = 5;
const int EntitlementAttribDatatype_DAY_OF_MONTH = 30;
const int TradSesControl_AUTOMATIC = 0;
const int TradSesControl_MANUAL = 1;
const int TradeVolType_NUMBER_OF_UNITS = 0;
const int TradeVolType_NUMBER_OF_ROUND_LOTS = 1;
const int OrderEventType_ADDED = 1;
const int OrderEventType_MODIFIED = 2;
const int OrderEventType_DELETED = 3;
const int OrderEventType_PARTIALLY_FILLED = 4;
const int OrderEventType_FILLED = 5;
const int OrderEventType_SUSPENDED = 6;
const int OrderEventType_RELEASED = 7;
const int OrderEventType_RESTATED = 8;
const int OrderEventType_LOCKED = 9;
const int OrderEventType_TRIGGERED = 10;
const int OrderEventType_ACTIVATED = 11;
const int OrderEventReason_ADD_ORDER_REQUEST = 1;
const int OrderEventReason_MODIFY_ORDER_REQUEST = 2;
const int OrderEventReason_DELETE_ORDER_REQUEST = 3;
const int OrderEventReason_ORDER_ENTERED_OOB = 4;
const int OrderEventReason_ORDER_MODIFIED_OOB = 5;
const int OrderEventReason_ORDER_DELETED_OOB = 6;
const int OrderEventReason_ORDER_ACTIVATED_OR_TRIGGERED = 7;
const int OrderEventReason_ORDER_EXPIRED = 8;
const int OrderEventReason_RESERVE_ORDER_REFRESHED = 9;
const int OrderEventReason_AWAY_MARKET_BETTER = 10;
const int OrderEventReason_CORPORATE_ACTION = 11;
const int OrderEventReason_START_OF_DAY = 12;
const int OrderEventReason_END_OF_DAY = 13;
const int AuctionType_NONE = 0;
const int AuctionType_BLOCK_ORDER_AUCTION = 1;
const int AuctionType_DIRECTED_ORDER_AUCTION = 2;
const int AuctionType_EXPOSURE_ORDER_AUCTION = 3;
const int AuctionType_FLASH_ORDER_AUCTION = 4;
const int AuctionType_FACILITATION_ORDER_AUCTION = 5;
const int AuctionType_SOLICITATION_ORDER_AUCTION = 6;
const int AuctionType_PRICE_IMPROVEMENT_MECHANISM = 7;
const int AuctionType_DIRECTED_ORDER_PRICE_IMPROVEMENT_MECHANISM = 8;
const int AuctionInstruction_AUTOMATED_AUCTION_PERMITTED = 0;
const int AuctionInstruction_AUTOMATED_AUCTION_NOT_PERMITTED = 1;
const int LockType_NOT_LOCKED = 0;
const int LockType_AWAY_MARKET_NETTER = 1;
const int LockType_THREE_TICK_LOCKED = 2;
const int LockType_LOCKED_BY_MARKET_MAKER = 3;
const int LockType_DIRECTED_ORDER_LOCK = 4;
const int LockType_MULTILEG_LOCK = 5;
const int LockType_MARKET_ORDER_LOCK = 6;
const int LockType_PRE_ASSIGNMENT_LOCK = 7;
const int ReleaseInstruction_ISO = 1;
const int ReleaseInstruction_NO_AWAY_MARKET_BETTER_CHECK = 2;
const int DisclosureType_VOLUME = 1;
const int DisclosureType_PRICE = 2;
const int DisclosureType_SIDE = 3;
const int DisclosureType_AON = 4;
const int DisclosureType_GENERAL = 5;
const int DisclosureType_CLEARING_ACCOUNT = 6;
const int DisclosureType_CMTA_ACCOUNT = 7;
const int DisclosureInstruction_NO = 0;
const int DisclosureInstruction_YES = 1;
const int DisclosureInstruction_USE_DEFAULT_SETTING = 2;
const int TradingCapacity_CUSTOMER = 1;
const int TradingCapacity_CUSTOMER_PROFESSIONAL = 2;
const int TradingCapacity_BROKER_DEALER = 3;
const int TradingCapacity_CUSTOMER_BROKER_DEALER = 4;
const int TradingCapacity_PRINCIPAL = 5;
const int TradingCapacity_MARKET_MAKER = 6;
const int TradingCapacity_AWAY_MARKET_MAKER = 7;
const int TradingCapacity_SYSTEMATIC_INTERNALISER = 8;
const int ClearingAccountType_CUSTOMER = 1;
const int ClearingAccountType_FIRM = 2;
const int ClearingAccountType_MARKET_MAKER = 3;
const int RelatedPriceSource_NB_BID = 1;
const int RelatedPriceSource_NB_OFFER = 2;
const int MinQtyMethod_ONCE = 1;
const int MinQtyMethod_MULTIPLE = 2;
const int Triggered_NOT_TRIGGERED = 0;
const int Triggered_TRIGGERED = 1;
const int Triggered_STOP_ORDER_TRIGGERED = 2;
const int Triggered_OCO_ORDER_TRIGGERED = 3;
const int Triggered_OTO_ORDER_TRIGGERED = 4;
const int Triggered_OUO_ORDER_TRIGGERED = 5;
const char EventTimeUnit_HOUR[] = "H";
const char EventTimeUnit_MINUTE[] = "Min";
const char EventTimeUnit_SECOND[] = "S";
const char EventTimeUnit_DAY[] = "D";
const char EventTimeUnit_WEEK[] = "Wk";
const char EventTimeUnit_MONTH[] = "Mo";
const char EventTimeUnit_YEAR[] = "Yr";
const int OrderOrigination_ORDER_RECEIVED_FROM_CUSTOMER = 1;
const int OrderOrigination_ORDER_RECEIVED_FROM_WITHIN_FIRM = 2;
const int OrderOrigination_ORDER_RECEIVED_FROM_ANOTHER_BROKER_DEALER = 3;
const int OrderOrigination_ORDER_RECEIVED_FROM_CUSTOMER_OR_WITH_FIRM = 4;
const int OrderOrigination_ORDER_RECEIVED_FROM_DIRECT_ACCESS_CUSTOMER = 5;
const int OrderOrigination_ORDER_RECEIVED_FROM_FOREIGN_DEALER_EQUIVALENT = 6;
const int OrderOrigination_ORDER_RECEIVED_FROM_EXECUTION_ONLY_SERVICE = 7;
const int ClearedIndicator_NOT_CLEARED = 0;
const int ClearedIndicator_CLEARED = 1;
const int ClearedIndicator_SUBMITTED = 2;
const int ClearedIndicator_REJECTED = 3;
const int ContractRefPosType_TWO_COMPONENT_INTERCOMMODITY_SPREAD = 0;
const int ContractRefPosType_INDEX_OR_BASKET = 1;
const int ContractRefPosType_TWO_COMPONENT_LOCATION_BASIS = 2;
const int ContractRefPosType_OTHER = 99;
const int PositionCapacity_PRINCIPAL = 0;
const int PositionCapacity_AGENT = 1;
const int PositionCapacity_CUSTOMER = 2;
const int PositionCapacity_COUNTERPARTY = 3;
const int TradePriceCondition_SPECIAL_CUM_DIVIDEND = 0;
const int TradePriceCondition_SPECIAL_CUM_RIGHTS = 1;
const int TradePriceCondition_SPECIAL_EX_DIVIDEND = 2;
const int TradePriceCondition_SPECIAL_EX_RIGHTS = 3;
const int TradePriceCondition_SPECIAL_CUM_COUPON = 4;
const int TradePriceCondition_SPECIAL_CUM_CAPITAL_REPAYMENTS = 5;
const int TradePriceCondition_SPECIAL_EX_COUPON = 6;
const int TradePriceCondition_SPECIAL_EX_CAPITAL_REPAYMENTS = 7;
const int TradePriceCondition_CASH_SETTLEMENT = 8;
const int TradePriceCondition_SPECIAL_CUM_BONUS = 9;
const int TradePriceCondition_SPECIAL_PRICE = 10;
const int TradePriceCondition_SPECIAL_EX_BONUS = 11;
const int TradePriceCondition_GUARANTEED_DELIVERY = 12;
const int TradePriceCondition_SPECIAL_DIVIDEND = 13;
const int TradePriceCondition_PRICE_IMPROVEMENT = 14;
const int TradePriceCondition_NON_PRICE_FORMING_TRADE = 15;
const int TradePriceCondition_TRADE_EXEMPTED_FROM_TRADING_OBLIGATION = 16;
const int TradePriceCondition_PRICE_PENDING = 17;
const int TradePriceCondition_PRICE_NOT_APPLICABLE = 18;
const int TradeAllocStatus_PENDING_CLEAR = 0;
const int TradeAllocStatus_CLAIMED = 1;
const int TradeAllocStatus_CLEARED = 2;
const int TradeAllocStatus_REJECTED = 3;
const int TradeQtyType_CLEARED_QUANTITY = 0;
const int TradeQtyType_LONG_SIDE_CLAIMED_QUANTITY = 1;
const int TradeQtyType_SHORT_SIDE_CLAIMED_QUANTITY = 2;
const int TradeQtyType_LONG_SIDE_REJECTED_QUANTITY = 3;
const int TradeQtyType_SHORT_SIDE_REJECTED_QUANTITY = 4;
const int TradeQtyType_PENDING_QUANTITY = 5;
const int TradeQtyType_TRANSACTION_QUANTITY = 6;
const int TradeQtyType_REMAINING_QUANTITY = 7;
const int TradeQtyType_PREVIOUS_REMAINING_QUANTITY = 8;
const int TradeAllocGroupInstruction_ADD = 0;
const int TradeAllocGroupInstruction_DO_NOT_ADD = 1;
const int OffsetInstruction_OFFSET = 0;
const int OffsetInstruction_ONSET = 1;
const int SideAvgPxIndicator_NO_AVG_PRICING = 0;
const int SideAvgPxIndicator_TRADE_IS_PART_AVG_PRICE_GRP = 1;
const int SideAvgPxIndicator_LAST_TRADE_IS_PART_AVG_PRICE_GRP = 2;
const int RelatedTradeIDSource_NON_FIX_SOURCE = 0;
const int RelatedTradeIDSource_TRADE_ID = 1;
const int RelatedTradeIDSource_SECONDARY_TRADE_ID = 2;
const int RelatedTradeIDSource_TRADE_REPORT_ID = 3;
const int RelatedTradeIDSource_FIRM_TRADE_ID = 4;
const int RelatedTradeIDSource_SECONDARY_FIRM_TRADE_ID = 5;
const int RelatedTradeIDSource_REGULATORY_TRADE_ID = 6;
const int RelatedPositionIDSource_POS_MAINT_RPT_ID = 1;
const int RelatedPositionIDSource_TRANSFER_ID = 2;
const int RelatedPositionIDSource_POSITION_ENTITY_ID = 3;
const int ValueCheckType_PRICE_CHECK = 1;
const int ValueCheckType_NOTIONAL_VALUE_CHECK = 2;
const int ValueCheckType_QUANTITY_CHECK = 3;
const int ValueCheckAction_DO_NOT_CHECK = 0;
const int ValueCheckAction_CHECK = 1;
const int ValueCheckAction_BEST_EFFORT = 2;
const int PartyDetailRequestResult_SUCCESSFUL = 0;
const int PartyDetailRequestResult_INVALID_PARTY = 1;
const int PartyDetailRequestResult_INVALID_RELATED_PARTY = 2;
const int PartyDetailRequestResult_INVALID_PARTY_STATUS = 3;
const int PartyDetailRequestResult_NOT_AUTHORIZED = 98;
const int PartyDetailRequestResult_OTHER = 99;
const int PartyDetailRequestStatus_ACCEPTED = 0;
const int PartyDetailRequestStatus_ACCEPTED_WITH_CHANGES = 1;
const int PartyDetailRequestStatus_REJECTED = 2;
const int PartyDetailRequestStatus_ACCEPTANCE_PENDING = 3;
const int PartyDetailDefinitionStatus_ACCEPTED = 0;
const int PartyDetailDefinitionStatus_ACCEPTED_WITH_CHANGES = 1;
const int PartyDetailDefinitionStatus_REJECTED = 2;
const int EntitlementRequestResult_SUCCESSFUL = 0;
const int EntitlementRequestResult_INVALID_PARTY = 1;
const int EntitlementRequestResult_INVALID_RELATED_PARTY = 2;
const int EntitlementRequestResult_INVALID_ENTITLEMENT_TYPE = 3;
const int EntitlementRequestResult_INVALID_ENTITLEMENT_ID = 4;
const int EntitlementRequestResult_INVALID_ENTITLEMENT_ATTRIBUTE = 5;
const int EntitlementRequestResult_INVALID_INSTRUMENT_SCOPE = 6;
const int EntitlementRequestResult_INVALID_MARKET_SEGMENT_SCOPE = 7;
const int EntitlementRequestResult_INVALID_START_DATE = 8;
const int EntitlementRequestResult_INVALID_END_DATE = 9;
const int EntitlementRequestResult_INSTRUMENT_SCOPE_NOT_SUPPORTED = 10;
const int EntitlementRequestResult_MARKET_SEGMENT_SCOPE_NOT_SUPPORTED = 11;
const int EntitlementRequestResult_ENTITLEMENT_NOT_APPROVED_FOR_PARTY = 12;
const int EntitlementRequestResult_ENTITLEMENT_ALREADY_DEFINED_FOR_PARTY = 13;
const int EntitlementRequestResult_INSTRUMENT_NOT_APPROVED_FOR_PARTY = 14;
const int EntitlementRequestResult_NOT_AUTHORIZED = 98;
const int EntitlementRequestResult_OTHER = 99;
const int EntitlementStatus_ACCEPTED = 0;
const int EntitlementStatus_ACCEPTED_WITH_CHANGES = 1;
const int EntitlementStatus_REJECTED = 2;
const int EntitlementStatus_PENDING = 3;
const int EntitlementStatus_REQUESTED = 4;
const int EntitlementStatus_DEFERRED = 5;
const int TradeMatchAckStatus_RECEIVED_NOT_PROCESSED = 0;
const int TradeMatchAckStatus_ACCEPTED = 1;
const int TradeMatchAckStatus_REJECTED = 2;
const int TradeMatchRejectReason_SUCCESSFUL = 0;
const int TradeMatchRejectReason_INVALID_PARTY_INFORMATION = 1;
const int TradeMatchRejectReason_UNKNOWN_INSTRUMENT = 2;
const int TradeMatchRejectReason_UNAUTHORIZED = 3;
const int TradeMatchRejectReason_INVALID_TRADE_TYPE = 4;
const int TradeMatchRejectReason_OTHER = 99;
const int PriceMovementType_AMOUNT = 0;
const int PriceMovementType_PERCENTAGE = 1;
const int RegulatoryTradeIDEvent_INITIAL_BLOCK_TRADE = 0;
const int RegulatoryTradeIDEvent_ALLOCATION = 1;
const int RegulatoryTradeIDEvent_CLEARING = 2;
const int RegulatoryTradeIDEvent_COMPRESSION = 3;
const int RegulatoryTradeIDEvent_NOVATION = 4;
const int RegulatoryTradeIDEvent_TERMINATION = 5;
const int RegulatoryTradeIDEvent_POST_TRD_VAL = 6;
const char RegulatoryTradeIDSource_UNIQUE_TRANSACTION_IDENTIFIER[] = "1";
const int RegulatoryTradeIDType_CURRENT = 0;
const int RegulatoryTradeIDType_PREVIOUS = 1;
const int RegulatoryTradeIDType_BLOCK = 2;
const int RegulatoryTradeIDType_RELATED = 3;
const int RegulatoryTradeIDType_CLEARED_BLOCK_TRADE = 4;
const int RegulatoryTradeIDType_TRADING_VENUE_TRANSACTION_IDENTIFIER = 5;
const int ClearingIntention_DO_NOT_INTEND_TO_CLEAR = 0;
const int ClearingIntention_INTEND_TO_CLEAR = 1;
const int ConfirmationMethod_NON_ELECTRONIC = 0;
const int ConfirmationMethod_ELECTRONIC = 1;
const int ConfirmationMethod_UNCONFIRMED = 2;
const int VerificationMethod_NON_ELECTRONIC = 0;
const int VerificationMethod_ELECTRONIC = 1;
const int ClearingRequirementException_NO_EXCEPTION = 0;
const int ClearingRequirementException_EXCEPTION = 1;
const int ClearingRequirementException_END_USER_EXCEPTION = 2;
const int ClearingRequirementException_INTER_AFFILIATE_EXCEPTION = 3;
const int ClearingRequirementException_TREASURY_AFFILIATE_EXCEPTION = 4;
const int ClearingRequirementException_COOPERATIVE_EXCEPTION = 5;
const char IRSDirection_PAY[] = "PAY";
const char IRSDirection_RCV[] = "RCV";
const char IRSDirection_NA[] = "NA";
const int RegulatoryReportType_RT = 0;
const int RegulatoryReportType_PET = 1;
const int RegulatoryReportType_SNAPSHOT = 2;
const int RegulatoryReportType_CONFIRMATION = 3;
const int RegulatoryReportType_RTPET = 4;
const int RegulatoryReportType_PET_CONFIRMATION = 5;
const int RegulatoryReportType_RTPET_CONFIRMATION = 6;
const int RegulatoryReportType_POST_TRADE = 7;
const int RegulatoryReportType_VERIFICATION = 8;
const int RegulatoryReportType_PST_TRD_EVNT = 9;
const int RegulatoryReportType_PST_TRD_EVNT_RT_REPORTABLE = 10;
const int RegulatoryReportType_LMTF = 11;
const int RegulatoryReportType_DATF = 12;
const int RegulatoryReportType_VOLO = 13;
const int RegulatoryReportType_FWAF = 14;
const int RegulatoryReportType_IDAF = 15;
const int RegulatoryReportType_VOLW = 16;
const int RegulatoryReportType_FULF = 17;
const int RegulatoryReportType_FULA = 18;
const int RegulatoryReportType_FULV = 19;
const int RegulatoryReportType_FULJ = 20;
const int RegulatoryReportType_COAF = 21;
const int RegulatoryReportType_ORDER = 22;
const int RegulatoryReportType_CHILD_ORDER = 23;
const int RegulatoryReportType_ORDER_ROUTE = 24;
const int RegulatoryReportType_TRADE = 25;
const int RegulatoryReportType_QUOTE = 26;
const int RegulatoryReportType_SUPPLEMENT = 27;
const int RegulatoryReportType_NEW_TRANSACTION = 28;
const int RegulatoryReportType_TRANSACTION_CORRECTION = 29;
const int RegulatoryReportType_TRANSACTION_MODIFICATION = 30;
const int RegulatoryReportType_COLLATERAL_UPDATE = 31;
const int RegulatoryReportType_MARGIN_UPDATE = 32;
const int RegulatoryReportType_TRANSACTION_REPORTED_IN_ERROR = 33;
const int RegulatoryReportType_TERMINATION_EARLY_TERMINATION = 34;
const int TradeCollateralization_UNCOLLATERALIZED = 0;
const int TradeCollateralization_PARTIALLY_COLLATERALIZED = 1;
const int TradeCollateralization_ONE_WAY_COLLATERALLIZATION = 2;
const int TradeCollateralization_FULLY_COLLATERALIZED = 3;
const int TradeCollateralization_NET_EXPOSURE = 4;
const int TradeContinuation_NOVATION = 0;
const int TradeContinuation_PARTIAL_NOVATION = 1;
const int TradeContinuation_TRADE_UNWIND = 2;
const int TradeContinuation_PARTIAL_TRADE_UNWIND = 3;
const int TradeContinuation_EXERCISE = 4;
const int TradeContinuation_NETTING = 5;
const int TradeContinuation_FULL_NETTING = 6;
const int TradeContinuation_PARTIAL_NETTING = 7;
const int TradeContinuation_AMENDMENT = 8;
const int TradeContinuation_INCREASE = 9;
const int TradeContinuation_CREDIT_EVENT = 10;
const int TradeContinuation_STRATEGIC_RESTRUCTURING = 11;
const int TradeContinuation_SUCCESSION_EVENT_REORGANIZATION = 12;
const int TradeContinuation_SUCCESSION_EVENT_RENAMING = 13;
const int TradeContinuation_PORTING = 14;
const int TradeContinuation_WITHDRAWL = 15;
const int TradeContinuation_VOID = 16;
const int TradeContinuation_ACCOUNT_TRANSFER = 17;
const int TradeContinuation_GIVE_UP = 18;
const int TradeContinuation_TAKE_UP = 19;
const int TradeContinuation_AVERAGE_PRICING = 20;
const int TradeContinuation_REVERSAL = 21;
const int TradeContinuation_ALLOC_TRD_POSTING = 22;
const int TradeContinuation_CASCADE = 23;
const int TradeContinuation_DELIVERY = 24;
const int TradeContinuation_OPTION_ASGN = 25;
const int TradeContinuation_EXPIRATION = 26;
const int TradeContinuation_MATURITY = 27;
const int TradeContinuation_EQUAL_POS_ADJ = 28;
const int TradeContinuation_UNEQUAL_POS_ADJ = 29;
const int TradeContinuation_CORRECTION = 30;
const int TradeContinuation_EARLY_TERMINATION = 31;
const int TradeContinuation_RERATE = 32;
const int TradeContinuation_OTHER = 99;
const int AssetClass_INTEREST_RATE = 1;
const int AssetClass_CURRENCY = 2;
const int AssetClass_CREDIT = 3;
const int AssetClass_EQUITY = 4;
const int AssetClass_COMMODITY = 5;
const int AssetClass_OTHER = 6;
const int AssetClass_CASH = 7;
const int AssetClass_DEBT = 8;
const int AssetClass_FUND = 9;
const int AssetClass_LOAN_FACILITY = 10;
const int AssetClass_INDEX = 11;
const int AssetSubClass_METALS = 13;
const int AssetSubClass_BULLION = 14;
const int AssetSubClass_ENERGY = 15;
const int AssetSubClass_COMMODITY_INDEX = 16;
const int AssetSubClass_AGRICULTURAL = 17;
const int AssetSubClass_ENVIRONMENTAL = 18;
const int AssetSubClass_FREIGHT = 19;
const int AssetSubClass_FERTILIZER = 41;
const int AssetSubClass_INDUSTRIAL_PRODUCT = 42;
const int AssetSubClass_INFLATION = 43;
const int AssetSubClass_PAPER = 44;
const int AssetSubClass_POLYPROPYLENE = 45;
const int AssetSubClass_OFFICIAL_ECONOMIC_STATISTICS = 46;
const int AssetSubClass_SINGLE_NAME = 4;
const int AssetSubClass_CREDIT_INDEX = 5;
const int AssetSubClass_INDEX_TRANCHE = 6;
const int AssetSubClass_CREDIT_BASKET = 7;
const int AssetSubClass_BASKET = 3;
const int AssetSubClass_FX_CROSS_RATES = 38;
const int AssetSubClass_FX_EMERGING_MARKETS = 39;
const int AssetSubClass_FX_MAJORS = 40;
const int AssetSubClass_GOVERNMENT = 20;
const int AssetSubClass_AGENCY = 21;
const int AssetSubClass_CORPORATE = 22;
const int AssetSubClass_FINANCING = 23;
const int AssetSubClass_MONEY_MARKET = 24;
const int AssetSubClass_MORTGAGE = 25;
const int AssetSubClass_MUNICIPAL = 26;
const int AssetSubClass_COMMON = 9;
const int AssetSubClass_PREFERRED = 10;
const int AssetSubClass_EQUITY_INDEX = 11;
const int AssetSubClass_EQUITY_BASKET = 12;
const int AssetSubClass_DIVIDEND_INDEX = 34;
const int AssetSubClass_STOCK_DIVIDEND = 35;
const int AssetSubClass_EXCHANGE_TRADED_FUND = 36;
const int AssetSubClass_VOLATILITY_INDEX = 37;
const int AssetSubClass_MUTUAL_FUND = 27;
const int AssetSubClass_COLLECTIVE_INVESTMENT_VEHICLE = 28;
const int AssetSubClass_INVESTMENT_PROGRAM = 29;
const int AssetSubClass_SPECIALIZED_ACCOUNT_PROGRAM = 30;
const int AssetSubClass_SINGLE_CURRENCY = 1;
const int AssetSubClass_CROSS_CURRENCY = 2;
const int AssetSubClass_TERM_LOAN = 31;
const int AssetSubClass_BRIDGE_LOAN = 32;
const int AssetSubClass_LETTER_OF_CREDIT = 33;
const int AssetSubClass_EXOTIC = 8;
const int AssetSubClass_OTHER_C10 = 47;
const int AssetSubClass_OTHER = 48;
const char SwapClass_BASIS_SWAP[] = "BS";
const char SwapClass_INDEX_SWAP[] = "IX";
const char SwapClass_BROAD_BASED_SECURITY_SWAP[] = "BB";
const char SwapClass_BASKET_SWAP[] = "SK";
const int CouponType_ZERO = 0;
const int CouponType_FIXED_RATE = 1;
const int CouponType_FLOATING_RATE = 2;
const int CouponType_STRUCTURED = 3;
const char CouponFrequencyUnit_DAY[] = "D";
const char CouponFrequencyUnit_WEEK[] = "Wk";
const char CouponFrequencyUnit_MONTH[] = "Mo";
const char CouponFrequencyUnit_YEAR[] = "Yr";
const char CouponFrequencyUnit_HOUR[] = "H";
const char CouponFrequencyUnit_MINUTE[] = "Min";
const char CouponFrequencyUnit_SECOND[] = "S";
const char CouponFrequencyUnit_TERM[] = "T";
const int CouponDayCount_ONE_ONE = 0;
const int CouponDayCount_THIRTY_THREE_SIXTY_US = 1;
const int CouponDayCount_THIRTY_THREE_SIXTY_SIA = 2;
const int CouponDayCount_THIRTY_THREE_SIXTY_M = 3;
const int CouponDayCount_THIRTY_E_THREE_SIXTY = 4;
const int CouponDayCount_THIRTY_E_THREE_SIXTY_ISDA = 5;
const int CouponDayCount_ACT_THREE_SIXTY = 6;
const int CouponDayCount_ACT_THREE_SIXTY_FIVE_FIXED = 7;
const int CouponDayCount_ACT_ACT_AFB = 8;
const int CouponDayCount_ACT_ACT_ICMA = 9;
const int CouponDayCount_ACT_ACT_ISMA_ULTIMO = 10;
const int CouponDayCount_ACT_ACT_ISDA = 11;
const int CouponDayCount_BUS_TWO_FIFTY_TWO = 12;
const int CouponDayCount_THIRTY_E_PLUS_THREE_SIXTY = 13;
const int CouponDayCount_ACT_THREE_SIXTY_FIVE_L = 14;
const int CouponDayCount_NL_THREE_SIXTY_FIVE = 15;
const int CouponDayCount_NL_THREE_SIXTY = 16;
const int CouponDayCount_ACT364 = 17;
const int CouponDayCount_THIRTY_THREE_SIXTY_FIVE = 18;
const int CouponDayCount_THIRTY_ACTUAL = 19;
const int CouponDayCount_THIRTY_THREE_SIXTY_ICMA = 20;
const int CouponDayCount_THIRTY_E_TWO_THREE_SIXTY = 21;
const int CouponDayCount_THIRTY_E_THREE_THREE_SIXTY = 22;
const int CouponDayCount_OTHER = 99;
const int LienSeniority_UNKNOWN = 0;
const int LienSeniority_FIRST_LIEN = 1;
const int LienSeniority_SECOND_LIEN = 2;
const int LienSeniority_THIRD_LIEN = 3;
const int LoanFacility_BRIDGE_LOAN = 0;
const int LoanFacility_LETTER_OF_CREDIT = 1;
const int LoanFacility_REVOLVING_LOAN = 2;
const int LoanFacility_SWINGLINE_FUNDING = 3;
const int LoanFacility_TERM_LOAN = 4;
const int LoanFacility_TRADE_CLAIM = 5;
const int ReferenceEntityType_ASIAN = 1;
const int ReferenceEntityType_AUSTRALIAN_NEW_ZEALAND = 2;
const int ReferenceEntityType_EUROPEAN_EMERGING_MARKETS = 3;
const int ReferenceEntityType_JAPANESE = 4;
const int ReferenceEntityType_NORTH_AMERICAN_HIGH_YIELD = 5;
const int ReferenceEntityType_NORTH_AMERICAN_INSURANCE = 6;
const int ReferenceEntityType_NORTH_AMERICAN_INVESTMENT_GRADE = 7;
const int ReferenceEntityType_SINGAPOREAN = 8;
const int ReferenceEntityType_WESTERN_EUROPEAN = 9;
const int ReferenceEntityType_WESTERN_EUROPEAN_INSURANCE = 10;
const int BlockTrdAllocIndicator_BLOCK_TO_BE_ALLOCATED = 0;
const int BlockTrdAllocIndicator_BLOCK_NOT_TO_BE_ALLOCATED = 1;
const int BlockTrdAllocIndicator_ALLOCATED_TRADE = 2;
const char UnderlyingObligationType_BOND[] = "0";
const char UnderlyingObligationType_CONVERTIBLE_BOND[] = "1";
const char UnderlyingObligationType_MORTGAGE[] = "2";
const char UnderlyingObligationType_LOAN[] = "3";
const int CashSettlQuoteMethod_BID = 0;
const int CashSettlQuoteMethod_MID = 1;
const int CashSettlQuoteMethod_OFFER = 2;
const int CashSettlValuationMethod_MARKET = 0;
const int CashSettlValuationMethod_HIGHEST = 1;
const int CashSettlValuationMethod_AVERAGE_MARKET = 2;
const int CashSettlValuationMethod_AVERAGE_HIGHEST = 3;
const int CashSettlValuationMethod_BLENDED_MARKET = 4;
const int CashSettlValuationMethod_BLENDED_HIGHEST = 5;
const int CashSettlValuationMethod_AVERAGE_BLENDED_MARKET = 6;
const int CashSettlValuationMethod_AVERAGE_BLENDED_HIGHEST = 7;
const int StreamType_PAYMENT_CASH_SETTLEMENT = 0;
const int StreamType_PHYSICAL_DELIVERY = 1;
const int ProvisionType_MANDATORY_EARLY_TERMINATION = 0;
const int ProvisionType_OPTIONAL_EARLY_TERMINATION = 1;
const int ProvisionType_CANCELABLE = 2;
const int ProvisionType_EXTENDABLE = 3;
const int ProvisionType_MUTUAL_EARLY_TERMINATION = 4;
const int ProvisionType_EVERGREEN = 5;
const int ProvisionType_CALLABLE = 6;
const int ProvisionType_PUTTABLE = 7;
const char ProvisionDateTenorUnit_DAY[] = "D";
const char ProvisionDateTenorUnit_WEEK[] = "Wk";
const char ProvisionDateTenorUnit_MONTH[] = "Mo";
const char ProvisionDateTenorUnit_YEAR[] = "Yr";
const int ProvisionCalculationAgent_EXERCISING_PARTY = 0;
const int ProvisionCalculationAgent_NON_EXERCISING_PARTY = 1;
const int ProvisionCalculationAgent_MASTER_AGREEENT = 2;
const int ProvisionCalculationAgent_SUPPLEMENT = 3;
const int ProvisionOptionSinglePartyBuyerSide_BUY = 1;
const int ProvisionOptionSinglePartyBuyerSide_SELL = 2;
const int ProvisionCashSettlMethod_CASH_PRICE = 0;
const int ProvisionCashSettlMethod_CASH_PRICE_ALTERNATE = 1;
const int ProvisionCashSettlMethod_PAR_YIELD_CURVE_ADJUSTED = 2;
const int ProvisionCashSettlMethod_ZERO_COUPON_YIELD_CURVE_ADJUSTED = 3;
const int ProvisionCashSettlMethod_PAR_YIELD_CURVE_UNADJUSTED = 4;
const int ProvisionCashSettlMethod_CROSS_CURRENCY = 5;
const int ProvisionCashSettlMethod_COLLATERALIZED_PRICE = 6;
const int ProvisionCashSettlQuoteType_BID = 0;
const int ProvisionCashSettlQuoteType_MID = 1;
const int ProvisionCashSettlQuoteType_OFFER = 2;
const int ProvisionCashSettlQuoteType_EXERCISING_PARTY_PAYS = 3;
const char ProvisionOptionExerciseEarliestDateOffsetUnit_DAY[] = "D";
const char ProvisionOptionExerciseEarliestDateOffsetUnit_WEEK[] = "Wk";
const char ProvisionOptionExerciseEarliestDateOffsetUnit_MONTH[] = "Mo";
const char ProvisionOptionExerciseEarliestDateOffsetUnit_YEAR[] = "Yr";
const int ProvisionOptionExerciseFixedDateType_UNADJUSTED = 0;
const int ProvisionOptionExerciseFixedDateType_ADJUSTED = 1;
const int ProvisionCashSettlPaymentDateType_UNADJUSTED = 0;
const int ProvisionCashSettlPaymentDateType_ADJUSTED = 1;
const char ProtectionTermEventUnit_DAY[] = "D";
const char ProtectionTermEventUnit_WEEK[] = "Wk";
const char ProtectionTermEventUnit_MONTH[] = "Mo";
const char ProtectionTermEventUnit_YEAR[] = "Yr";
const int ProtectionTermEventDayType_BUSINESS = 0;
const int ProtectionTermEventDayType_CALENDAR = 1;
const int ProtectionTermEventDayType_COMMODITY_BUSINESS = 2;
const int ProtectionTermEventDayType_CURRENCY_BUSINESS = 3;
const int ProtectionTermEventDayType_EXCHANGE_BUSINESS = 4;
const int ProtectionTermEventDayType_SCHEDULED_TRADING_DAY = 5;
const char ProtectionTermEventQualifier_RESTRUCTURING_MULTIPLE_HOLDING_OBLIGATIONS = 'H';
const char ProtectionTermEventQualifier_RESTRUCTURING_MULTIPLE_CREDIT_EVENT_NOTICES = 'E';
const char ProtectionTermEventQualifier_FLOATING_RATE_INTEREST_SHORTFALL = 'C';
const int PaymentType_BROKERAGE = 0;
const int PaymentType_UPFRONT_FEE = 1;
const int PaymentType_INDEPENDENT_AMOUNT_COLLATERAL = 2;
const int PaymentType_PRINCIPAL_EXCHANGE = 3;
const int PaymentType_NOVATION_TERMINATION = 4;
const int PaymentType_EARLY_TERMINATION_PROVISION = 5;
const int PaymentType_CANCELABLE_PROVISION = 6;
const int PaymentType_EXTENDIBLE_PROVISION = 7;
const int PaymentType_CAP_RATE_PROVISION = 8;
const int PaymentType_FLOOR_RATE_PROVISION = 9;
const int PaymentType_OPTION_PREMIUM = 10;
const int PaymentType_SETTLEMENT_PAYMENT = 11;
const int PaymentType_CASH_SETTL = 12;
const int PaymentType_SECURITY_LENDING = 13;
const int PaymentType_REBATE = 14;
const int PaymentType_OTHER = 99;
const int PaymentPaySide_BUY = 1;
const int PaymentPaySide_SELL = 2;
const int PaymentSettlStyle_STANDARD = 0;
const int PaymentSettlStyle_NET = 1;
const int PaymentSettlStyle_STANDARDF_NET = 2;
const int PaymentStreamType_PERIODIC = 0;
const int PaymentStreamType_INITIAL = 1;
const int PaymentStreamType_SINGLE = 2;
const int PaymentStreamType_DIVIDEND = 3;
const int PaymentStreamType_INTEREST = 4;
const int PaymentStreamType_DIVIDEND_RETURN = 5;
const int PaymentStreamType_PRICE_RETURN = 6;
const int PaymentStreamType_TOTAL_RETURN = 7;
const int PaymentStreamType_VARIANCE = 8;
const int PaymentStreamType_CORRELATION = 9;
const int PaymentStreamDiscountType_STANDARD = 0;
const int PaymentStreamDiscountType_FRA = 1;
const int PaymentStreamCompoundingMethod_NONE = 0;
const int PaymentStreamCompoundingMethod_FLAT = 1;
const int PaymentStreamCompoundingMethod_STRAIGHT = 2;
const int PaymentStreamCompoundingMethod_SPREAD_EXCLUSIVE = 3;
const char PaymentStreamPaymentFrequencyUnit_DAY[] = "D";
const char PaymentStreamPaymentFrequencyUnit_WEEK[] = "Wk";
const char PaymentStreamPaymentFrequencyUnit_MONTH[] = "Mo";
const char PaymentStreamPaymentFrequencyUnit_YEAR[] = "Yr";
const char PaymentStreamPaymentFrequencyUnit_TERM[] = "T";
const char PaymentStreamPaymentDateOffsetUnit_DAY[] = "D";
const char PaymentStreamPaymentDateOffsetUnit_WEEK[] = "Wk";
const char PaymentStreamPaymentDateOffsetUnit_MONTH[] = "Mo";
const char PaymentStreamPaymentDateOffsetUnit_YEAR[] = "Yr";
const char PaymentStreamResetWeeklyRollConvention_MONDAY[] = "MON";
const char PaymentStreamResetWeeklyRollConvention_TUESDAY[] = "TUE";
const char PaymentStreamResetWeeklyRollConvention_WEDNESDAY[] = "WED";
const char PaymentStreamResetWeeklyRollConvention_THURSDAY[] = "THU";
const char PaymentStreamResetWeeklyRollConvention_FRIDAY[] = "FRI";
const char PaymentStreamResetWeeklyRollConvention_SATURDAY[] = "SAT";
const char PaymentStreamResetWeeklyRollConvention_SUNDAY[] = "SUN";
const int PaymentStreamRateIndexSource_BLOOMBERG = 0;
const int PaymentStreamRateIndexSource_REUTERS = 1;
const int PaymentStreamRateIndexSource_TELERATE = 2;
const int PaymentStreamRateIndexSource_OTHER = 99;
const char PaymentStreamRateIndexCurveUnit_DAY[] = "D";
const char PaymentStreamRateIndexCurveUnit_WEEK[] = "Wk";
const char PaymentStreamRateIndexCurveUnit_MONTH[] = "Mo";
const char PaymentStreamRateIndexCurveUnit_YEAR[] = "Yr";
const int PaymentStreamRateSpreadPositionType_SHORT = 0;
const int PaymentStreamRateSpreadPositionType_LONG = 1;
const int PaymentStreamRateTreatment_BOND_EQUIVALENT_YIELD = 0;
const int PaymentStreamRateTreatment_MONEY_MARKET_YIELD = 1;
const int PaymentStreamCapRateBuySide_BUYER = 1;
const int PaymentStreamCapRateBuySide_SELLER = 2;
const int PaymentStreamFloorRateBuySide_BUYER = 1;
const int PaymentStreamFloorRateBuySide_SELLER = 2;
const int PaymentStreamAveragingMethod_UNWEIGHTED = 0;
const int PaymentStreamAveragingMethod_WEIGHTED = 1;
const int PaymentStreamNegativeRateTreatment_ZERO_INTEREST_RATE_METHOD = 0;
const int PaymentStreamNegativeRateTreatment_NEGATIVE_INTEREST_RATE_METHOD = 1;
const char PaymentStreamInflationLagUnit_DAY[] = "D";
const char PaymentStreamInflationLagUnit_WEEK[] = "Wk";
const char PaymentStreamInflationLagUnit_MONTH[] = "Mo";
const char PaymentStreamInflationLagUnit_YEAR[] = "Yr";
const int PaymentStreamInflationLagDayType_BUSINESS = 0;
const int PaymentStreamInflationLagDayType_CALENDAR = 1;
const int PaymentStreamInflationLagDayType_COMMODITY_BUSINESS = 2;
const int PaymentStreamInflationLagDayType_CURRENCY_BUSINESS = 3;
const int PaymentStreamInflationLagDayType_EXCHANGE_BUSINESS = 4;
const int PaymentStreamInflationLagDayType_SCHEDULED_TRADING_DAY = 5;
const int PaymentStreamInflationInterpolationMethod_NONE = 0;
const int PaymentStreamInflationInterpolationMethod_LINEAR_ZERO_YIELD = 1;
const int PaymentStreamFRADiscounting_NONE = 0;
const int PaymentStreamFRADiscounting_ISDA = 1;
const int PaymentStreamFRADiscounting_AFMA = 2;
const int NonDeliverableFixingDateType_UNADJUSTED = 0;
const int NonDeliverableFixingDateType_ADJUSTED = 1;
const int PaymentScheduleType_NOTIONAL = 0;
const int PaymentScheduleType_CASH_FLOW = 1;
const int PaymentScheduleType_FX_LINKED_NOTIONAL = 2;
const int PaymentScheduleType_FIXED_RATE = 3;
const int PaymentScheduleType_FUTURE_VALUE_NOTIONAL = 4;
const int PaymentScheduleType_KNOWN_AMOUNT = 5;
const int PaymentScheduleType_FLOATING_RATE_MULTIPLIER = 6;
const int PaymentScheduleType_SPREAD = 7;
const int PaymentScheduleType_CAP_RATE = 8;
const int PaymentScheduleType_FLOOR_RATE = 9;
const int PaymentScheduleType_NON_DELIVERABLE_SETTL_PAYMENT_DATES = 10;
const int PaymentScheduleType_NON_DELIVERABLE_SETTL_CALCULATION_DATES = 11;
const int PaymentScheduleType_NON_DELIVERABLE_FX_FIXING_DATES = 12;
const int PaymentScheduleType_SETTL_PERIOD_NOTNL = 13;
const int PaymentScheduleType_SETTL_PERIOD_PX = 14;
const int PaymentScheduleType_CALC_PERIOD = 15;
const int PaymentScheduleType_DIVIDEND_ACCRUAL_RATE_MULTIPLIER = 16;
const int PaymentScheduleType_DIVIDEND_ACCRUAL_RATE_SPREAD = 17;
const int PaymentScheduleType_DIVIDEND_ACCRUAL_CAP_RATE = 18;
const int PaymentScheduleType_DIVIDEND_ACCRUAL_FLOOR_RATE = 19;
const int PaymentScheduleType_COMPOUNDING_RATE_MULTIPLIER = 20;
const int PaymentScheduleType_COMPOUNDING_RATE_SPREAD = 21;
const int PaymentScheduleType_COMPOUNDING_CAP_RATE = 22;
const int PaymentScheduleType_COMPOUNDING_FLOOR_RATE = 23;
const int PaymentScheduleStepRelativeTo_INITIAL = 0;
const int PaymentScheduleStepRelativeTo_PREVIOUS = 1;
const int PaymentStubType_INITIAL = 0;
const int PaymentStubType_FINAL = 1;
const int PaymentStubType_COMPOUNDING_INITIAL = 2;
const int PaymentStubType_COMPOUNDING_FINAL = 3;
const int PaymentStubLength_SHORT = 0;
const int PaymentStubLength_LONG = 1;
const int PaymentStreamPaymentDateOffsetDayType_BUSINESS = 0;
const int PaymentStreamPaymentDateOffsetDayType_CALENDAR = 1;
const int PaymentStreamPaymentDateOffsetDayType_COMMODITY_BUSINESS = 2;
const int PaymentStreamPaymentDateOffsetDayType_CURRENCY_BUSINESS = 3;
const int PaymentStreamPaymentDateOffsetDayType_EXCHANGE_BUSINESS = 4;
const int PaymentStreamPaymentDateOffsetDayType_SCHEDULED_TRADING_DAY = 5;
const int BusinessDayConvention_NOT_APPLICABLE = 0;
const int BusinessDayConvention_NONE = 1;
const int BusinessDayConvention_FOLLOWING_DAY = 2;
const int BusinessDayConvention_FLOATING_RATE_NOTE = 3;
const int BusinessDayConvention_MODIFIED_FOLLOWING_DAY = 4;
const int BusinessDayConvention_PRECEDING_DAY = 5;
const int BusinessDayConvention_MODIFIED_PRECEDING_DAY = 6;
const int BusinessDayConvention_NEAREST_DAY = 7;
const char DateRollConvention_FIRST_DAY[] = "1";
const char DateRollConvention_SECOND_DAY[] = "2";
const char DateRollConvention_THIRD_DAY[] = "3";
const char DateRollConvention_FOURTH_DAY[] = "4";
const char DateRollConvention_FIFTH_DAY[] = "5";
const char DateRollConvention_SIXTH_DAY[] = "6";
const char DateRollConvention_SEVENTH_DAY[] = "7";
const char DateRollConvention_EIGHTH_DAY[] = "8";
const char DateRollConvention_NINTH_DAY[] = "9";
const char DateRollConvention_TENTH_DAY[] = "10";
const char DateRollConvention_ELEVENTH_DAY[] = "11";
const char DateRollConvention_TWELVTH_DAY[] = "12";
const char DateRollConvention_THIRTEENTH_DAY[] = "13";
const char DateRollConvention_FORTEENTH_DAY[] = "14";
const char DateRollConvention_FIFTEENTH_DAY[] = "15";
const char DateRollConvention_SIXTEENTH_DAY[] = "16";
const char DateRollConvention_SEVENTEENTH_DAY[] = "17";
const char DateRollConvention_EIGHTEENTH_DAY[] = "18";
const char DateRollConvention_NINETEENTH_DAY[] = "19";
const char DateRollConvention_TWENTIETH_DAY[] = "20";
const char DateRollConvention_TWENTY_FIRST_DAY[] = "21";
const char DateRollConvention_TWENTY_SECOND_DAY[] = "22";
const char DateRollConvention_TWENTY_THIRD_DAY[] = "23";
const char DateRollConvention_TWENTY_FOURTH_DAY[] = "24";
const char DateRollConvention_TWENTY_FIFTH_DAY[] = "25";
const char DateRollConvention_TWENTY_SIXTH_DAY[] = "26";
const char DateRollConvention_TWENTY_SEVENTH_DAY[] = "27";
const char DateRollConvention_TWENTY_EIGTH_DA28Y[] = "28";
const char DateRollConvention_TWENTY_NINTH_DAY[] = "29";
const char DateRollConvention_THIRTIETH_DAY[] = "30";
const char DateRollConvention_EOM[] = "EOM";
const char DateRollConvention_FRN[] = "FRN";
const char DateRollConvention_IMM[] = "IMM";
const char DateRollConvention_IMMCAD[] = "IMMCAD";
const char DateRollConvention_IMMAUD[] = "IMMAUD";
const char DateRollConvention_IMMNZD[] = "IMMNZD";
const char DateRollConvention_SFE[] = "SFE";
const char DateRollConvention_NONE[] = "NONE";
const char DateRollConvention_TBILL[] = "TBILL";
const char DateRollConvention_MON[] = "MON";
const char DateRollConvention_TUE[] = "TUE";
const char DateRollConvention_WED[] = "WED";
const char DateRollConvention_THU[] = "THU";
const char DateRollConvention_FRI[] = "FRI";
const char DateRollConvention_SAT[] = "SAT";
const char DateRollConvention_SUN[] = "SUN";
const int AttachmentEncodingType_BASE64 = 0;
const int AttachmentEncodingType_RAW_BINARY = 1;
const int NegotiationMethod_AUTO_SPOT = 0;
const int NegotiationMethod_NEGOTIATED_SPOT = 1;
const int NegotiationMethod_PHONE_SPOT = 2;
const int ComplexEventPeriodType_ASIAN_OUT = 0;
const int ComplexEventPeriodType_ASIAN_IN = 1;
const int ComplexEventPeriodType_BARRIER_CAP = 2;
const int ComplexEventPeriodType_BARRIER_FLOOR = 3;
const int ComplexEventPeriodType_KNOCK_OUT = 4;
const int ComplexEventPeriodType_KNOCK_IN = 5;
const int ComplexEventDateOffsetDayType_BUSINESS = 0;
const int ComplexEventDateOffsetDayType_CALENDAR = 1;
const int ComplexEventDateOffsetDayType_COMMODITY_BUSINESS = 2;
const int ComplexEventDateOffsetDayType_CURRENCY_BUSINESS = 3;
const int ComplexEventDateOffsetDayType_EXCHANGE_BUSINESS = 4;
const int ComplexEventDateOffsetDayType_SCHEDULED_TRADING_DAY = 5;
const int ComplexOptPayoutTime_CLOSE = 0;
const int ComplexOptPayoutTime_OPEN = 1;
const int ComplexOptPayoutTime_OFFICIAL_SETTL = 2;
const int ComplexOptPayoutTime_VALUATION_TIME = 3;
const int ComplexOptPayoutTime_EXCAHGNE_SETTL_TIME = 4;
const int ComplexOptPayoutTime_DERIVATIVES_CLOSE = 5;
const int ComplexOptPayoutTime_AS_SPECIFIED = 6;
const int ComplexEventQuoteBasis_CURRENCY1_PER_CURRENCY2 = 0;
const int ComplexEventQuoteBasis_CURRENCY2_PER_CURRENCY1 = 1;
const int ComplexEventCreditEventNotifyingParty_SELLER_NOTIFIES = 0;
const int ComplexEventCreditEventNotifyingParty_BUYER_NOTIFIES = 1;
const int ComplexEventCreditEventNotifyingParty_SELLER_OR_BUYER_NOTIFIES = 2;
const int DeliveryScheduleType_NOTIONAL = 0;
const int DeliveryScheduleType_DELIVERY = 1;
const int DeliveryScheduleType_PHYSICAL_SETTL_PERIODS = 2;
const int DeliveryScheduleToleranceType_ABSOLUTE = 0;
const int DeliveryScheduleToleranceType_PERCENTAGE = 1;
const int DeliveryScheduleSettlFlowType_ALL_TIMES = 0;
const int DeliveryScheduleSettlFlowType_ON_PEAK = 1;
const int DeliveryScheduleSettlFlowType_OFF_PEAK = 2;
const int DeliveryScheduleSettlFlowType_BASE = 3;
const int DeliveryScheduleSettlFlowType_BLOCK_HOURS = 4;
const int DeliveryScheduleSettlFlowType_OTHER = 5;
const int DeliveryScheduleSettlHolidaysProcessingInstruction_DO_NOT_INCLUDE_HOLIDAYS = 0;
const int DeliveryScheduleSettlHolidaysProcessingInstruction_INCLUDE_HOLIDAYS = 1;
const int DeliveryScheduleSettlDay_MONDAY = 1;
const int DeliveryScheduleSettlDay_TUESDAY = 2;
const int DeliveryScheduleSettlDay_WEDNESDAY = 3;
const int DeliveryScheduleSettlDay_THURSDAY = 4;
const int DeliveryScheduleSettlDay_FRIDAY = 5;
const int DeliveryScheduleSettlDay_SATURDAY = 6;
const int DeliveryScheduleSettlDay_SUNDAY = 7;
const int DeliveryScheduleSettlDay_ALL_WEEKDAYS = 8;
const int DeliveryScheduleSettlDay_ALL_DAYS = 9;
const int DeliveryScheduleSettlDay_ALL_WEEKENDS = 10;
const int DeliveryScheduleSettlTimeType_HOUR = 0;
const int DeliveryScheduleSettlTimeType_TIMESTAMP = 1;
const int DeliveryStreamType_PERIODIC = 0;
const int DeliveryStreamType_INITIAL = 1;
const int DeliveryStreamType_SINGLE = 2;
const int DeliveryStreamDeliveryRestriction_FIRM = 1;
const int DeliveryStreamDeliveryRestriction_NON_FIRM = 2;
const int DeliveryStreamDeliveryRestriction_FORCE_MAJEURE = 3;
const int DeliveryStreamDeliveryRestriction_SYSTEM_FIRM = 4;
const int DeliveryStreamDeliveryRestriction_UNIT_FIRM = 5;
const int DeliveryStreamTitleTransferCondition_TRANSFERS = 0;
const int DeliveryStreamTitleTransferCondition_DOES_NOT_TRANSFER = 1;
const int DeliveryStreamToleranceOptionSide_BUYER = 1;
const int DeliveryStreamToleranceOptionSide_SELLER = 2;
const int DeliveryStreamElectingPartySide_BUYER = 0;
const int DeliveryStreamElectingPartySide_SELLER = 1;
const char SwapSubClass_AMORTIZING[] = "AMTZ";
const char SwapSubClass_COMPOUNDING[] = "COMP";
const char SwapSubClass_CONSTANT_NOTIONAL_SCHEDULE[] = "CNST";
const char SwapSubClass_ACCRETING_NOTIONAL_SCHEDULE[] = "ACRT";
const char SwapSubClass_CUSTOM_NOTIONAL_SCHEDULE[] = "CUST";
const char StrategyType_STRADDLE[] = "STD";
const char StrategyType_STRANGLE[] = "STG";
const char StrategyType_BUTTERFLY[] = "BF";
const char StrategyType_CONDOR[] = "CNDR";
const char StrategyType_CALLABLE_INVERSIBLE_SNOWBALL[] = "CISN";
const char StrategyType_OTHER[] = "OTHER";
const int SettlDisruptionProvision_NEGOTIATION = 1;
const int SettlDisruptionProvision_CANCELLATION = 2;
const int MarketDisruptionProvision_NOT_APPLICABLE = 0;
const int MarketDisruptionProvision_APPLICABLE = 1;
const int MarketDisruptionProvision_AS_IN_MASTER_AGREEMENT = 2;
const int MarketDisruptionProvision_AS_IN_CONFIRMATION = 3;
const int MarketDisruptionFallbackProvision_MASTER_AGREEMENT = 0;
const int MarketDisruptionFallbackProvision_CONFIRMATION = 1;
const int MarketDisruptionFallbackUnderlierType_BASKET = 0;
const int MarketDisruptionFallbackUnderlierType_BOND = 1;
const int MarketDisruptionFallbackUnderlierType_CASH = 2;
const int MarketDisruptionFallbackUnderlierType_COMMODITY = 3;
const int MarketDisruptionFallbackUnderlierType_CONVERTIBLE_BOND = 4;
const int MarketDisruptionFallbackUnderlierType_EQUITY = 5;
const int MarketDisruptionFallbackUnderlierType_EXCHANGE_TRADED_FUND = 6;
const int MarketDisruptionFallbackUnderlierType_FUTURE = 7;
const int MarketDisruptionFallbackUnderlierType_INDEX = 8;
const int MarketDisruptionFallbackUnderlierType_LOAN = 9;
const int MarketDisruptionFallbackUnderlierType_MORTGAGE = 10;
const int MarketDisruptionFallbackUnderlierType_MUTUAL_FUND = 11;
const int ExerciseConfirmationMethod_NOT_REQUIRED = 0;
const int ExerciseConfirmationMethod_NON_ELECTRONIC = 1;
const int ExerciseConfirmationMethod_ELECTRONIC = 2;
const int ExerciseConfirmationMethod_UNKNOWN = 3;
const int OptionExerciseDateType_UNADJUSTED = 0;
const int OptionExerciseDateType_ADJUSTED = 1;
const int PaymentDateOffsetDayType_BUSINESS = 0;
const int PaymentDateOffsetDayType_CALENDAR = 1;
const int PaymentDateOffsetDayType_COMMODITY = 2;
const int PaymentDateOffsetDayType_CURRENCY = 3;
const int PaymentDateOffsetDayType_EXCHANGE = 4;
const int PaymentDateOffsetDayType_SCHEDULED = 5;
const int PaymentForwardStartType_PREPAID = 0;
const int PaymentForwardStartType_POSTPAID = 1;
const int PaymentForwardStartType_VARIABLE = 2;
const int PaymentForwardStartType_FIXED = 3;
const int PaymentStreamSettlLevel_AVERAGE = 0;
const int PaymentStreamSettlLevel_MAXIMUM = 1;
const int PaymentStreamSettlLevel_MINIMUM = 2;
const int PaymentStreamSettlLevel_CUMULATIVE = 3;
const int PaymentStreamRateSpreadType_ABSOLUTE = 0;
const int PaymentStreamRateSpreadType_PERCENTAGE = 1;
const int PaymentStreamPricingDayDistribution_ALL = 0;
const int PaymentStreamPricingDayDistribution_FIRST = 1;
const int PaymentStreamPricingDayDistribution_LAST = 2;
const int PaymentStreamPricingDayDistribution_PENULTIMATE = 3;
const int PaymentStreamPricingDayOfWeek_EVERY_DAY = 0;
const int PaymentStreamPricingDayOfWeek_MONDAY = 1;
const int PaymentStreamPricingDayOfWeek_TUESDAY = 2;
const int PaymentStreamPricingDayOfWeek_WEDNESDAY = 3;
const int PaymentStreamPricingDayOfWeek_THURSDAY = 4;
const int PaymentStreamPricingDayOfWeek_FRIDAY = 5;
const int PaymentStreamPricingDayOfWeek_SATURDAY = 6;
const int PaymentStreamPricingDayOfWeek_SUNDAY = 7;
const char StreamCommodityNearbySettlDayUnit_WEEK[] = "Wk";
const char StreamCommodityNearbySettlDayUnit_MONTH[] = "Mo";
const char StreamCommoditySettlDateRollUnit_DAY[] = "D";
const int StreamCommodityDataSourceIDType_CITY = 0;
const int StreamCommodityDataSourceIDType_AIRPORT = 1;
const int StreamCommodityDataSourceIDType_WEATHER_STATION = 2;
const int StreamCommodityDataSourceIDType_WEATHER_INDEX = 3;
const int StreamNotionalCommodityFrequency_TERM = 0;
const int StreamNotionalCommodityFrequency_PER_BUSINESS_DAY = 1;
const int StreamNotionalCommodityFrequency_PER_CALCULATION_PERIOD = 2;
const int StreamNotionalCommodityFrequency_PER_SETTL_PERIOD = 3;
const int StreamNotionalCommodityFrequency_PER_CALENDAR_DAY = 4;
const int StreamNotionalCommodityFrequency_PER_HOUR = 5;
const int StreamNotionalCommodityFrequency_PER_MONTH = 6;
const int RiskLimitReportStatus_ACCEPTED = 0;
const int RiskLimitReportStatus_REJECTED = 1;
const int RiskLimitReportRejectReason_UNK_RISK_LMT_RPRT_ID = 0;
const int RiskLimitReportRejectReason_UNK_PTY = 1;
const int RiskLimitReportRejectReason_OTHER = 99;
const int RiskLimitCheckTransType_NEW = 0;
const int RiskLimitCheckTransType_CANCEL = 1;
const int RiskLimitCheckTransType_REPLACE = 2;
const int RiskLimitCheckType_SUBMIT = 0;
const int RiskLimitCheckType_LIMIT_CONSUMED = 1;
const int RiskLimitCheckRequestType_ALL_OR_NONE = 0;
const int RiskLimitCheckRequestType_PARTIAL = 1;
const int RiskLimitCheckRequestStatus_APPROVED = 0;
const int RiskLimitCheckRequestStatus_PARTIALLY_APPROVED = 1;
const int RiskLimitCheckRequestStatus_REJECTED = 2;
const int RiskLimitCheckRequestStatus_APPROVAL_PENDING = 3;
const int RiskLimitCheckRequestStatus_CANCELLED = 4;
const int RiskLimitCheckRequestResult_SUCCESSFUL = 0;
const int RiskLimitCheckRequestResult_INVALID_PARTY = 1;
const int RiskLimitCheckRequestResult_REQ_EXCEEDS_CREDIT_LIMIT = 2;
const int RiskLimitCheckRequestResult_REQ_EXCEEDS_CLIP_SIZE_LIMIT = 3;
const int RiskLimitCheckRequestResult_REQ_EXCEEDS_MAX_NOTIONAL = 4;
const int RiskLimitCheckRequestResult_OTHER = 99;
const int PartyActionType_SUSPEND = 0;
const int PartyActionType_HALT_TRADING = 1;
const int PartyActionType_REINSTATE = 2;
const int PartyActionResponse_ACCEPTED = 0;
const int PartyActionResponse_COMPLETED = 1;
const int PartyActionResponse_REJECTED = 2;
const int PartyActionRejectReason_INVALID_PARTY = 0;
const int PartyActionRejectReason_UNK_REQ_PARTY = 1;
const int PartyActionRejectReason_NOT_AUTHORIZED = 98;
const int PartyActionRejectReason_OTHER = 99;
const int RefRiskLimitCheckIDType_RISK_LIMIT_REQUEST_ID = 0;
const int RefRiskLimitCheckIDType_RISK_LIMIT_CHECK_ID = 1;
const int RefRiskLimitCheckIDType_OUT_OF_BAND_ID = 3;
const int RiskLimitCheckModelType_NONE = 0;
const int RiskLimitCheckModelType_PLUS_ONE_MODEL = 1;
const int RiskLimitCheckModelType_PING_MODEL = 2;
const int RiskLimitCheckModelType_PUSH_MODEL = 3;
const int RiskLimitCheckStatus_ACCEPTED = 0;
const int RiskLimitCheckStatus_REJECTED = 1;
const int RiskLimitCheckStatus_CLAIM_REQUIRED = 2;
const int RiskLimitCheckStatus_PRE_DEFINED_LIMIT_CHECK_SUCCEEDED = 3;
const int RiskLimitCheckStatus_PRE_DEFINED_LIMIT_CHECK_FAILED = 4;
const int RiskLimitCheckStatus_PRE_DEFINED_AUTO_ACCEPT_RULE_INVOKED = 5;
const int RiskLimitCheckStatus_PRE_DEFINED_AUTO_REJECT_RULE_INVOKED = 6;
const int RiskLimitCheckStatus_ACCEPTED_BY_CLEARING_FIRM = 7;
const int RiskLimitCheckStatus_REJECTED_BY_CLEARING_FIRM = 8;
const int RiskLimitCheckStatus_PENDING = 9;
const int RiskLimitCheckStatus_ACCEPTED_BY_CREDIT_HUB = 10;
const int RiskLimitCheckStatus_REJECTED_BY_CREDIT_HUB = 11;
const int RiskLimitCheckStatus_PENDING_CREDIT_HUB_CHECK = 12;
const int RiskLimitCheckStatus_ACCEPTED_BY_EXEC_VENUE = 13;
const int RiskLimitCheckStatus_REJECTED_BY_EXEC_VENUE = 14;
const int RegulatoryTransactionType_NONE = 0;
const int RegulatoryTransactionType_SEF_REQUIRED_TRANSACTION = 1;
const int RegulatoryTransactionType_SEF_PERMITTED_TRANSACTION = 2;
const int BatchProcessMode_UPDATE = 0;
const int BatchProcessMode_SNAPSHOT = 1;
const int DeliveryStreamDeliveryPointSource_PROPRIETARY = 0;
const int DeliveryStreamDeliveryPointSource_EIC = 1;
const char TaxonomyType_ISIN_OR_ALT_INSTRMT_ID = 'I';
const char TaxonomyType_INTERIM_TAXONOMY = 'E';
const int RegulatoryTradeIDScope_CLEARING_MEMBER = 1;
const int RegulatoryTradeIDScope_CLIENT = 2;
const int EntitlementSubType_ORDER_ENTRY = 1;
const int EntitlementSubType_H_IT_LIFT = 2;
const int EntitlementSubType_VIEW_INDICATIVE_PX = 3;
const int EntitlementSubType_VIEW_EXECUTABLE_PX = 4;
const int EntitlementSubType_SINGLE_QUOTE = 5;
const int EntitlementSubType_STREAMING_QUOTES = 6;
const int EntitlementSubType_SINGLE_BROKER = 7;
const int EntitlementSubType_MULTI_BROKERS = 8;
const int QuoteModelType_QUOTE_ENTRY = 1;
const int QuoteModelType_QUOTE_MODIFICATION = 2;
const int ExecMethod_UNSPECIFIED = 0;
const int ExecMethod_MANUAL = 1;
const int ExecMethod_AUTOMATED = 2;
const int ExecMethod_VOICE_BROKERED = 3;
const int TradeContingency_DOES_NOT_APPLY = 0;
const int TradeContingency_CONTINGENT_TRADE = 1;
const int TradeContingency_NON_CONTINGENT_TRADE = 2;
const int PaymentSubType_INITIAL = 0;
const int PaymentSubType_INTERMEDIATE = 1;
const int PaymentSubType_FINAL = 2;
const int PaymentSubType_PREPAID = 3;
const int PaymentSubType_POSTPAID = 4;
const int PaymentSubType_VARIABLE = 5;
const int PaymentSubType_FIXED = 6;
const int PaymentSubType_SWAP = 7;
const int PaymentSubType_CONDITIONAL = 8;
const int PaymentSubType_FIXED_RATE = 9;
const int PaymentSubType_FLOATING_RATE = 10;
const int MassOrderRequestStatus_ACCEPTED = 1;
const int MassOrderRequestStatus_ACCEPTED_WITH_ADDITIONAL_EVENTS = 2;
const int MassOrderRequestStatus_REJECTED = 3;
const int MassOrderRequestResult_SUCCESSFUL = 0;
const int MassOrderRequestResult_RESPONSE_LEVEL_NOT_SUPPORTED = 1;
const int MassOrderRequestResult_INVALID_MARKET = 2;
const int MassOrderRequestResult_INVALID_MARKET_SEGMENT = 3;
const int MassOrderRequestResult_OTHER = 99;
const int OrderResponseLevel_NO_ACK = 0;
const int OrderResponseLevel_MINIMUM_ACK = 1;
const int OrderResponseLevel_ACK_EACH = 2;
const int OrderResponseLevel_SUMMARY_ACK = 3;
const char OrderEntryAction_ADD = '1';
const char OrderEntryAction_MODIFY = '2';
const char OrderEntryAction_DELETE = '3';
const char OrderEntryAction_SUSPEND = '4';
const char OrderEntryAction_RELEASE = '5';
const int ExecTypeReason_ORD_ADDED_ON_REQUEST = 1;
const int ExecTypeReason_ORD_REPLACED_ON_REQUEST = 2;
const int ExecTypeReason_ORD_CXLD_ON_REQUEST = 3;
const int ExecTypeReason_UNSOLICITED_ORD_CXL = 4;
const int ExecTypeReason_NON_RESTING_ORD_ADDED_ON_REQUEST = 5;
const int ExecTypeReason_ORD_REPLACED_WITH_NON_RESTING_ORD_ON_REQUEST = 6;
const int ExecTypeReason_TRIGGER_ORD_REPLACED_ON_REQUEST = 7;
const int ExecTypeReason_SUSPENDED_ORD_REPLACED_ON_REQUEST = 8;
const int ExecTypeReason_SUSPENDED_ORD_CXLD_ON_REQUEST = 9;
const int ExecTypeReason_ORD_CXL_PENDING = 10;
const int ExecTypeReason_PENDING_CXL_EXECUTED = 11;
const int ExecTypeReason_RESTING_ORD_TRIGGERED = 12;
const int ExecTypeReason_SUSPENDED_ORD_ACTIVATED = 13;
const int ExecTypeReason_ACTIVE_ORD_SUSPENDED = 14;
const int ExecTypeReason_ORD_EXPIRED = 15;
const int TransferTransType_NEW = 0;
const int TransferTransType_REPLACE = 1;
const int TransferTransType_CANCEL = 2;
const int TransferType_REQUEST_TRANSFER = 0;
const int TransferType_ACCEPT_TRANSFER = 1;
const int TransferType_DECLINE_TRANSFER = 2;
const int TransferScope_INTER_FIRM_TRANSFER = 0;
const int TransferScope_INTRA_FIRM_TRANSFER = 1;
const int TransferScope_CMTA = 2;
const int TransferStatus_RECEIVED = 0;
const int TransferStatus_REJECTED_BY_INTERMEDIARY = 1;
const int TransferStatus_ACCEPT_PENDING = 2;
const int TransferStatus_ACCEPTED = 3;
const int TransferStatus_DECLINED = 4;
const int TransferStatus_CANCELLED = 5;
const int TransferRejectReason_SUCCESS = 0;
const int TransferRejectReason_INVALID_PARTY = 1;
const int TransferRejectReason_UNKNOWN_INSTRUMENT = 2;
const int TransferRejectReason_UNAUTHORIZED_TO_SUBMIT_XFER = 3;
const int TransferRejectReason_UNKNOWN_POSITION = 4;
const int TransferRejectReason_OTHER = 99;
const int TransferReportType_SUBMIT = 0;
const int TransferReportType_ALLEGED = 1;
const int MDStatisticType_COUNT = 1;
const int MDStatisticType_AVERAGE_VOLUME = 2;
const int MDStatisticType_TOTAL_VOLUME = 3;
const int MDStatisticType_DISTRIBUTION = 4;
const int MDStatisticType_RATIO = 5;
const int MDStatisticType_LIQUIDITY = 6;
const int MDStatisticType_VWAP = 7;
const int MDStatisticType_VOLATILITY = 8;
const int MDStatisticType_DURATION = 9;
const int MDStatisticType_TICK = 10;
const int MDStatisticType_AVERAGE_VALUE = 11;
const int MDStatisticType_TOTAL_VALUE = 12;
const int MDStatisticType_HIGH = 13;
const int MDStatisticType_LOW = 14;
const int MDStatisticType_MIDPOINT = 15;
const int MDStatisticType_FIRST = 16;
const int MDStatisticType_LAST = 17;
const int MDStatisticType_FINAL = 18;
const int MDStatisticType_EXCHANGE_BEST = 19;
const int MDStatisticType_EXCHANGE_BEST_WITH_VOLUME = 20;
const int MDStatisticType_CONSOLIDATED_BEST = 21;
const int MDStatisticType_CONSOLIDATED_BEST_WITH_VOLUME = 22;
const int MDStatisticType_TWAP = 23;
const int MDStatisticType_AVERAGE_DURATION = 24;
const int MDStatisticType_AVERAGE_PRICE = 25;
const int MDStatisticType_TOTAL_FEES = 26;
const int MDStatisticType_TOTAL_BENEFITS = 27;
const int MDStatisticType_MEDIAN_VALUE = 28;
const int MDStatisticType_AVERAGE_LIQUIDITY = 29;
const int MDStatisticType_MEDIAN_DURATION = 30;
const int MDStatisticScope_BID_PRICES = 1;
const int MDStatisticScope_OFFER_PRICES = 2;
const int MDStatisticScope_BID_DEPTH = 3;
const int MDStatisticScope_OFFER_DEPTH = 4;
const int MDStatisticScope_ORDERS = 5;
const int MDStatisticScope_QUOTES = 6;
const int MDStatisticScope_ORDERS_AND_QUOTES = 7;
const int MDStatisticScope_TRADES = 8;
const int MDStatisticScope_TRADE_PRICES = 9;
const int MDStatisticScope_AUCTION_PRICES = 10;
const int MDStatisticScope_OPENING_PRICES = 11;
const int MDStatisticScope_CLOSING_PRICES = 12;
const int MDStatisticScope_SETTLEMENT_PRICES = 13;
const int MDStatisticScope_UNDERLYING_PRICES = 14;
const int MDStatisticScope_OPEN_INTEREST = 15;
const int MDStatisticScope_INDEX_VALUES = 16;
const int MDStatisticScope_MARGIN_RATES = 17;
const int MDStatisticScope_OUTAGES = 18;
const int MDStatisticScope_SCHEDULED_AUCTIONS = 19;
const int MDStatisticScope_REFERENCE_PRICES = 20;
const int MDStatisticScope_TRADE_VALUE = 21;
const int MDStatisticScope_MARKET_DATA_FEE_ITEMS = 22;
const int MDStatisticScope_REBATES = 23;
const int MDStatisticScope_DISCOUNTS = 24;
const int MDStatisticScope_PAYMENTS = 25;
const int MDStatisticScope_TAXES = 26;
const int MDStatisticScope_LEVIES = 27;
const int MDStatisticScope_BENEFITS = 28;
const int MDStatisticScope_FEES = 29;
const int MDStatisticScope_ORDERS_RF_QS = 30;
const int MDStatisticScope_MARKET_MAKERS = 31;
const int MDStatisticScope_TRADING_INTERRUPTIONS = 32;
const int MDStatisticScope_TRADING_SUSPENSIONS = 33;
const int MDStatisticScope_NO_QUOTES = 34;
const int MDStatisticScope_REQUEST_FOR_QUOTES = 35;
const int MDStatisticScope_TRADE_VOLUME = 36;
const int MDStatisticSubScope_VISIBLE = 1;
const int MDStatisticSubScope_HIDDEN = 2;
const int MDStatisticSubScope_INDICATIVE = 3;
const int MDStatisticSubScope_TRADEABLE = 4;
const int MDStatisticSubScope_PASSIVE = 5;
const int MDStatisticSubScope_MARKET_CONSENSUS = 6;
const int MDStatisticSubScope_POWER = 7;
const int MDStatisticSubScope_HARDWARE_ERROR = 8;
const int MDStatisticSubScope_SOFTWARE_ERROR = 9;
const int MDStatisticSubScope_NETWORK_ERROR = 10;
const int MDStatisticSubScope_FAILED = 11;
const int MDStatisticSubScope_EXECUTED = 12;
const int MDStatisticSubScope_ENTERED = 13;
const int MDStatisticSubScope_MODIFIED = 14;
const int MDStatisticSubScope_CANCELLED = 15;
const int MDStatisticSubScope_MARKET_DATA_ACCESS = 16;
const int MDStatisticSubScope_TERMINAL_ACCESS = 17;
const int MDStatisticSubScope_VOLUME = 18;
const int MDStatisticSubScope_CLEARED = 19;
const int MDStatisticSubScope_SETTLED = 20;
const int MDStatisticSubScope_OTHER = 21;
const int MDStatisticSubScope_MONETARY = 22;
const int MDStatisticSubScope_NON_MONETARY = 23;
const int MDStatisticSubScope_GROSS = 24;
const int MDStatisticSubScope_LARGE_IN_SCALE = 25;
const int MDStatisticSubScope_NEITHER_HIDDEN_NOR_LARGE_IN_SCALE = 26;
const int MDStatisticSubScope_CORPORATE_ACTION = 27;
const int MDStatisticSubScope_VENUE_DECISION = 28;
const int MDStatisticSubScope_MINIMUM_TIME_PERIOD = 29;
const int MDStatisticSubScope_OPEN = 30;
const int MDStatisticSubScope_NOT_EXECUTED = 31;
const int MDStatisticSubScope_AGGRESSIVE = 32;
const int MDStatisticSubScope_DIRECTED = 33;
const int MDStatisticScopeType_ENTRY_RATE = 1;
const int MDStatisticScopeType_MODIFICATION_RATE = 2;
const int MDStatisticScopeType_CANCEL_RATE = 3;
const int MDStatisticScopeType_DOWNWARD_MOVE = 4;
const int MDStatisticScopeType_UPWARD_MOVE = 5;
const int MDStatisticIntervalType_SLIDING_WINDOW = 1;
const int MDStatisticIntervalType_SLIDING_WINDOW_PEAK = 2;
const int MDStatisticIntervalType_FIXED_DATE_RANGE = 3;
const int MDStatisticIntervalType_FIXED_TIME_RANGE = 4;
const int MDStatisticIntervalType_CURRENT_TIME_UNIT = 5;
const int MDStatisticIntervalType_PREVIOUS_TIME_UNIT = 6;
const int MDStatisticIntervalType_MAXIMUM_RANGE = 7;
const int MDStatisticIntervalType_MAXIMUM_RANGE_UP_TO_PREVIOUS_TIME_UNIT = 8;
const int MDStatisticRatioType_BUYERS_TO_SELLERS = 1;
const int MDStatisticRatioType_UPTICKS_TO_DOWNTICKS = 2;
const int MDStatisticRatioType_MARKET_MAKER_TO_NON_MARKET_MAKER = 3;
const int MDStatisticRatioType_AUTOMATED_TO_NON_AUTOMATED = 4;
const int MDStatisticRatioType_ORDERS_TO_TRADES = 5;
const int MDStatisticRatioType_QUOTES_TO_TRADES = 6;
const int MDStatisticRatioType_ORDERS_AND_QUOTES_TO_TRADES = 7;
const int MDStatisticRatioType_FAILED_TO_TOTAL_TRADED_VALUE = 8;
const int MDStatisticRatioType_BENEFITS_TO_TOTAL_TRADED_VALUE = 9;
const int MDStatisticRatioType_FEES_TO_TOTAL_TRADED_VALUE = 10;
const int MDStatisticRatioType_TRADE_VOLUME_TO_TOTAL_TRADED_VOLUME = 11;
const int MDStatisticRatioType_ORDERS_TO_TOTAL_NUMBER_ORDERS = 12;
const int MDStatisticRequestResult_SUCCESSFUL = 0;
const int MDStatisticRequestResult_INVALID_OR_UNKNOWN_MARKET = 1;
const int MDStatisticRequestResult_INVALID_OR_UNKNOWN_MARKET_SEGMENT = 2;
const int MDStatisticRequestResult_INVALID_OR_UNKNOWN_SECURITY_LIST = 3;
const int MDStatisticRequestResult_INVALID_OR_UNKNOWN_INSTRUMENTS = 4;
const int MDStatisticRequestResult_INVALID_PARTIES = 5;
const int MDStatisticRequestResult_TRADE_DATE_OUT_OF_SUPPORTED_RANGE = 6;
const int MDStatisticRequestResult_UNSUPPORTED_STATISTIC_TYPE = 7;
const int MDStatisticRequestResult_UNSUPPORTED_SCOPE_OR_SUB_SCOPE = 8;
const int MDStatisticRequestResult_UNSUPPORTED_SCOPE_TYPE = 9;
const int MDStatisticRequestResult_MARKET_DEPTH_NOT_SUPPORTED = 10;
const int MDStatisticRequestResult_FREQUENCY_NOT_SUPPORTED = 11;
const int MDStatisticRequestResult_UNSUPPORTED_STATISTIC_INTERVAL = 12;
const int MDStatisticRequestResult_UNSUPPORTED_STATISTIC_DATE_RANGE = 13;
const int MDStatisticRequestResult_UNSUPPORTED_STATISTIC_TIME_RANGE = 14;
const int MDStatisticRequestResult_UNSUPPORTED_RATIO_TYPE = 15;
const int MDStatisticRequestResult_INVALID_OR_UNKNOWN_TRADE_INPUT_SOURCE = 16;
const int MDStatisticRequestResult_INVALID_OR_UNKNOWN_TRADING_SESSION = 17;
const int MDStatisticRequestResult_UNAUTHORIZED_FOR_STATISTIC_REQUEST = 18;
const int MDStatisticRequestResult_OTHER = 99;
const int MDStatisticStatus_ACTIVE = 1;
const int MDStatisticStatus_INACTIVE = 2;
const int MDStatisticValueType_ABSOLUTE = 1;
const int MDStatisticValueType_PERCENTAGE = 2;
const int AssetGroup_FINANCIALS = 1;
const int AssetGroup_COMMODITIES = 2;
const int AssetGroup_ALTERNATIVE_INVESTMENTS = 3;
const int CollRptRejectReason_UNKNOWN_TRADE = 0;
const int CollRptRejectReason_UNKNOWN_INSTRUMENT = 1;
const int CollRptRejectReason_UNKNOWN_COUNTERPARTY = 2;
const int CollRptRejectReason_UNKNOWN_POSITION = 3;
const int CollRptRejectReason_UNACCEPTABLE_COLLATERAL = 4;
const int CollRptRejectReason_OTHER = 99;
const int CollRptStatus_ACCEPTED = 0;
const int CollRptStatus_RECEIVED = 1;
const int CollRptStatus_REJECTED = 2;
const int RelativeValueType_ASW_SPREAD = 1;
const int RelativeValueType_OIS = 2;
const int RelativeValueType_Z_SPREAD = 3;
const int RelativeValueType_DISCOUNT_MARGIN = 4;
const int RelativeValueType_I_SPREAD = 5;
const int RelativeValueType_OAS = 6;
const int RelativeValueType_G_SPREAD = 7;
const int RelativeValueType_CDS_BASIS = 8;
const int RelativeValueType_CDS_INTERPOLATED_BASIS = 9;
const int RelativeValueType_DV01 = 10;
const int RelativeValueType_PV01 = 11;
const int RelativeValueType_CS01 = 12;
const int RelativeValueSide_BID = 1;
const int RelativeValueSide_MID = 2;
const int RelativeValueSide_OFFER = 3;
const int MDReportEvent_START_INSTRUMENT_REF_DATA = 1;
const int MDReportEvent_END_INSTRUMENT_REF_DATA = 2;
const int MDReportEvent_START_OFF_MARKET_TRADES = 3;
const int MDReportEvent_END_OFF_MARKET_TRADES = 4;
const int MDReportEvent_START_ORDER_BOOK_TRADES = 5;
const int MDReportEvent_END_ORDER_BOOK_TRADES = 6;
const int MDReportEvent_START_OPEN_INTEREST = 7;
const int MDReportEvent_END_OPEN_INTEREST = 8;
const int MDReportEvent_START_SETTLEMENT_PRICES = 9;
const int MDReportEvent_END_SETTLEMENT_PRICES = 10;
const int MDReportEvent_START_STATS_REF_DATA = 11;
const int MDReportEvent_END_STATS_REF_DATA = 12;
const int MDReportEvent_START_STATISTICS = 13;
const int MDReportEvent_END_STATISTICS = 14;
const int MarketSegmentStatus_ACTIVE = 1;
const int MarketSegmentStatus_INACTIVE = 2;
const int MarketSegmentStatus_PUBLISHED = 3;
const int MarketSegmentType_POOL = 1;
const int MarketSegmentType_RETAIL = 2;
const int MarketSegmentType_WHOLESALE = 3;
const int MarketSegmentSubType_INTER_PRODUCT_SPREAD = 1;
const int MarketSegmentRelationship_MARKET_SEGMENT_POOL_MEMBER = 1;
const int MarketSegmentRelationship_RETAIL_SEGMENT = 2;
const int MarketSegmentRelationship_WHOLESALE_SEGMENT = 3;
const char QuoteSideIndicator_NO = 'N';
const char QuoteSideIndicator_YES = 'Y';
const int CustomerPriority_NO_PRIORITY = 0;
const int CustomerPriority_UNCONDITIONAL_PRIORITY = 1;
const int SettlSubMethod_SHARES = 1;
const int SettlSubMethod_DERIVATIVES = 2;
const int SettlSubMethod_PAYMENT_VS_PAYMENT = 3;
const int SettlSubMethod_NOTIONAL = 4;
const int SettlSubMethod_CASCADE = 5;
const int SettlSubMethod_REPURCHASE = 6;
const int SettlSubMethod_OTHER = 99;
const int CalculationMethod_AUTOMATIC = 0;
const int CalculationMethod_MANUAL = 1;
const int CollateralAmountType_MARKET_VALUATION = 0;
const int CollateralAmountType_PORTFOLIO_VALUE = 1;
const int CollateralAmountType_VALUE_CONFIRMED = 2;
const int CollateralAmountType_COLLATERAL_CREDIT_VALUE = 3;
const int CollateralAmountType_ADDITIONAL_COLLATERAL_VALUE = 4;
const int CollateralAmountType_ESTIMATED_MARKET_VALUATION = 5;
const int CommissionAmountType_UNSPECIFIED = 0;
const int CommissionAmountType_ACCEPTANCE = 1;
const int CommissionAmountType_BROKER = 2;
const int CommissionAmountType_CLEARING_BROKER = 3;
const int CommissionAmountType_RETAIL = 4;
const int CommissionAmountType_SALES_COMMISSION = 5;
const int CommissionAmountType_LOCAL_COMMISSION = 6;
const int CommissionAmountType_RESEARCH_PAYMENT = 7;
const int CashSettlPriceDefault_CLOSE = 0;
const int CashSettlPriceDefault_HEDGE = 1;
const int ComplexEventPVFinalPriceElectionFallback_CLOSE = 0;
const int ComplexEventPVFinalPriceElectionFallback_HEDGE_ELECTION = 1;
const int DividendEntitlementEvent_EX_DATE = 0;
const int DividendEntitlementEvent_RECORD_DATE = 1;
const int DividendAmountType_RECORD_AMOUNT = 0;
const int DividendAmountType_EX_AMOUNT = 1;
const int DividendAmountType_PAID_AMOUNT = 2;
const int DividendAmountType_PER_MASTER_CONFIRM = 3;
const int NonCashDividendTreatment_POTENTIAL_ADJUSTMENT = 0;
const int NonCashDividendTreatment_CASH_EQUIVALENT = 1;
const int DividendComposition_EQUITY_AMOUNT_RECEIVER = 0;
const int DividendComposition_CALCULATION_AGENT = 1;
const int StrikeIndexQuote_BID = 0;
const int StrikeIndexQuote_MID = 1;
const int StrikeIndexQuote_OFFER = 2;
const int ExtraordinaryEventAdjustmentMethod_CALCULATION_AGENT = 0;
const int ExtraordinaryEventAdjustmentMethod_OPTIONS_EXCHANGE = 1;
const int PaymentStreamInterpolationPeriod_INITIAL = 0;
const int PaymentStreamInterpolationPeriod_INITIAL_AND_FINAL = 1;
const int PaymentStreamInterpolationPeriod_FINAL = 2;
const int PaymentStreamInterpolationPeriod_ANY_PERIOD = 3;
const int PaymentStreamLinkStrikePriceType_VOLATILITY = 0;
const int PaymentStreamLinkStrikePriceType_VARIANCE = 1;
const int PaymentStreamRealizedVarianceMethod_PREVIOUS = 0;
const int PaymentStreamRealizedVarianceMethod_LAST = 1;
const int PaymentStreamRealizedVarianceMethod_BOTH = 2;
const int ProvisionBreakFeeElection_FLAT_FEE = 0;
const int ProvisionBreakFeeElection_AMORTIZED_FEE = 1;
const int ProvisionBreakFeeElection_FUNDING_FEE = 2;
const int ProvisionBreakFeeElection_FLAT_AND_FUNDING_FEE = 3;
const int ProvisionBreakFeeElection_AMORTIZED_AND_FUNDING_FEE = 4;
const int ReturnRateDateMode_PRICE_VALUATION = 0;
const int ReturnRateDateMode_DIVIDEND_VALUATION = 1;
const int ReturnRatePriceSequence_INITIAL = 0;
const int ReturnRatePriceSequence_INTERIM = 1;
const int ReturnRatePriceSequence_FINAL = 2;
const int ReturnRateQuoteTimeType_OPEN = 0;
const int ReturnRateQuoteTimeType_OFFICIAL_SETTL_PX = 1;
const int ReturnRateQuoteTimeType_XETRA = 2;
const int ReturnRateQuoteTimeType_CLOSE = 3;
const int ReturnRateQuoteTimeType_DERIVATIVES_CLOSE = 4;
const int ReturnRateQuoteTimeType_HIGH = 5;
const int ReturnRateQuoteTimeType_LOW = 6;
const int ReturnRateQuoteTimeType_AS_SPECIFIED_IN_MASTER_CONFIRMATION = 7;
const int ReturnRateValuationPriceOption_NONE = 0;
const int ReturnRateValuationPriceOption_FUTURES_PRICE = 1;
const int ReturnRateValuationPriceOption_OPTIONS_PRICE = 2;
const int ReturnRatePriceBasis_GROSS = 0;
const int ReturnRatePriceBasis_NET = 1;
const int ReturnRatePriceBasis_ACCRUED = 2;
const int ReturnRatePriceBasis_CLEAN_NET = 3;
const int ReturnRatePriceType_ABSOLUTE_TERMS = 0;
const int ReturnRatePriceType_PERCENTAGE_OF_NOTIONAL = 1;
const int StreamNotionalAdjustments_EXECUTION = 0;
const int StreamNotionalAdjustments_PORTFOLIO_REBALANCING = 1;
const int StreamNotionalAdjustments_STANDARD = 2;
const int UnderlyingNotionalAdjustments_EXECUTION = 0;
const int UnderlyingNotionalAdjustments_PORTFOLIO_REBALANCING = 1;
const int UnderlyingNotionalAdjustments_STANDARD = 2;
const int RemunerationIndicator_NO_REMUNERATION_PAID = 0;
const int RemunerationIndicator_REMUNERATION_PAID = 1;
const int PartyRiskLimitStatus_DISABLED = 0;
const int PartyRiskLimitStatus_ENABLED = 1;
const int AlgorithmicTradeIndicator_NON_ALGORITHMIC_TRADE = 0;
const int AlgorithmicTradeIndicator_ALGORITHMIC_TRADE = 1;
const int TrdRegPublicationType_PRE_TRADE_TRANSPARENCY_WAIVER = 0;
const int TrdRegPublicationType_POST_TRADE_DEFERRAL = 1;
const int TrdRegPublicationType_EXEMPT_FROM_PUBLICATION = 2;
const int TrdRegPublicationType_ORDER_LEVEL_PUBLICATION_TO_SUBSCRIBERS = 3;
const int TrdRegPublicationType_PRICE_LEVEL_PUBLICATION_TO_SUBSCRIBERS = 4;
const int TrdRegPublicationType_ORDER_LEVEL_PUBLICATION_TO_THE_PUBLIC = 5;
const int TrdRegPublicationType_PUBLICATION_INTERNAL_TO_EXECUTION_VENUE = 6;
const int TrdRegPublicationReason_NO_BOOK_ORDER_DUE_TO_AVERAGE_SPREAD_PRICE = 0;
const int TrdRegPublicationReason_NO_BOOK_ORDER_DUE_TO_REF_PRICE = 1;
const int TrdRegPublicationReason_NO_BOOK_ORDER_DUE_TO_OTHER_CONDITIONS = 2;
const int TrdRegPublicationReason_NO_PUBLIC_PRICE_DUE_TO_REF_PRICE = 3;
const int TrdRegPublicationReason_NO_PUBLIC_PRICE_DUE_TO_ILLIQUID = 4;
const int TrdRegPublicationReason_NO_PUBLIC_PRICE_DUE_TO_ORDER_SIZE = 5;
const int TrdRegPublicationReason_DEFERRAL_DUE_TO_LARGE_IN_SCALE = 6;
const int TrdRegPublicationReason_DEFERRAL_DUE_TO_ILLIQUID = 7;
const int TrdRegPublicationReason_DEFERRAL_DUE_TO_SIZE_SPECIFIC = 8;
const int TrdRegPublicationReason_NO_PUBLIC_PRICE_DUE_TO_LARGE_IN_SCALE = 9;
const int TrdRegPublicationReason_NO_PUBLIC_PRICE_SIZE_DUE_TO_ORDER_HIDDEN = 10;
const int TrdRegPublicationReason_EXEMPTED_DUE_TO_SECURITIES_FINANCING_TRANSACTION = 11;
const int TrdRegPublicationReason_EXEMPTED_DUE_TO_ESCB_POLICY_TRANSACTION = 12;
const int TrdRegPublicationReason_EXCEPTION_DUE_TO_REPORT_BY_PAPER = 13;
const int TrdRegPublicationReason_EXCEPTION_DUE_TO_TRADE_EXECUTED_WITH_NON_REPORTING_PARTY = 14;
const int TrdRegPublicationReason_EXCEPTION_DUE_TO_INTRA_FIRM_ORDER = 15;
const int TrdRegPublicationReason_REPORTED_OUTSIDE_REPORTING_HOURS = 16;
const int CrossedIndicator_NO_CROSS = 0;
const int CrossedIndicator_CROSS_REJECTED = 1;
const int CrossedIndicator_CROSS_ACCEPTED = 2;
const int OrderAttributeType_AGGREGATED_ORDER = 0;
const int OrderAttributeType_PENDING_ALLOCATION = 1;
const int OrderAttributeType_LIQUIDITY_PROVISION_ACTIVITY_ORDER = 2;
const int OrderAttributeType_RISK_REDUCTION_ORDER = 3;
const int OrderAttributeType_ALGORITHMIC_ORDER = 4;
const int OrderAttributeType_SYSTEMATIC_INTERNALISER_ORDER = 5;
const int OrderAttributeType_ALL_EXECUTIONS_SUBMITTED_TO_APA = 6;
const int OrderAttributeType_ORDER_EXECUTION_INSTRUCTED_BY_CLIENT = 7;
const int OrderAttributeType_LARGE_IN_SCALE = 8;
const int OrderAttributeType_HIDDEN = 9;
const int OrderAttributeType_SUBJECT_TO_EUSTO = 10;
const int OrderAttributeType_SUBJECT_TO_UKSTO = 11;
const int OrderAttributeType_REPRESENTATIVE_ORDER = 12;
const int OrderAttributeType_LINKAGE_TYPE = 13;
const int OrderAttributeType_EXEMPT_FROM_STO = 14;
const int TradeReportingIndicator_NOT_REPORTED = 0;
const int TradeReportingIndicator_ON_BOOK = 1;
const int TradeReportingIndicator_SI_SELLER = 2;
const int TradeReportingIndicator_SI_BUYER = 3;
const int TradeReportingIndicator_NON_SI_SELLER = 4;
const int TradeReportingIndicator_SUB_DELEGATION_BY_FIRM = 5;
const int TradeReportingIndicator_REPORTABLE = 6;
const int TradeReportingIndicator_NON_SI_BUYER = 7;
const int TradeReportingIndicator_OFF_BOOK = 8;
const int TradeReportingIndicator_NOT_REPORTABLE = 9;
const int MassActionReason_NONE = 0;
const int MassActionReason_TRADING_RISK_CONTROL = 1;
const int MassActionReason_CLEARING_RISK_CONTROL = 2;
const int MassActionReason_MARKET_MAKER_PROTECTION = 3;
const int MassActionReason_STOP_TRADING = 4;
const int MassActionReason_EMERGENCY_ACTION = 5;
const int MassActionReason_SESSION_LOSS_LOGOUT = 6;
const int MassActionReason_DUPLICATE_LOGIN = 7;
const int MassActionReason_PRODUCT_NOT_TRADED = 8;
const int MassActionReason_INSTRUMENT_NOT_TRADED = 9;
const int MassActionReason_COMPLE_INSTRUMENT_DELETED = 10;
const int MassActionReason_CIRCUIT_BREAKER_ACTIVATED = 11;
const int MassActionReason_OTHER = 99;
const int NotAffectedReason_ORDER_SUSPENDED = 0;
const int NotAffectedReason_INSTRUMENT_SUSPENDED = 1;
const int OrderOwnershipIndicator_NO_CHANGE = 0;
const int OrderOwnershipIndicator_EXECUTING_PARTY_CHANGE = 1;
const int OrderOwnershipIndicator_ENTERING_PARTY_CHANGE = 2;
const int OrderOwnershipIndicator_SPECIFIED_PARTY_CHANGE = 3;
const int InTheMoneyCondition_STANDARD_ITM = 0;
const int InTheMoneyCondition_ATMITM = 1;
const int InTheMoneyCondition_ATM_CALL_ITM = 2;
const int InTheMoneyCondition_ATM_PUT_ITM = 3;
const int ExDestinationType_NO_RESTRICTION = 0;
const int ExDestinationType_TRADED_ONLY_ON_TRADING_VENUE = 1;
const int ExDestinationType_TRADED_ONLY_ON_SI = 2;
const int ExDestinationType_TRADED_ON_TRADING_VENUE_OR_SI = 3;
const int MarketCondition_NORMAL = 0;
const int MarketCondition_STRESSED = 1;
const int MarketCondition_EXCEPTIONAL = 2;
const int QuoteAttributeType_QUOTE_ABOVE_STANDARD_MARKET_SIZE = 0;
const int QuoteAttributeType_QUOTE_ABOVE_SPECIFIC_INSTRUMENT_SIZE = 1;
const int QuoteAttributeType_QUOTE_APPLICABLE_FOR_LIQUIDTY_PROVISION_ACTIVITY = 2;
const int QuoteAttributeType_QUOTE_ISSUER_STATUS = 3;
const int QuoteAttributeType_BID_OR_ASK_REQUEST = 4;
const int PriceQualifier_ACCRUED_INTEREST_IS_FACTORED = 0;
const int PriceQualifier_TAX_IS_FACTORED = 1;
const int PriceQualifier_BOND_AMORTIZATION_IS_FACTORED = 2;
const int MDValueTier_RANGE1 = 1;
const int MDValueTier_RANGE2 = 2;
const int MDValueTier_RANGE3 = 3;
const int MiscFeeQualifier_CONTRIBUTES = 0;
const int MiscFeeQualifier_DOES_NOT_CONTRIBUTE = 1;
const int CommissionAmountSubType_RESEARCH_PAYMENT_ACCOUNT = 0;
const int CommissionAmountSubType_COMMISSION_SHARING_AGREEMENT = 1;
const int CommissionAmountSubType_OTHER_TYPE_RESEARCH_PAYMENT = 2;
const int CommodityFinalPriceType_ARGUS_MC_CLOSKEY = 0;
const int CommodityFinalPriceType_BALTIC = 1;
const int CommodityFinalPriceType_EXCHANGE = 2;
const int CommodityFinalPriceType_GLOBAL_COAL = 3;
const int CommodityFinalPriceType_IHS_MC_CLOSKEY = 4;
const int CommodityFinalPriceType_PLATTS = 5;
const int CommodityFinalPriceType_OTHER = 99;
const int ReferenceDataDateType_ADMIT_TO_TRADE_REQUEST_DATE = 0;
const int ReferenceDataDateType_ADMIT_TO_TRADE_APPROVAL_DATE = 1;
const int ReferenceDataDateType_ADMIT_TO_TRADE_OR_FIRST_TRADE_DATE = 2;
const int ReferenceDataDateType_TERMINATION_DATE = 3;
const int ReturnTrigger_DIVIDEND = 1;
const int ReturnTrigger_VARIANCE = 2;
const int ReturnTrigger_VOLATILITY = 3;
const int ReturnTrigger_TOTAL_RETURN = 4;
const int ReturnTrigger_CONTRACT_FOR_DIFFERENCE = 5;
const int ReturnTrigger_CREDIT_DEFAULT = 6;
const int ReturnTrigger_SPREAD_BET = 7;
const int ReturnTrigger_PRICE = 8;
const int ReturnTrigger_FORWARD_PRICE_UNDERLYING_INSTRUMENT = 9;
const int ReturnTrigger_OTHER = 99;
const int AveragePriceType_TIME_WEIGHTED_AVERAGE_PRICE = 0;
const int AveragePriceType_VOLUME_WEIGHTED_AVERAGE_PRICE = 1;
const int AveragePriceType_PERCENT_OF_VOLUME_AVERAGE_PRICE = 2;
const int AveragePriceType_LIMIT_ORDER_AVERAGE_PRICE = 3;
const int AllocGroupStatus_ADDED = 0;
const int AllocGroupStatus_CANCELED = 1;
const int AllocGroupStatus_REPLACED = 2;
const int AllocGroupStatus_CHANGED = 3;
const int AllocGroupStatus_PENDING = 4;
const int AllocRequestStatus_ACCEPTED = 0;
const int AllocRequestStatus_REJECTED = 1;
const int MatchExceptionType_NO_MATCHING_CONFIRMATION = 0;
const int MatchExceptionType_NO_MATCHING_ALLOCATION = 1;
const int MatchExceptionType_ALLOCATION_DATA_ELEMENT_MISSING = 2;
const int MatchExceptionType_CONFIRMATION_DATA_ELEMENT_MISSING = 3;
const int MatchExceptionType_DATA_DIFFERENCE_NOT_WITHIN_TOLERANCE = 4;
const int MatchExceptionType_MATCH_WITHIN_TOLERANCE = 5;
const int MatchExceptionType_OTHER = 99;
const int MatchExceptionElementType_ACCRUED_INTEREST = 1;
const int MatchExceptionElementType_DEAL_PRICE = 2;
const int MatchExceptionElementType_TRADE_DATE = 3;
const int MatchExceptionElementType_SETTLEMENT_DATE = 4;
const int MatchExceptionElementType_SIDE_INDICATOR = 5;
const int MatchExceptionElementType_TRADED_CURRENCY = 6;
const int MatchExceptionElementType_ACCOUNT_ID = 7;
const int MatchExceptionElementType_EXECUTING_BROKER_ID = 8;
const int MatchExceptionElementType_SETTLEMENT_CURRENCY_AND_AMOUNT = 9;
const int MatchExceptionElementType_INVESTMENT_MANAGER_ID = 10;
const int MatchExceptionElementType_NET_AMOUNT = 11;
const int MatchExceptionElementType_PLACE_OF_SETTLEMENT = 12;
const int MatchExceptionElementType_COMMISSIONS = 13;
const int MatchExceptionElementType_SECURITY_IDENTIFIER = 14;
const int MatchExceptionElementType_QUALITY_ALLOCATED = 15;
const int MatchExceptionElementType_PRINCIPAL = 16;
const int MatchExceptionElementType_FEES = 17;
const int MatchExceptionElementType_TAX = 18;
const int MatchExceptionToleranceValueType_FIXED_AMOUNT = 1;
const int MatchExceptionToleranceValueType_PERCENTAGE = 2;
const int MatchingDataPointIndicator_MANDATORY = 1;
const int MatchingDataPointIndicator_OPTIONAL = 2;
const int TradeAggregationTransType_NEW = 0;
const int TradeAggregationTransType_CANCEL = 1;
const int TradeAggregationTransType_REPLACE = 2;
const int TradeAggregationRequestStatus_ACCEPTED = 0;
const int TradeAggregationRequestStatus_REJECTED = 1;
const int TradeAggregationRejectReason_UNKNOWN_ORDERS = 0;
const int TradeAggregationRejectReason_UNKNOWN_EXECUTION_FILLS = 1;
const int TradeAggregationRejectReason_OTHER = 99;
const int OffshoreIndicator_REGULAR = 0;
const int OffshoreIndicator_OFFSHORE = 1;
const int OffshoreIndicator_ONSHORE = 2;
const int PayReportTransType_NEW = 0;
const int PayReportTransType_REPLACE = 1;
const int PayReportTransType_STATUS = 2;
const int PayReportStatus_RECEIVED = 0;
const int PayReportStatus_ACCEPTED = 1;
const int PayReportStatus_REJECTED = 2;
const int PayReportStatus_DISPUTED = 3;
const int PayRequestTransType_NEW = 0;
const int PayRequestTransType_CANCEL = 1;
const int PayRequestStatus_RECEIVED = 0;
const int PayRequestStatus_ACCEPTED = 1;
const int PayRequestStatus_REJECTED = 2;
const int PayRequestStatus_DISPUTED = 3;
const int PostTradePaymentDebitOrCredit_DEBIT_PAY = 0;
const int PostTradePaymentDebitOrCredit_CREDIT_RECEIVE = 1;
const int PostTradePaymentStatus_NEW = 0;
const int PostTradePaymentStatus_INITIATED = 1;
const int PostTradePaymentStatus_PENDING = 2;
const int PostTradePaymentStatus_CONFIRMED = 3;
const int PostTradePaymentStatus_REJECTED = 4;
const char DuplicateClOrdIDIndicator_NO = 'N';
const char DuplicateClOrdIDIndicator_YES = 'Y';
const char EventInitiatorType_CUSTOMER_OR_CLIENT = 'C';
const char EventInitiatorType_EXCHANGE_OR_EXECUTION_VENUE = 'E';
const char EventInitiatorType_FIRM_OR_BROKER = 'F';
const int NBBOEntryType_BID = 0;
const int NBBOEntryType_OFFER = 1;
const int NBBOEntryType_MID_PRICE = 2;
const int NBBOSource_NOT_APPLICABLE = 0;
const int NBBOSource_DIRECT = 1;
const int NBBOSource_SIP = 2;
const int NBBOSource_HYBRID = 3;
const char SingleQuoteIndicator_NO = 'N';
const char SingleQuoteIndicator_YES = 'Y';
const char TrdRegTimestampManualIndicator_NO = 'N';
const char TrdRegTimestampManualIndicator_YES = 'Y';
const int CollateralReinvestmentType_MONEY_MARKET_FUND = 0;
const int CollateralReinvestmentType_OTHER_COMINGLED_POOL = 1;
const int CollateralReinvestmentType_REPO_MARKET = 2;
const int CollateralReinvestmentType_DIRECT_PURCHASE_OF_SECURITIES = 3;
const int CollateralReinvestmentType_OTHER_INVESTMENTS = 4;
const int FundingSource_REPO = 0;
const int FundingSource_CASH = 1;
const int FundingSource_FREE_CEDITS = 2;
const int FundingSource_CUSTOMER_SHORT_SALES = 3;
const int FundingSource_BROKER_SHORT_SALES = 4;
const int FundingSource_UNSECURED_BORROWING = 5;
const int FundingSource_OTHER = 99;
const int MarginDirection_POSTED = 0;
const int MarginDirection_RECEIVED = 1;
const int TransactionAttributeType_EXCLUSIVE_ARRANGEMENT = 0;
const int TransactionAttributeType_COLLATERAL_REUSE = 1;
const int TransactionAttributeType_COLLATERAL_ARRANGMENT_TYPE = 2;
const int RoutingArrangmentIndicator_NO_ROUTING_ARRANGMENT_IN_PLACE = 0;
const int RoutingArrangmentIndicator_ROUTING_ARRANGEMENT_IN_PLACE = 1;
const int RelatedOrderIDSource_NON_FIX_SOURCE = 0;
const int RelatedOrderIDSource_SYSTEM_ORDER_IDENTIFIER = 1;
const int RelatedOrderIDSource_CLIENT_ORDER_IDENTIFIER = 2;
const int RelatedOrderIDSource_SECONDARY_ORDER_IDENTIFIER = 3;
const int RelatedOrderIDSource_SECONDARY_CLIENT_ORDER_IDENTIFIER = 4;
const int OrderRelationship_NOT_SPECIFIED = 0;
const int OrderRelationship_ORDER_AGGREGATION = 1;
const int OrderRelationship_ORDER_SPLIT = 2;
const char CurrencyCodeSource_CUSIP[] = "1";
const char CurrencyCodeSource_SEDOL[] = "2";
const char CurrencyCodeSource_ISIN_NUMBER[] = "4";
const char CurrencyCodeSource_ISO_CURRENCY_CODE[] = "6";
const char CurrencyCodeSource_FINANCIAL_INSTRUMENT_GLOBAL_IDENTIFIER[] = "S";
const char CurrencyCodeSource_DIGITAL_TOKEN_IDENTIFIER[] = "Y";
const int MultiJurisdictionReportingIndicator_NOT_MULTI_JRSDCTN_ELIGIBLE = 0;
const int MultiJurisdictionReportingIndicator_MULTI_JRSDCTN_ELIGIBLE = 1;
const int SelfMatchPreventionInstruction_CANCEL_AGGRESSIVE = 1;
const int SelfMatchPreventionInstruction_CANCEL_PASSIVE = 2;
const int SelfMatchPreventionInstruction_CANCEL_AGGRESSIVE_PASSIVE = 3;
} // namespace FIX
#endif // FIX_VALUES_H
